/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import com.yammer.metrics.core.Meter;
import java.io.Serializable;
import java.net.InetAddress;
import java.nio.ByteBuffer;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicInteger;
import kafka.network.RequestChannel;
import kafka.server.ApiRequestHandler;
import kafka.server.BrokerTopicMetrics;
import kafka.server.BrokerTopicStats;
import kafka.server.KafkaRequestHandler;
import kafka.server.KafkaRequestHandler$;
import kafka.server.RequestLocal;
import kafka.server.RequestLocal$;
import org.apache.kafka.common.memory.MemoryPool;
import org.apache.kafka.common.network.ClientInformation;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.requests.RequestContext;
import org.apache.kafka.common.requests.RequestHeader;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.utils.BufferSupplier;
import org.apache.kafka.common.utils.MockTime;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.server.log.remote.storage.RemoteStorageMetrics;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.verification.VerificationMode;
import scala.Function1;
import scala.Function2;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.collection.Seq;
import scala.collection.immutable.Set;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;

@ScalaSignature(bytes="\u0006\u0001\u0005Uh\u0001\u0002\u00192\u0001YBQ!\u0010\u0001\u0005\u0002yBq!\u0011\u0001C\u0002\u0013\u0005!\t\u0003\u0004G\u0001\u0001\u0006Ia\u0011\u0005\b\u000f\u0002\u0011\r\u0011\"\u0001I\u0011\u0019\t\u0006\u0001)A\u0005\u0013\"9!\u000b\u0001b\u0001\n\u0003A\u0005BB*\u0001A\u0003%\u0011\nC\u0004U\u0001\t\u0007I\u0011A+\t\re\u0003\u0001\u0015!\u0003W\u0011\u001dQ\u0006A1A\u0005\u0002UCaa\u0017\u0001!\u0002\u00131\u0006\"\u0002/\u0001\t\u0003i\u0006\"\u00028\u0001\t\u0003i\u0006\"\u00029\u0001\t\u0003i\u0006\"\u0002:\u0001\t\u0003i\u0006\"\u0002;\u0001\t\u0003)\bbBA\u000e\u0001\u0011\u0005\u0011Q\u0004\u0005\b\u0003/\u0002A\u0011AA-\u0011%\ti\u0006AI\u0001\n\u0003\ty\u0006C\u0004\u0002v\u0001!\t!a\u001e\t\r\u0005\u0005\u0005\u0001\"\u0001^\u0011\u0019\t)\t\u0001C\u0001;\"1\u0011\u0011\u0012\u0001\u0005\u0002uCa!!$\u0001\t\u0003i\u0006BBAI\u0001\u0011\u0005Q\f\u0003\u0004\u0002\u0016\u0002!\t!\u0018\u0005\u0007\u00033\u0003A\u0011A/\t\r\u0005u\u0005\u0001\"\u0001^\u0011\u0019\t\t\u000b\u0001C\u0001;\"1\u0011Q\u0015\u0001\u0005\u0002uCa!!+\u0001\t\u0003i\u0006BBAW\u0001\u0011\u0005Q\f\u0003\u0004\u00022\u0002!\t!\u0018\u0005\u0007\u0003k\u0003A\u0011A/\t\r\u0005e\u0006\u0001\"\u0001^\u0011\u0019\ti\f\u0001C\u0001;\"1\u0011\u0011\u0019\u0001\u0005\u0002uCa!!2\u0001\t\u0003i\u0006BBAe\u0001\u0011\u0005Q\f\u0003\u0004\u0002N\u0002!\t!\u0018\u0005\u0007\u0003#\u0004A\u0011A/\t\u000f\u0005U\u0007\u0001\"\u0001\u0002X\"1\u0011\u0011\u001d\u0001\u0005\u0002uCa!!:\u0001\t\u0003i\u0006BBAu\u0001\u0011\u0005Q\f\u0003\u0004\u0002n\u0002!\t!\u0018\u0005\u0007\u0003c\u0004A\u0011A/\u0003/-\u000bgm[1SKF,Xm\u001d;IC:$G.\u001a:UKN$(B\u0001\u001a4\u0003\u0019\u0019XM\u001d<fe*\tA'A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\u0005\u00019\u0004C\u0001\u001d<\u001b\u0005I$\"\u0001\u001e\u0002\u000bM\u001c\u0017\r\\1\n\u0005qJ$AB!osJ+g-\u0001\u0004=S:LGO\u0010\u000b\u0002\u007fA\u0011\u0001\tA\u0007\u0002c\u0005\u0001\"M]8lKJ$v\u000e]5d'R\fGo]\u000b\u0002\u0007B\u0011\u0001\tR\u0005\u0003\u000bF\u0012\u0001C\u0011:pW\u0016\u0014Hk\u001c9jGN#\u0018\r^:\u0002#\t\u0014xn[3s)>\u0004\u0018nY*uCR\u001c\b%A\u0003u_BL7-F\u0001J!\tQu*D\u0001L\u0015\taU*\u0001\u0003mC:<'\"\u0001(\u0002\t)\fg/Y\u0005\u0003!.\u0013aa\u0015;sS:<\u0017A\u0002;pa&\u001c\u0007%\u0001\u0004u_BL7MM\u0001\bi>\u0004\u0018n\u0019\u001a!\u0003I\u0011'o\\6feR{\u0007/[2NKR\u0014\u0018nY:\u0016\u0003Y\u0003\"\u0001Q,\n\u0005a\u000b$A\u0005\"s_.,'\u000fV8qS\u000elU\r\u001e:jGN\f1C\u0019:pW\u0016\u0014Hk\u001c9jG6+GO]5dg\u0002\nq\"\u00197m)>\u0004\u0018nY'fiJL7m]\u0001\u0011C2dGk\u001c9jG6+GO]5dg\u0002\n!\u0003^3ti\u000e\u000bG\u000e\u001c2bG.$\u0016.\\5oOR\ta\f\u0005\u00029?&\u0011\u0001-\u000f\u0002\u0005+:LG\u000f\u000b\u0002\rEB\u00111\r\\\u0007\u0002I*\u0011QMZ\u0001\u0004CBL'BA4i\u0003\u001dQW\u000f]5uKJT!!\u001b6\u0002\u000b),h.\u001b;\u000b\u0003-\f1a\u001c:h\u0013\tiGM\u0001\u0003UKN$\u0018A\b;fgR\u001c\u0015\r\u001c7cC\u000e\\GK]=D_6\u0004H.\u001a;f\u0003\u000e$\u0018n\u001c8tQ\ti!-A\u0010uKN$\b*\u00198eY&twmQ1mY\n\f7m[(o\u001d\u0016<H\u000b\u001b:fC\u0012D#A\u00042\u00021Q,7\u000f^\"bY2\u0014\u0017mY6P]N\u000bW.\u001a+ie\u0016\fG\r\u000b\u0002\u0010E\u0006qA/Z:u)>\u0004\u0018nY*uCR\u001cHC\u00010w\u0011\u00159\b\u00031\u0001y\u0003i\u0019\u0018p\u001d;f[J+Wn\u001c;f'R|'/Y4f\u000b:\f'\r\\3e!\tA\u00140\u0003\u0002{s\t9!i\\8mK\u0006t\u0007F\u0002\t}\u0003\u0013\tY\u0001E\u0002~\u0003\u000bi\u0011A \u0006\u0004\u007f\u0006\u0005\u0011\u0001\u00039s_ZLG-\u001a:\u000b\u0007\u0005\ra-\u0001\u0004qCJ\fWn]\u0005\u0004\u0003\u000fq(a\u0003,bYV,7k\\;sG\u0016\f\u0001BY8pY\u0016\fgn\u001d\u0017\u0005\u0003\u001b\ty!G\u0001\u00023\u0005\u0001\u0001f\u0001\t\u0002\u0014A!\u0011QCA\f\u001b\t\t\t!\u0003\u0003\u0002\u001a\u0005\u0005!!\u0005)be\u0006lW\r^3sSj,G\rV3ti\u0006YQ.Y6f%\u0016\fX/Z:u)\u0019\ty\"a\r\u0002NA!\u0011\u0011EA\u0017\u001d\u0011\t\u0019#!\u000b\u000e\u0005\u0005\u0015\"bAA\u0014g\u00059a.\u001a;x_J\\\u0017\u0002BA\u0016\u0003K\taBU3rk\u0016\u001cHo\u00115b]:,G.\u0003\u0003\u00020\u0005E\"a\u0002*fcV,7\u000f\u001e\u0006\u0005\u0003W\t)\u0003C\u0004\u00026E\u0001\r!a\u000e\u0002\tQLW.\u001a\t\u0005\u0003s\tI%\u0004\u0002\u0002<)!\u0011QHA \u0003\u0015)H/\u001b7t\u0015\u0011\t\t%a\u0011\u0002\r\r|W.\\8o\u0015\r!\u0014Q\t\u0006\u0004\u0003\u000fR\u0017AB1qC\u000eDW-\u0003\u0003\u0002L\u0005m\"\u0001\u0002+j[\u0016Dq!a\u0014\u0012\u0001\u0004\t\t&A\u0004nKR\u0014\u0018nY:\u0011\t\u0005\u0005\u00121K\u0005\u0005\u0003+\n\tDA\u0004NKR\u0014\u0018nY:\u0002/M,G/\u001e9Ce>\\WM\u001d+pa&\u001cW*\u001a;sS\u000e\u001cHc\u0001,\u0002\\!9qO\u0005I\u0001\u0002\u0004A\u0018!I:fiV\u0004(I]8lKJ$v\u000e]5d\u001b\u0016$(/[2tI\u0011,g-Y;mi\u0012\nTCAA1U\rA\u00181M\u0016\u0003\u0003K\u0002B!a\u001a\u0002r5\u0011\u0011\u0011\u000e\u0006\u0005\u0003W\ni'A\u0005v]\u000eDWmY6fI*\u0019\u0011qN\u001d\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0002t\u0005%$!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0006qB/Z:u'&tw-\u001e7be\u000e{\u0007/\u001f'bO\nKH/Z:NKR\u0014\u0018n\u0019\u000b\u0004=\u0006e\u0004\"B<\u0015\u0001\u0004A\bF\u0002\u000b}\u0003\u0013\ti\b\f\u0003\u0002\u000e\u0005=\u0001f\u0001\u000b\u0002\u0014\u0005yB/Z:u\u001bVdG/\u001b9mK\u000e{\u0007/\u001f'bO\nKH/Z:NKR\u0014\u0018nY:)\u0005U\u0011\u0017\u0001\f;fgR\u001cu\u000e]=MC\u001e\u0014\u0015\u0010^3t\u001b\u0016$(/[2XSRD\u0007+\u0019:uSRLwN\\#ya\u0006t7/[8oQ\t1\"-\u0001\u0017uKN$8i\u001c9z\u0019\u0006<')\u001f;fg6+GO]5d/&$\b\u000eU1si&$\u0018n\u001c8TQJLgn[5oO\"\u0012qCY\u00018i\u0016\u001cHoQ8qs2\u000bwMQ=uKNlU\r\u001e:jG^KG\u000f\u001b*f[>4\u0018N\\4O_:,\u00070[:uK:$\b+\u0019:uSRLwN\\:)\u0005a\u0011\u0017a\u0007;fgR\u001cu\u000e]=MC\u001e\u0014\u0015\u0010^3t\u001b\u0016$(/[2DY\u0016\f'\u000f\u000b\u0002\u001aE\u0006\u0011C/Z:u\u001bVdG/\u001b9mK\u000e{\u0007/\u001f'bON+w-\\3oiNlU\r\u001e:jGND#A\u00072\u0002_Q,7\u000f^\"pafd\u0015mZ*fO6,g\u000e^:NKR\u0014\u0018nY,ji\"\u0004\u0016M\u001d;ji&|g.\u0012=qC:\u001c\u0018n\u001c8)\u0005m\u0011\u0017a\f;fgR\u001cu\u000e]=MC\u001e\u001cVmZ7f]R\u001cX*\u001a;sS\u000e<\u0016\u000e\u001e5QCJ$\u0018\u000e^5p]NC'/\u001b8lS:<\u0007F\u0001\u000fc\u0003i\"Xm\u001d;D_BLH*Y4TK\u001elWM\u001c;t\u001b\u0016$(/[2XSRD'+Z7pm&twMT8oKbL7\u000f^3oiB\u000b'\u000f^5uS>t7\u000f\u000b\u0002\u001eE\u0006qB/Z:u\u0007>\u0004\u0018\u0010T1h'\u0016<W.\u001a8ug6+GO]5d\u00072,\u0017M\u001d\u0015\u0003=\t\f\u0011\u0005^3ti6+H\u000e^5qY\u0016$U\r\\3uK2\u000bwMQ=uKNlU\r\u001e:jGND#a\b2\u0002]Q,7\u000f\u001e#fY\u0016$X\rT1h\u0005f$Xm]'fiJL7mV5uQB\u000b'\u000f^5uS>tW\t\u001f9b]NLwN\u001c\u0015\u0003A\t\fa\u0006^3ti\u0012+G.\u001a;f\u0019\u0006<')\u001f;fg6+GO]5d/&$\b\u000eU1si&$\u0018n\u001c8TQJLgn[5oO\"\u0012\u0011EY\u0001:i\u0016\u001cH\u000fR3mKR,G*Y4CsR,7/T3ue&\u001cw+\u001b;i%\u0016lwN^5oO:{g.\u001a=jgR,g\u000e\u001e)beRLG/[8og\"\u0012!EY\u0001\u001ei\u0016\u001cH\u000fR3mKR,G*Y4CsR,7/T3ue&\u001c7\t\\3be\"\u00121EY\u0001%i\u0016\u001cH/T;mi&\u0004H.\u001a#fY\u0016$X\rT1h'\u0016<W.\u001a8ug6+GO]5dg\"\u0012AEY\u00012i\u0016\u001cH\u000fR3mKR,G*Y4TK\u001elWM\u001c;t\u001b\u0016$(/[2XSRD\u0007+\u0019:uSRLwN\\#ya\u0006t7/[8oQ\t)#-A\u0019uKN$H)\u001a7fi\u0016d\u0015mZ*fO6,g\u000e^:NKR\u0014\u0018nY,ji\"\u0004\u0016M\u001d;ji&|gn\u00155sS:\\\u0017N\\4)\u0005\u0019\u0012\u0017\u0001\u0010;fgR$U\r\\3uK2\u000bwmU3h[\u0016tGo]'fiJL7mV5uQJ+Wn\u001c<j]\u001etuN\\3ySN$XM\u001c;QCJ$\u0018\u000e^5p]ND#a\n2\u0002AQ,7\u000f\u001e#fY\u0016$X\rT1h'\u0016<W.\u001a8ug6+GO]5d\u00072,\u0017M\u001d\u0015\u0003Q\t\f!\u0004^3tiJ+Wn\u001c;f\u0019><W*\u001a;bI\u0006$\u0018mQ8v]RD#!\u000b2\u0002=Q,7\u000f^*j]\u001e,H.\u0019:M_\u001e\u001c\u0016N_3CsR,7/T3ue&\u001cGc\u00010\u0002Z\")qO\u000ba\u0001q\"2!\u0006`A\u0005\u0003;dC!!\u0004\u0002\u0010!\u001a!&a\u0005\u0002?Q,7\u000f^'vYRL\u0007\u000f\\3M_\u001e\u001c\u0016N_3CsR,7/T3ue&\u001c7\u000f\u000b\u0002,E\u0006aC/Z:u\u0019><7+\u001b>f\u0005f$Xm]'fiJL7mV5uQB\u000b'\u000f^5uS>tW\t\u001f9b]NLwN\u001c\u0015\u0003Y\t\fA\u0006^3ti2{wmU5{K\nKH/Z:NKR\u0014\u0018nY,ji\"\u0004\u0016M\u001d;ji&|gn\u00155sS:\\\u0017N\\4)\u00055\u0012\u0017a\u000e;fgRdunZ*ju\u0016\u0014\u0015\u0010^3t\u001b\u0016$(/[2XSRD'+Z7pm&twMT8oKbL7\u000f^3oiB\u000b'\u000f^5uS>t7\u000f\u000b\u0002/E\u0006YB/Z:u\u0019><7+\u001b>f\u0005f$Xm]'fiJL7m\u00117fCJD#a\f2")
public class KafkaRequestHandlerTest {
    private final BrokerTopicStats brokerTopicStats = new BrokerTopicStats(true);
    private final String topic;
    private final String topic2;
    private final BrokerTopicMetrics brokerTopicMetrics = this.brokerTopicStats().topicStats(this.topic());
    private final BrokerTopicMetrics allTopicMetrics = this.brokerTopicStats().allTopicsStats();

    public BrokerTopicStats brokerTopicStats() {
        return this.brokerTopicStats;
    }

    public String topic() {
        return this.topic;
    }

    public String topic2() {
        return this.topic2;
    }

    public BrokerTopicMetrics brokerTopicMetrics() {
        return this.brokerTopicMetrics;
    }

    public BrokerTopicMetrics allTopicMetrics() {
        return this.allTopicMetrics;
    }

    @Test
    public void testCallbackTiming() {
        MockTime time = new MockTime();
        long startTime = time.nanoseconds();
        RequestChannel.Metrics metrics = new RequestChannel.Metrics(Option$.MODULE$.option2Iterable((Option)None$.MODULE$));
        RequestChannel requestChannel = new RequestChannel(10, "", (Time)time, metrics);
        ApiRequestHandler apiHandler = (ApiRequestHandler)Mockito.mock(ApiRequestHandler.class);
        try {
            KafkaRequestHandler handler = new KafkaRequestHandler(0, 0, (Meter)Mockito.mock(Meter.class), new AtomicInteger(1), requestChannel, apiHandler, (Time)time, KafkaRequestHandler$.MODULE$.$lessinit$greater$default$8());
            RequestChannel.Request request = this.makeRequest((Time)time, metrics);
            requestChannel.sendRequest(request);
            apiHandler.handle((RequestChannel.Request)ArgumentMatchers.eq((Object)request), (RequestLocal)ArgumentMatchers.any());
            Mockito.when((Object)BoxedUnit.UNIT).thenAnswer(x$1 -> {
                KafkaRequestHandlerTest.$anonfun$testCallbackTiming$1(time, handler, request, x$1);
                return BoxedUnit.UNIT;
            });
            handler.run();
            Assertions.assertEquals((long)startTime, (long)request.requestDequeueTimeNanos());
            Assertions.assertEquals((long)(startTime + 2000000L), (long)request.apiLocalCompleteTimeNanos());
            Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToLong((long)(startTime + 2000000L))), (Object)request.callbackRequestDequeueTimeNanos());
            Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToLong((long)(startTime + 3000000L))), (Object)request.callbackRequestCompleteTimeNanos());
        }
        finally {
            metrics.close();
        }
    }

    @Test
    public void testCallbackTryCompleteActions() {
        MockTime time = new MockTime();
        RequestChannel.Metrics metrics = (RequestChannel.Metrics)Mockito.mock(RequestChannel.Metrics.class);
        ApiRequestHandler apiHandler = (ApiRequestHandler)Mockito.mock(ApiRequestHandler.class);
        RequestChannel requestChannel = new RequestChannel(10, "", (Time)time, metrics);
        KafkaRequestHandler handler = new KafkaRequestHandler(0, 0, (Meter)Mockito.mock(Meter.class), new AtomicInteger(1), requestChannel, apiHandler, (Time)time, KafkaRequestHandler$.MODULE$.$lessinit$greater$default$8());
        IntRef handledCount = IntRef.create((int)0);
        IntRef tryCompleteActionCount = IntRef.create((int)0);
        RequestChannel.Request request = this.makeRequest((Time)time, metrics);
        requestChannel.sendRequest(request);
        apiHandler.handle((RequestChannel.Request)ArgumentMatchers.eq((Object)request), (RequestLocal)ArgumentMatchers.any());
        Mockito.when((Object)BoxedUnit.UNIT).thenAnswer(x$3 -> {
            ++handledCount$1.elem;
            return CompletableFuture.runAsync(() -> KafkaRequestHandlerTest.$anonfun$testCallbackTryCompleteActions$3(KafkaRequestHandler$.MODULE$.wrapAsyncCallback((Function2 & Serializable & scala.Serializable)(x$4, x$5) -> {
                handler.stop();
                return BoxedUnit.UNIT;
            }, RequestLocal$.MODULE$.NoCaching())));
        });
        apiHandler.tryCompleteActions();
        Mockito.when((Object)BoxedUnit.UNIT).thenAnswer(x$6 -> {
            KafkaRequestHandlerTest.$anonfun$testCallbackTryCompleteActions$4(tryCompleteActionCount, x$6);
            return BoxedUnit.UNIT;
        });
        handler.run();
        Assertions.assertEquals((int)1, (int)handledCount.elem);
        Assertions.assertEquals((int)1, (int)tryCompleteActionCount.elem);
    }

    @Test
    public void testHandlingCallbackOnNewThread() {
        MockTime time = new MockTime();
        RequestChannel.Metrics metrics = (RequestChannel.Metrics)Mockito.mock(RequestChannel.Metrics.class);
        ApiRequestHandler apiHandler = (ApiRequestHandler)Mockito.mock(ApiRequestHandler.class);
        RequestChannel requestChannel = new RequestChannel(10, "", (Time)time, metrics);
        KafkaRequestHandler handler = new KafkaRequestHandler(0, 0, (Meter)Mockito.mock(Meter.class), new AtomicInteger(1), requestChannel, apiHandler, (Time)time, KafkaRequestHandler$.MODULE$.$lessinit$greater$default$8());
        RequestLocal originalRequestLocal = (RequestLocal)Mockito.mock(RequestLocal.class);
        IntRef handledCount = IntRef.create((int)0);
        RequestChannel.Request request = this.makeRequest((Time)time, metrics);
        requestChannel.sendRequest(request);
        apiHandler.handle((RequestChannel.Request)ArgumentMatchers.eq((Object)request), (RequestLocal)ArgumentMatchers.any());
        Mockito.when((Object)BoxedUnit.UNIT).thenAnswer(x$7 -> CompletableFuture.runAsync(() -> KafkaRequestHandlerTest.$anonfun$testHandlingCallbackOnNewThread$3(KafkaRequestHandler$.MODULE$.wrapAsyncCallback((Function2 & Serializable & scala.Serializable)(reqLocal, x$8) -> {
            KafkaRequestHandlerTest.$anonfun$testHandlingCallbackOnNewThread$2(handledCount, handler, reqLocal, BoxesRunTime.unboxToInt((Object)x$8));
            return BoxedUnit.UNIT;
        }, originalRequestLocal))));
        handler.run();
        ((RequestLocal)Mockito.verify((Object)originalRequestLocal, (VerificationMode)Mockito.times((int)0))).bufferSupplier();
        Assertions.assertEquals((int)1, (int)handledCount.elem);
    }

    @Test
    public void testCallbackOnSameThread() {
        MockTime time = new MockTime();
        RequestChannel.Metrics metrics = (RequestChannel.Metrics)Mockito.mock(RequestChannel.Metrics.class);
        ApiRequestHandler apiHandler = (ApiRequestHandler)Mockito.mock(ApiRequestHandler.class);
        RequestChannel requestChannel = new RequestChannel(10, "", (Time)time, metrics);
        KafkaRequestHandler handler = new KafkaRequestHandler(0, 0, (Meter)Mockito.mock(Meter.class), new AtomicInteger(1), requestChannel, apiHandler, (Time)time, KafkaRequestHandler$.MODULE$.$lessinit$greater$default$8());
        RequestLocal originalRequestLocal = (RequestLocal)Mockito.mock(RequestLocal.class);
        Mockito.when((Object)originalRequestLocal.bufferSupplier()).thenReturn((Object)BufferSupplier.create());
        IntRef handledCount = IntRef.create((int)0);
        RequestChannel.Request request = this.makeRequest((Time)time, metrics);
        requestChannel.sendRequest(request);
        apiHandler.handle((RequestChannel.Request)ArgumentMatchers.eq((Object)request), (RequestLocal)ArgumentMatchers.any());
        Mockito.when((Object)BoxedUnit.UNIT).thenAnswer(x$9 -> {
            KafkaRequestHandlerTest.$anonfun$testCallbackOnSameThread$1(handledCount, handler, originalRequestLocal, x$9);
            return BoxedUnit.UNIT;
        });
        handler.run();
        ((RequestLocal)Mockito.verify((Object)originalRequestLocal, (VerificationMode)Mockito.times((int)1))).bufferSupplier();
        Assertions.assertEquals((int)1, (int)handledCount.elem);
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    public void testTopicStats(boolean systemRemoteStorageEnabled) {
        BrokerTopicMetrics brokerTopicMetrics = new BrokerTopicStats(systemRemoteStorageEnabled).topicStats(this.topic());
        Set gaugeMetrics = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{RemoteStorageMetrics.REMOTE_LOG_SIZE_COMPUTATION_TIME_METRIC.getName(), RemoteStorageMetrics.REMOTE_COPY_LAG_BYTES_METRIC.getName(), RemoteStorageMetrics.REMOTE_COPY_LAG_SEGMENTS_METRIC.getName(), RemoteStorageMetrics.REMOTE_DELETE_LAG_BYTES_METRIC.getName(), RemoteStorageMetrics.REMOTE_DELETE_LAG_SEGMENTS_METRIC.getName(), RemoteStorageMetrics.REMOTE_LOG_SIZE_COMPUTATION_TIME_METRIC.getName(), RemoteStorageMetrics.REMOTE_LOG_METADATA_COUNT_METRIC.getName(), RemoteStorageMetrics.REMOTE_LOG_SIZE_BYTES_METRIC.getName()}));
        RemoteStorageMetrics.brokerTopicStatsMetrics().forEach(metric -> {
            if (systemRemoteStorageEnabled) {
                if (!gaugeMetrics.contains((Object)metric.getName())) {
                    Assertions.assertTrue((boolean)brokerTopicMetrics.metricMap().contains((Object)metric.getName()), (String)new StringBuilder(23).append("the metric is missing: ").append(metric.getName()).toString());
                    return;
                }
                Assertions.assertFalse((boolean)brokerTopicMetrics.metricMap().contains((Object)metric.getName()), (String)new StringBuilder(30).append("the metric should not appear: ").append(metric.getName()).toString());
                return;
            }
            Assertions.assertFalse((boolean)brokerTopicMetrics.metricMap().contains((Object)metric.getName()));
        });
        gaugeMetrics.foreach((Function1 & Serializable & scala.Serializable)metricName -> {
            KafkaRequestHandlerTest.$anonfun$testTopicStats$2(systemRemoteStorageEnabled, brokerTopicMetrics, metricName);
            return BoxedUnit.UNIT;
        });
    }

    public RequestChannel.Request makeRequest(Time time, RequestChannel.Metrics metrics) {
        RequestHeader requestHeader = (RequestHeader)Mockito.mock(RequestHeader.class);
        Mockito.when((Object)requestHeader.apiKey()).thenReturn((Object)ApiKeys.API_VERSIONS);
        Mockito.when((Object)BoxesRunTime.boxToShort((short)requestHeader.apiVersion())).thenReturn((Object)BoxesRunTime.boxToShort((short)((short)0)));
        RequestContext context = new RequestContext(requestHeader, "0", (InetAddress)Mockito.mock(InetAddress.class), new KafkaPrincipal("", ""), new ListenerName(""), SecurityProtocol.PLAINTEXT, (ClientInformation)Mockito.mock(ClientInformation.class), false);
        return new RequestChannel.Request(0, context, time.nanoseconds(), (MemoryPool)Mockito.mock(MemoryPool.class), ByteBuffer.allocate(0), metrics, RequestChannel.Request$.MODULE$.$lessinit$greater$default$7());
    }

    public BrokerTopicMetrics setupBrokerTopicMetrics(boolean systemRemoteStorageEnabled) {
        String topic = "topic";
        return new BrokerTopicMetrics(Option$.MODULE$.apply((Object)topic), systemRemoteStorageEnabled);
    }

    public boolean setupBrokerTopicMetrics$default$1() {
        return true;
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    public void testSingularCopyLagBytesMetric(boolean systemRemoteStorageEnabled) {
        BrokerTopicStats brokerTopicStats = new BrokerTopicStats(systemRemoteStorageEnabled);
        BrokerTopicMetrics brokerTopicMetrics = brokerTopicStats.topicStats(this.topic());
        if (systemRemoteStorageEnabled) {
            brokerTopicStats.recordRemoteCopyLagBytes(this.topic(), 0, 100L);
            brokerTopicStats.recordRemoteCopyLagBytes(this.topic(), 1, 150L);
            brokerTopicStats.recordRemoteCopyLagBytes(this.topic(), 2, 250L);
            Assertions.assertEquals((long)500L, (long)brokerTopicMetrics.remoteCopyLagBytes());
            Assertions.assertEquals((long)500L, (long)brokerTopicStats.allTopicsStats().remoteCopyLagBytes());
            brokerTopicStats.recordRemoteCopyLagBytes(this.topic2(), 0, 100L);
            Assertions.assertEquals((long)600L, (long)brokerTopicStats.allTopicsStats().remoteCopyLagBytes());
            return;
        }
        Assertions.assertEquals((Object)None$.MODULE$, (Object)brokerTopicMetrics.metricGaugeMap().get((Object)RemoteStorageMetrics.REMOTE_COPY_LAG_BYTES_METRIC.getName()));
        Assertions.assertEquals((Object)None$.MODULE$, (Object)brokerTopicStats.allTopicsStats().metricGaugeMap().get((Object)RemoteStorageMetrics.REMOTE_COPY_LAG_BYTES_METRIC.getName()));
    }

    @Test
    public void testMultipleCopyLagBytesMetrics() {
        this.brokerTopicStats().recordRemoteCopyLagBytes(this.topic(), 0, 1L);
        this.brokerTopicStats().recordRemoteCopyLagBytes(this.topic(), 1, 2L);
        this.brokerTopicStats().recordRemoteCopyLagBytes(this.topic(), 2, 3L);
        this.brokerTopicStats().recordRemoteCopyLagBytes(this.topic(), 0, 4L);
        this.brokerTopicStats().recordRemoteCopyLagBytes(this.topic(), 1, 5L);
        this.brokerTopicStats().recordRemoteCopyLagBytes(this.topic(), 2, 6L);
        Assertions.assertEquals((long)15L, (long)this.brokerTopicMetrics().remoteCopyLagBytes());
        Assertions.assertEquals((long)15L, (long)this.allTopicMetrics().remoteCopyLagBytes());
        this.brokerTopicStats().recordRemoteCopyLagBytes(this.topic2(), 2, 5L);
        Assertions.assertEquals((long)20L, (long)this.allTopicMetrics().remoteCopyLagBytes());
    }

    @Test
    public void testCopyLagBytesMetricWithPartitionExpansion() {
        this.brokerTopicStats().recordRemoteCopyLagBytes(this.topic(), 0, 1L);
        this.brokerTopicStats().recordRemoteCopyLagBytes(this.topic(), 1, 2L);
        Assertions.assertEquals((long)3L, (long)this.brokerTopicMetrics().remoteCopyLagBytes());
        Assertions.assertEquals((long)3L, (long)this.allTopicMetrics().remoteCopyLagBytes());
        this.brokerTopicStats().recordRemoteCopyLagBytes(this.topic(), 2, 3L);
        Assertions.assertEquals((long)6L, (long)this.brokerTopicMetrics().remoteCopyLagBytes());
        Assertions.assertEquals((long)6L, (long)this.allTopicMetrics().remoteCopyLagBytes());
        this.brokerTopicStats().recordRemoteCopyLagBytes(this.topic2(), 0, 1L);
        Assertions.assertEquals((long)7L, (long)this.allTopicMetrics().remoteCopyLagBytes());
    }

    @Test
    public void testCopyLagBytesMetricWithPartitionShrinking() {
        this.brokerTopicStats().recordRemoteCopyLagBytes(this.topic(), 0, 1L);
        this.brokerTopicStats().recordRemoteCopyLagBytes(this.topic(), 1, 2L);
        Assertions.assertEquals((long)3L, (long)this.brokerTopicMetrics().remoteCopyLagBytes());
        Assertions.assertEquals((long)3L, (long)this.allTopicMetrics().remoteCopyLagBytes());
        this.brokerTopicStats().removeRemoteCopyLagBytes(this.topic(), 1);
        Assertions.assertEquals((long)1L, (long)this.brokerTopicMetrics().remoteCopyLagBytes());
        Assertions.assertEquals((long)1L, (long)this.allTopicMetrics().remoteCopyLagBytes());
        this.brokerTopicStats().recordRemoteCopyLagBytes(this.topic2(), 0, 1L);
        Assertions.assertEquals((long)2L, (long)this.allTopicMetrics().remoteCopyLagBytes());
    }

    @Test
    public void testCopyLagBytesMetricWithRemovingNonexistentPartitions() {
        this.brokerTopicStats().recordRemoteCopyLagBytes(this.topic(), 0, 1L);
        this.brokerTopicStats().recordRemoteCopyLagBytes(this.topic(), 1, 2L);
        Assertions.assertEquals((long)3L, (long)this.brokerTopicMetrics().remoteCopyLagBytes());
        Assertions.assertEquals((long)3L, (long)this.allTopicMetrics().remoteCopyLagBytes());
        this.brokerTopicStats().removeRemoteCopyLagBytes(this.topic(), 3);
        Assertions.assertEquals((long)3L, (long)this.brokerTopicMetrics().remoteCopyLagBytes());
        Assertions.assertEquals((long)3L, (long)this.allTopicMetrics().remoteCopyLagBytes());
    }

    @Test
    public void testCopyLagBytesMetricClear() {
        this.brokerTopicStats().recordRemoteCopyLagBytes(this.topic(), 0, 1L);
        this.brokerTopicStats().recordRemoteCopyLagBytes(this.topic(), 1, 2L);
        Assertions.assertEquals((long)3L, (long)this.brokerTopicMetrics().remoteCopyLagBytes());
        Assertions.assertEquals((long)3L, (long)this.allTopicMetrics().remoteCopyLagBytes());
        this.brokerTopicStats().close();
        Assertions.assertEquals((long)0L, (long)this.brokerTopicMetrics().remoteCopyLagBytes());
        Assertions.assertEquals((long)0L, (long)this.allTopicMetrics().remoteCopyLagBytes());
        this.brokerTopicStats().recordRemoteCopyLagBytes(this.topic2(), 0, 1L);
        Assertions.assertEquals((long)1L, (long)this.allTopicMetrics().remoteCopyLagBytes());
    }

    @Test
    public void testMultipleCopyLagSegmentsMetrics() {
        this.brokerTopicStats().recordRemoteCopyLagSegments(this.topic(), 0, 1L);
        this.brokerTopicStats().recordRemoteCopyLagSegments(this.topic(), 1, 2L);
        this.brokerTopicStats().recordRemoteCopyLagSegments(this.topic(), 2, 3L);
        this.brokerTopicStats().recordRemoteCopyLagSegments(this.topic(), 0, 4L);
        this.brokerTopicStats().recordRemoteCopyLagSegments(this.topic(), 1, 5L);
        this.brokerTopicStats().recordRemoteCopyLagSegments(this.topic(), 2, 6L);
        Assertions.assertEquals((long)15L, (long)this.brokerTopicMetrics().remoteCopyLagSegments());
        Assertions.assertEquals((long)15L, (long)this.allTopicMetrics().remoteCopyLagSegments());
        this.brokerTopicStats().recordRemoteCopyLagSegments(this.topic2(), 0, 1L);
        Assertions.assertEquals((long)16L, (long)this.allTopicMetrics().remoteCopyLagSegments());
    }

    @Test
    public void testCopyLagSegmentsMetricWithPartitionExpansion() {
        this.brokerTopicStats().recordRemoteCopyLagSegments(this.topic(), 0, 1L);
        this.brokerTopicStats().recordRemoteCopyLagSegments(this.topic(), 1, 2L);
        Assertions.assertEquals((long)3L, (long)this.brokerTopicMetrics().remoteCopyLagSegments());
        Assertions.assertEquals((long)3L, (long)this.allTopicMetrics().remoteCopyLagSegments());
        this.brokerTopicStats().recordRemoteCopyLagSegments(this.topic(), 2, 3L);
        Assertions.assertEquals((long)6L, (long)this.brokerTopicMetrics().remoteCopyLagSegments());
        Assertions.assertEquals((long)6L, (long)this.allTopicMetrics().remoteCopyLagSegments());
    }

    @Test
    public void testCopyLagSegmentsMetricWithPartitionShrinking() {
        this.brokerTopicStats().recordRemoteCopyLagSegments(this.topic(), 0, 1L);
        this.brokerTopicStats().recordRemoteCopyLagSegments(this.topic(), 1, 2L);
        Assertions.assertEquals((long)3L, (long)this.brokerTopicMetrics().remoteCopyLagSegments());
        Assertions.assertEquals((long)3L, (long)this.allTopicMetrics().remoteCopyLagSegments());
        this.brokerTopicStats().removeRemoteCopyLagSegments(this.topic(), 1);
        Assertions.assertEquals((long)1L, (long)this.brokerTopicMetrics().remoteCopyLagSegments());
        Assertions.assertEquals((long)1L, (long)this.allTopicMetrics().remoteCopyLagSegments());
    }

    @Test
    public void testCopyLagSegmentsMetricWithRemovingNonexistentPartitions() {
        this.brokerTopicStats().recordRemoteCopyLagSegments(this.topic(), 0, 1L);
        this.brokerTopicStats().recordRemoteCopyLagSegments(this.topic(), 1, 2L);
        Assertions.assertEquals((long)3L, (long)this.brokerTopicMetrics().remoteCopyLagSegments());
        Assertions.assertEquals((long)3L, (long)this.allTopicMetrics().remoteCopyLagSegments());
        this.brokerTopicStats().removeRemoteCopyLagSegments(this.topic(), 3);
        Assertions.assertEquals((long)3L, (long)this.brokerTopicMetrics().remoteCopyLagSegments());
        Assertions.assertEquals((long)3L, (long)this.allTopicMetrics().remoteCopyLagSegments());
    }

    @Test
    public void testCopyLagSegmentsMetricClear() {
        this.brokerTopicStats().recordRemoteCopyLagSegments(this.topic(), 0, 1L);
        this.brokerTopicStats().recordRemoteCopyLagSegments(this.topic(), 1, 2L);
        Assertions.assertEquals((long)3L, (long)this.brokerTopicMetrics().remoteCopyLagSegments());
        Assertions.assertEquals((long)3L, (long)this.allTopicMetrics().remoteCopyLagSegments());
        this.brokerTopicStats().close();
        Assertions.assertEquals((long)0L, (long)this.brokerTopicMetrics().remoteCopyLagSegments());
        Assertions.assertEquals((long)0L, (long)this.allTopicMetrics().remoteCopyLagSegments());
    }

    @Test
    public void testMultipleDeleteLagBytesMetrics() {
        this.brokerTopicStats().recordRemoteDeleteLagBytes(this.topic(), 0, 1L);
        this.brokerTopicStats().recordRemoteDeleteLagBytes(this.topic(), 1, 2L);
        this.brokerTopicStats().recordRemoteDeleteLagBytes(this.topic(), 2, 3L);
        this.brokerTopicStats().recordRemoteDeleteLagBytes(this.topic(), 0, 4L);
        this.brokerTopicStats().recordRemoteDeleteLagBytes(this.topic(), 1, 5L);
        this.brokerTopicStats().recordRemoteDeleteLagBytes(this.topic(), 2, 6L);
        Assertions.assertEquals((long)15L, (long)this.brokerTopicMetrics().remoteDeleteLagBytes());
        Assertions.assertEquals((long)15L, (long)this.allTopicMetrics().remoteDeleteLagBytes());
        this.brokerTopicStats().recordRemoteDeleteLagBytes(this.topic2(), 0, 1L);
        Assertions.assertEquals((long)16L, (long)this.allTopicMetrics().remoteDeleteLagBytes());
    }

    @Test
    public void testDeleteLagBytesMetricWithPartitionExpansion() {
        this.brokerTopicStats().recordRemoteDeleteLagBytes(this.topic(), 0, 1L);
        this.brokerTopicStats().recordRemoteDeleteLagBytes(this.topic(), 1, 2L);
        Assertions.assertEquals((long)3L, (long)this.brokerTopicMetrics().remoteDeleteLagBytes());
        Assertions.assertEquals((long)3L, (long)this.allTopicMetrics().remoteDeleteLagBytes());
        this.brokerTopicStats().recordRemoteDeleteLagBytes(this.topic(), 2, 3L);
        Assertions.assertEquals((long)6L, (long)this.brokerTopicMetrics().remoteDeleteLagBytes());
        Assertions.assertEquals((long)6L, (long)this.allTopicMetrics().remoteDeleteLagBytes());
    }

    @Test
    public void testDeleteLagBytesMetricWithPartitionShrinking() {
        this.brokerTopicStats().recordRemoteDeleteLagBytes(this.topic(), 0, 1L);
        this.brokerTopicStats().recordRemoteDeleteLagBytes(this.topic(), 1, 2L);
        Assertions.assertEquals((long)3L, (long)this.brokerTopicMetrics().remoteDeleteLagBytes());
        Assertions.assertEquals((long)3L, (long)this.allTopicMetrics().remoteDeleteLagBytes());
        this.brokerTopicStats().removeRemoteDeleteLagBytes(this.topic(), 1);
        Assertions.assertEquals((long)1L, (long)this.brokerTopicMetrics().remoteDeleteLagBytes());
        Assertions.assertEquals((long)1L, (long)this.allTopicMetrics().remoteDeleteLagBytes());
    }

    @Test
    public void testDeleteLagBytesMetricWithRemovingNonexistentPartitions() {
        this.brokerTopicStats().recordRemoteDeleteLagBytes(this.topic(), 0, 1L);
        this.brokerTopicStats().recordRemoteDeleteLagBytes(this.topic(), 1, 2L);
        Assertions.assertEquals((long)3L, (long)this.brokerTopicMetrics().remoteDeleteLagBytes());
        Assertions.assertEquals((long)3L, (long)this.allTopicMetrics().remoteDeleteLagBytes());
        this.brokerTopicStats().removeRemoteDeleteLagBytes(this.topic(), 3);
        Assertions.assertEquals((long)3L, (long)this.brokerTopicMetrics().remoteDeleteLagBytes());
        Assertions.assertEquals((long)3L, (long)this.allTopicMetrics().remoteDeleteLagBytes());
    }

    @Test
    public void testDeleteLagBytesMetricClear() {
        this.brokerTopicStats().recordRemoteDeleteLagBytes(this.topic(), 0, 1L);
        this.brokerTopicStats().recordRemoteDeleteLagBytes(this.topic(), 1, 2L);
        Assertions.assertEquals((long)3L, (long)this.brokerTopicMetrics().remoteDeleteLagBytes());
        Assertions.assertEquals((long)3L, (long)this.allTopicMetrics().remoteDeleteLagBytes());
        this.brokerTopicStats().close();
        Assertions.assertEquals((long)0L, (long)this.brokerTopicMetrics().remoteDeleteLagBytes());
        Assertions.assertEquals((long)0L, (long)this.allTopicMetrics().remoteDeleteLagBytes());
    }

    @Test
    public void testMultipleDeleteLagSegmentsMetrics() {
        this.brokerTopicStats().recordRemoteDeleteLagSegments(this.topic(), 0, 1L);
        this.brokerTopicStats().recordRemoteDeleteLagSegments(this.topic(), 1, 2L);
        this.brokerTopicStats().recordRemoteDeleteLagSegments(this.topic(), 2, 3L);
        this.brokerTopicStats().recordRemoteDeleteLagSegments(this.topic(), 0, 4L);
        this.brokerTopicStats().recordRemoteDeleteLagSegments(this.topic(), 1, 5L);
        this.brokerTopicStats().recordRemoteDeleteLagSegments(this.topic(), 2, 6L);
        Assertions.assertEquals((long)15L, (long)this.brokerTopicMetrics().remoteDeleteLagSegments());
        Assertions.assertEquals((long)15L, (long)this.allTopicMetrics().remoteDeleteLagSegments());
        this.brokerTopicStats().recordRemoteDeleteLagSegments(this.topic2(), 1, 5L);
        Assertions.assertEquals((long)20L, (long)this.allTopicMetrics().remoteDeleteLagSegments());
    }

    @Test
    public void testDeleteLagSegmentsMetricWithPartitionExpansion() {
        this.brokerTopicStats().recordRemoteDeleteLagSegments(this.topic(), 0, 1L);
        this.brokerTopicStats().recordRemoteDeleteLagSegments(this.topic(), 1, 2L);
        Assertions.assertEquals((long)3L, (long)this.brokerTopicMetrics().remoteDeleteLagSegments());
        Assertions.assertEquals((long)3L, (long)this.allTopicMetrics().remoteDeleteLagSegments());
        this.brokerTopicStats().recordRemoteDeleteLagSegments(this.topic(), 2, 3L);
        Assertions.assertEquals((long)6L, (long)this.brokerTopicMetrics().remoteDeleteLagSegments());
        Assertions.assertEquals((long)6L, (long)this.allTopicMetrics().remoteDeleteLagSegments());
    }

    @Test
    public void testDeleteLagSegmentsMetricWithPartitionShrinking() {
        this.brokerTopicStats().recordRemoteDeleteLagSegments(this.topic(), 0, 1L);
        this.brokerTopicStats().recordRemoteDeleteLagSegments(this.topic(), 1, 2L);
        Assertions.assertEquals((long)3L, (long)this.brokerTopicMetrics().remoteDeleteLagSegments());
        Assertions.assertEquals((long)3L, (long)this.allTopicMetrics().remoteDeleteLagSegments());
        this.brokerTopicStats().removeRemoteDeleteLagSegments(this.topic(), 1);
        Assertions.assertEquals((long)1L, (long)this.brokerTopicMetrics().remoteDeleteLagSegments());
        Assertions.assertEquals((long)1L, (long)this.allTopicMetrics().remoteDeleteLagSegments());
    }

    @Test
    public void testDeleteLagSegmentsMetricWithRemovingNonexistentPartitions() {
        this.brokerTopicStats().recordRemoteDeleteLagSegments(this.topic(), 0, 1L);
        this.brokerTopicStats().recordRemoteDeleteLagSegments(this.topic(), 1, 2L);
        Assertions.assertEquals((long)3L, (long)this.brokerTopicMetrics().remoteDeleteLagSegments());
        Assertions.assertEquals((long)3L, (long)this.allTopicMetrics().remoteDeleteLagSegments());
        this.brokerTopicStats().removeRemoteDeleteLagSegments(this.topic(), 3);
        Assertions.assertEquals((long)3L, (long)this.brokerTopicMetrics().remoteDeleteLagSegments());
        Assertions.assertEquals((long)3L, (long)this.allTopicMetrics().remoteDeleteLagSegments());
    }

    @Test
    public void testDeleteLagSegmentsMetricClear() {
        this.brokerTopicStats().recordRemoteDeleteLagSegments(this.topic(), 0, 1L);
        this.brokerTopicStats().recordRemoteDeleteLagSegments(this.topic(), 1, 2L);
        Assertions.assertEquals((long)3L, (long)this.brokerTopicMetrics().remoteDeleteLagSegments());
        Assertions.assertEquals((long)3L, (long)this.allTopicMetrics().remoteDeleteLagSegments());
        this.brokerTopicStats().close();
        Assertions.assertEquals((long)0L, (long)this.brokerTopicMetrics().remoteDeleteLagSegments());
        Assertions.assertEquals((long)0L, (long)this.allTopicMetrics().remoteDeleteLagSegments());
    }

    @Test
    public void testRemoteLogMetadataCount() {
        Assertions.assertEquals((long)0L, (long)this.brokerTopicMetrics().remoteLogMetadataCount());
        Assertions.assertEquals((long)0L, (long)this.allTopicMetrics().remoteLogMetadataCount());
        this.brokerTopicStats().recordRemoteLogMetadataCount(this.topic(), 0, 1L);
        Assertions.assertEquals((long)1L, (long)this.brokerTopicMetrics().remoteLogMetadataCount());
        Assertions.assertEquals((long)1L, (long)this.allTopicMetrics().remoteLogMetadataCount());
        this.brokerTopicStats().recordRemoteLogMetadataCount(this.topic(), 1, 2L);
        this.brokerTopicStats().recordRemoteLogMetadataCount(this.topic(), 2, 3L);
        Assertions.assertEquals((long)6L, (long)this.brokerTopicMetrics().remoteLogMetadataCount());
        Assertions.assertEquals((long)6L, (long)this.allTopicMetrics().remoteLogMetadataCount());
        this.brokerTopicStats().close();
        Assertions.assertEquals((long)0L, (long)this.brokerTopicMetrics().remoteLogMetadataCount());
        Assertions.assertEquals((long)0L, (long)this.allTopicMetrics().remoteLogMetadataCount());
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    public void testSingularLogSizeBytesMetric(boolean systemRemoteStorageEnabled) {
        BrokerTopicStats brokerTopicStats = new BrokerTopicStats(systemRemoteStorageEnabled);
        BrokerTopicMetrics brokerTopicMetrics = brokerTopicStats.topicStats(this.topic());
        if (systemRemoteStorageEnabled) {
            brokerTopicStats.recordRemoteLogSizeBytes(this.topic(), 0, 100L);
            brokerTopicStats.recordRemoteLogSizeBytes(this.topic(), 1, 150L);
            brokerTopicStats.recordRemoteLogSizeBytes(this.topic(), 2, 250L);
            Assertions.assertEquals((long)500L, (long)brokerTopicMetrics.remoteLogSizeBytes());
            Assertions.assertEquals((long)500L, (long)brokerTopicStats.allTopicsStats().remoteLogSizeBytes());
            brokerTopicStats.recordRemoteLogSizeBytes(this.topic2(), 0, 100L);
            Assertions.assertEquals((long)600L, (long)brokerTopicStats.allTopicsStats().remoteLogSizeBytes());
            return;
        }
        Assertions.assertEquals((Object)None$.MODULE$, (Object)brokerTopicMetrics.metricGaugeMap().get((Object)RemoteStorageMetrics.REMOTE_LOG_SIZE_BYTES_METRIC.getName()));
    }

    @Test
    public void testMultipleLogSizeBytesMetrics() {
        this.brokerTopicStats().recordRemoteLogSizeBytes(this.topic(), 0, 1L);
        this.brokerTopicStats().recordRemoteLogSizeBytes(this.topic(), 1, 2L);
        this.brokerTopicStats().recordRemoteLogSizeBytes(this.topic(), 2, 3L);
        this.brokerTopicStats().recordRemoteLogSizeBytes(this.topic(), 0, 4L);
        this.brokerTopicStats().recordRemoteLogSizeBytes(this.topic(), 1, 5L);
        this.brokerTopicStats().recordRemoteLogSizeBytes(this.topic(), 2, 6L);
        Assertions.assertEquals((long)15L, (long)this.brokerTopicMetrics().remoteLogSizeBytes());
        Assertions.assertEquals((long)15L, (long)this.allTopicMetrics().remoteLogSizeBytes());
    }

    @Test
    public void testLogSizeBytesMetricWithPartitionExpansion() {
        this.brokerTopicStats().recordRemoteLogSizeBytes(this.topic(), 0, 1L);
        this.brokerTopicStats().recordRemoteLogSizeBytes(this.topic(), 1, 2L);
        Assertions.assertEquals((long)3L, (long)this.brokerTopicMetrics().remoteLogSizeBytes());
        Assertions.assertEquals((long)3L, (long)this.allTopicMetrics().remoteLogSizeBytes());
        this.brokerTopicStats().recordRemoteLogSizeBytes(this.topic(), 2, 3L);
        Assertions.assertEquals((long)6L, (long)this.brokerTopicMetrics().remoteLogSizeBytes());
        Assertions.assertEquals((long)6L, (long)this.allTopicMetrics().remoteLogSizeBytes());
    }

    @Test
    public void testLogSizeBytesMetricWithPartitionShrinking() {
        this.brokerTopicStats().recordRemoteLogSizeBytes(this.topic(), 0, 1L);
        this.brokerTopicStats().recordRemoteLogSizeBytes(this.topic(), 1, 2L);
        Assertions.assertEquals((long)3L, (long)this.brokerTopicMetrics().remoteLogSizeBytes());
        Assertions.assertEquals((long)3L, (long)this.allTopicMetrics().remoteLogSizeBytes());
        this.brokerTopicStats().removeRemoteLogSizeBytes(this.topic(), 1);
        Assertions.assertEquals((long)1L, (long)this.brokerTopicMetrics().remoteLogSizeBytes());
        Assertions.assertEquals((long)1L, (long)this.allTopicMetrics().remoteLogSizeBytes());
    }

    @Test
    public void testLogSizeBytesMetricWithRemovingNonexistentPartitions() {
        this.brokerTopicStats().recordRemoteLogSizeBytes(this.topic(), 0, 1L);
        this.brokerTopicStats().recordRemoteLogSizeBytes(this.topic(), 1, 2L);
        Assertions.assertEquals((long)3L, (long)this.brokerTopicMetrics().remoteLogSizeBytes());
        Assertions.assertEquals((long)3L, (long)this.allTopicMetrics().remoteLogSizeBytes());
        this.brokerTopicStats().removeRemoteLogSizeBytes(this.topic(), 3);
        Assertions.assertEquals((long)3L, (long)this.brokerTopicMetrics().remoteLogSizeBytes());
        Assertions.assertEquals((long)3L, (long)this.allTopicMetrics().remoteLogSizeBytes());
    }

    @Test
    public void testLogSizeBytesMetricClear() {
        this.brokerTopicStats().recordRemoteLogSizeBytes(this.topic(), 0, 1L);
        this.brokerTopicStats().recordRemoteLogSizeBytes(this.topic(), 1, 2L);
        Assertions.assertEquals((long)3L, (long)this.brokerTopicMetrics().remoteLogSizeBytes());
        Assertions.assertEquals((long)3L, (long)this.allTopicMetrics().remoteLogSizeBytes());
        this.brokerTopicStats().close();
        Assertions.assertEquals((long)0L, (long)this.brokerTopicMetrics().remoteLogSizeBytes());
        Assertions.assertEquals((long)0L, (long)this.allTopicMetrics().remoteLogSizeBytes());
    }

    public static final /* synthetic */ void $anonfun$testCallbackTiming$2(MockTime time$1, KafkaRequestHandler handler$1, RequestLocal x$2, int ms) {
        time$1.sleep((long)ms);
        handler$1.stop();
    }

    public static final /* synthetic */ void $anonfun$testCallbackTiming$3(Function1 callback$1) {
        callback$1.apply$mcVI$sp(1);
    }

    public static final /* synthetic */ void $anonfun$testCallbackTiming$1(MockTime time$1, KafkaRequestHandler handler$1, RequestChannel.Request request$1, InvocationOnMock x$1) {
        time$1.sleep(2L);
        CompletableFuture.runAsync(() -> KafkaRequestHandlerTest.$anonfun$testCallbackTiming$3(KafkaRequestHandler$.MODULE$.wrapAsyncCallback((Function2 & Serializable & scala.Serializable)(x$2, ms) -> {
            KafkaRequestHandlerTest.$anonfun$testCallbackTiming$2(time$1, handler$1, x$2, BoxesRunTime.unboxToInt((Object)ms));
            return BoxedUnit.UNIT;
        }, RequestLocal$.MODULE$.NoCaching())));
        request$1.apiLocalCompleteTimeNanos_$eq(time$1.nanoseconds());
    }

    public static final /* synthetic */ void $anonfun$testCallbackTryCompleteActions$3(Function1 callback$2) {
        callback$2.apply$mcVI$sp(1);
    }

    public static final /* synthetic */ void $anonfun$testCallbackTryCompleteActions$4(IntRef tryCompleteActionCount$1, InvocationOnMock x$6) {
        ++tryCompleteActionCount$1.elem;
    }

    public static final /* synthetic */ void $anonfun$testHandlingCallbackOnNewThread$2(IntRef handledCount$2, KafkaRequestHandler handler$3, RequestLocal reqLocal, int x$8) {
        reqLocal.bufferSupplier().close();
        ++handledCount$2.elem;
        handler$3.stop();
    }

    public static final /* synthetic */ void $anonfun$testHandlingCallbackOnNewThread$3(Function1 callback$3) {
        callback$3.apply$mcVI$sp(1);
    }

    public static final /* synthetic */ void $anonfun$testCallbackOnSameThread$2(IntRef handledCount$3, KafkaRequestHandler handler$4, RequestLocal reqLocal, int x$10) {
        reqLocal.bufferSupplier().close();
        ++handledCount$3.elem;
        handler$4.stop();
    }

    public static final /* synthetic */ void $anonfun$testCallbackOnSameThread$1(IntRef handledCount$3, KafkaRequestHandler handler$4, RequestLocal originalRequestLocal$2, InvocationOnMock x$9) {
        KafkaRequestHandler$.MODULE$.wrapAsyncCallback((Function2 & Serializable & scala.Serializable)(reqLocal, x$10) -> {
            KafkaRequestHandlerTest.$anonfun$testCallbackOnSameThread$2(handledCount$3, handler$4, reqLocal, BoxesRunTime.unboxToInt((Object)x$10));
            return BoxedUnit.UNIT;
        }, originalRequestLocal$2).apply$mcVI$sp(1);
    }

    public static final /* synthetic */ void $anonfun$testTopicStats$2(boolean systemRemoteStorageEnabled$1, BrokerTopicMetrics brokerTopicMetrics$1, String metricName) {
        if (systemRemoteStorageEnabled$1) {
            Assertions.assertTrue((boolean)brokerTopicMetrics$1.metricGaugeMap().contains((Object)metricName), (String)new StringBuilder(22).append("The metric is missing:").append(metricName).toString());
            return;
        }
        Assertions.assertFalse((boolean)brokerTopicMetrics$1.metricGaugeMap().contains((Object)metricName), (String)new StringBuilder(25).append("The metric should appear:").append(metricName).toString());
    }

    public KafkaRequestHandlerTest() {
        this.topic = "topic";
        this.topic2 = "topic2";
    }
}

