/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.util.HashMap;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import kafka.server.ControllerServer;
import kafka.test.ClusterConfig;
import kafka.test.ClusterInstance;
import kafka.test.annotation.ClusterConfigProperty;
import kafka.test.annotation.ClusterTest;
import kafka.test.annotation.Type;
import kafka.test.junit.ClusterTestExtensions;
import kafka.test.junit.ZkClusterInvocationContext;
import kafka.testkit.KafkaClusterTestKit;
import kafka.testkit.TestKitNodes;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.server.common.MetadataVersion;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Timeout;
import org.junit.jupiter.api.extension.ExtendWith;
import scala.Predef$;
import scala.collection.IterableLike;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;

@Timeout(value=120L)
@Tag(value="integration")
@ExtendWith(value={ClusterTestExtensions.class})
@ScalaSignature(bytes="\u0006\u0001\u0005ma\u0001B\u0003\u0007\u0001-AQA\u0005\u0001\u0005\u0002MAQA\u0006\u0001\u0005\u0002]AQA\u0017\u0001\u0005\u0002mCQA\u0019\u0001\u0005\u0002\r\u0014\u0001eS1gW\u0006\u001cVM\u001d<fe.\u0013\u0016M\u001a;SK\u001eL7\u000f\u001e:bi&|g\u000eV3ti*\u0011q\u0001C\u0001\u0007g\u0016\u0014h/\u001a:\u000b\u0003%\tQa[1gW\u0006\u001c\u0001a\u0005\u0002\u0001\u0019A\u0011Q\u0002E\u0007\u0002\u001d)\tq\"A\u0003tG\u0006d\u0017-\u0003\u0002\u0012\u001d\t1\u0011I\\=SK\u001a\fa\u0001P5oSRtD#\u0001\u000b\u0011\u0005U\u0001Q\"\u0001\u0004\u00027Q,7\u000f\u001e*fO&\u001cH/\u001a:[W\n\u0013xn[3s\u0013:\\%/\u00194u)\tA2\u0004\u0005\u0002\u000e3%\u0011!D\u0004\u0002\u0005+:LG\u000fC\u0003\u001d\u0005\u0001\u0007Q$A\u0005{W\u000ecWo\u001d;feB\u0011a$I\u0007\u0002?)\u0011\u0001\u0005C\u0001\u0005i\u0016\u001cH/\u0003\u0002#?\ty1\t\\;ti\u0016\u0014\u0018J\\:uC:\u001cW\r\u000b\u0006\u0003I)Z\u0013GM\u001a5\u0003\n\u0003\"!\n\u0015\u000e\u0003\u0019R!aJ\u0010\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0002*M\tY1\t\\;ti\u0016\u0014H+Z:u\u0003\u0015!\u0018\u0010]3tY\u0005aC%A\u0017\n\u00059z\u0013A\u0001.L\u0015\t\u0001d%\u0001\u0003UsB,\u0017a\u00022s_.,'o]\u000f\u0002\u0007\u0005yQ.\u001a;bI\u0006$\u0018MV3sg&|g\u000eJ\u00016\u0013\t1t'A\u0006J\u0005B{6g\u0018\u001b`\u0013Z\u0003$B\u0001\u001d:\u0003=iU\r^1eCR\fg+\u001a:tS>t'B\u0001\u001e<\u0003\u0019\u0019w.\\7p]*\u0011q\u0001\u0010\u0006\u0003\u0013uR!AP \u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005\u0001\u0015aA8sO\u0006\u00012/\u001a:wKJ\u0004&o\u001c9feRLWm\u001d\u0017\u0005\u00076\u0013VkK\u0003E\u000f\"S5\n\u0005\u0002&\u000b&\u0011aI\n\u0002\u0016\u00072,8\u000f^3s\u0007>tg-[4Qe>\u0004XM\u001d;z\u0003\rYW-_\u0011\u0002\u0013\u0006Q\u0012N\u001c;fe:\u0012'o\\6fe:b\u0017n\u001d;f]\u0016\u0014hF\\1nK\u0006)a/\u00197vK\u0006\nA*\u0001\u0005F1R+%KT!MW\u0015!uI\u0014&QC\u0005y\u0015!\u00037jgR,g.\u001a:tC\u0005\t\u0016A\f)M\u0003&sE+\u0012-Uu=zCn\\2bY\"|7\u000f\u001e\u001e1Y\u0015CF+\u0012*O\u00032Stf\f7pG\u0006d\u0007n\\:uuAZS\u0001R$T\u0015B\u000b\u0013\u0001V\u0001\u0015C\u00124XM\u001d;jg\u0016$g\u0006\\5ti\u0016tWM]:,\u000b\u0011;eK\u0013-\"\u0003]\u000ba\u0004\\5ti\u0016tWM\u001d\u0018tK\u000e,(/\u001b;z]A\u0014x\u000e^8d_2tS.\u00199\"\u0003e\u000ba%\u0012-U\u000bJs\u0015\t\u0014\u001eQ\u0019\u0006Ke\nV#Y)2\u0002F*Q%O)\u0016CFK\u000f)M\u0003&sE+\u0012-U\u0003!\"Xm\u001d;SKN$\u0018M\u001d;PY\u0012L%\r\u001d.l\u0005J|7.\u001a:J]6KwM]1uS>tWj\u001c3f)\tAB\fC\u0003\u001d\u0007\u0001\u0007Q\u0004\u000b\u0005\u0004I)r\u0016GM\u001a`Y\u0005aC%\u00011\n\u0005\u0005<\u0014aC%C!~\u001btlM0J-B\n!c\u001d5vi\u0012|wO\\%o'\u0016\fX/\u001a8dKR\u0019\u0001\u0004Z3\t\u000bq!\u0001\u0019A\u000f\t\u000b\u0019$\u0001\u0019A4\u0002\u0019-\u0014\u0018M\u001a;DYV\u001cH/\u001a:\u0011\u0005!\\W\"A5\u000b\u0005)D\u0011a\u0002;fgR\\\u0017\u000e^\u0005\u0003Y&\u00141cS1gW\u0006\u001cE.^:uKJ$Vm\u001d;LSRDC\u0001\u00018KuB\u0011q\u000e_\u0007\u0002a*\u0011\u0011O]\u0001\nKb$XM\\:j_:T!a\u001d;\u0002\u0007\u0005\u0004\u0018N\u0003\u0002vm\u00069!.\u001e9ji\u0016\u0014(BA<@\u0003\u0015QWO\\5u\u0013\tI\bO\u0001\u0006FqR,g\u000eZ,ji\"d\u0013a_\u0012\u0002yB\u0011Qp`\u0007\u0002}*\u0011qoH\u0005\u0004\u0003\u0003q(!F\"mkN$XM\u001d+fgR,\u0005\u0010^3og&|gn\u001d\u0015\u0007\u0001\u0005\u0015!*!\u0004\u0011\t\u0005\u001d\u0011\u0011B\u0007\u0002e&\u0019\u00111\u0002:\u0003\u0007Q\u000bw-\t\u0002\u0002\u0010\u0005Y\u0011N\u001c;fOJ\fG/[8oQ\u0019\u0001\u00111\u0003&\u0002\u001aA!\u0011qAA\u000b\u0013\r\t9B\u001d\u0002\b)&lWm\\;u=\u0005A\b")
public class KafkaServerKRaftRegistrationTest {
    @ClusterTest(types={Type.ZK}, brokers=3, metadataVersion=MetadataVersion.IBP_3_4_IV0, serverProperties={@ClusterConfigProperty(key="inter.broker.listener.name", value="EXTERNAL"), @ClusterConfigProperty(key="listeners", value="PLAINTEXT://localhost:0,EXTERNAL://localhost:0"), @ClusterConfigProperty(key="advertised.listeners", value="PLAINTEXT://localhost:0,EXTERNAL://localhost:0"), @ClusterConfigProperty(key="listener.security.protocol.map", value="EXTERNAL:PLAINTEXT,PLAINTEXT:PLAINTEXT")})
    public void testRegisterZkBrokerInKraft(ClusterInstance zkCluster) {
        String clusterId = zkCluster.clusterId();
        KafkaClusterTestKit kraftCluster = new KafkaClusterTestKit.Builder(new TestKitNodes.Builder().setBootstrapMetadataVersion(MetadataVersion.IBP_3_4_IV0).setClusterId(Uuid.fromString((String)clusterId)).setNumBrokerNodes(0).setNumControllerNodes(1).build()).setConfigProp("zookeeper.metadata.migration.enable", "true").setConfigProp("zookeeper.connect", ((ZkClusterInvocationContext.ZkClusterInstance)zkCluster).getUnderlying().zkConnect()).build();
        try {
            kraftCluster.format();
            kraftCluster.startup();
            CompletableFuture readyFuture = ((ControllerServer)((IterableLike)CollectionConverters$.MODULE$.collectionAsScalaIterableConverter(kraftCluster.controllers().values()).asScala()).head()).controller().waitForReadyBrokers(3);
            HashMap<String, String> serverProperties = new HashMap<String, String>(zkCluster.config().serverProperties());
            serverProperties.put("zookeeper.metadata.migration.enable", "true");
            serverProperties.put("controller.quorum.voters", kraftCluster.quorumVotersConfig());
            serverProperties.put("controller.listener.names", "CONTROLLER");
            serverProperties.put("listener.security.protocol.map", "CONTROLLER:PLAINTEXT,EXTERNAL:PLAINTEXT,PLAINTEXT:PLAINTEXT");
            ClusterConfig clusterConfig = ClusterConfig.builder(zkCluster.config()).setServerProperties(serverProperties).build();
            ((ZkClusterInvocationContext.ZkClusterInstance)zkCluster).rollingBrokerRestart(Optional.of(clusterConfig));
            zkCluster.waitForReadyBrokers();
            try {
                readyFuture.get(30L, TimeUnit.SECONDS);
            }
            catch (TimeoutException timeoutException) {
                Assertions.fail((String)"Did not see 3 brokers within 30 seconds");
            }
            catch (Throwable t) {
                Assertions.fail((String)"Had some other error waiting for brokers", (Throwable)t);
            }
        }
        finally {
            this.shutdownInSequence(zkCluster, kraftCluster);
        }
    }

    @ClusterTest(types={Type.ZK}, brokers=3, metadataVersion=MetadataVersion.IBP_3_3_IV0)
    public void testRestartOldIbpZkBrokerInMigrationMode(ClusterInstance zkCluster) {
        String clusterId = zkCluster.clusterId();
        KafkaClusterTestKit kraftCluster = new KafkaClusterTestKit.Builder(new TestKitNodes.Builder().setBootstrapMetadataVersion(MetadataVersion.IBP_3_4_IV0).setClusterId(Uuid.fromString((String)clusterId)).setNumBrokerNodes(0).setNumControllerNodes(1).build()).setConfigProp("zookeeper.metadata.migration.enable", "true").setConfigProp("zookeeper.connect", ((ZkClusterInvocationContext.ZkClusterInstance)zkCluster).getUnderlying().zkConnect()).build();
        try {
            kraftCluster.format();
            kraftCluster.startup();
            HashMap<String, String> serverProperties = new HashMap<String, String>(zkCluster.config().serverProperties());
            serverProperties.put("zookeeper.metadata.migration.enable", "true");
            serverProperties.put("controller.quorum.voters", kraftCluster.quorumVotersConfig());
            serverProperties.put("controller.listener.names", "CONTROLLER");
            serverProperties.put("listener.security.protocol.map", "CONTROLLER:PLAINTEXT,PLAINTEXT:PLAINTEXT");
            ClusterConfig clusterConfig = ClusterConfig.builder(zkCluster.config()).setServerProperties(serverProperties).build();
            Assertions.assertThrows(IllegalArgumentException.class, () -> ((ZkClusterInvocationContext.ZkClusterInstance)zkCluster).rollingBrokerRestart(Optional.of(clusterConfig)));
        }
        finally {
            this.shutdownInSequence(zkCluster, kraftCluster);
        }
    }

    public void shutdownInSequence(ClusterInstance zkCluster, KafkaClusterTestKit kraftCluster) {
        zkCluster.brokerIds().forEach(x$1 -> zkCluster.shutdownBroker(Predef$.MODULE$.Integer2int(x$1)));
        kraftCluster.close();
        zkCluster.stop();
    }
}

