/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.Serializable;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import kafka.server.BaseRequestTest;
import kafka.server.KafkaBroker;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.admin.TopicDescription;
import org.apache.kafka.common.IsolationLevel;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.TopicPartitionInfo;
import org.apache.kafka.common.message.ListOffsetsRequestData;
import org.apache.kafka.common.message.ListOffsetsResponseData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.ListOffsetsRequest;
import org.apache.kafka.common.requests.ListOffsetsResponse;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Iterable;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.mutable.Buffer$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.RichLong$;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\u0005%g\u0001\u0002\n\u0014\u0001aAQ!\b\u0001\u0005\u0002yAq\u0001\t\u0001C\u0002\u0013\u0005\u0011\u0005\u0003\u0004+\u0001\u0001\u0006IA\t\u0005\bW\u0001\u0011\r\u0011\"\u0001-\u0011\u0019A\u0004\u0001)A\u0005[!)\u0011\b\u0001C\u0001u!)Q\r\u0001C\u0001M\")1\u000e\u0001C\u0001Y\"9\u00111\u0002\u0001\u0005\u0002\u00055\u0001\u0002CA\f\u0001\u0001&I!!\u0007\t\u0011\u0005e\u0003\u0001)C\u0005\u00037B\u0001\"!\u001b\u0001A\u0013%\u00111\u000e\u0005\b\u0003s\u0002A\u0011AA>\u0011\u001d\t)\t\u0001C\u0001\u0003\u000fCq!!%\u0001\t\u0013\t\u0019\nC\u0004\u0002\u0018\u0001!I!!+\t\u000f\u0005]\u0006\u0001\"\u0001\u0002:\n1B*[:u\u001f\u001a47/\u001a;t%\u0016\fX/Z:u)\u0016\u001cHO\u0003\u0002\u0015+\u000511/\u001a:wKJT\u0011AF\u0001\u0006W\u000647.Y\u0002\u0001'\t\u0001\u0011\u0004\u0005\u0002\u001b75\t1#\u0003\u0002\u001d'\ty!)Y:f%\u0016\fX/Z:u)\u0016\u001cH/\u0001\u0004=S:LGO\u0010\u000b\u0002?A\u0011!\u0004A\u0001\u0006i>\u0004\u0018nY\u000b\u0002EA\u00111\u0005K\u0007\u0002I)\u0011QEJ\u0001\u0005Y\u0006twMC\u0001(\u0003\u0011Q\u0017M^1\n\u0005%\"#AB*ue&tw-\u0001\u0004u_BL7\rI\u0001\na\u0006\u0014H/\u001b;j_:,\u0012!\f\t\u0003]Yj\u0011a\f\u0006\u0003aE\naaY8n[>t'B\u0001\f3\u0015\t\u0019D'\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002k\u0005\u0019qN]4\n\u0005]z#A\u0004+pa&\u001c\u0007+\u0019:uSRLwN\\\u0001\u000ba\u0006\u0014H/\u001b;j_:\u0004\u0013!\u0007;fgRd\u0015n\u001d;PM\u001a\u001cX\r^:FeJ|'oQ8eKN$\"aO!\u0011\u0005qzT\"A\u001f\u000b\u0003y\nQa]2bY\u0006L!\u0001Q\u001f\u0003\tUs\u0017\u000e\u001e\u0005\u0006\u0005\u001a\u0001\raQ\u0001\u0007cV|'/^7\u0011\u0005\u0011[eBA#J!\t1U(D\u0001H\u0015\tAu#\u0001\u0004=e>|GOP\u0005\u0003\u0015v\na\u0001\u0015:fI\u00164\u0017BA\u0015M\u0015\tQU\b\u000b\u0003\u0007\u001dj[\u0006CA(Y\u001b\u0005\u0001&BA)S\u0003!\u0001(o\u001c<jI\u0016\u0014(BA*U\u0003\u0019\u0001\u0018M]1ng*\u0011QKV\u0001\bUV\u0004\u0018\u000e^3s\u0015\t9F'A\u0003kk:LG/\u0003\u0002Z!\nYa+\u00197vKN{WO]2f\u0003\u001d\u0019HO]5oONd#\u0001\u00180\"\u0003u\u000b!A_6\"\u0003}\u000bQa\u001b:bMRD#AB1\u0011\u0005\t\u001cW\"\u0001*\n\u0005\u0011\u0014&!\u0005)be\u0006lW\r^3sSj,G\rV3ti\u0006AC/Z:u\u0019&\u001cHo\u00144gg\u0016$8/T1y)&lWm\u0015;b[B|E\u000eZ3tiZ+'o]5p]R\u00111h\u001a\u0005\u0006\u0005\u001e\u0001\ra\u0011\u0015\u0005\u000f9S\u0016\u000e\f\u0002]=\"\u0012q!Y\u0001\u001cCN\u001cXM\u001d;SKN\u0004xN\\:f\u000bJ\u0014xN\u001d$pe\u0016\u0003xn\u00195\u0015\tmjWO\u001f\u0005\u0006]\"\u0001\ra\\\u0001\u0006KJ\u0014xN\u001d\t\u0003aNl\u0011!\u001d\u0006\u0003e>\n\u0001\u0002\u001d:pi>\u001cw\u000e\\\u0005\u0003iF\u0014a!\u0012:s_J\u001c\b\"\u0002<\t\u0001\u00049\u0018\u0001\u00032s_.,'/\u00133\u0011\u0005qB\u0018BA=>\u0005\rIe\u000e\u001e\u0005\u0006w\"\u0001\r\u0001`\u0001\u0013GV\u0014(/\u001a8u\u0019\u0016\fG-\u001a:Fa>\u001c\u0007\u000eE\u0003~\u0003\u0003\t)!D\u0001\u007f\u0015\tyh%\u0001\u0003vi&d\u0017bAA\u0002}\nAq\n\u001d;j_:\fG\u000eE\u0002$\u0003\u000fI1!!\u0003%\u0005\u001dIe\u000e^3hKJ\f!\u0004^3ti\u000e+(O]3oi\u0016\u0003xn\u00195WC2LG-\u0019;j_:$2aOA\b\u0011\u0015\u0011\u0015\u00021\u0001DQ\u0015IaJWA\nY\taf\f\u000b\u0002\nC\u0006Y1/\u001a8e%\u0016\fX/Z:u)!\tY\"!\u0011\u0002F\u0005=\u0003\u0003BA\u000f\u0003wqA!a\b\u000269!\u0011\u0011EA\u0019\u001d\u0011\t\u0019#a\f\u000f\t\u0005\u0015\u0012Q\u0006\b\u0005\u0003O\tYCD\u0002G\u0003SI\u0011!N\u0005\u0003gQJ!A\u0006\u001a\n\u0005A\n\u0014bAA\u001a_\u00059Q.Z:tC\u001e,\u0017\u0002BA\u001c\u0003s\tq\u0003T5ti>3gm]3ugJ+7\u000f]8og\u0016$\u0015\r^1\u000b\u0007\u0005Mr&\u0003\u0003\u0002>\u0005}\"\u0001\b'jgR|eMZ:fiN\u0004\u0016M\u001d;ji&|gNU3ta>t7/\u001a\u0006\u0005\u0003o\tI\u0004\u0003\u0004\u0002D)\u0001\ra^\u0001\tg\u0016\u0014h/\u001a:JI\"9\u0011q\t\u0006A\u0002\u0005%\u0013!\u0003;j[\u0016\u001cH/Y7q!\ra\u00141J\u0005\u0004\u0003\u001bj$\u0001\u0002'p]\u001eDq!!\u0015\u000b\u0001\u0004\t\u0019&A\u0004wKJ\u001c\u0018n\u001c8\u0011\u0007q\n)&C\u0002\u0002Xu\u0012Qa\u00155peR\f1CZ3uG\"|eMZ:fi\u0006sG-\u00129pG\"$\u0002\"!\u0018\u0002d\u0005\u0015\u0014q\r\t\u0007y\u0005}\u0013\u0011J<\n\u0007\u0005\u0005TH\u0001\u0004UkBdWM\r\u0005\u0007\u0003\u0007Z\u0001\u0019A<\t\u000f\u0005\u001d3\u00021\u0001\u0002J!9\u0011\u0011K\u0006A\u0002\u0005M\u0013\u0001\b4fi\u000eDwJ\u001a4tKR\fe\u000eZ#q_\u000eDw+\u001b;i\u000bJ\u0014xN\u001d\u000b\t\u0003[\n\u0019(!\u001e\u0002xAAA(a\u001c\u0002J]\f\u0019&C\u0002\u0002ru\u0012a\u0001V;qY\u0016\u001c\u0004BBA\"\u0019\u0001\u0007q\u000fC\u0004\u0002H1\u0001\r!!\u0013\t\u000f\u0005EC\u00021\u0001\u0002T\u0005yB/Z:u%\u0016\u001c\bo\u001c8tK&s7\r\\;eKNdU-\u00193fe\u0016\u0003xn\u00195\u0015\u0007m\ni\bC\u0003C\u001b\u0001\u00071\tK\u0003\u000e\u001dj\u000b\t\t\f\u0002]=\"\u0012Q\"Y\u00016i\u0016\u001cHOU3ta>t7/\u001a#fM\u0006,H\u000e^(gMN,G/\u00118e\u0019\u0016\fG-\u001a:Fa>\u001c\u0007NR8s\u00032dg+\u001a:tS>t7\u000fF\u0002<\u0003\u0013CQA\u0011\bA\u0002\rCSA\u0004([\u0003\u001bc#\u0001\u00180)\u00059\t\u0017aE1tg\u0016\u0014HOU3ta>t7/Z#se>\u0014HcB\u001e\u0002\u0016\u0006]\u0015\u0011\u0014\u0005\u0006]>\u0001\ra\u001c\u0005\u0006m>\u0001\ra\u001e\u0005\b\u00037{\u0001\u0019AAO\u0003\u001d\u0011X-];fgR\u0004B!a(\u0002&6\u0011\u0011\u0011\u0015\u0006\u0004\u0003G{\u0013\u0001\u0003:fcV,7\u000f^:\n\t\u0005\u001d\u0016\u0011\u0015\u0002\u0013\u0019&\u001cHo\u00144gg\u0016$8OU3rk\u0016\u001cH\u000f\u0006\u0004\u0002,\u0006E\u0016Q\u0017\t\u0005\u0003?\u000bi+\u0003\u0003\u00020\u0006\u0005&a\u0005'jgR|eMZ:fiN\u0014Vm\u001d9p]N,\u0007BBAZ!\u0001\u0007q/\u0001\u0005mK\u0006$WM]%e\u0011\u001d\tY\n\u0005a\u0001\u0003;\u000b1b\u0019:fCR,Gk\u001c9jGR1\u00111XAa\u0003\u000b\u0004R\u0001RA_o^L1!a0M\u0005\ri\u0015\r\u001d\u0005\u0007\u0003\u0007\f\u0002\u0019A<\u0002\u001b9,X\u000eU1si&$\u0018n\u001c8t\u0011\u0019\t9-\u0005a\u0001o\u0006\t\"/\u001a9mS\u000e\fG/[8o\r\u0006\u001cGo\u001c:")
public class ListOffsetsRequestTest
extends BaseRequestTest {
    private final String topic;
    private final TopicPartition partition = new TopicPartition(this.topic(), 0);

    public String topic() {
        return this.topic;
    }

    public TopicPartition partition() {
        return this.partition;
    }

    @ParameterizedTest
    @ValueSource(strings={"zk", "kraft"})
    public void testListOffsetsErrorCodes(String quorum) {
        java.util.List targetTimes = (java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)new ListOffsetsRequestData.ListOffsetsTopic().setName(this.topic()).setPartitions((java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)new ListOffsetsRequestData.ListOffsetsPartition().setPartitionIndex(this.partition().partition()).setTimestamp(-2L).setCurrentLeaderEpoch(0), (List)Nil$.MODULE$)).asJava()), (List)Nil$.MODULE$)).asJava();
        ListOffsetsRequest consumerRequest = (ListOffsetsRequest)ListOffsetsRequest.Builder.forConsumer((boolean)false, (IsolationLevel)IsolationLevel.READ_UNCOMMITTED, (boolean)false).setTargetTimes(targetTimes).build();
        ListOffsetsRequest replicaRequest = (ListOffsetsRequest)ListOffsetsRequest.Builder.forReplica((short)ApiKeys.LIST_OFFSETS.latestVersion(), (int)((KafkaBroker)this.brokers().head()).config().brokerId()).setTargetTimes(targetTimes).build();
        ListOffsetsRequest debugReplicaRequest = (ListOffsetsRequest)ListOffsetsRequest.Builder.forReplica((short)ApiKeys.LIST_OFFSETS.latestVersion(), (int)-2).setTargetTimes(targetTimes).build();
        int randomBrokerId = ((KafkaBroker)this.brokers().head()).config().brokerId();
        this.assertResponseError(Errors.UNKNOWN_TOPIC_OR_PARTITION, randomBrokerId, consumerRequest);
        this.assertResponseError(Errors.UNKNOWN_TOPIC_OR_PARTITION, randomBrokerId, replicaRequest);
        this.assertResponseError(Errors.UNKNOWN_TOPIC_OR_PARTITION, randomBrokerId, debugReplicaRequest);
        scala.collection.immutable.Map<Object, Object> partitionToLeader = this.createTopic(1, 2);
        Map topicDescription = (Map)this.createAdminClient(this.createAdminClient$default$1(), this.createAdminClient$default$2()).describeTopics((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)this.partition().topic(), (List)Nil$.MODULE$)).asJava()).allTopicNames().get();
        Set replicas = ((TraversableOnce)((TraversableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(((TopicPartitionInfo)((TopicDescription)topicDescription.get(this.partition().topic())).partitions().get(this.partition().partition())).replicas()).asScala()).map((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToInteger((int)x$1.id()), Buffer$.MODULE$.canBuildFrom())).toSet();
        int leader = BoxesRunTime.unboxToInt((Object)partitionToLeader.apply((Object)BoxesRunTime.boxToInteger((int)this.partition().partition())));
        int follower = BoxesRunTime.unboxToInt((Object)replicas.find((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)x$2 -> x$2 != leader).get());
        int nonReplica = BoxesRunTime.unboxToInt((Object)((IterableLike)this.brokers().map((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToInteger((int)ListOffsetsRequestTest.$anonfun$testListOffsetsErrorCodes$3(x$3)), Buffer$.MODULE$.canBuildFrom())).find((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)x$4 -> !replicas.contains((Object)BoxesRunTime.boxToInteger((int)x$4))).get());
        this.assertResponseError(Errors.NOT_LEADER_OR_FOLLOWER, follower, consumerRequest);
        this.assertResponseError(Errors.NOT_LEADER_OR_FOLLOWER, follower, replicaRequest);
        this.assertResponseError(Errors.NONE, follower, debugReplicaRequest);
        this.assertResponseError(Errors.NOT_LEADER_OR_FOLLOWER, nonReplica, consumerRequest);
        this.assertResponseError(Errors.NOT_LEADER_OR_FOLLOWER, nonReplica, replicaRequest);
        this.assertResponseError(Errors.NOT_LEADER_OR_FOLLOWER, nonReplica, debugReplicaRequest);
    }

    @ParameterizedTest
    @ValueSource(strings={"zk", "kraft"})
    public void testListOffsetsMaxTimeStampOldestVersion(String quorum) {
        ListOffsetsRequest.Builder consumerRequestBuilder = ListOffsetsRequest.Builder.forConsumer((boolean)false, (IsolationLevel)IsolationLevel.READ_UNCOMMITTED, (boolean)false);
        ListOffsetsRequest.Builder maxTimestampRequestBuilder = ListOffsetsRequest.Builder.forConsumer((boolean)false, (IsolationLevel)IsolationLevel.READ_UNCOMMITTED, (boolean)true);
        Assertions.assertEquals((short)((short)0), (short)consumerRequestBuilder.oldestAllowedVersion());
        Assertions.assertEquals((short)((short)7), (short)maxTimestampRequestBuilder.oldestAllowedVersion());
    }

    public void assertResponseErrorForEpoch(Errors error, int brokerId, Optional<Integer> currentLeaderEpoch) {
        ListOffsetsRequestData.ListOffsetsPartition listOffsetPartition = new ListOffsetsRequestData.ListOffsetsPartition().setPartitionIndex(this.partition().partition()).setTimestamp(-2L);
        if (currentLeaderEpoch.isPresent()) {
            listOffsetPartition.setCurrentLeaderEpoch(Predef$.MODULE$.Integer2int(currentLeaderEpoch.get()));
        }
        java.util.List targetTimes = (java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)new ListOffsetsRequestData.ListOffsetsTopic().setName(this.topic()).setPartitions((java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)listOffsetPartition, (List)Nil$.MODULE$)).asJava()), (List)Nil$.MODULE$)).asJava();
        ListOffsetsRequest request = (ListOffsetsRequest)ListOffsetsRequest.Builder.forConsumer((boolean)false, (IsolationLevel)IsolationLevel.READ_UNCOMMITTED, (boolean)false).setTargetTimes(targetTimes).build();
        this.assertResponseError(error, brokerId, request);
    }

    @ParameterizedTest
    @ValueSource(strings={"zk", "kraft"})
    public void testCurrentEpochValidation(String quorum) {
        String topic = "topic";
        TopicPartition topicPartition = new TopicPartition(topic, 0);
        int firstLeaderId = BoxesRunTime.unboxToInt((Object)this.createTopic(1, 3).apply((Object)BoxesRunTime.boxToInteger((int)topicPartition.partition())));
        this.killBroker(firstLeaderId);
        int secondLeaderId = TestUtils$.MODULE$.awaitLeaderChange(this.brokers(), topicPartition, firstLeaderId, TestUtils$.MODULE$.awaitLeaderChange$default$4());
        int secondLeaderEpoch = TestUtils$.MODULE$.findLeaderEpoch(secondLeaderId, topicPartition, (Iterable<KafkaBroker>)this.brokers());
        this.assertResponseErrorForEpoch(Errors.NONE, secondLeaderId, Optional.empty());
        this.assertResponseErrorForEpoch(Errors.NONE, secondLeaderId, Optional.of(Predef$.MODULE$.int2Integer(secondLeaderEpoch)));
        this.assertResponseErrorForEpoch(Errors.FENCED_LEADER_EPOCH, secondLeaderId, Optional.of(Predef$.MODULE$.int2Integer(secondLeaderEpoch - 1)));
        this.assertResponseErrorForEpoch(Errors.UNKNOWN_LEADER_EPOCH, secondLeaderId, Optional.of(Predef$.MODULE$.int2Integer(secondLeaderEpoch + 1)));
        int followerId = TestUtils$.MODULE$.findFollowerId(topicPartition, (Iterable<KafkaBroker>)this.brokers());
        this.assertResponseErrorForEpoch(Errors.NOT_LEADER_OR_FOLLOWER, followerId, Optional.empty());
        this.assertResponseErrorForEpoch(Errors.NOT_LEADER_OR_FOLLOWER, followerId, Optional.of(Predef$.MODULE$.int2Integer(secondLeaderEpoch)));
        this.assertResponseErrorForEpoch(Errors.UNKNOWN_LEADER_EPOCH, followerId, Optional.of(Predef$.MODULE$.int2Integer(secondLeaderEpoch + 1)));
        this.assertResponseErrorForEpoch(Errors.FENCED_LEADER_EPOCH, followerId, Optional.of(Predef$.MODULE$.int2Integer(secondLeaderEpoch - 1)));
    }

    private ListOffsetsResponseData.ListOffsetsPartitionResponse sendRequest(int serverId, long timestamp, short version) {
        java.util.List targetTimes = (java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)new ListOffsetsRequestData.ListOffsetsTopic().setName(this.topic()).setPartitions((java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)new ListOffsetsRequestData.ListOffsetsPartition().setPartitionIndex(this.partition().partition()).setTimestamp(timestamp), (List)Nil$.MODULE$)).asJava()), (List)Nil$.MODULE$)).asJava();
        ListOffsetsRequest.Builder builder = ListOffsetsRequest.Builder.forConsumer((boolean)false, (IsolationLevel)IsolationLevel.READ_UNCOMMITTED, (boolean)false).setTargetTimes(targetTimes);
        ListOffsetsRequest request = version == -1 ? (ListOffsetsRequest)builder.build() : builder.build(version);
        return (ListOffsetsResponseData.ListOffsetsPartitionResponse)((IterableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(((ListOffsetsResponseData.ListOffsetsTopicResponse)((IterableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(this.sendRequest(serverId, request).topics()).asScala()).find((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)ListOffsetsRequestTest.$anonfun$sendRequest$1(this, x$5))).get()).partitions()).asScala()).find((Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)ListOffsetsRequestTest.$anonfun$sendRequest$2(this, x$6))).get();
    }

    /*
     * WARNING - void declaration
     */
    private Tuple2<Object, Object> fetchOffsetAndEpoch(int serverId, long timestamp, short version) {
        void var8_6;
        void var6_5;
        Tuple3<Object, Object, Object> tuple3 = this.fetchOffsetAndEpochWithError(serverId, timestamp, version);
        if (tuple3 == null) {
            throw new MatchError(null);
        }
        long offset = BoxesRunTime.unboxToLong((Object)tuple3._1());
        int leaderEpoch = BoxesRunTime.unboxToInt((Object)tuple3._2());
        return new Tuple2.mcJI.sp((long)var6_5, (int)var8_6);
    }

    private Tuple3<Object, Object, Object> fetchOffsetAndEpochWithError(int serverId, long timestamp, short version) {
        ListOffsetsResponseData.ListOffsetsPartitionResponse partitionData = this.sendRequest(serverId, timestamp, version);
        if (version == 0) {
            if (partitionData.oldStyleOffsets().isEmpty()) {
                return new Tuple3((Object)BoxesRunTime.boxToLong((long)-1L), (Object)BoxesRunTime.boxToInteger((int)partitionData.leaderEpoch()), (Object)BoxesRunTime.boxToShort((short)partitionData.errorCode()));
            }
            return new Tuple3((Object)BoxesRunTime.boxToLong((long)Predef$.MODULE$.Long2long((Long)((IterableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(partitionData.oldStyleOffsets()).asScala()).head())), (Object)BoxesRunTime.boxToInteger((int)partitionData.leaderEpoch()), (Object)BoxesRunTime.boxToShort((short)partitionData.errorCode()));
        }
        return new Tuple3((Object)BoxesRunTime.boxToLong((long)partitionData.offset()), (Object)BoxesRunTime.boxToInteger((int)partitionData.leaderEpoch()), (Object)BoxesRunTime.boxToShort((short)partitionData.errorCode()));
    }

    /*
     * WARNING - void declaration
     */
    @ParameterizedTest
    @ValueSource(strings={"zk", "kraft"})
    public void testResponseIncludesLeaderEpoch(String quorum) {
        int firstLeaderId = BoxesRunTime.unboxToInt((Object)this.createTopic(1, 3).apply((Object)BoxesRunTime.boxToInteger((int)this.partition().partition())));
        TestUtils$.MODULE$.generateAndProduceMessages(this.brokers(), this.topic(), 9, TestUtils$.MODULE$.generateAndProduceMessages$default$4());
        TestUtils$.MODULE$.produceMessage(this.brokers(), this.topic(), "test-10", Predef$.MODULE$.long2Long(System.currentTimeMillis() + 10L), TestUtils$.MODULE$.produceMessage$default$5(), TestUtils$.MODULE$.produceMessage$default$6());
        int firstLeaderEpoch = TestUtils$.MODULE$.findLeaderEpoch(firstLeaderId, this.partition(), (Iterable<KafkaBroker>)this.brokers());
        Assertions.assertEquals((Object)new Tuple2.mcJI.sp(0L, firstLeaderEpoch), this.fetchOffsetAndEpoch(firstLeaderId, 0L, (short)-1));
        Assertions.assertEquals((Object)new Tuple2.mcJI.sp(0L, firstLeaderEpoch), this.fetchOffsetAndEpoch(firstLeaderId, -2L, (short)-1));
        Assertions.assertEquals((Object)new Tuple2.mcJI.sp(0L, firstLeaderEpoch), this.fetchOffsetAndEpoch(firstLeaderId, -4L, (short)-1));
        Assertions.assertEquals((Object)new Tuple2.mcJI.sp(10L, firstLeaderEpoch), this.fetchOffsetAndEpoch(firstLeaderId, -1L, (short)-1));
        Assertions.assertEquals((Object)new Tuple2.mcJI.sp(9L, firstLeaderEpoch), this.fetchOffsetAndEpoch(firstLeaderId, -3L, (short)-1));
        this.killBroker(firstLeaderId);
        int secondLeaderId = TestUtils$.MODULE$.awaitLeaderChange(this.brokers(), this.partition(), firstLeaderId, TestUtils$.MODULE$.awaitLeaderChange$default$4());
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!ListOffsetsRequestTest.$anonfun$testResponseIncludesLeaderEpoch$1(this, secondLeaderId)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)ListOffsetsRequestTest.$anonfun$testResponseIncludesLeaderEpoch$2());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        int secondLeaderEpoch = TestUtils$.MODULE$.findLeaderEpoch(secondLeaderId, this.partition(), (Iterable<KafkaBroker>)this.brokers());
        Assertions.assertEquals((Object)new Tuple2.mcJI.sp(0L, firstLeaderEpoch), this.fetchOffsetAndEpoch(secondLeaderId, 0L, (short)-1));
        Assertions.assertEquals((Object)new Tuple2.mcJI.sp(0L, firstLeaderEpoch), this.fetchOffsetAndEpoch(secondLeaderId, -4L, (short)-1));
        Assertions.assertEquals((Object)new Tuple2.mcJI.sp(0L, firstLeaderEpoch), this.fetchOffsetAndEpoch(secondLeaderId, 0L, (short)-1));
        Assertions.assertEquals((Object)new Tuple2.mcJI.sp(0L, firstLeaderEpoch), this.fetchOffsetAndEpoch(secondLeaderId, -2L, (short)-1));
        Assertions.assertEquals((Object)new Tuple2.mcJI.sp(0L, firstLeaderEpoch), this.fetchOffsetAndEpoch(secondLeaderId, 0L, (short)-1));
        Assertions.assertEquals((Object)new Tuple2.mcJI.sp(0L, firstLeaderEpoch), this.fetchOffsetAndEpoch(secondLeaderId, -2L, (short)-1));
        Assertions.assertEquals((Object)new Tuple3((Object)BoxesRunTime.boxToLong((long)10L), (Object)BoxesRunTime.boxToInteger((int)secondLeaderEpoch), (Object)BoxesRunTime.boxToShort((short)Errors.NONE.code())), this.fetchOffsetAndEpochWithError(secondLeaderId, -1L, (short)-1));
        Assertions.assertEquals((Object)new Tuple3((Object)BoxesRunTime.boxToLong((long)9L), (Object)BoxesRunTime.boxToInteger((int)firstLeaderEpoch), (Object)BoxesRunTime.boxToShort((short)Errors.NONE.code())), this.fetchOffsetAndEpochWithError(secondLeaderId, -3L, (short)-1));
    }

    @ParameterizedTest
    @ValueSource(strings={"zk", "kraft"})
    public void testResponseDefaultOffsetAndLeaderEpochForAllVersions(String quorum) {
        int firstLeaderId = BoxesRunTime.unboxToInt((Object)this.createTopic(1, 3).apply((Object)BoxesRunTime.boxToInteger((int)this.partition().partition())));
        TestUtils$.MODULE$.generateAndProduceMessages(this.brokers(), this.topic(), 9, TestUtils$.MODULE$.generateAndProduceMessages$default$4());
        TestUtils$.MODULE$.produceMessage(this.brokers(), this.topic(), "test-10", Predef$.MODULE$.long2Long(System.currentTimeMillis() + 10L), TestUtils$.MODULE$.produceMessage$default$5(), TestUtils$.MODULE$.produceMessage$default$6());
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper((int)ApiKeys.LIST_OFFSETS.oldestVersion()), (int)ApiKeys.LIST_OFFSETS.latestVersion()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)version -> {
            if (version == 0) {
                Assertions.assertEquals((Object)new Tuple2.mcJI.sp(-1L, -1), this.fetchOffsetAndEpoch(firstLeaderId, 0L, (short)version));
                Assertions.assertEquals((Object)new Tuple2.mcJI.sp(0L, -1), this.fetchOffsetAndEpoch(firstLeaderId, -2L, (short)version));
                Assertions.assertEquals((Object)new Tuple2.mcJI.sp(0L, -1), this.fetchOffsetAndEpoch(firstLeaderId, -4L, (short)version));
                Assertions.assertEquals((Object)new Tuple2.mcJI.sp(10L, -1), this.fetchOffsetAndEpoch(firstLeaderId, -1L, (short)version));
                return;
            }
            if (version >= 1 && version <= 3) {
                Assertions.assertEquals((Object)new Tuple2.mcJI.sp(0L, -1), this.fetchOffsetAndEpoch(firstLeaderId, 0L, (short)version));
                Assertions.assertEquals((Object)new Tuple2.mcJI.sp(0L, -1), this.fetchOffsetAndEpoch(firstLeaderId, -2L, (short)version));
                Assertions.assertEquals((Object)new Tuple2.mcJI.sp(0L, -1), this.fetchOffsetAndEpoch(firstLeaderId, -4L, (short)version));
                Assertions.assertEquals((Object)new Tuple2.mcJI.sp(10L, -1), this.fetchOffsetAndEpoch(firstLeaderId, -1L, (short)version));
                return;
            }
            if (version >= 4 && version <= 6) {
                Assertions.assertEquals((Object)new Tuple2.mcJI.sp(0L, 0), this.fetchOffsetAndEpoch(firstLeaderId, 0L, (short)version));
                Assertions.assertEquals((Object)new Tuple2.mcJI.sp(0L, 0), this.fetchOffsetAndEpoch(firstLeaderId, -2L, (short)version));
                Assertions.assertEquals((Object)new Tuple2.mcJI.sp(0L, 0), this.fetchOffsetAndEpoch(firstLeaderId, -4L, (short)version));
                Assertions.assertEquals((Object)new Tuple2.mcJI.sp(10L, 0), this.fetchOffsetAndEpoch(firstLeaderId, -1L, (short)version));
                return;
            }
            if (version >= 7) {
                Assertions.assertEquals((Object)new Tuple2.mcJI.sp(0L, 0), this.fetchOffsetAndEpoch(firstLeaderId, 0L, (short)version));
                Assertions.assertEquals((Object)new Tuple2.mcJI.sp(0L, 0), this.fetchOffsetAndEpoch(firstLeaderId, -2L, (short)version));
                Assertions.assertEquals((Object)new Tuple2.mcJI.sp(0L, 0), this.fetchOffsetAndEpoch(firstLeaderId, -4L, (short)version));
                Assertions.assertEquals((Object)new Tuple2.mcJI.sp(10L, 0), this.fetchOffsetAndEpoch(firstLeaderId, -1L, (short)version));
                Assertions.assertEquals((Object)new Tuple2.mcJI.sp(9L, 0), this.fetchOffsetAndEpoch(firstLeaderId, -3L, (short)version));
                return;
            }
        });
    }

    private void assertResponseError(Errors error, int brokerId, ListOffsetsRequest request) {
        ListOffsetsResponse response = this.sendRequest(brokerId, request);
        Assertions.assertEquals((int)request.topics().size(), (int)response.topics().size());
        ((IterableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(response.topics()).asScala()).foreach((Function1 & Serializable & scala.Serializable)topic -> {
            ListOffsetsRequestTest.$anonfun$assertResponseError$1(error, topic);
            return BoxedUnit.UNIT;
        });
    }

    private ListOffsetsResponse sendRequest(int leaderId, ListOffsetsRequest request) {
        return (ListOffsetsResponse)this.connectAndReceive((AbstractRequest)request, this.brokerSocketServer(leaderId), this.connectAndReceive$default$3(), ClassTag$.MODULE$.apply(ListOffsetsResponse.class));
    }

    public scala.collection.immutable.Map<Object, Object> createTopic(int numPartitions, int replicationFactor) {
        return super.createTopic(this.topic(), numPartitions, replicationFactor, super.createTopic$default$4(), super.createTopic$default$5(), super.createTopic$default$6());
    }

    public static final /* synthetic */ int $anonfun$testListOffsetsErrorCodes$3(KafkaBroker x$3) {
        return x$3.config().brokerId();
    }

    public static final /* synthetic */ boolean $anonfun$sendRequest$1(ListOffsetsRequestTest $this, ListOffsetsResponseData.ListOffsetsTopicResponse x$5) {
        String string = x$5.name();
        String string2 = $this.topic();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$sendRequest$2(ListOffsetsRequestTest $this, ListOffsetsResponseData.ListOffsetsPartitionResponse x$6) {
        return x$6.partitionIndex() == $this.partition().partition();
    }

    public static final /* synthetic */ boolean $anonfun$testResponseIncludesLeaderEpoch$1(ListOffsetsRequestTest $this, int secondLeaderId$1) {
        return $this.sendRequest(secondLeaderId$1, -1L, (short)-1).errorCode() != Errors.OFFSET_NOT_AVAILABLE.code();
    }

    public static final /* synthetic */ String $anonfun$testResponseIncludesLeaderEpoch$2() {
        return "the second leader does not sync to follower";
    }

    public static final /* synthetic */ void $anonfun$assertResponseError$2(Errors error$1, ListOffsetsResponseData.ListOffsetsPartitionResponse partition) {
        Assertions.assertEquals((short)error$1.code(), (short)partition.errorCode());
    }

    public static final /* synthetic */ void $anonfun$assertResponseError$1(Errors error$1, ListOffsetsResponseData.ListOffsetsTopicResponse topic) {
        ((IterableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(topic.partitions()).asScala()).foreach((Function1 & Serializable & scala.Serializable)partition -> {
            ListOffsetsRequestTest.$anonfun$assertResponseError$2(error$1, partition);
            return BoxedUnit.UNIT;
        });
    }

    public ListOffsetsRequestTest() {
        this.topic = "topic";
    }
}

