/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import kafka.test.ClusterInstance;
import kafka.test.annotation.ClusterTest;
import kafka.test.annotation.ClusterTests;
import kafka.test.annotation.Type;
import kafka.test.junit.ClusterTestExtensions;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.clients.admin.FeatureMetadata;
import org.apache.kafka.clients.admin.FeatureUpdate;
import org.apache.kafka.clients.admin.FinalizedVersionRange;
import org.apache.kafka.clients.admin.UpdateFeaturesOptions;
import org.apache.kafka.server.common.MetadataVersion;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.extension.ExtendWith;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Map;
import scala.collection.Seq;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.RichLong$;

@ExtendWith(value={ClusterTestExtensions.class})
@ScalaSignature(bytes="\u0006\u0001e4A!\u0002\u0004\u0001\u0017!)!\u0003\u0001C\u0001'!)a\u0003\u0001C\u0001/!)1\f\u0001C\u00019\")\u0001\r\u0001C\u0001C\nqR*\u001a;bI\u0006$\u0018MV3sg&|g.\u00138uK\u001e\u0014\u0018\r^5p]R+7\u000f\u001e\u0006\u0003\u000f!\taa]3sm\u0016\u0014(\"A\u0005\u0002\u000b-\fgm[1\u0004\u0001M\u0011\u0001\u0001\u0004\t\u0003\u001bAi\u0011A\u0004\u0006\u0002\u001f\u0005)1oY1mC&\u0011\u0011C\u0004\u0002\u0007\u0003:L(+\u001a4\u0002\rqJg.\u001b;?)\u0005!\u0002CA\u000b\u0001\u001b\u00051\u0011a\b;fgR\u0014\u0015m]5d\u001b\u0016$\u0018\rZ1uCZ+'o]5p]V\u0003xM]1eKR\u0011\u0001d\u0007\t\u0003\u001beI!A\u0007\b\u0003\tUs\u0017\u000e\u001e\u0005\u00069\t\u0001\r!H\u0001\u0010G2,8\u000f^3s\u0013:\u001cH/\u00198dKB\u0011a$I\u0007\u0002?)\u0011\u0001\u0005C\u0001\u0005i\u0016\u001cH/\u0003\u0002#?\ty1\t\\;ti\u0016\u0014\u0018J\\:uC:\u001cW\r\u000b\u0003\u0003I)Z\u0003CA\u0013)\u001b\u00051#BA\u0014 \u0003)\tgN\\8uCRLwN\\\u0005\u0003S\u0019\u0012Ab\u00117vgR,'\u000fV3tiN\fQA^1mk\u0016dc\u0001L#K\u001fRK6&B\u00171c]B\u0004CA\u0013/\u0013\tycEA\u0006DYV\u001cH/\u001a:UKN$\u0018!\u0002;za\u0016\u001cH&\u0001\u001a%\u0003MJ!\u0001N\u001b\u0002\u000b-\u0013\u0016I\u0012+\u000b\u0005Y2\u0013\u0001\u0002+za\u0016\fq\"\\3uC\u0012\fG/\u0019,feNLwN\u001c\u0013\u0002s%\u0011!hO\u0001\f\u0013\n\u0003vlM04?&3\u0006G\u0003\u0002={\u0005yQ*\u001a;bI\u0006$\u0018MV3sg&|gN\u0003\u0002?\u007f\u000511m\\7n_:T!a\u0002!\u000b\u0005%\t%B\u0001\"D\u0003\u0019\t\u0007/Y2iK*\tA)A\u0002pe\u001e\\S!\f\u0019Go\u001dc\u0013A\r\u0013\u0002\u0011&\u0011\u0011jO\u0001\f\u0013\n\u0003vlM04?&3\u0016gK\u0003.a-;D\nL\u00013I\u0005i\u0015B\u0001(<\u0003-I%\tU04?Nz\u0016J\u0016\u001a,\u000b5\u0002\u0004kN)-\u0003I\"\u0013AU\u0005\u0003'n\n1\"\u0013\"Q?Nz6gX%Wg-*Q\u0006M+8-2\n!\u0007J\u0001X\u0013\tA6(A\u0006J\u0005B{6g\u0018\u001b`\u0013Z\u00034&B\u001715^2F&\u0001\u001a\u0002-Q,7\u000f^+qOJ\fG-Z*b[\u00164VM]:j_:$\"\u0001G/\t\u000bq\u0019\u0001\u0019A\u000f)\r\ri\u0003gX\u001c9Y\u0005\u0011\u0014A\u0007;fgR$UMZ1vYRL5\u000fT1uKN$h+\u001a:tS>tGC\u0001\rc\u0011\u0015aB\u00011\u0001\u001eQ\u0011!Q\u0006\r3-\u0003IBC\u0001\u00014+eB\u0011q\r]\u0007\u0002Q*\u0011\u0011N[\u0001\nKb$XM\\:j_:T!a\u001b7\u0002\u0007\u0005\u0004\u0018N\u0003\u0002n]\u00069!.\u001e9ji\u0016\u0014(BA8D\u0003\u0015QWO\\5u\u0013\t\t\bN\u0001\u0006FqR,g\u000eZ,ji\"d\u0013a]\u0012\u0002iB\u0011Qo^\u0007\u0002m*\u0011qnH\u0005\u0003qZ\u0014Qc\u00117vgR,'\u000fV3ti\u0016CH/\u001a8tS>t7\u000f")
public class MetadataVersionIntegrationTest {
    /*
     * WARNING - void declaration
     */
    @ClusterTests(value={@ClusterTest(types={Type.KRAFT}, metadataVersion=MetadataVersion.IBP_3_3_IV0), @ClusterTest(types={Type.KRAFT}, metadataVersion=MetadataVersion.IBP_3_3_IV1), @ClusterTest(types={Type.KRAFT}, metadataVersion=MetadataVersion.IBP_3_3_IV2), @ClusterTest(types={Type.KRAFT}, metadataVersion=MetadataVersion.IBP_3_3_IV3), @ClusterTest(types={Type.KRAFT}, metadataVersion=MetadataVersion.IBP_3_4_IV0), @ClusterTest(types={Type.KRAFT}, metadataVersion=MetadataVersion.IBP_3_4_IV0)})
    public void testBasicMetadataVersionUpgrade(ClusterInstance clusterInstance) {
        Admin admin = clusterInstance.createAdminClient();
        FinalizedVersionRange ff = (FinalizedVersionRange)((FeatureMetadata)admin.describeFeatures().featureMetadata().get()).finalizedFeatures().get("metadata.version");
        Assertions.assertEquals((short)ff.minVersionLevel(), (short)clusterInstance.config().metadataVersion().featureLevel());
        Assertions.assertEquals((short)ff.maxVersionLevel(), (short)clusterInstance.config().metadataVersion().featureLevel());
        short updateVersion = MetadataVersion.IBP_3_5_IV1.featureLevel();
        admin.updateFeatures((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"metadata.version"), (Object)new FeatureUpdate(updateVersion, FeatureUpdate.UpgradeType.UPGRADE))}))).asJava(), new UpdateFeaturesOptions()).all().get();
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!MetadataVersionIntegrationTest.$anonfun$testBasicMetadataVersionUpgrade$1(admin, updateVersion)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)MetadataVersionIntegrationTest.$anonfun$testBasicMetadataVersionUpgrade$2());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
    }

    @ClusterTest(types={Type.KRAFT}, metadataVersion=MetadataVersion.IBP_3_3_IV0)
    public void testUpgradeSameVersion(ClusterInstance clusterInstance) {
        Admin admin = clusterInstance.createAdminClient();
        short updateVersion = MetadataVersion.IBP_3_3_IV0.featureLevel();
        admin.updateFeatures((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"metadata.version"), (Object)new FeatureUpdate(updateVersion, FeatureUpdate.UpgradeType.UPGRADE))}))).asJava(), new UpdateFeaturesOptions()).all().get();
    }

    @ClusterTest(types={Type.KRAFT})
    public void testDefaultIsLatestVersion(ClusterInstance clusterInstance) {
        FinalizedVersionRange ff = (FinalizedVersionRange)((FeatureMetadata)clusterInstance.createAdminClient().describeFeatures().featureMetadata().get()).finalizedFeatures().get("metadata.version");
        Assertions.assertEquals((short)ff.minVersionLevel(), (short)MetadataVersion.latestTesting().featureLevel(), (String)"If this test fails, check the default MetadataVersion in the @ClusterTest annotation");
        Assertions.assertEquals((short)ff.maxVersionLevel(), (short)MetadataVersion.latestTesting().featureLevel());
    }

    public static final /* synthetic */ boolean $anonfun$testBasicMetadataVersionUpgrade$1(Admin admin$1, short updateVersion$1) {
        FinalizedVersionRange ff2 = (FinalizedVersionRange)((FeatureMetadata)admin$1.describeFeatures().featureMetadata().get()).finalizedFeatures().get("metadata.version");
        return ff2.minVersionLevel() == updateVersion$1 && ff2.maxVersionLevel() == updateVersion$1;
    }

    public static final /* synthetic */ String $anonfun$testBasicMetadataVersionUpgrade$2() {
        return "Never saw metadata.version increase on broker";
    }
}

