/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import com.yammer.metrics.core.MetricName;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.Collections;
import java.util.Properties;
import java.util.stream.Stream;
import kafka.server.BaseRequestTest;
import kafka.server.BrokerTopicStats$;
import kafka.server.KafkaBroker;
import kafka.server.ProduceRequestTest$;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.compress.Compression;
import org.apache.kafka.common.message.ProduceRequestData;
import org.apache.kafka.common.message.ProduceResponseData;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.record.BaseRecords;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.MemoryRecordsBuilder;
import org.apache.kafka.common.record.SimpleRecord;
import org.apache.kafka.common.record.TimestampType;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.ProduceRequest;
import org.apache.kafka.common.requests.ProduceResponse;
import org.apache.kafka.server.metrics.KafkaYammerMetrics;
import org.apache.kafka.server.record.BrokerCompressionType;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;
import org.junit.jupiter.params.provider.ValueSource;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.PartialFunction;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Set;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\u0005Ud\u0001B\b\u0011\u0001UAQA\u0007\u0001\u0005\u0002mAq!\b\u0001C\u0002\u0013\u0005a\u0004\u0003\u00046\u0001\u0001\u0006Ia\b\u0005\u0006m\u0001!\ta\u000e\u0005\u0006G\u0002!\t\u0001\u001a\u0005\u0006k\u0002!\tA\u001e\u0005\u0006w\u0002!I\u0001 \u0005\b\u0003\u0017\u0001A\u0011AA\u0007\u0011\u001d\t9\u0002\u0001C\u0001\u00033Aq!a\t\u0001\t\u0013\t)cB\u0004\u0002LAA\t!!\u0014\u0007\r=\u0001\u0002\u0012AA(\u0011\u0019QB\u0002\"\u0001\u0002X!11\u000f\u0004C\u0001\u00033\u0012!\u0003\u0015:pIV\u001cWMU3rk\u0016\u001cH\u000fV3ti*\u0011\u0011CE\u0001\u0007g\u0016\u0014h/\u001a:\u000b\u0003M\tQa[1gW\u0006\u001c\u0001a\u0005\u0002\u0001-A\u0011q\u0003G\u0007\u0002!%\u0011\u0011\u0004\u0005\u0002\u0010\u0005\u0006\u001cXMU3rk\u0016\u001cH\u000fV3ti\u00061A(\u001b8jiz\"\u0012\u0001\b\t\u0003/\u0001\tQ\"\\3ue&\u001c7oS3z'\u0016$X#A\u0010\u0011\u0007\u0001:\u0013&D\u0001\"\u0015\t\u00113%A\u0004nkR\f'\r\\3\u000b\u0005\u0011*\u0013AC2pY2,7\r^5p]*\ta%A\u0003tG\u0006d\u0017-\u0003\u0002)C\t\u00191+\u001a;\u0011\u0005)\u001aT\"A\u0016\u000b\u00051j\u0013\u0001B2pe\u0016T!AL\u0018\u0002\u000f5,GO]5dg*\u0011\u0001'M\u0001\u0007s\u0006lW.\u001a:\u000b\u0003I\n1aY8n\u0013\t!4F\u0001\u0006NKR\u0014\u0018n\u0019(b[\u0016\fa\"\\3ue&\u001c7oS3z'\u0016$\b%\u0001\ruKN$8+[7qY\u0016\u0004&o\u001c3vG\u0016\u0014V-];fgR$\"\u0001\u000f\u001f\u0011\u0005eRT\"A\u0013\n\u0005m*#\u0001B+oSRDQ!\u0010\u0003A\u0002y\na!];peVl\u0007CA G\u001d\t\u0001E\t\u0005\u0002BK5\t!I\u0003\u0002D)\u00051AH]8pizJ!!R\u0013\u0002\rA\u0013X\rZ3g\u0013\t9\u0005J\u0001\u0004TiJLgn\u001a\u0006\u0003\u000b\u0016BC\u0001\u0002&Y3B\u00111JV\u0007\u0002\u0019*\u0011QJT\u0001\taJ|g/\u001b3fe*\u0011q\nU\u0001\u0007a\u0006\u0014\u0018-\\:\u000b\u0005E\u0013\u0016a\u00026va&$XM\u001d\u0006\u0003'R\u000bQA[;oSRT\u0011!V\u0001\u0004_J<\u0017BA,M\u0005-1\u0016\r\\;f'>,(oY3\u0002\u000fM$(/\u001b8hg2\u0012!\fX\u0011\u00027\u0006\u0011!p[\u0011\u0002;\u0006)1N]1gi\"\u0012Aa\u0018\t\u0003A\u0006l\u0011AT\u0005\u0003E:\u0013\u0011\u0003U1sC6,G/\u001a:ju\u0016$G+Z:u\u0003}!Xm\u001d;Qe>$WoY3XSRD\u0017J\u001c<bY&$G+[7fgR\fW\u000e\u001d\u000b\u0004q\u0015<\u0007\"\u00024\u0006\u0001\u0004q\u0014AF7fgN\fw-\u001a+j[\u0016\u001cF/Y7q\u0007>tg-[4\t\u000b!,\u0001\u0019A5\u0002\u001fI,7m\u001c:e)&lWm\u001d;b[B\u0004\"!\u000f6\n\u0005-,#\u0001\u0002'p]\u001eDC!B7qcB\u00111J\\\u0005\u0003_2\u0013A\"T3uQ>$7k\\;sG\u0016\fQA^1mk\u0016d\u0013A]\u0011\u0002g\u00069B/[7fgR\fW\u000e]\"p]\u001aLw\r\u0015:pm&$WM\u001d\u0015\u0003\u000b}\u000bq\u0003^3tiB\u0013x\u000eZ;dKR{gj\u001c8SKBd\u0017nY1\u0015\u0005a:\b\"B\u001f\u0007\u0001\u0004q\u0004\u0006\u0002\u0004K1fd#A\u0017/)\u0005\u0019y\u0016!J2sK\u0006$X\rV8qS\u000e\fe\u000e\u001a$j]\u0012\u0004\u0016M\u001d;ji&|gnV5uQ2+\u0017\rZ3s)\ri\u0018q\u0001\t\u0007sy\f\t!!\u0001\n\u0005},#A\u0002+va2,'\u0007E\u0002:\u0003\u0007I1!!\u0002&\u0005\rIe\u000e\u001e\u0005\u0007\u0003\u00139\u0001\u0019\u0001 \u0002\u000bQ|\u0007/[2\u00029Q,7\u000f^\"peJ,\b\u000f\u001e'{iA\u0013x\u000eZ;dKJ+\u0017/^3tiR\u0019\u0001(a\u0004\t\u000buB\u0001\u0019\u0001 )\u000b!Q\u0005,a\u0005-\u0005ic\u0006F\u0001\u0005`\u0003Y!Xm\u001d;['R#\u0005K]8ek\u000e,'+Z9vKN$Hc\u0001\u001d\u0002\u001c!)Q(\u0003a\u0001}!*\u0011B\u0013-\u0002 1\u0012!\f\u0018\u0015\u0003\u0013}\u000b!c]3oIB\u0013x\u000eZ;dKJ+\u0017/^3tiR1\u0011qEA\u001f\u0003\u0003\u0002B!!\u000b\u0002:5\u0011\u00111\u0006\u0006\u0005\u0003[\ty#\u0001\u0005sKF,Xm\u001d;t\u0015\u0011\t\t$a\r\u0002\r\r|W.\\8o\u0015\r\u0019\u0012Q\u0007\u0006\u0004\u0003o!\u0016AB1qC\u000eDW-\u0003\u0003\u0002<\u0005-\"a\u0004)s_\u0012,8-\u001a*fgB|gn]3\t\u000f\u0005}\"\u00021\u0001\u0002\u0002\u0005AA.Z1eKJLE\rC\u0004\u0002D)\u0001\r!!\u0012\u0002\u000fI,\u0017/^3tiB!\u0011\u0011FA$\u0013\u0011\tI%a\u000b\u0003\u001dA\u0013x\u000eZ;dKJ+\u0017/^3ti\u0006\u0011\u0002K]8ek\u000e,'+Z9vKN$H+Z:u!\t9BbE\u0002\r\u0003#\u00022!OA*\u0013\r\t)&\n\u0002\u0007\u0003:L(+\u001a4\u0015\u0005\u00055SCAA.!\u0019\ti&a\u001b\u0002p5\u0011\u0011q\f\u0006\u0005\u0003C\n\u0019'\u0001\u0004tiJ,\u0017-\u001c\u0006\u0005\u0003K\n9'\u0001\u0003vi&d'BAA5\u0003\u0011Q\u0017M^1\n\t\u00055\u0014q\f\u0002\u0007'R\u0014X-Y7\u0011\u0007-\u000b\t(C\u0002\u0002t1\u0013\u0011\"\u0011:hk6,g\u000e^:")
public class ProduceRequestTest
extends BaseRequestTest {
    private final Set<MetricName> metricsKeySet = (Set)CollectionConverters$.MODULE$.asScalaSetConverter(KafkaYammerMetrics.defaultRegistry().allMetrics().keySet()).asScala();

    public static Stream<Arguments> timestampConfigProvider() {
        return ProduceRequestTest$.MODULE$.timestampConfigProvider();
    }

    public Set<MetricName> metricsKeySet() {
        return this.metricsKeySet;
    }

    /*
     * WARNING - void declaration
     */
    @ParameterizedTest
    @ValueSource(strings={"zk", "kraft"})
    public void testSimpleProduceRequest(String quorum) {
        void var4_4;
        void var3_3;
        Tuple2<Object, Object> tuple2 = this.createTopicAndFindPartitionWithLeader("topic");
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        int partition = tuple2._1$mcI$sp();
        int leader = tuple2._2$mcI$sp();
        this.sendAndCheck$1(MemoryRecords.withRecords((Compression)Compression.NONE, (SimpleRecord[])new SimpleRecord[]{new SimpleRecord(System.currentTimeMillis(), "key".getBytes(), "value".getBytes())}), 0L, (int)var3_3, (int)var4_4);
        this.sendAndCheck$1(MemoryRecords.withRecords((Compression)Compression.gzip().build(), (SimpleRecord[])new SimpleRecord[]{new SimpleRecord(System.currentTimeMillis(), "key1".getBytes(), "value1".getBytes()), new SimpleRecord(System.currentTimeMillis(), "key2".getBytes(), "value2".getBytes())}), 1L, (int)var3_3, (int)var4_4);
    }

    @ParameterizedTest
    @MethodSource(value={"timestampConfigProvider"})
    public void testProduceWithInvalidTimestamp(String messageTimeStampConfig, long recordTimestamp) {
        String topic = "topic";
        int partition = 0;
        Properties topicConfig = new Properties();
        topicConfig.setProperty(messageTimeStampConfig, "1000");
        int leader = BoxesRunTime.unboxToInt((Object)TestUtils$.MODULE$.createTopic(this.zkClient(), topic, 1, 1, (Seq<KafkaBroker>)this.servers(), topicConfig).apply((Object)BoxesRunTime.boxToInteger((int)partition)));
        MemoryRecords records = ProduceRequestTest.createRecords$1((byte)2, recordTimestamp, (Compression)Compression.gzip().build());
        TopicPartition topicPartition = new TopicPartition("topic", partition);
        ProduceResponse produceResponse = this.sendProduceRequest(leader, (ProduceRequest)ProduceRequest.forCurrentMagic((ProduceRequestData)new ProduceRequestData().setTopicData(new ProduceRequestData.TopicProduceDataCollection(Collections.singletonList(new ProduceRequestData.TopicProduceData().setName(topicPartition.topic()).setPartitionData(Collections.singletonList(new ProduceRequestData.PartitionProduceData().setIndex(topicPartition.partition()).setRecords((BaseRecords)records)))).iterator())).setAcks((short)-1).setTimeoutMs(3000).setTransactionalId(null)).build());
        Assertions.assertEquals((int)1, (int)produceResponse.data().responses().size());
        ProduceResponseData.TopicProduceResponse topicProduceResponse = (ProduceResponseData.TopicProduceResponse)((IterableLike)CollectionConverters$.MODULE$.collectionAsScalaIterableConverter((Collection)produceResponse.data().responses()).asScala()).head();
        Assertions.assertEquals((int)1, (int)topicProduceResponse.partitionResponses().size());
        ProduceResponseData.PartitionProduceResponse partitionProduceResponse = (ProduceResponseData.PartitionProduceResponse)((IterableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(topicProduceResponse.partitionResponses()).asScala()).head();
        TopicPartition tp = new TopicPartition(topicProduceResponse.name(), partitionProduceResponse.index());
        Assertions.assertEquals((Object)topicPartition, (Object)tp);
        Assertions.assertEquals((Object)Errors.INVALID_TIMESTAMP, (Object)Errors.forCode((short)partitionProduceResponse.errorCode()));
        Assertions.assertEquals((int)3, (int)partitionProduceResponse.recordErrors().size());
        Buffer recordErrors = (Buffer)CollectionConverters$.MODULE$.asScalaBufferConverter(partitionProduceResponse.recordErrors()).asScala();
        recordErrors.indices().foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> Assertions.assertEquals((int)i, (int)((ProduceResponseData.BatchIndexAndErrorMessage)recordErrors.apply(i)).batchIndex()));
        recordErrors.foreach((Function1 & Serializable & scala.Serializable)recordError -> {
            ProduceRequestTest.$anonfun$testProduceWithInvalidTimestamp$2(recordError);
            return BoxedUnit.UNIT;
        });
        Assertions.assertEquals((Object)"One or more records have been rejected due to invalid timestamp", (Object)partitionProduceResponse.errorMessage());
    }

    @ParameterizedTest
    @ValueSource(strings={"zk", "kraft"})
    public void testProduceToNonReplica(String quorum) {
        String topic = "topic";
        int partition = 0;
        int leader = BoxesRunTime.unboxToInt((Object)this.createTopic(topic, this.createTopic$default$2(), this.createTopic$default$3(), this.createTopic$default$4(), this.createTopic$default$5(), this.createTopic$default$6()).apply((Object)BoxesRunTime.boxToInteger((int)partition)));
        Option nonReplicaOpt = this.brokers().find((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)ProduceRequestTest.$anonfun$testProduceToNonReplica$1(leader, x$2)));
        Assertions.assertTrue((boolean)nonReplicaOpt.isDefined());
        int nonReplicaId = ((KafkaBroker)nonReplicaOpt.get()).config().brokerId();
        MemoryRecords records = MemoryRecords.withRecords((Compression)Compression.NONE, (SimpleRecord[])new SimpleRecord[]{new SimpleRecord("key".getBytes(), "value".getBytes())});
        TopicPartition topicPartition = new TopicPartition("topic", partition);
        ProduceRequest produceRequest = (ProduceRequest)ProduceRequest.forCurrentMagic((ProduceRequestData)new ProduceRequestData().setTopicData(new ProduceRequestData.TopicProduceDataCollection(Collections.singletonList(new ProduceRequestData.TopicProduceData().setName(topicPartition.topic()).setPartitionData(Collections.singletonList(new ProduceRequestData.PartitionProduceData().setIndex(topicPartition.partition()).setRecords((BaseRecords)records)))).iterator())).setAcks((short)-1).setTimeoutMs(3000).setTransactionalId(null)).build();
        ProduceResponse produceResponse = this.sendProduceRequest(nonReplicaId, produceRequest);
        Assertions.assertEquals((int)1, (int)produceResponse.data().responses().size());
        ProduceResponseData.TopicProduceResponse topicProduceResponse = (ProduceResponseData.TopicProduceResponse)((IterableLike)CollectionConverters$.MODULE$.collectionAsScalaIterableConverter((Collection)produceResponse.data().responses()).asScala()).head();
        Assertions.assertEquals((int)1, (int)topicProduceResponse.partitionResponses().size());
        ProduceResponseData.PartitionProduceResponse partitionProduceResponse = (ProduceResponseData.PartitionProduceResponse)((IterableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(topicProduceResponse.partitionResponses()).asScala()).head();
        Assertions.assertEquals((Object)Errors.NOT_LEADER_OR_FOLLOWER, (Object)Errors.forCode((short)partitionProduceResponse.errorCode()));
    }

    private Tuple2<Object, Object> createTopicAndFindPartitionWithLeader(String topic) {
        return (Tuple2)this.createTopic(topic, 3, 2, this.createTopic$default$4(), this.createTopic$default$5(), this.createTopic$default$6()).collectFirst((PartialFunction)new scala.Serializable(null){
            public static final long serialVersionUID = 0L;

            public final <A1 extends Tuple2<Object, Object>, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                if (x1 != null) {
                    int partition = x1._1$mcI$sp();
                    int leader = x1._2$mcI$sp();
                    if (leader != -1) {
                        return (B1)new Tuple2.mcII.sp(partition, leader);
                    }
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(Tuple2<Object, Object> x1) {
                return x1 != null && x1._2$mcI$sp() != -1;
            }
        }).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new AssertionError((Object)new StringBuilder(28).append("No leader elected for topic ").append(topic).toString());
        });
    }

    /*
     * WARNING - void declaration
     */
    @ParameterizedTest
    @ValueSource(strings={"zk", "kraft"})
    public void testCorruptLz4ProduceRequest(String quorum) {
        void var4_4;
        void var3_3;
        Tuple2<Object, Object> tuple2 = this.createTopicAndFindPartitionWithLeader("topic");
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        int partition = tuple2._1$mcI$sp();
        int leader = tuple2._2$mcI$sp();
        int timestamp = 1000000;
        MemoryRecords memoryRecords = MemoryRecords.withRecords((Compression)Compression.lz4().build(), (SimpleRecord[])new SimpleRecord[]{new SimpleRecord((long)timestamp, "key".getBytes(), "value".getBytes())});
        int lz4ChecksumOffset = 6;
        memoryRecords.buffer().array()[61 + lz4ChecksumOffset] = 0;
        TopicPartition topicPartition = new TopicPartition("topic", (int)var3_3);
        ProduceResponse produceResponse = this.sendProduceRequest((int)var4_4, (ProduceRequest)ProduceRequest.forCurrentMagic((ProduceRequestData)new ProduceRequestData().setTopicData(new ProduceRequestData.TopicProduceDataCollection(Collections.singletonList(new ProduceRequestData.TopicProduceData().setName(topicPartition.topic()).setPartitionData(Collections.singletonList(new ProduceRequestData.PartitionProduceData().setIndex(topicPartition.partition()).setRecords((BaseRecords)memoryRecords)))).iterator())).setAcks((short)-1).setTimeoutMs(3000).setTransactionalId(null)).build());
        Assertions.assertEquals((int)1, (int)produceResponse.data().responses().size());
        ProduceResponseData.TopicProduceResponse topicProduceResponse = (ProduceResponseData.TopicProduceResponse)((IterableLike)CollectionConverters$.MODULE$.collectionAsScalaIterableConverter((Collection)produceResponse.data().responses()).asScala()).head();
        Assertions.assertEquals((int)1, (int)topicProduceResponse.partitionResponses().size());
        ProduceResponseData.PartitionProduceResponse partitionProduceResponse = (ProduceResponseData.PartitionProduceResponse)((IterableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(topicProduceResponse.partitionResponses()).asScala()).head();
        TopicPartition tp = new TopicPartition(topicProduceResponse.name(), partitionProduceResponse.index());
        Assertions.assertEquals((Object)topicPartition, (Object)tp);
        Assertions.assertEquals((Object)Errors.CORRUPT_MESSAGE, (Object)Errors.forCode((short)partitionProduceResponse.errorCode()));
        Assertions.assertEquals((long)-1L, (long)partitionProduceResponse.baseOffset());
        Assertions.assertEquals((long)-1L, (long)partitionProduceResponse.logAppendTimeMs());
        Assertions.assertEquals((int)this.metricsKeySet().count((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)ProduceRequestTest.$anonfun$testCorruptLz4ProduceRequest$1(x$4))), (int)1);
        Assertions.assertTrue((TestUtils$.MODULE$.meterCount(String.valueOf(BrokerTopicStats$.MODULE$.InvalidMessageCrcRecordsPerSec())) > 0L ? 1 : 0) != 0);
    }

    @ParameterizedTest
    @ValueSource(strings={"zk", "kraft"})
    public void testZSTDProduceRequest(String quorum) {
        String topic = "topic";
        int partition = 0;
        Properties topicConfig = new Properties();
        topicConfig.setProperty("compression.type", BrokerCompressionType.ZSTD.name);
        int x$3 = this.createTopic$default$2();
        int x$4 = this.createTopic$default$3();
        ListenerName x$5 = this.createTopic$default$5();
        Properties x$6 = this.createTopic$default$6();
        int leader = BoxesRunTime.unboxToInt((Object)this.createTopic(topic, x$3, x$4, topicConfig, x$5, x$6).apply((Object)BoxesRunTime.boxToInteger((int)partition)));
        MemoryRecords memoryRecords = MemoryRecords.withRecords((Compression)Compression.zstd().build(), (SimpleRecord[])new SimpleRecord[]{new SimpleRecord(System.currentTimeMillis(), "key".getBytes(), "value".getBytes())});
        TopicPartition topicPartition = new TopicPartition("topic", partition);
        ProduceRequestData partitionRecords = new ProduceRequestData().setTopicData(new ProduceRequestData.TopicProduceDataCollection(Collections.singletonList(new ProduceRequestData.TopicProduceData().setName("topic").setPartitionData(Collections.singletonList(new ProduceRequestData.PartitionProduceData().setIndex(partition).setRecords((BaseRecords)memoryRecords)))).iterator())).setAcks((short)-1).setTimeoutMs(3000).setTransactionalId(null);
        ProduceResponse produceResponse1 = this.sendProduceRequest(leader, (ProduceRequest)new ProduceRequest.Builder(7, 7, partitionRecords).build());
        ProduceResponseData.TopicProduceResponse topicProduceResponse1 = (ProduceResponseData.TopicProduceResponse)((IterableLike)CollectionConverters$.MODULE$.collectionAsScalaIterableConverter((Collection)produceResponse1.data().responses()).asScala()).head();
        ProduceResponseData.PartitionProduceResponse partitionProduceResponse1 = (ProduceResponseData.PartitionProduceResponse)((IterableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(topicProduceResponse1.partitionResponses()).asScala()).head();
        TopicPartition tp1 = new TopicPartition(topicProduceResponse1.name(), partitionProduceResponse1.index());
        Assertions.assertEquals((Object)topicPartition, (Object)tp1);
        Assertions.assertEquals((Object)Errors.NONE, (Object)Errors.forCode((short)partitionProduceResponse1.errorCode()));
        Assertions.assertEquals((long)0L, (long)partitionProduceResponse1.baseOffset());
        Assertions.assertEquals((long)-1L, (long)partitionProduceResponse1.logAppendTimeMs());
        ProduceResponse produceResponse2 = this.sendProduceRequest(leader, new ProduceRequest.Builder(3, 3, partitionRecords).buildUnsafe((short)3));
        ProduceResponseData.TopicProduceResponse topicProduceResponse2 = (ProduceResponseData.TopicProduceResponse)((IterableLike)CollectionConverters$.MODULE$.collectionAsScalaIterableConverter((Collection)produceResponse2.data().responses()).asScala()).head();
        ProduceResponseData.PartitionProduceResponse partitionProduceResponse2 = (ProduceResponseData.PartitionProduceResponse)((IterableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(topicProduceResponse2.partitionResponses()).asScala()).head();
        TopicPartition tp2 = new TopicPartition(topicProduceResponse2.name(), partitionProduceResponse2.index());
        Assertions.assertEquals((Object)topicPartition, (Object)tp2);
        Assertions.assertEquals((Object)Errors.UNSUPPORTED_COMPRESSION_TYPE, (Object)Errors.forCode((short)partitionProduceResponse2.errorCode()));
    }

    private ProduceResponse sendProduceRequest(int leaderId, ProduceRequest request) {
        return (ProduceResponse)this.connectAndReceive((AbstractRequest)request, this.brokerSocketServer(leaderId), this.connectAndReceive$default$3(), ClassTag$.MODULE$.apply(ProduceResponse.class));
    }

    private final void sendAndCheck$1(MemoryRecords memoryRecords, long expectedOffset, int partition$1, int leader$1) {
        TopicPartition topicPartition = new TopicPartition("topic", partition$1);
        ProduceResponse produceResponse = this.sendProduceRequest(leader$1, (ProduceRequest)ProduceRequest.forCurrentMagic((ProduceRequestData)new ProduceRequestData().setTopicData(new ProduceRequestData.TopicProduceDataCollection(Collections.singletonList(new ProduceRequestData.TopicProduceData().setName(topicPartition.topic()).setPartitionData(Collections.singletonList(new ProduceRequestData.PartitionProduceData().setIndex(topicPartition.partition()).setRecords((BaseRecords)memoryRecords)))).iterator())).setAcks((short)-1).setTimeoutMs(3000).setTransactionalId(null)).build());
        Assertions.assertEquals((int)1, (int)produceResponse.data().responses().size());
        ProduceResponseData.TopicProduceResponse topicProduceResponse = (ProduceResponseData.TopicProduceResponse)((IterableLike)CollectionConverters$.MODULE$.collectionAsScalaIterableConverter((Collection)produceResponse.data().responses()).asScala()).head();
        Assertions.assertEquals((int)1, (int)topicProduceResponse.partitionResponses().size());
        ProduceResponseData.PartitionProduceResponse partitionProduceResponse = (ProduceResponseData.PartitionProduceResponse)((IterableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(topicProduceResponse.partitionResponses()).asScala()).head();
        TopicPartition tp = new TopicPartition(topicProduceResponse.name(), partitionProduceResponse.index());
        Assertions.assertEquals((Object)topicPartition, (Object)tp);
        Assertions.assertEquals((Object)Errors.NONE, (Object)Errors.forCode((short)partitionProduceResponse.errorCode()));
        Assertions.assertEquals((long)expectedOffset, (long)partitionProduceResponse.baseOffset());
        Assertions.assertEquals((long)-1L, (long)partitionProduceResponse.logAppendTimeMs());
        Assertions.assertTrue((boolean)partitionProduceResponse.recordErrors().isEmpty());
    }

    private static final MemoryRecords createRecords$1(byte magicValue, long timestamp, Compression codec) {
        MemoryRecordsBuilder builder = MemoryRecords.builder((ByteBuffer)ByteBuffer.allocate(512), (byte)magicValue, (Compression)codec, (TimestampType)TimestampType.CREATE_TIME, (long)0L);
        builder.appendWithOffset(0L, timestamp, null, "hello".getBytes());
        builder.appendWithOffset(1L, timestamp, null, "there".getBytes());
        builder.appendWithOffset(2L, timestamp, null, "beautiful".getBytes());
        return builder.build();
    }

    public static final /* synthetic */ void $anonfun$testProduceWithInvalidTimestamp$2(ProduceResponseData.BatchIndexAndErrorMessage recordError) {
        Assertions.assertNotNull((Object)recordError.batchIndexErrorMessage());
    }

    public static final /* synthetic */ boolean $anonfun$testProduceToNonReplica$1(int leader$2, KafkaBroker x$2) {
        return x$2.config().brokerId() != leader$2;
    }

    public static final /* synthetic */ boolean $anonfun$testCorruptLz4ProduceRequest$1(MetricName x$4) {
        return x$4.getMBeanName().endsWith(String.valueOf(BrokerTopicStats$.MODULE$.InvalidMessageCrcRecordsPerSec()));
    }
}

