/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import com.typesafe.scalalogging.Logger;
import java.io.File;
import java.io.Serializable;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.Properties;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import javax.security.auth.login.Configuration;
import kafka.server.ControllerServer;
import kafka.server.FaultHandlerFactory;
import kafka.server.KRaftQuorumImplementation;
import kafka.server.KafkaBroker;
import kafka.server.KafkaConfig;
import kafka.server.KafkaRaftServer$;
import kafka.server.QuorumImplementation;
import kafka.server.QuorumTestHarness$;
import kafka.server.QuorumTestHarnessFaultHandlerFactory;
import kafka.server.SharedServer;
import kafka.server.ZooKeeperQuorumImplementation;
import kafka.utils.CoreUtils$;
import kafka.utils.Logging;
import kafka.utils.TestInfoUtils$;
import kafka.utils.TestUtils$;
import kafka.zk.AdminZkClient;
import kafka.zk.AdminZkClient$;
import kafka.zk.EmbeddedZookeeper;
import kafka.zk.KafkaZkClient;
import kafka.zk.KafkaZkClient$;
import org.apache.kafka.clients.consumer.GroupProtocol;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.metadata.FeatureLevelRecord;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.common.security.JaasUtils;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.utils.Exit;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.metadata.bootstrap.BootstrapMetadata;
import org.apache.kafka.metadata.properties.MetaProperties;
import org.apache.kafka.metadata.properties.MetaPropertiesEnsemble;
import org.apache.kafka.metadata.properties.MetaPropertiesVersion;
import org.apache.kafka.server.common.ApiMessageAndVersion;
import org.apache.kafka.server.common.MetadataVersion;
import org.apache.kafka.server.fault.FaultHandler;
import org.apache.kafka.server.fault.MockFaultHandler;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZooKeeper;
import org.apache.zookeeper.client.ZKClientConfig;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.TestInfo;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.compat.java8.OptionConverters;
import scala.compat.java8.OptionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.java8.JFunction0;

@Tag(value="integration")
@ScalaSignature(bytes="\u0006\u0001\tMh!\u0002 @\u0003\u0003!\u0005\"B)\u0001\t\u0003\u0011\u0006bB+\u0001\u0005\u0004%\tA\u0016\u0005\u00075\u0002\u0001\u000b\u0011B,\t\u000fm\u0003!\u0019!C\u0001-\"1A\f\u0001Q\u0001\n]Cq!\u0018\u0001C\u0002\u0013\u0005a\u000b\u0003\u0004_\u0001\u0001\u0006Ia\u0016\u0005\u0006?\u0002!\t\u0002\u0019\u0005\bO\u0002\u0011\r\u0011\"\u0005i\u0011\u0019A\b\u0001)A\u0005S\")\u0011\u0010\u0001C\tu\"9\u00111\u0003\u0001\u0005\u0012\u0005U\u0001bCA\u0012\u0001\u0001\u0007\t\u0019!C\u0005\u0003KA1\"a\u000f\u0001\u0001\u0004\u0005\r\u0011\"\u0003\u0002>!Y\u0011\u0011\n\u0001A\u0002\u0003\u0005\u000b\u0015BA\u0014\u0011-\tY\u0005\u0001a\u0001\u0002\u0004%\t\"!\u0014\t\u0017\u0005U\u0003\u00011AA\u0002\u0013E\u0011q\u000b\u0005\f\u00037\u0002\u0001\u0019!A!B\u0013\ty\u0005C\u0005\u0002^\u0001\u0011\r\u0011\"\u0001\u0002`!A\u00111\u000f\u0001!\u0002\u0013\t\t\u0007C\u0004\u0002v\u0001!\t!a\u001e\t\u000f\u0005e\u0004\u0001\"\u0001\u0002x!9\u00111\u0010\u0001\u0005\u0002\u0005]\u0004bBA?\u0001\u0011\u0005\u0011q\u0010\u0005\b\u0003+\u0003A\u0011AAL\u0011\u001d\tI\n\u0001C\u0001\u0003/Cq!a'\u0001\t\u0013\ti\nC\u0004\u0002&\u0002!I!a*\t\u000f\u0005=\u0006\u0001\"\u0001\u00022\"9\u0011q\u0018\u0001\u0005\u0002\u0005\u0005\u0007bBAe\u0001\u0011\u0005\u0011\u0011\u0019\u0005\b\u0003\u0017\u0004A\u0011AAg\u0011\u0019\t)\u000e\u0001C\u0001-\"9\u0011q\u001b\u0001\u0005\u0002\u0005e\u0007bBAy\u0001\u0011\u0005\u0011\u0011\u001c\u0005\b\u0003g\u0004A\u0011AA{\u0011\u001d\ti\u0010\u0001C\u0001\u0003\u007fD\u0011Ba\u0001\u0001\u0005\u0004%\tA!\u0002\t\u0011\t5\u0001\u0001)A\u0005\u0005\u000fA\u0011Ba\u0004\u0001\u0005\u0004%\tA!\u0005\t\u0011\t}\u0001\u0001)A\u0005\u0005'AqA!\t\u0001\t\u0003\u0011\u0019\u0003C\u0004\u00030\u0001!\tA!\r\t\u0013\tm\u0003!%A\u0005\u0002\tu\u0003\"\u0003B:\u0001E\u0005I\u0011\u0001B;\u0011%\u0011I\bAI\u0001\n\u0003\u0011Y\bC\u0004\u0003\u0000\u0001!\t!a&\t\u000f\t\u0005\u0005\u0001\"\u0001\u0002\u0018\"9!1\u0011\u0001\u0005\u0002\t\u0015\u0005b\u0002BH\u0001\u0011%!\u0011\u0013\u0005\b\u0005\u001f\u0003A\u0011\u0003BK\u0011\u001d\u0011Y\n\u0001C\u0005\u0003;CqA!(\u0001\t\u0003\t9\nC\u0004\u0003(\u0002!\tA!+\b\u000f\t\u001dw\b#\u0001\u0003J\u001a1ah\u0010E\u0001\u0005\u0017Da!\u0015\u001d\u0005\u0002\t5\u0007\"\u0003Bhq\t\u0007I\u0011\u0001Bi\u0011!\u0011i\u000e\u000fQ\u0001\n\tM\u0007b\u0002Bpq\u0011\u0005\u0011q\u0013\u0005\b\u0005SDD\u0011AAL\u0005E\tVo\u001c:v[R+7\u000f\u001e%be:,7o\u001d\u0006\u0003\u0001\u0006\u000baa]3sm\u0016\u0014(\"\u0001\"\u0002\u000b-\fgm[1\u0004\u0001M\u0019\u0001!R&\u0011\u0005\u0019KU\"A$\u000b\u0003!\u000bQa]2bY\u0006L!AS$\u0003\r\u0005s\u0017PU3g!\tau*D\u0001N\u0015\tq\u0015)A\u0003vi&d7/\u0003\u0002Q\u001b\n9Aj\\4hS:<\u0017A\u0002\u001fj]&$h\bF\u0001T!\t!\u0006!D\u0001@\u0003MQ8nQ8o]\u0016\u001cG/[8o)&lWm\\;u+\u00059\u0006C\u0001$Y\u0013\tIvIA\u0002J]R\fAC_6D_:tWm\u0019;j_:$\u0016.\\3pkR\u0004\u0013\u0001\u0005>l'\u0016\u001c8/[8o)&lWm\\;u\u0003EQ8nU3tg&|g\u000eV5nK>,H\u000fI\u0001\u0016u.l\u0015\r_%o\r2Lw\r\u001b;SKF,Xm\u001d;t\u0003YQ8.T1y\u0013:4E.[4iiJ+\u0017/^3tiN\u0004\u0013!\u0004>l\u0003\u000ed7/\u00128bE2,G-F\u0001b!\r1%\rZ\u0005\u0003G\u001e\u0013aa\u00149uS>t\u0007C\u0001$f\u0013\t1wIA\u0004C_>dW-\u00198\u0002E\r|g\u000e\u001e:pY2,'\u000fT5ti\u0016tWM]*fGV\u0014\u0018\u000e^=Qe>$xnY8m+\u0005I\u0007C\u00016w\u001b\u0005Y'B\u00017n\u0003\u0011\tW\u000f\u001e5\u000b\u00059|\u0017\u0001C:fGV\u0014\u0018\u000e^=\u000b\u0005A\f\u0018AB2p[6|gN\u0003\u0002Ce*\u00111\u000f^\u0001\u0007CB\f7\r[3\u000b\u0003U\f1a\u001c:h\u0013\t98N\u0001\tTK\u000e,(/\u001b;z!J|Go\\2pY\u0006\u00193m\u001c8ue>dG.\u001a:MSN$XM\\3s'\u0016\u001cWO]5usB\u0013x\u000e^8d_2\u0004\u0013AF6sC\u001a$8i\u001c8ue>dG.\u001a:D_:4\u0017nZ:\u0015\u0003m\u0004B\u0001`@\u0002\u00045\tQP\u0003\u0002\u007f\u000f\u0006Q1m\u001c7mK\u000e$\u0018n\u001c8\n\u0007\u0005\u0005QPA\u0002TKF\u0004B!!\u0002\u0002\u00105\u0011\u0011q\u0001\u0006\u0005\u0003\u0013\tY!\u0001\u0003vi&d'BAA\u0007\u0003\u0011Q\u0017M^1\n\t\u0005E\u0011q\u0001\u0002\u000b!J|\u0007/\u001a:uS\u0016\u001c\u0018aD7fi\u0006$\u0017\r^1WKJ\u001c\u0018n\u001c8\u0016\u0005\u0005]\u0001\u0003BA\r\u0003?i!!a\u0007\u000b\u0007A\fiB\u0003\u0002Ac&!\u0011\u0011EA\u000e\u0005=iU\r^1eCR\fg+\u001a:tS>t\u0017\u0001\u0003;fgRLeNZ8\u0016\u0005\u0005\u001d\u0002\u0003BA\u0015\u0003oi!!a\u000b\u000b\t\u00055\u0012qF\u0001\u0004CBL'\u0002BA\u0019\u0003g\tqA[;qSR,'OC\u0002\u00026Q\fQA[;oSRLA!!\u000f\u0002,\tAA+Z:u\u0013:4w.\u0001\u0007uKN$\u0018J\u001c4p?\u0012*\u0017\u000f\u0006\u0003\u0002@\u0005\u0015\u0003c\u0001$\u0002B%\u0019\u00111I$\u0003\tUs\u0017\u000e\u001e\u0005\n\u0003\u000fr\u0011\u0011!a\u0001\u0003O\t1\u0001\u001f\u00132\u0003%!Xm\u001d;J]\u001a|\u0007%\u0001\bj[BdW-\\3oi\u0006$\u0018n\u001c8\u0016\u0005\u0005=\u0003c\u0001+\u0002R%\u0019\u00111K \u0003)E+xN];n\u00136\u0004H.Z7f]R\fG/[8o\u0003IIW\u000e\u001d7f[\u0016tG/\u0019;j_:|F%Z9\u0015\t\u0005}\u0012\u0011\f\u0005\n\u0003\u000f\n\u0012\u0011!a\u0001\u0003\u001f\nq\"[7qY\u0016lWM\u001c;bi&|g\u000eI\u0001\u0011E>|Go\u001d;sCB\u0014VmY8sIN,\"!!\u0019\u0011\r\u0005\r\u0014\u0011NA7\u001b\t\t)GC\u0002\u0002hu\fq!\\;uC\ndW-\u0003\u0003\u0002l\u0005\u0015$A\u0003'jgR\u0014UO\u001a4feB!\u0011\u0011DA8\u0013\u0011\t\t(a\u0007\u0003)\u0005\u0003\u0018.T3tg\u0006<W-\u00118e-\u0016\u00148/[8o\u0003E\u0011wn\u001c;tiJ\f\u0007OU3d_J$7\u000fI\u0001\fSN\\%+\u00194u)\u0016\u001cH\u000fF\u0001e\u0003EI7OW6NS\u001e\u0014\u0018\r^5p]R+7\u000f^\u0001\u001dSNtUm^$s_V\u00048i\\8sI&t\u0017\r^8s\u000b:\f'\r\\3e\u0003mi\u0017-\u001f2f\u000fJ|W\u000f\u001d)s_R|7m\u001c7Ta\u0016\u001c\u0017NZ5fIR!\u0011\u0011QAJ!\u00111%-a!\u0011\t\u0005\u0015\u0015qR\u0007\u0003\u0003\u000fSA!!#\u0002\f\u0006A1m\u001c8tk6,'OC\u0002\u0002\u000eF\fqa\u00197jK:$8/\u0003\u0003\u0002\u0012\u0006\u001d%!D$s_V\u0004\bK]8u_\u000e|G\u000eC\u0004\u0002$a\u0001\r!a\n\u0002\u001b\rDWmY6Jgj[E+Z:u)\t\ty$\u0001\tdQ\u0016\u001c7.S:L%\u00064G\u000fV3ti\u0006!\u0011m\u001d.l)\t\ty\nE\u0002U\u0003CK1!a)@\u0005uQvn\\&fKB,'/U;peVl\u0017*\u001c9mK6,g\u000e^1uS>t\u0017aB1t\u0017J\u000bg\r\u001e\u000b\u0003\u0003S\u00032\u0001VAV\u0013\r\tik\u0010\u0002\u001a\u0017J\u000bg\r^)v_J,X.S7qY\u0016lWM\u001c;bi&|g.A\u0005{_>\\W-\u001a9feV\u0011\u00111\u0017\t\u0005\u0003k\u000bY,\u0004\u0002\u00028*\u0019\u0011\u0011X!\u0002\u0005i\\\u0017\u0002BA_\u0003o\u0013\u0011#R7cK\u0012$W\r\u001a.p_.,W\r]3s\u0003!Q8n\u00117jK:$XCAAb!\u0011\t),!2\n\t\u0005\u001d\u0017q\u0017\u0002\u000e\u0017\u000647.\u0019.l\u00072LWM\u001c;\u0002\u001di\\7\t\\5f]R|%OT;mY\u0006i\u0011\rZ7j]j[7\t\\5f]R,\"!a4\u0011\t\u0005U\u0016\u0011[\u0005\u0005\u0003'\f9LA\u0007BI6LgNW6DY&,g\u000e^\u0001\u0007u.\u0004vN\u001d;\u0002\u0013i\\7i\u001c8oK\u000e$XCAAn!\u0011\ti.a;\u000f\t\u0005}\u0017q\u001d\t\u0004\u0003C<UBAAr\u0015\r\t)oQ\u0001\u0007yI|w\u000e\u001e \n\u0007\u0005%x)\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0003[\fyO\u0001\u0004TiJLgn\u001a\u0006\u0004\u0003S<\u0015a\u0004>l\u0007>tg.Z2u\u001fJtU\u000f\u001c7\u0002!\r|g\u000e\u001e:pY2,'oU3sm\u0016\u0014XCAA|!\r!\u0016\u0011`\u0005\u0004\u0003w|$\u0001E\"p]R\u0014x\u000e\u001c7feN+'O^3s\u0003E\u0019wN\u001c;s_2dWM]*feZ,'o]\u000b\u0003\u0005\u0003\u0001B\u0001`@\u0002x\u0006\u0019b-Y;mi\"\u000bg\u000e\u001a7fe\u001a\u000b7\r^8ssV\u0011!q\u0001\t\u0004)\n%\u0011b\u0001B\u0006\u007f\t!\u0013+^8sk6$Vm\u001d;ICJtWm]:GCVdG\u000fS1oI2,'OR1di>\u0014\u00180\u0001\u000bgCVdG\u000fS1oI2,'OR1di>\u0014\u0018\u0010I\u0001\rM\u0006,H\u000e\u001e%b]\u0012dWM]\u000b\u0003\u0005'\u0001BA!\u0006\u0003\u001c5\u0011!q\u0003\u0006\u0005\u00053\ti\"A\u0003gCVdG/\u0003\u0003\u0003\u001e\t]!\u0001E'pG.4\u0015-\u001e7u\u0011\u0006tG\r\\3s\u000351\u0017-\u001e7u\u0011\u0006tG\r\\3sA\u0005)1/\u001a;VaR!\u0011q\bB\u0013\u0011\u001d\t\u0019C\u000ba\u0001\u0003OA3A\u000bB\u0015!\u0011\tICa\u000b\n\t\t5\u00121\u0006\u0002\u000b\u0005\u00164wN]3FC\u000eD\u0017\u0001D2sK\u0006$XM\u0011:pW\u0016\u0014HC\u0003B\u001a\u0005s\u0011\u0019E!\u0015\u0003VA\u0019AK!\u000e\n\u0007\t]rHA\u0006LC\u001a\\\u0017M\u0011:pW\u0016\u0014\bb\u0002B\u001eW\u0001\u0007!QH\u0001\u0007G>tg-[4\u0011\u0007Q\u0013y$C\u0002\u0003B}\u00121bS1gW\u0006\u001cuN\u001c4jO\"I!QI\u0016\u0011\u0002\u0003\u0007!qI\u0001\u0005i&lW\r\u0005\u0003\u0003J\t5SB\u0001B&\u0015\tqu.\u0003\u0003\u0003P\t-#\u0001\u0002+j[\u0016D\u0001Ba\u0015,!\u0003\u0005\r\u0001Z\u0001\bgR\f'\u000f^;q\u0011%\u00119f\u000bI\u0001\u0002\u0004\u0011I&\u0001\tuQJ,\u0017\r\u001a(b[\u0016\u0004&/\u001a4jqB!aIYAn\u0003Y\u0019'/Z1uK\n\u0013xn[3sI\u0011,g-Y;mi\u0012\u0012TC\u0001B0U\u0011\u00119E!\u0019,\u0005\t\r\u0004\u0003\u0002B3\u0005_j!Aa\u001a\u000b\t\t%$1N\u0001\nk:\u001c\u0007.Z2lK\u0012T1A!\u001cH\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0005c\u00129GA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\fac\u0019:fCR,'I]8lKJ$C-\u001a4bk2$HeM\u000b\u0003\u0005oR3\u0001\u001aB1\u0003Y\u0019'/Z1uK\n\u0013xn[3sI\u0011,g-Y;mi\u0012\"TC\u0001B?U\u0011\u0011IF!\u0019\u0002#MDW\u000f\u001e3po:Tvn\\&fKB,'/A\ftQV$Hm\\<o\u0017J\u000bg\r^\"p]R\u0014x\u000e\u001c7fe\u00069r\u000e\u001d;j_:\fG.T3uC\u0012\fG/\u0019*fG>\u0014Hm]\u000b\u0003\u0005\u000f\u0003BA\u00122\u0003\nB1\u00111\rBF\u0003[JAA!$\u0002f\tY\u0011I\u001d:bs\n+hMZ3s\u00039qWm^&SC\u001a$\u0018+^8sk6$B!!+\u0003\u0014\"9\u00111\u0005\u001aA\u0002\u0005\u001dB\u0003BAU\u0005/CqA!'4\u0001\u0004\t\u0019!A\bpm\u0016\u0014(/\u001b3j]\u001e\u0004&o\u001c9t\u0003IqWm\u001e.p_.+W\r]3s#V|'/^7\u0002\u0011Q,\u0017M\u001d#po:D3!\u000eBQ!\u0011\tICa)\n\t\t\u0015\u00161\u0006\u0002\n\u0003\u001a$XM]#bG\"\f1f\u0019:fCR,'l\\8LK\u0016\u0004XM]\"mS\u0016tG\u000fV8Ue&<w-\u001a:TKN\u001c\u0018n\u001c8FqBL'/\u001f\u000b\u0005\u0005W\u0013)\f\u0005\u0003\u0003.\nEVB\u0001BX\u0015\r\tyK]\u0005\u0005\u0005g\u0013yKA\u0005[_>\\U-\u001a9fe\"9!q\u0017\u001cA\u0002\t-\u0016!\u0003>p_.+W\r]3sQ\u001d\u0001!1\u0018Ba\u0005\u0007\u0004B!!\u000b\u0003>&!!qXA\u0016\u0005\r!\u0016mZ\u0001\u0006m\u0006dW/Z\u0011\u0003\u0005\u000b\f1\"\u001b8uK\u001e\u0014\u0018\r^5p]\u0006\t\u0012+^8sk6$Vm\u001d;ICJtWm]:\u0011\u0005QC4C\u0001\u001dF)\t\u0011I-A\r[W\u000ec\u0017.\u001a8u\u000bZ,g\u000e\u001e+ie\u0016\fGmU;gM&DXC\u0001Bj!\u0011\u0011)Na7\u000e\u0005\t]'\u0002\u0002Bm\u0003\u0017\tA\u0001\\1oO&!\u0011Q\u001eBl\u0003iQ6n\u00117jK:$XI^3oiRC'/Z1e'V4g-\u001b=!\u0003)\u0019X\r^+q\u00072\f7o\u001d\u0015\u0004y\t\r\b\u0003BA\u0015\u0005KLAAa:\u0002,\tI!)\u001a4pe\u0016\fE\u000e\\\u0001\u000ei\u0016\f'\u000fR8x]\u000ec\u0017m]:)\u0007u\u0012i\u000f\u0005\u0003\u0002*\t=\u0018\u0002\u0002By\u0003W\u0011\u0001\"\u00114uKJ\fE\u000e\u001c")
public abstract class QuorumTestHarness
implements Logging {
    private final int zkConnectionTimeout;
    private final int zkSessionTimeout;
    private final int zkMaxInFlightRequests;
    private final SecurityProtocol controllerListenerSecurityProtocol;
    private TestInfo testInfo;
    private QuorumImplementation implementation;
    private final ListBuffer<ApiMessageAndVersion> bootstrapRecords;
    private final QuorumTestHarnessFaultHandlerFactory faultHandlerFactory;
    private final MockFaultHandler faultHandler;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    @AfterAll
    public static void tearDownClass() {
        QuorumTestHarness$.MODULE$.tearDownClass();
    }

    @BeforeAll
    public static void setUpClass() {
        QuorumTestHarness$.MODULE$.setUpClass();
    }

    public static String ZkClientEventThreadSuffix() {
        return QuorumTestHarness$.MODULE$.ZkClientEventThreadSuffix();
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$((Logging)this, (String)msg);
    }

    public void trace(Function0<String> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$((Logging)this, msg, e);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void debug(Function0<String> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$((Logging)this, msg, e);
    }

    public void info(Function0<String> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$((Logging)this, msg, e);
    }

    public void warn(Function0<String> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$((Logging)this, msg, e);
    }

    public void error(Function0<String> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$((Logging)this, msg, e);
    }

    public void fatal(Function0<String> msg) {
        Logging.fatal$((Logging)this, msg);
    }

    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$((Logging)this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$((Logging)this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    public String logIdent() {
        return this.logIdent;
    }

    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public int zkConnectionTimeout() {
        return this.zkConnectionTimeout;
    }

    public int zkSessionTimeout() {
        return this.zkSessionTimeout;
    }

    public int zkMaxInFlightRequests() {
        return this.zkMaxInFlightRequests;
    }

    public Option<Object> zkAclsEnabled() {
        return None$.MODULE$;
    }

    public SecurityProtocol controllerListenerSecurityProtocol() {
        return this.controllerListenerSecurityProtocol;
    }

    public Seq<Properties> kraftControllerConfigs() {
        return new .colon.colon((Object)new Properties(), (List)Nil$.MODULE$);
    }

    public MetadataVersion metadataVersion() {
        return MetadataVersion.latestTesting();
    }

    private TestInfo testInfo() {
        return this.testInfo;
    }

    private void testInfo_$eq(TestInfo x$1) {
        this.testInfo = x$1;
    }

    public QuorumImplementation implementation() {
        return this.implementation;
    }

    public void implementation_$eq(QuorumImplementation x$1) {
        this.implementation = x$1;
    }

    public ListBuffer<ApiMessageAndVersion> bootstrapRecords() {
        return this.bootstrapRecords;
    }

    public boolean isKRaftTest() {
        return TestInfoUtils$.MODULE$.isKRaft(this.testInfo());
    }

    public boolean isZkMigrationTest() {
        return TestInfoUtils$.MODULE$.isZkMigrationTest(this.testInfo());
    }

    public boolean isNewGroupCoordinatorEnabled() {
        return TestInfoUtils$.MODULE$.isNewGroupCoordinatorEnabled(this.testInfo());
    }

    public Option<GroupProtocol> maybeGroupProtocolSpecified(TestInfo testInfo) {
        return TestInfoUtils$.MODULE$.maybeGroupProtocolSpecified(testInfo);
    }

    public void checkIsZKTest() {
        if (this.isKRaftTest()) {
            throw new RuntimeException("This function can't be accessed when running the test in KRaft mode. ZooKeeper mode is required.");
        }
    }

    public void checkIsKRaftTest() {
        if (!this.isKRaftTest()) {
            throw new RuntimeException("This function can't be accessed when running the test in ZooKeeper mode. KRaft mode is required.");
        }
    }

    private ZooKeeperQuorumImplementation asZk() {
        this.checkIsZKTest();
        return (ZooKeeperQuorumImplementation)this.implementation();
    }

    private KRaftQuorumImplementation asKRaft() {
        this.checkIsKRaftTest();
        return (KRaftQuorumImplementation)this.implementation();
    }

    public EmbeddedZookeeper zookeeper() {
        return this.asZk().zookeeper();
    }

    public KafkaZkClient zkClient() {
        return this.asZk().zkClient();
    }

    public KafkaZkClient zkClientOrNull() {
        if (this.isKRaftTest()) {
            return null;
        }
        return this.asZk().zkClient();
    }

    public AdminZkClient adminZkClient() {
        return this.asZk().adminZkClient();
    }

    public int zkPort() {
        return this.asZk().zookeeper().port();
    }

    public String zkConnect() {
        return new StringBuilder(10).append("127.0.0.1:").append(this.zkPort()).toString();
    }

    public String zkConnectOrNull() {
        if (this.isKRaftTest()) {
            return null;
        }
        return this.zkConnect();
    }

    public ControllerServer controllerServer() {
        return this.asKRaft().controllerServer();
    }

    public Seq<ControllerServer> controllerServers() {
        if (this.isKRaftTest()) {
            return new .colon.colon((Object)this.asKRaft().controllerServer(), (List)Nil$.MODULE$);
        }
        return Nil$.MODULE$;
    }

    public QuorumTestHarnessFaultHandlerFactory faultHandlerFactory() {
        return this.faultHandlerFactory;
    }

    public MockFaultHandler faultHandler() {
        return this.faultHandler;
    }

    @BeforeEach
    public void setUp(TestInfo testInfo) {
        this.testInfo_$eq(testInfo);
        Exit.setExitProcedure((code, message) -> {
            try {
                try {
                    throw new RuntimeException(new StringBuilder(16).append("exit(").append(code).append(", ").append(message).append(") called!").toString());
                }
                catch (Throwable e) {
                    this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "test error", (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> e);
                    throw e;
                }
            }
            catch (Throwable throwable) {
                this.tearDown();
                throw throwable;
            }
        });
        Exit.setHaltProcedure((code, message) -> {
            try {
                try {
                    throw new RuntimeException(new StringBuilder(16).append("halt(").append(code).append(", ").append(message).append(") called!").toString());
                }
                catch (Throwable e) {
                    this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "test error", (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> e);
                    throw e;
                }
            }
            catch (Throwable throwable) {
                this.tearDown();
                throw throwable;
            }
        });
        String name = (String)OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(testInfo.getTestMethod())).map((Function1 & Serializable & scala.Serializable)x$3 -> x$3.toString()).getOrElse((Function0 & Serializable & scala.Serializable)() -> "[unspecified]");
        if (TestInfoUtils$.MODULE$.isKRaft(testInfo)) {
            this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(19).append("Running KRAFT test ").append(name).toString());
            this.implementation_$eq(this.newKRaftQuorum(testInfo));
            return;
        }
        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(16).append("Running ZK test ").append(name).toString());
        this.implementation_$eq(this.newZooKeeperQuorum());
    }

    public KafkaBroker createBroker(KafkaConfig config, Time time, boolean startup, Option<String> threadNamePrefix) {
        return this.implementation().createBroker(config, time, startup, threadNamePrefix);
    }

    public Time createBroker$default$2() {
        return Time.SYSTEM;
    }

    public boolean createBroker$default$3() {
        return true;
    }

    public Option<String> createBroker$default$4() {
        return None$.MODULE$;
    }

    public void shutdownZooKeeper() {
        this.asZk().shutdown();
    }

    public void shutdownKRaftController() {
        KRaftQuorumImplementation kRaftQuorumImplementation = this.asKRaft();
        CoreUtils$.MODULE$.swallow((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> kRaftQuorumImplementation.controllerServer().shutdown(), kRaftQuorumImplementation.log(), CoreUtils$.MODULE$.swallow$default$3());
    }

    public Option<ArrayBuffer<ApiMessageAndVersion>> optionalMetadataRecords() {
        return None$.MODULE$;
    }

    private KRaftQuorumImplementation newKRaftQuorum(TestInfo testInfo) {
        return this.newKRaftQuorum(new Properties());
    }

    public KRaftQuorumImplementation newKRaftQuorum(Properties overridingProps) {
        Seq<Properties> propsList = this.kraftControllerConfigs();
        if (propsList.size() != 1) {
            throw new RuntimeException("Only one KRaft controller is supported for now.");
        }
        Properties props = (Properties)propsList.head();
        props.putAll((Map<?, ?>)overridingProps);
        props.setProperty("server.max.startup.time.ms", Long.toString(TimeUnit.MINUTES.toMillis(10L)));
        props.setProperty("process.roles", "controller");
        props.setProperty("unstable.feature.versions.enable", "true");
        if (props.getProperty("node.id") == null) {
            props.setProperty("node.id", "1000");
        }
        int nodeId = Integer.parseInt(props.getProperty("node.id"));
        File metadataDir = TestUtils$.MODULE$.tempDir();
        MetaProperties metaProperties = new MetaProperties.Builder().setVersion(MetaPropertiesVersion.V1).setClusterId(Uuid.randomUuid().toString()).setNodeId(nodeId).build();
        TestUtils$.MODULE$.formatDirectories((scala.collection.immutable.Seq<String>)new .colon.colon((Object)metadataDir.getAbsolutePath(), (List)Nil$.MODULE$), metaProperties, this.metadataVersion(), this.optionalMetadataRecords());
        ArrayList<ApiMessageAndVersion> metadataRecords = new ArrayList<ApiMessageAndVersion>();
        metadataRecords.add(new ApiMessageAndVersion((ApiMessage)new FeatureLevelRecord().setName("metadata.version").setFeatureLevel(this.metadataVersion().featureLevel()), (short)0));
        this.optionalMetadataRecords().foreach((Function1 & Serializable & scala.Serializable)metadataArguments -> {
            metadataArguments.foreach((Function1 & Serializable & scala.Serializable)record -> BoxesRunTime.boxToBoolean((boolean)metadataRecords$1.add(record)));
            return BoxedUnit.UNIT;
        });
        BootstrapMetadata bootstrapMetadata = BootstrapMetadata.fromRecords(metadataRecords, (String)"test harness");
        props.setProperty("metadata.log.dir", metadataDir.getAbsolutePath());
        String proto = this.controllerListenerSecurityProtocol().toString();
        props.setProperty("listener.security.protocol.map", new StringBuilder(11).append("CONTROLLER:").append(proto).toString());
        props.setProperty("listeners", "CONTROLLER://localhost:0");
        props.setProperty("controller.listener.names", "CONTROLLER");
        props.setProperty("controller.quorum.voters", new StringBuilder(12).append(nodeId).append("@localhost:0").toString());
        KafkaConfig config = new KafkaConfig((Map)props);
        CompletableFuture<Map<Integer, InetSocketAddress>> controllerQuorumVotersFuture = new CompletableFuture<Map<Integer, InetSocketAddress>>();
        MetaPropertiesEnsemble metaPropertiesEnsemble = new MetaPropertiesEnsemble.Loader().addMetadataLogDir(metadataDir.getAbsolutePath()).load();
        metaPropertiesEnsemble.verify(Optional.of(metaProperties.clusterId().get()), OptionalInt.of(nodeId), EnumSet.of(MetaPropertiesEnsemble.VerificationFlag.REQUIRE_AT_LEAST_ONE_VALID, MetaPropertiesEnsemble.VerificationFlag.REQUIRE_METADATA_LOG_DIR));
        SharedServer sharedServer = new SharedServer(config, metaPropertiesEnsemble, Time.SYSTEM, new Metrics(), controllerQuorumVotersFuture, Collections.emptyList(), (FaultHandlerFactory)this.faultHandlerFactory());
        ObjectRef controllerServer = ObjectRef.create(null);
        try {
            controllerServer.elem = new ControllerServer(sharedServer, KafkaRaftServer$.MODULE$.configSchema(), bootstrapMetadata);
            ((ControllerServer)controllerServer.elem).socketServerFirstBoundPortFuture().whenComplete((port, e) -> {
                if (e != null) {
                    this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Error completing controller socket server future", (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> e);
                    controllerQuorumVotersFuture.completeExceptionally((Throwable)e);
                    return;
                }
                controllerQuorumVotersFuture.complete(Collections.singletonMap(Predef$.MODULE$.int2Integer(nodeId), new InetSocketAddress("localhost", Predef$.MODULE$.Integer2int(port))));
            });
            ((ControllerServer)controllerServer.elem).startup();
        }
        catch (Throwable e2) {
            if ((ControllerServer)controllerServer.elem != null) {
                CoreUtils$.MODULE$.swallow((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> ((ControllerServer)controllerServer$1.elem).shutdown(), (Logging)this, CoreUtils$.MODULE$.swallow$default$3());
            }
            CoreUtils$.MODULE$.swallow((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> sharedServer.stopForController(), (Logging)this, CoreUtils$.MODULE$.swallow$default$3());
            throw e2;
        }
        return new KRaftQuorumImplementation((ControllerServer)controllerServer.elem, this.faultHandlerFactory(), metadataDir, controllerQuorumVotersFuture, (String)metaProperties.clusterId().get(), this, (FaultHandler)this.faultHandler());
    }

    private ZooKeeperQuorumImplementation newZooKeeperQuorum() {
        AdminZkClient adminZkClient;
        EmbeddedZookeeper zookeeper = new EmbeddedZookeeper();
        ObjectRef zkClient = ObjectRef.create(null);
        String zkConnect = new StringBuilder(10).append("127.0.0.1:").append(zookeeper.port()).toString();
        try {
            boolean x$2 = BoxesRunTime.unboxToBoolean((Object)this.zkAclsEnabled().getOrElse((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> JaasUtils.isZkSaslEnabled()));
            int x$3 = this.zkSessionTimeout();
            int x$4 = this.zkConnectionTimeout();
            int x$5 = this.zkMaxInFlightRequests();
            Time x$6 = Time.SYSTEM;
            String x$7 = "ZooKeeperTestHarness";
            ZKClientConfig x$8 = new ZKClientConfig();
            boolean x$9 = false;
            String x$10 = KafkaZkClient$.MODULE$.apply$default$9();
            String x$11 = KafkaZkClient$.MODULE$.apply$default$10();
            boolean x$12 = KafkaZkClient$.MODULE$.apply$default$11();
            zkClient.elem = KafkaZkClient$.MODULE$.apply(zkConnect, x$2, x$3, x$4, x$5, x$6, x$7, x$8, x$10, x$11, x$12, x$9);
            adminZkClient = new AdminZkClient((KafkaZkClient)zkClient.elem, AdminZkClient$.MODULE$.$lessinit$greater$default$2());
        }
        catch (Throwable t) {
            CoreUtils$.MODULE$.swallow((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> zookeeper.shutdown(), (Logging)this, CoreUtils$.MODULE$.swallow$default$3());
            if ((KafkaZkClient)zkClient.elem != null) {
                CoreUtils$.MODULE$.swallow((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> ((KafkaZkClient)zkClient$1.elem).close(), (Logging)this, CoreUtils$.MODULE$.swallow$default$3());
            }
            throw t;
        }
        return new ZooKeeperQuorumImplementation(zookeeper, zkConnect, (KafkaZkClient)zkClient.elem, adminZkClient, this);
    }

    @AfterEach
    public void tearDown() {
        if (this.implementation() != null) {
            this.implementation().shutdown();
        }
        Exit.resetExitProcedure();
        Exit.resetHaltProcedure();
        TestUtils$.MODULE$.clearYammerMetrics();
        System.clearProperty("java.security.auth.login.config");
        Configuration.setConfiguration(null);
        this.faultHandler().maybeRethrowFirstException();
    }

    public ZooKeeper createZooKeeperClientToTriggerSessionExpiry(ZooKeeper zooKeeper) {
        Watcher dummyWatcher = new Watcher(null){

            public void process(WatchedEvent event) {
            }
        };
        ZooKeeper anotherZkClient = new ZooKeeper(this.zkConnect(), 1000, dummyWatcher, zooKeeper.getSessionId(), zooKeeper.getSessionPasswd());
        Assertions.assertNull((Object)anotherZkClient.exists("/nonexistent", false));
        return anotherZkClient;
    }

    public QuorumTestHarness() {
        Logging.$init$((Logging)this);
        this.zkConnectionTimeout = 10000;
        this.zkSessionTimeout = 15000;
        this.zkMaxInFlightRequests = Integer.MAX_VALUE;
        this.controllerListenerSecurityProtocol = SecurityProtocol.PLAINTEXT;
        this.bootstrapRecords = (ListBuffer)ListBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.faultHandlerFactory = new QuorumTestHarnessFaultHandlerFactory(new MockFaultHandler("quorumTestHarnessFaultHandler"));
        this.faultHandler = this.faultHandlerFactory().faultHandler();
    }
}

