/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.File;
import java.net.Socket;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import kafka.api.KafkaSasl$;
import kafka.api.SaslSetup;
import kafka.api.SaslSetupMode;
import kafka.network.SocketServer;
import kafka.security.minikdc.MiniKdc;
import kafka.server.AbstractApiVersionsRequestTest;
import kafka.server.IntegrationTestUtils$;
import kafka.server.SaslApiVersionsRequestTest$;
import kafka.test.ClusterConfig;
import kafka.test.ClusterInstance;
import kafka.test.annotation.ClusterTemplate;
import kafka.test.junit.ClusterTestExtensions;
import kafka.utils.JaasTestUtils;
import kafka.utils.JaasTestUtils$;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.common.message.SaslHandshakeRequestData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.ApiVersionsRequest;
import org.apache.kafka.common.requests.ApiVersionsResponse;
import org.apache.kafka.common.requests.SaslHandshakeRequest;
import org.apache.kafka.common.requests.SaslHandshakeResponse;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.extension.ExtendWith;
import scala.Option;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;

@ExtendWith(value={ClusterTestExtensions.class})
@ScalaSignature(bytes="\u0006\u0001\u0005}t!\u0002\r\u001a\u0011\u0003qb!\u0002\u0011\u001a\u0011\u0003\t\u0003\"\u0002\u0015\u0002\t\u0003I\u0003b\u0002\u0016\u0002\u0005\u0004%\ta\u000b\u0005\u0007i\u0005\u0001\u000b\u0011\u0002\u0017\t\u000fU\n!\u0019!C\u0001m!1!*\u0001Q\u0001\n]BqaS\u0001C\u0002\u0013\u00051\u0006\u0003\u0004M\u0003\u0001\u0006I\u0001\f\u0005\b\u001b\u0006\u0011\r\u0011\"\u0001O\u0011\u0019q\u0016\u0001)A\u0005\u001f\")q,\u0001C\u0001A\u001a!\u0001%\u0007\u0001n\u0011!\tHB!A!\u0002\u0013\u0011\b\"\u0002\u0015\r\t\u0003)\b\"\u0003=\r\u0001\u0004\u0005\r\u0011\"\u0003z\u0011-\t\t\u0001\u0004a\u0001\u0002\u0004%I!a\u0001\t\u0015\u0005=A\u00021A\u0001B\u0003&!\u0010C\u0004\u0002\u00121!\t!a\u0005\t\u000f\u0005%B\u0002\"\u0001\u0002\u0014!9\u0011Q\b\u0007\u0005\u0002\u0005M\u0001bBA!\u0019\u0011\u0005\u00111\u0003\u0005\b\u0003\u000bbA\u0011AA\n\u0011\u001d\ty\u0005\u0004C\u0005\u0003#\n!dU1tY\u0006\u0003\u0018NV3sg&|gn\u001d*fcV,7\u000f\u001e+fgRT!AG\u000e\u0002\rM,'O^3s\u0015\u0005a\u0012!B6bM.\f7\u0001\u0001\t\u0003?\u0005i\u0011!\u0007\u0002\u001b'\u0006\u001cH.\u00119j-\u0016\u00148/[8ogJ+\u0017/^3tiR+7\u000f^\n\u0003\u0003\t\u0002\"a\t\u0014\u000e\u0003\u0011R\u0011!J\u0001\u0006g\u000e\fG.Y\u0005\u0003O\u0011\u0012a!\u00118z%\u00164\u0017A\u0002\u001fj]&$h\bF\u0001\u001f\u0003aY\u0017MZ6b\u00072LWM\u001c;TCNdW*Z2iC:L7/\\\u000b\u0002YA\u0011QFM\u0007\u0002])\u0011q\u0006M\u0001\u0005Y\u0006twMC\u00012\u0003\u0011Q\u0017M^1\n\u0005Mr#AB*ue&tw-A\rlC\u001a\\\u0017m\u00117jK:$8+Y:m\u001b\u0016\u001c\u0007.\u00198jg6\u0004\u0013!G6bM.\f7+\u001a:wKJ\u001c\u0016m\u001d7NK\u000eD\u0017M\\5t[N,\u0012a\u000e\t\u0004q\u0001\u001beBA\u001d?\u001d\tQT(D\u0001<\u0015\taT$\u0001\u0004=e>|GOP\u0005\u0002K%\u0011q\bJ\u0001\ba\u0006\u001c7.Y4f\u0013\t\t%IA\u0002TKFT!a\u0010\u0013\u0011\u0005\u0011CeBA#G!\tQD%\u0003\u0002HI\u00051\u0001K]3eK\u001aL!aM%\u000b\u0005\u001d#\u0013AG6bM.\f7+\u001a:wKJ\u001c\u0016m\u001d7NK\u000eD\u0017M\\5t[N\u0004\u0013\u0001G2p]R\u0014x\u000e\u001c)mC:,G*[:uK:,'OT1nK\u0006I2m\u001c8ue>d\u0007\u000b\\1oK2K7\u000f^3oKJt\u0015-\\3!\u0003A\u0019XmY;sSRL\bK]8u_\u000e|G.F\u0001P!\t\u0001F,D\u0001R\u0015\t\u00116+\u0001\u0003bkRD'B\u0001+V\u0003!\u0019XmY;sSRL(B\u0001,X\u0003\u0019\u0019w.\\7p]*\u0011A\u0004\u0017\u0006\u00033j\u000ba!\u00199bG\",'\"A.\u0002\u0007=\u0014x-\u0003\u0002^#\n\u00012+Z2ve&$\u0018\u0010\u0015:pi>\u001cw\u000e\\\u0001\u0012g\u0016\u001cWO]5usB\u0013x\u000e^8d_2\u0004\u0013aI:bg2\f\u0005/\u001b,feNLwN\\:SKF,Xm\u001d;DYV\u001cH/\u001a:D_:4\u0017n\u001a\u000b\u0002CB\u0019!-Z4\u000e\u0003\rT!\u0001\u001a\u0019\u0002\tU$\u0018\u000e\\\u0005\u0003M\u000e\u0014A\u0001T5tiB\u0011\u0001n[\u0007\u0002S*\u0011!nG\u0001\u0005i\u0016\u001cH/\u0003\u0002mS\ni1\t\\;ti\u0016\u00148i\u001c8gS\u001e\u001c\"\u0001\u00048\u0011\u0005}y\u0017B\u00019\u001a\u0005y\t%m\u001d;sC\u000e$\u0018\t]5WKJ\u001c\u0018n\u001c8t%\u0016\fX/Z:u)\u0016\u001cH/A\u0004dYV\u001cH/\u001a:\u0011\u0005!\u001c\u0018B\u0001;j\u0005=\u0019E.^:uKJLen\u001d;b]\u000e,GC\u0001<x!\tyB\u0002C\u0003r\u001d\u0001\u0007!/\u0001\u0003tCNdW#\u0001>\u0011\u0005mtX\"\u0001?\u000b\u0005u\\\u0012aA1qS&\u0011q\u0010 \u0002\n'\u0006\u001cHnU3ukB\f\u0001b]1tY~#S-\u001d\u000b\u0005\u0003\u000b\tY\u0001E\u0002$\u0003\u000fI1!!\u0003%\u0005\u0011)f.\u001b;\t\u0011\u00055\u0001#!AA\u0002i\f1\u0001\u001f\u00132\u0003\u0015\u0019\u0018m\u001d7!\u0003%\u0019X\r^;q'\u0006\u001cH\u000e\u0006\u0002\u0002\u0006!\u001a!#a\u0006\u0011\t\u0005e\u0011QE\u0007\u0003\u00037Q1!`A\u000f\u0015\u0011\ty\"!\t\u0002\u000f),\b/\u001b;fe*\u0019\u00111\u0005.\u0002\u000b),h.\u001b;\n\t\u0005\u001d\u00121\u0004\u0002\u000b\u0005\u00164wN]3FC\u000eD\u0017\u0001\r;fgR\f\u0005/\u001b,feNLwN\\:SKF,Xm\u001d;CK\u001a|'/Z*bg2D\u0015M\u001c3tQ\u0006\\WMU3rk\u0016\u001cH\u000fK\u0004\u0014\u0003[\tI$a\u000f\u0011\t\u0005=\u0012QG\u0007\u0003\u0003cQ1!a\rj\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0003o\t\tDA\bDYV\u001cH/\u001a:UK6\u0004H.\u0019;f\u0003\u00151\u0018\r\\;fC\u0005y\u0016a\f;fgR\f\u0005/\u001b,feNLwN\\:SKF,Xm\u001d;BMR,'oU1tY\"\u000bg\u000eZ:iC.,'+Z9vKN$\bf\u0002\u000b\u0002.\u0005e\u00121H\u0001-i\u0016\u001cH/\u00119j-\u0016\u00148/[8ogJ+\u0017/^3ti^KG\u000f[+ogV\u0004\bo\u001c:uK\u00124VM]:j_:Ds!FA\u0017\u0003s\tY$A\u0005dY>\u001cXmU1tY\"\u001aa#!\u0013\u0011\t\u0005e\u00111J\u0005\u0005\u0003\u001b\nYBA\u0005BMR,'/R1dQ\u0006A3/\u001a8e'\u0006\u001cH\u000eS1oIND\u0017m[3SKF,Xm\u001d;WC2LG-\u0019;f%\u0016\u001c\bo\u001c8tKR!\u0011QAA*\u0011\u001d\t)f\u0006a\u0001\u0003/\naa]8dW\u0016$\b\u0003BA-\u0003?j!!a\u0017\u000b\u0007\u0005u\u0003'A\u0002oKRLA!!\u0019\u0002\\\t11k\\2lKRDs\u0001DA3\u0003s\t\t\b\u0005\u0003\u0002h\u00055TBAA5\u0015\u0011\tY'a\u0007\u0002\u0013\u0015DH/\u001a8tS>t\u0017\u0002BA8\u0003S\u0012!\"\u0012=uK:$w+\u001b;iY\t\t\u0019h\t\u0002\u0002vA!\u0011qOA>\u001b\t\tIHC\u0002\u0002$%LA!! \u0002z\t)2\t\\;ti\u0016\u0014H+Z:u\u000bb$XM\\:j_:\u001c\b")
public class SaslApiVersionsRequestTest
extends AbstractApiVersionsRequestTest {
    private final ClusterInstance cluster;
    private SaslSetup sasl;

    public static List<ClusterConfig> saslApiVersionsRequestClusterConfig() {
        return SaslApiVersionsRequestTest$.MODULE$.saslApiVersionsRequestClusterConfig();
    }

    public static SecurityProtocol securityProtocol() {
        return SaslApiVersionsRequestTest$.MODULE$.securityProtocol();
    }

    public static String controlPlaneListenerName() {
        return SaslApiVersionsRequestTest$.MODULE$.controlPlaneListenerName();
    }

    public static Seq<String> kafkaServerSaslMechanisms() {
        return SaslApiVersionsRequestTest$.MODULE$.kafkaServerSaslMechanisms();
    }

    public static String kafkaClientSaslMechanism() {
        return SaslApiVersionsRequestTest$.MODULE$.kafkaClientSaslMechanism();
    }

    private SaslSetup sasl() {
        return this.sasl;
    }

    private void sasl_$eq(SaslSetup x$1) {
        this.sasl = x$1;
    }

    @BeforeEach
    public void setupSasl() {
        this.sasl_$eq(new SaslSetup(null){
            private final File kafka$api$SaslSetup$$workDir;
            private final Properties kafka$api$SaslSetup$$kdcConf;
            private MiniKdc kafka$api$SaslSetup$$kdc;
            private Option<File> kafka$api$SaslSetup$$serverKeytabFile;
            private Option<File> kafka$api$SaslSetup$$clientKeytabFile;

            public void startSasl(Seq<JaasTestUtils.JaasSection> jaasSections) {
                SaslSetup.startSasl$(this, jaasSections);
            }

            public void initializeKerberos() {
                SaslSetup.initializeKerberos$(this);
            }

            public Tuple2<File, File> maybeCreateEmptyKeytabFiles() {
                return SaslSetup.maybeCreateEmptyKeytabFiles$(this);
            }

            public Seq<JaasTestUtils.JaasSection> jaasSections(Seq<String> kafkaServerSaslMechanisms, Option<String> kafkaClientSaslMechanism, SaslSetupMode mode, String kafkaServerEntryName) {
                return SaslSetup.jaasSections$(this, kafkaServerSaslMechanisms, kafkaClientSaslMechanism, mode, kafkaServerEntryName);
            }

            public SaslSetupMode jaasSections$default$3() {
                return SaslSetup.jaasSections$default$3$(this);
            }

            public String jaasSections$default$4() {
                return SaslSetup.jaasSections$default$4$(this);
            }

            public void closeSasl() {
                SaslSetup.closeSasl$(this);
            }

            public Properties kafkaServerSaslProperties(Seq<String> serverSaslMechanisms, String interBrokerSaslMechanism) {
                return SaslSetup.kafkaServerSaslProperties$(this, serverSaslMechanisms, interBrokerSaslMechanism);
            }

            public Properties kafkaClientSaslProperties(String clientSaslMechanism, boolean dynamicJaasConfig) {
                return SaslSetup.kafkaClientSaslProperties$(this, clientSaslMechanism, dynamicJaasConfig);
            }

            public boolean kafkaClientSaslProperties$default$2() {
                return SaslSetup.kafkaClientSaslProperties$default$2$(this);
            }

            public String jaasClientLoginModule(String clientSaslMechanism, Option<String> serviceName) {
                return SaslSetup.jaasClientLoginModule$(this, clientSaslMechanism, serviceName);
            }

            public Option<String> jaasClientLoginModule$default$2() {
                return SaslSetup.jaasClientLoginModule$default$2$(this);
            }

            public String jaasAdminLoginModule(String clientSaslMechanism, Option<String> serviceName) {
                return SaslSetup.jaasAdminLoginModule$(this, clientSaslMechanism, serviceName);
            }

            public Option<String> jaasAdminLoginModule$default$2() {
                return SaslSetup.jaasAdminLoginModule$default$2$(this);
            }

            public String jaasScramClientLoginModule(String clientSaslScramMechanism, String scramUser, String scramPassword) {
                return SaslSetup.jaasScramClientLoginModule$(this, clientSaslScramMechanism, scramUser, scramPassword);
            }

            public Admin createPrivilegedAdminClient() {
                return SaslSetup.createPrivilegedAdminClient$(this);
            }

            public Admin createAdminClient(String brokerList, SecurityProtocol securityProtocol, Option<File> trustStoreFile, Option<Properties> clientSaslProperties, String scramMechanism, String user, String password) {
                return SaslSetup.createAdminClient$(this, brokerList, securityProtocol, trustStoreFile, clientSaslProperties, scramMechanism, user, password);
            }

            public void createScramCredentialsViaPrivilegedAdminClient(String userName, String password) {
                SaslSetup.createScramCredentialsViaPrivilegedAdminClient$(this, userName, password);
            }

            public void createScramCredentials(Admin adminClient, String userName, String password) {
                SaslSetup.createScramCredentials$((SaslSetup)this, adminClient, userName, password);
            }

            public void createScramCredentials(String zkConnect, String userName, String password) {
                SaslSetup.createScramCredentials$((SaslSetup)this, zkConnect, userName, password);
            }

            public File kafka$api$SaslSetup$$workDir() {
                return this.kafka$api$SaslSetup$$workDir;
            }

            public Properties kafka$api$SaslSetup$$kdcConf() {
                return this.kafka$api$SaslSetup$$kdcConf;
            }

            public MiniKdc kafka$api$SaslSetup$$kdc() {
                return this.kafka$api$SaslSetup$$kdc;
            }

            public void kafka$api$SaslSetup$$kdc_$eq(MiniKdc x$1) {
                this.kafka$api$SaslSetup$$kdc = x$1;
            }

            public Option<File> kafka$api$SaslSetup$$serverKeytabFile() {
                return this.kafka$api$SaslSetup$$serverKeytabFile;
            }

            public void kafka$api$SaslSetup$$serverKeytabFile_$eq(Option<File> x$1) {
                this.kafka$api$SaslSetup$$serverKeytabFile = x$1;
            }

            public Option<File> kafka$api$SaslSetup$$clientKeytabFile() {
                return this.kafka$api$SaslSetup$$clientKeytabFile;
            }

            public void kafka$api$SaslSetup$$clientKeytabFile_$eq(Option<File> x$1) {
                this.kafka$api$SaslSetup$$clientKeytabFile = x$1;
            }

            public final void kafka$api$SaslSetup$_setter_$kafka$api$SaslSetup$$workDir_$eq(File x$1) {
                this.kafka$api$SaslSetup$$workDir = x$1;
            }

            public final void kafka$api$SaslSetup$_setter_$kafka$api$SaslSetup$$kdcConf_$eq(Properties x$1) {
                this.kafka$api$SaslSetup$$kdcConf = x$1;
            }
            {
                SaslSetup.$init$(this);
            }
        });
        this.sasl().startSasl(this.sasl().jaasSections(SaslApiVersionsRequestTest$.MODULE$.kafkaServerSaslMechanisms(), (Option<String>)new Some((Object)SaslApiVersionsRequestTest$.MODULE$.kafkaClientSaslMechanism()), KafkaSasl$.MODULE$, JaasTestUtils$.MODULE$.KafkaServerContextName()));
    }

    @ClusterTemplate(value="saslApiVersionsRequestClusterConfig")
    public void testApiVersionsRequestBeforeSaslHandshakeRequest() {
        try (Socket socket = IntegrationTestUtils$.MODULE$.connect((SocketServer)((IterableLike)CollectionConverters$.MODULE$.collectionAsScalaIterableConverter(this.cluster.brokerSocketServers()).asScala()).head(), this.cluster.clientListener());){
            ApiVersionsResponse apiVersionsResponse = (ApiVersionsResponse)IntegrationTestUtils$.MODULE$.sendAndReceive((AbstractRequest)new ApiVersionsRequest.Builder().build((short)0), socket, IntegrationTestUtils$.MODULE$.sendAndReceive$default$3(), IntegrationTestUtils$.MODULE$.sendAndReceive$default$4(), ClassTag$.MODULE$.apply(ApiVersionsResponse.class));
            this.validateApiVersionsResponse(apiVersionsResponse, this.validateApiVersionsResponse$default$2(), this.validateApiVersionsResponse$default$3(), this.validateApiVersionsResponse$default$4(), this.validateApiVersionsResponse$default$5());
            this.sendSaslHandshakeRequestValidateResponse(socket);
        }
    }

    @ClusterTemplate(value="saslApiVersionsRequestClusterConfig")
    public void testApiVersionsRequestAfterSaslHandshakeRequest() {
        try (Socket socket = IntegrationTestUtils$.MODULE$.connect((SocketServer)((IterableLike)CollectionConverters$.MODULE$.collectionAsScalaIterableConverter(this.cluster.brokerSocketServers()).asScala()).head(), this.cluster.clientListener());){
            this.sendSaslHandshakeRequestValidateResponse(socket);
            ApiVersionsResponse response = (ApiVersionsResponse)IntegrationTestUtils$.MODULE$.sendAndReceive((AbstractRequest)new ApiVersionsRequest.Builder().build((short)0), socket, IntegrationTestUtils$.MODULE$.sendAndReceive$default$3(), IntegrationTestUtils$.MODULE$.sendAndReceive$default$4(), ClassTag$.MODULE$.apply(ApiVersionsResponse.class));
            Assertions.assertEquals((short)Errors.ILLEGAL_SASL_STATE.code(), (short)response.data().errorCode());
        }
    }

    @ClusterTemplate(value="saslApiVersionsRequestClusterConfig")
    public void testApiVersionsRequestWithUnsupportedVersion() {
        try (Socket socket = IntegrationTestUtils$.MODULE$.connect((SocketServer)((IterableLike)CollectionConverters$.MODULE$.collectionAsScalaIterableConverter(this.cluster.brokerSocketServers()).asScala()).head(), this.cluster.clientListener());){
            ApiVersionsRequest apiVersionsRequest = new ApiVersionsRequest.Builder().build((short)0);
            ApiVersionsResponse apiVersionsResponse = this.sendUnsupportedApiVersionRequest(apiVersionsRequest);
            Assertions.assertEquals((short)Errors.UNSUPPORTED_VERSION.code(), (short)apiVersionsResponse.data().errorCode());
            ApiVersionsResponse apiVersionsResponse2 = (ApiVersionsResponse)IntegrationTestUtils$.MODULE$.sendAndReceive((AbstractRequest)new ApiVersionsRequest.Builder().build((short)0), socket, IntegrationTestUtils$.MODULE$.sendAndReceive$default$3(), IntegrationTestUtils$.MODULE$.sendAndReceive$default$4(), ClassTag$.MODULE$.apply(ApiVersionsResponse.class));
            this.validateApiVersionsResponse(apiVersionsResponse2, this.validateApiVersionsResponse$default$2(), this.validateApiVersionsResponse$default$3(), this.validateApiVersionsResponse$default$4(), this.validateApiVersionsResponse$default$5());
            this.sendSaslHandshakeRequestValidateResponse(socket);
        }
    }

    @AfterEach
    public void closeSasl() {
        this.sasl().closeSasl();
    }

    private void sendSaslHandshakeRequestValidateResponse(Socket socket) {
        SaslHandshakeRequest request = new SaslHandshakeRequest(new SaslHandshakeRequestData().setMechanism("PLAIN"), ApiKeys.SASL_HANDSHAKE.latestVersion());
        SaslHandshakeResponse response = (SaslHandshakeResponse)IntegrationTestUtils$.MODULE$.sendAndReceive((AbstractRequest)request, socket, IntegrationTestUtils$.MODULE$.sendAndReceive$default$3(), IntegrationTestUtils$.MODULE$.sendAndReceive$default$4(), ClassTag$.MODULE$.apply(SaslHandshakeResponse.class));
        Assertions.assertEquals((Object)Errors.NONE, (Object)response.error());
        Assertions.assertEquals(Collections.singletonList("PLAIN"), (Object)response.enabledMechanisms());
    }

    public SaslApiVersionsRequestTest(ClusterInstance cluster) {
        this.cluster = cluster;
        super(cluster);
    }
}

