/*
 * Decompiled with CFR 0.152.
 */
package kafka.tools;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collections;
import java.util.ListIterator;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.ConcurrentMap;
import java.util.stream.IntStream;
import kafka.log.LogTestUtils$;
import kafka.log.UnifiedLog;
import kafka.log.UnifiedLog$;
import kafka.raft.KafkaMetadataLog;
import kafka.raft.KafkaMetadataLog$;
import kafka.raft.MetadataLogConfig;
import kafka.serializer.Decoder;
import kafka.serializer.IntegerDecoder;
import kafka.serializer.LongDecoder;
import kafka.serializer.StringDecoder;
import kafka.server.BrokerTopicStats;
import kafka.server.BrokerTopicStats$;
import kafka.server.KafkaRaftServer$;
import kafka.server.RequestLocal;
import kafka.tools.BatchInfo;
import kafka.tools.DumpLogSegments;
import kafka.tools.DumpLogSegments$;
import kafka.utils.TestUtils$;
import kafka.utils.VerifiableProperties;
import org.apache.kafka.clients.consumer.ConsumerPartitionAssignor;
import org.apache.kafka.clients.consumer.internals.ConsumerProtocol;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.compress.Compression;
import org.apache.kafka.common.metadata.PartitionChangeRecord;
import org.apache.kafka.common.metadata.RegisterBrokerRecord;
import org.apache.kafka.common.metadata.TopicRecord;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.common.protocol.ByteBufferAccessor;
import org.apache.kafka.common.protocol.ObjectSerializationCache;
import org.apache.kafka.common.protocol.Writable;
import org.apache.kafka.common.record.ControlRecordType;
import org.apache.kafka.common.record.EndTransactionMarker;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.Record;
import org.apache.kafka.common.record.RecordBatch;
import org.apache.kafka.common.record.RecordVersion;
import org.apache.kafka.common.record.SimpleRecord;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.coordinator.group.CoordinatorRecord;
import org.apache.kafka.coordinator.group.CoordinatorRecordSerde;
import org.apache.kafka.coordinator.group.generated.ConsumerGroupMemberMetadataValue;
import org.apache.kafka.coordinator.group.generated.ConsumerGroupMetadataKey;
import org.apache.kafka.coordinator.group.generated.ConsumerGroupMetadataValue;
import org.apache.kafka.coordinator.group.generated.GroupMetadataKey;
import org.apache.kafka.coordinator.group.generated.GroupMetadataValue;
import org.apache.kafka.metadata.MetadataRecordSerde;
import org.apache.kafka.raft.OffsetAndEpoch;
import org.apache.kafka.raft.internals.VoterSetTest;
import org.apache.kafka.server.common.ApiMessageAndVersion;
import org.apache.kafka.server.common.MetadataVersion;
import org.apache.kafka.server.common.serialization.RecordSerde;
import org.apache.kafka.server.util.MockScheduler;
import org.apache.kafka.server.util.MockTime;
import org.apache.kafka.server.util.Scheduler;
import org.apache.kafka.snapshot.RawSnapshotWriter;
import org.apache.kafka.snapshot.RecordsSnapshotWriter;
import org.apache.kafka.storage.internals.log.AppendOrigin;
import org.apache.kafka.storage.internals.log.FetchDataInfo;
import org.apache.kafka.storage.internals.log.FetchIsolation;
import org.apache.kafka.storage.internals.log.LogConfig;
import org.apache.kafka.storage.internals.log.LogDirFailureChannel;
import org.apache.kafka.storage.internals.log.LogOffsetsListener;
import org.apache.kafka.storage.internals.log.ProducerStateManagerConfig;
import org.apache.kafka.storage.internals.log.VerificationGuard;
import org.apache.kafka.tools.api.DefaultDecoder;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import scala.Array$;
import scala.Console$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.Iterator;
import scala.collection.LinearSeqOptimized;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Map$;
import scala.collection.mutable.ResizableArray;
import scala.jdk.CollectionConverters$;
import scala.math.Numeric;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;
import scala.util.Using;
import scala.util.Using$;
import scala.util.matching.Regex;

@ScalaSignature(bytes="\u0006\u0001\t\u0005c\u0001\u0002\u001c8\u0001qBQa\u0011\u0001\u0005\u0002\u0011Cqa\u0012\u0001C\u0002\u0013\u0005\u0001\n\u0003\u0004R\u0001\u0001\u0006I!\u0013\u0005\b%\u0002\u0011\r\u0011\"\u0001I\u0011\u0019\u0019\u0006\u0001)A\u0005\u0013\"9A\u000b\u0001b\u0001\n\u0003)\u0006B\u0002/\u0001A\u0003%a\u000bC\u0004^\u0001\t\u0007I\u0011\u00010\t\r%\u0004\u0001\u0015!\u0003`\u0011\u001dQ\u0007A1A\u0005\u0002yCaa\u001b\u0001!\u0002\u0013y\u0006b\u00027\u0001\u0005\u0004%\tA\u0018\u0005\u0007[\u0002\u0001\u000b\u0011B0\t\u000f9\u0004!\u0019!C\u0001=\"1q\u000e\u0001Q\u0001\n}Cq\u0001\u001d\u0001C\u0002\u0013\u0005\u0011\u000f\u0003\u0004\u0000\u0001\u0001\u0006IA\u001d\u0005\n\u0003\u0003\u0001!\u0019!C\u0001\u0003\u0007A\u0001\"a\u0007\u0001A\u0003%\u0011Q\u0001\u0005\f\u0003;\u0001\u0001\u0019!a\u0001\n\u0003\ty\u0002C\u0006\u0002,\u0001\u0001\r\u00111A\u0005\u0002\u00055\u0002bCA\u001d\u0001\u0001\u0007\t\u0011)Q\u0005\u0003CAq!a\u000f\u0001\t\u0003\ti\u0004C\u0004\u0002V\u0001!\t!!\u0010\t\u000f\u0005]\u0003\u0001\"\u0001\u0002>!9\u0011\u0011\r\u0001\u0005\u0002\u0005u\u0002bBA6\u0001\u0011\u0005\u0011Q\b\u0005\b\u0003_\u0002A\u0011AA\u001f\u0011\u001d\t\u0019\b\u0001C\u0001\u0003{Aq!a\u001e\u0001\t\u0003\ti\u0004C\u0004\u0002|\u0001!\t!!\u0010\t\u000f\u0005}\u0004\u0001\"\u0001\u0002>!9\u00111\u0011\u0001\u0005\n\u0005\u0015\u0005bBAI\u0001\u0011\u0005\u0011Q\b\u0005\b\u0003+\u0003A\u0011AA\u001f\u0011\u001d\tI\n\u0001C\u0001\u0003{Aq!!(\u0001\t\u0003\ti\u0004C\u0004\u0002\"\u0002!I!a)\t\u000f\u0005e\u0006\u0001\"\u0003\u0002<\"9\u0011\u0011\u001a\u0001\u0005\n\u0005-\u0007bBAh\u0001\u0011%\u0011\u0011\u001b\u0005\b\u0003O\u0004A\u0011BAu\u0011\u001d\t)\u0010\u0001C\u0005\u0003{9q!a>8\u0011\u0003\tIP\u0002\u00047o!\u0005\u00111 \u0005\u0007\u00076\"\t!!@\u0007\r\u0005}X\u0006\u0001B\u0001\u0011)\u00119b\fB\u0001B\u0003%!\u0011\u0004\u0005\u0007\u0007>\"\tA!\n\t\u000f\t5r\u0006\"\u0011\u00030\u00191!QG\u0017\u0001\u0005oAaaQ\u001a\u0005\u0002\te\u0002b\u0002B\u0017g\u0011\u0005#Q\b\u0002\u0014\tVl\u0007\u000fT8h'\u0016<W.\u001a8ugR+7\u000f\u001e\u0006\u0003qe\nQ\u0001^8pYNT\u0011AO\u0001\u0006W\u000647.Y\u0002\u0001'\t\u0001Q\b\u0005\u0002?\u00036\tqHC\u0001A\u0003\u0015\u00198-\u00197b\u0013\t\u0011uH\u0001\u0004B]f\u0014VMZ\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003\u0015\u0003\"A\u0012\u0001\u000e\u0003]\na\u0001^7q\t&\u0014X#A%\u0011\u0005){U\"A&\u000b\u00051k\u0015AA5p\u0015\u0005q\u0015\u0001\u00026bm\u0006L!\u0001U&\u0003\t\u0019KG.Z\u0001\bi6\u0004H)\u001b:!\u0003\u0019awn\u001a#je\u00069An\\4ESJ\u0004\u0013aC:fO6,g\u000e\u001e(b[\u0016,\u0012A\u0016\t\u0003/jk\u0011\u0001\u0017\u0006\u000336\u000bA\u0001\\1oO&\u00111\f\u0017\u0002\u0007'R\u0014\u0018N\\4\u0002\u0019M,w-\\3oi:\u000bW.\u001a\u0011\u0002\u00171|wMR5mKB\u000bG\u000f[\u000b\u0002?B\u0011\u0001m\u001a\b\u0003C\u0016\u0004\"AY \u000e\u0003\rT!\u0001Z\u001e\u0002\rq\u0012xn\u001c;?\u0013\t1w(\u0001\u0004Qe\u0016$WMZ\u0005\u00037\"T!AZ \u0002\u00191|wMR5mKB\u000bG\u000f\u001b\u0011\u0002\u0019Mt\u0017\r]:i_R\u0004\u0016\r\u001e5\u0002\u001bMt\u0017\r]:i_R\u0004\u0016\r\u001e5!\u00035Ig\u000eZ3y\r&dW\rU1uQ\u0006q\u0011N\u001c3fq\u001aKG.\u001a)bi\"\u0004\u0013!\u0005;j[\u0016Le\u000eZ3y\r&dW\rU1uQ\u0006\u0011B/[7f\u0013:$W\r\u001f$jY\u0016\u0004\u0016\r\u001e5!\u0003\u0011!\u0018.\\3\u0016\u0003I\u0004\"a]?\u000e\u0003QT!!\u001e<\u0002\tU$\u0018\u000e\u001c\u0006\u0003ob\faa]3sm\u0016\u0014(B\u0001\u001ez\u0015\tQ80\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002y\u0006\u0019qN]4\n\u0005y$(\u0001C'pG.$\u0016.\\3\u0002\u000bQLW.\u001a\u0011\u0002\u000f\t\fGo\u00195fgV\u0011\u0011Q\u0001\t\u0007\u0003\u000f\t\t\"!\u0006\u000e\u0005\u0005%!\u0002BA\u0006\u0003\u001b\tq!\\;uC\ndWMC\u0002\u0002\u0010}\n!bY8mY\u0016\u001cG/[8o\u0013\u0011\t\u0019\"!\u0003\u0003\u0017\u0005\u0013(/Y=Ck\u001a4WM\u001d\t\u0004\r\u0006]\u0011bAA\ro\tI!)\u0019;dQ&sgm\\\u0001\tE\u0006$8\r[3tA\u0005\u0019An\\4\u0016\u0005\u0005\u0005\u0002\u0003BA\u0012\u0003Oi!!!\n\u000b\u0007\u0005u\u0011(\u0003\u0003\u0002*\u0005\u0015\"AC+oS\u001aLW\r\u001a'pO\u00069An\\4`I\u0015\fH\u0003BA\u0018\u0003k\u00012APA\u0019\u0013\r\t\u0019d\u0010\u0002\u0005+:LG\u000fC\u0005\u00028U\t\t\u00111\u0001\u0002\"\u0005\u0019\u0001\u0010J\u0019\u0002\t1|w\rI\u0001\u0006g\u0016$X\u000b\u001d\u000b\u0003\u0003_A3aFA!!\u0011\t\u0019%!\u0015\u000e\u0005\u0005\u0015#\u0002BA$\u0003\u0013\n1!\u00199j\u0015\u0011\tY%!\u0014\u0002\u000f),\b/\u001b;fe*\u0019\u0011qJ>\u0002\u000b),h.\u001b;\n\t\u0005M\u0013Q\t\u0002\u000b\u0005\u00164wN]3FC\u000eD\u0017\u0001E1eINKW\u000e\u001d7f%\u0016\u001cwN\u001d3t\u0003!!X-\u0019:E_^t\u0007fA\r\u0002\\A!\u00111IA/\u0013\u0011\ty&!\u0012\u0003\u0013\u00053G/\u001a:FC\u000eD\u0017\u0001\t;fgR\u0014\u0015\r^2i\u0003:$'+Z2pe\u0012lU\r^1eCR\fw*\u001e;qkRD3AGA3!\u0011\t\u0019%a\u001a\n\t\u0005%\u0014Q\t\u0002\u0005)\u0016\u001cH/\u0001\tuKN$\bK]5oi\u0012\u000bG/\u0019'pO\"\u001a1$!\u001a\u0002/Q,7\u000f\u001e#v[BLe\u000eZ3y\u001b&\u001cX.\u0019;dQ\u0016\u001c\bf\u0001\u000f\u0002f\u00059B/Z:u\tVl\u0007\u000fV5nK&sG-\u001a=FeJ|'o\u001d\u0015\u0004;\u0005\u0015\u0014a\u0006;fgR$U/\u001c9NKR\fG-\u0019;b%\u0016\u001cwN\u001d3tQ\rq\u0012QM\u0001\u0019i\u0016\u001cH\u000fR;na6+G/\u00193bi\u0006\u001cf.\u00199tQ>$\bfA\u0010\u0002f\u0005\u0011B/Z:u\tVl\u0007/R7qifLe\u000eZ3yQ\r\u0001\u0013QM\u0001\u0013eVtG)^7q\u0019><7+Z4nK:$8\u000fF\u0002`\u0003\u000fCq!!#\"\u0001\u0004\tY)\u0001\u0003be\u001e\u001c\b\u0003\u0002 \u0002\u000e~K1!a$@\u0005\u0015\t%O]1z\u0003y!Xm\u001d;Qe&tG\u000fR1uC2{w\rU1si&\fGNQ1uG\",7\u000fK\u0002#\u0003K\n\u0001\u0004^3ti>3gm]3ug6+7o]1hKB\u000b'o]3sQ\r\u0019\u0013QM\u0001\u000fi\u0016\u001cHOT3x\t\u0016\u001cw\u000eZ3sQ\r!\u0013QM\u0001\"i\u0016\u001cHoQ8om\u0016\u0014H\u000fR3qe\u0016\u001c\u0017\r^3e\t\u0016\u001cw\u000eZ3s\u00072\f7o\u001d\u0015\u0004K\u0005\u0015\u0014!\u0005:fC\u0012\u0014\u0015\r^2i\u001b\u0016$\u0018\rZ1uCR!\u0011QUAV!\u0011q\u0014qU0\n\u0007\u0005%vH\u0001\u0004PaRLwN\u001c\u0005\b\u0003[3\u0003\u0019AAX\u0003\u0015a\u0017N\\3t!\u0015\t\t,!.`\u001b\t\t\u0019L\u0003\u0002v\u001b&!\u0011qWAZ\u00051a\u0015n\u001d;Ji\u0016\u0014\u0018\r^8s\u0003]\u0011X-\u00193QCJ$\u0018.\u00197CCR\u001c\u0007.Z:CsR,7\u000f\u0006\u0004\u0002>\u0006\r\u0017Q\u0019\t\u0004}\u0005}\u0016bAAa\u007f\t\u0019\u0011J\u001c;\t\u000f\u00055v\u00051\u0001\u00020\"9\u0011qY\u0014A\u0002\u0005u\u0016!\u00027j[&$\u0018\u0001D2pk:$()\u0019;dQ\u0016\u001cH\u0003BA_\u0003\u001bDq!!,)\u0001\u0004\ty+\u0001\tsK\u0006$')\u0019;dQJ+7m\u001c:egR!\u00111[As!\u0015\t).a8`\u001d\u0011\t9.a7\u000f\u0007\t\fI.C\u0001A\u0013\r\tinP\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\t\t/a9\u0003\u0007M+\u0017OC\u0002\u0002^~Bq!!,*\u0001\u0004\ty+A\nqCJ\u001cX-T3uC\u0012\fG/\u0019$jK2$7\u000f\u0006\u0003\u0002l\u0006E\b#\u00021\u0002n~{\u0016bAAxQ\n\u0019Q*\u00199\t\r\u0005M(\u00061\u0001`\u0003\u0011a\u0017N\\3\u00027\u0005\u001c8/\u001a:u\tVl\u0007\u000fT8h%\u0016\u001cwN\u001d3NKR\fG-\u0019;b\u0003M!U/\u001c9M_\u001e\u001cVmZ7f]R\u001cH+Z:u!\t1Uf\u0005\u0002.{Q\u0011\u0011\u0011 \u0002\f)\u0016\u001cH\u000fR3d_\u0012,'o\u0005\u00030{\t\r\u0001C\u0002B\u0003\u0005\u0017\u0011y!\u0004\u0002\u0003\b)\u0019!\u0011B\u001d\u0002\u0015M,'/[1mSj,'/\u0003\u0003\u0003\u000e\t\u001d!a\u0002#fG>$WM\u001d\t\u0006}\u00055%\u0011\u0003\t\u0004}\tM\u0011b\u0001B\u000b\u007f\t!!)\u001f;f\u0003\u0015\u0001(o\u001c9t!\u0011\u0011YB!\t\u000e\u0005\tu!b\u0001B\u0010s\u0005)Q\u000f^5mg&!!1\u0005B\u000f\u0005Q1VM]5gS\u0006\u0014G.\u001a)s_B,'\u000f^5fgR!!q\u0005B\u0016!\r\u0011IcL\u0007\u0002[!9!qC\u0019A\u0002\te\u0011!\u00034s_6\u0014\u0015\u0010^3t)\u0011\u0011yA!\r\t\u000f\tM\"\u00071\u0001\u0003\u0010\u0005)!-\u001f;fg\n1C+Z:u\t\u0016\u001cw\u000eZ3s/&$\bn\\;u-\u0016\u0014\u0018NZ5bE2,\u0007K]8qKJ$\u0018.Z:\u0014\tMj$1\u0001\u000b\u0003\u0005w\u00012A!\u000b4)\u0011\u0011yAa\u0010\t\u000f\tMR\u00071\u0001\u0003\u0010\u0001")
public class DumpLogSegmentsTest {
    private final File tmpDir = TestUtils$.MODULE$.tempDir();
    private final File logDir = TestUtils$.MODULE$.randomPartitionLogDir(this.tmpDir());
    private final String segmentName;
    private final String logFilePath = new StringBuilder(5).append(this.logDir()).append("/").append(this.segmentName()).append(".log").toString();
    private final String snapshotPath = new StringBuilder(43).append(this.logDir()).append("/00000000000000000000-0000000000.checkpoint").toString();
    private final String indexFilePath = new StringBuilder(7).append(this.logDir()).append("/").append(this.segmentName()).append(".index").toString();
    private final String timeIndexFilePath = new StringBuilder(11).append(this.logDir()).append("/").append(this.segmentName()).append(".timeindex").toString();
    private final MockTime time = new MockTime(0L, 0L);
    private final ArrayBuffer<BatchInfo> batches = new ArrayBuffer();
    private UnifiedLog log;

    public File tmpDir() {
        return this.tmpDir;
    }

    public File logDir() {
        return this.logDir;
    }

    public String segmentName() {
        return this.segmentName;
    }

    public String logFilePath() {
        return this.logFilePath;
    }

    public String snapshotPath() {
        return this.snapshotPath;
    }

    public String indexFilePath() {
        return this.indexFilePath;
    }

    public String timeIndexFilePath() {
        return this.timeIndexFilePath;
    }

    public MockTime time() {
        return this.time;
    }

    public ArrayBuffer<BatchInfo> batches() {
        return this.batches;
    }

    public UnifiedLog log() {
        return this.log;
    }

    public void log_$eq(UnifiedLog x$1) {
        this.log = x$1;
    }

    @BeforeEach
    public void setUp() {
        Properties props = new Properties();
        props.setProperty("index.interval.bytes", "128");
        File x$1 = this.logDir();
        LogConfig x$2 = new LogConfig((Map)props);
        long x$3 = 0L;
        long x$4 = 0L;
        MockScheduler x$5 = this.time().scheduler;
        MockTime x$6 = this.time();
        BrokerTopicStats x$7 = new BrokerTopicStats(BrokerTopicStats$.MODULE$.$lessinit$greater$default$1());
        int x$8 = 300000;
        ProducerStateManagerConfig x$9 = new ProducerStateManagerConfig(86400000, false);
        int x$10 = 600000;
        LogDirFailureChannel x$11 = new LogDirFailureChannel(10);
        None$ x$12 = None$.MODULE$;
        boolean x$13 = true;
        boolean x$14 = UnifiedLog$.MODULE$.apply$default$12();
        ConcurrentMap x$15 = UnifiedLog$.MODULE$.apply$default$15();
        boolean x$16 = UnifiedLog$.MODULE$.apply$default$16();
        LogOffsetsListener x$17 = UnifiedLog$.MODULE$.apply$default$17();
        this.log_$eq(UnifiedLog$.MODULE$.apply(x$1, x$2, x$3, x$4, (Scheduler)x$5, x$7, (Time)x$6, x$8, x$9, x$10, x$11, x$14, (Option)x$12, x$13, x$15, x$16, x$17));
    }

    public void addSimpleRecords() {
        long now = System.currentTimeMillis();
        IndexedSeq firstBatchRecords = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 10).map((Function1 & Serializable & scala.Serializable)i -> DumpLogSegmentsTest.$anonfun$addSimpleRecords$1(now, BoxesRunTime.unboxToInt((Object)i)), IndexedSeq$.MODULE$.canBuildFrom());
        this.batches().$plus$eq((Object)new BatchInfo((Seq<SimpleRecord>)firstBatchRecords, true, true));
        IndexedSeq secondBatchRecords = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(10), 30).map((Function1 & Serializable & scala.Serializable)i -> DumpLogSegmentsTest.$anonfun$addSimpleRecords$2(now, BoxesRunTime.unboxToInt((Object)i)), IndexedSeq$.MODULE$.canBuildFrom());
        this.batches().$plus$eq((Object)new BatchInfo((Seq<SimpleRecord>)secondBatchRecords, true, false));
        IndexedSeq thirdBatchRecords = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(30), 50).map((Function1 & Serializable & scala.Serializable)i -> DumpLogSegmentsTest.$anonfun$addSimpleRecords$3(now, BoxesRunTime.unboxToInt((Object)i)), IndexedSeq$.MODULE$.canBuildFrom());
        this.batches().$plus$eq((Object)new BatchInfo((Seq<SimpleRecord>)thirdBatchRecords, false, true));
        IndexedSeq fourthBatchRecords = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(50), 60).map((Function1 & Serializable & scala.Serializable)i -> DumpLogSegmentsTest.$anonfun$addSimpleRecords$4(now, BoxesRunTime.unboxToInt((Object)i)), IndexedSeq$.MODULE$.canBuildFrom());
        this.batches().$plus$eq((Object)new BatchInfo((Seq<SimpleRecord>)fourthBatchRecords, false, false));
        this.batches().foreach((Function1 & Serializable & scala.Serializable)batchInfo -> {
            UnifiedLog qual$1 = this.log();
            MemoryRecords x$1 = MemoryRecords.withRecords((Compression)Compression.NONE, (int)0, (SimpleRecord[])((SimpleRecord[])batchInfo.records().toArray(ClassTag$.MODULE$.apply(SimpleRecord.class))));
            int x$2 = 0;
            AppendOrigin x$3 = qual$1.appendAsLeader$default$3();
            MetadataVersion x$4 = qual$1.appendAsLeader$default$4();
            RequestLocal x$5 = qual$1.appendAsLeader$default$5();
            VerificationGuard x$6 = qual$1.appendAsLeader$default$6();
            return qual$1.appendAsLeader(x$1, x$2, x$3, x$4, x$5, x$6);
        });
        this.log().flush(false);
    }

    @AfterEach
    public void tearDown() {
        Utils.closeQuietly((AutoCloseable)this.log(), (String)"UnifiedLog");
        Utils.delete((File)this.tmpDir());
    }

    @Test
    public void testBatchAndRecordMetadataOutput() {
        UnifiedLog qual$1 = this.log();
        MemoryRecords x$1 = MemoryRecords.withRecords((Compression)Compression.NONE, (int)0, (SimpleRecord[])new SimpleRecord[]{new SimpleRecord("a".getBytes()), new SimpleRecord("b".getBytes())});
        int x$2 = 0;
        AppendOrigin x$3 = qual$1.appendAsLeader$default$3();
        MetadataVersion x$4 = qual$1.appendAsLeader$default$4();
        RequestLocal x$5 = qual$1.appendAsLeader$default$5();
        VerificationGuard x$6 = qual$1.appendAsLeader$default$6();
        qual$1.appendAsLeader(x$1, x$2, x$3, x$4, x$5, x$6);
        UnifiedLog qual$2 = this.log();
        MemoryRecords x$7 = MemoryRecords.withRecords((Compression)Compression.gzip().build(), (int)0, (SimpleRecord[])new SimpleRecord[]{new SimpleRecord(this.time().milliseconds(), "c".getBytes(), "1".getBytes()), new SimpleRecord("d".getBytes())});
        int x$8 = 3;
        AppendOrigin x$9 = qual$2.appendAsLeader$default$3();
        MetadataVersion x$10 = qual$2.appendAsLeader$default$4();
        RequestLocal x$11 = qual$2.appendAsLeader$default$5();
        VerificationGuard x$12 = qual$2.appendAsLeader$default$6();
        qual$2.appendAsLeader(x$7, x$8, x$9, x$10, x$11, x$12);
        UnifiedLog qual$3 = this.log();
        MemoryRecords x$13 = MemoryRecords.withRecords((Compression)Compression.NONE, (int)0, (SimpleRecord[])new SimpleRecord[]{new SimpleRecord("e".getBytes(), null), new SimpleRecord(null, "f".getBytes()), new SimpleRecord("g".getBytes())});
        int x$14 = 3;
        AppendOrigin x$15 = qual$3.appendAsLeader$default$3();
        MetadataVersion x$16 = qual$3.appendAsLeader$default$4();
        RequestLocal x$17 = qual$3.appendAsLeader$default$5();
        VerificationGuard x$18 = qual$3.appendAsLeader$default$6();
        qual$3.appendAsLeader(x$13, x$14, x$15, x$16, x$17, x$18);
        UnifiedLog qual$4 = this.log();
        MemoryRecords x$19 = MemoryRecords.withIdempotentRecords((Compression)Compression.NONE, (long)29342342L, (short)((short)15), (int)234123, (SimpleRecord[])new SimpleRecord[]{new SimpleRecord("h".getBytes())});
        int x$20 = 3;
        AppendOrigin x$21 = qual$4.appendAsLeader$default$3();
        MetadataVersion x$22 = qual$4.appendAsLeader$default$4();
        RequestLocal x$23 = qual$4.appendAsLeader$default$5();
        VerificationGuard x$24 = qual$4.appendAsLeader$default$6();
        qual$4.appendAsLeader(x$19, x$20, x$21, x$22, x$23, x$24);
        UnifiedLog qual$5 = this.log();
        MemoryRecords x$25 = MemoryRecords.withTransactionalRecords((Compression)Compression.gzip().build(), (long)98323L, (short)((short)99), (int)266, (SimpleRecord[])new SimpleRecord[]{new SimpleRecord("i".getBytes()), new SimpleRecord("j".getBytes())});
        int x$26 = 5;
        AppendOrigin x$27 = qual$5.appendAsLeader$default$3();
        MetadataVersion x$28 = qual$5.appendAsLeader$default$4();
        RequestLocal x$29 = qual$5.appendAsLeader$default$5();
        VerificationGuard x$30 = qual$5.appendAsLeader$default$6();
        qual$5.appendAsLeader(x$25, x$26, x$27, x$28, x$29, x$30);
        UnifiedLog qual$6 = this.log();
        MemoryRecords x$31 = MemoryRecords.withEndTransactionMarker((long)98323L, (short)((short)99), (EndTransactionMarker)new EndTransactionMarker(ControlRecordType.COMMIT, 100));
        AppendOrigin x$32 = AppendOrigin.COORDINATOR;
        int x$33 = 7;
        MetadataVersion x$34 = qual$6.appendAsLeader$default$4();
        RequestLocal x$35 = qual$6.appendAsLeader$default$5();
        VerificationGuard x$36 = qual$6.appendAsLeader$default$6();
        qual$6.appendAsLeader(x$31, x$33, x$32, x$34, x$35, x$36);
        this.assertDumpLogRecordMetadata();
    }

    @Test
    public void testPrintDataLog() {
        this.addSimpleRecords();
        this.verifyRecordsInOutput$1(true, (String[])((Object[])new String[]{"--print-data-log", "--files", this.logFilePath()}));
        this.verifyRecordsInOutput$1(true, (String[])((Object[])new String[]{"--print-data-log", "--deep-iteration", "--files", this.logFilePath()}));
        this.verifyRecordsInOutput$1(true, (String[])((Object[])new String[]{"--value-decoder-class", "kafka.serializer.StringDecoder", "--files", this.logFilePath()}));
        this.verifyRecordsInOutput$1(true, (String[])((Object[])new String[]{"--key-decoder-class", "kafka.serializer.StringDecoder", "--files", this.logFilePath()}));
        this.verifyRecordsInOutput$1(false, (String[])((Object[])new String[]{"--deep-iteration", "--files", this.logFilePath()}));
        this.verifyNoRecordsInOutput$1((String[])((Object[])new String[]{"--files", this.logFilePath()}));
    }

    @Test
    public void testDumpIndexMismatches() {
        this.addSimpleRecords();
        scala.collection.mutable.Map offsetMismatches = (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
        DumpLogSegments$.MODULE$.dumpIndex(new File(this.indexFilePath()), false, true, offsetMismatches, Integer.MAX_VALUE);
        Assertions.assertEquals((Object)Predef$.MODULE$.Map().empty(), (Object)offsetMismatches);
    }

    @Test
    public void testDumpTimeIndexErrors() {
        this.addSimpleRecords();
        DumpLogSegments.TimeIndexDumpErrors errors = new DumpLogSegments.TimeIndexDumpErrors();
        DumpLogSegments$.MODULE$.dumpTimeIndex(new File(this.timeIndexFilePath()), false, true, errors);
        Assertions.assertEquals((Object)Predef$.MODULE$.Map().empty(), (Object)errors.misMatchesForTimeIndexFilesMap());
        Assertions.assertEquals((Object)Predef$.MODULE$.Map().empty(), (Object)errors.outOfOrderTimestamp());
        Assertions.assertEquals((Object)Predef$.MODULE$.Map().empty(), (Object)errors.shallowOffsetNotFound());
    }

    @Test
    public void testDumpMetadataRecords() {
        MockTime mockTime = new MockTime();
        int x$1 = 0x100000;
        long x$2 = LogTestUtils$.MODULE$.createLogConfig$default$1();
        long x$3 = LogTestUtils$.MODULE$.createLogConfig$default$3();
        long x$4 = LogTestUtils$.MODULE$.createLogConfig$default$4();
        long x$5 = LogTestUtils$.MODULE$.createLogConfig$default$5();
        long x$6 = LogTestUtils$.MODULE$.createLogConfig$default$6();
        long x$7 = LogTestUtils$.MODULE$.createLogConfig$default$7();
        String x$8 = LogTestUtils$.MODULE$.createLogConfig$default$8();
        int x$9 = LogTestUtils$.MODULE$.createLogConfig$default$9();
        int x$10 = LogTestUtils$.MODULE$.createLogConfig$default$10();
        int x$11 = LogTestUtils$.MODULE$.createLogConfig$default$11();
        long x$12 = LogTestUtils$.MODULE$.createLogConfig$default$12();
        boolean x$13 = LogTestUtils$.MODULE$.createLogConfig$default$13();
        LogConfig logConfig = LogTestUtils$.MODULE$.createLogConfig(x$2, x$1, x$3, x$4, x$5, x$6, x$7, x$8, x$9, x$10, x$11, x$12, x$13);
        this.log_$eq(LogTestUtils$.MODULE$.createLog(this.logDir(), logConfig, new BrokerTopicStats(BrokerTopicStats$.MODULE$.$lessinit$greater$default$1()), (Scheduler)mockTime.scheduler, (Time)mockTime, LogTestUtils$.MODULE$.createLog$default$6(), LogTestUtils$.MODULE$.createLog$default$7(), LogTestUtils$.MODULE$.createLog$default$8(), LogTestUtils$.MODULE$.createLog$default$9(), LogTestUtils$.MODULE$.createLog$default$10(), LogTestUtils$.MODULE$.createLog$default$11(), LogTestUtils$.MODULE$.createLog$default$12(), LogTestUtils$.MODULE$.createLog$default$13(), LogTestUtils$.MODULE$.createLog$default$14(), LogTestUtils$.MODULE$.createLog$default$15(), LogTestUtils$.MODULE$.createLog$default$16(), LogTestUtils$.MODULE$.createLog$default$17()));
        SimpleRecord[] records = (SimpleRecord[])((TraversableOnce)new .colon.colon((Object)new ApiMessageAndVersion((ApiMessage)new RegisterBrokerRecord().setBrokerId(0).setBrokerEpoch(10L), (short)0), (List)new .colon.colon((Object)new ApiMessageAndVersion((ApiMessage)new RegisterBrokerRecord().setBrokerId(1).setBrokerEpoch(20L), (short)0), (List)new .colon.colon((Object)new ApiMessageAndVersion((ApiMessage)new TopicRecord().setName("test-topic").setTopicId(Uuid.randomUuid()), (short)0), (List)new .colon.colon((Object)new ApiMessageAndVersion((ApiMessage)new PartitionChangeRecord().setTopicId(Uuid.randomUuid()).setLeader(1).setPartitionId(0).setIsr(Arrays.asList((Object[])new Integer[]{Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(2)})), (short)0), (List)Nil$.MODULE$)))).map((Function1 & Serializable & scala.Serializable)message -> {
            MetadataRecordSerde serde = MetadataRecordSerde.INSTANCE;
            ObjectSerializationCache cache = new ObjectSerializationCache();
            ByteBuffer buf = ByteBuffer.allocate(serde.recordSize(message, cache));
            ByteBufferAccessor writer = new ByteBufferAccessor(buf);
            serde.write(message, cache, (Writable)writer);
            buf.flip();
            return new SimpleRecord(null, buf.array());
        }, Seq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(SimpleRecord.class));
        UnifiedLog qual$1 = this.log();
        MemoryRecords x$14 = MemoryRecords.withRecords((Compression)Compression.NONE, (SimpleRecord[])records);
        int x$15 = 1;
        AppendOrigin x$16 = qual$1.appendAsLeader$default$3();
        MetadataVersion x$17 = qual$1.appendAsLeader$default$4();
        RequestLocal x$18 = qual$1.appendAsLeader$default$5();
        VerificationGuard x$19 = qual$1.appendAsLeader$default$6();
        qual$1.appendAsLeader(x$14, x$15, x$16, x$17, x$18, x$19);
        this.log().flush(false);
        String output = this.runDumpLogSegments((String[])((Object[])new String[]{"--cluster-metadata-decoder", "--files", this.logFilePath()}));
        Assertions.assertTrue((boolean)output.contains("Log starting offset: 0"));
        Assertions.assertTrue((boolean)output.contains("TOPIC_RECORD"));
        Assertions.assertTrue((boolean)output.contains("BROKER_RECORD"));
        output = this.runDumpLogSegments((String[])((Object[])new String[]{"--cluster-metadata-decoder", "--skip-record-metadata", "--files", this.logFilePath()}));
        Assertions.assertTrue((boolean)output.contains("TOPIC_RECORD"));
        Assertions.assertTrue((boolean)output.contains("BROKER_RECORD"));
        ByteBuffer buf = ByteBuffer.allocate(4);
        ByteBufferAccessor writer = new ByteBufferAccessor(buf);
        writer.writeUnsignedVarint(10000);
        writer.writeUnsignedVarint(10000);
        UnifiedLog qual$2 = this.log();
        MemoryRecords x$20 = MemoryRecords.withRecords((Compression)Compression.NONE, (SimpleRecord[])new SimpleRecord[]{new SimpleRecord(null, buf.array())});
        int x$21 = 2;
        AppendOrigin x$22 = qual$2.appendAsLeader$default$3();
        MetadataVersion x$23 = qual$2.appendAsLeader$default$4();
        RequestLocal x$24 = qual$2.appendAsLeader$default$5();
        VerificationGuard x$25 = qual$2.appendAsLeader$default$6();
        qual$2.appendAsLeader(x$20, x$21, x$22, x$23, x$24, x$25);
        UnifiedLog qual$3 = this.log();
        MemoryRecords x$26 = MemoryRecords.withRecords((Compression)Compression.NONE, (SimpleRecord[])records);
        int x$27 = 2;
        AppendOrigin x$28 = qual$3.appendAsLeader$default$3();
        MetadataVersion x$29 = qual$3.appendAsLeader$default$4();
        RequestLocal x$30 = qual$3.appendAsLeader$default$5();
        VerificationGuard x$31 = qual$3.appendAsLeader$default$6();
        qual$3.appendAsLeader(x$26, x$27, x$28, x$29, x$30, x$31);
        output = this.runDumpLogSegments((String[])((Object[])new String[]{"--cluster-metadata-decoder", "--skip-record-metadata", "--files", this.logFilePath()}));
        Assertions.assertTrue((boolean)output.contains("TOPIC_RECORD"));
        Assertions.assertTrue((boolean)output.contains("BROKER_RECORD"));
        Assertions.assertTrue((boolean)output.contains("skipping"));
    }

    @Test
    public void testDumpMetadataSnapshot() {
        .colon.colon metadataRecords = new .colon.colon((Object)new ApiMessageAndVersion((ApiMessage)new RegisterBrokerRecord().setBrokerId(0).setBrokerEpoch(10L), (short)0), (List)new .colon.colon((Object)new ApiMessageAndVersion((ApiMessage)new RegisterBrokerRecord().setBrokerId(1).setBrokerEpoch(20L), (short)0), (List)new .colon.colon((Object)new ApiMessageAndVersion((ApiMessage)new TopicRecord().setName("test-topic").setTopicId(Uuid.randomUuid()), (short)0), (List)new .colon.colon((Object)new ApiMessageAndVersion((ApiMessage)new PartitionChangeRecord().setTopicId(Uuid.randomUuid()).setLeader(1).setPartitionId(0).setIsr(Arrays.asList((Object[])new Integer[]{Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(2)})), (short)0), (List)Nil$.MODULE$))));
        KafkaMetadataLog metadataLog = KafkaMetadataLog$.MODULE$.apply(KafkaRaftServer$.MODULE$.MetadataPartition(), KafkaRaftServer$.MODULE$.MetadataTopicId(), this.logDir(), (Time)this.time(), (Scheduler)this.time().scheduler, new MetadataLogConfig(102400, 102400, 10000L, 102400L, 60000L, 0x800000, 0x800000, 60000L, 1));
        int lastContainedLogTimestamp = 10000;
        Using$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> new RecordsSnapshotWriter.Builder().setTime((Time)new MockTime()).setLastContainedLogTimestamp((long)lastContainedLogTimestamp).setRawSnapshotWriter((RawSnapshotWriter)metadataLog.createNewSnapshot(new OffsetAndEpoch(0L, 0)).get()).setKraftVersion((short)1).setVoterSet(Optional.of(VoterSetTest.voterSet((Map)VoterSetTest.voterMap((IntStream)IntStream.of(1, 2, 3), (boolean)true)))).build((RecordSerde)MetadataRecordSerde.INSTANCE), arg_0 -> DumpLogSegmentsTest.$anonfun$testDumpMetadataSnapshot$2$adapted((Seq)metadataRecords, arg_0), (Using.Releasable)Using.Releasable$.AutoCloseableIsReleasable$.MODULE$);
        String output = this.runDumpLogSegments((String[])((Object[])new String[]{"--cluster-metadata-decoder", "--files", this.snapshotPath()}));
        Assertions.assertTrue((boolean)output.contains("Snapshot end offset: 0, epoch: 0"), (String)output);
        Assertions.assertTrue((boolean)output.contains("TOPIC_RECORD"), (String)output);
        Assertions.assertTrue((boolean)output.contains("BROKER_RECORD"), (String)output);
        Assertions.assertTrue((boolean)output.contains("SnapshotHeader"), (String)output);
        Assertions.assertTrue((boolean)output.contains("SnapshotFooter"), (String)output);
        Assertions.assertTrue((boolean)output.contains("KRaftVersion"), (String)output);
        Assertions.assertTrue((boolean)output.contains("KRaftVoters"), (String)output);
        Assertions.assertTrue((boolean)output.contains(new StringBuilder(28).append("\"lastContainedLogTimestamp\":").append(lastContainedLogTimestamp).toString()), (String)output);
        output = this.runDumpLogSegments((String[])((Object[])new String[]{"--cluster-metadata-decoder", "--skip-record-metadata", "--files", this.snapshotPath()}));
        Assertions.assertTrue((boolean)output.contains("Snapshot end offset: 0, epoch: 0"), (String)output);
        Assertions.assertTrue((boolean)output.contains("TOPIC_RECORD"), (String)output);
        Assertions.assertTrue((boolean)output.contains("BROKER_RECORD"), (String)output);
        Assertions.assertFalse((boolean)output.contains("SnapshotHeader"), (String)output);
        Assertions.assertFalse((boolean)output.contains("SnapshotFooter"), (String)output);
        Assertions.assertFalse((boolean)output.contains("KRaftVersion"), (String)output);
        Assertions.assertFalse((boolean)output.contains("KRaftVoters"), (String)output);
        Assertions.assertFalse((boolean)output.contains(new StringBuilder(29).append("\"lastContainedLogTimestamp\": ").append(lastContainedLogTimestamp).toString()), (String)output);
    }

    @Test
    public void testDumpEmptyIndex() {
        File indexFile = new File(this.indexFilePath());
        new PrintWriter(indexFile).close();
        String expectOutput = new StringBuilder(11).append(indexFile).append(" is empty.\n").toString();
        ByteArrayOutputStream outContent = new ByteArrayOutputStream();
        Console$.MODULE$.withOut((OutputStream)outContent, (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> DumpLogSegments$.MODULE$.dumpIndex(indexFile, false, true, (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$), Integer.MAX_VALUE));
        Assertions.assertEquals((Object)expectOutput, (Object)outContent.toString());
    }

    private String runDumpLogSegments(String[] args) {
        ByteArrayOutputStream outContent = new ByteArrayOutputStream();
        Console$.MODULE$.withOut((OutputStream)outContent, (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> DumpLogSegments$.MODULE$.main(args));
        return outContent.toString();
    }

    @Test
    public void testPrintDataLogPartialBatches() {
        this.addSimpleRecords();
        int partialBatches = this.batches().size() / 2;
        ListIterator<Object> lines = Arrays.asList((Object[])this.runDumpLogSegments((String[])((Object[])new String[]{"--files", this.logFilePath()})).split("\n")).listIterator();
        int partialBatchesBytes = this.readPartialBatchesBytes(lines, partialBatches);
        ListIterator<Object> partialLines = Arrays.asList((Object[])this.runDumpLogSegments((String[])((Object[])new String[]{"--max-bytes", Integer.toString(partialBatchesBytes), "--files", this.logFilePath()})).split("\n")).listIterator();
        int partialBatchesCount = this.countBatches(partialLines);
        Assertions.assertEquals((int)partialBatches, (int)partialBatchesCount);
    }

    @Test
    public void testOffsetsMessageParser() {
        CoordinatorRecordSerde serde = new CoordinatorRecordSerde();
        DumpLogSegments.OffsetsMessageParser parser = new DumpLogSegments.OffsetsMessageParser();
        Assertions.assertEquals((Object)"Failed to decode message at offset 0 using offset topic decoder (message had a missing key)", (Object)Assertions.assertThrows(RuntimeException.class, () -> {
            Compression x$3 = TestUtils$.MODULE$.singletonRecords$default$3();
            long x$4 = TestUtils$.MODULE$.singletonRecords$default$4();
            byte x$5 = TestUtils$.MODULE$.singletonRecords$default$5();
            parser.parse((Record)TestUtils$.MODULE$.singletonRecords(null, null, x$3, x$4, x$5).records().iterator().next());
        }).getMessage());
        Assertions.assertEquals((Object)new Tuple2((Object)new Some((Object)"{\"type\":\"3\",\"data\":{\"groupId\":\"group\"}}"), (Object)new Some((Object)"{\"version\":\"0\",\"data\":{\"epoch\":10}}")), (Object)parser.parse(DumpLogSegmentsTest.serializedRecord$1(new ApiMessageAndVersion((ApiMessage)new ConsumerGroupMetadataKey().setGroupId("group"), (short)3), new ApiMessageAndVersion((ApiMessage)new ConsumerGroupMetadataValue().setEpoch(10), (short)0), serde)));
        Assertions.assertEquals((Object)new Tuple2((Object)new Some((Object)"{\"type\":\"2\",\"data\":{\"group\":\"group\"}}"), (Object)new Some((Object)"{\"version\":\"4\",\"data\":{\"protocolType\":\"consumer\",\"generation\":10,\"protocol\":\"range\",\"leader\":\"member\",\"currentStateTimestamp\":-1,\"members\":[{\"memberId\":\"member\",\"groupInstanceId\":\"instance\",\"clientId\":\"client\",\"clientHost\":\"host\",\"rebalanceTimeout\":1000,\"sessionTimeout\":100,\"subscription\":{\"topics\":[\"foo\"],\"userData\":null,\"ownedPartitions\":[{\"topic\":\"foo\",\"partitions\":[0]}],\"generationId\":0,\"rackId\":\"rack\"},\"assignment\":{\"assignedPartitions\":[{\"topic\":\"foo\",\"partitions\":[0]}],\"userData\":null}}]}}")), (Object)parser.parse(DumpLogSegmentsTest.serializedRecord$1(new ApiMessageAndVersion((ApiMessage)new GroupMetadataKey().setGroup("group"), (short)2), new ApiMessageAndVersion((ApiMessage)new GroupMetadataValue().setProtocolType("consumer").setProtocol("range").setLeader("member").setGeneration(10).setMembers(Collections.singletonList(new GroupMetadataValue.MemberMetadata().setMemberId("member").setClientId("client").setClientHost("host").setGroupInstanceId("instance").setSessionTimeout(100).setRebalanceTimeout(1000).setSubscription(Utils.toArray((ByteBuffer)ConsumerProtocol.serializeSubscription((ConsumerPartitionAssignor.Subscription)new ConsumerPartitionAssignor.Subscription(Collections.singletonList("foo"), null, Collections.singletonList(new TopicPartition("foo", 0)), 0, Optional.of("rack"))))).setAssignment(Utils.toArray((ByteBuffer)ConsumerProtocol.serializeAssignment((ConsumerPartitionAssignor.Assignment)new ConsumerPartitionAssignor.Assignment(Collections.singletonList(new TopicPartition("foo", 0)))))))), 4), serde)));
        Assertions.assertEquals((Object)new Tuple2((Object)new Some((Object)"{\"type\":\"2\",\"data\":{\"group\":\"group\"}}"), (Object)new Some((Object)"{\"version\":\"4\",\"data\":{\"protocolType\":\"consumer\",\"generation\":10,\"protocol\":\"range\",\"leader\":\"member\",\"currentStateTimestamp\":-1,\"members\":[{\"memberId\":\"member\",\"groupInstanceId\":\"instance\",\"clientId\":\"client\",\"clientHost\":\"host\",\"rebalanceTimeout\":1000,\"sessionTimeout\":100,\"subscription\":\"U3Vic2NyaXB0aW9u\",\"assignment\":\"QXNzaWdubWVudA==\"}]}}")), (Object)parser.parse(DumpLogSegmentsTest.serializedRecord$1(new ApiMessageAndVersion((ApiMessage)new GroupMetadataKey().setGroup("group"), (short)2), new ApiMessageAndVersion((ApiMessage)new GroupMetadataValue().setProtocolType("consumer").setProtocol("range").setLeader("member").setGeneration(10).setMembers(Collections.singletonList(new GroupMetadataValue.MemberMetadata().setMemberId("member").setClientId("client").setClientHost("host").setGroupInstanceId("instance").setSessionTimeout(100).setRebalanceTimeout(1000).setSubscription("Subscription".getBytes()).setAssignment("Assignment".getBytes()))), 4), serde)));
        Assertions.assertEquals((Object)new Tuple2((Object)new Some((Object)"{\"type\":\"3\",\"data\":{\"groupId\":\"group\"}}"), (Object)new Some((Object)"<DELETE>")), (Object)parser.parse(DumpLogSegmentsTest.serializedRecord$1(new ApiMessageAndVersion((ApiMessage)new ConsumerGroupMetadataKey().setGroupId("group"), (short)3), null, serde)));
        Assertions.assertEquals((Object)new Tuple2((Object)new Some((Object)"Unknown record type 32767 at offset 0, skipping."), (Object)None$.MODULE$), (Object)parser.parse(DumpLogSegmentsTest.serializedRecord$1(new ApiMessageAndVersion((ApiMessage)new ConsumerGroupMetadataKey().setGroupId("group"), Short.MAX_VALUE), new ApiMessageAndVersion((ApiMessage)new ConsumerGroupMetadataValue().setEpoch(10), (short)0), serde)));
        Assertions.assertEquals((Object)new Tuple2((Object)new Some((Object)"Error at offset 0, skipping. Could not read record with version 0 from value's buffer due to: Error reading byte array of 536870911 byte(s): only 1 byte(s) available."), (Object)None$.MODULE$), (Object)parser.parse(DumpLogSegmentsTest.serializedRecord$1(new ApiMessageAndVersion((ApiMessage)new ConsumerGroupMetadataKey().setGroupId("group"), (short)3), new ApiMessageAndVersion((ApiMessage)new ConsumerGroupMemberMetadataValue(), (short)0), serde)));
    }

    @Test
    public void testNewDecoder() {
        DumpLogSegments$.MODULE$.newDecoder(TestDecoder.class.getName());
        DumpLogSegments$.MODULE$.newDecoder(kafka.serializer.DefaultDecoder.class.getName());
        Assertions.assertThrows(Exception.class, () -> DumpLogSegments$.MODULE$.newDecoder(TestDecoderWithoutVerifiableProperties.class.getName()));
    }

    @Test
    public void testConvertDeprecatedDecoderClass() {
        Assertions.assertEquals((Object)DefaultDecoder.class.getName(), (Object)DumpLogSegments$.MODULE$.convertDeprecatedDecoderClass(kafka.serializer.DefaultDecoder.class.getName()));
        Assertions.assertEquals((Object)org.apache.kafka.tools.api.IntegerDecoder.class.getName(), (Object)DumpLogSegments$.MODULE$.convertDeprecatedDecoderClass(IntegerDecoder.class.getName()));
        Assertions.assertEquals((Object)org.apache.kafka.tools.api.LongDecoder.class.getName(), (Object)DumpLogSegments$.MODULE$.convertDeprecatedDecoderClass(LongDecoder.class.getName()));
        Assertions.assertEquals((Object)org.apache.kafka.tools.api.StringDecoder.class.getName(), (Object)DumpLogSegments$.MODULE$.convertDeprecatedDecoderClass(StringDecoder.class.getName()));
    }

    private Option<String> readBatchMetadata(ListIterator<String> lines) {
        while (lines.hasNext()) {
            String line = lines.next();
            if (line.startsWith("|")) {
                throw new IllegalStateException("Read unexpected record entry");
            }
            if (!line.startsWith("baseOffset")) continue;
            return new Some((Object)line);
        }
        return None$.MODULE$;
    }

    private int readPartialBatchesBytes(ListIterator<String> lines, int limit) {
        Regex sizePattern = new StringOps(Predef$.MODULE$.augmentString(".+?size:\\s(\\d+).+")).r();
        int batchesBytes = 0;
        int batchesCounter = 0;
        while (lines.hasNext()) {
            if (batchesCounter >= limit) {
                return batchesBytes;
            }
            String line = lines.next();
            if (!line.startsWith("baseOffset")) continue;
            Option option = sizePattern.unapplySeq((CharSequence)line);
            if (!option.isEmpty() && option.get() != null && ((LinearSeqOptimized)option.get()).lengthCompare(1) == 0) {
                String size = (String)((LinearSeqOptimized)option.get()).apply(0);
                batchesBytes += new StringOps(Predef$.MODULE$.augmentString(size)).toInt();
            } else {
                throw new IllegalStateException(new StringBuilder(52).append("Failed to parse and find size value for batch line: ").append(line).toString());
            }
            ++batchesCounter;
        }
        return batchesBytes;
    }

    private int countBatches(ListIterator<String> lines) {
        int countBatches = 0;
        while (lines.hasNext()) {
            if (!lines.next().startsWith("baseOffset")) continue;
            ++countBatches;
        }
        return countBatches;
    }

    private Seq<String> readBatchRecords(ListIterator<String> lines) {
        ArrayBuffer records = (ArrayBuffer)ArrayBuffer$.MODULE$.empty();
        while (lines.hasNext()) {
            String line = lines.next();
            if (line.startsWith("|")) {
                records.$plus$eq((Object)line.substring(1));
                continue;
            }
            lines.previous();
            return records.toSeq();
        }
        return records.toSeq();
    }

    private scala.collection.immutable.Map<String, String> parseMetadataFields(String line) {
        scala.collection.mutable.Map fields = Map$.MODULE$.empty();
        Iterator tokens = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])line.split("\\s+"))).map((Function1 & Serializable & scala.Serializable)x$3 -> x$3.trim(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).filter((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)DumpLogSegmentsTest.$anonfun$parseMetadataFields$2(x$4))))).iterator();
        while (tokens.hasNext()) {
            String token = (String)tokens.next();
            if (!token.endsWith(":")) {
                throw new IllegalStateException(new StringBuilder(27).append("Unexpected non-field token ").append(token).toString());
            }
            String field = token.substring(0, token.length() - 1);
            if (!tokens.hasNext()) {
                throw new IllegalStateException(new StringBuilder(26).append("Failed to parse value for ").append(field).toString());
            }
            String value = (String)tokens.next();
            fields.$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)field), (Object)value));
        }
        return fields.toMap(Predef$.MODULE$.$conforms());
    }

    private void assertDumpLogRecordMetadata() {
        FetchDataInfo logReadInfo = this.log().read(0L, Integer.MAX_VALUE, FetchIsolation.LOG_END, true);
        ListIterator<Object> lines = Arrays.asList((Object[])this.runDumpLogSegments((String[])((Object[])new String[]{"--deep-iteration", "--files", this.logFilePath()})).split("\n")).listIterator();
        ((IterableLike)CollectionConverters$.MODULE$.iterableAsScalaIterableConverter(logReadInfo.records.batches()).asScala()).foreach((Function1 & Serializable & scala.Serializable)batch -> {
            DumpLogSegmentsTest.$anonfun$assertDumpLogRecordMetadata$1(this, lines, batch);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ SimpleRecord $anonfun$addSimpleRecords$1(long now$1, int i) {
        return new SimpleRecord(now$1 + (long)(i * 2), new StringBuilder(12).append("message key ").append(i).toString().getBytes(), new StringBuilder(14).append("message value ").append(i).toString().getBytes());
    }

    public static final /* synthetic */ SimpleRecord $anonfun$addSimpleRecords$2(long now$1, int i) {
        return new SimpleRecord(now$1 + (long)(i * 3), new StringBuilder(12).append("message key ").append(i).toString().getBytes(), null);
    }

    public static final /* synthetic */ SimpleRecord $anonfun$addSimpleRecords$3(long now$1, int i) {
        return new SimpleRecord(now$1 + (long)(i * 5), null, new StringBuilder(14).append("message value ").append(i).toString().getBytes());
    }

    public static final /* synthetic */ SimpleRecord $anonfun$addSimpleRecords$4(long now$1, int i) {
        return new SimpleRecord(now$1 + (long)(i * 7), null);
    }

    public static final /* synthetic */ void $anonfun$testPrintDataLog$1(IntRef i$1, int index$1, Object nonLocalReturnKey1$1, Tuple2 x0$1) {
        if (x0$1 != null) {
            BatchInfo batch = (BatchInfo)x0$1._1();
            if (i$1.elem == index$1) {
                throw new NonLocalReturnControl.mcZ.sp(nonLocalReturnKey1$1, true);
            }
            ++i$1.elem;
            batch.records().indices().foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)x$1 -> {
                if (i$1.elem == index$1) {
                    throw new NonLocalReturnControl.mcZ.sp(nonLocalReturnKey1$1, false);
                }
                ++i$1.elem;
            });
            return;
        }
        throw new MatchError(null);
    }

    private final boolean isBatch$1(int index) {
        Object object = new Object();
        try {
            IntRef i = IntRef.create((int)0);
            ((ResizableArray)this.batches().zipWithIndex(ArrayBuffer$.MODULE$.canBuildFrom())).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
                DumpLogSegmentsTest.$anonfun$testPrintDataLog$1(i, index, object, x0$1);
                return BoxedUnit.UNIT;
            });
            throw new AssertionError((Object)new StringBuilder(19).append("No match for index ").append(index).toString());
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                return ex.value$mcZ$sp();
            }
            throw ex;
        }
    }

    public static final /* synthetic */ int $anonfun$testPrintDataLog$3(BatchInfo x$2) {
        return x$2.records().size();
    }

    private final void verifyRecordsInOutput$1(boolean checkKeysAndValues, String[] args) {
        String output = this.runDumpLogSegments(args);
        String[] lines = output.split("\n");
        Assertions.assertTrue((lines.length > 2 ? 1 : 0) != 0, (String)new StringBuilder(18).append("Data not printed: ").append(output).toString());
        int totalRecords = BoxesRunTime.unboxToInt((Object)((TraversableOnce)this.batches().map((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToInteger((int)DumpLogSegmentsTest.$anonfun$testPrintDataLog$3(x$2)), ArrayBuffer$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
        IntRef offset = IntRef.create((int)0);
        Iterator batchIterator = this.batches().iterator();
        ObjectRef batch = ObjectRef.create(null);
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), totalRecords + this.batches().size()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)index -> {
            String line = lines[lines.length - totalRecords - this.batches().size() + index];
            if (this.isBatch$1(index)) {
                Assertions.assertTrue((boolean)line.startsWith(new StringBuilder(25).append("baseOffset: ").append(offset$1.elem).append(" lastOffset: ").toString()), (String)new StringBuilder(40).append("Not a valid batch-level message record: ").append(line).toString());
                batch$1.elem = (BatchInfo)batchIterator.next();
                return;
            }
            Assertions.assertTrue((boolean)line.startsWith(new StringBuilder(9).append(DumpLogSegments$.MODULE$.RecordIndent()).append(" offset: ").append(offset$1.elem).toString()), (String)new StringBuilder(28).append("Not a valid message record: ").append(line).toString());
            if (checkKeysAndValues) {
                String suffix = "headerKeys: []";
                if (((BatchInfo)batch$1.elem).hasKeys()) {
                    suffix = new StringBuilder(18).append(suffix).append(" key: message key ").append(offset$1.elem).toString();
                }
                if (((BatchInfo)batch$1.elem).hasValues()) {
                    suffix = new StringBuilder(24).append(suffix).append(" payload: message value ").append(offset$1.elem).toString();
                }
                Assertions.assertTrue((boolean)line.endsWith(suffix), (String)new StringBuilder(37).append("Message record missing key or value: ").append(line).toString());
            }
            ++offset$1.elem;
        });
    }

    private final void verifyNoRecordsInOutput$1(String[] args) {
        String output = this.runDumpLogSegments(args);
        Assertions.assertFalse((boolean)output.matches("(?s).*offset: [0-9]* isvalid.*"), (String)new StringBuilder(35).append("Data should not have been printed: ").append(output).toString());
    }

    public static final /* synthetic */ long $anonfun$testDumpMetadataSnapshot$2(Seq metadataRecords$1, RecordsSnapshotWriter snapshotWriter) {
        snapshotWriter.append((java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter(metadataRecords$1).asJava());
        return snapshotWriter.freeze();
    }

    private static final Record serializedRecord$1(ApiMessageAndVersion key, ApiMessageAndVersion value, CoordinatorRecordSerde serde$1) {
        CoordinatorRecord record = new CoordinatorRecord(key, value);
        byte[] x$1 = serde$1.serializeKey(record);
        byte[] x$2 = serde$1.serializeValue(record);
        Compression x$3 = TestUtils$.MODULE$.singletonRecords$default$3();
        long x$4 = TestUtils$.MODULE$.singletonRecords$default$4();
        byte x$5 = TestUtils$.MODULE$.singletonRecords$default$5();
        return (Record)TestUtils$.MODULE$.singletonRecords(x$2, x$1, x$3, x$4, x$5).records().iterator().next();
    }

    public static final /* synthetic */ boolean $anonfun$parseMetadataFields$2(String x$4) {
        return new StringOps(Predef$.MODULE$.augmentString(x$4)).nonEmpty();
    }

    public static final /* synthetic */ long $anonfun$assertDumpLogRecordMetadata$2(String x$5) {
        return new StringOps(Predef$.MODULE$.augmentString(x$5)).toLong();
    }

    public static final /* synthetic */ long $anonfun$assertDumpLogRecordMetadata$3(String x$6) {
        return new StringOps(Predef$.MODULE$.augmentString(x$6)).toLong();
    }

    public static final /* synthetic */ long $anonfun$assertDumpLogRecordMetadata$4(String x$7) {
        return new StringOps(Predef$.MODULE$.augmentString(x$7)).toLong();
    }

    public static final /* synthetic */ int $anonfun$assertDumpLogRecordMetadata$5(String x$8) {
        return new StringOps(Predef$.MODULE$.augmentString(x$8)).toInt();
    }

    public static final /* synthetic */ boolean $anonfun$assertDumpLogRecordMetadata$6(String x$9) {
        return new StringOps(Predef$.MODULE$.augmentString(x$9)).toBoolean();
    }

    public static final /* synthetic */ boolean $anonfun$assertDumpLogRecordMetadata$7(String x$10) {
        return new StringOps(Predef$.MODULE$.augmentString(x$10)).toBoolean();
    }

    public static final /* synthetic */ long $anonfun$assertDumpLogRecordMetadata$8(String x$11) {
        return new StringOps(Predef$.MODULE$.augmentString(x$11)).toLong();
    }

    public static final /* synthetic */ short $anonfun$assertDumpLogRecordMetadata$9(String x$12) {
        return new StringOps(Predef$.MODULE$.augmentString(x$12)).toShort();
    }

    public static final /* synthetic */ int $anonfun$assertDumpLogRecordMetadata$10(String x$13) {
        return new StringOps(Predef$.MODULE$.augmentString(x$13)).toInt();
    }

    public static final /* synthetic */ long $anonfun$assertDumpLogRecordMetadata$12(String x$14) {
        return new StringOps(Predef$.MODULE$.augmentString(x$14)).toLong();
    }

    public static final /* synthetic */ int $anonfun$assertDumpLogRecordMetadata$13(String x$15) {
        return new StringOps(Predef$.MODULE$.augmentString(x$15)).toInt();
    }

    public static final /* synthetic */ int $anonfun$assertDumpLogRecordMetadata$14(String x$16) {
        return new StringOps(Predef$.MODULE$.augmentString(x$16)).toInt();
    }

    public static final /* synthetic */ long $anonfun$assertDumpLogRecordMetadata$15(String x$17) {
        return new StringOps(Predef$.MODULE$.augmentString(x$17)).toLong();
    }

    public static final /* synthetic */ int $anonfun$assertDumpLogRecordMetadata$16(String x$18) {
        return new StringOps(Predef$.MODULE$.augmentString(x$18)).toInt();
    }

    public static final /* synthetic */ void $anonfun$assertDumpLogRecordMetadata$11(DumpLogSegmentsTest $this, Iterator parsedRecordIter$1, RecordBatch batch$2, Record record) {
        Assertions.assertTrue((boolean)parsedRecordIter$1.hasNext());
        scala.collection.immutable.Map<String, String> parsedRecord = $this.parseMetadataFields((String)parsedRecordIter$1.next());
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToLong((long)record.offset())), (Object)parsedRecord.get((Object)"offset").map((Function1 & Serializable & scala.Serializable)x$14 -> BoxesRunTime.boxToLong((long)DumpLogSegmentsTest.$anonfun$assertDumpLogRecordMetadata$12(x$14))));
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToInteger((int)record.keySize())), (Object)parsedRecord.get((Object)"keySize").map((Function1 & Serializable & scala.Serializable)x$15 -> BoxesRunTime.boxToInteger((int)DumpLogSegmentsTest.$anonfun$assertDumpLogRecordMetadata$13(x$15))));
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToInteger((int)record.valueSize())), (Object)parsedRecord.get((Object)"valueSize").map((Function1 & Serializable & scala.Serializable)x$16 -> BoxesRunTime.boxToInteger((int)DumpLogSegmentsTest.$anonfun$assertDumpLogRecordMetadata$14(x$16))));
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToLong((long)record.timestamp())), (Object)parsedRecord.get((Object)batch$2.timestampType().name).map((Function1 & Serializable & scala.Serializable)x$17 -> BoxesRunTime.boxToLong((long)DumpLogSegmentsTest.$anonfun$assertDumpLogRecordMetadata$15(x$17))));
        if (batch$2.magic() >= RecordVersion.V2.value) {
            Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToInteger((int)record.sequence())), (Object)parsedRecord.get((Object)"sequence").map((Function1 & Serializable & scala.Serializable)x$18 -> BoxesRunTime.boxToInteger((int)DumpLogSegmentsTest.$anonfun$assertDumpLogRecordMetadata$16(x$18))));
        }
        Assertions.assertEquals((Object)None$.MODULE$, (Object)parsedRecord.get((Object)"baseOffset"));
        Assertions.assertEquals((Object)None$.MODULE$, (Object)parsedRecord.get((Object)"lastOffset"));
        Assertions.assertEquals((Object)None$.MODULE$, (Object)parsedRecord.get((Object)"partitionLeaderEpoch"));
        Assertions.assertEquals((Object)None$.MODULE$, (Object)parsedRecord.get((Object)"producerId"));
        Assertions.assertEquals((Object)None$.MODULE$, (Object)parsedRecord.get((Object)"producerEpoch"));
        Assertions.assertEquals((Object)None$.MODULE$, (Object)parsedRecord.get((Object)"baseSequence"));
        Assertions.assertEquals((Object)None$.MODULE$, (Object)parsedRecord.get((Object)"isTransactional"));
        Assertions.assertEquals((Object)None$.MODULE$, (Object)parsedRecord.get((Object)"isControl"));
        Assertions.assertEquals((Object)None$.MODULE$, (Object)parsedRecord.get((Object)"compresscodec"));
    }

    public static final /* synthetic */ void $anonfun$assertDumpLogRecordMetadata$1(DumpLogSegmentsTest $this, ListIterator lines$2, RecordBatch batch) {
        Option<String> parsedBatchOpt = $this.readBatchMetadata(lines$2);
        Assertions.assertTrue((boolean)parsedBatchOpt.isDefined());
        scala.collection.immutable.Map<String, String> parsedBatch = $this.parseMetadataFields((String)parsedBatchOpt.get());
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToLong((long)batch.baseOffset())), (Object)parsedBatch.get((Object)"baseOffset").map((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToLong((long)DumpLogSegmentsTest.$anonfun$assertDumpLogRecordMetadata$2(x$5))));
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToLong((long)batch.lastOffset())), (Object)parsedBatch.get((Object)"lastOffset").map((Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToLong((long)DumpLogSegmentsTest.$anonfun$assertDumpLogRecordMetadata$3(x$6))));
        Assertions.assertEquals((Object)Option$.MODULE$.apply((Object)batch.countOrNull()), (Object)parsedBatch.get((Object)"count").map((Function1 & Serializable & scala.Serializable)x$7 -> BoxesRunTime.boxToLong((long)DumpLogSegmentsTest.$anonfun$assertDumpLogRecordMetadata$4(x$7))));
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToInteger((int)batch.partitionLeaderEpoch())), (Object)parsedBatch.get((Object)"partitionLeaderEpoch").map((Function1 & Serializable & scala.Serializable)x$8 -> BoxesRunTime.boxToInteger((int)DumpLogSegmentsTest.$anonfun$assertDumpLogRecordMetadata$5(x$8))));
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToBoolean((boolean)batch.isTransactional())), (Object)parsedBatch.get((Object)"isTransactional").map((Function1 & Serializable & scala.Serializable)x$9 -> BoxesRunTime.boxToBoolean((boolean)DumpLogSegmentsTest.$anonfun$assertDumpLogRecordMetadata$6(x$9))));
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToBoolean((boolean)batch.isControlBatch())), (Object)parsedBatch.get((Object)"isControl").map((Function1 & Serializable & scala.Serializable)x$10 -> BoxesRunTime.boxToBoolean((boolean)DumpLogSegmentsTest.$anonfun$assertDumpLogRecordMetadata$7(x$10))));
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToLong((long)batch.producerId())), (Object)parsedBatch.get((Object)"producerId").map((Function1 & Serializable & scala.Serializable)x$11 -> BoxesRunTime.boxToLong((long)DumpLogSegmentsTest.$anonfun$assertDumpLogRecordMetadata$8(x$11))));
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToShort((short)batch.producerEpoch())), (Object)parsedBatch.get((Object)"producerEpoch").map((Function1 & Serializable & scala.Serializable)x$12 -> BoxesRunTime.boxToShort((short)DumpLogSegmentsTest.$anonfun$assertDumpLogRecordMetadata$9(x$12))));
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToInteger((int)batch.baseSequence())), (Object)parsedBatch.get((Object)"baseSequence").map((Function1 & Serializable & scala.Serializable)x$13 -> BoxesRunTime.boxToInteger((int)DumpLogSegmentsTest.$anonfun$assertDumpLogRecordMetadata$10(x$13))));
        Assertions.assertEquals((Object)new Some((Object)batch.compressionType().name), (Object)parsedBatch.get((Object)"compresscodec"));
        Iterator parsedRecordIter = $this.readBatchRecords(lines$2).iterator();
        ((IterableLike)CollectionConverters$.MODULE$.iterableAsScalaIterableConverter((Iterable)batch).asScala()).foreach((Function1 & Serializable & scala.Serializable)record -> {
            DumpLogSegmentsTest.$anonfun$assertDumpLogRecordMetadata$11($this, parsedRecordIter, batch, record);
            return BoxedUnit.UNIT;
        });
    }

    public DumpLogSegmentsTest() {
        this.segmentName = "00000000000000000000";
    }

    public static final /* synthetic */ Object $anonfun$testDumpMetadataSnapshot$2$adapted(Seq metadataRecords$1, RecordsSnapshotWriter snapshotWriter) {
        return BoxesRunTime.boxToLong((long)DumpLogSegmentsTest.$anonfun$testDumpMetadataSnapshot$2(metadataRecords$1, snapshotWriter));
    }

    public static class TestDecoder
    implements Decoder<byte[]> {
        public byte[] fromBytes(byte[] bytes) {
            return bytes;
        }

        public TestDecoder(VerifiableProperties props) {
        }
    }

    public static class TestDecoderWithoutVerifiableProperties
    implements Decoder<byte[]> {
        public byte[] fromBytes(byte[] bytes) {
            return bytes;
        }
    }
}

