/*
 * Decompiled with CFR 0.152.
 */
package kafka.utils;

import com.typesafe.scalalogging.Logger;
import com.yammer.metrics.core.Histogram;
import com.yammer.metrics.core.Meter;
import com.yammer.metrics.core.Metric;
import com.yammer.metrics.core.MetricName;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Serializable;
import java.net.InetAddress;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import java.util.Properties;
import java.util.Random;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import kafka.api.LeaderAndIsr$;
import kafka.cluster.EndPoint;
import kafka.cluster.Partition;
import kafka.controller.ControllerEventManager$;
import kafka.log.LogManager;
import kafka.log.UnifiedLog;
import kafka.log.UnifiedLog$;
import kafka.network.RequestChannel;
import kafka.server.BrokerServer;
import kafka.server.BrokerTopicStats;
import kafka.server.BrokerTopicStats$;
import kafka.server.ControllerServer;
import kafka.server.KafkaBroker;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.server.QuorumTestHarness$;
import kafka.server.checkpoints.OffsetCheckpointFile;
import kafka.server.checkpoints.OffsetCheckpointFile$;
import kafka.server.metadata.ConfigRepository;
import kafka.server.metadata.MockConfigRepository;
import kafka.tools.StorageTool$;
import kafka.utils.CoreUtils$;
import kafka.utils.Implicits;
import kafka.utils.Implicits$;
import kafka.utils.JaasTestUtils$;
import kafka.utils.Logging;
import kafka.utils.TestUtils;
import kafka.utils.TestUtils$Checkpoint$;
import kafka.utils.TestUtils$Roll$;
import kafka.zk.AdminZkClient;
import kafka.zk.AdminZkClient$;
import kafka.zk.KafkaZkClient;
import kafka.zk.ZkData$;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.clients.admin.AdminClientUnitTestEnv;
import org.apache.kafka.clients.admin.AlterConfigOp;
import org.apache.kafka.clients.admin.AlterConfigsResult;
import org.apache.kafka.clients.admin.ConfigEntry;
import org.apache.kafka.clients.admin.CreateTopicsResult;
import org.apache.kafka.clients.admin.NewTopic;
import org.apache.kafka.clients.admin.TopicDescription;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.clients.consumer.OffsetAndMetadata;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.clients.producer.RecordMetadata;
import org.apache.kafka.common.KafkaFuture;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.TopicPartitionInfo;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.acl.AccessControlEntry;
import org.apache.kafka.common.acl.AccessControlEntryFilter;
import org.apache.kafka.common.acl.AclBindingFilter;
import org.apache.kafka.common.compress.Compression;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.config.ConfigResource;
import org.apache.kafka.common.errors.KafkaStorageException;
import org.apache.kafka.common.errors.TopicExistsException;
import org.apache.kafka.common.errors.UnknownTopicOrPartitionException;
import org.apache.kafka.common.header.Header;
import org.apache.kafka.common.memory.MemoryPool;
import org.apache.kafka.common.message.UpdateMetadataRequestData;
import org.apache.kafka.common.metrics.KafkaMetric;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.network.ClientInformation;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.network.Mode;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.record.DefaultRecordBatch;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.MemoryRecordsBuilder;
import org.apache.kafka.common.record.SimpleRecord;
import org.apache.kafka.common.record.TimestampType;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.EnvelopeRequest;
import org.apache.kafka.common.requests.FetchRequest;
import org.apache.kafka.common.requests.RequestContext;
import org.apache.kafka.common.requests.RequestHeader;
import org.apache.kafka.common.resource.ResourcePattern;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.apache.kafka.common.security.auth.KafkaPrincipalSerde;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.serialization.ByteArrayDeserializer;
import org.apache.kafka.common.serialization.ByteArraySerializer;
import org.apache.kafka.common.serialization.Deserializer;
import org.apache.kafka.common.serialization.IntegerSerializer;
import org.apache.kafka.common.serialization.Serializer;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.metadata.bootstrap.BootstrapMetadata;
import org.apache.kafka.metadata.properties.MetaProperties;
import org.apache.kafka.server.authorizer.AuthorizableRequestContext;
import org.apache.kafka.server.authorizer.Authorizer;
import org.apache.kafka.server.common.ApiMessageAndVersion;
import org.apache.kafka.server.common.MetadataVersion;
import org.apache.kafka.server.config.ServerLogConfigs;
import org.apache.kafka.server.metrics.KafkaYammerMetrics;
import org.apache.kafka.server.util.MockScheduler;
import org.apache.kafka.server.util.MockTime;
import org.apache.kafka.server.util.Scheduler;
import org.apache.kafka.storage.internals.log.CleanerConfig;
import org.apache.kafka.storage.internals.log.LogConfig;
import org.apache.kafka.storage.internals.log.LogDirFailureChannel;
import org.apache.kafka.storage.internals.log.ProducerStateManagerConfig;
import org.apache.kafka.test.TestSslUtils;
import org.apache.kafka.test.TestUtils;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.data.ACL;
import org.junit.jupiter.api.Assertions;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenSeq;
import scala.collection.GenSet;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.IterableLike;
import scala.collection.Map;
import scala.collection.MapLike;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.Set$;
import scala.collection.SetLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.compat.MapExtensionMethods$;
import scala.collection.compat.package$;
import scala.collection.immutable.;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.Map$;
import scala.collection.mutable.Set;
import scala.collection.mutable.WrappedArray;
import scala.concurrent.Await$;
import scala.concurrent.Awaitable;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.FiniteDuration$;
import scala.jdk.CollectionConverters$;
import scala.math.Numeric;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LongRef;
import scala.runtime.Nothing$;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.RichLong$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;
import scala.util.Either;
import scala.util.Failure;
import scala.util.Left;
import scala.util.Properties$;
import scala.util.Right;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

public final class TestUtils$
implements Logging {
    public static TestUtils$ MODULE$;
    private final Random random;
    private final int RandomPort;
    private final int IncorrectBrokerPort;
    private final int MockZkPort;
    private final String MockZkConnect;
    private final String SslCertificateCn;
    private final String kafka$utils$TestUtils$$transactionStatusKey;
    private final byte[] kafka$utils$TestUtils$$committedValue;
    private final byte[] kafka$utils$TestUtils$$abortedValue;
    private final AuthorizableRequestContext anonymousAuthorizableContext;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    static {
        new TestUtils$();
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$((Logging)this, (String)msg);
    }

    public void trace(Function0<String> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$((Logging)this, msg, e);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void debug(Function0<String> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$((Logging)this, msg, e);
    }

    public void info(Function0<String> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$((Logging)this, msg, e);
    }

    public void warn(Function0<String> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$((Logging)this, msg, e);
    }

    public void error(Function0<String> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$((Logging)this, msg, e);
    }

    public void fatal(Function0<String> msg) {
        Logging.fatal$((Logging)this, msg);
    }

    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$((Logging)this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$((Logging)this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    public String logIdent() {
        return this.logIdent;
    }

    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public Random random() {
        return this.random;
    }

    public int RandomPort() {
        return this.RandomPort;
    }

    public int IncorrectBrokerPort() {
        return this.IncorrectBrokerPort;
    }

    public int MockZkPort() {
        return this.MockZkPort;
    }

    public String MockZkConnect() {
        return this.MockZkConnect;
    }

    public String SslCertificateCn() {
        return this.SslCertificateCn;
    }

    public String kafka$utils$TestUtils$$transactionStatusKey() {
        return this.kafka$utils$TestUtils$$transactionStatusKey;
    }

    public byte[] kafka$utils$TestUtils$$committedValue() {
        return this.kafka$utils$TestUtils$$committedValue;
    }

    public byte[] kafka$utils$TestUtils$$abortedValue() {
        return this.kafka$utils$TestUtils$$abortedValue;
    }

    public File tempDir() {
        return TestUtils.tempDirectory();
    }

    public File tempRelativeDir(String root) {
        return TestUtils.tempRelativeDir((String)root);
    }

    public File randomPartitionLogDir(File parentDir) {
        int attempts = 1000;
        File f = (File)scala.package$.MODULE$.Iterator().continually((Function0 & Serializable & scala.Serializable)() -> new File(parentDir, new StringBuilder(6).append("kafka-").append(MODULE$.random().nextInt(1000000)).toString())).take(attempts).find((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)x$1.mkdir())).getOrElse((Function0 & Serializable & scala.Serializable)() -> scala.sys.package$.MODULE$.error(new StringBuilder(42).append("Failed to create directory after ").append(attempts).append(" attempts").toString()));
        f.deleteOnExit();
        return f;
    }

    public File tempFile() {
        return TestUtils.tempFile();
    }

    public File tempFile(String prefix, String suffix) {
        return TestUtils.tempFile((String)prefix, (String)suffix);
    }

    public File tempFile(String contents) {
        return TestUtils.tempFile((String)contents);
    }

    public File tempPropertiesFile(Map<String, String> properties) {
        String content = ((TraversableOnce)properties.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            if (x0$1 != null) {
                String k = (String)x0$1._1();
                String v = (String)x0$1._2();
                return new StringBuilder(1).append(k).append("=").append(v).toString();
            }
            throw new MatchError(null);
        }, Iterable$.MODULE$.canBuildFrom())).mkString(System.lineSeparator());
        return this.tempFile(content);
    }

    public KafkaServer createServer(KafkaConfig config, Time time) {
        return this.createServer(config, time, (Option<String>)None$.MODULE$);
    }

    public KafkaServer createServer(KafkaConfig config, Time time, Option<String> threadNamePrefix) {
        return this.createServer(config, time, threadNamePrefix, true);
    }

    public KafkaServer createServer(KafkaConfig config, Time time, Option<String> threadNamePrefix, boolean startup) {
        return this.createServer(config, time, threadNamePrefix, startup, false);
    }

    public KafkaServer createServer(KafkaConfig config, Time time, Option<String> threadNamePrefix, boolean startup, boolean enableZkApiForwarding) {
        KafkaServer server = new KafkaServer(config, time, threadNamePrefix, enableZkApiForwarding);
        if (startup) {
            server.startup();
        }
        return server;
    }

    public Time createServer$default$2() {
        return Time.SYSTEM;
    }

    public int boundPort(KafkaBroker broker, SecurityProtocol securityProtocol) {
        return broker.boundPort(ListenerName.forSecurityProtocol((SecurityProtocol)securityProtocol));
    }

    public SecurityProtocol boundPort$default$2() {
        return SecurityProtocol.PLAINTEXT;
    }

    public scala.collection.Seq<Properties> createBrokerConfigs(int numConfigs, String zkConnect, boolean enableControlledShutdown, boolean enableDeleteTopic, Option<SecurityProtocol> interBrokerSecurityProtocol, Option<File> trustStoreFile, Option<Properties> saslProperties, boolean enablePlaintext, boolean enableSsl, boolean enableSaslPlaintext, boolean enableSaslSsl, Map<Object, String> rackInfo, int logDirCount, boolean enableToken, int numPartitions, short defaultReplicationFactor, int startingIdNumber, boolean enableFetchFromFollower) {
        int endingIdNumber = startingIdNumber + numConfigs - 1;
        return (scala.collection.Seq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(startingIdNumber), endingIdNumber).map((Function1 & Serializable & scala.Serializable)node -> TestUtils$.$anonfun$createBrokerConfigs$1(zkConnect, enableControlledShutdown, enableDeleteTopic, interBrokerSecurityProtocol, trustStoreFile, saslProperties, enablePlaintext, enableSsl, enableSaslPlaintext, enableSaslSsl, rackInfo, logDirCount, enableToken, numPartitions, defaultReplicationFactor, enableFetchFromFollower, BoxesRunTime.unboxToInt((Object)node)), IndexedSeq$.MODULE$.canBuildFrom());
    }

    public <B extends KafkaBroker> String plaintextBootstrapServers(scala.collection.Seq<B> brokers) {
        return this.bootstrapServers(brokers, ListenerName.forSecurityProtocol((SecurityProtocol)SecurityProtocol.PLAINTEXT));
    }

    public <B extends KafkaBroker> String bootstrapServers(scala.collection.Seq<B> brokers, ListenerName listenerName) {
        return ((TraversableOnce)brokers.map((Function1 & Serializable & scala.Serializable)s -> Utils.formatAddress((String)((EndPoint)s.config().effectiveAdvertisedListeners().find((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)TestUtils$.$anonfun$bootstrapServers$2(listenerName, x$2))).getOrElse((Function0 & Serializable & scala.Serializable)() -> scala.sys.package$.MODULE$.error(new StringBuilder(34).append("Could not find listener with name ").append(listenerName.value()).toString()))).host(), (Integer)Predef$.MODULE$.int2Integer(s.boundPort(listenerName))), Seq$.MODULE$.canBuildFrom())).mkString(",");
    }

    public <B extends KafkaBroker> void shutdownServers(scala.collection.Seq<B> brokers, boolean deleteLogDirs) {
        Future future = Future$.MODULE$.traverse(brokers, (Function1 & Serializable & scala.Serializable)s -> Future$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            s.shutdown();
            if (deleteLogDirs) {
                CoreUtils$.MODULE$.delete(s.config().logDirs());
                return;
            }
        }, ExecutionContext.Implicits$.MODULE$.global()), Seq$.MODULE$.canBuildFrom(), ExecutionContext.Implicits$.MODULE$.global());
        Await$.MODULE$.result((Awaitable)future, (Duration)FiniteDuration$.MODULE$.apply(5L, TimeUnit.MINUTES));
    }

    public <B extends KafkaBroker> boolean shutdownServers$default$2() {
        return true;
    }

    public Properties createDummyBrokerConfig() {
        return this.createBrokerConfig(0, "", this.createBrokerConfig$default$3(), this.createBrokerConfig$default$4(), this.createBrokerConfig$default$5(), this.createBrokerConfig$default$6(), this.createBrokerConfig$default$7(), this.createBrokerConfig$default$8(), this.createBrokerConfig$default$9(), this.createBrokerConfig$default$10(), this.createBrokerConfig$default$11(), this.createBrokerConfig$default$12(), this.createBrokerConfig$default$13(), this.createBrokerConfig$default$14(), this.createBrokerConfig$default$15(), this.createBrokerConfig$default$16(), this.createBrokerConfig$default$17(), this.createBrokerConfig$default$18(), this.createBrokerConfig$default$19(), this.createBrokerConfig$default$20(), this.createBrokerConfig$default$21());
    }

    public Properties createBrokerConfig(int nodeId, String zkConnect, boolean enableControlledShutdown, boolean enableDeleteTopic, int port, Option<SecurityProtocol> interBrokerSecurityProtocol, Option<File> trustStoreFile, Option<Properties> saslProperties, boolean enablePlaintext, boolean enableSaslPlaintext, int saslPlaintextPort, boolean enableSsl, int sslPort, boolean enableSaslSsl, int saslSslPort, Option<String> rack, int logDirCount, boolean enableToken, int numPartitions, short defaultReplicationFactor, boolean enableFetchFromFollower) {
        ArrayBuffer protocolAndPorts = (ArrayBuffer)ArrayBuffer$.MODULE$.apply((scala.collection.Seq)Nil$.MODULE$);
        if (enablePlaintext || TestUtils$.shouldEnable$1(SecurityProtocol.PLAINTEXT, interBrokerSecurityProtocol)) {
            protocolAndPorts.$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SecurityProtocol.PLAINTEXT), (Object)BoxesRunTime.boxToInteger((int)port)));
        }
        if (enableSsl || TestUtils$.shouldEnable$1(SecurityProtocol.SSL, interBrokerSecurityProtocol)) {
            protocolAndPorts.$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SecurityProtocol.SSL), (Object)BoxesRunTime.boxToInteger((int)sslPort)));
        }
        if (enableSaslPlaintext || TestUtils$.shouldEnable$1(SecurityProtocol.SASL_PLAINTEXT, interBrokerSecurityProtocol)) {
            protocolAndPorts.$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SecurityProtocol.SASL_PLAINTEXT), (Object)BoxesRunTime.boxToInteger((int)saslPlaintextPort)));
        }
        if (enableSaslSsl || TestUtils$.shouldEnable$1(SecurityProtocol.SASL_SSL, interBrokerSecurityProtocol)) {
            protocolAndPorts.$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SecurityProtocol.SASL_SSL), (Object)BoxesRunTime.boxToInteger((int)saslSslPort)));
        }
        String listeners = ((TraversableOnce)protocolAndPorts.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            if (x0$1 != null) {
                SecurityProtocol protocol = (SecurityProtocol)x0$1._1();
                int port = x0$1._2$mcI$sp();
                return new StringBuilder(13).append(protocol.name).append("://localhost:").append(port).toString();
            }
            throw new MatchError(null);
        }, ArrayBuffer$.MODULE$.canBuildFrom())).mkString(",");
        Properties props = new Properties();
        props.put("unstable.feature.versions.enable", "true");
        if (zkConnect == null) {
            props.setProperty("server.max.startup.time.ms", Long.toString(TimeUnit.MINUTES.toMillis(10L)));
            props.put("node.id", Integer.toString(nodeId));
            props.put("broker.id", Integer.toString(nodeId));
            props.put("advertised.listeners", listeners);
            props.put("listeners", listeners);
            props.put("controller.listener.names", "CONTROLLER");
            props.put("listener.security.protocol.map", new StringBuilder(21).append(((TraversableOnce)protocolAndPorts.map((Function1 & Serializable & scala.Serializable)p -> new StringOps(Predef$.MODULE$.augmentString("%s:%s")).format((scala.collection.Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{p._1(), p._1()})), ArrayBuffer$.MODULE$.canBuildFrom())).mkString(",")).append(",CONTROLLER:PLAINTEXT").toString());
        } else {
            if (nodeId >= 0) {
                props.put("broker.id", Integer.toString(nodeId));
            }
            props.put("listeners", listeners);
        }
        if (logDirCount > 1) {
            String logDirs = ((TraversableOnce)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), logDirCount).toList().map((Function1 & Serializable & scala.Serializable)i -> TestUtils$.$anonfun$createBrokerConfig$5(BoxesRunTime.unboxToInt((Object)i)), List$.MODULE$.canBuildFrom())).mkString(",");
            props.put("log.dirs", logDirs);
        } else {
            props.put("log.dir", this.tempDir().getAbsolutePath());
        }
        if (zkConnect == null) {
            props.put("process.roles", "broker");
            props.put("controller.quorum.voters", "1000@localhost:0");
        } else {
            props.put("zookeeper.connect", zkConnect);
            props.put("zookeeper.connection.timeout.ms", "10000");
        }
        props.put("replica.socket.timeout.ms", "1500");
        props.put("controller.socket.timeout.ms", "1500");
        props.put("controlled.shutdown.enable", Boolean.toString(enableControlledShutdown));
        props.put("delete.topic.enable", Boolean.toString(enableDeleteTopic));
        props.put(ServerLogConfigs.LOG_DELETE_DELAY_MS_CONFIG, "1000");
        props.put("controlled.shutdown.retry.backoff.ms", "100");
        props.put("log.cleaner.dedupe.buffer.size", "2097152");
        props.put("offsets.topic.replication.factor", "1");
        if (!props.containsKey("offsets.topic.num.partitions")) {
            props.put("offsets.topic.num.partitions", "5");
        }
        if (!props.containsKey("group.initial.rebalance.delay.ms")) {
            props.put("group.initial.rebalance.delay.ms", "0");
        }
        rack.foreach((Function1 & Serializable & scala.Serializable)x$4 -> props.put("broker.rack", x$4));
        props.put("num.network.threads", "2");
        props.put("background.threads", "2");
        if (protocolAndPorts.exists((Function1 & Serializable & scala.Serializable)x0$2 -> BoxesRunTime.boxToBoolean((boolean)TestUtils$.$anonfun$createBrokerConfig$7(x0$2)))) {
            Implicits$.MODULE$.PropertiesOps(props).$plus$plus$eq(this.sslConfigs(Mode.SERVER, false, trustStoreFile, new StringBuilder(6).append("server").append(nodeId).toString(), this.sslConfigs$default$5(), this.sslConfigs$default$6()));
        }
        if (protocolAndPorts.exists((Function1 & Serializable & scala.Serializable)x0$3 -> BoxesRunTime.boxToBoolean((boolean)TestUtils$.$anonfun$createBrokerConfig$8(x0$3)))) {
            Implicits$.MODULE$.PropertiesOps(props).$plus$plus$eq(JaasTestUtils$.MODULE$.saslConfigs(saslProperties));
        }
        interBrokerSecurityProtocol.foreach((Function1 & Serializable & scala.Serializable)protocol -> props.put("security.inter.broker.protocol", protocol.name));
        if (enableToken) {
            props.put("delegation.token.secret.key", "secretkey");
        }
        props.put("num.partitions", Integer.toString(numPartitions));
        props.put("default.replication.factor", Short.toString(defaultReplicationFactor));
        if (enableFetchFromFollower) {
            props.put("broker.rack", Integer.toString(nodeId));
            props.put("replica.selector.class", "org.apache.kafka.common.replica.RackAwareReplicaSelector");
        }
        return props;
    }

    public boolean createBrokerConfigs$default$3() {
        return true;
    }

    public boolean createBrokerConfigs$default$4() {
        return true;
    }

    public Option<SecurityProtocol> createBrokerConfigs$default$5() {
        return None$.MODULE$;
    }

    public Option<File> createBrokerConfigs$default$6() {
        return None$.MODULE$;
    }

    public Option<Properties> createBrokerConfigs$default$7() {
        return None$.MODULE$;
    }

    public boolean createBrokerConfigs$default$8() {
        return true;
    }

    public boolean createBrokerConfigs$default$9() {
        return false;
    }

    public boolean createBrokerConfigs$default$10() {
        return false;
    }

    public boolean createBrokerConfigs$default$11() {
        return false;
    }

    public Map<Object, String> createBrokerConfigs$default$12() {
        return (Map)scala.collection.Map$.MODULE$.apply((scala.collection.Seq)Nil$.MODULE$);
    }

    public int createBrokerConfigs$default$13() {
        return 1;
    }

    public boolean createBrokerConfigs$default$14() {
        return false;
    }

    public int createBrokerConfigs$default$15() {
        return 1;
    }

    public short createBrokerConfigs$default$16() {
        return 1;
    }

    public int createBrokerConfigs$default$17() {
        return 0;
    }

    public boolean createBrokerConfigs$default$18() {
        return false;
    }

    public boolean createBrokerConfig$default$3() {
        return true;
    }

    public boolean createBrokerConfig$default$4() {
        return true;
    }

    public int createBrokerConfig$default$5() {
        return this.RandomPort();
    }

    public Option<SecurityProtocol> createBrokerConfig$default$6() {
        return None$.MODULE$;
    }

    public Option<File> createBrokerConfig$default$7() {
        return None$.MODULE$;
    }

    public Option<Properties> createBrokerConfig$default$8() {
        return None$.MODULE$;
    }

    public boolean createBrokerConfig$default$9() {
        return true;
    }

    public boolean createBrokerConfig$default$10() {
        return false;
    }

    public int createBrokerConfig$default$11() {
        return this.RandomPort();
    }

    public boolean createBrokerConfig$default$12() {
        return false;
    }

    public int createBrokerConfig$default$13() {
        return this.RandomPort();
    }

    public boolean createBrokerConfig$default$14() {
        return false;
    }

    public int createBrokerConfig$default$15() {
        return this.RandomPort();
    }

    public Option<String> createBrokerConfig$default$16() {
        return None$.MODULE$;
    }

    public int createBrokerConfig$default$17() {
        return 1;
    }

    public boolean createBrokerConfig$default$18() {
        return false;
    }

    public int createBrokerConfig$default$19() {
        return 1;
    }

    public short createBrokerConfig$default$20() {
        return 1;
    }

    public boolean createBrokerConfig$default$21() {
        return false;
    }

    public void setIbpAndMessageFormatVersions(Properties config, MetadataVersion version) {
        config.setProperty("inter.broker.protocol.version", version.version());
        if (!LogConfig.shouldIgnoreMessageFormatVersion((MetadataVersion)version)) {
            config.setProperty(ServerLogConfigs.LOG_MESSAGE_FORMAT_VERSION_CONFIG, version.version());
            return;
        }
    }

    public <B extends KafkaBroker> Admin createAdminClient(scala.collection.Seq<B> brokers, ListenerName listenerName, Properties adminConfig) {
        Properties adminClientProperties = new Properties();
        adminClientProperties.putAll((java.util.Map<?, ?>)adminConfig);
        if (!adminClientProperties.containsKey("bootstrap.servers")) {
            adminClientProperties.put("bootstrap.servers", this.bootstrapServers(brokers, listenerName));
        }
        return Admin.create((Properties)adminClientProperties);
    }

    public <B extends KafkaBroker> Properties createAdminClient$default$3() {
        return new Properties();
    }

    /*
     * WARNING - void declaration
     */
    public <B extends KafkaBroker> Uuid createTopicWithAdminRaw(Admin admin, String topic, int numPartitions, int replicationFactor, Map<Object, scala.collection.Seq<Object>> replicaAssignment, Properties topicConfig) {
        CreateTopicsResult createTopicsResult;
        java.util.HashMap configsMap = new java.util.HashMap();
        topicConfig.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(k, v) -> configsMap.put(k.toString(), v.toString())));
        if (replicaAssignment.isEmpty()) {
            createTopicsResult = admin.createTopics(Collections.singletonList(new NewTopic(topic, numPartitions, (short)replicationFactor).configs(configsMap)));
        } else {
            void forKeyValue$extension_f;
            void forKeyValue$extension_$this;
            java.util.HashMap assignment = new java.util.HashMap();
            Function2 & Serializable & scala.Serializable intersect = (Function2 & Serializable & scala.Serializable)(x0$1, x1$1) -> TestUtils$.$anonfun$createTopicWithAdminRaw$2(assignment, BoxesRunTime.unboxToInt((Object)x0$1), x1$1);
            Map map = Implicits$.MODULE$.MapExtensionMethods(replicaAssignment);
            if (Implicits.MapExtensionMethods$.MODULE$ == null) {
                throw null;
            }
            MapExtensionMethods$.MODULE$.foreachEntry$extension(package$.MODULE$.toMapExtensionMethods((Map)forKeyValue$extension_$this), (arg_0, arg_1) -> Implicits.MapExtensionMethods$.$anonfun$forKeyValue$1((Function2)forKeyValue$extension_f, arg_0, arg_1));
            createTopicsResult = admin.createTopics(Collections.singletonList(new NewTopic(topic, assignment).configs(configsMap)));
        }
        return (Uuid)createTopicsResult.topicId(topic).get();
    }

    public <B extends KafkaBroker> scala.collection.immutable.Map<Object, Object> createTopicWithAdmin(Admin admin, String topic, scala.collection.Seq<B> brokers, scala.collection.Seq<ControllerServer> controllers, int numPartitions, int replicationFactor, Map<Object, scala.collection.Seq<Object>> replicaAssignment, Properties topicConfig) {
        int effectiveNumPartitions;
        block2: {
            effectiveNumPartitions = replicaAssignment.isEmpty() ? numPartitions : replicaAssignment.size();
            try {
                this.createTopicWithAdminRaw(admin, topic, numPartitions, replicationFactor, replicaAssignment, topicConfig);
            }
            catch (ExecutionException e) {
                if (this.isTopicExistsAndHasSameNumPartitionsAndReplicationFactor$1(e.getCause(), brokers, topic, effectiveNumPartitions, admin, replicationFactor)) break block2;
                throw e;
            }
        }
        Map<TopicPartition, UpdateMetadataRequestData.UpdateMetadataPartitionState> allPartitionsMetadata = this.waitForAllPartitionsMetadata(brokers, topic, effectiveNumPartitions);
        controllers.foreach((Function1 & Serializable & scala.Serializable)controller -> {
            TestUtils$.MODULE$.ensureConsistentKRaftMetadata((scala.collection.Seq<KafkaBroker>)brokers, controller, TestUtils$.MODULE$.ensureConsistentKRaftMetadata$default$3());
            return BoxedUnit.UNIT;
        });
        return ((TraversableOnce)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), effectiveNumPartitions).map((Function1 & Serializable & scala.Serializable)i -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)i))), allPartitionsMetadata.get((Object)new TopicPartition(topic, BoxesRunTime.unboxToInt((Object)i))).map((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToInteger((int)x$5.leader())).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new IllegalStateException(new StringBuilder(81).append("Cannot get the partition leader for topic: ").append(topic$1).append(", partition: ").append(i).append(" in server metadata cache").toString());
        })), IndexedSeq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
    }

    public TopicDescription describeTopic(Admin admin, String topic) {
        return (TopicDescription)((java.util.Map)admin.describeTopics(Collections.singleton(topic)).allTopicNames().get()).get(topic);
    }

    public boolean topicHasSameNumPartitionsAndReplicationFactor(Admin adminClient, String topic, int numPartitions, int replicationFactor) {
        TopicDescription description = this.describeTopic(adminClient, topic);
        return description != null && description.partitions().size() == numPartitions && ((TopicPartitionInfo)description.partitions().iterator().next()).replicas().size() == replicationFactor;
    }

    public <B extends KafkaBroker> Map<Object, Object> createOffsetsTopicWithAdmin(Admin admin, scala.collection.Seq<B> brokers, scala.collection.Seq<ControllerServer> controllers) {
        KafkaBroker broker = (KafkaBroker)brokers.head();
        String x$2 = "__consumer_offsets";
        int x$3 = Predef$.MODULE$.Integer2int(broker.config().getInt("offsets.topic.num.partitions"));
        short x$4 = Predef$.MODULE$.Short2short(broker.config().getShort("offsets.topic.replication.factor"));
        Properties x$7 = broker.groupCoordinator().groupMetadataTopicConfigs();
        Map<Object, scala.collection.Seq<Object>> x$8 = this.createTopicWithAdmin$default$7();
        return this.createTopicWithAdmin(admin, x$2, brokers, controllers, x$3, x$4, x$8, x$7);
    }

    public <B extends KafkaBroker> void deleteTopicWithAdmin(Admin admin, String topic, scala.collection.Seq<B> brokers, scala.collection.Seq<ControllerServer> controllers) {
        block2: {
            try {
                admin.deleteTopics(Collections.singletonList(topic)).all().get();
            }
            catch (Throwable throwable) {
                ExecutionException executionException;
                if (throwable instanceof ExecutionException && (executionException = (ExecutionException)throwable).getCause() != null && executionException.getCause() instanceof UnknownTopicOrPartitionException) break block2;
                throw throwable;
            }
        }
        this.waitForAllPartitionsMetadata(brokers, topic, 0);
        controllers.foreach((Function1 & Serializable & scala.Serializable)controller -> {
            TestUtils$.MODULE$.ensureConsistentKRaftMetadata((scala.collection.Seq<KafkaBroker>)brokers, controller, TestUtils$.MODULE$.ensureConsistentKRaftMetadata$default$3());
            return BoxedUnit.UNIT;
        });
    }

    /*
     * WARNING - void declaration
     */
    public scala.collection.immutable.Map<Object, Object> createTopic(KafkaZkClient zkClient, String topic, int numPartitions, int replicationFactor, scala.collection.Seq<KafkaBroker> servers, Properties topicConfig) {
        AdminZkClient adminZkClient = new AdminZkClient(zkClient, AdminZkClient$.MODULE$.$lessinit$greater$default$2());
        long l = this.waitUntilTrue$default$4();
        long waitUntilTrue_waitTimeMs = this.waitUntilTrue$default$3();
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!TestUtils$.$anonfun$createTopic$1(adminZkClient, topic, numPartitions, replicationFactor, topicConfig)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)TestUtils$.$anonfun$createTopic$2(topic));
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        Map<TopicPartition, UpdateMetadataRequestData.UpdateMetadataPartitionState> allPartitionsMetadata = this.waitForAllPartitionsMetadata(servers, topic, numPartitions);
        return ((TraversableOnce)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numPartitions).map((Function1 & Serializable & scala.Serializable)i -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)i))), allPartitionsMetadata.get((Object)new TopicPartition(topic, BoxesRunTime.unboxToInt((Object)i))).map((Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToInteger((int)x$6.leader())).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new IllegalStateException(new StringBuilder(81).append("Cannot get the partition leader for topic: ").append(topic$2).append(", partition: ").append(i).append(" in server metadata cache").toString());
        })), IndexedSeq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
    }

    public <B extends KafkaBroker> scala.collection.immutable.Map<Object, Object> createTopic(KafkaZkClient zkClient, String topic, Map<Object, scala.collection.Seq<Object>> partitionReplicaAssignment, scala.collection.Seq<B> servers) {
        return this.createTopic(zkClient, topic, partitionReplicaAssignment, servers, new Properties());
    }

    /*
     * WARNING - void declaration
     */
    public scala.collection.immutable.Map<Object, Object> createTopic(KafkaZkClient zkClient, String topic, Map<Object, scala.collection.Seq<Object>> partitionReplicaAssignment, scala.collection.Seq<KafkaBroker> servers, Properties topicConfig) {
        AdminZkClient adminZkClient = new AdminZkClient(zkClient, AdminZkClient$.MODULE$.$lessinit$greater$default$2());
        long l = this.waitUntilTrue$default$4();
        long waitUntilTrue_waitTimeMs = this.waitUntilTrue$default$3();
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!TestUtils$.$anonfun$createTopic$6(adminZkClient, topic, topicConfig, partitionReplicaAssignment)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)TestUtils$.$anonfun$createTopic$7(topic));
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        Map<TopicPartition, UpdateMetadataRequestData.UpdateMetadataPartitionState> allPartitionsMetadata = this.waitForAllPartitionsMetadata(servers, topic, partitionReplicaAssignment.size());
        return ((TraversableOnce)partitionReplicaAssignment.keySet().map((Function1 & Serializable & scala.Serializable)i -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)i))), allPartitionsMetadata.get((Object)new TopicPartition(topic, BoxesRunTime.unboxToInt((Object)i))).map((Function1 & Serializable & scala.Serializable)x$7 -> BoxesRunTime.boxToInteger((int)x$7.leader())).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new IllegalStateException(new StringBuilder(81).append("Cannot get the partition leader for topic: ").append(topic$3).append(", partition: ").append(i).append(" in server metadata cache").toString());
        })), Set$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
    }

    public <B extends KafkaBroker> int createTopicWithAdminRaw$default$3() {
        return 1;
    }

    public <B extends KafkaBroker> int createTopicWithAdminRaw$default$4() {
        return 1;
    }

    public <B extends KafkaBroker> Map<Object, scala.collection.Seq<Object>> createTopicWithAdminRaw$default$5() {
        return scala.collection.Map$.MODULE$.empty();
    }

    public <B extends KafkaBroker> Properties createTopicWithAdminRaw$default$6() {
        return new Properties();
    }

    public <B extends KafkaBroker> int createTopicWithAdmin$default$5() {
        return 1;
    }

    public <B extends KafkaBroker> int createTopicWithAdmin$default$6() {
        return 1;
    }

    public <B extends KafkaBroker> Map<Object, scala.collection.Seq<Object>> createTopicWithAdmin$default$7() {
        return scala.collection.Map$.MODULE$.empty();
    }

    public <B extends KafkaBroker> Properties createTopicWithAdmin$default$8() {
        return new Properties();
    }

    public int createTopic$default$3() {
        return 1;
    }

    public int createTopic$default$4() {
        return 1;
    }

    public Properties createTopic$default$6() {
        return new Properties();
    }

    public MemoryRecords singletonRecords(byte[] value, byte[] key, Compression codec, long timestamp, byte magicValue) {
        return this.records((Iterable<SimpleRecord>)new .colon.colon((Object)new SimpleRecord(timestamp, key, value), (List)Nil$.MODULE$), magicValue, codec, this.records$default$4(), this.records$default$5(), this.records$default$6(), this.records$default$7(), this.records$default$8());
    }

    public byte[] singletonRecords$default$2() {
        return null;
    }

    public Compression singletonRecords$default$3() {
        return Compression.NONE;
    }

    public long singletonRecords$default$4() {
        return -1L;
    }

    public byte singletonRecords$default$5() {
        return 2;
    }

    public MemoryRecords records(Iterable<SimpleRecord> records, byte magicValue, Compression codec, long producerId, short producerEpoch, int sequence, long baseOffset, int partitionLeaderEpoch) {
        MemoryRecordsBuilder builder = MemoryRecords.builder((ByteBuffer)ByteBuffer.allocate(DefaultRecordBatch.sizeInBytes((java.lang.Iterable)((java.lang.Iterable)CollectionConverters$.MODULE$.asJavaIterableConverter(records).asJava()))), (byte)magicValue, (Compression)codec, (TimestampType)TimestampType.CREATE_TIME, (long)baseOffset, (long)System.currentTimeMillis(), (long)producerId, (short)producerEpoch, (int)sequence, (boolean)false, (int)partitionLeaderEpoch);
        records.foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
            builder.append(x$1);
            return BoxedUnit.UNIT;
        });
        return builder.build();
    }

    public byte records$default$2() {
        return 2;
    }

    public Compression records$default$3() {
        return Compression.NONE;
    }

    public long records$default$4() {
        return -1L;
    }

    public short records$default$5() {
        return -1;
    }

    public int records$default$6() {
        return -1;
    }

    public long records$default$7() {
        return 0L;
    }

    public int records$default$8() {
        return -1;
    }

    public byte[] randomBytes(int numBytes) {
        return TestUtils.randomBytes((int)numBytes);
    }

    public Properties securityConfigs(Mode mode, SecurityProtocol securityProtocol, Option<File> trustStoreFile, String certAlias, String certCn, Option<Properties> saslProperties, String tlsProtocol, Option<Object> needsClientCert) {
        Properties props = new Properties();
        if (this.usesSslTransportLayer(securityProtocol)) {
            boolean addClientCert = BoxesRunTime.unboxToBoolean((Object)needsClientCert.getOrElse((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
                SecurityProtocol securityProtocol = securityProtocol;
                SecurityProtocol securityProtocol2 = SecurityProtocol.SSL;
                return !(securityProtocol != null ? !securityProtocol.equals(securityProtocol2) : securityProtocol2 != null);
            }));
            Implicits$.MODULE$.PropertiesOps(props).$plus$plus$eq(this.sslConfigs(mode, addClientCert, trustStoreFile, certAlias, certCn, tlsProtocol));
        }
        if (this.usesSaslAuthentication(securityProtocol)) {
            Implicits$.MODULE$.PropertiesOps(props).$plus$plus$eq(JaasTestUtils$.MODULE$.saslConfigs(saslProperties));
        }
        props.put("security.protocol", securityProtocol.name);
        return props;
    }

    public String securityConfigs$default$7() {
        return TestSslUtils.DEFAULT_TLS_PROTOCOL_FOR_TESTS;
    }

    public Option<Object> securityConfigs$default$8() {
        return None$.MODULE$;
    }

    public Properties producerSecurityConfigs(SecurityProtocol securityProtocol, Option<File> trustStoreFile, Option<Properties> saslProperties) {
        return this.securityConfigs(Mode.CLIENT, securityProtocol, trustStoreFile, "producer", this.SslCertificateCn(), saslProperties, this.securityConfigs$default$7(), this.securityConfigs$default$8());
    }

    public <K, V> KafkaProducer<K, V> createProducer(String brokerList, int acks, long maxBlockMs, long bufferSize, int retries, int deliveryTimeoutMs, int lingerMs, int batchSize, String compressionType, int requestTimeoutMs, SecurityProtocol securityProtocol, Option<File> trustStoreFile, Option<Properties> saslProperties, Serializer<K> keySerializer, Serializer<V> valueSerializer, boolean enableIdempotence) {
        Properties producerProps = new Properties();
        producerProps.put("bootstrap.servers", brokerList);
        producerProps.put("acks", Integer.toString(acks));
        producerProps.put("max.block.ms", Long.toString(maxBlockMs));
        producerProps.put("buffer.memory", Long.toString(bufferSize));
        producerProps.put("retries", Integer.toString(retries));
        producerProps.put("delivery.timeout.ms", Integer.toString(deliveryTimeoutMs));
        producerProps.put("request.timeout.ms", Integer.toString(requestTimeoutMs));
        producerProps.put("linger.ms", Integer.toString(lingerMs));
        producerProps.put("batch.size", Integer.toString(batchSize));
        producerProps.put("compression.type", compressionType);
        producerProps.put("enable.idempotence", Boolean.toString(enableIdempotence));
        Implicits$.MODULE$.PropertiesOps(producerProps).$plus$plus$eq(this.producerSecurityConfigs(securityProtocol, trustStoreFile, saslProperties));
        return new KafkaProducer(producerProps, keySerializer, valueSerializer);
    }

    public <K, V> int createProducer$default$2() {
        return -1;
    }

    public <K, V> long createProducer$default$3() {
        return 60000L;
    }

    public <K, V> long createProducer$default$4() {
        return 0x100000L;
    }

    public <K, V> int createProducer$default$5() {
        return Integer.MAX_VALUE;
    }

    public <K, V> int createProducer$default$6() {
        return 30000;
    }

    public <K, V> int createProducer$default$7() {
        return 0;
    }

    public <K, V> int createProducer$default$8() {
        return 16384;
    }

    public <K, V> String createProducer$default$9() {
        return "none";
    }

    public <K, V> int createProducer$default$10() {
        return 20000;
    }

    public <K, V> SecurityProtocol createProducer$default$11() {
        return SecurityProtocol.PLAINTEXT;
    }

    public <K, V> Option<File> createProducer$default$12() {
        return None$.MODULE$;
    }

    public <K, V> Option<Properties> createProducer$default$13() {
        return None$.MODULE$;
    }

    public <K, V> ByteArraySerializer createProducer$default$14() {
        return new ByteArraySerializer();
    }

    public <K, V> ByteArraySerializer createProducer$default$15() {
        return new ByteArraySerializer();
    }

    public <K, V> boolean createProducer$default$16() {
        return false;
    }

    public boolean usesSslTransportLayer(SecurityProtocol securityProtocol) {
        return SecurityProtocol.SSL.equals(securityProtocol) ? true : SecurityProtocol.SASL_SSL.equals(securityProtocol);
    }

    public boolean usesSaslAuthentication(SecurityProtocol securityProtocol) {
        return SecurityProtocol.SASL_PLAINTEXT.equals(securityProtocol) ? true : SecurityProtocol.SASL_SSL.equals(securityProtocol);
    }

    public Properties consumerSecurityConfigs(SecurityProtocol securityProtocol, Option<File> trustStoreFile, Option<Properties> saslProperties) {
        return this.securityConfigs(Mode.CLIENT, securityProtocol, trustStoreFile, "consumer", this.SslCertificateCn(), saslProperties, this.securityConfigs$default$7(), this.securityConfigs$default$8());
    }

    public Properties adminClientSecurityConfigs(SecurityProtocol securityProtocol, Option<File> trustStoreFile, Option<Properties> saslProperties) {
        return this.securityConfigs(Mode.CLIENT, securityProtocol, trustStoreFile, "admin-client", this.SslCertificateCn(), saslProperties, this.securityConfigs$default$7(), this.securityConfigs$default$8());
    }

    public <K, V> Consumer<K, V> createConsumer(String brokerList, String groupId, String autoOffsetReset, boolean enableAutoCommit, boolean readCommitted, int maxPollRecords, SecurityProtocol securityProtocol, Option<File> trustStoreFile, Option<Properties> saslProperties, Deserializer<K> keyDeserializer, Deserializer<V> valueDeserializer) {
        Properties consumerProps = new Properties();
        consumerProps.put("bootstrap.servers", brokerList);
        consumerProps.put("auto.offset.reset", autoOffsetReset);
        consumerProps.put("group.id", groupId);
        consumerProps.put("enable.auto.commit", Boolean.toString(enableAutoCommit));
        consumerProps.put("max.poll.records", Integer.toString(maxPollRecords));
        consumerProps.put("isolation.level", readCommitted ? "read_committed" : "read_uncommitted");
        Implicits$.MODULE$.PropertiesOps(consumerProps).$plus$plus$eq(this.consumerSecurityConfigs(securityProtocol, trustStoreFile, saslProperties));
        return new KafkaConsumer(consumerProps, keyDeserializer, valueDeserializer);
    }

    public <K, V> String createConsumer$default$2() {
        return "group";
    }

    public <K, V> String createConsumer$default$3() {
        return "earliest";
    }

    public <K, V> boolean createConsumer$default$4() {
        return true;
    }

    public <K, V> boolean createConsumer$default$5() {
        return false;
    }

    public <K, V> int createConsumer$default$6() {
        return 500;
    }

    public <K, V> SecurityProtocol createConsumer$default$7() {
        return SecurityProtocol.PLAINTEXT;
    }

    public <K, V> Option<File> createConsumer$default$8() {
        return None$.MODULE$;
    }

    public <K, V> Option<Properties> createConsumer$default$9() {
        return None$.MODULE$;
    }

    public <K, V> ByteArrayDeserializer createConsumer$default$10() {
        return new ByteArrayDeserializer();
    }

    public <K, V> ByteArrayDeserializer createConsumer$default$11() {
        return new ByteArrayDeserializer();
    }

    public int waitUntilLeaderIsElectedOrChanged(KafkaZkClient zkClient, String topic, int partition, long timeoutMs, Option<Object> oldLeaderOpt, Option<Object> newLeaderOpt, boolean ignoreNoLeader) {
        Predef$.MODULE$.require(!oldLeaderOpt.isDefined() || !newLeaderOpt.isDefined(), (Function0 & Serializable & scala.Serializable)() -> "Can't define both the old and the new leader");
        long doWaitUntilLeaderIsElectedOrChanged_startTime = System.currentTimeMillis();
        TopicPartition doWaitUntilLeaderIsElectedOrChanged_topicPartition = new TopicPartition(topic, partition);
        if (this.logger().underlying().isTraceEnabled()) {
            this.logger().underlying().trace(this.msgWithLogIdent(TestUtils$.$anonfun$doWaitUntilLeaderIsElectedOrChanged$2(doWaitUntilLeaderIsElectedOrChanged_topicPartition, oldLeaderOpt, newLeaderOpt)));
        }
        ObjectRef doWaitUntilLeaderIsElectedOrChanged_leader = ObjectRef.create((Object)None$.MODULE$);
        None$ doWaitUntilLeaderIsElectedOrChanged_electedOrChangedLeader = None$.MODULE$;
        while (doWaitUntilLeaderIsElectedOrChanged_electedOrChangedLeader.isEmpty() && System.currentTimeMillis() < doWaitUntilLeaderIsElectedOrChanged_startTime + timeoutMs) {
            doWaitUntilLeaderIsElectedOrChanged_leader.elem = TestUtils$.getPartitionLeader$1(topic, partition, zkClient, ignoreNoLeader);
            Option option = (Option)doWaitUntilLeaderIsElectedOrChanged_leader.elem;
            if (option instanceof Some) {
                int doWaitUntilLeaderIsElectedOrChanged_oldLeader;
                int doWaitUntilLeaderIsElectedOrChanged_l = BoxesRunTime.unboxToInt((Object)((Some)option).value());
                if (newLeaderOpt instanceof Some && BoxesRunTime.unboxToInt((Object)((Some)newLeaderOpt).value()) == doWaitUntilLeaderIsElectedOrChanged_l) {
                    if (this.logger().underlying().isTraceEnabled()) {
                        this.logger().underlying().trace(this.msgWithLogIdent(TestUtils$.$anonfun$doWaitUntilLeaderIsElectedOrChanged$3(doWaitUntilLeaderIsElectedOrChanged_l, doWaitUntilLeaderIsElectedOrChanged_topicPartition)));
                    }
                    doWaitUntilLeaderIsElectedOrChanged_electedOrChangedLeader = (Option)doWaitUntilLeaderIsElectedOrChanged_leader.elem;
                } else if (oldLeaderOpt instanceof Some && (doWaitUntilLeaderIsElectedOrChanged_oldLeader = BoxesRunTime.unboxToInt((Object)((Some)oldLeaderOpt).value())) != doWaitUntilLeaderIsElectedOrChanged_l) {
                    if (this.logger().underlying().isTraceEnabled()) {
                        this.logger().underlying().trace(this.msgWithLogIdent(TestUtils$.$anonfun$doWaitUntilLeaderIsElectedOrChanged$4(doWaitUntilLeaderIsElectedOrChanged_topicPartition, doWaitUntilLeaderIsElectedOrChanged_oldLeader, doWaitUntilLeaderIsElectedOrChanged_l)));
                    }
                    doWaitUntilLeaderIsElectedOrChanged_electedOrChangedLeader = (Option)doWaitUntilLeaderIsElectedOrChanged_leader.elem;
                } else if (None$.MODULE$.equals(newLeaderOpt) && None$.MODULE$.equals(oldLeaderOpt)) {
                    if (this.logger().underlying().isTraceEnabled()) {
                        this.logger().underlying().trace(this.msgWithLogIdent(TestUtils$.$anonfun$doWaitUntilLeaderIsElectedOrChanged$5(doWaitUntilLeaderIsElectedOrChanged_l, doWaitUntilLeaderIsElectedOrChanged_topicPartition)));
                    }
                    doWaitUntilLeaderIsElectedOrChanged_electedOrChangedLeader = (Option)doWaitUntilLeaderIsElectedOrChanged_leader.elem;
                } else if (this.logger().underlying().isTraceEnabled()) {
                    this.logger().underlying().trace(this.msgWithLogIdent(TestUtils$.$anonfun$doWaitUntilLeaderIsElectedOrChanged$6(doWaitUntilLeaderIsElectedOrChanged_topicPartition, doWaitUntilLeaderIsElectedOrChanged_l)));
                }
            } else if (None$.MODULE$.equals(option)) {
                if (this.logger().underlying().isTraceEnabled()) {
                    this.logger().underlying().trace(this.msgWithLogIdent(TestUtils$.$anonfun$doWaitUntilLeaderIsElectedOrChanged$7(doWaitUntilLeaderIsElectedOrChanged_topicPartition)));
                }
            } else {
                throw new MatchError((Object)option);
            }
            Thread.sleep(scala.math.package$.MODULE$.min(timeoutMs, 100L));
        }
        return BoxesRunTime.unboxToInt((Object)doWaitUntilLeaderIsElectedOrChanged_electedOrChangedLeader.getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            String string;
            if (newLeaderOpt instanceof Some) {
                int newLeader = BoxesRunTime.unboxToInt((Object)((Some)newLeaderOpt).value());
                string = new StringBuilder(90).append("Timing out after ").append(timeoutMs).append(" ms since expected new leader ").append(newLeader).append(" was not elected for partition ").append(doWaitUntilLeaderIsElectedOrChanged_topicPartition).append(", leader is ").append((Option)leader$1.elem).toString();
            } else if (oldLeaderOpt instanceof Some) {
                int oldLeader = BoxesRunTime.unboxToInt((Object)((Some)oldLeaderOpt).value());
                string = new StringBuilder(106).append("Timing out after ").append(timeoutMs).append(" ms since a new leader that is different from ").append(oldLeader).append(" was not elected for partition ").append(doWaitUntilLeaderIsElectedOrChanged_topicPartition).append(", ").append("leader is ").append((Option)leader$1.elem).toString();
            } else {
                string = new StringBuilder(66).append("Timing out after ").append(timeoutMs).append(" ms since a leader was not elected for partition ").append(doWaitUntilLeaderIsElectedOrChanged_topicPartition).toString();
            }
            String errorMessage = string;
            throw new AssertionError((Object)errorMessage);
        }));
    }

    public long waitUntilLeaderIsElectedOrChanged$default$4() {
        return 30000L;
    }

    public Option<Object> waitUntilLeaderIsElectedOrChanged$default$5() {
        return None$.MODULE$;
    }

    public Option<Object> waitUntilLeaderIsElectedOrChanged$default$6() {
        return None$.MODULE$;
    }

    public boolean waitUntilLeaderIsElectedOrChanged$default$7() {
        return false;
    }

    public int waitUntilLeaderIsElectedOrChangedWithAdmin(Admin admin, String topic, int partition, long timeoutMs, Option<Object> oldLeaderOpt, Option<Object> newLeaderOpt) {
        Predef$.MODULE$.require(!oldLeaderOpt.isDefined() || !newLeaderOpt.isDefined(), (Function0 & Serializable & scala.Serializable)() -> "Can't define both the old and the new leader");
        long doWaitUntilLeaderIsElectedOrChanged_startTime = System.currentTimeMillis();
        TopicPartition doWaitUntilLeaderIsElectedOrChanged_topicPartition = new TopicPartition(topic, partition);
        if (this.logger().underlying().isTraceEnabled()) {
            this.logger().underlying().trace(this.msgWithLogIdent(TestUtils$.$anonfun$doWaitUntilLeaderIsElectedOrChanged$2(doWaitUntilLeaderIsElectedOrChanged_topicPartition, oldLeaderOpt, newLeaderOpt)));
        }
        ObjectRef doWaitUntilLeaderIsElectedOrChanged_leader = ObjectRef.create((Object)None$.MODULE$);
        None$ doWaitUntilLeaderIsElectedOrChanged_electedOrChangedLeader = None$.MODULE$;
        while (doWaitUntilLeaderIsElectedOrChanged_electedOrChangedLeader.isEmpty() && System.currentTimeMillis() < doWaitUntilLeaderIsElectedOrChanged_startTime + timeoutMs) {
            doWaitUntilLeaderIsElectedOrChanged_leader.elem = TestUtils$.getPartitionLeader$2(topic, partition, admin);
            Option option = (Option)doWaitUntilLeaderIsElectedOrChanged_leader.elem;
            if (option instanceof Some) {
                int doWaitUntilLeaderIsElectedOrChanged_oldLeader;
                int doWaitUntilLeaderIsElectedOrChanged_l = BoxesRunTime.unboxToInt((Object)((Some)option).value());
                if (newLeaderOpt instanceof Some && BoxesRunTime.unboxToInt((Object)((Some)newLeaderOpt).value()) == doWaitUntilLeaderIsElectedOrChanged_l) {
                    if (this.logger().underlying().isTraceEnabled()) {
                        this.logger().underlying().trace(this.msgWithLogIdent(TestUtils$.$anonfun$doWaitUntilLeaderIsElectedOrChanged$3(doWaitUntilLeaderIsElectedOrChanged_l, doWaitUntilLeaderIsElectedOrChanged_topicPartition)));
                    }
                    doWaitUntilLeaderIsElectedOrChanged_electedOrChangedLeader = (Option)doWaitUntilLeaderIsElectedOrChanged_leader.elem;
                } else if (oldLeaderOpt instanceof Some && (doWaitUntilLeaderIsElectedOrChanged_oldLeader = BoxesRunTime.unboxToInt((Object)((Some)oldLeaderOpt).value())) != doWaitUntilLeaderIsElectedOrChanged_l) {
                    if (this.logger().underlying().isTraceEnabled()) {
                        this.logger().underlying().trace(this.msgWithLogIdent(TestUtils$.$anonfun$doWaitUntilLeaderIsElectedOrChanged$4(doWaitUntilLeaderIsElectedOrChanged_topicPartition, doWaitUntilLeaderIsElectedOrChanged_oldLeader, doWaitUntilLeaderIsElectedOrChanged_l)));
                    }
                    doWaitUntilLeaderIsElectedOrChanged_electedOrChangedLeader = (Option)doWaitUntilLeaderIsElectedOrChanged_leader.elem;
                } else if (None$.MODULE$.equals(newLeaderOpt) && None$.MODULE$.equals(oldLeaderOpt)) {
                    if (this.logger().underlying().isTraceEnabled()) {
                        this.logger().underlying().trace(this.msgWithLogIdent(TestUtils$.$anonfun$doWaitUntilLeaderIsElectedOrChanged$5(doWaitUntilLeaderIsElectedOrChanged_l, doWaitUntilLeaderIsElectedOrChanged_topicPartition)));
                    }
                    doWaitUntilLeaderIsElectedOrChanged_electedOrChangedLeader = (Option)doWaitUntilLeaderIsElectedOrChanged_leader.elem;
                } else if (this.logger().underlying().isTraceEnabled()) {
                    this.logger().underlying().trace(this.msgWithLogIdent(TestUtils$.$anonfun$doWaitUntilLeaderIsElectedOrChanged$6(doWaitUntilLeaderIsElectedOrChanged_topicPartition, doWaitUntilLeaderIsElectedOrChanged_l)));
                }
            } else if (None$.MODULE$.equals(option)) {
                if (this.logger().underlying().isTraceEnabled()) {
                    this.logger().underlying().trace(this.msgWithLogIdent(TestUtils$.$anonfun$doWaitUntilLeaderIsElectedOrChanged$7(doWaitUntilLeaderIsElectedOrChanged_topicPartition)));
                }
            } else {
                throw new MatchError((Object)option);
            }
            Thread.sleep(scala.math.package$.MODULE$.min(timeoutMs, 100L));
        }
        return BoxesRunTime.unboxToInt((Object)doWaitUntilLeaderIsElectedOrChanged_electedOrChangedLeader.getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            String string;
            if (newLeaderOpt instanceof Some) {
                int newLeader = BoxesRunTime.unboxToInt((Object)((Some)newLeaderOpt).value());
                string = new StringBuilder(90).append("Timing out after ").append(timeoutMs).append(" ms since expected new leader ").append(newLeader).append(" was not elected for partition ").append(doWaitUntilLeaderIsElectedOrChanged_topicPartition).append(", leader is ").append((Option)leader$1.elem).toString();
            } else if (oldLeaderOpt instanceof Some) {
                int oldLeader = BoxesRunTime.unboxToInt((Object)((Some)oldLeaderOpt).value());
                string = new StringBuilder(106).append("Timing out after ").append(timeoutMs).append(" ms since a new leader that is different from ").append(oldLeader).append(" was not elected for partition ").append(doWaitUntilLeaderIsElectedOrChanged_topicPartition).append(", ").append("leader is ").append((Option)leader$1.elem).toString();
            } else {
                string = new StringBuilder(66).append("Timing out after ").append(timeoutMs).append(" ms since a leader was not elected for partition ").append(doWaitUntilLeaderIsElectedOrChanged_topicPartition).toString();
            }
            String errorMessage = string;
            throw new AssertionError((Object)errorMessage);
        }));
    }

    public long waitUntilLeaderIsElectedOrChangedWithAdmin$default$4() {
        return 30000L;
    }

    public Option<Object> waitUntilLeaderIsElectedOrChangedWithAdmin$default$5() {
        return None$.MODULE$;
    }

    public Option<Object> waitUntilLeaderIsElectedOrChangedWithAdmin$default$6() {
        return None$.MODULE$;
    }

    private int doWaitUntilLeaderIsElectedOrChanged(Function2<String, Object, Option<Object>> getPartitionLeader, String topic, int partition, long timeoutMs, Option<Object> oldLeaderOpt, Option<Object> newLeaderOpt) {
        Predef$.MODULE$.require(!oldLeaderOpt.isDefined() || !newLeaderOpt.isDefined(), (Function0 & Serializable & scala.Serializable)() -> "Can't define both the old and the new leader");
        long startTime = System.currentTimeMillis();
        TopicPartition topicPartition = new TopicPartition(topic, partition);
        if (this.logger().underlying().isTraceEnabled()) {
            this.logger().underlying().trace(this.msgWithLogIdent(TestUtils$.$anonfun$doWaitUntilLeaderIsElectedOrChanged$2(topicPartition, oldLeaderOpt, newLeaderOpt)));
        }
        ObjectRef leader = ObjectRef.create((Object)None$.MODULE$);
        None$ electedOrChangedLeader = None$.MODULE$;
        while (electedOrChangedLeader.isEmpty() && System.currentTimeMillis() < startTime + timeoutMs) {
            leader.elem = (Option)getPartitionLeader.apply((Object)topic, (Object)BoxesRunTime.boxToInteger((int)partition));
            Option option = (Option)leader.elem;
            if (option instanceof Some) {
                int oldLeader;
                int l = BoxesRunTime.unboxToInt((Object)((Some)option).value());
                if (newLeaderOpt instanceof Some && BoxesRunTime.unboxToInt((Object)((Some)newLeaderOpt).value()) == l) {
                    if (this.logger().underlying().isTraceEnabled()) {
                        this.logger().underlying().trace(this.msgWithLogIdent(TestUtils$.$anonfun$doWaitUntilLeaderIsElectedOrChanged$3(l, topicPartition)));
                    }
                    electedOrChangedLeader = (Option)leader.elem;
                } else if (oldLeaderOpt instanceof Some && (oldLeader = BoxesRunTime.unboxToInt((Object)((Some)oldLeaderOpt).value())) != l) {
                    if (this.logger().underlying().isTraceEnabled()) {
                        this.logger().underlying().trace(this.msgWithLogIdent(TestUtils$.$anonfun$doWaitUntilLeaderIsElectedOrChanged$4(topicPartition, oldLeader, l)));
                    }
                    electedOrChangedLeader = (Option)leader.elem;
                } else if (None$.MODULE$.equals(newLeaderOpt) && None$.MODULE$.equals(oldLeaderOpt)) {
                    if (this.logger().underlying().isTraceEnabled()) {
                        this.logger().underlying().trace(this.msgWithLogIdent(TestUtils$.$anonfun$doWaitUntilLeaderIsElectedOrChanged$5(l, topicPartition)));
                    }
                    electedOrChangedLeader = (Option)leader.elem;
                } else if (this.logger().underlying().isTraceEnabled()) {
                    this.logger().underlying().trace(this.msgWithLogIdent(TestUtils$.$anonfun$doWaitUntilLeaderIsElectedOrChanged$6(topicPartition, l)));
                }
            } else if (None$.MODULE$.equals(option)) {
                if (this.logger().underlying().isTraceEnabled()) {
                    this.logger().underlying().trace(this.msgWithLogIdent(TestUtils$.$anonfun$doWaitUntilLeaderIsElectedOrChanged$7(topicPartition)));
                }
            } else {
                throw new MatchError((Object)option);
            }
            Thread.sleep(scala.math.package$.MODULE$.min(timeoutMs, 100L));
        }
        return BoxesRunTime.unboxToInt((Object)electedOrChangedLeader.getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            String string;
            if (newLeaderOpt instanceof Some) {
                int newLeader = BoxesRunTime.unboxToInt((Object)((Some)newLeaderOpt).value());
                string = new StringBuilder(90).append("Timing out after ").append(timeoutMs).append(" ms since expected new leader ").append(newLeader).append(" was not elected for partition ").append(doWaitUntilLeaderIsElectedOrChanged_topicPartition).append(", leader is ").append((Option)leader$1.elem).toString();
            } else if (oldLeaderOpt instanceof Some) {
                int oldLeader = BoxesRunTime.unboxToInt((Object)((Some)oldLeaderOpt).value());
                string = new StringBuilder(106).append("Timing out after ").append(timeoutMs).append(" ms since a new leader that is different from ").append(oldLeader).append(" was not elected for partition ").append(doWaitUntilLeaderIsElectedOrChanged_topicPartition).append(", ").append("leader is ").append((Option)leader$1.elem).toString();
            } else {
                string = new StringBuilder(66).append("Timing out after ").append(timeoutMs).append(" ms since a leader was not elected for partition ").append(doWaitUntilLeaderIsElectedOrChanged_topicPartition).toString();
            }
            String errorMessage = string;
            throw new AssertionError((Object)errorMessage);
        }));
    }

    public void retry(long maxWaitMs, Function0<BoxedUnit> block) {
        LongRef wait = LongRef.create((long)1L);
        long startTime = System.currentTimeMillis();
        while (true) {
            try {
                block.apply$mcV$sp();
                return;
            }
            catch (AssertionError e) {
                if (System.currentTimeMillis() - startTime > maxWaitMs) {
                    throw e;
                }
                if (this.logger().underlying().isInfoEnabled()) {
                    this.logger().underlying().info(this.msgWithLogIdent(TestUtils$.$anonfun$retry$1(wait)));
                }
                Thread.sleep(wait.elem);
                wait.elem += scala.math.package$.MODULE$.min(wait.elem, 1000L);
                continue;
            }
            break;
        }
    }

    public void pollUntilTrue(Consumer<?, ?> consumer, Function0<Object> action, Function0<String> msg, long waitTimeMs) {
        long x$3 = 0L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!TestUtils$.$anonfun$pollUntilTrue$1(consumer, action)) {
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitTimeMs) {
                Assertions.fail((String)((String)msg.apply()));
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitTimeMs), x$3));
        }
    }

    public long pollUntilTrue$default$4() {
        return 15000L;
    }

    public <K, V> void pollRecordsUntilTrue(Consumer<K, V> consumer, Function1<ConsumerRecords<K, V>, Object> action, Function0<String> msg, long waitTimeMs, long pollTimeoutMs) {
        long x$3 = 0L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!TestUtils$.$anonfun$pollRecordsUntilTrue$1(consumer, pollTimeoutMs, action)) {
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitTimeMs) {
                Assertions.fail((String)((String)msg.apply()));
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitTimeMs), x$3));
        }
    }

    public <K, V> long pollRecordsUntilTrue$default$4() {
        return 15000L;
    }

    public <K, V> long pollRecordsUntilTrue$default$5() {
        return 100L;
    }

    public void waitUntilTrue(Function0<Object> condition, Function0<String> msg, long waitTimeMs, long pause) {
        long startTime = System.currentTimeMillis();
        while (!condition.apply$mcZ$sp()) {
            if (System.currentTimeMillis() > startTime + waitTimeMs) {
                Assertions.fail((String)((String)msg.apply()));
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitTimeMs), pause));
        }
        return;
    }

    public long waitUntilTrue$default$3() {
        return 15000L;
    }

    public long waitUntilTrue$default$4() {
        return 100L;
    }

    public <T> Tuple2<T, Object> computeUntilTrue(Function0<T> compute, long waitTime, long pause, Function1<T, Object> predicate) {
        long startTime = System.currentTimeMillis();
        Object result;
        while (!BoxesRunTime.unboxToBoolean((Object)predicate.apply(result = compute.apply()))) {
            if (System.currentTimeMillis() > startTime + waitTime) {
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(result), (Object)BoxesRunTime.boxToBoolean((boolean)false));
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitTime), pause));
        }
        return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(result), (Object)BoxesRunTime.boxToBoolean((boolean)true));
    }

    public <T> long computeUntilTrue$default$2() {
        return 15000L;
    }

    public <T> long computeUntilTrue$default$3() {
        return 100L;
    }

    /*
     * WARNING - void declaration
     */
    public <T> T tryUntilNoAssertionError(long waitTime, long pause, Function0<T> assertions) {
        void var7_7;
        Tuple2 tuple2;
        long computeUntilTrue_startTime = System.currentTimeMillis();
        while (true) {
            Either computeUntilTrue_result;
            if ((computeUntilTrue_result = TestUtils$.$anonfun$tryUntilNoAssertionError$1(assertions)).isLeft()) {
                tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)computeUntilTrue_result), (Object)BoxesRunTime.boxToBoolean((boolean)true));
                break;
            }
            if (System.currentTimeMillis() > computeUntilTrue_startTime + waitTime) {
                tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)computeUntilTrue_result), (Object)BoxesRunTime.boxToBoolean((boolean)false));
                break;
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitTime), pause));
        }
        Tuple2 tuple22 = tuple2;
        if (tuple22 == null) {
            throw new MatchError(null);
        }
        Either either = (Either)tuple22._1();
        if (var7_7 instanceof Left) {
            return (T)((Left)var7_7).value();
        }
        if (var7_7 instanceof Right) {
            throw (AssertionError)((Right)var7_7).value();
        }
        throw new MatchError((Object)var7_7);
    }

    public <T> long tryUntilNoAssertionError$default$1() {
        return 15000L;
    }

    public <T> long tryUntilNoAssertionError$default$2() {
        return 100L;
    }

    public int findLeaderEpoch(int brokerId, TopicPartition topicPartition, Iterable<KafkaBroker> brokers) {
        return ((Partition)brokers.find((Function1 & Serializable & scala.Serializable)x$10 -> BoxesRunTime.boxToBoolean((boolean)TestUtils$.$anonfun$findLeaderEpoch$1(brokerId, x$10))).flatMap((Function1 & Serializable & scala.Serializable)x$11 -> x$11.replicaManager().onlinePartition(topicPartition)).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new AssertionError((Object)new StringBuilder(42).append("Failed to find expected replica on broker ").append(brokerId).toString());
        })).getLeaderEpoch();
    }

    public int findFollowerId(TopicPartition topicPartition, Iterable<KafkaBroker> brokers) {
        return BoxesRunTime.unboxToInt((Object)brokers.find((Function1 & Serializable & scala.Serializable)server -> BoxesRunTime.boxToBoolean((boolean)TestUtils$.$anonfun$findFollowerId$1(topicPartition, server))).map((Function1 & Serializable & scala.Serializable)x$12 -> BoxesRunTime.boxToInteger((int)TestUtils$.$anonfun$findFollowerId$2(x$12))).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new AssertionError((Object)new StringBuilder(30).append("Unable to locate follower for ").append(topicPartition).toString());
        }));
    }

    public <B extends KafkaBroker> void waitUntilBrokerMetadataIsPropagated(scala.collection.Seq<B> brokers, long timeout) {
        scala.collection.immutable.Set expectedBrokerIds = ((TraversableOnce)brokers.map((Function1 & Serializable & scala.Serializable)x$13 -> BoxesRunTime.boxToInteger((int)TestUtils$.$anonfun$waitUntilBrokerMetadataIsPropagated$1(x$13)), Seq$.MODULE$.canBuildFrom())).toSet();
        long waitUntilTrue_pause = this.waitUntilTrue$default$4();
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!brokers.forall((Function1 & Serializable & scala.Serializable)server -> BoxesRunTime.boxToBoolean((boolean)TestUtils$.$anonfun$waitUntilBrokerMetadataIsPropagated$3(expectedBrokerIds$1, server)))) {
            if (System.currentTimeMillis() > waitUntilTrue_startTime + timeout) {
                Assertions.fail((String)TestUtils$.$anonfun$waitUntilBrokerMetadataIsPropagated$5());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(timeout), waitUntilTrue_pause));
        }
    }

    public <B extends KafkaBroker> long waitUntilBrokerMetadataIsPropagated$default$2() {
        return 15000L;
    }

    /*
     * WARNING - void declaration
     */
    public <B extends KafkaBroker> Map<TopicPartition, UpdateMetadataRequestData.UpdateMetadataPartitionState> waitForAllPartitionsMetadata(scala.collection.Seq<B> brokers, String topic, int expectedNumPartitions) {
        long l = this.waitUntilTrue$default$4();
        long waitUntilTrue_waitTimeMs = 60000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!brokers.forall((Function1 & Serializable & scala.Serializable)broker -> BoxesRunTime.boxToBoolean((boolean)TestUtils$.$anonfun$waitForAllPartitionsMetadata$2(expectedNumPartitions$1, topic$4, broker)))) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)TestUtils$.$anonfun$waitForAllPartitionsMetadata$3(topic));
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        return ((TraversableOnce)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), expectedNumPartitions).map((Function1 & Serializable & scala.Serializable)i -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition(topic, BoxesRunTime.unboxToInt((Object)i))), ((KafkaBroker)brokers.head()).metadataCache().getPartitionInfo(topic, BoxesRunTime.unboxToInt((Object)i)).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new IllegalStateException(new StringBuilder(56).append("Cannot get topic: ").append(topic$4).append(", partition: ").append(i).append(" in server metadata cache").toString());
        })), IndexedSeq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
    }

    public <B extends KafkaBroker> UpdateMetadataRequestData.UpdateMetadataPartitionState waitForPartitionMetadata(scala.collection.Seq<B> brokers, String topic, int partition, long timeout) {
        long waitUntilTrue_pause = this.waitUntilTrue$default$4();
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!brokers.forall((Function1 & Serializable & scala.Serializable)broker -> BoxesRunTime.boxToBoolean((boolean)TestUtils$.$anonfun$waitForPartitionMetadata$2(topic$5, partition$2, broker)))) {
            if (System.currentTimeMillis() > waitUntilTrue_startTime + timeout) {
                Assertions.fail((String)TestUtils$.$anonfun$waitForPartitionMetadata$3(topic, partition, timeout));
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(timeout), waitUntilTrue_pause));
        }
        return (UpdateMetadataRequestData.UpdateMetadataPartitionState)((KafkaBroker)brokers.head()).metadataCache().getPartitionInfo(topic, partition).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new IllegalStateException(new StringBuilder(56).append("Cannot get topic: ").append(topic).append(", partition: ").append(partition).append(" in server metadata cache").toString());
        });
    }

    public <B extends KafkaBroker> long waitForPartitionMetadata$default$4() {
        return 15000L;
    }

    /*
     * WARNING - void declaration
     */
    public void ensureConsistentKRaftMetadata(scala.collection.Seq<KafkaBroker> brokers, ControllerServer controllerServer, String msg) {
        long controllerOffset = controllerServer.raftManager().replicatedLog().endOffset().offset - 1L;
        long l = this.waitUntilTrue$default$4();
        long waitUntilTrue_waitTimeMs = this.waitUntilTrue$default$3();
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!brokers.forall((Function1 & Serializable & scala.Serializable)broker -> BoxesRunTime.boxToBoolean((boolean)TestUtils$.$anonfun$ensureConsistentKRaftMetadata$2(controllerOffset$1, broker)))) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)msg);
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
    }

    public String ensureConsistentKRaftMetadata$default$3() {
        return "Timeout waiting for controller metadata propagating to brokers";
    }

    /*
     * WARNING - void declaration
     */
    public int waitUntilControllerElected(KafkaZkClient zkClient, long timeout) {
        void var5_7;
        Tuple2 tuple2;
        long computeUntilTrue_pause = this.computeUntilTrue$default$3();
        long computeUntilTrue_startTime = System.currentTimeMillis();
        while (true) {
            Option computeUntilTrue_result;
            if ((computeUntilTrue_result = zkClient.getControllerId()).isDefined()) {
                tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)computeUntilTrue_result), (Object)BoxesRunTime.boxToBoolean((boolean)true));
                break;
            }
            if (System.currentTimeMillis() > computeUntilTrue_startTime + timeout) {
                tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)computeUntilTrue_result), (Object)BoxesRunTime.boxToBoolean((boolean)false));
                break;
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(timeout), computeUntilTrue_pause));
        }
        Tuple2 tuple22 = tuple2;
        if (tuple22 == null) {
            throw new MatchError(null);
        }
        Option controllerId = (Option)tuple22._1();
        return BoxesRunTime.unboxToInt((Object)var5_7.getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new AssertionError((Object)new StringBuilder(32).append("Controller not elected after ").append(timeout).append(" ms").toString());
        }));
    }

    public long waitUntilControllerElected$default$2() {
        return 15000L;
    }

    public <B extends KafkaBroker> int awaitLeaderChange(scala.collection.Seq<B> brokers, TopicPartition tp, int oldLeader, long timeout) {
        long waitUntilTrue_pause = this.waitUntilTrue$default$4();
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!TestUtils$.$anonfun$awaitLeaderChange$4(brokers, oldLeader, tp)) {
            if (System.currentTimeMillis() > waitUntilTrue_startTime + timeout) {
                Assertions.fail((String)TestUtils$.$anonfun$awaitLeaderChange$5(tp, timeout));
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(timeout), waitUntilTrue_pause));
        }
        return BoxesRunTime.unboxToInt((Object)TestUtils$.newLeaderExists$1(brokers, oldLeader, tp).get());
    }

    public <B extends KafkaBroker> long awaitLeaderChange$default$4() {
        return 15000L;
    }

    public <B extends KafkaBroker> int waitUntilLeaderIsKnown(scala.collection.Seq<B> brokers, TopicPartition tp, long timeout) {
        long waitUntilTrue_pause = this.waitUntilTrue$default$4();
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!TestUtils$.$anonfun$waitUntilLeaderIsKnown$4(brokers, tp)) {
            if (System.currentTimeMillis() > waitUntilTrue_startTime + timeout) {
                Assertions.fail((String)TestUtils$.$anonfun$waitUntilLeaderIsKnown$5(tp, timeout));
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(timeout), waitUntilTrue_pause));
        }
        return BoxesRunTime.unboxToInt((Object)TestUtils$.leaderIfExists$1(brokers, tp).get());
    }

    public <B extends KafkaBroker> long waitUntilLeaderIsKnown$default$3() {
        return 15000L;
    }

    public void appendNonsenseToFile(File file, int size) {
        try (OutputStream outputStream = Files.newOutputStream(file.toPath(), StandardOpenOption.APPEND);){
            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), size).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)_ -> outputStream.write(MODULE$.random().nextInt(255)));
        }
    }

    public void assertNoNonDaemonThreads(String threadNamePrefix) {
        Set nonDaemonThreads = (Set)((TraversableLike)CollectionConverters$.MODULE$.asScalaSetConverter(Thread.getAllStackTraces().keySet()).asScala()).filter((Function1 & Serializable & scala.Serializable)t -> BoxesRunTime.boxToBoolean((boolean)TestUtils$.$anonfun$assertNoNonDaemonThreads$1(threadNamePrefix, t)));
        int threadCount = nonDaemonThreads.size();
        Assertions.assertEquals((int)0, (int)threadCount, (String)new StringBuilder(36).append("Found unexpected ").append(threadCount).append(" NonDaemon threads=").append(((TraversableOnce)nonDaemonThreads.map((Function1 & Serializable & scala.Serializable)t -> t.getName(), scala.collection.mutable.Set$.MODULE$.canBuildFrom())).mkString(", ")).toString());
    }

    public void formatDirectories(Seq<String> directories, MetaProperties metaProperties, MetadataVersion metadataVersion, Option<ArrayBuffer<ApiMessageAndVersion>> optionalMetadataRecords) {
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        PrintStream out = null;
        try {
            out = new PrintStream(stream);
            BootstrapMetadata bootstrapMetadata = StorageTool$.MODULE$.buildBootstrapMetadata(metadataVersion, optionalMetadataRecords, "format command");
            if (StorageTool$.MODULE$.formatCommand(out, directories, metaProperties, bootstrapMetadata, metadataVersion, false) != 0) {
                throw new RuntimeException(stream.toString());
            }
            if (this.logger().underlying().isDebugEnabled()) {
                this.logger().underlying().debug(this.msgWithLogIdent(TestUtils$.$anonfun$formatDirectories$1(directories)));
            }
        }
        catch (Throwable throwable) {
            if (out != null) {
                out.close();
            }
            stream.close();
            throw throwable;
        }
        out.close();
        stream.close();
    }

    public LogManager createLogManager(scala.collection.Seq<File> logDirs, LogConfig defaultConfig, ConfigRepository configRepository, CleanerConfig cleanerConfig, MockTime time, MetadataVersion interBrokerProtocolVersion, int recoveryThreadsPerDataDir, boolean transactionVerificationEnabled, Option<UnifiedLog> log, boolean remoteStorageSystemEnable, long initialTaskDelayMs) {
        scala.collection.Seq x$1 = (scala.collection.Seq)logDirs.map((Function1 & Serializable & scala.Serializable)x$20 -> x$20.getAbsoluteFile(), Seq$.MODULE$.canBuildFrom());
        WrappedArray x$2 = Predef$.MODULE$.wrapRefArray((Object[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(File.class)));
        long x$7 = 1000L;
        long x$8 = 10000L;
        long x$9 = 10000L;
        long x$10 = 1000L;
        int x$11 = 300000;
        ProducerStateManagerConfig x$12 = new ProducerStateManagerConfig(86400000, transactionVerificationEnabled);
        int x$13 = 600000;
        MockScheduler x$14 = time.scheduler;
        BrokerTopicStats x$16 = new BrokerTopicStats(BrokerTopicStats$.MODULE$.$lessinit$greater$default$1());
        LogDirFailureChannel x$17 = new LogDirFailureChannel(logDirs.size());
        boolean x$18 = true;
        LogManager logManager = new LogManager(x$1, (scala.collection.Seq)x$2, configRepository, defaultConfig, cleanerConfig, recoveryThreadsPerDataDir, x$7, x$8, x$9, x$10, x$11, x$12, x$13, interBrokerProtocolVersion, (Scheduler)x$14, x$16, x$17, (Time)time, x$18, remoteStorageSystemEnable, initialTaskDelayMs);
        if (log.isDefined()) {
            LogManager spyLogManager = (LogManager)Mockito.spy((Object)logManager);
            ((LogManager)Mockito.doReturn((Object)log.get(), (Object[])ScalaRunTime$.MODULE$.toObjectArray(Nil$.MODULE$.toArray(ClassTag$.MODULE$.Any()))).when((Object)spyLogManager)).getOrCreateLog((TopicPartition)ArgumentMatchers.any(TopicPartition.class), ArgumentMatchers.anyBoolean(), ArgumentMatchers.anyBoolean(), (Option)ArgumentMatchers.any(Option.class), (Option)ArgumentMatchers.any(Option.class));
            return spyLogManager;
        }
        return logManager;
    }

    public scala.collection.Seq<File> createLogManager$default$1() {
        return Nil$.MODULE$;
    }

    public LogConfig createLogManager$default$2() {
        return new LogConfig((java.util.Map)new Properties());
    }

    public ConfigRepository createLogManager$default$3() {
        return new MockConfigRepository();
    }

    public CleanerConfig createLogManager$default$4() {
        return new CleanerConfig(false);
    }

    public MockTime createLogManager$default$5() {
        return new MockTime();
    }

    public MetadataVersion createLogManager$default$6() {
        return MetadataVersion.latestTesting();
    }

    public int createLogManager$default$7() {
        return 4;
    }

    public boolean createLogManager$default$8() {
        return false;
    }

    public Option<UnifiedLog> createLogManager$default$9() {
        return None$.MODULE$;
    }

    public boolean createLogManager$default$10() {
        return false;
    }

    public long createLogManager$default$11() {
        return 30000L;
    }

    public TestUtils.MockAlterPartitionManager createAlterIsrManager() {
        return new TestUtils.MockAlterPartitionManager();
    }

    public <B extends KafkaBroker> void produceMessages(scala.collection.Seq<B> brokers, scala.collection.Seq<ProducerRecord<byte[], byte[]>> records, int acks) {
        try (KafkaProducer producer = this.createProducer(this.plaintextBootstrapServers(brokers), acks, this.createProducer$default$3(), this.createProducer$default$4(), this.createProducer$default$5(), this.createProducer$default$6(), this.createProducer$default$7(), this.createProducer$default$8(), this.createProducer$default$9(), this.createProducer$default$10(), this.createProducer$default$11(), this.createProducer$default$12(), this.createProducer$default$13(), (Serializer)this.createProducer$default$14(), (Serializer)this.createProducer$default$15(), this.createProducer$default$16());){
            ((scala.collection.Seq)records.map((Function1 & Serializable & scala.Serializable)x$1 -> producer.send(x$1), Seq$.MODULE$.canBuildFrom())).foreach((Function1 & Serializable & scala.Serializable)x$21 -> (RecordMetadata)x$21.get());
        }
        scala.collection.Seq topics = (scala.collection.Seq)((SeqLike)records.map((Function1 & Serializable & scala.Serializable)x$22 -> x$22.topic(), Seq$.MODULE$.canBuildFrom())).distinct();
        if (this.logger().underlying().isDebugEnabled()) {
            this.logger().underlying().debug(this.msgWithLogIdent(TestUtils$.$anonfun$produceMessages$4(records, topics)));
            return;
        }
    }

    public <B extends KafkaBroker> scala.collection.Seq<String> generateAndProduceMessages(scala.collection.Seq<B> brokers, String topic, int numMessages, int acks) {
        IndexedSeq values = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numMessages).map((Function1 & Serializable & scala.Serializable)x -> TestUtils$.$anonfun$generateAndProduceMessages$1(BoxesRunTime.unboxToInt((Object)x)), IndexedSeq$.MODULE$.canBuildFrom());
        IntegerSerializer intSerializer = new IntegerSerializer();
        IndexedSeq records = (IndexedSeq)((TraversableLike)values.zipWithIndex(IndexedSeq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            if (x0$1 != null) {
                String v = (String)x0$1._1();
                int i = x0$1._2$mcI$sp();
                return new ProducerRecord(topic, (Object)intSerializer.serialize(topic, Predef$.MODULE$.int2Integer(i)), (Object)v.getBytes());
            }
            throw new MatchError(null);
        }, IndexedSeq$.MODULE$.canBuildFrom());
        this.produceMessages(brokers, (scala.collection.Seq<ProducerRecord<byte[], byte[]>>)records, acks);
        return values;
    }

    public <B extends KafkaBroker> int generateAndProduceMessages$default$4() {
        return -1;
    }

    public <B extends KafkaBroker> void produceMessage(scala.collection.Seq<B> brokers, String topic, String message, Long timestamp, int deliveryTimeoutMs, int requestTimeoutMs) {
        String x$1 = this.plaintextBootstrapServers(brokers);
        int x$4 = this.createProducer$default$2();
        long x$5 = this.createProducer$default$3();
        long x$6 = this.createProducer$default$4();
        int x$7 = this.createProducer$default$5();
        int x$8 = this.createProducer$default$7();
        int x$9 = this.createProducer$default$8();
        String x$10 = this.createProducer$default$9();
        SecurityProtocol x$11 = this.createProducer$default$11();
        Option<File> x$12 = this.createProducer$default$12();
        Option<Properties> x$13 = this.createProducer$default$13();
        ByteArraySerializer x$14 = this.createProducer$default$14();
        ByteArraySerializer x$15 = this.createProducer$default$15();
        boolean x$16 = this.createProducer$default$16();
        try (KafkaProducer producer = this.createProducer(x$1, x$4, x$5, x$6, x$7, deliveryTimeoutMs, x$8, x$9, x$10, requestTimeoutMs, x$11, x$12, x$13, (Serializer)x$14, (Serializer)x$15, x$16);){
            producer.send(new ProducerRecord(topic, null, timestamp, (Object)topic.getBytes(), (Object)message.getBytes())).get();
        }
    }

    public <B extends KafkaBroker> int produceMessages$default$3() {
        return -1;
    }

    public <B extends KafkaBroker> Long produceMessage$default$4() {
        return null;
    }

    public <B extends KafkaBroker> int produceMessage$default$5() {
        return 30000;
    }

    public <B extends KafkaBroker> int produceMessage$default$6() {
        return 20000;
    }

    /*
     * WARNING - void declaration
     */
    public <B extends KafkaBroker> void verifyTopicDeletion(KafkaZkClient zkClient, String topic, int numPartitions, scala.collection.Seq<B> brokers) {
        IndexedSeq topicPartitions = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numPartitions).map((Function1 & Serializable & scala.Serializable)x$23 -> TestUtils$.$anonfun$verifyTopicDeletion$1(topic, BoxesRunTime.unboxToInt((Object)x$23)), IndexedSeq$.MODULE$.canBuildFrom());
        if (zkClient != null) {
            long l = this.waitUntilTrue$default$4();
            long waitUntilTrue_waitTimeMs = this.waitUntilTrue$default$3();
            long waitUntilTrue_startTime = System.currentTimeMillis();
            while (!TestUtils$.$anonfun$verifyTopicDeletion$2(zkClient, topic)) {
                void waitUntilTrue_pause;
                if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                    Assertions.fail((String)TestUtils$.$anonfun$verifyTopicDeletion$3(topic));
                }
                Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
            }
            long l2 = this.waitUntilTrue$default$4();
            long waitUntilTrue_waitTimeMs2 = this.waitUntilTrue$default$3();
            long waitUntilTrue_startTime2 = System.currentTimeMillis();
            while (!TestUtils$.$anonfun$verifyTopicDeletion$4(zkClient, topic)) {
                void waitUntilTrue_pause;
                if (System.currentTimeMillis() > waitUntilTrue_startTime2 + waitUntilTrue_waitTimeMs2) {
                    Assertions.fail((String)TestUtils$.$anonfun$verifyTopicDeletion$5(topic));
                }
                Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs2), (long)waitUntilTrue_pause));
            }
        }
        long l = this.waitUntilTrue$default$4();
        long waitUntilTrue_waitTimeMs = this.waitUntilTrue$default$3();
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!brokers.forall((Function1 & Serializable & scala.Serializable)broker -> BoxesRunTime.boxToBoolean((boolean)topicPartitions$1.forall((Function1 & Serializable & scala.Serializable)tp -> BoxesRunTime.boxToBoolean((boolean)TestUtils$.$anonfun$verifyTopicDeletion$8(broker, tp)))))) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)TestUtils$.$anonfun$verifyTopicDeletion$9());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        long l3 = this.waitUntilTrue$default$4();
        long waitUntilTrue_waitTimeMs3 = this.waitUntilTrue$default$3();
        long waitUntilTrue_startTime3 = System.currentTimeMillis();
        while (!brokers.forall((Function1 & Serializable & scala.Serializable)broker -> BoxesRunTime.boxToBoolean((boolean)topicPartitions$1.forall((Function1 & Serializable & scala.Serializable)tp -> BoxesRunTime.boxToBoolean((boolean)TestUtils$.$anonfun$verifyTopicDeletion$12(broker, tp)))))) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime3 + waitUntilTrue_waitTimeMs3) {
                Assertions.fail((String)TestUtils$.$anonfun$verifyTopicDeletion$13());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs3), (long)waitUntilTrue_pause));
        }
        long l4 = this.waitUntilTrue$default$4();
        long waitUntilTrue_waitTimeMs4 = this.waitUntilTrue$default$3();
        long waitUntilTrue_startTime4 = System.currentTimeMillis();
        while (!brokers.forall((Function1 & Serializable & scala.Serializable)broker -> BoxesRunTime.boxToBoolean((boolean)topicPartitions$1.forall((Function1 & Serializable & scala.Serializable)tp -> BoxesRunTime.boxToBoolean((boolean)TestUtils$.$anonfun$verifyTopicDeletion$16(broker, tp)))))) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime4 + waitUntilTrue_waitTimeMs4) {
                Assertions.fail((String)TestUtils$.$anonfun$verifyTopicDeletion$19());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs4), (long)waitUntilTrue_pause));
        }
        long l5 = this.waitUntilTrue$default$4();
        long waitUntilTrue_waitTimeMs5 = this.waitUntilTrue$default$3();
        long waitUntilTrue_startTime5 = System.currentTimeMillis();
        while (!brokers.forall((Function1 & Serializable & scala.Serializable)broker -> BoxesRunTime.boxToBoolean((boolean)TestUtils$.$anonfun$verifyTopicDeletion$21(topicPartitions$1, broker)))) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime5 + waitUntilTrue_waitTimeMs5) {
                Assertions.fail((String)TestUtils$.$anonfun$verifyTopicDeletion$24());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs5), (long)waitUntilTrue_pause));
        }
        long l6 = this.waitUntilTrue$default$4();
        long waitUntilTrue_waitTimeMs6 = this.waitUntilTrue$default$3();
        long waitUntilTrue_startTime6 = System.currentTimeMillis();
        while (!brokers.forall((Function1 & Serializable & scala.Serializable)broker -> BoxesRunTime.boxToBoolean((boolean)TestUtils$.$anonfun$verifyTopicDeletion$26(topicPartitions$1, broker)))) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime6 + waitUntilTrue_waitTimeMs6) {
                Assertions.fail((String)TestUtils$.$anonfun$verifyTopicDeletion$30());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs6), (long)waitUntilTrue_pause));
        }
    }

    /*
     * WARNING - void declaration
     */
    public File causeLogDirFailure(TestUtils.LogDirFailureType failureType, KafkaBroker leaderBroker, TopicPartition partition) {
        File logDir = leaderBroker.replicaManager().localLogOrException(partition).dir().getParentFile();
        CoreUtils$.MODULE$.swallow((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> Utils.delete((File)logDir), (Logging)this, CoreUtils$.MODULE$.swallow$default$3());
        Files.createFile(logDir.toPath(), new FileAttribute[0]);
        Assertions.assertTrue((boolean)logDir.isFile());
        TestUtils.LogDirFailureType logDirFailureType = failureType;
        TestUtils$Roll$ testUtils$Roll$ = TestUtils$Roll$.MODULE$;
        if (!(logDirFailureType != null ? !logDirFailureType.equals(testUtils$Roll$) : testUtils$Roll$ != null)) {
            Assertions.assertThrows(KafkaStorageException.class, () -> {
                UnifiedLog qual$1 = (UnifiedLog)leaderBroker.replicaManager().getLog(partition).get();
                Option x$1 = qual$1.roll$default$1();
                qual$1.roll(x$1);
            });
        } else {
            TestUtils.LogDirFailureType logDirFailureType2 = failureType;
            TestUtils$Checkpoint$ testUtils$Checkpoint$ = TestUtils$Checkpoint$.MODULE$;
            if (!(logDirFailureType2 != null ? !logDirFailureType2.equals(testUtils$Checkpoint$) : testUtils$Checkpoint$ != null)) {
                leaderBroker.replicaManager().checkpointHighWatermarks();
            }
        }
        long l = this.waitUntilTrue$default$4();
        long waitUntilTrue_waitTimeMs = 3000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!TestUtils$.$anonfun$causeLogDirFailure$3(leaderBroker, logDir)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)TestUtils$.$anonfun$causeLogDirFailure$4());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        Assertions.assertTrue((boolean)leaderBroker.replicaManager().localLog(partition).isEmpty());
        return logDir;
    }

    public String readString(ByteBuffer buffer, String encoding) {
        byte[] bytes = new byte[buffer.remaining()];
        buffer.get(bytes);
        return new String(bytes, encoding);
    }

    public String readString$default$2() {
        return Charset.defaultCharset().toString();
    }

    public Properties sslConfigs(Mode mode, boolean clientCert, Option<File> trustStoreFile, String certAlias, String certCn, String tlsProtocol) {
        File trustStore = (File)trustStoreFile.getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new Exception("SSL enabled but no trustStoreFile provided");
        });
        java.util.Map sslConfigs = new TestSslUtils.SslConfigsBuilder(mode).useClientCert(clientCert).createNewTrustStore(trustStore).certAlias(certAlias).cn(certCn).tlsProtocol(tlsProtocol).build();
        Properties sslProps = new Properties();
        sslConfigs.forEach((k, v) -> sslProps.put(k, v));
        return sslProps;
    }

    public String sslConfigs$default$5() {
        return this.SslCertificateCn();
    }

    public String sslConfigs$default$6() {
        return TestSslUtils.DEFAULT_TLS_PROTOCOL_FOR_TESTS;
    }

    /*
     * WARNING - void declaration
     */
    public void waitAndVerifyAcls(scala.collection.immutable.Set<AccessControlEntry> expected, Authorizer authorizer, ResourcePattern resource, AccessControlEntryFilter accessControlEntryFilter) {
        String newLine = Properties$.MODULE$.lineSeparator();
        AclBindingFilter filter = new AclBindingFilter(resource.toFilter(), accessControlEntryFilter);
        long l = this.waitUntilTrue$default$4();
        long waitUntilTrue_waitTimeMs = 45000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!TestUtils$.$anonfun$waitAndVerifyAcls$1(authorizer, filter, expected)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)TestUtils$.$anonfun$waitAndVerifyAcls$3(expected, newLine, authorizer, filter));
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
    }

    /*
     * WARNING - void declaration
     */
    public void waitAndVerifyAcl(AccessControlEntry expected, Authorizer authorizer, ResourcePattern resource, AccessControlEntryFilter accessControlEntryFilter) {
        String newLine = Properties$.MODULE$.lineSeparator();
        AclBindingFilter filter = new AclBindingFilter(resource.toFilter(), accessControlEntryFilter);
        long l = this.waitUntilTrue$default$4();
        long waitUntilTrue_waitTimeMs = 45000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!TestUtils$.$anonfun$waitAndVerifyAcl$1(authorizer, filter, expected)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)TestUtils$.$anonfun$waitAndVerifyAcl$3(expected, authorizer, filter, newLine));
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
    }

    public AccessControlEntryFilter waitAndVerifyAcls$default$4() {
        return AccessControlEntryFilter.ANY;
    }

    public AccessControlEntryFilter waitAndVerifyAcl$default$4() {
        return AccessControlEntryFilter.ANY;
    }

    /*
     * WARNING - void declaration
     */
    public void waitAndVerifyRemovedAcl(AccessControlEntry expectedToRemoved, Authorizer authorizer, ResourcePattern resource, AccessControlEntryFilter accessControlEntryFilter) {
        String newLine = Properties$.MODULE$.lineSeparator();
        AclBindingFilter filter = new AclBindingFilter(resource.toFilter(), accessControlEntryFilter);
        long l = this.waitUntilTrue$default$4();
        long waitUntilTrue_waitTimeMs = 45000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!TestUtils$.$anonfun$waitAndVerifyRemovedAcl$1(authorizer, filter, expectedToRemoved)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)TestUtils$.$anonfun$waitAndVerifyRemovedAcl$3(expectedToRemoved, authorizer, filter, newLine));
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
    }

    public AccessControlEntryFilter waitAndVerifyRemovedAcl$default$4() {
        return AccessControlEntryFilter.ANY;
    }

    public boolean isAclSecure(ACL acl, boolean sensitive) {
        if (this.logger().underlying().isDebugEnabled()) {
            this.logger().underlying().debug(this.msgWithLogIdent(TestUtils$.$anonfun$isAclSecure$1(acl)));
        }
        switch (acl.getPerms()) {
            case 1: {
                if (!sensitive) {
                    String string = acl.getId().getScheme();
                    String string2 = "world";
                    if (string != null && string.equals(string2)) {
                        return true;
                    }
                }
                return false;
            }
            case 31: {
                String string = acl.getId().getScheme();
                String string3 = "sasl";
                return string != null && string.equals(string3);
            }
        }
        return false;
    }

    public boolean isAclUnsecure(ACL acl) {
        if (this.logger().underlying().isDebugEnabled()) {
            this.logger().underlying().debug(this.msgWithLogIdent(TestUtils$.$anonfun$isAclUnsecure$1(acl)));
        }
        switch (acl.getPerms()) {
            case 31: {
                String string = acl.getId().getScheme();
                String string2 = "world";
                return string != null && string.equals(string2);
            }
        }
        return false;
    }

    public scala.collection.Seq<String> secureZkPaths(KafkaZkClient zkClient) {
        return (scala.collection.Seq)((scala.collection.Seq)ZkData$.MODULE$.SecureRootPaths().$plus$plus((GenTraversableOnce)ZkData$.MODULE$.SensitiveRootPaths(), Seq$.MODULE$.canBuildFrom())).flatMap((Function1 & Serializable & scala.Serializable)path -> TestUtils$.subPaths$1(path, zkClient), Seq$.MODULE$.canBuildFrom());
    }

    public void assertConcurrent(String message, scala.collection.Seq<Function0<Object>> functions, int timeoutMs) {
        ExecutorService threadPool = Executors.newFixedThreadPool(functions.size());
        ArrayBuffer exceptions = (ArrayBuffer)ArrayBuffer$.MODULE$.apply((scala.collection.Seq)Nil$.MODULE$);
        try {
            try {
                java.util.List runnables = (java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((scala.collection.Seq)functions.map((Function1 & Serializable & scala.Serializable)function -> new Callable<BoxedUnit>(function){
                    private final Function0 function$1;

                    public void call() {
                        this.function$1.apply();
                    }
                    {
                        this.function$1 = function$1;
                    }
                }, Seq$.MODULE$.canBuildFrom())).asJava();
                ((Buffer)CollectionConverters$.MODULE$.asScalaBufferConverter(threadPool.invokeAll(runnables, timeoutMs, TimeUnit.MILLISECONDS)).asScala()).foreach((Function1 & Serializable & scala.Serializable)future -> {
                    if (future.isCancelled()) {
                        TestUtils$.failWithTimeout$1(message, timeoutMs);
                        return BoxedUnit.UNIT;
                    }
                    try {
                        return future.get();
                    }
                    catch (Exception e) {
                        return exceptions.$plus$eq((Object)e);
                    }
                });
            }
            catch (InterruptedException interruptedException) {
                TestUtils$.failWithTimeout$1(message, timeoutMs);
            }
            catch (Throwable e) {
                exceptions.$plus$eq((Object)e);
            }
        }
        finally {
            threadPool.shutdownNow();
        }
        Assertions.assertTrue((boolean)exceptions.isEmpty(), (String)new StringBuilder(26).append(message).append(" failed with exception(s) ").append(exceptions).toString());
    }

    public <K, V, B extends KafkaBroker> scala.collection.Seq<ConsumerRecord<byte[], byte[]>> consumeTopicRecords(scala.collection.Seq<B> brokers, String topic, int numMessages, String groupId, SecurityProtocol securityProtocol, Option<File> trustStoreFile, long waitTime) {
        scala.collection.Seq<ConsumerRecord<K, V>> seq;
        String x$1 = this.bootstrapServers(brokers, ListenerName.forSecurityProtocol((SecurityProtocol)securityProtocol));
        String x$5 = this.createConsumer$default$3();
        boolean x$6 = this.createConsumer$default$4();
        boolean x$7 = this.createConsumer$default$5();
        int x$8 = this.createConsumer$default$6();
        Option<Properties> x$9 = this.createConsumer$default$9();
        ByteArrayDeserializer x$10 = this.createConsumer$default$10();
        ByteArrayDeserializer x$11 = this.createConsumer$default$11();
        try (Consumer<K, V> consumer = this.createConsumer(x$1, groupId, x$5, x$6, x$7, x$8, securityProtocol, trustStoreFile, x$9, (Deserializer<K>)x$10, (Deserializer<V>)x$11);){
            consumer.subscribe(Collections.singleton(topic));
            seq = this.consumeRecords(consumer, numMessages, waitTime);
        }
        return seq;
    }

    public <K, V, B extends KafkaBroker> String consumeTopicRecords$default$4() {
        return "group";
    }

    public <K, V, B extends KafkaBroker> SecurityProtocol consumeTopicRecords$default$5() {
        return SecurityProtocol.PLAINTEXT;
    }

    public <K, V, B extends KafkaBroker> Option<File> consumeTopicRecords$default$6() {
        return None$.MODULE$;
    }

    public <K, V, B extends KafkaBroker> long consumeTopicRecords$default$7() {
        return 15000L;
    }

    public <K, V> scala.collection.Seq<ConsumerRecord<K, V>> pollUntilAtLeastNumRecords(Consumer<K, V> consumer, int numRecords, long waitTimeMs) {
        ArrayBuffer records = new ArrayBuffer();
        Function1 & Serializable & scala.Serializable x$2 = (Function1 & Serializable & scala.Serializable)polledRecords -> BoxesRunTime.boxToBoolean((boolean)TestUtils$.pollAction$1(polledRecords, records, numRecords));
        long x$5 = this.pollRecordsUntilTrue$default$5();
        long pollRecordsUntilTrue_x$3 = 0L;
        long pollRecordsUntilTrue_waitUntilTrue_startTime = System.currentTimeMillis();
        while (!TestUtils$.$anonfun$pollRecordsUntilTrue$1(consumer, x$5, x$2)) {
            if (System.currentTimeMillis() > pollRecordsUntilTrue_waitUntilTrue_startTime + waitTimeMs) {
                Assertions.fail((String)TestUtils$.$anonfun$pollUntilAtLeastNumRecords$2(records, numRecords));
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitTimeMs), pollRecordsUntilTrue_x$3));
        }
        return records;
    }

    public <K, V> long pollUntilAtLeastNumRecords$default$3() {
        return 15000L;
    }

    public <K, V> scala.collection.Seq<ConsumerRecord<K, V>> consumeRecords(Consumer<K, V> consumer, int numRecords, long waitTimeMs) {
        scala.collection.Seq<ConsumerRecord<K, V>> records = this.pollUntilAtLeastNumRecords(consumer, numRecords, waitTimeMs);
        Assertions.assertEquals((int)numRecords, (int)records.size(), (String)"Consumed more records than expected");
        return records;
    }

    public <K, V> long consumeRecords$default$3() {
        return 15000L;
    }

    public <B extends KafkaBroker> KafkaProducer<byte[], byte[]> createTransactionalProducer(String transactionalId, scala.collection.Seq<B> brokers, int batchSize, long transactionTimeoutMs, long maxBlockMs, int deliveryTimeoutMs, int requestTimeoutMs, int maxInFlight) {
        Properties props = new Properties();
        props.put("bootstrap.servers", this.plaintextBootstrapServers(brokers));
        props.put("acks", "all");
        props.put("batch.size", Integer.toString(batchSize));
        props.put("transactional.id", transactionalId);
        props.put("enable.idempotence", "true");
        props.put("transaction.timeout.ms", Long.toString(transactionTimeoutMs));
        props.put("max.block.ms", Long.toString(maxBlockMs));
        props.put("delivery.timeout.ms", Integer.toString(deliveryTimeoutMs));
        props.put("request.timeout.ms", Integer.toString(requestTimeoutMs));
        props.put("max.in.flight.requests.per.connection", Integer.toString(maxInFlight));
        return new KafkaProducer(props, (Serializer)new ByteArraySerializer(), (Serializer)new ByteArraySerializer());
    }

    public <B extends KafkaBroker> int createTransactionalProducer$default$3() {
        return 16384;
    }

    public <B extends KafkaBroker> long createTransactionalProducer$default$4() {
        return 60000L;
    }

    public <B extends KafkaBroker> long createTransactionalProducer$default$5() {
        return 60000L;
    }

    public <B extends KafkaBroker> int createTransactionalProducer$default$6() {
        return 120000;
    }

    public <B extends KafkaBroker> int createTransactionalProducer$default$7() {
        return 30000;
    }

    public <B extends KafkaBroker> int createTransactionalProducer$default$8() {
        return 5;
    }

    public <B extends KafkaBroker> void seedTopicWithNumberedRecords(String topic, int numRecords, scala.collection.Seq<B> brokers) {
        Properties props = new Properties();
        props.put("enable.idempotence", "true");
        props.put("bootstrap.servers", this.plaintextBootstrapServers(brokers));
        try (KafkaProducer producer = new KafkaProducer(props, (Serializer)new ByteArraySerializer(), (Serializer)new ByteArraySerializer());){
            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numRecords).foreach((Function1 & Serializable & scala.Serializable)i -> producer.send(new ProducerRecord(topic, (Object)TestUtils$.MODULE$.asBytes(Integer.toString(BoxesRunTime.unboxToInt((Object)i))), (Object)TestUtils$.MODULE$.asBytes(Integer.toString(BoxesRunTime.unboxToInt((Object)i))))));
            producer.flush();
        }
    }

    private String asString(byte[] bytes) {
        return new String(bytes, StandardCharsets.UTF_8);
    }

    private byte[] asBytes(String string) {
        return string.getBytes(StandardCharsets.UTF_8);
    }

    public String assertCommittedAndGetValue(ConsumerRecord<byte[], byte[]> record) {
        Option option = ((TraversableLike)CollectionConverters$.MODULE$.iterableAsScalaIterableConverter(record.headers().headers(this.kafka$utils$TestUtils$$transactionStatusKey())).asScala()).headOption();
        if (option instanceof Some) {
            Header header = (Header)((Some)option).value();
            Assertions.assertEquals((Object)this.asString(this.kafka$utils$TestUtils$$committedValue()), (Object)this.asString(header.value()), (String)new StringBuilder(57).append("Got ").append(this.asString(header.value())).append(" but expected the value to indicate ").append("committed status.").toString());
        } else if (None$.MODULE$.equals(option)) {
            BoxedUnit cfr_ignored_0 = (BoxedUnit)Assertions.fail((String)"expected the record header to include an expected transaction status, but received nothing.");
        } else {
            throw new MatchError((Object)option);
        }
        return this.recordValueAsString(record);
    }

    public String recordValueAsString(ConsumerRecord<byte[], byte[]> record) {
        return this.asString((byte[])record.value());
    }

    public ProducerRecord<byte[], byte[]> producerRecordWithExpectedTransactionStatus(String topic, Integer partition, byte[] key, byte[] value, boolean willBeCommitted) {
        Header header = new Header(willBeCommitted){
            private final boolean willBeCommitted$1;

            public String key() {
                return TestUtils$.MODULE$.kafka$utils$TestUtils$$transactionStatusKey();
            }

            public byte[] value() {
                if (this.willBeCommitted$1) {
                    return TestUtils$.MODULE$.kafka$utils$TestUtils$$committedValue();
                }
                return TestUtils$.MODULE$.kafka$utils$TestUtils$$abortedValue();
            }
            {
                this.willBeCommitted$1 = willBeCommitted$1;
            }
        };
        return new ProducerRecord(topic, partition, (Object)key, (Object)value, Collections.singleton(header));
    }

    public ProducerRecord<byte[], byte[]> producerRecordWithExpectedTransactionStatus(String topic, Integer partition, String key, String value, boolean willBeCommitted) {
        return this.producerRecordWithExpectedTransactionStatus(topic, partition, this.asBytes(key), this.asBytes(value), willBeCommitted);
    }

    public Map<TopicPartition, OffsetAndMetadata> consumerPositions(Consumer<byte[], byte[]> consumer) {
        HashMap offsetsToCommit = new HashMap();
        consumer.assignment().forEach(topicPartition -> offsetsToCommit.put(topicPartition, (Object)new OffsetAndMetadata(consumer.position(topicPartition))));
        return offsetsToCommit.toMap(Predef$.MODULE$.$conforms());
    }

    public void resetToCommittedPositions(Consumer<byte[], byte[]> consumer) {
        scala.collection.mutable.Map committed = (scala.collection.mutable.Map)((TraversableLike)((TraversableLike)CollectionConverters$.MODULE$.mapAsScalaMapConverter(consumer.committed(consumer.assignment())).asScala()).filter((Function1 & Serializable & scala.Serializable)x$31 -> BoxesRunTime.boxToBoolean((boolean)TestUtils$.$anonfun$resetToCommittedPositions$1(x$31)))).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            if (x0$1 != null) {
                TopicPartition k = (TopicPartition)x0$1._1();
                OffsetAndMetadata v = (OffsetAndMetadata)x0$1._2();
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)k), (Object)BoxesRunTime.boxToLong((long)v.offset()));
            }
            throw new MatchError(null);
        }, Map$.MODULE$.canBuildFrom());
        consumer.assignment().forEach(topicPartition -> {
            if (committed.contains(topicPartition)) {
                consumer.seek(topicPartition, BoxesRunTime.unboxToLong((Object)committed.apply(topicPartition)));
                return;
            }
            consumer.seekToBeginning(Collections.singletonList(topicPartition));
        });
    }

    public <B extends KafkaBroker> AlterConfigsResult incrementalAlterConfigs(scala.collection.Seq<B> servers, Admin adminClient, Properties props, boolean perBrokerConfig, AlterConfigOp.OpType opType) {
        Collection configEntries = CollectionConverters$.MODULE$.asJavaCollectionConverter((Iterable)((TraversableOnce)((TraversableLike)CollectionConverters$.MODULE$.propertiesAsScalaMapConverter(props).asScala()).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            if (x0$1 != null) {
                String k = (String)x0$1._1();
                String v = (String)x0$1._2();
                return new AlterConfigOp(new ConfigEntry(k, v), opType);
            }
            throw new MatchError(null);
        }, scala.collection.mutable.Iterable$.MODULE$.canBuildFrom())).toList()).asJavaCollection();
        java.util.Map configs = perBrokerConfig ? (java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)((TraversableOnce)servers.map((Function1 & Serializable & scala.Serializable)server -> {
            ConfigResource resource = new ConfigResource(ConfigResource.Type.BROKER, Integer.toString(server.config().brokerId()));
            return new Tuple2((Object)resource, (Object)configEntries);
        }, Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms())).asJava() : (java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)scala.collection.Map$.MODULE$.apply((scala.collection.Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new ConfigResource(ConfigResource.Type.BROKER, "")), (Object)configEntries)}))).asJava();
        return adminClient.incrementalAlterConfigs(configs);
    }

    public <B extends KafkaBroker> AlterConfigOp.OpType incrementalAlterConfigs$default$5() {
        return AlterConfigOp.OpType.SET;
    }

    public void assertLeader(Admin client, TopicPartition topicPartition, int expectedLeader) {
        this.waitForLeaderToBecome(client, topicPartition, (Option<Object>)new Some((Object)BoxesRunTime.boxToInteger((int)expectedLeader)));
    }

    public void assertNoLeader(Admin client, TopicPartition topicPartition) {
        this.waitForLeaderToBecome(client, topicPartition, (Option<Object>)None$.MODULE$);
    }

    /*
     * WARNING - void declaration
     */
    public void waitForOnlineBroker(Admin client, int brokerId) {
        long l = this.waitUntilTrue$default$4();
        long waitUntilTrue_waitTimeMs = this.waitUntilTrue$default$3();
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!TestUtils$.$anonfun$waitForOnlineBroker$1(client, brokerId)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)TestUtils$.$anonfun$waitForOnlineBroker$3(brokerId));
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
    }

    /*
     * WARNING - void declaration
     */
    public void waitForLeaderToBecome(Admin client, TopicPartition topicPartition, Option<Object> expectedLeaderOpt) {
        void var7_11;
        Tuple2 tuple2;
        String topic = topicPartition.topic();
        int partitionId = topicPartition.partition();
        long l = this.computeUntilTrue$default$3();
        long computeUntilTrue_waitTime = this.computeUntilTrue$default$2();
        long computeUntilTrue_startTime = System.currentTimeMillis();
        while (true) {
            void computeUntilTrue_pause;
            Try computeUntilTrue_result;
            if (TestUtils$.$anonfun$waitForLeaderToBecome$6(expectedLeaderOpt, computeUntilTrue_result = TestUtils$.currentLeader$1(client, topic, partitionId))) {
                tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)computeUntilTrue_result), (Object)BoxesRunTime.boxToBoolean((boolean)true));
                break;
            }
            if (System.currentTimeMillis() > computeUntilTrue_startTime + computeUntilTrue_waitTime) {
                tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)computeUntilTrue_result), (Object)BoxesRunTime.boxToBoolean((boolean)false));
                break;
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(computeUntilTrue_waitTime), (long)computeUntilTrue_pause));
        }
        Tuple2 tuple22 = tuple2;
        if (tuple22 == null) {
            throw new MatchError(null);
        }
        Try lastLeaderCheck = (Try)tuple22._1();
        Assertions.assertTrue((boolean)tuple22._2$mcZ$sp(), (String)new StringBuilder(80).append("Timed out waiting for leader to become ").append(expectedLeaderOpt).append(". ").append("Last metadata lookup returned leader = ").append(var7_11.getOrElse((Function0 & Serializable & scala.Serializable)() -> "unknown")).toString());
    }

    /*
     * WARNING - void declaration
     */
    public void waitForBrokersOutOfIsr(Admin client, scala.collection.immutable.Set<TopicPartition> partition, scala.collection.immutable.Set<Object> brokerIds) {
        long l = this.waitUntilTrue$default$4();
        long waitUntilTrue_waitTimeMs = this.waitUntilTrue$default$3();
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!TestUtils$.$anonfun$waitForBrokersOutOfIsr$1(client, partition, brokerIds)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)TestUtils$.$anonfun$waitForBrokersOutOfIsr$6(brokerIds, partition));
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
    }

    public scala.collection.immutable.Set<Object> currentIsr(Admin admin, TopicPartition partition) {
        return ((TraversableOnce)((TraversableLike)((scala.collection.mutable.Map)CollectionConverters$.MODULE$.mapAsScalaMapConverter((java.util.Map)admin.describeTopics((Collection)CollectionConverters$.MODULE$.setAsJavaSetConverter((scala.collection.Set)Predef$.MODULE$.Set().apply((scala.collection.Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{partition.topic()}))).asJava()).allTopicNames().get()).asScala()).values().flatMap((Function1 & Serializable & scala.Serializable)x$40 -> (Buffer)((TraversableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(x$40.partitions()).asScala()).flatMap((Function1 & Serializable & scala.Serializable)x$41 -> (Buffer)CollectionConverters$.MODULE$.asScalaBufferConverter(x$41.isr()).asScala(), Buffer$.MODULE$.canBuildFrom()), Iterable$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x$42 -> BoxesRunTime.boxToInteger((int)x$42.id()), Iterable$.MODULE$.canBuildFrom())).toSet();
    }

    /*
     * WARNING - void declaration
     */
    public void waitForBrokersInIsr(Admin client, TopicPartition partition, scala.collection.immutable.Set<Object> brokerIds) {
        long l = this.waitUntilTrue$default$4();
        long waitUntilTrue_waitTimeMs = this.waitUntilTrue$default$3();
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!TestUtils$.$anonfun$waitForBrokersInIsr$1(client, partition, brokerIds)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)TestUtils$.$anonfun$waitForBrokersInIsr$2(brokerIds, partition));
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
    }

    public void assertFutureExceptionTypeEquals(KafkaFuture<?> future, Class<? extends Throwable> clazz, Option<String> expectedErrorMessage) {
        Throwable cause = Assertions.assertThrows(ExecutionException.class, () -> future.get()).getCause();
        Assertions.assertTrue((boolean)clazz.isInstance(cause), (String)new StringBuilder(41).append("Expected an exception of type ").append(clazz.getName()).append("; got type ").append(cause.getClass().getName()).toString());
        expectedErrorMessage.foreach((Function1 & Serializable & scala.Serializable)message -> {
            TestUtils$.$anonfun$assertFutureExceptionTypeEquals$2(cause, message);
            return BoxedUnit.UNIT;
        });
    }

    public Option<String> assertFutureExceptionTypeEquals$default$3() {
        return None$.MODULE$;
    }

    public void assertBadConfigContainingMessage(Properties props, String expectedExceptionContainsText) {
        try {
            KafkaConfig$.MODULE$.fromProps(props);
            Assertions.fail((String)"Expected illegal configuration but instead it was legal");
            return;
        }
        catch (Throwable throwable) {
            if (throwable instanceof ConfigException ? true : throwable instanceof IllegalArgumentException) {
                Assertions.assertTrue((boolean)throwable.getMessage().contains(expectedExceptionContainsText), (String)new StringBuilder(21).append("\"").append(throwable.getMessage()).append("\" doesn't contain \"").append(expectedExceptionContainsText).append("\"").toString());
                return;
            }
            throw throwable;
        }
    }

    public long totalMetricValue(KafkaBroker broker, String metricName) {
        return this.totalMetricValue(broker.metrics(), metricName);
    }

    public long totalMetricValue(Metrics metrics, String metricName) {
        java.util.Map allMetrics = metrics.metrics();
        return (long)BoxesRunTime.unboxToDouble((Object)((TraversableOnce)((TraversableLike)CollectionConverters$.MODULE$.collectionAsScalaIterableConverter(allMetrics.values()).asScala()).filter((Function1 & Serializable & scala.Serializable)x$43 -> BoxesRunTime.boxToBoolean((boolean)TestUtils$.$anonfun$totalMetricValue$1(metricName, x$43)))).foldLeft((Object)BoxesRunTime.boxToDouble((double)0.0), (Function2 & Serializable & scala.Serializable)(total, metric) -> BoxesRunTime.boxToDouble((double)TestUtils$.$anonfun$totalMetricValue$2(BoxesRunTime.unboxToDouble((Object)total), metric))));
    }

    public long meterCount(String metricName) {
        return BoxesRunTime.unboxToLong((Object)this.meterCountOpt(metricName).getOrElse((Function0 & Serializable & scala.Serializable)() -> (Nothing$)Assertions.fail((String)new StringBuilder(22).append("Unable to find metric ").append(metricName).toString())));
    }

    public Option<Object> meterCountOpt(String metricName) {
        return ((MapLike)((TraversableLike)CollectionConverters$.MODULE$.mapAsScalaMapConverter(KafkaYammerMetrics.defaultRegistry().allMetrics()).asScala()).filter((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)TestUtils$.$anonfun$meterCountOpt$1(metricName, x0$1)))).values().headOption().map((Function1 & Serializable & scala.Serializable)x$44 -> BoxesRunTime.boxToLong((long)TestUtils$.$anonfun$meterCountOpt$2(x$44)));
    }

    public long metersCount(String metricName) {
        return BoxesRunTime.unboxToLong((Object)((TraversableOnce)((MapLike)((TraversableLike)CollectionConverters$.MODULE$.mapAsScalaMapConverter(KafkaYammerMetrics.defaultRegistry().allMetrics()).asScala()).filter((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)TestUtils$.$anonfun$metersCount$1(metricName, x0$1)))).values().map((Function1 & Serializable & scala.Serializable)x0$2 -> BoxesRunTime.boxToLong((long)TestUtils$.$anonfun$metersCount$2(x0$2)), Iterable$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.LongIsIntegral$.MODULE$));
    }

    public void clearYammerMetrics() {
        ((IterableLike)CollectionConverters$.MODULE$.asScalaSetConverter(KafkaYammerMetrics.defaultRegistry().allMetrics().keySet()).asScala()).foreach((Function1 & Serializable & scala.Serializable)metricName -> {
            TestUtils$.$anonfun$clearYammerMetrics$1(metricName);
            return BoxedUnit.UNIT;
        });
    }

    public void waitForAllReassignmentsToComplete(Admin adminClient, long pause) {
        long x$4 = this.waitUntilTrue$default$3();
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!TestUtils$.$anonfun$waitForAllReassignmentsToComplete$1(adminClient)) {
            if (System.currentTimeMillis() > waitUntilTrue_startTime + x$4) {
                Assertions.fail((String)TestUtils$.$anonfun$waitForAllReassignmentsToComplete$2());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(x$4), pause));
        }
    }

    public long waitForAllReassignmentsToComplete$default$2() {
        return 100L;
    }

    public <B extends KafkaBroker> Authorizer pickAuthorizerForWrite(scala.collection.Seq<B> brokers, scala.collection.Seq<ControllerServer> controllers) {
        if (controllers.isEmpty()) {
            return (Authorizer)((KafkaBroker)brokers.head()).authorizer().get();
        }
        ObjectRef result = ObjectRef.create(null);
        long retry_maxWaitMs = 120000L;
        LongRef retry_wait = LongRef.create((long)1L);
        long retry_startTime = System.currentTimeMillis();
        while (true) {
            try {
                TestUtils$.$anonfun$pickAuthorizerForWrite$1(controllers, result);
            }
            catch (AssertionError retry_e) {
                if (System.currentTimeMillis() - retry_startTime > retry_maxWaitMs) {
                    throw retry_e;
                }
                if (this.logger().underlying().isInfoEnabled()) {
                    this.logger().underlying().info(this.msgWithLogIdent(TestUtils$.$anonfun$retry$1(retry_wait)));
                }
                Thread.sleep(retry_wait.elem);
                retry_wait.elem += scala.math.package$.MODULE$.min(retry_wait.elem, 1000L);
                continue;
            }
            break;
        }
        return (Authorizer)result.elem;
    }

    public AuthorizableRequestContext anonymousAuthorizableContext() {
        return this.anonymousAuthorizableContext;
    }

    public RequestChannel.Request buildEnvelopeRequest(AbstractRequest request, KafkaPrincipalSerde principalSerde, RequestChannel.Metrics requestChannelMetrics, long startTimeNanos, long dequeueTimeNanos, boolean fromPrivilegedListener) {
        String clientId = "id";
        ListenerName listenerName = ListenerName.forSecurityProtocol((SecurityProtocol)SecurityProtocol.PLAINTEXT);
        RequestHeader requestHeader = new RequestHeader(request.apiKey(), request.version(), clientId, 0);
        ByteBuffer requestBuffer = request.serializeWithHeader(requestHeader);
        RequestHeader envelopeHeader = new RequestHeader(ApiKeys.ENVELOPE, ApiKeys.ENVELOPE.latestVersion(), clientId, 0);
        ByteBuffer envelopeBuffer = new EnvelopeRequest.Builder(requestBuffer, principalSerde.serialize(KafkaPrincipal.ANONYMOUS), InetAddress.getLocalHost().getAddress()).build().serializeWithHeader(envelopeHeader);
        RequestHeader.parse((ByteBuffer)envelopeBuffer);
        RequestContext envelopeContext = new RequestContext(envelopeHeader, "1", InetAddress.getLocalHost(), Optional.empty(), KafkaPrincipal.ANONYMOUS, listenerName, SecurityProtocol.PLAINTEXT, ClientInformation.EMPTY, fromPrivilegedListener, Optional.of(principalSerde));
        RequestChannel.Request envelopRequest = new RequestChannel.Request(1, envelopeContext, startTimeNanos, MemoryPool.NONE, envelopeBuffer, requestChannelMetrics, (Option)None$.MODULE$);
        envelopRequest.requestDequeueTimeNanos_$eq(dequeueTimeNanos);
        return envelopRequest;
    }

    public long buildEnvelopeRequest$default$5() {
        return -1L;
    }

    public boolean buildEnvelopeRequest$default$6() {
        return true;
    }

    /*
     * WARNING - void declaration
     */
    public void verifyNoUnexpectedThreads(String context) {
        void var4_8;
        Tuple2 tuple2;
        scala.collection.immutable.Set unexpectedThreadNames = (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{ControllerEventManager$.MODULE$.ControllerEventThreadName(), "kafka-producer-network-thread", AdminClientUnitTestEnv.kafkaAdminClientNetworkThreadPrefix(), "kafka-coordinator-heartbeat-thread", QuorumTestHarness$.MODULE$.ZkClientEventThreadSuffix(), "event-handler", "client-metrics-reaper", "executor-"}));
        long l = this.computeUntilTrue$default$3();
        long computeUntilTrue_waitTime = this.computeUntilTrue$default$2();
        long computeUntilTrue_startTime = System.currentTimeMillis();
        while (true) {
            void computeUntilTrue_pause;
            scala.collection.immutable.Set computeUntilTrue_result;
            if ((computeUntilTrue_result = TestUtils$.unexpectedThreads$1(unexpectedThreadNames)).isEmpty()) {
                tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)computeUntilTrue_result), (Object)BoxesRunTime.boxToBoolean((boolean)true));
                break;
            }
            if (System.currentTimeMillis() > computeUntilTrue_startTime + computeUntilTrue_waitTime) {
                tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)computeUntilTrue_result), (Object)BoxesRunTime.boxToBoolean((boolean)false));
                break;
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(computeUntilTrue_waitTime), (long)computeUntilTrue_pause));
        }
        Tuple2 tuple22 = tuple2;
        if (tuple22 == null) {
            throw new MatchError(null);
        }
        scala.collection.immutable.Set unexpected = (scala.collection.immutable.Set)tuple22._1();
        Assertions.assertTrue((boolean)var4_8.isEmpty(), (String)new StringBuilder(35).append("Found ").append(var4_8.size()).append(" unexpected threads during ").append(context).append(": ").append(var4_8.mkString("`", ",", "`")).toString());
    }

    public static final /* synthetic */ Properties $anonfun$createBrokerConfigs$1(String zkConnect$1, boolean enableControlledShutdown$1, boolean enableDeleteTopic$1, Option interBrokerSecurityProtocol$1, Option trustStoreFile$1, Option saslProperties$1, boolean enablePlaintext$1, boolean enableSsl$1, boolean enableSaslPlaintext$1, boolean enableSaslSsl$1, Map rackInfo$1, int logDirCount$1, boolean enableToken$1, int numPartitions$1, short defaultReplicationFactor$1, boolean enableFetchFromFollower$1, int node) {
        int x$5 = MODULE$.RandomPort();
        Option x$13 = rackInfo$1.get((Object)BoxesRunTime.boxToInteger((int)node));
        int x$19 = MODULE$.createBrokerConfig$default$11();
        int x$20 = MODULE$.createBrokerConfig$default$13();
        int x$21 = MODULE$.createBrokerConfig$default$15();
        return MODULE$.createBrokerConfig(node, zkConnect$1, enableControlledShutdown$1, enableDeleteTopic$1, x$5, (Option<SecurityProtocol>)interBrokerSecurityProtocol$1, (Option<File>)trustStoreFile$1, (Option<Properties>)saslProperties$1, enablePlaintext$1, enableSaslPlaintext$1, x$19, enableSsl$1, x$20, enableSaslSsl$1, x$21, (Option<String>)x$13, logDirCount$1, enableToken$1, numPartitions$1, defaultReplicationFactor$1, enableFetchFromFollower$1);
    }

    public static final /* synthetic */ boolean $anonfun$bootstrapServers$2(ListenerName listenerName$1, EndPoint x$2) {
        ListenerName listenerName = x$2.listenerName();
        return !(listenerName != null ? !listenerName.equals(listenerName$1) : listenerName$1 != null);
    }

    public static final /* synthetic */ boolean $anonfun$createBrokerConfig$2(SecurityProtocol protocol$1, SecurityProtocol x$3) {
        SecurityProtocol securityProtocol = x$3;
        return !(securityProtocol != null ? !securityProtocol.equals(protocol$1) : protocol$1 != null);
    }

    private static final boolean shouldEnable$1(SecurityProtocol protocol, Option interBrokerSecurityProtocol$2) {
        return BoxesRunTime.unboxToBoolean((Object)interBrokerSecurityProtocol$2.fold((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> false, (Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)TestUtils$.$anonfun$createBrokerConfig$2(protocol, x$3))));
    }

    public static final /* synthetic */ Object $anonfun$createBrokerConfig$5(int i) {
        if (i % 2 == 0) {
            return MODULE$.tempDir().getAbsolutePath();
        }
        return MODULE$.tempRelativeDir("data");
    }

    public static final /* synthetic */ boolean $anonfun$createBrokerConfig$7(Tuple2 x0$2) {
        if (x0$2 != null) {
            SecurityProtocol protocol = (SecurityProtocol)x0$2._1();
            return MODULE$.usesSslTransportLayer(protocol);
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ boolean $anonfun$createBrokerConfig$8(Tuple2 x0$3) {
        if (x0$3 != null) {
            SecurityProtocol protocol = (SecurityProtocol)x0$3._1();
            return MODULE$.usesSaslAuthentication(protocol);
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ java.util.List $anonfun$createTopicWithAdminRaw$2(java.util.HashMap assignment$1, int x0$1, scala.collection.Seq x1$1) {
        ArrayList replicas = new ArrayList();
        x1$1.foreach((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)r -> replicas.add(BoxesRunTime.boxToInteger((int)r)));
        return assignment$1.put(BoxesRunTime.boxToInteger((int)x0$1), replicas);
    }

    private final boolean isTopicExistsAndHasSameNumPartitionsAndReplicationFactor$1(Throwable cause, scala.collection.Seq brokers$1, String topic$1, int effectiveNumPartitions$1, Admin admin$1, int replicationFactor$1) {
        return cause != null && cause instanceof TopicExistsException && this.waitForAllPartitionsMetadata(brokers$1, topic$1, effectiveNumPartitions$1).nonEmpty() && this.topicHasSameNumPartitionsAndReplicationFactor(admin$1, topic$1, effectiveNumPartitions$1, replicationFactor$1);
    }

    public static final /* synthetic */ boolean $anonfun$createTopic$1(AdminZkClient adminZkClient$1, String topic$2, int numPartitions$2, int replicationFactor$2, Properties topicConfig$1) {
        boolean hasSessionExpirationException = false;
        try {
            adminZkClient$1.createTopic(topic$2, numPartitions$2, replicationFactor$2, topicConfig$1, adminZkClient$1.createTopic$default$5(), adminZkClient$1.createTopic$default$6());
        }
        catch (KeeperException.SessionExpiredException sessionExpiredException) {
            hasSessionExpirationException = true;
        }
        catch (Throwable throwable) {
            throw throwable;
        }
        return !hasSessionExpirationException;
    }

    public static final /* synthetic */ String $anonfun$createTopic$2(String topic$2) {
        return new StringBuilder(19).append("Can't create topic ").append(topic$2).toString();
    }

    public static final /* synthetic */ boolean $anonfun$createTopic$6(AdminZkClient adminZkClient$2, String topic$3, Properties topicConfig$2, Map partitionReplicaAssignment$1) {
        boolean hasSessionExpirationException = false;
        try {
            adminZkClient$2.createTopicWithAssignment(topic$3, topicConfig$2, partitionReplicaAssignment$1, adminZkClient$2.createTopicWithAssignment$default$4(), adminZkClient$2.createTopicWithAssignment$default$5());
        }
        catch (KeeperException.SessionExpiredException sessionExpiredException) {
            hasSessionExpirationException = true;
        }
        catch (Throwable throwable) {
            throw throwable;
        }
        return !hasSessionExpirationException;
    }

    public static final /* synthetic */ String $anonfun$createTopic$7(String topic$3) {
        return new StringBuilder(19).append("Can't create topic ").append(topic$3).toString();
    }

    private static final Option getPartitionLeader$1(String topic, int partition, KafkaZkClient zkClient$1, boolean ignoreNoLeader$1) {
        return zkClient$1.getLeaderForPartition(new TopicPartition(topic, partition)).filter((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)p -> !ignoreNoLeader$1 || p != LeaderAndIsr$.MODULE$.NoLeader());
    }

    public static final /* synthetic */ boolean $anonfun$waitUntilLeaderIsElectedOrChangedWithAdmin$1(int partition$1, TopicPartitionInfo x$8) {
        return x$8.partition() == partition$1;
    }

    private static final Option getPartitionLeader$2(String topic, int partition, Admin admin$2) {
        return ((IterableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(((TopicDescription)((java.util.Map)admin$2.describeTopics(Collections.singletonList(topic)).allTopicNames().get()).get(topic)).partitions()).asScala()).find((Function1 & Serializable & scala.Serializable)x$8 -> BoxesRunTime.boxToBoolean((boolean)TestUtils$.$anonfun$waitUntilLeaderIsElectedOrChangedWithAdmin$1(partition, x$8))).flatMap((Function1 & Serializable & scala.Serializable)p -> {
            if (p.leader().id() == Node.noNode().id()) {
                return None$.MODULE$;
            }
            return new Some((Object)BoxesRunTime.boxToInteger((int)p.leader().id()));
        });
    }

    public static final /* synthetic */ String $anonfun$doWaitUntilLeaderIsElectedOrChanged$2(TopicPartition topicPartition$1, Option oldLeaderOpt$1, Option newLeaderOpt$1) {
        return new StringBuilder(90).append("Waiting for leader to be elected or changed for partition ").append(topicPartition$1).append(", old leader is ").append(oldLeaderOpt$1).append(", ").append("new leader is ").append(newLeaderOpt$1).toString();
    }

    public static final /* synthetic */ String $anonfun$doWaitUntilLeaderIsElectedOrChanged$3(int l$1, TopicPartition topicPartition$1) {
        return new StringBuilder(46).append("Expected new leader ").append(l$1).append(" is elected for partition ").append(topicPartition$1).toString();
    }

    public static final /* synthetic */ String $anonfun$doWaitUntilLeaderIsElectedOrChanged$4(TopicPartition topicPartition$1, int oldLeader$1, int l$1) {
        return new StringBuilder(42).append("Leader for partition ").append(topicPartition$1).append(" is changed from ").append(oldLeader$1).append(" to ").append(l$1).toString();
    }

    public static final /* synthetic */ String $anonfun$doWaitUntilLeaderIsElectedOrChanged$5(int l$1, TopicPartition topicPartition$1) {
        return new StringBuilder(33).append("Leader ").append(l$1).append(" is elected for partition ").append(topicPartition$1).toString();
    }

    public static final /* synthetic */ String $anonfun$doWaitUntilLeaderIsElectedOrChanged$6(TopicPartition topicPartition$1, int l$1) {
        return new StringBuilder(33).append("Current leader for partition ").append(topicPartition$1).append(" is ").append(l$1).toString();
    }

    public static final /* synthetic */ String $anonfun$doWaitUntilLeaderIsElectedOrChanged$7(TopicPartition topicPartition$1) {
        return new StringBuilder(40).append("Leader for partition ").append(topicPartition$1).append(" is not elected yet").toString();
    }

    public static final /* synthetic */ String $anonfun$retry$1(LongRef wait$1) {
        return new StringBuilder(49).append("Attempt failed, sleeping for ").append(wait$1.elem).append(", and then retrying.").toString();
    }

    public static final /* synthetic */ boolean $anonfun$pollUntilTrue$1(Consumer consumer$1, Function0 action$1) {
        consumer$1.poll(java.time.Duration.ofMillis(100L));
        return action$1.apply$mcZ$sp();
    }

    public static final /* synthetic */ boolean $anonfun$pollRecordsUntilTrue$1(Consumer consumer$2, long pollTimeoutMs$1, Function1 action$2) {
        ConsumerRecords records = consumer$2.poll(java.time.Duration.ofMillis(pollTimeoutMs$1));
        return BoxesRunTime.unboxToBoolean((Object)action$2.apply((Object)records));
    }

    public static final /* synthetic */ Either $anonfun$tryUntilNoAssertionError$1(Function0 assertions$1) {
        try {
            Object res = assertions$1.apply();
            return scala.package$.MODULE$.Left().apply(res);
        }
        catch (AssertionError ae) {
            return scala.package$.MODULE$.Right().apply((Object)ae);
        }
    }

    public static final /* synthetic */ boolean $anonfun$findLeaderEpoch$1(int brokerId$1, KafkaBroker x$10) {
        return x$10.config().brokerId() == brokerId$1;
    }

    public static final /* synthetic */ boolean $anonfun$findFollowerId$1(TopicPartition topicPartition$3, KafkaBroker server) {
        Option option = server.replicaManager().onlinePartition(topicPartition$3);
        if (option instanceof Some) {
            return !((Partition)((Some)option).value()).leaderReplicaIdOpt().contains((Object)BoxesRunTime.boxToInteger((int)server.config().brokerId()));
        }
        if (None$.MODULE$.equals(option)) {
            return false;
        }
        throw new MatchError((Object)option);
    }

    public static final /* synthetic */ int $anonfun$findFollowerId$2(KafkaBroker x$12) {
        return x$12.config().brokerId();
    }

    public static final /* synthetic */ int $anonfun$waitUntilBrokerMetadataIsPropagated$1(KafkaBroker x$13) {
        return x$13.config().brokerId();
    }

    public static final /* synthetic */ boolean $anonfun$waitUntilBrokerMetadataIsPropagated$3(scala.collection.immutable.Set expectedBrokerIds$1, KafkaBroker server) {
        scala.collection.immutable.Set set = expectedBrokerIds$1;
        scala.collection.immutable.Set set2 = ((TraversableOnce)server.dataPlaneRequestProcessor().metadataCache().getAliveBrokers().map((Function1 & Serializable & scala.Serializable)x$14 -> BoxesRunTime.boxToInteger((int)x$14.id), Iterable$.MODULE$.canBuildFrom())).toSet();
        return !(set != null ? !set.equals(set2) : set2 != null);
    }

    public static final /* synthetic */ String $anonfun$waitUntilBrokerMetadataIsPropagated$5() {
        return "Timed out waiting for broker metadata to propagate to all servers";
    }

    public static final /* synthetic */ boolean $anonfun$waitForAllPartitionsMetadata$2(int expectedNumPartitions$1, String topic$4, KafkaBroker broker) {
        if (expectedNumPartitions$1 == 0) {
            Option option = broker.metadataCache().numPartitions(topic$4);
            None$ none$ = None$.MODULE$;
            return !(option != null ? !option.equals(none$) : none$ != null);
        }
        Option option = broker.metadataCache().numPartitions(topic$4);
        Some some = new Some((Object)BoxesRunTime.boxToInteger((int)expectedNumPartitions$1));
        return option != null && option.equals(some);
    }

    public static final /* synthetic */ String $anonfun$waitForAllPartitionsMetadata$3(String topic$4) {
        return new StringBuilder(47).append("Topic [").append(topic$4).append("] metadata not propagated after 60000 ms").toString();
    }

    public static final /* synthetic */ boolean $anonfun$waitForPartitionMetadata$2(String topic$5, int partition$2, KafkaBroker broker) {
        Option option = broker.metadataCache().getPartitionInfo(topic$5, partition$2);
        if (option instanceof Some) {
            return FetchRequest.isValidBrokerId((int)((UpdateMetadataRequestData.UpdateMetadataPartitionState)((Some)option).value()).leader());
        }
        return false;
    }

    public static final /* synthetic */ String $anonfun$waitForPartitionMetadata$3(String topic$5, int partition$2, long timeout$1) {
        return new StringOps(Predef$.MODULE$.augmentString("Partition [%s,%d] metadata not propagated after %d ms")).format((scala.collection.Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{topic$5, BoxesRunTime.boxToInteger((int)partition$2), BoxesRunTime.boxToLong((long)timeout$1)}));
    }

    public static final /* synthetic */ boolean $anonfun$ensureConsistentKRaftMetadata$2(long controllerOffset$1, KafkaBroker broker) {
        return ((BrokerServer)broker).sharedServer().loader().lastAppliedOffset() >= controllerOffset$1;
    }

    public static final /* synthetic */ boolean $anonfun$awaitLeaderChange$2(Partition x$16) {
        return x$16.leaderLogIfLocal().isDefined();
    }

    public static final /* synthetic */ boolean $anonfun$awaitLeaderChange$1(int oldLeader$2, TopicPartition tp$1, KafkaBroker broker) {
        return broker.config().brokerId() != oldLeader$2 && broker.replicaManager().onlinePartition(tp$1).exists((Function1 & Serializable & scala.Serializable)x$16 -> BoxesRunTime.boxToBoolean((boolean)TestUtils$.$anonfun$awaitLeaderChange$2(x$16)));
    }

    public static final /* synthetic */ int $anonfun$awaitLeaderChange$3(KafkaBroker x$17) {
        return x$17.config().brokerId();
    }

    private static final Option newLeaderExists$1(scala.collection.Seq brokers$7, int oldLeader$2, TopicPartition tp$1) {
        return brokers$7.find((Function1 & Serializable & scala.Serializable)broker -> BoxesRunTime.boxToBoolean((boolean)TestUtils$.$anonfun$awaitLeaderChange$1(oldLeader$2, tp$1, broker))).map((Function1 & Serializable & scala.Serializable)x$17 -> BoxesRunTime.boxToInteger((int)TestUtils$.$anonfun$awaitLeaderChange$3(x$17)));
    }

    public static final /* synthetic */ boolean $anonfun$awaitLeaderChange$4(scala.collection.Seq brokers$7, int oldLeader$2, TopicPartition tp$1) {
        return TestUtils$.newLeaderExists$1(brokers$7, oldLeader$2, tp$1).isDefined();
    }

    public static final /* synthetic */ String $anonfun$awaitLeaderChange$5(TopicPartition tp$1, long timeout$3) {
        return new StringBuilder(54).append("Did not observe leader change for partition ").append(tp$1).append(" after ").append(timeout$3).append(" ms").toString();
    }

    public static final /* synthetic */ boolean $anonfun$waitUntilLeaderIsKnown$2(Partition x$18) {
        return x$18.leaderLogIfLocal().isDefined();
    }

    public static final /* synthetic */ boolean $anonfun$waitUntilLeaderIsKnown$1(TopicPartition tp$2, KafkaBroker broker) {
        return broker.replicaManager().onlinePartition(tp$2).exists((Function1 & Serializable & scala.Serializable)x$18 -> BoxesRunTime.boxToBoolean((boolean)TestUtils$.$anonfun$waitUntilLeaderIsKnown$2(x$18)));
    }

    public static final /* synthetic */ int $anonfun$waitUntilLeaderIsKnown$3(KafkaBroker x$19) {
        return x$19.config().brokerId();
    }

    private static final Option leaderIfExists$1(scala.collection.Seq brokers$8, TopicPartition tp$2) {
        return brokers$8.find((Function1 & Serializable & scala.Serializable)broker -> BoxesRunTime.boxToBoolean((boolean)TestUtils$.$anonfun$waitUntilLeaderIsKnown$1(tp$2, broker))).map((Function1 & Serializable & scala.Serializable)x$19 -> BoxesRunTime.boxToInteger((int)TestUtils$.$anonfun$waitUntilLeaderIsKnown$3(x$19)));
    }

    public static final /* synthetic */ boolean $anonfun$waitUntilLeaderIsKnown$4(scala.collection.Seq brokers$8, TopicPartition tp$2) {
        return TestUtils$.leaderIfExists$1(brokers$8, tp$2).isDefined();
    }

    public static final /* synthetic */ String $anonfun$waitUntilLeaderIsKnown$5(TopicPartition tp$2, long timeout$4) {
        return new StringBuilder(41).append("Partition ").append(tp$2).append(" leaders not made yet after ").append(timeout$4).append(" ms").toString();
    }

    public static final /* synthetic */ boolean $anonfun$assertNoNonDaemonThreads$1(String threadNamePrefix$1, Thread t) {
        return !t.isDaemon() && t.isAlive() && t.getName().startsWith(threadNamePrefix$1);
    }

    public static final /* synthetic */ String $anonfun$formatDirectories$1(Seq directories$1) {
        return new StringBuilder(33).append("Formatted storage directory(ies) ").append(directories$1).toString();
    }

    public static final /* synthetic */ String $anonfun$produceMessages$4(scala.collection.Seq records$1, scala.collection.Seq topics$1) {
        return new StringBuilder(26).append("Sent ").append(records$1.size()).append(" messages for topics ").append(topics$1.mkString(",")).toString();
    }

    public static final /* synthetic */ String $anonfun$generateAndProduceMessages$1(int x) {
        return new StringBuilder(5).append("test-").append(x).toString();
    }

    public static final /* synthetic */ TopicPartition $anonfun$verifyTopicDeletion$1(String topic$7, int x$23) {
        return new TopicPartition(topic$7, x$23);
    }

    public static final /* synthetic */ boolean $anonfun$verifyTopicDeletion$2(KafkaZkClient zkClient$3, String topic$7) {
        return !zkClient$3.isTopicMarkedForDeletion(topic$7);
    }

    public static final /* synthetic */ String $anonfun$verifyTopicDeletion$3(String topic$7) {
        return new StringOps(Predef$.MODULE$.augmentString("Admin path /admin/delete_topics/%s path not deleted even after a replica is restarted")).format((scala.collection.Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{topic$7}));
    }

    public static final /* synthetic */ boolean $anonfun$verifyTopicDeletion$4(KafkaZkClient zkClient$3, String topic$7) {
        return !zkClient$3.topicExists(topic$7);
    }

    public static final /* synthetic */ String $anonfun$verifyTopicDeletion$5(String topic$7) {
        return new StringOps(Predef$.MODULE$.augmentString("Topic path /brokers/topics/%s not deleted after /admin/delete_topics/%s path is deleted")).format((scala.collection.Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{topic$7, topic$7}));
    }

    public static final /* synthetic */ boolean $anonfun$verifyTopicDeletion$8(KafkaBroker broker$1, TopicPartition tp) {
        return broker$1.replicaManager().onlinePartition(tp).isEmpty();
    }

    public static final /* synthetic */ String $anonfun$verifyTopicDeletion$9() {
        return "Replica manager's should have deleted all of this topic's partitions";
    }

    public static final /* synthetic */ boolean $anonfun$verifyTopicDeletion$12(KafkaBroker broker$2, TopicPartition tp) {
        LogManager qual$1 = broker$2.logManager();
        boolean x$2 = qual$1.getLog$default$2();
        return qual$1.getLog(tp, x$2).isEmpty();
    }

    public static final /* synthetic */ String $anonfun$verifyTopicDeletion$13() {
        return "Replica logs not deleted after delete topic is complete";
    }

    public static final /* synthetic */ boolean $anonfun$verifyTopicDeletion$18(TopicPartition tp$3, Map checkpointsPerLogDir) {
        return !checkpointsPerLogDir.contains((Object)tp$3);
    }

    public static final /* synthetic */ boolean $anonfun$verifyTopicDeletion$16(KafkaBroker broker$3, TopicPartition tp) {
        return ((scala.collection.Seq)broker$3.logManager().liveLogDirs().map((Function1 & Serializable & scala.Serializable)logDir -> new OffsetCheckpointFile(new File((File)logDir, "cleaner-offset-checkpoint"), OffsetCheckpointFile$.MODULE$.$lessinit$greater$default$2()).read(), Seq$.MODULE$.canBuildFrom())).forall((Function1 & Serializable & scala.Serializable)checkpointsPerLogDir -> BoxesRunTime.boxToBoolean((boolean)TestUtils$.$anonfun$verifyTopicDeletion$18(tp, checkpointsPerLogDir)));
    }

    public static final /* synthetic */ String $anonfun$verifyTopicDeletion$19() {
        return "Cleaner offset for deleted partition should have been removed";
    }

    public static final /* synthetic */ boolean $anonfun$verifyTopicDeletion$23(String logDir$1, TopicPartition tp) {
        return !new File(logDir$1, new StringBuilder(1).append(tp.topic()).append("-").append(tp.partition()).toString()).exists();
    }

    public static final /* synthetic */ boolean $anonfun$verifyTopicDeletion$21(IndexedSeq topicPartitions$1, KafkaBroker broker) {
        return broker.config().logDirs().forall((Function1 & Serializable & scala.Serializable)logDir -> BoxesRunTime.boxToBoolean((boolean)topicPartitions$1.forall((Function1 & Serializable & scala.Serializable)tp -> BoxesRunTime.boxToBoolean((boolean)TestUtils$.$anonfun$verifyTopicDeletion$23(logDir, tp)))));
    }

    public static final /* synthetic */ String $anonfun$verifyTopicDeletion$24() {
        return "Failed to soft-delete the data to a delete directory";
    }

    public static final /* synthetic */ boolean $anonfun$verifyTopicDeletion$29(TopicPartition tp$4, String[] partitionDirectoryName) {
        return new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])partitionDirectoryName)).startsWith((GenSeq)Predef$.MODULE$.wrapString(new StringBuilder(1).append(tp$4.topic()).append("-").append(tp$4.partition()).toString())) && new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])partitionDirectoryName)).endsWith((GenSeq)Predef$.MODULE$.wrapString(UnifiedLog$.MODULE$.DeleteDirSuffix()));
    }

    public static final /* synthetic */ boolean $anonfun$verifyTopicDeletion$28(String logDir$2, TopicPartition tp) {
        return !((IterableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(Arrays.asList((Object[])new String[][]{new File(logDir$2).list()})).asScala()).exists((Function1 & Serializable & scala.Serializable)partitionDirectoryName -> BoxesRunTime.boxToBoolean((boolean)TestUtils$.$anonfun$verifyTopicDeletion$29(tp, partitionDirectoryName)));
    }

    public static final /* synthetic */ boolean $anonfun$verifyTopicDeletion$26(IndexedSeq topicPartitions$1, KafkaBroker broker) {
        return broker.config().logDirs().forall((Function1 & Serializable & scala.Serializable)logDir -> BoxesRunTime.boxToBoolean((boolean)topicPartitions$1.forall((Function1 & Serializable & scala.Serializable)tp -> BoxesRunTime.boxToBoolean((boolean)TestUtils$.$anonfun$verifyTopicDeletion$28(logDir, tp)))));
    }

    public static final /* synthetic */ String $anonfun$verifyTopicDeletion$30() {
        return "Failed to hard-delete the delete directory";
    }

    public static final /* synthetic */ boolean $anonfun$causeLogDirFailure$3(KafkaBroker leaderBroker$1, File logDir$3) {
        return !leaderBroker$1.logManager().isLogDirOnline(logDir$3.getAbsolutePath());
    }

    public static final /* synthetic */ String $anonfun$causeLogDirFailure$4() {
        return "Expected log directory offline";
    }

    public static final /* synthetic */ boolean $anonfun$waitAndVerifyAcls$1(Authorizer authorizer$1, AclBindingFilter filter$1, scala.collection.immutable.Set expected$1) {
        scala.collection.immutable.Set set = ((TraversableOnce)((TraversableLike)CollectionConverters$.MODULE$.iterableAsScalaIterableConverter(authorizer$1.acls(filter$1)).asScala()).map((Function1 & Serializable & scala.Serializable)x$24 -> x$24.entry(), Iterable$.MODULE$.canBuildFrom())).toSet();
        return !(set != null ? !set.equals(expected$1) : expected$1 != null);
    }

    public static final /* synthetic */ String $anonfun$waitAndVerifyAcls$3(scala.collection.immutable.Set expected$1, String newLine$1, Authorizer authorizer$1, AclBindingFilter filter$1) {
        return new StringBuilder(22).append("expected acls:").append(expected$1.mkString(new StringBuilder(1).append(newLine$1).append("\t").toString(), new StringBuilder(1).append(newLine$1).append("\t").toString(), newLine$1)).append("but got:").append(((TraversableOnce)((TraversableLike)CollectionConverters$.MODULE$.iterableAsScalaIterableConverter(authorizer$1.acls(filter$1)).asScala()).map((Function1 & Serializable & scala.Serializable)x$25 -> x$25.entry(), Iterable$.MODULE$.canBuildFrom())).mkString(new StringBuilder(1).append(newLine$1).append("\t").toString(), new StringBuilder(1).append(newLine$1).append("\t").toString(), newLine$1)).toString();
    }

    public static final /* synthetic */ boolean $anonfun$waitAndVerifyAcl$1(Authorizer authorizer$2, AclBindingFilter filter$2, AccessControlEntry expected$2) {
        return ((TraversableOnce)((TraversableLike)CollectionConverters$.MODULE$.iterableAsScalaIterableConverter(authorizer$2.acls(filter$2)).asScala()).map((Function1 & Serializable & scala.Serializable)x$26 -> x$26.entry(), Iterable$.MODULE$.canBuildFrom())).toSet().contains((Object)expected$2);
    }

    public static final /* synthetic */ String $anonfun$waitAndVerifyAcl$3(AccessControlEntry expected$2, Authorizer authorizer$2, AclBindingFilter filter$2, String newLine$2) {
        return new StringBuilder(33).append("expected to contain acl: ").append(expected$2).append("but got:").append(((TraversableOnce)((TraversableLike)CollectionConverters$.MODULE$.iterableAsScalaIterableConverter(authorizer$2.acls(filter$2)).asScala()).map((Function1 & Serializable & scala.Serializable)x$27 -> x$27.entry(), Iterable$.MODULE$.canBuildFrom())).mkString(new StringBuilder(1).append(newLine$2).append("\t").toString(), new StringBuilder(1).append(newLine$2).append("\t").toString(), newLine$2)).toString();
    }

    public static final /* synthetic */ boolean $anonfun$waitAndVerifyRemovedAcl$1(Authorizer authorizer$3, AclBindingFilter filter$3, AccessControlEntry expectedToRemoved$1) {
        return !((TraversableOnce)((TraversableLike)CollectionConverters$.MODULE$.iterableAsScalaIterableConverter(authorizer$3.acls(filter$3)).asScala()).map((Function1 & Serializable & scala.Serializable)x$28 -> x$28.entry(), Iterable$.MODULE$.canBuildFrom())).toSet().contains((Object)expectedToRemoved$1);
    }

    public static final /* synthetic */ String $anonfun$waitAndVerifyRemovedAcl$3(AccessControlEntry expectedToRemoved$1, Authorizer authorizer$3, AclBindingFilter filter$3, String newLine$3) {
        return new StringBuilder(37).append("expected acl to be removed : ").append(expectedToRemoved$1).append("but got:").append(((TraversableOnce)((TraversableLike)CollectionConverters$.MODULE$.iterableAsScalaIterableConverter(authorizer$3.acls(filter$3)).asScala()).map((Function1 & Serializable & scala.Serializable)x$29 -> x$29.entry(), Iterable$.MODULE$.canBuildFrom())).mkString(new StringBuilder(1).append(newLine$3).append("\t").toString(), new StringBuilder(1).append(newLine$3).append("\t").toString(), newLine$3)).toString();
    }

    public static final /* synthetic */ String $anonfun$isAclSecure$1(ACL acl$1) {
        return new StringBuilder(4).append("ACL ").append(acl$1).toString();
    }

    public static final /* synthetic */ String $anonfun$isAclUnsecure$1(ACL acl$2) {
        return new StringBuilder(4).append("ACL ").append(acl$2).toString();
    }

    private static final scala.collection.Seq subPaths$1(String path2, KafkaZkClient zkClient$4) {
        if (zkClient$4.pathExists(path2)) {
            return (scala.collection.Seq)((SeqLike)((TraversableLike)zkClient$4.getChildren(path2).map((Function1 & Serializable & scala.Serializable)c -> new StringBuilder(1).append(path2).append("/").append((String)c).toString(), Seq$.MODULE$.canBuildFrom())).flatMap((Function1 & Serializable & scala.Serializable)path -> TestUtils$.subPaths$1(path, zkClient$4), Seq$.MODULE$.canBuildFrom())).$plus$colon((Object)path2, Seq$.MODULE$.canBuildFrom());
        }
        return Nil$.MODULE$;
    }

    private static final void failWithTimeout$1(String message$1, int timeoutMs$2) {
        Assertions.fail((String)new StringBuilder(66).append(message$1).append(". Timed out, the concurrent functions took more than ").append(timeoutMs$2).append(" milliseconds").toString());
    }

    private static final boolean pollAction$1(ConsumerRecords polledRecords, ArrayBuffer records$2, int numRecords$1) {
        records$2.$plus$plus$eq((TraversableOnce)CollectionConverters$.MODULE$.iterableAsScalaIterableConverter((java.lang.Iterable)polledRecords).asScala());
        return records$2.size() >= numRecords$1;
    }

    public static final /* synthetic */ String $anonfun$pollUntilAtLeastNumRecords$2(ArrayBuffer records$2, int numRecords$1) {
        return new StringBuilder(65).append("Consumed ").append(records$2.size()).append(" records before timeout instead of the expected ").append(numRecords$1).append(" records").toString();
    }

    public static final /* synthetic */ boolean $anonfun$resetToCommittedPositions$1(Tuple2 x$31) {
        return x$31._2() != null;
    }

    public static final /* synthetic */ boolean $anonfun$waitForOnlineBroker$2(int brokerId$2, Node x$32) {
        return x$32.id() == brokerId$2;
    }

    public static final /* synthetic */ boolean $anonfun$waitForOnlineBroker$1(Admin client$1, int brokerId$2) {
        Collection nodes = (Collection)client$1.describeCluster().nodes().get();
        return ((IterableLike)CollectionConverters$.MODULE$.collectionAsScalaIterableConverter(nodes).asScala()).exists((Function1 & Serializable & scala.Serializable)x$32 -> BoxesRunTime.boxToBoolean((boolean)TestUtils$.$anonfun$waitForOnlineBroker$2(brokerId$2, x$32)));
    }

    public static final /* synthetic */ String $anonfun$waitForOnlineBroker$3(int brokerId$2) {
        return new StringBuilder(46).append("Timed out waiting for brokerId ").append(brokerId$2).append(" to come online").toString();
    }

    public static final /* synthetic */ boolean $anonfun$waitForLeaderToBecome$2(int partitionId$1, TopicPartitionInfo x$33) {
        return x$33.partition() == partitionId$1;
    }

    private static final Try currentLeader$1(Admin client$2, String topic$9, int partitionId$1) {
        return Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
            TopicDescription topicDescription = (TopicDescription)((java.util.Map)client$2.describeTopics((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter((scala.collection.Seq)new .colon.colon((Object)topic$9, (List)Nil$.MODULE$)).asJava()).allTopicNames().get()).get(topic$9);
            return ((IterableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(topicDescription.partitions()).asScala()).find((Function1 & Serializable & scala.Serializable)x$33 -> BoxesRunTime.boxToBoolean((boolean)TestUtils$.$anonfun$waitForLeaderToBecome$2(partitionId$1, x$33))).flatMap((Function1 & Serializable & scala.Serializable)partitionState -> Option$.MODULE$.apply((Object)partitionState.leader())).map((Function1 & Serializable & scala.Serializable)x$34 -> BoxesRunTime.boxToInteger((int)x$34.id()));
        });
    }

    public static final /* synthetic */ boolean $anonfun$waitForLeaderToBecome$6(Option expectedLeaderOpt$1, Try x0$1) {
        boolean bl = false;
        Failure failure = null;
        if (x0$1 instanceof Success) {
            Option option = (Option)((Success)x0$1).value();
            return !(option != null ? !option.equals(expectedLeaderOpt$1) : expectedLeaderOpt$1 != null);
        }
        if (x0$1 instanceof Failure) {
            bl = true;
            failure = (Failure)x0$1;
            Throwable e = failure.exception();
            if (e instanceof ExecutionException && ((ExecutionException)e).getCause() instanceof UnknownTopicOrPartitionException) {
                return false;
            }
        }
        if (bl) {
            throw failure.exception();
        }
        throw new MatchError((Object)x0$1);
    }

    public static final /* synthetic */ boolean $anonfun$waitForBrokersOutOfIsr$1(Admin client$3, scala.collection.immutable.Set partition$4, scala.collection.immutable.Set brokerIds$1) {
        scala.collection.immutable.Set isr = ((TraversableOnce)((TraversableLike)((scala.collection.mutable.Map)CollectionConverters$.MODULE$.mapAsScalaMapConverter((java.util.Map)client$3.describeTopics((Collection)CollectionConverters$.MODULE$.setAsJavaSetConverter((scala.collection.Set)partition$4.map((Function1 & Serializable & scala.Serializable)x$36 -> x$36.topic(), scala.collection.immutable.Set$.MODULE$.canBuildFrom())).asJava()).allTopicNames().get()).asScala()).values().flatMap((Function1 & Serializable & scala.Serializable)x$37 -> (Buffer)((TraversableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(x$37.partitions()).asScala()).flatMap((Function1 & Serializable & scala.Serializable)x$38 -> (Buffer)CollectionConverters$.MODULE$.asScalaBufferConverter(x$38.isr()).asScala(), Buffer$.MODULE$.canBuildFrom()), Iterable$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x$39 -> BoxesRunTime.boxToInteger((int)x$39.id()), Iterable$.MODULE$.canBuildFrom())).toSet();
        return ((SetLike)brokerIds$1.intersect((GenSet)isr)).isEmpty();
    }

    public static final /* synthetic */ String $anonfun$waitForBrokersOutOfIsr$6(scala.collection.immutable.Set brokerIds$1, scala.collection.immutable.Set partition$4) {
        return new StringBuilder(49).append("Expected brokers ").append(brokerIds$1).append(" to no longer be in the ISR for ").append(partition$4).toString();
    }

    public static final /* synthetic */ boolean $anonfun$waitForBrokersInIsr$1(Admin client$4, TopicPartition partition$5, scala.collection.immutable.Set brokerIds$2) {
        scala.collection.immutable.Set<Object> isr = MODULE$.currentIsr(client$4, partition$5);
        return brokerIds$2.subsetOf(isr);
    }

    public static final /* synthetic */ String $anonfun$waitForBrokersInIsr$2(scala.collection.immutable.Set brokerIds$2, TopicPartition partition$5) {
        return new StringBuilder(39).append("Expected brokers ").append(brokerIds$2).append(" to be in the ISR for ").append(partition$5).toString();
    }

    public static final /* synthetic */ void $anonfun$assertFutureExceptionTypeEquals$2(Throwable cause$1, String message) {
        Assertions.assertTrue((boolean)cause$1.getMessage().contains(message), (String)new StringBuilder(68).append("Received error message : ").append(cause$1.getMessage()).append(" does not contain expected error message : ").append(message).toString());
    }

    public static final /* synthetic */ boolean $anonfun$totalMetricValue$1(String metricName$1, KafkaMetric x$43) {
        String string = x$43.metricName().name();
        return !(string != null ? !string.equals(metricName$1) : metricName$1 != null);
    }

    public static final /* synthetic */ double $anonfun$totalMetricValue$2(double total, KafkaMetric metric) {
        return total + BoxesRunTime.unboxToDouble((Object)metric.metricValue());
    }

    public static final /* synthetic */ boolean $anonfun$meterCountOpt$1(String metricName$3, Tuple2 x0$1) {
        if (x0$1 != null) {
            return ((MetricName)x0$1._1()).getMBeanName().endsWith(metricName$3);
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ long $anonfun$meterCountOpt$2(Metric x$44) {
        return ((Meter)x$44).count();
    }

    public static final /* synthetic */ boolean $anonfun$metersCount$1(String metricName$4, Tuple2 x0$1) {
        if (x0$1 != null) {
            return ((MetricName)x0$1._1()).getMBeanName().endsWith(metricName$4);
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ long $anonfun$metersCount$2(Metric x0$2) {
        if (x0$2 instanceof Histogram) {
            return ((Histogram)x0$2).count();
        }
        if (x0$2 instanceof Meter) {
            return ((Meter)x0$2).count();
        }
        return 0L;
    }

    public static final /* synthetic */ void $anonfun$clearYammerMetrics$1(MetricName metricName) {
        KafkaYammerMetrics.defaultRegistry().removeMetric(metricName);
    }

    public static final /* synthetic */ boolean $anonfun$waitForAllReassignmentsToComplete$1(Admin adminClient$1) {
        return ((java.util.Map)adminClient$1.listPartitionReassignments().reassignments().get()).isEmpty();
    }

    public static final /* synthetic */ String $anonfun$waitForAllReassignmentsToComplete$2() {
        return "There still are ongoing reassignments";
    }

    public static final /* synthetic */ boolean $anonfun$pickAuthorizerForWrite$2(ControllerServer x$45) {
        return x$45.controller().isActive();
    }

    public static final /* synthetic */ void $anonfun$pickAuthorizerForWrite$1(scala.collection.Seq controllers$1, ObjectRef result$1) {
        ControllerServer active = (ControllerServer)((IterableLike)controllers$1.filter((Function1 & Serializable & scala.Serializable)x$45 -> BoxesRunTime.boxToBoolean((boolean)TestUtils$.$anonfun$pickAuthorizerForWrite$2(x$45)))).head();
        result$1.elem = (Authorizer)active.authorizer().get();
    }

    private static final scala.collection.immutable.Set unexpectedThreads$1(scala.collection.immutable.Set unexpectedThreadNames$1) {
        return ((TraversableOnce)((Set)((SetLike)CollectionConverters$.MODULE$.asScalaSetConverter(Thread.getAllStackTraces().keySet()).asScala()).map((Function1 & Serializable & scala.Serializable)thread -> thread.getName(), scala.collection.mutable.Set$.MODULE$.canBuildFrom())).filter((Function1 & Serializable & scala.Serializable)t -> BoxesRunTime.boxToBoolean((boolean)unexpectedThreadNames$1.exists((Function1 & Serializable & scala.Serializable)s -> BoxesRunTime.boxToBoolean((boolean)t.contains(s)))))).toSet();
    }

    private TestUtils$() {
        MODULE$ = this;
        Logging.$init$((Logging)this);
        this.random = TestUtils.RANDOM;
        this.RandomPort = 0;
        this.IncorrectBrokerPort = 225;
        this.MockZkPort = 1;
        this.MockZkConnect = new StringBuilder(10).append("127.0.0.1:").append(this.MockZkPort()).toString();
        this.SslCertificateCn = "localhost";
        this.kafka$utils$TestUtils$$transactionStatusKey = "transactionStatus";
        this.kafka$utils$TestUtils$$committedValue = "committed".getBytes(StandardCharsets.UTF_8);
        this.kafka$utils$TestUtils$$abortedValue = "aborted".getBytes(StandardCharsets.UTF_8);
        this.anonymousAuthorizableContext = new AuthorizableRequestContext(){

            public String listenerName() {
                return "";
            }

            public SecurityProtocol securityProtocol() {
                return SecurityProtocol.PLAINTEXT;
            }

            public KafkaPrincipal principal() {
                return KafkaPrincipal.ANONYMOUS;
            }

            public InetAddress clientAddress() {
                return null;
            }

            public int requestType() {
                return 0;
            }

            public int requestVersion() {
                return 0;
            }

            public String clientId() {
                return "";
            }

            public int correlationId() {
                return 0;
            }
        };
    }

    public static final /* synthetic */ Option $anonfun$waitUntilLeaderIsElectedOrChanged$2$adapted(KafkaZkClient zkClient$1, boolean ignoreNoLeader$1, String topic, Object partition) {
        return TestUtils$.getPartitionLeader$1(topic, BoxesRunTime.unboxToInt((Object)partition), zkClient$1, ignoreNoLeader$1);
    }

    public static final /* synthetic */ Option $anonfun$waitUntilLeaderIsElectedOrChangedWithAdmin$3$adapted(Admin admin$2, String topic, Object partition) {
        return TestUtils$.getPartitionLeader$2(topic, BoxesRunTime.unboxToInt((Object)partition), admin$2);
    }

    public static final /* synthetic */ Object $anonfun$tryUntilNoAssertionError$2$adapted(Either x$9) {
        return BoxesRunTime.boxToBoolean((boolean)x$9.isLeft());
    }

    public static final /* synthetic */ Object $anonfun$waitUntilControllerElected$2$adapted(Option x$15) {
        return BoxesRunTime.boxToBoolean((boolean)x$15.isDefined());
    }

    public static final /* synthetic */ Object $anonfun$waitForLeaderToBecome$6$adapted(Option expectedLeaderOpt$1, Try x0$1) {
        return BoxesRunTime.boxToBoolean((boolean)TestUtils$.$anonfun$waitForLeaderToBecome$6(expectedLeaderOpt$1, x0$1));
    }

    public static final /* synthetic */ Object $anonfun$verifyNoUnexpectedThreads$5$adapted(scala.collection.immutable.Set x$46) {
        return BoxesRunTime.boxToBoolean((boolean)x$46.isEmpty());
    }
}

