/*
 * Decompiled with CFR 0.152.
 */
package kafka.zk.migration;

import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Properties;
import java.util.function.BiConsumer;
import kafka.server.ZkAdminManager$;
import kafka.utils.CoreUtils$;
import kafka.zk.AdminZkClient;
import kafka.zk.ZkMigrationClient;
import kafka.zk.migration.ZkMigrationTestHarness;
import org.apache.kafka.clients.admin.ScramMechanism;
import org.apache.kafka.common.config.ConfigResource;
import org.apache.kafka.common.config.types.Password;
import org.apache.kafka.common.metadata.ClientQuotaRecord;
import org.apache.kafka.common.metadata.ConfigRecord;
import org.apache.kafka.common.metadata.UserScramCredentialRecord;
import org.apache.kafka.common.quota.ClientQuotaEntity;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.apache.kafka.common.security.scram.ScramCredential;
import org.apache.kafka.common.security.scram.internals.ScramCredentialUtils;
import org.apache.kafka.common.security.token.delegation.DelegationToken;
import org.apache.kafka.common.security.token.delegation.TokenInformation;
import org.apache.kafka.common.utils.SecurityUtils;
import org.apache.kafka.image.ClientQuotasDelta;
import org.apache.kafka.image.ClientQuotasImage;
import org.apache.kafka.image.MetadataDelta;
import org.apache.kafka.image.MetadataImage;
import org.apache.kafka.image.MetadataProvenance;
import org.apache.kafka.metadata.RecordTestUtils;
import org.apache.kafka.metadata.migration.KRaftMigrationZkWriter;
import org.apache.kafka.metadata.migration.MigrationClient;
import org.apache.kafka.metadata.migration.ZkMigrationLeadershipState;
import org.apache.kafka.server.common.ApiMessageAndVersion;
import org.apache.kafka.server.util.MockRandom;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import scala.Function1;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u0005]b\u0001\u0002\b\u0010\u0001YAQa\u0007\u0001\u0005\u0002qAQA\b\u0001\u0005\u0002}AQ!\u0010\u0001\u0005\u0002yBQ!\u0014\u0001\u0005\n9CQA\u0018\u0001\u0005\u0002yBQ\u0001\u0019\u0001\u0005\u0002yBQA\u0019\u0001\u0005\n\rDa!a\b\u0001\t\u0003q\u0004BBA\u0012\u0001\u0011\u0005a\b\u0003\u0004\u0002(\u0001!\tA\u0010\u0005\u0007\u0003W\u0001A\u0011\u0001 \t\r\u0005=\u0002\u0001\"\u0001?\u0011\u0019\t\u0019\u0004\u0001C\u0001}\tY\"l[\"p]\u001aLw-T5he\u0006$\u0018n\u001c8DY&,g\u000e\u001e+fgRT!\u0001E\t\u0002\u00135LwM]1uS>t'B\u0001\n\u0014\u0003\tQ8NC\u0001\u0015\u0003\u0015Y\u0017MZ6b\u0007\u0001\u0019\"\u0001A\f\u0011\u0005aIR\"A\b\n\u0005iy!A\u0006.l\u001b&<'/\u0019;j_:$Vm\u001d;ICJtWm]:\u0002\rqJg.\u001b;?)\u0005i\u0002C\u0001\r\u0001\u00031\u0011\u0018M\u001c3p[\n+hMZ3s)\r\u0001\u0013\u0006\u000f\t\u0004C\u00112S\"\u0001\u0012\u000b\u0003\r\nQa]2bY\u0006L!!\n\u0012\u0003\u000b\u0005\u0013(/Y=\u0011\u0005\u0005:\u0013B\u0001\u0015#\u0005\u0011\u0011\u0015\u0010^3\t\u000b)\u0012\u0001\u0019A\u0016\u0002\rI\fg\u000eZ8n!\tac'D\u0001.\u0015\tqs&\u0001\u0003vi&d'B\u0001\u00192\u0003\u0019\u0019XM\u001d<fe*\u0011AC\r\u0006\u0003gQ\na!\u00199bG\",'\"A\u001b\u0002\u0007=\u0014x-\u0003\u00028[\tQQj\\2l%\u0006tGm\\7\t\u000be\u0012\u0001\u0019\u0001\u001e\u0002\r1,gn\u001a;i!\t\t3(\u0003\u0002=E\t\u0019\u0011J\u001c;\u00025Q,7\u000f^'jOJ\fG/[8o\u0005J|7.\u001a:D_:4\u0017nZ:\u0015\u0003}\u0002\"!\t!\n\u0005\u0005\u0013#\u0001B+oSRD#aA\"\u0011\u0005\u0011[U\"A#\u000b\u0005\u0019;\u0015aA1qS*\u0011\u0001*S\u0001\bUV\u0004\u0018\u000e^3s\u0015\tQE'A\u0003kk:LG/\u0003\u0002M\u000b\n!A+Z:u\u0003i\t7o]3siB\u000bG\u000f[#ySN$XM\\2f\u0003:$G)\u0019;b)\ryt\n\u0018\u0005\u0006!\u0012\u0001\r!U\u0001\rKb\u0004Xm\u0019;fIB\u000bG\u000f\u001b\t\u0003%fs!aU,\u0011\u0005Q\u0013S\"A+\u000b\u0005Y+\u0012A\u0002\u001fs_>$h(\u0003\u0002YE\u00051\u0001K]3eK\u001aL!AW.\u0003\rM#(/\u001b8h\u0015\tA&\u0005C\u0003^\t\u0001\u0007\u0011+\u0001\u0003eCR\f\u0017a\u0006;fgRl\u0015n\u001a:bi\u0016\u001cE.[3oiF+x\u000e^1tQ\t)1)A\u000fuKN$xK]5uK\u0016C\u0018n\u001d;j]\u001e\u001cE.[3oiF+x\u000e^1tQ\t11)A\rxe&$Xm\u00117jK:$\u0018+^8uC\u0006sGMV3sS\u001aLHc\u00033lcZD\u0018\u0011AA\f\u00037\u0001\"!Z5\u000e\u0003\u0019T!\u0001E4\u000b\u0005!\f\u0014\u0001C7fi\u0006$\u0017\r^1\n\u0005)4'A\u0007.l\u001b&<'/\u0019;j_:dU-\u00193feND\u0017\u000e]*uCR,\u0007\"\u00027\b\u0001\u0004i\u0017aD7jOJ\fG/[8o\u00072LWM\u001c;\u0011\u00059|W\"A\t\n\u0005A\f\"!\u0005.l\u001b&<'/\u0019;j_:\u001cE.[3oi\")!o\u0002a\u0001g\u0006i\u0011\rZ7j]j[7\t\\5f]R\u0004\"A\u001c;\n\u0005U\f\"!D!e[&t'l[\"mS\u0016tG\u000fC\u0003x\u000f\u0001\u0007A-\u0001\bnS\u001e\u0014\u0018\r^5p]N#\u0018\r^3\t\u000be<\u0001\u0019\u0001>\u0002\r\u0015tG/\u001b;z!\u0011Yh0U)\u000e\u0003qT!! \u0012\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0002\u0000y\n\u0019Q*\u00199\t\u000f\u0005\rq\u00011\u0001\u0002\u0006\u00051\u0011/^8uCN\u0004Ra\u001f@R\u0003\u000f\u0001B!!\u0003\u0002\u00145\u0011\u00111\u0002\u0006\u0005\u0003\u001b\ty!\u0001\u0003mC:<'BAA\t\u0003\u0011Q\u0017M^1\n\t\u0005U\u00111\u0002\u0002\u0007\t>,(\r\\3\t\r\u0005eq\u00011\u0001R\u00031Q8.\u00128uSRLH+\u001f9f\u0011\u0019\tib\u0002a\u0001#\u0006a!p[#oi&$\u0018PT1nK\u0006AB/Z:u/JLG/\u001a(fo\u000ec\u0017.\u001a8u#V|G/Y:)\u0005!\u0019\u0015\u0001\u0007;fgR<&/\u001b;f\u001d\u0016<Hk\u001c9jG\u000e{gNZ5hg\"\u0012\u0011bQ\u0001\u001ei\u0016\u001cHo\u0016:ji\u0016,\u00050[:uS:<Gk\u001c9jG\u000e{gNZ5hg\"\u0012!bQ\u0001\ni\u0016\u001cHoU2sC6D#aC\"\u0002EQ,7\u000f^*de\u0006l\u0017I\u001c3Rk>$\u0018m\u00115b]\u001e,7/\u00138T]\u0006\u00048\u000f[8uQ\ta1)\u0001\u000buKN$H)\u001a7fO\u0006$\u0018n\u001c8U_.,gn\u001d\u0015\u0003\u001b\r\u0003")
public class ZkConfigMigrationClientTest
extends ZkMigrationTestHarness {
    public byte[] randomBuffer(MockRandom random, int length) {
        byte[] buf = new byte[length];
        random.nextBytes(buf);
        return buf;
    }

    @Test
    public void testMigrationBrokerConfigs() {
        ArrayList brokers = new ArrayList();
        ArrayList batches = new ArrayList();
        Properties props = new Properties();
        props.put("default.replication.factor", "1");
        props.put("ssl.keystore.password", this.encoder().encode(new Password(this.SECRET())));
        this.zkClient().setOrCreateEntityConfigs("brokers", "1", props);
        Properties defaultProps = new Properties();
        defaultProps.put("default.replication.factor", "3");
        this.zkClient().setOrCreateEntityConfigs("brokers", "<default>", defaultProps);
        this.migrationClient().migrateBrokerConfigs(batch -> batches.add(batch), brokerId -> brokers.add(brokerId));
        Assertions.assertEquals((int)1, (int)brokers.size());
        Assertions.assertEquals((int)2, (int)batches.size());
        Assertions.assertEquals((int)2, (int)((java.util.List)batches.get(0)).size());
        Assertions.assertEquals((int)1, (int)((java.util.List)batches.get(1)).size());
        ((Iterable)batches.get(0)).forEach(record -> {
            ConfigRecord message = (ConfigRecord)record.message();
            String name = message.name();
            String value = message.value();
            Assertions.assertTrue((boolean)props.containsKey(name));
            String string = name;
            String string2 = "ssl.keystore.password";
            if (string != null && string.equals(string2)) {
                Assertions.assertEquals((Object)this.SECRET(), (Object)value);
                return;
            }
            Assertions.assertEquals((Object)props.getProperty(name), (Object)value);
        });
        ConfigRecord record2 = (ConfigRecord)((ApiMessageAndVersion)((java.util.List)batches.get(1)).get(0)).message();
        Assertions.assertEquals((byte)ConfigResource.Type.BROKER.id(), (byte)record2.resourceType());
        Assertions.assertEquals((Object)"", (Object)record2.resourceName());
        Assertions.assertEquals((Object)"default.replication.factor", (Object)record2.name());
        Assertions.assertEquals((Object)"3", (Object)record2.value());
        HashMap<String, String> newProps = new HashMap<String, String>();
        newProps.put("default.replication.factor", "2");
        newProps.put("ssl.keystore.password", this.NEW_SECRET());
        this.migrationState_$eq(this.migrationClient().configClient().writeConfigs(new ConfigResource(ConfigResource.Type.BROKER, "1"), newProps, this.migrationState()));
        Properties actualPropsInZk = this.zkClient().getEntityConfigs("brokers", "1");
        Assertions.assertEquals((int)2, (int)actualPropsInZk.size());
        actualPropsInZk.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(x0$1, x1$1) -> {
            Object object = x0$1;
            String string = "ssl.keystore.password";
            if (object != null && object.equals(string)) {
                Assertions.assertEquals((Object)this.NEW_SECRET(), (Object)this.encoder().decode(x1$1.toString()).value());
                return;
            }
            Assertions.assertEquals(newProps.get(x0$1), (Object)x1$1);
        }));
        this.assertPathExistenceAndData("/config/changes/config_change_0000000000", "{\"version\":2,\"entity_path\":\"brokers/1\"}");
        this.migrationState_$eq(this.migrationClient().configClient().deleteConfigs(new ConfigResource(ConfigResource.Type.BROKER, "1"), this.migrationState()));
        Assertions.assertEquals((int)0, (int)this.zkClient().getEntityConfigs("brokers", "1").size());
        this.assertPathExistenceAndData("/config/changes/config_change_0000000001", "{\"version\":2,\"entity_path\":\"brokers/1\"}");
        Assertions.assertFalse((boolean)this.zkClient().pathExists("/config/changes/config_change_0000000002"));
    }

    private void assertPathExistenceAndData(String expectedPath, String data) {
        Assertions.assertTrue((boolean)this.zkClient().pathExists(expectedPath));
        Assertions.assertEquals((Object)new Some((Object)data), (Object)((Option)this.zkClient().getDataAndStat(expectedPath)._1()).map((Function1 & Serializable & scala.Serializable)x$1 -> new String((byte[])x$1, StandardCharsets.UTF_8)));
    }

    @Test
    public void testMigrateClientQuotas() {
        Properties props = new Properties();
        props.put("producer_byte_rate", "100000");
        AdminZkClient qual$1 = this.adminZkClient();
        String x$1 = "users";
        String x$2 = "<default>";
        boolean x$4 = qual$1.changeConfigs$default$4();
        qual$1.changeConfigs(x$1, x$2, props, x$4);
        AdminZkClient qual$2 = this.adminZkClient();
        String x$5 = "users";
        String x$6 = "user1";
        boolean x$8 = qual$2.changeConfigs$default$4();
        qual$2.changeConfigs(x$5, x$6, props, x$8);
        AdminZkClient qual$3 = this.adminZkClient();
        String x$9 = "users";
        String x$10 = "user1/clients/clientA";
        boolean x$12 = qual$3.changeConfigs$default$4();
        qual$3.changeConfigs(x$9, x$10, props, x$12);
        AdminZkClient qual$4 = this.adminZkClient();
        String x$13 = "users";
        String x$14 = "<default>/clients/<default>";
        boolean x$16 = qual$4.changeConfigs$default$4();
        qual$4.changeConfigs(x$13, x$14, props, x$16);
        AdminZkClient qual$5 = this.adminZkClient();
        String x$17 = "users";
        String x$18 = "<default>/clients/clientA";
        boolean x$20 = qual$5.changeConfigs$default$4();
        qual$5.changeConfigs(x$17, x$18, props, x$20);
        AdminZkClient qual$6 = this.adminZkClient();
        String x$21 = "clients";
        String x$22 = "<default>";
        boolean x$24 = qual$6.changeConfigs$default$4();
        qual$6.changeConfigs(x$21, x$22, props, x$24);
        AdminZkClient qual$7 = this.adminZkClient();
        String x$25 = "clients";
        String x$26 = "clientB";
        boolean x$28 = qual$7.changeConfigs$default$4();
        qual$7.changeConfigs(x$25, x$26, props, x$28);
        props.remove("producer_byte_rate");
        props.put("connection_creation_rate", "10");
        AdminZkClient qual$8 = this.adminZkClient();
        String x$29 = "ips";
        String x$30 = "1.1.1.1";
        boolean x$32 = qual$8.changeConfigs$default$4();
        qual$8.changeConfigs(x$29, x$30, props, x$32);
        AdminZkClient qual$9 = this.adminZkClient();
        String x$33 = "ips";
        String x$34 = "<default>";
        boolean x$36 = qual$9.changeConfigs$default$4();
        qual$9.changeConfigs(x$33, x$34, props, x$36);
        ArrayList batches = new ArrayList();
        this.migrationClient().migrateClientQuotas(batch -> batches.add(batch));
        Assertions.assertEquals((int)9, (int)batches.size());
        ClientQuotasDelta delta = new ClientQuotasDelta(ClientQuotasImage.EMPTY);
        RecordTestUtils.replayAllBatches((Object)delta, batches);
        ClientQuotasImage image = delta.apply();
        Assertions.assertEquals(new HashSet<Object>(Arrays.asList((Object[])new ClientQuotaEntity[]{new ClientQuotaEntity((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"user"), null)}))).asJava()), new ClientQuotaEntity((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"user"), (Object)"user1")}))).asJava()), new ClientQuotaEntity((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"user"), (Object)"user1"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"client-id"), (Object)"clientA")}))).asJava()), new ClientQuotaEntity((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"user"), null), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"client-id"), null)}))).asJava()), new ClientQuotaEntity((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"user"), null), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"client-id"), (Object)"clientA")}))).asJava()), new ClientQuotaEntity((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"client-id"), null)}))).asJava()), new ClientQuotaEntity((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"client-id"), (Object)"clientB")}))).asJava()), new ClientQuotaEntity((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"ip"), (Object)"1.1.1.1")}))).asJava()), new ClientQuotaEntity((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"ip"), null)}))).asJava())})), image.entities().keySet());
    }

    @Test
    public void testWriteExistingClientQuotas() {
        Properties props = new Properties();
        props.put("producer_byte_rate", "100000");
        AdminZkClient qual$1 = this.adminZkClient();
        String x$1 = "users";
        String x$2 = "user1";
        boolean x$4 = qual$1.changeConfigs$default$4();
        qual$1.changeConfigs(x$1, x$2, props, x$4);
        AdminZkClient qual$2 = this.adminZkClient();
        String x$5 = "users";
        String x$6 = "user1/clients/clientA";
        boolean x$8 = qual$2.changeConfigs$default$4();
        qual$2.changeConfigs(x$5, x$6, props, x$8);
        Assertions.assertEquals((int)0, (int)this.migrationState().migrationZkVersion());
        this.migrationState_$eq(this.writeClientQuotaAndVerify(this.migrationClient(), this.adminZkClient(), this.migrationState(), (Map<String, String>)((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"user"), (Object)"user1")}))), (Map<String, Double>)((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"producer_byte_rate"), (Object)Predef$.MODULE$.double2Double(20000.0))}))), "users", "user1"));
        Assertions.assertEquals((int)1, (int)this.migrationState().migrationZkVersion());
        this.migrationState_$eq(this.writeClientQuotaAndVerify(this.migrationClient(), this.adminZkClient(), this.migrationState(), (Map<String, String>)((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"user"), (Object)"user1")}))), (Map<String, Double>)((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"producer_byte_rate"), (Object)Predef$.MODULE$.double2Double(10000.0))}))), "users", "user1"));
        Assertions.assertEquals((int)2, (int)this.migrationState().migrationZkVersion());
        this.migrationState_$eq(this.writeClientQuotaAndVerify(this.migrationClient(), this.adminZkClient(), this.migrationState(), (Map<String, String>)((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"user"), (Object)"user1")}))), (Map<String, Double>)Map$.MODULE$.empty(), "users", "user1"));
        Assertions.assertEquals((int)3, (int)this.migrationState().migrationZkVersion());
        this.migrationState_$eq(this.writeClientQuotaAndVerify(this.migrationClient(), this.adminZkClient(), this.migrationState(), (Map<String, String>)((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"user"), (Object)"user1")}))), (Map<String, Double>)((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"consumer_byte_rate"), (Object)Predef$.MODULE$.double2Double(100.0))}))), "users", "user1"));
        Assertions.assertEquals((int)4, (int)this.migrationState().migrationZkVersion());
        this.migrationState_$eq(this.writeClientQuotaAndVerify(this.migrationClient(), this.adminZkClient(), this.migrationState(), (Map<String, String>)((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"user"), null)}))), (Map<String, Double>)((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"consumer_byte_rate"), (Object)Predef$.MODULE$.double2Double(200.0))}))), "users", "<default>"));
        Assertions.assertEquals((int)5, (int)this.migrationState().migrationZkVersion());
    }

    private ZkMigrationLeadershipState writeClientQuotaAndVerify(ZkMigrationClient migrationClient, AdminZkClient adminZkClient, ZkMigrationLeadershipState migrationState, Map<String, String> entity, Map<String, Double> quotas, String zkEntityType, String zkEntityName) {
        ZkMigrationLeadershipState nextMigrationState = migrationClient.configClient().writeClientQuotas((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter(entity).asJava(), (java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter(quotas).asJava(), (java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Map$.MODULE$.empty()).asJava(), migrationState);
        Map newProps = ZkAdminManager$.MODULE$.clientQuotaPropsToDoubleMap((Map)CollectionConverters$.MODULE$.propertiesAsScalaMapConverter(adminZkClient.fetchEntityConfig(zkEntityType, zkEntityName)).asScala());
        Assertions.assertEquals(quotas, (Object)newProps);
        return nextMigrationState;
    }

    @Test
    public void testWriteNewClientQuotas() {
        Assertions.assertEquals((int)0, (int)this.migrationState().migrationZkVersion());
        this.migrationState_$eq(this.writeClientQuotaAndVerify(this.migrationClient(), this.adminZkClient(), this.migrationState(), (Map<String, String>)((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"user"), (Object)"user2")}))), (Map<String, Double>)((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"producer_byte_rate"), (Object)Predef$.MODULE$.double2Double(20000.0)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"consumer_byte_rate"), (Object)Predef$.MODULE$.double2Double(100.0))}))), "users", "user2"));
        Assertions.assertEquals((int)1, (int)this.migrationState().migrationZkVersion());
        this.migrationState_$eq(this.writeClientQuotaAndVerify(this.migrationClient(), this.adminZkClient(), this.migrationState(), (Map<String, String>)((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"user"), (Object)"user2"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"client-id"), (Object)"clientA")}))), (Map<String, Double>)((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"producer_byte_rate"), (Object)Predef$.MODULE$.double2Double(10000.0)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"consumer_byte_rate"), (Object)Predef$.MODULE$.double2Double(200.0))}))), "users", "user2/clients/clientA"));
        Assertions.assertEquals((int)2, (int)this.migrationState().migrationZkVersion());
    }

    @Test
    public void testWriteNewTopicConfigs() {
        this.migrationState_$eq(this.migrationClient().configClient().writeConfigs(new ConfigResource(ConfigResource.Type.TOPIC, "test"), Collections.singletonMap("segment.ms", "100000"), this.migrationState()));
        Assertions.assertEquals((int)1, (int)this.migrationState().migrationZkVersion());
        Properties newProps = this.zkClient().getEntityConfigs("topics", "test");
        Assertions.assertEquals((int)1, (int)newProps.size());
        Assertions.assertEquals((Object)"100000", (Object)newProps.getProperty("segment.ms"));
    }

    @Test
    public void testWriteExistingTopicConfigs() {
        Properties props = new Properties();
        props.put("flush.ms", "60000");
        props.put("retention.ms", "300000");
        this.zkClient().setOrCreateEntityConfigs("topics", "test", props);
        this.migrationState_$eq(this.migrationClient().claimControllerLeadership(this.migrationState()));
        this.migrationState_$eq(this.migrationClient().configClient().writeConfigs(new ConfigResource(ConfigResource.Type.TOPIC, "test"), Collections.singletonMap("segment.ms", "100000"), this.migrationState()));
        Assertions.assertEquals((int)1, (int)this.migrationState().migrationZkVersion());
        Properties newProps = this.zkClient().getEntityConfigs("topics", "test");
        Assertions.assertEquals((int)1, (int)newProps.size());
        Assertions.assertEquals((Object)"100000", (Object)newProps.getProperty("segment.ms"));
    }

    @Test
    public void testScram() {
        MockRandom random = new MockRandom();
        ScramCredential scramCredential = new ScramCredential(this.randomBuffer(random, 1024), this.randomBuffer(random, 1024), this.randomBuffer(random, 1024), 4096);
        Properties props = new Properties();
        props.put("SCRAM-SHA-256", ScramCredentialUtils.credentialToString((ScramCredential)scramCredential));
        AdminZkClient qual$1 = this.adminZkClient();
        String x$1 = "users";
        String x$2 = "alice";
        boolean x$4 = qual$1.changeConfigs$default$4();
        qual$1.changeConfigs(x$1, x$2, props, x$4);
        ArrayList brokers = new ArrayList();
        ArrayList batches = new ArrayList();
        this.migrationClient().readAllMetadata(batch -> batches.add(batch), brokerId -> brokers.add(brokerId));
        Assertions.assertEquals((int)0, (int)brokers.size());
        Assertions.assertEquals((int)1, (int)batches.size());
        Assertions.assertEquals((int)1, (int)((java.util.List)batches.get(0)).size());
    }

    @Test
    public void testScramAndQuotaChangesInSnapshot() {
        MockRandom random = new MockRandom();
        Properties props = new Properties();
        props.put("producer_byte_rate", "100000");
        AdminZkClient qual$1 = this.adminZkClient();
        String x$1 = "users";
        String x$22 = "user1";
        boolean x$42 = qual$1.changeConfigs$default$4();
        qual$1.changeConfigs(x$1, x$22, props, x$42);
        ScramCredential aliceScramCredential = new ScramCredential(this.randomBuffer(random, 1024), this.randomBuffer(random, 1024), this.randomBuffer(random, 1024), 4096);
        Properties alicePropsInit = new Properties();
        alicePropsInit.put("SCRAM-SHA-256", ScramCredentialUtils.credentialToString((ScramCredential)aliceScramCredential));
        AdminZkClient qual$2 = this.adminZkClient();
        String x$5 = "users";
        String x$6 = "alice";
        boolean x$8 = qual$2.changeConfigs$default$4();
        qual$2.changeConfigs(x$5, x$6, alicePropsInit, x$8);
        MetadataDelta delta = new MetadataDelta(MetadataImage.EMPTY);
        ClientQuotaRecord.EntityData entityData = new ClientQuotaRecord.EntityData().setEntityType("user").setEntityName("user2");
        ClientQuotaRecord clientQuotaRecord = new ClientQuotaRecord().setEntity((java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)entityData, (List)Nil$.MODULE$)).asJava()).setKey("request_percentage").setValue(58.58).setRemove(false);
        delta.replay(clientQuotaRecord);
        UserScramCredentialRecord scramCredentialRecord = new UserScramCredentialRecord().setName("george").setMechanism(ScramMechanism.SCRAM_SHA_256.type()).setSalt(this.randomBuffer(random, 1024)).setStoredKey(this.randomBuffer(random, 1024)).setServerKey(this.randomBuffer(random, 1024)).setIterations(8192);
        delta.replay(scramCredentialRecord);
        MetadataImage image = delta.apply(MetadataProvenance.EMPTY);
        new KRaftMigrationZkWriter((MigrationClient)this.migrationClient(), x$2 -> Assertions.fail((String)x$2)).handleSnapshot(image, (x$3, x$4, operation) -> this.migrationState_$eq(operation.apply(this.migrationState())));
        Properties user1Props = this.zkClient().getEntityConfigs("users", "user1");
        Assertions.assertEquals((int)0, (int)user1Props.size());
        Properties user2Props = this.zkClient().getEntityConfigs("users", "user2");
        Assertions.assertEquals((int)1, (int)user2Props.size());
        Properties georgeProps = this.zkClient().getEntityConfigs("users", "george");
        Assertions.assertEquals((int)1, (int)georgeProps.size());
        Properties aliceProps = this.zkClient().getEntityConfigs("users", "alice");
        Assertions.assertEquals((int)0, (int)aliceProps.size());
    }

    @Test
    public void testDelegationTokens() {
        String uuid = CoreUtils$.MODULE$.generateUuidAsBase64();
        KafkaPrincipal owner = SecurityUtils.parseKafkaPrincipal((String)"User:alice");
        TokenInformation tokenInfo = new TokenInformation(uuid, owner, owner, (Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)owner, (List)Nil$.MODULE$)).asJava(), 0L, 100L, 1000L);
        byte[] hmac = new byte[]{(byte)1, (byte)2, (byte)3, (byte)4};
        DelegationToken token = new DelegationToken(tokenInfo, hmac);
        this.zkClient().createDelegationTokenPaths();
        this.zkClient().setOrCreateDelegationToken(token);
        ArrayList brokers = new ArrayList();
        ArrayList batches = new ArrayList();
        this.migrationClient().readAllMetadata(batch -> batches.add(batch), brokerId -> brokers.add(brokerId));
        Assertions.assertEquals((int)0, (int)brokers.size());
        Assertions.assertEquals((int)1, (int)batches.size());
        Assertions.assertEquals((int)1, (int)((java.util.List)batches.get(0)).size());
    }
}

