/*
 * Decompiled with CFR 0.152.
 */
package kafka.admin;

import java.io.Serializable;
import java.util.Collection;
import java.util.Optional;
import java.util.Properties;
import kafka.admin.RackAwareMode;
import kafka.admin.RackAwareTest;
import kafka.admin.ReplicaDistributions;
import kafka.api.LeaderAndIsr;
import kafka.api.LeaderAndIsr$;
import kafka.cluster.Broker;
import kafka.cluster.Broker$;
import kafka.cluster.EndPoint;
import kafka.controller.LeaderIsrAndControllerEpoch;
import kafka.controller.ReplicaAssignment;
import kafka.controller.ReplicaAssignment$;
import kafka.log.LogManager;
import kafka.log.UnifiedLog;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.server.QuorumTestHarness;
import kafka.utils.CoreUtils$;
import kafka.utils.TestUtils$;
import kafka.zk.AdminZkClient;
import kafka.zk.AdminZkClient$;
import kafka.zk.BrokerIdsZNode$;
import kafka.zk.BrokerInfo$;
import kafka.zk.ConfigEntityTypeZNode$;
import kafka.zk.KafkaZkClient;
import kafka.zk.ZkVersion$;
import org.apache.kafka.admin.BrokerMetadata;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.InvalidReplicaAssignmentException;
import org.apache.kafka.common.errors.InvalidTopicException;
import org.apache.kafka.common.errors.TopicExistsException;
import org.apache.kafka.common.metrics.Quota;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.server.common.AdminOperationException;
import org.apache.kafka.server.common.MetadataVersion;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable$;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Range;
import scala.collection.immutable.Set;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.jdk.CollectionConverters$;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LongRef;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\u0005\re\u0001B\u000e\u001d\u0001\u0005BQA\r\u0001\u0005\u0002MBq!\u000e\u0001C\u0002\u0013%a\u0007\u0003\u0004@\u0001\u0001\u0006Ia\u000e\u0005\b\u0001\u0002\u0011\r\u0011\"\u00037\u0011\u0019\t\u0005\u0001)A\u0005o!9!\t\u0001a\u0001\n\u0003\u0019\u0005bB(\u0001\u0001\u0004%\t\u0001\u0015\u0005\u0007/\u0002\u0001\u000b\u0015\u0002#\t\u000ba\u0003A\u0011I-\t\u000b\u001d\u0004A\u0011A-\t\u000b1\u0004A\u0011A-\t\u000b9\u0004A\u0011A-\t\u000bA\u0004A\u0011A-\t\u000bI\u0004A\u0011A-\t\u000bQ\u0004A\u0011A-\t\u000bY\u0004A\u0011A-\t\u000ba\u0004A\u0011A-\t\u000bi\u0004A\u0011A-\t\u000bq\u0004A\u0011A-\t\u000by\u0004A\u0011A-\t\r\u0005\u0005\u0001\u0001\"\u0001Z\u0011\u0019\t)\u0001\u0001C\u00013\"1\u0011\u0011\u0002\u0001\u0005\u0002eCq!!\u0004\u0001\t\u0013\ty\u0001C\u0004\u0002\u000e\u0001!I!a\u000f\t\u000f\u0005U\u0003\u0001\"\u0003\u0002X\t\t\u0012\tZ7j]j[7\t\\5f]R$Vm\u001d;\u000b\u0005uq\u0012!B1e[&t'\"A\u0010\u0002\u000b-\fgm[1\u0004\u0001M!\u0001A\t\u0015/!\t\u0019c%D\u0001%\u0015\t)c$\u0001\u0004tKJ4XM]\u0005\u0003O\u0011\u0012\u0011#U;peVlG+Z:u\u0011\u0006\u0014h.Z:t!\tIC&D\u0001+\u0015\tYc$A\u0003vi&d7/\u0003\u0002.U\t9Aj\\4hS:<\u0007CA\u00181\u001b\u0005a\u0012BA\u0019\u001d\u00055\u0011\u0016mY6Bo\u0006\u0014X\rV3ti\u00061A(\u001b8jiz\"\u0012\u0001\u000e\t\u0003_\u0001\t\u0001\u0003\u001d:pIV\u001cWM\u001d\"zi\u0016\u0014\u0016\r^3\u0016\u0003]\u0002\"\u0001O\u001f\u000e\u0003eR!AO\u001e\u0002\t1\fgn\u001a\u0006\u0002y\u0005!!.\u0019<b\u0013\tq\u0014H\u0001\u0004TiJLgnZ\u0001\u0012aJ|G-^2fe\nKH/\u001a*bi\u0016\u0004\u0013\u0001E5q\u0007>tg.Z2uS>t'+\u0019;f\u0003EI\u0007oQ8o]\u0016\u001cG/[8o%\u0006$X\rI\u0001\bg\u0016\u0014h/\u001a:t+\u0005!\u0005cA#K\u00196\taI\u0003\u0002H\u0011\u0006Q1m\u001c7mK\u000e$\u0018n\u001c8\u000b\u0003%\u000bQa]2bY\u0006L!a\u0013$\u0003\u0007M+\u0017\u000f\u0005\u0002$\u001b&\u0011a\n\n\u0002\f\u0017\u000647.Y*feZ,'/A\u0006tKJ4XM]:`I\u0015\fHCA)V!\t\u00116+D\u0001I\u0013\t!\u0006J\u0001\u0003V]&$\bb\u0002,\b\u0003\u0003\u0005\r\u0001R\u0001\u0004q\u0012\n\u0014\u0001C:feZ,'o\u001d\u0011\u0002\u0011Q,\u0017M\u001d#po:$\u0012!\u0015\u0015\u0003\u0013m\u0003\"\u0001X3\u000e\u0003uS!AX0\u0002\u0007\u0005\u0004\u0018N\u0003\u0002aC\u00069!.\u001e9ji\u0016\u0014(B\u00012d\u0003\u0015QWO\\5u\u0015\u0005!\u0017aA8sO&\u0011a-\u0018\u0002\n\u0003\u001a$XM]#bG\"\f1\u0004^3ti6\u000bg.^1m%\u0016\u0004H.[2b\u0003N\u001c\u0018n\u001a8nK:$\bF\u0001\u0006j!\ta&.\u0003\u0002l;\n!A+Z:u\u0003U!Xm\u001d;U_BL7m\u0011:fCRLwN\\%o5.C#aC5\u0002=Q,7\u000f\u001e+pa&\u001c7I]3bi&|gnV5uQ\u000e{G\u000e\\5tS>t\u0007F\u0001\u0007j\u0003}!Xm\u001d;NCJ\\W\r\u001a#fY\u0016$\u0018n\u001c8U_BL7m\u0011:fCRLwN\u001c\u0015\u0003\u001b%\f\u0011\u0005^3ti6{7m[3e\u0007>t7-\u001e:sK:$Hk\u001c9jG\u000e\u0013X-\u0019;j_:D#AD5\u00027Q,7\u000f^\"p]\u000e,(O]3oiR{\u0007/[2De\u0016\fG/[8oQ\ty\u0011.A\u000buKN$Hk\u001c9jG\u000e{gNZ5h\u0007\"\fgnZ3)\u0005AI\u0017aI:i_VdG\r\u0015:pa\u0006<\u0017\r^3Es:\fW.[2Ce>\\WM]\"p]\u001aLwm\u001d\u0015\u0003#%\f1\u0004^3ti\n{w\u000e^:ue\u0006\u00048\t\\5f]RLEmQ8oM&<\u0007F\u0001\nj\u0003Y!Xm\u001d;HKR\u0014%o\\6fe6+G/\u00193bi\u0006\u001c\bFA\nj\u0003U\"Xm\u001d;DQ\u0006tw-Z+tKJ|%/V:fe\u000ec\u0017.\u001a8u\u0013\u0012\u001cuN\u001c4jO^KG\u000f[+tKJ\fe\u000eZ\"mS\u0016tG/\u00133)\u0005QI\u0017A\u000b;fgR\u001c\u0005.\u00198hKV\u001bXM](s+N,'o\u00117jK:$\u0018\nZ\"p]\u001aLwmV5uQV\u001bXM\u001d\u0015\u0003+%\f\u0001\u0004^3ti\u000eC\u0017M\\4f\u00072LWM\u001c;JI\u000e{gNZ5hQ\t1\u0012.\u0001\nuKN$8\t[1oO\u0016L\u0005oQ8oM&<\u0007FA\fj\u0003E\u0019'/Z1uK\n\u0013xn[3sg&s'l\u001b\u000b\u0007\u0003#\ty\"a\f\u0011\t\u0015S\u00151\u0003\t\u0005\u0003+\tY\"\u0004\u0002\u0002\u0018)\u0019\u0011\u0011\u0004\u0010\u0002\u000f\rdWo\u001d;fe&!\u0011QDA\f\u0005\u0019\u0011%o\\6fe\"9\u0011\u0011\u0005\rA\u0002\u0005\r\u0012\u0001\u0003>l\u00072LWM\u001c;\u0011\t\u0005\u0015\u00121F\u0007\u0003\u0003OQ1!!\u000b\u001f\u0003\tQ8.\u0003\u0003\u0002.\u0005\u001d\"!D&bM.\f'l[\"mS\u0016tG\u000fC\u0004\u00022a\u0001\r!a\r\u0002\u0007%$7\u000f\u0005\u0003F\u0015\u0006U\u0002c\u0001*\u00028%\u0019\u0011\u0011\b%\u0003\u0007%sG\u000f\u0006\u0004\u0002\u0012\u0005u\u00121\u000b\u0005\b\u0003\u007fI\u0002\u0019AA!\u0003=\u0011'o\\6fe6+G/\u00193bi\u0006\u001c\b\u0003B#K\u0003\u0007\u0002B!!\u0012\u0002P5\u0011\u0011q\t\u0006\u0004;\u0005%#bA\u0010\u0002L)\u0019\u0011QJ2\u0002\r\u0005\u0004\u0018m\u00195f\u0013\u0011\t\t&a\u0012\u0003\u001d\t\u0013xn[3s\u001b\u0016$\u0018\rZ1uC\"9\u0011\u0011E\rA\u0002\u0005\r\u0012AF7bW\u0016dU-\u00193fe\u001a{'\u000fU1si&$\u0018n\u001c8\u0015\u000fE\u000bI&a\u0017\u0002t!9\u0011\u0011\u0005\u000eA\u0002\u0005\r\u0002bBA/5\u0001\u0007\u0011qL\u0001\u0006i>\u0004\u0018n\u0019\t\u0005\u0003C\nyG\u0004\u0003\u0002d\u0005-\u0004cAA3\u00116\u0011\u0011q\r\u0006\u0004\u0003S\u0002\u0013A\u0002\u001fs_>$h(C\u0002\u0002n!\u000ba\u0001\u0015:fI\u00164\u0017b\u0001 \u0002r)\u0019\u0011Q\u000e%\t\u000f\u0005U$\u00041\u0001\u0002x\u0005)B.Z1eKJ\u0004VM\u001d)beRLG/[8o\u001b\u0006\u0004\b\u0003CA=\u0003\u007f\n)$!\u000e\u000e\u0005\u0005m$bAA?\r\u0006I\u0011.\\7vi\u0006\u0014G.Z\u0005\u0005\u0003\u0003\u000bYHA\u0002NCB\u0004")
public class AdminZkClientTest
extends QuorumTestHarness
implements RackAwareTest {
    private final String producerByteRate;
    private final String ipConnectionRate;
    private Seq<KafkaServer> servers;

    @Override
    public void checkReplicaDistribution(Map<Object, Seq<Object>> assignment, Map<Object, String> brokerRackMapping, int numBrokers, int numPartitions, int replicationFactor, boolean verifyRackAware, boolean verifyLeaderDistribution, boolean verifyReplicasDistribution) {
        RackAwareTest.checkReplicaDistribution$(this, assignment, brokerRackMapping, numBrokers, numPartitions, replicationFactor, verifyRackAware, verifyLeaderDistribution, verifyReplicasDistribution);
    }

    @Override
    public boolean checkReplicaDistribution$default$6() {
        return RackAwareTest.checkReplicaDistribution$default$6$(this);
    }

    @Override
    public boolean checkReplicaDistribution$default$7() {
        return RackAwareTest.checkReplicaDistribution$default$7$(this);
    }

    @Override
    public boolean checkReplicaDistribution$default$8() {
        return RackAwareTest.checkReplicaDistribution$default$8$(this);
    }

    @Override
    public ReplicaDistributions getReplicaDistribution(Map<Object, Seq<Object>> assignment, Map<Object, String> brokerRackMapping) {
        return RackAwareTest.getReplicaDistribution$(this, assignment, brokerRackMapping);
    }

    @Override
    public Collection<BrokerMetadata> toBrokerMetadata(Map<Object, String> rackMap, Seq<Object> brokersWithoutRack) {
        return RackAwareTest.toBrokerMetadata$(this, rackMap, brokersWithoutRack);
    }

    @Override
    public Seq<Object> toBrokerMetadata$default$2() {
        return RackAwareTest.toBrokerMetadata$default$2$(this);
    }

    private String producerByteRate() {
        return this.producerByteRate;
    }

    private String ipConnectionRate() {
        return this.ipConnectionRate;
    }

    public Seq<KafkaServer> servers() {
        return this.servers;
    }

    public void servers_$eq(Seq<KafkaServer> x$1) {
        this.servers = x$1;
    }

    @Override
    @AfterEach
    public void tearDown() {
        TestUtils$.MODULE$.shutdownServers(this.servers(), TestUtils$.MODULE$.shutdownServers$default$2());
        super.tearDown();
    }

    @Test
    public void testManualReplicaAssignment() {
        List brokers = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2, 3, 4}));
        this.createBrokersInZk(this.zkClient(), (Seq<Object>)brokers);
        Properties topicConfig = new Properties();
        Assertions.assertThrows(InvalidReplicaAssignmentException.class, () -> {
            AdminZkClient qual$1 = this.adminZkClient();
            String x$1 = "test";
            Map x$3 = (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 0})))}));
            boolean x$4 = qual$1.createTopicWithAssignment$default$4();
            boolean x$5 = qual$1.createTopicWithAssignment$default$5();
            qual$1.createTopicWithAssignment(x$1, topicConfig, x$3, x$4, x$5);
        });
        Assertions.assertThrows(InvalidReplicaAssignmentException.class, () -> {
            AdminZkClient qual$2 = this.adminZkClient();
            String x$6 = "test";
            Map x$8 = (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0})))}));
            boolean x$9 = qual$2.createTopicWithAssignment$default$4();
            boolean x$10 = qual$2.createTopicWithAssignment$default$5();
            qual$2.createTopicWithAssignment(x$6, topicConfig, x$8, x$9, x$10);
        });
        Assertions.assertThrows(InvalidReplicaAssignmentException.class, () -> {
            AdminZkClient qual$3 = this.adminZkClient();
            String x$11 = "test";
            Map x$13 = (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)2)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2})))}));
            boolean x$14 = qual$3.createTopicWithAssignment$default$4();
            boolean x$15 = qual$3.createTopicWithAssignment$default$5();
            qual$3.createTopicWithAssignment(x$11, topicConfig, x$13, x$14, x$15);
        });
        Assertions.assertThrows(InvalidReplicaAssignmentException.class, () -> {
            AdminZkClient qual$4 = this.adminZkClient();
            String x$16 = "test";
            Map x$18 = (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)3)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2})))}));
            boolean x$19 = qual$4.createTopicWithAssignment$default$4();
            boolean x$20 = qual$4.createTopicWithAssignment$default$5();
            qual$4.createTopicWithAssignment(x$16, topicConfig, x$18, x$19, x$20);
        });
        Assertions.assertThrows(InvalidReplicaAssignmentException.class, () -> {
            AdminZkClient qual$5 = this.adminZkClient();
            String x$21 = "test";
            Map x$23 = (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)-1)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)2)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)4)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2})))}));
            boolean x$24 = qual$5.createTopicWithAssignment$default$4();
            boolean x$25 = qual$5.createTopicWithAssignment$default$5();
            qual$5.createTopicWithAssignment(x$21, topicConfig, x$23, x$24, x$25);
        });
        Map assignment = (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3})))}));
        AdminZkClient qual$6 = this.adminZkClient();
        String x$26 = "test";
        boolean x$29 = qual$6.createTopicWithAssignment$default$4();
        boolean x$30 = qual$6.createTopicWithAssignment$default$5();
        qual$6.createTopicWithAssignment(x$26, topicConfig, assignment, x$29, x$30);
        Map found = this.zkClient().getPartitionAssignmentForTopics((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"test"})));
        Assertions.assertEquals((Object)assignment.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            if (x0$1 != null) {
                int k = x0$1._1$mcI$sp();
                List v = (List)x0$1._2();
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)k)), (Object)ReplicaAssignment$.MODULE$.apply((Seq)v, (Seq)Nil$.MODULE$, (Seq)Nil$.MODULE$));
            }
            throw new MatchError(null);
        }, Map$.MODULE$.canBuildFrom()), (Object)found.apply((Object)"test"));
    }

    @Test
    public void testTopicCreationInZK() {
        Map expectedReplicaAssignment = (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)2)), (Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 3, 4}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)3)), (Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{3, 4, 0}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)4)), (Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{4, 0, 1}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)5)), (Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 2, 3}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)6)), (Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 3, 4}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)7)), (Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 4, 0}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)8)), (Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{3, 0, 1}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)9)), (Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{4, 1, 2}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)10)), (Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)11)), (Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 3, 4})))}));
        scala.collection.immutable.Map leaderForPartitionMap = (scala.collection.immutable.Map)scala.collection.immutable.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)BoxesRunTime.boxToInteger((int)0)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)BoxesRunTime.boxToInteger((int)1)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)2)), (Object)BoxesRunTime.boxToInteger((int)2)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)3)), (Object)BoxesRunTime.boxToInteger((int)3)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)4)), (Object)BoxesRunTime.boxToInteger((int)4)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)5)), (Object)BoxesRunTime.boxToInteger((int)0)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)6)), (Object)BoxesRunTime.boxToInteger((int)1)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)7)), (Object)BoxesRunTime.boxToInteger((int)2)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)8)), (Object)BoxesRunTime.boxToInteger((int)3)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)9)), (Object)BoxesRunTime.boxToInteger((int)4)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)10)), (Object)BoxesRunTime.boxToInteger((int)1)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)11)), (Object)BoxesRunTime.boxToInteger((int)1))}));
        String topic = "test";
        Properties topicConfig = new Properties();
        this.createBrokersInZk(this.zkClient(), (Seq<Object>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2, 3, 4})));
        AdminZkClient qual$1 = this.adminZkClient();
        boolean x$4 = qual$1.createTopicWithAssignment$default$4();
        boolean x$5 = qual$1.createTopicWithAssignment$default$5();
        qual$1.createTopicWithAssignment(topic, topicConfig, expectedReplicaAssignment, x$4, x$5);
        this.makeLeaderForPartition(this.zkClient(), topic, (scala.collection.immutable.Map<Object, Object>)leaderForPartitionMap);
        scala.collection.immutable.Map actualReplicaMap = ((TraversableOnce)leaderForPartitionMap.keys().map((Function1 & Serializable & scala.Serializable)p -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)p))), (Object)this.zkClient().getReplicasForPartition(new TopicPartition(topic, BoxesRunTime.unboxToInt((Object)p)))), Iterable$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        Assertions.assertEquals((int)expectedReplicaAssignment.size(), (int)actualReplicaMap.size());
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), actualReplicaMap.size()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> Assertions.assertEquals((Object)expectedReplicaAssignment.apply((Object)BoxesRunTime.boxToInteger((int)i)), (Object)actualReplicaMap.apply((Object)BoxesRunTime.boxToInteger((int)i))));
        Assertions.assertThrows(TopicExistsException.class, () -> {
            AdminZkClient qual$2 = this.adminZkClient();
            boolean x$9 = qual$2.createTopicWithAssignment$default$4();
            boolean x$10 = qual$2.createTopicWithAssignment$default$5();
            qual$2.createTopicWithAssignment(topic, topicConfig, expectedReplicaAssignment, x$9, x$10);
        });
    }

    @Test
    public void testTopicCreationWithCollision() {
        String topic = "test.topic";
        String collidingTopic = "test_topic";
        this.createBrokersInZk(this.zkClient(), (Seq<Object>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2, 3, 4})));
        AdminZkClient qual$1 = this.adminZkClient();
        int x$2 = 3;
        int x$3 = 1;
        Properties x$4 = qual$1.createTopic$default$4();
        RackAwareMode x$5 = qual$1.createTopic$default$5();
        boolean x$6 = qual$1.createTopic$default$6();
        qual$1.createTopic(topic, x$2, x$3, x$4, x$5, x$6);
        Assertions.assertThrows(InvalidTopicException.class, () -> {
            AdminZkClient qual$2 = this.adminZkClient();
            int x$8 = 3;
            int x$9 = 1;
            Properties x$10 = qual$2.createTopic$default$4();
            RackAwareMode x$11 = qual$2.createTopic$default$5();
            boolean x$12 = qual$2.createTopic$default$6();
            qual$2.createTopic(collidingTopic, x$8, x$9, x$10, x$11, x$12);
        });
    }

    @Test
    public void testMarkedDeletionTopicCreation() {
        KafkaZkClient zkMock = (KafkaZkClient)Mockito.mock(KafkaZkClient.class);
        String topic = new TopicPartition("test", 0).topic();
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)zkMock.isTopicMarkedForDeletion(topic))).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)true));
        AdminZkClient adminZkClient = new AdminZkClient(zkMock, AdminZkClient$.MODULE$.$lessinit$greater$default$2());
        Assertions.assertThrows(TopicExistsException.class, () -> adminZkClient.validateTopicCreate(topic, (Map)Map$.MODULE$.empty(), new Properties()));
    }

    @Test
    public void testMockedConcurrentTopicCreation() {
        String topic = "test.topic";
        KafkaZkClient zkMock = (KafkaZkClient)Mockito.mock(KafkaZkClient.class);
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)zkMock.topicExists(topic))).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)false));
        Mockito.when((Object)zkMock.getAllTopicsInCluster(zkMock.getAllTopicsInCluster$default$1())).thenReturn((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"some.topic", topic, "some.other.topic"})));
        AdminZkClient adminZkClient = new AdminZkClient(zkMock, AdminZkClient$.MODULE$.$lessinit$greater$default$2());
        Assertions.assertThrows(TopicExistsException.class, () -> adminZkClient.validateTopicCreate(topic, (Map)Map$.MODULE$.empty(), new Properties()));
    }

    @Test
    public void testConcurrentTopicCreation() {
        String topic = "test-concurrent-topic-creation";
        this.createBrokersInZk(this.zkClient(), (Seq<Object>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2, 3, 4})));
        Properties props = new Properties();
        props.setProperty("min.insync.replicas", "2");
        TestUtils$.MODULE$.assertConcurrent("Concurrent topic creation failed", (Seq<Function0<Object>>)new .colon.colon((JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.createTopic$1(topic, props), (List)new .colon.colon((JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.createTopic$1(topic, props), (List)Nil$.MODULE$)), (int)15000L);
    }

    @Test
    public void testTopicConfigChange() {
        int partitions = 3;
        String topic = "my-topic";
        KafkaServer server = TestUtils$.MODULE$.createServer(KafkaConfig$.MODULE$.fromProps(TestUtils$.MODULE$.createBrokerConfig(0, this.zkConnect(), TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18(), TestUtils$.MODULE$.createBrokerConfig$default$19(), TestUtils$.MODULE$.createBrokerConfig$default$20(), TestUtils$.MODULE$.createBrokerConfig$default$21())), TestUtils$.MODULE$.createServer$default$2());
        this.servers_$eq((Seq<KafkaServer>)new .colon.colon((Object)server, (List)Nil$.MODULE$));
        int maxMessageSize = 1024;
        int retentionMs = 1000000;
        AdminZkClient qual$1 = this.adminZkClient();
        int x$3 = 1;
        Properties x$4 = AdminZkClientTest.makeConfig$1(maxMessageSize, retentionMs, "0:0,1:0,2:0", "0:1,1:1,2:1");
        RackAwareMode x$5 = qual$1.createTopic$default$5();
        boolean x$6 = qual$1.createTopic$default$6();
        qual$1.createTopic(topic, partitions, x$3, x$4, x$5, x$6);
        AdminZkClientTest.checkConfig$1(maxMessageSize, retentionMs, "0:0,1:0,2:0", "0:1,1:1,2:1", false, partitions, topic, server);
        this.adminZkClient().changeTopicConfig(topic, AdminZkClientTest.makeConfig$1(maxMessageSize, retentionMs, "0:0,1:0,2:0", "0:1,1:1,2:1"));
        AdminZkClientTest.checkConfig$1(maxMessageSize, retentionMs, "0:0,1:0,2:0", "0:1,1:1,2:1", true, partitions, topic, server);
        Properties newConfig = AdminZkClientTest.makeConfig$1(2 * maxMessageSize, 2 * retentionMs, "*", "*");
        this.adminZkClient().changeTopicConfig(topic, AdminZkClientTest.makeConfig$1(2 * maxMessageSize, 2 * retentionMs, "*", "*"));
        AdminZkClientTest.checkConfig$1(2 * maxMessageSize, 2 * retentionMs, "*", "*", true, partitions, topic, server);
        Properties configInZk = this.adminZkClient().fetchEntityConfig("topics", topic);
        Assertions.assertEquals((Object)newConfig, (Object)configInZk);
        this.adminZkClient().changeTopicConfig(topic, new Properties());
        AdminZkClientTest.checkConfig$1(0x10000C, 604800000L, "", "", false, partitions, topic, server);
        this.adminZkClient().changeTopicConfig(topic, AdminZkClientTest.makeConfig$1(maxMessageSize, retentionMs, "0:0,1:0,2:0", "0:1,1:1,2:1"));
        AdminZkClientTest.checkConfig$1(maxMessageSize, retentionMs, "0:0,1:0,2:0", "0:1,1:1,2:1", true, partitions, topic, server);
        this.adminZkClient().changeTopicConfig(topic, CoreUtils$.MODULE$.propsWith((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"follower.replication.throttled.replicas", (Object)""), new Tuple2((Object)"leader.replication.throttled.replicas", (Object)"")})));
        AdminZkClientTest.checkConfig$1(0x10000C, 604800000L, "", "", false, partitions, topic, server);
    }

    @Test
    public void shouldPropagateDynamicBrokerConfigs() {
        Seq brokerIds = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2}));
        this.servers_$eq((Seq<KafkaServer>)((Seq)((TraversableLike)TestUtils$.MODULE$.createBrokerConfigs(3, this.zkConnect(), TestUtils$.MODULE$.createBrokerConfigs$default$3(), TestUtils$.MODULE$.createBrokerConfigs$default$4(), TestUtils$.MODULE$.createBrokerConfigs$default$5(), TestUtils$.MODULE$.createBrokerConfigs$default$6(), TestUtils$.MODULE$.createBrokerConfigs$default$7(), TestUtils$.MODULE$.createBrokerConfigs$default$8(), TestUtils$.MODULE$.createBrokerConfigs$default$9(), TestUtils$.MODULE$.createBrokerConfigs$default$10(), TestUtils$.MODULE$.createBrokerConfigs$default$11(), TestUtils$.MODULE$.createBrokerConfigs$default$12(), TestUtils$.MODULE$.createBrokerConfigs$default$13(), TestUtils$.MODULE$.createBrokerConfigs$default$14(), TestUtils$.MODULE$.createBrokerConfigs$default$15(), TestUtils$.MODULE$.createBrokerConfigs$default$16(), TestUtils$.MODULE$.createBrokerConfigs$default$17(), TestUtils$.MODULE$.createBrokerConfigs$default$18()).map((Function1 & Serializable & scala.Serializable)props -> KafkaConfig$.MODULE$.fromProps(props), Seq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x$1 -> TestUtils$.MODULE$.createServer((KafkaConfig)x$1, TestUtils$.MODULE$.createServer$default$2()), Seq$.MODULE$.canBuildFrom())));
        long limit = 1000000L;
        this.adminZkClient().changeBrokerConfig(brokerIds, CoreUtils$.MODULE$.propsWith((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"leader.replication.throttled.rate", (Object)Long.toString(limit)), new Tuple2((Object)"follower.replication.throttled.rate", (Object)Long.toString(limit))})));
        this.checkConfig$2(limit);
        long newLimit = 2L * limit;
        this.adminZkClient().changeBrokerConfig(brokerIds, CoreUtils$.MODULE$.propsWith((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"leader.replication.throttled.rate", (Object)Long.toString(newLimit)), new Tuple2((Object)"follower.replication.throttled.rate", (Object)Long.toString(newLimit))})));
        this.checkConfig$2(newLimit);
        brokerIds.foreach((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)brokerId -> {
            Properties configInZk = this.adminZkClient().fetchEntityConfig("brokers", Integer.toString(brokerId));
            Assertions.assertEquals((long)newLimit, (long)new StringOps(Predef$.MODULE$.augmentString(configInZk.getProperty("leader.replication.throttled.rate"))).toInt());
            Assertions.assertEquals((long)newLimit, (long)new StringOps(Predef$.MODULE$.augmentString(configInZk.getProperty("follower.replication.throttled.rate"))).toInt());
        });
        this.adminZkClient().changeBrokerConfig(brokerIds, new Properties());
        this.checkConfig$2(Long.MAX_VALUE);
    }

    @Test
    public void testBootstrapClientIdConfig() {
        String clientId = "my-client";
        Properties props = new Properties();
        props.setProperty("producer_byte_rate", "1000");
        props.setProperty("consumer_byte_rate", "2000");
        this.zkClient().setOrCreateEntityConfigs("clients", clientId, props);
        Map configInZk = this.adminZkClient().fetchAllEntityConfigs("clients");
        Assertions.assertEquals((int)1, (int)configInZk.size(), (String)"Must have 1 overridden client config");
        Assertions.assertEquals((Object)props, (Object)configInZk.apply((Object)clientId));
        KafkaServer server = TestUtils$.MODULE$.createServer(KafkaConfig$.MODULE$.fromProps(TestUtils$.MODULE$.createBrokerConfig(0, this.zkConnect(), TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18(), TestUtils$.MODULE$.createBrokerConfig$default$19(), TestUtils$.MODULE$.createBrokerConfig$default$20(), TestUtils$.MODULE$.createBrokerConfig$default$21())), TestUtils$.MODULE$.createServer$default$2());
        this.servers_$eq((Seq<KafkaServer>)new .colon.colon((Object)server, (List)Nil$.MODULE$));
        Assertions.assertEquals((Object)new Quota(1000.0, true), (Object)server.dataPlaneRequestProcessor().quotas().produce().quota("ANONYMOUS", clientId));
        Assertions.assertEquals((Object)new Quota(2000.0, true), (Object)server.dataPlaneRequestProcessor().quotas().fetch().quota("ANONYMOUS", clientId));
    }

    @Test
    public void testGetBrokerMetadatas() {
        Range.Inclusive brokerList = RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), 5);
        Map rackInfo = (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)"rack1"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)"rack2"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)2)), (Object)"rack2"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)3)), (Object)"rack1"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)5)), (Object)"rack3")}));
        Collection<BrokerMetadata> brokerMetadatas = this.toBrokerMetadata((Map<Object, String>)rackInfo, (Seq<Object>)((Seq)brokerList.filterNot((Function1)rackInfo.keySet())));
        this.createBrokersInZk((Seq<BrokerMetadata>)((TraversableOnce)CollectionConverters$.MODULE$.collectionAsScalaIterableConverter(brokerMetadatas).asScala()).toSeq(), this.zkClient());
        AdminZkClient qual$1 = this.adminZkClient();
        RackAwareMode.Disabled$ x$1 = RackAwareMode.Disabled$.MODULE$;
        Option x$22 = qual$1.getBrokerMetadatas$default$2();
        Seq processedMetadatas1 = qual$1.getBrokerMetadatas((RackAwareMode)x$1, x$22);
        Assertions.assertEquals((Object)brokerList, (Object)processedMetadatas1.map((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToInteger((int)x$2.id), Seq$.MODULE$.canBuildFrom()));
        Assertions.assertEquals((Object)List$.MODULE$.fill(brokerList.size(), (Function0 & Serializable & scala.Serializable)() -> Optional.empty()), (Object)processedMetadatas1.map((Function1 & Serializable & scala.Serializable)x$3 -> x$3.rack, Seq$.MODULE$.canBuildFrom()));
        AdminZkClient qual$2 = this.adminZkClient();
        RackAwareMode.Safe$ x$32 = RackAwareMode.Safe$.MODULE$;
        Option x$42 = qual$2.getBrokerMetadatas$default$2();
        Seq processedMetadatas2 = qual$2.getBrokerMetadatas((RackAwareMode)x$32, x$42);
        Assertions.assertEquals((Object)brokerList, (Object)processedMetadatas2.map((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToInteger((int)x$4.id), Seq$.MODULE$.canBuildFrom()));
        Assertions.assertEquals((Object)List$.MODULE$.fill(brokerList.size(), (Function0 & Serializable & scala.Serializable)() -> Optional.empty()), (Object)processedMetadatas2.map((Function1 & Serializable & scala.Serializable)x$5 -> x$5.rack, Seq$.MODULE$.canBuildFrom()));
        Assertions.assertThrows(AdminOperationException.class, () -> {
            AdminZkClient qual$3 = this.adminZkClient();
            RackAwareMode.Enforced$ x$5 = RackAwareMode.Enforced$.MODULE$;
            Option x$6 = qual$3.getBrokerMetadatas$default$2();
            qual$3.getBrokerMetadatas((RackAwareMode)x$5, x$6);
        });
        List partialList = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2, 3, 5}));
        Seq processedMetadatas3 = this.adminZkClient().getBrokerMetadatas((RackAwareMode)RackAwareMode.Enforced$.MODULE$, (Option)new Some((Object)partialList));
        Assertions.assertEquals((Object)partialList, (Object)processedMetadatas3.map((Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToInteger((int)x$6.id), Seq$.MODULE$.canBuildFrom()));
        Assertions.assertEquals((Object)partialList.map((Function1)rackInfo, List$.MODULE$.canBuildFrom()), (Object)processedMetadatas3.map((Function1 & Serializable & scala.Serializable)x$7 -> (String)x$7.rack.get(), Seq$.MODULE$.canBuildFrom()));
        int numPartitions = 3;
        AdminZkClient qual$4 = this.adminZkClient();
        String x$72 = "foo";
        int x$9 = 2;
        RackAwareMode.Safe$ x$10 = RackAwareMode.Safe$.MODULE$;
        Properties x$11 = qual$4.createTopic$default$4();
        boolean x$12 = qual$4.createTopic$default$6();
        qual$4.createTopic(x$72, numPartitions, x$9, x$11, (RackAwareMode)x$10, x$12);
        Map assignment = this.zkClient().getReplicaAssignmentForTopics((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"foo"})));
        Assertions.assertEquals((int)numPartitions, (int)assignment.size());
    }

    @Test
    public void testChangeUserOrUserClientIdConfigWithUserAndClientId() {
        Properties config = new Properties();
        config.put("producer_byte_rate", this.producerByteRate());
        this.adminZkClient().changeUserOrUserClientIdConfig("user01/clients/client01", config, true);
        Properties props = this.zkClient().getEntityConfigs("users", "user01/clients/client01");
        Assertions.assertEquals((Object)this.producerByteRate(), (Object)props.getProperty("producer_byte_rate"));
        this.adminZkClient().changeUserOrUserClientIdConfig("user01/clients/client01", new Properties(), true);
        Seq users = this.zkClient().getChildren(ConfigEntityTypeZNode$.MODULE$.path("users"));
        Predef$.MODULE$.assert(users.isEmpty());
        AdminZkClient qual$1 = this.adminZkClient();
        String x$1 = "user01";
        boolean x$3 = qual$1.changeUserOrUserClientIdConfig$default$3();
        qual$1.changeUserOrUserClientIdConfig(x$1, config, x$3);
        props = this.zkClient().getEntityConfigs("users", "user01");
        Assertions.assertEquals((Object)this.producerByteRate(), (Object)props.getProperty("producer_byte_rate"));
        this.adminZkClient().changeUserOrUserClientIdConfig("user01/clients/client01", config, true);
        props = this.zkClient().getEntityConfigs("users", "user01/clients/client01");
        Assertions.assertEquals((Object)this.producerByteRate(), (Object)props.getProperty("producer_byte_rate"));
        this.adminZkClient().changeUserOrUserClientIdConfig("user01/clients/client01", new Properties(), true);
        Seq seq = users = this.zkClient().getChildren(ConfigEntityTypeZNode$.MODULE$.path("users"));
        .colon.colon colon2 = new .colon.colon((Object)"user01", (List)Nil$.MODULE$);
        Predef$.MODULE$.assert(seq != null && seq.equals(colon2));
    }

    @Test
    public void testChangeUserOrUserClientIdConfigWithUser() {
        Properties config = new Properties();
        config.put("producer_byte_rate", this.producerByteRate());
        AdminZkClient qual$1 = this.adminZkClient();
        String x$1 = "user01";
        boolean x$3 = qual$1.changeUserOrUserClientIdConfig$default$3();
        qual$1.changeUserOrUserClientIdConfig(x$1, config, x$3);
        Properties props = this.zkClient().getEntityConfigs("users", "user01");
        Assertions.assertEquals((Object)this.producerByteRate(), (Object)props.getProperty("producer_byte_rate"));
        AdminZkClient qual$2 = this.adminZkClient();
        String x$4 = "user01";
        Properties x$5 = new Properties();
        boolean x$6 = qual$2.changeUserOrUserClientIdConfig$default$3();
        qual$2.changeUserOrUserClientIdConfig(x$4, x$5, x$6);
        Seq users = this.zkClient().getChildren(ConfigEntityTypeZNode$.MODULE$.path("users"));
        Predef$.MODULE$.assert(users.isEmpty());
    }

    @Test
    public void testChangeClientIdConfig() {
        Properties config = new Properties();
        config.put("producer_byte_rate", this.producerByteRate());
        this.adminZkClient().changeClientIdConfig("client01", config);
        Properties props = this.zkClient().getEntityConfigs("clients", "client01");
        Assertions.assertEquals((Object)this.producerByteRate(), (Object)props.getProperty("producer_byte_rate"));
        this.adminZkClient().changeClientIdConfig("client01", new Properties());
        Seq users = this.zkClient().getChildren(ConfigEntityTypeZNode$.MODULE$.path("clients"));
        Predef$.MODULE$.assert(users.isEmpty());
    }

    @Test
    public void testChangeIpConfig() {
        Properties config = new Properties();
        config.put("connection_creation_rate", this.ipConnectionRate());
        this.adminZkClient().changeIpConfig("127.0.0.1", config);
        Properties props = this.zkClient().getEntityConfigs("ips", "127.0.0.1");
        Assertions.assertEquals((Object)this.ipConnectionRate(), (Object)props.getProperty("connection_creation_rate"));
        this.adminZkClient().changeIpConfig("127.0.0.1", new Properties());
        Seq users = this.zkClient().getChildren(ConfigEntityTypeZNode$.MODULE$.path("ips"));
        Predef$.MODULE$.assert(users.isEmpty());
    }

    private Seq<Broker> createBrokersInZk(KafkaZkClient zkClient, Seq<Object> ids) {
        return this.createBrokersInZk((Seq<BrokerMetadata>)((Seq)ids.map((Function1 & Serializable & scala.Serializable)x$8 -> AdminZkClientTest.$anonfun$createBrokersInZk$1(BoxesRunTime.unboxToInt((Object)x$8)), Seq$.MODULE$.canBuildFrom())), zkClient);
    }

    private Seq<Broker> createBrokersInZk(Seq<BrokerMetadata> brokerMetadatas, KafkaZkClient zkClient) {
        zkClient.makeSurePersistentPathExists(BrokerIdsZNode$.MODULE$.path());
        Seq brokers = (Seq)brokerMetadatas.map((Function1 & Serializable & scala.Serializable)b -> {
            SecurityProtocol protocol = SecurityProtocol.PLAINTEXT;
            ListenerName listenerName = ListenerName.forSecurityProtocol((SecurityProtocol)protocol);
            return Broker$.MODULE$.apply(b.id, (Seq)new .colon.colon((Object)new EndPoint("localhost", 6667, listenerName, protocol), (List)Nil$.MODULE$), (Option)(b.rack.isPresent() ? new Some(b.rack.get()) : None$.MODULE$));
        }, Seq$.MODULE$.canBuildFrom());
        brokers.foreach((Function1 & Serializable & scala.Serializable)b -> BoxesRunTime.boxToLong((long)zkClient.registerBroker(BrokerInfo$.MODULE$.apply(Broker$.MODULE$.apply(b.id(), b.endPoints(), b.rack()), MetadataVersion.latestTesting(), -1))));
        return brokers;
    }

    private void makeLeaderForPartition(KafkaZkClient zkClient, String topic, scala.collection.immutable.Map<Object, Object> leaderPerPartitionMap) {
        scala.collection.immutable.Map newLeaderIsrAndControllerEpochs = (scala.collection.immutable.Map)leaderPerPartitionMap.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            if (x0$1 != null) {
                int partition = x0$1._1$mcI$sp();
                int leader = x0$1._2$mcI$sp();
                TopicPartition topicPartition = new TopicPartition(topic, partition);
                LeaderAndIsr newLeaderAndIsr = (LeaderAndIsr)zkClient.getTopicPartitionState(topicPartition).map((Function1 & Serializable & scala.Serializable)x$9 -> x$9.leaderAndIsr().newLeader(leader)).getOrElse((Function0 & Serializable & scala.Serializable)() -> LeaderAndIsr$.MODULE$.apply(leader, List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{leader}))));
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicPartition), (Object)new LeaderIsrAndControllerEpoch(newLeaderAndIsr, 1));
            }
            throw new MatchError(null);
        }, scala.collection.immutable.Map$.MODULE$.canBuildFrom());
        zkClient.setTopicPartitionStatesRaw((Map)newLeaderIsrAndControllerEpochs, ZkVersion$.MODULE$.MatchAnyVersion());
    }

    public static final /* synthetic */ void $anonfun$testConcurrentTopicCreation$1(Tuple2 x0$1) {
        if (x0$1 != null) {
            int partition = x0$1._1$mcI$sp();
            ReplicaAssignment partitionReplicaAssignment = (ReplicaAssignment)x0$1._2();
            Assertions.assertEquals((int)1, (int)partitionReplicaAssignment.replicas().size(), (String)new StringBuilder(34).append("Unexpected replication factor for ").append(partition).toString());
            return;
        }
        throw new MatchError(null);
    }

    /*
     * WARNING - void declaration
     */
    private final void createTopic$1(String topic$4, Properties props$1) {
        void var9_9;
        try {
            AdminZkClient qual$1 = this.adminZkClient();
            int x$2 = 3;
            int x$3 = 1;
            RackAwareMode x$5 = qual$1.createTopic$default$5();
            boolean x$6 = qual$1.createTopic$default$6();
            qual$1.createTopic(topic$4, x$2, x$3, props$1, x$5, x$6);
        }
        catch (TopicExistsException topicExistsException) {}
        Tuple2 tuple2 = (Tuple2)this.zkClient().getPartitionAssignmentForTopics((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{topic$4}))).head();
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        Map partitionAssignment = (Map)tuple2._2();
        Assertions.assertEquals((int)3, (int)var9_9.size());
        var9_9.foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            AdminZkClientTest.$anonfun$testConcurrentTopicCreation$1(x0$1);
            return BoxedUnit.UNIT;
        });
        Properties savedProps = this.zkClient().getEntityConfigs("topics", topic$4);
        Assertions.assertEquals((Object)props$1, (Object)savedProps);
    }

    private static final Properties makeConfig$1(int messageSize, long retentionMs, String throttledLeaders, String throttledFollowers) {
        Properties props = new Properties();
        props.setProperty("max.message.bytes", Integer.toString(messageSize));
        props.setProperty("retention.ms", Long.toString(retentionMs));
        props.setProperty("leader.replication.throttled.replicas", throttledLeaders);
        props.setProperty("follower.replication.throttled.replicas", throttledFollowers);
        return props;
    }

    private static final void checkList$1(java.util.List actual, String expected) {
        Assertions.assertNotNull((Object)actual);
        String string = expected;
        String string2 = "";
        if (string != null && string.equals(string2)) {
            Assertions.assertTrue((boolean)actual.isEmpty());
            return;
        }
        Assertions.assertEquals((Object)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])expected.split(","))).toSeq(), (Object)CollectionConverters$.MODULE$.asScalaBufferConverter(actual).asScala());
    }

    public static final /* synthetic */ void $anonfun$testTopicConfigChange$1(int partitions$1, String topic$5, KafkaServer server$1, long retentionMs$1, int messageSize$1, String throttledLeaders$1, String throttledFollowers$1, boolean quotaManagerIsThrottled$1) {
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), partitions$1).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)part -> {
            TopicPartition tp = new TopicPartition(topic$5, part);
            LogManager qual$1 = server$1.logManager();
            boolean x$2 = qual$1.getLog$default$2();
            Option log = qual$1.getLog(tp, x$2);
            Assertions.assertTrue((boolean)log.isDefined());
            Assertions.assertEquals((long)retentionMs$1, (long)((UnifiedLog)log.get()).config().retentionMs);
            Assertions.assertEquals((int)messageSize$1, (int)((UnifiedLog)log.get()).config().maxMessageSize());
            AdminZkClientTest.checkList$1(((UnifiedLog)log.get()).config().leaderReplicationThrottledReplicas, throttledLeaders$1);
            AdminZkClientTest.checkList$1(((UnifiedLog)log.get()).config().followerReplicationThrottledReplicas, throttledFollowers$1);
            Assertions.assertEquals((Object)BoxesRunTime.boxToBoolean((boolean)quotaManagerIsThrottled$1), (Object)BoxesRunTime.boxToBoolean((boolean)server$1.quotaManagers().leader().isThrottled(tp)));
        });
    }

    /*
     * WARNING - void declaration
     */
    private static final void checkConfig$1(int messageSize, long retentionMs, String throttledLeaders, String throttledFollowers, boolean quotaManagerIsThrottled, int partitions$1, String topic$5, KafkaServer server$1) {
        TestUtils$ testUtils$ = TestUtils$.MODULE$;
        long l = 10000L;
        if (testUtils$ == null) {
            throw null;
        }
        TestUtils$ retry_this = testUtils$;
        LongRef retry_wait = LongRef.create((long)1L);
        long retry_startTime = System.currentTimeMillis();
        while (true) {
            try {
                AdminZkClientTest.$anonfun$testTopicConfigChange$1(partitions$1, topic$5, server$1, retentionMs, messageSize, throttledLeaders, throttledFollowers, quotaManagerIsThrottled);
            }
            catch (AssertionError retry_e) {
                void retry_maxWaitMs;
                if (System.currentTimeMillis() - retry_startTime > retry_maxWaitMs) {
                    throw retry_e;
                }
                if (retry_this.logger().underlying().isInfoEnabled()) {
                    retry_this.logger().underlying().info(retry_this.msgWithLogIdent(TestUtils$.$anonfun$retry$1(retry_wait)));
                }
                Thread.sleep(retry_wait.elem);
                retry_wait.elem += package$.MODULE$.min(retry_wait.elem, 1000L);
                continue;
            }
            break;
        }
    }

    public static final /* synthetic */ void $anonfun$shouldPropagateDynamicBrokerConfigs$4(long limit$1, KafkaServer server) {
        Assertions.assertEquals((long)limit$1, (long)server.quotaManagers().leader().upperBound(), (String)"Leader Quota Manager was not updated");
        Assertions.assertEquals((long)limit$1, (long)server.quotaManagers().follower().upperBound(), (String)"Follower Quota Manager was not updated");
    }

    public static final /* synthetic */ void $anonfun$shouldPropagateDynamicBrokerConfigs$3(AdminZkClientTest $this, long limit$1) {
        $this.servers().foreach((Function1 & Serializable & scala.Serializable)server -> {
            AdminZkClientTest.$anonfun$shouldPropagateDynamicBrokerConfigs$4(limit$1, server);
            return BoxedUnit.UNIT;
        });
    }

    /*
     * WARNING - void declaration
     */
    private final void checkConfig$2(long limit) {
        TestUtils$ testUtils$ = TestUtils$.MODULE$;
        long l = 10000L;
        if (testUtils$ == null) {
            throw null;
        }
        TestUtils$ retry_this = testUtils$;
        LongRef retry_wait = LongRef.create((long)1L);
        long retry_startTime = System.currentTimeMillis();
        while (true) {
            try {
                AdminZkClientTest.$anonfun$shouldPropagateDynamicBrokerConfigs$3(this, limit);
            }
            catch (AssertionError retry_e) {
                void retry_maxWaitMs;
                if (System.currentTimeMillis() - retry_startTime > retry_maxWaitMs) {
                    throw retry_e;
                }
                if (retry_this.logger().underlying().isInfoEnabled()) {
                    retry_this.logger().underlying().info(retry_this.msgWithLogIdent(TestUtils$.$anonfun$retry$1(retry_wait)));
                }
                Thread.sleep(retry_wait.elem);
                retry_wait.elem += package$.MODULE$.min(retry_wait.elem, 1000L);
                continue;
            }
            break;
        }
    }

    public static final /* synthetic */ BrokerMetadata $anonfun$createBrokersInZk$1(int x$8) {
        return new BrokerMetadata(x$8, Optional.empty());
    }

    public AdminZkClientTest() {
        RackAwareTest.$init$(this);
        this.producerByteRate = "1024";
        this.ipConnectionRate = "10";
        this.servers = Nil$.MODULE$;
    }
}

