/*
 * Decompiled with CFR 0.152.
 */
package kafka.api;

import java.io.Serializable;
import java.util.Collection;
import java.util.Properties;
import java.util.concurrent.ExecutionException;
import kafka.api.GroupAuthorizerIntegrationTest$;
import kafka.security.authorizer.AclAuthorizer;
import kafka.server.BaseRequestTest;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.acl.AccessControlEntry;
import org.apache.kafka.common.acl.AclOperation;
import org.apache.kafka.common.acl.AclPermissionType;
import org.apache.kafka.common.errors.TopicAuthorizationException;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.resource.PatternType;
import org.apache.kafka.common.resource.ResourcePattern;
import org.apache.kafka.common.resource.ResourceType;
import org.apache.kafka.common.security.auth.AuthenticationContext;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.apache.kafka.common.security.authenticator.DefaultKafkaPrincipalBuilder;
import org.apache.kafka.common.serialization.ByteArrayDeserializer;
import org.apache.kafka.metadata.authorizer.StandardAuthorizer;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.TestInfo;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;
import scala.Function1;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0001\u0005Mx!B\u0011#\u0011\u00039c!B\u0015#\u0011\u0003Q\u0003\"B\u0019\u0002\t\u0003\u0011\u0004bB\u001a\u0002\u0005\u0004%\t\u0001\u000e\u0005\u0007\t\u0006\u0001\u000b\u0011B\u001b\t\u000f\u0015\u000b!\u0019!C\u0001i!1a)\u0001Q\u0001\nUBqaR\u0001C\u0002\u0013\u0005\u0001\n\u0003\u0004R\u0003\u0001\u0006I!\u0013\u0005\b%\u0006\u0011\r\u0011\"\u0001I\u0011\u0019\u0019\u0016\u0001)A\u0005\u0013\"9A+\u0001b\u0001\n\u0003A\u0005BB+\u0002A\u0003%\u0011J\u0002\u0003W\u0003\u00019\u0006\"B\u0019\u000e\t\u0003q\u0006\"B1\u000e\t\u0003\u0012g\u0001B\u0015#\u0001!DQ!\r\t\u0005\u0002=Dq!\u001d\tC\u0002\u0013\u0005!\u000f\u0003\u0004w!\u0001\u0006Ia\u001d\u0005\u0006oB!\t\u0005\u001f\u0005\u0006yB!\t% \u0005\u0007\u0003\u0013\u0001B\u0011I?\t\r\u0005-\u0001\u0003\"\u00015\u0011\u0019\ti\u0001\u0005C\u0001i!9\u0011q\u0002\t\u0005B\u0005E\u0001bBA!!\u0011\u0005\u00131\t\u0005\b\u0003\u001f\u0002B\u0011BA)\u0011\u001d\t)\u0006\u0005C!\u0003/Bq!a\u0019\u0011\t\u0013\t)\u0007C\u0005\u0002\fB\t\n\u0011\"\u0003\u0002\u000e\"9\u00111\u0015\t\u0005\u0002\u0005\u0015\u0006bBAt!\u0011\u0005\u0011\u0011^\u0001\u001f\u000fJ|W\u000f]!vi\"|'/\u001b>fe&sG/Z4sCRLwN\u001c+fgRT!a\t\u0013\u0002\u0007\u0005\u0004\u0018NC\u0001&\u0003\u0015Y\u0017MZ6b\u0007\u0001\u0001\"\u0001K\u0001\u000e\u0003\t\u0012ad\u0012:pkB\fU\u000f\u001e5pe&TXM]%oi\u0016<'/\u0019;j_:$Vm\u001d;\u0014\u0005\u0005Y\u0003C\u0001\u00170\u001b\u0005i#\"\u0001\u0018\u0002\u000bM\u001c\u0017\r\\1\n\u0005Aj#AB!osJ+g-\u0001\u0004=S:LGO\u0010\u000b\u0002O\u0005y!I]8lKJ\u0004&/\u001b8dSB\fG.F\u00016!\t1$)D\u00018\u0015\tA\u0014(\u0001\u0003bkRD'B\u0001\u001e<\u0003!\u0019XmY;sSRL(B\u0001\u001f>\u0003\u0019\u0019w.\\7p]*\u0011QE\u0010\u0006\u0003\u007f\u0001\u000ba!\u00199bG\",'\"A!\u0002\u0007=\u0014x-\u0003\u0002Do\tq1*\u00194lCB\u0013\u0018N\\2ja\u0006d\u0017\u0001\u0005\"s_.,'\u000f\u0015:j]\u000eL\u0007/\u00197!\u0003=\u0019E.[3oiB\u0013\u0018N\\2ja\u0006d\u0017\u0001E\"mS\u0016tG\u000f\u0015:j]\u000eL\u0007/\u00197!\u0003I\u0011%o\\6fe2K7\u000f^3oKJt\u0015-\\3\u0016\u0003%\u0003\"AS(\u000e\u0003-S!\u0001T'\u0002\t1\fgn\u001a\u0006\u0002\u001d\u0006!!.\u0019<b\u0013\t\u00016J\u0001\u0004TiJLgnZ\u0001\u0014\u0005J|7.\u001a:MSN$XM\\3s\u001d\u0006lW\rI\u0001\u0013\u00072LWM\u001c;MSN$XM\\3s\u001d\u0006lW-A\nDY&,g\u000e\u001e'jgR,g.\u001a:OC6,\u0007%\u0001\fD_:$(o\u001c7mKJd\u0015n\u001d;f]\u0016\u0014h*Y7f\u0003]\u0019uN\u001c;s_2dWM\u001d'jgR,g.\u001a:OC6,\u0007EA\u000bHe>,\b\u000f\u0015:j]\u000eL\u0007/\u00197Ck&dG-\u001a:\u0014\u00055A\u0006CA-]\u001b\u0005Q&BA.:\u00035\tW\u000f\u001e5f]RL7-\u0019;pe&\u0011QL\u0017\u0002\u001d\t\u00164\u0017-\u001e7u\u0017\u000647.\u0019)sS:\u001c\u0017\u000e]1m\u0005VLG\u000eZ3s)\u0005y\u0006C\u00011\u000e\u001b\u0005\t\u0011!\u00022vS2$GCA\u001bd\u0011\u0015!w\u00021\u0001f\u0003\u001d\u0019wN\u001c;fqR\u0004\"A\u000e4\n\u0005\u001d<$!F!vi\",g\u000e^5dCRLwN\\\"p]R,\u0007\u0010^\n\u0003!%\u0004\"A[7\u000e\u0003-T!\u0001\u001c\u0013\u0002\rM,'O^3s\u0013\tq7NA\bCCN,'+Z9vKN$H+Z:u)\u0005\u0001\bC\u0001\u0015\u0011\u0003!\u0011'o\\6fe&#W#A:\u0011\u0005)#\u0018BA;L\u0005\u001dIe\u000e^3hKJ\f\u0011B\u0019:pW\u0016\u0014\u0018\n\u001a\u0011\u0002\u0017\t\u0014xn[3s\u0007>,h\u000e^\u000b\u0002sB\u0011AF_\u0005\u0003w6\u00121!\u00138u\u0003]Ig\u000e^3s\u0005J|7.\u001a:MSN$XM\\3s\u001d\u0006lW-F\u0001\u007f!\ry\u0018QA\u0007\u0003\u0003\u0003Q1!a\u0001<\u0003\u001dqW\r^<pe.LA!a\u0002\u0002\u0002\taA*[:uK:,'OT1nK\u0006aA.[:uK:,'OT1nK\u0006y!M]8lKJ\u0004&/\u001b8dSB\fG.A\bdY&,g\u000e\u001e)sS:\u001c\u0017\u000e]1m\u0003YY'/\u00194u\u0007>tGO]8mY\u0016\u00148i\u001c8gS\u001e\u001cH\u0003BA\n\u0003W\u0001b!!\u0006\u0002\u001c\u0005}QBAA\f\u0015\r\tI\"L\u0001\u000bG>dG.Z2uS>t\u0017\u0002BA\u000f\u0003/\u00111aU3r!\u0011\t\t#a\n\u000e\u0005\u0005\r\"bAA\u0013\u001b\u0006!Q\u000f^5m\u0013\u0011\tI#a\t\u0003\u0015A\u0013x\u000e]3si&,7\u000fC\u0004\u0002.e\u0001\r!a\f\u0002\u0011Q,7\u000f^%oM>\u0004B!!\r\u0002>5\u0011\u00111\u0007\u0006\u0004G\u0005U\"\u0002BA\u001c\u0003s\tqA[;qSR,'OC\u0002\u0002<\u0001\u000bQA[;oSRLA!a\u0010\u00024\tAA+Z:u\u0013:4w.A\fce>\\WM\u001d)s_B,'\u000f^=Pm\u0016\u0014(/\u001b3fgR!\u0011QIA&!\ra\u0013qI\u0005\u0004\u0003\u0013j#\u0001B+oSRDq!!\u0014\u001b\u0001\u0004\ty\"\u0001\u0006qe>\u0004XM\u001d;jKN\f\u0011#\u00193e\u001d>$W\r\u0015:pa\u0016\u0014H/[3t)\u0011\t)%a\u0015\t\u000f\u000553\u00041\u0001\u0002 \u0005)1/\u001a;VaR!\u0011QIA-\u0011\u001d\ti\u0003\ba\u0001\u0003_A3\u0001HA/!\u0011\t\t$a\u0018\n\t\u0005\u0005\u00141\u0007\u0002\u000b\u0005\u00164wN]3FC\u000eD\u0017!C2sK\u0006$X-Q2m)!\t9'a\u001d\u0002~\u0005\u001d\u0005\u0003BA5\u0003_j!!a\u001b\u000b\u0007\u000554(A\u0002bG2LA!!\u001d\u0002l\t\u0011\u0012iY2fgN\u001cuN\u001c;s_2,e\u000e\u001e:z\u0011\u001d\t)(\ba\u0001\u0003o\nA\"Y2m\u001fB,'/\u0019;j_:\u0004B!!\u001b\u0002z%!\u00111PA6\u00051\t5\r\\(qKJ\fG/[8o\u0011\u001d\ty(\ba\u0001\u0003\u0003\u000b\u0011#Y2m!\u0016\u0014X.[:tS>tG+\u001f9f!\u0011\tI'a!\n\t\u0005\u0015\u00151\u000e\u0002\u0012\u0003\u000ed\u0007+\u001a:nSN\u001c\u0018n\u001c8UsB,\u0007\u0002CAE;A\u0005\t\u0019A\u001b\u0002\u0013A\u0014\u0018N\\2ja\u0006d\u0017aE2sK\u0006$X-Q2mI\u0011,g-Y;mi\u0012\u001aTCAAHU\r)\u0014\u0011S\u0016\u0003\u0003'\u0003B!!&\u0002 6\u0011\u0011q\u0013\u0006\u0005\u00033\u000bY*A\u0005v]\u000eDWmY6fI*\u0019\u0011QT\u0017\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0002\"\u0006]%!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0006\tC/Z:u+:\fW\u000f\u001e5pe&TX\r\u001a)s_\u0012,8-Z!oI\u000e{gn];nKR!\u0011QIAT\u0011\u001d\tIk\ba\u0001\u0003W\u000ba!];peVl\u0007\u0003BAW\u0003wsA!a,\u00028B\u0019\u0011\u0011W\u0017\u000e\u0005\u0005M&bAA[M\u00051AH]8pizJ1!!/.\u0003\u0019\u0001&/\u001a3fM&\u0019\u0001+!0\u000b\u0007\u0005eV\u0006K\u0004 \u0003\u0003\f\t.a5\u0011\t\u0005\r\u0017QZ\u0007\u0003\u0003\u000bTA!a2\u0002J\u0006A\u0001O]8wS\u0012,'O\u0003\u0003\u0002L\u0006U\u0012A\u00029be\u0006l7/\u0003\u0003\u0002P\u0006\u0015'a\u0003,bYV,7k\\;sG\u0016\fqa\u001d;sS:<7\u000f\f\u0003\u0002V\u0006e\u0017EAAl\u0003\tQ8.\t\u0002\u0002\\\u0006)1N]1gi\"\u001aq$a8\u0011\t\u0005\u0005\u00181]\u0007\u0003\u0003\u0013LA!!:\u0002J\n\t\u0002+\u0019:b[\u0016$XM]5{K\u0012$Vm\u001d;\u0002?Q,7\u000f^!vi\"|'/\u001b>fIB\u0013x\u000eZ;dK\u0006sGmQ8ogVlW\r\u0006\u0003\u0002F\u0005-\bbBAUA\u0001\u0007\u00111\u0016\u0015\bA\u0005\u0005\u0017\u0011[AxY\u0011\t).!7)\u0007\u0001\ny\u000e")
public class GroupAuthorizerIntegrationTest
extends BaseRequestTest {
    private final Integer brokerId = Predef$.MODULE$.int2Integer(0);

    public static String ControllerListenerName() {
        return GroupAuthorizerIntegrationTest$.MODULE$.ControllerListenerName();
    }

    public static String ClientListenerName() {
        return GroupAuthorizerIntegrationTest$.MODULE$.ClientListenerName();
    }

    public static String BrokerListenerName() {
        return GroupAuthorizerIntegrationTest$.MODULE$.BrokerListenerName();
    }

    public static KafkaPrincipal ClientPrincipal() {
        return GroupAuthorizerIntegrationTest$.MODULE$.ClientPrincipal();
    }

    public static KafkaPrincipal BrokerPrincipal() {
        return GroupAuthorizerIntegrationTest$.MODULE$.BrokerPrincipal();
    }

    public Integer brokerId() {
        return this.brokerId;
    }

    @Override
    public int brokerCount() {
        return 1;
    }

    @Override
    public ListenerName interBrokerListenerName() {
        return new ListenerName(GroupAuthorizerIntegrationTest$.MODULE$.BrokerListenerName());
    }

    @Override
    public ListenerName listenerName() {
        return new ListenerName(GroupAuthorizerIntegrationTest$.MODULE$.ClientListenerName());
    }

    public KafkaPrincipal brokerPrincipal() {
        return GroupAuthorizerIntegrationTest$.MODULE$.BrokerPrincipal();
    }

    public KafkaPrincipal clientPrincipal() {
        return GroupAuthorizerIntegrationTest$.MODULE$.ClientPrincipal();
    }

    @Override
    public Seq<Properties> kraftControllerConfigs(TestInfo testInfo) {
        Seq<Properties> controllerConfigs = super.kraftControllerConfigs(testInfo);
        controllerConfigs.foreach((Function1 & Serializable & scala.Serializable)properties -> {
            this.addNodeProperties(properties);
            return BoxedUnit.UNIT;
        });
        return controllerConfigs;
    }

    @Override
    public void brokerPropertyOverrides(Properties properties) {
        properties.put("broker.id", this.brokerId().toString());
        this.addNodeProperties(properties);
    }

    private void addNodeProperties(Properties properties) {
        if (this.isKRaftTest()) {
            properties.put("authorizer.class.name", StandardAuthorizer.class.getName());
            properties.put("super.users", GroupAuthorizerIntegrationTest$.MODULE$.BrokerPrincipal().toString());
        } else {
            properties.put("authorizer.class.name", AclAuthorizer.class.getName());
        }
        properties.put("offsets.topic.num.partitions", "1");
        properties.put("offsets.topic.replication.factor", "1");
        properties.put("transaction.state.log.num.partitions", "1");
        properties.put("transaction.state.log.replication.factor", "1");
        properties.put("transaction.state.log.min.isr", "1");
        properties.put("principal.builder.class", GroupPrincipalBuilder.class.getName());
    }

    @Override
    @BeforeEach
    public void setUp(TestInfo testInfo) {
        this.doSetup(testInfo, false);
        this.addAndVerifyAcls((Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{this.createAcl(AclOperation.CLUSTER_ACTION, AclPermissionType.ALLOW, GroupAuthorizerIntegrationTest$.MODULE$.BrokerPrincipal())}))), new ResourcePattern(ResourceType.CLUSTER, "kafka-cluster", PatternType.LITERAL));
        this.createOffsetsTopic(this.interBrokerListenerName(), this.createOffsetsTopic$default$2());
    }

    private AccessControlEntry createAcl(AclOperation aclOperation, AclPermissionType aclPermissionType, KafkaPrincipal principal) {
        return new AccessControlEntry(principal.toString(), "*", aclOperation, aclPermissionType);
    }

    private KafkaPrincipal createAcl$default$3() {
        return GroupAuthorizerIntegrationTest$.MODULE$.ClientPrincipal();
    }

    @ParameterizedTest
    @ValueSource(strings={"zk", "kraft"})
    public void testUnauthorizedProduceAndConsume(String quorum) {
        String topic = "topic";
        TopicPartition topicPartition = new TopicPartition("topic", 0);
        ListenerName x$2 = this.interBrokerListenerName();
        int x$3 = this.createTopic$default$2();
        int x$4 = this.createTopic$default$3();
        Properties x$5 = this.createTopic$default$4();
        Properties x$6 = this.createTopic$default$6();
        this.createTopic(topic, x$3, x$4, x$5, x$2, x$6);
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        Throwable produceException = Assertions.assertThrows(ExecutionException.class, () -> producer.send(new ProducerRecord(topic, (Object)"message".getBytes())).get()).getCause();
        Assertions.assertTrue((boolean)(produceException instanceof TopicAuthorizationException));
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{topic})), (Object)CollectionConverters$.MODULE$.asScalaSetConverter(((TopicAuthorizationException)produceException).unauthorizedTopics()).asScala());
        .colon.colon x$7 = new .colon.colon((Object)"group.id", (List)Nil$.MODULE$);
        ByteArrayDeserializer x$8 = this.createConsumer$default$1();
        ByteArrayDeserializer x$9 = this.createConsumer$default$2();
        Properties x$10 = this.createConsumer$default$3();
        Consumer consumer = this.createConsumer(x$8, x$9, x$10, (List<String>)x$7);
        consumer.assign((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)topicPartition, (List)Nil$.MODULE$)).asJava());
        TopicAuthorizationException consumeException = (TopicAuthorizationException)Assertions.assertThrows(TopicAuthorizationException.class, () -> TestUtils$.MODULE$.pollUntilAtLeastNumRecords(consumer, 1, TestUtils$.MODULE$.pollUntilAtLeastNumRecords$default$3()));
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{topic})), (Object)CollectionConverters$.MODULE$.asScalaSetConverter(consumeException.unauthorizedTopics()).asScala());
    }

    @ParameterizedTest
    @ValueSource(strings={"zk", "kraft"})
    public void testAuthorizedProduceAndConsume(String quorum) {
        String topic = "topic";
        TopicPartition topicPartition = new TopicPartition("topic", 0);
        ListenerName x$2 = this.interBrokerListenerName();
        int x$3 = this.createTopic$default$2();
        int x$4 = this.createTopic$default$3();
        Properties x$5 = this.createTopic$default$4();
        Properties x$6 = this.createTopic$default$6();
        this.createTopic(topic, x$3, x$4, x$5, x$2, x$6);
        this.addAndVerifyAcls((Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{this.createAcl(AclOperation.WRITE, AclPermissionType.ALLOW, this.createAcl$default$3())}))), new ResourcePattern(ResourceType.TOPIC, topic, PatternType.LITERAL));
        this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3()).send(new ProducerRecord(topic, (Object)"message".getBytes())).get();
        this.addAndVerifyAcls((Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{this.createAcl(AclOperation.READ, AclPermissionType.ALLOW, this.createAcl$default$3())}))), new ResourcePattern(ResourceType.TOPIC, topic, PatternType.LITERAL));
        .colon.colon x$7 = new .colon.colon((Object)"group.id", (List)Nil$.MODULE$);
        ByteArrayDeserializer x$8 = this.createConsumer$default$1();
        ByteArrayDeserializer x$9 = this.createConsumer$default$2();
        Properties x$10 = this.createConsumer$default$3();
        Consumer consumer = this.createConsumer(x$8, x$9, x$10, (List<String>)x$7);
        consumer.assign((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)topicPartition, (List)Nil$.MODULE$)).asJava());
        TestUtils$.MODULE$.pollUntilAtLeastNumRecords(consumer, 1, TestUtils$.MODULE$.pollUntilAtLeastNumRecords$default$3());
    }

    public static class GroupPrincipalBuilder
    extends DefaultKafkaPrincipalBuilder {
        public KafkaPrincipal build(AuthenticationContext context) {
            boolean bl;
            String string = context.listenerName();
            String string2 = GroupAuthorizerIntegrationTest$.MODULE$.BrokerListenerName();
            if (!(string2 != null ? !string2.equals(string) : string != null)) {
                bl = true;
            } else {
                String string3 = GroupAuthorizerIntegrationTest$.MODULE$.ControllerListenerName();
                bl = !(string3 != null ? !string3.equals(string) : string != null);
            }
            if (bl) {
                return GroupAuthorizerIntegrationTest$.MODULE$.BrokerPrincipal();
            }
            String string4 = GroupAuthorizerIntegrationTest$.MODULE$.ClientListenerName();
            if (!(string4 != null ? !string4.equals(string) : string != null)) {
                return GroupAuthorizerIntegrationTest$.MODULE$.ClientPrincipal();
            }
            throw new IllegalArgumentException(new StringBuilder(32).append("No principal mapped to listener ").append(string).toString());
        }

        public GroupPrincipalBuilder() {
            super(null, null);
        }
    }
}

