/*
 * Decompiled with CFR 0.152.
 */
package kafka.api;

import java.io.Serializable;
import java.time.Duration;
import java.util.Collection;
import java.util.HashMap;
import java.util.Properties;
import java.util.stream.Stream;
import kafka.api.AbstractConsumerTest;
import kafka.api.PlaintextConsumerPollTest$;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.consumer.ConsumerRebalanceListener;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.apache.kafka.clients.consumer.NoOffsetForPartitionException;
import org.apache.kafka.clients.consumer.OffsetAndMetadata;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.common.Metric;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.record.TimestampType;
import org.apache.kafka.common.serialization.ByteArrayDeserializer;
import org.apache.kafka.common.utils.Utils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Timeout;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Set;
import scala.collection.SetLike;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LongRef;
import scala.runtime.RichLong$;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

@Timeout(value=600L)
@ScalaSignature(bytes="\u0006\u0001\u0005ue\u0001\u0002\u000b\u0016\u0001iAQa\b\u0001\u0005\u0002\u0001BQA\t\u0001\u0005\u0002\rBQ\u0001\u0018\u0001\u0005\u0002uCQ!\u001a\u0001\u0005\u0002\u0019DQ\u0001\u001c\u0001\u0005\u00025DQa\u001d\u0001\u0005\u0002QDQA\u001f\u0001\u0005\u0002mDq!a\u0001\u0001\t\u0003\t)\u0001C\u0004\u0002\u0012\u0001!\t!a\u0005\t\u000f\u0005}\u0001\u0001\"\u0001\u0002\"!9\u0011Q\u0006\u0001\u0005\u0002\u0005=\u0002bBA\u001e\u0001\u0011\u0005\u0011Q\b\u0005\b\u0003\u0013\u0002A\u0011AA&\u0011\u001d\t9\u0006\u0001C\u0001\u00033:q!a\u001d\u0016\u0011\u0003\t)H\u0002\u0004\u0015+!\u0005\u0011q\u000f\u0005\u0007?A!\t!a \t\r-\u0003B\u0011AAA\u0011\u0019\u0019\u0007\u0003\"\u0001\u0002\u0002\nI\u0002\u000b\\1j]R,\u0007\u0010^\"p]N,X.\u001a:Q_2dG+Z:u\u0015\t1r#A\u0002ba&T\u0011\u0001G\u0001\u0006W\u000647.Y\u0002\u0001'\t\u00011\u0004\u0005\u0002\u001d;5\tQ#\u0003\u0002\u001f+\t!\u0012IY:ue\u0006\u001cGoQ8ogVlWM\u001d+fgR\fa\u0001P5oSRtD#A\u0011\u0011\u0005q\u0001\u0011!\n;fgR$U\r\u001d:fG\u0006$X\r\u001a)pY2\u0014En\\2lg\u001a{'/Q:tS\u001etW.\u001a8u)\r!#f\u000e\t\u0003K!j\u0011A\n\u0006\u0002O\u0005)1oY1mC&\u0011\u0011F\n\u0002\u0005+:LG\u000fC\u0003,\u0005\u0001\u0007A&\u0001\u0004rk>\u0014X/\u001c\t\u0003[Qr!A\f\u001a\u0011\u0005=2S\"\u0001\u0019\u000b\u0005EJ\u0012A\u0002\u001fs_>$h(\u0003\u00024M\u00051\u0001K]3eK\u001aL!!\u000e\u001c\u0003\rM#(/\u001b8h\u0015\t\u0019d\u0005C\u00039\u0005\u0001\u0007A&A\u0007he>,\b\u000f\u0015:pi>\u001cw\u000e\u001c\u0015\u0005\u0005iB\u0015\n\u0005\u0002<\r6\tAH\u0003\u0002>}\u0005A\u0001O]8wS\u0012,'O\u0003\u0002@\u0001\u00061\u0001/\u0019:b[NT!!\u0011\"\u0002\u000f),\b/\u001b;fe*\u00111\tR\u0001\u0006UVt\u0017\u000e\u001e\u0006\u0002\u000b\u0006\u0019qN]4\n\u0005\u001dc$\u0001D'fi\"|GmU8ve\u000e,\u0017!\u0002<bYV,G&\u0001&\"\u0003-\u000bqhZ3u)\u0016\u001cH/U;peVl\u0017I\u001c3He>,\b\u000f\u0015:pi>\u001cw\u000e\u001c)be\u0006lW\r^3sg\u000ec\u0017m]:jG\u001e\u0013x.\u001e9Qe>$xnY8m\u001f:d\u0017\u0010\u000b\u0003\u0003\u001bF\u0013\u0006C\u0001(P\u001b\u0005q\u0014B\u0001)?\u0005E\u0001\u0016M]1nKR,'/\u001b>fIR+7\u000f^\u0001\u0005]\u0006lW-I\u0001T\u0003)ZH-[:qY\u0006Lh*Y7f{:\nXo\u001c:v[vZ\b' \u0018he>,\b\u000f\u0015:pi>\u001cw\u000e\\\u001f|cuDCAA+Y5B\u0011QEV\u0005\u0003/\u001a\u0012!\u0002Z3qe\u0016\u001c\u0017\r^3eC\u0005I\u0016!\t9pY2DC)\u001e:bi&|g.\u000b\u0011jg\u0002\"\b.\u001a\u0011sKBd\u0017mY3nK:$\u0018%A.\u0002\u0007Ir\u0003'\u0001\nuKN$X*\u0019=Q_2d'+Z2pe\u0012\u001cHc\u0001\u0013_?\")1f\u0001a\u0001Y!)\u0001h\u0001a\u0001Y!\"1A\u000f%bY\u0005\u0011\u0017%A2\u0002U\u001d,G\u000fV3tiF+xN];n\u0003:$wI]8vaB\u0013x\u000e^8d_2\u0004\u0016M]1nKR,'o]!mY\"\"1!T)S\u0003U!Xm\u001d;NCb\u0004v\u000e\u001c7J]R,'O^1m\u001bN$2\u0001J4i\u0011\u0015YC\u00011\u0001-\u0011\u0015AD\u00011\u0001-Q\u0011!!\b\u00136-\u0003\tDC\u0001B'R%\u00061C/Z:u\u001b\u0006D\bk\u001c7m\u0013:$XM\u001d<bY6\u001bH)\u001a7bs&s'+\u001a<pG\u0006$\u0018n\u001c8\u0015\u0007\u0011rw\u000eC\u0003,\u000b\u0001\u0007A\u0006C\u00039\u000b\u0001\u0007A\u0006\u000b\u0003\u0006u!\u000bH&\u00012)\t\u0015i\u0015KU\u0001'i\u0016\u001cH/T1y!>dG.\u00138uKJ4\u0018\r\\'t\t\u0016d\u0017-_%o\u0003N\u001c\u0018n\u001a8nK:$Hc\u0001\u0013vm\")1F\u0002a\u0001Y!)\u0001H\u0002a\u0001Y!\"aA\u000f%yY\u0005\u0011\u0007\u0006\u0002\u0004N#J\u000b1\u0006^3ti6\u000b\u0007\u0010U8mY&sG/\u001a:wC2l5o\u00155peR,'\u000f\u00165b]B{G\u000e\u001c+j[\u0016|W\u000f\u001e\u000b\u0004Iql\b\"B\u0016\b\u0001\u0004a\u0003\"\u0002\u001d\b\u0001\u0004a\u0003\u0006B\u0004;\u0011~d\u0013A\u0019\u0015\u0005\u000f5\u000b&+\u0001\u0014uKN$\b+\u001a:QCJ$\u0018\u000e^5p]2+\u0017\rZ,ji\"l\u0015\r\u001f)pY2\u0014VmY8sIN$R\u0001JA\u0004\u0003\u0013AQa\u000b\u0005A\u00021BQ\u0001\u000f\u0005A\u00021BS\u0001\u0003\u001eI\u0003\u001ba\u0013A\u0019\u0015\u0005\u00115\u000b&+A\u0013uKN$\b+\u001a:QCJ$\u0018\u000e^5p]2\u000bwmV5uQ6\u000b\u0007\u0010U8mYJ+7m\u001c:egR)A%!\u0006\u0002\u0018!)1&\u0003a\u0001Y!)\u0001(\u0003a\u0001Y!*\u0011B\u000f%\u0002\u001c1\n!\r\u000b\u0003\n\u001bF\u0013\u0016\u0001\f;fgRlU\u000f\u001c;j\u0007>t7/^7feN+7o]5p]RKW.Z8vi>s7\u000b^8q!>dG.\u001b8h)\u0015!\u00131EA\u0013\u0011\u0015Y#\u00021\u0001-\u0011\u0015A$\u00021\u0001-Q\u0015Q!\bSA\u0015Y\u0005\u0011\u0007\u0006\u0002\u0006N#J\u000ba\u0005^3ti6+H\u000e^5D_:\u001cX/\\3s'\u0016\u001c8/[8o)&lWm\\;u\u001f:\u001cEn\\:f)\u0015!\u0013\u0011GA\u001a\u0011\u0015Y3\u00021\u0001-\u0011\u0015A4\u00021\u0001-Q\u0015Y!\bSA\u001cY\u0005\u0011\u0007\u0006B\u0006N#J\u000bq\u0006^3tiB{G\u000e\\#wK:$X/\u00197msJ+G/\u001e:ogJ+7m\u001c:eg^KG\u000f\u001b.fe>$\u0016.\\3pkR$R\u0001JA \u0003\u0003BQa\u000b\u0007A\u00021BQ\u0001\u000f\u0007A\u00021BS\u0001\u0004\u001eI\u0003\u000bb\u0013A\u0019\u0015\u0005\u00195\u000b&+A\u0016uKN$hj\\(gMN,GOR8s!\u0006\u0014H/\u001b;j_:,\u0005pY3qi&|gn\u00148Q_2d',\u001a:p)\u0015!\u0013QJA(\u0011\u0015YS\u00021\u0001-\u0011\u0015AT\u00021\u0001-Q\u0015i!\bSA*Y\u0005\u0011\u0007\u0006B\u0007N#J\u000b!E];o\u001bVdG/[\"p]N,X.\u001a:TKN\u001c\u0018n\u001c8US6,w.\u001e;UKN$Hc\u0001\u0013\u0002\\!9\u0011Q\f\bA\u0002\u0005}\u0013!D2m_N,7i\u001c8tk6,'\u000fE\u0002&\u0003CJ1!a\u0019'\u0005\u001d\u0011un\u001c7fC:Dc\u0001AA4\u0011\u0006E\u0004\u0003BA5\u0003[j!!a\u001b\u000b\u0005Y\u0001\u0015\u0002BA8\u0003W\u0012q\u0001V5nK>,HO\b\u0002\u00031\u0006I\u0002\u000b\\1j]R,\u0007\u0010^\"p]N,X.\u001a:Q_2dG+Z:u!\ta\u0002cE\u0002\u0011\u0003s\u00022!JA>\u0013\r\tiH\n\u0002\u0007\u0003:L(+\u001a4\u0015\u0005\u0005UTCAAB!\u0019\t))a%\u0002\u00186\u0011\u0011q\u0011\u0006\u0005\u0003\u0013\u000bY)\u0001\u0004tiJ,\u0017-\u001c\u0006\u0005\u0003\u001b\u000by)\u0001\u0003vi&d'BAAI\u0003\u0011Q\u0017M^1\n\t\u0005U\u0015q\u0011\u0002\u0007'R\u0014X-Y7\u0011\u0007m\nI*C\u0002\u0002\u001cr\u0012\u0011\"\u0011:hk6,g\u000e^:")
public class PlaintextConsumerPollTest
extends AbstractConsumerTest {
    public static Stream<Arguments> getTestQuorumAndGroupProtocolParametersAll() {
        return PlaintextConsumerPollTest$.MODULE$.getTestQuorumAndGroupProtocolParametersAll();
    }

    public static Stream<Arguments> getTestQuorumAndGroupProtocolParametersClassicGroupProtocolOnly() {
        return PlaintextConsumerPollTest$.MODULE$.getTestQuorumAndGroupProtocolParametersClassicGroupProtocolOnly();
    }

    @ParameterizedTest(name="{displayName}.quorum={0}.groupProtocol={1}")
    @MethodSource(value={"getTestQuorumAndGroupProtocolParametersClassicGroupProtocolOnly"})
    public void testDeprecatedPollBlocksForAssignment(String quorum, String groupProtocol) {
        Consumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        consumer.subscribe((Collection)CollectionConverters$.MODULE$.setAsJavaSetConverter((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.topic()}))).asJava());
        consumer.poll(0L);
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp(), this.tp2()})), (Object)CollectionConverters$.MODULE$.asScalaSetConverter(consumer.assignment()).asScala());
    }

    @ParameterizedTest(name="{displayName}.quorum={0}.groupProtocol={1}")
    @MethodSource(value={"getTestQuorumAndGroupProtocolParametersAll"})
    public void testMaxPollRecords(String quorum, String groupProtocol) {
        int maxPollRecords = 2;
        int numRecords = 10000;
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        long startingTimestamp = System.currentTimeMillis();
        this.sendRecords(producer, numRecords, this.tp(), startingTimestamp);
        this.consumerConfig().setProperty("max.poll.records", Integer.toString(maxPollRecords));
        Consumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        consumer.assign((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)this.tp(), (List)Nil$.MODULE$)).asJava());
        int x$3 = 0;
        int x$6 = this.consumeAndVerifyRecords$default$4();
        TimestampType x$7 = this.consumeAndVerifyRecords$default$6();
        TopicPartition x$8 = this.consumeAndVerifyRecords$default$7();
        this.consumeAndVerifyRecords(consumer, numRecords, x$3, x$6, startingTimestamp, x$7, x$8, maxPollRecords);
    }

    @ParameterizedTest(name="{displayName}.quorum={0}.groupProtocol={1}")
    @MethodSource(value={"getTestQuorumAndGroupProtocolParametersAll"})
    public void testMaxPollIntervalMs(String quorum, String groupProtocol) {
        this.consumerConfig().setProperty("max.poll.interval.ms", Integer.toString(1000));
        this.consumerConfig().setProperty("heartbeat.interval.ms", Integer.toString(500));
        this.consumerConfig().setProperty("session.timeout.ms", Integer.toString(2000));
        Consumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        AbstractConsumerTest.TestConsumerReassignmentListener listener = new AbstractConsumerTest.TestConsumerReassignmentListener(this);
        consumer.subscribe((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)this.topic(), (List)Nil$.MODULE$)).asJava(), (ConsumerRebalanceListener)listener);
        this.awaitRebalance(consumer, listener);
        Assertions.assertEquals((int)1, (int)listener.callsToAssigned());
        Assertions.assertEquals((int)0, (int)listener.callsToRevoked());
        Thread.sleep(3000L);
        this.awaitRebalance(consumer, listener);
        Assertions.assertEquals((int)2, (int)listener.callsToAssigned());
        Assertions.assertEquals((int)1, (int)listener.callsToRevoked());
    }

    @ParameterizedTest(name="{displayName}.quorum={0}.groupProtocol={1}")
    @MethodSource(value={"getTestQuorumAndGroupProtocolParametersAll"})
    public void testMaxPollIntervalMsDelayInRevocation(String quorum, String groupProtocol) {
        this.consumerConfig().setProperty("max.poll.interval.ms", Integer.toString(5000));
        this.consumerConfig().setProperty("heartbeat.interval.ms", Integer.toString(500));
        this.consumerConfig().setProperty("session.timeout.ms", Integer.toString(1000));
        this.consumerConfig().setProperty("enable.auto.commit", Boolean.toString(false));
        Consumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        BooleanRef commitCompleted = BooleanRef.create((boolean)false);
        LongRef committedPosition = LongRef.create((long)-1L);
        AbstractConsumerTest.TestConsumerReassignmentListener listener = new AbstractConsumerTest.TestConsumerReassignmentListener(this, committedPosition, consumer, commitCompleted){
            private final /* synthetic */ PlaintextConsumerPollTest $outer;
            private final LongRef committedPosition$1;
            private final Consumer consumer$1;
            private final BooleanRef commitCompleted$1;

            public void onPartitionsLost(Collection<TopicPartition> partitions) {
            }

            public void onPartitionsRevoked(Collection<TopicPartition> partitions) {
                if (!partitions.isEmpty() && partitions.contains(this.$outer.tp())) {
                    Utils.sleep((long)1500L);
                    this.committedPosition$1.elem = this.consumer$1.position(this.$outer.tp());
                    this.consumer$1.commitSync((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.$outer.tp()), (Object)new OffsetAndMetadata(this.committedPosition$1.elem))}))).asJava());
                    this.commitCompleted$1.elem = true;
                }
                super.onPartitionsRevoked(partitions);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.committedPosition$1 = committedPosition$1;
                this.consumer$1 = consumer$1;
                this.commitCompleted$1 = commitCompleted$1;
                super($outer);
            }
        };
        consumer.subscribe((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)this.topic(), (List)Nil$.MODULE$)).asJava(), (ConsumerRebalanceListener)listener);
        this.awaitRebalance(consumer, listener);
        consumer.subscribe((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)"otherTopic", (List)Nil$.MODULE$)).asJava(), (ConsumerRebalanceListener)listener);
        this.awaitRebalance(consumer, listener);
        Assertions.assertEquals((long)0L, (long)committedPosition.elem);
        Assertions.assertTrue((boolean)commitCompleted.elem);
    }

    @ParameterizedTest(name="{displayName}.quorum={0}.groupProtocol={1}")
    @MethodSource(value={"getTestQuorumAndGroupProtocolParametersAll"})
    public void testMaxPollIntervalMsDelayInAssignment(String quorum, String groupProtocol) {
        this.consumerConfig().setProperty("max.poll.interval.ms", Integer.toString(5000));
        this.consumerConfig().setProperty("heartbeat.interval.ms", Integer.toString(500));
        this.consumerConfig().setProperty("session.timeout.ms", Integer.toString(1000));
        this.consumerConfig().setProperty("enable.auto.commit", Boolean.toString(false));
        Consumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        AbstractConsumerTest.TestConsumerReassignmentListener listener = new AbstractConsumerTest.TestConsumerReassignmentListener(this){

            public void onPartitionsAssigned(Collection<TopicPartition> partitions) {
                Utils.sleep((long)1500L);
                super.onPartitionsAssigned(partitions);
            }
        };
        consumer.subscribe((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)this.topic(), (List)Nil$.MODULE$)).asJava(), (ConsumerRebalanceListener)listener);
        this.awaitRebalance(consumer, listener);
        this.ensureNoRebalance(consumer, listener);
    }

    @ParameterizedTest(name="{displayName}.quorum={0}.groupProtocol={1}")
    @MethodSource(value={"getTestQuorumAndGroupProtocolParametersAll"})
    public void testMaxPollIntervalMsShorterThanPollTimeout(String quorum, String groupProtocol) {
        this.consumerConfig().setProperty("max.poll.interval.ms", Integer.toString(1000));
        this.consumerConfig().setProperty("heartbeat.interval.ms", Integer.toString(500));
        Consumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        AbstractConsumerTest.TestConsumerReassignmentListener listener = new AbstractConsumerTest.TestConsumerReassignmentListener(this);
        consumer.subscribe((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)this.topic(), (List)Nil$.MODULE$)).asJava(), (ConsumerRebalanceListener)listener);
        this.awaitRebalance(consumer, listener);
        int callsToAssignedAfterFirstRebalance = listener.callsToAssigned();
        consumer.poll(Duration.ofMillis(2000L));
        consumer.poll(Duration.ofMillis(500L));
        consumer.poll(Duration.ofMillis(500L));
        Assertions.assertEquals((int)callsToAssignedAfterFirstRebalance, (int)listener.callsToAssigned());
    }

    @ParameterizedTest(name="{displayName}.quorum={0}.groupProtocol={1}")
    @MethodSource(value={"getTestQuorumAndGroupProtocolParametersAll"})
    public void testPerPartitionLeadWithMaxPollRecords(String quorum, String groupProtocol) {
        int numMessages = 1000;
        int maxPollRecords = 10;
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        this.sendRecords(producer, numMessages, this.tp(), this.sendRecords$default$4());
        this.consumerConfig().setProperty("group.id", "testPerPartitionLeadWithMaxPollRecords");
        this.consumerConfig().setProperty("client.id", "testPerPartitionLeadWithMaxPollRecords");
        this.consumerConfig().setProperty("max.poll.records", Integer.toString(maxPollRecords));
        Consumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        consumer.assign((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)this.tp(), (List)Nil$.MODULE$)).asJava());
        this.awaitNonEmptyRecords(consumer, this.tp(), this.awaitNonEmptyRecords$default$3());
        HashMap<String, String> tags = new HashMap<String, String>();
        tags.put("client-id", "testPerPartitionLeadWithMaxPollRecords");
        tags.put("topic", this.tp().topic());
        tags.put("partition", String.valueOf(this.tp().partition()));
        Metric lead = (Metric)consumer.metrics().get(new MetricName("records-lead", "consumer-fetch-manager-metrics", "", tags));
        Assertions.assertEquals((double)maxPollRecords, (double)BoxesRunTime.unboxToDouble((Object)lead.metricValue()), (String)new StringBuilder(19).append("The lead should be ").append(maxPollRecords).toString());
    }

    @ParameterizedTest(name="{displayName}.quorum={0}.groupProtocol={1}")
    @MethodSource(value={"getTestQuorumAndGroupProtocolParametersAll"})
    public void testPerPartitionLagWithMaxPollRecords(String quorum, String groupProtocol) {
        int numMessages = 1000;
        int maxPollRecords = 10;
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        this.sendRecords(producer, numMessages, this.tp(), this.sendRecords$default$4());
        this.consumerConfig().setProperty("group.id", "testPerPartitionLagWithMaxPollRecords");
        this.consumerConfig().setProperty("client.id", "testPerPartitionLagWithMaxPollRecords");
        this.consumerConfig().setProperty("max.poll.records", Integer.toString(maxPollRecords));
        Consumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        consumer.assign((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)this.tp(), (List)Nil$.MODULE$)).asJava());
        ConsumerRecords records = this.awaitNonEmptyRecords(consumer, this.tp(), this.awaitNonEmptyRecords$default$3());
        HashMap<String, String> tags = new HashMap<String, String>();
        tags.put("client-id", "testPerPartitionLagWithMaxPollRecords");
        tags.put("topic", this.tp().topic());
        tags.put("partition", String.valueOf(this.tp().partition()));
        Metric lag = (Metric)consumer.metrics().get(new MetricName("records-lag", "consumer-fetch-manager-metrics", "", tags));
        Assertions.assertEquals((double)(numMessages - records.count()), (double)BoxesRunTime.unboxToDouble((Object)lag.metricValue()), (double)this.epsilon(), (String)new StringBuilder(18).append("The lag should be ").append(numMessages - records.count()).toString());
    }

    @ParameterizedTest(name="{displayName}.quorum={0}.groupProtocol={1}")
    @MethodSource(value={"getTestQuorumAndGroupProtocolParametersAll"})
    public void testMultiConsumerSessionTimeoutOnStopPolling(String quorum, String groupProtocol) {
        this.runMultiConsumerSessionTimeoutTest(false);
    }

    @ParameterizedTest(name="{displayName}.quorum={0}.groupProtocol={1}")
    @MethodSource(value={"getTestQuorumAndGroupProtocolParametersAll"})
    public void testMultiConsumerSessionTimeoutOnClose(String quorum, String groupProtocol) {
        this.runMultiConsumerSessionTimeoutTest(true);
    }

    @ParameterizedTest(name="{displayName}.quorum={0}.groupProtocol={1}")
    @MethodSource(value={"getTestQuorumAndGroupProtocolParametersAll"})
    public void testPollEventuallyReturnsRecordsWithZeroTimeout(String quorum, String groupProtocol) {
        int numMessages = 100;
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        this.sendRecords(producer, numMessages, this.tp(), this.sendRecords$default$4());
        Consumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        consumer.subscribe((Collection)CollectionConverters$.MODULE$.setAsJavaSetConverter((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.topic()}))).asJava());
        ConsumerRecords records = this.awaitNonEmptyRecords(consumer, this.tp(), 0L);
        Assertions.assertEquals((int)numMessages, (int)records.count());
    }

    /*
     * WARNING - void declaration
     */
    @ParameterizedTest(name="{displayName}.quorum={0}.groupProtocol={1}")
    @MethodSource(value={"getTestQuorumAndGroupProtocolParametersAll"})
    public void testNoOffsetForPartitionExceptionOnPollZero(String quorum, String groupProtocol) {
        void var14_14;
        Tuple2 tuple2;
        this.consumerConfig().setProperty("auto.offset.reset", "none");
        Properties x$1 = this.consumerConfig();
        ByteArrayDeserializer x$2 = this.createConsumer$default$1();
        ByteArrayDeserializer x$3 = this.createConsumer$default$2();
        List<String> x$4 = this.createConsumer$default$4();
        Consumer consumer = this.createConsumer(x$2, x$3, x$1, x$4);
        consumer.assign((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)this.tp(), (List)Nil$.MODULE$)).asJava());
        Function0 & Serializable & scala.Serializable intersect = (Function0 & Serializable & scala.Serializable)() -> (NoOffsetForPartitionException)Assertions.assertThrows(NoOffsetForPartitionException.class, () -> consumer.poll(Duration.ZERO));
        long l = TestUtils$.MODULE$.tryUntilNoAssertionError$default$2();
        long l2 = TestUtils$.MODULE$.tryUntilNoAssertionError$default$1();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long tryUntilNoAssertionError_computeUntilTrue_startTime = System.currentTimeMillis();
        while (true) {
            void tryUntilNoAssertionError_pause;
            void tryUntilNoAssertionError_waitTime;
            void tryUntilNoAssertionError_assertions;
            Either tryUntilNoAssertionError_computeUntilTrue_result;
            if (TestUtils$.$anonfun$tryUntilNoAssertionError$2(tryUntilNoAssertionError_computeUntilTrue_result = TestUtils$.$anonfun$tryUntilNoAssertionError$1((Function0)tryUntilNoAssertionError_assertions))) {
                tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tryUntilNoAssertionError_computeUntilTrue_result), (Object)BoxesRunTime.boxToBoolean((boolean)true));
                break;
            }
            if (System.currentTimeMillis() > tryUntilNoAssertionError_computeUntilTrue_startTime + tryUntilNoAssertionError_waitTime) {
                tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tryUntilNoAssertionError_computeUntilTrue_result), (Object)BoxesRunTime.boxToBoolean((boolean)false));
                break;
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)tryUntilNoAssertionError_waitTime), (long)tryUntilNoAssertionError_pause));
        }
        Tuple2 tuple22 = tuple2;
        if (tuple22 == null) {
            throw new MatchError(null);
        }
        Either tryUntilNoAssertionError_either = (Either)tuple22._1();
        if (var14_14 instanceof Left) {
            ((Left)var14_14).value();
            return;
        }
        if (var14_14 instanceof Right) {
            throw (AssertionError)((Right)var14_14).value();
        }
        throw new MatchError((Object)var14_14);
    }

    public void runMultiConsumerSessionTimeoutTest(boolean closeConsumer) {
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        this.sendRecords(producer, 100, this.tp(), this.sendRecords$default$4());
        this.sendRecords(producer, 100, this.tp2(), this.sendRecords$default$4());
        String topic1 = "topic1";
        scala.collection.immutable.Set subscriptions = (scala.collection.immutable.Set)((SetLike)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp(), this.tp2()}))).$plus$plus(this.createTopicAndSendRecords(producer, topic1, 6, 100));
        Buffer consumerPollers = (Buffer)Buffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        consumerPollers.$plus$eq((Object)this.subscribeConsumerAndStartPolling(this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4()), (List<String>)new .colon.colon((Object)this.topic(), (List)new .colon.colon((Object)topic1, (List)Nil$.MODULE$)), this.subscribeConsumerAndStartPolling$default$3()));
        consumerPollers.$plus$eq((Object)this.subscribeConsumerAndStartPolling(this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4()), (List<String>)new .colon.colon((Object)this.topic(), (List)new .colon.colon((Object)topic1, (List)Nil$.MODULE$)), this.subscribeConsumerAndStartPolling$default$3()));
        Consumer timeoutConsumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        AbstractConsumerTest.ConsumerAssignmentPoller timeoutPoller = this.subscribeConsumerAndStartPolling(timeoutConsumer, (List<String>)new .colon.colon((Object)this.topic(), (List)new .colon.colon((Object)topic1, (List)Nil$.MODULE$)), this.subscribeConsumerAndStartPolling$default$3());
        consumerPollers.$plus$eq((Object)timeoutPoller);
        this.validateGroupAssignment((Buffer<AbstractConsumerTest.ConsumerAssignmentPoller>)consumerPollers, (scala.collection.immutable.Set<TopicPartition>)subscriptions, this.validateGroupAssignment$default$3(), this.validateGroupAssignment$default$4(), this.validateGroupAssignment$default$5());
        timeoutPoller.shutdown();
        consumerPollers.$minus$eq((Object)timeoutPoller);
        if (closeConsumer) {
            timeoutConsumer.close();
        }
        this.validateGroupAssignment((Buffer<AbstractConsumerTest.ConsumerAssignmentPoller>)consumerPollers, (scala.collection.immutable.Set<TopicPartition>)subscriptions, (Option<String>)new Some((Object)new StringBuilder(68).append("Did not get valid assignment for partitions ").append(CollectionConverters$.MODULE$.setAsJavaSetConverter((Set)subscriptions).asJava()).append(" after one consumer left").toString()), 3L * this.groupMaxSessionTimeoutMs(), this.validateGroupAssignment$default$5());
        consumerPollers.foreach((Function1 & Serializable & scala.Serializable)poller -> {
            poller.shutdown();
            return BoxedUnit.UNIT;
        });
    }
}

