/*
 * Decompiled with CFR 0.152.
 */
package kafka.api;

import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Optional;
import kafka.api.IntegrationTestHarness;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.admin.NewPartitionReassignment;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.clients.producer.RecordMetadata;
import org.apache.kafka.common.TopicPartition;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;
import scala.Function1;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u000113Aa\u0002\u0005\u0001\u001b!)!\u0003\u0001C\u0001'!9Q\u0003\u0001b\u0001\n\u00031\u0002BB\u000f\u0001A\u0003%q\u0003C\u0004\u001f\u0001\t\u0007I\u0011\u0001\f\t\r}\u0001\u0001\u0015!\u0003\u0018\u0011\u0015\u0001\u0003\u0001\"\u0001\"\u0005u\u0001&o\u001c3vG\u0016\u00148+\u001a8e/\"LG.\u001a#fY\u0016$\u0018n\u001c8UKN$(BA\u0005\u000b\u0003\r\t\u0007/\u001b\u0006\u0002\u0017\u0005)1.\u00194lC\u000e\u00011C\u0001\u0001\u000f!\ty\u0001#D\u0001\t\u0013\t\t\u0002B\u0001\fJ]R,wM]1uS>tG+Z:u\u0011\u0006\u0014h.Z:t\u0003\u0019a\u0014N\\5u}Q\tA\u0003\u0005\u0002\u0010\u0001\u0005i\u0001O]8ek\u000e,'oQ8v]R,\u0012a\u0006\t\u00031mi\u0011!\u0007\u0006\u00025\u0005)1oY1mC&\u0011A$\u0007\u0002\u0004\u0013:$\u0018A\u00049s_\u0012,8-\u001a:D_VtG\u000fI\u0001\fEJ|7.\u001a:D_VtG/\u0001\u0007ce>\\WM]\"pk:$\b%A\u0010uKN$8+\u001a8e/&$\b\u000eV8qS\u000e$U\r\\3uS>tW*\u001b3XCf$\"AI\u0013\u0011\u0005a\u0019\u0013B\u0001\u0013\u001a\u0005\u0011)f.\u001b;\t\u000b\u00192\u0001\u0019A\u0014\u0002\rE,xN];n!\tAsF\u0004\u0002*[A\u0011!&G\u0007\u0002W)\u0011A\u0006D\u0001\u0007yI|w\u000e\u001e \n\u00059J\u0012A\u0002)sK\u0012,g-\u0003\u00021c\t11\u000b\u001e:j]\u001eT!AL\r)\t\u0019\u0019\u0014I\u0011\t\u0003i}j\u0011!\u000e\u0006\u0003m]\n\u0001\u0002\u001d:pm&$WM\u001d\u0006\u0003qe\na\u0001]1sC6\u001c(B\u0001\u001e<\u0003\u001dQW\u000f]5uKJT!\u0001P\u001f\u0002\u000b),h.\u001b;\u000b\u0003y\n1a\u001c:h\u0013\t\u0001UGA\u0006WC2,XmU8ve\u000e,\u0017aB:ue&twm\u001d\u0017\u0003\u0007\u0016\u000b\u0013\u0001R\u0001\u0003u.\f\u0013AR\u0001\u0006WJ\fg\r\u001e\u0015\u0003\r!\u0003\"!\u0013&\u000e\u0003]J!aS\u001c\u0003#A\u000b'/Y7fi\u0016\u0014\u0018N_3e)\u0016\u001cH\u000f")
public class ProducerSendWhileDeletionTest
extends IntegrationTestHarness {
    private final int producerCount;
    private final int brokerCount;

    public int producerCount() {
        return this.producerCount;
    }

    @Override
    public int brokerCount() {
        return this.brokerCount;
    }

    @ParameterizedTest
    @ValueSource(strings={"zk", "kraft"})
    public void testSendWithTopicDeletionMidWay(String quorum) {
        int numRecords = 10;
        String topic = "topic";
        this.createTopicWithAssignment(topic, (Map<Object, Seq<Object>>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1})))}))), this.createTopicWithAssignment$default$3());
        scala.collection.immutable.Map reassignment = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition(topic, 0)), Optional.of(new NewPartitionReassignment(Arrays.asList((Object[])new Integer[]{Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(0)})))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition(topic, 1)), Optional.of(new NewPartitionReassignment(Arrays.asList((Object[])new Integer[]{Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(0)}))))}));
        this.createAdminClient(this.createAdminClient$default$1(), this.createAdminClient$default$2()).alterPartitionReassignments((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)reassignment).asJava()).all().get();
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), numRecords).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
            RecordMetadata resp = (RecordMetadata)producer.send(new ProducerRecord(topic, null, (Object)new StringBuilder(5).append("value").append(i).toString().getBytes(StandardCharsets.UTF_8))).get();
            Assertions.assertEquals((Object)topic, (Object)resp.topic());
        });
        this.deleteTopic(topic, this.listenerName());
        TestUtils$.MODULE$.verifyTopicDeletion(this.zkClientOrNull(), topic, 2, this.brokers());
        Assertions.assertEquals((Object)topic, (Object)((RecordMetadata)producer.send(new ProducerRecord(topic, null, (Object)"value".getBytes(StandardCharsets.UTF_8))).get()).topic());
    }

    public ProducerSendWhileDeletionTest() {
        this.producerCount = 1;
        this.brokerCount = 2;
        this.serverConfig().put("num.partitions", Integer.toString(2));
        this.serverConfig().put("default.replication.factor", Integer.toString(2));
        this.serverConfig().put("auto.leader.rebalance.enable", Boolean.toString(false));
        this.producerConfig().put("max.block.ms", Long.toString(5000L));
        this.producerConfig().put("request.timeout.ms", Integer.toString(10000));
        this.producerConfig().put("delivery.timeout.ms", Integer.toString(10000));
    }
}

