/*
 * Decompiled with CFR 0.152.
 */
package kafka.api;

import java.io.File;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import kafka.api.IntegrationTestHarness;
import kafka.log.LogManager;
import kafka.log.UnifiedLog;
import kafka.server.KafkaBroker;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.consumer.ConsumerGroupMetadata;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.OffsetAndMetadata;
import org.apache.kafka.clients.consumer.OffsetAndTimestamp;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.clients.producer.RecordMetadata;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.InvalidProducerEpochException;
import org.apache.kafka.common.errors.ProducerFencedException;
import org.apache.kafka.common.errors.TimeoutException;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.serialization.ByteArrayDeserializer;
import org.apache.kafka.server.config.ReplicationConfigs;
import org.apache.kafka.server.config.ServerLogConfigs;
import org.apache.kafka.storage.internals.log.ProducerStateEntry;
import org.apache.kafka.test.TestUtils;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.TestInfo;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;
import scala.Function0;
import scala.Function1;
import scala.Function3;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Set;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.RichInt$;
import scala.runtime.RichLong$;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\ruf\u0001B A\u0001\u0015CQA\u0013\u0001\u0005\u0002-CQ!\u0014\u0001\u0005B9Cq!\u0016\u0001C\u0002\u0013\u0005a\n\u0003\u0004W\u0001\u0001\u0006Ia\u0014\u0005\b/\u0002\u0011\r\u0011\"\u0001O\u0011\u0019A\u0006\u0001)A\u0005\u001f\"9\u0011\f\u0001b\u0001\n\u0003q\u0005B\u0002.\u0001A\u0003%q\nC\u0004\\\u0001\t\u0007I\u0011\u0001/\t\r\u0015\u0004\u0001\u0015!\u0003^\u0011\u001d1\u0007A1A\u0005\u0002qCaa\u001a\u0001!\u0002\u0013i\u0006b\u00025\u0001\u0005\u0004%\tA\u0014\u0005\u0007S\u0002\u0001\u000b\u0011B(\t\u000f)\u0004!\u0019!C\u0001W\"9\u0011q\u0002\u0001!\u0002\u0013a\u0007\"CA\t\u0001\t\u0007I\u0011AA\n\u0011!\t\u0019\u0003\u0001Q\u0001\n\u0005U\u0001\"CA\u0013\u0001\t\u0007I\u0011AA\n\u0011!\t9\u0003\u0001Q\u0001\n\u0005U\u0001bBA\u0015\u0001\u0011\u0005\u00111\u0006\u0005\b\u0003s\u0001A\u0011KA\u001e\u0011\u001d\ty\u0005\u0001C)\u0003#Bq!!\u001b\u0001\t\u0003\tY\u0003C\u0004\u0002l\u0001!\t%!\u001c\t\u000f\u0005e\u0004\u0001\"\u0011\u0002|!9\u0011Q\u0011\u0001\u0005\u0002\u0005\u001d\u0005bBAg\u0001\u0011\u0005\u0011q\u001a\u0005\b\u00033\u0004A\u0011AAn\u0011\u001d\t)\u000f\u0001C\u0001\u0003ODq!!=\u0001\t\u0003\t\u0019\u0010C\u0004\u0002~\u0002!I!a@\t\u000f\t-\u0001\u0001\"\u0001\u0003\u000e!9!q\u0003\u0001\u0005\u0002\te\u0001b\u0002B\u0012\u0001\u0011\u0005!Q\u0005\u0005\b\u0005_\u0001A\u0011\u0001B\u0019\u0011\u001d\u0011Y\u0004\u0001C\u0001\u0005{AqAa\u0012\u0001\t\u0003\u0011I\u0005C\u0004\u0003T\u0001!\tA!\u0016\t\u000f\t}\u0003\u0001\"\u0003\u0003b!9!q\u000f\u0001\u0005\u0002\te\u0004b\u0002BB\u0001\u0011\u0005!Q\u0011\u0005\b\u0005\u001f\u0003A\u0011\u0001BI\u0011\u001d\u0011Y\n\u0001C\u0001\u0005;CqAa*\u0001\t\u0003\u0011I\u000bC\u0004\u00034\u0002!\tA!.\t\u000f\t}\u0006\u0001\"\u0001\u0003B\"9!1\u001a\u0001\u0005\n\t5\u0007b\u0002Bq\u0001\u0011%!1\u001d\u0005\n\u0005_\u0004\u0011\u0013!C\u0005\u0005cD\u0011ba\u0002\u0001#\u0003%Ia!\u0003\t\u0013\r5\u0001!%A\u0005\n\r=\u0001bBB\n\u0001\u0011%1Q\u0003\u0005\b\u00073\u0001A\u0011BB\u000e\u0011%\u00199\u0004AI\u0001\n\u0013\u0019I\u0004C\u0005\u0004>\u0001\t\n\u0011\"\u0003\u0004:!I1q\b\u0001\u0012\u0002\u0013%1\u0011\u0002\u0005\n\u0007\u0003\u0002\u0011\u0013!C\u0005\u0007\u0013Aqaa\u0011\u0001\t\u0003\u0019)\u0005C\u0004\u0004Z\u0001!\taa\u0017\t\u000f\r\u001d\u0004\u0001\"\u0003\u0004j!91Q\u0013\u0001\u0005\u0002\r]%\u0001\u0005+sC:\u001c\u0018m\u0019;j_:\u001cH+Z:u\u0015\t\t%)A\u0002ba&T\u0011aQ\u0001\u0006W\u000647.Y\u0002\u0001'\t\u0001a\t\u0005\u0002H\u00116\t\u0001)\u0003\u0002J\u0001\n1\u0012J\u001c;fOJ\fG/[8o)\u0016\u001cH\u000fS1s]\u0016\u001c8/\u0001\u0004=S:LGO\u0010\u000b\u0002\u0019B\u0011q\tA\u0001\fEJ|7.\u001a:D_VtG/F\u0001P!\t\u00016+D\u0001R\u0015\u0005\u0011\u0016!B:dC2\f\u0017B\u0001+R\u0005\rIe\u000e^\u0001\u001biJ\fgn]1di&|g.\u00197Qe>$WoY3s\u0007>,h\u000e^\u0001\u001ciJ\fgn]1di&|g.\u00197Qe>$WoY3s\u0007>,h\u000e\u001e\u0011\u00025Q\u0014\u0018M\\:bGRLwN\\1m\u0007>t7/^7fe\u000e{WO\u001c;\u00027Q\u0014\u0018M\\:bGRLwN\\1m\u0007>t7/^7fe\u000e{WO\u001c;!\u0003uqwN\u001c+sC:\u001c\u0018m\u0019;j_:\fGnQ8ogVlWM]\"pk:$\u0018A\b8p]R\u0013\u0018M\\:bGRLwN\\1m\u0007>t7/^7fe\u000e{WO\u001c;!\u0003\u0019!x\u000e]5dcU\tQ\f\u0005\u0002_G6\tqL\u0003\u0002aC\u0006!A.\u00198h\u0015\u0005\u0011\u0017\u0001\u00026bm\u0006L!\u0001Z0\u0003\rM#(/\u001b8h\u0003\u001d!x\u000e]5dc\u0001\na\u0001^8qS\u000e\u0014\u0014a\u0002;pa&\u001c'\u0007I\u0001\u000e]Vl\u0007+\u0019:uSRLwN\\:\u0002\u001d9,X\u000eU1si&$\u0018n\u001c8tA\u00051BO]1og\u0006\u001cG/[8oC2\u0004&o\u001c3vG\u0016\u00148/F\u0001m!\ri'\u000f^\u0007\u0002]*\u0011q\u000e]\u0001\b[V$\u0018M\u00197f\u0015\t\t\u0018+\u0001\u0006d_2dWm\u0019;j_:L!a\u001d8\u0003\r\t+hMZ3s!\u0019)x0a\u0001\u0002\u00045\taO\u0003\u0002xq\u0006A\u0001O]8ek\u000e,'O\u0003\u0002zu\u000691\r\\5f]R\u001c(BA\"|\u0015\taX0\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002}\u0006\u0019qN]4\n\u0007\u0005\u0005aOA\u0007LC\u001a\\\u0017\r\u0015:pIV\u001cWM\u001d\t\u0006!\u0006\u0015\u0011\u0011B\u0005\u0004\u0003\u000f\t&!B!se\u0006L\bc\u0001)\u0002\f%\u0019\u0011QB)\u0003\t\tKH/Z\u0001\u0018iJ\fgn]1di&|g.\u00197Qe>$WoY3sg\u0002\na\u0003\u001e:b]N\f7\r^5p]\u0006d7i\u001c8tk6,'o]\u000b\u0003\u0003+\u0001B!\u001c:\u0002\u0018AA\u0011\u0011DA\u0010\u0003\u0007\t\u0019!\u0004\u0002\u0002\u001c)\u0019\u0011Q\u0004=\u0002\u0011\r|gn];nKJLA!!\t\u0002\u001c\tA1i\u001c8tk6,'/A\fue\u0006t7/Y2uS>t\u0017\r\\\"p]N,X.\u001a:tA\u0005Ibn\u001c8Ue\u0006t7/Y2uS>t\u0017\r\\\"p]N,X.\u001a:t\u0003iqwN\u001c+sC:\u001c\u0018m\u0019;j_:\fGnQ8ogVlWM]:!\u0003=yg/\u001a:sS\u0012Lgn\u001a)s_B\u001cHCAA\u0017!\u0011\ty#!\u000e\u000e\u0005\u0005E\"bAA\u001aC\u0006!Q\u000f^5m\u0013\u0011\t9$!\r\u0003\u0015A\u0013x\u000e]3si&,7/A\u0007n_\u0012Lg-_\"p]\u001aLwm\u001d\u000b\u0005\u0003{\t\u0019\u0005E\u0002Q\u0003\u007fI1!!\u0011R\u0005\u0011)f.\u001b;\t\u000f\u0005\u0015c\u00031\u0001\u0002H\u0005)\u0001O]8qgB1\u0011\u0011JA&\u0003[i\u0011\u0001]\u0005\u0004\u0003\u001b\u0002(aA*fc\u000612N]1gi\u000e{g\u000e\u001e:pY2,'oQ8oM&<7\u000f\u0006\u0003\u0002H\u0005M\u0003bBA+/\u0001\u0007\u0011qK\u0001\ti\u0016\u001cH/\u00138g_B!\u0011\u0011LA3\u001b\t\tYFC\u0002B\u0003;RA!a\u0018\u0002b\u00059!.\u001e9ji\u0016\u0014(bAA2{\u0006)!.\u001e8ji&!\u0011qMA.\u0005!!Vm\u001d;J]\u001a|\u0017a\u0003;pa&\u001c7i\u001c8gS\u001e\fQa]3u+B$B!!\u0010\u0002p!9\u0011QK\rA\u0002\u0005]\u0003fA\r\u0002tA!\u0011\u0011LA;\u0013\u0011\t9(a\u0017\u0003\u0015\t+gm\u001c:f\u000b\u0006\u001c\u0007.\u0001\u0005uK\u0006\u0014Hi\\<o)\t\ti\u0004K\u0002\u001b\u0003\u007f\u0002B!!\u0017\u0002\u0002&!\u00111QA.\u0005%\te\r^3s\u000b\u0006\u001c\u0007.A\u000buKN$()Y:jGR\u0013\u0018M\\:bGRLwN\\:\u0015\t\u0005u\u0012\u0011\u0012\u0005\b\u0003\u0017[\u0002\u0019AAG\u0003\u0019\tXo\u001c:v[B!\u0011qRAO\u001d\u0011\t\t*!'\u0011\u0007\u0005M\u0015+\u0004\u0002\u0002\u0016*\u0019\u0011q\u0013#\u0002\rq\u0012xn\u001c;?\u0013\r\tY*U\u0001\u0007!J,G-\u001a4\n\u0007\u0011\fyJC\u0002\u0002\u001cFCsaGAR\u0003g\u000b)\f\u0005\u0003\u0002&\u0006=VBAAT\u0015\u0011\tI+a+\u0002\u0011A\u0014xN^5eKJTA!!,\u0002^\u00051\u0001/\u0019:b[NLA!!-\u0002(\nYa+\u00197vKN{WO]2f\u0003\u001d\u0019HO]5oONdc!a.\u0002<\u0006}\u0016EAA]\u0003\tQ8.\t\u0002\u0002>\u0006)1N]1gi\u0006\u0012\u0011\u0011Y\u0001\rWJ\fg\r^\u0016lSBDD\u0007\u000f\u0015\u00047\u0005\u0015\u0007\u0003BAd\u0003\u0013l!!a+\n\t\u0005-\u00171\u0016\u0002\u0012!\u0006\u0014\u0018-\\3uKJL'0\u001a3UKN$\u0018A\r;fgR\u0014V-\u00193D_6l\u0017\u000e\u001e;fI\u000e{gn];nKJ\u001c\u0006n\\;mI:{GoU3f+:$WmY5eK\u0012$\u0015\r^1\u0015\t\u0005u\u0012\u0011\u001b\u0005\b\u0003\u0017c\u0002\u0019AAGQ\u001da\u00121UAZ\u0003+dc!a.\u0002<\u0006}\u0006f\u0001\u000f\u0002F\u0006QC/Z:u\t\u0016d\u0017-_3e\r\u0016$8\r[%oG2,H-Z:BE>\u0014H/\u001a3Ue\u0006t7/Y2uS>tG\u0003BA\u001f\u0003;Dq!a#\u001e\u0001\u0004\ti\tK\u0004\u001e\u0003G\u000b\u0019,!9-\r\u0005]\u00161XA`Q\ri\u0012QY\u0001\u001bi\u0016\u001cHoU3oI>3gm]3ug^KG\u000f[$s_V\u0004\u0018\n\u001a\u000b\u0005\u0003{\tI\u000fC\u0004\u0002\fz\u0001\r!!$)\u000fy\t\u0019+a-\u0002n22\u0011qWA^\u0003\u007fC3AHAc\u0003\u0001\"Xm\u001d;TK:$wJ\u001a4tKR\u001cx+\u001b;i\u000fJ|W\u000f]'fi\u0006$\u0017\r^1\u0015\t\u0005u\u0012Q\u001f\u0005\b\u0003\u0017{\u0002\u0019AAGQ\u001dy\u00121UAZ\u0003sdc!a.\u0002<\u0006}\u0006fA\u0010\u0002F\u0006Q1/\u001a8e\u001f\u001a47/\u001a;\u0015\t\u0005u\"\u0011\u0001\u0005\b\u0005\u0007\u0001\u0003\u0019\u0001B\u0003\u0003\u0019\u0019w.\\7jiBQ\u0001Ka\u0002u\u0003\u001b\u000b9\"!\u0010\n\u0007\t%\u0011KA\u0005Gk:\u001cG/[8og\u0005\u0019B/Z:u\r\u0016t7-\u001b8h\u001f:\u001cu.\\7jiR!\u0011Q\bB\b\u0011\u001d\tY)\ta\u0001\u0003\u001bCs!IAR\u0003g\u0013\u0019\u0002\f\u0004\u00028\u0006m\u0016q\u0018\u0015\u0004C\u0005\u0015\u0017\u0001\u0007;fgR4UM\\2j]\u001e|enU3oI>3gm]3ugR!\u0011Q\bB\u000e\u0011\u001d\tYI\ta\u0001\u0003\u001bCsAIAR\u0003g\u0013y\u0002\f\u0004\u00028\u0006m\u0016q\u0018\u0015\u0004E\u0005\u0015\u0017\u0001\f;fgR|eMZ:fi6+G/\u00193bi\u0006LenU3oI>3gm]3ugR{GK]1og\u0006\u001cG/[8o)\u0011\tiDa\n\t\u000f\u0005-5\u00051\u0001\u0002\u000e\":1%a)\u00024\n-BFBA\\\u0003w\u000by\fK\u0002$\u0003\u000b\f1\u0004^3ti&s\u0017\u000e\u001e+sC:\u001c\u0018m\u0019;j_:\u001cH+[7f_V$H\u0003BA\u001f\u0005gAq!a#%\u0001\u0004\ti\tK\u0004%\u0003G\u000b\u0019La\u000e-\r\u0005]\u00161XA`Q\r!\u0013QY\u0001$i\u0016\u001cHoU3oI>3gm]3ugR{GK]1og\u0006\u001cG/[8o)&lWm\\;u)\u0011\tiDa\u0010\t\u000f\u0005-U\u00051\u0001\u0002\u000e\":Q%a)\u00024\n\rCFBA\\\u0003w\u000by\fK\u0002&\u0003\u000b\fA\u0004^3ti\u000e{W.\\5u)J\fgn]1di&|g\u000eV5nK>,H\u000f\u0006\u0003\u0002>\t-\u0003bBAFM\u0001\u0007\u0011Q\u0012\u0015\bM\u0005\r\u00161\u0017B(Y\u0019\t9,a/\u0002@\"\u001aa%!2\u00027Q,7\u000f^!c_J$HK]1og\u0006\u001cG/[8o)&lWm\\;u)\u0011\tiDa\u0016\t\u000f\u0005-u\u00051\u0001\u0002\u000e\":q%a)\u00024\nmCFBA\\\u0003w\u000by\fK\u0002(\u0003\u000b\f1\u0002^3tiRKW.Z8viR1\u0011Q\bB2\u0005[BqA!\u001a)\u0001\u0004\u00119'\u0001\noK\u0016$\u0017J\\5u\u0003:$7+\u001a8e\u001bN<\u0007c\u0001)\u0003j%\u0019!1N)\u0003\u000f\t{w\u000e\\3b]\"9!q\u000e\u0015A\u0002\tE\u0014A\u0004;j[\u0016|W\u000f\u001e)s_\u000e,7o\u001d\t\u0007!\nMD/!\u0010\n\u0007\tU\u0014KA\u0005Gk:\u001cG/[8oc\u0005\tB/Z:u\r\u0016t7-\u001b8h\u001f:\u001cVM\u001c3\u0015\t\u0005u\"1\u0010\u0005\b\u0003\u0017K\u0003\u0019AAGQ\u001dI\u00131UAZ\u0005\u007fbc!a.\u0002<\u0006}\u0006fA\u0015\u0002F\u0006QB/Z:u\r\u0016t7-\u001b8h\u001f:\fE\r\u001a)beRLG/[8ogR!\u0011Q\bBD\u0011\u001d\tYI\u000ba\u0001\u0003\u001bCsAKAR\u0003g\u0013Y\t\f\u0004\u00028\u0006m\u0016q\u0018\u0015\u0004U\u0005\u0015\u0017A\t;fgR4UM\\2j]\u001e|e\u000e\u0016:b]N\f7\r^5p]\u0016C\b/\u001b:bi&|g\u000e\u0006\u0003\u0002>\tM\u0005bBAFW\u0001\u0007\u0011Q\u0012\u0015\bW\u0005\r\u00161\u0017BLY\u0019\t9,a/\u0002@\"\u001a1&!2\u00029Q,7\u000f^'vYRL\u0007\u000f\\3NCJ\\WM]:P]\u0016dU-\u00193feR!\u0011Q\bBP\u0011\u001d\tY\t\fa\u0001\u0003\u001bCs\u0001LAR\u0003g\u0013\u0019\u000b\f\u0004\u00028\u0006m\u0016q\u0018\u0015\u0004Y\u0005\u0015\u0017\u0001\n;fgR\u001cuN\\:fGV$\u0018N^3msJ+h.\u00138jiR\u0013\u0018M\\:bGRLwN\\:\u0015\t\u0005u\"1\u0016\u0005\b\u0003\u0017k\u0003\u0019AAGQ\u001di\u00131UAZ\u0005_cc!a.\u0002<\u0006}\u0006fA\u0017\u0002F\u0006QB/Z:u\u0005Vl\u0007\u000f\u0016:b]N\f7\r^5p]\u0006dW\t]8dQR!\u0011Q\bB\\\u0011\u001d\tYI\fa\u0001\u0003\u001bCsALAR\u0003g\u0013Y\f\f\u0004\u00028\u0006m\u0016q\u0018\u0015\u0004]\u0005\u0015\u0017a\u0006;fgR4\u0015-\u001b7ve\u0016$vNR3oG\u0016,\u0005o\\2i)\u0011\tiDa1\t\u000f\u0005-u\u00061\u0001\u0002\u000e\":q&a)\u00024\n\u001dGFBA\\\u0003w\u000by\fK\u00020\u0003\u000b\fqe]3oIR\u0013\u0018M\\:bGRLwN\\1m\u001b\u0016\u001c8/Y4fg^KG\u000f\u001b,bYV,'+\u00198hKRa\u0011Q\bBh\u0005#\u0014)N!7\u0003^\")q\u000f\ra\u0001i\"9!1\u001b\u0019A\u0002\u00055\u0015!\u0002;pa&\u001c\u0007B\u0002Bla\u0001\u0007q*A\u0003ti\u0006\u0014H\u000f\u0003\u0004\u0003\\B\u0002\raT\u0001\u0004K:$\u0007b\u0002Bpa\u0001\u0007!qM\u0001\u0010o&dGNQ3D_6l\u0017\u000e\u001e;fI\u0006Y2M]3bi\u0016\u0014V-\u00193D_6l\u0017\u000e\u001e;fI\u000e{gn];nKJ$\u0002\"a\u0006\u0003f\n%(Q\u001e\u0005\n\u0005O\f\u0004\u0013!a\u0001\u0003\u001b\u000bQa\u001a:pkBD\u0001Ba;2!\u0003\u0005\raT\u0001\u000f[\u0006D\bk\u001c7m%\u0016\u001cwN\u001d3t\u0011%\t)%\rI\u0001\u0002\u0004\ti#A\u0013de\u0016\fG/\u001a*fC\u0012\u001cu.\\7jiR,GmQ8ogVlWM\u001d\u0013eK\u001a\fW\u000f\u001c;%cU\u0011!1\u001f\u0016\u0005\u0003\u001b\u0013)p\u000b\u0002\u0003xB!!\u0011`B\u0002\u001b\t\u0011YP\u0003\u0003\u0003~\n}\u0018!C;oG\",7m[3e\u0015\r\u0019\t!U\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BB\u0003\u0005w\u0014\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u0003\u0015\u001a'/Z1uKJ+\u0017\rZ\"p[6LG\u000f^3e\u0007>t7/^7fe\u0012\"WMZ1vYR$#'\u0006\u0002\u0004\f)\u001aqJ!>\u0002K\r\u0014X-\u0019;f%\u0016\fGmQ8n[&$H/\u001a3D_:\u001cX/\\3sI\u0011,g-Y;mi\u0012\u001aTCAB\tU\u0011\tiC!>\u0002;\r\u0014X-\u0019;f%\u0016\fG-\u00168d_6l\u0017\u000e\u001e;fI\u000e{gn];nKJ$B!a\u0006\u0004\u0018!9!q]\u001bA\u0002\u00055\u0015aG2sK\u0006$X\r\u0016:b]N\f7\r^5p]\u0006d\u0007K]8ek\u000e,'\u000fF\u0006u\u0007;\u0019\tca\u000b\u00040\rM\u0002bBB\u0010m\u0001\u0007\u0011QR\u0001\u0010iJ\fgn]1di&|g.\u00197JI\"I11\u0005\u001c\u0011\u0002\u0003\u00071QE\u0001\u0015iJ\fgn]1di&|g\u000eV5nK>,H/T:\u0011\u0007A\u001b9#C\u0002\u0004*E\u0013A\u0001T8oO\"I1Q\u0006\u001c\u0011\u0002\u0003\u00071QE\u0001\u000b[\u0006D(\t\\8dW6\u001b\b\u0002CB\u0019mA\u0005\t\u0019A(\u0002#\u0011,G.\u001b<fef$\u0016.\\3pkRl5\u000f\u0003\u0005\u00046Y\u0002\n\u00111\u0001P\u0003A\u0011X-];fgR$\u0016.\\3pkRl5/A\u0013de\u0016\fG/\u001a+sC:\u001c\u0018m\u0019;j_:\fG\u000e\u0015:pIV\u001cWM\u001d\u0013eK\u001a\fW\u000f\u001c;%eU\u001111\b\u0016\u0005\u0007K\u0011)0A\u0013de\u0016\fG/\u001a+sC:\u001c\u0018m\u0019;j_:\fG\u000e\u0015:pIV\u001cWM\u001d\u0013eK\u001a\fW\u000f\u001c;%g\u0005)3M]3bi\u0016$&/\u00198tC\u000e$\u0018n\u001c8bYB\u0013x\u000eZ;dKJ$C-\u001a4bk2$H\u0005N\u0001&GJ,\u0017\r^3Ue\u0006t7/Y2uS>t\u0017\r\u001c)s_\u0012,8-\u001a:%I\u00164\u0017-\u001e7uIU\n1%\\1zE\u0016<\u0016-\u001b;G_J\fE\u000fT3bgR|e.Z*fO6,g\u000e^+qY>\fG\r\u0006\u0003\u0002>\r\u001d\u0003bBB%w\u0001\u000711J\u0001\u0010i>\u0004\u0018n\u0019)beRLG/[8ogB1\u0011\u0011JA&\u0007\u001b\u0002Baa\u0014\u0004V5\u00111\u0011\u000b\u0006\u0004\u0007'R\u0018AB2p[6|g.\u0003\u0003\u0004X\rE#A\u0004+pa&\u001c\u0007+\u0019:uSRLwN\\\u0001\u0016m\u0016\u0014\u0018NZ=M_\u001e\u001cF/\u0019:u\u001f\u001a47/\u001a;t)\u0011\tid!\u0018\t\u000f\r}C\b1\u0001\u0004b\u0005)\u0002/\u0019:uSRLwN\\*uCJ$xJ\u001a4tKR\u001c\bcBAH\u0007G\u001aieT\u0005\u0005\u0007K\nyJA\u0002NCB\f\u0011cY8ogVlWMU3d_J$7OR8s+\u0019\u0019Yg!\u001f\u0004\u000eR!1QNBI!\u0019\tI%a\u0013\u0004pAA\u0011\u0011DB9\u0007k\u001aY)\u0003\u0003\u0004t\u0005m!AD\"p]N,X.\u001a:SK\u000e|'\u000f\u001a\t\u0005\u0007o\u001aI\b\u0004\u0001\u0005\u000f\rmTH1\u0001\u0004~\t\t1*\u0005\u0003\u0004\u0000\r\u0015\u0005c\u0001)\u0004\u0002&\u001911Q)\u0003\u000f9{G\u000f[5oOB\u0019\u0001ka\"\n\u0007\r%\u0015KA\u0002B]f\u0004Baa\u001e\u0004\u000e\u001291qR\u001fC\u0002\ru$!\u0001,\t\u000f\u0005uQ\b1\u0001\u0004\u0014BA\u0011\u0011DA\u0010\u0007k\u001aY)A\u0010nCf\u0014WMV3sS\u001aLHj\\2bY2{wm\u0015;beR|eMZ:fiN$B!!\u0010\u0004\u001a\"91q\f A\u0002\rm\u0005\u0003CAH\u0007G\u001aie!(\u0011\u0007y\u001by*C\u0002\u0004*}CSAPBR\u0007w\u0003R\u0001UBS\u0007SK1aa*R\u0005\u0019!\bN]8xgB!11VB[\u001d\u0011\u0019ik!-\u000f\t\u0005M5qV\u0005\u0002%&\u001911W)\u0002\u000fA\f7m[1hK&!1qWB]\u0005QIe\u000e^3seV\u0004H/\u001a3Fq\u000e,\u0007\u000f^5p]*\u001911W)$\u0005\r%\u0006")
public class TransactionsTest
extends IntegrationTestHarness {
    private final int transactionalProducerCount;
    private final int transactionalConsumerCount;
    private final int nonTransactionalConsumerCount;
    private final String topic1;
    private final String topic2;
    private final int numPartitions;
    private final Buffer<KafkaProducer<byte[], byte[]>> transactionalProducers = (Buffer)Buffer$.MODULE$.apply((Seq)Nil$.MODULE$);
    private final Buffer<Consumer<byte[], byte[]>> transactionalConsumers = (Buffer)Buffer$.MODULE$.apply((Seq)Nil$.MODULE$);
    private final Buffer<Consumer<byte[], byte[]>> nonTransactionalConsumers = (Buffer)Buffer$.MODULE$.apply((Seq)Nil$.MODULE$);

    @Override
    public int brokerCount() {
        return 3;
    }

    public int transactionalProducerCount() {
        return this.transactionalProducerCount;
    }

    public int transactionalConsumerCount() {
        return this.transactionalConsumerCount;
    }

    public int nonTransactionalConsumerCount() {
        return this.nonTransactionalConsumerCount;
    }

    public String topic1() {
        return this.topic1;
    }

    public String topic2() {
        return this.topic2;
    }

    public int numPartitions() {
        return this.numPartitions;
    }

    public Buffer<KafkaProducer<byte[], byte[]>> transactionalProducers() {
        return this.transactionalProducers;
    }

    public Buffer<Consumer<byte[], byte[]>> transactionalConsumers() {
        return this.transactionalConsumers;
    }

    public Buffer<Consumer<byte[], byte[]>> nonTransactionalConsumers() {
        return this.nonTransactionalConsumers;
    }

    public Properties overridingProps() {
        Properties props = new Properties();
        props.put("auto.create.topics.enable", Boolean.toString(false));
        props.put("offsets.topic.num.partitions", Integer.toString(1));
        props.put("transaction.state.log.num.partitions", Integer.toString(3));
        props.put("transaction.state.log.replication.factor", Integer.toString(2));
        props.put("transaction.state.log.min.isr", Integer.toString(2));
        props.put("controlled.shutdown.enable", Boolean.toString(true));
        props.put(ReplicationConfigs.UNCLEAN_LEADER_ELECTION_ENABLE_CONFIG, Boolean.toString(false));
        props.put("auto.leader.rebalance.enable", Boolean.toString(false));
        props.put("group.initial.rebalance.delay.ms", "0");
        props.put("transaction.abort.timed.out.transaction.cleanup.interval.ms", "200");
        return props;
    }

    @Override
    public void modifyConfigs(Seq<Properties> props) {
        props.foreach((Function1 & Serializable & scala.Serializable)p -> {
            p.putAll((java.util.Map<?, ?>)this.overridingProps());
            return BoxedUnit.UNIT;
        });
    }

    @Override
    public Seq<Properties> kraftControllerConfigs(TestInfo testInfo) {
        return new .colon.colon((Object)this.overridingProps(), (List)Nil$.MODULE$);
    }

    public Properties topicConfig() {
        Properties topicConfig = new Properties();
        topicConfig.put(ServerLogConfigs.MIN_IN_SYNC_REPLICAS_CONFIG, Integer.toString(2));
        return topicConfig;
    }

    @Override
    @BeforeEach
    public void setUp(TestInfo testInfo) {
        super.setUp(testInfo);
        this.createTopic(this.topic1(), this.numPartitions(), this.brokerCount(), this.topicConfig(), this.createTopic$default$5(), this.createTopic$default$6());
        this.createTopic(this.topic2(), this.numPartitions(), this.brokerCount(), this.topicConfig(), this.createTopic$default$5(), this.createTopic$default$6());
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.transactionalProducerCount()).foreach((Function1 & Serializable & scala.Serializable)_ -> this.createTransactionalProducer("transactional-producer", this.createTransactionalProducer$default$2(), this.createTransactionalProducer$default$3(), this.createTransactionalProducer$default$4(), this.createTransactionalProducer$default$5()));
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.transactionalConsumerCount()).foreach((Function1 & Serializable & scala.Serializable)_ -> this.createReadCommittedConsumer("transactional-group", this.createReadCommittedConsumer$default$2(), this.createReadCommittedConsumer$default$3()));
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.nonTransactionalConsumerCount()).foreach((Function1 & Serializable & scala.Serializable)_ -> this.createReadUncommittedConsumer("non-transactional-group"));
    }

    @Override
    @AfterEach
    public void tearDown() {
        this.transactionalProducers().foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
            x$1.close();
            return BoxedUnit.UNIT;
        });
        this.transactionalConsumers().foreach((Function1 & Serializable & scala.Serializable)x$2 -> {
            x$2.close();
            return BoxedUnit.UNIT;
        });
        this.nonTransactionalConsumers().foreach((Function1 & Serializable & scala.Serializable)x$3 -> {
            x$3.close();
            return BoxedUnit.UNIT;
        });
        super.tearDown();
    }

    @ParameterizedTest
    @ValueSource(strings={"zk", "kraft", "kraft+kip848"})
    public void testBasicTransactions(String quorum) {
        KafkaProducer producer = (KafkaProducer)this.transactionalProducers().head();
        Consumer consumer = (Consumer)this.transactionalConsumers().head();
        Consumer unCommittedConsumer = (Consumer)this.nonTransactionalConsumers().head();
        TopicPartition tp11 = new TopicPartition(this.topic1(), 1);
        TopicPartition tp22 = new TopicPartition(this.topic2(), 2);
        producer.initTransactions();
        producer.beginTransaction();
        producer.send(TestUtils$.MODULE$.producerRecordWithExpectedTransactionStatus(this.topic2(), Predef$.MODULE$.int2Integer(2), "2", "2", false));
        producer.send(TestUtils$.MODULE$.producerRecordWithExpectedTransactionStatus(this.topic1(), Predef$.MODULE$.int2Integer(1), "4", "4", false));
        producer.flush();
        this.verifyLogStartOffsets((scala.collection.immutable.Map<TopicPartition, Object>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)tp11, (Object)BoxesRunTime.boxToInteger((int)0)), new Tuple2((Object)tp22, (Object)BoxesRunTime.boxToInteger((int)0))}))));
        this.maybeVerifyLocalLogStartOffsets((scala.collection.immutable.Map<TopicPartition, Long>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)tp11, (Object)Predef$.MODULE$.long2Long(0L)), new Tuple2((Object)tp22, (Object)Predef$.MODULE$.long2Long(0L))}))));
        producer.abortTransaction();
        this.maybeWaitForAtLeastOneSegmentUpload((Seq<TopicPartition>)new .colon.colon((Object)tp11, (List)new .colon.colon((Object)tp22, (List)Nil$.MODULE$)));
        this.verifyLogStartOffsets((scala.collection.immutable.Map<TopicPartition, Object>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)tp11, (Object)BoxesRunTime.boxToInteger((int)0)), new Tuple2((Object)tp22, (Object)BoxesRunTime.boxToInteger((int)0))}))));
        this.maybeVerifyLocalLogStartOffsets((scala.collection.immutable.Map<TopicPartition, Long>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)tp11, (Object)Predef$.MODULE$.long2Long(1L)), new Tuple2((Object)tp22, (Object)Predef$.MODULE$.long2Long(1L))}))));
        producer.beginTransaction();
        producer.send(TestUtils$.MODULE$.producerRecordWithExpectedTransactionStatus(this.topic1(), Predef$.MODULE$.int2Integer(1), "1", "1", true));
        producer.send(TestUtils$.MODULE$.producerRecordWithExpectedTransactionStatus(this.topic2(), Predef$.MODULE$.int2Integer(2), "3", "3", true));
        this.verifyLogStartOffsets((scala.collection.immutable.Map<TopicPartition, Object>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)tp11, (Object)BoxesRunTime.boxToInteger((int)0)), new Tuple2((Object)tp22, (Object)BoxesRunTime.boxToInteger((int)0))}))));
        this.maybeVerifyLocalLogStartOffsets((scala.collection.immutable.Map<TopicPartition, Long>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)tp11, (Object)Predef$.MODULE$.long2Long(1L)), new Tuple2((Object)tp22, (Object)Predef$.MODULE$.long2Long(1L))}))));
        producer.commitTransaction();
        this.verifyLogStartOffsets((scala.collection.immutable.Map<TopicPartition, Object>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)tp11, (Object)BoxesRunTime.boxToInteger((int)0)), new Tuple2((Object)tp22, (Object)BoxesRunTime.boxToInteger((int)0))}))));
        this.maybeVerifyLocalLogStartOffsets((scala.collection.immutable.Map<TopicPartition, Long>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)tp11, (Object)Predef$.MODULE$.long2Long(3L)), new Tuple2((Object)tp22, (Object)Predef$.MODULE$.long2Long(3L))}))));
        consumer.subscribe((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)this.topic1(), (List)new .colon.colon((Object)this.topic2(), (List)Nil$.MODULE$))).asJava());
        unCommittedConsumer.subscribe((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)this.topic1(), (List)new .colon.colon((Object)this.topic2(), (List)Nil$.MODULE$))).asJava());
        TestUtils$.MODULE$.consumeRecords(consumer, 2, TestUtils$.MODULE$.consumeRecords$default$3()).foreach((Function1 & Serializable & scala.Serializable)record -> TestUtils$.MODULE$.assertCommittedAndGetValue((ConsumerRecord<byte[], byte[]>)record));
        Seq allRecords = TestUtils$.MODULE$.consumeRecords(unCommittedConsumer, 4, TestUtils$.MODULE$.consumeRecords$default$3());
        scala.collection.immutable.Set expectedValues = new .colon.colon((Object)"1", (List)new .colon.colon((Object)"2", (List)new .colon.colon((Object)"3", (List)new .colon.colon((Object)"4", (List)Nil$.MODULE$)))).toSet();
        allRecords.foreach((Function1 & Serializable & scala.Serializable)record -> {
            TransactionsTest.$anonfun$testBasicTransactions$2(expectedValues, record);
            return BoxedUnit.UNIT;
        });
    }

    @ParameterizedTest
    @ValueSource(strings={"zk", "kraft", "kraft+kip848"})
    public void testReadCommittedConsumerShouldNotSeeUndecidedData(String quorum) {
        KafkaProducer producer1 = (KafkaProducer)this.transactionalProducers().head();
        KafkaProducer<byte[], byte[]> producer2 = this.createTransactionalProducer("other", this.createTransactionalProducer$default$2(), this.createTransactionalProducer$default$3(), this.createTransactionalProducer$default$4(), this.createTransactionalProducer$default$5());
        Consumer readCommittedConsumer = (Consumer)this.transactionalConsumers().head();
        Consumer readUncommittedConsumer = (Consumer)this.nonTransactionalConsumers().head();
        producer1.initTransactions();
        producer2.initTransactions();
        producer1.beginTransaction();
        producer2.beginTransaction();
        long latestVisibleTimestamp = System.currentTimeMillis();
        producer2.send(new ProducerRecord(this.topic1(), Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.long2Long(latestVisibleTimestamp), (Object)"x".getBytes(), (Object)"1".getBytes()));
        producer2.send(new ProducerRecord(this.topic2(), Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.long2Long(latestVisibleTimestamp), (Object)"x".getBytes(), (Object)"1".getBytes()));
        producer2.flush();
        long latestWrittenTimestamp = latestVisibleTimestamp + 1L;
        producer1.send(new ProducerRecord(this.topic1(), Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.long2Long(latestWrittenTimestamp), (Object)"a".getBytes(), (Object)"1".getBytes()));
        producer1.send(new ProducerRecord(this.topic1(), Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.long2Long(latestWrittenTimestamp), (Object)"b".getBytes(), (Object)"2".getBytes()));
        producer1.send(new ProducerRecord(this.topic2(), Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.long2Long(latestWrittenTimestamp), (Object)"c".getBytes(), (Object)"3".getBytes()));
        producer1.send(new ProducerRecord(this.topic2(), Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.long2Long(latestWrittenTimestamp), (Object)"d".getBytes(), (Object)"4".getBytes()));
        producer1.flush();
        producer2.send(new ProducerRecord(this.topic1(), Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.long2Long(latestWrittenTimestamp), (Object)"x".getBytes(), (Object)"2".getBytes()));
        producer2.send(new ProducerRecord(this.topic2(), Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.long2Long(latestWrittenTimestamp), (Object)"x".getBytes(), (Object)"2".getBytes()));
        producer2.commitTransaction();
        TopicPartition tp1 = new TopicPartition(this.topic1(), 0);
        TopicPartition tp2 = new TopicPartition(this.topic2(), 0);
        readUncommittedConsumer.assign((Collection)CollectionConverters$.MODULE$.setAsJavaSetConverter((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{tp1, tp2}))).asJava());
        TestUtils$.MODULE$.consumeRecords(readUncommittedConsumer, 8, TestUtils$.MODULE$.consumeRecords$default$3());
        java.util.Map readUncommittedOffsetsForTimes = readUncommittedConsumer.offsetsForTimes((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp1), (Object)Predef$.MODULE$.long2Long(latestWrittenTimestamp)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp2), (Object)Predef$.MODULE$.long2Long(latestWrittenTimestamp))}))).asJava());
        Assertions.assertEquals((int)2, (int)readUncommittedOffsetsForTimes.size());
        Assertions.assertEquals((long)latestWrittenTimestamp, (long)((OffsetAndTimestamp)readUncommittedOffsetsForTimes.get(tp1)).timestamp());
        Assertions.assertEquals((long)latestWrittenTimestamp, (long)((OffsetAndTimestamp)readUncommittedOffsetsForTimes.get(tp2)).timestamp());
        readUncommittedConsumer.unsubscribe();
        readCommittedConsumer.assign((Collection)CollectionConverters$.MODULE$.setAsJavaSetConverter((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{tp1, tp2}))).asJava());
        TestUtils$.MODULE$.consumeRecords(readCommittedConsumer, 2, TestUtils$.MODULE$.consumeRecords$default$3()).foreach((Function1 & Serializable & scala.Serializable)record -> {
            TransactionsTest.$anonfun$testReadCommittedConsumerShouldNotSeeUndecidedData$1(record);
            return BoxedUnit.UNIT;
        });
        Assertions.assertEquals((int)2, (int)readCommittedConsumer.assignment().size());
        readCommittedConsumer.seekToEnd((Collection)readCommittedConsumer.assignment());
        readCommittedConsumer.assignment().forEach(tp -> Assertions.assertEquals((long)1L, (long)readCommittedConsumer.position(tp)));
        java.util.Map readCommittedOffsetsForTimes = readCommittedConsumer.offsetsForTimes((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp1), (Object)Predef$.MODULE$.long2Long(latestWrittenTimestamp)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp2), (Object)Predef$.MODULE$.long2Long(latestWrittenTimestamp))}))).asJava());
        Assertions.assertNull(readCommittedOffsetsForTimes.get(tp1));
        Assertions.assertNull(readCommittedOffsetsForTimes.get(tp2));
    }

    @ParameterizedTest
    @ValueSource(strings={"zk", "kraft", "kraft+kip848"})
    public void testDelayedFetchIncludesAbortedTransaction(String quorum) {
        KafkaProducer producer1 = (KafkaProducer)this.transactionalProducers().head();
        KafkaProducer<byte[], byte[]> producer2 = this.createTransactionalProducer("other", this.createTransactionalProducer$default$2(), this.createTransactionalProducer$default$3(), this.createTransactionalProducer$default$4(), this.createTransactionalProducer$default$5());
        TopicPartition tp10 = new TopicPartition(this.topic1(), 0);
        producer1.initTransactions();
        producer2.initTransactions();
        producer1.beginTransaction();
        producer2.beginTransaction();
        producer2.send(new ProducerRecord(this.topic1(), Predef$.MODULE$.int2Integer(0), (Object)"x".getBytes(), (Object)"1".getBytes()));
        producer2.flush();
        producer1.send(new ProducerRecord(this.topic1(), Predef$.MODULE$.int2Integer(0), (Object)"y".getBytes(), (Object)"1".getBytes()));
        producer1.send(new ProducerRecord(this.topic1(), Predef$.MODULE$.int2Integer(0), (Object)"y".getBytes(), (Object)"2".getBytes()));
        producer1.flush();
        producer2.send(new ProducerRecord(this.topic1(), Predef$.MODULE$.int2Integer(0), (Object)"x".getBytes(), (Object)"2".getBytes()));
        producer2.flush();
        this.verifyLogStartOffsets((scala.collection.immutable.Map<TopicPartition, Object>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)tp10, (Object)BoxesRunTime.boxToInteger((int)0))}))));
        this.maybeVerifyLocalLogStartOffsets((scala.collection.immutable.Map<TopicPartition, Long>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)tp10, (Object)Predef$.MODULE$.long2Long(0L))}))));
        producer1.abortTransaction();
        producer2.commitTransaction();
        this.maybeWaitForAtLeastOneSegmentUpload((Seq<TopicPartition>)new .colon.colon((Object)tp10, (List)Nil$.MODULE$));
        this.verifyLogStartOffsets((scala.collection.immutable.Map<TopicPartition, Object>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)tp10, (Object)BoxesRunTime.boxToInteger((int)0))}))));
        this.maybeVerifyLocalLogStartOffsets((scala.collection.immutable.Map<TopicPartition, Long>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)tp10, (Object)Predef$.MODULE$.long2Long(5L))}))));
        Properties consumerProps = new Properties();
        consumerProps.put("fetch.min.bytes", "100000");
        consumerProps.put("fetch.max.wait.ms", "100");
        String x$2 = this.createReadCommittedConsumer$default$1();
        int x$3 = this.createReadCommittedConsumer$default$2();
        Consumer<byte[], byte[]> readCommittedConsumer = this.createReadCommittedConsumer(x$2, x$3, consumerProps);
        readCommittedConsumer.assign((Collection)CollectionConverters$.MODULE$.setAsJavaSetConverter((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{tp10}))).asJava());
        Seq<ConsumerRecord<byte[], byte[]>> records = TestUtils$.MODULE$.consumeRecords(readCommittedConsumer, 2, TestUtils$.MODULE$.consumeRecords$default$3());
        Assertions.assertEquals((int)2, (int)records.size());
        ConsumerRecord first = (ConsumerRecord)records.head();
        Assertions.assertEquals((Object)"x", (Object)new String((byte[])first.key()));
        Assertions.assertEquals((Object)"1", (Object)new String((byte[])first.value()));
        Assertions.assertEquals((long)0L, (long)first.offset());
        ConsumerRecord second = (ConsumerRecord)records.last();
        Assertions.assertEquals((Object)"x", (Object)new String((byte[])second.key()));
        Assertions.assertEquals((Object)"2", (Object)new String((byte[])second.value()));
        Assertions.assertEquals((long)3L, (long)second.offset());
    }

    @ParameterizedTest
    @ValueSource(strings={"zk", "kraft", "kraft+kip848"})
    public void testSendOffsetsWithGroupId(String quorum) {
        String sendOffset_consumerGroupId = "foobar-consumer-group";
        int sendOffset_numSeedMessages = 500;
        TestUtils$.MODULE$.seedTopicWithNumberedRecords(this.topic1(), sendOffset_numSeedMessages, this.brokers());
        KafkaProducer sendOffset_producer = (KafkaProducer)this.transactionalProducers().head();
        Consumer<byte[], byte[]> sendOffset_consumer = this.createReadCommittedConsumer(sendOffset_consumerGroupId, sendOffset_numSeedMessages / 4, this.createReadCommittedConsumer$default$3());
        sendOffset_consumer.subscribe((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)this.topic1(), (List)Nil$.MODULE$)).asJava());
        sendOffset_producer.initTransactions();
        BooleanRef sendOffset_shouldCommit = BooleanRef.create((boolean)false);
        IntRef sendOffset_recordsProcessed = IntRef.create((int)0);
        try {
            while (sendOffset_recordsProcessed.elem < sendOffset_numSeedMessages) {
                Seq<ConsumerRecord<byte[], byte[]>> sendOffset_records = TestUtils$.MODULE$.pollUntilAtLeastNumRecords(sendOffset_consumer, Math.min(10, sendOffset_numSeedMessages - sendOffset_recordsProcessed.elem), TestUtils$.MODULE$.pollUntilAtLeastNumRecords$default$3());
                sendOffset_producer.beginTransaction();
                sendOffset_shouldCommit.elem = !sendOffset_shouldCommit.elem;
                sendOffset_records.foreach((Function1 & Serializable & scala.Serializable)record -> {
                    String key = new String((byte[])record.key(), StandardCharsets.UTF_8);
                    String value = new String((byte[])record.value(), StandardCharsets.UTF_8);
                    return sendOffset_producer.send(TestUtils$.MODULE$.producerRecordWithExpectedTransactionStatus(this.topic2(), null, key, value, shouldCommit$1.elem));
                });
                sendOffset_producer.sendOffsetsToTransaction((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter(TestUtils$.MODULE$.consumerPositions((Consumer<byte[], byte[]>)sendOffset_consumer)).asJava(), sendOffset_consumerGroupId);
                if (sendOffset_shouldCommit.elem) {
                    sendOffset_producer.commitTransaction();
                    sendOffset_recordsProcessed.elem += sendOffset_records.size();
                    this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(74).append("committed transaction.. Last committed record: ").append(new String((byte[])((ConsumerRecord)sendOffset_records.last()).value(), StandardCharsets.UTF_8)).append(". Num ").append("records written to ").append(this.topic2()).append(": ").append(recordsProcessed$1.elem).toString());
                    continue;
                }
                sendOffset_producer.abortTransaction();
                this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(70).append("aborted transaction Last committed record: ").append(new String((byte[])((ConsumerRecord)sendOffset_records.last()).value(), StandardCharsets.UTF_8)).append(". Num ").append("records written to ").append(this.topic2()).append(": ").append(recordsProcessed$1.elem).toString());
                TestUtils$.MODULE$.resetToCommittedPositions(sendOffset_consumer);
            }
        }
        finally {
            sendOffset_consumer.close();
        }
        ListBuffer sendOffset_partitions = (ListBuffer)ListBuffer$.MODULE$.empty();
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.numPartitions()).foreach((Function1 & Serializable & scala.Serializable)partition -> sendOffset_partitions.$plus$eq((Object)new TopicPartition(this.topic2(), BoxesRunTime.unboxToInt((Object)partition))));
        this.maybeWaitForAtLeastOneSegmentUpload((Seq<TopicPartition>)sendOffset_partitions.toSeq());
        Consumer sendOffset_verifyingConsumer = (Consumer)this.transactionalConsumers().apply(0);
        sendOffset_verifyingConsumer.subscribe((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)this.topic2(), (List)Nil$.MODULE$)).asJava());
        Seq sendOffset_valueSeq = (Seq)TestUtils$.MODULE$.pollUntilAtLeastNumRecords(sendOffset_verifyingConsumer, sendOffset_numSeedMessages, TestUtils$.MODULE$.pollUntilAtLeastNumRecords$default$3()).map((Function1 & Serializable & scala.Serializable)record -> BoxesRunTime.boxToInteger((int)TransactionsTest.$anonfun$sendOffset$5(record)), Seq$.MODULE$.canBuildFrom());
        scala.collection.immutable.Set sendOffset_valueSet = sendOffset_valueSeq.toSet();
        Assertions.assertEquals((int)sendOffset_numSeedMessages, (int)sendOffset_valueSeq.size(), (String)new StringBuilder(21).append("Expected ").append(sendOffset_numSeedMessages).append(" values in ").append(this.topic2()).append(".").toString());
        Assertions.assertEquals((int)sendOffset_valueSeq.size(), (int)sendOffset_valueSet.size(), (String)new StringBuilder(30).append("Expected ").append(sendOffset_valueSeq.size()).append(" unique messages in ").append(this.topic2()).append(".").toString());
    }

    @ParameterizedTest
    @ValueSource(strings={"zk", "kraft", "kraft+kip848"})
    public void testSendOffsetsWithGroupMetadata(String quorum) {
        String sendOffset_consumerGroupId = "foobar-consumer-group";
        int sendOffset_numSeedMessages = 500;
        TestUtils$.MODULE$.seedTopicWithNumberedRecords(this.topic1(), sendOffset_numSeedMessages, this.brokers());
        KafkaProducer sendOffset_producer = (KafkaProducer)this.transactionalProducers().head();
        Consumer<byte[], byte[]> sendOffset_consumer = this.createReadCommittedConsumer(sendOffset_consumerGroupId, sendOffset_numSeedMessages / 4, this.createReadCommittedConsumer$default$3());
        sendOffset_consumer.subscribe((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)this.topic1(), (List)Nil$.MODULE$)).asJava());
        sendOffset_producer.initTransactions();
        BooleanRef sendOffset_shouldCommit = BooleanRef.create((boolean)false);
        IntRef sendOffset_recordsProcessed = IntRef.create((int)0);
        try {
            while (sendOffset_recordsProcessed.elem < sendOffset_numSeedMessages) {
                Seq<ConsumerRecord<byte[], byte[]>> sendOffset_records = TestUtils$.MODULE$.pollUntilAtLeastNumRecords(sendOffset_consumer, Math.min(10, sendOffset_numSeedMessages - sendOffset_recordsProcessed.elem), TestUtils$.MODULE$.pollUntilAtLeastNumRecords$default$3());
                sendOffset_producer.beginTransaction();
                sendOffset_shouldCommit.elem = !sendOffset_shouldCommit.elem;
                sendOffset_records.foreach((Function1 & Serializable & scala.Serializable)record -> {
                    String key = new String((byte[])record.key(), StandardCharsets.UTF_8);
                    String value = new String((byte[])record.value(), StandardCharsets.UTF_8);
                    return sendOffset_producer.send(TestUtils$.MODULE$.producerRecordWithExpectedTransactionStatus(this.topic2(), null, key, value, shouldCommit$1.elem));
                });
                sendOffset_producer.sendOffsetsToTransaction((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter(TestUtils$.MODULE$.consumerPositions((Consumer<byte[], byte[]>)sendOffset_consumer)).asJava(), sendOffset_consumer.groupMetadata());
                if (sendOffset_shouldCommit.elem) {
                    sendOffset_producer.commitTransaction();
                    sendOffset_recordsProcessed.elem += sendOffset_records.size();
                    this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(74).append("committed transaction.. Last committed record: ").append(new String((byte[])((ConsumerRecord)sendOffset_records.last()).value(), StandardCharsets.UTF_8)).append(". Num ").append("records written to ").append(this.topic2()).append(": ").append(recordsProcessed$1.elem).toString());
                    continue;
                }
                sendOffset_producer.abortTransaction();
                this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(70).append("aborted transaction Last committed record: ").append(new String((byte[])((ConsumerRecord)sendOffset_records.last()).value(), StandardCharsets.UTF_8)).append(". Num ").append("records written to ").append(this.topic2()).append(": ").append(recordsProcessed$1.elem).toString());
                TestUtils$.MODULE$.resetToCommittedPositions(sendOffset_consumer);
            }
        }
        finally {
            sendOffset_consumer.close();
        }
        ListBuffer sendOffset_partitions = (ListBuffer)ListBuffer$.MODULE$.empty();
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.numPartitions()).foreach((Function1 & Serializable & scala.Serializable)partition -> sendOffset_partitions.$plus$eq((Object)new TopicPartition(this.topic2(), BoxesRunTime.unboxToInt((Object)partition))));
        this.maybeWaitForAtLeastOneSegmentUpload((Seq<TopicPartition>)sendOffset_partitions.toSeq());
        Consumer sendOffset_verifyingConsumer = (Consumer)this.transactionalConsumers().apply(0);
        sendOffset_verifyingConsumer.subscribe((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)this.topic2(), (List)Nil$.MODULE$)).asJava());
        Seq sendOffset_valueSeq = (Seq)TestUtils$.MODULE$.pollUntilAtLeastNumRecords(sendOffset_verifyingConsumer, sendOffset_numSeedMessages, TestUtils$.MODULE$.pollUntilAtLeastNumRecords$default$3()).map((Function1 & Serializable & scala.Serializable)record -> BoxesRunTime.boxToInteger((int)TransactionsTest.$anonfun$sendOffset$5(record)), Seq$.MODULE$.canBuildFrom());
        scala.collection.immutable.Set sendOffset_valueSet = sendOffset_valueSeq.toSet();
        Assertions.assertEquals((int)sendOffset_numSeedMessages, (int)sendOffset_valueSeq.size(), (String)new StringBuilder(21).append("Expected ").append(sendOffset_numSeedMessages).append(" values in ").append(this.topic2()).append(".").toString());
        Assertions.assertEquals((int)sendOffset_valueSeq.size(), (int)sendOffset_valueSet.size(), (String)new StringBuilder(30).append("Expected ").append(sendOffset_valueSeq.size()).append(" unique messages in ").append(this.topic2()).append(".").toString());
    }

    private void sendOffset(Function3<KafkaProducer<byte[], byte[]>, String, Consumer<byte[], byte[]>, BoxedUnit> commit) {
        String consumerGroupId = "foobar-consumer-group";
        int numSeedMessages = 500;
        TestUtils$.MODULE$.seedTopicWithNumberedRecords(this.topic1(), numSeedMessages, this.brokers());
        KafkaProducer producer = (KafkaProducer)this.transactionalProducers().head();
        Consumer<byte[], byte[]> consumer = this.createReadCommittedConsumer(consumerGroupId, numSeedMessages / 4, this.createReadCommittedConsumer$default$3());
        consumer.subscribe((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)this.topic1(), (List)Nil$.MODULE$)).asJava());
        producer.initTransactions();
        BooleanRef shouldCommit = BooleanRef.create((boolean)false);
        IntRef recordsProcessed = IntRef.create((int)0);
        try {
            while (recordsProcessed.elem < numSeedMessages) {
                Seq<ConsumerRecord<byte[], byte[]>> records = TestUtils$.MODULE$.pollUntilAtLeastNumRecords(consumer, Math.min(10, numSeedMessages - recordsProcessed.elem), TestUtils$.MODULE$.pollUntilAtLeastNumRecords$default$3());
                producer.beginTransaction();
                shouldCommit.elem = !shouldCommit.elem;
                records.foreach((Function1 & Serializable & scala.Serializable)record -> {
                    String key = new String((byte[])record.key(), StandardCharsets.UTF_8);
                    String value = new String((byte[])record.value(), StandardCharsets.UTF_8);
                    return sendOffset_producer.send(TestUtils$.MODULE$.producerRecordWithExpectedTransactionStatus(this.topic2(), null, key, value, shouldCommit$1.elem));
                });
                commit.apply((Object)producer, (Object)consumerGroupId, consumer);
                if (shouldCommit.elem) {
                    producer.commitTransaction();
                    recordsProcessed.elem += records.size();
                    this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(74).append("committed transaction.. Last committed record: ").append(new String((byte[])((ConsumerRecord)sendOffset_records.last()).value(), StandardCharsets.UTF_8)).append(". Num ").append("records written to ").append(this.topic2()).append(": ").append(recordsProcessed$1.elem).toString());
                    continue;
                }
                producer.abortTransaction();
                this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(70).append("aborted transaction Last committed record: ").append(new String((byte[])((ConsumerRecord)sendOffset_records.last()).value(), StandardCharsets.UTF_8)).append(". Num ").append("records written to ").append(this.topic2()).append(": ").append(recordsProcessed$1.elem).toString());
                TestUtils$.MODULE$.resetToCommittedPositions(consumer);
            }
        }
        finally {
            consumer.close();
        }
        ListBuffer partitions = (ListBuffer)ListBuffer$.MODULE$.empty();
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.numPartitions()).foreach((Function1 & Serializable & scala.Serializable)partition -> sendOffset_partitions.$plus$eq((Object)new TopicPartition(this.topic2(), BoxesRunTime.unboxToInt((Object)partition))));
        this.maybeWaitForAtLeastOneSegmentUpload((Seq<TopicPartition>)partitions.toSeq());
        Consumer verifyingConsumer = (Consumer)this.transactionalConsumers().apply(0);
        verifyingConsumer.subscribe((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)this.topic2(), (List)Nil$.MODULE$)).asJava());
        Seq valueSeq = (Seq)TestUtils$.MODULE$.pollUntilAtLeastNumRecords(verifyingConsumer, numSeedMessages, TestUtils$.MODULE$.pollUntilAtLeastNumRecords$default$3()).map((Function1 & Serializable & scala.Serializable)record -> BoxesRunTime.boxToInteger((int)TransactionsTest.$anonfun$sendOffset$5(record)), Seq$.MODULE$.canBuildFrom());
        scala.collection.immutable.Set valueSet = valueSeq.toSet();
        Assertions.assertEquals((int)numSeedMessages, (int)valueSeq.size(), (String)new StringBuilder(21).append("Expected ").append(numSeedMessages).append(" values in ").append(this.topic2()).append(".").toString());
        Assertions.assertEquals((int)valueSeq.size(), (int)valueSet.size(), (String)new StringBuilder(30).append("Expected ").append(valueSeq.size()).append(" unique messages in ").append(this.topic2()).append(".").toString());
    }

    @ParameterizedTest
    @ValueSource(strings={"zk", "kraft", "kraft+kip848"})
    public void testFencingOnCommit(String quorum) {
        KafkaProducer producer1 = (KafkaProducer)this.transactionalProducers().apply(0);
        KafkaProducer producer2 = (KafkaProducer)this.transactionalProducers().apply(1);
        Consumer consumer = (Consumer)this.transactionalConsumers().apply(0);
        consumer.subscribe((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)this.topic1(), (List)new .colon.colon((Object)this.topic2(), (List)Nil$.MODULE$))).asJava());
        producer1.initTransactions();
        producer1.beginTransaction();
        producer1.send(TestUtils$.MODULE$.producerRecordWithExpectedTransactionStatus(this.topic1(), null, "1", "1", false));
        producer1.send(TestUtils$.MODULE$.producerRecordWithExpectedTransactionStatus(this.topic2(), null, "3", "3", false));
        producer2.initTransactions();
        producer2.beginTransaction();
        producer2.send(TestUtils$.MODULE$.producerRecordWithExpectedTransactionStatus(this.topic1(), null, "2", "4", true));
        producer2.send(TestUtils$.MODULE$.producerRecordWithExpectedTransactionStatus(this.topic2(), null, "2", "4", true));
        Assertions.assertThrows(ProducerFencedException.class, () -> producer1.commitTransaction());
        producer2.commitTransaction();
        TestUtils$.MODULE$.consumeRecords(consumer, 2, TestUtils$.MODULE$.consumeRecords$default$3()).foreach((Function1 & Serializable & scala.Serializable)record -> TestUtils$.MODULE$.assertCommittedAndGetValue((ConsumerRecord<byte[], byte[]>)record));
    }

    @ParameterizedTest
    @ValueSource(strings={"zk", "kraft", "kraft+kip848"})
    public void testFencingOnSendOffsets(String quorum) {
        KafkaProducer producer1 = (KafkaProducer)this.transactionalProducers().apply(0);
        KafkaProducer producer2 = (KafkaProducer)this.transactionalProducers().apply(1);
        Consumer consumer = (Consumer)this.transactionalConsumers().apply(0);
        consumer.subscribe((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)this.topic1(), (List)new .colon.colon((Object)this.topic2(), (List)Nil$.MODULE$))).asJava());
        producer1.initTransactions();
        producer1.beginTransaction();
        producer1.send(TestUtils$.MODULE$.producerRecordWithExpectedTransactionStatus(this.topic1(), null, "1", "1", false));
        producer1.send(TestUtils$.MODULE$.producerRecordWithExpectedTransactionStatus(this.topic2(), null, "3", "3", false));
        producer1.flush();
        producer2.initTransactions();
        producer2.beginTransaction();
        producer2.send(TestUtils$.MODULE$.producerRecordWithExpectedTransactionStatus(this.topic1(), null, "2", "4", true));
        producer2.send(TestUtils$.MODULE$.producerRecordWithExpectedTransactionStatus(this.topic2(), null, "2", "4", true));
        Assertions.assertThrows(ProducerFencedException.class, () -> producer1.sendOffsetsToTransaction((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("foobartopic", 0)), (Object)new OffsetAndMetadata(110L))}))).asJava(), new ConsumerGroupMetadata("foobarGroup")));
        producer2.commitTransaction();
        TestUtils$.MODULE$.consumeRecords(consumer, 2, TestUtils$.MODULE$.consumeRecords$default$3()).foreach((Function1 & Serializable & scala.Serializable)record -> TestUtils$.MODULE$.assertCommittedAndGetValue((ConsumerRecord<byte[], byte[]>)record));
    }

    /*
     * WARNING - void declaration
     */
    @ParameterizedTest
    @ValueSource(strings={"zk", "kraft", "kraft+kip848"})
    public void testOffsetMetadataInSendOffsetsToTransaction(String quorum) {
        TopicPartition tp = new TopicPartition(this.topic1(), 0);
        String groupId = "group";
        KafkaProducer producer = (KafkaProducer)this.transactionalProducers().head();
        Consumer<byte[], byte[]> consumer = this.createReadCommittedConsumer(groupId, this.createReadCommittedConsumer$default$2(), this.createReadCommittedConsumer$default$3());
        consumer.subscribe((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)this.topic1(), (List)Nil$.MODULE$)).asJava());
        producer.initTransactions();
        producer.beginTransaction();
        OffsetAndMetadata offsetAndMetadata = new OffsetAndMetadata(110L, Optional.of(Predef$.MODULE$.int2Integer(15)), "some metadata");
        producer.sendOffsetsToTransaction((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), (Object)offsetAndMetadata)}))).asJava(), new ConsumerGroupMetadata(groupId));
        producer.commitTransaction();
        ((KafkaProducer)this.transactionalProducers().apply(1)).initTransactions();
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!offsetAndMetadata.equals(consumer.committed((java.util.Set)CollectionConverters$.MODULE$.setAsJavaSetConverter((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{tp}))).asJava()).get(tp))) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)TransactionsTest.$anonfun$testOffsetMetadataInSendOffsetsToTransaction$2());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
    }

    @ParameterizedTest
    @ValueSource(strings={"zk", "kraft", "kraft+kip848"})
    public void testInitTransactionsTimeout(String quorum) {
        Function1 & Serializable & scala.Serializable testTimeout_timeoutProcess = (Function1 & Serializable & scala.Serializable)producer -> {
            producer.initTransactions();
            return BoxedUnit.UNIT;
        };
        boolean testTimeout_needInitAndSendMsg = false;
        String testTimeout_x$1 = "transactionProducer";
        long testTimeout_x$2 = 3000L;
        long testTimeout_x$3 = this.createTransactionalProducer$default$2();
        int testTimeout_x$4 = this.createTransactionalProducer$default$4();
        int testTimeout_x$5 = this.createTransactionalProducer$default$5();
        KafkaProducer<byte[], byte[]> testTimeout_producer = this.createTransactionalProducer(testTimeout_x$1, testTimeout_x$3, testTimeout_x$2, testTimeout_x$4, testTimeout_x$5);
        if (testTimeout_needInitAndSendMsg) {
            testTimeout_producer.initTransactions();
            testTimeout_producer.beginTransaction();
            testTimeout_producer.send(new ProducerRecord(this.topic1(), (Object)"foo".getBytes(), (Object)"bar".getBytes()));
        }
        this.brokers().indices().foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> this.killBroker(i));
        Assertions.assertThrows(TimeoutException.class, () -> testTimeout_timeoutProcess.apply((Object)testTimeout_producer));
        testTimeout_producer.close(Duration.ZERO);
    }

    @ParameterizedTest
    @ValueSource(strings={"zk", "kraft", "kraft+kip848"})
    public void testSendOffsetsToTransactionTimeout(String quorum) {
        Function1 & Serializable & scala.Serializable testTimeout_timeoutProcess = (Function1 & Serializable & scala.Serializable)producer -> {
            producer.sendOffsetsToTransaction((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition(this.topic1(), 0)), (Object)new OffsetAndMetadata(0L))}))).asJava(), new ConsumerGroupMetadata("test-group"));
            return BoxedUnit.UNIT;
        };
        boolean testTimeout_needInitAndSendMsg = true;
        String testTimeout_x$1 = "transactionProducer";
        long testTimeout_x$2 = 3000L;
        long testTimeout_x$3 = this.createTransactionalProducer$default$2();
        int testTimeout_x$4 = this.createTransactionalProducer$default$4();
        int testTimeout_x$5 = this.createTransactionalProducer$default$5();
        KafkaProducer<byte[], byte[]> testTimeout_producer = this.createTransactionalProducer(testTimeout_x$1, testTimeout_x$3, testTimeout_x$2, testTimeout_x$4, testTimeout_x$5);
        if (testTimeout_needInitAndSendMsg) {
            testTimeout_producer.initTransactions();
            testTimeout_producer.beginTransaction();
            testTimeout_producer.send(new ProducerRecord(this.topic1(), (Object)"foo".getBytes(), (Object)"bar".getBytes()));
        }
        this.brokers().indices().foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> this.killBroker(i));
        Assertions.assertThrows(TimeoutException.class, () -> testTimeout_timeoutProcess.apply((Object)testTimeout_producer));
        testTimeout_producer.close(Duration.ZERO);
    }

    @ParameterizedTest
    @ValueSource(strings={"zk", "kraft", "kraft+kip848"})
    public void testCommitTransactionTimeout(String quorum) {
        Function1 & Serializable & scala.Serializable testTimeout_timeoutProcess = (Function1 & Serializable & scala.Serializable)producer -> {
            producer.commitTransaction();
            return BoxedUnit.UNIT;
        };
        boolean testTimeout_needInitAndSendMsg = true;
        String testTimeout_x$1 = "transactionProducer";
        long testTimeout_x$2 = 3000L;
        long testTimeout_x$3 = this.createTransactionalProducer$default$2();
        int testTimeout_x$4 = this.createTransactionalProducer$default$4();
        int testTimeout_x$5 = this.createTransactionalProducer$default$5();
        KafkaProducer<byte[], byte[]> testTimeout_producer = this.createTransactionalProducer(testTimeout_x$1, testTimeout_x$3, testTimeout_x$2, testTimeout_x$4, testTimeout_x$5);
        if (testTimeout_needInitAndSendMsg) {
            testTimeout_producer.initTransactions();
            testTimeout_producer.beginTransaction();
            testTimeout_producer.send(new ProducerRecord(this.topic1(), (Object)"foo".getBytes(), (Object)"bar".getBytes()));
        }
        this.brokers().indices().foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> this.killBroker(i));
        Assertions.assertThrows(TimeoutException.class, () -> testTimeout_timeoutProcess.apply((Object)testTimeout_producer));
        testTimeout_producer.close(Duration.ZERO);
    }

    @ParameterizedTest
    @ValueSource(strings={"zk", "kraft", "kraft+kip848"})
    public void testAbortTransactionTimeout(String quorum) {
        Function1 & Serializable & scala.Serializable testTimeout_timeoutProcess = (Function1 & Serializable & scala.Serializable)producer -> {
            producer.abortTransaction();
            return BoxedUnit.UNIT;
        };
        boolean testTimeout_needInitAndSendMsg = true;
        String testTimeout_x$1 = "transactionProducer";
        long testTimeout_x$2 = 3000L;
        long testTimeout_x$3 = this.createTransactionalProducer$default$2();
        int testTimeout_x$4 = this.createTransactionalProducer$default$4();
        int testTimeout_x$5 = this.createTransactionalProducer$default$5();
        KafkaProducer<byte[], byte[]> testTimeout_producer = this.createTransactionalProducer(testTimeout_x$1, testTimeout_x$3, testTimeout_x$2, testTimeout_x$4, testTimeout_x$5);
        if (testTimeout_needInitAndSendMsg) {
            testTimeout_producer.initTransactions();
            testTimeout_producer.beginTransaction();
            testTimeout_producer.send(new ProducerRecord(this.topic1(), (Object)"foo".getBytes(), (Object)"bar".getBytes()));
        }
        this.brokers().indices().foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> this.killBroker(i));
        Assertions.assertThrows(TimeoutException.class, () -> testTimeout_timeoutProcess.apply((Object)testTimeout_producer));
        testTimeout_producer.close(Duration.ZERO);
    }

    private void testTimeout(boolean needInitAndSendMsg, Function1<KafkaProducer<byte[], byte[]>, BoxedUnit> timeoutProcess) {
        String x$1 = "transactionProducer";
        long x$2 = 3000L;
        long x$3 = this.createTransactionalProducer$default$2();
        int x$4 = this.createTransactionalProducer$default$4();
        int x$5 = this.createTransactionalProducer$default$5();
        KafkaProducer<byte[], byte[]> producer = this.createTransactionalProducer(x$1, x$3, x$2, x$4, x$5);
        if (needInitAndSendMsg) {
            producer.initTransactions();
            producer.beginTransaction();
            producer.send(new ProducerRecord(this.topic1(), (Object)"foo".getBytes(), (Object)"bar".getBytes()));
        }
        this.brokers().indices().foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> this.killBroker(i));
        Assertions.assertThrows(TimeoutException.class, () -> testTimeout_timeoutProcess.apply((Object)testTimeout_producer));
        producer.close(Duration.ZERO);
    }

    @ParameterizedTest
    @ValueSource(strings={"zk", "kraft", "kraft+kip848"})
    public void testFencingOnSend(String quorum) {
        KafkaProducer producer1 = (KafkaProducer)this.transactionalProducers().apply(0);
        KafkaProducer producer2 = (KafkaProducer)this.transactionalProducers().apply(1);
        Consumer consumer = (Consumer)this.transactionalConsumers().apply(0);
        consumer.subscribe((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)this.topic1(), (List)new .colon.colon((Object)this.topic2(), (List)Nil$.MODULE$))).asJava());
        producer1.initTransactions();
        producer1.beginTransaction();
        producer1.send(TestUtils$.MODULE$.producerRecordWithExpectedTransactionStatus(this.topic1(), null, "1", "1", false));
        producer1.send(TestUtils$.MODULE$.producerRecordWithExpectedTransactionStatus(this.topic2(), null, "3", "3", false));
        producer2.initTransactions();
        producer2.beginTransaction();
        producer2.send(TestUtils$.MODULE$.producerRecordWithExpectedTransactionStatus(this.topic1(), null, "2", "4", true)).get();
        producer2.send(TestUtils$.MODULE$.producerRecordWithExpectedTransactionStatus(this.topic2(), null, "2", "4", true)).get();
        try {
            RecordMetadata recordMetadata = (RecordMetadata)producer1.send(TestUtils$.MODULE$.producerRecordWithExpectedTransactionStatus(this.topic1(), null, "1", "5", false)).get();
            this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(69).append("Missed a producer fenced exception when writing to ").append(recordMetadata.topic()).append("-").append(recordMetadata.partition()).append(". Grab the logs!!").toString());
            this.brokers().foreach((Function1 & Serializable & scala.Serializable)broker -> {
                this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(10).append("log dirs: ").append(((IterableLike)broker.logManager().liveLogDirs().map((Function1 & Serializable & scala.Serializable)x$5 -> x$5.getAbsolutePath(), Seq$.MODULE$.canBuildFrom())).head()).toString());
                return BoxedUnit.UNIT;
            });
            Assertions.fail((String)"Should not be able to send messages from a fenced producer.");
        }
        catch (ProducerFencedException producerFencedException) {
            producer1.close();
        }
        catch (ExecutionException executionException) {
            Assertions.assertTrue((boolean)(executionException.getCause() instanceof InvalidProducerEpochException));
        }
        catch (Exception e) {
            throw new AssertionError("Got an unexpected exception from a fenced producer.", e);
        }
        producer2.commitTransaction();
        TestUtils$.MODULE$.consumeRecords(consumer, 2, TestUtils$.MODULE$.consumeRecords$default$3()).foreach((Function1 & Serializable & scala.Serializable)record -> TestUtils$.MODULE$.assertCommittedAndGetValue((ConsumerRecord<byte[], byte[]>)record));
    }

    @ParameterizedTest
    @ValueSource(strings={"zk", "kraft", "kraft+kip848"})
    public void testFencingOnAddPartitions(String quorum) {
        KafkaProducer producer1 = (KafkaProducer)this.transactionalProducers().apply(0);
        KafkaProducer producer2 = (KafkaProducer)this.transactionalProducers().apply(1);
        Consumer consumer = (Consumer)this.transactionalConsumers().apply(0);
        consumer.subscribe((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)this.topic1(), (List)new .colon.colon((Object)this.topic2(), (List)Nil$.MODULE$))).asJava());
        producer1.initTransactions();
        producer1.beginTransaction();
        producer1.send(TestUtils$.MODULE$.producerRecordWithExpectedTransactionStatus(this.topic1(), null, "1", "1", false));
        producer1.send(TestUtils$.MODULE$.producerRecordWithExpectedTransactionStatus(this.topic2(), null, "3", "3", false));
        producer1.abortTransaction();
        producer2.initTransactions();
        producer2.beginTransaction();
        producer2.send(TestUtils$.MODULE$.producerRecordWithExpectedTransactionStatus(this.topic1(), null, "2", "4", true)).get(20L, TimeUnit.SECONDS);
        producer2.send(TestUtils$.MODULE$.producerRecordWithExpectedTransactionStatus(this.topic2(), null, "2", "4", true)).get(20L, TimeUnit.SECONDS);
        try {
            producer1.beginTransaction();
            RecordMetadata recordMetadata = (RecordMetadata)producer1.send(TestUtils$.MODULE$.producerRecordWithExpectedTransactionStatus(this.topic1(), null, "1", "5", false)).get();
            this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(69).append("Missed a producer fenced exception when writing to ").append(recordMetadata.topic()).append("-").append(recordMetadata.partition()).append(". Grab the logs!!").toString());
            this.brokers().foreach((Function1 & Serializable & scala.Serializable)broker -> {
                this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(10).append("log dirs: ").append(((IterableLike)broker.logManager().liveLogDirs().map((Function1 & Serializable & scala.Serializable)x$6 -> x$6.getAbsolutePath(), Seq$.MODULE$.canBuildFrom())).head()).toString());
                return BoxedUnit.UNIT;
            });
            Assertions.fail((String)"Should not be able to send messages from a fenced producer.");
        }
        catch (ProducerFencedException producerFencedException) {
        }
        catch (ExecutionException executionException) {
            Assertions.assertTrue((boolean)(executionException.getCause() instanceof ProducerFencedException));
        }
        catch (Exception e) {
            throw new AssertionError("Got an unexpected exception from a fenced producer.", e);
        }
        producer2.commitTransaction();
        TestUtils$.MODULE$.consumeRecords(consumer, 2, TestUtils$.MODULE$.consumeRecords$default$3()).foreach((Function1 & Serializable & scala.Serializable)record -> TestUtils$.MODULE$.assertCommittedAndGetValue((ConsumerRecord<byte[], byte[]>)record));
    }

    @ParameterizedTest
    @ValueSource(strings={"zk", "kraft", "kraft+kip848"})
    public void testFencingOnTransactionExpiration(String quorum) {
        KafkaProducer<byte[], byte[]> producer = this.createTransactionalProducer("expiringProducer", 100L, this.createTransactionalProducer$default$3(), this.createTransactionalProducer$default$4(), this.createTransactionalProducer$default$5());
        producer.initTransactions();
        producer.beginTransaction();
        Assertions.assertTrue((boolean)((RecordMetadata)producer.send(TestUtils$.MODULE$.producerRecordWithExpectedTransactionStatus(this.topic1(), null, "1", "1", false)).get()).hasOffset());
        Thread.sleep(600L);
        try {
            producer.send(TestUtils$.MODULE$.producerRecordWithExpectedTransactionStatus(this.topic1(), null, "2", "2", false)).get();
            Assertions.fail((String)"should have raised a ProducerFencedException since the transaction has expired");
        }
        catch (ProducerFencedException producerFencedException) {
        }
        catch (ExecutionException executionException) {
            Assertions.assertTrue((boolean)(executionException.getCause() instanceof ProducerFencedException));
        }
        Consumer nonTransactionalConsumer = (Consumer)this.nonTransactionalConsumers().head();
        nonTransactionalConsumer.subscribe((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)this.topic1(), (List)Nil$.MODULE$)).asJava());
        Seq records = TestUtils$.MODULE$.consumeRecords(nonTransactionalConsumer, 1, TestUtils$.MODULE$.consumeRecords$default$3());
        Assertions.assertEquals((int)1, (int)records.size());
        Assertions.assertEquals((Object)"1", (Object)TestUtils$.MODULE$.recordValueAsString((ConsumerRecord<byte[], byte[]>)((ConsumerRecord)records.head())));
        Consumer transactionalConsumer = (Consumer)this.transactionalConsumers().head();
        transactionalConsumer.subscribe((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)this.topic1(), (List)Nil$.MODULE$)).asJava());
        Assertions.assertTrue((boolean)this.consumeRecordsFor(transactionalConsumer).isEmpty());
    }

    @ParameterizedTest
    @ValueSource(strings={"zk", "kraft", "kraft+kip848"})
    public void testMultipleMarkersOneLeader(String quorum) {
        KafkaProducer firstProducer = (KafkaProducer)this.transactionalProducers().head();
        Consumer consumer = (Consumer)this.transactionalConsumers().head();
        Consumer unCommittedConsumer = (Consumer)this.nonTransactionalConsumers().head();
        String topicWith10Partitions = "largeTopic";
        String topicWith10PartitionsAndOneReplica = "largeTopicOneReplica";
        this.createTopic(topicWith10Partitions, 10, this.brokerCount(), this.topicConfig(), this.createTopic$default$5(), this.createTopic$default$6());
        this.createTopic(topicWith10PartitionsAndOneReplica, 10, 1, new Properties(), this.createTopic$default$5(), this.createTopic$default$6());
        firstProducer.initTransactions();
        firstProducer.beginTransaction();
        this.sendTransactionalMessagesWithValueRange((KafkaProducer<byte[], byte[]>)firstProducer, topicWith10Partitions, 0, 5000, false);
        this.sendTransactionalMessagesWithValueRange((KafkaProducer<byte[], byte[]>)firstProducer, topicWith10PartitionsAndOneReplica, 5000, 10000, false);
        firstProducer.abortTransaction();
        firstProducer.beginTransaction();
        this.sendTransactionalMessagesWithValueRange((KafkaProducer<byte[], byte[]>)firstProducer, topicWith10Partitions, 10000, 11000, true);
        firstProducer.commitTransaction();
        consumer.subscribe((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)topicWith10PartitionsAndOneReplica, (List)new .colon.colon((Object)topicWith10Partitions, (List)Nil$.MODULE$))).asJava());
        unCommittedConsumer.subscribe((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)topicWith10PartitionsAndOneReplica, (List)new .colon.colon((Object)topicWith10Partitions, (List)Nil$.MODULE$))).asJava());
        TestUtils$.MODULE$.consumeRecords(consumer, 1000, TestUtils$.MODULE$.consumeRecords$default$3()).foreach((Function1 & Serializable & scala.Serializable)record -> TestUtils$.MODULE$.assertCommittedAndGetValue((ConsumerRecord<byte[], byte[]>)record));
        Seq allRecords = TestUtils$.MODULE$.consumeRecords(unCommittedConsumer, 11000, TestUtils$.MODULE$.consumeRecords$default$3());
        scala.collection.immutable.Set expectedValues = ((TraversableOnce)package$.MODULE$.Range().apply(0, 11000).map((Function1 & Serializable & scala.Serializable)x$7 -> TransactionsTest.$anonfun$testMultipleMarkersOneLeader$2(BoxesRunTime.unboxToInt((Object)x$7)), IndexedSeq$.MODULE$.canBuildFrom())).toSet();
        allRecords.foreach((Function1 & Serializable & scala.Serializable)record -> {
            TransactionsTest.$anonfun$testMultipleMarkersOneLeader$3(expectedValues, record);
            return BoxedUnit.UNIT;
        });
    }

    @ParameterizedTest
    @ValueSource(strings={"zk", "kraft", "kraft+kip848"})
    public void testConsecutivelyRunInitTransactions(String quorum) {
        KafkaProducer<byte[], byte[]> producer = this.createTransactionalProducer("normalProducer", this.createTransactionalProducer$default$2(), this.createTransactionalProducer$default$3(), this.createTransactionalProducer$default$4(), this.createTransactionalProducer$default$5());
        producer.initTransactions();
        Assertions.assertThrows(IllegalStateException.class, () -> producer.initTransactions());
    }

    @ParameterizedTest
    @ValueSource(strings={"zk", "kraft", "kraft+kip848"})
    public void testBumpTransactionalEpoch(String quorum) {
        String x$1 = "transactionalProducer";
        int x$2 = 5000;
        int x$3 = 5000;
        long x$4 = this.createTransactionalProducer$default$2();
        long x$5 = this.createTransactionalProducer$default$3();
        KafkaProducer<byte[], byte[]> producer = this.createTransactionalProducer(x$1, x$4, x$5, x$2, x$3);
        Consumer consumer = (Consumer)this.transactionalConsumers().head();
        try {
            String testTopic = "test-topic";
            this.createTopic(testTopic, this.numPartitions(), 1, new Properties(), this.createTopic$default$5(), this.createTopic$default$6());
            int partitionLeader = TestUtils$.MODULE$.waitUntilLeaderIsKnown(this.brokers(), new TopicPartition(testTopic, 0), TestUtils$.MODULE$.waitUntilLeaderIsKnown$default$3());
            producer.initTransactions();
            producer.beginTransaction();
            producer.send(TestUtils$.MODULE$.producerRecordWithExpectedTransactionStatus(testTopic, Predef$.MODULE$.int2Integer(0), "4", "4", true));
            producer.commitTransaction();
            LogManager qual$1 = ((KafkaBroker)this.brokers().apply(partitionLeader)).logManager();
            TopicPartition x$6 = new TopicPartition(testTopic, 0);
            boolean x$7 = qual$1.getLog$default$2();
            Iterator activeProducersIter = ((UnifiedLog)qual$1.getLog(x$6, x$7).get()).producerStateManager().activeProducers().entrySet().iterator();
            Assertions.assertTrue((boolean)activeProducersIter.hasNext());
            ProducerStateEntry producerStateEntry = (ProducerStateEntry)activeProducersIter.next().getValue();
            long producerId = producerStateEntry.producerId();
            short initialProducerEpoch = producerStateEntry.producerEpoch();
            producer.beginTransaction();
            producer.send(TestUtils$.MODULE$.producerRecordWithExpectedTransactionStatus(this.topic1(), null, "2", "2", false));
            this.killBroker(partitionLeader);
            Future failedFuture = producer.send(TestUtils$.MODULE$.producerRecordWithExpectedTransactionStatus(testTopic, Predef$.MODULE$.int2Integer(0), "3", "3", false));
            Thread.sleep(6000L);
            this.restartDeadBrokers(this.restartDeadBrokers$default$1());
            TestUtils.assertFutureThrows((Future)failedFuture, TimeoutException.class);
            producer.abortTransaction();
            producer.beginTransaction();
            producer.send(TestUtils$.MODULE$.producerRecordWithExpectedTransactionStatus(this.topic2(), null, "2", "2", true));
            producer.send(TestUtils$.MODULE$.producerRecordWithExpectedTransactionStatus(this.topic1(), null, "4", "4", true));
            producer.send(TestUtils$.MODULE$.producerRecordWithExpectedTransactionStatus(testTopic, Predef$.MODULE$.int2Integer(0), "1", "1", true));
            producer.send(TestUtils$.MODULE$.producerRecordWithExpectedTransactionStatus(testTopic, Predef$.MODULE$.int2Integer(0), "3", "3", true));
            producer.commitTransaction();
            consumer.subscribe((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)this.topic1(), (List)new .colon.colon((Object)this.topic2(), (List)new .colon.colon((Object)testTopic, (List)Nil$.MODULE$)))).asJava());
            TestUtils$.MODULE$.consumeRecords(consumer, 5, TestUtils$.MODULE$.consumeRecords$default$3()).foreach((Function1 & Serializable & scala.Serializable)record -> TestUtils$.MODULE$.assertCommittedAndGetValue((ConsumerRecord<byte[], byte[]>)record));
            LogManager qual$2 = ((KafkaBroker)this.brokers().apply(partitionLeader)).logManager();
            TopicPartition x$8 = new TopicPartition(testTopic, 0);
            boolean x$9 = qual$2.getLog$default$2();
            producerStateEntry = (ProducerStateEntry)((UnifiedLog)qual$2.getLog(x$8, x$9).get()).producerStateManager().activeProducers().get(BoxesRunTime.boxToLong((long)producerId));
            Assertions.assertNotNull((Object)producerStateEntry);
            Assertions.assertTrue((producerStateEntry.producerEpoch() > initialProducerEpoch ? 1 : 0) != 0);
        }
        finally {
            producer.close(Duration.ZERO);
        }
    }

    @ParameterizedTest
    @ValueSource(strings={"zk", "kraft", "kraft+kip848"})
    public void testFailureToFenceEpoch(String quorum) {
        KafkaProducer producer1 = (KafkaProducer)this.transactionalProducers().head();
        String x$1 = "transactional-producer";
        long x$2 = 1000L;
        long x$3 = this.createTransactionalProducer$default$2();
        int x$4 = this.createTransactionalProducer$default$4();
        int x$5 = this.createTransactionalProducer$default$5();
        KafkaProducer<byte[], byte[]> producer2 = this.createTransactionalProducer(x$1, x$3, x$2, x$4, x$5);
        producer1.initTransactions();
        producer1.beginTransaction();
        producer1.send(TestUtils$.MODULE$.producerRecordWithExpectedTransactionStatus(this.topic1(), Predef$.MODULE$.int2Integer(0), "4", "4", true));
        producer1.commitTransaction();
        int partitionLeader = TestUtils$.MODULE$.waitUntilLeaderIsKnown(this.brokers(), new TopicPartition(this.topic1(), 0), TestUtils$.MODULE$.waitUntilLeaderIsKnown$default$3());
        LogManager qual$1 = ((KafkaBroker)this.brokers().apply(partitionLeader)).logManager();
        TopicPartition x$6 = new TopicPartition(this.topic1(), 0);
        boolean x$7 = qual$1.getLog$default$2();
        Iterator activeProducersIter = ((UnifiedLog)qual$1.getLog(x$6, x$7).get()).producerStateManager().activeProducers().entrySet().iterator();
        Assertions.assertTrue((boolean)activeProducersIter.hasNext());
        ProducerStateEntry producerStateEntry = (ProducerStateEntry)activeProducersIter.next().getValue();
        long producerId = producerStateEntry.producerId();
        short initialProducerEpoch = producerStateEntry.producerEpoch();
        this.killBroker(0);
        this.killBroker(1);
        try {
            try {
                producer2.initTransactions();
            }
            catch (TimeoutException timeoutException) {
            }
            catch (Exception e) {
                throw new AssertionError("Got an unexpected exception from initTransactions", e);
            }
        }
        finally {
            producer2.close();
        }
        this.restartDeadBrokers(this.restartDeadBrokers$default$1());
        try {
            try {
                producer1.beginTransaction();
            }
            catch (ProducerFencedException producerFencedException) {
            }
            catch (Exception e) {
                throw new AssertionError("Got an unexpected exception from commitTransaction", e);
            }
        }
        finally {
            producer1.close();
        }
        String x$8 = "transactional-producer";
        long x$9 = 5000L;
        long x$10 = this.createTransactionalProducer$default$2();
        int x$11 = this.createTransactionalProducer$default$4();
        int x$12 = this.createTransactionalProducer$default$5();
        KafkaProducer<byte[], byte[]> producer3 = this.createTransactionalProducer(x$8, x$10, x$9, x$11, x$12);
        producer3.initTransactions();
        producer3.beginTransaction();
        producer3.send(TestUtils$.MODULE$.producerRecordWithExpectedTransactionStatus(this.topic1(), Predef$.MODULE$.int2Integer(0), "4", "4", true));
        producer3.commitTransaction();
        LogManager qual$2 = ((KafkaBroker)this.brokers().apply(partitionLeader)).logManager();
        TopicPartition x$13 = new TopicPartition(this.topic1(), 0);
        boolean x$14 = qual$2.getLog$default$2();
        producerStateEntry = (ProducerStateEntry)((UnifiedLog)qual$2.getLog(x$13, x$14).get()).producerStateManager().activeProducers().get(BoxesRunTime.boxToLong((long)producerId));
        Assertions.assertNotNull((Object)producerStateEntry);
        Assertions.assertEquals((short)((short)(initialProducerEpoch + 1)), (short)producerStateEntry.producerEpoch());
    }

    private void sendTransactionalMessagesWithValueRange(KafkaProducer<byte[], byte[]> producer, String topic, int start, int end, boolean willBeCommitted) {
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(start), end).foreach((Function1 & Serializable & scala.Serializable)i -> TransactionsTest.$anonfun$sendTransactionalMessagesWithValueRange$1(producer, topic, willBeCommitted, BoxesRunTime.unboxToInt((Object)i)));
        producer.flush();
    }

    private Consumer<byte[], byte[]> createReadCommittedConsumer(String group, int maxPollRecords, Properties props) {
        String x$1 = this.bootstrapServers(this.bootstrapServers$default$1());
        boolean x$3 = false;
        boolean x$4 = true;
        String x$6 = TestUtils$.MODULE$.createConsumer$default$3();
        SecurityProtocol x$7 = TestUtils$.MODULE$.createConsumer$default$7();
        Option<File> x$8 = TestUtils$.MODULE$.createConsumer$default$8();
        Option<Properties> x$9 = TestUtils$.MODULE$.createConsumer$default$9();
        ByteArrayDeserializer x$10 = TestUtils$.MODULE$.createConsumer$default$10();
        ByteArrayDeserializer x$11 = TestUtils$.MODULE$.createConsumer$default$11();
        Consumer consumer = TestUtils$.MODULE$.createConsumer(x$1, group, x$6, x$3, x$4, maxPollRecords, x$7, x$8, x$9, x$10, x$11);
        this.transactionalConsumers().$plus$eq(consumer);
        return consumer;
    }

    private String createReadCommittedConsumer$default$1() {
        return "group";
    }

    private int createReadCommittedConsumer$default$2() {
        return 500;
    }

    private Properties createReadCommittedConsumer$default$3() {
        return new Properties();
    }

    private Consumer<byte[], byte[]> createReadUncommittedConsumer(String group) {
        String x$1 = this.bootstrapServers(this.bootstrapServers$default$1());
        boolean x$3 = false;
        String x$4 = TestUtils$.MODULE$.createConsumer$default$3();
        boolean x$5 = TestUtils$.MODULE$.createConsumer$default$5();
        int x$6 = TestUtils$.MODULE$.createConsumer$default$6();
        SecurityProtocol x$7 = TestUtils$.MODULE$.createConsumer$default$7();
        Option<File> x$8 = TestUtils$.MODULE$.createConsumer$default$8();
        Option<Properties> x$9 = TestUtils$.MODULE$.createConsumer$default$9();
        ByteArrayDeserializer x$10 = TestUtils$.MODULE$.createConsumer$default$10();
        ByteArrayDeserializer x$11 = TestUtils$.MODULE$.createConsumer$default$11();
        Consumer consumer = TestUtils$.MODULE$.createConsumer(x$1, group, x$4, x$3, x$5, x$6, x$7, x$8, x$9, x$10, x$11);
        this.nonTransactionalConsumers().$plus$eq(consumer);
        return consumer;
    }

    private KafkaProducer<byte[], byte[]> createTransactionalProducer(String transactionalId, long transactionTimeoutMs, long maxBlockMs, int deliveryTimeoutMs, int requestTimeoutMs) {
        Buffer<KafkaBroker> x$2 = this.brokers();
        int x$7 = TestUtils$.MODULE$.createTransactionalProducer$default$3();
        int x$8 = TestUtils$.MODULE$.createTransactionalProducer$default$8();
        KafkaProducer<byte[], byte[]> producer = TestUtils$.MODULE$.createTransactionalProducer(transactionalId, x$2, x$7, transactionTimeoutMs, maxBlockMs, deliveryTimeoutMs, requestTimeoutMs, x$8);
        this.transactionalProducers().$plus$eq(producer);
        return producer;
    }

    private long createTransactionalProducer$default$2() {
        return 60000L;
    }

    private long createTransactionalProducer$default$3() {
        return 60000L;
    }

    private int createTransactionalProducer$default$4() {
        return 120000;
    }

    private int createTransactionalProducer$default$5() {
        return 30000;
    }

    public void maybeWaitForAtLeastOneSegmentUpload(Seq<TopicPartition> topicPartitions) {
    }

    /*
     * WARNING - void declaration
     */
    public void verifyLogStartOffsets(scala.collection.immutable.Map<TopicPartition, Object> partitionStartOffsets) {
        HashMap offsets = new HashMap();
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!TransactionsTest.$anonfun$verifyLogStartOffsets$1(this, partitionStartOffsets, offsets)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)TransactionsTest.$anonfun$verifyLogStartOffsets$4(partitionStartOffsets, offsets));
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
    }

    /*
     * WARNING - void declaration
     */
    private <K, V> Seq<ConsumerRecord<K, V>> consumeRecordsFor(Consumer<K, V> consumer) {
        int duration = 1000;
        long startTime = System.currentTimeMillis();
        ArrayBuffer records = new ArrayBuffer();
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!TransactionsTest.$anonfun$consumeRecordsFor$1(records, consumer, startTime, duration)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)TransactionsTest.$anonfun$consumeRecordsFor$2(duration));
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        return records;
    }

    public void maybeVerifyLocalLogStartOffsets(scala.collection.immutable.Map<TopicPartition, Long> partitionStartOffsets) throws InterruptedException {
    }

    public static final /* synthetic */ void $anonfun$testBasicTransactions$2(scala.collection.immutable.Set expectedValues$1, ConsumerRecord record) {
        Assertions.assertTrue((boolean)expectedValues$1.contains((Object)TestUtils$.MODULE$.recordValueAsString((ConsumerRecord<byte[], byte[]>)record)));
    }

    public static final /* synthetic */ void $anonfun$testReadCommittedConsumerShouldNotSeeUndecidedData$1(ConsumerRecord record) {
        Assertions.assertEquals((Object)"x", (Object)new String((byte[])record.key()));
        Assertions.assertEquals((Object)"1", (Object)new String((byte[])record.value()));
    }

    public static final /* synthetic */ int $anonfun$sendOffset$5(ConsumerRecord record) {
        return new StringOps(Predef$.MODULE$.augmentString(TestUtils$.MODULE$.assertCommittedAndGetValue((ConsumerRecord<byte[], byte[]>)record))).toInt();
    }

    public static final /* synthetic */ String $anonfun$testOffsetMetadataInSendOffsetsToTransaction$2() {
        return "cannot read committed offset";
    }

    public static final /* synthetic */ String $anonfun$testMultipleMarkersOneLeader$2(int x$7) {
        return Integer.toString(x$7);
    }

    public static final /* synthetic */ void $anonfun$testMultipleMarkersOneLeader$3(scala.collection.immutable.Set expectedValues$2, ConsumerRecord record) {
        Assertions.assertTrue((boolean)expectedValues$2.contains((Object)TestUtils$.MODULE$.recordValueAsString((ConsumerRecord<byte[], byte[]>)record)));
    }

    public static final /* synthetic */ Future $anonfun$sendTransactionalMessagesWithValueRange$1(KafkaProducer producer$4, String topic$1, boolean willBeCommitted$1, int i) {
        String x$3 = Integer.toString(i);
        String x$5 = Integer.toString(i);
        return producer$4.send(TestUtils$.MODULE$.producerRecordWithExpectedTransactionStatus(topic$1, null, x$5, x$3, willBeCommitted$1));
    }

    public static final /* synthetic */ boolean $anonfun$verifyLogStartOffsets$3(KafkaBroker broker$3, HashMap offsets$1, Tuple2 x0$1) {
        if (x0$1 != null) {
            TopicPartition partition = (TopicPartition)x0$1._1();
            int offset = x0$1._2$mcI$sp();
            long lso = ((UnifiedLog)broker$3.replicaManager().localLog(partition).get()).logStartOffset();
            offsets$1.put(Predef$.MODULE$.int2Integer(broker$3.config().brokerId()), Predef$.MODULE$.long2Long(lso));
            return (long)offset == lso;
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ boolean $anonfun$verifyLogStartOffsets$1(TransactionsTest $this, scala.collection.immutable.Map partitionStartOffsets$1, HashMap offsets$1) {
        return $this.brokers().forall((Function1 & Serializable & scala.Serializable)broker -> BoxesRunTime.boxToBoolean((boolean)partitionStartOffsets$1.forall((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)TransactionsTest.$anonfun$verifyLogStartOffsets$3(broker, offsets$1, x0$1)))));
    }

    public static final /* synthetic */ String $anonfun$verifyLogStartOffsets$4(scala.collection.immutable.Map partitionStartOffsets$1, HashMap offsets$1) {
        return new StringBuilder(78).append("log start offset doesn't change to the expected position: ").append(partitionStartOffsets$1).append(", current position: ").append(offsets$1).toString();
    }

    public static final /* synthetic */ boolean $anonfun$consumeRecordsFor$1(ArrayBuffer records$2, Consumer consumer$2, long startTime$1, int duration$1) {
        records$2.$plus$plus$eq((TraversableOnce)CollectionConverters$.MODULE$.iterableAsScalaIterableConverter((Iterable)consumer$2.poll(Duration.ofMillis(50L))).asScala());
        return System.currentTimeMillis() - startTime$1 > (long)duration$1;
    }

    public static final /* synthetic */ String $anonfun$consumeRecordsFor$2(int duration$1) {
        return new StringBuilder(52).append("The timeout ").append(duration$1).append(" was greater than the maximum wait time.").toString();
    }

    public TransactionsTest() {
        this.transactionalProducerCount = 2;
        this.transactionalConsumerCount = 1;
        this.nonTransactionalConsumerCount = 1;
        this.topic1 = "topic1";
        this.topic2 = "topic2";
        this.numPartitions = 4;
    }

    public static final /* synthetic */ Object $anonfun$testSendOffsetsWithGroupId$1$adapted(KafkaProducer producer, String groupId, Consumer consumer) {
        producer.sendOffsetsToTransaction((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter(TestUtils$.MODULE$.consumerPositions((Consumer<byte[], byte[]>)consumer)).asJava(), groupId);
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$testSendOffsetsWithGroupMetadata$1$adapted(KafkaProducer producer, String x$4, Consumer consumer) {
        producer.sendOffsetsToTransaction((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter(TestUtils$.MODULE$.consumerPositions((Consumer<byte[], byte[]>)consumer)).asJava(), consumer.groupMetadata());
        return BoxedUnit.UNIT;
    }
}

