/*
 * Decompiled with CFR 0.152.
 */
package kafka.cluster;

import java.io.File;
import java.io.Serializable;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicInteger;
import kafka.cluster.AbstractPartitionTest$;
import kafka.cluster.AlterPartitionListener;
import kafka.cluster.DelayedOperations;
import kafka.cluster.Partition;
import kafka.cluster.Partition$;
import kafka.log.LogManager;
import kafka.log.UnifiedLog;
import kafka.server.AlterPartitionManager;
import kafka.server.MetadataCache;
import kafka.server.checkpoints.OffsetCheckpoints;
import kafka.server.metadata.MockConfigRepository;
import kafka.server.metadata.MockConfigRepository$;
import kafka.utils.TestUtils;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.message.LeaderAndIsrRequestData;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.server.common.MetadataVersion;
import org.apache.kafka.server.util.MockTime;
import org.apache.kafka.storage.internals.log.CleanerConfig;
import org.apache.kafka.storage.internals.log.LogConfig;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.Set;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\t\u0005v!B\"E\u0011\u0003Ie!B&E\u0011\u0003a\u0005\"B*\u0002\t\u0003!\u0006bB+\u0002\u0005\u0004%\tA\u0016\u0005\u00075\u0006\u0001\u000b\u0011B,\u0007\t-#\u0005a\u0017\u0005\u0006'\u0016!\t\u0001\u0018\u0005\b+\u0016\u0011\r\u0011\"\u0001W\u0011\u0019QV\u0001)A\u0005/\"9a,\u0002b\u0001\n\u00031\u0006BB0\u0006A\u0003%q\u000bC\u0004a\u000b\t\u0007I\u0011A1\t\r5,\u0001\u0015!\u0003c\u0011\u001dqWA1A\u0005\u0002=Da\u0001_\u0003!\u0002\u0013\u0001\b\"C=\u0006\u0001\u0004\u0005\r\u0011\"\u0001{\u0011-\t9!\u0002a\u0001\u0002\u0004%\t!!\u0003\t\u0015\u0005UQ\u00011A\u0001B\u0003&1\u0010\u0003\u0006\u0002\u0018\u0015\u0001\r\u00111A\u0005\u0002iD1\"!\u0007\u0006\u0001\u0004\u0005\r\u0011\"\u0001\u0002\u001c!Q\u0011qD\u0003A\u0002\u0003\u0005\u000b\u0015B>\t\u0015\u0005\u0005R\u00011AA\u0002\u0013\u0005!\u0010C\u0006\u0002$\u0015\u0001\r\u00111A\u0005\u0002\u0005\u0015\u0002BCA\u0015\u000b\u0001\u0007\t\u0011)Q\u0005w\"Y\u00111F\u0003A\u0002\u0003\u0007I\u0011AA\u0017\u0011-\tY$\u0002a\u0001\u0002\u0004%\t!!\u0010\t\u0017\u0005\u0005S\u00011A\u0001B\u0003&\u0011q\u0006\u0005\f\u0003\u0007*\u0001\u0019!a\u0001\n\u0003\t)\u0005C\u0006\u0002h\u0015\u0001\r\u00111A\u0005\u0002\u0005%\u0004bCA7\u000b\u0001\u0007\t\u0011)Q\u0005\u0003\u000fB1\"a\u001c\u0006\u0001\u0004\u0005\r\u0011\"\u0001\u0002r!Y\u0011QV\u0003A\u0002\u0003\u0007I\u0011AAX\u0011-\t\u0019,\u0002a\u0001\u0002\u0003\u0006K!a\u001d\t\u0017\u0005UV\u00011AA\u0002\u0013\u0005\u0011q\u0017\u0005\f\u0003\u0017,\u0001\u0019!a\u0001\n\u0003\ti\rC\u0006\u0002R\u0016\u0001\r\u0011!Q!\n\u0005e\u0006bCAj\u000b\u0001\u0007\t\u0019!C\u0001\u0003+D1\"!:\u0006\u0001\u0004\u0005\r\u0011\"\u0001\u0002h\"Y\u00111^\u0003A\u0002\u0003\u0005\u000b\u0015BAl\u0011%\ti/\u0002b\u0001\n\u0003\ty\u000f\u0003\u0005\u0002x\u0016\u0001\u000b\u0011BAy\u0011%\tI0\u0002b\u0001\n\u0003\tY\u0010\u0003\u0005\u0003\u0006\u0015\u0001\u000b\u0011BA\u007f\u0011%\u00119!\u0002b\u0001\n\u0003\u0011I\u0001\u0003\u0005\u0003\u0018\u0015\u0001\u000b\u0011\u0002B\u0006\u0011-\u0011I\"\u0002a\u0001\u0002\u0004%\tAa\u0007\t\u0017\t\rR\u00011AA\u0002\u0013\u0005!Q\u0005\u0005\f\u0005S)\u0001\u0019!A!B\u0013\u0011i\u0002C\u0004\u0003,\u0015!\t!!*\t\u000f\t\rS\u0001\"\u0005\u0003F!9!\u0011K\u0003\u0005\u0002\tM\u0003b\u0002B<\u000b\u0011\u0005\u0011Q\u0015\u0005\b\u0005\u0003+A\u0011\u0003BB\u0011\u001d\u0011\u0019*\u0002C\u0001\u0005+CqAa(\u0006\t\u0013\t\tI\u0002\u0004\u0002x\u0015\u0001\u0011\u0011\u0010\u0005\u0007'^\"\t!!!\t\u0013\u0005\ruG1A\u0005\u0002\u0005\u0015\u0005\u0002CAMo\u0001\u0006I!a\"\t\u0013\u0005muG1A\u0005\u0002\u0005\u0015\u0005\u0002CAOo\u0001\u0006I!a\"\t\u0013\u0005}uG1A\u0005\u0002\u0005\u0015\u0005\u0002CAQo\u0001\u0006I!a\"\t\u000f\u0005\rv\u0007\"\u0011\u0002&\"9\u0011qU\u001c\u0005B\u0005\u0015\u0006bBAUo\u0011\u0005\u0013Q\u0015\u0005\b\u0003W;D\u0011AAS\u0003U\t%m\u001d;sC\u000e$\b+\u0019:uSRLwN\u001c+fgRT!!\u0012$\u0002\u000f\rdWo\u001d;fe*\tq)A\u0003lC\u001a\\\u0017m\u0001\u0001\u0011\u0005)\u000bQ\"\u0001#\u0003+\u0005\u00137\u000f\u001e:bGR\u0004\u0016M\u001d;ji&|g\u000eV3tiN\u0011\u0011!\u0014\t\u0003\u001dFk\u0011a\u0014\u0006\u0002!\u0006)1oY1mC&\u0011!k\u0014\u0002\u0007\u0003:L(+\u001a4\u0002\rqJg.\u001b;?)\u0005I\u0015\u0001\u00032s_.,'/\u00133\u0016\u0003]\u0003\"A\u0014-\n\u0005e{%aA%oi\u0006I!M]8lKJLE\rI\n\u0003\u000b5#\u0012!\u0018\t\u0003\u0015\u0016\tqB]3n_R,'+\u001a9mS\u000e\f\u0017\nZ\u0001\u0011e\u0016lw\u000e^3SKBd\u0017nY1JI\u0002\na\u0002^8qS\u000e\u0004\u0016M\u001d;ji&|g.F\u0001c!\t\u00197.D\u0001e\u0015\t)g-\u0001\u0004d_6lwN\u001c\u0006\u0003\u000f\u001eT!\u0001[5\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005Q\u0017aA8sO&\u0011A\u000e\u001a\u0002\u000f)>\u0004\u0018n\u0019)beRLG/[8o\u0003=!x\u000e]5d!\u0006\u0014H/\u001b;j_:\u0004\u0013\u0001\u0002;j[\u0016,\u0012\u0001\u001d\t\u0003cZl\u0011A\u001d\u0006\u0003gR\fA!\u001e;jY*\u0011QOZ\u0001\u0007g\u0016\u0014h/\u001a:\n\u0005]\u0014(\u0001C'pG.$\u0016.\\3\u0002\u000bQLW.\u001a\u0011\u0002\rQl\u0007\u000fR5s+\u0005Y\bc\u0001?\u0002\u00045\tQP\u0003\u0002\u007f\u007f\u0006\u0011\u0011n\u001c\u0006\u0003\u0003\u0003\tAA[1wC&\u0019\u0011QA?\u0003\t\u0019KG.Z\u0001\u000bi6\u0004H)\u001b:`I\u0015\fH\u0003BA\u0006\u0003#\u00012ATA\u0007\u0013\r\tya\u0014\u0002\u0005+:LG\u000f\u0003\u0005\u0002\u0014A\t\t\u00111\u0001|\u0003\rAH%M\u0001\bi6\u0004H)\u001b:!\u0003\u001dawn\u001a#jeF\n1\u0002\\8h\t&\u0014\u0018g\u0018\u0013fcR!\u00111BA\u000f\u0011!\t\u0019bEA\u0001\u0002\u0004Y\u0018\u0001\u00037pO\u0012K'/\r\u0011\u0002\u000f1|w\rR5se\u0005YAn\\4ESJ\u0014t\fJ3r)\u0011\tY!a\n\t\u0011\u0005Ma#!AA\u0002m\f\u0001\u0002\\8h\t&\u0014(\u0007I\u0001\u000bY><W*\u00198bO\u0016\u0014XCAA\u0018!\u0011\t\t$a\u000e\u000e\u0005\u0005M\"bAA\u001b\r\u0006\u0019An\\4\n\t\u0005e\u00121\u0007\u0002\u000b\u0019><W*\u00198bO\u0016\u0014\u0018A\u00047pO6\u000bg.Y4fe~#S-\u001d\u000b\u0005\u0003\u0017\ty\u0004C\u0005\u0002\u0014e\t\t\u00111\u0001\u00020\u0005YAn\\4NC:\fw-\u001a:!\u0003U\tG\u000e^3s!\u0006\u0014H/\u001b;j_:l\u0015M\\1hKJ,\"!a\u0012\u0011\t\u0005%\u0013\u0011\r\b\u0005\u0003\u0017\nYF\u0004\u0003\u0002N\u0005]c\u0002BA(\u0003+j!!!\u0015\u000b\u0007\u0005M\u0003*\u0001\u0004=e>|GOP\u0005\u0002\u000f&\u0019\u0011\u0011\f$\u0002\u000bU$\u0018\u000e\\:\n\t\u0005u\u0013qL\u0001\n)\u0016\u001cH/\u0016;jYNT1!!\u0017G\u0013\u0011\t\u0019'!\u001a\u000335{7m[!mi\u0016\u0014\b+\u0019:uSRLwN\\'b]\u0006<WM\u001d\u0006\u0005\u0003;\ny&A\rbYR,'\u000fU1si&$\u0018n\u001c8NC:\fw-\u001a:`I\u0015\fH\u0003BA\u0006\u0003WB\u0011\"a\u0005\u001d\u0003\u0003\u0005\r!a\u0012\u0002-\u0005dG/\u001a:QCJ$\u0018\u000e^5p]6\u000bg.Y4fe\u0002\na#\u00197uKJ\u0004\u0016M\u001d;ji&|g\u000eT5ti\u0016tWM]\u000b\u0003\u0003g\u00022!!\u001e8\u001b\u0005)!AG'pG.\fE\u000e^3s!\u0006\u0014H/\u001b;j_:d\u0015n\u001d;f]\u0016\u00148\u0003B\u001cN\u0003w\u00022ASA?\u0013\r\ty\b\u0012\u0002\u0017\u00032$XM\u001d)beRLG/[8o\u0019&\u001cH/\u001a8feR\u0011\u00111O\u0001\bKb\u0004\u0018M\u001c3t+\t\t9\t\u0005\u0003\u0002\n\u0006UUBAAF\u0015\u0011\ti)a$\u0002\r\u0005$x.\\5d\u0015\u0011\t\t*a%\u0002\u0015\r|gnY;se\u0016tGO\u0003\u0002t\u007f&!\u0011qSAF\u00055\tEo\\7jG&sG/Z4fe\u0006AQ\r\u001f9b]\u0012\u001c\b%A\u0004tQJLgn[:\u0002\u0011MD'/\u001b8lg\u0002\n\u0001BZ1jYV\u0014Xm]\u0001\nM\u0006LG.\u001e:fg\u0002\nQ\"\\1sW&\u001b(/\u0012=qC:$GCAA\u0006\u00035i\u0017M]6JgJ\u001c\u0006N]5oW\u0006QQ.\u0019:l\r\u0006LG.\u001a3\u0002\u000bI,7/\u001a;\u00025\u0005dG/\u001a:QCJ$\u0018\u000e^5p]2K7\u000f^3oKJ|F%Z9\u0015\t\u0005-\u0011\u0011\u0017\u0005\n\u0003'y\u0012\u0011!a\u0001\u0003g\nq#\u00197uKJ\u0004\u0016M\u001d;ji&|g\u000eT5ti\u0016tWM\u001d\u0011\u0002\u00131|wmQ8oM&<WCAA]!\u0011\tY,a2\u000e\u0005\u0005u&\u0002BA\u001b\u0003\u007fSA!!1\u0002D\u0006I\u0011N\u001c;fe:\fGn\u001d\u0006\u0004\u0003\u000b4\u0017aB:u_J\fw-Z\u0005\u0005\u0003\u0013\fiLA\u0005M_\u001e\u001cuN\u001c4jO\u0006iAn\\4D_:4\u0017nZ0%KF$B!a\u0003\u0002P\"I\u00111\u0003\u0012\u0002\u0002\u0003\u0007\u0011\u0011X\u0001\u000bY><7i\u001c8gS\u001e\u0004\u0013\u0001E2p]\u001aLwMU3q_NLGo\u001c:z+\t\t9\u000e\u0005\u0003\u0002Z\u0006\u0005XBAAn\u0015\u0011\ti.a8\u0002\u00115,G/\u00193bi\u0006T!!\u001e$\n\t\u0005\r\u00181\u001c\u0002\u0015\u001b>\u001c7nQ8oM&<'+\u001a9pg&$xN]=\u0002)\r|gNZ5h%\u0016\u0004xn]5u_JLx\fJ3r)\u0011\tY!!;\t\u0013\u0005MQ%!AA\u0002\u0005]\u0017!E2p]\u001aLwMU3q_NLGo\u001c:zA\u0005\tB-\u001a7bs\u0016$w\n]3sCRLwN\\:\u0016\u0005\u0005E\bc\u0001&\u0002t&\u0019\u0011Q\u001f#\u0003#\u0011+G.Y=fI>\u0003XM]1uS>t7/\u0001\neK2\f\u00170\u001a3Pa\u0016\u0014\u0018\r^5p]N\u0004\u0013!D7fi\u0006$\u0017\r^1DC\u000eDW-\u0006\u0002\u0002~B!\u0011q B\u0001\u001b\t\ty.\u0003\u0003\u0003\u0004\u0005}'!D'fi\u0006$\u0017\r^1DC\u000eDW-\u0001\bnKR\fG-\u0019;b\u0007\u0006\u001c\u0007.\u001a\u0011\u0002#=4gm]3u\u0007\",7m\u001b9pS:$8/\u0006\u0002\u0003\fA!!Q\u0002B\n\u001b\t\u0011yA\u0003\u0003\u0003\u0012\u0005}\u0017aC2iK\u000e\\\u0007o\\5oiNLAA!\u0006\u0003\u0010\t\trJ\u001a4tKR\u001c\u0005.Z2la>Lg\u000e^:\u0002%=4gm]3u\u0007\",7m\u001b9pS:$8\u000fI\u0001\na\u0006\u0014H/\u001b;j_:,\"A!\b\u0011\u0007)\u0013y\"C\u0002\u0003\"\u0011\u0013\u0011\u0002U1si&$\u0018n\u001c8\u0002\u001bA\f'\u000f^5uS>tw\fJ3r)\u0011\tYAa\n\t\u0013\u0005Ma&!AA\u0002\tu\u0011A\u00039beRLG/[8oA\u0005)1/\u001a;va\"\u001a\u0001Ga\f\u0011\t\tE\"qH\u0007\u0003\u0005gQAA!\u000e\u00038\u0005\u0019\u0011\r]5\u000b\t\te\"1H\u0001\bUV\u0004\u0018\u000e^3s\u0015\r\u0011i$[\u0001\u0006UVt\u0017\u000e^\u0005\u0005\u0005\u0003\u0012\u0019D\u0001\u0006CK\u001a|'/Z#bG\"\f!$\u001b8uKJ\u0014%o\\6feB\u0013x\u000e^8d_24VM]:j_:,\"Aa\u0012\u0011\t\t%#QJ\u0007\u0003\u0005\u0017R!!\u001a;\n\t\t=#1\n\u0002\u0010\u001b\u0016$\u0018\rZ1uCZ+'o]5p]\u0006\u00192M]3bi\u0016dun\u001a)s_B,'\u000f^5fgR!!Q\u000bB/!\u0011\u00119F!\u0017\u000e\u0005\u0005M\u0015\u0002\u0002B.\u0003'\u0013!\u0002\u0015:pa\u0016\u0014H/[3t\u0011\u001d\u0011yF\ra\u0001\u0005C\n\u0011b\u001c<feJLG-Z:\u0011\u0011\t\r$1\u000eB9\u0005crAA!\u001a\u0003hA\u0019\u0011qJ(\n\u0007\t%t*\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0005[\u0012yGA\u0002NCBT1A!\u001bP!\u0011\u0011\u0019Ga\u001d\n\t\tU$q\u000e\u0002\u0007'R\u0014\u0018N\\4\u0002\u0011Q,\u0017M\u001d#po:D3a\rB>!\u0011\u0011\tD! \n\t\t}$1\u0007\u0002\n\u0003\u001a$XM]#bG\"\fqc]3ukB\u0004\u0016M\u001d;ji&|gnV5uQ6{7m[:\u0015\r\tu!Q\u0011BE\u0011\u0019\u00119\t\u000ea\u0001/\u0006YA.Z1eKJ,\u0005o\\2i\u0011\u001d\u0011Y\t\u000ea\u0001\u0005\u001b\u000b\u0001\"[:MK\u0006$WM\u001d\t\u0004\u001d\n=\u0015b\u0001BI\u001f\n9!i\\8mK\u0006t\u0017A\u00053fM\u0006,H\u000e\u001e\"s_.,'/\u00129pG\"$BAa&\u0003\u001eB\u0019aJ!'\n\u0007\tmuJ\u0001\u0003M_:<\u0007\"B+6\u0001\u00049\u0016aF2sK\u0006$X-S:s\u0007\"\fgnZ3MSN$XM\\3s\u0001")
public class AbstractPartitionTest {
    private final int brokerId = AbstractPartitionTest$.MODULE$.brokerId();
    private final int remoteReplicaId = this.brokerId() + 1;
    private final TopicPartition topicPartition = new TopicPartition("test-topic", 0);
    private final MockTime time = new MockTime();
    private File tmpDir;
    private File logDir1;
    private File logDir2;
    private LogManager logManager;
    private TestUtils.MockAlterPartitionManager alterPartitionManager;
    private MockAlterPartitionListener alterPartitionListener;
    private LogConfig logConfig;
    private MockConfigRepository configRepository;
    private final DelayedOperations delayedOperations = (DelayedOperations)Mockito.mock(DelayedOperations.class);
    private final MetadataCache metadataCache = (MetadataCache)Mockito.mock(MetadataCache.class);
    private final OffsetCheckpoints offsetCheckpoints = (OffsetCheckpoints)Mockito.mock(OffsetCheckpoints.class);
    private Partition partition;

    public int brokerId() {
        return this.brokerId;
    }

    public int remoteReplicaId() {
        return this.remoteReplicaId;
    }

    public TopicPartition topicPartition() {
        return this.topicPartition;
    }

    public MockTime time() {
        return this.time;
    }

    public File tmpDir() {
        return this.tmpDir;
    }

    public void tmpDir_$eq(File x$1) {
        this.tmpDir = x$1;
    }

    public File logDir1() {
        return this.logDir1;
    }

    public void logDir1_$eq(File x$1) {
        this.logDir1 = x$1;
    }

    public File logDir2() {
        return this.logDir2;
    }

    public void logDir2_$eq(File x$1) {
        this.logDir2 = x$1;
    }

    public LogManager logManager() {
        return this.logManager;
    }

    public void logManager_$eq(LogManager x$1) {
        this.logManager = x$1;
    }

    public TestUtils.MockAlterPartitionManager alterPartitionManager() {
        return this.alterPartitionManager;
    }

    public void alterPartitionManager_$eq(TestUtils.MockAlterPartitionManager x$1) {
        this.alterPartitionManager = x$1;
    }

    public MockAlterPartitionListener alterPartitionListener() {
        return this.alterPartitionListener;
    }

    public void alterPartitionListener_$eq(MockAlterPartitionListener x$1) {
        this.alterPartitionListener = x$1;
    }

    public LogConfig logConfig() {
        return this.logConfig;
    }

    public void logConfig_$eq(LogConfig x$1) {
        this.logConfig = x$1;
    }

    public MockConfigRepository configRepository() {
        return this.configRepository;
    }

    public void configRepository_$eq(MockConfigRepository x$1) {
        this.configRepository = x$1;
    }

    public DelayedOperations delayedOperations() {
        return this.delayedOperations;
    }

    public MetadataCache metadataCache() {
        return this.metadataCache;
    }

    public OffsetCheckpoints offsetCheckpoints() {
        return this.offsetCheckpoints;
    }

    public Partition partition() {
        return this.partition;
    }

    public void partition_$eq(Partition x$1) {
        this.partition = x$1;
    }

    @BeforeEach
    public void setup() {
        TestUtils$.MODULE$.clearYammerMetrics();
        Properties logProps = this.createLogProperties((scala.collection.immutable.Map<String, String>)Predef$.MODULE$.Map().empty());
        this.logConfig_$eq(new LogConfig((Map)logProps));
        this.configRepository_$eq(MockConfigRepository$.MODULE$.forTopic(this.topicPartition().topic(), logProps));
        this.tmpDir_$eq(TestUtils$.MODULE$.tempDir());
        this.logDir1_$eq(TestUtils$.MODULE$.randomPartitionLogDir(this.tmpDir()));
        this.logDir2_$eq(TestUtils$.MODULE$.randomPartitionLogDir(this.tmpDir()));
        .colon.colon x$1 = new .colon.colon((Object)this.logDir1(), (List)new .colon.colon((Object)this.logDir2(), (List)Nil$.MODULE$));
        LogConfig x$2 = this.logConfig();
        MockConfigRepository x$3 = this.configRepository();
        CleanerConfig x$4 = new CleanerConfig(false);
        MockTime x$5 = this.time();
        MetadataVersion x$6 = this.interBrokerProtocolVersion();
        boolean x$7 = true;
        int x$8 = TestUtils$.MODULE$.createLogManager$default$7();
        Option<UnifiedLog> x$9 = TestUtils$.MODULE$.createLogManager$default$9();
        boolean x$10 = TestUtils$.MODULE$.createLogManager$default$10();
        long x$11 = TestUtils$.MODULE$.createLogManager$default$11();
        this.logManager_$eq(TestUtils$.MODULE$.createLogManager((Seq<File>)x$1, x$2, x$3, x$4, x$5, x$6, x$8, x$7, x$9, x$10, x$11));
        LogManager qual$1 = this.logManager();
        scala.collection.immutable.Set x$12 = Predef$.MODULE$.Set().empty();
        Function1 x$13 = qual$1.startup$default$2();
        qual$1.startup((Set)x$12, x$13);
        this.alterPartitionManager_$eq(TestUtils$.MODULE$.createAlterIsrManager());
        this.alterPartitionListener_$eq(this.createIsrChangeListener());
        this.partition_$eq(new Partition(this.topicPartition(), 30000L, this.interBrokerProtocolVersion(), this.brokerId(), (Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> this.defaultBrokerEpoch(this.brokerId()), (Time)this.time(), (AlterPartitionListener)this.alterPartitionListener(), this.delayedOperations(), this.metadataCache(), this.logManager(), (AlterPartitionManager)this.alterPartitionManager(), Partition$.MODULE$.$lessinit$greater$default$12()));
        Mockito.when((Object)this.offsetCheckpoints().fetch(ArgumentMatchers.anyString(), (TopicPartition)ArgumentMatchers.eq((Object)this.topicPartition()))).thenReturn((Object)None$.MODULE$);
    }

    public MetadataVersion interBrokerProtocolVersion() {
        return MetadataVersion.latestTesting();
    }

    public Properties createLogProperties(scala.collection.immutable.Map<String, String> overrides) {
        Properties logProps = new Properties();
        logProps.put("segment.bytes", Predef$.MODULE$.int2Integer(512));
        logProps.put("segment.index.bytes", Predef$.MODULE$.int2Integer(1000));
        logProps.put("retention.ms", Predef$.MODULE$.int2Integer(999));
        overrides.foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            if (x0$1 != null) {
                String k = (String)x0$1._1();
                String v = (String)x0$1._2();
                return logProps.put(k, v);
            }
            throw new MatchError(null);
        });
        return logProps;
    }

    @AfterEach
    public void tearDown() {
        if (this.tmpDir().exists()) {
            LogManager qual$1 = this.logManager();
            long x$1 = qual$1.shutdown$default$1();
            qual$1.shutdown(x$1);
            Utils.delete((File)this.tmpDir());
            TestUtils$.MODULE$.clearYammerMetrics();
            return;
        }
    }

    public Partition setupPartitionWithMocks(int leaderEpoch, boolean isLeader) {
        Partition qual$1 = this.partition();
        boolean x$1 = false;
        boolean x$2 = false;
        OffsetCheckpoints x$3 = this.offsetCheckpoints();
        None$ x$4 = None$.MODULE$;
        Option x$5 = qual$1.createLogIfNotExists$default$5();
        qual$1.createLogIfNotExists(x$1, x$2, x$3, (Option)x$4, x$5);
        int controllerEpoch = 0;
        java.util.List replicas = (java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)Predef$.MODULE$.int2Integer(this.brokerId()), (List)new .colon.colon((Object)Predef$.MODULE$.int2Integer(this.remoteReplicaId()), (List)Nil$.MODULE$))).asJava();
        if (isLeader) {
            Partition qual$2 = this.partition();
            LeaderAndIsrRequestData.LeaderAndIsrPartitionState x$6 = new LeaderAndIsrRequestData.LeaderAndIsrPartitionState().setControllerEpoch(controllerEpoch).setLeader(this.brokerId()).setLeaderEpoch(leaderEpoch).setIsr(replicas).setPartitionEpoch(1).setReplicas(replicas).setIsNew(true);
            OffsetCheckpoints x$7 = this.offsetCheckpoints();
            None$ x$8 = None$.MODULE$;
            Option x$9 = qual$2.makeLeader$default$4();
            Assertions.assertTrue((boolean)qual$2.makeLeader(x$6, x$7, (Option)x$8, x$9), (String)"Expected become leader transition to succeed");
            Assertions.assertEquals((int)leaderEpoch, (int)this.partition().getLeaderEpoch());
        } else {
            Partition qual$3 = this.partition();
            LeaderAndIsrRequestData.LeaderAndIsrPartitionState x$10 = new LeaderAndIsrRequestData.LeaderAndIsrPartitionState().setControllerEpoch(controllerEpoch).setLeader(this.remoteReplicaId()).setLeaderEpoch(leaderEpoch).setIsr(replicas).setPartitionEpoch(1).setReplicas(replicas).setIsNew(true);
            OffsetCheckpoints x$11 = this.offsetCheckpoints();
            None$ x$12 = None$.MODULE$;
            Option x$13 = qual$3.makeFollower$default$4();
            Assertions.assertTrue((boolean)qual$3.makeFollower(x$10, x$11, (Option)x$12, x$13), (String)"Expected become follower transition to succeed");
            Assertions.assertEquals((int)leaderEpoch, (int)this.partition().getLeaderEpoch());
            Assertions.assertEquals((Object)None$.MODULE$, (Object)this.partition().leaderLogIfLocal());
        }
        return this.partition();
    }

    public long defaultBrokerEpoch(int brokerId) {
        return (long)brokerId + 1000L;
    }

    private MockAlterPartitionListener createIsrChangeListener() {
        return new MockAlterPartitionListener();
    }

    public class MockAlterPartitionListener
    implements AlterPartitionListener {
        private final AtomicInteger expands;
        private final AtomicInteger shrinks;
        private final AtomicInteger failures;

        public AtomicInteger expands() {
            return this.expands;
        }

        public AtomicInteger shrinks() {
            return this.shrinks;
        }

        public AtomicInteger failures() {
            return this.failures;
        }

        public void markIsrExpand() {
            this.expands().incrementAndGet();
        }

        public void markIsrShrink() {
            this.shrinks().incrementAndGet();
        }

        public void markFailed() {
            this.failures().incrementAndGet();
        }

        public void reset() {
            this.expands().set(0);
            this.shrinks().set(0);
            this.failures().set(0);
        }

        public /* synthetic */ AbstractPartitionTest kafka$cluster$AbstractPartitionTest$MockAlterPartitionListener$$$outer() {
            return AbstractPartitionTest.this;
        }

        public MockAlterPartitionListener() {
            if (AbstractPartitionTest.this == null) {
                throw null;
            }
            this.expands = new AtomicInteger(0);
            this.shrinks = new AtomicInteger(0);
            this.failures = new AtomicInteger(0);
        }
    }
}

