/*
 * Decompiled with CFR 0.152.
 */
package kafka.cluster;

import kafka.cluster.Replica;
import kafka.cluster.ReplicaState;
import kafka.cluster.ReplicaTest$;
import kafka.log.UnifiedLog$;
import kafka.server.MetadataCache;
import kafka.server.metadata.KRaftMetadataCache;
import kafka.server.metadata.ZkMetadataCache;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.NotLeaderOrFollowerException;
import org.apache.kafka.server.util.MockTime;
import org.apache.kafka.storage.internals.log.LogOffsetMetadata;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;
import org.mockito.Mockito;
import scala.Function0;
import scala.Option;
import scala.Option$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u00055v!\u0002\u0011\"\u0011\u00031c!\u0002\u0015\"\u0011\u0003I\u0003\"\u0002\u0019\u0002\t\u0003\t\u0004b\u0002\u001a\u0002\u0005\u0004%\ta\r\u0005\u0007o\u0005\u0001\u000b\u0011\u0002\u001b\t\u000fa\n!\u0019!C\u0001s!1Q)\u0001Q\u0001\niBqAR\u0001C\u0002\u0013\u0005q\t\u0003\u0004L\u0003\u0001\u0006I\u0001\u0013\u0004\u0005Q\u0005\u0002A\nC\u00031\u0013\u0011\u0005Q\nC\u0004P\u0013\t\u0007I\u0011\u0001)\t\reK\u0001\u0015!\u0003R\u0011%Q\u0016\u00021AA\u0002\u0013\u00051\fC\u0005`\u0013\u0001\u0007\t\u0019!C\u0001A\"Ia-\u0003a\u0001\u0002\u0003\u0006K\u0001\u0018\u0005\u0006O&!\t\u0001\u001b\u0005\u0006i&!I!\u001e\u0005\n\u0003\u0017I\u0011\u0013!C\u0005\u0003\u001bAq!a\t\n\t\u0003\t)\u0003C\u0004\u00022%!I!a\r\t\u000f\u0005\u0005\u0013\u0002\"\u0003\u0002D!9\u0011QK\u0005\u0005\n\u0005]\u0003BBA.\u0013\u0011\u0005\u0001\u000e\u0003\u0004\u0002f%!\t\u0001\u001b\u0005\u0007\u0003SJA\u0011\u00015\t\r\u00055\u0014\u0002\"\u0001i\u0011\u0019\t\t(\u0003C\u0001Q\"1\u0011QO\u0005\u0005\u0002!Da!!\u001f\n\t\u0003A\u0007BBA?\u0013\u0011\u0005\u0001\u000eC\u0004\u0002\u0002&!\t!a!\u0002\u0017I+\u0007\u000f\\5dCR+7\u000f\u001e\u0006\u0003E\r\nqa\u00197vgR,'OC\u0001%\u0003\u0015Y\u0017MZ6b\u0007\u0001\u0001\"aJ\u0001\u000e\u0003\u0005\u00121BU3qY&\u001c\u0017\rV3tiN\u0011\u0011A\u000b\t\u0003W9j\u0011\u0001\f\u0006\u0002[\u0005)1oY1mC&\u0011q\u0006\f\u0002\u0007\u0003:L(+\u001a4\u0002\rqJg.\u001b;?)\u00051\u0013\u0001\u0003\"s_.,'/\u00133\u0016\u0003Q\u0002\"aK\u001b\n\u0005Yb#aA%oi\u0006I!I]8lKJLE\rI\u0001\n!\u0006\u0014H/\u001b;j_:,\u0012A\u000f\t\u0003w\rk\u0011\u0001\u0010\u0006\u0003{y\naaY8n[>t'B\u0001\u0013@\u0015\t\u0001\u0015)\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002\u0005\u0006\u0019qN]4\n\u0005\u0011c$A\u0004+pa&\u001c\u0007+\u0019:uSRLwN\\\u0001\u000b!\u0006\u0014H/\u001b;j_:\u0004\u0013a\u0005*fa2L7-\u0019'bORKW.Z'bq6\u001bX#\u0001%\u0011\u0005-J\u0015B\u0001&-\u0005\u0011auN\\4\u0002)I+\u0007\u000f\\5dC2\u000bw\rV5nK6\u000b\u00070T:!'\tI!\u0006F\u0001O!\t9\u0013\"\u0001\u0003uS6,W#A)\u0011\u0005I;V\"A*\u000b\u0005Q+\u0016\u0001B;uS2T!A\u0016 \u0002\rM,'O^3s\u0013\tA6K\u0001\u0005N_\u000e\\G+[7f\u0003\u0015!\u0018.\\3!\u0003\u001d\u0011X\r\u001d7jG\u0006,\u0012\u0001\u0018\t\u0003OuK!AX\u0011\u0003\u000fI+\u0007\u000f\\5dC\u0006Y!/\u001a9mS\u000e\fw\fJ3r)\t\tG\r\u0005\u0002,E&\u00111\r\f\u0002\u0005+:LG\u000fC\u0004f\u001d\u0005\u0005\t\u0019\u0001/\u0002\u0007a$\u0013'\u0001\u0005sKBd\u0017nY1!\u0003\u0015\u0019X\r^;q)\u0005\t\u0007F\u0001\tk!\tY'/D\u0001m\u0015\tig.A\u0002ba&T!a\u001c9\u0002\u000f),\b/\u001b;fe*\u0011\u0011/Q\u0001\u0006UVt\u0017\u000e^\u0005\u0003g2\u0014!BQ3g_J,W)Y2i\u0003I\t7o]3siJ+\u0007\u000f\\5dCN#\u0018\r^3\u0015\u0011\u00054\bP\u001f?\u007f\u0003\u0003AQa^\tA\u0002!\u000ba\u0002\\8h'R\f'\u000f^(gMN,G\u000fC\u0003z#\u0001\u0007\u0001*\u0001\u0007m_\u001e,e\u000eZ(gMN,G\u000fC\u0003|#\u0001\u0007\u0001*\u0001\nmCN$8)Y;hQR,\u0006\u000fV5nK6\u001b\b\"B?\u0012\u0001\u0004A\u0015a\u00077bgR4U\r^2i\u0019\u0016\fG-\u001a:M_\u001e,e\u000eZ(gMN,G\u000fC\u0003\u0000#\u0001\u0007\u0001*A\bmCN$h)\u001a;dQRKW.Z't\u0011%\t\u0019!\u0005I\u0001\u0002\u0004\t)!A\u0006ce>\\WM]#q_\u000eD\u0007\u0003B\u0016\u0002\b!K1!!\u0003-\u0005\u0019y\u0005\u000f^5p]\u0006a\u0012m]:feR\u0014V\r\u001d7jG\u0006\u001cF/\u0019;fI\u0011,g-Y;mi\u00122TCAA\bU\u0011\t)!!\u0005,\u0005\u0005M\u0001\u0003BA\u000b\u0003?i!!a\u0006\u000b\t\u0005e\u00111D\u0001\nk:\u001c\u0007.Z2lK\u0012T1!!\b-\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0003C\t9BA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\fq$Y:tKJ$(+\u001a9mS\u000e\f7\u000b^1uK\u0012{Wm\u001d(pi\u000eC\u0017M\\4f)\r\t\u0017q\u0005\u0005\t\u0003S\u0019B\u00111\u0001\u0002,\u0005\u0011q\u000e\u001d\t\u0005W\u00055\u0012-C\u0002\u000201\u0012\u0001\u0002\u00102z]\u0006lWMP\u0001\u0011kB$\u0017\r^3GKR\u001c\u0007n\u0015;bi\u0016$r\u0001SA\u001b\u0003s\ti\u0004\u0003\u0004\u00028Q\u0001\r\u0001S\u0001\u0014M>dGn\\<fe\u001a+Go\u00195PM\u001a\u001cX\r\u001e\u0005\u0007\u0003w!\u0002\u0019\u0001%\u0002'\u0019|G\u000e\\8xKJ\u001cF/\u0019:u\u001f\u001a47/\u001a;\t\r\u0005}B\u00031\u0001I\u0003=aW-\u00193fe\u0016sGm\u00144gg\u0016$\u0018!\u0005:fg\u0016$(+\u001a9mS\u000e\f7\u000b^1uKR9\u0001*!\u0012\u0002H\u0005E\u0003BBA +\u0001\u0007\u0001\nC\u0004\u0002JU\u0001\r!a\u0013\u0002\u0017%\u001ch*Z<MK\u0006$WM\u001d\t\u0004W\u00055\u0013bAA(Y\t9!i\\8mK\u0006t\u0007bBA*+\u0001\u0007\u00111J\u0001\u0011SN4u\u000e\u001c7po\u0016\u0014\u0018J\\*z]\u000e\f!\"[:DCV<\u0007\u000e^+q)\u0011\tY%!\u0017\t\r\u0005}b\u00031\u0001I\u0003A!Xm\u001d;J]&$\u0018.\u00197Ti\u0006$X\rK\u0002\u0018\u0003?\u00022a[A1\u0013\r\t\u0019\u0007\u001c\u0002\u0005)\u0016\u001cH/\u0001\u000buKN$X\u000b\u001d3bi\u00164U\r^2i'R\fG/\u001a\u0015\u00041\u0005}\u0013\u0001\u0010;fgR\u0014Vm]3u%\u0016\u0004H.[2b'R\fG/Z,iK:dU-\u00193fe&\u001b(+Z3mK\u000e$X\rZ!oIJ+\u0007\u000f\\5dC&\u001b\u0018J\\*z]\u000eD3!GA0\u0003}\"Xm\u001d;SKN,GOU3qY&\u001c\u0017m\u0015;bi\u0016<\u0006.\u001a8MK\u0006$WM]%t%\u0016,G.Z2uK\u0012\fe\u000e\u001a*fa2L7-Y%t\u001d>$\u0018J\\*z]\u000eD3AGA0\u0003u\"Xm\u001d;SKN,GOU3qY&\u001c\u0017m\u0015;bi\u0016<\u0006.\u001a8OK^dU-\u00193fe&\u001bX\t\\3di\u0016$\u0017I\u001c3SKBd\u0017nY1Jg&s7+\u001f8dQ\rY\u0012qL\u0001Ai\u0016\u001cHOU3tKR\u0014V\r\u001d7jG\u0006\u001cF/\u0019;f/\",gNT3x\u0019\u0016\fG-\u001a:Jg\u0016cWm\u0019;fI\u0006sGMU3qY&\u001c\u0017-S:O_RLenU=oG\"\u001aA$a\u0018\u0002WQ,7\u000f^%t\u0007\u0006,x\r\u001b;Va^CWM\u001c*fa2L7-Y%t\u0007\u0006,x\r\u001b;VaR{Gj\\4F]\u0012D3!HA0\u00039\"Xm\u001d;Jg\u000e\u000bWo\u001a5u+B<\u0006.\u001a8SKBd\u0017nY1Jg:{GoQ1vO\"$X\u000b\u001d+p\u0019><WI\u001c3)\u0007y\ty&A\u000buKN$h)\u001a8dKN#\u0018\r\\3Va\u0012\fG/Z:\u0015\u0007\u0005\f)\tC\u0004\u0002\b~\u0001\r!a\u0013\u0002\u000f%\u001c8J]1gi\":q$a#\u0002\u001c\u0006u\u0005\u0003BAG\u0003/k!!a$\u000b\t\u0005E\u00151S\u0001\taJ|g/\u001b3fe*\u0019\u0011Q\u00138\u0002\rA\f'/Y7t\u0013\u0011\tI*a$\u0003\u0017Y\u000bG.^3T_V\u00148-Z\u0001\tE>|G.Z1og2\"\u0011qTAQ3\u0005\t\u0011$\u0001\u0001)\u0007}\t)\u000b\u0005\u0003\u0002(\u0006%VBAAJ\u0013\u0011\tY+a%\u0003#A\u000b'/Y7fi\u0016\u0014\u0018N_3e)\u0016\u001cH\u000f")
public class ReplicaTest {
    private final MockTime time = new MockTime();
    private Replica replica;

    public static long ReplicaLagTimeMaxMs() {
        return ReplicaTest$.MODULE$.ReplicaLagTimeMaxMs();
    }

    public static TopicPartition Partition() {
        return ReplicaTest$.MODULE$.Partition();
    }

    public static int BrokerId() {
        return ReplicaTest$.MODULE$.BrokerId();
    }

    public MockTime time() {
        return this.time;
    }

    public Replica replica() {
        return this.replica;
    }

    public void replica_$eq(Replica x$1) {
        this.replica = x$1;
    }

    @BeforeEach
    public void setup() {
        KRaftMetadataCache metadataCache = (KRaftMetadataCache)Mockito.mock(KRaftMetadataCache.class);
        Mockito.when((Object)metadataCache.getAliveBrokerEpoch(ReplicaTest$.MODULE$.BrokerId())).thenReturn((Object)Option$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)1L)));
        this.replica_$eq(new Replica(ReplicaTest$.MODULE$.BrokerId(), ReplicaTest$.MODULE$.Partition(), (MetadataCache)metadataCache));
    }

    private void assertReplicaState(long logStartOffset, long logEndOffset, long lastCaughtUpTimeMs, long lastFetchLeaderLogEndOffset, long lastFetchTimeMs, Option<Object> brokerEpoch) {
        ReplicaState replicaState = this.replica().stateSnapshot();
        Assertions.assertEquals((long)logStartOffset, (long)replicaState.logStartOffset(), (String)"Unexpected Log Start Offset");
        Assertions.assertEquals((long)logEndOffset, (long)replicaState.logEndOffset(), (String)"Unexpected Log End Offset");
        Assertions.assertEquals((long)lastCaughtUpTimeMs, (long)replicaState.lastCaughtUpTimeMs(), (String)"Unexpected Last Caught Up Time");
        Assertions.assertEquals((long)lastFetchLeaderLogEndOffset, (long)replicaState.lastFetchLeaderLogEndOffset(), (String)"Unexpected Last Fetch Leader Log End Offset");
        Assertions.assertEquals((long)lastFetchTimeMs, (long)replicaState.lastFetchTimeMs(), (String)"Unexpected Last Fetch Time");
        Assertions.assertEquals(brokerEpoch, (Object)replicaState.brokerEpoch(), (String)"Broker Epoch Mismatch");
    }

    private Option<Object> assertReplicaState$default$6() {
        return Option$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)1L));
    }

    public void assertReplicaStateDoesNotChange(Function0<BoxedUnit> op) {
        ReplicaState previousState = this.replica().stateSnapshot();
        op.apply$mcV$sp();
        this.assertReplicaState(previousState.logStartOffset(), previousState.logEndOffset(), previousState.lastCaughtUpTimeMs(), previousState.lastFetchLeaderLogEndOffset(), previousState.lastFetchTimeMs(), this.assertReplicaState$default$6());
    }

    private long updateFetchState(long followerFetchOffset, long followerStartOffset, long leaderEndOffset) {
        long currentTimeMs = this.time().milliseconds();
        this.replica().updateFetchStateOrThrow(new LogOffsetMetadata(followerFetchOffset), followerStartOffset, currentTimeMs, leaderEndOffset, 1L);
        return currentTimeMs;
    }

    private long resetReplicaState(long leaderEndOffset, boolean isNewLeader, boolean isFollowerInSync) {
        long currentTimeMs = this.time().milliseconds();
        this.replica().resetReplicaState(currentTimeMs, leaderEndOffset, isNewLeader, isFollowerInSync);
        return currentTimeMs;
    }

    private boolean isCaughtUp(long leaderEndOffset) {
        return this.replica().stateSnapshot().isCaughtUp(leaderEndOffset, this.time().milliseconds(), ReplicaTest$.MODULE$.ReplicaLagTimeMaxMs());
    }

    @Test
    public void testInitialState() {
        this.assertReplicaState(UnifiedLog$.MODULE$.UnknownOffset(), UnifiedLog$.MODULE$.UnknownOffset(), 0L, 0L, 0L, (Option<Object>)Option$.MODULE$.empty());
    }

    @Test
    public void testUpdateFetchState() {
        long fetchTimeMs1 = this.updateFetchState(5L, 1L, 10L);
        this.assertReplicaState(1L, 5L, 0L, 10L, fetchTimeMs1, this.assertReplicaState$default$6());
        long fetchTimeMs2 = this.updateFetchState(10L, 2L, 15L);
        this.assertReplicaState(2L, 10L, fetchTimeMs1, 15L, fetchTimeMs2, this.assertReplicaState$default$6());
        long fetchTimeMs3 = this.updateFetchState(15L, 3L, 15L);
        this.assertReplicaState(3L, 15L, fetchTimeMs3, 15L, fetchTimeMs3, this.assertReplicaState$default$6());
    }

    @Test
    public void testResetReplicaStateWhenLeaderIsReelectedAndReplicaIsInSync() {
        this.updateFetchState(10L, 1L, 10L);
        long resetTimeMs1 = this.resetReplicaState(11L, false, true);
        this.assertReplicaState(1L, 10L, resetTimeMs1, 11L, resetTimeMs1, this.assertReplicaState$default$6());
    }

    @Test
    public void testResetReplicaStateWhenLeaderIsReelectedAndReplicaIsNotInSync() {
        this.updateFetchState(10L, 1L, 10L);
        this.resetReplicaState(11L, false, false);
        this.assertReplicaState(1L, 10L, 0L, 11L, 0L, this.assertReplicaState$default$6());
    }

    @Test
    public void testResetReplicaStateWhenNewLeaderIsElectedAndReplicaIsInSync() {
        this.updateFetchState(10L, 1L, 10L);
        long resetTimeMs1 = this.resetReplicaState(11L, true, true);
        this.assertReplicaState(UnifiedLog$.MODULE$.UnknownOffset(), UnifiedLog$.MODULE$.UnknownOffset(), resetTimeMs1, UnifiedLog$.MODULE$.UnknownOffset(), 0L, (Option<Object>)Option$.MODULE$.empty());
    }

    @Test
    public void testResetReplicaStateWhenNewLeaderIsElectedAndReplicaIsNotInSync() {
        this.updateFetchState(10L, 1L, 10L);
        this.resetReplicaState(11L, true, false);
        this.assertReplicaState(UnifiedLog$.MODULE$.UnknownOffset(), UnifiedLog$.MODULE$.UnknownOffset(), 0L, UnifiedLog$.MODULE$.UnknownOffset(), 0L, (Option<Object>)Option$.MODULE$.empty());
    }

    @Test
    public void testIsCaughtUpWhenReplicaIsCaughtUpToLogEnd() {
        Assertions.assertFalse((boolean)this.isCaughtUp(10L));
        this.updateFetchState(10L, 1L, 10L);
        Assertions.assertTrue((boolean)this.isCaughtUp(10L));
        this.time().sleep(ReplicaTest$.MODULE$.ReplicaLagTimeMaxMs() + 1L);
        Assertions.assertTrue((boolean)this.isCaughtUp(10L));
    }

    @Test
    public void testIsCaughtUpWhenReplicaIsNotCaughtUpToLogEnd() {
        Assertions.assertFalse((boolean)this.isCaughtUp(10L));
        this.updateFetchState(5L, 1L, 10L);
        Assertions.assertFalse((boolean)this.isCaughtUp(10L));
        this.updateFetchState(10L, 1L, 15L);
        Assertions.assertTrue((boolean)this.isCaughtUp(16L));
        this.time().sleep(ReplicaTest$.MODULE$.ReplicaLagTimeMaxMs() + 1L);
        Assertions.assertFalse((boolean)this.isCaughtUp(16L));
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    public void testFenceStaleUpdates(boolean isKraft) {
        MetadataCache metadataCache;
        if (isKraft) {
            KRaftMetadataCache kRaftMetadataCache = (KRaftMetadataCache)Mockito.mock(KRaftMetadataCache.class);
            Mockito.when((Object)kRaftMetadataCache.getAliveBrokerEpoch(ReplicaTest$.MODULE$.BrokerId())).thenReturn((Object)Option$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)2L)));
            metadataCache = kRaftMetadataCache;
        } else {
            metadataCache = (MetadataCache)Mockito.mock(ZkMetadataCache.class);
        }
        MetadataCache metadataCache2 = metadataCache;
        Replica replica = new Replica(ReplicaTest$.MODULE$.BrokerId(), ReplicaTest$.MODULE$.Partition(), metadataCache2);
        replica.updateFetchStateOrThrow(new LogOffsetMetadata(5L), 1L, 1L, 10L, 2L);
        if (isKraft) {
            Assertions.assertThrows(NotLeaderOrFollowerException.class, () -> replica.updateFetchStateOrThrow(new LogOffsetMetadata(5L), 2L, 3L, 10L, 1L));
        } else {
            replica.updateFetchStateOrThrow(new LogOffsetMetadata(5L), 2L, 3L, 10L, 1L);
        }
        replica.updateFetchStateOrThrow(new LogOffsetMetadata(5L), 2L, 4L, 10L, -1L);
    }
}

