/*
 * Decompiled with CFR 0.152.
 */
package kafka.controller;

import java.io.Serializable;
import java.util.Properties;
import kafka.api.LeaderAndIsr;
import kafka.api.LeaderAndIsr$;
import kafka.cluster.Broker;
import kafka.controller.AbstractControllerBrokerRequestBatch;
import kafka.controller.ControlledShutdownPartitionLeaderElectionStrategy$;
import kafka.controller.ControllerBrokerRequestBatch;
import kafka.controller.ControllerContext;
import kafka.controller.DeletionClient;
import kafka.controller.LeaderIsrAndControllerEpoch;
import kafka.controller.MockPartitionStateMachine;
import kafka.controller.MockReplicaStateMachine;
import kafka.controller.NewPartition$;
import kafka.controller.NonExistentPartition$;
import kafka.controller.OfflinePartition$;
import kafka.controller.OfflinePartitionLeaderElectionStrategy;
import kafka.controller.OfflineReplica$;
import kafka.controller.OnlinePartition$;
import kafka.controller.PartitionAndReplica;
import kafka.controller.PartitionState;
import kafka.controller.PartitionStateMachine;
import kafka.controller.PreferredReplicaPartitionLeaderElectionStrategy$;
import kafka.controller.ReplicaAssignment;
import kafka.controller.ReplicaAssignment$;
import kafka.controller.ReplicaState;
import kafka.controller.ReplicaStateMachine;
import kafka.controller.StateChangeLogger;
import kafka.controller.TopicDeletionManager;
import kafka.controller.ZkPartitionStateMachine;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.utils.TestUtils$;
import kafka.zk.KafkaZkClient;
import kafka.zk.TopicPartitionStateZNode$;
import kafka.zookeeper.CreateResponse;
import kafka.zookeeper.GetDataResponse;
import kafka.zookeeper.ResponseMetadata;
import kafka.zookeeper.ZooKeeperClientException;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.server.common.MetadataVersion;
import org.apache.kafka.storage.internals.log.LogConfig;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.data.Stat;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Set;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map$;
import scala.collection.immutable.Nil$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\t}d\u0001B\u001b7\u0001mBQA\u0011\u0001\u0005\u0002\rC\u0011B\u0012\u0001A\u0002\u0003\u0007I\u0011B$\t\u0013-\u0003\u0001\u0019!a\u0001\n\u0013a\u0005\"\u0003*\u0001\u0001\u0004\u0005\t\u0015)\u0003I\u0011%\u0019\u0006\u00011AA\u0002\u0013%A\u000bC\u0005\\\u0001\u0001\u0007\t\u0019!C\u00059\"Ia\f\u0001a\u0001\u0002\u0003\u0006K!\u0016\u0005\n?\u0002\u0001\r\u00111A\u0005\n\u0001D\u0011\u0002\u001a\u0001A\u0002\u0003\u0007I\u0011B3\t\u0013\u001d\u0004\u0001\u0019!A!B\u0013\t\u0007\"\u00035\u0001\u0001\u0004\u0005\r\u0011\"\u0003j\u0011%i\u0007\u00011AA\u0002\u0013%a\u000eC\u0005q\u0001\u0001\u0007\t\u0011)Q\u0005U\"9\u0011\u000f\u0001b\u0001\n\u0013\u0011\bB\u0002<\u0001A\u0003%1\u000fC\u0004x\u0001\t\u0007I\u0011\u0002=\t\r}\u0004\u0001\u0015!\u0003z\u0011!\t\t\u0001\u0001b\u0001\n\u0013\u0011\bbBA\u0002\u0001\u0001\u0006Ia\u001d\u0005\n\u0003\u000b\u0001!\u0019!C\u0005\u0003\u000fA\u0001\"a\b\u0001A\u0003%\u0011\u0011\u0002\u0005\n\u0003C\u0001!\u0019!C\u0005\u0003GA\u0001\"!\r\u0001A\u0003%\u0011Q\u0005\u0005\b\u0003g\u0001A\u0011AA\u001b\u0011\u001d\ti\u0005\u0001C\u0005\u0003\u001fBq!!\u0017\u0001\t\u0003\t)\u0004C\u0004\u0002d\u0001!\t!!\u000e\t\u000f\u0005\u001d\u0004\u0001\"\u0001\u00026!9\u00111\u000e\u0001\u0005\u0002\u0005U\u0002bBA8\u0001\u0011\u0005\u0011Q\u0007\u0005\b\u0003g\u0002A\u0011AA\u001b\u0011\u001d\t9\b\u0001C\u0001\u0003kAq!a\u001f\u0001\t\u0003\t)\u0004C\u0004\u0002\u0000\u0001!\t!!\u000e\t\u000f\u0005\r\u0005\u0001\"\u0001\u00026!9\u0011q\u0011\u0001\u0005\u0002\u0005U\u0002bBAF\u0001\u0011\u0005\u0011Q\u0007\u0005\b\u0003\u001f\u0003A\u0011AA\u001b\u0011\u001d\t\u0019\n\u0001C\u0001\u0003kAq!a&\u0001\t\u0003\tI\nC\u0004\u0002J\u0002!\t!!\u000e\t\u000f\u00055\u0007\u0001\"\u0001\u00026!9\u0011\u0011\u001b\u0001\u0005\u0002\u0005U\u0002bBAk\u0001\u0011\u0005\u0011Q\u0007\u0005\b\u00033\u0004A\u0011BAn\u0011\u001d\t)\u0010\u0001C\u0001\u0003kAq!!?\u0001\t\u0003\t)\u0004C\u0004\u0002~\u0002!\t!!\u000e\t\u000f\t\u0005\u0001\u0001\"\u0003\u0003\u0004!9!\u0011\u0003\u0001\u0005\n\tM\u0001\"\u0003B1\u0001E\u0005I\u0011\u0002B2\u0011%\u0011I\bAI\u0001\n\u0013\u0011YHA\rQCJ$\u0018\u000e^5p]N#\u0018\r^3NC\u000eD\u0017N\\3UKN$(BA\u001c9\u0003)\u0019wN\u001c;s_2dWM\u001d\u0006\u0002s\u0005)1.\u00194lC\u000e\u00011C\u0001\u0001=!\ti\u0004)D\u0001?\u0015\u0005y\u0014!B:dC2\f\u0017BA!?\u0005\u0019\te.\u001f*fM\u00061A(\u001b8jiz\"\u0012\u0001\u0012\t\u0003\u000b\u0002i\u0011AN\u0001\u0012G>tGO]8mY\u0016\u00148i\u001c8uKb$X#\u0001%\u0011\u0005\u0015K\u0015B\u0001&7\u0005E\u0019uN\u001c;s_2dWM]\"p]R,\u0007\u0010^\u0001\u0016G>tGO]8mY\u0016\u00148i\u001c8uKb$x\fJ3r)\ti\u0005\u000b\u0005\u0002>\u001d&\u0011qJ\u0010\u0002\u0005+:LG\u000fC\u0004R\u0007\u0005\u0005\t\u0019\u0001%\u0002\u0007a$\u0013'\u0001\nd_:$(o\u001c7mKJ\u001cuN\u001c;fqR\u0004\u0013\u0001D7pG.T6n\u00117jK:$X#A+\u0011\u0005YKV\"A,\u000b\u0005aC\u0014A\u0001>l\u0013\tQvKA\u0007LC\u001a\\\u0017MW6DY&,g\u000e^\u0001\u0011[>\u001c7NW6DY&,g\u000e^0%KF$\"!T/\t\u000fE3\u0011\u0011!a\u0001+\u0006iQn\\2l5.\u001cE.[3oi\u0002\n\u0001%\\8dW\u000e{g\u000e\u001e:pY2,'O\u0011:pW\u0016\u0014(+Z9vKN$()\u0019;dQV\t\u0011\r\u0005\u0002FE&\u00111M\u000e\u0002\u001d\u0007>tGO]8mY\u0016\u0014(I]8lKJ\u0014V-];fgR\u0014\u0015\r^2i\u0003\u0011jwnY6D_:$(o\u001c7mKJ\u0014%o\\6feJ+\u0017/^3ti\n\u000bGo\u00195`I\u0015\fHCA'g\u0011\u001d\t\u0016\"!AA\u0002\u0005\f\u0011%\\8dW\u000e{g\u000e\u001e:pY2,'O\u0011:pW\u0016\u0014(+Z9vKN$()\u0019;dQ\u0002\nQ\u0003]1si&$\u0018n\u001c8Ti\u0006$X-T1dQ&tW-F\u0001k!\t)5.\u0003\u0002mm\t)\u0002+\u0019:uSRLwN\\*uCR,W*Y2iS:,\u0017!\u00079beRLG/[8o'R\fG/Z'bG\"Lg.Z0%KF$\"!T8\t\u000fEc\u0011\u0011!a\u0001U\u00061\u0002/\u0019:uSRLwN\\*uCR,W*Y2iS:,\u0007%\u0001\u0005ce>\\WM]%e+\u0005\u0019\bCA\u001fu\u0013\t)hHA\u0002J]R\f\u0011B\u0019:pW\u0016\u0014\u0018\n\u001a\u0011\u0002\r\r|gNZ5h+\u0005I\bC\u0001>~\u001b\u0005Y(B\u0001?9\u0003\u0019\u0019XM\u001d<fe&\u0011ap\u001f\u0002\f\u0017\u000647.Y\"p]\u001aLw-A\u0004d_:4\u0017n\u001a\u0011\u0002\u001f\r|g\u000e\u001e:pY2,'/\u00129pG\"\f\u0001cY8oiJ|G\u000e\\3s\u000bB|7\r\u001b\u0011\u0002\u0013A\f'\u000f^5uS>tWCAA\u0005!\u0011\tY!a\u0007\u000e\u0005\u00055!\u0002BA\b\u0003#\taaY8n[>t'bA\u001d\u0002\u0014)!\u0011QCA\f\u0003\u0019\t\u0007/Y2iK*\u0011\u0011\u0011D\u0001\u0004_J<\u0017\u0002BA\u000f\u0003\u001b\u0011a\u0002V8qS\u000e\u0004\u0016M\u001d;ji&|g.\u0001\u0006qCJ$\u0018\u000e^5p]\u0002\n!\u0002]1si&$\u0018n\u001c8t+\t\t)\u0003\u0005\u0004\u0002(\u00055\u0012\u0011B\u0007\u0003\u0003SQ1!a\u000b?\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0005\u0003_\tICA\u0002TKF\f1\u0002]1si&$\u0018n\u001c8tA\u0005)1/\u001a;VaR\tQ\nK\u0002\u0019\u0003s\u0001B!a\u000f\u0002J5\u0011\u0011Q\b\u0006\u0005\u0003\u007f\t\t%A\u0002ba&TA!a\u0011\u0002F\u00059!.\u001e9ji\u0016\u0014(\u0002BA$\u0003/\tQA[;oSRLA!a\u0013\u0002>\tQ!)\u001a4pe\u0016,\u0015m\u00195\u0002\u001dA\f'\u000f^5uS>t7\u000b^1uKR!\u0011\u0011KA,!\r)\u00151K\u0005\u0004\u0003+2$A\u0004)beRLG/[8o'R\fG/\u001a\u0005\b\u0003\u000bI\u0002\u0019AA\u0005\u0003A\"Xm\u001d;O_:,\u00070[:uK:$\b+\u0019:uSRLwN\u001c+p\u001d\u0016<\b+\u0019:uSRLwN\u001c+sC:\u001c\u0018\u000e^5p]\"\u001a!$!\u0018\u0011\t\u0005m\u0012qL\u0005\u0005\u0003C\niD\u0001\u0003UKN$\u0018A\u000f;fgRLeN^1mS\u0012tuN\\3ySN$XM\u001c;QCJ$\u0018\u000e^5p]R{wJ\u001c7j]\u0016\u0004\u0016M\u001d;ji&|g\u000e\u0016:b]NLG/[8oQ\rY\u0012QL\u0001<i\u0016\u001cH/\u00138wC2LGMT8oKbL7\u000f^3oiB\u000b'\u000f^5uS>tGk\\(gM2Lg.\u001a)beRLG/[8o)J\fgn]5uS>t\u0007f\u0001\u000f\u0002^\u0005YC/Z:u\u001d\u0016<\b+\u0019:uSRLwN\u001c+p\u001f:d\u0017N\\3QCJ$\u0018\u000e^5p]R\u0013\u0018M\\:ji&|g\u000eK\u0002\u001e\u0003;\n1\u000b^3ti:+w\u000fU1si&$\u0018n\u001c8U_>sG.\u001b8f!\u0006\u0014H/\u001b;j_:$&/\u00198tSRLwN\u001c.p_.+W\r]3s\u00072LWM\u001c;Fq\u000e,\u0007\u000f^5p]\u001a\u0013x.\\\"sK\u0006$Xm\u0015;bi\u0016\u001c\bf\u0001\u0010\u0002^\u0005!E/Z:u\u001d\u0016<\b+\u0019:uSRLwN\u001c+p\u001f:d\u0017N\\3QCJ$\u0018\u000e^5p]R\u0013\u0018M\\:ji&|g.\u0012:s_J\u001cu\u000eZ3Ge>l7I]3bi\u0016\u001cF/\u0019;fg\"\u001aq$!\u0018\u0002YQ,7\u000f\u001e(foB\u000b'\u000f^5uS>tGk\\(gM2Lg.\u001a)beRLG/[8o)J\fgn]5uS>t\u0007f\u0001\u0011\u0002^\u00059D/Z:u\u0013:4\u0018\r\\5e\u001d\u0016<\b+\u0019:uSRLwN\u001c+p\u001d>tW\r_5ti\u0016tG\u000fU1si&$\u0018n\u001c8Ue\u0006t7/\u001b;j_:D3!IA/\u0003\u0015\"Xm\u001d;P]2Lg.\u001a)beRLG/[8o)>|e\u000e\\5oKR\u0013\u0018M\\:ji&|g\u000eK\u0002#\u0003;\n!\b^3ti>sG.\u001b8f!\u0006\u0014H/\u001b;j_:$vn\u00148mS:,GK]1og&$\u0018n\u001c8G_J\u001cuN\u001c;s_2dW\rZ*ikR$wn\u001e8)\u0007\r\ni&\u0001\u0014uKN$xJ\u001c7j]\u0016\u0004\u0016M\u001d;ji&|g\u000eV8PM\u001ad\u0017N\\3Ue\u0006t7/\u001b;j_:D3\u0001JA/\u0003i\"Xm\u001d;J]Z\fG.\u001b3P]2Lg.\u001a)beRLG/[8o)>tuN\\3ySN$XM\u001c;QCJ$\u0018\u000e^5p]R\u0013\u0018M\\:ji&|g\u000eK\u0002&\u0003;\n!\u0007^3ti&sg/\u00197jI>sG.\u001b8f!\u0006\u0014H/\u001b;j_:$vNT3x!\u0006\u0014H/\u001b;j_:$&/\u00198tSRLwN\u001c\u0015\u0004M\u0005u\u0013a\f;fgR|eM\u001a7j]\u0016\u0004\u0016M\u001d;ji&|g\u000eV8P]2Lg.\u001a)beRLG/[8o)J\fgn]5uS>t\u0007fA\u0014\u0002^\u00051D/Z:u\u001f\u001a4G.\u001b8f!\u0006\u0014H/\u001b;j_:$v.\u00168dY\u0016\fgn\u00148mS:,\u0007+\u0019:uSRLwN\u001c+sC:\u001c\u0018\u000e^5p]R\u0019Q*a'\t\u000f\u0005u\u0005\u00061\u0001\u0002 \u0006I\u0012n\u001d'fC\u0012,'OU3d_Z,'/_*vaB|'\u000f^3e!\ri\u0014\u0011U\u0005\u0004\u0003Gs$a\u0002\"p_2,\u0017M\u001c\u0015\bQ\u0005\u001d\u0016qWA]!\u0011\tI+a-\u000e\u0005\u0005-&\u0002BAW\u0003_\u000b\u0001\u0002\u001d:pm&$WM\u001d\u0006\u0005\u0003c\u000b\t%\u0001\u0004qCJ\fWn]\u0005\u0005\u0003k\u000bYKA\u0006WC2,XmU8ve\u000e,\u0017\u0001\u00032p_2,\u0017M\\:-\t\u0005m\u0016QX\r\u0002\u0003e\t\u0001\u0001K\u0002)\u0003\u0003\u0004B!a1\u0002F6\u0011\u0011qV\u0005\u0005\u0003\u000f\fyKA\tQCJ\fW.\u001a;fe&TX\r\u001a+fgR\fa\u000b^3ti>3g\r\\5oKB\u000b'\u000f^5uS>tGk\\(oY&tW\rU1si&$\u0018n\u001c8Ue\u0006t7/\u001b;j_:Tvn\\&fKB,'o\u00117jK:$X\t_2faRLwN\u001c$s_6\u001cF/\u0019;f\u0019>|7.\u001e9)\u0007%\ni&A$uKN$xJ\u001a4mS:,\u0007+\u0019:uSRLwN\u001c+p\u001f:d\u0017N\\3QCJ$\u0018\u000e^5p]R\u0013\u0018M\\:ji&|g.\u0012:s_J\u001cu\u000eZ3Ge>l7\u000b^1uK2{wn[;qQ\rQ\u0013QL\u00015i\u0016\u001cHo\u00144gY&tW\rU1si&$\u0018n\u001c8U_:{g.\u001a=jgR,g\u000e\u001e)beRLG/[8o)J\fgn]5uS>t\u0007fA\u0016\u0002^\u0005\u0019D/Z:u\u0013:4\u0018\r\\5e\u001f\u001a4G.\u001b8f!\u0006\u0014H/\u001b;j_:$vNT3x!\u0006\u0014H/\u001b;j_:$&/\u00198tSRLwN\u001c\u0015\u0004Y\u0005u\u0013!\n9sKB\f'/Z'pG.$v.\u00127fGRdU-\u00193fe\u001a{'\u000fU1si&$\u0018n\u001c8t)\ri\u0015Q\u001c\u0005\b\u0003Ci\u0003\u0019AAp!\u0019\t\t/!=\u0002\n9!\u00111]Aw\u001d\u0011\t)/a;\u000e\u0005\u0005\u001d(bAAuu\u00051AH]8pizJ\u0011aP\u0005\u0004\u0003_t\u0014a\u00029bG.\fw-Z\u0005\u0005\u0003_\t\u0019PC\u0002\u0002pz\n!\u0005^3tiV\u0003H-\u0019;j]\u001e|eM\u001a7j]\u0016\u0004\u0016M\u001d;ji&|gn]\"pk:$\bf\u0001\u0018\u0002^\u0005\u0011D/Z:u\u001d>|eM\u001a7j]\u0016\u0004\u0016M\u001d;ji&|gn]\"iC:<WMR8s)>\u0004\u0018nY:CK&tw\rR3mKR,G\rK\u00020\u0003;\nQ\u0007^3tiV\u0003H-\u0019;j]\u001e|eM\u001a7j]\u0016\u0004\u0016M\u001d;ji&|gn]\"pk:$H)\u001e:j]\u001e$v\u000e]5d\t\u0016dW\r^5p]\"\u001a\u0001'!\u0018\u0002#I,\u0007\u000f\\5dC\u0006\u001b8/[4o[\u0016tG\u000f\u0006\u0003\u0003\u0006\t-\u0001cA#\u0003\b%\u0019!\u0011\u0002\u001c\u0003#I+\u0007\u000f\\5dC\u0006\u001b8/[4o[\u0016tG\u000fC\u0004\u0003\u000eE\u0002\rAa\u0004\u0002\u0011I,\u0007\u000f\\5dCN\u0004R!!9\u0002rN\fAc\u0019:fCR,'I]8lKJ\fe\u000eZ#q_\u000eDG\u0003\u0004B\u000b\u0005[\u0011\tD!\u0012\u0003J\tu\u0003cB\u001f\u0003\u0018\tm!qE\u0005\u0004\u00053q$A\u0002+va2,'\u0007\u0005\u0003\u0003\u001e\t\rRB\u0001B\u0010\u0015\r\u0011\t\u0003O\u0001\bG2,8\u000f^3s\u0013\u0011\u0011)Ca\b\u0003\r\t\u0013xn[3s!\ri$\u0011F\u0005\u0004\u0005Wq$\u0001\u0002'p]\u001eDaAa\f3\u0001\u0004\u0019\u0018AA5e\u0011\u001d\u0011\u0019D\ra\u0001\u0005k\tA\u0001[8tiB!!q\u0007B \u001d\u0011\u0011IDa\u000f\u0011\u0007\u0005\u0015h(C\u0002\u0003>y\na\u0001\u0015:fI\u00164\u0017\u0002\u0002B!\u0005\u0007\u0012aa\u0015;sS:<'b\u0001B\u001f}!1!q\t\u001aA\u0002M\fA\u0001]8si\"I!1\n\u001a\u0011\u0002\u0003\u0007!QJ\u0001\u0011g\u0016\u001cWO]5usB\u0013x\u000e^8d_2\u0004BAa\u0014\u0003Z5\u0011!\u0011\u000b\u0006\u0005\u0005'\u0012)&\u0001\u0003bkRD'\u0002\u0002B,\u0003\u001b\t\u0001b]3dkJLG/_\u0005\u0005\u00057\u0012\tF\u0001\tTK\u000e,(/\u001b;z!J|Go\\2pY\"I!q\f\u001a\u0011\u0002\u0003\u0007!qE\u0001\u0006KB|7\r[\u0001\u001fGJ,\u0017\r^3Ce>\\WM]!oI\u0016\u0003xn\u00195%I\u00164\u0017-\u001e7uIQ*\"A!\u001a+\t\t5#qM\u0016\u0003\u0005S\u0002BAa\u001b\u0003v5\u0011!Q\u000e\u0006\u0005\u0005_\u0012\t(A\u0005v]\u000eDWmY6fI*\u0019!1\u000f \u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0003x\t5$!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0006q2M]3bi\u0016\u0014%o\\6fe\u0006sG-\u00129pG\"$C-\u001a4bk2$H%N\u000b\u0003\u0005{RCAa\n\u0003h\u0001")
public class PartitionStateMachineTest {
    private ControllerContext controllerContext;
    private KafkaZkClient mockZkClient;
    private ControllerBrokerRequestBatch mockControllerBrokerRequestBatch;
    private PartitionStateMachine partitionStateMachine;
    private final int brokerId;
    private final KafkaConfig config = KafkaConfig$.MODULE$.fromProps(TestUtils$.MODULE$.createBrokerConfig(this.brokerId(), "zkConnect", TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18(), TestUtils$.MODULE$.createBrokerConfig$default$19(), TestUtils$.MODULE$.createBrokerConfig$default$20(), TestUtils$.MODULE$.createBrokerConfig$default$21()));
    private final int controllerEpoch;
    private final TopicPartition partition = new TopicPartition("t", 0);
    private final Seq<TopicPartition> partitions = new .colon.colon((Object)this.partition(), (List)Nil$.MODULE$);

    private ControllerContext controllerContext() {
        return this.controllerContext;
    }

    private void controllerContext_$eq(ControllerContext x$1) {
        this.controllerContext = x$1;
    }

    private KafkaZkClient mockZkClient() {
        return this.mockZkClient;
    }

    private void mockZkClient_$eq(KafkaZkClient x$1) {
        this.mockZkClient = x$1;
    }

    private ControllerBrokerRequestBatch mockControllerBrokerRequestBatch() {
        return this.mockControllerBrokerRequestBatch;
    }

    private void mockControllerBrokerRequestBatch_$eq(ControllerBrokerRequestBatch x$1) {
        this.mockControllerBrokerRequestBatch = x$1;
    }

    private PartitionStateMachine partitionStateMachine() {
        return this.partitionStateMachine;
    }

    private void partitionStateMachine_$eq(PartitionStateMachine x$1) {
        this.partitionStateMachine = x$1;
    }

    private int brokerId() {
        return this.brokerId;
    }

    private KafkaConfig config() {
        return this.config;
    }

    private int controllerEpoch() {
        return this.controllerEpoch;
    }

    private TopicPartition partition() {
        return this.partition;
    }

    private Seq<TopicPartition> partitions() {
        return this.partitions;
    }

    @BeforeEach
    public void setUp() {
        this.controllerContext_$eq(new ControllerContext());
        this.controllerContext().epoch_$eq(this.controllerEpoch());
        this.mockZkClient_$eq((KafkaZkClient)Mockito.mock(KafkaZkClient.class));
        this.mockControllerBrokerRequestBatch_$eq((ControllerBrokerRequestBatch)Mockito.mock(ControllerBrokerRequestBatch.class));
        this.partitionStateMachine_$eq((PartitionStateMachine)new ZkPartitionStateMachine(this.config(), new StateChangeLogger(this.brokerId(), true, (Option)None$.MODULE$), this.controllerContext(), this.mockZkClient(), this.mockControllerBrokerRequestBatch()));
    }

    private PartitionState partitionState(TopicPartition partition) {
        return this.controllerContext().partitionState(partition);
    }

    @Test
    public void testNonexistentPartitionToNewPartitionTransition() {
        this.partitionStateMachine().handleStateChanges(this.partitions(), (PartitionState)NewPartition$.MODULE$);
        Assertions.assertEquals((Object)NewPartition$.MODULE$, (Object)this.partitionState(this.partition()));
    }

    @Test
    public void testInvalidNonexistentPartitionToOnlinePartitionTransition() {
        this.partitionStateMachine().handleStateChanges(this.partitions(), (PartitionState)OnlinePartition$.MODULE$, Option$.MODULE$.apply((Object)new OfflinePartitionLeaderElectionStrategy(false)));
        Assertions.assertEquals((Object)NonExistentPartition$.MODULE$, (Object)this.partitionState(this.partition()));
    }

    @Test
    public void testInvalidNonexistentPartitionToOfflinePartitionTransition() {
        this.partitionStateMachine().handleStateChanges(this.partitions(), (PartitionState)OfflinePartition$.MODULE$);
        Assertions.assertEquals((Object)NonExistentPartition$.MODULE$, (Object)this.partitionState(this.partition()));
    }

    @Test
    public void testNewPartitionToOnlinePartitionTransition() {
        this.controllerContext().setLiveBrokers((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{this.createBrokerAndEpoch(this.brokerId(), "host", 0, this.createBrokerAndEpoch$default$4(), this.createBrokerAndEpoch$default$5())})));
        this.controllerContext().updatePartitionFullReplicaAssignment(this.partition(), ReplicaAssignment$.MODULE$.apply((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.brokerId()}))));
        this.controllerContext().putPartitionState(this.partition(), (PartitionState)NewPartition$.MODULE$);
        LeaderIsrAndControllerEpoch leaderIsrAndControllerEpoch = new LeaderIsrAndControllerEpoch(LeaderAndIsr$.MODULE$.apply(this.brokerId(), List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.brokerId()}))), this.controllerEpoch());
        Mockito.when((Object)this.mockZkClient().createTopicPartitionStatesRaw((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.partition()), (Object)leaderIsrAndControllerEpoch)})), this.controllerContext().epochZkVersion())).thenReturn((Object)new .colon.colon((Object)new CreateResponse(KeeperException.Code.OK, null, (Option)new Some((Object)this.partition()), null, new ResponseMetadata(0L, 0L)), (List)Nil$.MODULE$));
        this.partitionStateMachine().handleStateChanges(this.partitions(), (PartitionState)OnlinePartition$.MODULE$, Option$.MODULE$.apply((Object)new OfflinePartitionLeaderElectionStrategy(false)));
        ((AbstractControllerBrokerRequestBatch)Mockito.verify((Object)this.mockControllerBrokerRequestBatch())).newBatch();
        ((AbstractControllerBrokerRequestBatch)Mockito.verify((Object)this.mockControllerBrokerRequestBatch())).addLeaderAndIsrRequestForBrokers((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.brokerId()})), this.partition(), leaderIsrAndControllerEpoch, this.replicaAssignment((Seq<Object>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.brokerId()})))), true);
        ((AbstractControllerBrokerRequestBatch)Mockito.verify((Object)this.mockControllerBrokerRequestBatch())).sendRequestsToBrokers(this.controllerEpoch());
        ((KafkaZkClient)Mockito.verify((Object)this.mockZkClient())).createTopicPartitionStatesRaw((Map)ArgumentMatchers.any(), ArgumentMatchers.anyInt());
        Assertions.assertEquals((Object)OnlinePartition$.MODULE$, (Object)this.partitionState(this.partition()));
    }

    @Test
    public void testNewPartitionToOnlinePartitionTransitionZooKeeperClientExceptionFromCreateStates() {
        this.controllerContext().setLiveBrokers((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{this.createBrokerAndEpoch(this.brokerId(), "host", 0, this.createBrokerAndEpoch$default$4(), this.createBrokerAndEpoch$default$5())})));
        this.controllerContext().updatePartitionFullReplicaAssignment(this.partition(), ReplicaAssignment$.MODULE$.apply((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.brokerId()}))));
        this.controllerContext().putPartitionState(this.partition(), (PartitionState)NewPartition$.MODULE$);
        LeaderIsrAndControllerEpoch leaderIsrAndControllerEpoch = new LeaderIsrAndControllerEpoch(LeaderAndIsr$.MODULE$.apply(this.brokerId(), List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.brokerId()}))), this.controllerEpoch());
        Mockito.when((Object)this.mockZkClient().createTopicPartitionStatesRaw((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.partition()), (Object)leaderIsrAndControllerEpoch)})), this.controllerContext().epochZkVersion())).thenThrow(new Throwable[]{new ZooKeeperClientException("test")});
        this.partitionStateMachine().handleStateChanges(this.partitions(), (PartitionState)OnlinePartition$.MODULE$, Option$.MODULE$.apply((Object)new OfflinePartitionLeaderElectionStrategy(false)));
        ((AbstractControllerBrokerRequestBatch)Mockito.verify((Object)this.mockControllerBrokerRequestBatch())).newBatch();
        ((AbstractControllerBrokerRequestBatch)Mockito.verify((Object)this.mockControllerBrokerRequestBatch())).sendRequestsToBrokers(this.controllerEpoch());
        ((KafkaZkClient)Mockito.verify((Object)this.mockZkClient())).createTopicPartitionStatesRaw((Map)ArgumentMatchers.any(), ArgumentMatchers.anyInt());
        Assertions.assertEquals((Object)NewPartition$.MODULE$, (Object)this.partitionState(this.partition()));
    }

    @Test
    public void testNewPartitionToOnlinePartitionTransitionErrorCodeFromCreateStates() {
        this.controllerContext().setLiveBrokers((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{this.createBrokerAndEpoch(this.brokerId(), "host", 0, this.createBrokerAndEpoch$default$4(), this.createBrokerAndEpoch$default$5())})));
        this.controllerContext().updatePartitionFullReplicaAssignment(this.partition(), ReplicaAssignment$.MODULE$.apply((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.brokerId()}))));
        this.controllerContext().putPartitionState(this.partition(), (PartitionState)NewPartition$.MODULE$);
        LeaderIsrAndControllerEpoch leaderIsrAndControllerEpoch = new LeaderIsrAndControllerEpoch(LeaderAndIsr$.MODULE$.apply(this.brokerId(), List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.brokerId()}))), this.controllerEpoch());
        Mockito.when((Object)this.mockZkClient().createTopicPartitionStatesRaw((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.partition()), (Object)leaderIsrAndControllerEpoch)})), this.controllerContext().epochZkVersion())).thenReturn((Object)new .colon.colon((Object)new CreateResponse(KeeperException.Code.NODEEXISTS, null, (Option)new Some((Object)this.partition()), null, new ResponseMetadata(0L, 0L)), (List)Nil$.MODULE$));
        this.partitionStateMachine().handleStateChanges(this.partitions(), (PartitionState)OnlinePartition$.MODULE$, Option$.MODULE$.apply((Object)new OfflinePartitionLeaderElectionStrategy(false)));
        ((AbstractControllerBrokerRequestBatch)Mockito.verify((Object)this.mockControllerBrokerRequestBatch())).newBatch();
        ((AbstractControllerBrokerRequestBatch)Mockito.verify((Object)this.mockControllerBrokerRequestBatch())).sendRequestsToBrokers(this.controllerEpoch());
        ((KafkaZkClient)Mockito.verify((Object)this.mockZkClient())).createTopicPartitionStatesRaw((Map)ArgumentMatchers.any(), ArgumentMatchers.anyInt());
        Assertions.assertEquals((Object)NewPartition$.MODULE$, (Object)this.partitionState(this.partition()));
    }

    @Test
    public void testNewPartitionToOfflinePartitionTransition() {
        this.controllerContext().putPartitionState(this.partition(), (PartitionState)NewPartition$.MODULE$);
        this.partitionStateMachine().handleStateChanges(this.partitions(), (PartitionState)OfflinePartition$.MODULE$);
        Assertions.assertEquals((Object)OfflinePartition$.MODULE$, (Object)this.partitionState(this.partition()));
    }

    @Test
    public void testInvalidNewPartitionToNonexistentPartitionTransition() {
        this.controllerContext().putPartitionState(this.partition(), (PartitionState)NewPartition$.MODULE$);
        this.partitionStateMachine().handleStateChanges(this.partitions(), (PartitionState)NonExistentPartition$.MODULE$);
        Assertions.assertEquals((Object)NewPartition$.MODULE$, (Object)this.partitionState(this.partition()));
    }

    @Test
    public void testOnlinePartitionToOnlineTransition() {
        this.controllerContext().setLiveBrokers((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{this.createBrokerAndEpoch(this.brokerId(), "host", 0, this.createBrokerAndEpoch$default$4(), this.createBrokerAndEpoch$default$5())})));
        this.controllerContext().updatePartitionFullReplicaAssignment(this.partition(), ReplicaAssignment$.MODULE$.apply((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.brokerId()}))));
        this.controllerContext().putPartitionState(this.partition(), (PartitionState)OnlinePartition$.MODULE$);
        LeaderAndIsr leaderAndIsr = LeaderAndIsr$.MODULE$.apply(this.brokerId(), List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.brokerId()})));
        LeaderIsrAndControllerEpoch leaderIsrAndControllerEpoch = new LeaderIsrAndControllerEpoch(leaderAndIsr, this.controllerEpoch());
        this.controllerContext().putPartitionLeadershipInfo(this.partition(), leaderIsrAndControllerEpoch);
        Stat stat = new Stat(0L, 0L, 0L, 0L, 0, 0, 0, 0L, 0, 0, 0L);
        Mockito.when((Object)this.mockZkClient().getTopicPartitionStatesRaw(this.partitions())).thenReturn((Object)new .colon.colon((Object)new GetDataResponse(KeeperException.Code.OK, null, (Option)new Some((Object)this.partition()), TopicPartitionStateZNode$.MODULE$.encode(leaderIsrAndControllerEpoch), stat, new ResponseMetadata(0L, 0L)), (List)Nil$.MODULE$));
        LeaderAndIsr leaderAndIsrAfterElection = leaderAndIsr.newLeader(this.brokerId());
        LeaderAndIsr updatedLeaderAndIsr = leaderAndIsrAfterElection.withPartitionEpoch(2);
        Mockito.when((Object)this.mockZkClient().updateLeaderAndIsr((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.partition()), (Object)leaderAndIsrAfterElection)})), this.controllerEpoch(), this.controllerContext().epochZkVersion())).thenReturn((Object)new KafkaZkClient.UpdateLeaderAndIsrResult((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.partition()), (Object)package$.MODULE$.Right().apply((Object)updatedLeaderAndIsr))})), (Seq)Nil$.MODULE$));
        this.partitionStateMachine().handleStateChanges(this.partitions(), (PartitionState)OnlinePartition$.MODULE$, Option$.MODULE$.apply((Object)PreferredReplicaPartitionLeaderElectionStrategy$.MODULE$));
        ((AbstractControllerBrokerRequestBatch)Mockito.verify((Object)this.mockControllerBrokerRequestBatch())).newBatch();
        ((AbstractControllerBrokerRequestBatch)Mockito.verify((Object)this.mockControllerBrokerRequestBatch())).addLeaderAndIsrRequestForBrokers((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.brokerId()})), this.partition(), new LeaderIsrAndControllerEpoch(updatedLeaderAndIsr, this.controllerEpoch()), this.replicaAssignment((Seq<Object>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.brokerId()})))), false);
        ((AbstractControllerBrokerRequestBatch)Mockito.verify((Object)this.mockControllerBrokerRequestBatch())).sendRequestsToBrokers(this.controllerEpoch());
        ((KafkaZkClient)Mockito.verify((Object)this.mockZkClient())).getTopicPartitionStatesRaw((Seq)ArgumentMatchers.any());
        ((KafkaZkClient)Mockito.verify((Object)this.mockZkClient())).updateLeaderAndIsr((Map)ArgumentMatchers.any(), ArgumentMatchers.anyInt(), ArgumentMatchers.anyInt());
        Assertions.assertEquals((Object)OnlinePartition$.MODULE$, (Object)this.partitionState(this.partition()));
    }

    @Test
    public void testOnlinePartitionToOnlineTransitionForControlledShutdown() {
        int otherBrokerId = this.brokerId() + 1;
        this.controllerContext().setLiveBrokers((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{this.createBrokerAndEpoch(this.brokerId(), "host", 0, this.createBrokerAndEpoch$default$4(), this.createBrokerAndEpoch$default$5()), this.createBrokerAndEpoch(otherBrokerId, "host", 0, this.createBrokerAndEpoch$default$4(), this.createBrokerAndEpoch$default$5())})));
        this.controllerContext().shuttingDownBrokerIds().add((Object)BoxesRunTime.boxToInteger((int)this.brokerId()));
        this.controllerContext().updatePartitionFullReplicaAssignment(this.partition(), ReplicaAssignment$.MODULE$.apply((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.brokerId(), otherBrokerId}))));
        this.controllerContext().putPartitionState(this.partition(), (PartitionState)OnlinePartition$.MODULE$);
        LeaderAndIsr leaderAndIsr = LeaderAndIsr$.MODULE$.apply(this.brokerId(), List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.brokerId(), otherBrokerId})));
        LeaderIsrAndControllerEpoch leaderIsrAndControllerEpoch = new LeaderIsrAndControllerEpoch(leaderAndIsr, this.controllerEpoch());
        this.controllerContext().putPartitionLeadershipInfo(this.partition(), leaderIsrAndControllerEpoch);
        Stat stat = new Stat(0L, 0L, 0L, 0L, 0, 0, 0, 0L, 0, 0, 0L);
        Mockito.when((Object)this.mockZkClient().getTopicPartitionStatesRaw(this.partitions())).thenReturn((Object)new .colon.colon((Object)new GetDataResponse(KeeperException.Code.OK, null, (Option)new Some((Object)this.partition()), TopicPartitionStateZNode$.MODULE$.encode(leaderIsrAndControllerEpoch), stat, new ResponseMetadata(0L, 0L)), (List)Nil$.MODULE$));
        LeaderAndIsr leaderAndIsrAfterElection = leaderAndIsr.newLeaderAndIsr(otherBrokerId, List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{otherBrokerId})));
        LeaderAndIsr updatedLeaderAndIsr = leaderAndIsrAfterElection.withPartitionEpoch(2);
        Mockito.when((Object)this.mockZkClient().updateLeaderAndIsr((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.partition()), (Object)leaderAndIsrAfterElection)})), this.controllerEpoch(), this.controllerContext().epochZkVersion())).thenReturn((Object)new KafkaZkClient.UpdateLeaderAndIsrResult((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.partition()), (Object)package$.MODULE$.Right().apply((Object)updatedLeaderAndIsr))})), (Seq)Nil$.MODULE$));
        this.partitionStateMachine().handleStateChanges(this.partitions(), (PartitionState)OnlinePartition$.MODULE$, Option$.MODULE$.apply((Object)ControlledShutdownPartitionLeaderElectionStrategy$.MODULE$));
        ((AbstractControllerBrokerRequestBatch)Mockito.verify((Object)this.mockControllerBrokerRequestBatch())).newBatch();
        ((AbstractControllerBrokerRequestBatch)Mockito.verify((Object)this.mockControllerBrokerRequestBatch())).addLeaderAndIsrRequestForBrokers((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.brokerId(), otherBrokerId})), this.partition(), new LeaderIsrAndControllerEpoch(updatedLeaderAndIsr, this.controllerEpoch()), this.replicaAssignment((Seq<Object>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.brokerId(), otherBrokerId})))), false);
        ((AbstractControllerBrokerRequestBatch)Mockito.verify((Object)this.mockControllerBrokerRequestBatch())).sendRequestsToBrokers(this.controllerEpoch());
        ((KafkaZkClient)Mockito.verify((Object)this.mockZkClient())).getTopicPartitionStatesRaw((Seq)ArgumentMatchers.any());
        ((KafkaZkClient)Mockito.verify((Object)this.mockZkClient())).updateLeaderAndIsr((Map)ArgumentMatchers.any(), ArgumentMatchers.anyInt(), ArgumentMatchers.anyInt());
        Assertions.assertEquals((Object)OnlinePartition$.MODULE$, (Object)this.partitionState(this.partition()));
    }

    @Test
    public void testOnlinePartitionToOfflineTransition() {
        this.controllerContext().putPartitionState(this.partition(), (PartitionState)OnlinePartition$.MODULE$);
        this.partitionStateMachine().handleStateChanges(this.partitions(), (PartitionState)OfflinePartition$.MODULE$);
        Assertions.assertEquals((Object)OfflinePartition$.MODULE$, (Object)this.partitionState(this.partition()));
    }

    @Test
    public void testInvalidOnlinePartitionToNonexistentPartitionTransition() {
        this.controllerContext().putPartitionState(this.partition(), (PartitionState)OnlinePartition$.MODULE$);
        this.partitionStateMachine().handleStateChanges(this.partitions(), (PartitionState)NonExistentPartition$.MODULE$);
        Assertions.assertEquals((Object)OnlinePartition$.MODULE$, (Object)this.partitionState(this.partition()));
    }

    @Test
    public void testInvalidOnlinePartitionToNewPartitionTransition() {
        this.controllerContext().putPartitionState(this.partition(), (PartitionState)OnlinePartition$.MODULE$);
        this.partitionStateMachine().handleStateChanges(this.partitions(), (PartitionState)NewPartition$.MODULE$);
        Assertions.assertEquals((Object)OnlinePartition$.MODULE$, (Object)this.partitionState(this.partition()));
    }

    @Test
    public void testOfflinePartitionToOnlinePartitionTransition() {
        this.controllerContext().setLiveBrokers((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{this.createBrokerAndEpoch(this.brokerId(), "host", 0, this.createBrokerAndEpoch$default$4(), this.createBrokerAndEpoch$default$5())})));
        this.controllerContext().updatePartitionFullReplicaAssignment(this.partition(), ReplicaAssignment$.MODULE$.apply((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.brokerId()}))));
        this.controllerContext().putPartitionState(this.partition(), (PartitionState)OfflinePartition$.MODULE$);
        LeaderAndIsr leaderAndIsr = LeaderAndIsr$.MODULE$.apply(LeaderAndIsr$.MODULE$.NoLeader(), List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.brokerId()})));
        LeaderIsrAndControllerEpoch leaderIsrAndControllerEpoch = new LeaderIsrAndControllerEpoch(leaderAndIsr, this.controllerEpoch());
        this.controllerContext().putPartitionLeadershipInfo(this.partition(), leaderIsrAndControllerEpoch);
        Stat stat = new Stat(0L, 0L, 0L, 0L, 0, 0, 0, 0L, 0, 0, 0L);
        Mockito.when((Object)this.mockZkClient().getTopicPartitionStatesRaw(this.partitions())).thenReturn((Object)new .colon.colon((Object)new GetDataResponse(KeeperException.Code.OK, null, (Option)new Some((Object)this.partition()), TopicPartitionStateZNode$.MODULE$.encode(leaderIsrAndControllerEpoch), stat, new ResponseMetadata(0L, 0L)), (List)Nil$.MODULE$));
        Mockito.when((Object)this.mockZkClient().getLogConfigs(Predef$.MODULE$.Set().empty(), this.config().originals())).thenReturn((Object)new Tuple2((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.partition().topic()), (Object)new LogConfig((java.util.Map)new Properties()))})), (Object)Predef$.MODULE$.Map().empty()));
        LeaderAndIsr leaderAndIsrAfterElection = leaderAndIsr.newLeader(this.brokerId());
        LeaderAndIsr updatedLeaderAndIsr = leaderAndIsrAfterElection.withPartitionEpoch(2);
        Mockito.when((Object)this.mockZkClient().updateLeaderAndIsr((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.partition()), (Object)leaderAndIsrAfterElection)})), this.controllerEpoch(), this.controllerContext().epochZkVersion())).thenReturn((Object)new KafkaZkClient.UpdateLeaderAndIsrResult((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.partition()), (Object)package$.MODULE$.Right().apply((Object)updatedLeaderAndIsr))})), (Seq)Nil$.MODULE$));
        this.partitionStateMachine().handleStateChanges(this.partitions(), (PartitionState)OnlinePartition$.MODULE$, Option$.MODULE$.apply((Object)new OfflinePartitionLeaderElectionStrategy(false)));
        ((AbstractControllerBrokerRequestBatch)Mockito.verify((Object)this.mockControllerBrokerRequestBatch())).newBatch();
        ((AbstractControllerBrokerRequestBatch)Mockito.verify((Object)this.mockControllerBrokerRequestBatch())).addLeaderAndIsrRequestForBrokers((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.brokerId()})), this.partition(), new LeaderIsrAndControllerEpoch(updatedLeaderAndIsr, this.controllerEpoch()), this.replicaAssignment((Seq<Object>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.brokerId()})))), false);
        ((AbstractControllerBrokerRequestBatch)Mockito.verify((Object)this.mockControllerBrokerRequestBatch())).sendRequestsToBrokers(this.controllerEpoch());
        ((KafkaZkClient)Mockito.verify((Object)this.mockZkClient())).getTopicPartitionStatesRaw((Seq)ArgumentMatchers.any());
        ((KafkaZkClient)Mockito.verify((Object)this.mockZkClient())).getLogConfigs((scala.collection.immutable.Set)ArgumentMatchers.any(), (java.util.Map)ArgumentMatchers.any());
        ((KafkaZkClient)Mockito.verify((Object)this.mockZkClient())).updateLeaderAndIsr((Map)ArgumentMatchers.any(), ArgumentMatchers.anyInt(), ArgumentMatchers.anyInt());
        Assertions.assertEquals((Object)OnlinePartition$.MODULE$, (Object)this.partitionState(this.partition()));
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    public void testOfflinePartitionToUncleanOnlinePartitionTransition(boolean isLeaderRecoverySupported) {
        MetadataVersion apiVersion = isLeaderRecoverySupported ? MetadataVersion.IBP_3_2_IV0 : MetadataVersion.IBP_3_1_IV0;
        Properties properties = TestUtils$.MODULE$.createBrokerConfig(this.brokerId(), "zkConnect", TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18(), TestUtils$.MODULE$.createBrokerConfig$default$19(), TestUtils$.MODULE$.createBrokerConfig$default$20(), TestUtils$.MODULE$.createBrokerConfig$default$21());
        properties.setProperty("inter.broker.protocol.version", apiVersion.toString());
        ZkPartitionStateMachine partitionStateMachine = new ZkPartitionStateMachine(KafkaConfig$.MODULE$.fromProps(properties), new StateChangeLogger(this.brokerId(), true, (Option)None$.MODULE$), this.controllerContext(), this.mockZkClient(), this.mockControllerBrokerRequestBatch());
        int leaderBrokerId = this.brokerId() + 1;
        this.controllerContext().setLiveBrokers((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{this.createBrokerAndEpoch(this.brokerId(), "host", 0, this.createBrokerAndEpoch$default$4(), this.createBrokerAndEpoch$default$5())})));
        this.controllerContext().updatePartitionFullReplicaAssignment(this.partition(), ReplicaAssignment$.MODULE$.apply((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{leaderBrokerId, this.brokerId()}))));
        this.controllerContext().putPartitionState(this.partition(), (PartitionState)OfflinePartition$.MODULE$);
        LeaderAndIsr leaderAndIsr = LeaderAndIsr$.MODULE$.apply(leaderBrokerId, List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{leaderBrokerId})));
        LeaderIsrAndControllerEpoch leaderIsrAndControllerEpoch = new LeaderIsrAndControllerEpoch(leaderAndIsr, this.controllerEpoch());
        this.controllerContext().putPartitionLeadershipInfo(this.partition(), leaderIsrAndControllerEpoch);
        Mockito.when((Object)this.mockZkClient().getTopicPartitionStatesRaw(this.partitions())).thenReturn((Object)new .colon.colon((Object)new GetDataResponse(KeeperException.Code.OK, null, Option$.MODULE$.apply((Object)this.partition()), TopicPartitionStateZNode$.MODULE$.encode(leaderIsrAndControllerEpoch), new Stat(0L, 0L, 0L, 0L, 0, 0, 0, 0L, 0, 0, 0L), new ResponseMetadata(0L, 0L)), (List)Nil$.MODULE$));
        LeaderAndIsr leaderAndIsrAfterElection = isLeaderRecoverySupported ? leaderAndIsr.newRecoveringLeaderAndIsr(this.brokerId(), List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.brokerId()}))) : leaderAndIsr.newLeaderAndIsr(this.brokerId(), List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.brokerId()})));
        LeaderAndIsr updatedLeaderAndIsr = leaderAndIsrAfterElection.withPartitionEpoch(2);
        Mockito.when((Object)this.mockZkClient().updateLeaderAndIsr((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.partition()), (Object)leaderAndIsrAfterElection)})), this.controllerEpoch(), this.controllerContext().epochZkVersion())).thenReturn((Object)new KafkaZkClient.UpdateLeaderAndIsrResult((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.partition()), (Object)package$.MODULE$.Right().apply((Object)updatedLeaderAndIsr))})), (Seq)Nil$.MODULE$));
        partitionStateMachine.handleStateChanges(this.partitions(), (PartitionState)OnlinePartition$.MODULE$, Option$.MODULE$.apply((Object)new OfflinePartitionLeaderElectionStrategy(true)));
        ((AbstractControllerBrokerRequestBatch)Mockito.verify((Object)this.mockControllerBrokerRequestBatch())).newBatch();
        ((AbstractControllerBrokerRequestBatch)Mockito.verify((Object)this.mockControllerBrokerRequestBatch())).addLeaderAndIsrRequestForBrokers((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.brokerId()})), this.partition(), new LeaderIsrAndControllerEpoch(updatedLeaderAndIsr, this.controllerEpoch()), this.replicaAssignment((Seq<Object>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{leaderBrokerId, this.brokerId()})))), false);
        ((AbstractControllerBrokerRequestBatch)Mockito.verify((Object)this.mockControllerBrokerRequestBatch())).sendRequestsToBrokers(this.controllerEpoch());
        ((KafkaZkClient)Mockito.verify((Object)this.mockZkClient())).getTopicPartitionStatesRaw((Seq)ArgumentMatchers.any());
        ((KafkaZkClient)Mockito.verify((Object)this.mockZkClient())).updateLeaderAndIsr((Map)ArgumentMatchers.any(), ArgumentMatchers.anyInt(), ArgumentMatchers.anyInt());
        Assertions.assertEquals((Object)OnlinePartition$.MODULE$, (Object)this.partitionState(this.partition()));
    }

    @Test
    public void testOfflinePartitionToOnlinePartitionTransitionZooKeeperClientExceptionFromStateLookup() {
        this.controllerContext().setLiveBrokers((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{this.createBrokerAndEpoch(this.brokerId(), "host", 0, this.createBrokerAndEpoch$default$4(), this.createBrokerAndEpoch$default$5())})));
        this.controllerContext().updatePartitionFullReplicaAssignment(this.partition(), ReplicaAssignment$.MODULE$.apply((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.brokerId()}))));
        this.controllerContext().putPartitionState(this.partition(), (PartitionState)OfflinePartition$.MODULE$);
        LeaderAndIsr leaderAndIsr = LeaderAndIsr$.MODULE$.apply(LeaderAndIsr$.MODULE$.NoLeader(), List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.brokerId()})));
        LeaderIsrAndControllerEpoch leaderIsrAndControllerEpoch = new LeaderIsrAndControllerEpoch(leaderAndIsr, this.controllerEpoch());
        this.controllerContext().putPartitionLeadershipInfo(this.partition(), leaderIsrAndControllerEpoch);
        Mockito.when((Object)this.mockZkClient().getTopicPartitionStatesRaw(this.partitions())).thenThrow(new Throwable[]{new ZooKeeperClientException("")});
        this.partitionStateMachine().handleStateChanges(this.partitions(), (PartitionState)OnlinePartition$.MODULE$, Option$.MODULE$.apply((Object)new OfflinePartitionLeaderElectionStrategy(false)));
        ((AbstractControllerBrokerRequestBatch)Mockito.verify((Object)this.mockControllerBrokerRequestBatch())).newBatch();
        ((AbstractControllerBrokerRequestBatch)Mockito.verify((Object)this.mockControllerBrokerRequestBatch())).sendRequestsToBrokers(this.controllerEpoch());
        ((KafkaZkClient)Mockito.verify((Object)this.mockZkClient())).getTopicPartitionStatesRaw((Seq)ArgumentMatchers.any());
        Assertions.assertEquals((Object)OfflinePartition$.MODULE$, (Object)this.partitionState(this.partition()));
    }

    @Test
    public void testOfflinePartitionToOnlinePartitionTransitionErrorCodeFromStateLookup() {
        this.controllerContext().setLiveBrokers((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{this.createBrokerAndEpoch(this.brokerId(), "host", 0, this.createBrokerAndEpoch$default$4(), this.createBrokerAndEpoch$default$5())})));
        this.controllerContext().updatePartitionFullReplicaAssignment(this.partition(), ReplicaAssignment$.MODULE$.apply((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.brokerId()}))));
        this.controllerContext().putPartitionState(this.partition(), (PartitionState)OfflinePartition$.MODULE$);
        LeaderAndIsr leaderAndIsr = LeaderAndIsr$.MODULE$.apply(LeaderAndIsr$.MODULE$.NoLeader(), List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.brokerId()})));
        LeaderIsrAndControllerEpoch leaderIsrAndControllerEpoch = new LeaderIsrAndControllerEpoch(leaderAndIsr, this.controllerEpoch());
        this.controllerContext().putPartitionLeadershipInfo(this.partition(), leaderIsrAndControllerEpoch);
        Stat stat = new Stat(0L, 0L, 0L, 0L, 0, 0, 0, 0L, 0, 0, 0L);
        Mockito.when((Object)this.mockZkClient().getTopicPartitionStatesRaw(this.partitions())).thenReturn((Object)new .colon.colon((Object)new GetDataResponse(KeeperException.Code.NONODE, null, (Option)new Some((Object)this.partition()), TopicPartitionStateZNode$.MODULE$.encode(leaderIsrAndControllerEpoch), stat, new ResponseMetadata(0L, 0L)), (List)Nil$.MODULE$));
        this.partitionStateMachine().handleStateChanges(this.partitions(), (PartitionState)OnlinePartition$.MODULE$, Option$.MODULE$.apply((Object)new OfflinePartitionLeaderElectionStrategy(false)));
        ((AbstractControllerBrokerRequestBatch)Mockito.verify((Object)this.mockControllerBrokerRequestBatch())).newBatch();
        ((AbstractControllerBrokerRequestBatch)Mockito.verify((Object)this.mockControllerBrokerRequestBatch())).sendRequestsToBrokers(this.controllerEpoch());
        ((KafkaZkClient)Mockito.verify((Object)this.mockZkClient())).getTopicPartitionStatesRaw((Seq)ArgumentMatchers.any());
        Assertions.assertEquals((Object)OfflinePartition$.MODULE$, (Object)this.partitionState(this.partition()));
    }

    @Test
    public void testOfflinePartitionToNonexistentPartitionTransition() {
        this.controllerContext().putPartitionState(this.partition(), (PartitionState)OfflinePartition$.MODULE$);
        this.partitionStateMachine().handleStateChanges(this.partitions(), (PartitionState)NonExistentPartition$.MODULE$);
        Assertions.assertEquals((Object)NonExistentPartition$.MODULE$, (Object)this.partitionState(this.partition()));
    }

    @Test
    public void testInvalidOfflinePartitionToNewPartitionTransition() {
        this.controllerContext().putPartitionState(this.partition(), (PartitionState)OfflinePartition$.MODULE$);
        this.partitionStateMachine().handleStateChanges(this.partitions(), (PartitionState)NewPartition$.MODULE$);
        Assertions.assertEquals((Object)OfflinePartition$.MODULE$, (Object)this.partitionState(this.partition()));
    }

    private void prepareMockToElectLeaderForPartitions(Seq<TopicPartition> partitions) {
        LeaderAndIsr leaderAndIsr = LeaderAndIsr$.MODULE$.apply(this.brokerId(), List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.brokerId()})));
        this.prepareMockToGetTopicPartitionsStatesRaw$1(leaderAndIsr, partitions);
        this.prepareMockToGetLogConfigs$1();
        this.prepareMockToUpdateLeaderAndIsr$1(partitions, leaderAndIsr);
    }

    @Test
    public void testUpdatingOfflinePartitionsCount() {
        this.controllerContext().setLiveBrokers((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{this.createBrokerAndEpoch(this.brokerId(), "host", 0, this.createBrokerAndEpoch$default$4(), this.createBrokerAndEpoch$default$5())})));
        Seq partitionIds = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2, 3}));
        String topic = "test";
        Seq partitions = (Seq)partitionIds.map((Function1 & Serializable & scala.Serializable)x$1 -> PartitionStateMachineTest.$anonfun$testUpdatingOfflinePartitionsCount$1(topic, BoxesRunTime.unboxToInt((Object)x$1)), Seq$.MODULE$.canBuildFrom());
        partitions.foreach((Function1 & Serializable & scala.Serializable)partition -> {
            PartitionStateMachineTest.$anonfun$testUpdatingOfflinePartitionsCount$2(this, partition);
            return BoxedUnit.UNIT;
        });
        this.prepareMockToElectLeaderForPartitions((Seq<TopicPartition>)partitions);
        this.partitionStateMachine().handleStateChanges(partitions, (PartitionState)NewPartition$.MODULE$);
        this.partitionStateMachine().handleStateChanges(partitions, (PartitionState)OfflinePartition$.MODULE$);
        Assertions.assertEquals((int)partitions.size(), (int)this.controllerContext().offlinePartitionCount(), (String)new StringBuilder(37).append("There should be ").append(partitions.size()).append(" offline partition(s)").toString());
        this.partitionStateMachine().handleStateChanges(partitions, (PartitionState)OnlinePartition$.MODULE$, (Option)new Some((Object)new OfflinePartitionLeaderElectionStrategy(false)));
        Assertions.assertEquals((int)0, (int)this.controllerContext().offlinePartitionCount(), (String)"There should be no offline partition(s)");
    }

    @Test
    public void testNoOfflinePartitionsChangeForTopicsBeingDeleted() {
        Seq partitionIds = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2, 3}));
        String topic = "test";
        Seq partitions = (Seq)partitionIds.map((Function1 & Serializable & scala.Serializable)x$2 -> PartitionStateMachineTest.$anonfun$testNoOfflinePartitionsChangeForTopicsBeingDeleted$1(topic, BoxesRunTime.unboxToInt((Object)x$2)), Seq$.MODULE$.canBuildFrom());
        this.controllerContext().topicsToBeDeleted().add((Object)topic);
        this.controllerContext().topicsWithDeletionStarted().add((Object)topic);
        this.partitionStateMachine().handleStateChanges(partitions, (PartitionState)NewPartition$.MODULE$);
        this.partitionStateMachine().handleStateChanges(partitions, (PartitionState)OfflinePartition$.MODULE$);
        Assertions.assertEquals((int)0, (int)this.controllerContext().offlinePartitionCount(), (String)"There should be no offline partition(s)");
    }

    @Test
    public void testUpdatingOfflinePartitionsCountDuringTopicDeletion() {
        Seq partitionIds = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2, 3}));
        String topic = "test";
        Seq partitions = (Seq)partitionIds.map((Function1 & Serializable & scala.Serializable)x$3 -> PartitionStateMachineTest.$anonfun$testUpdatingOfflinePartitionsCountDuringTopicDeletion$1(BoxesRunTime.unboxToInt((Object)x$3)), Seq$.MODULE$.canBuildFrom());
        partitions.foreach((Function1 & Serializable & scala.Serializable)partition -> {
            PartitionStateMachineTest.$anonfun$testUpdatingOfflinePartitionsCountDuringTopicDeletion$2(this, partition);
            return BoxedUnit.UNIT;
        });
        MockPartitionStateMachine partitionStateMachine = new MockPartitionStateMachine(this.controllerContext(), false, true);
        MockReplicaStateMachine replicaStateMachine = new MockReplicaStateMachine(this.controllerContext());
        DeletionClient deletionClient = (DeletionClient)Mockito.mock(DeletionClient.class);
        TopicDeletionManager topicDeletionManager = new TopicDeletionManager(this.config(), this.controllerContext(), (ReplicaStateMachine)replicaStateMachine, (PartitionStateMachine)partitionStateMachine, deletionClient);
        partitionStateMachine.handleStateChanges(partitions, (PartitionState)NewPartition$.MODULE$);
        partitionStateMachine.handleStateChanges(partitions, (PartitionState)OfflinePartition$.MODULE$);
        partitions.foreach((Function1 & Serializable & scala.Serializable)partition -> {
            PartitionStateMachineTest.$anonfun$testUpdatingOfflinePartitionsCountDuringTopicDeletion$3(this, partition);
            return BoxedUnit.UNIT;
        });
        Assertions.assertEquals((int)partitions.size(), (int)this.controllerContext().offlinePartitionCount(), (String)new StringBuilder(37).append("There should be ").append(partitions.size()).append(" offline partition(s)").toString());
        topicDeletionManager.enqueueTopicsForDeletion((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{topic})));
        Assertions.assertEquals((int)0, (int)this.controllerContext().offlinePartitionCount(), (String)"There should be no offline partition(s)");
    }

    private ReplicaAssignment replicaAssignment(Seq<Object> replicas) {
        return ReplicaAssignment$.MODULE$.apply(replicas, (Seq)Nil$.MODULE$, (Seq)Nil$.MODULE$);
    }

    private Tuple2<Broker, Object> createBrokerAndEpoch(int id, String host, int port, SecurityProtocol securityProtocol, long epoch) {
        return new Tuple2((Object)new Broker(id, host, port, ListenerName.forSecurityProtocol((SecurityProtocol)securityProtocol), securityProtocol), (Object)BoxesRunTime.boxToLong((long)epoch));
    }

    private SecurityProtocol createBrokerAndEpoch$default$4() {
        return SecurityProtocol.PLAINTEXT;
    }

    private long createBrokerAndEpoch$default$5() {
        return 0L;
    }

    private final void prepareMockToGetTopicPartitionsStatesRaw$1(LeaderAndIsr leaderAndIsr$1, Seq partitions$1) {
        Stat stat = new Stat(0L, 0L, 0L, 0L, 0, 0, 0, 0L, 0, 0, 0L);
        LeaderIsrAndControllerEpoch leaderIsrAndControllerEpoch = new LeaderIsrAndControllerEpoch(leaderAndIsr$1, this.controllerEpoch());
        Seq getDataResponses = (Seq)partitions$1.map((Function1 & Serializable & scala.Serializable)p -> new GetDataResponse(KeeperException.Code.OK, null, (Option)new Some(p), TopicPartitionStateZNode$.MODULE$.encode(leaderIsrAndControllerEpoch), stat, new ResponseMetadata(0L, 0L)), Seq$.MODULE$.canBuildFrom());
        Mockito.when((Object)this.mockZkClient().getTopicPartitionStatesRaw(partitions$1)).thenReturn((Object)getDataResponses);
    }

    private final void prepareMockToGetLogConfigs$1() {
        Mockito.when((Object)this.mockZkClient().getLogConfigs(Predef$.MODULE$.Set().empty(), this.config().originals())).thenReturn((Object)new Tuple2((Object)Predef$.MODULE$.Map().empty(), (Object)Predef$.MODULE$.Map().empty()));
    }

    private final void prepareMockToUpdateLeaderAndIsr$1(Seq partitions$1, LeaderAndIsr leaderAndIsr$1) {
        scala.collection.immutable.Map updatedLeaderAndIsr = ((TraversableOnce)partitions$1.map((Function1 & Serializable & scala.Serializable)partition -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(partition), (Object)leaderAndIsr$1.newLeaderAndIsr(this.brokerId(), List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.brokerId()})))), Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        Mockito.when((Object)this.mockZkClient().updateLeaderAndIsr((Map)updatedLeaderAndIsr, this.controllerEpoch(), this.controllerContext().epochZkVersion())).thenReturn((Object)new KafkaZkClient.UpdateLeaderAndIsrResult((Map)updatedLeaderAndIsr.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            if (x0$1 != null) {
                TopicPartition k = (TopicPartition)x0$1._1();
                LeaderAndIsr v = (LeaderAndIsr)x0$1._2();
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)k), (Object)package$.MODULE$.Right().apply((Object)v));
            }
            throw new MatchError(null);
        }, Map$.MODULE$.canBuildFrom()), (Seq)Nil$.MODULE$));
    }

    public static final /* synthetic */ TopicPartition $anonfun$testUpdatingOfflinePartitionsCount$1(String topic$1, int x$1) {
        return new TopicPartition(topic$1, x$1);
    }

    public static final /* synthetic */ void $anonfun$testUpdatingOfflinePartitionsCount$2(PartitionStateMachineTest $this, TopicPartition partition) {
        $this.controllerContext().updatePartitionFullReplicaAssignment(partition, ReplicaAssignment$.MODULE$.apply((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{$this.brokerId()}))));
    }

    public static final /* synthetic */ TopicPartition $anonfun$testNoOfflinePartitionsChangeForTopicsBeingDeleted$1(String topic$2, int x$2) {
        return new TopicPartition(topic$2, x$2);
    }

    public static final /* synthetic */ TopicPartition $anonfun$testUpdatingOfflinePartitionsCountDuringTopicDeletion$1(int x$3) {
        return new TopicPartition("test", x$3);
    }

    public static final /* synthetic */ void $anonfun$testUpdatingOfflinePartitionsCountDuringTopicDeletion$2(PartitionStateMachineTest $this, TopicPartition partition) {
        $this.controllerContext().updatePartitionFullReplicaAssignment(partition, ReplicaAssignment$.MODULE$.apply((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{$this.brokerId()}))));
    }

    public static final /* synthetic */ void $anonfun$testUpdatingOfflinePartitionsCountDuringTopicDeletion$3(PartitionStateMachineTest $this, TopicPartition partition) {
        PartitionAndReplica replica = new PartitionAndReplica(partition, $this.brokerId());
        $this.controllerContext().putReplicaState(replica, (ReplicaState)OfflineReplica$.MODULE$);
    }

    public PartitionStateMachineTest() {
        this.brokerId = 5;
        this.controllerEpoch = 50;
    }
}

