/*
 * Decompiled with CFR 0.152.
 */
package kafka.coordinator.transaction;

import java.io.Serializable;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import kafka.coordinator.transaction.ProducerIdManager$;
import kafka.coordinator.transaction.ProducerIdManagerTest$MockProducerIdManager$;
import kafka.coordinator.transaction.RPCProducerIdManager;
import kafka.coordinator.transaction.ZkProducerIdManager;
import kafka.utils.TestUtils$;
import kafka.zk.KafkaZkClient;
import kafka.zk.ProducerIdBlockZNode$;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.errors.CoordinatorLoadInProgressException;
import org.apache.kafka.common.message.AllocateProducerIdsResponseData;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.AllocateProducerIdsResponse;
import org.apache.kafka.common.utils.MockTime;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.server.NodeToControllerChannelManager;
import org.apache.kafka.server.common.ProducerIdsBlock;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.EnumSource;
import org.junit.jupiter.params.provider.ValueSource;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.RichLong;
import scala.runtime.RichLong$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;

@ScalaSignature(bytes="\u0006\u0001\tec\u0001\u0002\u0017.\u0001QBQa\u000f\u0001\u0005\u0002qBqa\u0010\u0001A\u0002\u0013\u0005\u0001\tC\u0004M\u0001\u0001\u0007I\u0011A'\t\rM\u0003\u0001\u0015)\u0003B\u0011\u001d!\u0006A1A\u0005\u0002UCa\u0001\u0018\u0001!\u0002\u00131f\u0001B/\u0001\u0001yC\u0001BY\u0004\u0003\u0006\u0004%\ta\u0019\u0005\tO\u001e\u0011\t\u0011)A\u0005I\"A\u0001n\u0002BA\u0002\u0013\u0005\u0011\u000e\u0003\u0005n\u000f\t\u0005\r\u0011\"\u0001o\u0011!\u0001xA!A!B\u0013Q\u0007\u0002C9\b\u0005\u000b\u0007I\u0011A2\t\u0011I<!\u0011!Q\u0001\n\u0011D\u0001b]\u0004\u0003\u0006\u0004%\t\u0001\u001e\u0005\n\u0003\u001f9!\u0011!Q\u0001\nUD!\"!\u0005\b\u0005\u000b\u0007I\u0011AA\n\u0011)\tYb\u0002B\u0001B\u0003%\u0011Q\u0003\u0005\u000b\u0003;9!Q1A\u0005\u0002\u0005}\u0001BCA\u0017\u000f\t\u0005\t\u0015!\u0003\u0002\"!11h\u0002C\u0001\u0003_A\u0011\"!\u0011\b\u0005\u0004%I!a\u0011\t\u0011\u0005-s\u0001)A\u0005\u0003\u000bB\u0011\"!\u0014\b\u0005\u0004%\t!a\u0014\t\u0011\u0005us\u0001)A\u0005\u0003#B\u0001\"a\u0018\b\t\u0003j\u0013\u0011\r\u0005\t\u0003G:A\u0011I\u0017\u0002f\u001dI\u0011q\u000f\u0001\u0002\u0002#\u0005\u0011\u0011\u0010\u0004\t;\u0002\t\t\u0011#\u0001\u0002|!11(\bC\u0001\u0003{B\u0011\"a \u001e#\u0003%\t!!!\t\u0013\u0005]U$%A\u0005\u0002\u0005e\u0005\"CAO;E\u0005I\u0011AAP\u0011\u001d\t\u0019\u000b\u0001C\u0001\u0003CBq!a/\u0001\t\u0003\t\t\u0007C\u0004\u0002@\u0002!\t!!1\t\u000f\u0005=\b\u0001\"\u0001\u0002r\"9!\u0011\u0003\u0001\u0005\u0002\u0005\u0005\u0004b\u0002B\u000b\u0001\u0011\u0005\u0011\u0011\r\u0005\b\u00053\u0001A\u0011\u0002B\u000e\u0011\u001d\u00119\u0003\u0001C\u0005\u0005SAqAa\f\u0001\t\u0013\u0011\t\u0004C\u0004\u0003H\u0001!IA!\u0013\u0003+A\u0013x\u000eZ;dKJLE-T1oC\u001e,'\u000fV3ti*\u0011afL\u0001\fiJ\fgn]1di&|gN\u0003\u00021c\u0005Y1m\\8sI&t\u0017\r^8s\u0015\u0005\u0011\u0014!B6bM.\f7\u0001A\n\u0003\u0001U\u0002\"AN\u001d\u000e\u0003]R\u0011\u0001O\u0001\u0006g\u000e\fG.Y\u0005\u0003u]\u0012a!\u00118z%\u00164\u0017A\u0002\u001fj]&$h\bF\u0001>!\tq\u0004!D\u0001.\u0003I\u0011'o\\6feR{7i\u001c8ue>dG.\u001a:\u0016\u0003\u0005\u0003\"A\u0011&\u000e\u0003\rS!\u0001R#\u0002\rM,'O^3s\u0015\t\u0011dI\u0003\u0002H\u0011\u00061\u0011\r]1dQ\u0016T\u0011!S\u0001\u0004_J<\u0017BA&D\u0005yqu\u000eZ3U_\u000e{g\u000e\u001e:pY2,'o\u00115b]:,G.T1oC\u001e,'/\u0001\fce>\\WM\u001d+p\u0007>tGO]8mY\u0016\u0014x\fJ3r)\tq\u0015\u000b\u0005\u00027\u001f&\u0011\u0001k\u000e\u0002\u0005+:LG\u000fC\u0004S\u0007\u0005\u0005\t\u0019A!\u0002\u0007a$\u0013'A\nce>\\WM\u001d+p\u0007>tGO]8mY\u0016\u0014\b%\u0001\u0005{W\u000ec\u0017.\u001a8u+\u00051\u0006CA,[\u001b\u0005A&BA-2\u0003\tQ8.\u0003\u0002\\1\ni1*\u00194lCj[7\t\\5f]R\f\u0011B_6DY&,g\u000e\u001e\u0011\u0003+5{7m\u001b)s_\u0012,8-\u001a:JI6\u000bg.Y4feN\u0011qa\u0018\t\u0003}\u0001L!!Y\u0017\u0003)I\u00036\t\u0015:pIV\u001cWM]%e\u001b\u0006t\u0017mZ3s\u0003!\u0011'o\\6fe&#W#\u00013\u0011\u0005Y*\u0017B\u000148\u0005\rIe\u000e^\u0001\nEJ|7.\u001a:JI\u0002\nq!\u001b3Ti\u0006\u0014H/F\u0001k!\t14.\u0003\u0002mo\t!Aj\u001c8h\u0003-IGm\u0015;beR|F%Z9\u0015\u00059{\u0007b\u0002*\f\u0003\u0003\u0005\rA[\u0001\tS\u0012\u001cF/\u0019:uA\u0005)\u0011\u000e\u001a'f]\u00061\u0011\u000e\u001a'f]\u0002\n!\"\u001a:s_J\fV/Z;f+\u0005)\bc\u0001<~\u007f6\tqO\u0003\u0002ys\u0006Q1m\u001c8dkJ\u0014XM\u001c;\u000b\u0005i\\\u0018\u0001B;uS2T\u0011\u0001`\u0001\u0005U\u00064\u0018-\u0003\u0002\u007fo\n)2i\u001c8dkJ\u0014XM\u001c;MS:\\W\rZ)vKV,\u0007\u0003BA\u0001\u0003\u0017i!!a\u0001\u000b\t\u0005\u0015\u0011qA\u0001\taJ|Go\\2pY*\u0019\u0011\u0011B#\u0002\r\r|W.\\8o\u0013\u0011\ti!a\u0001\u0003\r\u0015\u0013(o\u001c:t\u0003-)'O]8s#V,W/\u001a\u0011\u0002!%\u001cXI\u001d:p]\u0016|Wo\u001d\"m_\u000e\\WCAA\u000b!\r1\u0014qC\u0005\u0004\u000339$a\u0002\"p_2,\u0017M\\\u0001\u0012SN,%O]8oK>,8O\u00117pG.\u0004\u0013\u0001\u0002;j[\u0016,\"!!\t\u0011\t\u0005\r\u0012\u0011F\u0007\u0003\u0003KQA!a\n\u0002\b\u0005)Q\u000f^5mg&!\u00111FA\u0013\u0005\u0011!\u0016.\\3\u0002\u000bQLW.\u001a\u0011\u0015\u001d\u0005E\u0012QGA\u001c\u0003s\tY$!\u0010\u0002@A\u0019\u00111G\u0004\u000e\u0003\u0001AQAY\u000bA\u0002\u0011DQ\u0001[\u000bA\u0002)DQ!]\u000bA\u0002\u0011Dqa]\u000b\u0011\u0002\u0003\u0007Q\u000fC\u0005\u0002\u0012U\u0001\n\u00111\u0001\u0002\u0016!I\u0011QD\u000b\u0011\u0002\u0003\u0007\u0011\u0011E\u0001\"EJ|7.\u001a:U_\u000e{g\u000e\u001e:pY2,'OU3rk\u0016\u001cH/\u0012=fGV$xN]\u000b\u0003\u0003\u000b\u00022A^A$\u0013\r\tIe\u001e\u0002\u0010\u000bb,7-\u001e;peN+'O^5dK\u0006\u0011#M]8lKJ$vnQ8oiJ|G\u000e\\3s%\u0016\fX/Z:u\u000bb,7-\u001e;pe\u0002\nqbY1qiV\u0014X\r\u001a$bS2,(/Z\u000b\u0003\u0003#\u0002B!a\u0015\u0002Z5\u0011\u0011Q\u000b\u0006\u0004\u0003/:\u0018AB1u_6L7-\u0003\u0003\u0002\\\u0005U#!D!u_6L7MQ8pY\u0016\fg.\u0001\tdCB$XO]3e\r\u0006LG.\u001e:fA\u0005Y1/\u001a8e%\u0016\fX/Z:u)\u0005q\u0015!\t5b]\u0012dW-\u00117m_\u000e\fG/\u001a)s_\u0012,8-\u001a:JIN\u0014Vm\u001d9p]N,Gc\u0001(\u0002h!9\u0011\u0011N\u000eA\u0002\u0005-\u0014\u0001\u0003:fgB|gn]3\u0011\t\u00055\u00141O\u0007\u0003\u0003_RA!!\u001d\u0002\b\u0005A!/Z9vKN$8/\u0003\u0003\u0002v\u0005=$aG!mY>\u001c\u0017\r^3Qe>$WoY3s\u0013\u0012\u001c(+Z:q_:\u001cX-A\u000bN_\u000e\\\u0007K]8ek\u000e,'/\u00133NC:\fw-\u001a:\u0011\u0007\u0005MRd\u0005\u0002\u001ekQ\u0011\u0011\u0011P\u0001\u001cI1,7o]5oSR$sM]3bi\u0016\u0014H\u0005Z3gCVdG\u000f\n\u001b\u0016\u0005\u0005\r%fA;\u0002\u0006.\u0012\u0011q\u0011\t\u0005\u0003\u0013\u000b\u0019*\u0004\u0002\u0002\f*!\u0011QRAH\u0003%)hn\u00195fG.,GMC\u0002\u0002\u0012^\n!\"\u00198o_R\fG/[8o\u0013\u0011\t)*a#\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW-A\u000e%Y\u0016\u001c8/\u001b8ji\u0012:'/Z1uKJ$C-\u001a4bk2$H%N\u000b\u0003\u00037SC!!\u0006\u0002\u0006\u0006YB\u0005\\3tg&t\u0017\u000e\u001e\u0013he\u0016\fG/\u001a:%I\u00164\u0017-\u001e7uIY*\"!!)+\t\u0005\u0005\u0012QQ\u0001\u0014i\u0016\u001cHoR3u!J|G-^2fe&#'l\u001b\u0015\u0004E\u0005\u001d\u0006\u0003BAU\u0003ok!!a+\u000b\t\u00055\u0016qV\u0001\u0004CBL'\u0002BAY\u0003g\u000bqA[;qSR,'OC\u0002\u00026\"\u000bQA[;oSRLA!!/\u0002,\n!A+Z:u\u0003m!Xm\u001d;Fq\u000e,W\r\u001a)s_\u0012,8-\u001a:JI2KW.\u001b;[W\"\u001a1%a*\u0002CQ,7\u000f^\"p]\u000e,(O]3oi\u001e+g.\u001a:bi\u0016\u0004\u0016\u000e\u001a*fcV,7\u000f^:\u0015\u00079\u000b\u0019\r\u0003\u0004\u0002F\u0012\u0002\r\u0001Z\u0001\u000bS\u0012\u0014En\\2l\u0019\u0016t\u0007f\u0002\u0013\u0002J\u0006e\u00171\u001c\t\u0005\u0003\u0017\f).\u0004\u0002\u0002N*!\u0011qZAi\u0003!\u0001(o\u001c<jI\u0016\u0014(\u0002BAj\u0003_\u000ba\u0001]1sC6\u001c\u0018\u0002BAl\u0003\u001b\u00141BV1mk\u0016\u001cv.\u001e:dK\u0006!\u0011N\u001c;tY!\ti.a8\u0002b\u0006\rX$A\u0001\u001e\u0003\ti\u0012AC\u000f\u0002I\"\u001aA%a:\u0011\t\u0005%\u00181^\u0007\u0003\u0003#LA!!<\u0002R\n\t\u0002+\u0019:b[\u0016$XM]5{K\u0012$Vm\u001d;\u0002/Q,7\u000f^+oe\u0016\u001cwN^3sC\ndW-\u0012:s_J\u001cHc\u0001(\u0002t\"1\u0011Q_\u0013A\u0002}\fQ!\u001a:s_JD3\"JA}\u0003\u007f\u0014\tAa\u0001\u0003\u0006A!\u00111ZA~\u0013\u0011\ti0!4\u0003\u0015\u0015sW/\\*pkJ\u001cW-A\u0003wC2,XmI\u0001\u0000\u0003\u0015q\u0017-\\3tY\u0011\u00119Aa\u0003\"\u0005\t%\u0011\u0001F+O\u0017:{uKT0T\u000bJ3VIU0F%J{%+\t\u0002\u0003\u000e\u0005y\u0011J\u0014,B\u0019&#uLU#R+\u0016\u001bF\u000bK\u0002&\u0003O\f\u0011\u0003^3ti&sg/\u00197jIJ\u000bgnZ3tQ\r1\u0013qU\u0001\u0011i\u0016\u001cHOU3uef\u0014\u0015mY6pM\u001aD3aJAT\u0003\u0015\tX/Z;f)\r)(Q\u0004\u0005\b\u0005?A\u0003\u0019\u0001B\u0011\u0003\u0019)'O]8sgB!aGa\t\u0000\u0013\r\u0011)c\u000e\u0002\u000byI,\u0007/Z1uK\u0012t\u0014!\u0004<fe&4\u0017PR1jYV\u0014X\rF\u0002O\u0005WAqA!\f*\u0001\u0004\t\t$A\u0004nC:\fw-\u001a:\u00027Y,'/\u001b4z\u001d\u0016<(\t\\8dW\u0006sG\r\u0015:pIV\u001cWM]%e)\u001dq%1\u0007B\u001b\u0005\u0007BqA!\f+\u0001\u0004\t\t\u0004C\u0004\u00038)\u0002\rA!\u000f\u0002\u001b\u0015D\b/Z2uK\u0012\u0014En\\2l!\u0011\u0011YDa\u0010\u000e\u0005\tu\"bAA\u0005\u0007&!!\u0011\tB\u001f\u0005A\u0001&o\u001c3vG\u0016\u0014\u0018\nZ:CY>\u001c7\u000e\u0003\u0004\u0003F)\u0002\rA[\u0001\fKb\u0004Xm\u0019;fIBKG-A\u0018bgN,'\u000f^\"p_J$\u0017N\\1u_Jdu.\u00193J]B\u0013xn\u001a:fgN,\u0005pY3qi&|gNR1jYV\u0014X\rF\u0002O\u0005\u0017BqA!\u0014,\u0001\u0004\u0011y%A\nhK:,'/\u0019;fIB\u0013x\u000eZ;dKJLE\rE\u0003\u0003R\tU#.\u0004\u0002\u0003T)\u0011!pN\u0005\u0005\u0005/\u0012\u0019FA\u0002Uef\u0004")
public class ProducerIdManagerTest {
    private volatile ProducerIdManagerTest$MockProducerIdManager$ MockProducerIdManager$module;
    private NodeToControllerChannelManager brokerToController = (NodeToControllerChannelManager)Mockito.mock(NodeToControllerChannelManager.class);
    private final KafkaZkClient zkClient = (KafkaZkClient)Mockito.mock(KafkaZkClient.class);

    public ProducerIdManagerTest$MockProducerIdManager$ MockProducerIdManager() {
        if (this.MockProducerIdManager$module == null) {
            this.MockProducerIdManager$lzycompute$1();
        }
        return this.MockProducerIdManager$module;
    }

    public NodeToControllerChannelManager brokerToController() {
        return this.brokerToController;
    }

    public void brokerToController_$eq(NodeToControllerChannelManager x$1) {
        this.brokerToController = x$1;
    }

    public KafkaZkClient zkClient() {
        return this.zkClient;
    }

    @Test
    public void testGetProducerIdZk() {
        ObjectRef zkVersion = ObjectRef.create((Object)None$.MODULE$);
        ObjectRef data = ObjectRef.create(null);
        Mockito.when((Object)this.zkClient().getDataAndVersion(ArgumentMatchers.anyString())).thenAnswer(x$1 -> (Tuple2)((Option)zkVersion$1.elem).map((Function1 & Serializable & scala.Serializable)x$2 -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new Some((Object)((byte[])data.elem))), (Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)x$2)))).getOrElse((Function0 & Serializable & scala.Serializable)() -> new Tuple2((Object)None$.MODULE$, (Object)BoxesRunTime.boxToInteger((int)0))));
        ArgumentCaptor capturedVersion = ArgumentCaptor.forClass(Integer.TYPE);
        ArgumentCaptor capturedData = ArgumentCaptor.forClass(byte[].class);
        Mockito.when((Object)this.zkClient().conditionalUpdatePath(ArgumentMatchers.anyString(), (byte[])capturedData.capture(), BoxesRunTime.unboxToInt((Object)capturedVersion.capture()), (Option)ArgumentMatchers.any())).thenAnswer(x$3 -> {
            int newZkVersion = BoxesRunTime.unboxToInt((Object)capturedVersion.getValue()) + 1;
            zkVersion$1.elem = new Some((Object)BoxesRunTime.boxToInteger((int)newZkVersion));
            data$1.elem = (byte[])capturedData.getValue();
            return new Tuple2.mcZI.sp(true, newZkVersion);
        });
        ZkProducerIdManager manager1 = new ZkProducerIdManager(0, this.zkClient());
        ZkProducerIdManager manager2 = new ZkProducerIdManager(1, this.zkClient());
        long pid1 = BoxesRunTime.unboxToLong((Object)manager1.generateProducerId().get());
        long pid2 = BoxesRunTime.unboxToLong((Object)manager2.generateProducerId().get());
        Assertions.assertEquals((long)0L, (long)pid1);
        Assertions.assertEquals((long)1000L, (long)pid2);
        new RichLong(Predef$.MODULE$.longWrapper(1L)).until((Object)BoxesRunTime.boxToLong((long)1000L)).foreach((Function1)(JFunction1.mcVJ.sp & Serializable & scala.Serializable)i -> Assertions.assertEquals((long)(pid1 + i), (long)BoxesRunTime.unboxToLong((Object)manager1.generateProducerId().get())));
        new RichLong(Predef$.MODULE$.longWrapper(1L)).until((Object)BoxesRunTime.boxToLong((long)1000L)).foreach((Function1)(JFunction1.mcVJ.sp & Serializable & scala.Serializable)i -> Assertions.assertEquals((long)(pid2 + i), (long)BoxesRunTime.unboxToLong((Object)manager2.generateProducerId().get())));
        Assertions.assertEquals((long)(pid2 + 1000L), (long)BoxesRunTime.unboxToLong((Object)manager1.generateProducerId().get()));
        Assertions.assertEquals((long)(pid2 + 2000L), (long)BoxesRunTime.unboxToLong((Object)manager2.generateProducerId().get()));
    }

    @Test
    public void testExceedProducerIdLimitZk() {
        Mockito.when((Object)this.zkClient().getDataAndVersion(ArgumentMatchers.anyString())).thenAnswer(x$4 -> {
            byte[] json = ProducerIdBlockZNode$.MODULE$.generateProducerIdBlockJson(new ProducerIdsBlock(0, 9223372036854774807L, 1000));
            return new Tuple2((Object)new Some((Object)json), (Object)BoxesRunTime.boxToInteger((int)0));
        });
        Assertions.assertThrows(KafkaException.class, () -> new ZkProducerIdManager(0, this.zkClient()));
    }

    @ParameterizedTest
    @ValueSource(ints={1, 2, 10, 100})
    public void testConcurrentGeneratePidRequests(int idBlockLen) {
        int numThreads = 5;
        CountDownLatch latch = new CountDownLatch(idBlockLen * 3);
        MockProducerIdManager manager = new MockProducerIdManager(this, 0, 0L, idBlockLen, this.MockProducerIdManager().$lessinit$greater$default$4(), this.MockProducerIdManager().$lessinit$greater$default$5(), this.MockProducerIdManager().$lessinit$greater$default$6());
        Map pidMap = (Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
        ExecutorService requestHandlerThreadPool = Executors.newFixedThreadPool(numThreads);
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numThreads).foreach((Function1 & Serializable & scala.Serializable)_ -> requestHandlerThreadPool.submit(() -> {
            while (latch$1.getCount() > 0L) {
                Try result = manager$1.generateProducerId();
                if (result instanceof Success) {
                    long pid = BoxesRunTime.unboxToLong((Object)((Success)result).value());
                    synchronized (pidMap$1) {
                        if (latch$1.getCount() != 0L) {
                            int counter = BoxesRunTime.unboxToInt((Object)pidMap$1.getOrElse((Object)BoxesRunTime.boxToLong((long)pid), (Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> 0));
                            pidMap$1.$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToLong((long)pid)), (Object)BoxesRunTime.boxToInteger((int)(counter + 1))));
                            latch$1.countDown();
                        }
                    }
                } else if (result instanceof Failure) {
                    Throwable exception = ((Failure)result).exception();
                    Assertions.assertEquals(CoordinatorLoadInProgressException.class, exception.getClass());
                } else {
                    throw new MatchError((Object)result);
                }
                Thread.sleep(100L);
            }
        }, BoxesRunTime.boxToInteger((int)0)));
        Assertions.assertTrue((boolean)latch.await(12000L, TimeUnit.MILLISECONDS));
        requestHandlerThreadPool.shutdown();
        Assertions.assertEquals((int)(idBlockLen * 3), (int)pidMap.size());
        pidMap.foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            ProducerIdManagerTest.$anonfun$testConcurrentGeneratePidRequests$4(idBlockLen, numThreads, x0$1);
            return BoxedUnit.UNIT;
        });
    }

    @ParameterizedTest
    @EnumSource(value=Errors.class, names={"UNKNOWN_SERVER_ERROR", "INVALID_REQUEST"})
    public void testUnrecoverableErrors(Errors error) {
        MockTime time = new MockTime();
        int x$1 = 0;
        long x$2 = 0L;
        int x$3 = 1;
        ConcurrentLinkedQueue<Errors> x$4 = this.queue((Seq<Errors>)Predef$.MODULE$.wrapRefArray((Object[])new Errors[]{Errors.NONE, error}));
        boolean x$6 = this.MockProducerIdManager().$lessinit$greater$default$5();
        MockProducerIdManager manager = new MockProducerIdManager(this, x$1, x$2, x$3, x$4, x$6, (Time)time);
        this.verifyNewBlockAndProducerId(manager, new ProducerIdsBlock(0, 0L, 1), 0L);
        this.verifyFailure(manager);
        time.sleep((long)ProducerIdManager$.MODULE$.RetryBackoffMs());
        this.verifyNewBlockAndProducerId(manager, new ProducerIdsBlock(0, 1L, 1), 1L);
    }

    @Test
    public void testInvalidRanges() {
        int x$1 = 0;
        long x$2 = -1L;
        int x$3 = 10;
        boolean x$4 = true;
        ConcurrentLinkedQueue<Errors> x$5 = this.MockProducerIdManager().$lessinit$greater$default$4();
        Time x$6 = this.MockProducerIdManager().$lessinit$greater$default$6();
        MockProducerIdManager manager = new MockProducerIdManager(this, x$1, x$2, x$3, x$5, x$4, x$6);
        this.verifyFailure(manager);
        int x$7 = 0;
        long x$8 = 0L;
        int x$9 = -1;
        boolean x$10 = true;
        ConcurrentLinkedQueue<Errors> x$11 = this.MockProducerIdManager().$lessinit$greater$default$4();
        Time x$12 = this.MockProducerIdManager().$lessinit$greater$default$6();
        manager = new MockProducerIdManager(this, x$7, x$8, x$9, x$11, x$10, x$12);
        this.verifyFailure(manager);
        int x$13 = 0;
        long x$14 = 0x7FFFFFFFFFFFFFFEL;
        int x$15 = 10;
        boolean x$16 = true;
        ConcurrentLinkedQueue<Errors> x$17 = this.MockProducerIdManager().$lessinit$greater$default$4();
        Time x$18 = this.MockProducerIdManager().$lessinit$greater$default$6();
        manager = new MockProducerIdManager(this, x$13, x$14, x$15, x$17, x$16, x$18);
        this.verifyFailure(manager);
    }

    @Test
    public void testRetryBackoff() {
        MockTime time = new MockTime();
        int x$1 = 0;
        long x$2 = 0L;
        int x$3 = 1;
        ConcurrentLinkedQueue<Errors> x$4 = this.queue((Seq<Errors>)Predef$.MODULE$.wrapRefArray((Object[])new Errors[]{Errors.UNKNOWN_SERVER_ERROR}));
        boolean x$6 = this.MockProducerIdManager().$lessinit$greater$default$5();
        MockProducerIdManager manager = new MockProducerIdManager(this, x$1, x$2, x$3, x$4, x$6, (Time)time);
        this.verifyFailure(manager);
        this.assertCoordinatorLoadInProgressExceptionFailure((Try<Object>)manager.generateProducerId());
        time.sleep((long)ProducerIdManager$.MODULE$.RetryBackoffMs());
        this.verifyNewBlockAndProducerId(manager, new ProducerIdsBlock(0, 0L, 1), 0L);
    }

    private ConcurrentLinkedQueue<Errors> queue(Seq<Errors> errors) {
        ConcurrentLinkedQueue<Errors> queue = new ConcurrentLinkedQueue<Errors>();
        errors.foreach((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)queue.add(x$1)));
        return queue;
    }

    /*
     * WARNING - void declaration
     */
    private void verifyFailure(MockProducerIdManager manager) {
        this.assertCoordinatorLoadInProgressExceptionFailure((Try<Object>)manager.generateProducerId());
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!ProducerIdManagerTest.$anonfun$verifyFailure$1(manager)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)ProducerIdManagerTest.$anonfun$verifyFailure$2());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        manager.capturedFailure().set(false);
    }

    /*
     * WARNING - void declaration
     */
    private void verifyNewBlockAndProducerId(MockProducerIdManager manager, ProducerIdsBlock expectedBlock, long expectedPid) {
        this.assertCoordinatorLoadInProgressExceptionFailure((Try<Object>)manager.generateProducerId());
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!ProducerIdManagerTest.$anonfun$verifyNewBlockAndProducerId$1(manager, expectedBlock)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)ProducerIdManagerTest.$anonfun$verifyNewBlockAndProducerId$2());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        Assertions.assertEquals((long)expectedPid, (long)BoxesRunTime.unboxToLong((Object)manager.generateProducerId().get()));
    }

    private void assertCoordinatorLoadInProgressExceptionFailure(Try<Object> generatedProducerId) {
        Assertions.assertTrue((boolean)generatedProducerId.isFailure(), () -> new StringBuilder(37).append("expected failure but got producerId: ").append(generatedProducerId.get()).toString());
        Assertions.assertEquals(CoordinatorLoadInProgressException.class, generatedProducerId.failed().get().getClass());
    }

    private final void MockProducerIdManager$lzycompute$1() {
        synchronized (this) {
            if (this.MockProducerIdManager$module == null) {
                this.MockProducerIdManager$module = new ProducerIdManagerTest$MockProducerIdManager$(this);
            }
            return;
        }
    }

    public static final /* synthetic */ void $anonfun$testConcurrentGeneratePidRequests$4(int idBlockLen$1, int numThreads$1, Tuple2 x0$1) {
        if (x0$1 != null) {
            long pid = x0$1._1$mcJ$sp();
            int count = x0$1._2$mcI$sp();
            Assertions.assertEquals((int)1, (int)count);
            Assertions.assertTrue((pid < (long)(3 * idBlockLen$1 + numThreads$1) ? 1 : 0) != 0, (String)new StringBuilder(81).append("Unexpected pid ").append(pid).append("; ").append("non-contiguous blocks generated or did not fully exhaust blocks.").toString());
            return;
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ boolean $anonfun$verifyFailure$1(MockProducerIdManager manager$2) {
        synchronized (manager$2) {
            boolean bl = manager$2.capturedFailure().get();
            return bl;
        }
    }

    public static final /* synthetic */ String $anonfun$verifyFailure$2() {
        return "Expected failure";
    }

    public static final /* synthetic */ boolean $anonfun$verifyNewBlockAndProducerId$1(MockProducerIdManager manager$3, ProducerIdsBlock expectedBlock$1) {
        ProducerIdsBlock nextBlock = (ProducerIdsBlock)manager$3.nextProducerIdBlock().get();
        return nextBlock != null && nextBlock.equals((Object)expectedBlock$1);
    }

    public static final /* synthetic */ String $anonfun$verifyNewBlockAndProducerId$2() {
        return "failed to generate block";
    }

    public class MockProducerIdManager
    extends RPCProducerIdManager {
        private final int brokerId;
        private long idStart;
        private final int idLen;
        private final ConcurrentLinkedQueue<Errors> errorQueue;
        private final boolean isErroneousBlock;
        private final Time time;
        private final ExecutorService brokerToControllerRequestExecutor;
        private final AtomicBoolean capturedFailure;
        public final /* synthetic */ ProducerIdManagerTest $outer;

        public int brokerId() {
            return this.brokerId;
        }

        public long idStart() {
            return this.idStart;
        }

        public void idStart_$eq(long x$1) {
            this.idStart = x$1;
        }

        public int idLen() {
            return this.idLen;
        }

        public ConcurrentLinkedQueue<Errors> errorQueue() {
            return this.errorQueue;
        }

        public boolean isErroneousBlock() {
            return this.isErroneousBlock;
        }

        public Time time() {
            return this.time;
        }

        private ExecutorService brokerToControllerRequestExecutor() {
            return this.brokerToControllerRequestExecutor;
        }

        public AtomicBoolean capturedFailure() {
            return this.capturedFailure;
        }

        public void sendRequest() {
            this.brokerToControllerRequestExecutor().submit(() -> {
                Errors error = this.errorQueue().poll();
                if (error == null || error.equals(Errors.NONE)) {
                    this.handleAllocateProducerIdsResponse(new AllocateProducerIdsResponse(new AllocateProducerIdsResponseData().setProducerIdStart(this.idStart()).setProducerIdLen(this.idLen())));
                    if (!this.isErroneousBlock()) {
                        this.idStart_$eq(this.idStart() + (long)this.idLen());
                        return;
                    }
                    return;
                }
                this.handleAllocateProducerIdsResponse(new AllocateProducerIdsResponse(new AllocateProducerIdsResponseData().setErrorCode(error.code())));
            }, BoxesRunTime.boxToInteger((int)0));
        }

        public void handleAllocateProducerIdsResponse(AllocateProducerIdsResponse response) {
            super.handleAllocateProducerIdsResponse(response);
            this.capturedFailure().set(this.nextProducerIdBlock().get() == null);
        }

        public /* synthetic */ ProducerIdManagerTest kafka$coordinator$transaction$ProducerIdManagerTest$MockProducerIdManager$$$outer() {
            return this.$outer;
        }

        public MockProducerIdManager(ProducerIdManagerTest $outer, int brokerId, long idStart, int idLen, ConcurrentLinkedQueue<Errors> errorQueue, boolean isErroneousBlock, Time time) {
            this.brokerId = brokerId;
            this.idStart = idStart;
            this.idLen = idLen;
            this.errorQueue = errorQueue;
            this.isErroneousBlock = isErroneousBlock;
            this.time = time;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            super(brokerId, time, (Function0)new scala.Serializable(null){
                public static final long serialVersionUID = 0L;

                public final long apply() {
                    return this.apply$mcJ$sp();
                }

                public long apply$mcJ$sp() {
                    return 1L;
                }
            }, $outer.brokerToController());
            this.brokerToControllerRequestExecutor = Executors.newSingleThreadExecutor();
            this.capturedFailure = new AtomicBoolean(false);
        }
    }
}

