/*
 * Decompiled with CFR 0.152.
 */
package kafka.coordinator.transaction;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kafka.coordinator.transaction.CoordinatorEpochAndTxnMetadata;
import kafka.coordinator.transaction.PendingCompleteTxn;
import kafka.coordinator.transaction.PendingCompleteTxnAndMarkerEntry;
import kafka.coordinator.transaction.PrepareCommit$;
import kafka.coordinator.transaction.TransactionMarkerChannelManager;
import kafka.coordinator.transaction.TransactionMarkerRequestCompletionHandler;
import kafka.coordinator.transaction.TransactionMetadata;
import kafka.coordinator.transaction.TransactionState;
import kafka.coordinator.transaction.TransactionStateManager;
import org.apache.kafka.clients.ClientResponse;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.AbstractResponse;
import org.apache.kafka.common.requests.RequestHeader;
import org.apache.kafka.common.requests.TransactionResult;
import org.apache.kafka.common.requests.WriteTxnMarkersRequest;
import org.apache.kafka.common.requests.WriteTxnMarkersResponse;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import scala.Predef$;
import scala.Some;
import scala.collection.Seq;
import scala.collection.mutable.Set;
import scala.collection.mutable.Set$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\t\u001da\u0001B\u001d;\u0001\u0005CQ\u0001\u0013\u0001\u0005\u0002%Cq\u0001\u0014\u0001C\u0002\u0013%Q\n\u0003\u0004R\u0001\u0001\u0006IA\u0014\u0005\b%\u0002\u0011\r\u0011\"\u0003N\u0011\u0019\u0019\u0006\u0001)A\u0005\u001d\"9A\u000b\u0001b\u0001\n\u0013)\u0006B\u00020\u0001A\u0003%a\u000bC\u0004`\u0001\t\u0007I\u0011\u00021\t\r\u0011\u0004\u0001\u0015!\u0003b\u0011\u001d)\u0007A1A\u0005\n\u0019DaA\u001b\u0001!\u0002\u00139\u0007bB6\u0001\u0005\u0004%IA\u001a\u0005\u0007Y\u0002\u0001\u000b\u0011B4\t\u000f5\u0004!\u0019!C\u0005\u001b\"1a\u000e\u0001Q\u0001\n9Cqa\u001c\u0001C\u0002\u0013%Q\n\u0003\u0004q\u0001\u0001\u0006IA\u0014\u0005\bc\u0002\u0011\r\u0011\"\u0003s\u0011\u001d\t\t\u0001\u0001Q\u0001\nMD\u0011\"a\u0001\u0001\u0005\u0004%I!!\u0002\t\u0011\u0005=\u0001\u0001)A\u0005\u0003\u000fA\u0011\"!\u0005\u0001\u0005\u0004%I!a\u0005\t\u0011\u0005m\u0001\u0001)A\u0005\u0003+A\u0011\"!\b\u0001\u0005\u0004%I!a\b\t\u0011\u0005M\u0002\u0001)A\u0005\u0003CA\u0011\"!\u000e\u0001\u0005\u0004%I!a\u000e\t\u0011\u0005}\u0002\u0001)A\u0005\u0003sA\u0011\"!\u0011\u0001\u0005\u0004%I!a\u0011\t\u0011\u0005-\u0003\u0001)A\u0005\u0003\u000bB\u0011\"!\u0014\u0001\u0005\u0004%I!a\u0014\t\u0011\u0005]\u0003\u0001)A\u0005\u0003#Bq!!\u0017\u0001\t\u0013\tY\u0006C\u0004\u0002d\u0001!\t!a\u0017\t\u000f\u0005m\u0004\u0001\"\u0001\u0002\\!9\u0011q\u0010\u0001\u0005\u0002\u0005m\u0003bBAB\u0001\u0011\u0005\u00111\f\u0005\b\u0003\u000f\u0003A\u0011AA.\u0011\u001d\tY\t\u0001C\u0001\u00037Bq!a$\u0001\t\u0003\tY\u0006C\u0004\u0002\u0014\u0002!\t!a\u0017\t\u000f\u0005]\u0005\u0001\"\u0001\u0002\\!9\u00111\u0014\u0001\u0005\u0002\u0005m\u0003bBAP\u0001\u0011\u0005\u00111\f\u0005\b\u0003G\u0003A\u0011AA.\u0011\u001d\t9\u000b\u0001C\u0001\u00037Bq!a+\u0001\t\u0003\tY\u0006C\u0004\u00020\u0002!\t!a\u0017\t\u000f\u0005M\u0006\u0001\"\u0001\u0002\\!9\u0011q\u0017\u0001\u0005\u0002\u0005m\u0003bBA^\u0001\u0011\u0005\u00111\f\u0005\b\u0003\u007f\u0003A\u0011AA.\u0011\u001d\t\u0019\r\u0001C\u0005\u0003\u000bDq!a6\u0001\t\u0013\tI\u000eC\u0004\u0002d\u0002!I!!:\t\u000f\u0005%\b\u0001\"\u0003\u0002l\"9\u0011q\u001e\u0001\u0005\n\u0005E(!\f+sC:\u001c\u0018m\u0019;j_:l\u0015M]6feJ+\u0017/^3ti\u000e{W\u000e\u001d7fi&|g\u000eS1oI2,'\u000fV3ti*\u00111\bP\u0001\fiJ\fgn]1di&|gN\u0003\u0002>}\u0005Y1m\\8sI&t\u0017\r^8s\u0015\u0005y\u0014!B6bM.\f7\u0001A\n\u0003\u0001\t\u0003\"a\u0011$\u000e\u0003\u0011S\u0011!R\u0001\u0006g\u000e\fG.Y\u0005\u0003\u000f\u0012\u0013a!\u00118z%\u00164\u0017A\u0002\u001fj]&$h\bF\u0001K!\tY\u0005!D\u0001;\u0003!\u0011'o\\6fe&#W#\u0001(\u0011\u0005\r{\u0015B\u0001)E\u0005\rIe\u000e^\u0001\nEJ|7.\u001a:JI\u0002\n\u0011\u0003\u001e=o)>\u0004\u0018n\u0019)beRLG/[8o\u0003I!\bP\u001c+pa&\u001c\u0007+\u0019:uSRLwN\u001c\u0011\u0002\u001fQ\u0014\u0018M\\:bGRLwN\\1m\u0013\u0012,\u0012A\u0016\t\u0003/rk\u0011\u0001\u0017\u0006\u00033j\u000bA\u0001\\1oO*\t1,\u0001\u0003kCZ\f\u0017BA/Y\u0005\u0019\u0019FO]5oO\u0006\u0001BO]1og\u0006\u001cG/[8oC2LE\rI\u0001\u000baJ|G-^2fe&#W#A1\u0011\u0005\r\u0013\u0017BA2E\u0005\u0011auN\\4\u0002\u0017A\u0014x\u000eZ;dKJLE\rI\u0001\u000eaJ|G-^2fe\u0016\u0003xn\u00195\u0016\u0003\u001d\u0004\"a\u00115\n\u0005%$%!B*i_J$\u0018A\u00049s_\u0012,8-\u001a:Fa>\u001c\u0007\u000eI\u0001\u0012Y\u0006\u001cH\u000f\u0015:pIV\u001cWM]#q_\u000eD\u0017A\u00057bgR\u0004&o\u001c3vG\u0016\u0014X\t]8dQ\u0002\nA\u0002\u001e=o)&lWm\\;u\u001bN\fQ\u0002\u001e=o)&lWm\\;u\u001bN\u0004\u0013\u0001E2p_J$\u0017N\\1u_J,\u0005o\\2i\u0003E\u0019wn\u001c:eS:\fGo\u001c:Fa>\u001c\u0007\u000eI\u0001\nibt'+Z:vYR,\u0012a\u001d\t\u0003izl\u0011!\u001e\u0006\u0003m^\f\u0001B]3rk\u0016\u001cHo\u001d\u0006\u0003qf\faaY8n[>t'BA {\u0015\tYH0\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002{\u0006\u0019qN]4\n\u0005},(!\u0005+sC:\u001c\u0018m\u0019;j_:\u0014Vm];mi\u0006QA\u000f\u001f8SKN,H\u000e\u001e\u0011\u0002\u001dQ|\u0007/[2QCJ$\u0018\u000e^5p]V\u0011\u0011q\u0001\t\u0005\u0003\u0013\tY!D\u0001x\u0013\r\tia\u001e\u0002\u000f)>\u0004\u0018n\u0019)beRLG/[8o\u0003=!x\u000e]5d!\u0006\u0014H/\u001b;j_:\u0004\u0013a\u0003;y]6+G/\u00193bi\u0006,\"!!\u0006\u0011\u0007-\u000b9\"C\u0002\u0002\u001ai\u00121\u0003\u0016:b]N\f7\r^5p]6+G/\u00193bi\u0006\fA\u0002\u001e=o\u001b\u0016$\u0018\rZ1uC\u0002\nA\u0004]3oI&twmQ8na2,G/\u001a+y]\u0006sG-T1sW\u0016\u00148/\u0006\u0002\u0002\"A1\u00111EA\u0015\u0003[i!!!\n\u000b\u0007\u0005\u001d\",\u0001\u0003vi&d\u0017\u0002BA\u0016\u0003K\u0011A\u0001T5tiB\u00191*a\f\n\u0007\u0005E\"H\u0001\u0011QK:$\u0017N\\4D_6\u0004H.\u001a;f)bt\u0017I\u001c3NCJ\\WM]#oiJL\u0018!\b9f]\u0012LgnZ\"p[BdW\r^3Uq:\fe\u000eZ'be.,'o\u001d\u0011\u0002)5\f'o[3s\u0007\"\fgN\\3m\u001b\u0006t\u0017mZ3s+\t\tI\u0004E\u0002L\u0003wI1!!\u0010;\u0005}!&/\u00198tC\u000e$\u0018n\u001c8NCJ\\WM]\"iC:tW\r\\'b]\u0006<WM]\u0001\u0016[\u0006\u00148.\u001a:DQ\u0006tg.\u001a7NC:\fw-\u001a:!\u0003=!\bP\\*uCR,W*\u00198bO\u0016\u0014XCAA#!\rY\u0015qI\u0005\u0004\u0003\u0013R$a\u0006+sC:\u001c\u0018m\u0019;j_:\u001cF/\u0019;f\u001b\u0006t\u0017mZ3s\u0003A!\bP\\*uCR,W*\u00198bO\u0016\u0014\b%A\u0004iC:$G.\u001a:\u0016\u0005\u0005E\u0003cA&\u0002T%\u0019\u0011Q\u000b\u001e\u0003SQ\u0013\u0018M\\:bGRLwN\\'be.,'OU3rk\u0016\u001cHoQ8na2,G/[8o\u0011\u0006tG\r\\3s\u0003!A\u0017M\u001c3mKJ\u0004\u0013!C7pG.\u001c\u0015m\u00195f)\t\ti\u0006E\u0002D\u0003?J1!!\u0019E\u0005\u0011)f.\u001b;\u0002_MDw.\u001e7e%\u0016,e.];fk\u0016\u0004\u0016M\u001d;ji&|gn],iK:\u0014%o\\6fe\u0012K7oY8o]\u0016\u001cG/\u001a3)\u0007\u0005\n9\u0007\u0005\u0003\u0002j\u0005]TBAA6\u0015\u0011\ti'a\u001c\u0002\u0007\u0005\u0004\u0018N\u0003\u0003\u0002r\u0005M\u0014a\u00026va&$XM\u001d\u0006\u0004\u0003kb\u0018!\u00026v]&$\u0018\u0002BA=\u0003W\u0012A\u0001V3ti\u0006i4\u000f[8vY\u0012$\u0006N]8x\u00132dWmZ1m'R\fG/Z#yG\u0016\u0004H/[8o\u0013\u001a,%O]8s\u0007>$WMT8u\u0003Z\f\u0017\u000e\\1cY\u00164uN\u001d)jI\"\u001a!%a\u001a\u0002UMDw.\u001e7e\u0007>l\u0007\u000f\\3uK\u0012+G.Y=fI>\u0003XM]1uS>tw\u000b[3o\u001d>,%O]8sg\"\u001a1%a\u001a\u0002aMDw.\u001e7e\u0007>l\u0007\u000f\\3uK\u0012+G.Y=fI>\u0003XM]1uS>tw\u000b[3o\u001d>$8i\\8sI&t\u0017\r^8sQ\r!\u0013qM\u00015g\"|W\u000f\u001c3D_6\u0004H.\u001a;f\t\u0016d\u0017-_3e\u001fB,'/\u0019;j_:<\u0006.\u001a8D_>\u0014H-\u001b8bi>\u0014Hj\\1eS:<\u0007fA\u0013\u0002h\u0005I4\u000f[8vY\u0012\u001cu.\u001c9mKR,G)\u001a7bs\u0016$w\n]3sCRLwN\\,iK:\u001cun\u001c:eS:\fGo\u001c:Fa>\u001c\u0007n\u00115b]\u001e,G\rK\u0002'\u0003O\nag\u001d5pk2$7i\\7qY\u0016$X\rR3mCf,Gm\u00149fe\u0006$\u0018n\u001c8XQ\u0016t\u0017J\u001c<bY&$\u0007K]8ek\u000e,'/\u00129pG\"D3aJA4\u0003a\u001a\bn\\;mI\u000e{W\u000e\u001d7fi\u0016$U\r\\1zK\u0012|\u0005/\u001a:bi&|gn\u00165f]\u000e{wN\u001d3j]\u0006$xN]#q_\u000eDg)\u001a8dK\u0012D3\u0001KA4\u0003A\u001a\bn\\;mIRC'o\\<JY2,w-\u00197Ti\u0006$X-\u0012=dKB$\u0018n\u001c8XQ\u0016tWK\\6o_^tWI\u001d:pe\"\u001a\u0011&a\u001a\u0002oMDw.\u001e7e)\"\u0014xn^%mY\u0016<\u0017\r\\*uCR,W\t_2faRLwN\\,iK:\u001cuN\u001d:vaRlUm]:bO\u0016,%O]8sQ\rQ\u0013qM\u00019g\"|W\u000f\u001c3UQJ|w/\u00137mK\u001e\fGn\u0015;bi\u0016,\u0005pY3qi&|gn\u00165f]6+7o]1hKR{w\u000eT1sO\u0016,%O]8sQ\rY\u0013qM\u0001<g\"|W\u000f\u001c3UQJ|w/\u00137mK\u001e\fGn\u0015;bi\u0016,\u0005pY3qi&|gn\u00165f]J+7m\u001c:e\u0019&\u001cH\u000fV8p\u0019\u0006\u0014x-Z#se>\u0014\bf\u0001\u0017\u0002h\u0005a4\u000f[8vY\u0012$\u0006N]8x\u00132dWmZ1m'R\fG/Z#yG\u0016\u0004H/[8o/\",g.\u00138wC2LGMU3rk&\u0014X\rZ!dWN,%O]8sQ\ri\u0013qM\u00015g\"|W\u000f\u001c3SKR\u0014\u0018\u0010U1si&$\u0018n\u001c8XQ\u0016tWK\\6o_^tGk\u001c9jG>\u0013\b+\u0019:uSRLwN\\#se>\u0014\bf\u0001\u0018\u0002h\u0005\u00014\u000f[8vY\u0012\u0014V\r\u001e:z!\u0006\u0014H/\u001b;j_:<\u0006.\u001a8O_RdU-\u00193fe>\u0013hi\u001c7m_^,'/\u0012:s_JD3aLA4\u00039\u001a\bn\\;mIJ+GO]=QCJ$\u0018\u000e^5p]^CWM\u001c(pi\u0016sw.^4i%\u0016\u0004H.[2bg\u0016\u0013(o\u001c:)\u0007A\n9'A\u001dtQ>,H\u000e\u001a*fiJL\b+\u0019:uSRLwN\\,iK:tu\u000e^#o_V<\u0007NU3qY&\u001c\u0017m]!gi\u0016\u0014\u0018\t\u001d9f]\u0012,%O]8sQ\r\t\u0014qM\u0001*g\"|W\u000f\u001c3SKR\u0014\u0018\u0010U1si&$\u0018n\u001c8XQ\u0016t7*\u00194lCN#xN]1hK\u0016\u0013(o\u001c:)\u0007I\n9'A#tQ>,H\u000e\u001a*f[>4X\rV8qS\u000e\u0004\u0016M\u001d;ji&|gN\u0012:p[^\u000b\u0017\u000e^5oON+Go\u00148V]N,\b\u000f]8si\u0016$gi\u001c:NKN\u001c\u0018mZ3G_Jl\u0017\r\u001e\u0015\u0004g\u0005\u001d\u0014!\b<fe&4\u0017PU3ue&,7\u000fU1si&$\u0018n\u001c8P]\u0016\u0013(o\u001c:\u0015\t\u0005u\u0013q\u0019\u0005\b\u0003\u0013$\u0004\u0019AAf\u0003\u0015)'O]8s!\u0011\ti-a5\u000e\u0005\u0005='bAAio\u0006A\u0001O]8u_\u000e|G.\u0003\u0003\u0002V\u0006='AB#se>\u00148/A\u0014wKJLg-\u001f+ie><\u0018\n\u001c7fO\u0006d7\u000b^1uK\u0016C8-\u001a9uS>twJ\\#se>\u0014H\u0003BAn\u0003C\u00042aVAo\u0013\r\ty\u000e\u0017\u0002\u0016\u00132dWmZ1m'R\fG/Z#yG\u0016\u0004H/[8o\u0011\u001d\tI-\u000ea\u0001\u0003\u0017\fQE^3sS\u001aL8i\\7qY\u0016$X\rR3mCf,Gm\u00149fe\u0006$\u0018n\u001c8P]\u0016\u0013(o\u001c:\u0015\t\u0005u\u0013q\u001d\u0005\b\u0003\u00134\u0004\u0019AAf\u0003\r2XM]5gsJ+Wn\u001c<f\t\u0016d\u0017-_3e\u001fB,'/\u0019;j_:|e.\u0012:s_J$B!!\u0018\u0002n\"9\u0011\u0011Z\u001cA\u0002\u0005-\u0017\u0001G2sK\u0006$X\r\u0015:pIV\u001cWM]%e\u000bJ\u0014xN]'baR!\u00111\u001fB\u0002!!\t\u0019#!>\u0002z\u0006u\u0018\u0002BA|\u0003K\u0011q\u0001S1tQ6\u000b\u0007\u000fE\u0002X\u0003wL!a\u0019-\u0011\u0011\u0005\r\u0012q`A\u0004\u0003\u0017LAA!\u0001\u0002&\t\u0019Q*\u00199\t\u000f\t\u0015\u0001\b1\u0001\u0002L\u00061QM\u001d:peN\u0004")
public class TransactionMarkerRequestCompletionHandlerTest {
    private final int brokerId;
    private final int txnTopicPartition;
    private final String transactionalId;
    private final long producerId;
    private final short producerEpoch = (short)0;
    private final short lastProducerEpoch = (short)-1;
    private final int txnTimeoutMs;
    private final int coordinatorEpoch;
    private final TransactionResult txnResult = TransactionResult.COMMIT;
    private final TopicPartition topicPartition = new TopicPartition("topic1", 0);
    private final TransactionMetadata txnMetadata = new TransactionMetadata(this.transactionalId(), this.producerId(), this.producerId(), this.producerEpoch(), this.lastProducerEpoch(), this.txnTimeoutMs(), (TransactionState)PrepareCommit$.MODULE$, (Set)Set$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.topicPartition()})), 0L, 0L);
    private final List<PendingCompleteTxnAndMarkerEntry> pendingCompleteTxnAndMarkers = Arrays.asList((Object[])new PendingCompleteTxnAndMarkerEntry[]{new PendingCompleteTxnAndMarkerEntry(new PendingCompleteTxn(this.transactionalId(), this.coordinatorEpoch(), this.txnMetadata(), this.txnMetadata().prepareComplete(42L)), new WriteTxnMarkersRequest.TxnMarkerEntry(this.producerId(), this.producerEpoch(), this.coordinatorEpoch(), this.txnResult(), Arrays.asList((Object[])new TopicPartition[]{this.topicPartition()})))});
    private final TransactionMarkerChannelManager markerChannelManager = (TransactionMarkerChannelManager)Mockito.mock(TransactionMarkerChannelManager.class);
    private final TransactionStateManager txnStateManager = (TransactionStateManager)Mockito.mock(TransactionStateManager.class);
    private final TransactionMarkerRequestCompletionHandler handler = new TransactionMarkerRequestCompletionHandler(this.brokerId(), this.txnStateManager(), this.markerChannelManager(), this.pendingCompleteTxnAndMarkers());

    private int brokerId() {
        return this.brokerId;
    }

    private int txnTopicPartition() {
        return this.txnTopicPartition;
    }

    private String transactionalId() {
        return this.transactionalId;
    }

    private long producerId() {
        return this.producerId;
    }

    private short producerEpoch() {
        return this.producerEpoch;
    }

    private short lastProducerEpoch() {
        return this.lastProducerEpoch;
    }

    private int txnTimeoutMs() {
        return this.txnTimeoutMs;
    }

    private int coordinatorEpoch() {
        return this.coordinatorEpoch;
    }

    private TransactionResult txnResult() {
        return this.txnResult;
    }

    private TopicPartition topicPartition() {
        return this.topicPartition;
    }

    private TransactionMetadata txnMetadata() {
        return this.txnMetadata;
    }

    private List<PendingCompleteTxnAndMarkerEntry> pendingCompleteTxnAndMarkers() {
        return this.pendingCompleteTxnAndMarkers;
    }

    private TransactionMarkerChannelManager markerChannelManager() {
        return this.markerChannelManager;
    }

    private TransactionStateManager txnStateManager() {
        return this.txnStateManager;
    }

    private TransactionMarkerRequestCompletionHandler handler() {
        return this.handler;
    }

    private void mockCache() {
        Mockito.when((Object)BoxesRunTime.boxToInteger((int)this.txnStateManager().partitionFor(this.transactionalId()))).thenReturn((Object)BoxesRunTime.boxToInteger((int)this.txnTopicPartition()));
        Mockito.when((Object)this.txnStateManager().getTransactionState((String)ArgumentMatchers.eq((Object)this.transactionalId()))).thenReturn((Object)package$.MODULE$.Right().apply((Object)new Some((Object)new CoordinatorEpochAndTxnMetadata(this.coordinatorEpoch(), this.txnMetadata()))));
    }

    @Test
    public void shouldReEnqueuePartitionsWhenBrokerDisconnected() {
        this.mockCache();
        this.handler().onComplete(new ClientResponse(new RequestHeader(ApiKeys.PRODUCE, 0, "client", 1), null, null, 0L, 0L, true, null, null, null));
        ((TransactionMarkerChannelManager)Mockito.verify((Object)this.markerChannelManager())).addTxnMarkersToBrokerQueue(this.producerId(), this.producerEpoch(), this.txnResult(), this.pendingCompleteTxnAndMarkers().get(0).pendingCompleteTxn(), (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.topicPartition()})));
    }

    @Test
    public void shouldThrowIllegalStateExceptionIfErrorCodeNotAvailableForPid() {
        this.mockCache();
        WriteTxnMarkersResponse response = new WriteTxnMarkersResponse(new HashMap());
        Assertions.assertThrows(IllegalStateException.class, () -> this.handler().onComplete(new ClientResponse(new RequestHeader(ApiKeys.PRODUCE, 0, "client", 1), null, null, 0L, 0L, false, null, null, (AbstractResponse)response)));
    }

    @Test
    public void shouldCompleteDelayedOperationWhenNoErrors() {
        this.mockCache();
        this.verifyCompleteDelayedOperationOnError(Errors.NONE);
    }

    @Test
    public void shouldCompleteDelayedOperationWhenNotCoordinator() {
        Mockito.when((Object)this.txnStateManager().getTransactionState((String)ArgumentMatchers.eq((Object)this.transactionalId()))).thenReturn((Object)package$.MODULE$.Left().apply((Object)Errors.NOT_COORDINATOR));
        this.verifyRemoveDelayedOperationOnError(Errors.NONE);
    }

    @Test
    public void shouldCompleteDelayedOperationWhenCoordinatorLoading() {
        Mockito.when((Object)this.txnStateManager().getTransactionState((String)ArgumentMatchers.eq((Object)this.transactionalId()))).thenReturn((Object)package$.MODULE$.Left().apply((Object)Errors.COORDINATOR_LOAD_IN_PROGRESS));
        this.verifyRemoveDelayedOperationOnError(Errors.NONE);
    }

    @Test
    public void shouldCompleteDelayedOperationWhenCoordinatorEpochChanged() {
        Mockito.when((Object)this.txnStateManager().getTransactionState((String)ArgumentMatchers.eq((Object)this.transactionalId()))).thenReturn((Object)package$.MODULE$.Right().apply((Object)new Some((Object)new CoordinatorEpochAndTxnMetadata(this.coordinatorEpoch() + 1, this.txnMetadata()))));
        this.verifyRemoveDelayedOperationOnError(Errors.NONE);
    }

    @Test
    public void shouldCompleteDelayedOperationWhenInvalidProducerEpoch() {
        this.mockCache();
        this.verifyRemoveDelayedOperationOnError(Errors.INVALID_PRODUCER_EPOCH);
    }

    @Test
    public void shouldCompleteDelayedOperationWhenCoordinatorEpochFenced() {
        this.mockCache();
        this.verifyRemoveDelayedOperationOnError(Errors.TRANSACTION_COORDINATOR_FENCED);
    }

    @Test
    public void shouldThrowIllegalStateExceptionWhenUnknownError() {
        this.verifyThrowIllegalStateExceptionOnError(Errors.UNKNOWN_SERVER_ERROR);
    }

    @Test
    public void shouldThrowIllegalStateExceptionWhenCorruptMessageError() {
        this.verifyThrowIllegalStateExceptionOnError(Errors.CORRUPT_MESSAGE);
    }

    @Test
    public void shouldThrowIllegalStateExceptionWhenMessageTooLargeError() {
        this.verifyThrowIllegalStateExceptionOnError(Errors.MESSAGE_TOO_LARGE);
    }

    @Test
    public void shouldThrowIllegalStateExceptionWhenRecordListTooLargeError() {
        this.verifyThrowIllegalStateExceptionOnError(Errors.RECORD_LIST_TOO_LARGE);
    }

    @Test
    public void shouldThrowIllegalStateExceptionWhenInvalidRequiredAcksError() {
        this.verifyThrowIllegalStateExceptionOnError(Errors.INVALID_REQUIRED_ACKS);
    }

    @Test
    public void shouldRetryPartitionWhenUnknownTopicOrPartitionError() {
        this.verifyRetriesPartitionOnError(Errors.UNKNOWN_TOPIC_OR_PARTITION);
    }

    @Test
    public void shouldRetryPartitionWhenNotLeaderOrFollowerError() {
        this.verifyRetriesPartitionOnError(Errors.NOT_LEADER_OR_FOLLOWER);
    }

    @Test
    public void shouldRetryPartitionWhenNotEnoughReplicasError() {
        this.verifyRetriesPartitionOnError(Errors.NOT_ENOUGH_REPLICAS);
    }

    @Test
    public void shouldRetryPartitionWhenNotEnoughReplicasAfterAppendError() {
        this.verifyRetriesPartitionOnError(Errors.NOT_ENOUGH_REPLICAS_AFTER_APPEND);
    }

    @Test
    public void shouldRetryPartitionWhenKafkaStorageError() {
        this.verifyRetriesPartitionOnError(Errors.KAFKA_STORAGE_ERROR);
    }

    @Test
    public void shouldRemoveTopicPartitionFromWaitingSetOnUnsupportedForMessageFormat() {
        this.mockCache();
        this.verifyCompleteDelayedOperationOnError(Errors.UNSUPPORTED_FOR_MESSAGE_FORMAT);
    }

    private void verifyRetriesPartitionOnError(Errors error) {
        this.mockCache();
        WriteTxnMarkersResponse response = new WriteTxnMarkersResponse(this.createProducerIdErrorMap(error));
        this.handler().onComplete(new ClientResponse(new RequestHeader(ApiKeys.PRODUCE, 0, "client", 1), null, null, 0L, 0L, false, null, null, (AbstractResponse)response));
        Assertions.assertEquals((Object)this.txnMetadata().topicPartitions(), (Object)Set$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.topicPartition()})));
        ((TransactionMarkerChannelManager)Mockito.verify((Object)this.markerChannelManager())).addTxnMarkersToBrokerQueue(this.producerId(), this.producerEpoch(), this.txnResult(), this.pendingCompleteTxnAndMarkers().get(0).pendingCompleteTxn(), (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.topicPartition()})));
    }

    private IllegalStateException verifyThrowIllegalStateExceptionOnError(Errors error) {
        this.mockCache();
        WriteTxnMarkersResponse response = new WriteTxnMarkersResponse(this.createProducerIdErrorMap(error));
        return (IllegalStateException)Assertions.assertThrows(IllegalStateException.class, () -> this.handler().onComplete(new ClientResponse(new RequestHeader(ApiKeys.PRODUCE, 0, "client", 1), null, null, 0L, 0L, false, null, null, (AbstractResponse)response)));
    }

    private void verifyCompleteDelayedOperationOnError(Errors error) {
        BooleanRef completed = BooleanRef.create((boolean)false);
        this.markerChannelManager().maybeWriteTxnCompletion(this.transactionalId());
        Mockito.when((Object)BoxedUnit.UNIT).thenAnswer(x$1 -> {
            completed.elem = true;
            return BoxedUnit.UNIT;
        });
        WriteTxnMarkersResponse response = new WriteTxnMarkersResponse(this.createProducerIdErrorMap(error));
        this.handler().onComplete(new ClientResponse(new RequestHeader(ApiKeys.PRODUCE, 0, "client", 1), null, null, 0L, 0L, false, null, null, (AbstractResponse)response));
        Assertions.assertTrue((boolean)this.txnMetadata().topicPartitions().isEmpty());
        Assertions.assertTrue((boolean)completed.elem);
    }

    private void verifyRemoveDelayedOperationOnError(Errors error) {
        BooleanRef removed = BooleanRef.create((boolean)false);
        PendingCompleteTxn pendingCompleteTxn = this.pendingCompleteTxnAndMarkers().get(0).pendingCompleteTxn();
        this.markerChannelManager().removeMarkersForTxn(pendingCompleteTxn);
        Mockito.when((Object)BoxedUnit.UNIT).thenAnswer(x$2 -> {
            removed.elem = true;
            return BoxedUnit.UNIT;
        });
        WriteTxnMarkersResponse response = new WriteTxnMarkersResponse(this.createProducerIdErrorMap(error));
        this.handler().onComplete(new ClientResponse(new RequestHeader(ApiKeys.PRODUCE, 0, "client", 1), null, null, 0L, 0L, false, null, null, (AbstractResponse)response));
        Assertions.assertTrue((boolean)removed.elem);
    }

    private HashMap<Long, Map<TopicPartition, Errors>> createProducerIdErrorMap(Errors errors) {
        HashMap<Long, Map<TopicPartition, Errors>> pidMap = new HashMap<Long, Map<TopicPartition, Errors>>();
        HashMap<TopicPartition, Errors> errorsMap = new HashMap<TopicPartition, Errors>();
        errorsMap.put(this.topicPartition(), errors);
        pidMap.put(Predef$.MODULE$.long2Long(this.producerId()), errorsMap);
        return pidMap;
    }

    public TransactionMarkerRequestCompletionHandlerTest() {
        this.brokerId = 0;
        this.txnTopicPartition = 0;
        this.transactionalId = "txnId1";
        this.producerId = 0;
        this.txnTimeoutMs = 0;
        this.coordinatorEpoch = 0;
    }
}

