/*
 * Decompiled with CFR 0.152.
 */
package kafka.docker;

import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import kafka.docker.KafkaDockerWrapper$;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayOps;
import scala.io.BufferedSource;
import scala.io.Codec$;
import scala.io.Source$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u000114AAF\f\u00019!)1\u0005\u0001C\u0001I!)q\u0005\u0001C\u0001Q!)\u0011\b\u0001C\u0001Q!)1\b\u0001C\u0001Q!)Q\b\u0001C\u0001Q!)q\b\u0001C\u0001Q!)\u0011\t\u0001C\u0001Q!)1\t\u0001C\u0001Q!)Q\t\u0001C\u0001Q!)q\t\u0001C\u0001Q!)\u0011\n\u0001C\u0001Q!)1\n\u0001C\u0001Q!)Q\n\u0001C\u0001Q!)q\n\u0001C\u0001Q!)\u0011\u000b\u0001C\u0001Q!)1\u000b\u0001C\u0001Q!)Q\u000b\u0001C\u0001Q!)q\u000b\u0001C\u0001Q!)\u0011\f\u0001C\u0001Q!)1\f\u0001C\u0001Q!)Q\f\u0001C\u0005=\n12*\u00194lC\u0012{7m[3s/J\f\u0007\u000f]3s)\u0016\u001cHO\u0003\u0002\u00193\u00051Am\\2lKJT\u0011AG\u0001\u0006W\u000647.Y\u0002\u0001'\t\u0001Q\u0004\u0005\u0002\u001fC5\tqDC\u0001!\u0003\u0015\u00198-\u00197b\u0013\t\u0011sD\u0001\u0004B]f\u0014VMZ\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003\u0015\u0002\"A\n\u0001\u000e\u0003]\t1\u0004^3ti\u001e+GoU3sm\u0016\u00148i\u001c8gS\u001e\u001chI]8n\u000b:4H#A\u0015\u0011\u0005yQ\u0013BA\u0016 \u0005\u0011)f.\u001b;)\u0005\ti\u0003C\u0001\u00188\u001b\u0005y#B\u0001\u00192\u0003\r\t\u0007/\u001b\u0006\u0003eM\nqA[;qSR,'O\u0003\u00025k\u0005)!.\u001e8ji*\ta'A\u0002pe\u001eL!\u0001O\u0018\u0003\tQ+7\u000f^\u0001\u0019i\u0016\u001cH\u000f\u0015:fa\u0006\u0014XmU3sm\u0016\u00148i\u001c8gS\u001e\u001c\bFA\u0002.\u0003)\"Xm\u001d;Qe\u0016\u0004\u0018M]3TKJ4XM]\"p]\u001aLwm],ji\"|W\u000f^'pk:$X\r\u001a$jY\u0016D#\u0001B\u0017\u0002WQ,7\u000f\u001e)sKB\f'/Z*feZ,'oQ8oM&<7oV5uQ>,H/\u00128w-\u0006\u0014\u0018.\u00192mKND#!B\u0017\u0002QQ,7\u000f\u001e)sKB\f'/Z*feZ,'oQ8oM&<7oV5uQ>,H/V:fe&s\u0007/\u001e;)\u0005\u0019i\u0013\u0001\f;fgR\u0004&/\u001a9be\u0016\u001cVM\u001d<fe\u000e{gNZ5hg^KG\u000f[#naRLXj\\;oi\u0016$g)\u001b7fQ\t9Q&\u0001\u000buKN$hi\u001c:nCR\u001cFo\u001c:bO\u0016\u001cU\u000e\u001a\u0015\u0003\u00115\n!\u0004^3ti\u001e+G\u000fT8hi)\u001cuN\u001c4jON4%o\\7F]ZD#!C\u0017\u0002YQ,7\u000f^$fi2{w\r\u000e6D_:4\u0017nZ:Ge>lWI\u001c<J]Z\fG.\u001b3F]Z4\u0016M]5bE2,\u0007F\u0001\u0006.\u00039\"Xm\u001d;HKRdun\u001a\u001bk\u0007>tg-[4t\rJ|W.\u00128w/&$\b.R7qif,eN\u001e,be&\f'\r\\3)\u0005-i\u0013a\u0006;fgR\u0004&/\u001a9be\u0016dun\u001a\u001bk\u0007>tg-[4tQ\taQ&A\u0015uKN$\bK]3qCJ,Gj\\45U\u000e{gNZ5hg^KG\u000f[8vi6{WO\u001c;fI\u001aKG.\u001a\u0015\u0003\u001b5\n!\u0006^3tiB\u0013X\r]1sK2{w\r\u000e6D_:4\u0017nZ:XSRDw.\u001e;F]Z4\u0016M]5bE2,7\u000f\u000b\u0002\u000f[\u0005yB/Z:u\u000f\u0016$Hk\\8mg2{w\r\u000e6D_:4\u0017nZ:Ge>lWI\u001c<)\u0005=i\u0013!\r;fgR<U\r\u001e+p_2\u001cHj\\45U\u000e{gNZ5hg\u001a\u0013x.\\#om&sg/\u00197jI\u0016sgOV1sS\u0006\u0014G.\u001a\u0015\u0003!5\n1\u0007^3ti\u001e+G\u000fV8pYNdun\u001a\u001bk\u0007>tg-[4t\rJ|W.\u00128w/&$\b.R7qif,eN\u001e,be&\f'\r\\3)\u0005Ei\u0013\u0001\b;fgR\u0004&/\u001a9be\u0016$vn\u001c7t\u0019><GG[\"p]\u001aLwm\u001d\u0015\u0003%5\na\u0006^3tiB\u0013X\r]1sKR{w\u000e\\:M_\u001e$$nQ8oM&<7oV5uQ>,H/T8v]R,GMR5mK\"\u00121#L\u0001/i\u0016\u001cH\u000f\u0015:fa\u0006\u0014X\rV8pYNdun\u001a\u001bk\u0007>tg-[4t/&$\bn\\;u\u000b:4h+\u0019:jC\ndW\r\u000b\u0002\u0015[\u0005Q1M]3bi\u0016$\u0015N]:\u0015\u0003}\u0003RA\b1cE\nL!!Y\u0010\u0003\rQ+\b\u000f\\34!\t\u0019'.D\u0001e\u0015\t)g-\u0001\u0003gS2,'BA4i\u0003\rq\u0017n\u001c\u0006\u0002S\u0006!!.\u0019<b\u0013\tYGM\u0001\u0003QCRD\u0007")
public class KafkaDockerWrapperTest {
    @Test
    public void testGetServerConfigsFromEnv() {
        Map envVars = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"KAFKA_TOOLS_LOG4J_LOGLEVEL"), (Object)"TRACE"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"KAFKA_VALID_PROPERTY"), (Object)"Value"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"SOME_VARIABLE"), (Object)"Some Value"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"KAFKA_VALID___PROPERTY__ALL_CASES"), (Object)"All Cases Value")}));
        .colon.colon expected = new .colon.colon((Object)"valid.property=Value", (List)new .colon.colon((Object)"valid-property_all.cases=All Cases Value", (List)Nil$.MODULE$));
        List actual = KafkaDockerWrapper$.MODULE$.getServerConfigsFromEnv(envVars);
        Assertions.assertEquals((Object)expected, (Object)actual);
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testPrepareServerConfigs() {
        String string;
        void var4_4;
        void var3_3;
        void var2_2;
        Tuple3<Path, Path, Path> tuple3 = this.createDirs();
        if (tuple3 == null) {
            throw new MatchError(null);
        }
        Path defaultConfigsPath = (Path)tuple3._1();
        Path mountedConfigsPath = (Path)tuple3._2();
        Path finalConfigsPath = (Path)tuple3._3();
        void defaultConfigsPath2 = var2_2;
        void mountedConfigsPath2 = var3_3;
        void finalConfigsPath2 = var4_4;
        Map envVars = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"KAFKA_ENV_CONFIG"), (Object)"env value")}));
        Files.write(defaultConfigsPath2.resolve("server.properties"), "default.config=default value".getBytes(StandardCharsets.UTF_8), new OpenOption[0]).toFile().deleteOnExit();
        Files.write(mountedConfigsPath2.resolve("server.properties"), "mounted.config=mounted value".getBytes(StandardCharsets.UTF_8), new OpenOption[0]).toFile().deleteOnExit();
        Files.write(finalConfigsPath2.resolve("server.properties"), "existing.config=existing value".getBytes(StandardCharsets.UTF_8), new OpenOption[0]).toFile().deleteOnExit();
        KafkaDockerWrapper$.MODULE$.prepareServerConfigs((Path)defaultConfigsPath2, (Path)mountedConfigsPath2, (Path)finalConfigsPath2, envVars);
        try (BufferedSource source = Source$.MODULE$.fromFile(new StringBuilder(18).append(finalConfigsPath2.toString()).append("/server.properties").toString(), Codec$.MODULE$.fallbackSystemCodec());){
            string = source.mkString();
        }
        String actual = string;
        Assertions.assertEquals((Object)"mounted.config=mounted value\nenv.config=env value", (Object)actual);
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testPrepareServerConfigsWithoutMountedFile() {
        String string;
        void var4_4;
        void var3_3;
        void var2_2;
        Tuple3<Path, Path, Path> tuple3 = this.createDirs();
        if (tuple3 == null) {
            throw new MatchError(null);
        }
        Path defaultConfigsPath = (Path)tuple3._1();
        Path mountedConfigsPath = (Path)tuple3._2();
        Path finalConfigsPath = (Path)tuple3._3();
        void defaultConfigsPath2 = var2_2;
        void mountedConfigsPath2 = var3_3;
        void finalConfigsPath2 = var4_4;
        Map envVars = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"KAFKA_ENV_CONFIG"), (Object)"env value")}));
        Files.write(defaultConfigsPath2.resolve("server.properties"), "default.config=default value".getBytes(StandardCharsets.UTF_8), new OpenOption[0]).toFile().deleteOnExit();
        Files.write(finalConfigsPath2.resolve("server.properties"), "existing.config=existing value".getBytes(StandardCharsets.UTF_8), new OpenOption[0]).toFile().deleteOnExit();
        KafkaDockerWrapper$.MODULE$.prepareServerConfigs((Path)defaultConfigsPath2, (Path)mountedConfigsPath2, (Path)finalConfigsPath2, envVars);
        try (BufferedSource source = Source$.MODULE$.fromFile(new StringBuilder(18).append(finalConfigsPath2.toString()).append("/server.properties").toString(), Codec$.MODULE$.fallbackSystemCodec());){
            string = source.mkString();
        }
        String actual = string;
        Assertions.assertEquals((Object)"\nenv.config=env value", (Object)actual);
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testPrepareServerConfigsWithoutEnvVariables() {
        String string;
        void var4_4;
        void var3_3;
        void var2_2;
        Tuple3<Path, Path, Path> tuple3 = this.createDirs();
        if (tuple3 == null) {
            throw new MatchError(null);
        }
        Path defaultConfigsPath = (Path)tuple3._1();
        Path mountedConfigsPath = (Path)tuple3._2();
        Path finalConfigsPath = (Path)tuple3._3();
        void defaultConfigsPath2 = var2_2;
        void mountedConfigsPath2 = var3_3;
        void finalConfigsPath2 = var4_4;
        Map envVars = Predef$.MODULE$.Map().empty();
        Files.write(defaultConfigsPath2.resolve("server.properties"), "default.config=default value".getBytes(StandardCharsets.UTF_8), new OpenOption[0]).toFile().deleteOnExit();
        Files.write(mountedConfigsPath2.resolve("server.properties"), "mounted.config=mounted value".getBytes(StandardCharsets.UTF_8), new OpenOption[0]).toFile().deleteOnExit();
        Files.write(finalConfigsPath2.resolve("server.properties"), "existing.config=existing value".getBytes(StandardCharsets.UTF_8), new OpenOption[0]).toFile().deleteOnExit();
        KafkaDockerWrapper$.MODULE$.prepareServerConfigs((Path)defaultConfigsPath2, (Path)mountedConfigsPath2, (Path)finalConfigsPath2, envVars);
        try (BufferedSource source = Source$.MODULE$.fromFile(new StringBuilder(18).append(finalConfigsPath2.toString()).append("/server.properties").toString(), Codec$.MODULE$.fallbackSystemCodec());){
            string = source.mkString();
        }
        String actual = string;
        Assertions.assertEquals((Object)"mounted.config=mounted value", (Object)actual);
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testPrepareServerConfigsWithoutUserInput() {
        String string;
        void var4_4;
        void var3_3;
        void var2_2;
        Tuple3<Path, Path, Path> tuple3 = this.createDirs();
        if (tuple3 == null) {
            throw new MatchError(null);
        }
        Path defaultConfigsPath = (Path)tuple3._1();
        Path mountedConfigsPath = (Path)tuple3._2();
        Path finalConfigsPath = (Path)tuple3._3();
        void defaultConfigsPath2 = var2_2;
        void mountedConfigsPath2 = var3_3;
        void finalConfigsPath2 = var4_4;
        Map envVars = Predef$.MODULE$.Map().empty();
        Files.write(defaultConfigsPath2.resolve("server.properties"), "default.config=default value".getBytes(StandardCharsets.UTF_8), new OpenOption[0]).toFile().deleteOnExit();
        Files.write(finalConfigsPath2.resolve("server.properties"), "existing.config=existing value".getBytes(StandardCharsets.UTF_8), new OpenOption[0]).toFile().deleteOnExit();
        KafkaDockerWrapper$.MODULE$.prepareServerConfigs((Path)defaultConfigsPath2, (Path)mountedConfigsPath2, (Path)finalConfigsPath2, envVars);
        try (BufferedSource source = Source$.MODULE$.fromFile(new StringBuilder(18).append(finalConfigsPath2.toString()).append("/server.properties").toString(), Codec$.MODULE$.fallbackSystemCodec());){
            string = source.mkString();
        }
        String actual = string;
        Assertions.assertEquals((Object)"default.config=default value", (Object)actual);
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testPrepareServerConfigsWithEmptyMountedFile() {
        String string;
        void var4_4;
        void var3_3;
        void var2_2;
        Tuple3<Path, Path, Path> tuple3 = this.createDirs();
        if (tuple3 == null) {
            throw new MatchError(null);
        }
        Path defaultConfigsPath = (Path)tuple3._1();
        Path mountedConfigsPath = (Path)tuple3._2();
        Path finalConfigsPath = (Path)tuple3._3();
        void defaultConfigsPath2 = var2_2;
        void mountedConfigsPath2 = var3_3;
        void finalConfigsPath2 = var4_4;
        Map envVars = Predef$.MODULE$.Map().empty();
        Files.write(defaultConfigsPath2.resolve("server.properties"), "default.config=default value".getBytes(StandardCharsets.UTF_8), new OpenOption[0]).toFile().deleteOnExit();
        Files.write(mountedConfigsPath2.resolve("server.properties"), " \n \n ".getBytes(StandardCharsets.UTF_8), new OpenOption[0]).toFile().deleteOnExit();
        Files.write(finalConfigsPath2.resolve("server.properties"), "existing.config=existing value".getBytes(StandardCharsets.UTF_8), new OpenOption[0]).toFile().deleteOnExit();
        KafkaDockerWrapper$.MODULE$.prepareServerConfigs((Path)defaultConfigsPath2, (Path)mountedConfigsPath2, (Path)finalConfigsPath2, envVars);
        try (BufferedSource source = Source$.MODULE$.fromFile(new StringBuilder(18).append(finalConfigsPath2.toString()).append("/server.properties").toString(), Codec$.MODULE$.fallbackSystemCodec());){
            string = source.mkString();
        }
        String actual = string;
        Assertions.assertEquals((Object)"default.config=default value", (Object)actual);
    }

    @Test
    public void testFormatStorageCmd() {
        Path configsPath = Paths.get("/path/to/configs", new String[0]);
        Map envVars = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"CLUSTER_ID"), (Object)"MYwKGPhXQZidgd0qMv8Mkw")}));
        String[] expected = (String[])((Object[])new String[]{"format", "--cluster-id=MYwKGPhXQZidgd0qMv8Mkw", "-c", "/path/to/configs/server.properties"});
        String[] actual = KafkaDockerWrapper$.MODULE$.formatStorageCmd(configsPath, envVars);
        Assertions.assertArrayEquals((Object[])((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])expected)).toArray(ClassTag$.MODULE$.Object())), (Object[])((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])actual)).toArray(ClassTag$.MODULE$.Object())));
        Assertions.assertThrows(RuntimeException.class, () -> KafkaDockerWrapper$.MODULE$.formatStorageCmd(configsPath, (Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$)));
    }

    @Test
    public void testGetLog4jConfigsFromEnv() {
        Map envVars = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"KAFKA_LOG4J_LOGGERS"), (Object)"kafka=INFO,kafka.network.RequestChannel$=WARN,kafka.producer.async.DefaultEventHandler=DEBUG,"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"KAFKA_LOG4J_ROOT_LOGLEVEL"), (Object)"ERROR"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"SOME_VARIABLE"), (Object)"Some Value")}));
        String expected = "\nlog4j.rootLogger=ERROR, stdout\nlog4j.logger.kafka=INFO\nlog4j.logger.kafka.network.RequestChannel$=WARN\nlog4j.logger.kafka.producer.async.DefaultEventHandler=DEBUG";
        String actual = KafkaDockerWrapper$.MODULE$.getLog4jConfigsFromEnv(envVars);
        Assertions.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testGetLog4jConfigsFromEnvInvalidEnvVariable() {
        Map envVars = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"SOME_VARIABLE"), (Object)"Some Value")}));
        String expected = "";
        String actual = KafkaDockerWrapper$.MODULE$.getLog4jConfigsFromEnv(envVars);
        Assertions.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testGetLog4jConfigsFromEnvWithEmptyEnvVariable() {
        Map envVars = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"SOME_VARIABLE"), (Object)"Some Value"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"KAFKA_LOG4J_LOGGERS"), (Object)""), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"KAFKA_LOG4J_ROOT_LOGLEVEL"), (Object)"")}));
        String expected = "";
        String actual = KafkaDockerWrapper$.MODULE$.getLog4jConfigsFromEnv(envVars);
        Assertions.assertEquals((Object)expected, (Object)actual);
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testPrepareLog4jConfigs() {
        String string;
        void var4_4;
        void var3_3;
        void var2_2;
        Tuple3<Path, Path, Path> tuple3 = this.createDirs();
        if (tuple3 == null) {
            throw new MatchError(null);
        }
        Path defaultConfigsPath = (Path)tuple3._1();
        Path mountedConfigsPath = (Path)tuple3._2();
        Path finalConfigsPath = (Path)tuple3._3();
        void defaultConfigsPath2 = var2_2;
        void mountedConfigsPath2 = var3_3;
        void finalConfigsPath2 = var4_4;
        Map envVars = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"KAFKA_LOG4J_LOGGERS"), (Object)"kafka=INFO,kafka.network.RequestChannel$=WARN,kafka.producer.async.DefaultEventHandler=DEBUG,"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"KAFKA_LOG4J_ROOT_LOGLEVEL"), (Object)"ERROR"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"SOME_VARIABLE"), (Object)"Some Value")}));
        Files.write(defaultConfigsPath2.resolve("log4j.properties"), "default.config=default value".getBytes(StandardCharsets.UTF_8), new OpenOption[0]).toFile().deleteOnExit();
        Files.write(mountedConfigsPath2.resolve("log4j.properties"), "mounted.config=mounted value".getBytes(StandardCharsets.UTF_8), new OpenOption[0]).toFile().deleteOnExit();
        Files.write(finalConfigsPath2.resolve("log4j.properties"), "existing.config=existing value".getBytes(StandardCharsets.UTF_8), new OpenOption[0]).toFile().deleteOnExit();
        KafkaDockerWrapper$.MODULE$.prepareLog4jConfigs((Path)defaultConfigsPath2, (Path)mountedConfigsPath2, (Path)finalConfigsPath2, envVars);
        try (BufferedSource source = Source$.MODULE$.fromFile(new StringBuilder(17).append(finalConfigsPath2.toString()).append("/log4j.properties").toString(), Codec$.MODULE$.fallbackSystemCodec());){
            string = source.mkString();
        }
        String actual = string;
        Assertions.assertEquals((Object)"mounted.config=mounted value\nlog4j.rootLogger=ERROR, stdout\nlog4j.logger.kafka=INFO\nlog4j.logger.kafka.network.RequestChannel$=WARN\nlog4j.logger.kafka.producer.async.DefaultEventHandler=DEBUG", (Object)actual);
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testPrepareLog4jConfigsWithoutMountedFile() {
        String string;
        void var4_4;
        void var3_3;
        void var2_2;
        Tuple3<Path, Path, Path> tuple3 = this.createDirs();
        if (tuple3 == null) {
            throw new MatchError(null);
        }
        Path defaultConfigsPath = (Path)tuple3._1();
        Path mountedConfigsPath = (Path)tuple3._2();
        Path finalConfigsPath = (Path)tuple3._3();
        void defaultConfigsPath2 = var2_2;
        void mountedConfigsPath2 = var3_3;
        void finalConfigsPath2 = var4_4;
        Map envVars = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"KAFKA_LOG4J_LOGGERS"), (Object)"kafka=INFO,kafka.network.RequestChannel$=WARN,kafka.producer.async.DefaultEventHandler=DEBUG,"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"KAFKA_LOG4J_ROOT_LOGLEVEL"), (Object)"ERROR"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"SOME_VARIABLE"), (Object)"Some Value")}));
        Files.write(defaultConfigsPath2.resolve("log4j.properties"), "default.config=default value".getBytes(StandardCharsets.UTF_8), new OpenOption[0]).toFile().deleteOnExit();
        Files.write(finalConfigsPath2.resolve("log4j.properties"), "existing.config=existing value".getBytes(StandardCharsets.UTF_8), new OpenOption[0]).toFile().deleteOnExit();
        KafkaDockerWrapper$.MODULE$.prepareLog4jConfigs((Path)defaultConfigsPath2, (Path)mountedConfigsPath2, (Path)finalConfigsPath2, envVars);
        try (BufferedSource source = Source$.MODULE$.fromFile(new StringBuilder(17).append(finalConfigsPath2.toString()).append("/log4j.properties").toString(), Codec$.MODULE$.fallbackSystemCodec());){
            string = source.mkString();
        }
        String actual = string;
        Assertions.assertEquals((Object)"default.config=default value\nlog4j.rootLogger=ERROR, stdout\nlog4j.logger.kafka=INFO\nlog4j.logger.kafka.network.RequestChannel$=WARN\nlog4j.logger.kafka.producer.async.DefaultEventHandler=DEBUG", (Object)actual);
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testPrepareLog4jConfigsWithoutEnvVariables() {
        String string;
        void var4_4;
        void var3_3;
        void var2_2;
        Tuple3<Path, Path, Path> tuple3 = this.createDirs();
        if (tuple3 == null) {
            throw new MatchError(null);
        }
        Path defaultConfigsPath = (Path)tuple3._1();
        Path mountedConfigsPath = (Path)tuple3._2();
        Path finalConfigsPath = (Path)tuple3._3();
        void defaultConfigsPath2 = var2_2;
        void mountedConfigsPath2 = var3_3;
        void finalConfigsPath2 = var4_4;
        Map envVars = Predef$.MODULE$.Map().empty();
        Files.write(defaultConfigsPath2.resolve("log4j.properties"), "default.config=default value".getBytes(StandardCharsets.UTF_8), new OpenOption[0]).toFile().deleteOnExit();
        Files.write(mountedConfigsPath2.resolve("log4j.properties"), "mounted.config=mounted value".getBytes(StandardCharsets.UTF_8), new OpenOption[0]).toFile().deleteOnExit();
        Files.write(finalConfigsPath2.resolve("log4j.properties"), "existing.config=existing value".getBytes(StandardCharsets.UTF_8), new OpenOption[0]).toFile().deleteOnExit();
        KafkaDockerWrapper$.MODULE$.prepareLog4jConfigs((Path)defaultConfigsPath2, (Path)mountedConfigsPath2, (Path)finalConfigsPath2, envVars);
        try (BufferedSource source = Source$.MODULE$.fromFile(new StringBuilder(17).append(finalConfigsPath2.toString()).append("/log4j.properties").toString(), Codec$.MODULE$.fallbackSystemCodec());){
            string = source.mkString();
        }
        String actual = string;
        Assertions.assertEquals((Object)"mounted.config=mounted value", (Object)actual);
    }

    @Test
    public void testGetToolsLog4jConfigsFromEnv() {
        Map envVars = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"KAFKA_TOOLS_LOG4J_LOGLEVEL"), (Object)"TRACE"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"SOME_VARIABLE"), (Object)"Some Value")}));
        String expected = "\nlog4j.rootLogger=TRACE, stderr";
        String actual = KafkaDockerWrapper$.MODULE$.getToolsLog4jConfigsFromEnv(envVars);
        Assertions.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testGetToolsLog4jConfigsFromEnvInvalidEnvVariable() {
        Map envVars = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"SOME_VARIABLE"), (Object)"Some Value")}));
        String expected = "";
        String actual = KafkaDockerWrapper$.MODULE$.getToolsLog4jConfigsFromEnv(envVars);
        Assertions.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testGetToolsLog4jConfigsFromEnvWithEmptyEnvVariable() {
        Map envVars = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"SOME_VARIABLE"), (Object)"Some Value"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"KAFKA_TOOLS_LOG4J_LOGLEVEL"), (Object)"")}));
        String expected = "";
        String actual = KafkaDockerWrapper$.MODULE$.getToolsLog4jConfigsFromEnv(envVars);
        Assertions.assertEquals((Object)expected, (Object)actual);
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testPrepareToolsLog4jConfigs() {
        String string;
        void var4_4;
        void var3_3;
        void var2_2;
        Tuple3<Path, Path, Path> tuple3 = this.createDirs();
        if (tuple3 == null) {
            throw new MatchError(null);
        }
        Path defaultConfigsPath = (Path)tuple3._1();
        Path mountedConfigsPath = (Path)tuple3._2();
        Path finalConfigsPath = (Path)tuple3._3();
        void defaultConfigsPath2 = var2_2;
        void mountedConfigsPath2 = var3_3;
        void finalConfigsPath2 = var4_4;
        Map envVars = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"KAFKA_TOOLS_LOG4J_LOGLEVEL"), (Object)"TRACE")}));
        Files.write(defaultConfigsPath2.resolve("tools-log4j.properties"), "default.config=default value".getBytes(StandardCharsets.UTF_8), new OpenOption[0]).toFile().deleteOnExit();
        Files.write(mountedConfigsPath2.resolve("tools-log4j.properties"), "mounted.config=mounted value".getBytes(StandardCharsets.UTF_8), new OpenOption[0]).toFile().deleteOnExit();
        Files.write(finalConfigsPath2.resolve("tools-log4j.properties"), "existing.config=existing value".getBytes(StandardCharsets.UTF_8), new OpenOption[0]).toFile().deleteOnExit();
        KafkaDockerWrapper$.MODULE$.prepareToolsLog4jConfigs((Path)defaultConfigsPath2, (Path)mountedConfigsPath2, (Path)finalConfigsPath2, envVars);
        try (BufferedSource source = Source$.MODULE$.fromFile(new StringBuilder(23).append(finalConfigsPath2.toString()).append("/tools-log4j.properties").toString(), Codec$.MODULE$.fallbackSystemCodec());){
            string = source.mkString();
        }
        String actual = string;
        Assertions.assertEquals((Object)"mounted.config=mounted value\nlog4j.rootLogger=TRACE, stderr", (Object)actual);
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testPrepareToolsLog4jConfigsWithoutMountedFile() {
        String string;
        void var4_4;
        void var3_3;
        void var2_2;
        Tuple3<Path, Path, Path> tuple3 = this.createDirs();
        if (tuple3 == null) {
            throw new MatchError(null);
        }
        Path defaultConfigsPath = (Path)tuple3._1();
        Path mountedConfigsPath = (Path)tuple3._2();
        Path finalConfigsPath = (Path)tuple3._3();
        void defaultConfigsPath2 = var2_2;
        void mountedConfigsPath2 = var3_3;
        void finalConfigsPath2 = var4_4;
        Map envVars = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"KAFKA_TOOLS_LOG4J_LOGLEVEL"), (Object)"TRACE")}));
        Files.write(defaultConfigsPath2.resolve("tools-log4j.properties"), "default.config=default value".getBytes(StandardCharsets.UTF_8), new OpenOption[0]).toFile().deleteOnExit();
        Files.write(finalConfigsPath2.resolve("tools-log4j.properties"), "existing.config=existing value".getBytes(StandardCharsets.UTF_8), new OpenOption[0]).toFile().deleteOnExit();
        KafkaDockerWrapper$.MODULE$.prepareToolsLog4jConfigs((Path)defaultConfigsPath2, (Path)mountedConfigsPath2, (Path)finalConfigsPath2, envVars);
        try (BufferedSource source = Source$.MODULE$.fromFile(new StringBuilder(23).append(finalConfigsPath2.toString()).append("/tools-log4j.properties").toString(), Codec$.MODULE$.fallbackSystemCodec());){
            string = source.mkString();
        }
        String actual = string;
        Assertions.assertEquals((Object)"default.config=default value\nlog4j.rootLogger=TRACE, stderr", (Object)actual);
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testPrepareToolsLog4jConfigsWithoutEnvVariable() {
        String string;
        void var4_4;
        void var3_3;
        void var2_2;
        Tuple3<Path, Path, Path> tuple3 = this.createDirs();
        if (tuple3 == null) {
            throw new MatchError(null);
        }
        Path defaultConfigsPath = (Path)tuple3._1();
        Path mountedConfigsPath = (Path)tuple3._2();
        Path finalConfigsPath = (Path)tuple3._3();
        void defaultConfigsPath2 = var2_2;
        void mountedConfigsPath2 = var3_3;
        void finalConfigsPath2 = var4_4;
        Map envVars = Predef$.MODULE$.Map().empty();
        Files.write(defaultConfigsPath2.resolve("tools-log4j.properties"), "default.config=default value".getBytes(StandardCharsets.UTF_8), new OpenOption[0]).toFile().deleteOnExit();
        Files.write(mountedConfigsPath2.resolve("tools-log4j.properties"), "mounted.config=mounted value".getBytes(StandardCharsets.UTF_8), new OpenOption[0]).toFile().deleteOnExit();
        Files.write(finalConfigsPath2.resolve("tools-log4j.properties"), "existing.config=existing value".getBytes(StandardCharsets.UTF_8), new OpenOption[0]).toFile().deleteOnExit();
        KafkaDockerWrapper$.MODULE$.prepareToolsLog4jConfigs((Path)defaultConfigsPath2, (Path)mountedConfigsPath2, (Path)finalConfigsPath2, envVars);
        try (BufferedSource source = Source$.MODULE$.fromFile(new StringBuilder(23).append(finalConfigsPath2.toString()).append("/tools-log4j.properties").toString(), Codec$.MODULE$.fallbackSystemCodec());){
            string = source.mkString();
        }
        String actual = string;
        Assertions.assertEquals((Object)"mounted.config=mounted value", (Object)actual);
    }

    private Tuple3<Path, Path, Path> createDirs() {
        Path defaultConfigsPath = Files.createTempDirectory("tmp", new FileAttribute[0]);
        Path mountedConfigsPath = Files.createTempDirectory("tmp", new FileAttribute[0]);
        Path finalConfigsPath = Files.createTempDirectory("tmp", new FileAttribute[0]);
        defaultConfigsPath.toFile().deleteOnExit();
        mountedConfigsPath.toFile().deleteOnExit();
        finalConfigsPath.toFile().deleteOnExit();
        return new Tuple3((Object)defaultConfigsPath, (Object)mountedConfigsPath, (Object)finalConfigsPath);
    }
}

