/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import java.io.File;
import java.io.Serializable;
import java.nio.channels.ClosedChannelException;
import java.util.Collections;
import java.util.Properties;
import java.util.regex.Pattern;
import kafka.log.LocalLog;
import kafka.log.LocalLog$;
import kafka.log.LocalLogTest;
import kafka.log.LocalLogTest$KeyValue$;
import kafka.log.LogTestUtils$;
import kafka.log.LogTruncation;
import kafka.log.SegmentDeletionReason;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.compress.Compression;
import org.apache.kafka.common.errors.KafkaStorageException;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.Record;
import org.apache.kafka.common.record.SimpleRecord;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.server.util.MockTime;
import org.apache.kafka.server.util.Scheduler;
import org.apache.kafka.storage.internals.log.FetchDataInfo;
import org.apache.kafka.storage.internals.log.LogConfig;
import org.apache.kafka.storage.internals.log.LogDirFailureChannel;
import org.apache.kafka.storage.internals.log.LogFileUtils;
import org.apache.kafka.storage.internals.log.LogOffsetMetadata;
import org.apache.kafka.storage.internals.log.LogSegment;
import org.apache.kafka.storage.internals.log.LogSegments;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.IterableLike;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.immutable.Vector;
import scala.collection.mutable.ArrayOps;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\u0011ub\u0001B5k\u0001=DQA\u001e\u0001\u0005\u0002]D\u0011B\u001f\u0001A\u0002\u0003\u0007I\u0011A>\t\u0017\u0005\u0015\u0001\u00011AA\u0002\u0013\u0005\u0011q\u0001\u0005\u000b\u0003'\u0001\u0001\u0019!A!B\u0013a\b\"CA\u000b\u0001\t\u0007I\u0011AA\f\u0011!\tI\u0003\u0001Q\u0001\n\u0005e\u0001\"CA\u0016\u0001\t\u0007I\u0011AA\f\u0011!\ti\u0003\u0001Q\u0001\n\u0005e\u0001\"CA\u0018\u0001\t\u0007I\u0011AA\u0019\u0011!\tI\u0005\u0001Q\u0001\n\u0005M\u0002\"CA&\u0001\t\u0007I\u0011AA'\u0011!\t\t\u0007\u0001Q\u0001\n\u0005=\u0003\"CA2\u0001\t\u0007I\u0011AA3\u0011!\t)\b\u0001Q\u0001\n\u0005\u001d\u0004\u0002C6\u0001\u0005\u0004%\t!a\u001e\t\u0011\u0005}\u0004\u0001)A\u0005\u0003sBq!!!\u0001\t\u0003\t\u0019\tC\u0004\u0002\u001c\u0002!\t!a!\u0007\r\u0005\u0015\u0006\u0001QAT\u0011)\t)l\u0005BK\u0002\u0013\u0005\u0011q\u0017\u0005\u000b\u0003\u001f\u001c\"\u0011#Q\u0001\n\u0005e\u0006BCAi'\tU\r\u0011\"\u0001\u00028\"Q\u00111[\n\u0003\u0012\u0003\u0006I!!/\t\rY\u001cB\u0011AAk\u0011\u001d\tyn\u0005C\u0001\u0003CD\u0011\"a@\u0014#\u0003%\tA!\u0001\t\u0013\t]1#!A\u0005\u0002\te\u0001\"\u0003B\u0010'E\u0005I\u0011\u0001B\u0011\u0011%\u0011)cEI\u0001\n\u0003\u0011\t\u0003C\u0005\u0003(M\t\t\u0011\"\u0011\u0003*!I!QG\n\u0002\u0002\u0013\u0005!q\u0007\u0005\n\u0005\u007f\u0019\u0012\u0011!C\u0001\u0005\u0003B\u0011Ba\u0013\u0014\u0003\u0003%\tE!\u0014\t\u0013\tm3#!A\u0005\u0002\tu\u0003\"\u0003B4'\u0005\u0005I\u0011\tB5\u0011%\u0011YgEA\u0001\n\u0003\u0012i\u0007C\u0005\u0003pM\t\t\u0011\"\u0011\u0003r\u001d9!Q\u000f\u0001\t\u0002\t]daBAS\u0001!\u0005!\u0011\u0010\u0005\u0007m\u001e\"\tAa\u001f\t\u000f\tut\u0005\"\u0001\u0003\u0000!I!\u0011R\u0014\u0002\u0002\u0013\u0005%1\u0012\u0005\n\u0005#;\u0013\u0011!CA\u0005'CqA!*\u0001\t\u0013\u00119\u000bC\u0004\u0003B\u0002!IAa1\t\u000f\t-\u0007\u0001\"\u0003\u0003N\"I!q\u001b\u0001\u0012\u0002\u0013%!\u0011\u001c\u0005\n\u0005;\u0004\u0011\u0013!C\u0005\u0005\u0003AqAa8\u0001\t\u0013\u0011\t\u000fC\u0005\u0004\n\u0001\t\n\u0011\"\u0003\u0003Z\"I11\u0002\u0001\u0012\u0002\u0013%!\u0011\u0001\u0005\n\u0007\u001b\u0001\u0011\u0013!C\u0005\u0007\u001fA\u0011ba\u0005\u0001#\u0003%Ia!\u0006\t\u0013\re\u0001!%A\u0005\n\rm\u0001\"CB\u0010\u0001E\u0005I\u0011BB\u000b\u0011\u001d\u0019\t\u0003\u0001C\u0001\u0003\u0007Cqaa\u000b\u0001\t\u0003\t\u0019\tC\u0004\u00040\u0001!\t!a!\t\u000f\rM\u0002\u0001\"\u0001\u0002\u0004\"91q\u0007\u0001\u0005\u0002\u0005\r\u0005bBB\u001e\u0001\u0011\u0005\u00111\u0011\u0005\b\u0007\u007f\u0001A\u0011AAB\u0011\u001d\u0019\u0019\u0005\u0001C\u0001\u0003\u0007Cqaa\u0012\u0001\t\u0003\t\u0019\tC\u0004\u0004L\u0001!\t!a!\t\u000f\r=\u0003\u0001\"\u0001\u0002\u0004\"911\u000b\u0001\u0005\u0002\u0005\r\u0005bBB,\u0001\u0011\u0005\u00111\u0011\u0005\b\u00077\u0002A\u0011BB/\u0011\u001d\u0019\u0019\u0007\u0001C\u0001\u0003\u0007Cqaa\u001a\u0001\t\u0003\t\u0019\tC\u0004\u0004l\u0001!Ia!\u001c\t\u000f\rE\u0004\u0001\"\u0001\u0002\u0004\"91Q\u000f\u0001\u0005\u0002\u0005\r\u0005bBB=\u0001\u0011\u0005\u00111\u0011\u0005\b\u0007{\u0002A\u0011AAB\u0011\u001d\u0019\t\t\u0001C\u0001\u0003\u0007Cqa!\"\u0001\t\u0003\t\u0019\tC\u0004\u0004\n\u0002!\t!a!\t\u000f\r5\u0005\u0001\"\u0003\u0004\u0010\"91\u0011\u0014\u0001\u0005\u0002\u0005\r\u0005bBBO\u0001\u0011\u0005\u00111\u0011\u0005\b\u0007C\u0003A\u0011AAB\u0011\u001d\u0019)\u000b\u0001C\u0001\u0003\u0007Cqa!+\u0001\t\u0003\t\u0019\tC\u0004\u0004.\u0002!\t!a!\t\u000f\rE\u0006\u0001\"\u0001\u0002\u0004\"91Q\u0017\u0001\u0005\u0002\u0005\r\u0005bBB]\u0001\u0011\u0005\u00111\u0011\u0005\b\u0007{\u0003A\u0011AAB\u0011\u001d\u0019\t\r\u0001C\u0001\u0003\u0007Cqa!2\u0001\t\u0003\t\u0019\tC\u0004\u0004J\u0002!\t!a!\t\u000f\r5\u0007\u0001\"\u0001\u0002\u0004\"91\u0011\u001b\u0001\u0005\u0002\u0005\r\u0005bBBk\u0001\u0011%1q\u001b\u0005\n\t+\u0001\u0011\u0013!C\u0005\t/A\u0011\u0002b\u0007\u0001#\u0003%I\u0001\"\b\t\u0013\u0011\u0005\u0002!%A\u0005\n\t\u0005\u0001\"\u0003C\u0012\u0001E\u0005I\u0011BB\u000e\u0011%!)\u0003AI\u0001\n\u0013!9\u0003C\u0005\u0005,\u0001\t\n\u0011\"\u0003\u0005.!IA\u0011\u0007\u0001\u0012\u0002\u0013%A1\u0007\u0005\n\to\u0001\u0011\u0013!C\u0005\ts\u0011A\u0002T8dC2dun\u001a+fgRT!a\u001b7\u0002\u00071|wMC\u0001n\u0003\u0015Y\u0017MZ6b\u0007\u0001\u0019\"\u0001\u00019\u0011\u0005E$X\"\u0001:\u000b\u0003M\fQa]2bY\u0006L!!\u001e:\u0003\r\u0005s\u0017PU3g\u0003\u0019a\u0014N\\5u}Q\t\u0001\u0010\u0005\u0002z\u00015\t!.\u0001\u0004d_:4\u0017nZ\u000b\u0002yB\u0019Q0!\u0001\u000e\u0003yT!a 7\u0002\rM,'O^3s\u0013\r\t\u0019A \u0002\f\u0017\u000647.Y\"p]\u001aLw-\u0001\u0006d_:4\u0017nZ0%KF$B!!\u0003\u0002\u0010A\u0019\u0011/a\u0003\n\u0007\u00055!O\u0001\u0003V]&$\b\u0002CA\t\u0007\u0005\u0005\t\u0019\u0001?\u0002\u0007a$\u0013'A\u0004d_:4\u0017n\u001a\u0011\u0002\rQl\u0007\u000fR5s+\t\tI\u0002\u0005\u0003\u0002\u001c\u0005\u0015RBAA\u000f\u0015\u0011\ty\"!\t\u0002\u0005%|'BAA\u0012\u0003\u0011Q\u0017M^1\n\t\u0005\u001d\u0012Q\u0004\u0002\u0005\r&dW-A\u0004u[B$\u0015N\u001d\u0011\u0002\r1|w\rR5s\u0003\u001dawn\u001a#je\u0002\na\u0002^8qS\u000e\u0004\u0016M\u001d;ji&|g.\u0006\u0002\u00024A!\u0011QGA#\u001b\t\t9D\u0003\u0003\u0002:\u0005m\u0012AB2p[6|gNC\u0002n\u0003{QA!a\u0010\u0002B\u00051\u0011\r]1dQ\u0016T!!a\u0011\u0002\u0007=\u0014x-\u0003\u0003\u0002H\u0005]\"A\u0004+pa&\u001c\u0007+\u0019:uSRLwN\\\u0001\u0010i>\u0004\u0018n\u0019)beRLG/[8oA\u0005!Bn\\4ESJ4\u0015-\u001b7ve\u0016\u001c\u0005.\u00198oK2,\"!a\u0014\u0011\t\u0005E\u0013QL\u0007\u0003\u0003'R1a[A+\u0015\u0011\t9&!\u0017\u0002\u0013%tG/\u001a:oC2\u001c(\u0002BA.\u0003w\tqa\u001d;pe\u0006<W-\u0003\u0003\u0002`\u0005M#\u0001\u0006'pO\u0012K'OR1jYV\u0014Xm\u00115b]:,G.A\u000bm_\u001e$\u0015N\u001d$bS2,(/Z\"iC:tW\r\u001c\u0011\u0002\u00115|7m\u001b+j[\u0016,\"!a\u001a\u0011\t\u0005%\u0014\u0011O\u0007\u0003\u0003WRA!!\u001c\u0002p\u0005!Q\u000f^5m\u0015\ry\u00181H\u0005\u0005\u0003g\nYG\u0001\u0005N_\u000e\\G+[7f\u0003%iwnY6US6,\u0007%\u0006\u0002\u0002zA\u0019\u00110a\u001f\n\u0007\u0005u$N\u0001\u0005M_\u000e\fG\u000eT8h\u0003\u0011awn\u001a\u0011\u0002\u000bM,G/\u00169\u0015\u0005\u0005%\u0001fA\t\u0002\bB!\u0011\u0011RAL\u001b\t\tYI\u0003\u0003\u0002\u000e\u0006=\u0015aA1qS*!\u0011\u0011SAJ\u0003\u001dQW\u000f]5uKJTA!!&\u0002B\u0005)!.\u001e8ji&!\u0011\u0011TAF\u0005)\u0011UMZ8sK\u0016\u000b7\r[\u0001\ti\u0016\f'\u000fR8x]\"\u001a!#a(\u0011\t\u0005%\u0015\u0011U\u0005\u0005\u0003G\u000bYIA\u0005BMR,'/R1dQ\nA1*Z=WC2,Xm\u0005\u0004\u0014a\u0006%\u0016q\u0016\t\u0004c\u0006-\u0016bAAWe\n9\u0001K]8ek\u000e$\bcA9\u00022&\u0019\u00111\u0017:\u0003\u0019M+'/[1mSj\f'\r\\3\u0002\u0007-,\u00170\u0006\u0002\u0002:B!\u00111XAe\u001d\u0011\ti,!2\u0011\u0007\u0005}&/\u0004\u0002\u0002B*\u0019\u00111\u00198\u0002\rq\u0012xn\u001c;?\u0013\r\t9M]\u0001\u0007!J,G-\u001a4\n\t\u0005-\u0017Q\u001a\u0002\u0007'R\u0014\u0018N\\4\u000b\u0007\u0005\u001d'/\u0001\u0003lKf\u0004\u0013!\u0002<bYV,\u0017A\u0002<bYV,\u0007\u0005\u0006\u0004\u0002X\u0006m\u0017Q\u001c\t\u0004\u00033\u001cR\"\u0001\u0001\t\u000f\u0005U\u0006\u00041\u0001\u0002:\"9\u0011\u0011\u001b\rA\u0002\u0005e\u0016\u0001\u0003;p%\u0016\u001cwN\u001d3\u0015\t\u0005\r\u0018q\u001e\t\u0005\u0003K\fY/\u0004\u0002\u0002h*!\u0011\u0011^A\u001c\u0003\u0019\u0011XmY8sI&!\u0011Q^At\u00051\u0019\u0016.\u001c9mKJ+7m\u001c:e\u0011%\t\t0\u0007I\u0005\u0002\u0004\t\u00190A\u0005uS6,7\u000f^1naB)\u0011/!>\u0002z&\u0019\u0011q\u001f:\u0003\u0011q\u0012\u0017P\\1nKz\u00022!]A~\u0013\r\tiP\u001d\u0002\u0005\u0019>tw-\u0001\nu_J+7m\u001c:eI\u0011,g-Y;mi\u0012\nTC\u0001B\u0002U\u0011\tIP!\u0002,\u0005\t\u001d\u0001\u0003\u0002B\u0005\u0005'i!Aa\u0003\u000b\t\t5!qB\u0001\nk:\u001c\u0007.Z2lK\u0012T1A!\u0005s\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0005+\u0011YAA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\fAaY8qsR1\u0011q\u001bB\u000e\u0005;A\u0011\"!.\u001c!\u0003\u0005\r!!/\t\u0013\u0005E7\u0004%AA\u0002\u0005e\u0016AD2paf$C-\u001a4bk2$H%M\u000b\u0003\u0005GQC!!/\u0003\u0006\u0005q1m\u001c9zI\u0011,g-Y;mi\u0012\u0012\u0014!\u00049s_\u0012,8\r\u001e)sK\u001aL\u00070\u0006\u0002\u0003,A!!Q\u0006B\u001a\u001b\t\u0011yC\u0003\u0003\u00032\u0005\u0005\u0012\u0001\u00027b]\u001eLA!a3\u00030\u0005a\u0001O]8ek\u000e$\u0018I]5usV\u0011!\u0011\b\t\u0004c\nm\u0012b\u0001B\u001fe\n\u0019\u0011J\u001c;\u0002\u001dA\u0014x\u000eZ;di\u0016cW-\\3oiR!!1\tB%!\r\t(QI\u0005\u0004\u0005\u000f\u0012(aA!os\"I\u0011\u0011\u0003\u0011\u0002\u0002\u0003\u0007!\u0011H\u0001\u0010aJ|G-^2u\u0013R,'/\u0019;peV\u0011!q\n\t\u0007\u0005#\u00129Fa\u0011\u000e\u0005\tM#b\u0001B+e\u0006Q1m\u001c7mK\u000e$\u0018n\u001c8\n\t\te#1\u000b\u0002\t\u0013R,'/\u0019;pe\u0006A1-\u00198FcV\fG\u000e\u0006\u0003\u0003`\t\u0015\u0004cA9\u0003b%\u0019!1\r:\u0003\u000f\t{w\u000e\\3b]\"I\u0011\u0011\u0003\u0012\u0002\u0002\u0003\u0007!1I\u0001\tQ\u0006\u001c\bnQ8eKR\u0011!\u0011H\u0001\ti>\u001cFO]5oOR\u0011!1F\u0001\u0007KF,\u0018\r\\:\u0015\t\t}#1\u000f\u0005\n\u0003#)\u0013\u0011!a\u0001\u0005\u0007\n\u0001bS3z-\u0006dW/\u001a\t\u0004\u00033<3\u0003B\u0014q\u0003_#\"Aa\u001e\u0002\u0015\u0019\u0014x.\u001c*fG>\u0014H\r\u0006\u0003\u0002X\n\u0005\u0005bBAuS\u0001\u0007!1\u0011\t\u0005\u0003K\u0014))\u0003\u0003\u0003\b\u0006\u001d(A\u0002*fG>\u0014H-A\u0003baBd\u0017\u0010\u0006\u0004\u0002X\n5%q\u0012\u0005\b\u0003kS\u0003\u0019AA]\u0011\u001d\t\tN\u000ba\u0001\u0003s\u000bq!\u001e8baBd\u0017\u0010\u0006\u0003\u0003\u0016\n\u0005\u0006#B9\u0003\u0018\nm\u0015b\u0001BMe\n1q\n\u001d;j_:\u0004r!\u001dBO\u0003s\u000bI,C\u0002\u0003 J\u0014a\u0001V;qY\u0016\u0014\u0004\"\u0003BRW\u0005\u0005\t\u0019AAl\u0003\rAH\u0005M\u0001\rWZ\u001cHk\u001c*fG>\u0014Hm\u001d\u000b\u0005\u0005S\u0013Y\f\u0005\u0004\u0003,\nU\u00161\u001d\b\u0005\u0005[\u0013\tL\u0004\u0003\u0002@\n=\u0016\"A:\n\u0007\tM&/A\u0004qC\u000e\\\u0017mZ3\n\t\t]&\u0011\u0018\u0002\t\u0013R,'/\u00192mK*\u0019!1\u0017:\t\u000f\tuF\u00061\u0001\u0003@\u0006I1.Z=WC2,Xm\u001d\t\u0007\u0005W\u0013),a6\u0002\u0019I,7m\u001c:egR{7J^:\u0015\t\t}&Q\u0019\u0005\b\u0005\u000fl\u0003\u0019\u0001Be\u0003\u001d\u0011XmY8sIN\u0004bAa+\u00036\n\r\u0015!D1qa\u0016tGMU3d_J$7\u000f\u0006\u0005\u0002\n\t='\u0011\u001bBj\u0011\u001d\u00119M\fa\u0001\u0005SC\u0001b\u001b\u0018\u0011\u0002\u0003\u0007\u0011\u0011\u0010\u0005\n\u0005+t\u0003\u0013!a\u0001\u0003s\fQ\"\u001b8ji&\fGn\u00144gg\u0016$\u0018aF1qa\u0016tGMU3d_J$7\u000f\n3fM\u0006,H\u000e\u001e\u00133+\t\u0011YN\u000b\u0003\u0002z\t\u0015\u0011aF1qa\u0016tGMU3d_J$7\u000f\n3fM\u0006,H\u000e\u001e\u00134\u0003-\u0011X-\u00193SK\u000e|'\u000fZ:\u0015\u001d\t\r(\u0011\u001eBv\u0005_\u0014)P!?\u0004\u0006A!\u0011\u0011\u000bBs\u0013\u0011\u00119/a\u0015\u0003\u001b\u0019+Go\u00195ECR\f\u0017J\u001c4p\u0011!Y\u0017\u0007%AA\u0002\u0005e\u0004\"\u0003BwcA\u0005\t\u0019AA}\u0003-\u0019H/\u0019:u\u001f\u001a47/\u001a;\t\u0013\tE\u0018\u0007%CA\u0002\tM\u0018!C7bq2+gn\u001a;i!\u0015\t\u0018Q\u001fB\u001d\u0011%\u001190\rI\u0001\u0002\u0004\u0011y&A\u0007nS:|e.Z'fgN\fw-\u001a\u0005\n\u0005w\f\u0004\u0013\"a\u0001\u0005{\f\u0011#\\1y\u001f\u001a47/\u001a;NKR\fG-\u0019;b!\u0015\t\u0018Q\u001fB\u0000!\u0011\t\tf!\u0001\n\t\r\r\u00111\u000b\u0002\u0012\u0019><wJ\u001a4tKRlU\r^1eCR\f\u0007\"CB\u0004cA\u0005\t\u0019\u0001B0\u0003IIgn\u00197vI\u0016\f%m\u001c:uK\u0012$\u0006P\\:\u0002+I,\u0017\r\u001a*fG>\u0014Hm\u001d\u0013eK\u001a\fW\u000f\u001c;%c\u0005)\"/Z1e%\u0016\u001cwN\u001d3tI\u0011,g-Y;mi\u0012\u0012\u0014!\u0006:fC\u0012\u0014VmY8sIN$C-\u001a4bk2$HeM\u000b\u0003\u0007#QCA!\u000f\u0003\u0006\u0005)\"/Z1e%\u0016\u001cwN\u001d3tI\u0011,g-Y;mi\u0012\"TCAB\fU\u0011\u0011yF!\u0002\u0002+I,\u0017\r\u001a*fG>\u0014Hm\u001d\u0013eK\u001a\fW\u000f\u001c;%kU\u00111Q\u0004\u0016\u0005\u0005\u007f\u0014)!A\u000bsK\u0006$'+Z2pe\u0012\u001cH\u0005Z3gCVdG\u000f\n\u001c\u00029Q,7\u000f\u001e'pO\u0012+G.\u001a;f'\u0016<W.\u001a8ugN+8mY3tg\"\u001a\u0001h!\n\u0011\t\u0005%5qE\u0005\u0005\u0007S\tYI\u0001\u0003UKN$\u0018A\u0007;fgR\u0014v\u000e\u001c7F[B$\u00180Q2uSZ,7+Z4nK:$\bfA\u001d\u0004&\u00051D/Z:u\u0019><G)\u001a7fi\u0016$\u0015N]*vG\u000e,7o],iK:,U\u000e\u001d;z\u0003:$g)Y5mkJ,w\u000b[3o\u001d>tW)\u001c9us\"\u001a!h!\n\u0002!Q,7\u000f^+qI\u0006$XmQ8oM&<\u0007fA\u001e\u0004&\u0005AB/Z:u\u0019><G)\u001b:SK:\fW.\u001a+p\u001d\u0016<H)\u001b:)\u0007q\u001a)#A\u000fuKN$Hj\\4ESJ\u0014VM\\1nKR{W\t_5ti&tw\rR5sQ\ri4QE\u0001\ri\u0016\u001cH\u000fT8h\r2,8\u000f\u001b\u0015\u0004}\r\u0015\u0012!\u0004;fgRdunZ!qa\u0016tG\rK\u0002@\u0007K\t1\u0003^3ti2{wm\u00117pg\u0016\u001cVoY2fgND3\u0001QB\u0013\u0003Y!Xm\u001d;M_\u001e\u001cEn\\:f\u0013\u0012,W\u000e]8uK:$\bfA!\u0004&\u0005YC/Z:u\u0019><7\t\\8tK\u001a\u000b\u0017\u000e\\;sK^CWM\\%o\u001b\u0016lwN]=Ck\u001a4WM]\"m_N,G\rK\u0002C\u0007K\tA\u0003^3ti2{wm\u00117pg\u0016D\u0015M\u001c3mKJ\u001c\bfA\"\u0004&\u0005qB/Z:u\u0019><7\t\\8tK\"\u000bg\u000e\u001a7feNLE-Z7q_R,g\u000e\u001e\u0015\u0004\t\u000e\u0015\u0012a\u0007;fgR\u0014V-\\8wK\u0006sG\rR3mKR,7+Z4nK:$8\u000f\u0006\u0003\u0002\n\r}\u0003bBB1\u000b\u0002\u0007!qL\u0001\fCNLhn\u0019#fY\u0016$X-A\u0010uKN$(+Z7pm\u0016\fe\u000e\u001a#fY\u0016$XmU3h[\u0016tGo]*z]\u000eD3ARB\u0013\u0003\u0001\"Xm\u001d;SK6|g/Z!oI\u0012+G.\u001a;f'\u0016<W.\u001a8ug\u0006\u001b\u0018P\\2)\u0007\u001d\u001b)#\u0001\fuKN$H)\u001a7fi\u0016\u001cVmZ7f]R4\u0015\u000e\\3t)\u0011\tIaa\u001c\t\u000f\r\u0005\u0004\n1\u0001\u0003`\u0005QB/Z:u\t\u0016dW\r^3TK\u001elWM\u001c;GS2,7oU=oG\"\u001a\u0011j!\n\u00027Q,7\u000f\u001e#fY\u0016$XmU3h[\u0016tGOR5mKN\f5/\u001f8dQ\rQ5QE\u0001\u001bi\u0016\u001cHo\u0011:fCR,\u0017I\u001c3EK2,G/Z*fO6,g\u000e\u001e\u0015\u0004\u0017\u000e\u0015\u0012a\u0007;fgR$&/\u001e8dCR,g)\u001e7ms\u0006sGm\u0015;beR\fE\u000fK\u0002M\u0007K\ta\u0005^3ti^CWM\u001c$fi\u000eDwJ\u001a4tKRD\u0015n\u001a5feRC\u0017M\\'bq>3gm]3uQ\ri5QE\u0001\u000fi\u0016\u001cH\u000f\u0016:v]\u000e\fG/\u001a+pQ\rq5QE\u0001\u001ai\u0016\u001cHOT8o\u0003\u000e$\u0018N^3TK\u001elWM\u001c;t\rJ|W\u000eK\u0002P\u0007K\t!\u0003^8qS\u000e\u0004\u0016M\u001d;ji&|gNT1nKR1\u0011\u0011XBI\u0007+Cqaa%Q\u0001\u0004\tI,A\u0003u_BL7\rC\u0004\u0004\u0018B\u0003\r!!/\u0002\u0013A\f'\u000f^5uS>t\u0017a\u0007;fgR\u0004\u0016M]:f)>\u0004\u0018n\u0019)beRLG/[8o\u001d\u0006lW\rK\u0002R\u0007K\tA\u0007^3tiB\u000b'o]3U_BL7\rU1si&$\u0018n\u001c8OC6,w+\u001b;i!\u0016\u0014\u0018n\u001c3G_J$U\r\\3uK\u0012$v\u000e]5dQ\r\u00116QE\u0001(i\u0016\u001cH\u000fU1sg\u0016$v\u000e]5d!\u0006\u0014H/\u001b;j_:t\u0015-\\3G_J,U\u000e\u001d;z\u001d\u0006lW\rK\u0002T\u0007K\t!\u0005^3tiB\u000b'o]3U_BL7\rU1si&$\u0018n\u001c8OC6,gi\u001c:Ok2d\u0007f\u0001+\u0004&\u0005qC/Z:u!\u0006\u00148/\u001a+pa&\u001c\u0007+\u0019:uSRLwN\u001c(b[\u00164uN]'jgNLgnZ*fa\u0006\u0014\u0018\r^8sQ\r)6QE\u0001+i\u0016\u001cH\u000fU1sg\u0016$v\u000e]5d!\u0006\u0014H/\u001b;j_:t\u0015-\\3G_Jl\u0015n]:j]\u001e$v\u000e]5dQ\r16QE\u0001/i\u0016\u001cH\u000fU1sg\u0016$v\u000e]5d!\u0006\u0014H/\u001b;j_:t\u0015-\\3G_Jl\u0015n]:j]\u001e\u0004\u0016M\u001d;ji&|g\u000eK\u0002X\u0007K\ta\u0006^3tiB\u000b'o]3U_BL7\rU1si&$\u0018n\u001c8OC6,gi\u001c:J]Z\fG.\u001b3QCJ$\u0018\u000e^5p]\"\u001a\u0001l!\n\u0002aQ,7\u000f\u001e)beN,Gk\u001c9jGB\u000b'\u000f^5uS>tg*Y7f\r>\u0014X\t_5ti&tw-\u00138wC2LG\rR5sQ\rI6QE\u0001\u0015i\u0016\u001cH\u000fT8h\t\u0016dW\r^3ESJt\u0015-\\3)\u0007i\u001b)#\u0001\nuKN$xJ\u001a4tKR4%o\\7GS2,\u0007fA.\u0004&\u0005\u0001C/Z:u%>dGnU3h[\u0016tG\u000f\u00165bi\u0006c'/Z1es\u0016C\u0018n\u001d;tQ\ra6QE\u0001\u0019i\u0016\u001cHOT3x'\u0016<W.\u001a8ug\u00063G/\u001a:S_2d\u0007fA/\u0004&\u0005YC/Z:u%>dGnU3h[\u0016tG/\u0012:s_J<\u0006.\u001a8OKb$xJ\u001a4tKRL5/\u00137mK\u001e\fG\u000eK\u0002_\u0007K\t!\u0004^3ti\u001acWo\u001d5j]\u001etuN\\#ySN$XM\u001c;ESJD3aXB\u0013\u0003}\u0019'/Z1uK2{7-\u00197M_\u001e<\u0016\u000e\u001e5BGRLg/Z*fO6,g\u000e\u001e\u000b\u0015\u0003s\u001aIn!8\u0004f\u000e=81_B|\t\u0003!\t\u0002b\u0005\t\u0013\rm\u0007\r%AA\u0002\u0005e\u0011a\u00013je\"1!\u0010\u0019a\u0001\u0007?\u0004B!!\u0015\u0004b&!11]A*\u0005%aunZ\"p]\u001aLw\rC\u0005\u0004h\u0002\u0004\n\u00111\u0001\u0004j\u0006A1/Z4nK:$8\u000f\u0005\u0003\u0002R\r-\u0018\u0002BBw\u0003'\u00121\u0002T8h'\u0016<W.\u001a8ug\"I1\u0011\u001f1\u0011\u0002\u0003\u0007\u0011\u0011`\u0001\u000ee\u0016\u001cwN^3ssB{\u0017N\u001c;\t\u0013\rU\b\r%AA\u0002\t}\u0018A\u00058fqR|eMZ:fi6+G/\u00193bi\u0006D\u0011b!?a!\u0003\u0005\raa?\u0002\u0013M\u001c\u0007.\u001a3vY\u0016\u0014\b\u0003BA5\u0007{LAaa@\u0002l\tI1k\u00195fIVdWM\u001d\u0005\n\t\u0007\u0001\u0007\u0013!a\u0001\t\u000b\tA\u0001^5nKB!Aq\u0001C\u0007\u001b\t!IA\u0003\u0003\u0005\f\u0005]\u0012!B;uS2\u001c\u0018\u0002\u0002C\b\t\u0013\u0011A\u0001V5nK\"I\u0011q\u00061\u0011\u0002\u0003\u0007\u00111\u0007\u0005\n\u0003\u0017\u0002\u0007\u0013!a\u0001\u0003\u001f\n\u0011f\u0019:fCR,Gj\\2bY2{wmV5uQ\u0006\u001bG/\u001b<f'\u0016<W.\u001a8uI\u0011,g-Y;mi\u0012\nTC\u0001C\rU\u0011\tIB!\u0002\u0002S\r\u0014X-\u0019;f\u0019>\u001c\u0017\r\u001c'pO^KG\u000f[!di&4XmU3h[\u0016tG\u000f\n3fM\u0006,H\u000e\u001e\u00134+\t!yB\u000b\u0003\u0004j\n\u0015\u0011!K2sK\u0006$X\rT8dC2dunZ,ji\"\f5\r^5wKN+w-\\3oi\u0012\"WMZ1vYR$C'A\u0015de\u0016\fG/\u001a'pG\u0006dGj\\4XSRD\u0017i\u0019;jm\u0016\u001cVmZ7f]R$C-\u001a4bk2$H%N\u0001*GJ,\u0017\r^3M_\u000e\fG\u000eT8h/&$\b.Q2uSZ,7+Z4nK:$H\u0005Z3gCVdG\u000f\n\u001c\u0016\u0005\u0011%\"\u0006BB~\u0005\u000b\t\u0011f\u0019:fCR,Gj\\2bY2{wmV5uQ\u0006\u001bG/\u001b<f'\u0016<W.\u001a8uI\u0011,g-Y;mi\u0012:TC\u0001C\u0018U\u0011!)A!\u0002\u0002S\r\u0014X-\u0019;f\u0019>\u001c\u0017\r\u001c'pO^KG\u000f[!di&4XmU3h[\u0016tG\u000f\n3fM\u0006,H\u000e\u001e\u00139+\t!)D\u000b\u0003\u00024\t\u0015\u0011!K2sK\u0006$X\rT8dC2dunZ,ji\"\f5\r^5wKN+w-\\3oi\u0012\"WMZ1vYR$\u0013(\u0006\u0002\u0005<)\"\u0011q\nB\u0003\u0001")
public class LocalLogTest {
    private volatile LocalLogTest$KeyValue$ KeyValue$module;
    private KafkaConfig config;
    private final File tmpDir = TestUtils$.MODULE$.tempDir();
    private final File logDir = TestUtils$.MODULE$.randomPartitionLogDir(this.tmpDir());
    private final TopicPartition topicPartition = new TopicPartition("test_topic", 1);
    private final LogDirFailureChannel logDirFailureChannel = new LogDirFailureChannel(10);
    private final MockTime mockTime = new MockTime();
    private final LocalLog log;

    public LocalLogTest$KeyValue$ KeyValue() {
        if (this.KeyValue$module == null) {
            this.KeyValue$lzycompute$1();
        }
        return this.KeyValue$module;
    }

    public KafkaConfig config() {
        return this.config;
    }

    public void config_$eq(KafkaConfig x$1) {
        this.config = x$1;
    }

    public File tmpDir() {
        return this.tmpDir;
    }

    public File logDir() {
        return this.logDir;
    }

    public TopicPartition topicPartition() {
        return this.topicPartition;
    }

    public LogDirFailureChannel logDirFailureChannel() {
        return this.logDirFailureChannel;
    }

    public MockTime mockTime() {
        return this.mockTime;
    }

    public LocalLog log() {
        return this.log;
    }

    @BeforeEach
    public void setUp() {
        int x$1 = 0;
        String x$2 = "127.0.0.1:1";
        int x$3 = -1;
        boolean x$4 = TestUtils$.MODULE$.createBrokerConfig$default$3();
        boolean x$5 = TestUtils$.MODULE$.createBrokerConfig$default$4();
        Option<SecurityProtocol> x$6 = TestUtils$.MODULE$.createBrokerConfig$default$6();
        Option<File> x$7 = TestUtils$.MODULE$.createBrokerConfig$default$7();
        Option<Properties> x$8 = TestUtils$.MODULE$.createBrokerConfig$default$8();
        boolean x$9 = TestUtils$.MODULE$.createBrokerConfig$default$9();
        boolean x$10 = TestUtils$.MODULE$.createBrokerConfig$default$10();
        int x$11 = TestUtils$.MODULE$.createBrokerConfig$default$11();
        boolean x$12 = TestUtils$.MODULE$.createBrokerConfig$default$12();
        int x$13 = TestUtils$.MODULE$.createBrokerConfig$default$13();
        boolean x$14 = TestUtils$.MODULE$.createBrokerConfig$default$14();
        int x$15 = TestUtils$.MODULE$.createBrokerConfig$default$15();
        Option<String> x$16 = TestUtils$.MODULE$.createBrokerConfig$default$16();
        int x$17 = TestUtils$.MODULE$.createBrokerConfig$default$17();
        boolean x$18 = TestUtils$.MODULE$.createBrokerConfig$default$18();
        int x$19 = TestUtils$.MODULE$.createBrokerConfig$default$19();
        short x$20 = TestUtils$.MODULE$.createBrokerConfig$default$20();
        boolean x$21 = TestUtils$.MODULE$.createBrokerConfig$default$21();
        Properties props = TestUtils$.MODULE$.createBrokerConfig(x$1, x$2, x$4, x$5, x$3, x$6, x$7, x$8, x$9, x$10, x$11, x$12, x$13, x$14, x$15, x$16, x$17, x$18, x$19, x$20, x$21);
        this.config_$eq(KafkaConfig$.MODULE$.fromProps(props));
    }

    @AfterEach
    public void tearDown() {
        try {
            this.log().close();
        }
        catch (KafkaStorageException kafkaStorageException) {}
        Utils.delete((File)this.tmpDir());
    }

    private Iterable<SimpleRecord> kvsToRecords(Iterable<KeyValue> keyValues) {
        return (Iterable)keyValues.map((Function1 & Serializable & scala.Serializable)kv -> kv.toRecord((Function0<Object>)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> kv.toRecord$default$1()), Iterable$.MODULE$.canBuildFrom());
    }

    private Iterable<KeyValue> recordsToKvs(Iterable<Record> records) {
        return (Iterable)records.map((Function1 & Serializable & scala.Serializable)r -> this.KeyValue().fromRecord((Record)r), Iterable$.MODULE$.canBuildFrom());
    }

    private void appendRecords(Iterable<SimpleRecord> records, LocalLog log, long initialOffset) {
        log.append(initialOffset + (long)records.size() - 1L, ((SimpleRecord)records.head()).timestamp(), initialOffset, MemoryRecords.withRecords((long)initialOffset, (Compression)Compression.NONE, (Integer)Predef$.MODULE$.int2Integer(0), (SimpleRecord[])((SimpleRecord[])records.toList().toArray(ClassTag$.MODULE$.apply(SimpleRecord.class)))));
    }

    private LocalLog appendRecords$default$2() {
        return this.log();
    }

    private long appendRecords$default$3() {
        return 0L;
    }

    private FetchDataInfo readRecords(LocalLog log, long startOffset, Function0<Object> maxLength, boolean minOneMessage, Function0<LogOffsetMetadata> maxOffsetMetadata, boolean includeAbortedTxns) {
        return log.read(startOffset, maxLength.apply$mcI$sp(), minOneMessage, (LogOffsetMetadata)maxOffsetMetadata.apply(), includeAbortedTxns);
    }

    private LocalLog readRecords$default$1() {
        return this.log();
    }

    private long readRecords$default$2() {
        return 0L;
    }

    private int readRecords$default$3() {
        return this.log().segments().activeSegment().size();
    }

    private boolean readRecords$default$4() {
        return false;
    }

    private LogOffsetMetadata readRecords$default$5() {
        return this.log().logEndOffsetMetadata();
    }

    private boolean readRecords$default$6() {
        return false;
    }

    @Test
    public void testLogDeleteSegmentsSuccess() {
        SimpleRecord record = new SimpleRecord(this.mockTime().milliseconds(), "a".getBytes());
        this.appendRecords((Iterable<SimpleRecord>)new .colon.colon((Object)record, (List)Nil$.MODULE$), this.appendRecords$default$2(), this.appendRecords$default$3());
        this.log().roll(this.log().roll$default$1());
        Assertions.assertEquals((int)2, (int)this.log().segments().numberOfSegments());
        Assertions.assertFalse((boolean)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.logDir().listFiles())).isEmpty());
        Vector segmentsBeforeDelete = ((TraversableOnce)CollectionConverters$.MODULE$.collectionAsScalaIterableConverter(this.log().segments().values()).asScala()).toVector();
        Iterable deletedSegments = this.log().deleteAllSegments();
        Assertions.assertTrue((boolean)this.log().segments().isEmpty());
        Assertions.assertEquals((Object)segmentsBeforeDelete, (Object)deletedSegments);
        Assertions.assertThrows(KafkaStorageException.class, () -> this.log().checkIfMemoryMappedBufferClosed());
        Assertions.assertTrue((boolean)this.logDir().exists());
    }

    @Test
    public void testRollEmptyActiveSegment() {
        LogSegment oldActiveSegment = this.log().segments().activeSegment();
        this.log().roll(this.log().roll$default$1());
        Assertions.assertEquals((int)1, (int)this.log().segments().numberOfSegments());
        Assertions.assertNotEquals((Object)oldActiveSegment, (Object)this.log().segments().activeSegment());
        Assertions.assertFalse((boolean)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.logDir().listFiles())).isEmpty());
        Assertions.assertTrue((boolean)oldActiveSegment.hasSuffix(LocalLog$.MODULE$.DeletedFileSuffix()));
    }

    @Test
    public void testLogDeleteDirSuccessWhenEmptyAndFailureWhenNonEmpty() {
        SimpleRecord record = new SimpleRecord(this.mockTime().milliseconds(), "a".getBytes());
        this.appendRecords((Iterable<SimpleRecord>)new .colon.colon((Object)record, (List)Nil$.MODULE$), this.appendRecords$default$2(), this.appendRecords$default$3());
        this.log().roll(this.log().roll$default$1());
        Assertions.assertEquals((int)2, (int)this.log().segments().numberOfSegments());
        Assertions.assertFalse((boolean)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.logDir().listFiles())).isEmpty());
        Assertions.assertThrows(IllegalStateException.class, () -> this.log().deleteEmptyDir());
        Assertions.assertTrue((boolean)this.logDir().exists());
        this.log().deleteAllSegments();
        this.log().deleteEmptyDir();
        Assertions.assertFalse((boolean)this.logDir().exists());
    }

    @Test
    public void testUpdateConfig() {
        LogConfig oldConfig = this.log().config();
        Assertions.assertEquals((Object)oldConfig, (Object)this.log().config());
        int x$1 = oldConfig.segmentSize + 1;
        long x$2 = LogTestUtils$.MODULE$.createLogConfig$default$1();
        long x$3 = LogTestUtils$.MODULE$.createLogConfig$default$3();
        long x$4 = LogTestUtils$.MODULE$.createLogConfig$default$4();
        long x$5 = LogTestUtils$.MODULE$.createLogConfig$default$5();
        long x$6 = LogTestUtils$.MODULE$.createLogConfig$default$6();
        long x$7 = LogTestUtils$.MODULE$.createLogConfig$default$7();
        String x$8 = LogTestUtils$.MODULE$.createLogConfig$default$8();
        int x$9 = LogTestUtils$.MODULE$.createLogConfig$default$9();
        int x$10 = LogTestUtils$.MODULE$.createLogConfig$default$10();
        int x$11 = LogTestUtils$.MODULE$.createLogConfig$default$11();
        long x$12 = LogTestUtils$.MODULE$.createLogConfig$default$12();
        boolean x$13 = LogTestUtils$.MODULE$.createLogConfig$default$13();
        boolean x$14 = LogTestUtils$.MODULE$.createLogConfig$default$14();
        boolean x$15 = LogTestUtils$.MODULE$.createLogConfig$default$15();
        LogConfig newConfig = LogTestUtils$.MODULE$.createLogConfig(x$2, x$1, x$3, x$4, x$5, x$6, x$7, x$8, x$9, x$10, x$11, x$12, x$13, x$14, x$15);
        this.log().updateConfig(newConfig);
        Assertions.assertEquals((Object)newConfig, (Object)this.log().config());
    }

    @Test
    public void testLogDirRenameToNewDir() {
        SimpleRecord record = new SimpleRecord(this.mockTime().milliseconds(), "a".getBytes());
        this.appendRecords((Iterable<SimpleRecord>)new .colon.colon((Object)record, (List)Nil$.MODULE$), this.appendRecords$default$2(), this.appendRecords$default$3());
        this.log().roll(this.log().roll$default$1());
        Assertions.assertEquals((int)2, (int)this.log().segments().numberOfSegments());
        File newLogDir = TestUtils$.MODULE$.randomPartitionLogDir(this.tmpDir());
        Assertions.assertTrue((boolean)this.log().renameDir(newLogDir.getName()));
        Assertions.assertFalse((boolean)this.logDir().exists());
        Assertions.assertTrue((boolean)newLogDir.exists());
        Assertions.assertEquals((Object)newLogDir, (Object)this.log().dir());
        Assertions.assertEquals((Object)newLogDir.getParent(), (Object)this.log().parentDir());
        Assertions.assertEquals((Object)newLogDir.getParent(), (Object)this.log().dir().getParent());
        this.log().segments().values().forEach(segment -> Assertions.assertEquals((Object)newLogDir.getPath(), (Object)segment.log().file().getParentFile().getPath()));
        Assertions.assertEquals((int)2, (int)this.log().segments().numberOfSegments());
    }

    @Test
    public void testLogDirRenameToExistingDir() {
        Assertions.assertFalse((boolean)this.log().renameDir(this.log().dir().getName()));
    }

    @Test
    public void testLogFlush() {
        Assertions.assertEquals((long)0L, (long)this.log().recoveryPoint());
        Assertions.assertEquals((long)this.mockTime().milliseconds(), (long)this.log().lastFlushTime());
        SimpleRecord record = new SimpleRecord(this.mockTime().milliseconds(), "a".getBytes());
        this.appendRecords((Iterable<SimpleRecord>)new .colon.colon((Object)record, (List)Nil$.MODULE$), this.appendRecords$default$2(), this.appendRecords$default$3());
        this.mockTime().sleep(1L);
        LogSegment newSegment = this.log().roll(this.log().roll$default$1());
        this.log().flush(newSegment.baseOffset());
        this.log().markFlushed(newSegment.baseOffset());
        Assertions.assertEquals((long)1L, (long)this.log().recoveryPoint());
        Assertions.assertEquals((long)this.mockTime().milliseconds(), (long)this.log().lastFlushTime());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testLogAppend() {
        void readRecords_includeAbortedTxns;
        LocalLog x$2 = this.readRecords$default$1();
        long x$3 = this.readRecords$default$2();
        boolean x$4 = this.readRecords$default$4();
        boolean x$6 = this.readRecords$default$6();
        FetchDataInfo fetchDataInfoBeforeAppend = x$2.read(x$3, LocalLogTest.$anonfun$testLogAppend$1(), x$4, this.readRecords$default$5(), x$6);
        Assertions.assertTrue((boolean)((IterableLike)CollectionConverters$.MODULE$.iterableAsScalaIterableConverter(fetchDataInfoBeforeAppend.records.records()).asScala()).isEmpty());
        this.mockTime().sleep(1L);
        .colon.colon keyValues = new .colon.colon((Object)new KeyValue(this, "abc", "ABC"), (List)new .colon.colon((Object)new KeyValue(this, "de", "DE"), (List)Nil$.MODULE$));
        this.appendRecords(this.kvsToRecords((Iterable<KeyValue>)keyValues), this.appendRecords$default$2(), this.appendRecords$default$3());
        Assertions.assertEquals((long)2L, (long)this.log().logEndOffset());
        Assertions.assertEquals((long)0L, (long)this.log().recoveryPoint());
        boolean bl = this.readRecords$default$6();
        boolean readRecords_minOneMessage = this.readRecords$default$4();
        FetchDataInfo fetchDataInfo = this.readRecords$default$1().read(this.readRecords$default$2(), this.readRecords$default$3(), readRecords_minOneMessage, this.readRecords$default$5(), (boolean)readRecords_includeAbortedTxns);
        Assertions.assertEquals((long)2L, (long)((TraversableOnce)CollectionConverters$.MODULE$.iterableAsScalaIterableConverter(fetchDataInfo.records.records()).asScala()).size());
        Assertions.assertEquals((Object)keyValues, this.recordsToKvs((Iterable<Record>)((Iterable)CollectionConverters$.MODULE$.iterableAsScalaIterableConverter(fetchDataInfo.records.records()).asScala())));
    }

    @Test
    public void testLogCloseSuccess() {
        .colon.colon keyValues = new .colon.colon((Object)new KeyValue(this, "abc", "ABC"), (List)new .colon.colon((Object)new KeyValue(this, "de", "DE"), (List)Nil$.MODULE$));
        this.appendRecords(this.kvsToRecords((Iterable<KeyValue>)keyValues), this.appendRecords$default$2(), this.appendRecords$default$3());
        this.log().close();
        Assertions.assertThrows(ClosedChannelException.class, () -> LocalLogTest.$anonfun$testLogCloseSuccess$1(this, (Seq)keyValues));
    }

    @Test
    public void testLogCloseIdempotent() {
        this.log().close();
        this.log().close();
    }

    @Test
    public void testLogCloseFailureWhenInMemoryBufferClosed() {
        .colon.colon keyValues = new .colon.colon((Object)new KeyValue(this, "abc", "ABC"), (List)new .colon.colon((Object)new KeyValue(this, "de", "DE"), (List)Nil$.MODULE$));
        this.appendRecords(this.kvsToRecords((Iterable<KeyValue>)keyValues), this.appendRecords$default$2(), this.appendRecords$default$3());
        this.log().closeHandlers();
        Assertions.assertThrows(KafkaStorageException.class, () -> this.log().close());
    }

    @Test
    public void testLogCloseHandlers() {
        .colon.colon keyValues = new .colon.colon((Object)new KeyValue(this, "abc", "ABC"), (List)new .colon.colon((Object)new KeyValue(this, "de", "DE"), (List)Nil$.MODULE$));
        this.appendRecords(this.kvsToRecords((Iterable<KeyValue>)keyValues), this.appendRecords$default$2(), this.appendRecords$default$3());
        this.log().closeHandlers();
        Assertions.assertThrows(ClosedChannelException.class, () -> LocalLogTest.$anonfun$testLogCloseHandlers$1(this, (Seq)keyValues));
    }

    @Test
    public void testLogCloseHandlersIdempotent() {
        this.log().closeHandlers();
        this.log().closeHandlers();
    }

    private void testRemoveAndDeleteSegments(boolean asyncDelete) {
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), 8).foreach((Function1 & Serializable & scala.Serializable)offset -> LocalLogTest.$anonfun$testRemoveAndDeleteSegments$1(this, BoxesRunTime.unboxToInt((Object)offset)));
        Assertions.assertEquals((long)10L, (long)this.log().segments().numberOfSegments());
        public class Kafka_log_LocalLogTest$TestDeletionReason$1
        implements SegmentDeletionReason {
            private Iterable<LogSegment> _deletedSegments;

            private Iterable<LogSegment> _deletedSegments() {
                return this._deletedSegments;
            }

            private void _deletedSegments_$eq(Iterable<LogSegment> x$1) {
                this._deletedSegments = x$1;
            }

            public void logReason(List<LogSegment> toDelete) {
                this._deletedSegments_$eq((Iterable<LogSegment>)((Iterable)Nil$.MODULE$.$plus$plus(toDelete, List$.MODULE$.canBuildFrom())));
            }

            public Iterable<LogSegment> deletedSegments() {
                return this._deletedSegments();
            }

            public Kafka_log_LocalLogTest$TestDeletionReason$1(LocalLogTest $outer) {
                this._deletedSegments = Nil$.MODULE$;
            }
        }
        Kafka_log_LocalLogTest$TestDeletionReason$1 reason = new Kafka_log_LocalLogTest$TestDeletionReason$1(null);
        Vector toDelete = ((TraversableOnce)CollectionConverters$.MODULE$.collectionAsScalaIterableConverter(this.log().segments().values()).asScala()).toVector();
        this.log().removeAndDeleteSegments((Iterable)toDelete, asyncDelete, (SegmentDeletionReason)reason);
        if (asyncDelete) {
            this.mockTime().sleep(this.log().config().fileDeleteDelayMs + 1L);
        }
        Assertions.assertTrue((boolean)this.log().segments().isEmpty());
        Assertions.assertEquals((Object)toDelete, reason.deletedSegments());
        toDelete.foreach((Function1 & Serializable & scala.Serializable)segment -> {
            LocalLogTest.$anonfun$testRemoveAndDeleteSegments$2(segment);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testRemoveAndDeleteSegmentsSync() {
        this.testRemoveAndDeleteSegments(false);
    }

    @Test
    public void testRemoveAndDeleteSegmentsAsync() {
        this.testRemoveAndDeleteSegments(true);
    }

    private void testDeleteSegmentFiles(boolean asyncDelete) {
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), 8).foreach((Function1 & Serializable & scala.Serializable)offset -> LocalLogTest.$anonfun$testDeleteSegmentFiles$1(this, BoxesRunTime.unboxToInt((Object)offset)));
        Assertions.assertEquals((long)10L, (long)this.log().segments().numberOfSegments());
        Vector toDelete = ((TraversableOnce)CollectionConverters$.MODULE$.collectionAsScalaIterableConverter(this.log().segments().values()).asScala()).toVector();
        LocalLog$.MODULE$.deleteSegmentFiles((scala.collection.immutable.Iterable)toDelete, asyncDelete, this.log().dir(), this.log().topicPartition(), this.log().config(), this.log().scheduler(), this.log().logDirFailureChannel(), "");
        if (asyncDelete) {
            toDelete.foreach((Function1 & Serializable & scala.Serializable)segment -> {
                LocalLogTest.$anonfun$testDeleteSegmentFiles$2(segment);
                return BoxedUnit.UNIT;
            });
            this.mockTime().sleep(this.log().config().fileDeleteDelayMs + 1L);
        }
        toDelete.foreach((Function1 & Serializable & scala.Serializable)segment -> {
            LocalLogTest.$anonfun$testDeleteSegmentFiles$3(segment);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testDeleteSegmentFilesSync() {
        this.testDeleteSegmentFiles(false);
    }

    @Test
    public void testDeleteSegmentFilesAsync() {
        this.testDeleteSegmentFiles(true);
    }

    @Test
    public void testCreateAndDeleteSegment() {
        SimpleRecord record = new SimpleRecord(this.mockTime().milliseconds(), "a".getBytes());
        this.appendRecords((Iterable<SimpleRecord>)new .colon.colon((Object)record, (List)Nil$.MODULE$), this.appendRecords$default$2(), this.appendRecords$default$3());
        long newOffset = this.log().segments().activeSegment().baseOffset() + 1L;
        LogSegment oldActiveSegment = this.log().segments().activeSegment();
        LogSegment newActiveSegment = this.log().createAndDeleteSegment(newOffset, this.log().segments().activeSegment(), true, (SegmentDeletionReason)new LogTruncation(this.log()));
        Assertions.assertEquals((int)1, (int)this.log().segments().numberOfSegments());
        Assertions.assertEquals((Object)newActiveSegment, (Object)this.log().segments().activeSegment());
        Assertions.assertNotEquals((Object)oldActiveSegment, (Object)this.log().segments().activeSegment());
        Assertions.assertTrue((boolean)oldActiveSegment.hasSuffix(LocalLog$.MODULE$.DeletedFileSuffix()));
        Assertions.assertEquals((long)newOffset, (long)this.log().segments().activeSegment().baseOffset());
        Assertions.assertEquals((long)0L, (long)this.log().recoveryPoint());
        Assertions.assertEquals((long)newOffset, (long)this.log().logEndOffset());
        LocalLog x$2 = this.readRecords$default$1();
        boolean x$4 = this.readRecords$default$4();
        boolean x$6 = this.readRecords$default$6();
        FetchDataInfo fetchDataInfo = x$2.read(newOffset, this.readRecords$default$3(), x$4, this.readRecords$default$5(), x$6);
        Assertions.assertTrue((boolean)((IterableLike)CollectionConverters$.MODULE$.iterableAsScalaIterableConverter(fetchDataInfo.records.records()).asScala()).isEmpty());
    }

    @Test
    public void testTruncateFullyAndStartAt() {
        SimpleRecord record = new SimpleRecord(this.mockTime().milliseconds(), "a".getBytes());
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), 7).foreach((Function1 & Serializable & scala.Serializable)offset -> LocalLogTest.$anonfun$testTruncateFullyAndStartAt$1(this, record, BoxesRunTime.unboxToInt((Object)offset)));
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(8), 12).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)offset -> {
            SimpleRecord record = new SimpleRecord(this.mockTime().milliseconds(), "a".getBytes());
            .colon.colon x$4 = new .colon.colon((Object)record, (List)Nil$.MODULE$);
            long x$5 = offset;
            LocalLog x$6 = this.appendRecords$default$2();
            this.appendRecords((Iterable<SimpleRecord>)x$4, x$6, x$5);
        });
        Assertions.assertEquals((int)5, (int)this.log().segments().numberOfSegments());
        Assertions.assertNotEquals((long)10L, (long)this.log().segments().activeSegment().baseOffset());
        Vector expected = ((TraversableOnce)CollectionConverters$.MODULE$.collectionAsScalaIterableConverter(this.log().segments().values()).asScala()).toVector();
        Iterable deleted = this.log().truncateFullyAndStartAt(10L);
        Assertions.assertEquals((Object)expected, (Object)deleted);
        Assertions.assertEquals((int)1, (int)this.log().segments().numberOfSegments());
        Assertions.assertEquals((long)10L, (long)this.log().segments().activeSegment().baseOffset());
        Assertions.assertEquals((long)0L, (long)this.log().recoveryPoint());
        Assertions.assertEquals((long)10L, (long)this.log().logEndOffset());
        long x$7 = 10L;
        LocalLog x$8 = this.readRecords$default$1();
        boolean x$10 = this.readRecords$default$4();
        boolean x$12 = this.readRecords$default$6();
        FetchDataInfo fetchDataInfo = x$8.read(x$7, this.readRecords$default$3(), x$10, this.readRecords$default$5(), x$12);
        Assertions.assertTrue((boolean)((IterableLike)CollectionConverters$.MODULE$.iterableAsScalaIterableConverter(fetchDataInfo.records.records()).asScala()).isEmpty());
    }

    @Test
    public void testWhenFetchOffsetHigherThanMaxOffset() {
        SimpleRecord record = new SimpleRecord(this.mockTime().milliseconds(), "a".getBytes());
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), 4).foreach((Function1 & Serializable & scala.Serializable)offset -> LocalLogTest.$anonfun$testWhenFetchOffsetHigherThanMaxOffset$1(this, record, BoxesRunTime.unboxToInt((Object)offset)));
        Assertions.assertEquals((int)3, (int)this.log().segments().numberOfSegments());
        long x$4 = 3L;
        LocalLog x$6 = this.readRecords$default$1();
        boolean x$8 = this.readRecords$default$4();
        boolean x$9 = this.readRecords$default$6();
        FetchDataInfo fetchDataInfo = x$6.read(x$4, this.readRecords$default$3(), x$8, LocalLogTest.$anonfun$testWhenFetchOffsetHigherThanMaxOffset$2(), x$9);
        Assertions.assertEquals((int)1, (int)((TraversableOnce)CollectionConverters$.MODULE$.iterableAsScalaIterableConverter(fetchDataInfo.records.records()).asScala()).size());
        Assertions.assertEquals((Object)new LogOffsetMetadata(3L, 2L, 69), (Object)fetchDataInfo.fetchOffsetMetadata);
        long x$10 = 4L;
        LocalLog x$12 = this.readRecords$default$1();
        boolean x$14 = this.readRecords$default$4();
        boolean x$15 = this.readRecords$default$6();
        fetchDataInfo = x$12.read(x$10, this.readRecords$default$3(), x$14, LocalLogTest.$anonfun$testWhenFetchOffsetHigherThanMaxOffset$4(), x$15);
        Assertions.assertTrue((boolean)((IterableLike)CollectionConverters$.MODULE$.iterableAsScalaIterableConverter(fetchDataInfo.records.records()).asScala()).isEmpty());
        Assertions.assertEquals((Object)new LogOffsetMetadata(4L, 4L, 0), (Object)fetchDataInfo.fetchOffsetMetadata);
        long x$16 = 5L;
        LocalLog x$18 = this.readRecords$default$1();
        boolean x$20 = this.readRecords$default$4();
        boolean x$21 = this.readRecords$default$6();
        fetchDataInfo = x$18.read(x$16, this.readRecords$default$3(), x$20, LocalLogTest.$anonfun$testWhenFetchOffsetHigherThanMaxOffset$6(), x$21);
        Assertions.assertTrue((boolean)((IterableLike)CollectionConverters$.MODULE$.iterableAsScalaIterableConverter(fetchDataInfo.records.records()).asScala()).isEmpty());
        Assertions.assertEquals((Object)new LogOffsetMetadata(5L, 4L, 69), (Object)fetchDataInfo.fetchOffsetMetadata);
        long x$22 = 3L;
        LocalLog x$24 = this.readRecords$default$1();
        boolean x$26 = this.readRecords$default$4();
        boolean x$27 = this.readRecords$default$6();
        fetchDataInfo = x$24.read(x$22, this.readRecords$default$3(), x$26, LocalLogTest.$anonfun$testWhenFetchOffsetHigherThanMaxOffset$8(), x$27);
        Assertions.assertTrue((boolean)((IterableLike)CollectionConverters$.MODULE$.iterableAsScalaIterableConverter(fetchDataInfo.records.records()).asScala()).isEmpty());
        Assertions.assertEquals((Object)new LogOffsetMetadata(3L, 2L, 69), (Object)fetchDataInfo.fetchOffsetMetadata);
        long x$28 = 3L;
        LocalLog x$30 = this.readRecords$default$1();
        boolean x$32 = this.readRecords$default$4();
        boolean x$33 = this.readRecords$default$6();
        fetchDataInfo = x$30.read(x$28, this.readRecords$default$3(), x$32, LocalLogTest.$anonfun$testWhenFetchOffsetHigherThanMaxOffset$10(), x$33);
        Assertions.assertTrue((boolean)((IterableLike)CollectionConverters$.MODULE$.iterableAsScalaIterableConverter(fetchDataInfo.records.records()).asScala()).isEmpty());
        Assertions.assertEquals((Object)new LogOffsetMetadata(3L, 2L, 69), (Object)fetchDataInfo.fetchOffsetMetadata);
    }

    @Test
    public void testTruncateTo() {
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), 11).foreach((Function1 & Serializable & scala.Serializable)offset -> LocalLogTest.$anonfun$testTruncateTo$1(this, BoxesRunTime.unboxToInt((Object)offset)));
        Assertions.assertEquals((int)5, (int)this.log().segments().numberOfSegments());
        Assertions.assertEquals((long)12L, (long)this.log().logEndOffset());
        Vector expected = ((TraversableOnce)CollectionConverters$.MODULE$.collectionAsScalaIterableConverter(this.log().segments().values(9L, this.log().logEndOffset() + 1L)).asScala()).toVector();
        Iterable deleted = this.log().truncateTo(7L);
        Assertions.assertEquals((Object)expected, (Object)deleted.toVector());
        Assertions.assertEquals((int)3, (int)this.log().segments().numberOfSegments());
        Assertions.assertEquals((long)6L, (long)this.log().segments().activeSegment().baseOffset());
        Assertions.assertEquals((long)0L, (long)this.log().recoveryPoint());
        Assertions.assertEquals((long)7L, (long)this.log().logEndOffset());
        long x$4 = 6L;
        LocalLog x$5 = this.readRecords$default$1();
        boolean x$7 = this.readRecords$default$4();
        boolean x$9 = this.readRecords$default$6();
        FetchDataInfo fetchDataInfo = x$5.read(x$4, this.readRecords$default$3(), x$7, this.readRecords$default$5(), x$9);
        Assertions.assertEquals((int)1, (int)((TraversableOnce)CollectionConverters$.MODULE$.iterableAsScalaIterableConverter(fetchDataInfo.records.records()).asScala()).size());
        Assertions.assertEquals((Object)new .colon.colon((Object)new KeyValue(this, "", "a"), (List)Nil$.MODULE$), this.recordsToKvs((Iterable<Record>)((Iterable)CollectionConverters$.MODULE$.iterableAsScalaIterableConverter(fetchDataInfo.records.records()).asScala())));
        SimpleRecord record = new SimpleRecord(this.mockTime().milliseconds(), "a".getBytes());
        .colon.colon x$10 = new .colon.colon((Object)record, (List)Nil$.MODULE$);
        long x$11 = 7L;
        LocalLog x$12 = this.appendRecords$default$2();
        this.appendRecords((Iterable<SimpleRecord>)x$10, x$12, x$11);
        Assertions.assertEquals((long)8L, (long)this.log().logEndOffset());
    }

    @Test
    public void testNonActiveSegmentsFrom() {
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 5).foreach((Function1 & Serializable & scala.Serializable)i -> LocalLogTest.$anonfun$testNonActiveSegmentsFrom$1(this, BoxesRunTime.unboxToInt((Object)i)));
        Assertions.assertEquals((long)5L, (long)this.log().segments().activeSegment().baseOffset());
        Assertions.assertEquals((Object)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 5), (Object)this.nonActiveBaseOffsetsFrom$1(0L));
        Assertions.assertEquals((Object)Nil$.MODULE$, (Object)this.nonActiveBaseOffsetsFrom$1(5L));
        Assertions.assertEquals((Object)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(2), 5), (Object)this.nonActiveBaseOffsetsFrom$1(2L));
        Assertions.assertEquals((Object)Nil$.MODULE$, (Object)this.nonActiveBaseOffsetsFrom$1(6L));
    }

    private String topicPartitionName(String topic, String partition) {
        return new StringBuilder(1).append(topic).append("-").append(partition).toString();
    }

    @Test
    public void testParseTopicPartitionName() {
        String topic = "test_topic";
        String partition = "143";
        File dir = new File(this.logDir(), this.topicPartitionName(topic, partition));
        TopicPartition topicPartition = LocalLog$.MODULE$.parseTopicPartitionName(dir);
        Assertions.assertEquals((Object)topic, (Object)topicPartition.topic());
        Assertions.assertEquals((int)new StringOps(Predef$.MODULE$.augmentString(partition)).toInt(), (int)topicPartition.partition());
    }

    @Test
    public void testParseTopicPartitionNameWithPeriodForDeletedTopic() {
        String topic = "foo.bar-testtopic";
        String partition = "42";
        File dir = new File(this.logDir(), LocalLog$.MODULE$.logDeleteDirName(new TopicPartition(topic, new StringOps(Predef$.MODULE$.augmentString(partition)).toInt())));
        TopicPartition topicPartition = LocalLog$.MODULE$.parseTopicPartitionName(dir);
        Assertions.assertEquals((Object)topic, (Object)topicPartition.topic(), (String)"Unexpected topic name parsed");
        Assertions.assertEquals((int)new StringOps(Predef$.MODULE$.augmentString(partition)).toInt(), (int)topicPartition.partition(), (String)"Unexpected partition number parsed");
    }

    @Test
    public void testParseTopicPartitionNameForEmptyName() {
        File dir = new File("");
        Assertions.assertThrows(KafkaException.class, () -> LocalLog$.MODULE$.parseTopicPartitionName(dir), () -> new StringBuilder(48).append("KafkaException should have been thrown for dir: ").append(dir.getCanonicalPath()).toString());
    }

    @Test
    public void testParseTopicPartitionNameForNull() {
        Assertions.assertThrows(KafkaException.class, () -> LocalLogTest.$anonfun$testParseTopicPartitionNameForNull$1(null), () -> LocalLogTest.$anonfun$testParseTopicPartitionNameForNull$2(null));
    }

    @Test
    public void testParseTopicPartitionNameForMissingSeparator() {
        String topic = "test_topic";
        String partition = "1999";
        File dir = new File(this.logDir(), new StringBuilder(0).append(topic).append(partition).toString());
        Assertions.assertThrows(KafkaException.class, () -> LocalLog$.MODULE$.parseTopicPartitionName(dir), () -> new StringBuilder(48).append("KafkaException should have been thrown for dir: ").append(dir.getCanonicalPath()).toString());
        File deleteMarkerDir = new File(this.logDir(), new StringBuilder(1).append(topic).append(partition).append(".").append(LocalLog$.MODULE$.DeleteDirSuffix()).toString());
        Assertions.assertThrows(KafkaException.class, () -> LocalLog$.MODULE$.parseTopicPartitionName(deleteMarkerDir), () -> new StringBuilder(48).append("KafkaException should have been thrown for dir: ").append(deleteMarkerDir.getCanonicalPath()).toString());
    }

    @Test
    public void testParseTopicPartitionNameForMissingTopic() {
        String topic = "";
        String partition = "1999";
        File dir = new File(this.logDir(), this.topicPartitionName(topic, partition));
        Assertions.assertThrows(KafkaException.class, () -> LocalLog$.MODULE$.parseTopicPartitionName(dir), () -> new StringBuilder(48).append("KafkaException should have been thrown for dir: ").append(dir.getCanonicalPath()).toString());
        File deleteMarkerDir = new File(this.logDir(), LocalLog$.MODULE$.logDeleteDirName(new TopicPartition(topic, new StringOps(Predef$.MODULE$.augmentString(partition)).toInt())));
        Assertions.assertThrows(KafkaException.class, () -> LocalLog$.MODULE$.parseTopicPartitionName(deleteMarkerDir), () -> new StringBuilder(48).append("KafkaException should have been thrown for dir: ").append(deleteMarkerDir.getCanonicalPath()).toString());
    }

    @Test
    public void testParseTopicPartitionNameForMissingPartition() {
        String topic = "test_topic";
        String partition = "";
        File dir = new File(new StringBuilder(0).append(this.logDir().getPath()).append(this.topicPartitionName(topic, partition)).toString());
        Assertions.assertThrows(KafkaException.class, () -> LocalLog$.MODULE$.parseTopicPartitionName(dir), () -> new StringBuilder(48).append("KafkaException should have been thrown for dir: ").append(dir.getCanonicalPath()).toString());
        File deleteMarkerDir = new File(this.logDir(), new StringBuilder(1).append(this.topicPartitionName(topic, partition)).append(".").append(LocalLog$.MODULE$.DeleteDirSuffix()).toString());
        Assertions.assertThrows(KafkaException.class, () -> LocalLog$.MODULE$.parseTopicPartitionName(deleteMarkerDir), () -> new StringBuilder(48).append("KafkaException should have been thrown for dir: ").append(deleteMarkerDir.getCanonicalPath()).toString());
    }

    @Test
    public void testParseTopicPartitionNameForInvalidPartition() {
        String topic = "test_topic";
        String partition = "1999a";
        File dir = new File(this.logDir(), this.topicPartitionName(topic, partition));
        Assertions.assertThrows(KafkaException.class, () -> LocalLog$.MODULE$.parseTopicPartitionName(dir), () -> new StringBuilder(48).append("KafkaException should have been thrown for dir: ").append(dir.getCanonicalPath()).toString());
        File deleteMarkerDir = new File(this.logDir(), new StringBuilder(1).append(topic).append(partition).append(".").append(LocalLog$.MODULE$.DeleteDirSuffix()).toString());
        Assertions.assertThrows(KafkaException.class, () -> LocalLog$.MODULE$.parseTopicPartitionName(deleteMarkerDir), () -> new StringBuilder(48).append("KafkaException should have been thrown for dir: ").append(deleteMarkerDir.getCanonicalPath()).toString());
    }

    @Test
    public void testParseTopicPartitionNameForExistingInvalidDir() {
        File dir1 = new File(new StringBuilder(14).append(this.logDir().getPath()).append("/non_kafka_dir").toString());
        Assertions.assertThrows(KafkaException.class, () -> LocalLog$.MODULE$.parseTopicPartitionName(dir1), () -> new StringBuilder(48).append("KafkaException should have been thrown for dir: ").append(dir1.getCanonicalPath()).toString());
        File dir2 = new File(new StringBuilder(21).append(this.logDir().getPath()).append("/non_kafka_dir-delete").toString());
        Assertions.assertThrows(KafkaException.class, () -> LocalLog$.MODULE$.parseTopicPartitionName(dir2), () -> new StringBuilder(48).append("KafkaException should have been thrown for dir: ").append(dir2.getCanonicalPath()).toString());
    }

    @Test
    public void testLogDeleteDirName() {
        String name1 = LocalLog$.MODULE$.logDeleteDirName(new TopicPartition("foo", 3));
        Assertions.assertTrue((name1.length() <= 255 ? 1 : 0) != 0);
        Assertions.assertTrue((boolean)Pattern.compile("foo-3\\.[0-9a-z]{32}-delete").matcher(name1).matches());
        Assertions.assertTrue((boolean)LocalLog$.MODULE$.DeleteDirPattern().matcher(name1).matches());
        Assertions.assertFalse((boolean)LocalLog$.MODULE$.FutureDirPattern().matcher(name1).matches());
        String name2 = LocalLog$.MODULE$.logDeleteDirName(new TopicPartition(new StringBuilder(1).append("n").append(String.join((CharSequence)"", Collections.nCopies(248, "o"))).toString(), 5));
        Assertions.assertEquals((int)255, (int)name2.length());
        Assertions.assertTrue((boolean)Pattern.compile("n[o]{212}-5\\.[0-9a-z]{32}-delete").matcher(name2).matches());
        Assertions.assertTrue((boolean)LocalLog$.MODULE$.DeleteDirPattern().matcher(name2).matches());
        Assertions.assertFalse((boolean)LocalLog$.MODULE$.FutureDirPattern().matcher(name2).matches());
    }

    @Test
    public void testOffsetFromFile() {
        long offset = 23423423L;
        File logFile = LogFileUtils.logFile((File)this.tmpDir(), (long)offset);
        Assertions.assertEquals((long)offset, (Long)LogFileUtils.offsetFromFile((File)logFile));
        File offsetIndexFile = LogFileUtils.offsetIndexFile((File)this.tmpDir(), (long)offset);
        Assertions.assertEquals((long)offset, (Long)LogFileUtils.offsetFromFile((File)offsetIndexFile));
        File timeIndexFile = LogFileUtils.timeIndexFile((File)this.tmpDir(), (long)offset);
        Assertions.assertEquals((long)offset, (Long)LogFileUtils.offsetFromFile((File)timeIndexFile));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testRollSegmentThatAlreadyExists() {
        void readRecords_includeAbortedTxns;
        Assertions.assertEquals((int)1, (int)this.log().segments().numberOfSegments(), (String)"Log begins with a single empty segment.");
        this.log().roll((Option)new Some((Object)BoxesRunTime.boxToLong((long)0L)));
        Assertions.assertEquals((int)1, (int)this.log().segments().numberOfSegments(), (String)"Expect 1 segment after roll() empty segment with base offset.");
        .colon.colon keyValues1 = new .colon.colon((Object)new KeyValue(this, "k1", "v1"), (List)Nil$.MODULE$);
        this.appendRecords(this.kvsToRecords((Iterable<KeyValue>)keyValues1), this.appendRecords$default$2(), this.appendRecords$default$3());
        Assertions.assertEquals((long)0L, (long)this.log().segments().activeSegment().baseOffset());
        .colon.colon keyValues2 = new .colon.colon((Object)new KeyValue(this, "k2", "v2"), (List)Nil$.MODULE$);
        Iterable x$1 = (Iterable)keyValues2.map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.toRecord((Function0<Object>)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> this.mockTime().milliseconds() + 10L), List$.MODULE$.canBuildFrom());
        long x$22 = 1L;
        LocalLog x$3 = this.appendRecords$default$2();
        this.appendRecords((Iterable<SimpleRecord>)x$1, x$3, x$22);
        Assertions.assertEquals((long)2L, (long)this.log().logEndOffset(), (String)"Expect two records in the log");
        boolean bl = this.readRecords$default$6();
        boolean readRecords_minOneMessage = this.readRecords$default$4();
        FetchDataInfo readResult = this.readRecords$default$1().read(this.readRecords$default$2(), this.readRecords$default$3(), readRecords_minOneMessage, this.readRecords$default$5(), (boolean)readRecords_includeAbortedTxns);
        Assertions.assertEquals((long)2L, (long)((TraversableOnce)CollectionConverters$.MODULE$.iterableAsScalaIterableConverter(readResult.records.records()).asScala()).size());
        Assertions.assertEquals((Object)keyValues1.$plus$plus((GenTraversableOnce)keyValues2, List$.MODULE$.canBuildFrom()), this.recordsToKvs((Iterable<Record>)((Iterable)CollectionConverters$.MODULE$.iterableAsScalaIterableConverter(readResult.records.records()).asScala())));
        this.log().roll(this.log().roll$default$1());
        Assertions.assertEquals((long)2L, (long)this.log().segments().activeSegment().baseOffset(), (String)"Expect base offset of active segment to be LEO");
        Assertions.assertEquals((int)2, (int)this.log().segments().numberOfSegments(), (String)"Expect two segments.");
        Assertions.assertEquals((long)2L, (long)this.log().logEndOffset());
    }

    @Test
    public void testNewSegmentsAfterRoll() {
        Assertions.assertEquals((int)1, (int)this.log().segments().numberOfSegments(), (String)"Log begins with a single empty segment.");
        LogSegment newSegment = this.log().roll(this.log().roll$default$1());
        Assertions.assertEquals((long)0L, (long)newSegment.baseOffset());
        Assertions.assertEquals((int)1, (int)this.log().segments().numberOfSegments());
        Assertions.assertEquals((long)0L, (long)this.log().logEndOffset());
        KeyValue qual$1 = new KeyValue(this, "k1", "v1");
        JFunction0.mcJ.sp & Serializable & scala.Serializable x$1 = (JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> qual$1.toRecord$default$1();
        this.appendRecords((Iterable<SimpleRecord>)new .colon.colon((Object)qual$1.toRecord((Function0<Object>)x$1), (List)Nil$.MODULE$), this.appendRecords$default$2(), this.appendRecords$default$3());
        LogSegment newSegment2 = this.log().roll(this.log().roll$default$1());
        Assertions.assertEquals((long)1L, (long)newSegment2.baseOffset());
        Assertions.assertEquals((int)2, (int)this.log().segments().numberOfSegments());
        Assertions.assertEquals((long)1L, (long)this.log().logEndOffset());
        KeyValue qual$2 = new KeyValue(this, "k2", "v2");
        JFunction0.mcJ.sp & Serializable & scala.Serializable x$2 = (JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> qual$2.toRecord$default$1();
        .colon.colon x$3 = new .colon.colon((Object)qual$2.toRecord((Function0<Object>)x$2), (List)Nil$.MODULE$);
        long x$4 = 1L;
        LocalLog x$5 = this.appendRecords$default$2();
        this.appendRecords((Iterable<SimpleRecord>)x$3, x$5, x$4);
        LogSegment newSegment3 = this.log().roll((Option)new Some((Object)BoxesRunTime.boxToLong((long)1L)));
        Assertions.assertEquals((long)2L, (long)newSegment3.baseOffset());
        Assertions.assertEquals((int)3, (int)this.log().segments().numberOfSegments());
        Assertions.assertEquals((long)2L, (long)this.log().logEndOffset());
    }

    @Test
    public void testRollSegmentErrorWhenNextOffsetIsIllegal() {
        Assertions.assertEquals((int)1, (int)this.log().segments().numberOfSegments(), (String)"Log begins with a single empty segment.");
        .colon.colon keyValues = new .colon.colon((Object)new KeyValue(this, "k1", "v1"), (List)new .colon.colon((Object)new KeyValue(this, "k2", "v2"), (List)new .colon.colon((Object)new KeyValue(this, "k3", "v3"), (List)Nil$.MODULE$)));
        this.appendRecords(this.kvsToRecords((Iterable<KeyValue>)keyValues), this.appendRecords$default$2(), this.appendRecords$default$3());
        Assertions.assertEquals((long)0L, (long)this.log().segments().activeSegment().baseOffset());
        Assertions.assertEquals((long)3L, (long)this.log().logEndOffset(), (String)"Expect two records in the log");
        this.log().roll(this.log().roll$default$1());
        Assertions.assertEquals((long)3L, (long)this.log().segments().activeSegment().baseOffset());
        this.log().updateLogEndOffset(1L);
        Assertions.assertThrows(KafkaException.class, () -> this.log().roll(this.log().roll$default$1()));
    }

    @Test
    public void testFlushingNonExistentDir() {
        LocalLog spyLog = (LocalLog)Mockito.spy((Object)this.log());
        SimpleRecord record = new SimpleRecord(this.mockTime().milliseconds(), "a".getBytes());
        this.appendRecords((Iterable<SimpleRecord>)new .colon.colon((Object)record, (List)Nil$.MODULE$), this.appendRecords$default$2(), this.appendRecords$default$3());
        this.mockTime().sleep(1L);
        LogSegment newSegment = this.log().roll(this.log().roll$default$1());
        ((LocalLog)Mockito.doReturn((Object)new File("__NON_EXISTENT__"), (Object[])ScalaRunTime$.MODULE$.toObjectArray(Nil$.MODULE$.toArray(ClassTag$.MODULE$.Any()))).when((Object)spyLog)).dir();
        Assertions.assertDoesNotThrow(() -> spyLog.flush(newSegment.baseOffset()));
    }

    private LocalLog createLocalLogWithActiveSegment(File dir, LogConfig config, LogSegments segments, long recoveryPoint, LogOffsetMetadata nextOffsetMetadata, Scheduler scheduler, Time time, TopicPartition topicPartition, LogDirFailureChannel logDirFailureChannel) {
        segments.add(LogSegment.open((File)dir, (long)0L, (LogConfig)config, (Time)time, (int)config.initFileSize(), (boolean)config.preallocate));
        return new LocalLog(dir, config, segments, recoveryPoint, nextOffsetMetadata, scheduler, time, topicPartition, logDirFailureChannel);
    }

    private File createLocalLogWithActiveSegment$default$1() {
        return this.logDir();
    }

    private LogSegments createLocalLogWithActiveSegment$default$3() {
        return new LogSegments(this.topicPartition());
    }

    private long createLocalLogWithActiveSegment$default$4() {
        return 0L;
    }

    private LogOffsetMetadata createLocalLogWithActiveSegment$default$5() {
        return new LogOffsetMetadata(0L, 0L, 0);
    }

    private Scheduler createLocalLogWithActiveSegment$default$6() {
        return this.mockTime().scheduler;
    }

    private Time createLocalLogWithActiveSegment$default$7() {
        return this.mockTime();
    }

    private TopicPartition createLocalLogWithActiveSegment$default$8() {
        return this.topicPartition();
    }

    private LogDirFailureChannel createLocalLogWithActiveSegment$default$9() {
        return this.logDirFailureChannel();
    }

    private final void KeyValue$lzycompute$1() {
        synchronized (this) {
            if (this.KeyValue$module == null) {
                this.KeyValue$module = new LocalLogTest$KeyValue$(this);
            }
            return;
        }
    }

    public static final /* synthetic */ int $anonfun$testLogAppend$1() {
        return 1;
    }

    public static final /* synthetic */ void $anonfun$testLogCloseSuccess$1(LocalLogTest $this, Seq keyValues$1) {
        Iterable<SimpleRecord> x$1 = $this.kvsToRecords((Iterable<KeyValue>)keyValues$1);
        long x$2 = 2L;
        LocalLog x$3 = $this.appendRecords$default$2();
        $this.appendRecords(x$1, x$3, x$2);
    }

    public static final /* synthetic */ void $anonfun$testLogCloseHandlers$1(LocalLogTest $this, Seq keyValues$2) {
        Iterable<SimpleRecord> x$1 = $this.kvsToRecords((Iterable<KeyValue>)keyValues$2);
        long x$2 = 2L;
        LocalLog x$3 = $this.appendRecords$default$2();
        $this.appendRecords(x$1, x$3, x$2);
    }

    public static final /* synthetic */ LogSegment $anonfun$testRemoveAndDeleteSegments$1(LocalLogTest $this, int offset) {
        SimpleRecord record = new SimpleRecord($this.mockTime().milliseconds(), "a".getBytes());
        .colon.colon x$1 = new .colon.colon((Object)record, (List)Nil$.MODULE$);
        long x$2 = offset;
        LocalLog x$3 = $this.appendRecords$default$2();
        $this.appendRecords((Iterable<SimpleRecord>)x$1, x$3, x$2);
        return $this.log().roll($this.log().roll$default$1());
    }

    public static final /* synthetic */ void $anonfun$testRemoveAndDeleteSegments$2(LogSegment segment) {
        Assertions.assertTrue((boolean)segment.deleted());
    }

    public static final /* synthetic */ LogSegment $anonfun$testDeleteSegmentFiles$1(LocalLogTest $this, int offset) {
        SimpleRecord record = new SimpleRecord($this.mockTime().milliseconds(), "a".getBytes());
        .colon.colon x$1 = new .colon.colon((Object)record, (List)Nil$.MODULE$);
        long x$2 = offset;
        LocalLog x$3 = $this.appendRecords$default$2();
        $this.appendRecords((Iterable<SimpleRecord>)x$1, x$3, x$2);
        return $this.log().roll($this.log().roll$default$1());
    }

    public static final /* synthetic */ void $anonfun$testDeleteSegmentFiles$2(LogSegment segment) {
        Assertions.assertFalse((boolean)segment.deleted());
        Assertions.assertTrue((boolean)segment.hasSuffix(LocalLog$.MODULE$.DeletedFileSuffix()));
    }

    public static final /* synthetic */ void $anonfun$testDeleteSegmentFiles$3(LogSegment segment) {
        Assertions.assertTrue((boolean)segment.deleted());
    }

    public static final /* synthetic */ Object $anonfun$testTruncateFullyAndStartAt$1(LocalLogTest $this, SimpleRecord record$1, int offset) {
        .colon.colon x$1 = new .colon.colon((Object)record$1, (List)Nil$.MODULE$);
        long x$2 = offset;
        LocalLog x$3 = $this.appendRecords$default$2();
        $this.appendRecords((Iterable<SimpleRecord>)x$1, x$3, x$2);
        if (offset % 2 != 0) {
            return $this.log().roll($this.log().roll$default$1());
        }
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$testWhenFetchOffsetHigherThanMaxOffset$1(LocalLogTest $this, SimpleRecord record$2, int offset) {
        .colon.colon x$1 = new .colon.colon((Object)record$2, (List)Nil$.MODULE$);
        long x$2 = offset;
        LocalLog x$3 = $this.appendRecords$default$2();
        $this.appendRecords((Iterable<SimpleRecord>)x$1, x$3, x$2);
        if (offset % 2 != 0) {
            return $this.log().roll($this.log().roll$default$1());
        }
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ LogOffsetMetadata $anonfun$testWhenFetchOffsetHigherThanMaxOffset$2() {
        return new LogOffsetMetadata(4L, 4L, 0);
    }

    public static final /* synthetic */ LogOffsetMetadata $anonfun$testWhenFetchOffsetHigherThanMaxOffset$4() {
        return new LogOffsetMetadata(4L, 4L, 0);
    }

    public static final /* synthetic */ LogOffsetMetadata $anonfun$testWhenFetchOffsetHigherThanMaxOffset$6() {
        return new LogOffsetMetadata(4L, 4L, 0);
    }

    public static final /* synthetic */ LogOffsetMetadata $anonfun$testWhenFetchOffsetHigherThanMaxOffset$8() {
        return new LogOffsetMetadata(4L, -1L, -1);
    }

    public static final /* synthetic */ LogOffsetMetadata $anonfun$testWhenFetchOffsetHigherThanMaxOffset$10() {
        return new LogOffsetMetadata(4L, 0L, 40);
    }

    public static final /* synthetic */ Object $anonfun$testTruncateTo$1(LocalLogTest $this, int offset) {
        SimpleRecord record = new SimpleRecord($this.mockTime().milliseconds(), "a".getBytes());
        .colon.colon x$1 = new .colon.colon((Object)record, (List)Nil$.MODULE$);
        long x$2 = offset;
        LocalLog x$3 = $this.appendRecords$default$2();
        $this.appendRecords((Iterable<SimpleRecord>)x$1, x$3, x$2);
        if (offset % 3 == 2) {
            return $this.log().roll($this.log().roll$default$1());
        }
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ LogSegment $anonfun$testNonActiveSegmentsFrom$1(LocalLogTest $this, int i) {
        .colon.colon keyValues = new .colon.colon((Object)new KeyValue($this, Integer.toString(i), Integer.toString(i)), (List)Nil$.MODULE$);
        Iterable<SimpleRecord> x$1 = $this.kvsToRecords((Iterable<KeyValue>)keyValues);
        long x$2 = i;
        LocalLog x$3 = $this.appendRecords$default$2();
        $this.appendRecords(x$1, x$3, x$2);
        return $this.log().roll($this.log().roll$default$1());
    }

    private final Seq nonActiveBaseOffsetsFrom$1(long startOffset) {
        return ((TraversableOnce)((TraversableLike)CollectionConverters$.MODULE$.collectionAsScalaIterableConverter(this.log().segments().nonActiveLogSegmentsFrom(startOffset)).asScala()).map((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToLong((long)x$1.baseOffset()), Iterable$.MODULE$.canBuildFrom())).toSeq();
    }

    public static final /* synthetic */ void $anonfun$testParseTopicPartitionNameForNull$1(File dir$2) {
        LocalLog$.MODULE$.parseTopicPartitionName(dir$2);
    }

    public static final /* synthetic */ String $anonfun$testParseTopicPartitionNameForNull$2(File dir$2) {
        return new StringBuilder(48).append("KafkaException should have been thrown for dir: ").append(dir$2).toString();
    }

    public LocalLogTest() {
        LogConfig x$1 = LogTestUtils$.MODULE$.createLogConfig(LogTestUtils$.MODULE$.createLogConfig$default$1(), LogTestUtils$.MODULE$.createLogConfig$default$2(), LogTestUtils$.MODULE$.createLogConfig$default$3(), LogTestUtils$.MODULE$.createLogConfig$default$4(), LogTestUtils$.MODULE$.createLogConfig$default$5(), LogTestUtils$.MODULE$.createLogConfig$default$6(), LogTestUtils$.MODULE$.createLogConfig$default$7(), LogTestUtils$.MODULE$.createLogConfig$default$8(), LogTestUtils$.MODULE$.createLogConfig$default$9(), LogTestUtils$.MODULE$.createLogConfig$default$10(), LogTestUtils$.MODULE$.createLogConfig$default$11(), LogTestUtils$.MODULE$.createLogConfig$default$12(), LogTestUtils$.MODULE$.createLogConfig$default$13(), LogTestUtils$.MODULE$.createLogConfig$default$14(), LogTestUtils$.MODULE$.createLogConfig$default$15());
        File x$2 = this.createLocalLogWithActiveSegment$default$1();
        LogSegments x$3 = this.createLocalLogWithActiveSegment$default$3();
        long x$4 = this.createLocalLogWithActiveSegment$default$4();
        LogOffsetMetadata x$5 = this.createLocalLogWithActiveSegment$default$5();
        Scheduler x$6 = this.createLocalLogWithActiveSegment$default$6();
        Time x$7 = this.createLocalLogWithActiveSegment$default$7();
        TopicPartition x$8 = this.createLocalLogWithActiveSegment$default$8();
        LogDirFailureChannel x$9 = this.createLocalLogWithActiveSegment$default$9();
        this.log = this.createLocalLogWithActiveSegment(x$2, x$1, x$3, x$4, x$5, x$6, x$7, x$8, x$9);
    }

    public class KeyValue
    implements Product,
    scala.Serializable {
        private final String key;
        private final String value;
        public final /* synthetic */ LocalLogTest $outer;

        public String key() {
            return this.key;
        }

        public String value() {
            return this.value;
        }

        public SimpleRecord toRecord(Function0<Object> timestamp) {
            return new SimpleRecord(timestamp.apply$mcJ$sp(), this.key().getBytes(), this.value().getBytes());
        }

        public long toRecord$default$1() {
            return this.kafka$log$LocalLogTest$KeyValue$$$outer().mockTime().milliseconds();
        }

        public KeyValue copy(String key, String value) {
            return new KeyValue(this.kafka$log$LocalLogTest$KeyValue$$$outer(), key, value);
        }

        public String copy$default$1() {
            return this.key();
        }

        public String copy$default$2() {
            return this.value();
        }

        public String productPrefix() {
            return "KeyValue";
        }

        public int productArity() {
            return 2;
        }

        public Object productElement(int x$1) {
            switch (x$1) {
                case 0: {
                    return this.key();
                }
                case 1: {
                    return this.value();
                }
            }
            throw new IndexOutOfBoundsException(Integer.toString(x$1));
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof KeyValue;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean equals(Object x$1) {
            block3: {
                block2: {
                    if (this == x$1) break block2;
                    if (!(x$1 instanceof KeyValue && ((KeyValue)x$1).kafka$log$LocalLogTest$KeyValue$$$outer() == this.kafka$log$LocalLogTest$KeyValue$$$outer())) break block3;
                    KeyValue keyValue = (KeyValue)x$1;
                    String string = this.key();
                    String string2 = keyValue.key();
                    if (string != null ? !string.equals(string2) : string2 != null) break block3;
                    String string3 = this.value();
                    String string4 = keyValue.value();
                    if ((string3 != null ? !string3.equals(string4) : string4 != null) || !keyValue.canEqual(this)) break block3;
                }
                return true;
            }
            return false;
        }

        public /* synthetic */ LocalLogTest kafka$log$LocalLogTest$KeyValue$$$outer() {
            return this.$outer;
        }

        public KeyValue(LocalLogTest $outer, String key, String value) {
            this.key = key;
            this.value = value;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            Product.$init$((Product)this);
        }
    }
}

