/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import java.io.File;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Properties;
import java.util.stream.Stream;
import kafka.log.AbstractLogCleanerIntegrationTest;
import kafka.log.LogCleaner;
import kafka.log.UnifiedLog;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.checkpoints.OffsetCheckpointFile;
import kafka.server.checkpoints.OffsetCheckpointFile$;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.compress.Compression;
import org.apache.kafka.common.compress.NoCompression;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.SimpleRecord;
import org.apache.kafka.server.common.MetadataVersion;
import org.apache.kafka.server.util.MockTime;
import org.apache.kafka.storage.internals.log.CleanerConfig;
import org.apache.kafka.storage.internals.log.LogAppendInfo;
import org.apache.kafka.storage.internals.log.LogConfig;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.ArgumentsProvider;
import org.junit.jupiter.params.provider.ArgumentsSource;
import scala.Array$;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.GenIterable;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.NumericRange;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.WrappedArray;
import scala.jdk.CollectionConverters$;
import scala.math.Numeric;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.RichLong;
import scala.runtime.RichLong$;

@ScalaSignature(bytes="\u0006\u0001\t}b\u0001\u0002\u000e\u001c\u0001\u0001BQ!\n\u0001\u0005\u0002\u0019Bq\u0001\u000b\u0001C\u0002\u0013\u0005\u0011\u0006\u0003\u00048\u0001\u0001\u0006IA\u000b\u0005\bq\u0001\u0011\r\u0011\"\u0001:\u0011\u00191\u0005\u0001)A\u0005u!)q\t\u0001C\u0001\u0011\"9\u0011q\u000b\u0001\u0005\u0002\u0005e\u0003bBA1\u0001\u0011\u0005\u00111\r\u0005\b\u0003_\u0002A\u0011AA9\u0011\u001d\tY\b\u0001C\u0001\u0003{Bq!!\"\u0001\t\u0013\t9\tC\u0004\u00028\u0002!I!!/\t\u000f\u0005u\u0007\u0001\"\u0003\u0002`\"9\u0011q\u001f\u0001\u0005\n\u0005e\bbBA\u007f\u0001\u0011%\u0011q \u0005\n\u0005O\u0001\u0011\u0013!C\u0005\u0005S9Q!Z\u000e\t\u0002\u00194QAG\u000e\t\u0002\u001dDQ!\n\n\u0005\u0002-4A\u0001\u001c\n\u0001[\")Q\u0005\u0006C\u0001s\")A\u0010\u0006C!{\u001a1\u0011q\u0007\n\u0001\u0003sAa!J\f\u0005\u0002\u0005m\u0002B\u0002?\u0018\t\u0003\nyD\u0001\u0014M_\u001e\u001cE.Z1oKJ\u0004\u0016M]1nKR,'/\u001b>fI&sG/Z4sCRLwN\u001c+fgRT!\u0001H\u000f\u0002\u00071|wMC\u0001\u001f\u0003\u0015Y\u0017MZ6b\u0007\u0001\u0019\"\u0001A\u0011\u0011\u0005\t\u001aS\"A\u000e\n\u0005\u0011Z\"!I!cgR\u0014\u0018m\u0019;M_\u001e\u001cE.Z1oKJLe\u000e^3he\u0006$\u0018n\u001c8UKN$\u0018A\u0002\u001fj]&$h\bF\u0001(!\t\u0011\u0003!\u0001\u0003uS6,W#\u0001\u0016\u0011\u0005-*T\"\u0001\u0017\u000b\u00055r\u0013\u0001B;uS2T!a\f\u0019\u0002\rM,'O^3s\u0015\tq\u0012G\u0003\u00023g\u00051\u0011\r]1dQ\u0016T\u0011\u0001N\u0001\u0004_J<\u0017B\u0001\u001c-\u0005!iunY6US6,\u0017!\u0002;j[\u0016\u0004\u0013a\u0004;pa&\u001c\u0007+\u0019:uSRLwN\\:\u0016\u0003i\u00022a\u000f A\u001b\u0005a$\"A\u001f\u0002\u000bM\u001c\u0017\r\\1\n\u0005}b$!B!se\u0006L\bCA!E\u001b\u0005\u0011%BA\"1\u0003\u0019\u0019w.\\7p]&\u0011QI\u0011\u0002\u000f)>\u0004\u0018n\u0019)beRLG/[8o\u0003A!x\u000e]5d!\u0006\u0014H/\u001b;j_:\u001c\b%A\u0006dY\u0016\fg.\u001a:UKN$HCA%M!\tY$*\u0003\u0002Ly\t!QK\\5u\u0011\u0015ie\u00011\u0001O\u0003=\u0019w.\u001c9sKN\u001c\u0018n\u001c8UsB,\u0007CA(S\u001b\u0005\u0001&BA)C\u0003\u0019\u0011XmY8sI&\u00111\u000b\u0015\u0002\u0010\u0007>l\u0007O]3tg&|g\u000eV=qK\"\"a!V1c!\t1v,D\u0001X\u0015\tA\u0016,\u0001\u0005qe>4\u0018\u000eZ3s\u0015\tQ6,\u0001\u0004qCJ\fWn\u001d\u0006\u00039v\u000bqA[;qSR,'O\u0003\u0002_g\u0005)!.\u001e8ji&\u0011\u0001m\u0016\u0002\u0010\u0003J<W/\\3oiN\u001cv.\u001e:dK\u0006)a/\u00197vK\u000e\n1\r\u0005\u0002e)9\u0011!%E\u0001'\u0019><7\t\\3b]\u0016\u0014\b+\u0019:b[\u0016$XM]5{K\u0012Le\u000e^3he\u0006$\u0018n\u001c8UKN$\bC\u0001\u0012\u0013'\t\u0011\u0002\u000e\u0005\u0002<S&\u0011!\u000e\u0010\u0002\u0007\u0003:L(+\u001a4\u0015\u0003\u0019\u0014q\"\u00117m\u0007>l\u0007O]3tg&|gn]\n\u0004)94\bCA8u\u001b\u0005\u0001(BA9s\u0003\u0011a\u0017M\\4\u000b\u0003M\fAA[1wC&\u0011Q\u000f\u001d\u0002\u0007\u001f\nTWm\u0019;\u0011\u0005Y;\u0018B\u0001=X\u0005E\t%oZ;nK:$8\u000f\u0015:pm&$WM\u001d\u000b\u0002uB\u00111\u0010F\u0007\u0002%\u0005\u0001\u0002O]8wS\u0012,\u0017I]4v[\u0016tGo\u001d\u000b\u0004}\u0006\r\u0002gA@\u0002\u0012A1\u0011\u0011AA\u0005\u0003\u001bi!!a\u0001\u000b\t\u0005\u0015\u0011qA\u0001\u0007gR\u0014X-Y7\u000b\u00055\u0012\u0018\u0002BA\u0006\u0003\u0007\u0011aa\u0015;sK\u0006l\u0007\u0003BA\b\u0003#a\u0001\u0001B\u0006\u0002\u0014Y\t\t\u0011!A\u0003\u0002\u0005U!aA0%cE!\u0011qCA\u000f!\rY\u0014\u0011D\u0005\u0004\u00037a$a\u0002(pi\"Lgn\u001a\t\u0004-\u0006}\u0011bAA\u0011/\nI\u0011I]4v[\u0016tGo\u001d\u0005\b\u0003K1\u0002\u0019AA\u0014\u0003\u001d\u0019wN\u001c;fqR\u0004B!!\u000b\u000245\u0011\u00111\u0006\u0006\u0005\u0003[\ty#A\u0005fqR,gn]5p]*\u0019\u0011\u0011G.\u0002\u0007\u0005\u0004\u0018.\u0003\u0003\u00026\u0005-\"\u0001E#yi\u0016t7/[8o\u0007>tG/\u001a=u\u0005-)\u0005p\u00197vI\u0016T6\u000f\u001e3\u0014\u0007]qg\u000f\u0006\u0002\u0002>A\u00111p\u0006\u000b\u0005\u0003\u0003\nY\u0005\r\u0003\u0002D\u0005\u001d\u0003CBA\u0001\u0003\u0013\t)\u0005\u0005\u0003\u0002\u0010\u0005\u001dCaCA%3\u0005\u0005\t\u0011!B\u0001\u0003+\u00111a\u0018\u00133\u0011\u001d\t)#\u0007a\u0001\u0003OA3ABA(!\u0011\t\t&a\u0015\u000e\u0003eK1!!\u0016Z\u0005E\u0001\u0016M]1nKR,'/\u001b>fIR+7\u000f^\u0001(i\u0016\u001cHo\u00117fC:\u001c8i\\7cS:,GmQ8na\u0006\u001cG/\u00118e\t\u0016dW\r^3U_BL7\rF\u0002J\u00037BQ!T\u0004A\u00029CCaB+bE\"\u001aq!a\u0014\u0002=Q,7\u000f^\"mK\u0006tWM],ji\"lUm]:bO\u00164uN]7biZ\u0003DcA%\u0002f!)Q\n\u0003a\u0001\u001d\"*\u0001\"V1\u0002j\r\u0012\u00111\u000e\t\u0003I^A3\u0001CA(\u0003\u0015\"Xm\u001d;DY\u0016\fg.\u001b8h\u001d\u0016\u001cH/\u001a3NKN\u001c\u0018mZ3t/&$\bN\u0016\u0019B]\u00124\u0016\u0007F\u0002J\u0003gBa!!\u001e\n\u0001\u0004q\u0015!B2pI\u0016\u001c\u0007&B\u0005VC\u0006%\u0004fA\u0005\u0002P\u000592\r\\3b]\u0016\u00148i\u001c8gS\u001e,\u0006\u000fZ1uKR+7\u000f\u001e\u000b\u0004\u0013\u0006}\u0004\"B'\u000b\u0001\u0004q\u0005\u0006\u0002\u0006VC\nD3ACA(\u0003A\u0019\u0007.Z2l\u0019\u0006\u001cHo\u00117fC:,G\rF\u0004J\u0003\u0013\u000b\u0019+!,\t\u000f\u0005-5\u00021\u0001\u0002\u000e\u0006)Ao\u001c9jGB!\u0011qRAO\u001d\u0011\t\t*!'\u0011\u0007\u0005ME(\u0004\u0002\u0002\u0016*\u0019\u0011qS\u0010\u0002\rq\u0012xn\u001c;?\u0013\r\tY\nP\u0001\u0007!J,G-\u001a4\n\t\u0005}\u0015\u0011\u0015\u0002\u0007'R\u0014\u0018N\\4\u000b\u0007\u0005mE\bC\u0004\u0002&.\u0001\r!a*\u0002\u0017A\f'\u000f^5uS>t\u0017\n\u001a\t\u0004w\u0005%\u0016bAAVy\t\u0019\u0011J\u001c;\t\u000f\u0005=6\u00021\u0001\u00022\u0006Qa-\u001b:ti\u0012K'\u000f^=\u0011\u0007m\n\u0019,C\u0002\u00026r\u0012A\u0001T8oO\u0006Q2\r[3dW2{w-\u00114uKJ\f\u0005\u000f]3oI&tw\rR;qgR9\u0011*a/\u0002D\u0006\u001d\u0007B\u0002\u000f\r\u0001\u0004\ti\fE\u0002#\u0003\u007fK1!!1\u001c\u0005))f.\u001b4jK\u0012dun\u001a\u0005\b\u0003\u000bd\u0001\u0019AAY\u0003%\u0019H/\u0019:u'&TX\rC\u0004\u0002J2\u0001\r!a3\u0002\u000f\u0005\u0004\b/\u001a8egB1\u0011QZAj\u0003/l!!a4\u000b\u0007\u0005EG(\u0001\u0006d_2dWm\u0019;j_:LA!!6\u0002P\n\u00191+Z9\u0011\u0013m\nI.a*\u0002\u000e\u0006E\u0016bAAny\t1A+\u001e9mKN\nQ\u0001^8NCB$B!!9\u0002nBA\u0011QZAr\u0003O\u000b9/\u0003\u0003\u0002f\u0006='aA'baB91(!;\u0002\u000e\u0006E\u0016bAAvy\t1A+\u001e9mKJBq!a<\u000e\u0001\u0004\t\t0\u0001\u0005nKN\u001c\u0018mZ3t!\u0019\ti-a=\u0002X&!\u0011Q_Ah\u0005!IE/\u001a:bE2,\u0017a\u0003:fC\u00124%o\\7M_\u001e$B!!=\u0002|\"1AD\u0004a\u0001\u0003{\u000b\u0011d\u001e:ji\u0016$U\u000f]:TS:<G.Z'fgN\fw-Z*fiRq\u00111\u001aB\u0001\u0005\u000b\u0011IAa\u0003\u0003\u001a\tu\u0001b\u0002B\u0002\u001f\u0001\u0007\u0011qU\u0001\b]Vl7*Z=t\u0011\u001d\u00119a\u0004a\u0001\u0003O\u000bqA\\;n\tV\u00048\u000f\u0003\u0004\u001d\u001f\u0001\u0007\u0011Q\u0018\u0005\b\u0003kz\u0001\u0019\u0001B\u0007!\u0011\u0011yA!\u0006\u000e\u0005\tE!b\u0001B\n\u0005\u0006A1m\\7qe\u0016\u001c8/\u0003\u0003\u0003\u0018\tE!aC\"p[B\u0014Xm]:j_:D\u0011Ba\u0007\u0010!\u0003\u0005\r!a*\u0002\u0011M$\u0018M\u001d;LKfDqAa\b\u0010\u0001\u0004\u0011\t#\u0001\u0006nC\u001eL7MV1mk\u0016\u00042a\u000fB\u0012\u0013\r\u0011)\u0003\u0010\u0002\u0005\u0005f$X-A\u0012xe&$X\rR;qgNKgn\u001a7f\u001b\u0016\u001c8/Y4f'\u0016$H\u0005Z3gCVdG\u000fJ\u001b\u0016\u0005\t-\"\u0006BAT\u0005[Y#Aa\f\u0011\t\tE\"1H\u0007\u0003\u0005gQAA!\u000e\u00038\u0005IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0005sa\u0014AC1o]>$\u0018\r^5p]&!!Q\bB\u001a\u0005E)hn\u00195fG.,GMV1sS\u0006t7-\u001a")
public class LogCleanerParameterizedIntegrationTest
extends AbstractLogCleanerIntegrationTest {
    private final MockTime time = new MockTime();
    private final TopicPartition[] topicPartitions = (TopicPartition[])((Object[])new TopicPartition[]{new TopicPartition("log", 0), new TopicPartition("log", 1), new TopicPartition("log", 2)});

    @Override
    public MockTime time() {
        return this.time;
    }

    public TopicPartition[] topicPartitions() {
        return this.topicPartitions;
    }

    /*
     * WARNING - void declaration
     */
    @ParameterizedTest
    @ArgumentsSource(value=AllCompressions.class)
    public void cleanerTest(CompressionType compressionType) {
        void var6_6;
        void var5_5;
        int largeMessageKey = 20;
        Compression codec = Compression.of((CompressionType)compressionType).build();
        Tuple2<String, MemoryRecords> tuple2 = this.createLargeSingleMessageSet(largeMessageKey, (byte)2, codec);
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        String largeMessageValue = (String)tuple2._1();
        MemoryRecords largeMessageSet = (MemoryRecords)tuple2._2();
        void largeMessageValue2 = var5_5;
        void largeMessageSet2 = var6_6;
        int maxMessageSize = largeMessageSet2.sizeInBytes();
        WrappedArray x$1 = Predef$.MODULE$.wrapRefArray((Object[])this.topicPartitions());
        float x$3 = this.makeCleaner$default$2();
        int x$4 = this.makeCleaner$default$3();
        long x$5 = this.makeCleaner$default$4();
        long x$6 = this.makeCleaner$default$6();
        int x$7 = this.makeCleaner$default$7();
        int x$8 = this.makeCleaner$default$8();
        long x$9 = this.makeCleaner$default$9();
        Option<Object> x$10 = this.makeCleaner$default$10();
        Properties x$11 = this.makeCleaner$default$11();
        this.cleaner_$eq(this.makeCleaner((Iterable<TopicPartition>)x$1, x$3, x$4, x$5, maxMessageSize, x$6, x$7, x$8, x$9, x$10, x$11));
        UnifiedLog log = (UnifiedLog)this.cleaner().logs().get((Object)this.topicPartitions()[0]);
        Seq<Tuple3<Object, String, Object>> appends = this.writeDups(100, 3, log, codec, this.writeDups$default$5(), this.writeDups$default$6());
        long startSize = log.size();
        this.cleaner().startup();
        long firstDirty = log.activeSegment().baseOffset();
        this.checkLastCleaned("log", 0, firstDirty);
        int compactedSize = BoxesRunTime.unboxToInt((Object)((TraversableOnce)((TraversableLike)CollectionConverters$.MODULE$.collectionAsScalaIterableConverter(log.logSegments()).asScala()).map((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToInteger((int)x$2.size()), Iterable$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
        Assertions.assertTrue((startSize > (long)compactedSize ? 1 : 0) != 0, (String)new StringBuilder(57).append("log should have been compacted: startSize=").append(startSize).append(" compactedSize=").append(compactedSize).toString());
        this.checkLogAfterAppendingDups(log, startSize, appends);
        LogAppendInfo appendInfo = log.appendAsLeader((MemoryRecords)largeMessageSet2, 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4(), log.appendAsLeader$default$5(), log.appendAsLeader$default$6());
        log.updateHighWatermark(log.logEndOffset());
        long largeMessageOffset = appendInfo.firstOffset();
        int x$12 = largeMessageKey + 1;
        int x$13 = 100;
        int x$14 = 3;
        byte x$17 = this.writeDups$default$6();
        Seq<Tuple3<Object, String, Object>> dups = this.writeDups(x$13, x$14, log, codec, x$12, x$17);
        Seq appends2 = (Seq)((TraversableLike)appends.$plus$plus((GenTraversableOnce)new .colon.colon((Object)new Tuple3((Object)BoxesRunTime.boxToInteger((int)largeMessageKey), (Object)largeMessageValue2, (Object)BoxesRunTime.boxToLong((long)largeMessageOffset)), (List)Nil$.MODULE$), Seq$.MODULE$.canBuildFrom())).$plus$plus(dups, Seq$.MODULE$.canBuildFrom());
        long firstDirty2 = log.activeSegment().baseOffset();
        this.checkLastCleaned("log", 0, firstDirty2);
        this.checkLogAfterAppendingDups(log, startSize, (Seq<Tuple3<Object, String, Object>>)appends2);
        this.cleaner().logs().remove((Object)this.topicPartitions()[0]);
        this.cleaner().updateCheckpoints(this.logDir(), Option$.MODULE$.apply((Object)this.topicPartitions()[0]));
        Assertions.assertFalse((boolean)new OffsetCheckpointFile(new File(this.logDir(), this.cleaner().cleanerManager().offsetCheckpointFile()), OffsetCheckpointFile$.MODULE$.$lessinit$greater$default$2()).read().contains((Object)this.topicPartitions()[0]));
    }

    /*
     * WARNING - void declaration
     */
    @ParameterizedTest
    @ArgumentsSource(value=AllCompressions.class)
    public void testCleansCombinedCompactAndDeleteTopic(CompressionType compressionType) {
        void var10_12;
        void var9_11;
        void var5_5;
        Properties logProps = new Properties();
        Integer retentionMs = Predef$.MODULE$.int2Integer(100000);
        logProps.put("retention.ms", retentionMs);
        logProps.put("cleanup.policy", "compact,delete");
        Tuple2 tuple2 = this.runCleanerAndCheckCompacted$1(100, logProps, compressionType);
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        UnifiedLog log = (UnifiedLog)tuple2._1();
        long endOffset = var5_5.logEndOffset();
        var5_5.logSegments().forEach(x$4 -> x$4.setLastModified(this.time().milliseconds() - (long)(2 * Predef$.MODULE$.Integer2int(retentionMs))));
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!LogCleanerParameterizedIntegrationTest.$anonfun$testCleansCombinedCompactAndDeleteTopic$3((UnifiedLog)var5_5, endOffset)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)LogCleanerParameterizedIntegrationTest.$anonfun$testCleansCombinedCompactAndDeleteTopic$4());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        this.cleaner().shutdown();
        this.closeLog((UnifiedLog)var5_5);
        Tuple2 tuple22 = this.runCleanerAndCheckCompacted$1(20, logProps, compressionType);
        if (tuple22 == null) {
            throw new MatchError(null);
        }
        UnifiedLog log2 = (UnifiedLog)tuple22._1();
        Seq messages = (Seq)tuple22._2();
        void log22 = var9_11;
        void messages2 = var10_12;
        Iterable<Tuple3<Object, String, Object>> read = this.readFromLog((UnifiedLog)log22);
        Assertions.assertEquals(this.toMap((Iterable<Tuple3<Object, String, Object>>)messages2), this.toMap(read), (String)"Contents of the map shouldn't change");
    }

    /*
     * WARNING - void declaration
     */
    @ParameterizedTest
    @ArgumentsSource(value=ExcludeZstd.class)
    public void testCleanerWithMessageFormatV0(CompressionType compressionType) {
        void var6_6;
        void var5_5;
        int largeMessageKey = 20;
        Compression codec = Compression.of((CompressionType)compressionType).build();
        Tuple2<String, MemoryRecords> tuple2 = this.createLargeSingleMessageSet(largeMessageKey, (byte)0, codec);
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        String largeMessageValue = (String)tuple2._1();
        MemoryRecords largeMessageSet = (MemoryRecords)tuple2._2();
        void largeMessageValue2 = var5_5;
        void largeMessageSet2 = var6_6;
        NoCompression noCompression = Compression.NONE;
        int maxMessageSize = !(noCompression != null ? !noCompression.equals(codec) : codec != null) ? largeMessageSet2.sizeInBytes() : largeMessageSet2.sizeInBytes() + 6;
        WrappedArray x$1 = Predef$.MODULE$.wrapRefArray((Object[])this.topicPartitions());
        float x$3 = this.makeCleaner$default$2();
        int x$4 = this.makeCleaner$default$3();
        long x$5 = this.makeCleaner$default$4();
        long x$6 = this.makeCleaner$default$6();
        int x$72 = this.makeCleaner$default$7();
        int x$8 = this.makeCleaner$default$8();
        long x$9 = this.makeCleaner$default$9();
        Option<Object> x$10 = this.makeCleaner$default$10();
        Properties x$11 = this.makeCleaner$default$11();
        this.cleaner_$eq(this.makeCleaner((Iterable<TopicPartition>)x$1, x$3, x$4, x$5, maxMessageSize, x$6, x$72, x$8, x$9, x$10, x$11));
        UnifiedLog log = (UnifiedLog)this.cleaner().logs().get((Object)this.topicPartitions()[0]);
        Properties x$13 = this.logConfigProperties$default$1();
        float x$14 = this.logConfigProperties$default$3();
        long x$15 = this.logConfigProperties$default$4();
        int x$16 = this.logConfigProperties$default$5();
        int x$17 = this.logConfigProperties$default$6();
        long x$18 = this.logConfigProperties$default$7();
        Properties props = this.logConfigProperties(x$13, maxMessageSize, x$14, x$15, x$16, x$17, x$18);
        props.put("message.format.version", MetadataVersion.IBP_0_9_0.version());
        log.updateConfig(new LogConfig((java.util.Map)props));
        int x$19 = 100;
        int x$20 = 3;
        byte x$23 = 0;
        int x$24 = this.writeDups$default$5();
        Seq<Tuple3<Object, String, Object>> appends = this.writeDups(x$19, x$20, log, codec, x$24, x$23);
        long startSize = log.size();
        this.cleaner().startup();
        long firstDirty = log.activeSegment().baseOffset();
        this.checkLastCleaned("log", 0, firstDirty);
        int compactedSize = BoxesRunTime.unboxToInt((Object)((TraversableOnce)((TraversableLike)CollectionConverters$.MODULE$.collectionAsScalaIterableConverter(log.logSegments()).asScala()).map((Function1 & Serializable & scala.Serializable)x$7 -> BoxesRunTime.boxToInteger((int)x$7.size()), Iterable$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
        Assertions.assertTrue((startSize > (long)compactedSize ? 1 : 0) != 0, (String)new StringBuilder(57).append("log should have been compacted: startSize=").append(startSize).append(" compactedSize=").append(compactedSize).toString());
        this.checkLogAfterAppendingDups(log, startSize, appends);
        int x$25 = 40;
        int x$26 = 3;
        byte x$29 = 0;
        int x$30 = this.writeDups$default$5();
        Seq<Tuple3<Object, String, Object>> dupsV0 = this.writeDups(x$25, x$26, log, codec, x$30, x$29);
        LogAppendInfo appendInfo = log.appendAsLeader((MemoryRecords)largeMessageSet2, 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4(), log.appendAsLeader$default$5(), log.appendAsLeader$default$6());
        log.updateHighWatermark(log.logEndOffset());
        long largeMessageOffset = appendInfo.firstOffset();
        props.put("message.format.version", MetadataVersion.IBP_0_11_0_IV0.version());
        log.updateConfig(new LogConfig((java.util.Map)props));
        int x$31 = 30;
        int x$32 = 40;
        int x$33 = 3;
        byte x$36 = 1;
        Seq<Tuple3<Object, String, Object>> dupsV1 = this.writeDups(x$32, x$33, log, codec, x$31, x$36);
        int x$37 = 15;
        int x$38 = 5;
        int x$39 = 3;
        byte x$42 = 2;
        Seq<Tuple3<Object, String, Object>> dupsV2 = this.writeDups(x$38, x$39, log, codec, x$37, x$42);
        Seq appends2 = (Seq)((TraversableLike)((TraversableLike)((TraversableLike)appends.$plus$plus(dupsV0, Seq$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)new .colon.colon((Object)new Tuple3((Object)BoxesRunTime.boxToInteger((int)largeMessageKey), (Object)largeMessageValue2, (Object)BoxesRunTime.boxToLong((long)largeMessageOffset)), (List)Nil$.MODULE$), Seq$.MODULE$.canBuildFrom())).$plus$plus(dupsV1, Seq$.MODULE$.canBuildFrom())).$plus$plus(dupsV2, Seq$.MODULE$.canBuildFrom());
        long firstDirty2 = log.activeSegment().baseOffset();
        this.checkLastCleaned("log", 0, firstDirty2);
        this.checkLogAfterAppendingDups(log, startSize, (Seq<Tuple3<Object, String, Object>>)appends2);
    }

    @ParameterizedTest
    @ArgumentsSource(value=ExcludeZstd.class)
    public void testCleaningNestedMessagesWithV0AndV1(CompressionType codec) {
        Compression compression = Compression.of((CompressionType)codec).build();
        int maxMessageSize = 192;
        WrappedArray x$1 = Predef$.MODULE$.wrapRefArray((Object[])this.topicPartitions());
        int x$3 = 256;
        float x$4 = this.makeCleaner$default$2();
        int x$5 = this.makeCleaner$default$3();
        long x$6 = this.makeCleaner$default$4();
        long x$7 = this.makeCleaner$default$6();
        int x$82 = this.makeCleaner$default$7();
        long x$9 = this.makeCleaner$default$9();
        Option<Object> x$10 = this.makeCleaner$default$10();
        Properties x$11 = this.makeCleaner$default$11();
        this.cleaner_$eq(this.makeCleaner((Iterable<TopicPartition>)x$1, x$4, x$5, x$6, maxMessageSize, x$7, x$82, x$3, x$9, x$10, x$11));
        UnifiedLog log = (UnifiedLog)this.cleaner().logs().get((Object)this.topicPartitions()[0]);
        int x$13 = 256;
        Properties x$14 = this.logConfigProperties$default$1();
        float x$15 = this.logConfigProperties$default$3();
        long x$16 = this.logConfigProperties$default$4();
        int x$17 = this.logConfigProperties$default$5();
        long x$18 = this.logConfigProperties$default$7();
        Properties props = this.logConfigProperties(x$14, maxMessageSize, x$15, x$16, x$17, x$13, x$18);
        props.put("message.format.version", MetadataVersion.IBP_0_9_0.version());
        log.updateConfig(new LogConfig((java.util.Map)props));
        int x$19 = 2;
        int x$20 = 3;
        byte x$23 = 0;
        int x$24 = this.writeDupsSingleMessageSet$default$5();
        Seq appendsV0 = this.writeDupsSingleMessageSet(x$19, x$20, log, compression, x$24, x$23);
        int x$25 = 2;
        int x$26 = 3;
        int x$27 = 2;
        byte x$30 = 0;
        appendsV0 = (Seq)appendsV0.$plus$plus(this.writeDupsSingleMessageSet(x$25, x$27, log, compression, x$26, x$30), Seq$.MODULE$.canBuildFrom());
        props.put("message.format.version", MetadataVersion.IBP_0_10_0_IV1.version());
        log.updateConfig(new LogConfig((java.util.Map)props));
        int x$31 = 4;
        int x$32 = 2;
        int x$33 = 2;
        byte x$36 = 1;
        Seq appendsV1 = this.writeDupsSingleMessageSet(x$32, x$33, log, compression, x$31, x$36);
        int x$37 = 4;
        int x$38 = 2;
        int x$39 = 2;
        byte x$42 = 1;
        appendsV1 = (Seq)appendsV1.$plus$plus(this.writeDupsSingleMessageSet(x$38, x$39, log, compression, x$37, x$42), Seq$.MODULE$.canBuildFrom());
        int x$43 = 6;
        int x$44 = 2;
        int x$45 = 2;
        byte x$48 = 1;
        appendsV1 = (Seq)appendsV1.$plus$plus(this.writeDupsSingleMessageSet(x$44, x$45, log, compression, x$43, x$48), Seq$.MODULE$.canBuildFrom());
        Seq appends = (Seq)appendsV0.$plus$plus((GenTraversableOnce)appendsV1, Seq$.MODULE$.canBuildFrom());
        long startSize = log.size();
        this.cleaner().startup();
        long firstDirty = log.activeSegment().baseOffset();
        Assertions.assertTrue((firstDirty > (long)appendsV0.size() ? 1 : 0) != 0);
        this.checkLastCleaned("log", 0, firstDirty);
        int compactedSize = BoxesRunTime.unboxToInt((Object)((TraversableOnce)((TraversableLike)CollectionConverters$.MODULE$.collectionAsScalaIterableConverter(log.logSegments()).asScala()).map((Function1 & Serializable & scala.Serializable)x$8 -> BoxesRunTime.boxToInteger((int)x$8.size()), Iterable$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
        Assertions.assertTrue((startSize > (long)compactedSize ? 1 : 0) != 0, (String)new StringBuilder(57).append("log should have been compacted: startSize=").append(startSize).append(" compactedSize=").append(compactedSize).toString());
        this.checkLogAfterAppendingDups(log, startSize, (Seq<Tuple3<Object, String, Object>>)appends);
    }

    /*
     * WARNING - void declaration
     */
    @ParameterizedTest
    @ArgumentsSource(value=AllCompressions.class)
    public void cleanerConfigUpdateTest(CompressionType compressionType) {
        void var5_5;
        int largeMessageKey = 20;
        Compression codec = Compression.of((CompressionType)compressionType).build();
        Tuple2<String, MemoryRecords> tuple2 = this.createLargeSingleMessageSet(largeMessageKey, (byte)2, codec);
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        MemoryRecords largeMessageSet = (MemoryRecords)tuple2._2();
        int maxMessageSize = var5_5.sizeInBytes();
        WrappedArray x$1 = Predef$.MODULE$.wrapRefArray((Object[])this.topicPartitions());
        long x$2 = 1L;
        Some x$4 = new Some((Object)BoxesRunTime.boxToInteger((int)1));
        float x$5 = this.makeCleaner$default$2();
        int x$6 = this.makeCleaner$default$3();
        long x$7 = this.makeCleaner$default$6();
        int x$8 = this.makeCleaner$default$7();
        int x$92 = this.makeCleaner$default$8();
        long x$10 = this.makeCleaner$default$9();
        Properties x$11 = this.makeCleaner$default$11();
        this.cleaner_$eq(this.makeCleaner((Iterable<TopicPartition>)x$1, x$5, x$6, x$2, maxMessageSize, x$7, x$8, x$92, x$10, (Option<Object>)x$4, x$11));
        UnifiedLog log = (UnifiedLog)this.cleaner().logs().get((Object)this.topicPartitions()[0]);
        this.writeDups(100, 3, log, codec, this.writeDups$default$5(), this.writeDups$default$6());
        long startSize = log.size();
        this.cleaner().startup();
        Assertions.assertEquals((int)1, (int)this.cleaner().cleanerCount());
        long firstDirty = log.activeSegment().baseOffset();
        TopicPartition topicPartition = new TopicPartition("log", 0);
        this.cleaner().awaitCleaned(topicPartition, firstDirty, 10L);
        Assertions.assertTrue((boolean)this.cleaner().cleanerManager().allCleanerCheckpoints().isEmpty(), (String)"Should not have cleaned");
        KafkaConfig oldConfig = LogCleanerParameterizedIntegrationTest.kafkaConfigWithCleanerConfig$1(this.cleaner().currentConfig());
        KafkaConfig newConfig = LogCleanerParameterizedIntegrationTest.kafkaConfigWithCleanerConfig$1(new CleanerConfig(2, this.cleaner().currentConfig().dedupeBufferSize, this.cleaner().currentConfig().dedupeBufferLoadFactor, 100000, this.cleaner().currentConfig().maxMessageSize, this.cleaner().currentConfig().maxIoBytesPerSecond, this.cleaner().currentConfig().backoffMs, true));
        this.cleaner().reconfigure(oldConfig, newConfig);
        Assertions.assertEquals((int)2, (int)this.cleaner().cleanerCount());
        this.checkLastCleaned("log", 0, firstDirty);
        int compactedSize = BoxesRunTime.unboxToInt((Object)((TraversableOnce)((TraversableLike)CollectionConverters$.MODULE$.collectionAsScalaIterableConverter(log.logSegments()).asScala()).map((Function1 & Serializable & scala.Serializable)x$9 -> BoxesRunTime.boxToInteger((int)x$9.size()), Iterable$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
        Assertions.assertTrue((startSize > (long)compactedSize ? 1 : 0) != 0, (String)new StringBuilder(57).append("log should have been compacted: startSize=").append(startSize).append(" compactedSize=").append(compactedSize).toString());
    }

    private void checkLastCleaned(String topic, int partitionId, long firstDirty) {
        TopicPartition topicPartition = new TopicPartition(topic, partitionId);
        LogCleaner qual$1 = this.cleaner();
        long x$3 = qual$1.awaitCleaned$default$3();
        qual$1.awaitCleaned(topicPartition, firstDirty, x$3);
        long lastCleaned = BoxesRunTime.unboxToLong((Object)this.cleaner().cleanerManager().allCleanerCheckpoints().apply((Object)topicPartition));
        Assertions.assertTrue((lastCleaned >= firstDirty ? 1 : 0) != 0, (String)new StringBuilder(65).append("log cleaner should have processed up to offset ").append(firstDirty).append(", but lastCleaned=").append(lastCleaned).toString());
    }

    private void checkLogAfterAppendingDups(UnifiedLog log, long startSize, Seq<Tuple3<Object, String, Object>> appends) {
        Iterable<Tuple3<Object, String, Object>> read = this.readFromLog(log);
        Assertions.assertEquals(this.toMap((Iterable<Tuple3<Object, String, Object>>)appends), this.toMap(read), (String)"Contents of the map shouldn't change");
        Assertions.assertTrue((startSize > log.size() ? 1 : 0) != 0);
    }

    private Map<Object, Tuple2<String, Object>> toMap(Iterable<Tuple3<Object, String, Object>> messages) {
        return ((TraversableOnce)messages.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            if (x0$1 != null) {
                int key = BoxesRunTime.unboxToInt((Object)x0$1._1());
                String value = (String)x0$1._2();
                long offset = BoxesRunTime.unboxToLong((Object)x0$1._3());
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)key)), (Object)new Tuple2((Object)value, (Object)BoxesRunTime.boxToLong((long)offset)));
            }
            throw new MatchError(null);
        }, Iterable$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
    }

    private Iterable<Tuple3<Object, String, Object>> readFromLog(UnifiedLog log) {
        return (Iterable)((TraversableLike)CollectionConverters$.MODULE$.collectionAsScalaIterableConverter(log.logSegments()).asScala()).flatMap((Function1 & Serializable & scala.Serializable)segment -> (Iterable)((TraversableLike)CollectionConverters$.MODULE$.iterableAsScalaIterableConverter(segment.log().records()).asScala()).map((Function1 & Serializable & scala.Serializable)deepLogEntry -> {
            int key = new StringOps(Predef$.MODULE$.augmentString(TestUtils$.MODULE$.readString(deepLogEntry.key(), TestUtils$.MODULE$.readString$default$2()))).toInt();
            String value = TestUtils$.MODULE$.readString(deepLogEntry.value(), TestUtils$.MODULE$.readString$default$2());
            return new Tuple3((Object)BoxesRunTime.boxToInteger((int)key), (Object)value, (Object)BoxesRunTime.boxToLong((long)deepLogEntry.offset()));
        }, Iterable$.MODULE$.canBuildFrom()), Iterable$.MODULE$.canBuildFrom());
    }

    private Seq<Tuple3<Object, String, Object>> writeDupsSingleMessageSet(int numKeys, int numDups, UnifiedLog log, Compression codec, int startKey, byte magicValue) {
        IndexedSeq kvs = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numDups).flatMap((Function1 & Serializable & scala.Serializable)_ -> LogCleanerParameterizedIntegrationTest.$anonfun$writeDupsSingleMessageSet$1(this, startKey, numKeys, BoxesRunTime.unboxToInt((Object)_)), IndexedSeq$.MODULE$.canBuildFrom());
        IndexedSeq records = (IndexedSeq)kvs.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            if (x0$1 != null) {
                int key = x0$1._1$mcI$sp();
                String payload = (String)x0$1._2();
                return new SimpleRecord(Integer.toString(key).getBytes(), payload.getBytes());
            }
            throw new MatchError(null);
        }, IndexedSeq$.MODULE$.canBuildFrom());
        LogAppendInfo appendInfo = log.appendAsLeader(MemoryRecords.withRecords((byte)magicValue, (Compression)codec, (SimpleRecord[])((SimpleRecord[])records.toArray(ClassTag$.MODULE$.apply(SimpleRecord.class)))), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4(), log.appendAsLeader$default$5(), log.appendAsLeader$default$6());
        log.updateHighWatermark(log.logEndOffset());
        NumericRange.Inclusive offsets = new RichLong(Predef$.MODULE$.longWrapper(appendInfo.firstOffset())).to((Object)BoxesRunTime.boxToLong((long)appendInfo.lastOffset()));
        return (Seq)((TraversableLike)kvs.zip((GenIterable)offsets, IndexedSeq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x0$2 -> {
            if (x0$2 != null) {
                Tuple2 kv = (Tuple2)x0$2._1();
                long offset = x0$2._2$mcJ$sp();
                return new Tuple3((Object)BoxesRunTime.boxToInteger((int)kv._1$mcI$sp()), kv._2(), (Object)BoxesRunTime.boxToLong((long)offset));
            }
            throw new MatchError(null);
        }, IndexedSeq$.MODULE$.canBuildFrom());
    }

    private int writeDupsSingleMessageSet$default$5() {
        return 0;
    }

    private final Tuple2 runCleanerAndCheckCompacted$1(int numKeys, Properties logProps$1, CompressionType compressionType$1) {
        WrappedArray x$1 = Predef$.MODULE$.wrapRefArray((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.topicPartitions())).take(1));
        long x$32 = 100L;
        float x$4 = this.makeCleaner$default$2();
        int x$5 = this.makeCleaner$default$3();
        int x$6 = this.makeCleaner$default$5();
        long x$7 = this.makeCleaner$default$6();
        int x$8 = this.makeCleaner$default$7();
        int x$9 = this.makeCleaner$default$8();
        long x$10 = this.makeCleaner$default$9();
        Option<Object> x$11 = this.makeCleaner$default$10();
        this.cleaner_$eq(this.makeCleaner((Iterable<TopicPartition>)x$1, x$4, x$5, x$32, x$6, x$7, x$8, x$9, x$10, x$11, logProps$1));
        UnifiedLog log = (UnifiedLog)this.cleaner().logs().get((Object)this.topicPartitions()[0]);
        Seq<Tuple3<Object, String, Object>> messages = this.writeDups(numKeys, 3, log, Compression.of((CompressionType)compressionType$1).build(), this.writeDups$default$5(), this.writeDups$default$6());
        long startSize = log.size();
        log.updateHighWatermark(log.logEndOffset());
        long firstDirty = log.activeSegment().baseOffset();
        this.cleaner().startup();
        this.checkLastCleaned("log", 0, firstDirty);
        int compactedSize = BoxesRunTime.unboxToInt((Object)((TraversableOnce)((TraversableLike)CollectionConverters$.MODULE$.collectionAsScalaIterableConverter(log.logSegments()).asScala()).map((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToInteger((int)x$3.size()), Iterable$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
        Assertions.assertTrue((startSize > (long)compactedSize ? 1 : 0) != 0, (String)new StringBuilder(57).append("log should have been compacted: startSize=").append(startSize).append(" compactedSize=").append(compactedSize).toString());
        return new Tuple2((Object)log, messages);
    }

    public static final /* synthetic */ boolean $anonfun$testCleansCombinedCompactAndDeleteTopic$3(UnifiedLog log$1, long endOffset$1) {
        return log$1.logStartOffset() == endOffset$1 && log$1.numberOfSegments() == 1;
    }

    public static final /* synthetic */ String $anonfun$testCleansCombinedCompactAndDeleteTopic$4() {
        return "Timed out waiting for deletion of old segments";
    }

    private static final KafkaConfig kafkaConfigWithCleanerConfig$1(CleanerConfig cleanerConfig) {
        Properties props = TestUtils$.MODULE$.createBrokerConfig(0, "localhost:2181", TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18(), TestUtils$.MODULE$.createBrokerConfig$default$19(), TestUtils$.MODULE$.createBrokerConfig$default$20(), TestUtils$.MODULE$.createBrokerConfig$default$21());
        props.put("log.cleaner.threads", Integer.toString(cleanerConfig.numThreads));
        props.put("log.cleaner.dedupe.buffer.size", Long.toString(cleanerConfig.dedupeBufferSize));
        props.put("log.cleaner.io.buffer.load.factor", Double.toString(cleanerConfig.dedupeBufferLoadFactor));
        props.put("log.cleaner.io.buffer.size", Integer.toString(cleanerConfig.ioBufferSize));
        props.put("message.max.bytes", Integer.toString(cleanerConfig.maxMessageSize));
        props.put("log.cleaner.backoff.ms", Long.toString(cleanerConfig.backoffMs));
        props.put("log.cleaner.io.max.bytes.per.second", Double.toString(cleanerConfig.maxIoBytesPerSecond));
        return KafkaConfig$.MODULE$.fromProps(props);
    }

    public static final /* synthetic */ Tuple2 $anonfun$writeDupsSingleMessageSet$2(LogCleanerParameterizedIntegrationTest $this, int key) {
        String payload = Integer.toString($this.counter());
        $this.incCounter();
        return new Tuple2((Object)BoxesRunTime.boxToInteger((int)key), (Object)payload);
    }

    public static final /* synthetic */ IndexedSeq $anonfun$writeDupsSingleMessageSet$1(LogCleanerParameterizedIntegrationTest $this, int startKey$1, int numKeys$1, int _) {
        return (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(startKey$1), startKey$1 + numKeys$1).map((Function1 & Serializable & scala.Serializable)key -> LogCleanerParameterizedIntegrationTest.$anonfun$writeDupsSingleMessageSet$2($this, BoxesRunTime.unboxToInt((Object)key)), IndexedSeq$.MODULE$.canBuildFrom());
    }

    public static class AllCompressions
    implements ArgumentsProvider {
        public Stream<? extends Arguments> provideArguments(ExtensionContext context) {
            return Arrays.stream((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])CompressionType.values())).map((Function1 & Serializable & scala.Serializable)codec -> Arguments.of((Object[])new Object[]{codec}), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Arguments.class))));
        }
    }

    public static class ExcludeZstd
    implements ArgumentsProvider {
        public Stream<? extends Arguments> provideArguments(ExtensionContext context) {
            return Arrays.stream((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])CompressionType.values())).filter((Function1 & Serializable & scala.Serializable)x$10 -> BoxesRunTime.boxToBoolean((boolean)ExcludeZstd.$anonfun$provideArguments$2(x$10))))).map((Function1 & Serializable & scala.Serializable)codec -> Arguments.of((Object[])new Object[]{codec}), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Arguments.class))));
        }

        public static final /* synthetic */ boolean $anonfun$provideArguments$2(CompressionType x$10) {
            CompressionType compressionType = x$10;
            CompressionType compressionType2 = CompressionType.ZSTD;
            return compressionType == null ? compressionType2 != null : !compressionType.equals(compressionType2);
        }
    }
}

