/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import java.io.File;
import java.io.Serializable;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.errors.InvalidConfigurationException;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.server.common.MetadataVersion;
import org.apache.kafka.server.config.ServerLogConfigs;
import org.apache.kafka.storage.internals.log.LogConfig;
import org.apache.kafka.storage.internals.log.ThrottledReplicaListValidator;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005mg\u0001B\u0010!\u0001\u0015BQ\u0001\f\u0001\u0005\u00025BQ\u0001\r\u0001\u0005\u0002EBQA\u0011\u0001\u0005\u0002EBQ\u0001\u0012\u0001\u0005\u0002EBQA\u0012\u0001\u0005\u0002EBQ\u0001\u0013\u0001\u0005\u0002EBQA\u0013\u0001\u0005\u0002EBQ\u0001\u0014\u0001\u0005\u0002EBQA\u0014\u0001\u0005\u0002EBQ\u0001\u0015\u0001\u0005\u0002EBQA\u0015\u0001\u0005\u0002EBQ\u0001\u0016\u0001\u0005\u0002EBQA\u0016\u0001\u0005\n]CQ\u0001\u001b\u0001\u0005\n%DQ!\u001d\u0001\u0005\u0002EBQa\u001d\u0001\u0005\u0002EBQ!\u001e\u0001\u0005\u0002EBQa\u001e\u0001\u0005\u0002EBQ!\u001f\u0001\u0005\niDa!!\u000b\u0001\t\u0003\t\u0004bBA\u0017\u0001\u0011\u0005\u0011q\u0006\u0005\b\u0003;\u0002A\u0011AA0\u0011\u001d\ty\u0007\u0001C\u0001\u0003cBq!a \u0001\t\u0003\t\t\tC\u0004\u0002\u0010\u0002!\t!!%\t\u000f\u0005}\u0005\u0001\"\u0001\u0002\"\"9\u0011Q\u0016\u0001\u0005\u0002\u0005=\u0006bBA^\u0001\u0011\u0005\u0011Q\u0018\u0005\u0007\u0003'\u0004A\u0011A\u0019\t\r\u0005]\u0007\u0001\"\u00012\u00055aunZ\"p]\u001aLw\rV3ti*\u0011\u0011EI\u0001\u0004Y><'\"A\u0012\u0002\u000b-\fgm[1\u0004\u0001M\u0011\u0001A\n\t\u0003O)j\u0011\u0001\u000b\u0006\u0002S\u0005)1oY1mC&\u00111\u0006\u000b\u0002\u0007\u0003:L(+\u001a4\u0002\rqJg.\u001b;?)\u0005q\u0003CA\u0018\u0001\u001b\u0005\u0001\u0013aK3ogV\u0014XMT8Ti\u0006$\u0018nY%oSRL\u0017\r\\5{CRLwN\\(sI\u0016\u0014H)\u001a9f]\u0012,gnY=\u0015\u0003I\u0002\"aJ\u001a\n\u0005QB#\u0001B+oSRD#A\u0001\u001c\u0011\u0005]\u0002U\"\u0001\u001d\u000b\u0005eR\u0014aA1qS*\u00111\bP\u0001\bUV\u0004\u0018\u000e^3s\u0015\tid(A\u0003kk:LGOC\u0001@\u0003\ry'oZ\u0005\u0003\u0003b\u0012A\u0001V3ti\u00061B/Z:u\u0017\u000647.Y\"p]\u001aLw\rV8Qe>\u00048\u000f\u000b\u0002\u0004m\u0005!B/Z:u\rJ|W\u000e\u0015:paNLeN^1mS\u0012D#\u0001\u0002\u001c\u0002=Q,7\u000f^%om\u0006d\u0017\u000eZ\"p[B\f7\r^5p]2\u000bwmQ8oM&<\u0007FA\u00037\u0003\u0015\u001a\bn\\;mIZ\u000bG.\u001b3bi\u0016$\u0006N]8ui2,GMU3qY&\u001c\u0017m]\"p]\u001aLw\r\u000b\u0002\u0007m\u0005yA/Z:u)>DE/\u001c7UC\ndW\r\u000b\u0002\bm\u0005QA/Z:u)>DE/\u001c7)\u0005!1\u0014!\u0005;fgR$v.\u00128sS\u000eDW\r\u001a*ti\"\u0012\u0011BN\u0001\ni\u0016\u001cH\u000fV8SgRD#A\u0003\u001c\u0002%Q,7\u000f^$fi\u000e{gNZ5h-\u0006dW/\u001a\u0015\u0003\u0017Y\nQ\u0005^3ti>3XM\u001d:jI\u0012,gnQ8oM&<7/Q:M_\u001e<\u0017M\u00197f'R\u0014\u0018N\\4)\u000511\u0014aB5t-\u0006d\u0017\u000e\u001a\u000b\u00031n\u0003\"aJ-\n\u0005iC#a\u0002\"p_2,\u0017M\u001c\u0005\u000696\u0001\r!X\u0001\fG>tg-[4WC2,X\r\u0005\u0002_K:\u0011ql\u0019\t\u0003A\"j\u0011!\u0019\u0006\u0003E\u0012\na\u0001\u0010:p_Rt\u0014B\u00013)\u0003\u0019\u0001&/\u001a3fM&\u0011am\u001a\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005\u0011D\u0013!F1tg\u0016\u0014H\u000f\u0015:pa\u0016\u0014H/_%om\u0006d\u0017\u000e\u001a\u000b\u0004e)d\u0007\"B6\u000f\u0001\u0004i\u0016\u0001\u00028b[\u0016DQ!\u001c\bA\u00029\faA^1mk\u0016\u001c\bcA\u0014pM%\u0011\u0001\u000f\u000b\u0002\u000byI,\u0007/Z1uK\u0012t\u0014!\t;fgRdunY1m\u0019><'+\u001a;f]RLwN\u001c#fe&4X\r\u001a)s_B\u001c\bFA\b7\u0003!\"Xm\u001d;M_\u000e\fG\u000eT8h%\u0016$XM\u001c;j_:$UM]5wK\u0012$UMZ1vYR\u0004&o\u001c9tQ\t\u0001b'\u0001\u000euKN$Hj\\2bY2{wMU3uK:$\u0018n\u001c8Qe>\u00048\u000f\u000b\u0002\u0012m\u0005\tC/Z:u\u0013:4\u0018\r\\5e\u0019>\u001c\u0017\r\u001c'pOJ+G/\u001a8uS>t\u0007K]8qg\"\u0012!CN\u0001$I>$Vm\u001d;J]Z\fG.\u001b3M_\u000e\fG\u000eT8h%\u0016$XM\u001c;j_:\u0004&o\u001c9t)%Y\u0018QBA\f\u0003C\t)\u0003E\u0002}\u0003\u0013i\u0011! \u0006\u0003}~\faaY8oM&<'\u0002BA\u0001\u0003\u0007\taaY8n[>t'bA\u0012\u0002\u0006)\u0019\u0011q\u0001 \u0002\r\u0005\u0004\u0018m\u00195f\u0013\r\tY! \u0002\u0010\u0007>tg-[4Fq\u000e,\u0007\u000f^5p]\"9\u0011qB\nA\u0002\u0005E\u0011\u0001\u00057pG\u0006d'+\u001a;f]RLwN\\'t!\r9\u00131C\u0005\u0004\u0003+A#\u0001\u0002'p]\u001eDq!!\u0007\u0014\u0001\u0004\tY\"A\nm_\u000e\fGNU3uK:$\u0018n\u001c8CsR,7\u000fE\u0002(\u0003;I1!a\b)\u0005\rIe\u000e\u001e\u0005\b\u0003G\u0019\u0002\u0019AA\u000e\u00039\u0011X\r^3oi&|gNQ=uKNDq!a\n\u0014\u0001\u0004\t\t\"A\u0006sKR,g\u000e^5p]6\u001b\u0018A\u000b;fgR,e.\u00192mKJ+Wn\u001c;f\u0019><7\u000b^8sC\u001e,wJ\\\"p[B\f7\r^3e)>\u0004\u0018n\u0019\u0015\u0003)Y\n!\u0004^3ti\u0016s\u0017M\u00197f%\u0016lw\u000e^3M_\u001e\u001cFo\u001c:bO\u0016$2AMA\u0019\u0011\u0019\t\u0019$\u0006a\u00011\u000692/_:SK6|G/Z*u_J\fw-Z#oC\ndW\r\u001a\u0015\b+\u0005]\u0012qIA%!\u0011\tI$a\u0011\u000e\u0005\u0005m\"\u0002BA\u001f\u0003\u007f\t\u0001\u0002\u001d:pm&$WM\u001d\u0006\u0004\u0003\u0003R\u0014A\u00029be\u0006l7/\u0003\u0003\u0002F\u0005m\"a\u0003,bYV,7k\\;sG\u0016\f\u0001BY8pY\u0016\fgn\u001d\u0017\u0005\u0003\u0017\ni%G\u0001\u00023\u0005\u0001\u0001FB\u000b\u0002R-\fI\u0006\u0005\u0003\u0002T\u0005USBAA \u0013\u0011\t9&a\u0010\u0003#A\u000b'/Y7fi\u0016\u0014\u0018N_3e)\u0016\u001cH/\t\u0002\u0002\\\u0005aD/Z:u\u000b:\f'\r\\3SK6|G/\u001a'pON#xN]1hK\u0002:\u0018\u000e\u001e5!gf\u001c(+Z7pi\u0016\u001cFo\u001c:bO\u0016,e.\u00192mK\u0012T\u0004e\u001f\u0019~\u0003m!Xm\u001d;ESN\f'\r\\3SK6|G/\u001a'pON#xN]1hKR\u0019!'!\u0019\t\r\u0005\rd\u00031\u0001Y\u0003]9\u0018m\u001d*f[>$Xm\u0015;pe\u0006<W-\u00128bE2,G\rK\u0004\u0017\u0003o\t9%a\u001a-\t\u0005-\u0013Q\n\u0015\u0007-\u0005E3.a\u001b\"\u0005\u00055\u0014!\u0010;fgR$\u0015n]1cY\u0016\u0014V-\\8uK2{wm\u0015;pe\u0006<W\rI<ji\"\u0004s/Y:SK6|G/Z*u_J\fw-Z#oC\ndW\r\u001a\u001e!wBj\u0018!\u000b;fgR$v\u000e]5d\u0007J,\u0017\r^5p]^KG\u000f[%om\u0006d\u0017\u000e\u001a*fi\u0016tG/[8o)&lW\rF\u00023\u0003gBa!a\r\u0018\u0001\u0004A\u0006fB\f\u00028\u0005\u001d\u0013q\u000f\u0017\u0005\u0003\u0017\ni\u0005\u000b\u0004\u0018\u0003#Z\u00171P\u0011\u0003\u0003{\n1\n^3tiR{\u0007/[2De\u0016\fG/[8o/&$\b.\u00138wC2LGMU3uK:$\u0018n\u001c8US6,\u0007e^5uQ\u0002\u001a\u0018p\u001d*f[>$Xm\u0015;pe\u0006<W-\u00128bE2,GM\u000f\u0011|au\f\u0011\u0006^3tiR{\u0007/[2De\u0016\fG/[8o/&$\b.\u00138wC2LGMU3uK:$\u0018n\u001c8TSj,Gc\u0001\u001a\u0002\u0004\"1\u00111\u0007\rA\u0002aCs\u0001GA\u001c\u0003\u000f\n9\t\f\u0003\u0002L\u00055\u0003F\u0002\r\u0002R-\fY)\t\u0002\u0002\u000e\u0006YE/Z:u)>\u0004\u0018nY\"sK\u0006$\u0018n\u001c8XSRD\u0017J\u001c<bY&$'+\u001a;f]RLwN\\*ju\u0016\u0004s/\u001b;iAML8OU3n_R,7\u000b^8sC\u001e,WI\\1cY\u0016$'\bI>1{\u0006aB/Z:u-\u0006d\u0017\u000eZ1uK\n\u0013xn[3s\u0019><7i\u001c8gS\u001e\u001cHc\u0001\u001a\u0002\u0014\"1\u00111G\rA\u0002aCs!GA\u001c\u0003\u000f\n9\n\f\u0003\u0002L\u00055\u0003FB\r\u0002R-\fY*\t\u0002\u0002\u001e\u0006qD/Z:u-\u0006d\u0017\u000eZ1uK\n\u0013xn[3s\u0019><7i\u001c8gS\u001e\u001c\be^5uQ\u0002\u001a\u0018p\u001d*f[>$Xm\u0015;pe\u0006<W-\u00128bE2,GM\u000f\u0011|au\fa\u0004^3tiZ\u000bG.\u001b3SK6|G/\u001a'pO\u000e{\u0007/\u001f#jg\u0006\u0014G.\u001a3\u0015\u0007I\n\u0019\u000b\u0003\u0004\u0002&j\u0001\r\u0001W\u0001\rG>\u0004\u0018\u0010R5tC\ndW\r\u001a\u0015\b5\u0005]\u0012qIAUY\u0011\tY%!\u0014)\u0007i\t\t&A\u0011uKN$h+\u00197jIJ+Wn\u001c;f\u0019><G)\u001a7fi\u0016|e\u000eR5tC\ndW\rF\u00023\u0003cCa!a-\u001c\u0001\u0004A\u0016a\u00043fY\u0016$Xm\u00148ESN\f'\r\\3)\u000fm\t9$a\u0012\u000282\"\u00111JA'Q\rY\u0012\u0011K\u0001\u001di\u0016\u001cH/\u00138WC2LGMU3n_R,7i\u001c8gS\u001e\u001c\u0018J\u001c.L)\r\u0011\u0014q\u0018\u0005\u0007\u0003\u0003d\u0002\u0019A/\u0002\u0013\r|gNZ5h\u0017\u0016L\bf\u0002\u000f\u00028\u0005\u0015\u0017qY\u0001\bgR\u0014\u0018N\\4tY\u0011\tI-!4\"\u0005\u0005-\u0017\u0001\b:f[>$XM\f7pO:\"W\r\\3uK:zgN\f3jg\u0006\u0014G.Z\u0011\u0003\u0003\u001f\fqC]3n_R,g\u0006\\8h]\r|\u0007/\u001f\u0018eSN\f'\r\\3)\u0007q\t\t&\u0001\u0017uKN$H+[7fgR\fW\u000e\u001d\"fM>\u0014X-T1y\u001bN,6/Z:EKB\u0014XmY1uK\u0012\u001cuN\u001c4jO\"\u0012QDN\u0001+i\u0016\u001cHOV1mS\u0012\fG/Z,ji\"lU\r^1eCR\fg+\u001a:tS>t'JY8e'V\u0004\bo\u001c:uQ\tqb\u0007")
public class LogConfigTest {
    @Test
    public void ensureNoStaticInitializationOrderDependency() {
        Assertions.assertNotNull((Object)ServerLogConfigs.LOG_RETENTION_TIME_MILLIS_CONFIG);
        Assertions.assertTrue((boolean)((IterableLike)((TraversableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(LogConfig.configNames()).asScala()).filter((Function1 & Serializable & scala.Serializable)config -> BoxesRunTime.boxToBoolean((boolean)LogConfigTest.$anonfun$ensureNoStaticInitializationOrderDependency$1(config)))).forall((Function1 & Serializable & scala.Serializable)config -> BoxesRunTime.boxToBoolean((boolean)LogConfigTest.$anonfun$ensureNoStaticInitializationOrderDependency$2(config))));
    }

    @Test
    public void testKafkaConfigToProps() {
        long millisInHour = 3600000L;
        long millisInDay = 24L * millisInHour;
        long bytesInGB = 0x40000000L;
        Properties kafkaProps = TestUtils$.MODULE$.createBrokerConfig(0, "", TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18(), TestUtils$.MODULE$.createBrokerConfig$default$19(), TestUtils$.MODULE$.createBrokerConfig$default$20(), TestUtils$.MODULE$.createBrokerConfig$default$21());
        kafkaProps.put("log.roll.hours", "2");
        kafkaProps.put("log.roll.jitter.hours", "2");
        kafkaProps.put("log.retention.hours", "960");
        kafkaProps.put(ServerLogConfigs.LOG_MESSAGE_FORMAT_VERSION_CONFIG, "0.11.0");
        kafkaProps.put("log.local.retention.ms", "2592000000");
        kafkaProps.put("log.local.retention.bytes", "4294967296");
        Map logProps = KafkaConfig$.MODULE$.fromProps(kafkaProps).extractLogConfigMap();
        Assertions.assertEquals((Object)BoxesRunTime.boxToLong((long)(2L * millisInHour)), logProps.get("segment.ms"));
        Assertions.assertEquals((Object)BoxesRunTime.boxToLong((long)(2L * millisInHour)), logProps.get("segment.jitter.ms"));
        Assertions.assertEquals((Object)BoxesRunTime.boxToLong((long)(40L * millisInDay)), logProps.get("retention.ms"));
        Assertions.assertEquals((Object)MetadataVersion.IBP_3_0_IV1.version(), logProps.get("message.format.version"));
        Assertions.assertEquals((Object)BoxesRunTime.boxToLong((long)(30L * millisInDay)), logProps.get("local.retention.ms"));
        Assertions.assertEquals((Object)BoxesRunTime.boxToLong((long)(4L * bytesInGB)), logProps.get("local.retention.bytes"));
    }

    @Test
    public void testFromPropsInvalid() {
        LogConfig.configNames().forEach(name -> {
            if ("unclean.leader.election.enable".equals(name)) {
                this.assertPropertyInvalid((String)name, (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"not a boolean"}));
                return;
            }
            if ("retention.bytes".equals(name)) {
                this.assertPropertyInvalid((String)name, (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"not_a_number"}));
                return;
            }
            if ("retention.ms".equals(name)) {
                this.assertPropertyInvalid((String)name, (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"not_a_number"}));
                return;
            }
            if ("cleanup.policy".equals(name)) {
                this.assertPropertyInvalid((String)name, (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"true", "foobar"}));
                return;
            }
            if ("min.cleanable.dirty.ratio".equals(name)) {
                this.assertPropertyInvalid((String)name, (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"not_a_number", "-0.1", "1.2"}));
                return;
            }
            if ("min.insync.replicas".equals(name)) {
                this.assertPropertyInvalid((String)name, (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"not_a_number", "0", "-1"}));
                return;
            }
            if ("message.format.version".equals(name)) {
                this.assertPropertyInvalid((String)name, (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{""}));
                return;
            }
            if ("remote.storage.enable".equals(name)) {
                this.assertPropertyInvalid((String)name, (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"not_a_boolean"}));
                return;
            }
            if ("local.retention.ms".equals(name)) {
                this.assertPropertyInvalid((String)name, (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"not_a_number", "-3"}));
                return;
            }
            if ("local.retention.bytes".equals(name)) {
                this.assertPropertyInvalid((String)name, (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"not_a_number", "-3"}));
                return;
            }
            if ("compression.gzip.level".equals(name)) {
                this.assertPropertyInvalid((String)name, (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"not_a_number", "-2"}));
                return;
            }
            if ("compression.lz4.level".equals(name)) {
                this.assertPropertyInvalid((String)name, (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"not_a_number", "-1"}));
                return;
            }
            if ("compression.zstd.level".equals(name)) {
                this.assertPropertyInvalid((String)name, (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"not_a_number", "-0.1"}));
                return;
            }
            if ("remote.log.copy.disable".equals(name)) {
                this.assertPropertyInvalid((String)name, (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"not_a_number", "remove", "0"}));
                return;
            }
            if ("remote.log.delete.on.disable".equals(name)) {
                this.assertPropertyInvalid((String)name, (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"not_a_number", "remove", "0"}));
                return;
            }
            this.assertPropertyInvalid((String)name, (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"not_a_number", "-1"}));
        });
    }

    @Test
    public void testInvalidCompactionLagConfig() {
        Properties props = new Properties();
        props.setProperty("max.compaction.lag.ms", "100");
        props.setProperty("min.compaction.lag.ms", "200");
        Assertions.assertThrows(Exception.class, () -> LogConfig.validate((Properties)props));
    }

    @Test
    public void shouldValidateThrottledReplicasConfig() {
        Assertions.assertTrue((boolean)this.isValid("*"));
        Assertions.assertTrue((boolean)this.isValid("* "));
        Assertions.assertTrue((boolean)this.isValid(""));
        Assertions.assertTrue((boolean)this.isValid(" "));
        Assertions.assertTrue((boolean)this.isValid("100:10"));
        Assertions.assertTrue((boolean)this.isValid("100:10,12:10"));
        Assertions.assertTrue((boolean)this.isValid("100:10,12:10,15:1"));
        Assertions.assertTrue((boolean)this.isValid("100:10,12:10,15:1  "));
        Assertions.assertTrue((boolean)this.isValid("100:0,"));
        Assertions.assertFalse((boolean)this.isValid("100"));
        Assertions.assertFalse((boolean)this.isValid("100:"));
        Assertions.assertFalse((boolean)this.isValid("100:0,10"));
        Assertions.assertFalse((boolean)this.isValid("100:0,10:"));
        Assertions.assertFalse((boolean)this.isValid("100:0,10:   "));
        Assertions.assertFalse((boolean)this.isValid("100 :0,10:   "));
        Assertions.assertFalse((boolean)this.isValid("100: 0,10:   "));
        Assertions.assertFalse((boolean)this.isValid("100:0,10 :   "));
        Assertions.assertFalse((boolean)this.isValid("*,100:10"));
        Assertions.assertFalse((boolean)this.isValid("* ,100:10"));
    }

    @Test
    public void testToHtmlTable() {
        String html = LogConfig.configDefCopy().toHtmlTable();
        String expectedConfig = "<td>file.delete.delay.ms</td>";
        Assertions.assertTrue((boolean)html.contains(expectedConfig), (String)new StringBuilder(23).append("Could not find `").append(expectedConfig).append("` in:\n ").append(html).toString());
    }

    @Test
    public void testToHtml() {
        String html = LogConfig.configDefCopy().toHtml(4, key -> new StringBuilder(7).append("prefix_").append((String)key).toString(), Collections.emptyMap());
        String expectedConfig = "<h4><a id=\"file.delete.delay.ms\"></a><a id=\"prefix_file.delete.delay.ms\" href=\"#prefix_file.delete.delay.ms\">file.delete.delay.ms</a></h4>";
        Assertions.assertTrue((boolean)html.contains(expectedConfig), (String)new StringBuilder(23).append("Could not find `").append(expectedConfig).append("` in:\n ").append(html).toString());
    }

    @Test
    public void testToEnrichedRst() {
        String rst = LogConfig.configDefCopy().toEnrichedRst();
        String expectedConfig = "``file.delete.delay.ms``";
        Assertions.assertTrue((boolean)rst.contains(expectedConfig), (String)new StringBuilder(23).append("Could not find `").append(expectedConfig).append("` in:\n ").append(rst).toString());
    }

    @Test
    public void testToRst() {
        String rst = LogConfig.configDefCopy().toRst();
        String expectedConfig = "``file.delete.delay.ms``";
        Assertions.assertTrue((boolean)rst.contains(expectedConfig), (String)new StringBuilder(23).append("Could not find `").append(expectedConfig).append("` in:\n ").append(rst).toString());
    }

    @Test
    public void testGetConfigValue() {
        LogConfig.LogConfigDef configDef = LogConfig.configDefCopy();
        String configNameWithNoServerMapping = "log.foo";
        configDef.define(configNameWithNoServerMapping, ConfigDef.Type.INT, (Object)BoxesRunTime.boxToInteger((int)1), ConfigDef.Importance.MEDIUM, new StringBuilder(4).append(configNameWithNoServerMapping).append(" doc").toString());
        ConfigDef.ConfigKey deleteDelayKey = (ConfigDef.ConfigKey)configDef.configKeys().get("file.delete.delay.ms");
        String deleteDelayServerDefault = configDef.getConfigValue(deleteDelayKey, "Server Default Property");
        Assertions.assertEquals((Object)ServerLogConfigs.LOG_DELETE_DELAY_MS_CONFIG, (Object)deleteDelayServerDefault);
        ConfigDef.ConfigKey keyWithNoServerMapping = (ConfigDef.ConfigKey)configDef.configKeys().get(configNameWithNoServerMapping);
        Assertions.assertNull((Object)configDef.getConfigValue(keyWithNoServerMapping, "Server Default Property"));
    }

    @Test
    public void testOverriddenConfigsAsLoggableString() {
        Properties kafkaProps = TestUtils$.MODULE$.createBrokerConfig(0, "", TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18(), TestUtils$.MODULE$.createBrokerConfig$default$19(), TestUtils$.MODULE$.createBrokerConfig$default$20(), TestUtils$.MODULE$.createBrokerConfig$default$21());
        kafkaProps.put("unknown.broker.password.config", "aaaaa");
        kafkaProps.put(ServerLogConfigs.LOG_RETENTION_BYTES_CONFIG, "50");
        kafkaProps.put("ssl.key.password", "somekeypassword");
        KafkaConfig kafkaConfig = KafkaConfig$.MODULE$.fromProps(kafkaProps);
        Properties topicOverrides = new Properties();
        topicOverrides.setProperty("min.insync.replicas", "2");
        topicOverrides.setProperty("retention.bytes", "100");
        topicOverrides.setProperty("ssl.truststore.password", "sometrustpasswrd");
        topicOverrides.setProperty("unknown.topic.password.config", "bbbb");
        LogConfig logConfig = LogConfig.fromProps((Map)kafkaConfig.extractLogConfigMap(), (Properties)topicOverrides);
        Assertions.assertEquals((Object)"{min.insync.replicas=2, retention.bytes=100, ssl.truststore.password=(redacted), unknown.topic.password.config=(redacted)}", (Object)logConfig.overriddenConfigsAsLoggableString());
    }

    private boolean isValid(String configValue) {
        try {
            ThrottledReplicaListValidator.ensureValidString((String)"", (String)configValue);
            return true;
        }
        catch (ConfigException configException) {
            return false;
        }
    }

    private void assertPropertyInvalid(String name, Seq<Object> values) {
        values.foreach((Function1 & Serializable & scala.Serializable)value -> {
            Properties props = new Properties();
            props.setProperty(name, value.toString());
            return (Exception)Assertions.assertThrows(Exception.class, () -> new LogConfig((Map)props), () -> new StringBuilder(27).append("Property ").append(name).append(" should not allow ").append(value).toString());
        });
    }

    @Test
    public void testLocalLogRetentionDerivedProps() {
        Properties props = new Properties();
        int retentionBytes = 1024;
        long retentionMs = 1000L;
        props.put("retention.bytes", Integer.toString(retentionBytes));
        props.put("retention.ms", Long.toString(retentionMs));
        LogConfig logConfig = new LogConfig((Map)props);
        Assertions.assertEquals((long)retentionMs, (long)logConfig.localRetentionMs());
        Assertions.assertEquals((long)retentionBytes, (long)logConfig.localRetentionBytes());
    }

    @Test
    public void testLocalLogRetentionDerivedDefaultProps() {
        LogConfig logConfig = new LogConfig((Map)new Properties());
        Assertions.assertEquals((long)604800000L, (long)logConfig.localRetentionMs());
        Assertions.assertEquals((long)-1L, (long)logConfig.localRetentionBytes());
    }

    @Test
    public void testLocalLogRetentionProps() {
        Properties props = new Properties();
        int localRetentionMs = 500;
        int localRetentionBytes = 1000;
        props.put("retention.bytes", Integer.toString(2000));
        props.put("retention.ms", Integer.toString(1000));
        props.put("local.retention.ms", Integer.toString(localRetentionMs));
        props.put("local.retention.bytes", Integer.toString(localRetentionBytes));
        LogConfig logConfig = new LogConfig((Map)props);
        Assertions.assertEquals((long)localRetentionMs, (long)logConfig.localRetentionMs());
        Assertions.assertEquals((long)localRetentionBytes, (long)logConfig.localRetentionBytes());
    }

    @Test
    public void testInvalidLocalLogRetentionProps() {
        this.doTestInvalidLocalLogRetentionProps(-3L, 10, 2, 500L);
        this.doTestInvalidLocalLogRetentionProps(500L, -3, 2, 1000L);
        this.doTestInvalidLocalLogRetentionProps(2000L, 2, 100, 1000L);
        this.doTestInvalidLocalLogRetentionProps(500L, 200, 100, 1000L);
        this.doTestInvalidLocalLogRetentionProps(-1L, 200, 100, 1000L);
        this.doTestInvalidLocalLogRetentionProps(2000L, -1, 100, 1000L);
    }

    private ConfigException doTestInvalidLocalLogRetentionProps(long localRetentionMs, int localRetentionBytes, int retentionBytes, long retentionMs) {
        Properties kafkaProps = TestUtils$.MODULE$.createDummyBrokerConfig();
        kafkaProps.put("remote.log.storage.system.enable", "true");
        KafkaConfig kafkaConfig = KafkaConfig$.MODULE$.fromProps(kafkaProps);
        Properties props = new Properties();
        props.put("remote.storage.enable", "true");
        props.put("retention.bytes", Integer.toString(retentionBytes));
        props.put("retention.ms", Long.toString(retentionMs));
        props.put("local.retention.ms", Long.toString(localRetentionMs));
        props.put("local.retention.bytes", Integer.toString(localRetentionBytes));
        return (ConfigException)Assertions.assertThrows(ConfigException.class, () -> LogConfig.validate(Collections.emptyMap(), (Properties)props, (Map)kafkaConfig.extractLogConfigMap(), (boolean)kafkaConfig.remoteLogManagerConfig().isRemoteStorageSystemEnabled(), (boolean)true));
    }

    @Test
    public void testEnableRemoteLogStorageOnCompactedTopic() {
        Properties kafkaProps = TestUtils$.MODULE$.createDummyBrokerConfig();
        kafkaProps.put("remote.log.storage.system.enable", "true");
        KafkaConfig kafkaConfig = KafkaConfig$.MODULE$.fromProps(kafkaProps);
        Properties logProps = new Properties();
        logProps.put("cleanup.policy", "delete");
        logProps.put("remote.storage.enable", "true");
        LogConfig.validate(Collections.emptyMap(), (Properties)logProps, (Map)kafkaConfig.extractLogConfigMap(), (boolean)kafkaConfig.remoteLogManagerConfig().isRemoteStorageSystemEnabled(), (boolean)true);
        logProps.put("cleanup.policy", "compact");
        Assertions.assertThrows(ConfigException.class, () -> LogConfig.validate(Collections.emptyMap(), (Properties)logProps, (Map)kafkaConfig.extractLogConfigMap(), (boolean)kafkaConfig.remoteLogManagerConfig().isRemoteStorageSystemEnabled(), (boolean)true));
        logProps.put("cleanup.policy", "delete,compact");
        Assertions.assertThrows(ConfigException.class, () -> LogConfig.validate(Collections.emptyMap(), (Properties)logProps, (Map)kafkaConfig.extractLogConfigMap(), (boolean)kafkaConfig.remoteLogManagerConfig().isRemoteStorageSystemEnabled(), (boolean)true));
        logProps.put("cleanup.policy", "compact,delete");
        Assertions.assertThrows(ConfigException.class, () -> LogConfig.validate(Collections.emptyMap(), (Properties)logProps, (Map)kafkaConfig.extractLogConfigMap(), (boolean)kafkaConfig.remoteLogManagerConfig().isRemoteStorageSystemEnabled(), (boolean)true));
    }

    @ParameterizedTest(name="testEnableRemoteLogStorage with sysRemoteStorageEnabled: {0}")
    @ValueSource(booleans={true, false})
    public void testEnableRemoteLogStorage(boolean sysRemoteStorageEnabled) {
        Properties kafkaProps = TestUtils$.MODULE$.createDummyBrokerConfig();
        kafkaProps.put("remote.log.storage.system.enable", Boolean.toString(sysRemoteStorageEnabled));
        KafkaConfig kafkaConfig = KafkaConfig$.MODULE$.fromProps(kafkaProps);
        Properties logProps = new Properties();
        logProps.put("remote.storage.enable", "true");
        if (sysRemoteStorageEnabled) {
            LogConfig.validate(Collections.emptyMap(), (Properties)logProps, (Map)kafkaConfig.extractLogConfigMap(), (boolean)kafkaConfig.remoteLogManagerConfig().isRemoteStorageSystemEnabled(), (boolean)true);
            return;
        }
        Assertions.assertTrue((boolean)((ConfigException)Assertions.assertThrows(ConfigException.class, () -> LogConfig.validate(Collections.emptyMap(), (Properties)logProps, (Map)kafkaConfig.extractLogConfigMap(), (boolean)kafkaConfig.remoteLogManagerConfig().isRemoteStorageSystemEnabled(), (boolean)true))).getMessage().contains("Tiered Storage functionality is disabled in the broker"));
    }

    @ParameterizedTest(name="testDisableRemoteLogStorage with wasRemoteStorageEnabled: {0}")
    @ValueSource(booleans={true, false})
    public void testDisableRemoteLogStorage(boolean wasRemoteStorageEnabled) {
        Properties kafkaProps = TestUtils$.MODULE$.createDummyBrokerConfig();
        kafkaProps.put("remote.log.storage.system.enable", "true");
        KafkaConfig kafkaConfig = KafkaConfig$.MODULE$.fromProps(kafkaProps);
        Properties logProps = new Properties();
        logProps.put("remote.storage.enable", "false");
        if (wasRemoteStorageEnabled) {
            Assertions.assertTrue((boolean)((InvalidConfigurationException)Assertions.assertThrows(InvalidConfigurationException.class, () -> LogConfig.validate(Collections.singletonMap("remote.storage.enable", "true"), (Properties)logProps, (Map)kafkaConfig.extractLogConfigMap(), (boolean)kafkaConfig.remoteLogManagerConfig().isRemoteStorageSystemEnabled(), (boolean)false))).getMessage().contains("It is invalid to disable remote storage without deleting remote data. If you want to keep the remote data and turn to read only, please set `remote.storage.enable=true,remote.log.copy.disable=true`. If you want to disable remote storage and delete all remote data, please set `remote.storage.enable=false,remote.log.delete.on.disable=true`."));
            logProps.put("remote.log.delete.on.disable", "true");
            LogConfig.validate(Collections.singletonMap("remote.storage.enable", "true"), (Properties)logProps, (Map)kafkaConfig.extractLogConfigMap(), (boolean)kafkaConfig.remoteLogManagerConfig().isRemoteStorageSystemEnabled(), (boolean)false);
            return;
        }
        LogConfig.validate(Collections.emptyMap(), (Properties)logProps, (Map)kafkaConfig.extractLogConfigMap(), (boolean)kafkaConfig.remoteLogManagerConfig().isRemoteStorageSystemEnabled(), (boolean)true);
        LogConfig.validate(Collections.singletonMap("remote.storage.enable", "false"), (Properties)logProps, (Map)kafkaConfig.extractLogConfigMap(), (boolean)kafkaConfig.remoteLogManagerConfig().isRemoteStorageSystemEnabled(), (boolean)false);
    }

    @ParameterizedTest(name="testTopicCreationWithInvalidRetentionTime with sysRemoteStorageEnabled: {0}")
    @ValueSource(booleans={true, false})
    public void testTopicCreationWithInvalidRetentionTime(boolean sysRemoteStorageEnabled) {
        Properties kafkaProps = TestUtils$.MODULE$.createDummyBrokerConfig();
        kafkaProps.put("remote.log.storage.system.enable", Boolean.toString(sysRemoteStorageEnabled));
        kafkaProps.put(ServerLogConfigs.LOG_RETENTION_TIME_MILLIS_CONFIG, "1000");
        kafkaProps.put("log.local.retention.ms", "900");
        KafkaConfig kafkaConfig = KafkaConfig$.MODULE$.fromProps(kafkaProps);
        Properties logProps = new Properties();
        logProps.put("remote.storage.enable", Boolean.toString(sysRemoteStorageEnabled));
        logProps.put("retention.ms", "500");
        if (sysRemoteStorageEnabled) {
            Assertions.assertTrue((boolean)((ConfigException)Assertions.assertThrows(ConfigException.class, () -> LogConfig.validate(Collections.emptyMap(), (Properties)logProps, (Map)kafkaConfig.extractLogConfigMap(), (boolean)kafkaConfig.remoteLogManagerConfig().isRemoteStorageSystemEnabled(), (boolean)true))).getMessage().contains("local.retention.ms"));
            return;
        }
        LogConfig.validate(Collections.emptyMap(), (Properties)logProps, (Map)kafkaConfig.extractLogConfigMap(), (boolean)kafkaConfig.remoteLogManagerConfig().isRemoteStorageSystemEnabled(), (boolean)true);
    }

    @ParameterizedTest(name="testTopicCreationWithInvalidRetentionSize with sysRemoteStorageEnabled: {0}")
    @ValueSource(booleans={true, false})
    public void testTopicCreationWithInvalidRetentionSize(boolean sysRemoteStorageEnabled) {
        Properties props = TestUtils$.MODULE$.createDummyBrokerConfig();
        props.put("remote.log.storage.system.enable", Boolean.toString(sysRemoteStorageEnabled));
        props.put(ServerLogConfigs.LOG_RETENTION_BYTES_CONFIG, "1024");
        props.put("log.local.retention.bytes", "512");
        KafkaConfig kafkaConfig = KafkaConfig$.MODULE$.fromProps(props);
        Properties logProps = new Properties();
        logProps.put("remote.storage.enable", Boolean.toString(sysRemoteStorageEnabled));
        logProps.put("retention.bytes", "128");
        if (sysRemoteStorageEnabled) {
            Assertions.assertTrue((boolean)((ConfigException)Assertions.assertThrows(ConfigException.class, () -> LogConfig.validate(Collections.emptyMap(), (Properties)logProps, (Map)kafkaConfig.extractLogConfigMap(), (boolean)kafkaConfig.remoteLogManagerConfig().isRemoteStorageSystemEnabled(), (boolean)true))).getMessage().contains("local.retention.bytes"));
            return;
        }
        LogConfig.validate(Collections.emptyMap(), (Properties)logProps, (Map)kafkaConfig.extractLogConfigMap(), (boolean)kafkaConfig.remoteLogManagerConfig().isRemoteStorageSystemEnabled(), (boolean)true);
    }

    @ParameterizedTest(name="testValidateBrokerLogConfigs with sysRemoteStorageEnabled: {0}")
    @ValueSource(booleans={true, false})
    public void testValidateBrokerLogConfigs(boolean sysRemoteStorageEnabled) {
        Properties props = TestUtils$.MODULE$.createDummyBrokerConfig();
        props.put("remote.log.storage.system.enable", Boolean.toString(sysRemoteStorageEnabled));
        props.put(ServerLogConfigs.LOG_RETENTION_BYTES_CONFIG, "1024");
        props.put("log.local.retention.bytes", "2048");
        KafkaConfig kafkaConfig = KafkaConfig$.MODULE$.fromProps(props);
        if (sysRemoteStorageEnabled) {
            Assertions.assertTrue((boolean)((ConfigException)Assertions.assertThrows(ConfigException.class, () -> LogConfig.validateBrokerLogConfigValues((Map)kafkaConfig.extractLogConfigMap(), (boolean)kafkaConfig.remoteLogManagerConfig().isRemoteStorageSystemEnabled()))).getMessage().contains("local.retention.bytes"));
            return;
        }
        LogConfig.validateBrokerLogConfigValues((Map)kafkaConfig.extractLogConfigMap(), (boolean)kafkaConfig.remoteLogManagerConfig().isRemoteStorageSystemEnabled());
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    public void testValidRemoteLogCopyDisabled(boolean copyDisabled) {
        Properties logProps = new Properties();
        logProps.put("remote.log.copy.disable", Boolean.toString(copyDisabled));
        LogConfig.validate((Properties)logProps);
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    public void testValidRemoteLogDeleteOnDisable(boolean deleteOnDisable) {
        Properties logProps = new Properties();
        logProps.put("remote.log.delete.on.disable", Boolean.toString(deleteOnDisable));
        LogConfig.validate((Properties)logProps);
    }

    @ParameterizedTest
    @ValueSource(strings={"remote.log.delete.on.disable", "remote.log.copy.disable"})
    public void testInValidRemoteConfigsInZK(String configKey) {
        Properties kafkaProps = TestUtils$.MODULE$.createDummyBrokerConfig();
        kafkaProps.put("remote.log.storage.system.enable", "true");
        KafkaConfig kafkaConfig = KafkaConfig$.MODULE$.fromProps(kafkaProps);
        Properties logProps = new Properties();
        logProps.put(configKey, "true");
        Assertions.assertTrue((boolean)((InvalidConfigurationException)Assertions.assertThrows(InvalidConfigurationException.class, () -> LogConfig.validate(Collections.emptyMap(), (Properties)logProps, (Map)kafkaConfig.extractLogConfigMap(), (boolean)true, (boolean)true))).getMessage().contains("It is invalid to set `remote.log.delete.on.disable` or `remote.log.copy.disable` under Zookeeper's mode."));
    }

    @Test
    public void testTimestampBeforeMaxMsUsesDeprecatedConfig() {
        long oneDayInMillis = 86400000L;
        Properties kafkaProps = TestUtils$.MODULE$.createBrokerConfig(0, "", TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18(), TestUtils$.MODULE$.createBrokerConfig$default$19(), TestUtils$.MODULE$.createBrokerConfig$default$20(), TestUtils$.MODULE$.createBrokerConfig$default$21());
        kafkaProps.put(ServerLogConfigs.LOG_MESSAGE_TIMESTAMP_BEFORE_MAX_MS_CONFIG, Long.toString(Long.MAX_VALUE));
        kafkaProps.put(ServerLogConfigs.LOG_MESSAGE_TIMESTAMP_AFTER_MAX_MS_CONFIG, Long.toString(Long.MAX_VALUE));
        kafkaProps.put(ServerLogConfigs.LOG_MESSAGE_TIMESTAMP_DIFFERENCE_MAX_MS_CONFIG, Long.toString(oneDayInMillis));
        Map logProps = KafkaConfig$.MODULE$.fromProps(kafkaProps).extractLogConfigMap();
        Assertions.assertEquals((Object)BoxesRunTime.boxToLong((long)oneDayInMillis), logProps.get("message.timestamp.before.max.ms"));
        Assertions.assertEquals((Object)BoxesRunTime.boxToLong((long)oneDayInMillis), logProps.get("message.timestamp.after.max.ms"));
    }

    @Test
    public void testValidateWithMetadataVersionJbodSupport() {
        LogConfigTest.validate$1(MetadataVersion.IBP_3_6_IV2, false);
        LogConfigTest.validate$1(MetadataVersion.IBP_3_7_IV0, false);
        LogConfigTest.validate$1(MetadataVersion.IBP_3_7_IV2, false);
        Assertions.assertThrows(IllegalArgumentException.class, () -> LogConfigTest.validate$1(MetadataVersion.IBP_3_6_IV2, true));
        Assertions.assertThrows(IllegalArgumentException.class, () -> LogConfigTest.validate$1(MetadataVersion.IBP_3_7_IV0, true));
        LogConfigTest.validate$1(MetadataVersion.IBP_3_7_IV2, true);
    }

    public static final /* synthetic */ boolean $anonfun$ensureNoStaticInitializationOrderDependency$1(String config) {
        return !LogConfig.CONFIGS_WITH_NO_SERVER_DEFAULTS.contains(config);
    }

    public static final /* synthetic */ boolean $anonfun$ensureNoStaticInitializationOrderDependency$2(String config) {
        Optional serverConfigOpt = LogConfig.serverConfigName((String)config);
        return serverConfigOpt.isPresent() && serverConfigOpt.get() != null;
    }

    private static final void validate$1(MetadataVersion metadataVersion, boolean jbodConfig) {
        int x$1 = 0;
        int x$3 = jbodConfig ? 2 : 1;
        boolean x$4 = TestUtils$.MODULE$.createBrokerConfig$default$3();
        boolean x$5 = TestUtils$.MODULE$.createBrokerConfig$default$4();
        int x$6 = TestUtils$.MODULE$.createBrokerConfig$default$5();
        Option<SecurityProtocol> x$7 = TestUtils$.MODULE$.createBrokerConfig$default$6();
        Option<File> x$8 = TestUtils$.MODULE$.createBrokerConfig$default$7();
        Option<Properties> x$9 = TestUtils$.MODULE$.createBrokerConfig$default$8();
        boolean x$10 = TestUtils$.MODULE$.createBrokerConfig$default$9();
        boolean x$11 = TestUtils$.MODULE$.createBrokerConfig$default$10();
        int x$12 = TestUtils$.MODULE$.createBrokerConfig$default$11();
        boolean x$13 = TestUtils$.MODULE$.createBrokerConfig$default$12();
        int x$14 = TestUtils$.MODULE$.createBrokerConfig$default$13();
        boolean x$15 = TestUtils$.MODULE$.createBrokerConfig$default$14();
        int x$16 = TestUtils$.MODULE$.createBrokerConfig$default$15();
        Option<String> x$17 = TestUtils$.MODULE$.createBrokerConfig$default$16();
        boolean x$18 = TestUtils$.MODULE$.createBrokerConfig$default$18();
        int x$19 = TestUtils$.MODULE$.createBrokerConfig$default$19();
        short x$20 = TestUtils$.MODULE$.createBrokerConfig$default$20();
        boolean x$21 = TestUtils$.MODULE$.createBrokerConfig$default$21();
        KafkaConfig$.MODULE$.fromProps(TestUtils$.MODULE$.createBrokerConfig(x$1, null, x$4, x$5, x$6, x$7, x$8, x$9, x$10, x$11, x$12, x$13, x$14, x$15, x$16, x$17, x$3, x$18, x$19, x$20, x$21)).validateWithMetadataVersion(metadataVersion);
    }
}

