/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Properties;
import kafka.network.SocketServer;
import kafka.server.AlterCredentialsTest;
import kafka.server.BaseRequestTest;
import kafka.utils.TestInfoUtils$;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.admin.ScramMechanism;
import org.apache.kafka.common.message.AlterUserScramCredentialsRequestData;
import org.apache.kafka.common.message.AlterUserScramCredentialsResponseData;
import org.apache.kafka.common.message.DescribeUserScramCredentialsRequestData;
import org.apache.kafka.common.message.DescribeUserScramCredentialsResponseData;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.AlterUserScramCredentialsRequest;
import org.apache.kafka.common.requests.AlterUserScramCredentialsResponse;
import org.apache.kafka.common.requests.DescribeUserScramCredentialsRequest;
import org.apache.kafka.common.requests.DescribeUserScramCredentialsResponse;
import org.apache.kafka.server.common.MetadataVersion;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInfo;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;
import scala.Function1;
import scala.Predef$;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichLong$;

@ScalaSignature(bytes="\u0006\u0001\tmf\u0001\u0002\u0016,\u0001ABQ!\u000e\u0001\u0005\u0002YBq\u0001\u000f\u0001A\u0002\u0013E\u0011\bC\u0004G\u0001\u0001\u0007I\u0011C$\t\rA\u0003\u0001\u0015)\u0003;\u0011\u0015\t\u0006\u0001\"\u0015:\u0011\u0015\u0011\u0006\u0001\"\u0011T\u0011\u0015!\u0007\u0001\"\u0011f\u0011\u001d)\bA1A\u0005\nYDa! \u0001!\u0002\u00139\bb\u0002@\u0001\u0005\u0004%IA\u001e\u0005\u0007\u007f\u0002\u0001\u000b\u0011B<\t\u0013\u0005\u0005\u0001A1A\u0005\n\u0005\r\u0001\u0002CA\t\u0001\u0001\u0006I!!\u0002\t\u0013\u0005M\u0001A1A\u0005\n\u0005\r\u0001\u0002CA\u000b\u0001\u0001\u0006I!!\u0002\t\u0013\u0005]\u0001A1A\u0005\n\u0005\r\u0001\u0002CA\r\u0001\u0001\u0006I!!\u0002\t\u0013\u0005m\u0001A1A\u0005\n\u0005\r\u0001\u0002CA\u000f\u0001\u0001\u0006I!!\u0002\t\u000f\u0005}\u0001\u0001\"\u0001\u0002\"!9\u00111\r\u0001\u0005\u0002\u0005\u0015\u0004bBA8\u0001\u0011\u0005\u0011\u0011\u000f\u0005\b\u0003w\u0002A\u0011AA?\u0011\u001d\t9\t\u0001C\u0001\u0003\u0013Cq!a%\u0001\t\u0003\t)\nC\u0004\u0002 \u0002!\t!!)\t\u000f\u0005-\u0006\u0001\"\u0001\u0002.\"9\u0011q\u0017\u0001\u0005\u0002\u0005e\u0006bBAb\u0001\u0011\u0005\u0011Q\u0019\u0005\b\u0003'\u0004A\u0011BAk\u0011%\ty\u0010AI\u0001\n\u0013\u0011\t\u0001C\u0004\u0003\u0018\u0001!IA!\u0007\t\u0013\t-\u0002!%A\u0005\n\t\u0005\u0001b\u0002B\u0017\u0001\u0011%!q\u0006\u0005\b\u0005k\u0002A\u0011\u0002B<\u0011\u001d\u0011Y\b\u0001C\u0005\u0005{BqA!\"\u0001\t\u0013\u00119\tC\u0004\u0003\n\u0002!IAa#\t\u000f\tE\u0005\u0001\"\u0003\u0003\u0014\"9!\u0011\u0016\u0001\u0005\n\t-\u0006b\u0002BY\u0001\u0011%!1\u0017\u0002%\u00032$XM]+tKJ\u001c6M]1n\u0007J,G-\u001a8uS\u0006d7OU3rk\u0016\u001cH\u000fV3ti*\u0011A&L\u0001\u0007g\u0016\u0014h/\u001a:\u000b\u00039\nQa[1gW\u0006\u001c\u0001a\u0005\u0002\u0001cA\u0011!gM\u0007\u0002W%\u0011Ag\u000b\u0002\u0010\u0005\u0006\u001cXMU3rk\u0016\u001cH\u000fV3ti\u00061A(\u001b8jiz\"\u0012a\u000e\t\u0003e\u0001\t1\u0003^3ti6+G/\u00193bi\u00064VM]:j_:,\u0012A\u000f\t\u0003w\u0011k\u0011\u0001\u0010\u0006\u0003{y\naaY8n[>t'B\u0001\u0017@\u0015\tq\u0003I\u0003\u0002B\u0005\u00061\u0011\r]1dQ\u0016T\u0011aQ\u0001\u0004_J<\u0017BA#=\u0005=iU\r^1eCR\fg+\u001a:tS>t\u0017a\u0006;fgRlU\r^1eCR\fg+\u001a:tS>tw\fJ3r)\tAe\n\u0005\u0002J\u00196\t!JC\u0001L\u0003\u0015\u00198-\u00197b\u0013\ti%J\u0001\u0003V]&$\bbB(\u0004\u0003\u0003\u0005\rAO\u0001\u0004q\u0012\n\u0014\u0001\u0006;fgRlU\r^1eCR\fg+\u001a:tS>t\u0007%A\bnKR\fG-\u0019;b-\u0016\u00148/[8o\u0003\u0015\u0019X\r^+q)\tAE\u000bC\u0003V\r\u0001\u0007a+\u0001\u0005uKN$\u0018J\u001c4p!\t9f,D\u0001Y\u0015\tI&,A\u0002ba&T!a\u0017/\u0002\u000f),\b/\u001b;fe*\u0011QLQ\u0001\u0006UVt\u0017\u000e^\u0005\u0003?b\u0013\u0001\u0002V3ti&sgm\u001c\u0015\u0003\r\u0005\u0004\"a\u00162\n\u0005\rD&A\u0003\"fM>\u0014X-R1dQ\u000612N]1gi\u000e{g\u000e\u001e:pY2,'oQ8oM&<7\u000f\u0006\u0002giB\u0019qM\u001b7\u000e\u0003!T!!\u001b&\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0002lQ\n\u00191+Z9\u0011\u00055\u0014X\"\u00018\u000b\u0005=\u0004\u0018\u0001B;uS2T\u0011!]\u0001\u0005U\u00064\u0018-\u0003\u0002t]\nQ\u0001K]8qKJ$\u0018.Z:\t\u000bU;\u0001\u0019\u0001,\u0002'M\fG\u000e^3e!\u0006\u001c8o^8sI\nKH/Z:\u0016\u0003]\u00042!\u0013={\u0013\tI(JA\u0003BeJ\f\u0017\u0010\u0005\u0002Jw&\u0011AP\u0013\u0002\u0005\u0005f$X-\u0001\u000btC2$X\r\u001a)bgN<xN\u001d3CsR,7\u000fI\u0001\ng\u0006dGOQ=uKN\f!b]1mi\nKH/Z:!\u0003\u0015)8/\u001a:2+\t\t)\u0001\u0005\u0003\u0002\b\u00055QBAA\u0005\u0015\r\tY\u0001]\u0001\u0005Y\u0006tw-\u0003\u0003\u0002\u0010\u0005%!AB*ue&tw-\u0001\u0004vg\u0016\u0014\u0018\u0007I\u0001\u0006kN,'OM\u0001\u0007kN,'O\r\u0011\u0002\u000bU\u001cXM]\u001a\u0002\rU\u001cXM]\u001a!\u0003-)hn\u001b8po:,6/\u001a:\u0002\u0019Ut7N\\8x]V\u001bXM\u001d\u0011\u0002!Q,7\u000f^!mi\u0016\u0014hj\u001c;iS:<Gc\u0001%\u0002$!9\u0011Q\u0005\u000bA\u0002\u0005\u001d\u0012AB9v_J,X\u000e\u0005\u0003\u0002*\u0005]b\u0002BA\u0016\u0003g\u00012!!\fK\u001b\t\tyCC\u0002\u00022=\na\u0001\u0010:p_Rt\u0014bAA\u001b\u0015\u00061\u0001K]3eK\u001aLA!a\u0004\u0002:)\u0019\u0011Q\u0007&)\u000fQ\ti$!\u0014\u0002PA!\u0011qHA%\u001b\t\t\tE\u0003\u0003\u0002D\u0005\u0015\u0013\u0001\u00039s_ZLG-\u001a:\u000b\u0007\u0005\u001d#,\u0001\u0004qCJ\fWn]\u0005\u0005\u0003\u0017\n\tEA\u0006WC2,XmU8ve\u000e,\u0017aB:ue&twm\u001d\u0017\u0005\u0003#\n)&\t\u0002\u0002T\u0005)1N]1gi\u0006\u0012\u0011qK\u0001\u0003u.D3\u0001FA.!\u0011\ti&a\u0018\u000e\u0005\u0005\u0015\u0013\u0002BA1\u0003\u000b\u0012\u0011\u0003U1sC6,G/\u001a:ju\u0016$G+Z:u\u0003]!Xm\u001d;BYR,'oU1nKRC\u0017N\\4Uo&\u001cW\rF\u0002I\u0003OBq!!\n\u0016\u0001\u0004\t9\u0003K\u0004\u0016\u0003{\ti%a\u001b-\t\u0005E\u0013Q\u000b\u0015\u0004+\u0005m\u0013A\u0005;fgR\fE\u000e^3s\u000b6\u0004H/_+tKJ$2\u0001SA:\u0011\u001d\t)C\u0006a\u0001\u0003OAsAFA\u001f\u0003\u001b\n9\b\f\u0003\u0002R\u0005U\u0003f\u0001\f\u0002\\\u0005IB/Z:u\u00032$XM]+oW:|wO\\'fG\"\fg.[:n)\rA\u0015q\u0010\u0005\b\u0003K9\u0002\u0019AA\u0014Q\u001d9\u0012QHA'\u0003\u0007cC!!\u0015\u0002V!\u001aq#a\u0017\u00023Q,7\u000f^!mi\u0016\u0014Hk\\8GK^LE/\u001a:bi&|gn\u001d\u000b\u0004\u0011\u0006-\u0005bBA\u00131\u0001\u0007\u0011q\u0005\u0015\b1\u0005u\u0012QJAHY\u0011\t\t&!\u0016)\u0007a\tY&\u0001\u000euKN$\u0018\t\u001c;feR{w.T1os&#XM]1uS>t7\u000fF\u0002I\u0003/Cq!!\n\u001a\u0001\u0004\t9\u0003K\u0004\u001a\u0003{\ti%a'-\t\u0005E\u0013Q\u000b\u0015\u00043\u0005m\u0013a\t;fgR$U\r\\3uKN{W.\u001a;iS:<G\u000b[1u\t>,7OT8u\u000bbL7\u000f\u001e\u000b\u0004\u0011\u0006\r\u0006bBA\u00135\u0001\u0007\u0011q\u0005\u0015\b5\u0005u\u0012QJATY\u0011\t\t&!\u0016)\u0007i\tY&\u0001\fuKN$\u0018\t\u001c;fe:{GoQ8oiJ|G\u000e\\3s)\u0005A\u0005fA\u000e\u00022B\u0019q+a-\n\u0007\u0005U\u0006L\u0001\u0003UKN$\u0018\u0001\u0006;fgR\fE\u000e^3s\u0003:$G)Z:de&\u0014W\rF\u0002I\u0003wCq!!\n\u001d\u0001\u0004\t9\u0003K\u0004\u001d\u0003{\ti%a0-\t\u0005E\u0013Q\u000b\u0015\u00049\u0005m\u0013!\u0007;fgRlU\r^1eCR\fg+\u001a:tS>tGk\\8M_^$2\u0001SAd\u0011\u001d\t)#\ba\u0001\u0003OAs!HA\u001f\u0003\u001b\nY\r\f\u0002\u0002N\u0006\u0012\u0011qZ\u0001\u000eWJ\fg\r^\u0017J\u0005B{6g\u0018\u001b)\u0007u\tY&\u0001\u0013tK:$\u0017\t\u001c;feV\u001bXM]*de\u0006l7I]3eK:$\u0018.\u00197t%\u0016\fX/Z:u)\u0019\t9.!:\u0002pB!\u0011\u0011\\Aq\u001b\t\tYN\u0003\u0003\u0002^\u0006}\u0017\u0001\u0003:fcV,7\u000f^:\u000b\u0005uz\u0014\u0002BAr\u00037\u0014\u0011%\u00117uKJ,6/\u001a:TGJ\fWn\u0011:fI\u0016tG/[1mgJ+7\u000f]8og\u0016Dq!a:\u001f\u0001\u0004\tI/A\u0004sKF,Xm\u001d;\u0011\t\u0005e\u00171^\u0005\u0005\u0003[\fYN\u0001\u0011BYR,'/V:feN\u001b'/Y7De\u0016$WM\u001c;jC2\u001c(+Z9vKN$\b\"CAy=A\u0005\t\u0019AAz\u00031\u0019xnY6fiN+'O^3s!\u0011\t)0a?\u000e\u0005\u0005](bAA}[\u00059a.\u001a;x_J\\\u0017\u0002BA\u007f\u0003o\u0014AbU8dW\u0016$8+\u001a:wKJ\faf]3oI\u0006cG/\u001a:Vg\u0016\u00148k\u0019:b[\u000e\u0013X\rZ3oi&\fGn\u001d*fcV,7\u000f\u001e\u0013eK\u001a\fW\u000f\u001c;%eU\u0011!1\u0001\u0016\u0005\u0003g\u0014)a\u000b\u0002\u0003\bA!!\u0011\u0002B\n\u001b\t\u0011YA\u0003\u0003\u0003\u000e\t=\u0011!C;oG\",7m[3e\u0015\r\u0011\tBS\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002\u0002B\u000b\u0005\u0017\u0011\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u0003\u001d\u001aXM\u001c3EKN\u001c'/\u001b2f+N,'oU2sC6\u001c%/\u001a3f]RL\u0017\r\\:SKF,Xm\u001d;\u0015\r\tm!\u0011\u0005B\u0015!\u0011\tIN!\b\n\t\t}\u00111\u001c\u0002%\t\u0016\u001c8M]5cKV\u001bXM]*de\u0006l7I]3eK:$\u0018.\u00197t%\u0016\u001c\bo\u001c8tK\"9\u0011q\u001d\u0011A\u0002\t\r\u0002\u0003BAm\u0005KIAAa\n\u0002\\\n\u0019C)Z:de&\u0014W-V:feN\u001b'/Y7De\u0016$WM\u001c;jC2\u001c(+Z9vKN$\b\"CAyAA\u0005\t\u0019AAz\u0003E\u001aXM\u001c3EKN\u001c'/\u001b2f+N,'oU2sC6\u001c%/\u001a3f]RL\u0017\r\\:SKF,Xm\u001d;%I\u00164\u0017-\u001e7uII\n\u0011e\u00195fG.\fE\u000e\\#se>\u00148/\u00117uKJLgnZ\"sK\u0012,g\u000e^5bYN$r\u0001\u0013B\u0019\u0005C\u0012\t\bC\u0004\u00034\t\u0002\rA!\u000e\u0002\u001dI,7/\u001e7ugR{7\t[3dWB)QNa\u000e\u0003<%\u0019!\u0011\b8\u0003\t1K7\u000f\u001e\t\u0005\u0005{\u0011YF\u0004\u0003\u0003@\tUc\u0002\u0002B!\u0005#rAAa\u0011\u0003P9!!Q\tB'\u001d\u0011\u00119Ea\u0013\u000f\t\u00055\"\u0011J\u0005\u0002\u0007&\u0011\u0011IQ\u0005\u0003]\u0001K!!P \n\t\tM\u0013q\\\u0001\b[\u0016\u001c8/Y4f\u0013\u0011\u00119F!\u0017\u0002K\u0005cG/\u001a:Vg\u0016\u00148k\u0019:b[\u000e\u0013X\rZ3oi&\fGn\u001d*fgB|gn]3ECR\f'\u0002\u0002B*\u0003?LAA!\u0018\u0003`\ty\u0012\t\u001c;feV\u001bXM]*de\u0006l7I]3eK:$\u0018.\u00197t%\u0016\u001cX\u000f\u001c;\u000b\t\t]#\u0011\f\u0005\b\u0005G\u0012\u0003\u0019\u0001B3\u00035)\u0007\u0010]3di\u0016$WI\u001d:peB!!q\rB7\u001b\t\u0011IG\u0003\u0003\u0003l\u0005}\u0017\u0001\u00039s_R|7m\u001c7\n\t\t=$\u0011\u000e\u0002\u0007\u000bJ\u0014xN]:\t\u000f\tM$\u00051\u0001\u0002(\u0005Q1m\u001c8uKb$Xj]4\u0002A\rDWmY6O_\u0016\u0013(o\u001c:t\u00032$XM]5oO\u000e\u0013X\rZ3oi&\fGn\u001d\u000b\u0004\u0011\ne\u0004b\u0002B\u001aG\u0001\u0007!QG\u0001\u001fG\",7m[+tKJ\f\u0005\u000f]3beNLe.\u00117uKJ\u0014Vm];miN$R\u0001\u0013B@\u0005\u0003CqAa\r%\u0001\u0004\u0011)\u0004C\u0004\u0003\u0004\u0012\u0002\r!a\n\u0002\tU\u001cXM]\u0001(I\u0016\u001c8M]5cK\u0006cGnV5uQ:{Gk\u001c9MKZ,G.\u0012:s_J\u001cuN\u001c4je6,G\r\u0006\u0002\u0003\u001c\u0005I3\r[3dW:{Gk\u001c9MKZ,G.\u0012:s_J$Um]2sS\nLgnZ\"sK\u0012,g\u000e^5bYN$2\u0001\u0013BG\u0011\u001d\u0011yI\na\u0001\u00057\tqB]3ta>t7/\u001a+p\u0007\",7m[\u0001\u001bG\",7m[+tKJD\u0015m\u001d+x_\u000e\u0013X\rZ3oi&\fGn\u001d\u000b\u0006\u0011\nU%q\u0015\u0005\b\u0005g9\u0003\u0019\u0001BL!\u0015i'q\u0007BM!\u0011\u0011YJ!)\u000f\t\t}\"QT\u0005\u0005\u0005?\u0013I&\u0001\u0015EKN\u001c'/\u001b2f+N,'oU2sC6\u001c%/\u001a3f]RL\u0017\r\\:SKN\u0004xN\\:f\t\u0006$\u0018-\u0003\u0003\u0003$\n\u0015&A\t#fg\u000e\u0014\u0018NY3Vg\u0016\u00148k\u0019:b[\u000e\u0013X\rZ3oi&\fGn\u001d*fgVdGO\u0003\u0003\u0003 \ne\u0003b\u0002BBO\u0001\u0007\u0011qE\u0001-G\",7m\u001b$peNKgn\u001a7f'\"\fW'\r\u001aJi\u0016\u0014\u0018\r^5p]ND\u0014'\u000f\u001aDe\u0016$WM\u001c;jC2$R\u0001\u0013BW\u0005_CqAa\r)\u0001\u0004\u00119\nC\u0004\u0003\u0004\"\u0002\r!a\n\u0002+\rDWmY6EKN\u001c'/\u001b2f\r>\u0014XI\u001d:peR9\u0001J!.\u00038\ne\u0006b\u0002B\u001aS\u0001\u0007!q\u0013\u0005\b\u0005\u0007K\u0003\u0019AA\u0014\u0011\u001d\u0011\u0019'\u000ba\u0001\u0005K\u0002")
public class AlterUserScramCredentialsRequestTest
extends BaseRequestTest {
    private MetadataVersion testMetadataVersion = MetadataVersion.latestTesting();
    private final byte[] saltedPasswordBytes = "saltedPassword".getBytes(StandardCharsets.UTF_8);
    private final byte[] saltBytes = "salt".getBytes(StandardCharsets.UTF_8);
    private final String user1;
    private final String user2;
    private final String user3;
    private final String unknownUser;

    public MetadataVersion testMetadataVersion() {
        return this.testMetadataVersion;
    }

    public void testMetadataVersion_$eq(MetadataVersion x$1) {
        this.testMetadataVersion = x$1;
    }

    @Override
    public MetadataVersion metadataVersion() {
        return this.testMetadataVersion();
    }

    @Override
    @BeforeEach
    public void setUp(TestInfo testInfo) {
        if (TestInfoUtils$.MODULE$.isKRaft(testInfo)) {
            this.serverConfig().setProperty("authorizer.class.name", AlterCredentialsTest.TestStandardAuthorizer.class.getName());
            if (testInfo.getDisplayName().contains("quorum=kraft-IBP_3_4")) {
                this.testMetadataVersion_$eq(MetadataVersion.IBP_3_4_IV0);
            }
        } else {
            this.serverConfig().setProperty("authorizer.class.name", AlterCredentialsTest.TestAuthorizer.class.getName());
        }
        this.serverConfig().setProperty("principal.builder.class", AlterCredentialsTest.TestPrincipalBuilderReturningAuthorized.class.getName());
        this.serverConfig().setProperty("controlled.shutdown.enable", "false");
        super.setUp(testInfo);
    }

    @Override
    public Seq<Properties> kraftControllerConfigs(TestInfo testInfo) {
        Seq<Properties> controllerConfigs = super.kraftControllerConfigs(testInfo);
        ((Properties)controllerConfigs.head()).setProperty("authorizer.class.name", AlterCredentialsTest.TestStandardAuthorizer.class.getName());
        ((Properties)controllerConfigs.head()).setProperty("principal.builder.class", AlterCredentialsTest.TestPrincipalBuilderReturningAuthorized.class.getName());
        return controllerConfigs;
    }

    private byte[] saltedPasswordBytes() {
        return this.saltedPasswordBytes;
    }

    private byte[] saltBytes() {
        return this.saltBytes;
    }

    private String user1() {
        return this.user1;
    }

    private String user2() {
        return this.user2;
    }

    private String user3() {
        return this.user3;
    }

    private String unknownUser() {
        return this.unknownUser;
    }

    @ParameterizedTest
    @ValueSource(strings={"kraft", "zk"})
    public void testAlterNothing(String quorum) {
        AlterUserScramCredentialsRequest request = (AlterUserScramCredentialsRequest)new AlterUserScramCredentialsRequest.Builder(new AlterUserScramCredentialsRequestData().setDeletions(new ArrayList()).setUpsertions(new ArrayList())).build();
        java.util.List results = this.sendAlterUserScramCredentialsRequest(request, this.sendAlterUserScramCredentialsRequest$default$2()).data().results();
        Assertions.assertEquals((int)0, (int)results.size());
    }

    @ParameterizedTest
    @ValueSource(strings={"kraft", "zk"})
    public void testAlterSameThingTwice(String quorum) {
        AlterUserScramCredentialsRequestData.ScramCredentialDeletion deletion1 = new AlterUserScramCredentialsRequestData.ScramCredentialDeletion().setName(this.user1()).setMechanism(ScramMechanism.SCRAM_SHA_256.type());
        AlterUserScramCredentialsRequestData.ScramCredentialDeletion deletion2 = new AlterUserScramCredentialsRequestData.ScramCredentialDeletion().setName(this.user2()).setMechanism(ScramMechanism.SCRAM_SHA_256.type());
        AlterUserScramCredentialsRequestData.ScramCredentialUpsertion upsertion1 = new AlterUserScramCredentialsRequestData.ScramCredentialUpsertion().setName(this.user1()).setMechanism(ScramMechanism.SCRAM_SHA_256.type()).setIterations(4096).setSalt(this.saltBytes()).setSaltedPassword(this.saltedPasswordBytes());
        AlterUserScramCredentialsRequestData.ScramCredentialUpsertion upsertion2 = new AlterUserScramCredentialsRequestData.ScramCredentialUpsertion().setName(this.user2()).setMechanism(ScramMechanism.SCRAM_SHA_256.type()).setIterations(4096).setSalt(this.saltBytes()).setSaltedPassword(this.saltedPasswordBytes());
        new .colon.colon((Object)((AlterUserScramCredentialsRequest)new AlterUserScramCredentialsRequest.Builder(new AlterUserScramCredentialsRequestData().setDeletions(Collections.emptyList()).setUpsertions(Arrays.asList((Object[])new AlterUserScramCredentialsRequestData.ScramCredentialUpsertion[]{upsertion1, upsertion2}))).build()), (List)Nil$.MODULE$).foreach((Function1 & Serializable & scala.Serializable)request -> {
            AlterUserScramCredentialsRequestTest.$anonfun$testAlterSameThingTwice$1(this, request);
            return BoxedUnit.UNIT;
        });
        new .colon.colon((Object)((AlterUserScramCredentialsRequest)new AlterUserScramCredentialsRequest.Builder(new AlterUserScramCredentialsRequestData().setDeletions(Arrays.asList((Object[])new AlterUserScramCredentialsRequestData.ScramCredentialDeletion[]{deletion1, deletion1})).setUpsertions(Arrays.asList((Object[])new AlterUserScramCredentialsRequestData.ScramCredentialUpsertion[]{upsertion2, upsertion2}))).build()), (List)new .colon.colon((Object)((AlterUserScramCredentialsRequest)new AlterUserScramCredentialsRequest.Builder(new AlterUserScramCredentialsRequestData().setDeletions(Arrays.asList((Object[])new AlterUserScramCredentialsRequestData.ScramCredentialDeletion[]{deletion1, deletion2})).setUpsertions(Arrays.asList((Object[])new AlterUserScramCredentialsRequestData.ScramCredentialUpsertion[]{upsertion1, upsertion2}))).build()), (List)Nil$.MODULE$)).foreach((Function1 & Serializable & scala.Serializable)request -> {
            AlterUserScramCredentialsRequestTest.$anonfun$testAlterSameThingTwice$2(this, request);
            return BoxedUnit.UNIT;
        });
    }

    @ParameterizedTest
    @ValueSource(strings={"kraft", "zk"})
    public void testAlterEmptyUser(String quorum) {
        AlterUserScramCredentialsRequestData.ScramCredentialDeletion deletionEmpty = new AlterUserScramCredentialsRequestData.ScramCredentialDeletion().setName("").setMechanism(ScramMechanism.SCRAM_SHA_256.type());
        AlterUserScramCredentialsRequestData.ScramCredentialUpsertion upsertionEmpty = new AlterUserScramCredentialsRequestData.ScramCredentialUpsertion().setName("").setMechanism(ScramMechanism.SCRAM_SHA_256.type()).setIterations(4096).setSalt(this.saltBytes()).setSaltedPassword(this.saltedPasswordBytes());
        new .colon.colon((Object)((AlterUserScramCredentialsRequest)new AlterUserScramCredentialsRequest.Builder(new AlterUserScramCredentialsRequestData().setDeletions(Arrays.asList((Object[])new AlterUserScramCredentialsRequestData.ScramCredentialDeletion[]{deletionEmpty})).setUpsertions(new ArrayList())).build()), (List)new .colon.colon((Object)((AlterUserScramCredentialsRequest)new AlterUserScramCredentialsRequest.Builder(new AlterUserScramCredentialsRequestData().setDeletions(new ArrayList()).setUpsertions(Arrays.asList((Object[])new AlterUserScramCredentialsRequestData.ScramCredentialUpsertion[]{upsertionEmpty}))).build()), (List)new .colon.colon((Object)((AlterUserScramCredentialsRequest)new AlterUserScramCredentialsRequest.Builder(new AlterUserScramCredentialsRequestData().setDeletions(Arrays.asList((Object[])new AlterUserScramCredentialsRequestData.ScramCredentialDeletion[]{deletionEmpty, deletionEmpty})).setUpsertions(Arrays.asList((Object[])new AlterUserScramCredentialsRequestData.ScramCredentialUpsertion[]{upsertionEmpty}))).build()), (List)Nil$.MODULE$))).foreach((Function1 & Serializable & scala.Serializable)request -> {
            AlterUserScramCredentialsRequestTest.$anonfun$testAlterEmptyUser$1(this, request);
            return BoxedUnit.UNIT;
        });
    }

    @ParameterizedTest
    @ValueSource(strings={"kraft", "zk"})
    public void testAlterUnknownMechanism(String quorum) {
        AlterUserScramCredentialsRequestData.ScramCredentialDeletion deletionUnknown1 = new AlterUserScramCredentialsRequestData.ScramCredentialDeletion().setName(this.user1()).setMechanism(ScramMechanism.UNKNOWN.type());
        AlterUserScramCredentialsRequestData.ScramCredentialDeletion deletionValid1 = new AlterUserScramCredentialsRequestData.ScramCredentialDeletion().setName(this.user1()).setMechanism(ScramMechanism.SCRAM_SHA_256.type());
        AlterUserScramCredentialsRequestData.ScramCredentialDeletion deletionUnknown2 = new AlterUserScramCredentialsRequestData.ScramCredentialDeletion().setName(this.user2()).setMechanism((byte)10);
        String user4 = "user4";
        AlterUserScramCredentialsRequestData.ScramCredentialUpsertion upsertionUnknown4 = new AlterUserScramCredentialsRequestData.ScramCredentialUpsertion().setName(user4).setMechanism(ScramMechanism.UNKNOWN.type()).setIterations(8192).setSalt(this.saltBytes()).setSaltedPassword(this.saltedPasswordBytes());
        AlterUserScramCredentialsRequestData.ScramCredentialUpsertion upsertionValid4 = new AlterUserScramCredentialsRequestData.ScramCredentialUpsertion().setName(user4).setMechanism(ScramMechanism.SCRAM_SHA_256.type()).setIterations(8192).setSalt(this.saltBytes()).setSaltedPassword(this.saltedPasswordBytes());
        String user5 = "user5";
        AlterUserScramCredentialsRequestData.ScramCredentialUpsertion upsertionUnknown5 = new AlterUserScramCredentialsRequestData.ScramCredentialUpsertion().setName(user5).setMechanism((byte)10).setIterations(8192).setSalt(this.saltBytes()).setSaltedPassword(this.saltedPasswordBytes());
        String user6 = "user6";
        AlterUserScramCredentialsRequestData.ScramCredentialUpsertion upsertionUnknown6 = new AlterUserScramCredentialsRequestData.ScramCredentialUpsertion().setName(user6).setMechanism(ScramMechanism.UNKNOWN.type()).setIterations(8192).setSalt(this.saltBytes()).setSaltedPassword(this.saltedPasswordBytes());
        AlterUserScramCredentialsRequest request = (AlterUserScramCredentialsRequest)new AlterUserScramCredentialsRequest.Builder(new AlterUserScramCredentialsRequestData().setDeletions(Arrays.asList((Object[])new AlterUserScramCredentialsRequestData.ScramCredentialDeletion[]{deletionUnknown1, deletionValid1, deletionUnknown2})).setUpsertions(Arrays.asList((Object[])new AlterUserScramCredentialsRequestData.ScramCredentialUpsertion[]{upsertionUnknown4, upsertionValid4, upsertionUnknown5, upsertionUnknown6}))).build();
        java.util.List results = this.sendAlterUserScramCredentialsRequest(request, this.sendAlterUserScramCredentialsRequest$default$2()).data().results();
        Assertions.assertEquals((int)5, (int)results.size());
        this.checkAllErrorsAlteringCredentials(results, Errors.UNSUPPORTED_SASL_MECHANISM, "when altering the credentials with unknown SCRAM mechanisms");
        ((IterableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(results).asScala()).foreach((Function1 & Serializable & scala.Serializable)result -> {
            AlterUserScramCredentialsRequestTest.$anonfun$testAlterUnknownMechanism$1(result);
            return BoxedUnit.UNIT;
        });
    }

    @ParameterizedTest
    @ValueSource(strings={"kraft", "zk"})
    public void testAlterTooFewIterations(String quorum) {
        AlterUserScramCredentialsRequestData.ScramCredentialUpsertion upsertionTooFewIterations = new AlterUserScramCredentialsRequestData.ScramCredentialUpsertion().setName(this.user1()).setMechanism(ScramMechanism.SCRAM_SHA_256.type()).setIterations(1).setSalt(this.saltBytes()).setSaltedPassword(this.saltedPasswordBytes());
        AlterUserScramCredentialsRequest request = (AlterUserScramCredentialsRequest)new AlterUserScramCredentialsRequest.Builder(new AlterUserScramCredentialsRequestData().setDeletions(Collections.emptyList()).setUpsertions(Arrays.asList((Object[])new AlterUserScramCredentialsRequestData.ScramCredentialUpsertion[]{upsertionTooFewIterations}))).build();
        java.util.List results = this.sendAlterUserScramCredentialsRequest(request, this.sendAlterUserScramCredentialsRequest$default$2()).data().results();
        Assertions.assertEquals((int)1, (int)results.size());
        this.checkAllErrorsAlteringCredentials(results, Errors.UNACCEPTABLE_CREDENTIAL, "when altering the credentials with too few iterations");
        Assertions.assertEquals((Object)"Too few iterations", (Object)((AlterUserScramCredentialsResponseData.AlterUserScramCredentialsResult)results.get(0)).errorMessage());
    }

    @ParameterizedTest
    @ValueSource(strings={"kraft", "zk"})
    public void testAlterTooManyIterations(String quorum) {
        AlterUserScramCredentialsRequestData.ScramCredentialUpsertion upsertionTooFewIterations = new AlterUserScramCredentialsRequestData.ScramCredentialUpsertion().setName(this.user1()).setMechanism(ScramMechanism.SCRAM_SHA_256.type()).setIterations(Integer.MAX_VALUE).setSalt(this.saltBytes()).setSaltedPassword(this.saltedPasswordBytes());
        AlterUserScramCredentialsRequest request = (AlterUserScramCredentialsRequest)new AlterUserScramCredentialsRequest.Builder(new AlterUserScramCredentialsRequestData().setDeletions(Collections.emptyList()).setUpsertions(Arrays.asList((Object[])new AlterUserScramCredentialsRequestData.ScramCredentialUpsertion[]{upsertionTooFewIterations}))).build();
        java.util.List results = this.sendAlterUserScramCredentialsRequest(request, this.sendAlterUserScramCredentialsRequest$default$2()).data().results();
        Assertions.assertEquals((int)1, (int)results.size());
        this.checkAllErrorsAlteringCredentials(results, Errors.UNACCEPTABLE_CREDENTIAL, "when altering the credentials with too many iterations");
        Assertions.assertEquals((Object)"Too many iterations", (Object)((AlterUserScramCredentialsResponseData.AlterUserScramCredentialsResult)results.get(0)).errorMessage());
    }

    @ParameterizedTest
    @ValueSource(strings={"kraft", "zk"})
    public void testDeleteSomethingThatDoesNotExist(String quorum) {
        AlterUserScramCredentialsRequest request = (AlterUserScramCredentialsRequest)new AlterUserScramCredentialsRequest.Builder(new AlterUserScramCredentialsRequestData().setDeletions(Arrays.asList((Object[])new AlterUserScramCredentialsRequestData.ScramCredentialDeletion[]{new AlterUserScramCredentialsRequestData.ScramCredentialDeletion().setName(this.user1()).setMechanism(ScramMechanism.SCRAM_SHA_256.type())})).setUpsertions(new ArrayList())).build();
        java.util.List results = this.sendAlterUserScramCredentialsRequest(request, this.sendAlterUserScramCredentialsRequest$default$2()).data().results();
        Assertions.assertEquals((int)1, (int)results.size());
        this.checkAllErrorsAlteringCredentials(results, Errors.RESOURCE_NOT_FOUND, "when deleting a non-existing credential");
    }

    @Test
    public void testAlterNotController() {
        AlterUserScramCredentialsRequest request = (AlterUserScramCredentialsRequest)new AlterUserScramCredentialsRequest.Builder(new AlterUserScramCredentialsRequestData().setDeletions(Arrays.asList((Object[])new AlterUserScramCredentialsRequestData.ScramCredentialDeletion[]{new AlterUserScramCredentialsRequestData.ScramCredentialDeletion().setName(this.user1()).setMechanism(ScramMechanism.SCRAM_SHA_256.type())})).setUpsertions(Arrays.asList((Object[])new AlterUserScramCredentialsRequestData.ScramCredentialUpsertion[]{new AlterUserScramCredentialsRequestData.ScramCredentialUpsertion().setName(this.user2()).setMechanism(ScramMechanism.SCRAM_SHA_512.type())}))).build();
        java.util.List results = this.sendAlterUserScramCredentialsRequest(request, this.notControllerSocketServer()).data().results();
        Assertions.assertEquals((int)2, (int)results.size());
        this.checkAllErrorsAlteringCredentials(results, Errors.NOT_CONTROLLER, "when routed incorrectly to a non-Controller broker");
    }

    /*
     * WARNING - void declaration
     */
    @ParameterizedTest
    @ValueSource(strings={"kraft", "zk"})
    public void testAlterAndDescribe(String quorum) {
        AlterUserScramCredentialsRequest request1_0 = (AlterUserScramCredentialsRequest)new AlterUserScramCredentialsRequest.Builder(new AlterUserScramCredentialsRequestData().setUpsertions(Arrays.asList((Object[])new AlterUserScramCredentialsRequestData.ScramCredentialUpsertion[]{new AlterUserScramCredentialsRequestData.ScramCredentialUpsertion().setName(this.user1()).setMechanism(ScramMechanism.SCRAM_SHA_256.type()).setIterations(4096).setSalt(this.saltBytes()).setSaltedPassword(this.saltedPasswordBytes())}))).build();
        java.util.List results1_0 = this.sendAlterUserScramCredentialsRequest(request1_0, this.sendAlterUserScramCredentialsRequest$default$2()).data().results();
        Assertions.assertEquals((int)1, (int)results1_0.size());
        this.checkNoErrorsAlteringCredentials(results1_0);
        this.checkUserAppearsInAlterResults(results1_0, this.user1());
        AlterUserScramCredentialsRequest request1_1 = (AlterUserScramCredentialsRequest)new AlterUserScramCredentialsRequest.Builder(new AlterUserScramCredentialsRequestData().setUpsertions(Arrays.asList((Object[])new AlterUserScramCredentialsRequestData.ScramCredentialUpsertion[]{new AlterUserScramCredentialsRequestData.ScramCredentialUpsertion().setName(this.user1()).setMechanism(ScramMechanism.SCRAM_SHA_512.type()).setIterations(8192).setSalt(this.saltBytes()).setSaltedPassword(this.saltedPasswordBytes()), new AlterUserScramCredentialsRequestData.ScramCredentialUpsertion().setName(this.user2()).setMechanism(ScramMechanism.SCRAM_SHA_512.type()).setIterations(8192).setSalt(this.saltBytes()).setSaltedPassword(this.saltedPasswordBytes()), new AlterUserScramCredentialsRequestData.ScramCredentialUpsertion().setName(this.user3()).setMechanism(ScramMechanism.SCRAM_SHA_512.type()).setIterations(8192).setSalt(this.saltBytes()).setSaltedPassword(this.saltedPasswordBytes())}))).build();
        java.util.List results1_1 = this.sendAlterUserScramCredentialsRequest(request1_1, this.sendAlterUserScramCredentialsRequest$default$2()).data().results();
        Assertions.assertEquals((int)3, (int)results1_1.size());
        this.checkNoErrorsAlteringCredentials(results1_1);
        this.checkUserAppearsInAlterResults(results1_1, this.user1());
        this.checkUserAppearsInAlterResults(results1_1, this.user2());
        this.checkUserAppearsInAlterResults(results1_1, this.user3());
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!AlterUserScramCredentialsRequestTest.$anonfun$testAlterAndDescribe$1(this)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)AlterUserScramCredentialsRequestTest.$anonfun$testAlterAndDescribe$2());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        java.util.List results2 = this.describeAllWithNoTopLevelErrorConfirmed().data().results();
        Assertions.assertEquals((int)3, (int)results2.size());
        this.checkUserHasTwoCredentials(results2, this.user1());
        this.checkForSingleSha512Iterations8192Credential(results2, this.user2());
        this.checkForSingleSha512Iterations8192Credential(results2, this.user3());
        DescribeUserScramCredentialsRequest request3 = (DescribeUserScramCredentialsRequest)new DescribeUserScramCredentialsRequest.Builder(new DescribeUserScramCredentialsRequestData().setUsers(Arrays.asList((Object[])new DescribeUserScramCredentialsRequestData.UserName[]{new DescribeUserScramCredentialsRequestData.UserName().setName(this.user1())}))).build();
        DescribeUserScramCredentialsResponse response3 = this.sendDescribeUserScramCredentialsRequest(request3, this.sendDescribeUserScramCredentialsRequest$default$2());
        this.checkNoTopLevelErrorDescribingCredentials(response3);
        java.util.List results3 = response3.data().results();
        Assertions.assertEquals((int)1, (int)results3.size());
        this.checkUserHasTwoCredentials(results3, this.user1());
        DescribeUserScramCredentialsRequest requestUnknown = (DescribeUserScramCredentialsRequest)new DescribeUserScramCredentialsRequest.Builder(new DescribeUserScramCredentialsRequestData().setUsers(Arrays.asList((Object[])new DescribeUserScramCredentialsRequestData.UserName[]{new DescribeUserScramCredentialsRequestData.UserName().setName(this.user1()), new DescribeUserScramCredentialsRequestData.UserName().setName(this.unknownUser())}))).build();
        DescribeUserScramCredentialsResponse responseUnknown = this.sendDescribeUserScramCredentialsRequest(requestUnknown, this.sendDescribeUserScramCredentialsRequest$default$2());
        this.checkNoTopLevelErrorDescribingCredentials(responseUnknown);
        java.util.List resultsUnknown = responseUnknown.data().results();
        Assertions.assertEquals((int)2, (int)resultsUnknown.size());
        this.checkUserHasTwoCredentials(resultsUnknown, this.user1());
        this.checkDescribeForError(resultsUnknown, this.unknownUser(), Errors.RESOURCE_NOT_FOUND);
        DescribeUserScramCredentialsRequest requestDuplicateUser = (DescribeUserScramCredentialsRequest)new DescribeUserScramCredentialsRequest.Builder(new DescribeUserScramCredentialsRequestData().setUsers(Arrays.asList((Object[])new DescribeUserScramCredentialsRequestData.UserName[]{new DescribeUserScramCredentialsRequestData.UserName().setName(this.user1()), new DescribeUserScramCredentialsRequestData.UserName().setName(this.user2()), new DescribeUserScramCredentialsRequestData.UserName().setName(this.user2())}))).build();
        DescribeUserScramCredentialsResponse responseDuplicateUser = this.sendDescribeUserScramCredentialsRequest(requestDuplicateUser, this.sendDescribeUserScramCredentialsRequest$default$2());
        this.checkNoTopLevelErrorDescribingCredentials(responseDuplicateUser);
        java.util.List resultsDuplicateUser = responseDuplicateUser.data().results();
        Assertions.assertEquals((int)2, (int)resultsDuplicateUser.size());
        this.checkUserHasTwoCredentials(resultsDuplicateUser, this.user1());
        this.checkDescribeForError(resultsDuplicateUser, this.user2(), Errors.DUPLICATE_RESOURCE);
        AlterUserScramCredentialsRequest request4 = (AlterUserScramCredentialsRequest)new AlterUserScramCredentialsRequest.Builder(new AlterUserScramCredentialsRequestData().setDeletions(Arrays.asList((Object[])new AlterUserScramCredentialsRequestData.ScramCredentialDeletion[]{new AlterUserScramCredentialsRequestData.ScramCredentialDeletion().setName(this.user1()).setMechanism(ScramMechanism.SCRAM_SHA_256.type()), new AlterUserScramCredentialsRequestData.ScramCredentialDeletion().setName(this.user2()).setMechanism(ScramMechanism.SCRAM_SHA_512.type())}))).build();
        java.util.List results4 = this.sendAlterUserScramCredentialsRequest(request4, this.sendAlterUserScramCredentialsRequest$default$2()).data().results();
        Assertions.assertEquals((int)2, (int)results4.size());
        this.checkNoErrorsAlteringCredentials(results4);
        this.checkUserAppearsInAlterResults(results4, this.user1());
        this.checkUserAppearsInAlterResults(results4, this.user2());
        long l3 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l4 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime2 = System.currentTimeMillis();
        while (!AlterUserScramCredentialsRequestTest.$anonfun$testAlterAndDescribe$3(this)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime2 + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)AlterUserScramCredentialsRequestTest.$anonfun$testAlterAndDescribe$4());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        java.util.List results5 = this.describeAllWithNoTopLevelErrorConfirmed().data().results();
        Assertions.assertEquals((int)2, (int)results5.size());
        this.checkForSingleSha512Iterations8192Credential(results5, this.user1());
        this.checkForSingleSha512Iterations8192Credential(results5, this.user3());
        AlterUserScramCredentialsRequest request6 = (AlterUserScramCredentialsRequest)new AlterUserScramCredentialsRequest.Builder(new AlterUserScramCredentialsRequestData().setDeletions(Arrays.asList((Object[])new AlterUserScramCredentialsRequestData.ScramCredentialDeletion[]{new AlterUserScramCredentialsRequestData.ScramCredentialDeletion().setName(this.user1()).setMechanism(ScramMechanism.SCRAM_SHA_512.type()), new AlterUserScramCredentialsRequestData.ScramCredentialDeletion().setName(this.user3()).setMechanism(ScramMechanism.SCRAM_SHA_512.type())}))).build();
        java.util.List results6 = this.sendAlterUserScramCredentialsRequest(request6, this.sendAlterUserScramCredentialsRequest$default$2()).data().results();
        Assertions.assertEquals((int)2, (int)results6.size());
        this.checkNoErrorsAlteringCredentials(results6);
        this.checkUserAppearsInAlterResults(results6, this.user1());
        this.checkUserAppearsInAlterResults(results6, this.user3());
        long l5 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l6 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime3 = System.currentTimeMillis();
        while (!AlterUserScramCredentialsRequestTest.$anonfun$testAlterAndDescribe$5(this)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime3 + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)AlterUserScramCredentialsRequestTest.$anonfun$testAlterAndDescribe$6());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        java.util.List results7 = this.describeAllWithNoTopLevelErrorConfirmed().data().results();
        Assertions.assertEquals((int)0, (int)results7.size());
    }

    @ParameterizedTest
    @ValueSource(strings={"kraft-IBP_3_4"})
    public void testMetadataVersionTooLow(String quorum) {
        AlterUserScramCredentialsRequestData.ScramCredentialUpsertion upsertionMetadataVersionTooLow = new AlterUserScramCredentialsRequestData.ScramCredentialUpsertion().setName(this.user1()).setMechanism(ScramMechanism.SCRAM_SHA_256.type()).setIterations(8192).setSalt(this.saltBytes()).setSaltedPassword(this.saltedPasswordBytes());
        AlterUserScramCredentialsRequest request = (AlterUserScramCredentialsRequest)new AlterUserScramCredentialsRequest.Builder(new AlterUserScramCredentialsRequestData().setDeletions(Collections.emptyList()).setUpsertions(Arrays.asList((Object[])new AlterUserScramCredentialsRequestData.ScramCredentialUpsertion[]{upsertionMetadataVersionTooLow}))).build();
        java.util.List results = this.sendAlterUserScramCredentialsRequest(request, this.sendAlterUserScramCredentialsRequest$default$2()).data().results();
        Assertions.assertEquals((int)1, (int)results.size());
        this.checkAllErrorsAlteringCredentials(results, Errors.UNSUPPORTED_VERSION, "when altering the credentials on unsupported IBP version");
        Assertions.assertEquals((Object)"The current metadata.version does not support SCRAM", (Object)((AlterUserScramCredentialsResponseData.AlterUserScramCredentialsResult)results.get(0)).errorMessage());
    }

    private AlterUserScramCredentialsResponse sendAlterUserScramCredentialsRequest(AlterUserScramCredentialsRequest request, SocketServer socketServer) {
        return (AlterUserScramCredentialsResponse)this.connectAndReceive((AbstractRequest)request, socketServer, this.connectAndReceive$default$3(), ClassTag$.MODULE$.apply(AlterUserScramCredentialsResponse.class));
    }

    private SocketServer sendAlterUserScramCredentialsRequest$default$2() {
        return this.adminSocketServer();
    }

    private DescribeUserScramCredentialsResponse sendDescribeUserScramCredentialsRequest(DescribeUserScramCredentialsRequest request, SocketServer socketServer) {
        return (DescribeUserScramCredentialsResponse)this.connectAndReceive((AbstractRequest)request, socketServer, this.connectAndReceive$default$3(), ClassTag$.MODULE$.apply(DescribeUserScramCredentialsResponse.class));
    }

    private SocketServer sendDescribeUserScramCredentialsRequest$default$2() {
        return this.adminSocketServer();
    }

    private void checkAllErrorsAlteringCredentials(java.util.List<AlterUserScramCredentialsResponseData.AlterUserScramCredentialsResult> resultsToCheck, Errors expectedError, String contextMsg) {
        Assertions.assertEquals((int)0, (int)((SeqLike)((TraversableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(resultsToCheck).asScala()).filterNot((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)AlterUserScramCredentialsRequestTest.$anonfun$checkAllErrorsAlteringCredentials$1(expectedError, x$1)))).size(), (String)new StringBuilder(49).append("Expected all '").append(expectedError.name()).append("' errors when altering credentials ").append(contextMsg).toString());
    }

    private void checkNoErrorsAlteringCredentials(java.util.List<AlterUserScramCredentialsResponseData.AlterUserScramCredentialsResult> resultsToCheck) {
        Assertions.assertEquals((int)0, (int)((SeqLike)((TraversableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(resultsToCheck).asScala()).filterNot((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)AlterUserScramCredentialsRequestTest.$anonfun$checkNoErrorsAlteringCredentials$1(x$2)))).size(), (String)"Expected no error when altering credentials");
    }

    private void checkUserAppearsInAlterResults(java.util.List<AlterUserScramCredentialsResponseData.AlterUserScramCredentialsResult> resultsToCheck, String user) {
        Assertions.assertTrue((boolean)((IterableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(resultsToCheck).asScala()).exists((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)AlterUserScramCredentialsRequestTest.$anonfun$checkUserAppearsInAlterResults$1(user, x$3))), (String)new StringBuilder(29).append("Expected result to contain '").append(user).append("'").toString());
    }

    private DescribeUserScramCredentialsResponse describeAllWithNoTopLevelErrorConfirmed() {
        DescribeUserScramCredentialsResponse response = this.sendDescribeUserScramCredentialsRequest((DescribeUserScramCredentialsRequest)new DescribeUserScramCredentialsRequest.Builder(new DescribeUserScramCredentialsRequestData()).build(), this.sendDescribeUserScramCredentialsRequest$default$2());
        this.checkNoTopLevelErrorDescribingCredentials(response);
        return response;
    }

    private void checkNoTopLevelErrorDescribingCredentials(DescribeUserScramCredentialsResponse responseToCheck) {
        Assertions.assertEquals((short)Errors.NONE.code(), (short)responseToCheck.data().errorCode(), (String)"Expected no top-level error when describing the credentials");
    }

    private void checkUserHasTwoCredentials(java.util.List<DescribeUserScramCredentialsResponseData.DescribeUserScramCredentialsResult> resultsToCheck, String user) {
        Assertions.assertTrue((boolean)((IterableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(resultsToCheck).asScala()).exists((Function1 & Serializable & scala.Serializable)result -> BoxesRunTime.boxToBoolean((boolean)AlterUserScramCredentialsRequestTest.$anonfun$checkUserHasTwoCredentials$1(user, result))), (String)new StringBuilder(50).append("Expected result to contain '").append(user).append("' with 2 credentials: ").append(resultsToCheck).toString());
        Assertions.assertTrue((boolean)((IterableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(resultsToCheck).asScala()).exists((Function1 & Serializable & scala.Serializable)result -> BoxesRunTime.boxToBoolean((boolean)AlterUserScramCredentialsRequestTest.$anonfun$checkUserHasTwoCredentials$2(user, result))), (String)new StringBuilder(90).append("Expected result to contain '").append(user).append("' with SCRAM_SHA_256/4096 and SCRAM_SHA_512/8192 credentials: ").append(resultsToCheck).toString());
    }

    private void checkForSingleSha512Iterations8192Credential(java.util.List<DescribeUserScramCredentialsResponseData.DescribeUserScramCredentialsResult> resultsToCheck, String user) {
        Assertions.assertTrue((boolean)((IterableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(resultsToCheck).asScala()).exists((Function1 & Serializable & scala.Serializable)result -> BoxesRunTime.boxToBoolean((boolean)AlterUserScramCredentialsRequestTest.$anonfun$checkForSingleSha512Iterations8192Credential$1(user, result))), (String)new StringBuilder(49).append("Expected result to contain '").append(user).append("' with 1 credential: ").append(resultsToCheck).toString());
        Assertions.assertTrue((boolean)((IterableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(resultsToCheck).asScala()).exists((Function1 & Serializable & scala.Serializable)result -> BoxesRunTime.boxToBoolean((boolean)AlterUserScramCredentialsRequestTest.$anonfun$checkForSingleSha512Iterations8192Credential$2(user, result))), (String)new StringBuilder(66).append("Expected result to contain '").append(user).append("' with SCRAM_SHA_512/8192 credential: ").append(resultsToCheck).toString());
    }

    private void checkDescribeForError(java.util.List<DescribeUserScramCredentialsResponseData.DescribeUserScramCredentialsResult> resultsToCheck, String user, Errors expectedError) {
        Assertions.assertTrue((boolean)((IterableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(resultsToCheck).asScala()).exists((Function1 & Serializable & scala.Serializable)result -> BoxesRunTime.boxToBoolean((boolean)AlterUserScramCredentialsRequestTest.$anonfun$checkDescribeForError$1(user, expectedError, result))), (String)new StringBuilder(45).append("Expected result to contain '").append(user).append("' with a ").append(expectedError.name()).append(" error: ").append(resultsToCheck).toString());
    }

    public static final /* synthetic */ void $anonfun$testAlterSameThingTwice$1(AlterUserScramCredentialsRequestTest $this, AlterUserScramCredentialsRequest request) {
        java.util.List results = $this.sendAlterUserScramCredentialsRequest(request, $this.sendAlterUserScramCredentialsRequest$default$2()).data().results();
        $this.checkNoErrorsAlteringCredentials(results);
    }

    public static final /* synthetic */ void $anonfun$testAlterSameThingTwice$2(AlterUserScramCredentialsRequestTest $this, AlterUserScramCredentialsRequest request) {
        java.util.List results = $this.sendAlterUserScramCredentialsRequest(request, $this.sendAlterUserScramCredentialsRequest$default$2()).data().results();
        Assertions.assertEquals((int)2, (int)results.size());
        $this.checkAllErrorsAlteringCredentials(results, Errors.DUPLICATE_RESOURCE, "when altering the same credential twice in a single request");
    }

    public static final /* synthetic */ void $anonfun$testAlterEmptyUser$1(AlterUserScramCredentialsRequestTest $this, AlterUserScramCredentialsRequest request) {
        java.util.List results = $this.sendAlterUserScramCredentialsRequest(request, $this.sendAlterUserScramCredentialsRequest$default$2()).data().results();
        Assertions.assertEquals((int)1, (int)results.size());
        $this.checkAllErrorsAlteringCredentials(results, Errors.UNACCEPTABLE_CREDENTIAL, "when altering an empty user");
        Assertions.assertEquals((Object)"Username must not be empty", (Object)((AlterUserScramCredentialsResponseData.AlterUserScramCredentialsResult)results.get(0)).errorMessage());
    }

    public static final /* synthetic */ void $anonfun$testAlterUnknownMechanism$1(AlterUserScramCredentialsResponseData.AlterUserScramCredentialsResult result) {
        Assertions.assertEquals((Object)"Unknown SCRAM mechanism", (Object)result.errorMessage());
    }

    public static final /* synthetic */ boolean $anonfun$testAlterAndDescribe$1(AlterUserScramCredentialsRequestTest $this) {
        return $this.describeAllWithNoTopLevelErrorConfirmed().data().results().size() == 3;
    }

    public static final /* synthetic */ String $anonfun$testAlterAndDescribe$2() {
        return "describeAllWithNoTopLevelErrorConfirmed does not see 3 users";
    }

    public static final /* synthetic */ boolean $anonfun$testAlterAndDescribe$3(AlterUserScramCredentialsRequestTest $this) {
        return $this.describeAllWithNoTopLevelErrorConfirmed().data().results().size() == 2;
    }

    public static final /* synthetic */ String $anonfun$testAlterAndDescribe$4() {
        return "describeAllWithNoTopLevelErrorConfirmed does not see only 2 users";
    }

    public static final /* synthetic */ boolean $anonfun$testAlterAndDescribe$5(AlterUserScramCredentialsRequestTest $this) {
        return $this.describeAllWithNoTopLevelErrorConfirmed().data().results().size() == 0;
    }

    public static final /* synthetic */ String $anonfun$testAlterAndDescribe$6() {
        return "describeAllWithNoTopLevelErrorConfirmed does not see empty user";
    }

    public static final /* synthetic */ boolean $anonfun$checkAllErrorsAlteringCredentials$1(Errors expectedError$1, AlterUserScramCredentialsResponseData.AlterUserScramCredentialsResult x$1) {
        return x$1.errorCode() == expectedError$1.code();
    }

    public static final /* synthetic */ boolean $anonfun$checkNoErrorsAlteringCredentials$1(AlterUserScramCredentialsResponseData.AlterUserScramCredentialsResult x$2) {
        return x$2.errorCode() == Errors.NONE.code();
    }

    public static final /* synthetic */ boolean $anonfun$checkUserAppearsInAlterResults$1(String user$1, AlterUserScramCredentialsResponseData.AlterUserScramCredentialsResult x$3) {
        String string = x$3.user();
        return !(string != null ? !string.equals(user$1) : user$1 != null);
    }

    public static final /* synthetic */ boolean $anonfun$checkUserHasTwoCredentials$1(String user$2, DescribeUserScramCredentialsResponseData.DescribeUserScramCredentialsResult result) {
        String string = result.user();
        if (!(string != null ? !string.equals(user$2) : user$2 != null)) {
            if (result.credentialInfos().size() == 2 && result.errorCode() == Errors.NONE.code()) {
                return true;
            }
        }
        return false;
    }

    public static final /* synthetic */ boolean $anonfun$checkUserHasTwoCredentials$3(DescribeUserScramCredentialsResponseData.CredentialInfo info) {
        return info.mechanism() == ScramMechanism.SCRAM_SHA_256.type() && info.iterations() == 4096;
    }

    public static final /* synthetic */ boolean $anonfun$checkUserHasTwoCredentials$4(DescribeUserScramCredentialsResponseData.CredentialInfo info) {
        return info.mechanism() == ScramMechanism.SCRAM_SHA_512.type() && info.iterations() == 8192;
    }

    public static final /* synthetic */ boolean $anonfun$checkUserHasTwoCredentials$2(String user$2, DescribeUserScramCredentialsResponseData.DescribeUserScramCredentialsResult result) {
        String string = result.user();
        if (!(string != null ? !string.equals(user$2) : user$2 != null)) {
            if (((IterableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(result.credentialInfos()).asScala()).exists((Function1 & Serializable & scala.Serializable)info -> BoxesRunTime.boxToBoolean((boolean)AlterUserScramCredentialsRequestTest.$anonfun$checkUserHasTwoCredentials$3(info))) && ((IterableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(result.credentialInfos()).asScala()).exists((Function1 & Serializable & scala.Serializable)info -> BoxesRunTime.boxToBoolean((boolean)AlterUserScramCredentialsRequestTest.$anonfun$checkUserHasTwoCredentials$4(info)))) {
                return true;
            }
        }
        return false;
    }

    public static final /* synthetic */ boolean $anonfun$checkForSingleSha512Iterations8192Credential$1(String user$3, DescribeUserScramCredentialsResponseData.DescribeUserScramCredentialsResult result) {
        String string = result.user();
        if (!(string != null ? !string.equals(user$3) : user$3 != null)) {
            if (result.credentialInfos().size() == 1 && result.errorCode() == Errors.NONE.code()) {
                return true;
            }
        }
        return false;
    }

    public static final /* synthetic */ boolean $anonfun$checkForSingleSha512Iterations8192Credential$3(DescribeUserScramCredentialsResponseData.CredentialInfo info) {
        return info.mechanism() == ScramMechanism.SCRAM_SHA_512.type() && info.iterations() == 8192;
    }

    public static final /* synthetic */ boolean $anonfun$checkForSingleSha512Iterations8192Credential$2(String user$3, DescribeUserScramCredentialsResponseData.DescribeUserScramCredentialsResult result) {
        String string = result.user();
        return !(string != null ? !string.equals(user$3) : user$3 != null) && ((IterableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(result.credentialInfos()).asScala()).exists((Function1 & Serializable & scala.Serializable)info -> BoxesRunTime.boxToBoolean((boolean)AlterUserScramCredentialsRequestTest.$anonfun$checkForSingleSha512Iterations8192Credential$3(info)));
    }

    public static final /* synthetic */ boolean $anonfun$checkDescribeForError$1(String user$4, Errors expectedError$2, DescribeUserScramCredentialsResponseData.DescribeUserScramCredentialsResult result) {
        String string = result.user();
        if (!(string != null ? !string.equals(user$4) : user$4 != null)) {
            if (result.credentialInfos().size() == 0 && result.errorCode() == expectedError$2.code()) {
                return true;
            }
        }
        return false;
    }

    public AlterUserScramCredentialsRequestTest() {
        this.user1 = "user1";
        this.user2 = "user2";
        this.user3 = "user3@user3.com";
        this.unknownUser = "unknownUser";
    }
}

