/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import kafka.server.BrokerFeatures;
import kafka.server.BrokerFeatures$;
import org.apache.kafka.common.feature.SupportedVersionRange;
import org.apache.kafka.server.common.Features;
import org.apache.kafka.server.common.MetadataVersion;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Map;
import scala.collection.Seq;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u000113A\u0001C\u0005\u0001\u001d!)Q\u0003\u0001C\u0001-!)\u0011\u0004\u0001C\u00015!)1\u0006\u0001C\u00015!)Q\u0006\u0001C\u00015!)q\u0006\u0001C\u00015!)\u0011\u0007\u0001C\u00015!)1\u0007\u0001C\u0001i\t\u0011\"I]8lKJ4U-\u0019;ve\u0016\u001cH+Z:u\u0015\tQ1\"\u0001\u0004tKJ4XM\u001d\u0006\u0002\u0019\u0005)1.\u00194lC\u000e\u00011C\u0001\u0001\u0010!\t\u00012#D\u0001\u0012\u0015\u0005\u0011\u0012!B:dC2\f\u0017B\u0001\u000b\u0012\u0005\u0019\te.\u001f*fM\u00061A(\u001b8jiz\"\u0012a\u0006\t\u00031\u0001i\u0011!C\u0001\ni\u0016\u001cH/R7qif$\u0012a\u0007\t\u0003!qI!!H\t\u0003\tUs\u0017\u000e\u001e\u0015\u0003\u0005}\u0001\"\u0001I\u0015\u000e\u0003\u0005R!AI\u0012\u0002\u0007\u0005\u0004\u0018N\u0003\u0002%K\u00059!.\u001e9ji\u0016\u0014(B\u0001\u0014(\u0003\u0015QWO\\5u\u0015\u0005A\u0013aA8sO&\u0011!&\t\u0002\u0005)\u0016\u001cH/A\u0014uKN$\u0018J\\2p[B\fG/\u001b2jY&$\u0018.Z:Ek\u0016$v.\u00112tK:$h)Z1ukJ,\u0007FA\u0002 \u00035\"Xm\u001d;J]\u000e|W\u000e]1uS\nLG.\u001b;jKN$U/\u001a+p\u0013:\u001cw.\u001c9bi&\u0014G.\u001a$fCR,(/\u001a\u0015\u0003\t}\ta\u0003^3ti\u000e{W\u000e]1uS\ndWMR3biV\u0014Xm\u001d\u0015\u0003\u000b}\tA\u0004^3ti\u0012+g-Y;mi\u001aKg.\u00197ju\u0016$g)Z1ukJ,7\u000f\u000b\u0002\u0007?\u0005iSM\\:ve\u0016$UMZ1vYR\u001cV\u000f\u001d9peR,GMR3biV\u0014Xm\u001d*b]\u001e,W*\u0019=O_RTVM]8\u0015\u0005m)\u0004\"\u0002\u001c\b\u0001\u00049\u0014aF;ogR\f'\r\\3WKJ\u001c\u0018n\u001c8t\u000b:\f'\r\\3e!\t\u0001\u0002(\u0003\u0002:#\t9!i\\8mK\u0006t\u0007\u0006B\u0004<\u0007\u0012\u0003\"\u0001P!\u000e\u0003uR!AP \u0002\u0011A\u0014xN^5eKJT!\u0001Q\u0012\u0002\rA\f'/Y7t\u0013\t\u0011UHA\u0006WC2,XmU8ve\u000e,\u0017\u0001\u00032p_2,\u0017M\\:-\u0005\u00153\u0015$A\u0001\u001a\u0003\u0001A#a\u0002%\u0011\u0005%SU\"A \n\u0005-{$!\u0005)be\u0006lW\r^3sSj,G\rV3ti\u0002")
public class BrokerFeaturesTest {
    @Test
    public void testEmpty() {
        Assertions.assertTrue((boolean)BrokerFeatures$.MODULE$.createEmpty().supportedFeatures().empty());
    }

    @Test
    public void testIncompatibilitiesDueToAbsentFeature() {
        BrokerFeatures brokerFeatures = BrokerFeatures$.MODULE$.createDefault(true);
        org.apache.kafka.common.feature.Features supportedFeatures = org.apache.kafka.common.feature.Features.supportedFeatures((java.util.Map)((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"test_feature_1"), (Object)new SupportedVersionRange(1, 4)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"test_feature_2"), (Object)new SupportedVersionRange(1, 3))}))).asJava()));
        brokerFeatures.setSupportedFeatures(supportedFeatures);
        scala.collection.immutable.Map compatibleFeatures = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"test_feature_1"), (Object)BoxesRunTime.boxToShort((short)4))}));
        scala.collection.immutable.Map inCompatibleFeatures = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"test_feature_3"), (Object)BoxesRunTime.boxToShort((short)4))}));
        scala.collection.immutable.Map features = compatibleFeatures.$plus$plus((GenTraversableOnce)inCompatibleFeatures);
        Assertions.assertEquals((Object)inCompatibleFeatures, (Object)brokerFeatures.incompatibleFeatures(features));
        Assertions.assertTrue((boolean)BrokerFeatures$.MODULE$.hasIncompatibleFeatures(supportedFeatures, features));
    }

    @Test
    public void testIncompatibilitiesDueToIncompatibleFeature() {
        BrokerFeatures brokerFeatures = BrokerFeatures$.MODULE$.createDefault(true);
        org.apache.kafka.common.feature.Features supportedFeatures = org.apache.kafka.common.feature.Features.supportedFeatures((java.util.Map)((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"test_feature_1"), (Object)new SupportedVersionRange(1, 4)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"test_feature_2"), (Object)new SupportedVersionRange(1, 3))}))).asJava()));
        brokerFeatures.setSupportedFeatures(supportedFeatures);
        scala.collection.immutable.Map compatibleFeatures = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"test_feature_1"), (Object)BoxesRunTime.boxToShort((short)3))}));
        scala.collection.immutable.Map inCompatibleFeatures = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"test_feature_2"), (Object)BoxesRunTime.boxToShort((short)4))}));
        scala.collection.immutable.Map features = compatibleFeatures.$plus$plus((GenTraversableOnce)inCompatibleFeatures);
        Assertions.assertEquals((Object)inCompatibleFeatures, (Object)brokerFeatures.incompatibleFeatures(features));
        Assertions.assertTrue((boolean)BrokerFeatures$.MODULE$.hasIncompatibleFeatures(supportedFeatures, features));
    }

    @Test
    public void testCompatibleFeatures() {
        BrokerFeatures brokerFeatures = BrokerFeatures$.MODULE$.createDefault(true);
        org.apache.kafka.common.feature.Features supportedFeatures = org.apache.kafka.common.feature.Features.supportedFeatures((java.util.Map)((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"test_feature_1"), (Object)new SupportedVersionRange(1, 4)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"test_feature_2"), (Object)new SupportedVersionRange(1, 3))}))).asJava()));
        brokerFeatures.setSupportedFeatures(supportedFeatures);
        scala.collection.immutable.Map compatibleFeatures = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"test_feature_1"), (Object)BoxesRunTime.boxToShort((short)3)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"test_feature_2"), (Object)BoxesRunTime.boxToShort((short)3))}));
        Assertions.assertTrue((boolean)brokerFeatures.incompatibleFeatures(compatibleFeatures).isEmpty());
        Assertions.assertFalse((boolean)BrokerFeatures$.MODULE$.hasIncompatibleFeatures(supportedFeatures, compatibleFeatures));
    }

    @Test
    public void testDefaultFinalizedFeatures() {
        BrokerFeatures brokerFeatures = BrokerFeatures$.MODULE$.createDefault(true);
        org.apache.kafka.common.feature.Features supportedFeatures = org.apache.kafka.common.feature.Features.supportedFeatures((java.util.Map)((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"test_feature_1"), (Object)new SupportedVersionRange(1, 4)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"test_feature_2"), (Object)new SupportedVersionRange(1, 3)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"test_feature_3"), (Object)new SupportedVersionRange(3, 7))}))).asJava()));
        brokerFeatures.setSupportedFeatures(supportedFeatures);
        Assertions.assertEquals((Object)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"metadata.version"), (Object)BoxesRunTime.boxToShort((short)MetadataVersion.latestTesting().featureLevel())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Features.TRANSACTION_VERSION.featureName()), (Object)BoxesRunTime.boxToShort((short)Features.TRANSACTION_VERSION.latestTesting())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"kraft.version"), (Object)BoxesRunTime.boxToShort((short)0)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"test_feature_1"), (Object)BoxesRunTime.boxToShort((short)4)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"test_feature_2"), (Object)BoxesRunTime.boxToShort((short)3)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"test_feature_3"), (Object)BoxesRunTime.boxToShort((short)7))}))), (Object)brokerFeatures.defaultFinalizedFeatures());
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    public void ensureDefaultSupportedFeaturesRangeMaxNotZero(boolean unstableVersionsEnabled) {
        BrokerFeatures$.MODULE$.createDefault(unstableVersionsEnabled).supportedFeatures().features().values().forEach(supportedVersionRange -> Assertions.assertNotEquals((int)0, (int)supportedVersionRange.max()));
    }
}

