/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.Serializable;
import java.util.Collections;
import java.util.OptionalLong;
import java.util.Properties;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import kafka.server.BrokerFeatures$;
import kafka.server.BrokerLifecycleManager;
import kafka.server.BrokerLifecycleManager$;
import kafka.server.RegistrationTestContext;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.message.BrokerHeartbeatResponseData;
import org.apache.kafka.common.message.BrokerRegistrationRequestData;
import org.apache.kafka.common.message.BrokerRegistrationResponseData;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.AbstractResponse;
import org.apache.kafka.common.requests.BrokerHeartbeatRequest;
import org.apache.kafka.common.requests.BrokerHeartbeatResponse;
import org.apache.kafka.common.requests.BrokerRegistrationRequest;
import org.apache.kafka.common.requests.BrokerRegistrationResponse;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.metadata.BrokerState;
import org.apache.kafka.metadata.VersionRange;
import org.apache.kafka.server.NodeToControllerChannelManager;
import org.apache.kafka.server.common.Features;
import org.apache.kafka.server.common.MetadataVersion;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;
import scala.Function0;
import scala.Function1;
import scala.Predef;
import scala.Predef$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.SetLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Set;
import scala.collection.immutable.Set$;
import scala.collection.mutable.Buffer$;
import scala.jdk.CollectionConverters$;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.LongRef;
import scala.runtime.java8.JFunction0;

@Timeout(value=12L)
@ScalaSignature(bytes="\u0006\u0001\u0005Ud\u0001B\n\u0015\u0001eAQ\u0001\t\u0001\u0005\u0002\u0005Bq\u0001\n\u0001A\u0002\u0013%Q\u0005C\u0004*\u0001\u0001\u0007I\u0011\u0002\u0016\t\rA\u0002\u0001\u0015)\u0003'\u0011\u0015\t\u0004\u0001\"\u00013\u0011\u0015\u0001\u0005\u0001\"\u0001B\u0011\u0015Q\u0005\u0001\"\u0001L\u0011\u0015A\u0006\u0001\"\u00013\u0011\u0015i\u0006\u0001\"\u00013\u0011\u0015y\u0006\u0001\"\u00013\u0011\u0015\t\u0007\u0001\"\u0001c\u0011\u0015Q\b\u0001\"\u00013\u0011\u0015a\b\u0001\"\u00013\u0011\u0015q\b\u0001\"\u0001\u0000\u0011\u001d\t\t\u0005\u0001C\u0001\u0003\u0007Ba!!\u0018\u0001\t\u0003\u0011\u0004BBA1\u0001\u0011\u0005!\u0007\u0003\u0004\u0002f\u0001!\tA\r\u0002\u001b\u0005J|7.\u001a:MS\u001a,7-_2mK6\u000bg.Y4feR+7\u000f\u001e\u0006\u0003+Y\taa]3sm\u0016\u0014(\"A\f\u0002\u000b-\fgm[1\u0004\u0001M\u0011\u0001A\u0007\t\u00037yi\u0011\u0001\b\u0006\u0002;\u0005)1oY1mC&\u0011q\u0004\b\u0002\u0007\u0003:L(+\u001a4\u0002\rqJg.\u001b;?)\u0005\u0011\u0003CA\u0012\u0001\u001b\u0005!\u0012aB7b]\u0006<WM]\u000b\u0002MA\u00111eJ\u0005\u0003QQ\u0011aC\u0011:pW\u0016\u0014H*\u001b4fGf\u001cG.Z'b]\u0006<WM]\u0001\f[\u0006t\u0017mZ3s?\u0012*\u0017\u000f\u0006\u0002,]A\u00111\u0004L\u0005\u0003[q\u0011A!\u00168ji\"9qfAA\u0001\u0002\u00041\u0013a\u0001=%c\u0005AQ.\u00198bO\u0016\u0014\b%\u0001\u0005uK\u0006\u0014Hi\\<o)\u0005Y\u0003FA\u00035!\t)d(D\u00017\u0015\t9\u0004(A\u0002ba&T!!\u000f\u001e\u0002\u000f),\b/\u001b;fe*\u00111\bP\u0001\u0006UVt\u0017\u000e\u001e\u0006\u0002{\u0005\u0019qN]4\n\u0005}2$!C!gi\u0016\u0014X)Y2i\u0003A\u0019wN\u001c4jOB\u0013x\u000e]3si&,7/F\u0001C!\t\u0019\u0005*D\u0001E\u0015\t)e)\u0001\u0003vi&d'\"A$\u0002\t)\fg/Y\u0005\u0003\u0013\u0012\u0013!\u0002\u0015:pa\u0016\u0014H/[3t\u0003ei\u0017n\u001a:bi&|gnQ8oM&<\u0007K]8qKJ$\u0018.Z:\u0015\u0005\tc\u0005\"B'\b\u0001\u0004q\u0015aA5caB\u0011qJV\u0007\u0002!*\u0011\u0011KU\u0001\u0007G>lWn\u001c8\u000b\u0005U\u0019&BA\fU\u0015\t)F(\u0001\u0004ba\u0006\u001c\u0007.Z\u0005\u0003/B\u0013q\"T3uC\u0012\fG/\u0019,feNLwN\\\u0001\u0013i\u0016\u001cHo\u0011:fCR,\u0017I\u001c3DY>\u001cX\r\u000b\u0002\t5B\u0011QgW\u0005\u00039Z\u0012A\u0001V3ti\u00069B/Z:u\u0007J,\u0017\r^3Ti\u0006\u0014H/\u00118e\u00072|7/\u001a\u0015\u0003\u0013i\u000b!\u0004^3tiN+8mY3tg\u001a,HNU3hSN$(/\u0019;j_:D#A\u0003.\u0002SQ,7\u000f^*vG\u000e,7o\u001d4vYJ+w-[:ue\u0006$\u0018n\u001c8EkJLgnZ'jOJ\fG/[8o)\tY3\rC\u0003e\u0017\u0001\u0007Q-\u0001\fo_:Le.\u001b;jC2\\%/\u00194u-\u0016\u00148/[8o!\tYb-\u0003\u0002h9\t9!i\\8mK\u0006t\u0007\u0006B\u0006jcJ\u0004\"A[8\u000e\u0003-T!\u0001\\7\u0002\u0011A\u0014xN^5eKJT!A\u001c\u001d\u0002\rA\f'/Y7t\u0013\t\u00018NA\u0006WC2,XmU8ve\u000e,\u0017\u0001\u00032p_2,\u0017M\\:-\u0005M$\u0018$A\u0001\u001a\u0003\u0001A#a\u0003<\u0011\u0005]DX\"A7\n\u0005el'!\u0005)be\u0006lW\r^3sSj,G\rV3ti\u00069B/Z:u%\u0016<\u0017n\u001d;sCRLwN\u001c+j[\u0016|W\u000f\u001e\u0015\u0003\u0019i\u000ba\u0003^3ti\u000e{g\u000e\u001e:pY2,Gm\u00155vi\u0012|wO\u001c\u0015\u0003\u001bi\u000bq\u0002\u001d:fa\u0006\u0014XMU3ta>t7/Z\u000b\u0005\u0003\u0003\t\u0019\u0002\u0006\u0004\u0002\u0004\u00055\u0012q\u0007\t\u0007\u0003\u000b\tY!a\u0004\u000e\u0005\u0005\u001d!bAA\u0005\t\u0006Q1m\u001c8dkJ\u0014XM\u001c;\n\t\u00055\u0011q\u0001\u0002\u0007\rV$XO]3\u0011\t\u0005E\u00111\u0003\u0007\u0001\t\u001d\t)B\u0004b\u0001\u0003/\u0011\u0011\u0001V\t\u0005\u00033\ty\u0002E\u0002\u001c\u00037I1!!\b\u001d\u0005\u001dqu\u000e\u001e5j]\u001e\u0004B!!\t\u0002*5\u0011\u00111\u0005\u0006\u0005\u0003K\t9#\u0001\u0005sKF,Xm\u001d;t\u0015\t\t6+\u0003\u0003\u0002,\u0005\r\"aD!cgR\u0014\u0018m\u0019;SKF,Xm\u001d;\t\u000f\u0005=b\u00021\u0001\u00022\u0005\u00191\r\u001e=\u0011\u0007\r\n\u0019$C\u0002\u00026Q\u0011qCU3hSN$(/\u0019;j_:$Vm\u001d;D_:$X\r\u001f;\t\u000f\u0005eb\u00021\u0001\u0002<\u0005A!/Z:q_:\u001cX\r\u0005\u0003\u0002\"\u0005u\u0012\u0002BA \u0003G\u0011\u0001#\u00112tiJ\f7\r\u001e*fgB|gn]3\u0002\tA|G\u000e\\\u000b\u0005\u0003\u000b\nI\u0005\u0006\u0005\u0002H\u0005M\u0013QKA,!\u0011\t\t\"!\u0013\u0005\u000f\u0005UqB1\u0001\u0002LE!\u0011\u0011DA'!\rY\u0012qJ\u0005\u0004\u0003#b\"aA!os\"9\u0011qF\bA\u0002\u0005E\u0002\"\u0002\u0013\u0010\u0001\u00041\u0003bBA-\u001f\u0001\u0007\u00111L\u0001\u0007MV$XO]3\u0011\r\u0005\u0015\u00111BA$\u0003\u0015\"Xm\u001d;BY^\f\u0017p]*f]\u0012\u001c\u0018iY2v[Vd\u0017\r^3e\u001f\u001a4G.\u001b8f\t&\u00148\u000f\u000b\u0002\u00115\u0006aB/Z:u%\u0016<\u0017n\u001d;sCRLwN\\%oG2,H-Z:ESJ\u001c\bFA\t[\u0003\u001d\"Xm\u001d;Le\u00064GO\u0013\"P\t6+G/\u00193bi\u00064VM]:j_:,\u0006\u000fZ1uK\u00163XM\u001c;)\u0005IQ\u0006f\u0002\u0001\u0002l\u0005E\u00141\u000f\t\u0004k\u00055\u0014bAA8m\t9A+[7f_V$\u0018!\u0002<bYV,g$\u0001\u0007")
public class BrokerLifecycleManagerTest {
    private BrokerLifecycleManager manager = null;

    private BrokerLifecycleManager manager() {
        return this.manager;
    }

    private void manager_$eq(BrokerLifecycleManager x$1) {
        this.manager = x$1;
    }

    @AfterEach
    public void tearDown() {
        if (this.manager() != null) {
            this.manager().close();
            return;
        }
    }

    public Properties configProperties() {
        Properties properties = new Properties();
        properties.setProperty("log.dirs", "/tmp/foo");
        properties.setProperty("process.roles", "broker");
        properties.setProperty("node.id", "1");
        properties.setProperty("controller.quorum.voters", "2@localhost:9093");
        properties.setProperty("controller.listener.names", "SSL");
        properties.setProperty("initial.broker.registration.timeout.ms", "300000");
        properties.setProperty("broker.heartbeat.interval.ms", "100");
        return properties;
    }

    public Properties migrationConfigProperties(MetadataVersion ibp) {
        Properties migrationConfigProperties = this.configProperties();
        migrationConfigProperties.setProperty("zookeeper.metadata.migration.enable", "true");
        migrationConfigProperties.setProperty("zookeeper.connect", "localhost:2181");
        migrationConfigProperties.setProperty("process.roles", "");
        migrationConfigProperties.setProperty("inter.broker.protocol.version", ibp.toString());
        return migrationConfigProperties;
    }

    @Test
    public void testCreateAndClose() {
        RegistrationTestContext context = new RegistrationTestContext(this.configProperties());
        this.manager_$eq(new BrokerLifecycleManager(context.config(), (Time)context.time(), "create-and-close-", false, (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Uuid[]{Uuid.fromString((String)"oFoTeS9QT0aAyCyH41v45A")})), BrokerLifecycleManager$.MODULE$.$lessinit$greater$default$6()));
        this.manager().close();
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testCreateStartAndClose() {
        RegistrationTestContext context = new RegistrationTestContext(this.configProperties());
        this.manager_$eq(new BrokerLifecycleManager(context.config(), (Time)context.time(), "create-start-and-close-", false, (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Uuid[]{Uuid.fromString((String)"uiUADXZWTPixVvp6UWFWnw")})), BrokerLifecycleManager$.MODULE$.$lessinit$greater$default$6()));
        Assertions.assertEquals((Object)BrokerState.NOT_RUNNING, (Object)this.manager().state());
        this.manager().start((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> context.highestMetadataOffset().get(), (NodeToControllerChannelManager)context.mockChannelManager(), context.clusterId(), context.advertisedListeners(), Collections.emptyMap(), OptionalLong.empty());
        TestUtils$ testUtils$ = TestUtils$.MODULE$;
        long l = 60000L;
        if (testUtils$ == null) {
            throw null;
        }
        TestUtils$ retry_this = testUtils$;
        LongRef retry_wait = LongRef.create((long)1L);
        long retry_startTime = System.currentTimeMillis();
        while (true) {
            try {
                BrokerLifecycleManagerTest.$anonfun$testCreateStartAndClose$2(this);
            }
            catch (AssertionError retry_e) {
                void retry_maxWaitMs;
                if (System.currentTimeMillis() - retry_startTime > retry_maxWaitMs) {
                    throw retry_e;
                }
                if (retry_this.logger().underlying().isInfoEnabled()) {
                    retry_this.logger().underlying().info(retry_this.msgWithLogIdent(TestUtils$.$anonfun$retry$1(retry_wait)));
                }
                Thread.sleep(retry_wait.elem);
                retry_wait.elem += package$.MODULE$.min(retry_wait.elem, 1000L);
                continue;
            }
            break;
        }
        this.manager().close();
        Assertions.assertEquals((Object)BrokerState.SHUTTING_DOWN, (Object)this.manager().state());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testSuccessfulRegistration() {
        RegistrationTestContext context = new RegistrationTestContext(this.configProperties());
        this.manager_$eq(new BrokerLifecycleManager(context.config(), (Time)context.time(), "successful-registration-", false, (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Uuid[]{Uuid.fromString((String)"gCpDJgRlS2CBCpxoP2VMsQ")})), BrokerLifecycleManager$.MODULE$.$lessinit$greater$default$6()));
        Node controllerNode = new Node(3000, "localhost", 8021);
        context.controllerNodeProvider().node().set(controllerNode);
        this.manager().start((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> context.highestMetadataOffset().get(), (NodeToControllerChannelManager)context.mockChannelManager(), context.clusterId(), context.advertisedListeners(), Collections.emptyMap(), OptionalLong.of(10L));
        TestUtils$ testUtils$ = TestUtils$.MODULE$;
        long l = 60000L;
        if (testUtils$ == null) {
            throw null;
        }
        TestUtils$ retry_this = testUtils$;
        LongRef retry_wait = LongRef.create((long)1L);
        long retry_startTime = System.currentTimeMillis();
        while (true) {
            try {
                BrokerLifecycleManagerTest.$anonfun$testSuccessfulRegistration$2(context);
            }
            catch (AssertionError retry_e) {
                void retry_maxWaitMs;
                if (System.currentTimeMillis() - retry_startTime > retry_maxWaitMs) {
                    throw retry_e;
                }
                if (retry_this.logger().underlying().isInfoEnabled()) {
                    retry_this.logger().underlying().info(retry_this.msgWithLogIdent(TestUtils$.$anonfun$retry$1(retry_wait)));
                }
                Thread.sleep(retry_wait.elem);
                retry_wait.elem += package$.MODULE$.min(retry_wait.elem, 1000L);
                continue;
            }
            break;
        }
        context.mockClient().prepareResponseFrom((AbstractResponse)new BrokerRegistrationResponse(new BrokerRegistrationResponseData().setBrokerEpoch(1000L)), controllerNode);
        TestUtils$ testUtils$2 = TestUtils$.MODULE$;
        long l2 = 10000L;
        if (testUtils$2 == null) {
            throw null;
        }
        TestUtils$ retry_this2 = testUtils$2;
        LongRef retry_wait2 = LongRef.create((long)1L);
        long retry_startTime2 = System.currentTimeMillis();
        while (true) {
            try {
                BrokerLifecycleManagerTest.$anonfun$testSuccessfulRegistration$3(this, context);
            }
            catch (AssertionError retry_e) {
                void retry_maxWaitMs;
                if (System.currentTimeMillis() - retry_startTime2 > retry_maxWaitMs) {
                    throw retry_e;
                }
                if (retry_this2.logger().underlying().isInfoEnabled()) {
                    retry_this2.logger().underlying().info(retry_this2.msgWithLogIdent(TestUtils$.$anonfun$retry$1(retry_wait2)));
                }
                Thread.sleep(retry_wait2.elem);
                retry_wait2.elem += package$.MODULE$.min(retry_wait2.elem, 1000L);
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - void declaration
     */
    @ParameterizedTest
    @ValueSource(booleans={true, false})
    public void testSuccessfulRegistrationDuringMigration(boolean nonInitialKraftVersion) {
        MetadataVersion ibp = nonInitialKraftVersion ? MetadataVersion.IBP_3_9_IV0 : MetadataVersion.IBP_3_8_IV0;
        RegistrationTestContext context = new RegistrationTestContext(this.migrationConfigProperties(ibp));
        this.manager_$eq(new BrokerLifecycleManager(context.config(), (Time)context.time(), "successful-registration-", false, (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Uuid[]{Uuid.fromString((String)"gCpDJgRlS2CBCpxoP2VMsQ")})), BrokerLifecycleManager$.MODULE$.$lessinit$greater$default$6()));
        Node controllerNode = new Node(3000, "localhost", 8021);
        context.controllerNodeProvider().node().set(controllerNode);
        scala.collection.immutable.Map featuresRemapped = BrokerFeatures$.MODULE$.createDefaultFeatureMap(BrokerFeatures$.MODULE$.createDefault(true)).$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"metadata.version"), (Object)VersionRange.of((short)ibp.featureLevel(), (short)ibp.featureLevel())));
        this.manager().start((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> context.highestMetadataOffset().get(), (NodeToControllerChannelManager)context.mockChannelManager(), context.clusterId(), context.advertisedListeners(), (java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)featuresRemapped).asJava(), OptionalLong.of(10L));
        TestUtils$ testUtils$ = TestUtils$.MODULE$;
        long l = 60000L;
        if (testUtils$ == null) {
            throw null;
        }
        TestUtils$ retry_this = testUtils$;
        LongRef retry_wait = LongRef.create((long)1L);
        long retry_startTime = System.currentTimeMillis();
        while (true) {
            try {
                BrokerLifecycleManagerTest.$anonfun$testSuccessfulRegistrationDuringMigration$2(context, ibp, nonInitialKraftVersion);
            }
            catch (AssertionError retry_e) {
                void retry_maxWaitMs;
                if (System.currentTimeMillis() - retry_startTime > retry_maxWaitMs) {
                    throw retry_e;
                }
                if (retry_this.logger().underlying().isInfoEnabled()) {
                    retry_this.logger().underlying().info(retry_this.msgWithLogIdent(TestUtils$.$anonfun$retry$1(retry_wait)));
                }
                Thread.sleep(retry_wait.elem);
                retry_wait.elem += package$.MODULE$.min(retry_wait.elem, 1000L);
                continue;
            }
            break;
        }
        context.mockClient().prepareResponseFrom((AbstractResponse)new BrokerRegistrationResponse(new BrokerRegistrationResponseData().setBrokerEpoch(1000L)), controllerNode);
        TestUtils$ testUtils$2 = TestUtils$.MODULE$;
        long l2 = 10000L;
        if (testUtils$2 == null) {
            throw null;
        }
        TestUtils$ retry_this2 = testUtils$2;
        LongRef retry_wait2 = LongRef.create((long)1L);
        long retry_startTime2 = System.currentTimeMillis();
        while (true) {
            try {
                BrokerLifecycleManagerTest.$anonfun$testSuccessfulRegistrationDuringMigration$3(this, context);
            }
            catch (AssertionError retry_e) {
                void retry_maxWaitMs;
                if (System.currentTimeMillis() - retry_startTime2 > retry_maxWaitMs) {
                    throw retry_e;
                }
                if (retry_this2.logger().underlying().isInfoEnabled()) {
                    retry_this2.logger().underlying().info(retry_this2.msgWithLogIdent(TestUtils$.$anonfun$retry$1(retry_wait2)));
                }
                Thread.sleep(retry_wait2.elem);
                retry_wait2.elem += package$.MODULE$.min(retry_wait2.elem, 1000L);
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testRegistrationTimeout() {
        RegistrationTestContext context = new RegistrationTestContext(this.configProperties());
        Node controllerNode = new Node(3000, "localhost", 8021);
        this.manager_$eq(new BrokerLifecycleManager(context.config(), (Time)context.time(), "registration-timeout-", false, (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Uuid[]{Uuid.fromString((String)"9XBOAtr4T0Wbx2sbiWh6xg")})), BrokerLifecycleManager$.MODULE$.$lessinit$greater$default$6()));
        context.controllerNodeProvider().node().set(controllerNode);
        BrokerLifecycleManagerTest.newDuplicateRegistrationResponse$1(context, controllerNode);
        Assertions.assertEquals((int)1, (int)context.mockClient().futureResponses().size());
        this.manager().start((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> context.highestMetadataOffset().get(), (NodeToControllerChannelManager)context.mockChannelManager(), context.clusterId(), context.advertisedListeners(), Collections.emptyMap(), OptionalLong.empty());
        TestUtils$ testUtils$ = TestUtils$.MODULE$;
        long l = 60000L;
        if (testUtils$ == null) {
            throw null;
        }
        TestUtils$ retry_this = testUtils$;
        LongRef retry_wait = LongRef.create((long)1L);
        long retry_startTime = System.currentTimeMillis();
        while (true) {
            try {
                BrokerLifecycleManagerTest.$anonfun$testRegistrationTimeout$2(context);
            }
            catch (AssertionError retry_e) {
                void retry_maxWaitMs;
                if (System.currentTimeMillis() - retry_startTime > retry_maxWaitMs) {
                    throw retry_e;
                }
                if (retry_this.logger().underlying().isInfoEnabled()) {
                    retry_this.logger().underlying().info(retry_this.msgWithLogIdent(TestUtils$.$anonfun$retry$1(retry_wait)));
                }
                Thread.sleep(retry_wait.elem);
                retry_wait.elem += package$.MODULE$.min(retry_wait.elem, 1000L);
                continue;
            }
            break;
        }
        BrokerLifecycleManagerTest.newDuplicateRegistrationResponse$1(context, controllerNode);
        TestUtils$ testUtils$2 = TestUtils$.MODULE$;
        long l2 = 60000L;
        if (testUtils$2 == null) {
            throw null;
        }
        TestUtils$ retry_this2 = testUtils$2;
        LongRef retry_wait2 = LongRef.create((long)1L);
        long retry_startTime2 = System.currentTimeMillis();
        while (true) {
            try {
                BrokerLifecycleManagerTest.$anonfun$testRegistrationTimeout$3(this, context);
            }
            catch (AssertionError retry_e) {
                void retry_maxWaitMs;
                if (System.currentTimeMillis() - retry_startTime2 > retry_maxWaitMs) {
                    throw retry_e;
                }
                if (retry_this2.logger().underlying().isInfoEnabled()) {
                    retry_this2.logger().underlying().info(retry_this2.msgWithLogIdent(TestUtils$.$anonfun$retry$1(retry_wait2)));
                }
                Thread.sleep(retry_wait2.elem);
                retry_wait2.elem += package$.MODULE$.min(retry_wait2.elem, 1000L);
                continue;
            }
            break;
        }
        context.time().sleep(300000L);
        TestUtils$ testUtils$3 = TestUtils$.MODULE$;
        long l3 = 60000L;
        if (testUtils$3 == null) {
            throw null;
        }
        TestUtils$ retry_this3 = testUtils$3;
        LongRef retry_wait3 = LongRef.create((long)1L);
        long retry_startTime3 = System.currentTimeMillis();
        while (true) {
            try {
                BrokerLifecycleManagerTest.$anonfun$testRegistrationTimeout$4(this, context);
            }
            catch (AssertionError retry_e) {
                void retry_maxWaitMs;
                if (System.currentTimeMillis() - retry_startTime3 > retry_maxWaitMs) {
                    throw retry_e;
                }
                if (retry_this3.logger().underlying().isInfoEnabled()) {
                    retry_this3.logger().underlying().info(retry_this3.msgWithLogIdent(TestUtils$.$anonfun$retry$1(retry_wait3)));
                }
                Thread.sleep(retry_wait3.elem);
                retry_wait3.elem += package$.MODULE$.min(retry_wait3.elem, 1000L);
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testControlledShutdown() {
        RegistrationTestContext context = new RegistrationTestContext(this.configProperties());
        this.manager_$eq(new BrokerLifecycleManager(context.config(), (Time)context.time(), "controlled-shutdown-", false, (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Uuid[]{Uuid.fromString((String)"B4RtUz1ySGip3A7ZFYB2dg")})), BrokerLifecycleManager$.MODULE$.$lessinit$greater$default$6()));
        Node controllerNode = new Node(3000, "localhost", 8021);
        context.controllerNodeProvider().node().set(controllerNode);
        context.mockClient().prepareResponseFrom((AbstractResponse)new BrokerRegistrationResponse(new BrokerRegistrationResponseData().setBrokerEpoch(1000L)), controllerNode);
        context.mockClient().prepareResponseFrom((AbstractResponse)new BrokerHeartbeatResponse(new BrokerHeartbeatResponseData().setIsCaughtUp(true)), controllerNode);
        this.manager().start((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> context.highestMetadataOffset().get(), (NodeToControllerChannelManager)context.mockChannelManager(), context.clusterId(), context.advertisedListeners(), Collections.emptyMap(), OptionalLong.empty());
        TestUtils$ testUtils$ = TestUtils$.MODULE$;
        long l = 10000L;
        if (testUtils$ == null) {
            throw null;
        }
        TestUtils$ retry_this = testUtils$;
        LongRef retry_wait = LongRef.create((long)1L);
        long retry_startTime = System.currentTimeMillis();
        while (true) {
            try {
                BrokerLifecycleManagerTest.$anonfun$testControlledShutdown$2(this, context);
            }
            catch (AssertionError retry_e) {
                void retry_maxWaitMs;
                if (System.currentTimeMillis() - retry_startTime > retry_maxWaitMs) {
                    throw retry_e;
                }
                if (retry_this.logger().underlying().isInfoEnabled()) {
                    retry_this.logger().underlying().info(retry_this.msgWithLogIdent(TestUtils$.$anonfun$retry$1(retry_wait)));
                }
                Thread.sleep(retry_wait.elem);
                retry_wait.elem += package$.MODULE$.min(retry_wait.elem, 1000L);
                continue;
            }
            break;
        }
        context.mockClient().prepareResponseFrom((AbstractResponse)new BrokerHeartbeatResponse(new BrokerHeartbeatResponseData().setIsFenced(false)), controllerNode);
        context.time().sleep(20L);
        TestUtils$ testUtils$2 = TestUtils$.MODULE$;
        long l2 = 10000L;
        if (testUtils$2 == null) {
            throw null;
        }
        TestUtils$ retry_this2 = testUtils$2;
        LongRef retry_wait2 = LongRef.create((long)1L);
        long retry_startTime2 = System.currentTimeMillis();
        while (true) {
            try {
                BrokerLifecycleManagerTest.$anonfun$testControlledShutdown$3(this, context);
            }
            catch (AssertionError retry_e) {
                void retry_maxWaitMs;
                if (System.currentTimeMillis() - retry_startTime2 > retry_maxWaitMs) {
                    throw retry_e;
                }
                if (retry_this2.logger().underlying().isInfoEnabled()) {
                    retry_this2.logger().underlying().info(retry_this2.msgWithLogIdent(TestUtils$.$anonfun$retry$1(retry_wait2)));
                }
                Thread.sleep(retry_wait2.elem);
                retry_wait2.elem += package$.MODULE$.min(retry_wait2.elem, 1000L);
                continue;
            }
            break;
        }
        this.manager().beginControlledShutdown();
        TestUtils$ testUtils$3 = TestUtils$.MODULE$;
        long l3 = 10000L;
        if (testUtils$3 == null) {
            throw null;
        }
        TestUtils$ retry_this3 = testUtils$3;
        LongRef retry_wait3 = LongRef.create((long)1L);
        long retry_startTime3 = System.currentTimeMillis();
        while (true) {
            try {
                BrokerLifecycleManagerTest.$anonfun$testControlledShutdown$4(this, context);
            }
            catch (AssertionError retry_e) {
                void retry_maxWaitMs;
                if (System.currentTimeMillis() - retry_startTime3 > retry_maxWaitMs) {
                    throw retry_e;
                }
                if (retry_this3.logger().underlying().isInfoEnabled()) {
                    retry_this3.logger().underlying().info(retry_this3.msgWithLogIdent(TestUtils$.$anonfun$retry$1(retry_wait3)));
                }
                Thread.sleep(retry_wait3.elem);
                retry_wait3.elem += package$.MODULE$.min(retry_wait3.elem, 1000L);
                continue;
            }
            break;
        }
        context.mockClient().respond(body -> {
            if (body instanceof BrokerHeartbeatRequest) {
                Assertions.assertTrue((boolean)((BrokerHeartbeatRequest)body).data().wantShutDown());
                return true;
            }
            return false;
        }, (AbstractResponse)new BrokerHeartbeatResponse(new BrokerHeartbeatResponseData().setShouldShutDown(true)));
        TestUtils$ testUtils$4 = TestUtils$.MODULE$;
        long l4 = 10000L;
        if (testUtils$4 == null) {
            throw null;
        }
        TestUtils$ retry_this4 = testUtils$4;
        LongRef retry_wait4 = LongRef.create((long)1L);
        long retry_startTime4 = System.currentTimeMillis();
        while (true) {
            try {
                BrokerLifecycleManagerTest.$anonfun$testControlledShutdown$6(this, context);
            }
            catch (AssertionError retry_e) {
                void retry_maxWaitMs;
                if (System.currentTimeMillis() - retry_startTime4 > retry_maxWaitMs) {
                    throw retry_e;
                }
                if (retry_this4.logger().underlying().isInfoEnabled()) {
                    retry_this4.logger().underlying().info(retry_this4.msgWithLogIdent(TestUtils$.$anonfun$retry$1(retry_wait4)));
                }
                Thread.sleep(retry_wait4.elem);
                retry_wait4.elem += package$.MODULE$.min(retry_wait4.elem, 1000L);
                continue;
            }
            break;
        }
        this.manager().controlledShutdownFuture().get();
    }

    public <T extends AbstractRequest> Future<T> prepareResponse(RegistrationTestContext ctx, AbstractResponse response) {
        CompletableFuture result = new CompletableFuture();
        ctx.mockClient().prepareResponseFrom(body -> result.complete(body), response, ctx.controllerNodeProvider().node().get());
        return result;
    }

    public <T> T poll(RegistrationTestContext ctx, BrokerLifecycleManager manager, Future<T> future) {
        while (ctx.mockChannelManager().unsentQueue().isEmpty()) {
            manager.eventQueue().cancelDeferred("initialRegistrationTimeout");
            if (manager.eventQueue().firstDeferredIfIdling().isPresent()) {
                ctx.time().sleep(5L);
            }
            manager.eventQueue().wakeup();
        }
        while (!future.isDone()) {
            ctx.poll();
        }
        return future.get();
    }

    @Test
    public void testAlwaysSendsAccumulatedOfflineDirs() {
        RegistrationTestContext ctx = new RegistrationTestContext(this.configProperties());
        this.manager_$eq(new BrokerLifecycleManager(ctx.config(), (Time)ctx.time(), "offline-dirs-sent-in-heartbeat-", false, (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Uuid[]{Uuid.fromString((String)"0IbF1sjhSGG6FNvnrPbqQg")})), BrokerLifecycleManager$.MODULE$.$lessinit$greater$default$6()));
        Node controllerNode = new Node(3000, "localhost", 8021);
        ctx.controllerNodeProvider().node().set(controllerNode);
        Future registration = this.prepareResponse(ctx, (AbstractResponse)new BrokerRegistrationResponse(new BrokerRegistrationResponseData().setBrokerEpoch(1000L)));
        this.manager().start((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> ctx.highestMetadataOffset().get(), (NodeToControllerChannelManager)ctx.mockChannelManager(), ctx.clusterId(), ctx.advertisedListeners(), Collections.emptyMap(), OptionalLong.empty());
        this.poll(ctx, this.manager(), registration);
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().empty(), (Object)this.nextHeartbeatDirs$1(ctx));
        this.manager().propagateDirectoryFailure(Uuid.fromString((String)"h3sC4Yk-Q9-fd0ntJTocCA"), Integer.MAX_VALUE);
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"h3sC4Yk-Q9-fd0ntJTocCA"})), (Object)this.nextHeartbeatDirs$1(ctx));
        this.manager().propagateDirectoryFailure(Uuid.fromString((String)"ej8Q9_d2Ri6FXNiTxKFiow"), Integer.MAX_VALUE);
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"h3sC4Yk-Q9-fd0ntJTocCA", "ej8Q9_d2Ri6FXNiTxKFiow"})), (Object)this.nextHeartbeatDirs$1(ctx));
        this.manager().propagateDirectoryFailure(Uuid.fromString((String)"1iF76HVNRPqC7Y4r6647eg"), Integer.MAX_VALUE);
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"h3sC4Yk-Q9-fd0ntJTocCA", "ej8Q9_d2Ri6FXNiTxKFiow", "1iF76HVNRPqC7Y4r6647eg"})), (Object)this.nextHeartbeatDirs$1(ctx));
    }

    @Test
    public void testRegistrationIncludesDirs() {
        Set logDirs = (Set)((SetLike)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"ad5FLIeCTnaQdai5vOjeng", "ybdzUKmYSLK6oiIpI6CPlw"}))).map((Function1 & Serializable & scala.Serializable)x$1 -> Uuid.fromString((String)x$1), Set$.MODULE$.canBuildFrom());
        RegistrationTestContext ctx = new RegistrationTestContext(this.configProperties());
        this.manager_$eq(new BrokerLifecycleManager(ctx.config(), (Time)ctx.time(), "registration-includes-dirs-", false, logDirs, BrokerLifecycleManager$.MODULE$.$lessinit$greater$default$6()));
        Node controllerNode = new Node(3000, "localhost", 8021);
        ctx.controllerNodeProvider().node().set(controllerNode);
        Future registration = this.prepareResponse(ctx, (AbstractResponse)new BrokerRegistrationResponse(new BrokerRegistrationResponseData().setBrokerEpoch(1000L)));
        this.manager().start((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> ctx.highestMetadataOffset().get(), (NodeToControllerChannelManager)ctx.mockChannelManager(), ctx.clusterId(), ctx.advertisedListeners(), Collections.emptyMap(), OptionalLong.empty());
        BrokerRegistrationRequest request = (BrokerRegistrationRequest)this.poll(ctx, this.manager(), registration);
        Assertions.assertEquals((Object)logDirs, (Object)((TraversableOnce)CollectionConverters$.MODULE$.asScalaBufferConverter(request.data().logDirs()).asScala()).toSet());
    }

    @Test
    public void testKraftJBODMetadataVersionUpdateEvent() {
        RegistrationTestContext ctx = new RegistrationTestContext(this.configProperties());
        this.manager_$eq(new BrokerLifecycleManager(ctx.config(), (Time)ctx.time(), "jbod-metadata-version-update", false, (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Uuid[]{Uuid.fromString((String)"gCpDJgRlS2CBCpxoP2VMsQ")})), BrokerLifecycleManager$.MODULE$.$lessinit$greater$default$6()));
        Node controllerNode = new Node(3000, "localhost", 8021);
        ctx.controllerNodeProvider().node().set(controllerNode);
        this.manager().start((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> ctx.highestMetadataOffset().get(), (NodeToControllerChannelManager)ctx.mockChannelManager(), ctx.clusterId(), ctx.advertisedListeners(), Collections.emptyMap(), OptionalLong.of(10L));
        Assertions.assertEquals((long)10L, (long)this.nextRegistrationRequest$1(1000L, ctx).data().previousBrokerEpoch());
        this.nextHeartbeatRequest$1(ctx);
        Assertions.assertEquals((long)1000L, (long)this.manager().brokerEpoch());
        this.manager().resendBrokerRegistrationUnlessZkMode();
        this.nextRegistrationRequest$1(1200L, ctx);
        this.nextHeartbeatRequest$1(ctx);
        Assertions.assertEquals((long)1200L, (long)this.manager().brokerEpoch());
    }

    public static final /* synthetic */ void $anonfun$testCreateStartAndClose$2(BrokerLifecycleManagerTest $this) {
        Assertions.assertEquals((Object)BrokerState.STARTING, (Object)$this.manager().state());
    }

    public static final /* synthetic */ void $anonfun$testSuccessfulRegistration$2(RegistrationTestContext context$2) {
        Assertions.assertEquals((int)1, (int)context$2.mockChannelManager().unsentQueue().size());
        Assertions.assertEquals((long)10L, (long)((BrokerRegistrationRequest)context$2.mockChannelManager().unsentQueue().getFirst().request().build()).data().previousBrokerEpoch());
    }

    public static final /* synthetic */ void $anonfun$testSuccessfulRegistration$3(BrokerLifecycleManagerTest $this, RegistrationTestContext context$2) {
        context$2.poll();
        Assertions.assertEquals((long)1000L, (long)$this.manager().brokerEpoch());
    }

    public static final /* synthetic */ void $anonfun$testSuccessfulRegistrationDuringMigration$2(RegistrationTestContext context$3, MetadataVersion ibp$1, boolean nonInitialKraftVersion$1) {
        Assertions.assertEquals((int)1, (int)context$3.mockChannelManager().unsentQueue().size());
        BrokerRegistrationRequestData sentBrokerRegistrationData = ((BrokerRegistrationRequest)context$3.mockChannelManager().unsentQueue().getFirst().request().build()).data();
        Assertions.assertEquals((long)10L, (long)sentBrokerRegistrationData.previousBrokerEpoch());
        Assertions.assertEquals((short)ibp$1.featureLevel(), (short)sentBrokerRegistrationData.features().find("metadata.version").maxSupportedVersion());
        if (nonInitialKraftVersion$1) {
            BrokerRegistrationRequestData.Feature sentKraftVersion = sentBrokerRegistrationData.features().find("kraft.version");
            Assertions.assertEquals((short)Features.KRAFT_VERSION.minimumProduction(), (short)sentKraftVersion.minSupportedVersion());
            Assertions.assertEquals((short)Features.KRAFT_VERSION.latestTesting(), (short)sentKraftVersion.maxSupportedVersion());
            return;
        }
    }

    public static final /* synthetic */ void $anonfun$testSuccessfulRegistrationDuringMigration$3(BrokerLifecycleManagerTest $this, RegistrationTestContext context$3) {
        context$3.poll();
        Assertions.assertEquals((long)1000L, (long)$this.manager().brokerEpoch());
    }

    private static final void newDuplicateRegistrationResponse$1(RegistrationTestContext context$4, Node controllerNode$1) {
        context$4.mockClient().prepareResponseFrom((AbstractResponse)new BrokerRegistrationResponse(new BrokerRegistrationResponseData().setErrorCode(Errors.DUPLICATE_BROKER_REGISTRATION.code())), controllerNode$1);
        context$4.mockChannelManager().poll();
    }

    public static final /* synthetic */ void $anonfun$testRegistrationTimeout$2(RegistrationTestContext context$4) {
        context$4.poll();
        Assertions.assertEquals((int)0, (int)context$4.mockClient().futureResponses().size());
    }

    public static final /* synthetic */ void $anonfun$testRegistrationTimeout$3(BrokerLifecycleManagerTest $this, RegistrationTestContext context$4) {
        context$4.time().sleep(100L);
        context$4.poll();
        $this.manager().eventQueue().wakeup();
        Assertions.assertEquals((int)0, (int)context$4.mockClient().futureResponses().size());
    }

    public static final /* synthetic */ void $anonfun$testRegistrationTimeout$4(BrokerLifecycleManagerTest $this, RegistrationTestContext context$4) {
        context$4.poll();
        $this.manager().eventQueue().wakeup();
        Assertions.assertEquals((Object)BrokerState.SHUTTING_DOWN, (Object)$this.manager().state());
        Assertions.assertTrue((boolean)$this.manager().initialCatchUpFuture().isCompletedExceptionally());
        Assertions.assertEquals((long)-1L, (long)$this.manager().brokerEpoch());
    }

    public static final /* synthetic */ void $anonfun$testControlledShutdown$2(BrokerLifecycleManagerTest $this, RegistrationTestContext context$5) {
        context$5.poll();
        $this.manager().eventQueue().wakeup();
        Assertions.assertEquals((Object)BrokerState.RECOVERY, (Object)$this.manager().state());
    }

    public static final /* synthetic */ void $anonfun$testControlledShutdown$3(BrokerLifecycleManagerTest $this, RegistrationTestContext context$5) {
        context$5.poll();
        $this.manager().eventQueue().wakeup();
        Assertions.assertEquals((Object)BrokerState.RUNNING, (Object)$this.manager().state());
    }

    public static final /* synthetic */ void $anonfun$testControlledShutdown$4(BrokerLifecycleManagerTest $this, RegistrationTestContext context$5) {
        context$5.poll();
        $this.manager().eventQueue().wakeup();
        Assertions.assertEquals((Object)BrokerState.PENDING_CONTROLLED_SHUTDOWN, (Object)$this.manager().state());
        Assertions.assertTrue((boolean)context$5.mockClient().hasInFlightRequests());
    }

    public static final /* synthetic */ void $anonfun$testControlledShutdown$6(BrokerLifecycleManagerTest $this, RegistrationTestContext context$5) {
        context$5.poll();
        $this.manager().eventQueue().wakeup();
        Assertions.assertEquals((Object)BrokerState.SHUTTING_DOWN, (Object)$this.manager().state());
    }

    private final Set nextHeartbeatDirs$1(RegistrationTestContext ctx$1) {
        return ((TraversableOnce)((TraversableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(((BrokerHeartbeatRequest)this.poll(ctx$1, this.manager(), this.prepareResponse(ctx$1, (AbstractResponse)new BrokerHeartbeatResponse(new BrokerHeartbeatResponseData())))).data().offlineLogDirs()).asScala()).map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.toString(), Buffer$.MODULE$.canBuildFrom())).toSet();
    }

    private final AbstractRequest doPoll$1(AbstractResponse response, RegistrationTestContext ctx$3) {
        return (AbstractRequest)this.poll(ctx$3, this.manager(), this.prepareResponse(ctx$3, response));
    }

    private final AbstractRequest nextHeartbeatRequest$1(RegistrationTestContext ctx$3) {
        return this.doPoll$1((AbstractResponse)new BrokerHeartbeatResponse(new BrokerHeartbeatResponseData()), ctx$3);
    }

    private final BrokerRegistrationRequest nextRegistrationRequest$1(long epoch, RegistrationTestContext ctx$3) {
        return (BrokerRegistrationRequest)this.doPoll$1((AbstractResponse)new BrokerRegistrationResponse(new BrokerRegistrationResponseData().setBrokerEpoch(epoch)), ctx$3);
    }
}

