/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.OptionalInt;
import java.util.Properties;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import kafka.server.ControllerRegistrationManager;
import kafka.server.RegistrationTestContext;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.message.ControllerRegistrationResponseData;
import org.apache.kafka.common.metadata.FeatureLevelRecord;
import org.apache.kafka.common.metadata.RegisterControllerRecord;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.AbstractResponse;
import org.apache.kafka.common.requests.ControllerRegistrationResponse;
import org.apache.kafka.common.utils.ExponentialBackoff;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.image.MetadataDelta;
import org.apache.kafka.image.MetadataImage;
import org.apache.kafka.image.MetadataProvenance;
import org.apache.kafka.image.loader.LoaderManifest;
import org.apache.kafka.image.loader.LogDeltaManifest;
import org.apache.kafka.image.loader.SnapshotManifest;
import org.apache.kafka.metadata.ListenerInfo;
import org.apache.kafka.metadata.RecordTestUtils;
import org.apache.kafka.metadata.VersionRange;
import org.apache.kafka.raft.LeaderAndEpoch;
import org.apache.kafka.server.NodeToControllerChannelManager;
import org.apache.kafka.server.common.MetadataVersion;
import org.apache.kafka.test.TestUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple3;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction1;

@Timeout(value=60L)
@ScalaSignature(bytes="\u0006\u0001\u0005ed\u0001B\b\u0011\u0001UAQ\u0001\b\u0001\u0005\u0002uAq\u0001\t\u0001C\u0002\u0013%\u0011\u0005\u0003\u0004.\u0001\u0001\u0006IA\t\u0005\u0006]\u0001!Ia\f\u0005\u0006q\u0001!I!\u000f\u0005\u0006-\u0002!Ia\u0016\u0005\u0006A\u0002!I!\u0019\u0005\u0006O\u0002!I\u0001\u001b\u0005\u0006a\u0002!I!\u001d\u0005\b\u0003+\u0001A\u0011AA\f\u0011\u001d\t)\u0004\u0001C\u0001\u0003/Aq!!\u000f\u0001\t\u0003\tY\u0004C\u0004\u0002f\u0001!\t!a\u0006\t\u000f\u0005%\u0004\u0001\"\u0001\u0002\u0018\t\t3i\u001c8ue>dG.\u001a:SK\u001eL7\u000f\u001e:bi&|g.T1oC\u001e,'\u000fV3ti*\u0011\u0011CE\u0001\u0007g\u0016\u0014h/\u001a:\u000b\u0003M\tQa[1gW\u0006\u001c\u0001a\u0005\u0002\u0001-A\u0011qCG\u0007\u00021)\t\u0011$A\u0003tG\u0006d\u0017-\u0003\u0002\u001c1\t1\u0011I\\=SK\u001a\fa\u0001P5oSRtD#\u0001\u0010\u0011\u0005}\u0001Q\"\u0001\t\u0002\u0017\r|g\u000e\u001e:pY2,'/M\u000b\u0002EA\u00111eK\u0007\u0002I)\u0011QEJ\u0001\u0007G>lWn\u001c8\u000b\u0005M9#B\u0001\u0015*\u0003\u0019\t\u0007/Y2iK*\t!&A\u0002pe\u001eL!\u0001\f\u0013\u0003\t9{G-Z\u0001\rG>tGO]8mY\u0016\u0014\u0018\u0007I\u0001\u0011G>tg-[4Qe>\u0004XM\u001d;jKN,\u0012\u0001\r\t\u0003cYj\u0011A\r\u0006\u0003gQ\nA!\u001e;jY*\tQ'\u0001\u0003kCZ\f\u0017BA\u001c3\u0005)\u0001&o\u001c9feRLWm]\u0001\u0018GJ,\u0017\r^3TkB\u0004xN\u001d;fI\u001a+\u0017\r^;sKN$\"A\u000f(\u0011\tEZT\bS\u0005\u0003yI\u00121!T1q!\tqTI\u0004\u0002@\u0007B\u0011\u0001\tG\u0007\u0002\u0003*\u0011!\tF\u0001\u0007yI|w\u000e\u001e \n\u0005\u0011C\u0012A\u0002)sK\u0012,g-\u0003\u0002G\u000f\n11\u000b\u001e:j]\u001eT!\u0001\u0012\r\u0011\u0005%cU\"\u0001&\u000b\u0005-3\u0013\u0001C7fi\u0006$\u0017\r^1\n\u00055S%\u0001\u0004,feNLwN\u001c*b]\u001e,\u0007\"B(\u0006\u0001\u0004\u0001\u0016a\b5jO\",7\u000f^*vaB|'\u000f^3e\u001b\u0016$\u0018\rZ1uCZ+'o]5p]B\u0011\u0011\u000bV\u0007\u0002%*\u0011Qe\u0015\u0006\u0003#\u0019J!!\u0016*\u0003\u001f5+G/\u00193bi\u00064VM]:j_:\f\u0001E\\3x\u0007>tGO]8mY\u0016\u0014(+Z4jgR\u0014\u0018\r^5p]6\u000bg.Y4feR\u0011\u0001l\u0017\t\u0003?eK!A\u0017\t\u0003;\r{g\u000e\u001e:pY2,'OU3hSN$(/\u0019;j_:l\u0015M\\1hKJDQ\u0001\u0018\u0004A\u0002u\u000bqaY8oi\u0016DH\u000f\u0005\u0002 =&\u0011q\f\u0005\u0002\u0018%\u0016<\u0017n\u001d;sCRLwN\u001c+fgR\u001cuN\u001c;fqR\fqB]3hSN$XM]3e\u0013:dun\u001a\u000b\u0003E\u0016\u0004\"aF2\n\u0005\u0011D\"a\u0002\"p_2,\u0017M\u001c\u0005\u0006M\u001e\u0001\r\u0001W\u0001\b[\u0006t\u0017mZ3s\u0003!\u0011\boY*uCR\u001cHCA5p!\u00159\"N\u00197m\u0013\tY\u0007D\u0001\u0004UkBdWm\r\t\u0003/5L!A\u001c\r\u0003\t1{gn\u001a\u0005\u0006M\"\u0001\r\u0001W\u0001\u0011I>lU\r^1eCR\fW\u000b\u001d3bi\u0016$RA\u001d={wv\u0004\"a\u001d<\u000e\u0003QT!!\u001e\u0014\u0002\u000b%l\u0017mZ3\n\u0005]$(!D'fi\u0006$\u0017\r^1J[\u0006<W\rC\u0003z\u0013\u0001\u0007!/A\u0005qe\u00164\u0018*\\1hK\")a-\u0003a\u00011\")A0\u0003a\u0001!\u0006yQ.\u001a;bI\u0006$\u0018MV3sg&|g\u000eC\u0003\u007f\u0013\u0001\u0007q0\u0001\u000bsK\u001eL7\u000f\u001e:bi&|g.T8eS\u001aLWM\u001d\t\b/\u0005\u0005\u0011QAA\b\u0013\r\t\u0019\u0001\u0007\u0002\n\rVt7\r^5p]F\u0002B!a\u0002\u0002\f5\u0011\u0011\u0011\u0002\u0006\u0003\u0017\u0012JA!!\u0004\u0002\n\tA\"+Z4jgR,'oQ8oiJ|G\u000e\\3s%\u0016\u001cwN\u001d3\u0011\u000b]\t\t\"!\u0002\n\u0007\u0005M\u0001D\u0001\u0004PaRLwN\\\u0001\u0013i\u0016\u001cHo\u0011:fCR,\u0017I\u001c3DY>\u001cX\r\u0006\u0002\u0002\u001aA\u0019q#a\u0007\n\u0007\u0005u\u0001D\u0001\u0003V]&$\bf\u0001\u0006\u0002\"A!\u00111EA\u0019\u001b\t\t)C\u0003\u0003\u0002(\u0005%\u0012aA1qS*!\u00111FA\u0017\u0003\u001dQW\u000f]5uKJT1!a\f*\u0003\u0015QWO\\5u\u0013\u0011\t\u0019$!\n\u0003\tQ+7\u000f^\u0001\u0018i\u0016\u001cHo\u0011:fCR,7\u000b^1si\u0006sGm\u00117pg\u0016D3aCA\u0011\u0003A!Xm\u001d;SK\u001eL7\u000f\u001e:bi&|g\u000e\u0006\u0003\u0002\u001a\u0005u\u0002BBA \u0019\u0001\u0007!-A\u0012nKR\fG-\u0019;b-\u0016\u00148/[8o'V\u0004\bo\u001c:ugJ+w-[:ue\u0006$\u0018n\u001c8)\u000f1\t\u0019%a\u0015\u0002VA!\u0011QIA(\u001b\t\t9E\u0003\u0003\u0002J\u0005-\u0013\u0001\u00039s_ZLG-\u001a:\u000b\t\u00055\u0013\u0011F\u0001\u0007a\u0006\u0014\u0018-\\:\n\t\u0005E\u0013q\t\u0002\f-\u0006dW/Z*pkJ\u001cW-\u0001\u0005c_>dW-\u00198tY\u0011\t9&!\u0017\u001a\u0003\u0001I\u0012!\u0001\u0015\u0004\u0019\u0005u\u0003\u0003BA0\u0003Cj!!a\u0013\n\t\u0005\r\u00141\n\u0002\u0012!\u0006\u0014\u0018-\\3uKJL'0\u001a3UKN$\u0018A\u0006;fgR<&o\u001c8h\u0013:\u001c\u0017M\u001d8bi&|g.\u00133)\u00075\t\t#\u0001\u000euKN$(+\u001a;sC:\u001cX.\u001b;SK\u001eL7\u000f\u001e:bi&|g\u000eK\u0002\u000f\u0003CAs\u0001AA8\u0003k\n9\b\u0005\u0003\u0002$\u0005E\u0014\u0002BA:\u0003K\u0011q\u0001V5nK>,H/A\u0003wC2,XMH\u0001=\u0001")
public class ControllerRegistrationManagerTest {
    private final Node controller1 = new Node(1, "localhost", 7000);

    private Node controller1() {
        return this.controller1;
    }

    private Properties configProperties() {
        Properties properties = new Properties();
        properties.setProperty("log.dirs", "/tmp/foo");
        properties.setProperty("process.roles", "controller");
        properties.setProperty("listener.security.protocol.map", "CONTROLLER:PLAINTEXT");
        properties.setProperty("listeners", "CONTROLLER://localhost:8001");
        properties.setProperty("controller.listener.names", "CONTROLLER");
        properties.setProperty("node.id", "1");
        properties.setProperty("controller.quorum.voters", "1@localhost:8000,2@localhost:5000,3@localhost:7000");
        return properties;
    }

    private Map<String, VersionRange> createSupportedFeatures(MetadataVersion highestSupportedMetadataVersion) {
        HashMap<String, VersionRange> results = new HashMap<String, VersionRange>();
        results.put("metadata.version", VersionRange.of((short)MetadataVersion.MINIMUM_KRAFT_VERSION.featureLevel(), (short)highestSupportedMetadataVersion.featureLevel()));
        return results;
    }

    private ControllerRegistrationManager newControllerRegistrationManager(RegistrationTestContext context) {
        return new ControllerRegistrationManager(context.config().nodeId(), context.clusterId(), Time.SYSTEM, "controller-registration-manager-test-", this.createSupportedFeatures(MetadataVersion.IBP_3_7_IV0), false, RecordTestUtils.createTestControllerRegistration((int)1, (boolean)false).incarnationId(), ListenerInfo.create((List)((List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)context.config().controllerListeners().map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.toJava(), Seq$.MODULE$.canBuildFrom())).asJava())), new ExponentialBackoff(1L, 2, 100L, 0.02));
    }

    private boolean registeredInLog(ControllerRegistrationManager manager) {
        CompletableFuture registeredInLog = new CompletableFuture();
        manager.eventQueue().append(() -> registeredInLog.complete(BoxesRunTime.boxToBoolean((boolean)manager.registeredInLog())));
        return BoxesRunTime.unboxToBoolean(registeredInLog.get(30L, TimeUnit.SECONDS));
    }

    private Tuple3<Object, Object, Object> rpcStats(ControllerRegistrationManager manager) {
        CompletableFuture failedAttempts = new CompletableFuture();
        manager.eventQueue().append(() -> failedAttempts.complete(new Tuple3((Object)BoxesRunTime.boxToBoolean((boolean)manager.pendingRpc()), (Object)BoxesRunTime.boxToLong((long)manager.successfulRpcs()), (Object)BoxesRunTime.boxToLong((long)manager.failedRpcs()))));
        return (Tuple3)failedAttempts.get(30L, TimeUnit.SECONDS);
    }

    private MetadataImage doMetadataUpdate(MetadataImage prevImage, ControllerRegistrationManager manager, MetadataVersion metadataVersion, Function1<RegisterControllerRecord, Option<RegisterControllerRecord>> registrationModifier) {
        MetadataDelta delta = new MetadataDelta.Builder().setImage(prevImage).build();
        if (!prevImage.features().metadataVersion().equals((Object)metadataVersion)) {
            delta.replay(new FeatureLevelRecord().setName("metadata.version").setFeatureLevel(metadataVersion.featureLevel()));
        }
        if (metadataVersion.isControllerRegistrationSupported()) {
            ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3}))).foreach((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> ((Option)registrationModifier.apply((Object)RecordTestUtils.createTestControllerRegistration((int)i, (boolean)false))).foreach((Function1 & Serializable & scala.Serializable)registration -> {
                delta.replay(registration);
                return BoxedUnit.UNIT;
            }));
        }
        MetadataProvenance provenance = new MetadataProvenance(100L, 200, 300L);
        MetadataImage newImage = delta.apply(provenance);
        SnapshotManifest manifest = !prevImage.features().metadataVersion().equals((Object)metadataVersion) ? new SnapshotManifest(provenance, 1000L) : new LogDeltaManifest.Builder().provenance(provenance).leaderAndEpoch(new LeaderAndEpoch(OptionalInt.of(1), 100)).numBatches(1).elapsedNs(100L).numBytes(200L).build();
        manager.onMetadataUpdate(delta, newImage, (LoaderManifest)manifest);
        return newImage;
    }

    @Test
    public void testCreateAndClose() {
        RegistrationTestContext context = new RegistrationTestContext(this.configProperties());
        ControllerRegistrationManager manager = this.newControllerRegistrationManager(context);
        Assertions.assertFalse((boolean)this.registeredInLog(manager));
        Assertions.assertEquals((Object)new Tuple3((Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)BoxesRunTime.boxToInteger((int)0), (Object)BoxesRunTime.boxToInteger((int)0)), this.rpcStats(manager));
        manager.close();
    }

    @Test
    public void testCreateStartAndClose() {
        RegistrationTestContext context = new RegistrationTestContext(this.configProperties());
        try (ControllerRegistrationManager manager = this.newControllerRegistrationManager(context);){
            manager.start((NodeToControllerChannelManager)context.mockChannelManager());
            Assertions.assertFalse((boolean)this.registeredInLog(manager));
            Assertions.assertEquals((Object)new Tuple3((Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)BoxesRunTime.boxToInteger((int)0), (Object)BoxesRunTime.boxToInteger((int)0)), this.rpcStats(manager));
        }
    }

    /*
     * WARNING - void declaration
     */
    @ParameterizedTest
    @ValueSource(booleans={false, true})
    public void testRegistration(boolean metadataVersionSupportsRegistration) {
        RegistrationTestContext context = new RegistrationTestContext(this.configProperties());
        MetadataVersion metadataVersion = metadataVersionSupportsRegistration ? MetadataVersion.IBP_3_7_IV0 : MetadataVersion.IBP_3_6_IV0;
        try (ControllerRegistrationManager manager = this.newControllerRegistrationManager(context);){
            if (!metadataVersionSupportsRegistration) {
                context.mockClient().prepareUnsupportedVersionResponse(x$2 -> true);
            } else {
                context.controllerNodeProvider().node().set(this.controller1());
            }
            manager.start((NodeToControllerChannelManager)context.mockChannelManager());
            Assertions.assertFalse((boolean)this.registeredInLog(manager));
            Assertions.assertEquals((Object)new Tuple3((Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)BoxesRunTime.boxToInteger((int)0), (Object)BoxesRunTime.boxToInteger((int)0)), this.rpcStats(manager));
            Function1 & Serializable & scala.Serializable intersect = (Function1 & Serializable & scala.Serializable)r -> {
                if (r.controllerId() == 1) {
                    return None$.MODULE$;
                }
                return new Some(r);
            };
            MetadataImage doMetadataUpdate_prevImage = MetadataImage.EMPTY;
            MetadataDelta doMetadataUpdate_delta = new MetadataDelta.Builder().setImage(doMetadataUpdate_prevImage).build();
            if (!doMetadataUpdate_prevImage.features().metadataVersion().equals((Object)metadataVersion)) {
                doMetadataUpdate_delta.replay(new FeatureLevelRecord().setName("metadata.version").setFeatureLevel(metadataVersion.featureLevel()));
            }
            if (metadataVersion.isControllerRegistrationSupported()) {
                void doMetadataUpdate_registrationModifier;
                ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3}))).foreach((Function1)((JFunction1.mcVI.sp & Serializable & scala.Serializable)arg_0 -> ControllerRegistrationManagerTest.$anonfun$doMetadataUpdate$1((Function1)doMetadataUpdate_registrationModifier, doMetadataUpdate_delta, arg_0)));
            }
            MetadataProvenance doMetadataUpdate_provenance = new MetadataProvenance(100L, 200, 300L);
            MetadataImage doMetadataUpdate_newImage = doMetadataUpdate_delta.apply(doMetadataUpdate_provenance);
            SnapshotManifest doMetadataUpdate_manifest = !doMetadataUpdate_prevImage.features().metadataVersion().equals((Object)metadataVersion) ? new SnapshotManifest(doMetadataUpdate_provenance, 1000L) : new LogDeltaManifest.Builder().provenance(doMetadataUpdate_provenance).leaderAndEpoch(new LeaderAndEpoch(OptionalInt.of(1), 100)).numBatches(1).elapsedNs(100L).numBytes(200L).build();
            manager.onMetadataUpdate(doMetadataUpdate_delta, doMetadataUpdate_newImage, (LoaderManifest)doMetadataUpdate_manifest);
            if (!metadataVersionSupportsRegistration) {
                Assertions.assertFalse((boolean)this.registeredInLog(manager));
                Assertions.assertEquals((Object)new Tuple3((Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)BoxesRunTime.boxToInteger((int)0), (Object)BoxesRunTime.boxToInteger((int)0)), this.rpcStats(manager));
            } else {
                void var10_9;
                TestUtils.retryOnExceptionWithTimeout((long)30000L, () -> Assertions.assertEquals((Object)new Tuple3((Object)BoxesRunTime.boxToBoolean((boolean)true), (Object)BoxesRunTime.boxToInteger((int)0), (Object)BoxesRunTime.boxToInteger((int)0)), this.rpcStats(manager)));
                context.mockClient().prepareResponseFrom((AbstractResponse)new ControllerRegistrationResponse(new ControllerRegistrationResponseData()), this.controller1());
                TestUtils.retryOnExceptionWithTimeout((long)30000L, () -> {
                    context.mockChannelManager().poll();
                    Assertions.assertEquals((Object)new Tuple3((Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)BoxesRunTime.boxToInteger((int)1), (Object)BoxesRunTime.boxToInteger((int)0)), this.rpcStats(manager));
                });
                Assertions.assertFalse((boolean)this.registeredInLog(manager));
                Function1 & Serializable & scala.Serializable doMetadataUpdate_registrationModifier = (Function1 & Serializable & scala.Serializable)r -> new Some(r);
                MetadataDelta doMetadataUpdate_delta2 = new MetadataDelta.Builder().setImage((MetadataImage)var10_9).build();
                if (!var10_9.features().metadataVersion().equals((Object)metadataVersion)) {
                    doMetadataUpdate_delta2.replay(new FeatureLevelRecord().setName("metadata.version").setFeatureLevel(metadataVersion.featureLevel()));
                }
                if (metadataVersion.isControllerRegistrationSupported()) {
                    ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3}))).foreach((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> ((Option)registrationModifier.apply((Object)RecordTestUtils.createTestControllerRegistration((int)i, (boolean)false))).foreach((Function1 & Serializable & scala.Serializable)registration -> {
                        delta.replay(registration);
                        return BoxedUnit.UNIT;
                    }));
                }
                MetadataProvenance doMetadataUpdate_provenance2 = new MetadataProvenance(100L, 200, 300L);
                MetadataImage doMetadataUpdate_newImage2 = doMetadataUpdate_delta2.apply(doMetadataUpdate_provenance2);
                SnapshotManifest doMetadataUpdate_manifest2 = !var10_9.features().metadataVersion().equals((Object)metadataVersion) ? new SnapshotManifest(doMetadataUpdate_provenance2, 1000L) : new LogDeltaManifest.Builder().provenance(doMetadataUpdate_provenance2).leaderAndEpoch(new LeaderAndEpoch(OptionalInt.of(1), 100)).numBatches(1).elapsedNs(100L).numBytes(200L).build();
                manager.onMetadataUpdate(doMetadataUpdate_delta2, doMetadataUpdate_newImage2, (LoaderManifest)doMetadataUpdate_manifest2);
                Assertions.assertTrue((boolean)this.registeredInLog(manager));
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testWrongIncarnationId() {
        RegistrationTestContext context = new RegistrationTestContext(this.configProperties());
        try (ControllerRegistrationManager manager = this.newControllerRegistrationManager(context);){
            void doMetadataUpdate_metadataVersion;
            void doMetadataUpdate_metadataVersion2;
            context.controllerNodeProvider().node().set(this.controller1());
            Function1 & Serializable & scala.Serializable intersect = (Function1 & Serializable & scala.Serializable)r -> new Some((Object)r.setIncarnationId(new Uuid(456L, (long)r.controllerId())));
            MetadataVersion metadataVersion = MetadataVersion.IBP_3_7_IV0;
            MetadataImage doMetadataUpdate_prevImage = MetadataImage.EMPTY;
            MetadataDelta doMetadataUpdate_delta = new MetadataDelta.Builder().setImage(doMetadataUpdate_prevImage).build();
            if (!doMetadataUpdate_prevImage.features().metadataVersion().equals((Object)doMetadataUpdate_metadataVersion2)) {
                doMetadataUpdate_delta.replay(new FeatureLevelRecord().setName("metadata.version").setFeatureLevel(doMetadataUpdate_metadataVersion2.featureLevel()));
            }
            if (doMetadataUpdate_metadataVersion2.isControllerRegistrationSupported()) {
                void doMetadataUpdate_registrationModifier;
                ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3}))).foreach((Function1)((JFunction1.mcVI.sp & Serializable & scala.Serializable)arg_0 -> ControllerRegistrationManagerTest.$anonfun$doMetadataUpdate$1((Function1)doMetadataUpdate_registrationModifier, doMetadataUpdate_delta, arg_0)));
            }
            MetadataProvenance doMetadataUpdate_provenance = new MetadataProvenance(100L, 200, 300L);
            MetadataImage doMetadataUpdate_newImage = doMetadataUpdate_delta.apply(doMetadataUpdate_provenance);
            SnapshotManifest doMetadataUpdate_manifest = !doMetadataUpdate_prevImage.features().metadataVersion().equals((Object)doMetadataUpdate_metadataVersion2) ? new SnapshotManifest(doMetadataUpdate_provenance, 1000L) : new LogDeltaManifest.Builder().provenance(doMetadataUpdate_provenance).leaderAndEpoch(new LeaderAndEpoch(OptionalInt.of(1), 100)).numBatches(1).elapsedNs(100L).numBytes(200L).build();
            manager.onMetadataUpdate(doMetadataUpdate_delta, doMetadataUpdate_newImage, (LoaderManifest)doMetadataUpdate_manifest);
            manager.start((NodeToControllerChannelManager)context.mockChannelManager());
            TestUtils.retryOnExceptionWithTimeout((long)30000L, () -> Assertions.assertEquals((Object)new Tuple3((Object)BoxesRunTime.boxToBoolean((boolean)true), (Object)BoxesRunTime.boxToInteger((int)0), (Object)BoxesRunTime.boxToInteger((int)0)), this.rpcStats(manager)));
            context.mockClient().prepareResponseFrom((AbstractResponse)new ControllerRegistrationResponse(new ControllerRegistrationResponseData()), this.controller1());
            TestUtils.retryOnExceptionWithTimeout((long)30000L, () -> {
                context.mockChannelManager().poll();
                Assertions.assertEquals((Object)new Tuple3((Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)BoxesRunTime.boxToInteger((int)1), (Object)BoxesRunTime.boxToInteger((int)0)), this.rpcStats(manager));
            });
            Function1 & Serializable & scala.Serializable intersect2 = (Function1 & Serializable & scala.Serializable)r -> new Some((Object)r.setIncarnationId(new Uuid(457L, (long)r.controllerId())));
            MetadataVersion metadataVersion2 = MetadataVersion.IBP_3_7_IV0;
            MetadataImage doMetadataUpdate_prevImage2 = MetadataImage.EMPTY;
            MetadataDelta doMetadataUpdate_delta2 = new MetadataDelta.Builder().setImage(doMetadataUpdate_prevImage2).build();
            if (!doMetadataUpdate_prevImage2.features().metadataVersion().equals((Object)doMetadataUpdate_metadataVersion)) {
                doMetadataUpdate_delta2.replay(new FeatureLevelRecord().setName("metadata.version").setFeatureLevel(doMetadataUpdate_metadataVersion.featureLevel()));
            }
            if (doMetadataUpdate_metadataVersion.isControllerRegistrationSupported()) {
                void doMetadataUpdate_registrationModifier;
                ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3}))).foreach((Function1)((JFunction1.mcVI.sp & Serializable & scala.Serializable)arg_0 -> ControllerRegistrationManagerTest.$anonfun$doMetadataUpdate$1((Function1)doMetadataUpdate_registrationModifier, doMetadataUpdate_delta2, arg_0)));
            }
            MetadataProvenance doMetadataUpdate_provenance2 = new MetadataProvenance(100L, 200, 300L);
            MetadataImage doMetadataUpdate_newImage2 = doMetadataUpdate_delta2.apply(doMetadataUpdate_provenance2);
            SnapshotManifest doMetadataUpdate_manifest2 = !doMetadataUpdate_prevImage2.features().metadataVersion().equals((Object)doMetadataUpdate_metadataVersion) ? new SnapshotManifest(doMetadataUpdate_provenance2, 1000L) : new LogDeltaManifest.Builder().provenance(doMetadataUpdate_provenance2).leaderAndEpoch(new LeaderAndEpoch(OptionalInt.of(1), 100)).numBatches(1).elapsedNs(100L).numBytes(200L).build();
            manager.onMetadataUpdate(doMetadataUpdate_delta2, doMetadataUpdate_newImage2, (LoaderManifest)doMetadataUpdate_manifest2);
            TestUtils.retryOnExceptionWithTimeout((long)30000L, () -> {
                context.mockChannelManager().poll();
                Assertions.assertEquals((Object)new Tuple3((Object)BoxesRunTime.boxToBoolean((boolean)true), (Object)BoxesRunTime.boxToInteger((int)1), (Object)BoxesRunTime.boxToInteger((int)0)), this.rpcStats(manager));
            });
        }
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testRetransmitRegistration() {
        RegistrationTestContext context = new RegistrationTestContext(this.configProperties());
        try (ControllerRegistrationManager manager = this.newControllerRegistrationManager(context);){
            void doMetadataUpdate_metadataVersion;
            context.controllerNodeProvider().node().set(this.controller1());
            manager.start((NodeToControllerChannelManager)context.mockChannelManager());
            context.mockClient().prepareResponseFrom((AbstractResponse)new ControllerRegistrationResponse(new ControllerRegistrationResponseData().setErrorCode(Errors.UNKNOWN_CONTROLLER_ID.code()).setErrorMessage("Unknown controller 1")), this.controller1());
            context.mockClient().prepareResponseFrom((AbstractResponse)new ControllerRegistrationResponse(new ControllerRegistrationResponseData()), this.controller1());
            Function1 & Serializable & scala.Serializable intersect = (Function1 & Serializable & scala.Serializable)r -> {
                if (r.controllerId() == 1) {
                    return None$.MODULE$;
                }
                return new Some(r);
            };
            MetadataVersion metadataVersion = MetadataVersion.IBP_3_7_IV0;
            MetadataImage doMetadataUpdate_prevImage = MetadataImage.EMPTY;
            MetadataDelta doMetadataUpdate_delta = new MetadataDelta.Builder().setImage(doMetadataUpdate_prevImage).build();
            if (!doMetadataUpdate_prevImage.features().metadataVersion().equals((Object)doMetadataUpdate_metadataVersion)) {
                doMetadataUpdate_delta.replay(new FeatureLevelRecord().setName("metadata.version").setFeatureLevel(doMetadataUpdate_metadataVersion.featureLevel()));
            }
            if (doMetadataUpdate_metadataVersion.isControllerRegistrationSupported()) {
                void doMetadataUpdate_registrationModifier;
                ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3}))).foreach((Function1)((JFunction1.mcVI.sp & Serializable & scala.Serializable)arg_0 -> ControllerRegistrationManagerTest.$anonfun$doMetadataUpdate$1((Function1)doMetadataUpdate_registrationModifier, doMetadataUpdate_delta, arg_0)));
            }
            MetadataProvenance doMetadataUpdate_provenance = new MetadataProvenance(100L, 200, 300L);
            MetadataImage doMetadataUpdate_newImage = doMetadataUpdate_delta.apply(doMetadataUpdate_provenance);
            SnapshotManifest doMetadataUpdate_manifest = !doMetadataUpdate_prevImage.features().metadataVersion().equals((Object)doMetadataUpdate_metadataVersion) ? new SnapshotManifest(doMetadataUpdate_provenance, 1000L) : new LogDeltaManifest.Builder().provenance(doMetadataUpdate_provenance).leaderAndEpoch(new LeaderAndEpoch(OptionalInt.of(1), 100)).numBatches(1).elapsedNs(100L).numBytes(200L).build();
            manager.onMetadataUpdate(doMetadataUpdate_delta, doMetadataUpdate_newImage, (LoaderManifest)doMetadataUpdate_manifest);
            TestUtils.retryOnExceptionWithTimeout((long)30000L, () -> {
                context.mockChannelManager().poll();
                Assertions.assertEquals((Object)new Tuple3((Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)BoxesRunTime.boxToInteger((int)1), (Object)BoxesRunTime.boxToInteger((int)0)), this.rpcStats(manager));
            });
        }
    }
}

