/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.Serializable;
import kafka.server.AbstractCreateTopicsRequestTest;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.message.CreateTopicsRequestData;
import org.apache.kafka.common.message.CreateTopicsResponseData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.ApiError;
import org.apache.kafka.common.requests.CreateTopicsRequest;
import org.apache.kafka.common.requests.CreateTopicsResponse;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;
import scala.Function1;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u000114A!\u0003\u0006\u0001\u001f!)A\u0003\u0001C\u0001+!)q\u0003\u0001C\u00011!)a\t\u0001C\u0001\u000f\")A\n\u0001C\u0001\u001b\")!\u000b\u0001C\u0001'\")\u0001\f\u0001C\u00013\")\u0001\r\u0001C\u0001C\")a\r\u0001C\u0001O\n92I]3bi\u0016$v\u000e]5dgJ+\u0017/^3tiR+7\u000f\u001e\u0006\u0003\u00171\taa]3sm\u0016\u0014(\"A\u0007\u0002\u000b-\fgm[1\u0004\u0001M\u0011\u0001\u0001\u0005\t\u0003#Ii\u0011AC\u0005\u0003')\u0011q$\u00112tiJ\f7\r^\"sK\u0006$X\rV8qS\u000e\u001c(+Z9vKN$H+Z:u\u0003\u0019a\u0014N\\5u}Q\ta\u0003\u0005\u0002\u0012\u0001\u0005iB/Z:u-\u0006d\u0017\u000eZ\"sK\u0006$X\rV8qS\u000e\u001c(+Z9vKN$8\u000f\u0006\u0002\u001a?A\u0011!$H\u0007\u00027)\tA$A\u0003tG\u0006d\u0017-\u0003\u0002\u001f7\t!QK\\5u\u0011\u0015\u0001#\u00011\u0001\"\u0003\u0019\tXo\u001c:v[B\u0011!%\u000b\b\u0003G\u001d\u0002\"\u0001J\u000e\u000e\u0003\u0015R!A\n\b\u0002\rq\u0012xn\u001c;?\u0013\tA3$\u0001\u0004Qe\u0016$WMZ\u0005\u0003U-\u0012aa\u0015;sS:<'B\u0001\u0015\u001cQ\u0011\u0011Qf\u000f\u001f\u0011\u00059JT\"A\u0018\u000b\u0005A\n\u0014\u0001\u00039s_ZLG-\u001a:\u000b\u0005I\u001a\u0014A\u00029be\u0006l7O\u0003\u00025k\u00059!.\u001e9ji\u0016\u0014(B\u0001\u001c8\u0003\u0015QWO\\5u\u0015\u0005A\u0014aA8sO&\u0011!h\f\u0002\f-\u0006dW/Z*pkJ\u001cW-A\u0004tiJLgnZ:-\u0005uz\u0014%\u0001 \u0002\u0005i\\\u0017%\u0001!\u0002\u000b-\u0014\u0018M\u001a;)\u0005\t\u0011\u0005CA\"E\u001b\u0005\t\u0014BA#2\u0005E\u0001\u0016M]1nKR,'/\u001b>fIR+7\u000f^\u0001\u001ei\u0016\u001cH/\u0012:s_J\u001c%/Z1uKR{\u0007/[2t%\u0016\fX/Z:ugR\u0011\u0011\u0004\u0013\u0005\u0006A\r\u0001\r!\t\u0015\u0005\u00075Z$\n\f\u0002>\u007f!\u00121AQ\u0001&i\u0016\u001cHo\u0011:fCR,Gk\u001c9jGN<\u0016\u000e\u001e5WKJL8\u000b[8siRKW.Z8viN$\"!\u0007(\t\u000b\u0001\"\u0001\u0019A\u0011)\t\u0011i3\b\u0015\u0017\u0002{!\u0012AAQ\u0001 i\u0016\u001cH/\u00138wC2LGm\u0011:fCR,Gk\u001c9jGN\u0014V-];fgR\u001cHCA\rU\u0011\u0015\u0001S\u00011\u0001\"Q\u0011)Qf\u000f,-\u0005uz\u0004FA\u0003C\u0003E!Xm\u001d;O_R\u001cuN\u001c;s_2dWM\u001d\u000b\u00033iCQ\u0001\t\u0004A\u0002\u0005BCAB\u0017<92\u0012Q(X\u0011\u0002=\u0006Y!p['jOJ\fG/[8oQ\t1!)A\u0010uKN$8I]3bi\u0016$v\u000e]5dgJ+\u0017/^3tiZ+'o]5p]N$\"!\u00072\t\u000b\u0001:\u0001\u0019A\u0011)\t\u001di3\b\u001a\u0017\u0002{!\u0012qAQ\u0001\u001fi\u0016\u001cHo\u0011:fCR,7\t\\;ti\u0016\u0014X*\u001a;bI\u0006$\u0018\rV8qS\u000e$\"!\u00075\t\u000b\u0001B\u0001\u0019A\u0011)\t!i3H\u001b\u0017\u0003{}B#\u0001\u0003\"")
public class CreateTopicsRequestTest
extends AbstractCreateTopicsRequestTest {
    @ParameterizedTest
    @ValueSource(strings={"zk", "kraft"})
    public void testValidCreateTopicsRequests(String quorum) {
        this.validateValidCreateTopicsRequests(this.topicsReq((Seq<CreateTopicsRequestData.CreatableTopic>)new .colon.colon((Object)this.topicReq("topic1", this.topicReq$default$2(), this.topicReq$default$3(), this.topicReq$default$4(), this.topicReq$default$5()), (List)Nil$.MODULE$), this.topicsReq$default$2(), this.topicsReq$default$3()));
        String x$1 = "topic2";
        Integer x$2 = Predef$.MODULE$.int2Integer(3);
        Integer x$3 = this.topicReq$default$2();
        Map<String, String> x$4 = this.topicReq$default$4();
        Map<Object, Seq<Object>> x$5 = this.topicReq$default$5();
        this.validateValidCreateTopicsRequests(this.topicsReq((Seq<CreateTopicsRequestData.CreatableTopic>)new .colon.colon((Object)this.topicReq(x$1, x$3, x$2, x$4, x$5), (List)Nil$.MODULE$), this.topicsReq$default$2(), this.topicsReq$default$3()));
        this.validateValidCreateTopicsRequests(this.topicsReq((Seq<CreateTopicsRequestData.CreatableTopic>)new .colon.colon((Object)this.topicReq("topic3", Predef$.MODULE$.int2Integer(5), Predef$.MODULE$.int2Integer(2), (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"min.insync.replicas"), (Object)"2")}))), this.topicReq$default$5()), (List)Nil$.MODULE$), this.topicsReq$default$2(), this.topicsReq$default$3()));
        String x$6 = "topic4";
        Map x$7 = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0})))}));
        Integer x$8 = this.topicReq$default$2();
        Integer x$9 = this.topicReq$default$3();
        Map<String, String> x$10 = this.topicReq$default$4();
        this.validateValidCreateTopicsRequests(this.topicsReq((Seq<CreateTopicsRequestData.CreatableTopic>)new .colon.colon((Object)this.topicReq(x$6, x$8, x$9, x$10, (Map<Object, Seq<Object>>)x$7), (List)Nil$.MODULE$), this.topicsReq$default$2(), this.topicsReq$default$3()));
        String x$11 = "topic5";
        Map x$12 = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 0}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)2)), (Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2})))}));
        Map x$13 = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"min.insync.replicas"), (Object)"2")}));
        Integer x$14 = this.topicReq$default$2();
        Integer x$15 = this.topicReq$default$3();
        this.validateValidCreateTopicsRequests(this.topicsReq((Seq<CreateTopicsRequestData.CreatableTopic>)new .colon.colon((Object)this.topicReq(x$11, x$14, x$15, (Map<String, String>)x$13, (Map<Object, Seq<Object>>)x$12), (List)Nil$.MODULE$), this.topicsReq$default$2(), this.topicsReq$default$3()));
        String x$16 = "topic8";
        Map x$17 = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 0}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)2)), (Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2})))}));
        Integer x$18 = this.topicReq$default$2();
        Integer x$19 = this.topicReq$default$3();
        Map<String, String> x$20 = this.topicReq$default$4();
        this.validateValidCreateTopicsRequests(this.topicsReq((Seq<CreateTopicsRequestData.CreatableTopic>)new .colon.colon((Object)this.topicReq("topic6", this.topicReq$default$2(), this.topicReq$default$3(), this.topicReq$default$4(), this.topicReq$default$5()), (List)new .colon.colon((Object)this.topicReq("topic7", Predef$.MODULE$.int2Integer(5), Predef$.MODULE$.int2Integer(2), this.topicReq$default$4(), this.topicReq$default$5()), (List)new .colon.colon((Object)this.topicReq(x$16, x$18, x$19, x$20, (Map<Object, Seq<Object>>)x$17), (List)Nil$.MODULE$))), this.topicsReq$default$2(), this.topicsReq$default$3()));
        String x$21 = "topic11";
        Map x$22 = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 0}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)2)), (Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2})))}));
        Integer x$23 = this.topicReq$default$2();
        Integer x$24 = this.topicReq$default$3();
        Map<String, String> x$25 = this.topicReq$default$4();
        .colon.colon x$26 = new .colon.colon((Object)this.topicReq("topic9", this.topicReq$default$2(), this.topicReq$default$3(), this.topicReq$default$4(), this.topicReq$default$5()), (List)new .colon.colon((Object)this.topicReq("topic10", Predef$.MODULE$.int2Integer(5), Predef$.MODULE$.int2Integer(2), this.topicReq$default$4(), this.topicReq$default$5()), (List)new .colon.colon((Object)this.topicReq(x$21, x$23, x$24, x$25, (Map<Object, Seq<Object>>)x$22), (List)Nil$.MODULE$)));
        boolean x$27 = true;
        Integer x$28 = this.topicsReq$default$2();
        this.validateValidCreateTopicsRequests(this.topicsReq((Seq<CreateTopicsRequestData.CreatableTopic>)x$26, x$28, x$27));
        String x$29 = "topic12";
        Integer x$30 = Predef$.MODULE$.int2Integer(-1);
        Integer x$31 = Predef$.MODULE$.int2Integer(-1);
        Map<String, String> x$32 = this.topicReq$default$4();
        Map<Object, Seq<Object>> x$33 = this.topicReq$default$5();
        this.validateValidCreateTopicsRequests(this.topicsReq((Seq<CreateTopicsRequestData.CreatableTopic>)new .colon.colon((Object)this.topicReq(x$29, x$31, x$30, x$32, x$33), (List)Nil$.MODULE$), this.topicsReq$default$2(), this.topicsReq$default$3()));
        String x$34 = "topic13";
        Integer x$35 = Predef$.MODULE$.int2Integer(2);
        Integer x$36 = Predef$.MODULE$.int2Integer(-1);
        Map<String, String> x$37 = this.topicReq$default$4();
        Map<Object, Seq<Object>> x$38 = this.topicReq$default$5();
        this.validateValidCreateTopicsRequests(this.topicsReq((Seq<CreateTopicsRequestData.CreatableTopic>)new .colon.colon((Object)this.topicReq(x$34, x$36, x$35, x$37, x$38), (List)Nil$.MODULE$), this.topicsReq$default$2(), this.topicsReq$default$3()));
        String x$39 = "topic14";
        Integer x$40 = Predef$.MODULE$.int2Integer(-1);
        Integer x$41 = Predef$.MODULE$.int2Integer(2);
        Map<String, String> x$42 = this.topicReq$default$4();
        Map<Object, Seq<Object>> x$43 = this.topicReq$default$5();
        this.validateValidCreateTopicsRequests(this.topicsReq((Seq<CreateTopicsRequestData.CreatableTopic>)new .colon.colon((Object)this.topicReq(x$39, x$41, x$40, x$42, x$43), (List)Nil$.MODULE$), this.topicsReq$default$2(), this.topicsReq$default$3()));
    }

    @ParameterizedTest
    @ValueSource(strings={"zk", "kraft"})
    public void testErrorCreateTopicsRequests(String quorum) {
        String existingTopic = "existing-topic";
        this.createTopic(existingTopic, this.createTopic$default$2(), this.createTopic$default$3(), this.createTopic$default$4(), this.createTopic$default$5(), this.createTopic$default$6());
        this.validateErrorCreateTopicsRequests(this.topicsReq((Seq<CreateTopicsRequestData.CreatableTopic>)new .colon.colon((Object)this.topicReq(existingTopic, this.topicReq$default$2(), this.topicReq$default$3(), this.topicReq$default$4(), this.topicReq$default$5()), (List)Nil$.MODULE$), this.topicsReq$default$2(), this.topicsReq$default$3()), (Map<String, ApiError>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)existingTopic), (Object)this.error(Errors.TOPIC_ALREADY_EXISTS, (Option<String>)new Some((Object)"Topic 'existing-topic' already exists.")))}))), this.validateErrorCreateTopicsRequests$default$3());
        this.validateErrorCreateTopicsRequests(this.topicsReq((Seq<CreateTopicsRequestData.CreatableTopic>)new .colon.colon((Object)this.topicReq("error-partitions", Predef$.MODULE$.int2Integer(-2), this.topicReq$default$3(), this.topicReq$default$4(), this.topicReq$default$5()), (List)Nil$.MODULE$), this.topicsReq$default$2(), this.topicsReq$default$3()), (Map<String, ApiError>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"error-partitions"), (Object)this.error(Errors.INVALID_PARTITIONS, this.error$default$2()))}))), false);
        String x$1 = "error-replication";
        Integer x$2 = Predef$.MODULE$.int2Integer(this.brokerCount() + 1);
        Integer x$3 = this.topicReq$default$2();
        Map<String, String> x$4 = this.topicReq$default$4();
        Map<Object, Seq<Object>> x$5 = this.topicReq$default$5();
        this.validateErrorCreateTopicsRequests(this.topicsReq((Seq<CreateTopicsRequestData.CreatableTopic>)new .colon.colon((Object)this.topicReq(x$1, x$3, x$2, x$4, x$5), (List)Nil$.MODULE$), this.topicsReq$default$2(), this.topicsReq$default$3()), (Map<String, ApiError>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"error-replication"), (Object)this.error(Errors.INVALID_REPLICATION_FACTOR, this.error$default$2()))}))), false);
        String x$6 = "error-config";
        Map x$7 = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"not.a.property"), (Object)"error")}));
        Integer x$8 = this.topicReq$default$2();
        Integer x$9 = this.topicReq$default$3();
        Map<Object, Seq<Object>> x$10 = this.topicReq$default$5();
        this.validateErrorCreateTopicsRequests(this.topicsReq((Seq<CreateTopicsRequestData.CreatableTopic>)new .colon.colon((Object)this.topicReq(x$6, x$8, x$9, (Map<String, String>)x$7, x$10), (List)Nil$.MODULE$), this.topicsReq$default$2(), this.topicsReq$default$3()), (Map<String, ApiError>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"error-config"), (Object)this.error(Errors.INVALID_CONFIG, this.error$default$2()))}))), false);
        String x$11 = "error-config-value";
        Map x$12 = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"message.format.version"), (Object)"invalid-value")}));
        Integer x$13 = this.topicReq$default$2();
        Integer x$14 = this.topicReq$default$3();
        Map<Object, Seq<Object>> x$15 = this.topicReq$default$5();
        this.validateErrorCreateTopicsRequests(this.topicsReq((Seq<CreateTopicsRequestData.CreatableTopic>)new .colon.colon((Object)this.topicReq(x$11, x$13, x$14, (Map<String, String>)x$12, x$15), (List)Nil$.MODULE$), this.topicsReq$default$2(), this.topicsReq$default$3()), (Map<String, ApiError>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"error-config-value"), (Object)this.error(Errors.INVALID_CONFIG, this.error$default$2()))}))), false);
        String x$16 = "error-assignment";
        Map x$17 = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0})))}));
        Integer x$18 = this.topicReq$default$2();
        Integer x$19 = this.topicReq$default$3();
        Map<String, String> x$20 = this.topicReq$default$4();
        this.validateErrorCreateTopicsRequests(this.topicsReq((Seq<CreateTopicsRequestData.CreatableTopic>)new .colon.colon((Object)this.topicReq(x$16, x$18, x$19, x$20, (Map<Object, Seq<Object>>)x$17), (List)Nil$.MODULE$), this.topicsReq$default$2(), this.topicsReq$default$3()), (Map<String, ApiError>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"error-assignment"), (Object)this.error(Errors.INVALID_REPLICA_ASSIGNMENT, this.error$default$2()))}))), false);
        String x$21 = "partial-replication";
        Integer x$22 = Predef$.MODULE$.int2Integer(this.brokerCount() + 1);
        Integer x$23 = this.topicReq$default$2();
        Map<String, String> x$24 = this.topicReq$default$4();
        Map<Object, Seq<Object>> x$25 = this.topicReq$default$5();
        String x$26 = "partial-assignment";
        Map x$27 = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0})))}));
        Integer x$28 = this.topicReq$default$2();
        Integer x$29 = this.topicReq$default$3();
        Map<String, String> x$30 = this.topicReq$default$4();
        this.validateErrorCreateTopicsRequests(this.topicsReq((Seq<CreateTopicsRequestData.CreatableTopic>)new .colon.colon((Object)this.topicReq(existingTopic, this.topicReq$default$2(), this.topicReq$default$3(), this.topicReq$default$4(), this.topicReq$default$5()), (List)new .colon.colon((Object)this.topicReq("partial-partitions", Predef$.MODULE$.int2Integer(-2), this.topicReq$default$3(), this.topicReq$default$4(), this.topicReq$default$5()), (List)new .colon.colon((Object)this.topicReq(x$21, x$23, x$22, x$24, x$25), (List)new .colon.colon((Object)this.topicReq(x$26, x$28, x$29, x$30, (Map<Object, Seq<Object>>)x$27), (List)new .colon.colon((Object)this.topicReq("partial-none", this.topicReq$default$2(), this.topicReq$default$3(), this.topicReq$default$4(), this.topicReq$default$5()), (List)Nil$.MODULE$))))), this.topicsReq$default$2(), this.topicsReq$default$3()), (Map<String, ApiError>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)existingTopic), (Object)this.error(Errors.TOPIC_ALREADY_EXISTS, this.error$default$2())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"partial-partitions"), (Object)this.error(Errors.INVALID_PARTITIONS, this.error$default$2())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"partial-replication"), (Object)this.error(Errors.INVALID_REPLICATION_FACTOR, this.error$default$2())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"partial-assignment"), (Object)this.error(Errors.INVALID_REPLICA_ASSIGNMENT, this.error$default$2())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"partial-none"), (Object)this.error(Errors.NONE, this.error$default$2()))}))), false);
        this.validateTopicExists("partial-none");
    }

    @ParameterizedTest
    @ValueSource(strings={"zk"})
    public void testCreateTopicsWithVeryShortTimeouts(String quorum) {
        this.validateErrorCreateTopicsRequests(this.topicsReq((Seq<CreateTopicsRequestData.CreatableTopic>)new .colon.colon((Object)this.topicReq("error-timeout", Predef$.MODULE$.int2Integer(10), Predef$.MODULE$.int2Integer(3), this.topicReq$default$4(), this.topicReq$default$5()), (List)Nil$.MODULE$), Predef$.MODULE$.int2Integer(1), this.topicsReq$default$3()), (Map<String, ApiError>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"error-timeout"), (Object)this.error(Errors.REQUEST_TIMED_OUT, this.error$default$2()))}))), false);
        this.validateErrorCreateTopicsRequests(this.topicsReq((Seq<CreateTopicsRequestData.CreatableTopic>)new .colon.colon((Object)this.topicReq("error-timeout-zero", Predef$.MODULE$.int2Integer(10), Predef$.MODULE$.int2Integer(3), this.topicReq$default$4(), this.topicReq$default$5()), (List)Nil$.MODULE$), Predef$.MODULE$.int2Integer(0), this.topicsReq$default$3()), (Map<String, ApiError>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"error-timeout-zero"), (Object)this.error(Errors.REQUEST_TIMED_OUT, this.error$default$2()))}))), false);
        this.validateErrorCreateTopicsRequests(this.topicsReq((Seq<CreateTopicsRequestData.CreatableTopic>)new .colon.colon((Object)this.topicReq("error-timeout-negative", Predef$.MODULE$.int2Integer(10), Predef$.MODULE$.int2Integer(3), this.topicReq$default$4(), this.topicReq$default$5()), (List)Nil$.MODULE$), Predef$.MODULE$.int2Integer(-1), this.topicsReq$default$3()), (Map<String, ApiError>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"error-timeout-negative"), (Object)this.error(Errors.REQUEST_TIMED_OUT, this.error$default$2()))}))), false);
        TestUtils$.MODULE$.waitForPartitionMetadata(this.servers(), "error-timeout", 0, TestUtils$.MODULE$.waitForPartitionMetadata$default$4());
        TestUtils$.MODULE$.waitForPartitionMetadata(this.servers(), "error-timeout-zero", 0, TestUtils$.MODULE$.waitForPartitionMetadata$default$4());
        TestUtils$.MODULE$.waitForPartitionMetadata(this.servers(), "error-timeout-negative", 0, TestUtils$.MODULE$.waitForPartitionMetadata$default$4());
        this.validateTopicExists("error-timeout");
        this.validateTopicExists("error-timeout-zero");
        this.validateTopicExists("error-timeout-negative");
    }

    @ParameterizedTest
    @ValueSource(strings={"zk", "kraft"})
    public void testInvalidCreateTopicsRequests(String quorum) {
        String x$1 = "bad-args-topic";
        Integer x$2 = Predef$.MODULE$.int2Integer(10);
        Integer x$3 = Predef$.MODULE$.int2Integer(3);
        Map x$4 = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0})))}));
        Map<String, String> x$5 = this.topicReq$default$4();
        this.validateErrorCreateTopicsRequests(this.topicsReq((Seq<CreateTopicsRequestData.CreatableTopic>)new .colon.colon((Object)this.topicReq(x$1, x$2, x$3, x$5, (Map<Object, Seq<Object>>)x$4), (List)Nil$.MODULE$), this.topicsReq$default$2(), this.topicsReq$default$3()), (Map<String, ApiError>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"bad-args-topic"), (Object)this.error(Errors.INVALID_REQUEST, this.error$default$2()))}))), false);
        String x$6 = "bad-args-topic";
        Integer x$7 = Predef$.MODULE$.int2Integer(10);
        Integer x$8 = Predef$.MODULE$.int2Integer(3);
        Map x$9 = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0})))}));
        Map<String, String> x$10 = this.topicReq$default$4();
        .colon.colon x$11 = new .colon.colon((Object)this.topicReq(x$6, x$7, x$8, x$10, (Map<Object, Seq<Object>>)x$9), (List)Nil$.MODULE$);
        boolean x$12 = true;
        Integer x$13 = this.topicsReq$default$2();
        this.validateErrorCreateTopicsRequests(this.topicsReq((Seq<CreateTopicsRequestData.CreatableTopic>)x$11, x$13, x$12), (Map<String, ApiError>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"bad-args-topic"), (Object)this.error(Errors.INVALID_REQUEST, this.error$default$2()))}))), false);
    }

    @ParameterizedTest
    @ValueSource(strings={"zk", "zkMigration"})
    public void testNotController(String quorum) {
        CreateTopicsRequest req = this.topicsReq((Seq<CreateTopicsRequestData.CreatableTopic>)new .colon.colon((Object)this.topicReq("topic1", this.topicReq$default$2(), this.topicReq$default$3(), this.topicReq$default$4(), this.topicReq$default$5()), (List)Nil$.MODULE$), this.topicsReq$default$2(), this.topicsReq$default$3());
        CreateTopicsResponse response = this.sendCreateTopicRequest(req, this.notControllerSocketServer());
        Errors error = this.isZkMigrationTest() ? Errors.NONE : Errors.NOT_CONTROLLER;
        Assertions.assertEquals((int)1, (Integer)((Integer)response.errorCounts().get(error)));
    }

    @ParameterizedTest
    @ValueSource(strings={"zk"})
    public void testCreateTopicsRequestVersions(String quorum) {
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper((int)ApiKeys.CREATE_TOPICS.oldestVersion()), (int)ApiKeys.CREATE_TOPICS.latestVersion()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)version -> {
            String topic = new StringBuilder(6).append("topic_").append(version).toString();
            CreateTopicsRequestData data = new CreateTopicsRequestData();
            data.setTimeoutMs(10000);
            data.setValidateOnly(false);
            data.setTopics(new CreateTopicsRequestData.CreatableTopicCollection(((java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)this.topicReq(topic, Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(1), (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"min.insync.replicas"), (Object)"2")}))), this.topicReq$default$5()), (List)Nil$.MODULE$)).asJava()).iterator()));
            CreateTopicsRequest request = new CreateTopicsRequest.Builder(data).build((short)version);
            CreateTopicsResponseData.CreatableTopicResult topicResponse = this.sendCreateTopicRequest(request, this.sendCreateTopicRequest$default$2()).data().topics().find(topic);
            Assertions.assertNotNull((Object)topicResponse);
            Assertions.assertEquals((Object)topic, (Object)topicResponse.name());
            Assertions.assertEquals((short)Errors.NONE.code(), (short)topicResponse.errorCode());
            if (version >= 5) {
                Assertions.assertEquals((int)1, (int)topicResponse.numPartitions());
                Assertions.assertEquals((int)1, (int)topicResponse.replicationFactor());
                Option config = ((IterableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(topicResponse.configs()).asScala()).find((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)CreateTopicsRequestTest.$anonfun$testCreateTopicsRequestVersions$2(x$1)));
                Assertions.assertTrue((boolean)config.isDefined());
                Assertions.assertEquals((Object)"2", (Object)((CreateTopicsResponseData.CreatableTopicConfigs)config.get()).value());
            } else {
                Assertions.assertEquals((int)-1, (int)topicResponse.numPartitions());
                Assertions.assertEquals((int)-1, (int)topicResponse.replicationFactor());
                Assertions.assertTrue((boolean)topicResponse.configs().isEmpty());
            }
            if (version >= 7) {
                Assertions.assertNotEquals((Object)Uuid.ZERO_UUID, (Object)topicResponse.topicId());
                return;
            }
            Assertions.assertEquals((Object)Uuid.ZERO_UUID, (Object)topicResponse.topicId());
        });
    }

    @ParameterizedTest
    @ValueSource(strings={"zk", "kraft"})
    public void testCreateClusterMetadataTopic(String quorum) {
        this.validateErrorCreateTopicsRequests(this.topicsReq((Seq<CreateTopicsRequestData.CreatableTopic>)new .colon.colon((Object)this.topicReq("__cluster_metadata", this.topicReq$default$2(), this.topicReq$default$3(), this.topicReq$default$4(), this.topicReq$default$5()), (List)Nil$.MODULE$), this.topicsReq$default$2(), this.topicsReq$default$3()), (Map<String, ApiError>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"__cluster_metadata"), (Object)this.error(Errors.INVALID_REQUEST, (Option<String>)new Some((Object)new StringBuilder(60).append("Creation of internal topic ").append("__cluster_metadata").append(" is prohibited.").toString())))}))), this.validateErrorCreateTopicsRequests$default$3());
    }

    public static final /* synthetic */ boolean $anonfun$testCreateTopicsRequestVersions$2(CreateTopicsResponseData.CreatableTopicConfigs x$1) {
        String string = x$1.name();
        String string2 = "min.insync.replicas";
        return string != null && string.equals(string2);
    }
}

