/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.Serializable;
import java.util.Optional;
import kafka.cluster.Partition;
import kafka.server.DelayedFetch;
import kafka.server.FetchPartitionStatus;
import kafka.server.LogReadResult;
import kafka.server.LogReadResult$;
import kafka.server.ReplicaManager;
import kafka.server.ReplicaQuota;
import org.apache.kafka.common.TopicIdPartition;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.errors.FencedLeaderEpochException;
import org.apache.kafka.common.errors.NotLeaderOrFollowerException;
import org.apache.kafka.common.message.OffsetForLeaderEpochResponseData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.Records;
import org.apache.kafka.common.requests.FetchRequest;
import org.apache.kafka.storage.internals.log.FetchDataInfo;
import org.apache.kafka.storage.internals.log.FetchIsolation;
import org.apache.kafka.storage.internals.log.FetchParams;
import org.apache.kafka.storage.internals.log.FetchPartitionData;
import org.apache.kafka.storage.internals.log.LogOffsetMetadata;
import org.apache.kafka.storage.internals.log.LogOffsetSnapshot;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;

@ScalaSignature(bytes="\u0006\u0001\u0005ec\u0001\u0002\t\u0012\u0001YAQ!\b\u0001\u0005\u0002yAq!\t\u0001C\u0002\u0013%!\u0005\u0003\u0004'\u0001\u0001\u0006Ia\t\u0005\bO\u0001\u0011\r\u0011\"\u0003)\u0011\u0019a\u0003\u0001)A\u0005S!9Q\u0006\u0001b\u0001\n\u0013q\u0003B\u0002\u001a\u0001A\u0003%q\u0006C\u00034\u0001\u0011\u0005A\u0007C\u0003F\u0001\u0011\u0005A\u0007C\u0003H\u0001\u0011\u0005A\u0007C\u0003J\u0001\u0011\u0005!\nC\u0003f\u0001\u0011%a\rC\u0004{\u0001E\u0005I\u0011B>\t\u000f\u00055\u0001\u0001\"\u0003\u0002\u0010!9\u0011Q\n\u0001\u0005\n\u0005=#\u0001\u0005#fY\u0006LX\r\u001a$fi\u000eDG+Z:u\u0015\t\u00112#\u0001\u0004tKJ4XM\u001d\u0006\u0002)\u0005)1.\u00194lC\u000e\u00011C\u0001\u0001\u0018!\tA2$D\u0001\u001a\u0015\u0005Q\u0012!B:dC2\f\u0017B\u0001\u000f\u001a\u0005\u0019\te.\u001f*fM\u00061A(\u001b8jiz\"\u0012a\b\t\u0003A\u0001i\u0011!E\u0001\t[\u0006D()\u001f;fgV\t1\u0005\u0005\u0002\u0019I%\u0011Q%\u0007\u0002\u0004\u0013:$\u0018!C7bq\nKH/Z:!\u00039\u0011X\r\u001d7jG\u0006l\u0015M\\1hKJ,\u0012!\u000b\t\u0003A)J!aK\t\u0003\u001dI+\u0007\u000f\\5dC6\u000bg.Y4fe\u0006y!/\u001a9mS\u000e\fW*\u00198bO\u0016\u0014\b%\u0001\u0007sKBd\u0017nY1Rk>$\u0018-F\u00010!\t\u0001\u0003'\u0003\u00022#\ta!+\u001a9mS\u000e\f\u0017+^8uC\u0006i!/\u001a9mS\u000e\f\u0017+^8uC\u0002\n\u0001\u0004^3ti\u001a+Go\u00195XSRDg)\u001a8dK\u0012,\u0005o\\2i)\u0005)\u0004C\u0001\r7\u0013\t9\u0014D\u0001\u0003V]&$\bF\u0001\u0005:!\tQ4)D\u0001<\u0015\taT(A\u0002ba&T!AP \u0002\u000f),\b/\u001b;fe*\u0011\u0001)Q\u0001\u0006UVt\u0017\u000e\u001e\u0006\u0002\u0005\u0006\u0019qN]4\n\u0005\u0011[$\u0001\u0002+fgR\fq\u0003^3ti:{G\u000fT3bI\u0016\u0014xJ\u001d$pY2|w/\u001a:)\u0005%I\u0014A\u0005;fgR$\u0015N^3sO&tw-\u00129pG\"D#AC\u001d\u0002YQ,7\u000f\u001e#fY\u0006LX\r\u001a$fi\u000eDw+\u001b;i\u001b\u0016\u001c8/Y4f\u001f:d\u0017\u0010S5hQ^\u000bG/\u001a:nCJ\\GCA\u001bL\u0011\u0015a5\u00021\u0001N\u0003%)g\u000eZ(gMN,G\u000f\u0005\u0002\u0019\u001d&\u0011q*\u0007\u0002\u0005\u0019>tw\r\u000b\u0003\f#fS\u0006C\u0001*X\u001b\u0005\u0019&B\u0001+V\u0003!\u0001(o\u001c<jI\u0016\u0014(B\u0001,>\u0003\u0019\u0001\u0018M]1ng&\u0011\u0001l\u0015\u0002\f-\u0006dW/Z*pkJ\u001cW-A\u0003m_:<7\u000f\f\u0002\\9z\t\u0001A\b\u0002\u0002i$\"1B\u00182d!\ty\u0006-D\u0001V\u0013\t\tWKA\tQCJ\fW.\u001a;fe&TX\r\u001a+fgR\fAA\\1nK\u0006\nA-\u0001\u001euKN$H)\u001a7bs\u0016$g)\u001a;dQ^KG\u000f['fgN\fw-Z(oYfD\u0015n\u001a5XCR,'/\\1sW\u0002*g\u000eZ(gMN,G/P>1{\u0006A\"-^5mI\u001a{G\u000e\\8xKJ4U\r^2i!\u0006\u0014\u0018-\\:\u0015\t\u001d$h\u000f\u001f\t\u0003QJl\u0011!\u001b\u0006\u0003U.\f1\u0001\\8h\u0015\taW.A\u0005j]R,'O\\1mg*\u0011an\\\u0001\bgR|'/Y4f\u0015\t!\u0002O\u0003\u0002r\u0003\u00061\u0011\r]1dQ\u0016L!a]5\u0003\u0017\u0019+Go\u00195QCJ\fWn\u001d\u0005\u0006k2\u0001\raI\u0001\ne\u0016\u0004H.[2b\u0013\u0012DQa\u001e\u0007A\u0002\r\n\u0011\"\\1y/\u0006LG/T:\t\u000fed\u0001\u0013!a\u0001G\u0005AQ.\u001b8CsR,7/\u0001\u0012ck&dGMR8mY><XM\u001d$fi\u000eD\u0007+\u0019:b[N$C-\u001a4bk2$HeM\u000b\u0002y*\u00121%`\u0016\u0002}B\u0019q0!\u0003\u000e\u0005\u0005\u0005!\u0002BA\u0002\u0003\u000b\t\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\u0005\u001d\u0011$\u0001\u0006b]:|G/\u0019;j_:LA!a\u0003\u0002\u0002\t\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0002+\u0015D\b/Z2u%\u0016\fGM\u0012:p[J+\u0007\u000f\\5dCRIQ'!\u0005\u0002\u0016\u0005\u0015\u0012Q\b\u0005\u0007\u0003'q\u0001\u0019A4\u0002\u0017\u0019,Go\u00195QCJ\fWn\u001d\u0005\b\u0003/q\u0001\u0019AA\r\u0003A!x\u000e]5d\u0013\u0012\u0004\u0016M\u001d;ji&|g\u000e\u0005\u0003\u0002\u001c\u0005\u0005RBAA\u000f\u0015\r\tyb\\\u0001\u0007G>lWn\u001c8\n\t\u0005\r\u0012Q\u0004\u0002\u0011)>\u0004\u0018nY%e!\u0006\u0014H/\u001b;j_:Dq!a\n\u000f\u0001\u0004\tI#\u0001\ngKR\u001c\u0007\u000eU1si&$\u0018n\u001c8ECR\f\u0007\u0003BA\u0016\u0003oqA!!\f\u000245\u0011\u0011q\u0006\u0006\u0005\u0003c\ti\"\u0001\u0005sKF,Xm\u001d;t\u0013\u0011\t)$a\f\u0002\u0019\u0019+Go\u00195SKF,Xm\u001d;\n\t\u0005e\u00121\b\u0002\u000e!\u0006\u0014H/\u001b;j_:$\u0015\r^1\u000b\t\u0005U\u0012q\u0006\u0005\b\u0003\u007fq\u0001\u0019AA!\u0003\u0015)'O]8s!\u0011\t\u0019%!\u0013\u000e\u0005\u0005\u0015#\u0002BA$\u0003;\t\u0001\u0002\u001d:pi>\u001cw\u000e\\\u0005\u0005\u0003\u0017\n)E\u0001\u0004FeJ|'o]\u0001\u0010EVLG\u000e\u001a*fC\u0012\u0014Vm];miR!\u0011\u0011KA,!\r\u0001\u00131K\u0005\u0004\u0003+\n\"!\u0004'pOJ+\u0017\r\u001a*fgVdG\u000fC\u0004\u0002@=\u0001\r!!\u0011")
public class DelayedFetchTest {
    private final int maxBytes;
    private final ReplicaManager replicaManager = (ReplicaManager)Mockito.mock(ReplicaManager.class);
    private final ReplicaQuota replicaQuota = (ReplicaQuota)Mockito.mock(ReplicaQuota.class);

    private int maxBytes() {
        return this.maxBytes;
    }

    private ReplicaManager replicaManager() {
        return this.replicaManager;
    }

    private ReplicaQuota replicaQuota() {
        return this.replicaQuota;
    }

    @Test
    public void testFetchWithFencedEpoch() {
        TopicIdPartition topicIdPartition = new TopicIdPartition(Uuid.randomUuid(), 0, "topic");
        long fetchOffset = 500L;
        long logStartOffset = 0L;
        Optional<Integer> currentLeaderEpoch = Optional.of(Predef$.MODULE$.int2Integer(10));
        int replicaId = 1;
        FetchPartitionStatus fetchStatus = new FetchPartitionStatus(new LogOffsetMetadata(fetchOffset), new FetchRequest.PartitionData(topicIdPartition.topicId(), fetchOffset, logStartOffset, this.maxBytes(), currentLeaderEpoch));
        FetchParams fetchParams = this.buildFollowerFetchParams(replicaId, 500, this.buildFollowerFetchParams$default$3());
        ObjectRef fetchResultOpt = ObjectRef.create((Object)None$.MODULE$);
        DelayedFetch delayedFetch = new DelayedFetch(fetchParams, (Seq)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicIdPartition), (Object)fetchStatus), (List)Nil$.MODULE$), this.replicaManager(), this.replicaQuota(), (Function1 & Serializable & scala.Serializable)responses -> {
            DelayedFetchTest.callback$1(responses, fetchResultOpt);
            return BoxedUnit.UNIT;
        });
        Partition partition = (Partition)Mockito.mock(Partition.class);
        Mockito.when((Object)this.replicaManager().getPartitionOrException(topicIdPartition.topicPartition())).thenReturn((Object)partition);
        Mockito.when((Object)partition.fetchOffsetSnapshot(currentLeaderEpoch, true)).thenThrow(new Throwable[]{new FencedLeaderEpochException("Requested epoch has been fenced")});
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)this.replicaManager().isAddingReplica((TopicPartition)ArgumentMatchers.any(), ArgumentMatchers.anyInt()))).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)false));
        this.expectReadFromReplica(fetchParams, topicIdPartition, fetchStatus.fetchInfo(), Errors.FENCED_LEADER_EPOCH);
        Assertions.assertTrue((boolean)delayedFetch.tryComplete());
        Assertions.assertTrue((boolean)delayedFetch.isCompleted());
        Assertions.assertTrue((boolean)((Option)fetchResultOpt.elem).isDefined());
        FetchPartitionData fetchResult = (FetchPartitionData)((Option)fetchResultOpt.elem).get();
        Assertions.assertEquals((Object)Errors.FENCED_LEADER_EPOCH, (Object)fetchResult.error);
    }

    @Test
    public void testNotLeaderOrFollower() {
        TopicIdPartition topicIdPartition = new TopicIdPartition(Uuid.randomUuid(), 0, "topic");
        long fetchOffset = 500L;
        long logStartOffset = 0L;
        Optional<Integer> currentLeaderEpoch = Optional.of(Predef$.MODULE$.int2Integer(10));
        int replicaId = 1;
        FetchPartitionStatus fetchStatus = new FetchPartitionStatus(new LogOffsetMetadata(fetchOffset), new FetchRequest.PartitionData(topicIdPartition.topicId(), fetchOffset, logStartOffset, this.maxBytes(), currentLeaderEpoch));
        FetchParams fetchParams = this.buildFollowerFetchParams(replicaId, 500, this.buildFollowerFetchParams$default$3());
        ObjectRef fetchResultOpt = ObjectRef.create((Object)None$.MODULE$);
        DelayedFetch delayedFetch = new DelayedFetch(fetchParams, (Seq)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicIdPartition), (Object)fetchStatus), (List)Nil$.MODULE$), this.replicaManager(), this.replicaQuota(), (Function1 & Serializable & scala.Serializable)responses -> {
            DelayedFetchTest.callback$2(responses, fetchResultOpt);
            return BoxedUnit.UNIT;
        });
        Mockito.when((Object)this.replicaManager().getPartitionOrException(topicIdPartition.topicPartition())).thenThrow(new Throwable[]{new NotLeaderOrFollowerException(new StringBuilder(26).append("Replica for ").append(topicIdPartition).append(" not available").toString())});
        this.expectReadFromReplica(fetchParams, topicIdPartition, fetchStatus.fetchInfo(), Errors.NOT_LEADER_OR_FOLLOWER);
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)this.replicaManager().isAddingReplica((TopicPartition)ArgumentMatchers.any(), ArgumentMatchers.anyInt()))).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)false));
        Assertions.assertTrue((boolean)delayedFetch.tryComplete());
        Assertions.assertTrue((boolean)delayedFetch.isCompleted());
        Assertions.assertTrue((boolean)((Option)fetchResultOpt.elem).isDefined());
        FetchPartitionData fetchResult = (FetchPartitionData)((Option)fetchResultOpt.elem).get();
        Assertions.assertEquals((Object)Errors.NOT_LEADER_OR_FOLLOWER, (Object)fetchResult.error);
    }

    @Test
    public void testDivergingEpoch() {
        TopicIdPartition topicIdPartition = new TopicIdPartition(Uuid.randomUuid(), 0, "topic");
        long fetchOffset = 500L;
        long logStartOffset = 0L;
        Optional<Integer> currentLeaderEpoch = Optional.of(Predef$.MODULE$.int2Integer(10));
        Optional<Integer> lastFetchedEpoch = Optional.of(Predef$.MODULE$.int2Integer(9));
        int replicaId = 1;
        FetchPartitionStatus fetchStatus = new FetchPartitionStatus(new LogOffsetMetadata(fetchOffset), new FetchRequest.PartitionData(topicIdPartition.topicId(), fetchOffset, logStartOffset, this.maxBytes(), currentLeaderEpoch, lastFetchedEpoch));
        FetchParams fetchParams = this.buildFollowerFetchParams(replicaId, 500, this.buildFollowerFetchParams$default$3());
        ObjectRef fetchResultOpt = ObjectRef.create((Object)None$.MODULE$);
        DelayedFetch delayedFetch = new DelayedFetch(fetchParams, (Seq)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicIdPartition), (Object)fetchStatus), (List)Nil$.MODULE$), this.replicaManager(), this.replicaQuota(), (Function1 & Serializable & scala.Serializable)responses -> {
            DelayedFetchTest.callback$3(responses, fetchResultOpt);
            return BoxedUnit.UNIT;
        });
        Partition partition = (Partition)Mockito.mock(Partition.class);
        Mockito.when((Object)this.replicaManager().getPartitionOrException(topicIdPartition.topicPartition())).thenReturn((Object)partition);
        LogOffsetMetadata endOffsetMetadata = new LogOffsetMetadata(500L, 0L, 500);
        Mockito.when((Object)partition.fetchOffsetSnapshot(currentLeaderEpoch, true)).thenReturn((Object)new LogOffsetSnapshot(0L, endOffsetMetadata, endOffsetMetadata, endOffsetMetadata));
        Mockito.when((Object)partition.lastOffsetForLeaderEpoch(currentLeaderEpoch, Predef$.MODULE$.Integer2int(lastFetchedEpoch.get()), false)).thenReturn((Object)new OffsetForLeaderEpochResponseData.EpochEndOffset().setPartition(topicIdPartition.partition()).setErrorCode(Errors.NONE.code()).setLeaderEpoch(Predef$.MODULE$.Integer2int(lastFetchedEpoch.get())).setEndOffset(fetchOffset - 1L));
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)this.replicaManager().isAddingReplica((TopicPartition)ArgumentMatchers.any(), ArgumentMatchers.anyInt()))).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)false));
        this.expectReadFromReplica(fetchParams, topicIdPartition, fetchStatus.fetchInfo(), Errors.NONE);
        Assertions.assertTrue((boolean)delayedFetch.tryComplete());
        Assertions.assertTrue((boolean)delayedFetch.isCompleted());
        Assertions.assertTrue((boolean)((Option)fetchResultOpt.elem).isDefined());
        FetchPartitionData fetchResult = (FetchPartitionData)((Option)fetchResultOpt.elem).get();
        Assertions.assertEquals((Object)Errors.NONE, (Object)fetchResult.error);
    }

    @ParameterizedTest(name="testDelayedFetchWithMessageOnlyHighWatermark endOffset={0}")
    @ValueSource(longs={0L, 500L})
    public void testDelayedFetchWithMessageOnlyHighWatermark(long endOffset) {
        TopicIdPartition topicIdPartition = new TopicIdPartition(Uuid.randomUuid(), 0, "topic");
        long fetchOffset = 450L;
        long logStartOffset = 5L;
        Optional<Integer> currentLeaderEpoch = Optional.of(Predef$.MODULE$.int2Integer(10));
        int replicaId = 1;
        FetchPartitionStatus fetchStatus = new FetchPartitionStatus(new LogOffsetMetadata(fetchOffset), new FetchRequest.PartitionData(topicIdPartition.topicId(), fetchOffset, logStartOffset, this.maxBytes(), currentLeaderEpoch));
        FetchParams fetchParams = this.buildFollowerFetchParams(replicaId, 500, this.buildFollowerFetchParams$default$3());
        ObjectRef fetchResultOpt = ObjectRef.create((Object)None$.MODULE$);
        DelayedFetch delayedFetch = new DelayedFetch(fetchParams, (Seq)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicIdPartition), (Object)fetchStatus), (List)Nil$.MODULE$), this.replicaManager(), this.replicaQuota(), (Function1 & Serializable & scala.Serializable)responses -> {
            DelayedFetchTest.callback$4(responses, fetchResultOpt);
            return BoxedUnit.UNIT;
        });
        Partition partition = (Partition)Mockito.mock(Partition.class);
        Mockito.when((Object)this.replicaManager().getPartitionOrException(topicIdPartition.topicPartition())).thenReturn((Object)partition);
        LogOffsetMetadata endOffsetMetadata = new LogOffsetMetadata(endOffset, -1L, -1);
        Mockito.when((Object)partition.fetchOffsetSnapshot(currentLeaderEpoch, true)).thenReturn((Object)new LogOffsetSnapshot(0L, endOffsetMetadata, endOffsetMetadata, endOffsetMetadata));
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)this.replicaManager().isAddingReplica((TopicPartition)ArgumentMatchers.any(), ArgumentMatchers.anyInt()))).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)false));
        this.expectReadFromReplica(fetchParams, topicIdPartition, fetchStatus.fetchInfo(), Errors.NONE);
        boolean expected = endOffset == 0L;
        Assertions.assertEquals((Object)BoxesRunTime.boxToBoolean((boolean)expected), (Object)BoxesRunTime.boxToBoolean((boolean)delayedFetch.tryComplete()));
        Assertions.assertEquals((Object)BoxesRunTime.boxToBoolean((boolean)expected), (Object)BoxesRunTime.boxToBoolean((boolean)delayedFetch.isCompleted()));
        Assertions.assertEquals((Object)BoxesRunTime.boxToBoolean((boolean)expected), (Object)BoxesRunTime.boxToBoolean((boolean)((Option)fetchResultOpt.elem).isDefined()));
        if (((Option)fetchResultOpt.elem).isDefined()) {
            Assertions.assertEquals((Object)Errors.NONE, (Object)((FetchPartitionData)((Option)fetchResultOpt.elem).get()).error);
            return;
        }
    }

    private FetchParams buildFollowerFetchParams(int replicaId, int maxWaitMs, int minBytes) {
        return new FetchParams(ApiKeys.FETCH.latestVersion(), replicaId, 1L, (long)maxWaitMs, minBytes, this.maxBytes(), FetchIsolation.LOG_END, Optional.empty());
    }

    private int buildFollowerFetchParams$default$3() {
        return 1;
    }

    private void expectReadFromReplica(FetchParams fetchParams, TopicIdPartition topicIdPartition, FetchRequest.PartitionData fetchPartitionData, Errors error) {
        Mockito.when((Object)this.replicaManager().readFromLog(fetchParams, (Seq)new .colon.colon((Object)new Tuple2((Object)topicIdPartition, (Object)fetchPartitionData), (List)Nil$.MODULE$), this.replicaQuota(), true)).thenReturn((Object)new .colon.colon((Object)new Tuple2((Object)topicIdPartition, (Object)this.buildReadResult(error)), (List)Nil$.MODULE$));
    }

    private LogReadResult buildReadResult(Errors error) {
        Errors errors = error;
        Errors errors2 = Errors.NONE;
        None$ x$1 = (errors == null ? errors2 != null : !errors.equals(errors2)) ? new Some((Object)error.exception()) : None$.MODULE$;
        FetchDataInfo x$2 = new FetchDataInfo(LogOffsetMetadata.UNKNOWN_OFFSET_METADATA, (Records)MemoryRecords.EMPTY);
        None$ x$3 = None$.MODULE$;
        long x$4 = -1L;
        long x$5 = -1L;
        long x$6 = -1L;
        long x$7 = -1L;
        long x$8 = -1L;
        None$ x$9 = None$.MODULE$;
        Option x$10 = LogReadResult$.MODULE$.apply$default$9();
        return new LogReadResult(x$2, (Option)x$3, x$4, x$5, x$6, x$7, x$8, (Option)x$9, x$10, (Option)x$1);
    }

    private static final void callback$1(Seq responses, ObjectRef fetchResultOpt$1) {
        fetchResultOpt$1.elem = new Some(((Tuple2)responses.head())._2());
    }

    private static final void callback$2(Seq responses, ObjectRef fetchResultOpt$2) {
        fetchResultOpt$2.elem = new Some(((Tuple2)responses.head())._2());
    }

    private static final void callback$3(Seq responses, ObjectRef fetchResultOpt$3) {
        fetchResultOpt$3.elem = new Some(((Tuple2)responses.head())._2());
    }

    private static final void callback$4(Seq responses, ObjectRef fetchResultOpt$4) {
        fetchResultOpt$4.elem = new Some(((Tuple2)responses.head())._2());
    }

    public DelayedFetchTest() {
        this.maxBytes = 1024;
    }
}

