/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.Serializable;
import java.util.Collections;
import java.util.concurrent.TimeUnit;
import kafka.log.LogManager;
import kafka.log.UnifiedLog;
import kafka.server.BaseRequestTest;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.clients.producer.RecordMetadata;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.message.DeleteRecordsRequestData;
import org.apache.kafka.common.message.DeleteRecordsResponseData;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.DeleteRecordsRequest;
import org.apache.kafka.common.requests.DeleteRecordsResponse;
import org.apache.kafka.common.serialization.StringSerializer;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.immutable.;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Buffer$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;

@ScalaSignature(bytes="\u0006\u0001\u0005Uc\u0001B\b\u0011\u0001UAQA\u0007\u0001\u0005\u0002mAq!\b\u0001C\u0002\u0013%a\u0004\u0003\u0004&\u0001\u0001\u0006Ia\b\u0005\bM\u0001\u0011\r\u0011\"\u0003\u001f\u0011\u00199\u0003\u0001)A\u0005?!)\u0001\u0006\u0001C\u0001S!)A\u000b\u0001C\u0001+\")!\f\u0001C\u00017\")\u0001\r\u0001C\u0005C\")a\u000e\u0001C\u0005_\")!\u0010\u0001C\u0005w\"1!\u0010\u0001C\u0005\u0003\u0007Aq!a\u0003\u0001\t\u0013\ti\u0001C\u0004\u0002F\u0001!I!a\u0012\u00031\u0011+G.\u001a;f%\u0016\u001cwN\u001d3t%\u0016\fX/Z:u)\u0016\u001cHO\u0003\u0002\u0012%\u000511/\u001a:wKJT\u0011aE\u0001\u0006W\u000647.Y\u0002\u0001'\t\u0001a\u0003\u0005\u0002\u001815\t\u0001#\u0003\u0002\u001a!\ty!)Y:f%\u0016\fX/Z:u)\u0016\u001cH/\u0001\u0004=S:LGO\u0010\u000b\u00029A\u0011q\u0003A\u0001\u000b)&kUiT+U?6\u001bV#A\u0010\u0011\u0005\u0001\u001aS\"A\u0011\u000b\u0003\t\nQa]2bY\u0006L!\u0001J\u0011\u0003\u0007%sG/A\u0006U\u00136+u*\u0016+`\u001bN\u0003\u0013aH'F'N\u000bu)R*`!J{E)V\"F\t~\u0003VIU0Q\u0003J#\u0016\nV%P\u001d\u0006\u0001S*R*T\u0003\u001e+5k\u0018)S\u001f\u0012+6)\u0012#`!\u0016\u0013v\fU!S)&#\u0016j\u0014(!\u0003i!Xm\u001d;EK2,G/\u001a*fG>\u0014Hm\u001d%baBL8)Y:f)\tQS\u0006\u0005\u0002!W%\u0011A&\t\u0002\u0005+:LG\u000fC\u0003/\r\u0001\u0007q&\u0001\u0004rk>\u0014X/\u001c\t\u0003a]r!!M\u001b\u0011\u0005I\nS\"A\u001a\u000b\u0005Q\"\u0012A\u0002\u001fs_>$h(\u0003\u00027C\u00051\u0001K]3eK\u001aL!\u0001O\u001d\u0003\rM#(/\u001b8h\u0015\t1\u0014\u0005\u000b\u0003\u0007w%S\u0005C\u0001\u001fH\u001b\u0005i$B\u0001 @\u0003!\u0001(o\u001c<jI\u0016\u0014(B\u0001!B\u0003\u0019\u0001\u0018M]1ng*\u0011!iQ\u0001\bUV\u0004\u0018\u000e^3s\u0015\t!U)A\u0003kk:LGOC\u0001G\u0003\ry'oZ\u0005\u0003\u0011v\u00121BV1mk\u0016\u001cv.\u001e:dK\u000691\u000f\u001e:j]\u001e\u001cHFA&NC\u0005a\u0015A\u0001>lC\u0005q\u0015!B6sC\u001a$\bF\u0001\u0004Q!\t\t&+D\u0001@\u0013\t\u0019vHA\tQCJ\fW.\u001a;fe&TX\r\u001a+fgR\fQ\u0006^3ti\u0016\u0013(o\u001c:XQ\u0016tG)\u001a7fi&twMU3d_J$7oV5uQ&sg/\u00197jI>3gm]3u)\tQc\u000bC\u0003/\u000f\u0001\u0007q\u0006\u000b\u0003\bw%CFFA&NQ\t9\u0001+\u0001\u0017uKN$XI\u001d:pe^CWM\u001c#fY\u0016$\u0018N\\4SK\u000e|'\u000fZ:XSRD\u0017J\u001c<bY&$Gk\u001c9jGR\u0011!\u0006\u0018\u0005\u0006]!\u0001\ra\f\u0015\u0005\u0011mJe\f\f\u0002L\u001b\"\u0012\u0001\u0002U\u0001\u001aGJ,\u0017\r^3U_BL7-\u00118e'\u0016tGMU3d_J$7/F\u0001c!\u0011\u00013-Z\u0010\n\u0005\u0011\f#A\u0002+va2,'\u0007\u0005\u0002gY6\tqM\u0003\u0002iS\u000611m\\7n_:T!a\u00056\u000b\u0005-,\u0015AB1qC\u000eDW-\u0003\u0002nO\nqAk\u001c9jGB\u000b'\u000f^5uS>t\u0017aK2sK\u0006$X\rR3mKR,'+Z2pe\u0012\u001c(+Z9vKN$hi\u001c:U_BL7\rU1si&$\u0018n\u001c8\u0015\u0007A4\b\u0010\u0005\u0002ri6\t!O\u0003\u0002tO\u0006A!/Z9vKN$8/\u0003\u0002ve\n!B)\u001a7fi\u0016\u0014VmY8sIN\u0014V-];fgRDQa\u001e\u0006A\u0002\u0015\fa\u0002^8qS\u000e\u0004\u0016M\u001d;ji&|g\u000eC\u0003z\u0015\u0001\u0007q$\u0001\bpM\u001a\u001cX\r\u001e+p\t\u0016dW\r^3\u00021M,g\u000e\u001a#fY\u0016$XMU3d_J$7OU3rk\u0016\u001cH\u000f\u0006\u0002}\u007fB\u0011\u0011/`\u0005\u0003}J\u0014Q\u0003R3mKR,'+Z2pe\u0012\u001c(+Z:q_:\u001cX\r\u0003\u0004\u0002\u0002-\u0001\r\u0001]\u0001\be\u0016\fX/Z:u)\u0015a\u0018QAA\u0004\u0011\u0019\t\t\u0001\u0004a\u0001a\"1\u0011\u0011\u0002\u0007A\u0002}\t\u0001\u0002\\3bI\u0016\u0014\u0018\nZ\u0001\faJ|G-^2f\t\u0006$\u0018\r\u0006\u0004\u0002\u0010\u0005-\u0012\u0011\t\t\u0007\u0003#\t9\"a\u0007\u000e\u0005\u0005M!bAA\u000bC\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\t\u0005e\u00111\u0003\u0002\u0004'\u0016\f\b\u0003BA\u000f\u0003Oi!!a\b\u000b\t\u0005\u0005\u00121E\u0001\taJ|G-^2fe*\u0019\u0011QE5\u0002\u000f\rd\u0017.\u001a8ug&!\u0011\u0011FA\u0010\u00059\u0011VmY8sI6+G/\u00193bi\u0006Dq!!\f\u000e\u0001\u0004\ty#A\bu_BL7\rU1si&$\u0018n\u001c8t!\u0015\t\t$a\u000ff\u001d\u0011\t\u0019$a\u000e\u000f\u0007I\n)$C\u0001#\u0013\r\tI$I\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\ti$a\u0010\u0003\u0011%#XM]1cY\u0016T1!!\u000f\"\u0011\u0019\t\u0019%\u0004a\u0001?\u00059b.^7NKN\u001c\u0018mZ3t!\u0016\u0014\b+\u0019:uSRLwN\\\u0001\u001fm\u0006d\u0017\u000eZ1uK2{wm\u0015;beR|eMZ:fi\u001a{'\u000fV8qS\u000e$RAKA%\u0003\u0017BQa\u001e\bA\u0002\u0015Dq!!\u0014\u000f\u0001\u0004\ty%A\nfqB,7\r^3e'R\f'\u000f^(gMN,G\u000fE\u0002!\u0003#J1!a\u0015\"\u0005\u0011auN\\4")
public class DeleteRecordsRequestTest
extends BaseRequestTest {
    private final int TIMEOUT_MS;
    private final int MESSAGES_PRODUCED_PER_PARTITION;

    private int TIMEOUT_MS() {
        return this.TIMEOUT_MS;
    }

    private int MESSAGES_PRODUCED_PER_PARTITION() {
        return this.MESSAGES_PRODUCED_PER_PARTITION;
    }

    /*
     * WARNING - void declaration
     */
    @ParameterizedTest
    @ValueSource(strings={"zk", "kraft"})
    public void testDeleteRecordsHappyCase(String quorum) {
        void var4_4;
        void var3_3;
        block3: {
            Tuple2<TopicPartition, Object> tuple2;
            block2: {
                tuple2 = this.createTopicAndSendRecords();
                if (tuple2 == null) break block2;
                TopicPartition topicPartition = (TopicPartition)tuple2._1();
                int leaderId = tuple2._2$mcI$sp();
                if (topicPartition != null) break block3;
            }
            throw new MatchError(tuple2);
        }
        int offsetToDelete = Math.max(this.MESSAGES_PRODUCED_PER_PARTITION() - 8, 0);
        DeleteRecordsRequest request = this.createDeleteRecordsRequestForTopicPartition((TopicPartition)var3_3, offsetToDelete);
        DeleteRecordsResponseData.DeleteRecordsPartitionResult partitionResult = this.sendDeleteRecordsRequest(request, (int)var4_4).data().topics().find(var3_3.topic()).partitions().find(var3_3.partition());
        Assertions.assertEquals((short)Errors.NONE.code(), (short)partitionResult.errorCode(), (String)new StringBuilder(32).append("Unexpected error code received: ").append(Errors.forCode((short)partitionResult.errorCode()).name()).toString());
        Assertions.assertEquals((long)offsetToDelete, (long)partitionResult.lowWatermark(), (String)new StringBuilder(34).append("Unexpected lowWatermark received: ").append(partitionResult.lowWatermark()).toString());
        this.validateLogStartOffsetForTopic((TopicPartition)var3_3, offsetToDelete);
    }

    /*
     * WARNING - void declaration
     */
    @ParameterizedTest
    @ValueSource(strings={"zk", "kraft"})
    public void testErrorWhenDeletingRecordsWithInvalidOffset(String quorum) {
        void var4_4;
        void var3_3;
        block3: {
            Tuple2<TopicPartition, Object> tuple2;
            block2: {
                tuple2 = this.createTopicAndSendRecords();
                if (tuple2 == null) break block2;
                TopicPartition topicPartition = (TopicPartition)tuple2._1();
                int leaderId = tuple2._2$mcI$sp();
                if (topicPartition != null) break block3;
            }
            throw new MatchError(tuple2);
        }
        int offsetToDelete = this.MESSAGES_PRODUCED_PER_PARTITION() + 5;
        DeleteRecordsRequest request = this.createDeleteRecordsRequestForTopicPartition((TopicPartition)var3_3, offsetToDelete);
        DeleteRecordsResponseData.DeleteRecordsPartitionResult partitionResult = this.sendDeleteRecordsRequest(request, (int)var4_4).data().topics().find(var3_3.topic()).partitions().find(var3_3.partition());
        Assertions.assertEquals((short)Errors.OFFSET_OUT_OF_RANGE.code(), (short)partitionResult.errorCode(), (String)new StringBuilder(32).append("Unexpected error code received: ").append(Errors.forCode((short)partitionResult.errorCode()).name()).toString());
        Assertions.assertEquals((long)-1L, (long)partitionResult.lowWatermark());
        this.validateLogStartOffsetForTopic((TopicPartition)var3_3, 0L);
    }

    @ParameterizedTest
    @ValueSource(strings={"zk", "kraft"})
    public void testErrorWhenDeletingRecordsWithInvalidTopic(String quorum) {
        TopicPartition invalidTopicPartition = new TopicPartition("invalid-topic", 0);
        int offsetToDelete = 1;
        DeleteRecordsRequest request = this.createDeleteRecordsRequestForTopicPartition(invalidTopicPartition, offsetToDelete);
        DeleteRecordsResponseData.DeleteRecordsPartitionResult partitionResult = this.sendDeleteRecordsRequest(request).data().topics().find(invalidTopicPartition.topic()).partitions().find(invalidTopicPartition.partition());
        Assertions.assertEquals((short)Errors.UNKNOWN_TOPIC_OR_PARTITION.code(), (short)partitionResult.errorCode(), (String)new StringBuilder(32).append("Unexpected error code received: ").append(Errors.forCode((short)partitionResult.errorCode()).name()).toString());
        Assertions.assertEquals((long)-1L, (long)partitionResult.lowWatermark());
    }

    private Tuple2<TopicPartition, Object> createTopicAndSendRecords() {
        String topic1 = "topic-1";
        TopicPartition topicPartition = new TopicPartition(topic1, 0);
        Map<Object, Object> partitionToLeader = this.createTopic(topic1, this.createTopic$default$2(), this.createTopic$default$3(), this.createTopic$default$4(), this.createTopic$default$5(), this.createTopic$default$6());
        Assertions.assertTrue((boolean)partitionToLeader.contains((Object)BoxesRunTime.boxToInteger((int)topicPartition.partition())), (String)"Topic creation did not succeed.");
        this.produceData((Iterable<TopicPartition>)new .colon.colon((Object)topicPartition, (List)Nil$.MODULE$), this.MESSAGES_PRODUCED_PER_PARTITION());
        return new Tuple2((Object)topicPartition, partitionToLeader.apply((Object)BoxesRunTime.boxToInteger((int)topicPartition.partition())));
    }

    private DeleteRecordsRequest createDeleteRecordsRequestForTopicPartition(TopicPartition topicPartition, int offsetToDelete) {
        DeleteRecordsRequestData requestData = new DeleteRecordsRequestData().setTopics(Collections.singletonList(new DeleteRecordsRequestData.DeleteRecordsTopic().setName(topicPartition.topic()).setPartitions(Collections.singletonList(new DeleteRecordsRequestData.DeleteRecordsPartition().setOffset((long)offsetToDelete).setPartitionIndex(topicPartition.partition()))))).setTimeoutMs(this.TIMEOUT_MS());
        return (DeleteRecordsRequest)new DeleteRecordsRequest.Builder(requestData).build();
    }

    private DeleteRecordsResponse sendDeleteRecordsRequest(DeleteRecordsRequest request) {
        return (DeleteRecordsResponse)this.connectAndReceive((AbstractRequest)request, this.anySocketServer(), this.connectAndReceive$default$3(), ClassTag$.MODULE$.apply(DeleteRecordsResponse.class));
    }

    private DeleteRecordsResponse sendDeleteRecordsRequest(DeleteRecordsRequest request, int leaderId) {
        return (DeleteRecordsResponse)this.connectAndReceive((AbstractRequest)request, this.brokerSocketServer(leaderId), this.connectAndReceive$default$3(), ClassTag$.MODULE$.apply(DeleteRecordsResponse.class));
    }

    private Seq<RecordMetadata> produceData(Iterable<TopicPartition> topicPartitions, int numMessagesPerPartition) {
        KafkaProducer producer = this.createProducer(new StringSerializer(), new StringSerializer(), this.createProducer$default$3());
        Seq sendfutureList = (Seq)((Seq)topicPartitions.toSeq().flatMap((Function1 & Serializable & scala.Serializable)tp -> (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numMessagesPerPartition).map((Function1 & Serializable & scala.Serializable)messageIndex -> DeleteRecordsRequestTest.$anonfun$produceData$2(tp, BoxesRunTime.unboxToInt((Object)messageIndex)), IndexedSeq$.MODULE$.canBuildFrom()), Seq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x$1 -> producer.send(x$1), Seq$.MODULE$.canBuildFrom());
        producer.flush();
        Seq recordMetadataList = (Seq)sendfutureList.map((Function1 & Serializable & scala.Serializable)x$3 -> (RecordMetadata)x$3.get(10L, TimeUnit.SECONDS), Seq$.MODULE$.canBuildFrom());
        recordMetadataList.foreach((Function1 & Serializable & scala.Serializable)recordMetadata -> {
            DeleteRecordsRequestTest.$anonfun$produceData$5(recordMetadata);
            return BoxedUnit.UNIT;
        });
        return recordMetadataList;
    }

    private void validateLogStartOffsetForTopic(TopicPartition topicPartition, long expectedStartOffset) {
        Option logForTopicPartition = ((TraversableLike)this.brokers().flatMap((Function1 & Serializable & scala.Serializable)x$4 -> {
            LogManager qual$1 = x$4.replicaManager().logManager();
            boolean x$2 = qual$1.getLog$default$2();
            return Option$.MODULE$.option2Iterable(qual$1.getLog(topicPartition, x$2));
        }, Buffer$.MODULE$.canBuildFrom())).headOption();
        Assertions.assertTrue((boolean)logForTopicPartition.isDefined());
        Assertions.assertEquals((long)expectedStartOffset, (long)((UnifiedLog)logForTopicPartition.get()).logStartOffset());
    }

    public static final /* synthetic */ ProducerRecord $anonfun$produceData$2(TopicPartition tp$1, int messageIndex) {
        String suffix = new StringBuilder(1).append(tp$1).append("-").append(messageIndex).toString();
        return new ProducerRecord(tp$1.topic(), Predef$.MODULE$.int2Integer(tp$1.partition()), (Object)new StringBuilder(4).append("key ").append(suffix).toString(), (Object)new StringBuilder(6).append("value ").append(suffix).toString());
    }

    public static final /* synthetic */ void $anonfun$produceData$5(RecordMetadata recordMetadata) {
        Assertions.assertTrue((recordMetadata.offset() >= 0L ? 1 : 0) != 0, (String)new StringBuilder(15).append("Invalid offset ").append(recordMetadata).toString());
    }

    public DeleteRecordsRequestTest() {
        this.TIMEOUT_MS = 1000;
        this.MESSAGES_PRODUCED_PER_PARTITION = 10;
    }
}

