/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import kafka.network.SocketServer;
import kafka.server.BaseRequestTest;
import kafka.server.KafkaBroker;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.message.DeleteTopicsRequestData;
import org.apache.kafka.common.message.DeleteTopicsResponseData;
import org.apache.kafka.common.message.UpdateMetadataRequestData;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.DeleteTopicsRequest;
import org.apache.kafka.common.requests.DeleteTopicsResponse;
import org.apache.kafka.common.requests.MetadataRequest;
import org.apache.kafka.common.requests.MetadataResponse;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.IterableLike;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayOps;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichLong$;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0015d\u0001\u0002\b\u0010\u0001QAQa\b\u0001\u0005\u0002\u0001BQA\t\u0001\u0005\u0002\rBQ!\u0015\u0001\u0005\u0002ICQa\u0016\u0001\u0005\naCQA\u001a\u0001\u0005\n\u001dDQ!\u001b\u0001\u0005\u0002)DQa\u001c\u0001\u0005\nADQ! \u0001\u0005\nyDq!!\u0004\u0001\t\u0003\ty\u0001C\u0004\u0002\u001e\u0001!I!a\b\t\u000f\u0005\u0015\u0002\u0001\"\u0003\u0002(!I\u0011\u0011\t\u0001\u0012\u0002\u0013%\u00111\t\u0005\b\u00033\u0002A\u0011AA.\u0005]!U\r\\3uKR{\u0007/[2t%\u0016\fX/Z:u)\u0016\u001cHO\u0003\u0002\u0011#\u000511/\u001a:wKJT\u0011AE\u0001\u0006W\u000647.Y\u0002\u0001'\r\u0001Q#\u0007\t\u0003-]i\u0011aD\u0005\u00031=\u0011qBQ1tKJ+\u0017/^3tiR+7\u000f\u001e\t\u00035ui\u0011a\u0007\u0006\u00039E\tQ!\u001e;jYNL!AH\u000e\u0003\u000f1{wmZ5oO\u00061A(\u001b8jiz\"\u0012!\t\t\u0003-\u0001\tA\u0006^3tiR{\u0007/[2EK2,G/[8o\u00072,8\u000f^3s\u0011\u0006\u001cxJ\u001a4mS:,\u0007+\u0019:uSRLwN\\:\u0015\u0005\u0011R\u0003CA\u0013)\u001b\u00051#\"A\u0014\u0002\u000bM\u001c\u0017\r\\1\n\u0005%2#\u0001B+oSRDQa\u000b\u0002A\u00021\na!];peVl\u0007CA\u00175\u001d\tq#\u0007\u0005\u00020M5\t\u0001G\u0003\u00022'\u00051AH]8pizJ!a\r\u0014\u0002\rA\u0013X\rZ3g\u0013\t)dG\u0001\u0004TiJLgn\u001a\u0006\u0003g\u0019BCA\u0001\u001dG\u000fB\u0011\u0011\bR\u0007\u0002u)\u00111\bP\u0001\taJ|g/\u001b3fe*\u0011QHP\u0001\u0007a\u0006\u0014\u0018-\\:\u000b\u0005}\u0002\u0015a\u00026va&$XM\u001d\u0006\u0003\u0003\n\u000bQA[;oSRT\u0011aQ\u0001\u0004_J<\u0017BA#;\u0005-1\u0016\r\\;f'>,(oY3\u0002\u000fM$(/\u001b8hg2\u0012\u0001JS\u0011\u0002\u0013\u0006\u0011!p[\u0011\u0002\u0017\u0006)1N]1gi\"\u0012!!\u0014\t\u0003\u001d>k\u0011\u0001P\u0005\u0003!r\u0012\u0011\u0003U1sC6,G/\u001a:ju\u0016$G+Z:u\u0003q!Xm\u001d;WC2LG\rR3mKR,Gk\u001c9jGJ+\u0017/^3tiN$\"\u0001J*\t\u000b-\u001a\u0001\u0019\u0001\u0017)\t\rAd)\u0016\u0017\u0003\u0011*C#aA'\u0002AY\fG.\u001b3bi\u00164\u0016\r\\5e\t\u0016dW\r^3U_BL7MU3rk\u0016\u001cHo\u001d\u000b\u0003IeCQA\u0017\u0003A\u0002m\u000bqA]3rk\u0016\u001cH\u000f\u0005\u0002]I6\tQL\u0003\u0002_?\u0006A!/Z9vKN$8O\u0003\u0002aC\u000611m\\7n_:T!A\u00052\u000b\u0005\r\u0014\u0015AB1qC\u000eDW-\u0003\u0002f;\n\u0019B)\u001a7fi\u0016$v\u000e]5dgJ+\u0017/^3ti\u00069c/\u00197jI\u0006$XMV1mS\u0012$U\r\\3uKR{\u0007/[2SKF,Xm\u001d;t/&$\b.\u00133t)\t!\u0003\u000eC\u0003[\u000b\u0001\u00071,\u0001\u000fuKN$XI\u001d:pe\u0012+G.\u001a;f)>\u0004\u0018n\u0019*fcV,7\u000f^:\u0015\u0005\u0011Z\u0007\"B\u0016\u0007\u0001\u0004a\u0003\u0006\u0002\u00049\r6d\u0013\u0001\u0013\u0015\u0003\r5\u000b\u0001E^1mS\u0012\fG/Z#se>\u0014H)\u001a7fi\u0016$v\u000e]5d%\u0016\fX/Z:ugR\u0019A%\u001d:\t\u000bi;\u0001\u0019A.\t\u000bM<\u0001\u0019\u0001;\u0002!\u0015D\b/Z2uK\u0012\u0014Vm\u001d9p]N,\u0007\u0003B\u0017vY]L!A\u001e\u001c\u0003\u00075\u000b\u0007\u000f\u0005\u0002yw6\t\u0011P\u0003\u0002{?\u0006A\u0001O]8u_\u000e|G.\u0003\u0002}s\n1QI\u001d:peN\fqE^1mS\u0012\fG/Z#se>\u0014H)\u001a7fi\u0016$v\u000e]5d%\u0016\fX/Z:ug^KG\u000f[%egR!Ae`A\u0001\u0011\u0015Q\u0006\u00021\u0001\\\u0011\u0019\u0019\b\u00021\u0001\u0002\u0004A)Q&^A\u0003oB!\u0011qAA\u0005\u001b\u0005y\u0016bAA\u0006?\n!Q+^5e\u0003E!Xm\u001d;O_R\u001cuN\u001c;s_2dWM\u001d\u000b\u0004I\u0005E\u0001\"B\u0016\n\u0001\u0004a\u0003&B\u00059\r\u0006UAf\u0001%\u0002\u0018\u0005\u0012\u0011\u0011D\u0001\fu.l\u0015n\u001a:bi&|g\u000e\u000b\u0002\n\u001b\u00061b/\u00197jI\u0006$X\rV8qS\u000eL5\u000fR3mKR,G\rF\u0002%\u0003CAa!a\t\u000b\u0001\u0004a\u0013!\u0002;pa&\u001c\u0017aF:f]\u0012$U\r\\3uKR{\u0007/[2t%\u0016\fX/Z:u)\u0019\tI#a\f\u00022A\u0019A,a\u000b\n\u0007\u00055RL\u0001\u000bEK2,G/\u001a+pa&\u001c7OU3ta>t7/\u001a\u0005\u00065.\u0001\ra\u0017\u0005\n\u0003gY\u0001\u0013!a\u0001\u0003k\tAb]8dW\u0016$8+\u001a:wKJ\u0004B!a\u000e\u0002>5\u0011\u0011\u0011\b\u0006\u0004\u0003w\t\u0012a\u00028fi^|'o[\u0005\u0005\u0003\u007f\tID\u0001\u0007T_\u000e\\W\r^*feZ,'/A\u0011tK:$G)\u001a7fi\u0016$v\u000e]5dgJ+\u0017/^3ti\u0012\"WMZ1vYR$#'\u0006\u0002\u0002F)\"\u0011QGA$W\t\tI\u0005\u0005\u0003\u0002L\u0005USBAA'\u0015\u0011\ty%!\u0015\u0002\u0013Ut7\r[3dW\u0016$'bAA*M\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\u0005]\u0013Q\n\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017\u0001\u0007;fgR$U\r\\3uKR{\u0007/[2t-\u0016\u00148/[8ogR\u0019A%!\u0018\t\u000b-j\u0001\u0019\u0001\u0017)\u000b5Ad)!\u0019-\u0003!C#!D'")
public class DeleteTopicsRequestTest
extends BaseRequestTest {
    /*
     * WARNING - void declaration
     */
    @ParameterizedTest
    @ValueSource(strings={"zk", "kraft"})
    public void testTopicDeletionClusterHasOfflinePartitions(String quorum) {
        String offlineTopic = "topic-1";
        String onlineTopic = "topic-2";
        this.createTopicWithAssignment(offlineTopic, (Map<Object, Seq<Object>>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0})))}))), this.createTopicWithAssignment$default$3());
        this.createTopicWithAssignment(onlineTopic, (Map<Object, Seq<Object>>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1})))}))), this.createTopicWithAssignment$default$3());
        this.killBroker(0);
        this.ensureConsistentKRaftMetadata();
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!DeleteTopicsRequestTest.$anonfun$testTopicDeletionClusterHasOfflinePartitions$1(this, onlineTopic, offlineTopic)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)DeleteTopicsRequestTest.$anonfun$testTopicDeletionClusterHasOfflinePartitions$4());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        this.deleteTopic(onlineTopic, this.deleteTopic$default$2());
        this.deleteTopic(offlineTopic, this.deleteTopic$default$2());
        this.ensureConsistentKRaftMetadata();
        this.restartDeadBrokers(this.restartDeadBrokers$default$1());
        long l3 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l4 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime2 = System.currentTimeMillis();
        while (!DeleteTopicsRequestTest.$anonfun$testTopicDeletionClusterHasOfflinePartitions$5(this, onlineTopic, offlineTopic)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime2 + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)DeleteTopicsRequestTest.$anonfun$testTopicDeletionClusterHasOfflinePartitions$8());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
    }

    @ParameterizedTest
    @ValueSource(strings={"zk", "kraft"})
    public void testValidDeleteTopicRequests(String quorum) {
        int timeout = 10000;
        this.createTopic("topic-1", this.createTopic$default$2(), this.createTopic$default$3(), this.createTopic$default$4(), this.createTopic$default$5(), this.createTopic$default$6());
        this.validateValidDeleteTopicRequests((DeleteTopicsRequest)new DeleteTopicsRequest.Builder(new DeleteTopicsRequestData().setTopicNames(Arrays.asList((Object[])new String[]{"topic-1"})).setTimeoutMs(timeout)).build());
        this.createTopic("topic-3", 5, 2, this.createTopic$default$4(), this.createTopic$default$5(), this.createTopic$default$6());
        this.createTopic("topic-4", 1, 2, this.createTopic$default$4(), this.createTopic$default$5(), this.createTopic$default$6());
        this.validateValidDeleteTopicRequests((DeleteTopicsRequest)new DeleteTopicsRequest.Builder(new DeleteTopicsRequestData().setTopicNames(Arrays.asList((Object[])new String[]{"topic-3", "topic-4"})).setTimeoutMs(timeout)).build());
        this.createTopic("topic-7", 3, 2, this.createTopic$default$4(), this.createTopic$default$5(), this.createTopic$default$6());
        this.createTopic("topic-6", 1, 2, this.createTopic$default$4(), this.createTopic$default$5(), this.createTopic$default$6());
        scala.collection.immutable.Map<String, Uuid> ids = this.getTopicIds();
        this.validateValidDeleteTopicRequestsWithIds((DeleteTopicsRequest)new DeleteTopicsRequest.Builder(new DeleteTopicsRequestData().setTopics(Arrays.asList((Object[])new DeleteTopicsRequestData.DeleteTopicState[]{new DeleteTopicsRequestData.DeleteTopicState().setTopicId((Uuid)ids.apply((Object)"topic-7")), new DeleteTopicsRequestData.DeleteTopicState().setTopicId((Uuid)ids.apply((Object)"topic-6"))})).setTimeoutMs(timeout)).build());
    }

    private void validateValidDeleteTopicRequests(DeleteTopicsRequest request) {
        DeleteTopicsResponse response = this.sendDeleteTopicsRequest(request, this.sendDeleteTopicsRequest$default$2());
        Assertions.assertTrue((boolean)((IterableLike)CollectionConverters$.MODULE$.mapAsScalaMapConverter(response.errorCounts()).asScala()).find((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)DeleteTopicsRequestTest.$anonfun$validateValidDeleteTopicRequests$1(x$5))).isEmpty(), (String)new StringBuilder(33).append("There should be no errors, found ").append(CollectionConverters$.MODULE$.collectionAsScalaIterableConverter((Collection)response.data().responses()).asScala()).toString());
        this.ensureConsistentKRaftMetadata();
        request.data().topicNames().forEach(topic -> this.validateTopicIsDeleted((String)topic));
    }

    private void validateValidDeleteTopicRequestsWithIds(DeleteTopicsRequest request) {
        DeleteTopicsResponse response2 = this.sendDeleteTopicsRequest(request, this.sendDeleteTopicsRequest$default$2());
        Assertions.assertTrue((boolean)((IterableLike)CollectionConverters$.MODULE$.mapAsScalaMapConverter(response2.errorCounts()).asScala()).find((Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)DeleteTopicsRequestTest.$anonfun$validateValidDeleteTopicRequestsWithIds$1(x$6))).isEmpty(), (String)new StringBuilder(33).append("There should be no errors, found ").append(CollectionConverters$.MODULE$.collectionAsScalaIterableConverter((Collection)response2.data().responses()).asScala()).toString());
        this.ensureConsistentKRaftMetadata();
        response2.data().responses().forEach(response -> this.validateTopicIsDeleted(response.name()));
    }

    /*
     * WARNING - void declaration
     */
    @ParameterizedTest
    @ValueSource(strings={"zk"})
    public void testErrorDeleteTopicRequests(String quorum) {
        int timeout = 30000;
        String timeoutTopic = "invalid-timeout";
        this.validateErrorDeleteTopicRequests((DeleteTopicsRequest)new DeleteTopicsRequest.Builder(new DeleteTopicsRequestData().setTopicNames(Arrays.asList((Object[])new String[]{"invalid-topic"})).setTimeoutMs(timeout)).build(), (scala.collection.immutable.Map<String, Errors>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"invalid-topic"), (Object)Errors.UNKNOWN_TOPIC_OR_PARTITION)}))));
        this.createTopic("partial-topic-1", this.createTopic$default$2(), this.createTopic$default$3(), this.createTopic$default$4(), this.createTopic$default$5(), this.createTopic$default$6());
        this.validateErrorDeleteTopicRequests((DeleteTopicsRequest)new DeleteTopicsRequest.Builder(new DeleteTopicsRequestData().setTopicNames(Arrays.asList((Object[])new String[]{"partial-topic-1", "partial-invalid-topic"})).setTimeoutMs(timeout)).build(), (scala.collection.immutable.Map<String, Errors>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"partial-topic-1"), (Object)Errors.NONE), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"partial-invalid-topic"), (Object)Errors.UNKNOWN_TOPIC_OR_PARTITION)}))));
        this.createTopic("topic-id-1", this.createTopic$default$2(), this.createTopic$default$3(), this.createTopic$default$4(), this.createTopic$default$5(), this.createTopic$default$6());
        Uuid validId = (Uuid)this.getTopicIds().apply((Object)"topic-id-1");
        Uuid invalidId = Uuid.randomUuid();
        this.validateErrorDeleteTopicRequestsWithIds((DeleteTopicsRequest)new DeleteTopicsRequest.Builder(new DeleteTopicsRequestData().setTopics(Arrays.asList((Object[])new DeleteTopicsRequestData.DeleteTopicState[]{new DeleteTopicsRequestData.DeleteTopicState().setTopicId(invalidId), new DeleteTopicsRequestData.DeleteTopicState().setTopicId(validId)})).setTimeoutMs(timeout)).build(), (scala.collection.immutable.Map<Uuid, Errors>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)invalidId), (Object)Errors.UNKNOWN_TOPIC_ID), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)validId), (Object)Errors.NONE)}))));
        this.createTopic(timeoutTopic, 5, 2, this.createTopic$default$4(), this.createTopic$default$5(), this.createTopic$default$6());
        this.validateErrorDeleteTopicRequests((DeleteTopicsRequest)new DeleteTopicsRequest.Builder(new DeleteTopicsRequestData().setTopicNames(Arrays.asList((Object[])new String[]{timeoutTopic})).setTimeoutMs(0)).build(), (scala.collection.immutable.Map<String, Errors>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)timeoutTopic), (Object)Errors.REQUEST_TIMED_OUT)}))));
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!DeleteTopicsRequestTest.$anonfun$testErrorDeleteTopicRequests$1(this, timeoutTopic)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)DeleteTopicsRequestTest.$anonfun$testErrorDeleteTopicRequests$2(timeoutTopic));
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        this.validateTopicIsDeleted(timeoutTopic);
    }

    private void validateErrorDeleteTopicRequests(DeleteTopicsRequest request, scala.collection.immutable.Map<String, Errors> expectedResponse) {
        DeleteTopicsResponse response = this.sendDeleteTopicsRequest(request, this.sendDeleteTopicsRequest$default$2());
        DeleteTopicsResponseData.DeletableTopicResultCollection errors = response.data().responses();
        int errorCount = BoxesRunTime.unboxToInt((Object)((TraversableOnce)CollectionConverters$.MODULE$.mapAsScalaMapConverter(response.errorCounts()).asScala()).foldLeft((Object)BoxesRunTime.boxToInteger((int)0), (Function2 & Serializable & scala.Serializable)(x$7, x$8) -> BoxesRunTime.boxToInteger((int)DeleteTopicsRequestTest.$anonfun$validateErrorDeleteTopicRequests$1(BoxesRunTime.unboxToInt((Object)x$7), x$8))));
        Assertions.assertEquals((int)expectedResponse.size(), (int)errorCount, (String)"The response size should match");
        expectedResponse.foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            DeleteTopicsRequestTest.$anonfun$validateErrorDeleteTopicRequests$2(this, expectedResponse, errors, x0$1);
            return BoxedUnit.UNIT;
        });
    }

    private void validateErrorDeleteTopicRequestsWithIds(DeleteTopicsRequest request, scala.collection.immutable.Map<Uuid, Errors> expectedResponse) {
        DeleteTopicsResponse response = this.sendDeleteTopicsRequest(request, this.sendDeleteTopicsRequest$default$2());
        DeleteTopicsResponseData.DeletableTopicResultCollection responses = response.data().responses();
        scala.collection.immutable.Map errors = ((TraversableOnce)((TraversableLike)CollectionConverters$.MODULE$.collectionAsScalaIterableConverter((Collection)responses).asScala()).map((Function1 & Serializable & scala.Serializable)result -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)result.topicId()), (Object)BoxesRunTime.boxToShort((short)result.errorCode())), Iterable$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        scala.collection.immutable.Map names = ((TraversableOnce)((TraversableLike)CollectionConverters$.MODULE$.collectionAsScalaIterableConverter((Collection)responses).asScala()).map((Function1 & Serializable & scala.Serializable)result -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)result.topicId()), (Object)result.name()), Iterable$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        int errorCount = BoxesRunTime.unboxToInt((Object)((TraversableOnce)CollectionConverters$.MODULE$.mapAsScalaMapConverter(response.errorCounts()).asScala()).foldLeft((Object)BoxesRunTime.boxToInteger((int)0), (Function2 & Serializable & scala.Serializable)(x$9, x$10) -> BoxesRunTime.boxToInteger((int)DeleteTopicsRequestTest.$anonfun$validateErrorDeleteTopicRequestsWithIds$3(BoxesRunTime.unboxToInt((Object)x$9), x$10))));
        Assertions.assertEquals((int)expectedResponse.size(), (int)errorCount, (String)"The response size should match");
        expectedResponse.foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            DeleteTopicsRequestTest.$anonfun$validateErrorDeleteTopicRequestsWithIds$4(this, expectedResponse, errors, names, x0$1);
            return BoxedUnit.UNIT;
        });
    }

    @ParameterizedTest
    @ValueSource(strings={"zk", "zkMigration"})
    public void testNotController(String quorum) {
        DeleteTopicsRequest request = (DeleteTopicsRequest)new DeleteTopicsRequest.Builder(new DeleteTopicsRequestData().setTopicNames(Collections.singletonList("not-controller")).setTimeoutMs(1000)).build();
        DeleteTopicsResponse response = this.sendDeleteTopicsRequest(request, this.notControllerSocketServer());
        Errors expectedError = this.isZkMigrationTest() ? Errors.NONE : Errors.NOT_CONTROLLER;
        short error = response.data().responses().find("not-controller").errorCode();
        Assertions.assertEquals((short)expectedError.code(), (short)error);
    }

    /*
     * WARNING - void declaration
     */
    private void validateTopicIsDeleted(String topic) {
        Iterable metadata = (Iterable)CollectionConverters$.MODULE$.collectionAsScalaIterableConverter(((MetadataResponse)this.connectAndReceive(new MetadataRequest.Builder((java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)topic, (List)Nil$.MODULE$)).asJava(), true).build(), this.connectAndReceive$default$2(), this.connectAndReceive$default$3(), ClassTag$.MODULE$.apply(MetadataResponse.class))).topicMetadata()).asScala();
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!DeleteTopicsRequestTest.$anonfun$validateTopicIsDeleted$1(metadata, topic)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)DeleteTopicsRequestTest.$anonfun$validateTopicIsDeleted$3(topic));
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
    }

    private DeleteTopicsResponse sendDeleteTopicsRequest(DeleteTopicsRequest request, SocketServer socketServer) {
        return (DeleteTopicsResponse)this.connectAndReceive((AbstractRequest)request, socketServer, this.connectAndReceive$default$3(), ClassTag$.MODULE$.apply(DeleteTopicsResponse.class));
    }

    private SocketServer sendDeleteTopicsRequest$default$2() {
        return this.adminSocketServer();
    }

    @ParameterizedTest
    @ValueSource(strings={"zk"})
    public void testDeleteTopicsVersions(String quorum) {
        Assertions.assertEquals((int)0, (int)0);
        Assertions.assertEquals((int)6, (int)6);
        int timeout = 10000;
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])DeleteTopicsRequestData.SCHEMAS)).indices().foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)version -> {
            this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(40).append("Creating and deleting tests for version ").append(version).toString());
            String topicName = new StringBuilder(6).append("topic-").append(version).toString();
            this.createTopic(topicName, this.createTopic$default$2(), this.createTopic$default$3(), this.createTopic$default$4(), this.createTopic$default$5(), this.createTopic$default$6());
            DeleteTopicsRequestData data = new DeleteTopicsRequestData().setTimeoutMs(timeout);
            if (version < 6) {
                data.setTopicNames(Arrays.asList((Object[])new String[]{topicName}));
            } else {
                data.setTopics(Arrays.asList((Object[])new DeleteTopicsRequestData.DeleteTopicState[]{new DeleteTopicsRequestData.DeleteTopicState().setName(topicName)}));
            }
            this.validateValidDeleteTopicRequests(new DeleteTopicsRequest.Builder(data).build((short)version));
        });
    }

    public static final /* synthetic */ boolean $anonfun$testTopicDeletionClusterHasOfflinePartitions$2(UpdateMetadataRequestData.UpdateMetadataPartitionState x$1) {
        return x$1.leader() == 1;
    }

    public static final /* synthetic */ boolean $anonfun$testTopicDeletionClusterHasOfflinePartitions$3(UpdateMetadataRequestData.UpdateMetadataPartitionState x$2) {
        return x$2.leader() == -1;
    }

    public static final /* synthetic */ boolean $anonfun$testTopicDeletionClusterHasOfflinePartitions$1(DeleteTopicsRequestTest $this, String onlineTopic$1, String offlineTopic$1) {
        return ((KafkaBroker)$this.aliveBrokers().head()).metadataCache().getPartitionInfo(onlineTopic$1, 0).exists((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)DeleteTopicsRequestTest.$anonfun$testTopicDeletionClusterHasOfflinePartitions$2(x$1))) && ((KafkaBroker)$this.aliveBrokers().head()).metadataCache().getPartitionInfo(offlineTopic$1, 0).exists((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)DeleteTopicsRequestTest.$anonfun$testTopicDeletionClusterHasOfflinePartitions$3(x$2)));
    }

    public static final /* synthetic */ String $anonfun$testTopicDeletionClusterHasOfflinePartitions$4() {
        return "Topic partition is not offline";
    }

    public static final /* synthetic */ boolean $anonfun$testTopicDeletionClusterHasOfflinePartitions$6(String onlineTopic$1, KafkaBroker x$3) {
        return x$3.metadataCache().contains(onlineTopic$1);
    }

    public static final /* synthetic */ boolean $anonfun$testTopicDeletionClusterHasOfflinePartitions$7(String offlineTopic$1, KafkaBroker x$4) {
        return x$4.metadataCache().contains(offlineTopic$1);
    }

    public static final /* synthetic */ boolean $anonfun$testTopicDeletionClusterHasOfflinePartitions$5(DeleteTopicsRequestTest $this, String onlineTopic$1, String offlineTopic$1) {
        return !$this.aliveBrokers().forall((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)DeleteTopicsRequestTest.$anonfun$testTopicDeletionClusterHasOfflinePartitions$6(onlineTopic$1, x$3))) && !$this.aliveBrokers().forall((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)DeleteTopicsRequestTest.$anonfun$testTopicDeletionClusterHasOfflinePartitions$7(offlineTopic$1, x$4)));
    }

    public static final /* synthetic */ String $anonfun$testTopicDeletionClusterHasOfflinePartitions$8() {
        return "The topics are found in the Broker's cache";
    }

    public static final /* synthetic */ boolean $anonfun$validateValidDeleteTopicRequests$1(Tuple2 x$5) {
        Object object = x$5._1();
        Errors errors = Errors.NONE;
        return object == null ? errors != null : !object.equals(errors);
    }

    public static final /* synthetic */ boolean $anonfun$validateValidDeleteTopicRequestsWithIds$1(Tuple2 x$6) {
        Object object = x$6._1();
        Errors errors = Errors.NONE;
        return object == null ? errors != null : !object.equals(errors);
    }

    public static final /* synthetic */ boolean $anonfun$testErrorDeleteTopicRequests$1(DeleteTopicsRequestTest $this, String timeoutTopic$1) {
        return !((KafkaBroker)$this.brokers().head()).metadataCache().contains(timeoutTopic$1);
    }

    public static final /* synthetic */ String $anonfun$testErrorDeleteTopicRequests$2(String timeoutTopic$1) {
        return new StringBuilder(23).append("Topic ").append(timeoutTopic$1).append(" is never deleted").toString();
    }

    public static final /* synthetic */ int $anonfun$validateErrorDeleteTopicRequests$1(int x$7, Tuple2 x$8) {
        return x$7 + Predef$.MODULE$.Integer2int((Integer)x$8._2());
    }

    public static final /* synthetic */ void $anonfun$validateErrorDeleteTopicRequests$2(DeleteTopicsRequestTest $this, scala.collection.immutable.Map expectedResponse$1, DeleteTopicsResponseData.DeletableTopicResultCollection errors$1, Tuple2 x0$1) {
        block5: {
            block8: {
                String topic;
                block7: {
                    Errors errors;
                    Errors errors2;
                    block6: {
                        if (x0$1 == null) break block5;
                        topic = (String)x0$1._1();
                        Errors expectedError = (Errors)x0$1._2();
                        Assertions.assertEquals((short)((Errors)expectedResponse$1.apply((Object)topic)).code(), (short)errors$1.find(topic).errorCode(), (String)"The response error should match");
                        errors2 = expectedError;
                        errors = Errors.NONE;
                        if (errors2 != null) break block6;
                        if (errors != null) {
                            return;
                        }
                        break block7;
                    }
                    if (!errors2.equals(errors)) break block8;
                }
                $this.validateTopicIsDeleted(topic);
                return;
            }
            return;
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ int $anonfun$validateErrorDeleteTopicRequestsWithIds$3(int x$9, Tuple2 x$10) {
        return x$9 + Predef$.MODULE$.Integer2int((Integer)x$10._2());
    }

    public static final /* synthetic */ void $anonfun$validateErrorDeleteTopicRequestsWithIds$4(DeleteTopicsRequestTest $this, scala.collection.immutable.Map expectedResponse$2, scala.collection.immutable.Map errors$2, scala.collection.immutable.Map names$1, Tuple2 x0$1) {
        block5: {
            block8: {
                Uuid topic;
                block7: {
                    Errors errors;
                    Errors errors2;
                    block6: {
                        if (x0$1 == null) break block5;
                        topic = (Uuid)x0$1._1();
                        Errors expectedError = (Errors)x0$1._2();
                        Assertions.assertEquals((short)((Errors)expectedResponse$2.apply((Object)topic)).code(), (short)BoxesRunTime.unboxToShort((Object)errors$2.apply((Object)topic)), (String)"The response error should match");
                        errors2 = expectedError;
                        errors = Errors.NONE;
                        if (errors2 != null) break block6;
                        if (errors != null) {
                            return;
                        }
                        break block7;
                    }
                    if (!errors2.equals(errors)) break block8;
                }
                $this.validateTopicIsDeleted((String)names$1.apply((Object)topic));
                return;
            }
            return;
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ boolean $anonfun$validateTopicIsDeleted$2(String topic$1, MetadataResponse.TopicMetadata p) {
        if (p.topic().equals(topic$1)) {
            Errors errors = p.error();
            Errors errors2 = Errors.NONE;
            if (!(errors != null ? !errors.equals(errors2) : errors2 != null)) {
                return true;
            }
        }
        return false;
    }

    public static final /* synthetic */ boolean $anonfun$validateTopicIsDeleted$1(Iterable metadata$1, String topic$1) {
        return !metadata$1.exists((Function1 & Serializable & scala.Serializable)p -> BoxesRunTime.boxToBoolean((boolean)DeleteTopicsRequestTest.$anonfun$validateTopicIsDeleted$2(topic$1, p)));
    }

    public static final /* synthetic */ String $anonfun$validateTopicIsDeleted$3(String topic$1) {
        return new StringBuilder(27).append("The topic ").append(topic$1).append(" should not exist").toString();
    }
}

