/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.IOException;
import java.io.Serializable;
import java.util.Collection;
import kafka.network.SocketServer;
import kafka.server.IntegrationTestUtils$;
import kafka.server.KafkaRaftServer$;
import kafka.test.ClusterInstance;
import kafka.test.annotation.ClusterTest;
import kafka.test.annotation.ClusterTestDefaults;
import kafka.test.annotation.Type;
import kafka.test.junit.ClusterTestExtensions;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.message.DescribeQuorumResponseData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.AbstractResponse;
import org.apache.kafka.common.requests.ApiVersionsRequest;
import org.apache.kafka.common.requests.ApiVersionsResponse;
import org.apache.kafka.common.requests.DescribeQuorumRequest;
import org.apache.kafka.common.requests.DescribeQuorumResponse;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Timeout;
import org.junit.jupiter.api.extension.ExtendWith;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.IterableLike;
import scala.collection.TraversableOnce;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@Timeout(value=120L)
@ExtendWith(value={ClusterTestExtensions.class})
@ClusterTestDefaults(types={Type.KRAFT})
@ScalaSignature(bytes="\u0006\u0001u4AAB\u0004\u0001\u0019!A1\u0003\u0001B\u0001B\u0003%A\u0003C\u0003\u001b\u0001\u0011\u00051\u0004C\u0003 \u0001\u0011\u0005\u0001\u0005C\u00033\u0001\u0011\u0005\u0001\u0005C\u00035\u0001\u0011%QGA\rEKN\u001c'/\u001b2f#V|'/^7SKF,Xm\u001d;UKN$(B\u0001\u0005\n\u0003\u0019\u0019XM\u001d<fe*\t!\"A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\u0005\u0001i\u0001C\u0001\b\u0012\u001b\u0005y!\"\u0001\t\u0002\u000bM\u001c\u0017\r\\1\n\u0005Iy!AB!osJ+g-A\u0004dYV\u001cH/\u001a:\u0011\u0005UAR\"\u0001\f\u000b\u0005]I\u0011\u0001\u0002;fgRL!!\u0007\f\u0003\u001f\rcWo\u001d;fe&s7\u000f^1oG\u0016\fa\u0001P5oSRtDC\u0001\u000f\u001f!\ti\u0002!D\u0001\b\u0011\u0015\u0019\"\u00011\u0001\u0015\u0003%\"Xm\u001d;EKN\u001c'/\u001b2f#V|'/^7O_R\u001cV\u000f\u001d9peR,GMQ=[W\n\u0013xn[3sgR\t\u0011\u0005\u0005\u0002\u000fE%\u00111e\u0004\u0002\u0005+:LG\u000f\u000b\u0003\u0004K-b\u0003C\u0001\u0014*\u001b\u00059#B\u0001\u0015\u0017\u0003)\tgN\\8uCRLwN\\\u0005\u0003U\u001d\u00121b\u00117vgR,'\u000fV3ti\u0006)A/\u001f9fg2\nQ\u0006J\u0001/\u0013\ty\u0003'\u0001\u0002[\u0017*\u0011\u0011gJ\u0001\u0005)f\u0004X-\u0001\nuKN$H)Z:de&\u0014W-U;peVl\u0007F\u0001\u0003&\u0003E\u0019wN\u001c8fGR\fe\u000e\u001a*fG\u0016Lg/Z\u000b\u0003mi\"\"aN+\u0015\u0005aj\u0005CA\u001d;\u0019\u0001!QaO\u0003C\u0002q\u0012\u0011\u0001V\t\u0003{\u0001\u0003\"A\u0004 \n\u0005}z!a\u0002(pi\"Lgn\u001a\t\u0003\u0003.k\u0011A\u0011\u0006\u0003\u0007\u0012\u000b\u0001B]3rk\u0016\u001cHo\u001d\u0006\u0003\u000b\u001a\u000baaY8n[>t'B\u0001\u0006H\u0015\tA\u0015*\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002\u0015\u0006\u0019qN]4\n\u00051\u0013%\u0001E!cgR\u0014\u0018m\u0019;SKN\u0004xN\\:f\u0011\u0015qU\u0001q\u0001P\u0003!\u0019G.Y:t)\u0006<\u0007c\u0001)Tq5\t\u0011K\u0003\u0002S\u001f\u00059!/\u001a4mK\u000e$\u0018B\u0001+R\u0005!\u0019E.Y:t)\u0006<\u0007\"\u0002,\u0006\u0001\u00049\u0016a\u0002:fcV,7\u000f\u001e\t\u0003\u0003bK!!\u0017\"\u0003\u001f\u0005\u00137\u000f\u001e:bGR\u0014V-];fgRDC\u0001A.,=B\u0011a\u0005X\u0005\u0003;\u001e\u00121c\u00117vgR,'\u000fV3ti\u0012+g-Y;miNd\u0013a\u0018\u0013\u0002A&\u0011\u0011\rM\u0001\u0006\u0017J\u000be\t\u0016\u0015\u0005\u0001\r|\u0007\u000f\u0005\u0002e[6\tQM\u0003\u0002gO\u0006IQ\r\u001f;f]NLwN\u001c\u0006\u0003Q&\f1!\u00199j\u0015\tQ7.A\u0004kkBLG/\u001a:\u000b\u00051L\u0015!\u00026v]&$\u0018B\u00018f\u0005))\u0005\u0010^3oI^KG\u000f[\u0001\u0006m\u0006dW/\u001a\u0017\u0002c\u000e\n!\u000f\u0005\u0002tk6\tAO\u0003\u0002m-%\u0011a\u000f\u001e\u0002\u0016\u00072,8\u000f^3s)\u0016\u001cH/\u0012=uK:\u001c\u0018n\u001c8tQ\u0011\u0001\u0001p\u001c?\u0011\u0005eTX\"A4\n\u0005m<'a\u0002+j[\u0016|W\u000f\u001e\u0010\u0002q\u0002")
public class DescribeQuorumRequestTest {
    private final ClusterInstance cluster;

    @ClusterTest(types={Type.ZK})
    public void testDescribeQuorumNotSupportedByZkBrokers() {
        ApiVersionsRequest apiRequest = (ApiVersionsRequest)new ApiVersionsRequest.Builder().build();
        Assertions.assertNull((Object)((ApiVersionsResponse)this.connectAndReceive((AbstractRequest)apiRequest, ClassTag$.MODULE$.apply(ApiVersionsResponse.class))).apiVersion(ApiKeys.DESCRIBE_QUORUM.id));
        DescribeQuorumRequest describeQuorumRequest = (DescribeQuorumRequest)new DescribeQuorumRequest.Builder(DescribeQuorumRequest.singletonRequest((TopicPartition)KafkaRaftServer$.MODULE$.MetadataPartition())).build();
        Assertions.assertThrows(IOException.class, () -> this.connectAndReceive((AbstractRequest)describeQuorumRequest, ClassTag$.MODULE$.apply(DescribeQuorumResponse.class)));
    }

    @ClusterTest
    public void testDescribeQuorum() {
        ((IterableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(ApiKeys.DESCRIBE_QUORUM.allVersions()).asScala()).foreach((Function1 & Serializable & scala.Serializable)version -> {
            DescribeQuorumRequestTest.$anonfun$testDescribeQuorum$1(this, version);
            return BoxedUnit.UNIT;
        });
    }

    private <T extends AbstractResponse> T connectAndReceive(AbstractRequest request, ClassTag<T> classTag) {
        return IntegrationTestUtils$.MODULE$.connectAndReceive(request, (SocketServer)((IterableLike)CollectionConverters$.MODULE$.collectionAsScalaIterableConverter(this.cluster.brokerSocketServers()).asScala()).head(), this.cluster.clientListener(), classTag);
    }

    public static final /* synthetic */ boolean $anonfun$testDescribeQuorum$2(int leaderId$1, DescribeQuorumResponseData.ReplicaState x$1) {
        return x$1.replicaId() == leaderId$1;
    }

    public static final /* synthetic */ void $anonfun$testDescribeQuorum$6(Short version$1, DescribeQuorumResponseData.ReplicaState state) {
        Assertions.assertTrue((0L < state.logEndOffset() ? 1 : 0) != 0);
        if (BoxesRunTime.equalsNumObject((Number)version$1, (Object)BoxesRunTime.boxToInteger((int)0))) {
            Assertions.assertEquals((long)-1L, (long)state.lastFetchTimestamp());
            Assertions.assertEquals((long)-1L, (long)state.lastCaughtUpTimestamp());
            return;
        }
        Assertions.assertNotEquals((long)-1L, (long)state.lastFetchTimestamp());
        Assertions.assertNotEquals((long)-1L, (long)state.lastCaughtUpTimestamp());
    }

    public static final /* synthetic */ boolean $anonfun$testDescribeQuorum$8(DescribeQuorumRequestTest $this, DescribeQuorumResponseData.Node x$5) {
        return BoxesRunTime.equals((Object)BoxesRunTime.boxToInteger((int)x$5.nodeId()), (Object)((IterableLike)CollectionConverters$.MODULE$.asScalaSetConverter($this.cluster.controllers().keySet()).asScala()).head());
    }

    public static final /* synthetic */ void $anonfun$testDescribeQuorum$1(DescribeQuorumRequestTest $this, Short version) {
        DescribeQuorumRequest request = new DescribeQuorumRequest.Builder(DescribeQuorumRequest.singletonRequest((TopicPartition)KafkaRaftServer$.MODULE$.MetadataPartition())).build(Predef$.MODULE$.Short2short(version));
        DescribeQuorumResponse response = (DescribeQuorumResponse)$this.connectAndReceive((AbstractRequest)request, ClassTag$.MODULE$.apply(DescribeQuorumResponse.class));
        Assertions.assertEquals((Object)Errors.NONE, (Object)Errors.forCode((short)response.data().errorCode()));
        Assertions.assertEquals((Object)"", (Object)response.data().errorMessage());
        Assertions.assertEquals((int)1, (int)response.data().topics().size());
        DescribeQuorumResponseData.TopicData topicData = (DescribeQuorumResponseData.TopicData)response.data().topics().get(0);
        Assertions.assertEquals((Object)KafkaRaftServer$.MODULE$.MetadataTopic(), (Object)topicData.topicName());
        Assertions.assertEquals((int)1, (int)topicData.partitions().size());
        DescribeQuorumResponseData.PartitionData partitionData = (DescribeQuorumResponseData.PartitionData)topicData.partitions().get(0);
        Assertions.assertEquals((int)KafkaRaftServer$.MODULE$.MetadataPartition().partition(), (int)partitionData.partitionIndex());
        Assertions.assertEquals((Object)Errors.NONE, (Object)Errors.forCode((short)partitionData.errorCode()));
        Assertions.assertEquals((Object)"", (Object)partitionData.errorMessage());
        Assertions.assertTrue((partitionData.leaderEpoch() > 0 ? 1 : 0) != 0);
        int leaderId = partitionData.leaderId();
        Assertions.assertTrue((leaderId > 0 ? 1 : 0) != 0);
        Assertions.assertTrue((partitionData.leaderEpoch() > 0 ? 1 : 0) != 0);
        Assertions.assertTrue((partitionData.highWatermark() > 0L ? 1 : 0) != 0);
        Assertions.assertTrue((((DescribeQuorumResponseData.ReplicaState)((IterableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(partitionData.currentVoters()).asScala()).find((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)DescribeQuorumRequestTest.$anonfun$testDescribeQuorum$2(leaderId, x$1))).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new AssertionError((Object)"Failed to find leader among current voter states");
        })).logEndOffset() > 0L ? 1 : 0) != 0);
        Buffer voterData = (Buffer)CollectionConverters$.MODULE$.asScalaBufferConverter(partitionData.currentVoters()).asScala();
        Assertions.assertEquals((Object)CollectionConverters$.MODULE$.asScalaSetConverter($this.cluster.controllerIds()).asScala(), (Object)((TraversableOnce)voterData.map((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToInteger((int)x$2.replicaId()), Buffer$.MODULE$.canBuildFrom())).toSet());
        Buffer observerData = (Buffer)CollectionConverters$.MODULE$.asScalaBufferConverter(partitionData.observers()).asScala();
        Assertions.assertEquals((Object)CollectionConverters$.MODULE$.asScalaSetConverter($this.cluster.brokerIds()).asScala(), (Object)((TraversableOnce)observerData.map((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToInteger((int)x$3.replicaId()), Buffer$.MODULE$.canBuildFrom())).toSet());
        voterData.$plus$plus((GenTraversableOnce)observerData).foreach((Function1 & Serializable & scala.Serializable)state -> {
            DescribeQuorumRequestTest.$anonfun$testDescribeQuorum$6(version, state);
            return BoxedUnit.UNIT;
        });
        if (Predef$.MODULE$.Short2short(version) >= 2) {
            Iterable nodes = (Iterable)CollectionConverters$.MODULE$.collectionAsScalaIterableConverter((Collection)response.data().nodes()).asScala();
            Assertions.assertEquals((Object)CollectionConverters$.MODULE$.asScalaSetConverter($this.cluster.controllerIds()).asScala(), (Object)((TraversableOnce)nodes.map((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToInteger((int)x$4.nodeId()), Iterable$.MODULE$.canBuildFrom())).toSet());
            Option node = nodes.find((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)DescribeQuorumRequestTest.$anonfun$testDescribeQuorum$8($this, x$5)));
            Assertions.assertEquals((Object)$this.cluster.controllerListenerName().get().value(), (Object)((DescribeQuorumResponseData.Listener)((IterableLike)CollectionConverters$.MODULE$.collectionAsScalaIterableConverter((Collection)((DescribeQuorumResponseData.Node)node.get()).listeners()).asScala()).head()).name());
            return;
        }
    }

    public DescribeQuorumRequestTest(ClusterInstance cluster) {
        this.cluster = cluster;
    }
}

