/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.Serializable;
import java.net.InetAddress;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Properties;
import java.util.concurrent.ExecutionException;
import kafka.integration.KafkaServerTestHarness;
import kafka.log.LogManager;
import kafka.log.UnifiedLog;
import kafka.network.ConnectionQuotas;
import kafka.server.ConfigHandler;
import kafka.server.KafkaBroker;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.server.QuotaFactory;
import kafka.server.ZkConfigManager;
import kafka.utils.Json$;
import kafka.utils.TestUtils$;
import kafka.zk.AdminZkClient;
import kafka.zk.ConfigEntityChangeNotificationZNode$;
import kafka.zk.KafkaZkClient;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.clients.admin.AlterConfigOp;
import org.apache.kafka.clients.admin.Config;
import org.apache.kafka.clients.admin.ConfigEntry;
import org.apache.kafka.common.KafkaFuture;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.compress.Compression;
import org.apache.kafka.common.config.ConfigResource;
import org.apache.kafka.common.errors.InvalidRequestException;
import org.apache.kafka.common.errors.UnknownTopicOrPartitionException;
import org.apache.kafka.common.metrics.Quota;
import org.apache.kafka.common.quota.ClientQuotaAlteration;
import org.apache.kafka.common.quota.ClientQuotaEntity;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.record.RecordVersion;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.apache.kafka.server.common.MetadataVersion;
import org.apache.kafka.server.config.ServerLogConfigs;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Timeout;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.jdk.CollectionConverters$;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LongRef;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.RichLong$;
import scala.runtime.java8.JFunction1;

@Timeout(value=100L)
@ScalaSignature(bytes="\u0006\u0001\t}c\u0001B\u000f\u001f\u0001\rBQA\u000b\u0001\u0005\u0002-BQA\f\u0001\u0005\u0002=BQ!\u0010\u0001\u0005\u0002yBQA\u001b\u0001\u0005\u0002-DQ\u0001\u001d\u0001\u0005\u0002EDQA\u001e\u0001\u0005\n]Dq!a\t\u0001\t\u0003\t)\u0003C\u0004\u00020\u0001!\t!!\r\t\u000f\u0005m\u0002\u0001\"\u0001\u0002>!9\u0011q\t\u0001\u0005\u0002\u0005%\u0003bBA*\u0001\u0011\u0005\u0011Q\u000b\u0005\b\u0003?\u0002A\u0011AA1\u0011\u001d\tY\u0007\u0001C\u0001\u0003[Bq!a\u001e\u0001\t\u0003\tI\bC\u0004\u0002\u0004\u0002!\t!!\"\t\u000f\u0005=\u0005\u0001\"\u0001\u0002\u0012\"9\u00111\u0014\u0001\u0005\n\u0005u\u0005bBAP\u0001\u0011\u0005\u0011\u0011\u0015\u0005\b\u0003W\u0003A\u0011AAW\u0011\u001d\t9\f\u0001C\u0001\u0003sCq!a1\u0001\t\u0003\t)\rC\u0004\u0002P\u0002!I!!5\t\u000f\u0005\u0005\b\u0001\"\u0003\u0002d\"9\u0011q\u001d\u0001\u0005\n\u0005%\bb\u0002B\u000f\u0001\u0011\u0005!q\u0004\u0005\b\u0005S\u0001A\u0011\u0001B\u0016\u0011\u001d\u0011)\u0004\u0001C\u0001\u0005oAqA!\u0011\u0001\t\u0013\u0011\u0019EA\fEs:\fW.[2D_:4\u0017nZ\"iC:<W\rV3ti*\u0011q\u0004I\u0001\u0007g\u0016\u0014h/\u001a:\u000b\u0003\u0005\nQa[1gW\u0006\u001c\u0001a\u0005\u0002\u0001IA\u0011Q\u0005K\u0007\u0002M)\u0011q\u0005I\u0001\fS:$Xm\u001a:bi&|g.\u0003\u0002*M\t12*\u00194lCN+'O^3s)\u0016\u001cH\u000fS1s]\u0016\u001c8/\u0001\u0004=S:LGO\u0010\u000b\u0002YA\u0011Q\u0006A\u0007\u0002=\u0005yq-\u001a8fe\u0006$XmQ8oM&<7/F\u00011!\r\t\u0004HO\u0007\u0002e)\u00111\u0007N\u0001\nS6lW\u000f^1cY\u0016T!!\u000e\u001c\u0002\u0015\r|G\u000e\\3di&|gNC\u00018\u0003\u0015\u00198-\u00197b\u0013\tI$G\u0001\u0003MSN$\bCA\u0017<\u0013\tadDA\u0006LC\u001a\\\u0017mQ8oM&<\u0017\u0001\u0005;fgR\u001cuN\u001c4jO\u000eC\u0017M\\4f)\ty4\t\u0005\u0002A\u00036\ta'\u0003\u0002Cm\t!QK\\5u\u0011\u0015!5\u00011\u0001F\u0003\u0019\tXo\u001c:v[B\u0011a)\u0014\b\u0003\u000f.\u0003\"\u0001\u0013\u001c\u000e\u0003%S!A\u0013\u0012\u0002\rq\u0012xn\u001c;?\u0013\tae'\u0001\u0004Qe\u0016$WMZ\u0005\u0003\u001d>\u0013aa\u0015;sS:<'B\u0001'7Q\u0011\u0019\u0011k\u00181\u0011\u0005IkV\"A*\u000b\u0005Q+\u0016\u0001\u00039s_ZLG-\u001a:\u000b\u0005Y;\u0016A\u00029be\u0006l7O\u0003\u0002Y3\u00069!.\u001e9ji\u0016\u0014(B\u0001.\\\u0003\u0015QWO\\5u\u0015\u0005a\u0016aA8sO&\u0011al\u0015\u0002\f-\u0006dW/Z*pkJ\u001cW-A\u0004tiJLgnZ:-\u0005\u0005\u001c\u0017%\u00012\u0002\u0005i\\\u0017%\u00013\u0002\u000b-\u0014\u0018M\u001a;)\u0005\r1\u0007CA4i\u001b\u0005)\u0016BA5V\u0005E\u0001\u0016M]1nKR,'/\u001b>fIR+7\u000f^\u0001\u001di\u0016\u001cH\u000fR=oC6L7\rV8qS\u000e\u001cuN\u001c4jO\u000eC\u0017M\\4f)\tyD\u000eC\u0003E\t\u0001\u0007Q\t\u000b\u0003\u0005#~sGFA1dQ\t!a-\u0001\u0010uKN$X*Z:tC\u001e,gi\u001c:nCR4VM]:j_:\u001c\u0005.\u00198hKR\u0011qH\u001d\u0005\u0006\t\u0016\u0001\r!\u0012\u0015\u0005\u000bE{F\u000fL\u0001bQ\t)a-A\u000buKN$\u0018+^8uC\u000e{gNZ5h\u0007\"\fgnZ3\u0015\r}B\u00181BA\u0010\u0011\u0015Ih\u00011\u0001{\u0003\u0019)g\u000e^5usB\u001910a\u0002\u000e\u0003qT!! @\u0002\u000bE,x\u000e^1\u000b\u0007}\f\t!\u0001\u0004d_6lwN\u001c\u0006\u0004C\u0005\r!bAA\u00037\u00061\u0011\r]1dQ\u0016L1!!\u0003}\u0005E\u0019E.[3oiF+x\u000e^1F]RLG/\u001f\u0005\b\u0003\u001b1\u0001\u0019AA\b\u0003\u0011)8/\u001a:\u0011\t\u0005E\u00111D\u0007\u0003\u0003'QA!!\u0006\u0002\u0018\u0005!\u0011-\u001e;i\u0015\r\tIB`\u0001\tg\u0016\u001cWO]5us&!\u0011QDA\n\u00059Y\u0015MZ6b!JLgnY5qC2Da!!\t\u0007\u0001\u0004)\u0015\u0001C2mS\u0016tG/\u00133\u0002;Q,7\u000f^\"mS\u0016tG/\u00133Rk>$\u0018mQ8oM&<7\t[1oO\u0016$2aPA\u0014\u0011\u0015!u\u00011\u0001FQ\u00159\u0011kXA\u0016Y\t\t7\r\u000b\u0002\bM\u0006IB/Z:u+N,'/U;pi\u0006\u001cuN\u001c4jO\u000eC\u0017M\\4f)\ry\u00141\u0007\u0005\u0006\t\"\u0001\r!\u0012\u0015\u0006\u0011E{\u0016q\u0007\u0017\u0003C\u000eD#\u0001\u00034\u00027Q,7\u000f^+tKJ\u001cE.[3oi&#\u0017+^8uC\u000eC\u0017M\\4f)\ry\u0014q\b\u0005\u0006\t&\u0001\r!\u0012\u0015\u0006\u0013E{\u00161\t\u0017\u0003C\u000eD#!\u00034\u0002IQ,7\u000f\u001e#fM\u0006,H\u000e^\"mS\u0016tG/\u00133Rk>$\u0018mQ8oM&<7\t[1oO\u0016$2aPA&\u0011\u0015!%\u00021\u0001FQ\u0015Q\u0011kXA(Y\t\t7\r\u000b\u0002\u000bM\u0006\u0001C/Z:u\t\u00164\u0017-\u001e7u+N,'/U;pi\u0006\u001cuN\u001c4jO\u000eC\u0017M\\4f)\ry\u0014q\u000b\u0005\u0006\t.\u0001\r!\u0012\u0015\u0006\u0017E{\u00161\f\u0017\u0003C\u000eD#a\u00034\u0002QQ,7\u000f\u001e#fM\u0006,H\u000e^+tKJ\u001cE.[3oi&#\u0017+^8uC\u000e{gNZ5h\u0007\"\fgnZ3\u0015\u0007}\n\u0019\u0007C\u0003E\u0019\u0001\u0007Q\tK\u0003\r#~\u000b9\u0007\f\u0002bG\"\u0012ABZ\u0001\u0018i\u0016\u001cH/U;pi\u0006Le.\u001b;jC2L'0\u0019;j_:$2aPA8\u0011\u0015!U\u00021\u0001FQ\u0015i\u0011kXA:Y\u0005\t\u0007FA\u0007g\u0003e!Xm\u001d;JaF+x\u000e^1J]&$\u0018.\u00197ju\u0006$\u0018n\u001c8\u0015\u0007}\nY\bC\u0003E\u001d\u0001\u0007Q\tK\u0003\u000f#~\u000by\b\f\u0002bG\"\u0012aBZ\u0001\u0018i\u0016\u001cH/\u00139Rk>$\u0018mQ8oM&<7\t[1oO\u0016$2aPAD\u0011\u0015!u\u00021\u0001FQ\u0015y\u0011kXAFY\t\t7\r\u000b\u0002\u0010M\u0006\u0011C/Z:u\u0007>tg-[4DQ\u0006tw-Z(o\u001d>tW\t_5ti&tw\rV8qS\u000e$2aPAJ\u0011\u0015!\u0005\u00031\u0001FQ\u0015\u0001\u0012kXALY\u0005\t\u0007F\u0001\tg\u0003%!X-\u001c9U_BL7\rF\u0001F\u0003E\"Xm\u001d;D_:4\u0017nZ\"iC:<Wm\u00148O_:,\u00050[:uS:<Gk\u001c9jG^KG\u000f[!e[&t7\t\\5f]R$2aPAR\u0011\u0015!%\u00031\u0001FQ\u0015\u0011\u0012kXATY\t\t7\r\u000b\u0002\u0013M\u00069B/Z:u!J|7-Z:t\u001d>$\u0018NZ5dCRLwN\u001c\u000b\u0004\u007f\u0005=\u0006\"\u0002#\u0014\u0001\u0004)\u0005&B\nR?\u0006MF&A1)\u0005M1\u0017A\n;fgRLen\u0019:f[\u0016tG/\u00197BYR,'\u000fR3gCVdG\u000fV8qS\u000e\u001cuN\u001c4jOR\u0019q(a/\t\u000b\u0011#\u0002\u0019A#)\u000bQ\tv,a0-\u0005\u0005\u001c\u0007F\u0001\u000bg\u0003m!Xm\u001d;BYR,'\u000fR3gCVdG\u000fV8qS\u000e\u001cuN\u001c4jOR\u0019q(a2\t\u000b\u0011+\u0002\u0019A#)\u000bU\tv,a3-\u0005\u0005\u001c\u0007FA\u000bg\u0003A\u0019X\r\u001e\"s_.,'oQ8oM&<7\u000fF\u0003@\u0003'\f9\u000e\u0003\u0004\u0002VZ\u0001\r!R\u0001\tEJ|7.\u001a:JI\"9\u0011\u0011\u001c\fA\u0002\u0005m\u0017\u0001\u00038foZ\u000bG.^3\u0011\u0007\u0001\u000bi.C\u0002\u0002`Z\u0012A\u0001T8oO\u0006\u0019B-\u001a7fi\u0016\u0014%o\\6fe\u000e{gNZ5hgR\u0019q(!:\t\r\u0005Uw\u00031\u0001F\u0003I\tG\u000e^3s\u0005J|7.\u001a:D_:4\u0017nZ:\u0015\u000f}\nY/!<\u0002p\"1\u0011Q\u001b\rA\u0002\u0015Cq!!7\u0019\u0001\u0004\tY\u000eC\u0004\u0002rb\u0001\r!a=\u0002\u0005=\u0004\b\u0003BA{\u0005/qA!a>\u0003\u00129!\u0011\u0011 B\u0006\u001d\u0011\tYPa\u0002\u000f\t\u0005u(Q\u0001\b\u0005\u0003\u007f\u0014\u0019AD\u0002I\u0005\u0003I\u0011\u0001X\u0005\u0004\u0003\u000bY\u0016bA\u0011\u0002\u0004%!!\u0011BA\u0001\u0003\u001d\u0019G.[3oiNLAA!\u0004\u0003\u0010\u0005)\u0011\rZ7j]*!!\u0011BA\u0001\u0013\u0011\u0011\u0019B!\u0006\u0002\u001b\u0005cG/\u001a:D_:4\u0017nZ(q\u0015\u0011\u0011iAa\u0004\n\t\te!1\u0004\u0002\u0007\u001fB$\u0016\u0010]3\u000b\t\tM!QC\u0001\"i\u0016\u001cHO\u0011:pW\u0016\u0014\u0018\nZ\"p]\u001aLwm\u00115b]\u001e,\u0017I\u001c3EK2,G/\u001a\u000b\u0004\u007f\t\u0005\u0002\"\u0002#\u001a\u0001\u0004)\u0005&B\rR?\n\u0015BFA1dQ\tIb-\u0001\u0015uKN$H)\u001a4bk2$(I]8lKJLEmQ8oM&<7\t[1oO\u0016\fe\u000e\u001a#fY\u0016$X\rF\u0002@\u0005[AQ\u0001\u0012\u000eA\u0002\u0015CSAG)`\u0005ca#!Y2)\u0005i1\u0017A\t;fgR$UMZ1vYR\fe\u000e\u001a\"s_.,'/\u00133D_:4\u0017nZ\"iC:<W\rF\u0002@\u0005sAQ\u0001R\u000eA\u0002\u0015CSaG)`\u0005{a#!Y2)\u0005m1\u0017!E2sK\u0006$X-\u00113nS:\u001cE.[3oiR\u0011!Q\t\t\u0005\u0005\u000f\u0012I%\u0004\u0002\u0003\u0016%!!1\nB\u000b\u0005\u0015\tE-\\5oQ\u001d\u0001!q\nB.\u0005;\u0002BA!\u0015\u0003X5\u0011!1\u000b\u0006\u0004\u0005+:\u0016aA1qS&!!\u0011\fB*\u0005\u001d!\u0016.\\3pkR\fQA^1mk\u0016t\u0012\u0001\u001a")
public class DynamicConfigChangeTest
extends KafkaServerTestHarness {
    public List<KafkaConfig> generateConfigs() {
        return new .colon.colon((Object)KafkaConfig$.MODULE$.fromProps(TestUtils$.MODULE$.createBrokerConfig(0, this.zkConnectOrNull(), TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18(), TestUtils$.MODULE$.createBrokerConfig$default$19(), TestUtils$.MODULE$.createBrokerConfig$default$20(), TestUtils$.MODULE$.createBrokerConfig$default$21())), (List)Nil$.MODULE$);
    }

    /*
     * WARNING - void declaration
     */
    @ParameterizedTest
    @ValueSource(strings={"zk", "kraft"})
    public void testConfigChange(String quorum) {
        if (!this.isKRaftTest()) {
            Assertions.assertTrue((boolean)((KafkaServer)this.servers().head()).dynamicConfigHandlers().contains((Object)"topics"), (String)"Should contain a ConfigHandler for topics");
        }
        Long oldVal = Predef$.MODULE$.long2Long(100000L);
        Long newVal = Predef$.MODULE$.long2Long(200000L);
        TopicPartition tp = new TopicPartition("test", 0);
        Properties logProps = new Properties();
        logProps.put("flush.messages", oldVal.toString());
        this.createTopic(tp.topic(), 1, 1, logProps, this.createTopic$default$5(), this.createTopic$default$6());
        TestUtils$ testUtils$ = TestUtils$.MODULE$;
        long l = 10000L;
        if (testUtils$ == null) {
            throw null;
        }
        TestUtils$ retry_this = testUtils$;
        LongRef retry_wait = LongRef.create((long)1L);
        long retry_startTime = System.currentTimeMillis();
        while (true) {
            try {
                DynamicConfigChangeTest.$anonfun$testConfigChange$1(this, tp, oldVal);
            }
            catch (AssertionError retry_e) {
                void retry_maxWaitMs;
                if (System.currentTimeMillis() - retry_startTime > retry_maxWaitMs) {
                    throw retry_e;
                }
                if (retry_this.logger().underlying().isInfoEnabled()) {
                    retry_this.logger().underlying().info(retry_this.msgWithLogIdent(TestUtils$.$anonfun$retry$1(retry_wait)));
                }
                Thread.sleep(retry_wait.elem);
                retry_wait.elem += package$.MODULE$.min(retry_wait.elem, 1000L);
                continue;
            }
            break;
        }
        if (this.isKRaftTest()) {
            try (Admin admin = this.createAdminClient();){
                ConfigResource resource = new ConfigResource(ConfigResource.Type.TOPIC, tp.topic());
                AlterConfigOp op = new AlterConfigOp(new ConfigEntry("flush.messages", newVal.toString()), AlterConfigOp.OpType.SET);
                ConfigResource resource2 = new ConfigResource(ConfigResource.Type.BROKER, "");
                AlterConfigOp op2 = new AlterConfigOp(new ConfigEntry(ServerLogConfigs.LOG_FLUSH_INTERVAL_MS_CONFIG, newVal.toString()), AlterConfigOp.OpType.SET);
                admin.incrementalAlterConfigs((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)resource), (Object)CollectionConverters$.MODULE$.asJavaCollectionConverter((Iterable)new .colon.colon((Object)op, (List)Nil$.MODULE$)).asJavaCollection()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)resource2), (Object)CollectionConverters$.MODULE$.asJavaCollectionConverter((Iterable)new .colon.colon((Object)op2, (List)Nil$.MODULE$)).asJavaCollection())}))).asJava()).all().get();
            }
        } else {
            Properties newProps = new Properties();
            newProps.setProperty("flush.messages", newVal.toString());
            this.adminZkClient().changeTopicConfig(tp.topic(), newProps);
        }
        TestUtils$ testUtils$2 = TestUtils$.MODULE$;
        long l2 = 10000L;
        if (testUtils$2 == null) {
            throw null;
        }
        TestUtils$ retry_this2 = testUtils$2;
        LongRef retry_wait2 = LongRef.create((long)1L);
        long retry_startTime2 = System.currentTimeMillis();
        while (true) {
            try {
                DynamicConfigChangeTest.$anonfun$testConfigChange$2(this, newVal, tp);
            }
            catch (AssertionError retry_e) {
                void retry_maxWaitMs;
                if (System.currentTimeMillis() - retry_startTime2 > retry_maxWaitMs) {
                    throw retry_e;
                }
                if (retry_this2.logger().underlying().isInfoEnabled()) {
                    retry_this2.logger().underlying().info(retry_this2.msgWithLogIdent(TestUtils$.$anonfun$retry$1(retry_wait2)));
                }
                Thread.sleep(retry_wait2.elem);
                retry_wait2.elem += package$.MODULE$.min(retry_wait2.elem, 1000L);
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - void declaration
     */
    @ParameterizedTest
    @ValueSource(strings={"zk", "kraft"})
    public void testDynamicTopicConfigChange(String quorum) {
        TopicPartition tp = new TopicPartition("test", 0);
        int oldSegmentSize = 1000;
        Properties logProps = new Properties();
        logProps.put("segment.bytes", Integer.toString(oldSegmentSize));
        this.createTopic(tp.topic(), 1, 1, logProps, this.createTopic$default$5(), this.createTopic$default$6());
        TestUtils$ testUtils$ = TestUtils$.MODULE$;
        long l = 10000L;
        if (testUtils$ == null) {
            throw null;
        }
        TestUtils$ retry_this = testUtils$;
        LongRef retry_wait = LongRef.create((long)1L);
        long retry_startTime = System.currentTimeMillis();
        while (true) {
            try {
                DynamicConfigChangeTest.$anonfun$testDynamicTopicConfigChange$1(this, tp, oldSegmentSize);
            }
            catch (AssertionError retry_e) {
                void retry_maxWaitMs;
                if (System.currentTimeMillis() - retry_startTime > retry_maxWaitMs) {
                    throw retry_e;
                }
                if (retry_this.logger().underlying().isInfoEnabled()) {
                    retry_this.logger().underlying().info(retry_this.msgWithLogIdent(TestUtils$.$anonfun$retry$1(retry_wait)));
                }
                Thread.sleep(retry_wait.elem);
                retry_wait.elem += package$.MODULE$.min(retry_wait.elem, 1000L);
                continue;
            }
            break;
        }
        int newSegmentSize = 2000;
        if (this.isKRaftTest()) {
            try (Admin admin = this.createAdminClient();){
                ConfigResource resource = new ConfigResource(ConfigResource.Type.TOPIC, tp.topic());
                AlterConfigOp op = new AlterConfigOp(new ConfigEntry("segment.bytes", Integer.toString(newSegmentSize)), AlterConfigOp.OpType.SET);
                admin.incrementalAlterConfigs((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)resource), (Object)CollectionConverters$.MODULE$.asJavaCollectionConverter((Iterable)new .colon.colon((Object)op, (List)Nil$.MODULE$)).asJavaCollection())}))).asJava()).all().get();
            }
        } else {
            Properties newProps = new Properties();
            newProps.put("segment.bytes", Integer.toString(newSegmentSize));
            this.adminZkClient().changeTopicConfig(tp.topic(), newProps);
        }
        LogManager qual$2 = ((KafkaBroker)this.brokers().head()).logManager();
        boolean x$4 = qual$2.getLog$default$2();
        UnifiedLog log = (UnifiedLog)qual$2.getLog(tp, x$4).get();
        TestUtils$ testUtils$2 = TestUtils$.MODULE$;
        long l2 = 10000L;
        if (testUtils$2 == null) {
            throw null;
        }
        TestUtils$ retry_this2 = testUtils$2;
        LongRef retry_wait2 = LongRef.create((long)1L);
        long retry_startTime2 = System.currentTimeMillis();
        while (true) {
            try {
                DynamicConfigChangeTest.$anonfun$testDynamicTopicConfigChange$2(newSegmentSize, log);
            }
            catch (AssertionError retry_e) {
                void retry_maxWaitMs;
                if (System.currentTimeMillis() - retry_startTime2 > retry_maxWaitMs) {
                    throw retry_e;
                }
                if (retry_this2.logger().underlying().isInfoEnabled()) {
                    retry_this2.logger().underlying().info(retry_this2.msgWithLogIdent(TestUtils$.$anonfun$retry$1(retry_wait2)));
                }
                Thread.sleep(retry_wait2.elem);
                retry_wait2.elem += package$.MODULE$.min(retry_wait2.elem, 1000L);
                continue;
            }
            break;
        }
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), 50).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> TestUtils$.MODULE$.produceMessage(this.brokers(), tp.topic(), Integer.toString(i), TestUtils$.MODULE$.produceMessage$default$4(), TestUtils$.MODULE$.produceMessage$default$5(), TestUtils$.MODULE$.produceMessage$default$6()));
        Assertions.assertTrue((boolean)log.logSegments().stream().allMatch(x$1 -> x$1.size() > 1000), (String)"Log segment size change not applied");
    }

    /*
     * WARNING - void declaration
     */
    @ParameterizedTest
    @ValueSource(strings={"zk"})
    public void testMessageFormatVersionChange(String quorum) {
        TopicPartition tp = new TopicPartition("test", 0);
        Properties logProps = new Properties();
        logProps.put("message.format.version", "0.10.2");
        this.createTopic(tp.topic(), 1, 1, logProps, this.createTopic$default$5(), this.createTopic$default$6());
        KafkaServer server = (KafkaServer)this.servers().head();
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!DynamicConfigChangeTest.$anonfun$testMessageFormatVersionChange$1(server, tp)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)DynamicConfigChangeTest.$anonfun$testMessageFormatVersionChange$2());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        LogManager qual$2 = server.logManager();
        boolean x$4 = qual$2.getLog$default$2();
        UnifiedLog log = (UnifiedLog)qual$2.getLog(tp, x$4).get();
        Assertions.assertEquals((Object)MetadataVersion.IBP_3_0_IV1, (Object)log.config().messageFormatVersion);
        Assertions.assertEquals((Object)RecordVersion.V2, (Object)log.config().recordVersion());
        CompressionType compressionType = CompressionType.LZ4;
        logProps.put("message.format.version", "0.11.0");
        logProps.put("compression.type", compressionType.name);
        this.adminZkClient().changeTopicConfig(tp.topic(), logProps);
        long l3 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l4 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime2 = System.currentTimeMillis();
        while (!DynamicConfigChangeTest.$anonfun$testMessageFormatVersionChange$3(server, tp, compressionType)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime2 + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)DynamicConfigChangeTest.$anonfun$testMessageFormatVersionChange$4());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        Assertions.assertEquals((Object)MetadataVersion.IBP_3_0_IV1, (Object)log.config().messageFormatVersion);
        Assertions.assertEquals((Object)RecordVersion.V2, (Object)log.config().recordVersion());
    }

    /*
     * WARNING - void declaration
     */
    private void testQuotaConfigChange(ClientQuotaEntity entity, KafkaPrincipal user, String clientId) {
        try (Admin admin = this.createAdminClient();){
            java.util.List<Object> alterations = Arrays.asList((Object[])new ClientQuotaAlteration[]{new ClientQuotaAlteration(entity, Arrays.asList((Object[])new ClientQuotaAlteration.Op[]{new ClientQuotaAlteration.Op("producer_byte_rate", Predef$.MODULE$.double2Double(1000.0)), new ClientQuotaAlteration.Op("consumer_byte_rate", Predef$.MODULE$.double2Double(2000.0))}))});
            admin.alterClientQuotas(alterations).all().get();
            QuotaFactory.QuotaManagers quotaManagers = ((KafkaBroker)this.brokers().head()).dataPlaneRequestProcessor().quotas();
            TestUtils$ testUtils$ = TestUtils$.MODULE$;
            long l = 10000L;
            if (testUtils$ == null) {
                throw null;
            }
            TestUtils$ retry_this = testUtils$;
            LongRef retry_wait = LongRef.create((long)1L);
            long retry_startTime = System.currentTimeMillis();
            while (true) {
                try {
                    DynamicConfigChangeTest.$anonfun$testQuotaConfigChange$1(quotaManagers, user, clientId);
                }
                catch (AssertionError retry_e) {
                    void retry_maxWaitMs;
                    if (System.currentTimeMillis() - retry_startTime > retry_maxWaitMs) {
                        throw retry_e;
                    }
                    if (retry_this.logger().underlying().isInfoEnabled()) {
                        retry_this.logger().underlying().info(retry_this.msgWithLogIdent(TestUtils$.$anonfun$retry$1(retry_wait)));
                    }
                    Thread.sleep(retry_wait.elem);
                    retry_wait.elem += package$.MODULE$.min(retry_wait.elem, 1000L);
                    continue;
                }
                break;
            }
            double defaultProducerQuota = Long.MAX_VALUE;
            double defaultConsumerQuota = Long.MAX_VALUE;
            java.util.List<Object> removals = Arrays.asList((Object[])new ClientQuotaAlteration[]{new ClientQuotaAlteration(entity, Arrays.asList((Object[])new ClientQuotaAlteration.Op[]{new ClientQuotaAlteration.Op("producer_byte_rate", null), new ClientQuotaAlteration.Op("consumer_byte_rate", null)}))});
            admin.alterClientQuotas(removals).all().get();
            TestUtils$ testUtils$2 = TestUtils$.MODULE$;
            long l2 = 10000L;
            if (testUtils$2 == null) {
                throw null;
            }
            TestUtils$ retry_this2 = testUtils$2;
            LongRef retry_wait2 = LongRef.create((long)1L);
            long retry_startTime2 = System.currentTimeMillis();
            while (true) {
                try {
                    DynamicConfigChangeTest.$anonfun$testQuotaConfigChange$2(quotaManagers, user, clientId, defaultProducerQuota, defaultConsumerQuota);
                }
                catch (AssertionError retry_e) {
                    void retry_maxWaitMs;
                    if (System.currentTimeMillis() - retry_startTime2 > retry_maxWaitMs) {
                        throw retry_e;
                    }
                    if (retry_this2.logger().underlying().isInfoEnabled()) {
                        retry_this2.logger().underlying().info(retry_this2.msgWithLogIdent(TestUtils$.$anonfun$retry$1(retry_wait2)));
                    }
                    Thread.sleep(retry_wait2.elem);
                    retry_wait2.elem += package$.MODULE$.min(retry_wait2.elem, 1000L);
                    continue;
                }
                break;
            }
        }
    }

    @ParameterizedTest
    @ValueSource(strings={"zk", "kraft"})
    public void testClientIdQuotaConfigChange(String quorum) {
        HashMap<String, String> m = new HashMap<String, String>();
        m.put("client-id", "testClient");
        this.testQuotaConfigChange(new ClientQuotaEntity(m), KafkaPrincipal.ANONYMOUS, "testClient");
    }

    @ParameterizedTest
    @ValueSource(strings={"zk", "kraft"})
    public void testUserQuotaConfigChange(String quorum) {
        HashMap<String, String> m = new HashMap<String, String>();
        m.put("user", "ANONYMOUS");
        this.testQuotaConfigChange(new ClientQuotaEntity(m), KafkaPrincipal.ANONYMOUS, "testClient");
    }

    @ParameterizedTest
    @ValueSource(strings={"zk", "kraft"})
    public void testUserClientIdQuotaChange(String quorum) {
        HashMap<String, String> m = new HashMap<String, String>();
        m.put("user", "ANONYMOUS");
        m.put("client-id", "testClient");
        this.testQuotaConfigChange(new ClientQuotaEntity(m), KafkaPrincipal.ANONYMOUS, "testClient");
    }

    @ParameterizedTest
    @ValueSource(strings={"zk", "kraft"})
    public void testDefaultClientIdQuotaConfigChange(String quorum) {
        HashMap<String, Object> m = new HashMap<String, Object>();
        m.put("client-id", null);
        this.testQuotaConfigChange(new ClientQuotaEntity(m), KafkaPrincipal.ANONYMOUS, "testClient");
    }

    @ParameterizedTest
    @ValueSource(strings={"zk", "kraft"})
    public void testDefaultUserQuotaConfigChange(String quorum) {
        HashMap<String, Object> m = new HashMap<String, Object>();
        m.put("user", null);
        this.testQuotaConfigChange(new ClientQuotaEntity(m), KafkaPrincipal.ANONYMOUS, "testClient");
    }

    @ParameterizedTest
    @ValueSource(strings={"zk", "kraft"})
    public void testDefaultUserClientIdQuotaConfigChange(String quorum) {
        HashMap<String, Object> m = new HashMap<String, Object>();
        m.put("user", null);
        m.put("client-id", null);
        this.testQuotaConfigChange(new ClientQuotaEntity(m), KafkaPrincipal.ANONYMOUS, "testClient");
    }

    @ParameterizedTest
    @ValueSource(strings={"zk"})
    public void testQuotaInitialization(String quorum) {
        KafkaServer server = (KafkaServer)this.servers().head();
        Properties clientIdProps = new Properties();
        server.shutdown();
        clientIdProps.put("producer_byte_rate", "1000");
        clientIdProps.put("consumer_byte_rate", "2000");
        Properties userProps = new Properties();
        userProps.put("producer_byte_rate", "10000");
        userProps.put("consumer_byte_rate", "20000");
        Properties userClientIdProps = new Properties();
        userClientIdProps.put("producer_byte_rate", "100000");
        userClientIdProps.put("consumer_byte_rate", "200000");
        this.adminZkClient().changeClientIdConfig("overriddenClientId", clientIdProps);
        AdminZkClient qual$1 = this.adminZkClient();
        String x$1 = "overriddenUser";
        boolean x$3 = qual$1.changeUserOrUserClientIdConfig$default$3();
        qual$1.changeUserOrUserClientIdConfig(x$1, userProps, x$3);
        AdminZkClient qual$2 = this.adminZkClient();
        String x$4 = "ANONYMOUS/clients/overriddenUserClientId";
        boolean x$6 = qual$2.changeUserOrUserClientIdConfig$default$3();
        qual$2.changeUserOrUserClientIdConfig(x$4, userClientIdProps, x$6);
        this.zkClient().getChildren(ConfigEntityChangeNotificationZNode$.MODULE$.path()).foreach((Function1 & Serializable & scala.Serializable)p -> {
            DynamicConfigChangeTest.$anonfun$testQuotaInitialization$1(this, p);
            return BoxedUnit.UNIT;
        });
        server.startup();
        QuotaFactory.QuotaManagers quotaManagers = server.dataPlaneRequestProcessor().quotas();
        Assertions.assertEquals((Object)Quota.upperBound((double)1000.0), (Object)quotaManagers.produce().quota("someuser", "overriddenClientId"));
        Assertions.assertEquals((Object)Quota.upperBound((double)2000.0), (Object)quotaManagers.fetch().quota("someuser", "overriddenClientId"));
        Assertions.assertEquals((Object)Quota.upperBound((double)10000.0), (Object)quotaManagers.produce().quota("overriddenUser", "someclientId"));
        Assertions.assertEquals((Object)Quota.upperBound((double)20000.0), (Object)quotaManagers.fetch().quota("overriddenUser", "someclientId"));
        Assertions.assertEquals((Object)Quota.upperBound((double)100000.0), (Object)quotaManagers.produce().quota("ANONYMOUS", "overriddenUserClientId"));
        Assertions.assertEquals((Object)Quota.upperBound((double)200000.0), (Object)quotaManagers.fetch().quota("ANONYMOUS", "overriddenUserClientId"));
    }

    /*
     * WARNING - void declaration
     */
    @ParameterizedTest
    @ValueSource(strings={"zk", "kraft"})
    public void testIpQuotaInitialization(String quorum) {
        KafkaBroker broker = (KafkaBroker)this.brokers().head();
        if (this.isKRaftTest()) {
            try (Admin admin = this.createAdminClient();){
                java.util.List<Object> alterations = Arrays.asList((Object[])new ClientQuotaAlteration[]{new ClientQuotaAlteration(new ClientQuotaEntity(Collections.singletonMap("ip", null)), Collections.singletonList(new ClientQuotaAlteration.Op("connection_creation_rate", Predef$.MODULE$.double2Double(20.0)))), new ClientQuotaAlteration(new ClientQuotaEntity(Collections.singletonMap("ip", "1.2.3.4")), Collections.singletonList(new ClientQuotaAlteration.Op("connection_creation_rate", Predef$.MODULE$.double2Double(10.0))))});
                admin.alterClientQuotas(alterations).all().get();
            }
        } else {
            broker.shutdown();
            Properties ipDefaultProps = new Properties();
            ipDefaultProps.put("connection_creation_rate", "20");
            this.adminZkClient().changeIpConfig("<default>", ipDefaultProps);
            Properties ipOverrideProps = new Properties();
            ipOverrideProps.put("connection_creation_rate", "10");
            this.adminZkClient().changeIpConfig("1.2.3.4", ipOverrideProps);
            this.zkClient().getChildren(ConfigEntityChangeNotificationZNode$.MODULE$.path()).foreach((Function1 & Serializable & scala.Serializable)p -> {
                DynamicConfigChangeTest.$anonfun$testIpQuotaInitialization$1(this, p);
                return BoxedUnit.UNIT;
            });
            broker.startup();
        }
        TestUtils$ testUtils$ = TestUtils$.MODULE$;
        long l = 10000L;
        if (testUtils$ == null) {
            throw null;
        }
        TestUtils$ retry_this = testUtils$;
        LongRef retry_wait = LongRef.create((long)1L);
        long retry_startTime = System.currentTimeMillis();
        while (true) {
            try {
                DynamicConfigChangeTest.$anonfun$testIpQuotaInitialization$2(broker);
            }
            catch (AssertionError retry_e) {
                void retry_maxWaitMs;
                if (System.currentTimeMillis() - retry_startTime > retry_maxWaitMs) {
                    throw retry_e;
                }
                if (retry_this.logger().underlying().isInfoEnabled()) {
                    retry_this.logger().underlying().info(retry_this.msgWithLogIdent(TestUtils$.$anonfun$retry$1(retry_wait)));
                }
                Thread.sleep(retry_wait.elem);
                retry_wait.elem += package$.MODULE$.min(retry_wait.elem, 1000L);
                continue;
            }
            break;
        }
    }

    @ParameterizedTest
    @ValueSource(strings={"zk", "kraft"})
    public void testIpQuotaConfigChange(String quorum) {
        try (Admin admin = this.createAdminClient();){
            java.util.List<Object> alterations = Arrays.asList((Object[])new ClientQuotaAlteration[]{new ClientQuotaAlteration(new ClientQuotaEntity(Collections.singletonMap("ip", null)), Collections.singletonList(new ClientQuotaAlteration.Op("connection_creation_rate", Predef$.MODULE$.double2Double(20.0)))), new ClientQuotaAlteration(new ClientQuotaEntity(Collections.singletonMap("ip", "1.2.3.4")), Collections.singletonList(new ClientQuotaAlteration.Op("connection_creation_rate", Predef$.MODULE$.double2Double(10.0))))});
            admin.alterClientQuotas(alterations).all().get();
            InetAddress overrideQuotaIp = InetAddress.getByName("1.2.3.4");
            this.verifyConnectionQuota$1(overrideQuotaIp, Predef$.MODULE$.int2Integer(10));
            InetAddress defaultQuotaIp = InetAddress.getByName("2.3.4.5");
            this.verifyConnectionQuota$1(defaultQuotaIp, Predef$.MODULE$.int2Integer(20));
            java.util.List<Object> deletions1 = Arrays.asList((Object[])new ClientQuotaAlteration[]{new ClientQuotaAlteration(new ClientQuotaEntity(Collections.singletonMap("ip", "1.2.3.4")), Collections.singletonList(new ClientQuotaAlteration.Op("connection_creation_rate", null)))});
            admin.alterClientQuotas(deletions1).all().get();
            this.verifyConnectionQuota$1(overrideQuotaIp, Predef$.MODULE$.int2Integer(20));
            java.util.List<Object> deletions2 = Arrays.asList((Object[])new ClientQuotaAlteration[]{new ClientQuotaAlteration(new ClientQuotaEntity(Collections.singletonMap("ip", null)), Collections.singletonList(new ClientQuotaAlteration.Op("connection_creation_rate", null)))});
            admin.alterClientQuotas(deletions2).all().get();
            this.verifyConnectionQuota$1(overrideQuotaIp, Predef$.MODULE$.int2Integer(Integer.MAX_VALUE));
        }
    }

    @ParameterizedTest
    @ValueSource(strings={"zk"})
    public void testConfigChangeOnNonExistingTopic(String quorum) {
        String topic = this.tempTopic();
        Properties logProps = new Properties();
        logProps.put("flush.messages", Predef$.MODULE$.int2Integer(10000));
        Assertions.assertThrows(UnknownTopicOrPartitionException.class, () -> this.adminZkClient().changeTopicConfig(topic, logProps));
    }

    private String tempTopic() {
        return new StringBuilder(9).append("testTopic").append(TestUtils$.MODULE$.random().nextInt(1000000)).toString();
    }

    @ParameterizedTest
    @ValueSource(strings={"zk", "kraft"})
    public void testConfigChangeOnNonExistingTopicWithAdminClient(String quorum) {
        String topic = this.tempTopic();
        try (Admin admin = this.createAdminClient();){
            try {
                ConfigResource resource = new ConfigResource(ConfigResource.Type.TOPIC, topic);
                AlterConfigOp op = new AlterConfigOp(new ConfigEntry("flush.messages", "10000"), AlterConfigOp.OpType.SET);
                admin.incrementalAlterConfigs((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)resource), (Object)CollectionConverters$.MODULE$.asJavaCollectionConverter((Iterable)new .colon.colon((Object)op, (List)Nil$.MODULE$)).asJavaCollection())}))).asJava()).all().get();
                Assertions.fail((String)"Should fail with UnknownTopicOrPartitionException for topic doesn't exist");
            }
            catch (ExecutionException executionException) {
                Assertions.assertTrue((boolean)(executionException.getCause() instanceof UnknownTopicOrPartitionException));
            }
        }
    }

    @ParameterizedTest
    @ValueSource(strings={"zk"})
    public void testProcessNotification(String quorum) {
        new Properties().put("a.b", "10");
        ConfigHandler handler = (ConfigHandler)Mockito.mock(ConfigHandler.class);
        ZkConfigManager configManager = new ZkConfigManager(this.zkClient(), (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"topics"), (Object)handler)})));
        configManager.ConfigChangedNotificationHandler().processNotification("not json".getBytes(StandardCharsets.UTF_8));
        ObjectRef jsonMap = ObjectRef.create((Object)((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"v"), (Object)BoxesRunTime.boxToInteger((int)1)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"x"), (Object)BoxesRunTime.boxToInteger((int)2))}))));
        Assertions.assertThrows(Throwable.class, () -> configManager.ConfigChangedNotificationHandler().processNotification(Json$.MODULE$.encodeAsBytes(CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)jsonMap$1.elem).asJava())));
        jsonMap.elem = (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"version"), (Object)BoxesRunTime.boxToInteger((int)1)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"entity_type"), (Object)"garbage"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"entity_name"), (Object)"x")}));
        Assertions.assertThrows(Throwable.class, () -> configManager.ConfigChangedNotificationHandler().processNotification(Json$.MODULE$.encodeAsBytes(CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)jsonMap$1.elem).asJava())));
        jsonMap.elem = (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"version"), (Object)BoxesRunTime.boxToInteger((int)1)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"entity_type"), (Object)"topics")}));
        Assertions.assertThrows(Throwable.class, () -> configManager.ConfigChangedNotificationHandler().processNotification(Json$.MODULE$.encodeAsBytes(CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)jsonMap$1.elem).asJava())));
        jsonMap.elem = (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"version"), (Object)BoxesRunTime.boxToInteger((int)1)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"entity_type"), (Object)"topics"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"entity_name"), (Object)"x")}));
        configManager.ConfigChangedNotificationHandler().processNotification(Json$.MODULE$.encodeAsBytes(CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)jsonMap.elem).asJava()));
        ((ConfigHandler)Mockito.verify((Object)handler)).processConfigChanges(ArgumentMatchers.anyString(), (Properties)ArgumentMatchers.any());
    }

    @ParameterizedTest
    @ValueSource(strings={"zk", "kraft"})
    public void testIncrementalAlterDefaultTopicConfig(String quorum) {
        try (Admin admin = this.createAdminClient();){
            ConfigResource resource = new ConfigResource(ConfigResource.Type.TOPIC, "");
            AlterConfigOp op = new AlterConfigOp(new ConfigEntry("flush.messages", "200000"), AlterConfigOp.OpType.SET);
            KafkaFuture future = admin.incrementalAlterConfigs((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)resource), (Object)CollectionConverters$.MODULE$.asJavaCollectionConverter((Iterable)new .colon.colon((Object)op, (List)Nil$.MODULE$)).asJavaCollection())}))).asJava()).all();
            TestUtils$.MODULE$.assertFutureExceptionTypeEquals(future, InvalidRequestException.class, TestUtils$.MODULE$.assertFutureExceptionTypeEquals$default$3());
        }
    }

    @ParameterizedTest
    @ValueSource(strings={"zk", "kraft"})
    public void testAlterDefaultTopicConfig(String quorum) {
        try (Admin admin = this.createAdminClient();){
            ConfigResource resource = new ConfigResource(ConfigResource.Type.TOPIC, "");
            Config config = new Config(Collections.singleton(new ConfigEntry("flush.messages", "200000")));
            KafkaFuture future = admin.alterConfigs((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)resource), (Object)config)}))).asJava()).all();
            TestUtils$.MODULE$.assertFutureExceptionTypeEquals(future, InvalidRequestException.class, TestUtils$.MODULE$.assertFutureExceptionTypeEquals$default$3());
        }
    }

    private void setBrokerConfigs(String brokerId, long newValue) {
        this.alterBrokerConfigs(brokerId, newValue, AlterConfigOp.OpType.SET);
    }

    private void deleteBrokerConfigs(String brokerId) {
        this.alterBrokerConfigs(brokerId, 0L, AlterConfigOp.OpType.DELETE);
    }

    private void alterBrokerConfigs(String brokerId, long newValue, AlterConfigOp.OpType op) {
        if (this.isKRaftTest()) {
            try (Admin admin = this.createAdminClient();){
                ConfigResource resource = new ConfigResource(ConfigResource.Type.BROKER, brokerId);
                AlterConfigOp configOp = new AlterConfigOp(new ConfigEntry("leader.replication.throttled.rate", Long.toString(newValue)), op);
                AlterConfigOp configOp2 = new AlterConfigOp(new ConfigEntry("follower.replication.throttled.rate", Long.toString(newValue)), op);
                AlterConfigOp configOp3 = new AlterConfigOp(new ConfigEntry("replica.alter.log.dirs.io.max.bytes.per.second", Long.toString(newValue)), op);
                Collection configOps = CollectionConverters$.MODULE$.asJavaCollectionConverter((Iterable)new .colon.colon((Object)configOp, (List)new .colon.colon((Object)configOp2, (List)new .colon.colon((Object)configOp3, (List)Nil$.MODULE$)))).asJavaCollection();
                admin.incrementalAlterConfigs((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)resource), (Object)configOps)}))).asJava()).all().get();
            }
            return;
        }
        Properties newProps = new Properties();
        AlterConfigOp.OpType opType = op;
        AlterConfigOp.OpType opType2 = AlterConfigOp.OpType.SET;
        if (!(opType != null ? !opType.equals(opType2) : opType2 != null)) {
            newProps.put("leader.replication.throttled.rate", Long.toString(newValue));
            newProps.put("follower.replication.throttled.rate", Long.toString(newValue));
            newProps.put("replica.alter.log.dirs.io.max.bytes.per.second", Long.toString(newValue));
        }
        String string = brokerId;
        String string2 = "";
        None$ brokerIdOption = string == null || !string.equals(string2) ? Option$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)new StringOps(Predef$.MODULE$.augmentString(brokerId)).toInt())) : None$.MODULE$;
        this.adminZkClient().changeBrokerConfig((Option)brokerIdOption, newProps);
    }

    @ParameterizedTest
    @ValueSource(strings={"zk", "kraft"})
    public void testBrokerIdConfigChangeAndDelete(String quorum) {
        long newValue = 100000L;
        String brokerId = Integer.toString(((KafkaBroker)this.brokers().head()).config().brokerId());
        this.setBrokerConfigs(brokerId, newValue);
        this.brokers().foreach((Function1 & Serializable & scala.Serializable)b -> {
            DynamicConfigChangeTest.$anonfun$testBrokerIdConfigChangeAndDelete$1(brokerId, newValue, b);
            return BoxedUnit.UNIT;
        });
        this.deleteBrokerConfigs(brokerId);
        this.brokers().foreach((Function1 & Serializable & scala.Serializable)b -> {
            DynamicConfigChangeTest.$anonfun$testBrokerIdConfigChangeAndDelete$3(b);
            return BoxedUnit.UNIT;
        });
    }

    @ParameterizedTest
    @ValueSource(strings={"zk", "kraft"})
    public void testDefaultBrokerIdConfigChangeAndDelete(String quorum) {
        long newValue = 100000L;
        String brokerId = "";
        this.setBrokerConfigs(brokerId, newValue);
        this.brokers().foreach((Function1 & Serializable & scala.Serializable)b -> {
            DynamicConfigChangeTest.$anonfun$testDefaultBrokerIdConfigChangeAndDelete$1(newValue, b);
            return BoxedUnit.UNIT;
        });
        this.deleteBrokerConfigs(brokerId);
        this.brokers().foreach((Function1 & Serializable & scala.Serializable)b -> {
            DynamicConfigChangeTest.$anonfun$testDefaultBrokerIdConfigChangeAndDelete$3(b);
            return BoxedUnit.UNIT;
        });
    }

    @ParameterizedTest
    @ValueSource(strings={"zk", "kraft"})
    public void testDefaultAndBrokerIdConfigChange(String quorum) {
        long newValue = 100000L;
        String brokerId = Integer.toString(((KafkaBroker)this.brokers().head()).config().brokerId());
        this.setBrokerConfigs(brokerId, newValue);
        long newDefaultValue = 200000L;
        this.setBrokerConfigs("", newDefaultValue);
        this.brokers().foreach((Function1 & Serializable & scala.Serializable)b -> {
            DynamicConfigChangeTest.$anonfun$testDefaultAndBrokerIdConfigChange$1(brokerId, newValue, newDefaultValue, b);
            return BoxedUnit.UNIT;
        });
    }

    private Admin createAdminClient() {
        Properties props = new Properties();
        props.put("bootstrap.servers", this.bootstrapServers(this.bootstrapServers$default$1()));
        return Admin.create((Properties)props);
    }

    public static final /* synthetic */ void $anonfun$testConfigChange$1(DynamicConfigChangeTest $this, TopicPartition tp$1, Long oldVal$1) {
        LogManager qual$1 = ((KafkaBroker)$this.brokers().head()).logManager();
        boolean x$2 = qual$1.getLog$default$2();
        Option logOpt = qual$1.getLog(tp$1, x$2);
        Assertions.assertTrue((boolean)logOpt.isDefined());
        Assertions.assertEquals((Long)oldVal$1, (long)((UnifiedLog)logOpt.get()).config().flushInterval);
    }

    public static final /* synthetic */ void $anonfun$testConfigChange$2(DynamicConfigChangeTest $this, Long newVal$1, TopicPartition tp$1) {
        LogManager qual$2 = ((KafkaBroker)$this.brokers().head()).logManager();
        boolean x$4 = qual$2.getLog$default$2();
        Assertions.assertEquals((Long)newVal$1, (long)((UnifiedLog)qual$2.getLog((TopicPartition)tp$1, (boolean)x$4).get()).config().flushInterval);
    }

    public static final /* synthetic */ void $anonfun$testDynamicTopicConfigChange$1(DynamicConfigChangeTest $this, TopicPartition tp$2, int oldSegmentSize$1) {
        LogManager qual$1 = ((KafkaBroker)$this.brokers().head()).logManager();
        boolean x$2 = qual$1.getLog$default$2();
        Option logOpt = qual$1.getLog(tp$2, x$2);
        Assertions.assertTrue((boolean)logOpt.isDefined());
        Assertions.assertEquals((int)oldSegmentSize$1, (int)((UnifiedLog)logOpt.get()).config().segmentSize);
    }

    public static final /* synthetic */ void $anonfun$testDynamicTopicConfigChange$2(int newSegmentSize$1, UnifiedLog log$1) {
        Assertions.assertEquals((int)newSegmentSize$1, (int)log$1.config().segmentSize);
    }

    public static final /* synthetic */ boolean $anonfun$testMessageFormatVersionChange$1(KafkaServer server$1, TopicPartition tp$3) {
        LogManager qual$1 = server$1.logManager();
        boolean x$2 = qual$1.getLog$default$2();
        return qual$1.getLog(tp$3, x$2).isDefined();
    }

    public static final /* synthetic */ String $anonfun$testMessageFormatVersionChange$2() {
        return "Topic metadata propagation failed";
    }

    public static final /* synthetic */ boolean $anonfun$testMessageFormatVersionChange$3(KafkaServer server$1, TopicPartition tp$3, CompressionType compressionType$1) {
        LogManager qual$3 = server$1.logManager();
        boolean x$6 = qual$3.getLog$default$2();
        if (((UnifiedLog)qual$3.getLog((TopicPartition)tp$3, (boolean)x$6).get()).config().compression.isPresent()) {
            LogManager qual$4 = server$1.logManager();
            boolean x$8 = qual$4.getLog$default$2();
            CompressionType compressionType = ((Compression)((UnifiedLog)qual$4.getLog((TopicPartition)tp$3, (boolean)x$8).get()).config().compression.get()).type();
            if (!(compressionType != null ? !compressionType.equals(compressionType$1) : compressionType$1 != null)) {
                return true;
            }
        }
        return false;
    }

    public static final /* synthetic */ String $anonfun$testMessageFormatVersionChange$4() {
        return "Topic config change propagation failed";
    }

    public static final /* synthetic */ void $anonfun$testQuotaConfigChange$1(QuotaFactory.QuotaManagers quotaManagers$1, KafkaPrincipal user$1, String clientId$1) {
        Quota overrideProducerQuota = quotaManagers$1.produce().quota(user$1, clientId$1);
        Quota overrideConsumerQuota = quotaManagers$1.fetch().quota(user$1, clientId$1);
        Assertions.assertEquals((Object)Quota.upperBound((double)1000.0), (Object)overrideProducerQuota, (String)new StringBuilder(59).append("User ").append(user$1).append(" clientId ").append(clientId$1).append(" must have overridden producer quota of 1000").toString());
        Assertions.assertEquals((Object)Quota.upperBound((double)2000.0), (Object)overrideConsumerQuota, (String)new StringBuilder(59).append("User ").append(user$1).append(" clientId ").append(clientId$1).append(" must have overridden consumer quota of 2000").toString());
    }

    public static final /* synthetic */ void $anonfun$testQuotaConfigChange$2(QuotaFactory.QuotaManagers quotaManagers$1, KafkaPrincipal user$1, String clientId$1, double defaultProducerQuota$1, double defaultConsumerQuota$1) {
        Quota producerQuota = quotaManagers$1.produce().quota(user$1, clientId$1);
        Quota consumerQuota = quotaManagers$1.fetch().quota(user$1, clientId$1);
        Assertions.assertEquals((Object)Quota.upperBound((double)defaultProducerQuota$1), (Object)producerQuota, (String)new StringBuilder(50).append("User ").append(user$1).append(" clientId ").append(clientId$1).append(" must have reset producer quota to ").append(defaultProducerQuota$1).toString());
        Assertions.assertEquals((Object)Quota.upperBound((double)defaultConsumerQuota$1), (Object)consumerQuota, (String)new StringBuilder(50).append("User ").append(user$1).append(" clientId ").append(clientId$1).append(" must have reset consumer quota to ").append(defaultConsumerQuota$1).toString());
    }

    public static final /* synthetic */ void $anonfun$testQuotaInitialization$1(DynamicConfigChangeTest $this, String p) {
        KafkaZkClient qual$3 = $this.zkClient();
        String x$7 = new StringBuilder(1).append(ConfigEntityChangeNotificationZNode$.MODULE$.path()).append("/").append(p).toString();
        int x$8 = qual$3.deletePath$default$2();
        boolean x$9 = qual$3.deletePath$default$3();
        qual$3.deletePath(x$7, x$8, x$9);
    }

    public static final /* synthetic */ void $anonfun$testIpQuotaInitialization$1(DynamicConfigChangeTest $this, String p) {
        KafkaZkClient qual$1 = $this.zkClient();
        String x$1 = new StringBuilder(1).append(ConfigEntityChangeNotificationZNode$.MODULE$.path()).append("/").append(p).toString();
        int x$2 = qual$1.deletePath$default$2();
        boolean x$3 = qual$1.deletePath$default$3();
        qual$1.deletePath(x$1, x$2, x$3);
    }

    public static final /* synthetic */ void $anonfun$testIpQuotaInitialization$2(KafkaBroker broker$1) {
        ConnectionQuotas connectionQuotas = broker$1.socketServer().connectionQuotas();
        Assertions.assertEquals((long)10L, (long)connectionQuotas.connectionRateForIp(InetAddress.getByName("1.2.3.4")));
        Assertions.assertEquals((long)20L, (long)connectionQuotas.connectionRateForIp(InetAddress.getByName("2.4.6.8")));
    }

    public static final /* synthetic */ void $anonfun$testIpQuotaConfigChange$1(ConnectionQuotas connectionQuotas$1, InetAddress ip$1, Integer expectedQuota$1) {
        int quota = connectionQuotas$1.connectionRateForIp(ip$1);
        Assertions.assertEquals((Integer)expectedQuota$1, (int)quota, (String)new StringBuilder(24).append("Unexpected quota for IP ").append(ip$1).toString());
    }

    /*
     * WARNING - void declaration
     */
    private final void verifyConnectionQuota$1(InetAddress ip, Integer expectedQuota) {
        ConnectionQuotas connectionQuotas = ((KafkaBroker)this.brokers().head()).socketServer().connectionQuotas();
        TestUtils$ testUtils$ = TestUtils$.MODULE$;
        long l = 10000L;
        if (testUtils$ == null) {
            throw null;
        }
        TestUtils$ retry_this = testUtils$;
        LongRef retry_wait = LongRef.create((long)1L);
        long retry_startTime = System.currentTimeMillis();
        while (true) {
            try {
                DynamicConfigChangeTest.$anonfun$testIpQuotaConfigChange$1(connectionQuotas, ip, expectedQuota);
            }
            catch (AssertionError retry_e) {
                void retry_maxWaitMs;
                if (System.currentTimeMillis() - retry_startTime > retry_maxWaitMs) {
                    throw retry_e;
                }
                if (retry_this.logger().underlying().isInfoEnabled()) {
                    retry_this.logger().underlying().info(retry_this.msgWithLogIdent(TestUtils$.$anonfun$retry$1(retry_wait)));
                }
                Thread.sleep(retry_wait.elem);
                retry_wait.elem += package$.MODULE$.min(retry_wait.elem, 1000L);
                continue;
            }
            break;
        }
    }

    public static final /* synthetic */ void $anonfun$testBrokerIdConfigChangeAndDelete$2(long value$1, KafkaBroker b$1) {
        Assertions.assertEquals((long)value$1, (long)b$1.quotaManagers().leader().upperBound());
        Assertions.assertEquals((long)value$1, (long)b$1.quotaManagers().follower().upperBound());
        Assertions.assertEquals((long)value$1, (long)b$1.quotaManagers().alterLogDirs().upperBound());
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void $anonfun$testBrokerIdConfigChangeAndDelete$1(String brokerId$1, long newValue$1, KafkaBroker b) {
        String string = Integer.toString(b.config().brokerId());
        long value = !(string != null ? !string.equals(brokerId$1) : brokerId$1 != null) ? newValue$1 : Long.MAX_VALUE;
        TestUtils$ testUtils$ = TestUtils$.MODULE$;
        long l = 10000L;
        if (testUtils$ == null) {
            throw null;
        }
        TestUtils$ retry_this = testUtils$;
        LongRef retry_wait = LongRef.create((long)1L);
        long retry_startTime = System.currentTimeMillis();
        while (true) {
            try {
                DynamicConfigChangeTest.$anonfun$testBrokerIdConfigChangeAndDelete$2(value, b);
            }
            catch (AssertionError retry_e) {
                void retry_maxWaitMs;
                if (System.currentTimeMillis() - retry_startTime > retry_maxWaitMs) {
                    throw retry_e;
                }
                if (retry_this.logger().underlying().isInfoEnabled()) {
                    retry_this.logger().underlying().info(retry_this.msgWithLogIdent(TestUtils$.$anonfun$retry$1(retry_wait)));
                }
                Thread.sleep(retry_wait.elem);
                retry_wait.elem += package$.MODULE$.min(retry_wait.elem, 1000L);
                continue;
            }
            break;
        }
    }

    public static final /* synthetic */ void $anonfun$testBrokerIdConfigChangeAndDelete$4(KafkaBroker b$2) {
        Assertions.assertEquals((long)Long.MAX_VALUE, (long)b$2.quotaManagers().leader().upperBound());
        Assertions.assertEquals((long)Long.MAX_VALUE, (long)b$2.quotaManagers().follower().upperBound());
        Assertions.assertEquals((long)Long.MAX_VALUE, (long)b$2.quotaManagers().alterLogDirs().upperBound());
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void $anonfun$testBrokerIdConfigChangeAndDelete$3(KafkaBroker b) {
        TestUtils$ testUtils$ = TestUtils$.MODULE$;
        long l = 10000L;
        if (testUtils$ == null) {
            throw null;
        }
        TestUtils$ retry_this = testUtils$;
        LongRef retry_wait = LongRef.create((long)1L);
        long retry_startTime = System.currentTimeMillis();
        while (true) {
            try {
                DynamicConfigChangeTest.$anonfun$testBrokerIdConfigChangeAndDelete$4(b);
            }
            catch (AssertionError retry_e) {
                void retry_maxWaitMs;
                if (System.currentTimeMillis() - retry_startTime > retry_maxWaitMs) {
                    throw retry_e;
                }
                if (retry_this.logger().underlying().isInfoEnabled()) {
                    retry_this.logger().underlying().info(retry_this.msgWithLogIdent(TestUtils$.$anonfun$retry$1(retry_wait)));
                }
                Thread.sleep(retry_wait.elem);
                retry_wait.elem += package$.MODULE$.min(retry_wait.elem, 1000L);
                continue;
            }
            break;
        }
    }

    public static final /* synthetic */ void $anonfun$testDefaultBrokerIdConfigChangeAndDelete$2(long newValue$2, KafkaBroker b$3) {
        Assertions.assertEquals((long)newValue$2, (long)b$3.quotaManagers().leader().upperBound());
        Assertions.assertEquals((long)newValue$2, (long)b$3.quotaManagers().follower().upperBound());
        Assertions.assertEquals((long)newValue$2, (long)b$3.quotaManagers().alterLogDirs().upperBound());
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void $anonfun$testDefaultBrokerIdConfigChangeAndDelete$1(long newValue$2, KafkaBroker b) {
        TestUtils$ testUtils$ = TestUtils$.MODULE$;
        long l = 10000L;
        if (testUtils$ == null) {
            throw null;
        }
        TestUtils$ retry_this = testUtils$;
        LongRef retry_wait = LongRef.create((long)1L);
        long retry_startTime = System.currentTimeMillis();
        while (true) {
            try {
                DynamicConfigChangeTest.$anonfun$testDefaultBrokerIdConfigChangeAndDelete$2(newValue$2, b);
            }
            catch (AssertionError retry_e) {
                void retry_maxWaitMs;
                if (System.currentTimeMillis() - retry_startTime > retry_maxWaitMs) {
                    throw retry_e;
                }
                if (retry_this.logger().underlying().isInfoEnabled()) {
                    retry_this.logger().underlying().info(retry_this.msgWithLogIdent(TestUtils$.$anonfun$retry$1(retry_wait)));
                }
                Thread.sleep(retry_wait.elem);
                retry_wait.elem += package$.MODULE$.min(retry_wait.elem, 1000L);
                continue;
            }
            break;
        }
    }

    public static final /* synthetic */ void $anonfun$testDefaultBrokerIdConfigChangeAndDelete$4(KafkaBroker b$4) {
        Assertions.assertEquals((long)Long.MAX_VALUE, (long)b$4.quotaManagers().leader().upperBound());
        Assertions.assertEquals((long)Long.MAX_VALUE, (long)b$4.quotaManagers().follower().upperBound());
        Assertions.assertEquals((long)Long.MAX_VALUE, (long)b$4.quotaManagers().alterLogDirs().upperBound());
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void $anonfun$testDefaultBrokerIdConfigChangeAndDelete$3(KafkaBroker b) {
        TestUtils$ testUtils$ = TestUtils$.MODULE$;
        long l = 10000L;
        if (testUtils$ == null) {
            throw null;
        }
        TestUtils$ retry_this = testUtils$;
        LongRef retry_wait = LongRef.create((long)1L);
        long retry_startTime = System.currentTimeMillis();
        while (true) {
            try {
                DynamicConfigChangeTest.$anonfun$testDefaultBrokerIdConfigChangeAndDelete$4(b);
            }
            catch (AssertionError retry_e) {
                void retry_maxWaitMs;
                if (System.currentTimeMillis() - retry_startTime > retry_maxWaitMs) {
                    throw retry_e;
                }
                if (retry_this.logger().underlying().isInfoEnabled()) {
                    retry_this.logger().underlying().info(retry_this.msgWithLogIdent(TestUtils$.$anonfun$retry$1(retry_wait)));
                }
                Thread.sleep(retry_wait.elem);
                retry_wait.elem += package$.MODULE$.min(retry_wait.elem, 1000L);
                continue;
            }
            break;
        }
    }

    public static final /* synthetic */ void $anonfun$testDefaultAndBrokerIdConfigChange$2(long value$2, KafkaBroker b$5) {
        Assertions.assertEquals((long)value$2, (long)b$5.quotaManagers().leader().upperBound());
        Assertions.assertEquals((long)value$2, (long)b$5.quotaManagers().follower().upperBound());
        Assertions.assertEquals((long)value$2, (long)b$5.quotaManagers().alterLogDirs().upperBound());
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void $anonfun$testDefaultAndBrokerIdConfigChange$1(String brokerId$2, long newValue$3, long newDefaultValue$1, KafkaBroker b) {
        String string = Integer.toString(b.config().brokerId());
        long value = !(string != null ? !string.equals(brokerId$2) : brokerId$2 != null) ? newValue$3 : newDefaultValue$1;
        TestUtils$ testUtils$ = TestUtils$.MODULE$;
        long l = 10000L;
        if (testUtils$ == null) {
            throw null;
        }
        TestUtils$ retry_this = testUtils$;
        LongRef retry_wait = LongRef.create((long)1L);
        long retry_startTime = System.currentTimeMillis();
        while (true) {
            try {
                DynamicConfigChangeTest.$anonfun$testDefaultAndBrokerIdConfigChange$2(value, b);
            }
            catch (AssertionError retry_e) {
                void retry_maxWaitMs;
                if (System.currentTimeMillis() - retry_startTime > retry_maxWaitMs) {
                    throw retry_e;
                }
                if (retry_this.logger().underlying().isInfoEnabled()) {
                    retry_this.logger().underlying().info(retry_this.msgWithLogIdent(TestUtils$.$anonfun$retry$1(retry_wait)));
                }
                Thread.sleep(retry_wait.elem);
                retry_wait.elem += package$.MODULE$.min(retry_wait.elem, 1000L);
                continue;
            }
            break;
        }
    }
}

