/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.File;
import java.io.Serializable;
import java.util.concurrent.atomic.AtomicBoolean;
import kafka.cluster.Partition;
import kafka.log.LogManager;
import kafka.log.UnifiedLog;
import kafka.server.AlterPartitionManager;
import kafka.server.BrokerTopicStats;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.MetadataCache;
import kafka.server.MetadataCache$;
import kafka.server.QuotaFactory;
import kafka.server.QuotaFactory$;
import kafka.server.ReplicaManager;
import kafka.server.ReplicaManager$;
import kafka.server.RequestLocal;
import kafka.server.checkpoints.OffsetCheckpointFile;
import kafka.server.metadata.ConfigRepository;
import kafka.server.metadata.MockConfigRepository;
import kafka.server.metadata.ZkMetadataCache;
import kafka.utils.TestUtils;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.SimpleRecord;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.metadata.LeaderRecoveryState;
import org.apache.kafka.server.common.DirectoryEventHandler;
import org.apache.kafka.server.common.MetadataVersion;
import org.apache.kafka.server.util.KafkaScheduler;
import org.apache.kafka.server.util.MockTime;
import org.apache.kafka.server.util.Scheduler;
import org.apache.kafka.storage.internals.log.AppendOrigin;
import org.apache.kafka.storage.internals.log.CleanerConfig;
import org.apache.kafka.storage.internals.log.LogConfig;
import org.apache.kafka.storage.internals.log.LogDirFailureChannel;
import org.apache.kafka.storage.internals.log.VerificationGuard;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\u0005Mc\u0001B\n\u0015\u0001eAQ\u0001\t\u0001\u0005\u0002\u0005Bq\u0001\n\u0001C\u0002\u0013\u0005Q\u0005\u0003\u00040\u0001\u0001\u0006IA\n\u0005\ba\u0001\u0011\r\u0011\"\u00012\u0011\u0019Q\u0004\u0001)A\u0005e!91\b\u0001b\u0001\n\u0003a\u0004BB\"\u0001A\u0003%Q\bC\u0004E\u0001\t\u0007I\u0011A#\t\r5\u0003\u0001\u0015!\u0003G\u0011\u001dq\u0005A1A\u0005\u0002=Caa\u0018\u0001!\u0002\u0013\u0001\u0006b\u00021\u0001\u0005\u0004%\t!\u0019\u0005\u0007Y\u0002\u0001\u000b\u0011\u00022\t\u000b5\u0004A\u0011\u00018\t\u000bu\u0004A\u0011\u00018\t\r\u0005\u0015\u0001\u0001\"\u0001o\u0011\u001d\tI\u0001\u0001C\u0005\u0003\u0017Aq!a\n\u0001\t\u0013\tIC\u0001\u000fIS\u001eDw/\u0019;fe6\f'o\u001b)feNL7\u000f^3oG\u0016$Vm\u001d;\u000b\u0005U1\u0012AB:feZ,'OC\u0001\u0018\u0003\u0015Y\u0017MZ6b\u0007\u0001\u0019\"\u0001\u0001\u000e\u0011\u0005mqR\"\u0001\u000f\u000b\u0003u\tQa]2bY\u0006L!a\b\u000f\u0003\r\u0005s\u0017PU3g\u0003\u0019a\u0014N\\5u}Q\t!\u0005\u0005\u0002$\u00015\tA#A\u0004d_:4\u0017nZ:\u0016\u0003\u0019\u00022a\n\u0016-\u001b\u0005A#BA\u0015\u001d\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0003W!\u00121aU3r!\t\u0019S&\u0003\u0002/)\tY1*\u00194lC\u000e{gNZ5h\u0003!\u0019wN\u001c4jON\u0004\u0013!\u0002;pa&\u001cW#\u0001\u001a\u0011\u0005MBT\"\u0001\u001b\u000b\u0005U2\u0014\u0001\u00027b]\u001eT\u0011aN\u0001\u0005U\u00064\u0018-\u0003\u0002:i\t11\u000b\u001e:j]\u001e\fa\u0001^8qS\u000e\u0004\u0013\u0001E2p]\u001aLwMU3q_NLGo\u001c:z+\u0005i\u0004C\u0001 B\u001b\u0005y$B\u0001!\u0015\u0003!iW\r^1eCR\f\u0017B\u0001\"@\u0005QiunY6D_:4\u0017n\u001a*fa>\u001c\u0018\u000e^8ss\u0006\t2m\u001c8gS\u001e\u0014V\r]8tSR|'/\u001f\u0011\u0002\u00171|w-T1oC\u001e,'o]\u000b\u0002\rB\u0019qEK$\u0011\u0005![U\"A%\u000b\u0005)3\u0012a\u00017pO&\u0011A*\u0013\u0002\u000b\u0019><W*\u00198bO\u0016\u0014\u0018\u0001\u00047pO6\u000bg.Y4feN\u0004\u0013!\u00067pO\u0012K'OR1jYV\u0014Xm\u00115b]:,Gn]\u000b\u0002!B\u0019qEK)\u0011\u0005IkV\"A*\u000b\u0005)#&BA+W\u0003%Ig\u000e^3s]\u0006d7O\u0003\u0002X1\u000691\u000f^8sC\u001e,'BA\fZ\u0015\tQ6,\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u00029\u0006\u0019qN]4\n\u0005y\u001b&\u0001\u0006'pO\u0012K'OR1jYV\u0014Xm\u00115b]:,G.\u0001\fm_\u001e$\u0015N\u001d$bS2,(/Z\"iC:tW\r\\:!\u0003=\tG\u000e^3s\u0013N\u0014X*\u00198bO\u0016\u0014X#\u00012\u0011\u0005\rLgB\u00013h\u001b\u0005)'B\u00014\u0017\u0003\u0015)H/\u001b7t\u0013\tAW-A\u0005UKN$X\u000b^5mg&\u0011!n\u001b\u0002\u001a\u001b>\u001c7.\u00117uKJ\u0004\u0016M\u001d;ji&|g.T1oC\u001e,'O\u0003\u0002iK\u0006\u0001\u0012\r\u001c;fe&\u001b(/T1oC\u001e,'\u000fI\u0001\ti\u0016\f'\u000fZ8x]R\tq\u000e\u0005\u0002\u001ca&\u0011\u0011\u000f\b\u0002\u0005+:LG\u000f\u000b\u0002\u000fgB\u0011Ao_\u0007\u0002k*\u0011ao^\u0001\u0004CBL'B\u0001=z\u0003\u001dQW\u000f]5uKJT!A_.\u0002\u000b),h.\u001b;\n\u0005q,(!C!gi\u0016\u0014X)Y2i\u0003-\"Xm\u001d;IS\u001eDw+\u0019;fe6\f'o\u001b)feNL7\u000f^3oG\u0016\u001c\u0016N\\4mKB\u000b'\u000f^5uS>t\u0007FA\b\u0000!\r!\u0018\u0011A\u0005\u0004\u0003\u0007)(\u0001\u0002+fgR\fa\u0006^3ti\"Kw\r[,bi\u0016\u0014X.\u0019:l!\u0016\u00148/[:uK:\u001cW-T;mi&\u0004H.\u001a)beRLG/[8og\"\u0012\u0001c`\u0001\u0007CB\u0004XM\u001c3\u0015\u000b=\fi!!\b\t\u000f\u0005=\u0011\u00031\u0001\u0002\u0012\u0005I\u0001/\u0019:uSRLwN\u001c\t\u0005\u0003'\tI\"\u0004\u0002\u0002\u0016)\u0019\u0011q\u0003\f\u0002\u000f\rdWo\u001d;fe&!\u00111DA\u000b\u0005%\u0001\u0016M\u001d;ji&|g\u000eC\u0004\u0002 E\u0001\r!!\t\u0002\u000b\r|WO\u001c;\u0011\u0007m\t\u0019#C\u0002\u0002&q\u00111!\u00138u\u0003\u0019Aw/\u001c$peRA\u00111FA\u0019\u0003w\t\t\u0006E\u0002\u001c\u0003[I1!a\f\u001d\u0005\u0011auN\\4\t\u000f\u0005M\"\u00031\u0001\u00026\u0005q!/\u001a9mS\u000e\fW*\u00198bO\u0016\u0014\bcA\u0012\u00028%\u0019\u0011\u0011\b\u000b\u0003\u001dI+\u0007\u000f\\5dC6\u000bg.Y4fe\"1\u0001G\u0005a\u0001\u0003{\u0001B!a\u0010\u0002N9!\u0011\u0011IA%!\r\t\u0019\u0005H\u0007\u0003\u0003\u000bR1!a\u0012\u0019\u0003\u0019a$o\\8u}%\u0019\u00111\n\u000f\u0002\rA\u0013X\rZ3g\u0013\rI\u0014q\n\u0006\u0004\u0003\u0017b\u0002bBA\b%\u0001\u0007\u0011\u0011\u0005")
public class HighwatermarkPersistenceTest {
    private final Seq<KafkaConfig> configs = (Seq)TestUtils$.MODULE$.createBrokerConfigs(2, TestUtils$.MODULE$.MockZkConnect(), TestUtils$.MODULE$.createBrokerConfigs$default$3(), TestUtils$.MODULE$.createBrokerConfigs$default$4(), TestUtils$.MODULE$.createBrokerConfigs$default$5(), TestUtils$.MODULE$.createBrokerConfigs$default$6(), TestUtils$.MODULE$.createBrokerConfigs$default$7(), TestUtils$.MODULE$.createBrokerConfigs$default$8(), TestUtils$.MODULE$.createBrokerConfigs$default$9(), TestUtils$.MODULE$.createBrokerConfigs$default$10(), TestUtils$.MODULE$.createBrokerConfigs$default$11(), TestUtils$.MODULE$.createBrokerConfigs$default$12(), TestUtils$.MODULE$.createBrokerConfigs$default$13(), TestUtils$.MODULE$.createBrokerConfigs$default$14(), TestUtils$.MODULE$.createBrokerConfigs$default$15(), TestUtils$.MODULE$.createBrokerConfigs$default$16(), TestUtils$.MODULE$.createBrokerConfigs$default$17(), TestUtils$.MODULE$.createBrokerConfigs$default$18()).map((Function1 & Serializable & scala.Serializable)props -> KafkaConfig$.MODULE$.fromProps(props), Seq$.MODULE$.canBuildFrom());
    private final String topic;
    private final MockConfigRepository configRepository = new MockConfigRepository();
    private final Seq<LogManager> logManagers = (Seq)this.configs().map((Function1 & Serializable & scala.Serializable)config -> {
        Seq x$12 = (Seq)config.logDirs().map((Function1 & Serializable & scala.Serializable)x$1 -> new File((String)x$1), Seq$.MODULE$.canBuildFrom());
        CleanerConfig x$2 = new CleanerConfig(true);
        LogConfig x$3 = TestUtils$.MODULE$.createLogManager$default$2();
        ConfigRepository x$4 = TestUtils$.MODULE$.createLogManager$default$3();
        MockTime x$5 = TestUtils$.MODULE$.createLogManager$default$5();
        MetadataVersion x$6 = TestUtils$.MODULE$.createLogManager$default$6();
        int x$7 = TestUtils$.MODULE$.createLogManager$default$7();
        boolean x$8 = TestUtils$.MODULE$.createLogManager$default$8();
        Option<UnifiedLog> x$9 = TestUtils$.MODULE$.createLogManager$default$9();
        boolean x$10 = TestUtils$.MODULE$.createLogManager$default$10();
        long x$11 = TestUtils$.MODULE$.createLogManager$default$11();
        return TestUtils$.MODULE$.createLogManager((Seq<File>)x$12, x$3, x$4, x$2, x$5, x$6, x$7, x$8, x$9, x$10, x$11);
    }, Seq$.MODULE$.canBuildFrom());
    private final Seq<LogDirFailureChannel> logDirFailureChannels = (Seq)this.configs().map((Function1 & Serializable & scala.Serializable)config -> new LogDirFailureChannel(config.logDirs().size()), Seq$.MODULE$.canBuildFrom());
    private final TestUtils.MockAlterPartitionManager alterIsrManager = TestUtils$.MODULE$.createAlterIsrManager();

    public Seq<KafkaConfig> configs() {
        return this.configs;
    }

    public String topic() {
        return this.topic;
    }

    public MockConfigRepository configRepository() {
        return this.configRepository;
    }

    public Seq<LogManager> logManagers() {
        return this.logManagers;
    }

    public Seq<LogDirFailureChannel> logDirFailureChannels() {
        return this.logDirFailureChannels;
    }

    public TestUtils.MockAlterPartitionManager alterIsrManager() {
        return this.alterIsrManager;
    }

    @AfterEach
    public void teardown() {
        this.logManagers().foreach((Function1 & Serializable & scala.Serializable)manager -> {
            HighwatermarkPersistenceTest.$anonfun$teardown$1(manager);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testHighWatermarkPersistenceSinglePartition() {
        KafkaScheduler scheduler = new KafkaScheduler(2);
        scheduler.startup();
        Metrics metrics = new Metrics();
        MockTime time = new MockTime();
        QuotaFactory.QuotaManagers quotaManager = QuotaFactory$.MODULE$.instantiate((KafkaConfig)this.configs().head(), metrics, (Time)time, "");
        KafkaConfig x$2 = (KafkaConfig)this.configs().head();
        LogManager x$5 = (LogManager)this.logManagers().head();
        ZkMetadataCache x$7 = MetadataCache$.MODULE$.zkMetadataCache(((KafkaConfig)this.configs().head()).brokerId(), ((KafkaConfig)this.configs().head()).interBrokerProtocolVersion(), MetadataCache$.MODULE$.zkMetadataCache$default$3(), MetadataCache$.MODULE$.zkMetadataCache$default$4());
        LogDirFailureChannel x$8 = (LogDirFailureChannel)this.logDirFailureChannels().head();
        TestUtils.MockAlterPartitionManager x$9 = this.alterIsrManager();
        Option x$10 = ReplicaManager$.MODULE$.$lessinit$greater$default$6();
        BrokerTopicStats x$11 = ReplicaManager$.MODULE$.$lessinit$greater$default$11();
        AtomicBoolean x$12 = ReplicaManager$.MODULE$.$lessinit$greater$default$12();
        Option x$13 = ReplicaManager$.MODULE$.$lessinit$greater$default$13();
        Option x$14 = ReplicaManager$.MODULE$.$lessinit$greater$default$14();
        Option x$15 = ReplicaManager$.MODULE$.$lessinit$greater$default$15();
        Option x$16 = ReplicaManager$.MODULE$.$lessinit$greater$default$16();
        Option x$17 = ReplicaManager$.MODULE$.$lessinit$greater$default$17();
        Option x$18 = ReplicaManager$.MODULE$.$lessinit$greater$default$18();
        Option x$19 = ReplicaManager$.MODULE$.$lessinit$greater$default$19();
        Function0 x$20 = ReplicaManager$.MODULE$.$lessinit$greater$default$20();
        Option x$21 = ReplicaManager$.MODULE$.$lessinit$greater$default$21();
        DirectoryEventHandler x$22 = ReplicaManager$.MODULE$.$lessinit$greater$default$22();
        ReplicaManager replicaManager = new ReplicaManager(x$2, metrics, (Time)time, (Scheduler)scheduler, x$5, x$10, quotaManager, (MetadataCache)x$7, x$8, (AlterPartitionManager)x$9, x$11, x$12, x$13, x$14, x$15, x$16, x$17, x$18, x$19, x$20, x$21, x$22);
        replicaManager.startup();
        try {
            replicaManager.checkpointHighWatermarks();
            long fooPartition0Hw = this.hwmFor(replicaManager, this.topic(), 0);
            Assertions.assertEquals((long)0L, (long)fooPartition0Hw);
            TopicPartition tp0 = new TopicPartition(this.topic(), 0);
            Partition partition0 = replicaManager.createPartition(tp0);
            LogManager qual$1 = (LogManager)this.logManagers().head();
            TopicPartition x$23 = new TopicPartition(this.topic(), 0);
            None$ x$24 = None$.MODULE$;
            boolean x$25 = qual$1.getOrCreateLog$default$2();
            boolean x$26 = qual$1.getOrCreateLog$default$3();
            Option x$27 = qual$1.getOrCreateLog$default$5();
            UnifiedLog log0 = qual$1.getOrCreateLog(x$23, x$25, x$26, (Option)x$24, x$27);
            partition0.setLog(log0, false);
            partition0.updateAssignmentAndIsr((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{((KafkaConfig)this.configs().head()).brokerId(), ((KafkaConfig)this.configs().last()).brokerId()})), true, (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{((KafkaConfig)this.configs().head()).brokerId()})), (Seq)Nil$.MODULE$, (Seq)Nil$.MODULE$, LeaderRecoveryState.RECOVERED);
            replicaManager.checkpointHighWatermarks();
            fooPartition0Hw = this.hwmFor(replicaManager, this.topic(), 0);
            Assertions.assertEquals((long)log0.highWatermark(), (long)fooPartition0Hw);
            partition0.localLogOrException().updateHighWatermark(5L);
            replicaManager.checkpointHighWatermarks();
            fooPartition0Hw = this.hwmFor(replicaManager, this.topic(), 0);
            Assertions.assertEquals((long)log0.highWatermark(), (long)fooPartition0Hw);
        }
        finally {
            replicaManager.shutdown(false);
            quotaManager.shutdown();
            metrics.close();
            scheduler.shutdown();
        }
    }

    @Test
    public void testHighWatermarkPersistenceMultiplePartitions() {
        String topic1 = "foo1";
        String topic2 = "foo2";
        KafkaScheduler scheduler = new KafkaScheduler(2);
        scheduler.startup();
        Metrics metrics = new Metrics();
        MockTime time = new MockTime();
        QuotaFactory.QuotaManagers quotaManager = QuotaFactory$.MODULE$.instantiate((KafkaConfig)this.configs().head(), metrics, (Time)time, "");
        KafkaConfig x$2 = (KafkaConfig)this.configs().head();
        LogManager x$5 = (LogManager)this.logManagers().head();
        ZkMetadataCache x$7 = MetadataCache$.MODULE$.zkMetadataCache(((KafkaConfig)this.configs().head()).brokerId(), ((KafkaConfig)this.configs().head()).interBrokerProtocolVersion(), MetadataCache$.MODULE$.zkMetadataCache$default$3(), MetadataCache$.MODULE$.zkMetadataCache$default$4());
        LogDirFailureChannel x$8 = (LogDirFailureChannel)this.logDirFailureChannels().head();
        TestUtils.MockAlterPartitionManager x$9 = this.alterIsrManager();
        Option x$10 = ReplicaManager$.MODULE$.$lessinit$greater$default$6();
        BrokerTopicStats x$11 = ReplicaManager$.MODULE$.$lessinit$greater$default$11();
        AtomicBoolean x$12 = ReplicaManager$.MODULE$.$lessinit$greater$default$12();
        Option x$13 = ReplicaManager$.MODULE$.$lessinit$greater$default$13();
        Option x$14 = ReplicaManager$.MODULE$.$lessinit$greater$default$14();
        Option x$15 = ReplicaManager$.MODULE$.$lessinit$greater$default$15();
        Option x$16 = ReplicaManager$.MODULE$.$lessinit$greater$default$16();
        Option x$17 = ReplicaManager$.MODULE$.$lessinit$greater$default$17();
        Option x$18 = ReplicaManager$.MODULE$.$lessinit$greater$default$18();
        Option x$19 = ReplicaManager$.MODULE$.$lessinit$greater$default$19();
        Function0 x$20 = ReplicaManager$.MODULE$.$lessinit$greater$default$20();
        Option x$21 = ReplicaManager$.MODULE$.$lessinit$greater$default$21();
        DirectoryEventHandler x$22 = ReplicaManager$.MODULE$.$lessinit$greater$default$22();
        ReplicaManager replicaManager = new ReplicaManager(x$2, metrics, (Time)time, (Scheduler)scheduler, x$5, x$10, quotaManager, (MetadataCache)x$7, x$8, (AlterPartitionManager)x$9, x$11, x$12, x$13, x$14, x$15, x$16, x$17, x$18, x$19, x$20, x$21, x$22);
        replicaManager.startup();
        try {
            replicaManager.checkpointHighWatermarks();
            long topic1Partition0Hw = this.hwmFor(replicaManager, topic1, 0);
            Assertions.assertEquals((long)0L, (long)topic1Partition0Hw);
            TopicPartition t1p0 = new TopicPartition(topic1, 0);
            Partition topic1Partition0 = replicaManager.createPartition(t1p0);
            LogManager qual$1 = (LogManager)this.logManagers().head();
            None$ x$24 = None$.MODULE$;
            boolean x$25 = qual$1.getOrCreateLog$default$2();
            boolean x$26 = qual$1.getOrCreateLog$default$3();
            Option x$27 = qual$1.getOrCreateLog$default$5();
            UnifiedLog topic1Log0 = qual$1.getOrCreateLog(t1p0, x$25, x$26, (Option)x$24, x$27);
            topic1Partition0.setLog(topic1Log0, false);
            replicaManager.checkpointHighWatermarks();
            topic1Partition0Hw = this.hwmFor(replicaManager, topic1, 0);
            Assertions.assertEquals((long)topic1Log0.highWatermark(), (long)topic1Partition0Hw);
            this.append(topic1Partition0, 5);
            topic1Partition0.localLogOrException().updateHighWatermark(5L);
            replicaManager.checkpointHighWatermarks();
            topic1Partition0Hw = this.hwmFor(replicaManager, topic1, 0);
            Assertions.assertEquals((long)5L, (long)topic1Log0.highWatermark());
            Assertions.assertEquals((long)5L, (long)topic1Partition0Hw);
            TopicPartition t2p0 = new TopicPartition(topic2, 0);
            Partition topic2Partition0 = replicaManager.createPartition(t2p0);
            LogManager qual$2 = (LogManager)this.logManagers().head();
            None$ x$29 = None$.MODULE$;
            boolean x$30 = qual$2.getOrCreateLog$default$2();
            boolean x$31 = qual$2.getOrCreateLog$default$3();
            Option x$32 = qual$2.getOrCreateLog$default$5();
            UnifiedLog topic2Log0 = qual$2.getOrCreateLog(t2p0, x$30, x$31, (Option)x$29, x$32);
            topic2Partition0.setLog(topic2Log0, false);
            replicaManager.checkpointHighWatermarks();
            long topic2Partition0Hw = this.hwmFor(replicaManager, topic2, 0);
            Assertions.assertEquals((long)topic2Log0.highWatermark(), (long)topic2Partition0Hw);
            this.append(topic2Partition0, 15);
            topic2Partition0.localLogOrException().updateHighWatermark(15L);
            Assertions.assertEquals((long)15L, (long)topic2Log0.highWatermark());
            this.append(topic1Partition0, 5);
            topic1Partition0.localLogOrException().updateHighWatermark(10L);
            Assertions.assertEquals((long)10L, (long)topic1Log0.highWatermark());
            replicaManager.checkpointHighWatermarks();
            topic2Partition0Hw = this.hwmFor(replicaManager, topic2, 0);
            Assertions.assertEquals((long)15L, (long)topic2Partition0Hw);
            topic1Partition0Hw = this.hwmFor(replicaManager, topic1, 0);
            Assertions.assertEquals((long)10L, (long)topic1Partition0Hw);
        }
        finally {
            replicaManager.shutdown(false);
            quotaManager.shutdown();
            metrics.close();
            scheduler.shutdown();
        }
    }

    private void append(Partition partition, int count) {
        MemoryRecords records = TestUtils$.MODULE$.records((Iterable<SimpleRecord>)((Iterable)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), count).map((Function1 & Serializable & scala.Serializable)i -> HighwatermarkPersistenceTest.$anonfun$append$1(BoxesRunTime.unboxToInt((Object)i)), IndexedSeq$.MODULE$.canBuildFrom())), TestUtils$.MODULE$.records$default$2(), TestUtils$.MODULE$.records$default$3(), TestUtils$.MODULE$.records$default$4(), TestUtils$.MODULE$.records$default$5(), TestUtils$.MODULE$.records$default$6(), TestUtils$.MODULE$.records$default$7(), TestUtils$.MODULE$.records$default$8());
        UnifiedLog qual$1 = partition.localLogOrException();
        int x$2 = 0;
        AppendOrigin x$3 = qual$1.appendAsLeader$default$3();
        MetadataVersion x$4 = qual$1.appendAsLeader$default$4();
        RequestLocal x$5 = qual$1.appendAsLeader$default$5();
        VerificationGuard x$6 = qual$1.appendAsLeader$default$6();
        qual$1.appendAsLeader(records, x$2, x$3, x$4, x$5, x$6);
    }

    private long hwmFor(ReplicaManager replicaManager, String topic, int partition) {
        return BoxesRunTime.unboxToLong((Object)((OffsetCheckpointFile)replicaManager.highWatermarkCheckpoints().apply((Object)new File((String)replicaManager.config().logDirs().head()).getAbsolutePath())).read().getOrElse((Object)new TopicPartition(topic, partition), (Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> 0L));
    }

    public static final /* synthetic */ void $anonfun$teardown$2(File dir) {
        Utils.delete((File)dir);
    }

    public static final /* synthetic */ void $anonfun$teardown$1(LogManager manager) {
        manager.liveLogDirs().foreach((Function1 & Serializable & scala.Serializable)dir -> {
            HighwatermarkPersistenceTest.$anonfun$teardown$2(dir);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ SimpleRecord $anonfun$append$1(int i) {
        return new SimpleRecord(String.valueOf(BoxesRunTime.boxToInteger((int)i)).getBytes());
    }

    public HighwatermarkPersistenceTest() {
        this.topic = "foo";
    }
}

