/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.Serializable;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.util.Properties;
import kafka.server.DefaultAlterPartitionManager;
import kafka.server.KafkaBroker;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.server.KafkaServer$;
import kafka.server.QuorumTestHarness;
import kafka.server.ZkAlterPartitionManager;
import kafka.utils.CoreUtils$;
import kafka.utils.Logging;
import kafka.utils.TestUtils$;
import org.apache.kafka.server.common.MetadataVersion;
import org.apache.kafka.server.config.ZkConfigs;
import org.apache.zookeeper.client.ZKClientConfig;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.collection.MapLike;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.ObjectRef;
import scala.runtime.RichLong$;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001}3AAD\b\u0001)!)\u0011\u0004\u0001C\u00015!)A\u0004\u0001C\u0001;!)\u0011\u0007\u0001C\u0001;!)1\u0007\u0001C\u0001;!)Q\u0007\u0001C\u0001;!)q\u0007\u0001C\u0001;!)\u0011\b\u0001C\u0001;!)1\b\u0001C\u0001;!)Q\b\u0001C\u0001;!)q\b\u0001C\u0001;!)\u0011\t\u0001C\u0001;!)1\t\u0001C\u0001\t\")A\f\u0001C\u0001;\ny1*\u00194lCN+'O^3s)\u0016\u001cHO\u0003\u0002\u0011#\u000511/\u001a:wKJT\u0011AE\u0001\u0006W\u000647.Y\u0002\u0001'\t\u0001Q\u0003\u0005\u0002\u0017/5\tq\"\u0003\u0002\u0019\u001f\t\t\u0012+^8sk6$Vm\u001d;ICJtWm]:\u0002\rqJg.\u001b;?)\u0005Y\u0002C\u0001\f\u0001\u0003!\"Xm\u001d;BYJ,\u0017\rZ=SK\u001eL7\u000f^3sK\u0012\fEM^3si&\u001cX\r\u001a'jgR,g.\u001a:t)\u0005q\u0002CA\u0010#\u001b\u0005\u0001#\"A\u0011\u0002\u000bM\u001c\u0017\r\\1\n\u0005\r\u0002#\u0001B+oSRD#AA\u0013\u0011\u0005\u0019zS\"A\u0014\u000b\u0005!J\u0013aA1qS*\u0011!fK\u0001\bUV\u0004\u0018\u000e^3s\u0015\taS&A\u0003kk:LGOC\u0001/\u0003\ry'oZ\u0005\u0003a\u001d\u0012A\u0001V3ti\u0006aB/Z:u\u0019&\u001cH/\u001a8feB{'\u000f^!me\u0016\fG-_%o+N,\u0007FA\u0002&\u0003%\"Xm\u001d;De\u0016\fG/Z:Qe>\u0004XM\u001d.l\u0007>tg-[4XQ\u0016t7+Y:m\t&\u001c\u0018M\u00197fI\"\u0012A!J\u0001)i\u0016\u001cHo\u0011:fCR,7\u000f\u0015:pa\u0016\u0014(l\u001b+mg\u000e{gNZ5h/\",g\u000eR5tC\ndW\r\u001a\u0015\u0003\u000b\u0015\n!\u0006^3ti\u000e\u0013X-\u0019;fgB\u0013x\u000e]3s5.$Fn]\"p]\u001aLwmV5uQR\u0013X/\u001a,bYV,7\u000f\u000b\u0002\u0007K\u0005\u0011D/Z:u\u0007J,\u0017\r^3t!J|\u0007/\u001a:[WRc7oQ8oM&<w+\u001b;i\r\u0006d7/Z!oI2K7\u000f\u001e,bYV,7\u000f\u000b\u0002\bK\u0005\u0001B/Z:u5.L5O]'b]\u0006<WM\u001d\u0015\u0003\u0011\u0015\n1\u0003^3ti\u0006cG/\u001a:JgJl\u0015M\\1hKJD#!C\u0013\u0002CQ,7\u000f\u001e*f[>$X\rT8h\u001b\u0006t\u0017mZ3s\u0013:\u001cH/\u00198uS\u0006$\u0018n\u001c8)\u0005))\u0013a\t;fgR<UM\\3sCR,GM\u0011:pW\u0016\u0014\u0018\nZ*z]\u000e<\u0016\u000e\u001e5O_\u0012,\u0017\n\u001a\u0015\u0003\u0017\u0015\nAb\u0019:fCR,7+\u001a:wKJ$B!\u0012%N5B\u0011aCR\u0005\u0003\u000f>\u00111bS1gW\u0006\u001cVM\u001d<fe\")\u0011\n\u0004a\u0001\u0015\u00061an\u001c3f\u0013\u0012\u0004\"aH&\n\u00051\u0003#aA%oi\")a\n\u0004a\u0001\u001f\u0006A\u0001n\\:u\u001d\u0006lW\r\u0005\u0002Q/:\u0011\u0011+\u0016\t\u0003%\u0002j\u0011a\u0015\u0006\u0003)N\ta\u0001\u0010:p_Rt\u0014B\u0001,!\u0003\u0019\u0001&/\u001a3fM&\u0011\u0001,\u0017\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005Y\u0003\u0003\"B.\r\u0001\u0004Q\u0015\u0001\u00029peR\fad\u0019:fCR,7+\u001a:wKJ<\u0016\u000e\u001e5MSN$XM\\3s\u001f:\u0004vN\u001d;\u0015\u0005\u0015s\u0006\"B.\u000e\u0001\u0004Q\u0005")
public class KafkaServerTest
extends QuorumTestHarness {
    @Test
    public void testAlreadyRegisteredAdvertisedListeners() {
        KafkaServer server1 = this.createServer(1, "myhost", TestUtils$.MODULE$.RandomPort());
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.createServer(2, "myhost", TestUtils$.MODULE$.boundPort((KafkaBroker)server1, TestUtils$.MODULE$.boundPort$default$2())));
        KafkaServer server2 = this.createServer(2, "myhost", TestUtils$.MODULE$.RandomPort());
        TestUtils$.MODULE$.shutdownServers(new .colon.colon((Object)server1, (List)new .colon.colon((Object)server2, (List)Nil$.MODULE$)), TestUtils$.MODULE$.shutdownServers$default$2());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testListenerPortAlreadyInUse() {
        ServerSocket serverSocket = new ServerSocket(0, 0, InetAddress.getLoopbackAddress());
        ObjectRef kafkaServer = ObjectRef.create((Object)None$.MODULE$);
        try {
            long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
            long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
            if (TestUtils$.MODULE$ == null) {
                throw null;
            }
            long waitUntilTrue_startTime = System.currentTimeMillis();
            while (!serverSocket.isBound()) {
                void waitUntilTrue_pause;
                void waitUntilTrue_waitTimeMs;
                if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                    Assertions.fail((String)KafkaServerTest.$anonfun$testListenerPortAlreadyInUse$2());
                }
                Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
            }
            Assertions.assertThrows(RuntimeException.class, () -> {
                kafkaServer$1.elem = Option$.MODULE$.apply((Object)this.createServerWithListenerOnPort(serverSocket.getLocalPort()));
            }, (String)"Expected RuntimeException due to address already in use during KafkaServer startup");
        }
        finally {
            CoreUtils$.MODULE$.swallow((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> serverSocket.close(), (Logging)this, CoreUtils$.MODULE$.swallow$default$3());
            TestUtils$.MODULE$.shutdownServers(((Option)kafkaServer.elem).toList(), TestUtils$.MODULE$.shutdownServers$default$2());
        }
    }

    @Test
    public void testCreatesProperZkConfigWhenSaslDisabled() {
        Properties props = new Properties();
        props.put("zookeeper.connect", this.zkConnect());
        ZKClientConfig zkClientConfig = KafkaServer$.MODULE$.zkClientConfigFromKafkaConfig(KafkaConfig$.MODULE$.fromProps(props), KafkaServer$.MODULE$.zkClientConfigFromKafkaConfig$default$2());
        Assertions.assertEquals((Object)"false", (Object)zkClientConfig.getProperty("zookeeper.sasl.client"));
    }

    @Test
    public void testCreatesProperZkTlsConfigWhenDisabled() {
        Properties props = new Properties();
        props.put("zookeeper.connect", this.zkConnect());
        props.put("zookeeper.ssl.client.enable", "false");
        ZKClientConfig zkClientConfig = KafkaServer$.MODULE$.zkClientConfigFromKafkaConfig(KafkaConfig$.MODULE$.fromProps(props), KafkaServer$.MODULE$.zkClientConfigFromKafkaConfig$default$2());
        ((MapLike)CollectionConverters$.MODULE$.mapAsScalaMapConverter(ZkConfigs.ZK_SSL_CONFIG_TO_SYSTEM_PROPERTY_MAP).asScala()).keys().foreach((Function1 & Serializable & scala.Serializable)propName -> {
            KafkaServerTest.$anonfun$testCreatesProperZkTlsConfigWhenDisabled$1(zkClientConfig, propName);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testCreatesProperZkTlsConfigWithTrueValues() {
        Properties props = new Properties();
        props.put("zookeeper.connect", this.zkConnect());
        String someValue = "some_value";
        ((MapLike)CollectionConverters$.MODULE$.mapAsScalaMapConverter(ZkConfigs.ZK_SSL_CONFIG_TO_SYSTEM_PROPERTY_MAP).asScala()).keys().foreach((Function1 & Serializable & scala.Serializable)kafkaProp -> props.put(kafkaProp, KafkaServerTest.kafkaConfigValueToSet$1(kafkaProp, someValue)));
        ZKClientConfig zkClientConfig = KafkaServer$.MODULE$.zkClientConfigFromKafkaConfig(KafkaConfig$.MODULE$.fromProps(props), KafkaServer$.MODULE$.zkClientConfigFromKafkaConfig$default$2());
        ((MapLike)CollectionConverters$.MODULE$.mapAsScalaMapConverter(ZkConfigs.ZK_SSL_CONFIG_TO_SYSTEM_PROPERTY_MAP).asScala()).keys().foreach((Function1 & Serializable & scala.Serializable)kafkaProp -> {
            KafkaServerTest.$anonfun$testCreatesProperZkTlsConfigWithTrueValues$2(zkClientConfig, someValue, kafkaProp);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testCreatesProperZkTlsConfigWithFalseAndListValues() {
        Properties props = new Properties();
        props.put("zookeeper.connect", this.zkConnect());
        String someValue = "some_value";
        ((MapLike)CollectionConverters$.MODULE$.mapAsScalaMapConverter(ZkConfigs.ZK_SSL_CONFIG_TO_SYSTEM_PROPERTY_MAP).asScala()).keys().foreach((Function1 & Serializable & scala.Serializable)kafkaProp -> props.put(kafkaProp, KafkaServerTest.kafkaConfigValueToSet$2(kafkaProp, someValue)));
        ZKClientConfig zkClientConfig = KafkaServer$.MODULE$.zkClientConfigFromKafkaConfig(KafkaConfig$.MODULE$.fromProps(props), KafkaServer$.MODULE$.zkClientConfigFromKafkaConfig$default$2());
        ((MapLike)CollectionConverters$.MODULE$.mapAsScalaMapConverter(ZkConfigs.ZK_SSL_CONFIG_TO_SYSTEM_PROPERTY_MAP).asScala()).keys().foreach((Function1 & Serializable & scala.Serializable)kafkaProp -> {
            KafkaServerTest.$anonfun$testCreatesProperZkTlsConfigWithFalseAndListValues$2(zkClientConfig, someValue, kafkaProp);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testZkIsrManager() {
        Properties props = (Properties)TestUtils$.MODULE$.createBrokerConfigs(1, this.zkConnect(), TestUtils$.MODULE$.createBrokerConfigs$default$3(), TestUtils$.MODULE$.createBrokerConfigs$default$4(), TestUtils$.MODULE$.createBrokerConfigs$default$5(), TestUtils$.MODULE$.createBrokerConfigs$default$6(), TestUtils$.MODULE$.createBrokerConfigs$default$7(), TestUtils$.MODULE$.createBrokerConfigs$default$8(), TestUtils$.MODULE$.createBrokerConfigs$default$9(), TestUtils$.MODULE$.createBrokerConfigs$default$10(), TestUtils$.MODULE$.createBrokerConfigs$default$11(), TestUtils$.MODULE$.createBrokerConfigs$default$12(), TestUtils$.MODULE$.createBrokerConfigs$default$13(), TestUtils$.MODULE$.createBrokerConfigs$default$14(), TestUtils$.MODULE$.createBrokerConfigs$default$15(), TestUtils$.MODULE$.createBrokerConfigs$default$16(), TestUtils$.MODULE$.createBrokerConfigs$default$17(), TestUtils$.MODULE$.createBrokerConfigs$default$18()).head();
        props.put("inter.broker.protocol.version", "2.7-IV1");
        KafkaServer server = TestUtils$.MODULE$.createServer(KafkaConfig$.MODULE$.fromProps(props), TestUtils$.MODULE$.createServer$default$2());
        if (!(server.replicaManager().alterPartitionManager() instanceof ZkAlterPartitionManager)) {
            BoxedUnit cfr_ignored_0 = (BoxedUnit)Assertions.fail((String)"Should use ZK for ISR manager in versions before 2.7-IV2");
        }
        server.shutdown();
    }

    @Test
    public void testAlterIsrManager() {
        Properties props = (Properties)TestUtils$.MODULE$.createBrokerConfigs(1, this.zkConnect(), TestUtils$.MODULE$.createBrokerConfigs$default$3(), TestUtils$.MODULE$.createBrokerConfigs$default$4(), TestUtils$.MODULE$.createBrokerConfigs$default$5(), TestUtils$.MODULE$.createBrokerConfigs$default$6(), TestUtils$.MODULE$.createBrokerConfigs$default$7(), TestUtils$.MODULE$.createBrokerConfigs$default$8(), TestUtils$.MODULE$.createBrokerConfigs$default$9(), TestUtils$.MODULE$.createBrokerConfigs$default$10(), TestUtils$.MODULE$.createBrokerConfigs$default$11(), TestUtils$.MODULE$.createBrokerConfigs$default$12(), TestUtils$.MODULE$.createBrokerConfigs$default$13(), TestUtils$.MODULE$.createBrokerConfigs$default$14(), TestUtils$.MODULE$.createBrokerConfigs$default$15(), TestUtils$.MODULE$.createBrokerConfigs$default$16(), TestUtils$.MODULE$.createBrokerConfigs$default$17(), TestUtils$.MODULE$.createBrokerConfigs$default$18()).head();
        props.put("inter.broker.protocol.version", MetadataVersion.latestTesting().toString());
        KafkaServer server = TestUtils$.MODULE$.createServer(KafkaConfig$.MODULE$.fromProps(props), TestUtils$.MODULE$.createServer$default$2());
        if (!(server.replicaManager().alterPartitionManager() instanceof DefaultAlterPartitionManager)) {
            BoxedUnit cfr_ignored_0 = (BoxedUnit)Assertions.fail((String)"Should use AlterIsr for ISR manager in versions after 2.7-IV2");
        }
        server.shutdown();
    }

    @Test
    public void testRemoteLogManagerInstantiation() {
        Properties props = (Properties)TestUtils$.MODULE$.createBrokerConfigs(1, this.zkConnect(), TestUtils$.MODULE$.createBrokerConfigs$default$3(), TestUtils$.MODULE$.createBrokerConfigs$default$4(), TestUtils$.MODULE$.createBrokerConfigs$default$5(), TestUtils$.MODULE$.createBrokerConfigs$default$6(), TestUtils$.MODULE$.createBrokerConfigs$default$7(), TestUtils$.MODULE$.createBrokerConfigs$default$8(), TestUtils$.MODULE$.createBrokerConfigs$default$9(), TestUtils$.MODULE$.createBrokerConfigs$default$10(), TestUtils$.MODULE$.createBrokerConfigs$default$11(), TestUtils$.MODULE$.createBrokerConfigs$default$12(), TestUtils$.MODULE$.createBrokerConfigs$default$13(), TestUtils$.MODULE$.createBrokerConfigs$default$14(), TestUtils$.MODULE$.createBrokerConfigs$default$15(), TestUtils$.MODULE$.createBrokerConfigs$default$16(), TestUtils$.MODULE$.createBrokerConfigs$default$17(), TestUtils$.MODULE$.createBrokerConfigs$default$18()).head();
        props.put("remote.log.storage.system.enable", Boolean.toString(true));
        props.put("remote.log.metadata.manager.class.name", "org.apache.kafka.server.log.remote.storage.NoOpRemoteLogMetadataManager");
        props.put("remote.log.storage.manager.class.name", "org.apache.kafka.server.log.remote.storage.NoOpRemoteStorageManager");
        KafkaServer server = TestUtils$.MODULE$.createServer(KafkaConfig$.MODULE$.fromProps(props), TestUtils$.MODULE$.createServer$default$2());
        Option option = server.remoteLogManagerOpt();
        if (!(option instanceof Some)) {
            if (None$.MODULE$.equals(option)) {
                BoxedUnit cfr_ignored_0 = (BoxedUnit)Assertions.fail((String)"RemoteLogManager should be initialized");
            } else {
                throw new MatchError((Object)option);
            }
        }
        server.shutdown();
    }

    @Test
    public void testGeneratedBrokerIdSyncWithNodeId() {
        Properties props = TestUtils$.MODULE$.createBrokerConfig(-1, this.zkConnect(), TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18(), TestUtils$.MODULE$.createBrokerConfig$default$19(), TestUtils$.MODULE$.createBrokerConfig$default$20(), TestUtils$.MODULE$.createBrokerConfig$default$21());
        props.put("reserved.broker.max.id", "2000");
        KafkaServer kafkaServer = TestUtils$.MODULE$.createServer(KafkaConfig$.MODULE$.fromProps(props), TestUtils$.MODULE$.createServer$default$2());
        try {
            kafkaServer.startup();
            Assertions.assertEquals((int)2001, (int)kafkaServer.config().brokerId());
            Assertions.assertEquals((int)2001, (int)kafkaServer.config().nodeId());
        }
        finally {
            kafkaServer.shutdown();
        }
    }

    public KafkaServer createServer(int nodeId, String hostName, int port) {
        Properties props = TestUtils$.MODULE$.createBrokerConfig(nodeId, this.zkConnect(), TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18(), TestUtils$.MODULE$.createBrokerConfig$default$19(), TestUtils$.MODULE$.createBrokerConfig$default$20(), TestUtils$.MODULE$.createBrokerConfig$default$21());
        props.put("advertised.listeners", new StringBuilder(13).append("PLAINTEXT://").append(hostName).append(":").append(port).toString());
        KafkaConfig kafkaConfig = KafkaConfig$.MODULE$.fromProps(props);
        return TestUtils$.MODULE$.createServer(kafkaConfig, TestUtils$.MODULE$.createServer$default$2());
    }

    public KafkaServer createServerWithListenerOnPort(int port) {
        Properties props = TestUtils$.MODULE$.createBrokerConfig(0, this.zkConnect(), TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18(), TestUtils$.MODULE$.createBrokerConfig$default$19(), TestUtils$.MODULE$.createBrokerConfig$default$20(), TestUtils$.MODULE$.createBrokerConfig$default$21());
        props.put("listeners", new StringBuilder(22).append("PLAINTEXT://localhost:").append(port).toString());
        KafkaConfig kafkaConfig = KafkaConfig$.MODULE$.fromProps(props);
        return TestUtils$.MODULE$.createServer(kafkaConfig, TestUtils$.MODULE$.createServer$default$2());
    }

    public static final /* synthetic */ String $anonfun$testListenerPortAlreadyInUse$2() {
        return "Server socket failed to bind.";
    }

    public static final /* synthetic */ void $anonfun$testCreatesProperZkTlsConfigWhenDisabled$1(ZKClientConfig zkClientConfig$1, String propName) {
        Assertions.assertNull((Object)zkClientConfig$1.getProperty(propName));
    }

    private static final String kafkaConfigValueToSet$1(String kafkaProp, String someValue$1) {
        if ("zookeeper.ssl.client.enable".equals(kafkaProp) ? true : ("zookeeper.ssl.crl.enable".equals(kafkaProp) ? true : "zookeeper.ssl.ocsp.enable".equals(kafkaProp))) {
            return "true";
        }
        if ("zookeeper.ssl.endpoint.identification.algorithm".equals(kafkaProp)) {
            return "HTTPS";
        }
        return someValue$1;
    }

    private static final String zkClientValueToExpect$1(String kafkaProp, String someValue$1) {
        if ("zookeeper.ssl.client.enable".equals(kafkaProp) ? true : ("zookeeper.ssl.crl.enable".equals(kafkaProp) ? true : "zookeeper.ssl.ocsp.enable".equals(kafkaProp))) {
            return "true";
        }
        if ("zookeeper.ssl.endpoint.identification.algorithm".equals(kafkaProp)) {
            return "true";
        }
        return someValue$1;
    }

    public static final /* synthetic */ void $anonfun$testCreatesProperZkTlsConfigWithTrueValues$2(ZKClientConfig zkClientConfig$2, String someValue$1, String kafkaProp) {
        Assertions.assertEquals((Object)KafkaServerTest.zkClientValueToExpect$1(kafkaProp, someValue$1), (Object)zkClientConfig$2.getProperty((String)ZkConfigs.ZK_SSL_CONFIG_TO_SYSTEM_PROPERTY_MAP.get(kafkaProp)));
    }

    private static final String kafkaConfigValueToSet$2(String kafkaProp, String someValue$2) {
        if ("zookeeper.ssl.client.enable".equals(kafkaProp)) {
            return "true";
        }
        if ("zookeeper.ssl.crl.enable".equals(kafkaProp) ? true : "zookeeper.ssl.ocsp.enable".equals(kafkaProp)) {
            return "false";
        }
        if ("zookeeper.ssl.endpoint.identification.algorithm".equals(kafkaProp)) {
            return "";
        }
        if ("zookeeper.ssl.enabled.protocols".equals(kafkaProp) ? true : "zookeeper.ssl.cipher.suites".equals(kafkaProp)) {
            return "A,B";
        }
        return someValue$2;
    }

    private static final String zkClientValueToExpect$2(String kafkaProp, String someValue$2) {
        if ("zookeeper.ssl.client.enable".equals(kafkaProp)) {
            return "true";
        }
        if ("zookeeper.ssl.crl.enable".equals(kafkaProp) ? true : "zookeeper.ssl.ocsp.enable".equals(kafkaProp)) {
            return "false";
        }
        if ("zookeeper.ssl.endpoint.identification.algorithm".equals(kafkaProp)) {
            return "false";
        }
        if ("zookeeper.ssl.enabled.protocols".equals(kafkaProp) ? true : "zookeeper.ssl.cipher.suites".equals(kafkaProp)) {
            return "A,B";
        }
        return someValue$2;
    }

    public static final /* synthetic */ void $anonfun$testCreatesProperZkTlsConfigWithFalseAndListValues$2(ZKClientConfig zkClientConfig$3, String someValue$2, String kafkaProp) {
        Assertions.assertEquals((Object)KafkaServerTest.zkClientValueToExpect$2(kafkaProp, someValue$2), (Object)zkClientConfig$3.getProperty((String)ZkConfigs.ZK_SSL_CONFIG_TO_SYSTEM_PROPERTY_MAP.get(kafkaProp)));
    }
}

