/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.util.Iterator;
import java.util.Optional;
import java.util.concurrent.ConcurrentLinkedDeque;
import kafka.server.ControllerNodeProvider;
import kafka.server.MockNodeToControllerChannelManager$;
import kafka.server.NodeToControllerQueueItem;
import org.apache.kafka.clients.ClientRequest;
import org.apache.kafka.clients.ClientResponse;
import org.apache.kafka.clients.MockClient;
import org.apache.kafka.clients.NodeApiVersions;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.server.ControllerRequestCompletionHandler;
import org.apache.kafka.server.NodeToControllerChannelManager;
import org.apache.kafka.server.util.MockTime;
import scala.Option;
import scala.Some;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u0005}d\u0001\u0002\u000e\u001c\u0001\u0001B\u0001b\r\u0001\u0003\u0006\u0004%\t\u0001\u000e\u0005\tw\u0001\u0011\t\u0011)A\u0005k!AA\b\u0001B\u0001B\u0003%Q\b\u0003\u0005D\u0001\t\u0005\t\u0015!\u0003E\u0011!A\u0005A!A!\u0002\u0013I\u0005\u0002\u0003'\u0001\u0005\u000b\u0007I\u0011A'\t\u0011Q\u0003!\u0011!Q\u0001\n9C\u0001\"\u0016\u0001\u0003\u0006\u0004%\t!\u0014\u0005\t-\u0002\u0011\t\u0011)A\u0005\u001d\")q\u000b\u0001C\u00011\"9\u0001\r\u0001b\u0001\n\u0003\t\u0007B\u00027\u0001A\u0003%!\rC\u0003n\u0001\u0011\u0005c\u000eC\u0003s\u0001\u0011\u0005c\u000eC\u0003t\u0001\u0011\u0005C\u000f\u0003\u0004I\u0001\u0011\u0005\u0013\u0011\u0006\u0005\b\u0003g\u0001A\u0011IA\u001b\u0011!\ti\u0004\u0001C\u00017\u0005}\u0002BBA(\u0001\u0011\u0005anB\u0005\u0002Rm\t\t\u0011#\u0001\u0002T\u0019A!dGA\u0001\u0012\u0003\t)\u0006\u0003\u0004X+\u0011\u0005\u0011Q\f\u0005\n\u0003?*\u0012\u0013!C\u0001\u0003CB\u0011\"a\u001e\u0016#\u0003%\t!!\u001f\t\u0013\u0005uT#%A\u0005\u0002\u0005e$AI'pG.tu\u000eZ3U_\u000e{g\u000e\u001e:pY2,'o\u00115b]:,G.T1oC\u001e,'O\u0003\u0002\u001d;\u000511/\u001a:wKJT\u0011AH\u0001\u0006W\u000647.Y\u0002\u0001'\r\u0001\u0011%\u000b\t\u0003E\u001dj\u0011a\t\u0006\u0003I\u0015\nA\u0001\\1oO*\ta%\u0001\u0003kCZ\f\u0017B\u0001\u0015$\u0005\u0019y%M[3diB\u0011!&M\u0007\u0002W)\u0011A\u0004\f\u0006\u0003=5R!AL\u0018\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005\u0001\u0014aA8sO&\u0011!g\u000b\u0002\u001f\u001d>$W\rV8D_:$(o\u001c7mKJ\u001c\u0005.\u00198oK2l\u0015M\\1hKJ\faa\u00197jK:$X#A\u001b\u0011\u0005YJT\"A\u001c\u000b\u0005ab\u0013aB2mS\u0016tGo]\u0005\u0003u]\u0012!\"T8dW\u000ec\u0017.\u001a8u\u0003\u001d\u0019G.[3oi\u0002\nA\u0001^5nKB\u0011a(Q\u0007\u0002\u007f)\u0011\u0001iK\u0001\u0005kRLG.\u0003\u0002C\u007f\tAQj\\2l)&lW-\u0001\fd_:$(o\u001c7mKJtu\u000eZ3Qe>4\u0018\u000eZ3s!\t)e)D\u0001\u001c\u0013\t95D\u0001\fD_:$(o\u001c7mKJtu\u000eZ3Qe>4\u0018\u000eZ3s\u0003U\u0019wN\u001c;s_2dWM]!qSZ+'o]5p]N\u0004\"A\u000e&\n\u0005-;$a\u0004(pI\u0016\f\u0005/\u001b,feNLwN\\:\u0002\u001dI,GO]=US6,w.\u001e;NgV\ta\n\u0005\u0002P%6\t\u0001KC\u0001R\u0003\u0015\u00198-\u00197b\u0013\t\u0019\u0006KA\u0002J]R\fqB]3uef$\u0016.\\3pkRl5\u000fI\u0001\u0011e\u0016\fX/Z:u)&lWm\\;u\u001bN\f\u0011C]3rk\u0016\u001cH\u000fV5nK>,H/T:!\u0003\u0019a\u0014N\\5u}Q9\u0011LW.];z{\u0006CA#\u0001\u0011\u0015\u0019$\u00021\u00016\u0011\u0015a$\u00021\u0001>\u0011\u0015\u0019%\u00021\u0001E\u0011\u001dA%\u0002%AA\u0002%Cq\u0001\u0014\u0006\u0011\u0002\u0003\u0007a\nC\u0004V\u0015A\u0005\t\u0019\u0001(\u0002\u0017Ut7/\u001a8u#V,W/Z\u000b\u0002EB\u00191mZ5\u000e\u0003\u0011T!!\u001a4\u0002\u0015\r|gnY;se\u0016tGO\u0003\u0002AK%\u0011\u0001\u000e\u001a\u0002\u0016\u0007>t7-\u001e:sK:$H*\u001b8lK\u0012$U-];f!\t)%.\u0003\u0002l7\tIbj\u001c3f)>\u001cuN\u001c;s_2dWM])vKV,\u0017\n^3n\u00031)hn]3oiF+X-^3!\u0003\u0015\u0019H/\u0019:u)\u0005y\u0007CA(q\u0013\t\t\bK\u0001\u0003V]&$\u0018\u0001C:ikR$wn\u001e8\u0002\u0017M,g\u000e\u001a*fcV,7\u000f\u001e\u000b\u0005_V\fy\u0002C\u0003w\u001f\u0001\u0007q/A\u0004sKF,Xm\u001d;1\u0007a\fi\u0001E\u0003z\u0003\u0007\tIA\u0004\u0002{\u007f6\t1P\u0003\u0002}{\u0006A!/Z9vKN$8O\u0003\u0002\u007fY\u000511m\\7n_:L1!!\u0001|\u0003=\t%m\u001d;sC\u000e$(+Z9vKN$\u0018\u0002BA\u0003\u0003\u000f\u0011qAQ;jY\u0012,'OC\u0002\u0002\u0002m\u0004B!a\u0003\u0002\u000e1\u0001AaCA\bk\u0006\u0005\t\u0011!B\u0001\u0003#\u00111a\u0018\u00132#\u0011\t\u0019\"!\u0007\u0011\u0007=\u000b)\"C\u0002\u0002\u0018A\u0013qAT8uQ&tw\rE\u0002{\u00037I1!!\b|\u0005=\t%m\u001d;sC\u000e$(+Z9vKN$\bbBA\u0011\u001f\u0001\u0007\u00111E\u0001\tG\u0006dGNY1dWB\u0019!&!\n\n\u0007\u0005\u001d2F\u0001\u0012D_:$(o\u001c7mKJ\u0014V-];fgR\u001cu.\u001c9mKRLwN\u001c%b]\u0012dWM\u001d\u000b\u0003\u0003W\u0001R!!\f\u00020%k\u0011AZ\u0005\u0004\u0003c1'\u0001C(qi&|g.\u00197\u0002\u0019\u001d,G\u000fV5nK>,H/T:\u0015\u0005\u0005]\u0002cA(\u0002:%\u0019\u00111\b)\u0003\t1{gnZ\u0001\u000fQ\u0006tG\r\\3SKN\u0004xN\\:f)\u0011\t\t%!\u0014\u0015\u0007=\f\u0019\u0005C\u0004\u0002FI\u0001\r!a\u0012\u0002\u0011I,7\u000f]8og\u0016\u00042ANA%\u0013\r\tYe\u000e\u0002\u000f\u00072LWM\u001c;SKN\u0004xN\\:f\u0011\u00151(\u00031\u0001j\u0003\u0011\u0001x\u000e\u001c7\u0002E5{7m\u001b(pI\u0016$vnQ8oiJ|G\u000e\\3s\u0007\"\fgN\\3m\u001b\u0006t\u0017mZ3s!\t)UcE\u0002\u0016\u0003/\u00022aTA-\u0013\r\tY\u0006\u0015\u0002\u0007\u0003:L(+\u001a4\u0015\u0005\u0005M\u0013a\u0007\u0013mKN\u001c\u0018N\\5uI\u001d\u0014X-\u0019;fe\u0012\"WMZ1vYR$C'\u0006\u0002\u0002d)\u001a\u0011*!\u001a,\u0005\u0005\u001d\u0004\u0003BA5\u0003gj!!a\u001b\u000b\t\u00055\u0014qN\u0001\nk:\u001c\u0007.Z2lK\u0012T1!!\u001dQ\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0003k\nYGA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\f1\u0004\n7fgNLg.\u001b;%OJ,\u0017\r^3sI\u0011,g-Y;mi\u0012*TCAA>U\rq\u0015QM\u0001\u001cI1,7o]5oSR$sM]3bi\u0016\u0014H\u0005Z3gCVdG\u000f\n\u001c")
public class MockNodeToControllerChannelManager
implements NodeToControllerChannelManager {
    private final MockClient client;
    private final MockTime time;
    private final ControllerNodeProvider controllerNodeProvider;
    private final NodeApiVersions controllerApiVersions;
    private final int retryTimeoutMs;
    private final int requestTimeoutMs;
    private final ConcurrentLinkedDeque<NodeToControllerQueueItem> unsentQueue;

    public static int $lessinit$greater$default$6() {
        return MockNodeToControllerChannelManager$.MODULE$.$lessinit$greater$default$6();
    }

    public static int $lessinit$greater$default$5() {
        return MockNodeToControllerChannelManager$.MODULE$.$lessinit$greater$default$5();
    }

    public static NodeApiVersions $lessinit$greater$default$4() {
        return MockNodeToControllerChannelManager$.MODULE$.$lessinit$greater$default$4();
    }

    public MockClient client() {
        return this.client;
    }

    public int retryTimeoutMs() {
        return this.retryTimeoutMs;
    }

    public int requestTimeoutMs() {
        return this.requestTimeoutMs;
    }

    public ConcurrentLinkedDeque<NodeToControllerQueueItem> unsentQueue() {
        return this.unsentQueue;
    }

    public void start() {
    }

    public void shutdown() {
    }

    public void sendRequest(AbstractRequest.Builder<? extends AbstractRequest> request, ControllerRequestCompletionHandler callback) {
        this.unsentQueue().add(new NodeToControllerQueueItem(this.time.milliseconds(), request, callback));
    }

    public Optional<NodeApiVersions> controllerApiVersions() {
        return Optional.of(this.controllerApiVersions);
    }

    public long getTimeoutMs() {
        return this.retryTimeoutMs();
    }

    public void handleResponse(NodeToControllerQueueItem request, ClientResponse response) {
        if (response.authenticationException() != null || response.versionMismatch() != null) {
            request.callback().onComplete(response);
            return;
        }
        if (response.wasDisconnected() || response.responseBody().errorCounts().containsKey(Errors.NOT_CONTROLLER)) {
            this.unsentQueue().addFirst(request);
            return;
        }
        request.callback().onComplete(response);
    }

    public void poll() {
        Iterator<NodeToControllerQueueItem> unsentIterator = this.unsentQueue().iterator();
        boolean canSend = true;
        while (canSend && unsentIterator.hasNext()) {
            NodeToControllerQueueItem queueItem = unsentIterator.next();
            if (this.time.milliseconds() - queueItem.createdTimeMs() >= (long)this.retryTimeoutMs()) {
                queueItem.callback().onTimeout();
                unsentIterator.remove();
                continue;
            }
            Option option = this.controllerNodeProvider.getControllerInfo().node();
            if (option instanceof Some) {
                Node controller = (Node)((Some)option).value();
                if (this.client().ready(controller, this.time.milliseconds())) {
                    ClientRequest clientRequest = this.client().newClientRequest(controller.idString(), queueItem.request(), queueItem.createdTimeMs(), true, this.requestTimeoutMs(), response -> this.handleResponse(queueItem, response));
                    this.client().send(clientRequest, this.time.milliseconds());
                    unsentIterator.remove();
                    continue;
                }
            }
            canSend = false;
        }
        this.client().poll(0L, this.time.milliseconds());
    }

    public MockNodeToControllerChannelManager(MockClient client, MockTime time, ControllerNodeProvider controllerNodeProvider, NodeApiVersions controllerApiVersions, int retryTimeoutMs, int requestTimeoutMs) {
        this.client = client;
        this.time = time;
        this.controllerNodeProvider = controllerNodeProvider;
        this.controllerApiVersions = controllerApiVersions;
        this.retryTimeoutMs = retryTimeoutMs;
        this.requestTimeoutMs = requestTimeoutMs;
        this.unsentQueue = new ConcurrentLinkedDeque();
        client.setNodeApiVersions(controllerApiVersions);
    }
}

