/*
 * Decompiled with CFR 0.152.
 */
package kafka.tools;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.file.AccessDeniedException;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.Paths;
import java.nio.file.attribute.PosixFilePermissions;
import java.util.Arrays;
import java.util.Collections;
import java.util.ListIterator;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.ConcurrentMap;
import java.util.stream.IntStream;
import kafka.log.LogTestUtils$;
import kafka.log.UnifiedLog;
import kafka.log.UnifiedLog$;
import kafka.raft.KafkaMetadataLog;
import kafka.raft.KafkaMetadataLog$;
import kafka.raft.MetadataLogConfig;
import kafka.serializer.Decoder;
import kafka.serializer.IntegerDecoder;
import kafka.serializer.LongDecoder;
import kafka.serializer.StringDecoder;
import kafka.server.BrokerTopicStats;
import kafka.server.BrokerTopicStats$;
import kafka.server.KafkaRaftServer$;
import kafka.server.RequestLocal;
import kafka.tools.BatchInfo;
import kafka.tools.DumpLogSegments;
import kafka.tools.DumpLogSegments$;
import kafka.utils.Exit$;
import kafka.utils.TestUtils$;
import kafka.utils.VerifiableProperties;
import org.apache.kafka.clients.consumer.ConsumerPartitionAssignor;
import org.apache.kafka.clients.consumer.internals.ConsumerProtocol;
import org.apache.kafka.common.TopicIdPartition;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.compress.Compression;
import org.apache.kafka.common.metadata.PartitionChangeRecord;
import org.apache.kafka.common.metadata.RegisterBrokerRecord;
import org.apache.kafka.common.metadata.TopicRecord;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.common.protocol.ByteBufferAccessor;
import org.apache.kafka.common.protocol.ObjectSerializationCache;
import org.apache.kafka.common.protocol.Writable;
import org.apache.kafka.common.record.ControlRecordType;
import org.apache.kafka.common.record.EndTransactionMarker;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.Record;
import org.apache.kafka.common.record.RecordBatch;
import org.apache.kafka.common.record.RecordVersion;
import org.apache.kafka.common.record.SimpleRecord;
import org.apache.kafka.common.utils.Exit;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.coordinator.group.CoordinatorRecord;
import org.apache.kafka.coordinator.group.CoordinatorRecordSerde;
import org.apache.kafka.coordinator.group.generated.ConsumerGroupMemberMetadataValue;
import org.apache.kafka.coordinator.group.generated.ConsumerGroupMetadataKey;
import org.apache.kafka.coordinator.group.generated.ConsumerGroupMetadataValue;
import org.apache.kafka.coordinator.group.generated.GroupMetadataKey;
import org.apache.kafka.coordinator.group.generated.GroupMetadataValue;
import org.apache.kafka.metadata.MetadataRecordSerde;
import org.apache.kafka.raft.OffsetAndEpoch;
import org.apache.kafka.raft.VoterSetTest;
import org.apache.kafka.server.common.ApiMessageAndVersion;
import org.apache.kafka.server.common.KRaftVersion;
import org.apache.kafka.server.common.MetadataVersion;
import org.apache.kafka.server.common.serialization.RecordSerde;
import org.apache.kafka.server.log.remote.metadata.storage.serialization.RemoteLogMetadataSerde;
import org.apache.kafka.server.log.remote.storage.RemoteLogMetadata;
import org.apache.kafka.server.log.remote.storage.RemoteLogSegmentId;
import org.apache.kafka.server.log.remote.storage.RemoteLogSegmentMetadata;
import org.apache.kafka.server.log.remote.storage.RemoteLogSegmentMetadataUpdate;
import org.apache.kafka.server.log.remote.storage.RemoteLogSegmentState;
import org.apache.kafka.server.log.remote.storage.RemotePartitionDeleteMetadata;
import org.apache.kafka.server.log.remote.storage.RemotePartitionDeleteState;
import org.apache.kafka.server.util.MockScheduler;
import org.apache.kafka.server.util.MockTime;
import org.apache.kafka.server.util.Scheduler;
import org.apache.kafka.snapshot.RawSnapshotWriter;
import org.apache.kafka.snapshot.RecordsSnapshotWriter;
import org.apache.kafka.storage.internals.log.AppendOrigin;
import org.apache.kafka.storage.internals.log.FetchDataInfo;
import org.apache.kafka.storage.internals.log.FetchIsolation;
import org.apache.kafka.storage.internals.log.LogConfig;
import org.apache.kafka.storage.internals.log.LogDirFailureChannel;
import org.apache.kafka.storage.internals.log.LogOffsetsListener;
import org.apache.kafka.storage.internals.log.LogSegment;
import org.apache.kafka.storage.internals.log.ProducerStateManagerConfig;
import org.apache.kafka.storage.internals.log.VerificationGuard;
import org.apache.kafka.tools.api.DefaultDecoder;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import scala.Array$;
import scala.Console$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.Iterator;
import scala.collection.LinearSeqOptimized;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Map$;
import scala.collection.mutable.ResizableArray;
import scala.jdk.CollectionConverters$;
import scala.math.Numeric;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.Nothing$;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;
import scala.util.Using;
import scala.util.Using$;
import scala.util.matching.Regex;

@ScalaSignature(bytes="\u0006\u0001\t=e\u0001\u0002!B\u0001\u0019CQ!\u0014\u0001\u0005\u00029Cq!\u0015\u0001C\u0002\u0013\u0005!\u000b\u0003\u0004\\\u0001\u0001\u0006Ia\u0015\u0005\b9\u0002\u0011\r\u0011\"\u0001S\u0011\u0019i\u0006\u0001)A\u0005'\"9a\f\u0001b\u0001\n\u0003y\u0006B\u00024\u0001A\u0003%\u0001\rC\u0004h\u0001\t\u0007I\u0011\u00015\t\rM\u0004\u0001\u0015!\u0003j\u0011\u001d!\bA1A\u0005\u0002!Da!\u001e\u0001!\u0002\u0013I\u0007b\u0002<\u0001\u0005\u0004%\t\u0001\u001b\u0005\u0007o\u0002\u0001\u000b\u0011B5\t\u000fa\u0004!\u0019!C\u0001Q\"1\u0011\u0010\u0001Q\u0001\n%DqA\u001f\u0001C\u0002\u0013\u00051\u0010C\u0004\u0002\u0014\u0001\u0001\u000b\u0011\u0002?\t\u0017\u0005U\u0001\u00011AA\u0002\u0013\u0005\u0011q\u0003\u0005\f\u0003G\u0001\u0001\u0019!a\u0001\n\u0003\t)\u0003C\u0006\u00022\u0001\u0001\r\u0011!Q!\n\u0005e\u0001bBA\u001a\u0001\u0011\u0005\u0011Q\u0007\u0005\b\u0003\u001b\u0002A\u0011BA\f\u0011\u001d\ty\u0005\u0001C\u0005\u0003#Bq!a\u001c\u0001\t\u0003\t)\u0004C\u0004\u0002z\u0001!\t!!\u000e\t\u000f\u0005u\u0004\u0001\"\u0001\u00026!9\u0011\u0011\u0011\u0001\u0005\u0002\u0005U\u0002bBAC\u0001\u0011\u0005\u0011q\u0011\u0005\b\u0003/\u0003A\u0011AAM\u0011\u001d\ti\n\u0001C\u0001\u0003?Cq!a)\u0001\t\u0003\t)\u0004C\u0004\u0002(\u0002!\t!!\u000e\t\u000f\u0005-\u0006\u0001\"\u0001\u00026!9\u0011q\u0016\u0001\u0005\u0002\u0005U\u0002bBAZ\u0001\u0011\u0005\u0011Q\u0007\u0005\b\u0003o\u0003A\u0011AA\u001b\u0011\u001d\tY\f\u0001C\u0001\u0003kAq!a0\u0001\t\u0003\t)\u0004C\u0004\u0002D\u0002!\t!!\u000e\t\u000f\u0005\u001d\u0007\u0001\"\u0001\u00026!9\u00111\u001a\u0001\u0005\u0002\u0005U\u0002bBAh\u0001\u0011\u0005\u0011Q\u0007\u0005\b\u0003'\u0004A\u0011BAk\u0011\u001d\t\t\u000f\u0001C\u0001\u0003kAq!!:\u0001\t\u0003\t)\u0004C\u0004\u0002j\u0002!\t!!\u000e\t\u000f\u00055\b\u0001\"\u0001\u00026!9\u0011\u0011\u001f\u0001\u0005\n\u0005M\bb\u0002B\u0005\u0001\u0011%!1\u0002\u0005\b\u0005'\u0001A\u0011\u0002B\u000b\u0011\u001d\u0011I\u0002\u0001C\u0005\u00057AqA!\r\u0001\t\u0013\u0011\u0019\u0004C\u0004\u0003@\u0001!IA!\u0011\b\u000f\t\u0015\u0013\t#\u0001\u0003H\u00191\u0001)\u0011E\u0001\u0005\u0013Ba!T\u001c\u0005\u0002\t-cA\u0002B'o\u0001\u0011y\u0005\u0003\u0006\u0003fe\u0012\t\u0011)A\u0005\u0005OBa!T\u001d\u0005\u0002\tM\u0004b\u0002B>s\u0011\u0005#Q\u0010\u0004\u0007\u0005\u0007;\u0004A!\"\t\r5kD\u0011\u0001BD\u0011\u001d\u0011Y(\u0010C!\u0005\u0017\u00131\u0003R;na2{wmU3h[\u0016tGo\u001d+fgRT!AQ\"\u0002\u000bQ|w\u000e\\:\u000b\u0003\u0011\u000bQa[1gW\u0006\u001c\u0001a\u0005\u0002\u0001\u000fB\u0011\u0001jS\u0007\u0002\u0013*\t!*A\u0003tG\u0006d\u0017-\u0003\u0002M\u0013\n1\u0011I\\=SK\u001a\fa\u0001P5oSRtD#A(\u0011\u0005A\u0003Q\"A!\u0002\rQl\u0007\u000fR5s+\u0005\u0019\u0006C\u0001+Z\u001b\u0005)&B\u0001,X\u0003\tIwNC\u0001Y\u0003\u0011Q\u0017M^1\n\u0005i+&\u0001\u0002$jY\u0016\fq\u0001^7q\t&\u0014\b%\u0001\u0004m_\u001e$\u0015N]\u0001\bY><G)\u001b:!\u0003-\u0019XmZ7f]Rt\u0015-\\3\u0016\u0003\u0001\u0004\"!\u00193\u000e\u0003\tT!aY,\u0002\t1\fgnZ\u0005\u0003K\n\u0014aa\u0015;sS:<\u0017\u0001D:fO6,g\u000e\u001e(b[\u0016\u0004\u0013a\u00037pO\u001aKG.\u001a)bi\",\u0012!\u001b\t\u0003UFt!a[8\u0011\u00051LU\"A7\u000b\u00059,\u0015A\u0002\u001fs_>$h(\u0003\u0002q\u0013\u00061\u0001K]3eK\u001aL!!\u001a:\u000b\u0005AL\u0015\u0001\u00047pO\u001aKG.\u001a)bi\"\u0004\u0013\u0001D:oCB\u001c\bn\u001c;QCRD\u0017!D:oCB\u001c\bn\u001c;QCRD\u0007%A\u0007j]\u0012,\u0007PR5mKB\u000bG\u000f[\u0001\u000fS:$W\r\u001f$jY\u0016\u0004\u0016\r\u001e5!\u0003E!\u0018.\\3J]\u0012,\u0007PR5mKB\u000bG\u000f[\u0001\u0013i&lW-\u00138eKb4\u0015\u000e\\3QCRD\u0007%\u0001\u0003uS6,W#\u0001?\u0011\u0007u\fy!D\u0001\u007f\u0015\ry\u0018\u0011A\u0001\u0005kRLGN\u0003\u0003\u0002\u0004\u0005\u0015\u0011AB:feZ,'OC\u0002E\u0003\u000fQA!!\u0003\u0002\f\u00051\u0011\r]1dQ\u0016T!!!\u0004\u0002\u0007=\u0014x-C\u0002\u0002\u0012y\u0014\u0001\"T8dWRKW.Z\u0001\u0006i&lW\rI\u0001\u0004Y><WCAA\r!\u0011\tY\"a\b\u000e\u0005\u0005u!bAA\u000b\u0007&!\u0011\u0011EA\u000f\u0005))f.\u001b4jK\u0012dunZ\u0001\bY><w\fJ3r)\u0011\t9#!\f\u0011\u0007!\u000bI#C\u0002\u0002,%\u0013A!\u00168ji\"I\u0011qF\n\u0002\u0002\u0003\u0007\u0011\u0011D\u0001\u0004q\u0012\n\u0014\u0001\u00027pO\u0002\n\u0011\"\u00194uKJ,\u0015m\u00195\u0015\u0005\u0005\u001d\u0002fA\u000b\u0002:A!\u00111HA%\u001b\t\tiD\u0003\u0003\u0002@\u0005\u0005\u0013aA1qS*!\u00111IA#\u0003\u001dQW\u000f]5uKJTA!a\u0012\u0002\f\u0005)!.\u001e8ji&!\u00111JA\u001f\u0005%\te\r^3s\u000b\u0006\u001c\u0007.A\u0007de\u0016\fG/\u001a+fgRdunZ\u0001\u0011C\u0012$7+[7qY\u0016\u0014VmY8sIN$b!a\n\u0002T\u0005U\u0003bBA\u000b/\u0001\u0007\u0011\u0011\u0004\u0005\b\u0003/:\u0002\u0019AA-\u0003\u001d\u0011\u0017\r^2iKN\u0004b!a\u0017\u0002f\u0005%TBAA/\u0015\u0011\ty&!\u0019\u0002\u000f5,H/\u00192mK*\u0019\u00111M%\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u0002h\u0005u#aC!se\u0006L()\u001e4gKJ\u00042\u0001UA6\u0013\r\ti'\u0011\u0002\n\u0005\u0006$8\r[%oM>\f\u0001\u0005^3ti\n\u000bGo\u00195B]\u0012\u0014VmY8sI6+G/\u00193bi\u0006|U\u000f\u001e9vi\"\u001a\u0001$a\u001d\u0011\t\u0005m\u0012QO\u0005\u0005\u0003o\niD\u0001\u0003UKN$\u0018\u0001\u0005;fgR\u0004&/\u001b8u\t\u0006$\u0018\rT8hQ\rI\u00121O\u0001\u0018i\u0016\u001cH\u000fR;na&sG-\u001a=NSNl\u0017\r^2iKND3AGA:\u0003]!Xm\u001d;Ek6\u0004H+[7f\u0013:$W\r_#se>\u00148\u000fK\u0002\u001c\u0003g\nabY8v]R\u001cVOY:ue&tw\r\u0006\u0004\u0002\n\u0006=\u00151\u0013\t\u0004\u0011\u0006-\u0015bAAG\u0013\n\u0019\u0011J\u001c;\t\r\u0005EE\u00041\u0001j\u0003\r\u0019HO\u001d\u0005\u0007\u0003+c\u0002\u0019A5\u0002\u0007M,(-\u0001\u0006cCR\u001c\u0007nQ8v]R$B!!#\u0002\u001c\"1\u0011\u0011S\u000fA\u0002%\f1B]3d_J$7i\\;oiR!\u0011\u0011RAQ\u0011\u0019\t\tJ\ba\u0001S\u0006qB/Z:u\tVl\u0007OU3n_R,Gj\\4NKR\fG-\u0019;b\u000b6\u0004H/\u001f\u0015\u0004?\u0005M\u0014A\u000b;fgR$U/\u001c9SK6|G/\u001a'pO6+G/\u00193bi\u0006|e.\u001a*fG>\u0014Hm\u00148f\u0005\u0006$8\r\u001b\u0015\u0004A\u0005M\u0014\u0001\r;fgR$U/\u001c9SK6|G/\u001a'pO6+G/\u00193bi\u0006lU\u000f\u001c;ja2,'+Z2pe\u0012\u001cxJ\\3CCR\u001c\u0007\u000eK\u0002\"\u0003g\nq\u0007^3ti\u0012+X\u000e\u001d*f[>$X\rT8h\u001b\u0016$\u0018\rZ1uC6+H\u000e^5qY\u0016\u0014VmY8sINlU\u000f\u001c;ja2,')\u0019;dQ\u0016\u001c\bf\u0001\u0012\u0002t\u0005qC/Z:u\tVl\u0007OU3n_R,Gj\\4NKR\fG-\u0019;b\u001d>t',\u001a:p'R\f'\u000f^5oO>3gm]3uQ\r\u0019\u00131O\u0001(i\u0016\u001cH\u000fR;naJ+Wn\u001c;f\u0019><W*\u001a;bI\u0006$\u0018mV5uQ\u000e{'O];qi&|g\u000eK\u0002%\u0003g\nA\u0005^3ti\u0012+X\u000e\u001d*f[>$X\rT8h\u001b\u0016$\u0018\rZ1uC&{W\t_2faRLwN\u001c\u0015\u0004K\u0005M\u0014\u0001\n;fgR$U/\u001c9SK6|G/\u001a'pO6+G/\u00193bi\u0006tuNR5mKN4E.Y4)\u0007\u0019\n\u0019(\u0001\u0017uKN$H)^7q%\u0016lw\u000e^3M_\u001elU\r^1eCR\fgj\\*vG\"4\u0015\u000e\\3Fq\u000e,\u0007\u000f^5p]\"\u001aq%a\u001d\u0002/Q,7\u000f\u001e#v[BlU\r^1eCR\f'+Z2pe\u0012\u001c\bf\u0001\u0015\u0002t\u0005AB/Z:u\tVl\u0007/T3uC\u0012\fG/Y*oCB\u001c\bn\u001c;)\u0007%\n\u0019(\u0001\nuKN$H)^7q\u000b6\u0004H/_%oI\u0016D\bf\u0001\u0016\u0002t\u0005\u0011\"/\u001e8Ek6\u0004Hj\\4TK\u001elWM\u001c;t)\rI\u0017q\u001b\u0005\b\u00033\\\u0003\u0019AAn\u0003\u0011\t'oZ:\u0011\t!\u000bi.[\u0005\u0004\u0003?L%!B!se\u0006L\u0018A\b;fgR\u0004&/\u001b8u\t\u0006$\u0018\rT8h!\u0006\u0014H/[1m\u0005\u0006$8\r[3tQ\ra\u00131O\u0001\u0019i\u0016\u001cHo\u00144gg\u0016$8/T3tg\u0006<W\rU1sg\u0016\u0014\bfA\u0017\u0002t\u0005qA/Z:u\u001d\u0016<H)Z2pI\u0016\u0014\bf\u0001\u0018\u0002t\u0005\tC/Z:u\u0007>tg/\u001a:u\t\u0016\u0004(/Z2bi\u0016$G)Z2pI\u0016\u00148\t\\1tg\"\u001aq&a\u001d\u0002#I,\u0017\r\u001a\"bi\u000eDW*\u001a;bI\u0006$\u0018\r\u0006\u0003\u0002v\u0006m\b\u0003\u0002%\u0002x&L1!!?J\u0005\u0019y\u0005\u000f^5p]\"9\u0011Q \u0019A\u0002\u0005}\u0018!\u00027j]\u0016\u001c\b#\u0002B\u0001\u0005\u000bIWB\u0001B\u0002\u0015\tyx+\u0003\u0003\u0003\b\t\r!\u0001\u0004'jgRLE/\u001a:bi>\u0014\u0018a\u0006:fC\u0012\u0004\u0016M\u001d;jC2\u0014\u0015\r^2iKN\u0014\u0015\u0010^3t)\u0019\tII!\u0004\u0003\u0010!9\u0011Q`\u0019A\u0002\u0005}\bb\u0002B\tc\u0001\u0007\u0011\u0011R\u0001\u0006Y&l\u0017\u000e^\u0001\rG>,h\u000e\u001e\"bi\u000eDWm\u001d\u000b\u0005\u0003\u0013\u00139\u0002C\u0004\u0002~J\u0002\r!a@\u0002!I,\u0017\r\u001a\"bi\u000eD'+Z2pe\u0012\u001cH\u0003\u0002B\u000f\u0005_\u0001RAa\b\u0003*%tAA!\t\u0003&9\u0019ANa\t\n\u0003)K1Aa\nJ\u0003\u001d\u0001\u0018mY6bO\u0016LAAa\u000b\u0003.\t\u00191+Z9\u000b\u0007\t\u001d\u0012\nC\u0004\u0002~N\u0002\r!a@\u0002'A\f'o]3NKR\fG-\u0019;b\r&,G\u000eZ:\u0015\t\tU\"1\b\t\u0006U\n]\u0012.[\u0005\u0004\u0005s\u0011(aA'ba\"1!Q\b\u001bA\u0002%\fA\u0001\\5oK\u0006Y\u0012m]:feR$U/\u001c9M_\u001e\u0014VmY8sI6+G/\u00193bi\u0006$B!a\n\u0003D!9\u0011QC\u001bA\u0002\u0005e\u0011a\u0005#v[BdunZ*fO6,g\u000e^:UKN$\bC\u0001)8'\t9t\t\u0006\u0002\u0003H\tYA+Z:u\t\u0016\u001cw\u000eZ3s'\u0011ItI!\u0015\u0011\r\tM#\u0011\fB/\u001b\t\u0011)FC\u0002\u0003X\r\u000b!b]3sS\u0006d\u0017N_3s\u0013\u0011\u0011YF!\u0016\u0003\u000f\u0011+7m\u001c3feB)\u0001*!8\u0003`A\u0019\u0001J!\u0019\n\u0007\t\r\u0014J\u0001\u0003CsR,\u0017!\u00029s_B\u001c\b\u0003\u0002B5\u0005_j!Aa\u001b\u000b\u0007\t54)A\u0003vi&d7/\u0003\u0003\u0003r\t-$\u0001\u0006,fe&4\u0017.\u00192mKB\u0013x\u000e]3si&,7\u000f\u0006\u0003\u0003v\te\u0004c\u0001B<s5\tq\u0007C\u0004\u0003fm\u0002\rAa\u001a\u0002\u0013\u0019\u0014x.\u001c\"zi\u0016\u001cH\u0003\u0002B/\u0005\u007fBqA!!=\u0001\u0004\u0011i&A\u0003csR,7O\u0001\u0014UKN$H)Z2pI\u0016\u0014x+\u001b;i_V$h+\u001a:jM&\f'\r\\3Qe>\u0004XM\u001d;jKN\u001cB!P$\u0003RQ\u0011!\u0011\u0012\t\u0004\u0005ojD\u0003\u0002B/\u0005\u001bCqA!!@\u0001\u0004\u0011i\u0006")
public class DumpLogSegmentsTest {
    private final File tmpDir = TestUtils$.MODULE$.tempDir();
    private final File logDir = TestUtils$.MODULE$.randomPartitionLogDir(this.tmpDir());
    private final String segmentName;
    private final String logFilePath = new StringBuilder(5).append(this.logDir()).append("/").append(this.segmentName()).append(".log").toString();
    private final String snapshotPath = new StringBuilder(43).append(this.logDir()).append("/00000000000000000000-0000000000.checkpoint").toString();
    private final String indexFilePath = new StringBuilder(7).append(this.logDir()).append("/").append(this.segmentName()).append(".index").toString();
    private final String timeIndexFilePath = new StringBuilder(11).append(this.logDir()).append("/").append(this.segmentName()).append(".timeindex").toString();
    private final MockTime time = new MockTime(0L, 0L);
    private UnifiedLog log;

    public File tmpDir() {
        return this.tmpDir;
    }

    public File logDir() {
        return this.logDir;
    }

    public String segmentName() {
        return this.segmentName;
    }

    public String logFilePath() {
        return this.logFilePath;
    }

    public String snapshotPath() {
        return this.snapshotPath;
    }

    public String indexFilePath() {
        return this.indexFilePath;
    }

    public String timeIndexFilePath() {
        return this.timeIndexFilePath;
    }

    public MockTime time() {
        return this.time;
    }

    public UnifiedLog log() {
        return this.log;
    }

    public void log_$eq(UnifiedLog x$1) {
        this.log = x$1;
    }

    @AfterEach
    public void afterEach() {
        Option$.MODULE$.apply((Object)this.log()).foreach((Function1 & Serializable & scala.Serializable)log -> {
            DumpLogSegmentsTest.$anonfun$afterEach$1(log);
            return BoxedUnit.UNIT;
        });
    }

    private UnifiedLog createTestLog() {
        Properties props = new Properties();
        props.setProperty("index.interval.bytes", "128");
        File x$1 = this.logDir();
        LogConfig x$2 = new LogConfig((Map)props);
        long x$3 = 0L;
        long x$4 = 0L;
        MockScheduler x$5 = this.time().scheduler;
        MockTime x$6 = this.time();
        BrokerTopicStats x$7 = new BrokerTopicStats(BrokerTopicStats$.MODULE$.$lessinit$greater$default$1());
        int x$8 = 300000;
        ProducerStateManagerConfig x$9 = new ProducerStateManagerConfig(86400000, false);
        int x$10 = 600000;
        LogDirFailureChannel x$11 = new LogDirFailureChannel(10);
        None$ x$12 = None$.MODULE$;
        boolean x$13 = true;
        boolean x$14 = UnifiedLog$.MODULE$.apply$default$12();
        ConcurrentMap x$15 = UnifiedLog$.MODULE$.apply$default$15();
        boolean x$16 = UnifiedLog$.MODULE$.apply$default$16();
        LogOffsetsListener x$17 = UnifiedLog$.MODULE$.apply$default$17();
        this.log_$eq(UnifiedLog$.MODULE$.apply(x$1, x$2, x$3, x$4, (Scheduler)x$5, x$7, (Time)x$6, x$8, x$9, x$10, x$11, x$14, (Option)x$12, x$13, x$15, x$16, x$17));
        return this.log();
    }

    private void addSimpleRecords(UnifiedLog log, ArrayBuffer<BatchInfo> batches) {
        long now = System.currentTimeMillis();
        IndexedSeq firstBatchRecords = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 10).map((Function1 & Serializable & scala.Serializable)i -> DumpLogSegmentsTest.$anonfun$addSimpleRecords$1(now, BoxesRunTime.unboxToInt((Object)i)), IndexedSeq$.MODULE$.canBuildFrom());
        batches.$plus$eq((Object)new BatchInfo((Seq<SimpleRecord>)firstBatchRecords, true, true));
        IndexedSeq secondBatchRecords = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(10), 30).map((Function1 & Serializable & scala.Serializable)i -> DumpLogSegmentsTest.$anonfun$addSimpleRecords$2(now, BoxesRunTime.unboxToInt((Object)i)), IndexedSeq$.MODULE$.canBuildFrom());
        batches.$plus$eq((Object)new BatchInfo((Seq<SimpleRecord>)secondBatchRecords, true, false));
        IndexedSeq thirdBatchRecords = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(30), 50).map((Function1 & Serializable & scala.Serializable)i -> DumpLogSegmentsTest.$anonfun$addSimpleRecords$3(now, BoxesRunTime.unboxToInt((Object)i)), IndexedSeq$.MODULE$.canBuildFrom());
        batches.$plus$eq((Object)new BatchInfo((Seq<SimpleRecord>)thirdBatchRecords, false, true));
        IndexedSeq fourthBatchRecords = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(50), 60).map((Function1 & Serializable & scala.Serializable)i -> DumpLogSegmentsTest.$anonfun$addSimpleRecords$4(now, BoxesRunTime.unboxToInt((Object)i)), IndexedSeq$.MODULE$.canBuildFrom());
        batches.$plus$eq((Object)new BatchInfo((Seq<SimpleRecord>)fourthBatchRecords, false, false));
        batches.foreach((Function1 & Serializable & scala.Serializable)batchInfo -> log.appendAsLeader(MemoryRecords.withRecords((Compression)Compression.NONE, (int)0, (SimpleRecord[])((SimpleRecord[])batchInfo.records().toArray(ClassTag$.MODULE$.apply(SimpleRecord.class)))), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4(), log.appendAsLeader$default$5(), log.appendAsLeader$default$6()));
        log.flush(false);
    }

    @Test
    public void testBatchAndRecordMetadataOutput() {
        this.log_$eq(this.createTestLog());
        UnifiedLog qual$1 = this.log();
        MemoryRecords x$1 = MemoryRecords.withRecords((Compression)Compression.NONE, (int)0, (SimpleRecord[])new SimpleRecord[]{new SimpleRecord("a".getBytes()), new SimpleRecord("b".getBytes())});
        int x$2 = 0;
        AppendOrigin x$3 = qual$1.appendAsLeader$default$3();
        MetadataVersion x$4 = qual$1.appendAsLeader$default$4();
        RequestLocal x$5 = qual$1.appendAsLeader$default$5();
        VerificationGuard x$6 = qual$1.appendAsLeader$default$6();
        qual$1.appendAsLeader(x$1, x$2, x$3, x$4, x$5, x$6);
        UnifiedLog qual$2 = this.log();
        MemoryRecords x$7 = MemoryRecords.withRecords((Compression)Compression.gzip().build(), (int)0, (SimpleRecord[])new SimpleRecord[]{new SimpleRecord(this.time().milliseconds(), "c".getBytes(), "1".getBytes()), new SimpleRecord("d".getBytes())});
        int x$8 = 3;
        AppendOrigin x$9 = qual$2.appendAsLeader$default$3();
        MetadataVersion x$10 = qual$2.appendAsLeader$default$4();
        RequestLocal x$11 = qual$2.appendAsLeader$default$5();
        VerificationGuard x$12 = qual$2.appendAsLeader$default$6();
        qual$2.appendAsLeader(x$7, x$8, x$9, x$10, x$11, x$12);
        UnifiedLog qual$3 = this.log();
        MemoryRecords x$13 = MemoryRecords.withRecords((Compression)Compression.NONE, (int)0, (SimpleRecord[])new SimpleRecord[]{new SimpleRecord("e".getBytes(), null), new SimpleRecord(null, "f".getBytes()), new SimpleRecord("g".getBytes())});
        int x$14 = 3;
        AppendOrigin x$15 = qual$3.appendAsLeader$default$3();
        MetadataVersion x$16 = qual$3.appendAsLeader$default$4();
        RequestLocal x$17 = qual$3.appendAsLeader$default$5();
        VerificationGuard x$18 = qual$3.appendAsLeader$default$6();
        qual$3.appendAsLeader(x$13, x$14, x$15, x$16, x$17, x$18);
        UnifiedLog qual$4 = this.log();
        MemoryRecords x$19 = MemoryRecords.withIdempotentRecords((Compression)Compression.NONE, (long)29342342L, (short)((short)15), (int)234123, (SimpleRecord[])new SimpleRecord[]{new SimpleRecord("h".getBytes())});
        int x$20 = 3;
        AppendOrigin x$21 = qual$4.appendAsLeader$default$3();
        MetadataVersion x$22 = qual$4.appendAsLeader$default$4();
        RequestLocal x$23 = qual$4.appendAsLeader$default$5();
        VerificationGuard x$24 = qual$4.appendAsLeader$default$6();
        qual$4.appendAsLeader(x$19, x$20, x$21, x$22, x$23, x$24);
        UnifiedLog qual$5 = this.log();
        MemoryRecords x$25 = MemoryRecords.withTransactionalRecords((Compression)Compression.gzip().build(), (long)98323L, (short)((short)99), (int)266, (SimpleRecord[])new SimpleRecord[]{new SimpleRecord("i".getBytes()), new SimpleRecord("j".getBytes())});
        int x$26 = 5;
        AppendOrigin x$27 = qual$5.appendAsLeader$default$3();
        MetadataVersion x$28 = qual$5.appendAsLeader$default$4();
        RequestLocal x$29 = qual$5.appendAsLeader$default$5();
        VerificationGuard x$30 = qual$5.appendAsLeader$default$6();
        qual$5.appendAsLeader(x$25, x$26, x$27, x$28, x$29, x$30);
        UnifiedLog qual$6 = this.log();
        MemoryRecords x$31 = MemoryRecords.withEndTransactionMarker((long)98323L, (short)((short)99), (EndTransactionMarker)new EndTransactionMarker(ControlRecordType.COMMIT, 100));
        AppendOrigin x$32 = AppendOrigin.COORDINATOR;
        int x$33 = 7;
        MetadataVersion x$34 = qual$6.appendAsLeader$default$4();
        RequestLocal x$35 = qual$6.appendAsLeader$default$5();
        VerificationGuard x$36 = qual$6.appendAsLeader$default$6();
        qual$6.appendAsLeader(x$31, x$33, x$32, x$34, x$35, x$36);
        this.assertDumpLogRecordMetadata(this.log());
    }

    @Test
    public void testPrintDataLog() {
        this.log_$eq(this.createTestLog());
        ArrayBuffer batches = new ArrayBuffer();
        this.addSimpleRecords(this.log(), (ArrayBuffer<BatchInfo>)batches);
        this.verifyRecordsInOutput$1(true, (String[])((Object[])new String[]{"--print-data-log", "--files", this.logFilePath()}), batches);
        this.verifyRecordsInOutput$1(true, (String[])((Object[])new String[]{"--print-data-log", "--deep-iteration", "--files", this.logFilePath()}), batches);
        this.verifyRecordsInOutput$1(true, (String[])((Object[])new String[]{"--value-decoder-class", "kafka.serializer.StringDecoder", "--files", this.logFilePath()}), batches);
        this.verifyRecordsInOutput$1(true, (String[])((Object[])new String[]{"--key-decoder-class", "kafka.serializer.StringDecoder", "--files", this.logFilePath()}), batches);
        this.verifyRecordsInOutput$1(false, (String[])((Object[])new String[]{"--deep-iteration", "--files", this.logFilePath()}), batches);
        this.verifyNoRecordsInOutput$1((String[])((Object[])new String[]{"--files", this.logFilePath()}));
    }

    @Test
    public void testDumpIndexMismatches() {
        this.log_$eq(this.createTestLog());
        ArrayBuffer batches = new ArrayBuffer();
        this.addSimpleRecords(this.log(), (ArrayBuffer<BatchInfo>)batches);
        scala.collection.mutable.Map offsetMismatches = (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
        DumpLogSegments$.MODULE$.dumpIndex(new File(this.indexFilePath()), false, true, offsetMismatches, Integer.MAX_VALUE);
        Assertions.assertEquals((Object)Predef$.MODULE$.Map().empty(), (Object)offsetMismatches);
    }

    @Test
    public void testDumpTimeIndexErrors() {
        this.log_$eq(this.createTestLog());
        ArrayBuffer batches = new ArrayBuffer();
        this.addSimpleRecords(this.log(), (ArrayBuffer<BatchInfo>)batches);
        DumpLogSegments.TimeIndexDumpErrors errors = new DumpLogSegments.TimeIndexDumpErrors();
        DumpLogSegments$.MODULE$.dumpTimeIndex(new File(this.timeIndexFilePath()), false, true, errors);
        Assertions.assertEquals((Object)Predef$.MODULE$.Map().empty(), (Object)errors.misMatchesForTimeIndexFilesMap());
        Assertions.assertEquals((Object)Predef$.MODULE$.Map().empty(), (Object)errors.outOfOrderTimestamp());
        Assertions.assertEquals((Object)Predef$.MODULE$.Map().empty(), (Object)errors.shallowOffsetNotFound());
    }

    public int countSubstring(String str, String sub) {
        return new StringOps(Predef$.MODULE$.augmentString(str)).sliding(sub.length()).count((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)DumpLogSegmentsTest.$anonfun$countSubstring$1(sub, x$3)));
    }

    public int batchCount(String str) {
        return this.countSubstring(str, "baseOffset:");
    }

    public int recordCount(String str) {
        return this.countSubstring(str, "payload:");
    }

    @Test
    public void testDumpRemoteLogMetadataEmpty() {
        int x$1 = 0x100000;
        long x$2 = LogTestUtils$.MODULE$.createLogConfig$default$1();
        long x$3 = LogTestUtils$.MODULE$.createLogConfig$default$3();
        long x$4 = LogTestUtils$.MODULE$.createLogConfig$default$4();
        long x$5 = LogTestUtils$.MODULE$.createLogConfig$default$5();
        long x$6 = LogTestUtils$.MODULE$.createLogConfig$default$6();
        long x$7 = LogTestUtils$.MODULE$.createLogConfig$default$7();
        String x$8 = LogTestUtils$.MODULE$.createLogConfig$default$8();
        int x$9 = LogTestUtils$.MODULE$.createLogConfig$default$9();
        int x$10 = LogTestUtils$.MODULE$.createLogConfig$default$10();
        int x$11 = LogTestUtils$.MODULE$.createLogConfig$default$11();
        long x$12 = LogTestUtils$.MODULE$.createLogConfig$default$12();
        boolean x$13 = LogTestUtils$.MODULE$.createLogConfig$default$13();
        boolean x$14 = LogTestUtils$.MODULE$.createLogConfig$default$14();
        boolean x$15 = LogTestUtils$.MODULE$.createLogConfig$default$15();
        LogConfig logConfig = LogTestUtils$.MODULE$.createLogConfig(x$2, x$1, x$3, x$4, x$5, x$6, x$7, x$8, x$9, x$10, x$11, x$12, x$13, x$14, x$15);
        this.log_$eq(LogTestUtils$.MODULE$.createLog(this.logDir(), logConfig, new BrokerTopicStats(BrokerTopicStats$.MODULE$.$lessinit$greater$default$1()), (Scheduler)this.time().scheduler, (Time)this.time(), LogTestUtils$.MODULE$.createLog$default$6(), LogTestUtils$.MODULE$.createLog$default$7(), LogTestUtils$.MODULE$.createLog$default$8(), LogTestUtils$.MODULE$.createLog$default$9(), LogTestUtils$.MODULE$.createLog$default$10(), LogTestUtils$.MODULE$.createLog$default$11(), LogTestUtils$.MODULE$.createLog$default$12(), LogTestUtils$.MODULE$.createLog$default$13(), LogTestUtils$.MODULE$.createLog$default$14(), LogTestUtils$.MODULE$.createLog$default$15(), LogTestUtils$.MODULE$.createLog$default$16(), LogTestUtils$.MODULE$.createLog$default$17()));
        String output = this.runDumpLogSegments((String[])((Object[])new String[]{"--remote-log-metadata-decoder", "--files", this.logFilePath()}));
        Assertions.assertTrue((this.batchCount(output) == 0 ? 1 : 0) != 0);
        Assertions.assertTrue((this.recordCount(output) == 0 ? 1 : 0) != 0);
        Assertions.assertTrue((boolean)output.contains("Log starting offset: 0"));
    }

    @Test
    public void testDumpRemoteLogMetadataOneRecordOneBatch() {
        Uuid topicId = Uuid.randomUuid();
        String topicName = "foo";
        SimpleRecord[] records = (SimpleRecord[])((TraversableOnce)new .colon.colon((Object)new RemotePartitionDeleteMetadata(new TopicIdPartition(topicId, new TopicPartition(topicName, 0)), RemotePartitionDeleteState.DELETE_PARTITION_MARKED, this.time().milliseconds(), 0), (List)Nil$.MODULE$).map((Function1 & Serializable & scala.Serializable)message -> new SimpleRecord(null, new RemoteLogMetadataSerde().serialize((RemoteLogMetadata)message)), Seq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(SimpleRecord.class));
        int x$1 = 0x100000;
        long x$2 = LogTestUtils$.MODULE$.createLogConfig$default$1();
        long x$3 = LogTestUtils$.MODULE$.createLogConfig$default$3();
        long x$4 = LogTestUtils$.MODULE$.createLogConfig$default$4();
        long x$5 = LogTestUtils$.MODULE$.createLogConfig$default$5();
        long x$6 = LogTestUtils$.MODULE$.createLogConfig$default$6();
        long x$7 = LogTestUtils$.MODULE$.createLogConfig$default$7();
        String x$8 = LogTestUtils$.MODULE$.createLogConfig$default$8();
        int x$9 = LogTestUtils$.MODULE$.createLogConfig$default$9();
        int x$10 = LogTestUtils$.MODULE$.createLogConfig$default$10();
        int x$11 = LogTestUtils$.MODULE$.createLogConfig$default$11();
        long x$12 = LogTestUtils$.MODULE$.createLogConfig$default$12();
        boolean x$13 = LogTestUtils$.MODULE$.createLogConfig$default$13();
        boolean x$14 = LogTestUtils$.MODULE$.createLogConfig$default$14();
        boolean x$15 = LogTestUtils$.MODULE$.createLogConfig$default$15();
        LogConfig logConfig = LogTestUtils$.MODULE$.createLogConfig(x$2, x$1, x$3, x$4, x$5, x$6, x$7, x$8, x$9, x$10, x$11, x$12, x$13, x$14, x$15);
        this.log_$eq(LogTestUtils$.MODULE$.createLog(this.logDir(), logConfig, new BrokerTopicStats(BrokerTopicStats$.MODULE$.$lessinit$greater$default$1()), (Scheduler)this.time().scheduler, (Time)this.time(), LogTestUtils$.MODULE$.createLog$default$6(), LogTestUtils$.MODULE$.createLog$default$7(), LogTestUtils$.MODULE$.createLog$default$8(), LogTestUtils$.MODULE$.createLog$default$9(), LogTestUtils$.MODULE$.createLog$default$10(), LogTestUtils$.MODULE$.createLog$default$11(), LogTestUtils$.MODULE$.createLog$default$12(), LogTestUtils$.MODULE$.createLog$default$13(), LogTestUtils$.MODULE$.createLog$default$14(), LogTestUtils$.MODULE$.createLog$default$15(), LogTestUtils$.MODULE$.createLog$default$16(), LogTestUtils$.MODULE$.createLog$default$17()));
        UnifiedLog qual$1 = this.log();
        MemoryRecords x$16 = MemoryRecords.withRecords((Compression)Compression.NONE, (SimpleRecord[])records);
        int x$17 = 0;
        AppendOrigin x$18 = qual$1.appendAsLeader$default$3();
        MetadataVersion x$19 = qual$1.appendAsLeader$default$4();
        RequestLocal x$20 = qual$1.appendAsLeader$default$5();
        VerificationGuard x$21 = qual$1.appendAsLeader$default$6();
        qual$1.appendAsLeader(x$16, x$17, x$18, x$19, x$20, x$21);
        this.log().flush(false);
        String expectedDeletePayload = String.format("RemotePartitionDeleteMetadata{topicPartition=%s:%s-0, state=DELETE_PARTITION_MARKED, eventTimestampMs=0, brokerId=0}", topicId, topicName);
        String output = this.runDumpLogSegments((String[])((Object[])new String[]{"--remote-log-metadata-decoder", "--files", this.logFilePath()}));
        Assertions.assertTrue((this.batchCount(output) == 1 ? 1 : 0) != 0);
        Assertions.assertTrue((this.recordCount(output) == 1 ? 1 : 0) != 0);
        Assertions.assertTrue((boolean)output.contains("Log starting offset: 0"));
        Assertions.assertTrue((boolean)output.contains(expectedDeletePayload));
    }

    @Test
    public void testDumpRemoteLogMetadataMultipleRecordsOneBatch() {
        Uuid topicId = Uuid.randomUuid();
        String topicName = "foo";
        Uuid remoteSegmentId = Uuid.randomUuid();
        TopicIdPartition topicIdPartition = new TopicIdPartition(topicId, new TopicPartition(topicName, 0));
        RemoteLogSegmentId remoteLogSegmentId = new RemoteLogSegmentId(topicIdPartition, remoteSegmentId);
        SimpleRecord[] metadataRecords = (SimpleRecord[])((TraversableOnce)new .colon.colon((Object)new RemoteLogSegmentMetadataUpdate(remoteLogSegmentId, this.time().milliseconds(), Optional.of(new RemoteLogSegmentMetadata.CustomMetadata((byte[])Array$.MODULE$.apply((Seq)Predef$.MODULE$.wrapByteArray(new byte[]{0, 1, 2, 3}), ClassTag$.MODULE$.Byte()))), RemoteLogSegmentState.COPY_SEGMENT_FINISHED, 0), (List)new .colon.colon((Object)new RemotePartitionDeleteMetadata(topicIdPartition, RemotePartitionDeleteState.DELETE_PARTITION_MARKED, this.time().milliseconds(), 0), (List)Nil$.MODULE$)).map((Function1 & Serializable & scala.Serializable)message -> new SimpleRecord(null, new RemoteLogMetadataSerde().serialize(message)), Seq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(SimpleRecord.class));
        int x$1 = 0x100000;
        long x$2 = LogTestUtils$.MODULE$.createLogConfig$default$1();
        long x$3 = LogTestUtils$.MODULE$.createLogConfig$default$3();
        long x$4 = LogTestUtils$.MODULE$.createLogConfig$default$4();
        long x$5 = LogTestUtils$.MODULE$.createLogConfig$default$5();
        long x$6 = LogTestUtils$.MODULE$.createLogConfig$default$6();
        long x$7 = LogTestUtils$.MODULE$.createLogConfig$default$7();
        String x$8 = LogTestUtils$.MODULE$.createLogConfig$default$8();
        int x$9 = LogTestUtils$.MODULE$.createLogConfig$default$9();
        int x$10 = LogTestUtils$.MODULE$.createLogConfig$default$10();
        int x$11 = LogTestUtils$.MODULE$.createLogConfig$default$11();
        long x$12 = LogTestUtils$.MODULE$.createLogConfig$default$12();
        boolean x$13 = LogTestUtils$.MODULE$.createLogConfig$default$13();
        boolean x$14 = LogTestUtils$.MODULE$.createLogConfig$default$14();
        boolean x$15 = LogTestUtils$.MODULE$.createLogConfig$default$15();
        LogConfig logConfig = LogTestUtils$.MODULE$.createLogConfig(x$2, x$1, x$3, x$4, x$5, x$6, x$7, x$8, x$9, x$10, x$11, x$12, x$13, x$14, x$15);
        this.log_$eq(LogTestUtils$.MODULE$.createLog(this.logDir(), logConfig, new BrokerTopicStats(BrokerTopicStats$.MODULE$.$lessinit$greater$default$1()), (Scheduler)this.time().scheduler, (Time)this.time(), LogTestUtils$.MODULE$.createLog$default$6(), LogTestUtils$.MODULE$.createLog$default$7(), LogTestUtils$.MODULE$.createLog$default$8(), LogTestUtils$.MODULE$.createLog$default$9(), LogTestUtils$.MODULE$.createLog$default$10(), LogTestUtils$.MODULE$.createLog$default$11(), LogTestUtils$.MODULE$.createLog$default$12(), LogTestUtils$.MODULE$.createLog$default$13(), LogTestUtils$.MODULE$.createLog$default$14(), LogTestUtils$.MODULE$.createLog$default$15(), LogTestUtils$.MODULE$.createLog$default$16(), LogTestUtils$.MODULE$.createLog$default$17()));
        UnifiedLog qual$1 = this.log();
        MemoryRecords x$16 = MemoryRecords.withRecords((Compression)Compression.NONE, (SimpleRecord[])metadataRecords);
        int x$17 = 0;
        AppendOrigin x$18 = qual$1.appendAsLeader$default$3();
        MetadataVersion x$19 = qual$1.appendAsLeader$default$4();
        RequestLocal x$20 = qual$1.appendAsLeader$default$5();
        VerificationGuard x$21 = qual$1.appendAsLeader$default$6();
        qual$1.appendAsLeader(x$16, x$17, x$18, x$19, x$20, x$21);
        this.log().flush(false);
        String expectedUpdatePayload = String.format("RemoteLogSegmentMetadataUpdate{remoteLogSegmentId=RemoteLogSegmentId{topicIdPartition=%s:%s-0, id=%s}, customMetadata=Optional[CustomMetadata{4 bytes}], state=COPY_SEGMENT_FINISHED, eventTimestampMs=0, brokerId=0}", topicId, topicName, remoteSegmentId);
        String expectedDeletePayload = String.format("RemotePartitionDeleteMetadata{topicPartition=%s:%s-0, state=DELETE_PARTITION_MARKED, eventTimestampMs=0, brokerId=0}", topicId, topicName);
        String output = this.runDumpLogSegments((String[])((Object[])new String[]{"--remote-log-metadata-decoder", "--files", this.logFilePath()}));
        Assertions.assertTrue((this.batchCount(output) == 1 ? 1 : 0) != 0);
        Assertions.assertTrue((this.recordCount(output) == 2 ? 1 : 0) != 0);
        Assertions.assertTrue((boolean)output.contains("Log starting offset: 0"));
        Assertions.assertTrue((boolean)output.contains(expectedUpdatePayload));
        Assertions.assertTrue((boolean)output.contains(expectedDeletePayload));
    }

    @Test
    public void testDumpRemoteLogMetadataMultipleRecordsMultipleBatches() {
        Uuid topicId = Uuid.randomUuid();
        String topicName = "foo";
        Uuid remoteSegmentId = Uuid.randomUuid();
        TopicIdPartition topicIdPartition = new TopicIdPartition(topicId, new TopicPartition(topicName, 0));
        RemoteLogSegmentId remoteLogSegmentId = new RemoteLogSegmentId(topicIdPartition, remoteSegmentId);
        SimpleRecord[] records = (SimpleRecord[])((TraversableOnce)new .colon.colon((Object)new RemoteLogSegmentMetadataUpdate(remoteLogSegmentId, this.time().milliseconds(), Optional.of(new RemoteLogSegmentMetadata.CustomMetadata((byte[])Array$.MODULE$.apply((Seq)Predef$.MODULE$.wrapByteArray(new byte[]{0, 1, 2, 3}), ClassTag$.MODULE$.Byte()))), RemoteLogSegmentState.COPY_SEGMENT_FINISHED, 0), (List)new .colon.colon((Object)new RemotePartitionDeleteMetadata(topicIdPartition, RemotePartitionDeleteState.DELETE_PARTITION_MARKED, this.time().milliseconds(), 0), (List)Nil$.MODULE$)).map((Function1 & Serializable & scala.Serializable)message -> new SimpleRecord(null, new RemoteLogMetadataSerde().serialize(message)), Seq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(SimpleRecord.class));
        int x$1 = 0x100000;
        long x$2 = LogTestUtils$.MODULE$.createLogConfig$default$1();
        long x$3 = LogTestUtils$.MODULE$.createLogConfig$default$3();
        long x$4 = LogTestUtils$.MODULE$.createLogConfig$default$4();
        long x$5 = LogTestUtils$.MODULE$.createLogConfig$default$5();
        long x$6 = LogTestUtils$.MODULE$.createLogConfig$default$6();
        long x$7 = LogTestUtils$.MODULE$.createLogConfig$default$7();
        String x$8 = LogTestUtils$.MODULE$.createLogConfig$default$8();
        int x$9 = LogTestUtils$.MODULE$.createLogConfig$default$9();
        int x$10 = LogTestUtils$.MODULE$.createLogConfig$default$10();
        int x$11 = LogTestUtils$.MODULE$.createLogConfig$default$11();
        long x$12 = LogTestUtils$.MODULE$.createLogConfig$default$12();
        boolean x$13 = LogTestUtils$.MODULE$.createLogConfig$default$13();
        boolean x$14 = LogTestUtils$.MODULE$.createLogConfig$default$14();
        boolean x$15 = LogTestUtils$.MODULE$.createLogConfig$default$15();
        LogConfig logConfig = LogTestUtils$.MODULE$.createLogConfig(x$2, x$1, x$3, x$4, x$5, x$6, x$7, x$8, x$9, x$10, x$11, x$12, x$13, x$14, x$15);
        this.log_$eq(LogTestUtils$.MODULE$.createLog(this.logDir(), logConfig, new BrokerTopicStats(BrokerTopicStats$.MODULE$.$lessinit$greater$default$1()), (Scheduler)this.time().scheduler, (Time)this.time(), LogTestUtils$.MODULE$.createLog$default$6(), LogTestUtils$.MODULE$.createLog$default$7(), LogTestUtils$.MODULE$.createLog$default$8(), LogTestUtils$.MODULE$.createLog$default$9(), LogTestUtils$.MODULE$.createLog$default$10(), LogTestUtils$.MODULE$.createLog$default$11(), LogTestUtils$.MODULE$.createLog$default$12(), LogTestUtils$.MODULE$.createLog$default$13(), LogTestUtils$.MODULE$.createLog$default$14(), LogTestUtils$.MODULE$.createLog$default$15(), LogTestUtils$.MODULE$.createLog$default$16(), LogTestUtils$.MODULE$.createLog$default$17()));
        UnifiedLog qual$1 = this.log();
        MemoryRecords x$16 = MemoryRecords.withRecords((Compression)Compression.NONE, (SimpleRecord[])records);
        int x$17 = 0;
        AppendOrigin x$18 = qual$1.appendAsLeader$default$3();
        MetadataVersion x$19 = qual$1.appendAsLeader$default$4();
        RequestLocal x$20 = qual$1.appendAsLeader$default$5();
        VerificationGuard x$21 = qual$1.appendAsLeader$default$6();
        qual$1.appendAsLeader(x$16, x$17, x$18, x$19, x$20, x$21);
        UnifiedLog qual$2 = this.log();
        MemoryRecords x$22 = MemoryRecords.withRecords((Compression)Compression.NONE, (SimpleRecord[])records);
        int x$23 = 0;
        AppendOrigin x$24 = qual$2.appendAsLeader$default$3();
        MetadataVersion x$25 = qual$2.appendAsLeader$default$4();
        RequestLocal x$26 = qual$2.appendAsLeader$default$5();
        VerificationGuard x$27 = qual$2.appendAsLeader$default$6();
        qual$2.appendAsLeader(x$22, x$23, x$24, x$25, x$26, x$27);
        this.log().flush(false);
        String expectedUpdatePayload = String.format("RemoteLogSegmentMetadataUpdate{remoteLogSegmentId=RemoteLogSegmentId{topicIdPartition=%s:%s-0, id=%s}, customMetadata=Optional[CustomMetadata{4 bytes}], state=COPY_SEGMENT_FINISHED, eventTimestampMs=0, brokerId=0}", topicId, topicName, remoteSegmentId);
        String expectedDeletePayload = String.format("RemotePartitionDeleteMetadata{topicPartition=%s:%s-0, state=DELETE_PARTITION_MARKED, eventTimestampMs=0, brokerId=0}", topicId, topicName);
        String output = this.runDumpLogSegments((String[])((Object[])new String[]{"--remote-log-metadata-decoder", "--files", this.logFilePath()}));
        Assertions.assertTrue((this.batchCount(output) == 2 ? 1 : 0) != 0);
        Assertions.assertTrue((this.recordCount(output) == 4 ? 1 : 0) != 0);
        Assertions.assertTrue((boolean)output.contains("Log starting offset: 0"));
        Assertions.assertTrue((this.countSubstring(output, expectedUpdatePayload) == 2 ? 1 : 0) != 0);
        Assertions.assertTrue((this.countSubstring(output, expectedDeletePayload) == 2 ? 1 : 0) != 0);
    }

    @Test
    public void testDumpRemoteLogMetadataNonZeroStartingOffset() {
        Uuid topicId = Uuid.randomUuid();
        String topicName = "foo";
        SimpleRecord[] metadataRecords = (SimpleRecord[])((TraversableOnce)new .colon.colon((Object)new RemotePartitionDeleteMetadata(new TopicIdPartition(topicId, new TopicPartition(topicName, 0)), RemotePartitionDeleteState.DELETE_PARTITION_MARKED, this.time().milliseconds(), 0), (List)Nil$.MODULE$).map((Function1 & Serializable & scala.Serializable)message -> new SimpleRecord(null, new RemoteLogMetadataSerde().serialize((RemoteLogMetadata)message)), Seq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(SimpleRecord.class));
        int x$1 = 0x100000;
        long x$2 = LogTestUtils$.MODULE$.createLogConfig$default$1();
        long x$3 = LogTestUtils$.MODULE$.createLogConfig$default$3();
        long x$4 = LogTestUtils$.MODULE$.createLogConfig$default$4();
        long x$5 = LogTestUtils$.MODULE$.createLogConfig$default$5();
        long x$6 = LogTestUtils$.MODULE$.createLogConfig$default$6();
        long x$7 = LogTestUtils$.MODULE$.createLogConfig$default$7();
        String x$8 = LogTestUtils$.MODULE$.createLogConfig$default$8();
        int x$9 = LogTestUtils$.MODULE$.createLogConfig$default$9();
        int x$10 = LogTestUtils$.MODULE$.createLogConfig$default$10();
        int x$11 = LogTestUtils$.MODULE$.createLogConfig$default$11();
        long x$12 = LogTestUtils$.MODULE$.createLogConfig$default$12();
        boolean x$13 = LogTestUtils$.MODULE$.createLogConfig$default$13();
        boolean x$14 = LogTestUtils$.MODULE$.createLogConfig$default$14();
        boolean x$15 = LogTestUtils$.MODULE$.createLogConfig$default$15();
        LogConfig logConfig = LogTestUtils$.MODULE$.createLogConfig(x$2, x$1, x$3, x$4, x$5, x$6, x$7, x$8, x$9, x$10, x$11, x$12, x$13, x$14, x$15);
        this.log_$eq(LogTestUtils$.MODULE$.createLog(this.logDir(), logConfig, new BrokerTopicStats(BrokerTopicStats$.MODULE$.$lessinit$greater$default$1()), (Scheduler)this.time().scheduler, (Time)this.time(), LogTestUtils$.MODULE$.createLog$default$6(), LogTestUtils$.MODULE$.createLog$default$7(), LogTestUtils$.MODULE$.createLog$default$8(), LogTestUtils$.MODULE$.createLog$default$9(), LogTestUtils$.MODULE$.createLog$default$10(), LogTestUtils$.MODULE$.createLog$default$11(), LogTestUtils$.MODULE$.createLog$default$12(), LogTestUtils$.MODULE$.createLog$default$13(), LogTestUtils$.MODULE$.createLog$default$14(), LogTestUtils$.MODULE$.createLog$default$15(), LogTestUtils$.MODULE$.createLog$default$16(), LogTestUtils$.MODULE$.createLog$default$17()));
        UnifiedLog qual$1 = this.log();
        MemoryRecords x$16 = MemoryRecords.withRecords((Compression)Compression.NONE, (SimpleRecord[])metadataRecords);
        int x$17 = 0;
        AppendOrigin x$18 = qual$1.appendAsLeader$default$3();
        MetadataVersion x$19 = qual$1.appendAsLeader$default$4();
        RequestLocal x$20 = qual$1.appendAsLeader$default$5();
        VerificationGuard x$21 = qual$1.appendAsLeader$default$6();
        qual$1.appendAsLeader(x$16, x$17, x$18, x$19, x$20, x$21);
        UnifiedLog qual$2 = this.log();
        Option x$22 = qual$2.roll$default$1();
        LogSegment secondSegment = qual$2.roll(x$22);
        secondSegment.append(1L, -1L, 1L, MemoryRecords.withRecords((Compression)Compression.NONE, (SimpleRecord[])metadataRecords));
        secondSegment.flush();
        this.log().flush(true);
        String expectedDeletePayload = String.format("RemotePartitionDeleteMetadata{topicPartition=%s:%s-0, state=DELETE_PARTITION_MARKED, eventTimestampMs=0, brokerId=0}", topicId, topicName);
        String output = this.runDumpLogSegments((String[])((Object[])new String[]{"--remote-log-metadata-decoder", "--files", secondSegment.log().file().getAbsolutePath()}));
        Assertions.assertTrue((this.batchCount(output) == 1 ? 1 : 0) != 0);
        Assertions.assertTrue((this.recordCount(output) == 1 ? 1 : 0) != 0);
        Assertions.assertTrue((boolean)output.contains("Log starting offset: 1"));
        Assertions.assertTrue((boolean)output.contains(expectedDeletePayload));
    }

    @Test
    public void testDumpRemoteLogMetadataWithCorruption() {
        SimpleRecord[] metadataRecords = (SimpleRecord[])((Object[])new SimpleRecord[]{new SimpleRecord(null, "corrupted".getBytes())});
        int x$1 = 0x100000;
        long x$2 = LogTestUtils$.MODULE$.createLogConfig$default$1();
        long x$3 = LogTestUtils$.MODULE$.createLogConfig$default$3();
        long x$4 = LogTestUtils$.MODULE$.createLogConfig$default$4();
        long x$5 = LogTestUtils$.MODULE$.createLogConfig$default$5();
        long x$6 = LogTestUtils$.MODULE$.createLogConfig$default$6();
        long x$7 = LogTestUtils$.MODULE$.createLogConfig$default$7();
        String x$8 = LogTestUtils$.MODULE$.createLogConfig$default$8();
        int x$9 = LogTestUtils$.MODULE$.createLogConfig$default$9();
        int x$10 = LogTestUtils$.MODULE$.createLogConfig$default$10();
        int x$11 = LogTestUtils$.MODULE$.createLogConfig$default$11();
        long x$12 = LogTestUtils$.MODULE$.createLogConfig$default$12();
        boolean x$13 = LogTestUtils$.MODULE$.createLogConfig$default$13();
        boolean x$14 = LogTestUtils$.MODULE$.createLogConfig$default$14();
        boolean x$15 = LogTestUtils$.MODULE$.createLogConfig$default$15();
        LogConfig logConfig = LogTestUtils$.MODULE$.createLogConfig(x$2, x$1, x$3, x$4, x$5, x$6, x$7, x$8, x$9, x$10, x$11, x$12, x$13, x$14, x$15);
        this.log_$eq(LogTestUtils$.MODULE$.createLog(this.logDir(), logConfig, new BrokerTopicStats(BrokerTopicStats$.MODULE$.$lessinit$greater$default$1()), (Scheduler)this.time().scheduler, (Time)this.time(), LogTestUtils$.MODULE$.createLog$default$6(), LogTestUtils$.MODULE$.createLog$default$7(), LogTestUtils$.MODULE$.createLog$default$8(), LogTestUtils$.MODULE$.createLog$default$9(), LogTestUtils$.MODULE$.createLog$default$10(), LogTestUtils$.MODULE$.createLog$default$11(), LogTestUtils$.MODULE$.createLog$default$12(), LogTestUtils$.MODULE$.createLog$default$13(), LogTestUtils$.MODULE$.createLog$default$14(), LogTestUtils$.MODULE$.createLog$default$15(), LogTestUtils$.MODULE$.createLog$default$16(), LogTestUtils$.MODULE$.createLog$default$17()));
        UnifiedLog qual$1 = this.log();
        MemoryRecords x$16 = MemoryRecords.withRecords((Compression)Compression.NONE, (SimpleRecord[])metadataRecords);
        int x$17 = 0;
        AppendOrigin x$18 = qual$1.appendAsLeader$default$3();
        MetadataVersion x$19 = qual$1.appendAsLeader$default$4();
        RequestLocal x$20 = qual$1.appendAsLeader$default$5();
        VerificationGuard x$21 = qual$1.appendAsLeader$default$6();
        qual$1.appendAsLeader(x$16, x$17, x$18, x$19, x$20, x$21);
        this.log().flush(false);
        String output = this.runDumpLogSegments((String[])((Object[])new String[]{"--remote-log-metadata-decoder", "--files", this.logFilePath()}));
        Assertions.assertTrue((this.batchCount(output) == 1 ? 1 : 0) != 0);
        Assertions.assertTrue((this.recordCount(output) == 1 ? 1 : 0) != 0);
        Assertions.assertTrue((boolean)output.contains("Log starting offset: 0"));
        Assertions.assertTrue((boolean)output.contains("Could not deserialize metadata record"));
    }

    @Test
    public void testDumpRemoteLogMetadataIoException() {
        Uuid topicId = Uuid.randomUuid();
        String topicName = "foo";
        SimpleRecord[] metadataRecords = (SimpleRecord[])((TraversableOnce)new .colon.colon((Object)new RemotePartitionDeleteMetadata(new TopicIdPartition(topicId, new TopicPartition(topicName, 0)), RemotePartitionDeleteState.DELETE_PARTITION_MARKED, this.time().milliseconds(), 0), (List)Nil$.MODULE$).map((Function1 & Serializable & scala.Serializable)message -> new SimpleRecord(null, new RemoteLogMetadataSerde().serialize((RemoteLogMetadata)message)), Seq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(SimpleRecord.class));
        int x$1 = 0x100000;
        long x$2 = LogTestUtils$.MODULE$.createLogConfig$default$1();
        long x$3 = LogTestUtils$.MODULE$.createLogConfig$default$3();
        long x$4 = LogTestUtils$.MODULE$.createLogConfig$default$4();
        long x$5 = LogTestUtils$.MODULE$.createLogConfig$default$5();
        long x$6 = LogTestUtils$.MODULE$.createLogConfig$default$6();
        long x$7 = LogTestUtils$.MODULE$.createLogConfig$default$7();
        String x$8 = LogTestUtils$.MODULE$.createLogConfig$default$8();
        int x$9 = LogTestUtils$.MODULE$.createLogConfig$default$9();
        int x$10 = LogTestUtils$.MODULE$.createLogConfig$default$10();
        int x$11 = LogTestUtils$.MODULE$.createLogConfig$default$11();
        long x$12 = LogTestUtils$.MODULE$.createLogConfig$default$12();
        boolean x$13 = LogTestUtils$.MODULE$.createLogConfig$default$13();
        boolean x$14 = LogTestUtils$.MODULE$.createLogConfig$default$14();
        boolean x$15 = LogTestUtils$.MODULE$.createLogConfig$default$15();
        LogConfig logConfig = LogTestUtils$.MODULE$.createLogConfig(x$2, x$1, x$3, x$4, x$5, x$6, x$7, x$8, x$9, x$10, x$11, x$12, x$13, x$14, x$15);
        this.log_$eq(LogTestUtils$.MODULE$.createLog(this.logDir(), logConfig, new BrokerTopicStats(BrokerTopicStats$.MODULE$.$lessinit$greater$default$1()), (Scheduler)this.time().scheduler, (Time)this.time(), LogTestUtils$.MODULE$.createLog$default$6(), LogTestUtils$.MODULE$.createLog$default$7(), LogTestUtils$.MODULE$.createLog$default$8(), LogTestUtils$.MODULE$.createLog$default$9(), LogTestUtils$.MODULE$.createLog$default$10(), LogTestUtils$.MODULE$.createLog$default$11(), LogTestUtils$.MODULE$.createLog$default$12(), LogTestUtils$.MODULE$.createLog$default$13(), LogTestUtils$.MODULE$.createLog$default$14(), LogTestUtils$.MODULE$.createLog$default$15(), LogTestUtils$.MODULE$.createLog$default$16(), LogTestUtils$.MODULE$.createLog$default$17()));
        UnifiedLog qual$1 = this.log();
        MemoryRecords x$16 = MemoryRecords.withRecords((Compression)Compression.NONE, (SimpleRecord[])metadataRecords);
        int x$17 = 0;
        AppendOrigin x$18 = qual$1.appendAsLeader$default$3();
        MetadataVersion x$19 = qual$1.appendAsLeader$default$4();
        RequestLocal x$20 = qual$1.appendAsLeader$default$5();
        VerificationGuard x$21 = qual$1.appendAsLeader$default$6();
        qual$1.appendAsLeader(x$16, x$17, x$18, x$19, x$20, x$21);
        this.log().flush(false);
        Files.setPosixFilePermissions(Paths.get(this.logFilePath(), new String[0]), PosixFilePermissions.fromString("-w-------"));
        Assertions.assertThrows(AccessDeniedException.class, () -> this.runDumpLogSegments((String[])((Object[])new String[]{"--remote-log-metadata-decoder", "--files", this.logFilePath()})));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testDumpRemoteLogMetadataNoFilesFlag() {
        void setExitProcedure_exitProcedure;
        Function2 & Serializable & scala.Serializable intersect = (Function2 & Serializable & scala.Serializable)(x$4, message) -> DumpLogSegmentsTest.$anonfun$testDumpRemoteLogMetadataNoFilesFlag$1(BoxesRunTime.unboxToInt((Object)x$4), message);
        if (Exit$.MODULE$ == null) {
            throw null;
        }
        Exit.setExitProcedure((Exit.Procedure)new /* Unavailable Anonymous Inner Class!! */);
        try {
            Assertions.assertTrue((boolean)((IllegalArgumentException)Assertions.assertThrows(IllegalArgumentException.class, () -> this.runDumpLogSegments((String[])((Object[])new String[]{"--remote-log-metadata-decoder"})))).getMessage().equals("Missing required argument \"[files]\""));
        }
        finally {
            Exit$.MODULE$.resetExitProcedure();
        }
    }

    @Test
    public void testDumpRemoteLogMetadataNoSuchFileException() {
        String noSuchFileLogPath = "/tmp/nosuchfile/00000000000000000000.log";
        Assertions.assertThrows(NoSuchFileException.class, () -> this.runDumpLogSegments((String[])((Object[])new String[]{"--remote-log-metadata-decoder", "--files", noSuchFileLogPath})));
    }

    @Test
    public void testDumpMetadataRecords() {
        MockTime mockTime = new MockTime();
        int x$1 = 0x100000;
        long x$2 = LogTestUtils$.MODULE$.createLogConfig$default$1();
        long x$3 = LogTestUtils$.MODULE$.createLogConfig$default$3();
        long x$4 = LogTestUtils$.MODULE$.createLogConfig$default$4();
        long x$5 = LogTestUtils$.MODULE$.createLogConfig$default$5();
        long x$6 = LogTestUtils$.MODULE$.createLogConfig$default$6();
        long x$7 = LogTestUtils$.MODULE$.createLogConfig$default$7();
        String x$8 = LogTestUtils$.MODULE$.createLogConfig$default$8();
        int x$9 = LogTestUtils$.MODULE$.createLogConfig$default$9();
        int x$10 = LogTestUtils$.MODULE$.createLogConfig$default$10();
        int x$11 = LogTestUtils$.MODULE$.createLogConfig$default$11();
        long x$12 = LogTestUtils$.MODULE$.createLogConfig$default$12();
        boolean x$13 = LogTestUtils$.MODULE$.createLogConfig$default$13();
        boolean x$14 = LogTestUtils$.MODULE$.createLogConfig$default$14();
        boolean x$15 = LogTestUtils$.MODULE$.createLogConfig$default$15();
        LogConfig logConfig = LogTestUtils$.MODULE$.createLogConfig(x$2, x$1, x$3, x$4, x$5, x$6, x$7, x$8, x$9, x$10, x$11, x$12, x$13, x$14, x$15);
        this.log_$eq(LogTestUtils$.MODULE$.createLog(this.logDir(), logConfig, new BrokerTopicStats(BrokerTopicStats$.MODULE$.$lessinit$greater$default$1()), (Scheduler)mockTime.scheduler, (Time)mockTime, LogTestUtils$.MODULE$.createLog$default$6(), LogTestUtils$.MODULE$.createLog$default$7(), LogTestUtils$.MODULE$.createLog$default$8(), LogTestUtils$.MODULE$.createLog$default$9(), LogTestUtils$.MODULE$.createLog$default$10(), LogTestUtils$.MODULE$.createLog$default$11(), LogTestUtils$.MODULE$.createLog$default$12(), LogTestUtils$.MODULE$.createLog$default$13(), LogTestUtils$.MODULE$.createLog$default$14(), LogTestUtils$.MODULE$.createLog$default$15(), LogTestUtils$.MODULE$.createLog$default$16(), LogTestUtils$.MODULE$.createLog$default$17()));
        SimpleRecord[] records = (SimpleRecord[])((TraversableOnce)new .colon.colon((Object)new ApiMessageAndVersion((ApiMessage)new RegisterBrokerRecord().setBrokerId(0).setBrokerEpoch(10L), (short)0), (List)new .colon.colon((Object)new ApiMessageAndVersion((ApiMessage)new RegisterBrokerRecord().setBrokerId(1).setBrokerEpoch(20L), (short)0), (List)new .colon.colon((Object)new ApiMessageAndVersion((ApiMessage)new TopicRecord().setName("test-topic").setTopicId(Uuid.randomUuid()), (short)0), (List)new .colon.colon((Object)new ApiMessageAndVersion((ApiMessage)new PartitionChangeRecord().setTopicId(Uuid.randomUuid()).setLeader(1).setPartitionId(0).setIsr(Arrays.asList((Object[])new Integer[]{Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(2)})), (short)0), (List)Nil$.MODULE$)))).map((Function1 & Serializable & scala.Serializable)message -> {
            MetadataRecordSerde serde = MetadataRecordSerde.INSTANCE;
            ObjectSerializationCache cache = new ObjectSerializationCache();
            ByteBuffer buf = ByteBuffer.allocate(serde.recordSize(message, cache));
            ByteBufferAccessor writer = new ByteBufferAccessor(buf);
            serde.write(message, cache, (Writable)writer);
            buf.flip();
            return new SimpleRecord(null, buf.array());
        }, Seq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(SimpleRecord.class));
        UnifiedLog qual$1 = this.log();
        MemoryRecords x$16 = MemoryRecords.withRecords((Compression)Compression.NONE, (SimpleRecord[])records);
        int x$17 = 1;
        AppendOrigin x$18 = qual$1.appendAsLeader$default$3();
        MetadataVersion x$19 = qual$1.appendAsLeader$default$4();
        RequestLocal x$20 = qual$1.appendAsLeader$default$5();
        VerificationGuard x$21 = qual$1.appendAsLeader$default$6();
        qual$1.appendAsLeader(x$16, x$17, x$18, x$19, x$20, x$21);
        this.log().flush(false);
        String output = this.runDumpLogSegments((String[])((Object[])new String[]{"--cluster-metadata-decoder", "--files", this.logFilePath()}));
        Assertions.assertTrue((boolean)output.contains("Log starting offset: 0"));
        Assertions.assertTrue((boolean)output.contains("TOPIC_RECORD"));
        Assertions.assertTrue((boolean)output.contains("BROKER_RECORD"));
        output = this.runDumpLogSegments((String[])((Object[])new String[]{"--cluster-metadata-decoder", "--skip-record-metadata", "--files", this.logFilePath()}));
        Assertions.assertTrue((boolean)output.contains("TOPIC_RECORD"));
        Assertions.assertTrue((boolean)output.contains("BROKER_RECORD"));
        ByteBuffer buf = ByteBuffer.allocate(4);
        ByteBufferAccessor writer = new ByteBufferAccessor(buf);
        writer.writeUnsignedVarint(10000);
        writer.writeUnsignedVarint(10000);
        UnifiedLog qual$2 = this.log();
        MemoryRecords x$22 = MemoryRecords.withRecords((Compression)Compression.NONE, (SimpleRecord[])new SimpleRecord[]{new SimpleRecord(null, buf.array())});
        int x$23 = 2;
        AppendOrigin x$24 = qual$2.appendAsLeader$default$3();
        MetadataVersion x$25 = qual$2.appendAsLeader$default$4();
        RequestLocal x$26 = qual$2.appendAsLeader$default$5();
        VerificationGuard x$27 = qual$2.appendAsLeader$default$6();
        qual$2.appendAsLeader(x$22, x$23, x$24, x$25, x$26, x$27);
        UnifiedLog qual$3 = this.log();
        MemoryRecords x$28 = MemoryRecords.withRecords((Compression)Compression.NONE, (SimpleRecord[])records);
        int x$29 = 2;
        AppendOrigin x$30 = qual$3.appendAsLeader$default$3();
        MetadataVersion x$31 = qual$3.appendAsLeader$default$4();
        RequestLocal x$32 = qual$3.appendAsLeader$default$5();
        VerificationGuard x$33 = qual$3.appendAsLeader$default$6();
        qual$3.appendAsLeader(x$28, x$29, x$30, x$31, x$32, x$33);
        output = this.runDumpLogSegments((String[])((Object[])new String[]{"--cluster-metadata-decoder", "--skip-record-metadata", "--files", this.logFilePath()}));
        Assertions.assertTrue((boolean)output.contains("TOPIC_RECORD"));
        Assertions.assertTrue((boolean)output.contains("BROKER_RECORD"));
        Assertions.assertTrue((boolean)output.contains("skipping"));
    }

    @Test
    public void testDumpMetadataSnapshot() {
        .colon.colon metadataRecords = new .colon.colon((Object)new ApiMessageAndVersion((ApiMessage)new RegisterBrokerRecord().setBrokerId(0).setBrokerEpoch(10L), (short)0), (List)new .colon.colon((Object)new ApiMessageAndVersion((ApiMessage)new RegisterBrokerRecord().setBrokerId(1).setBrokerEpoch(20L), (short)0), (List)new .colon.colon((Object)new ApiMessageAndVersion((ApiMessage)new TopicRecord().setName("test-topic").setTopicId(Uuid.randomUuid()), (short)0), (List)new .colon.colon((Object)new ApiMessageAndVersion((ApiMessage)new PartitionChangeRecord().setTopicId(Uuid.randomUuid()).setLeader(1).setPartitionId(0).setIsr(Arrays.asList((Object[])new Integer[]{Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(2)})), (short)0), (List)Nil$.MODULE$))));
        KafkaMetadataLog metadataLog = KafkaMetadataLog$.MODULE$.apply(KafkaRaftServer$.MODULE$.MetadataPartition(), KafkaRaftServer$.MODULE$.MetadataTopicId(), this.logDir(), (Time)this.time(), (Scheduler)this.time().scheduler, new MetadataLogConfig(102400, 102400, 10000L, 102400L, 60000L, 0x800000, 0x800000, 60000L, 1));
        int lastContainedLogTimestamp = 10000;
        Using$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> new RecordsSnapshotWriter.Builder().setTime((Time)new MockTime()).setLastContainedLogTimestamp((long)lastContainedLogTimestamp).setRawSnapshotWriter((RawSnapshotWriter)metadataLog.createNewSnapshot(new OffsetAndEpoch(0L, 0)).get()).setKraftVersion(KRaftVersion.KRAFT_VERSION_1).setVoterSet(Optional.of(VoterSetTest.voterSet((Map)VoterSetTest.voterMap((IntStream)IntStream.of(1, 2, 3), (boolean)true)))).build((RecordSerde)MetadataRecordSerde.INSTANCE), arg_0 -> DumpLogSegmentsTest.$anonfun$testDumpMetadataSnapshot$2$adapted((Seq)metadataRecords, arg_0), (Using.Releasable)Using.Releasable$.AutoCloseableIsReleasable$.MODULE$);
        String output = this.runDumpLogSegments((String[])((Object[])new String[]{"--cluster-metadata-decoder", "--files", this.snapshotPath()}));
        Assertions.assertTrue((boolean)output.contains("Snapshot end offset: 0, epoch: 0"), (String)output);
        Assertions.assertTrue((boolean)output.contains("TOPIC_RECORD"), (String)output);
        Assertions.assertTrue((boolean)output.contains("BROKER_RECORD"), (String)output);
        Assertions.assertTrue((boolean)output.contains("SnapshotHeader"), (String)output);
        Assertions.assertTrue((boolean)output.contains("SnapshotFooter"), (String)output);
        Assertions.assertTrue((boolean)output.contains("KRaftVersion"), (String)output);
        Assertions.assertTrue((boolean)output.contains("KRaftVoters"), (String)output);
        Assertions.assertTrue((boolean)output.contains(new StringBuilder(28).append("\"lastContainedLogTimestamp\":").append(lastContainedLogTimestamp).toString()), (String)output);
        output = this.runDumpLogSegments((String[])((Object[])new String[]{"--cluster-metadata-decoder", "--skip-record-metadata", "--files", this.snapshotPath()}));
        Assertions.assertTrue((boolean)output.contains("Snapshot end offset: 0, epoch: 0"), (String)output);
        Assertions.assertTrue((boolean)output.contains("TOPIC_RECORD"), (String)output);
        Assertions.assertTrue((boolean)output.contains("BROKER_RECORD"), (String)output);
        Assertions.assertFalse((boolean)output.contains("SnapshotHeader"), (String)output);
        Assertions.assertFalse((boolean)output.contains("SnapshotFooter"), (String)output);
        Assertions.assertFalse((boolean)output.contains("KRaftVersion"), (String)output);
        Assertions.assertFalse((boolean)output.contains("KRaftVoters"), (String)output);
        Assertions.assertFalse((boolean)output.contains(new StringBuilder(29).append("\"lastContainedLogTimestamp\": ").append(lastContainedLogTimestamp).toString()), (String)output);
    }

    @Test
    public void testDumpEmptyIndex() {
        this.log_$eq(this.createTestLog());
        File indexFile = new File(this.indexFilePath());
        new PrintWriter(indexFile).close();
        String expectOutput = new StringBuilder(11).append(indexFile).append(" is empty.\n").toString();
        ByteArrayOutputStream outContent = new ByteArrayOutputStream();
        Console$.MODULE$.withOut((OutputStream)outContent, (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> DumpLogSegments$.MODULE$.dumpIndex(indexFile, false, true, (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$), Integer.MAX_VALUE));
        Assertions.assertEquals((Object)expectOutput, (Object)outContent.toString());
    }

    private String runDumpLogSegments(String[] args) {
        ByteArrayOutputStream outContent = new ByteArrayOutputStream();
        Console$.MODULE$.withOut((OutputStream)outContent, (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> DumpLogSegments$.MODULE$.main(args));
        return outContent.toString();
    }

    @Test
    public void testPrintDataLogPartialBatches() {
        this.log_$eq(this.createTestLog());
        ArrayBuffer batches = new ArrayBuffer();
        this.addSimpleRecords(this.log(), (ArrayBuffer<BatchInfo>)batches);
        int partialBatches = batches.size() / 2;
        ListIterator<Object> lines = Arrays.asList((Object[])this.runDumpLogSegments((String[])((Object[])new String[]{"--files", this.logFilePath()})).split("\n")).listIterator();
        int partialBatchesBytes = this.readPartialBatchesBytes(lines, partialBatches);
        ListIterator<Object> partialLines = Arrays.asList((Object[])this.runDumpLogSegments((String[])((Object[])new String[]{"--max-bytes", Integer.toString(partialBatchesBytes), "--files", this.logFilePath()})).split("\n")).listIterator();
        int partialBatchesCount = this.countBatches(partialLines);
        Assertions.assertEquals((int)partialBatches, (int)partialBatchesCount);
    }

    @Test
    public void testOffsetsMessageParser() {
        CoordinatorRecordSerde serde = new CoordinatorRecordSerde();
        DumpLogSegments.OffsetsMessageParser parser = new DumpLogSegments.OffsetsMessageParser();
        Assertions.assertEquals((Object)"Failed to decode message at offset 0 using offset topic decoder (message had a missing key)", (Object)Assertions.assertThrows(RuntimeException.class, () -> {
            Compression x$3 = TestUtils$.MODULE$.singletonRecords$default$3();
            long x$4 = TestUtils$.MODULE$.singletonRecords$default$4();
            byte x$5 = TestUtils$.MODULE$.singletonRecords$default$5();
            parser.parse((Record)TestUtils$.MODULE$.singletonRecords(null, null, x$3, x$4, x$5).records().iterator().next());
        }).getMessage());
        Assertions.assertEquals((Object)new Tuple2((Object)new Some((Object)"{\"type\":\"3\",\"data\":{\"groupId\":\"group\"}}"), (Object)new Some((Object)"{\"version\":\"0\",\"data\":{\"epoch\":10}}")), (Object)parser.parse(DumpLogSegmentsTest.serializedRecord$1(new ApiMessageAndVersion((ApiMessage)new ConsumerGroupMetadataKey().setGroupId("group"), (short)3), new ApiMessageAndVersion((ApiMessage)new ConsumerGroupMetadataValue().setEpoch(10), (short)0), serde)));
        Assertions.assertEquals((Object)new Tuple2((Object)new Some((Object)"{\"type\":\"2\",\"data\":{\"group\":\"group\"}}"), (Object)new Some((Object)"{\"version\":\"4\",\"data\":{\"protocolType\":\"consumer\",\"generation\":10,\"protocol\":\"range\",\"leader\":\"member\",\"currentStateTimestamp\":-1,\"members\":[{\"memberId\":\"member\",\"groupInstanceId\":\"instance\",\"clientId\":\"client\",\"clientHost\":\"host\",\"rebalanceTimeout\":1000,\"sessionTimeout\":100,\"subscription\":{\"topics\":[\"foo\"],\"userData\":null,\"ownedPartitions\":[{\"topic\":\"foo\",\"partitions\":[0]}],\"generationId\":0,\"rackId\":\"rack\"},\"assignment\":{\"assignedPartitions\":[{\"topic\":\"foo\",\"partitions\":[0]}],\"userData\":null}}]}}")), (Object)parser.parse(DumpLogSegmentsTest.serializedRecord$1(new ApiMessageAndVersion((ApiMessage)new GroupMetadataKey().setGroup("group"), (short)2), new ApiMessageAndVersion((ApiMessage)new GroupMetadataValue().setProtocolType("consumer").setProtocol("range").setLeader("member").setGeneration(10).setMembers(Collections.singletonList(new GroupMetadataValue.MemberMetadata().setMemberId("member").setClientId("client").setClientHost("host").setGroupInstanceId("instance").setSessionTimeout(100).setRebalanceTimeout(1000).setSubscription(Utils.toArray((ByteBuffer)ConsumerProtocol.serializeSubscription((ConsumerPartitionAssignor.Subscription)new ConsumerPartitionAssignor.Subscription(Collections.singletonList("foo"), null, Collections.singletonList(new TopicPartition("foo", 0)), 0, Optional.of("rack"))))).setAssignment(Utils.toArray((ByteBuffer)ConsumerProtocol.serializeAssignment((ConsumerPartitionAssignor.Assignment)new ConsumerPartitionAssignor.Assignment(Collections.singletonList(new TopicPartition("foo", 0)))))))), 4), serde)));
        Assertions.assertEquals((Object)new Tuple2((Object)new Some((Object)"{\"type\":\"2\",\"data\":{\"group\":\"group\"}}"), (Object)new Some((Object)"{\"version\":\"4\",\"data\":{\"protocolType\":\"consumer\",\"generation\":10,\"protocol\":\"range\",\"leader\":\"member\",\"currentStateTimestamp\":-1,\"members\":[{\"memberId\":\"member\",\"groupInstanceId\":\"instance\",\"clientId\":\"client\",\"clientHost\":\"host\",\"rebalanceTimeout\":1000,\"sessionTimeout\":100,\"subscription\":\"U3Vic2NyaXB0aW9u\",\"assignment\":\"QXNzaWdubWVudA==\"}]}}")), (Object)parser.parse(DumpLogSegmentsTest.serializedRecord$1(new ApiMessageAndVersion((ApiMessage)new GroupMetadataKey().setGroup("group"), (short)2), new ApiMessageAndVersion((ApiMessage)new GroupMetadataValue().setProtocolType("consumer").setProtocol("range").setLeader("member").setGeneration(10).setMembers(Collections.singletonList(new GroupMetadataValue.MemberMetadata().setMemberId("member").setClientId("client").setClientHost("host").setGroupInstanceId("instance").setSessionTimeout(100).setRebalanceTimeout(1000).setSubscription("Subscription".getBytes()).setAssignment("Assignment".getBytes()))), 4), serde)));
        Assertions.assertEquals((Object)new Tuple2((Object)new Some((Object)"{\"type\":\"3\",\"data\":{\"groupId\":\"group\"}}"), (Object)new Some((Object)"<DELETE>")), (Object)parser.parse(DumpLogSegmentsTest.serializedRecord$1(new ApiMessageAndVersion((ApiMessage)new ConsumerGroupMetadataKey().setGroupId("group"), (short)3), null, serde)));
        Assertions.assertEquals((Object)new Tuple2((Object)new Some((Object)"Unknown record type 32767 at offset 0, skipping."), (Object)None$.MODULE$), (Object)parser.parse(DumpLogSegmentsTest.serializedRecord$1(new ApiMessageAndVersion((ApiMessage)new ConsumerGroupMetadataKey().setGroupId("group"), Short.MAX_VALUE), new ApiMessageAndVersion((ApiMessage)new ConsumerGroupMetadataValue().setEpoch(10), (short)0), serde)));
        Assertions.assertEquals((Object)new Tuple2((Object)new Some((Object)"Error at offset 0, skipping. Could not read record with version 0 from value's buffer due to: Error reading byte array of 536870911 byte(s): only 1 byte(s) available."), (Object)None$.MODULE$), (Object)parser.parse(DumpLogSegmentsTest.serializedRecord$1(new ApiMessageAndVersion((ApiMessage)new ConsumerGroupMetadataKey().setGroupId("group"), (short)3), new ApiMessageAndVersion((ApiMessage)new ConsumerGroupMemberMetadataValue(), (short)0), serde)));
    }

    @Test
    public void testNewDecoder() {
        DumpLogSegments$.MODULE$.newDecoder(TestDecoder.class.getName());
        DumpLogSegments$.MODULE$.newDecoder(kafka.serializer.DefaultDecoder.class.getName());
        Assertions.assertThrows(Exception.class, () -> DumpLogSegments$.MODULE$.newDecoder(TestDecoderWithoutVerifiableProperties.class.getName()));
    }

    @Test
    public void testConvertDeprecatedDecoderClass() {
        Assertions.assertEquals((Object)DefaultDecoder.class.getName(), (Object)DumpLogSegments$.MODULE$.convertDeprecatedDecoderClass(kafka.serializer.DefaultDecoder.class.getName()));
        Assertions.assertEquals((Object)org.apache.kafka.tools.api.IntegerDecoder.class.getName(), (Object)DumpLogSegments$.MODULE$.convertDeprecatedDecoderClass(IntegerDecoder.class.getName()));
        Assertions.assertEquals((Object)org.apache.kafka.tools.api.LongDecoder.class.getName(), (Object)DumpLogSegments$.MODULE$.convertDeprecatedDecoderClass(LongDecoder.class.getName()));
        Assertions.assertEquals((Object)org.apache.kafka.tools.api.StringDecoder.class.getName(), (Object)DumpLogSegments$.MODULE$.convertDeprecatedDecoderClass(StringDecoder.class.getName()));
    }

    private Option<String> readBatchMetadata(ListIterator<String> lines) {
        while (lines.hasNext()) {
            String line = lines.next();
            if (line.startsWith("|")) {
                throw new IllegalStateException("Read unexpected record entry");
            }
            if (!line.startsWith("baseOffset")) continue;
            return new Some((Object)line);
        }
        return None$.MODULE$;
    }

    private int readPartialBatchesBytes(ListIterator<String> lines, int limit) {
        Regex sizePattern = new StringOps(Predef$.MODULE$.augmentString(".+?size:\\s(\\d+).+")).r();
        int batchesBytes = 0;
        int batchesCounter = 0;
        while (lines.hasNext()) {
            if (batchesCounter >= limit) {
                return batchesBytes;
            }
            String line = lines.next();
            if (!line.startsWith("baseOffset")) continue;
            Option option = sizePattern.unapplySeq((CharSequence)line);
            if (!option.isEmpty() && option.get() != null && ((LinearSeqOptimized)option.get()).lengthCompare(1) == 0) {
                String size = (String)((LinearSeqOptimized)option.get()).apply(0);
                batchesBytes += new StringOps(Predef$.MODULE$.augmentString(size)).toInt();
            } else {
                throw new IllegalStateException(new StringBuilder(52).append("Failed to parse and find size value for batch line: ").append(line).toString());
            }
            ++batchesCounter;
        }
        return batchesBytes;
    }

    private int countBatches(ListIterator<String> lines) {
        int countBatches = 0;
        while (lines.hasNext()) {
            if (!lines.next().startsWith("baseOffset")) continue;
            ++countBatches;
        }
        return countBatches;
    }

    private Seq<String> readBatchRecords(ListIterator<String> lines) {
        ArrayBuffer records = (ArrayBuffer)ArrayBuffer$.MODULE$.empty();
        while (lines.hasNext()) {
            String line = lines.next();
            if (line.startsWith("|")) {
                records.$plus$eq((Object)line.substring(1));
                continue;
            }
            lines.previous();
            return records.toSeq();
        }
        return records.toSeq();
    }

    private scala.collection.immutable.Map<String, String> parseMetadataFields(String line) {
        scala.collection.mutable.Map fields = Map$.MODULE$.empty();
        Iterator tokens = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])line.split("\\s+"))).map((Function1 & Serializable & scala.Serializable)x$5 -> x$5.trim(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).filter((Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)DumpLogSegmentsTest.$anonfun$parseMetadataFields$2(x$6))))).iterator();
        while (tokens.hasNext()) {
            String token = (String)tokens.next();
            if (!token.endsWith(":")) {
                throw new IllegalStateException(new StringBuilder(27).append("Unexpected non-field token ").append(token).toString());
            }
            String field = token.substring(0, token.length() - 1);
            if (!tokens.hasNext()) {
                throw new IllegalStateException(new StringBuilder(26).append("Failed to parse value for ").append(field).toString());
            }
            String value = (String)tokens.next();
            fields.$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)field), (Object)value));
        }
        return fields.toMap(Predef$.MODULE$.$conforms());
    }

    private void assertDumpLogRecordMetadata(UnifiedLog log) {
        FetchDataInfo logReadInfo = log.read(0L, Integer.MAX_VALUE, FetchIsolation.LOG_END, true);
        ListIterator<Object> lines = Arrays.asList((Object[])this.runDumpLogSegments((String[])((Object[])new String[]{"--deep-iteration", "--files", this.logFilePath()})).split("\n")).listIterator();
        ((IterableLike)CollectionConverters$.MODULE$.iterableAsScalaIterableConverter(logReadInfo.records.batches()).asScala()).foreach((Function1 & Serializable & scala.Serializable)batch -> {
            DumpLogSegmentsTest.$anonfun$assertDumpLogRecordMetadata$1(this, lines, batch);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$afterEach$1(UnifiedLog log) {
        Utils.closeQuietly((AutoCloseable)log, (String)"UnifiedLog");
    }

    public static final /* synthetic */ SimpleRecord $anonfun$addSimpleRecords$1(long now$1, int i) {
        return new SimpleRecord(now$1 + (long)(i * 2), new StringBuilder(12).append("message key ").append(i).toString().getBytes(), new StringBuilder(14).append("message value ").append(i).toString().getBytes());
    }

    public static final /* synthetic */ SimpleRecord $anonfun$addSimpleRecords$2(long now$1, int i) {
        return new SimpleRecord(now$1 + (long)(i * 3), new StringBuilder(12).append("message key ").append(i).toString().getBytes(), null);
    }

    public static final /* synthetic */ SimpleRecord $anonfun$addSimpleRecords$3(long now$1, int i) {
        return new SimpleRecord(now$1 + (long)(i * 5), null, new StringBuilder(14).append("message value ").append(i).toString().getBytes());
    }

    public static final /* synthetic */ SimpleRecord $anonfun$addSimpleRecords$4(long now$1, int i) {
        return new SimpleRecord(now$1 + (long)(i * 7), null);
    }

    public static final /* synthetic */ void $anonfun$testPrintDataLog$1(IntRef i$1, int index$1, Object nonLocalReturnKey1$1, Tuple2 x0$1) {
        if (x0$1 != null) {
            BatchInfo batch = (BatchInfo)x0$1._1();
            if (i$1.elem == index$1) {
                throw new NonLocalReturnControl.mcZ.sp(nonLocalReturnKey1$1, true);
            }
            ++i$1.elem;
            batch.records().indices().foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)x$1 -> {
                if (i$1.elem == index$1) {
                    throw new NonLocalReturnControl.mcZ.sp(nonLocalReturnKey1$1, false);
                }
                ++i$1.elem;
            });
            return;
        }
        throw new MatchError(null);
    }

    private static final boolean isBatch$1(int index, ArrayBuffer batches$1) {
        Object object = new Object();
        try {
            IntRef i = IntRef.create((int)0);
            ((ResizableArray)batches$1.zipWithIndex(ArrayBuffer$.MODULE$.canBuildFrom())).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
                DumpLogSegmentsTest.$anonfun$testPrintDataLog$1(i, index, object, x0$1);
                return BoxedUnit.UNIT;
            });
            throw new AssertionError((Object)new StringBuilder(19).append("No match for index ").append(index).toString());
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                return ex.value$mcZ$sp();
            }
            throw ex;
        }
    }

    public static final /* synthetic */ int $anonfun$testPrintDataLog$3(BatchInfo x$2) {
        return x$2.records().size();
    }

    private final void verifyRecordsInOutput$1(boolean checkKeysAndValues, String[] args, ArrayBuffer batches$1) {
        String output = this.runDumpLogSegments(args);
        String[] lines = output.split("\n");
        Assertions.assertTrue((lines.length > 2 ? 1 : 0) != 0, (String)new StringBuilder(18).append("Data not printed: ").append(output).toString());
        int totalRecords = BoxesRunTime.unboxToInt((Object)((TraversableOnce)batches$1.map((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToInteger((int)DumpLogSegmentsTest.$anonfun$testPrintDataLog$3(x$2)), ArrayBuffer$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
        IntRef offset = IntRef.create((int)0);
        Iterator batchIterator = batches$1.iterator();
        ObjectRef batch = ObjectRef.create(null);
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), totalRecords + batches$1.size()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)index -> {
            String line = lines[lines.length - totalRecords - batches$1.size() + index];
            if (DumpLogSegmentsTest.isBatch$1(index, batches$1)) {
                Assertions.assertTrue((boolean)line.startsWith(new StringBuilder(25).append("baseOffset: ").append(offset$1.elem).append(" lastOffset: ").toString()), (String)new StringBuilder(40).append("Not a valid batch-level message record: ").append(line).toString());
                batch$1.elem = (BatchInfo)batchIterator.next();
                return;
            }
            Assertions.assertTrue((boolean)line.startsWith(new StringBuilder(9).append(DumpLogSegments$.MODULE$.RecordIndent()).append(" offset: ").append(offset$1.elem).toString()), (String)new StringBuilder(28).append("Not a valid message record: ").append(line).toString());
            if (checkKeysAndValues) {
                String suffix = "headerKeys: []";
                if (((BatchInfo)batch$1.elem).hasKeys()) {
                    suffix = new StringBuilder(18).append(suffix).append(" key: message key ").append(offset$1.elem).toString();
                }
                if (((BatchInfo)batch$1.elem).hasValues()) {
                    suffix = new StringBuilder(24).append(suffix).append(" payload: message value ").append(offset$1.elem).toString();
                }
                Assertions.assertTrue((boolean)line.endsWith(suffix), (String)new StringBuilder(37).append("Message record missing key or value: ").append(line).toString());
            }
            ++offset$1.elem;
        });
    }

    private final void verifyNoRecordsInOutput$1(String[] args) {
        String output = this.runDumpLogSegments(args);
        Assertions.assertFalse((boolean)output.matches("(?s).*offset: [0-9]* isvalid.*"), (String)new StringBuilder(35).append("Data should not have been printed: ").append(output).toString());
    }

    public static final /* synthetic */ boolean $anonfun$countSubstring$1(String sub$1, String x$3) {
        String string = x$3;
        return !(string != null ? !string.equals(sub$1) : sub$1 != null);
    }

    public static final /* synthetic */ Nothing$ $anonfun$testDumpRemoteLogMetadataNoFilesFlag$1(int x$4, Option message) {
        throw new IllegalArgumentException((String)message.orNull(Predef$.MODULE$.$conforms()));
    }

    public static final /* synthetic */ long $anonfun$testDumpMetadataSnapshot$2(Seq metadataRecords$1, RecordsSnapshotWriter snapshotWriter) {
        snapshotWriter.append((java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter(metadataRecords$1).asJava());
        return snapshotWriter.freeze();
    }

    private static final Record serializedRecord$1(ApiMessageAndVersion key, ApiMessageAndVersion value, CoordinatorRecordSerde serde$1) {
        CoordinatorRecord record = new CoordinatorRecord(key, value);
        byte[] x$1 = serde$1.serializeKey(record);
        byte[] x$2 = serde$1.serializeValue(record);
        Compression x$3 = TestUtils$.MODULE$.singletonRecords$default$3();
        long x$4 = TestUtils$.MODULE$.singletonRecords$default$4();
        byte x$5 = TestUtils$.MODULE$.singletonRecords$default$5();
        return (Record)TestUtils$.MODULE$.singletonRecords(x$2, x$1, x$3, x$4, x$5).records().iterator().next();
    }

    public static final /* synthetic */ boolean $anonfun$parseMetadataFields$2(String x$6) {
        return new StringOps(Predef$.MODULE$.augmentString(x$6)).nonEmpty();
    }

    public static final /* synthetic */ long $anonfun$assertDumpLogRecordMetadata$2(String x$7) {
        return new StringOps(Predef$.MODULE$.augmentString(x$7)).toLong();
    }

    public static final /* synthetic */ long $anonfun$assertDumpLogRecordMetadata$3(String x$8) {
        return new StringOps(Predef$.MODULE$.augmentString(x$8)).toLong();
    }

    public static final /* synthetic */ long $anonfun$assertDumpLogRecordMetadata$4(String x$9) {
        return new StringOps(Predef$.MODULE$.augmentString(x$9)).toLong();
    }

    public static final /* synthetic */ int $anonfun$assertDumpLogRecordMetadata$5(String x$10) {
        return new StringOps(Predef$.MODULE$.augmentString(x$10)).toInt();
    }

    public static final /* synthetic */ boolean $anonfun$assertDumpLogRecordMetadata$6(String x$11) {
        return new StringOps(Predef$.MODULE$.augmentString(x$11)).toBoolean();
    }

    public static final /* synthetic */ boolean $anonfun$assertDumpLogRecordMetadata$7(String x$12) {
        return new StringOps(Predef$.MODULE$.augmentString(x$12)).toBoolean();
    }

    public static final /* synthetic */ long $anonfun$assertDumpLogRecordMetadata$8(String x$13) {
        return new StringOps(Predef$.MODULE$.augmentString(x$13)).toLong();
    }

    public static final /* synthetic */ short $anonfun$assertDumpLogRecordMetadata$9(String x$14) {
        return new StringOps(Predef$.MODULE$.augmentString(x$14)).toShort();
    }

    public static final /* synthetic */ int $anonfun$assertDumpLogRecordMetadata$10(String x$15) {
        return new StringOps(Predef$.MODULE$.augmentString(x$15)).toInt();
    }

    public static final /* synthetic */ long $anonfun$assertDumpLogRecordMetadata$12(String x$16) {
        return new StringOps(Predef$.MODULE$.augmentString(x$16)).toLong();
    }

    public static final /* synthetic */ int $anonfun$assertDumpLogRecordMetadata$13(String x$17) {
        return new StringOps(Predef$.MODULE$.augmentString(x$17)).toInt();
    }

    public static final /* synthetic */ int $anonfun$assertDumpLogRecordMetadata$14(String x$18) {
        return new StringOps(Predef$.MODULE$.augmentString(x$18)).toInt();
    }

    public static final /* synthetic */ long $anonfun$assertDumpLogRecordMetadata$15(String x$19) {
        return new StringOps(Predef$.MODULE$.augmentString(x$19)).toLong();
    }

    public static final /* synthetic */ int $anonfun$assertDumpLogRecordMetadata$16(String x$20) {
        return new StringOps(Predef$.MODULE$.augmentString(x$20)).toInt();
    }

    public static final /* synthetic */ void $anonfun$assertDumpLogRecordMetadata$11(DumpLogSegmentsTest $this, Iterator parsedRecordIter$1, RecordBatch batch$2, Record record) {
        Assertions.assertTrue((boolean)parsedRecordIter$1.hasNext());
        scala.collection.immutable.Map<String, String> parsedRecord = $this.parseMetadataFields((String)parsedRecordIter$1.next());
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToLong((long)record.offset())), (Object)parsedRecord.get((Object)"offset").map((Function1 & Serializable & scala.Serializable)x$16 -> BoxesRunTime.boxToLong((long)DumpLogSegmentsTest.$anonfun$assertDumpLogRecordMetadata$12(x$16))));
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToInteger((int)record.keySize())), (Object)parsedRecord.get((Object)"keySize").map((Function1 & Serializable & scala.Serializable)x$17 -> BoxesRunTime.boxToInteger((int)DumpLogSegmentsTest.$anonfun$assertDumpLogRecordMetadata$13(x$17))));
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToInteger((int)record.valueSize())), (Object)parsedRecord.get((Object)"valueSize").map((Function1 & Serializable & scala.Serializable)x$18 -> BoxesRunTime.boxToInteger((int)DumpLogSegmentsTest.$anonfun$assertDumpLogRecordMetadata$14(x$18))));
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToLong((long)record.timestamp())), (Object)parsedRecord.get((Object)batch$2.timestampType().name).map((Function1 & Serializable & scala.Serializable)x$19 -> BoxesRunTime.boxToLong((long)DumpLogSegmentsTest.$anonfun$assertDumpLogRecordMetadata$15(x$19))));
        if (batch$2.magic() >= RecordVersion.V2.value) {
            Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToInteger((int)record.sequence())), (Object)parsedRecord.get((Object)"sequence").map((Function1 & Serializable & scala.Serializable)x$20 -> BoxesRunTime.boxToInteger((int)DumpLogSegmentsTest.$anonfun$assertDumpLogRecordMetadata$16(x$20))));
        }
        Assertions.assertEquals((Object)None$.MODULE$, (Object)parsedRecord.get((Object)"baseOffset"));
        Assertions.assertEquals((Object)None$.MODULE$, (Object)parsedRecord.get((Object)"lastOffset"));
        Assertions.assertEquals((Object)None$.MODULE$, (Object)parsedRecord.get((Object)"partitionLeaderEpoch"));
        Assertions.assertEquals((Object)None$.MODULE$, (Object)parsedRecord.get((Object)"producerId"));
        Assertions.assertEquals((Object)None$.MODULE$, (Object)parsedRecord.get((Object)"producerEpoch"));
        Assertions.assertEquals((Object)None$.MODULE$, (Object)parsedRecord.get((Object)"baseSequence"));
        Assertions.assertEquals((Object)None$.MODULE$, (Object)parsedRecord.get((Object)"isTransactional"));
        Assertions.assertEquals((Object)None$.MODULE$, (Object)parsedRecord.get((Object)"isControl"));
        Assertions.assertEquals((Object)None$.MODULE$, (Object)parsedRecord.get((Object)"compresscodec"));
    }

    public static final /* synthetic */ void $anonfun$assertDumpLogRecordMetadata$1(DumpLogSegmentsTest $this, ListIterator lines$2, RecordBatch batch) {
        Option<String> parsedBatchOpt = $this.readBatchMetadata(lines$2);
        Assertions.assertTrue((boolean)parsedBatchOpt.isDefined());
        scala.collection.immutable.Map<String, String> parsedBatch = $this.parseMetadataFields((String)parsedBatchOpt.get());
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToLong((long)batch.baseOffset())), (Object)parsedBatch.get((Object)"baseOffset").map((Function1 & Serializable & scala.Serializable)x$7 -> BoxesRunTime.boxToLong((long)DumpLogSegmentsTest.$anonfun$assertDumpLogRecordMetadata$2(x$7))));
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToLong((long)batch.lastOffset())), (Object)parsedBatch.get((Object)"lastOffset").map((Function1 & Serializable & scala.Serializable)x$8 -> BoxesRunTime.boxToLong((long)DumpLogSegmentsTest.$anonfun$assertDumpLogRecordMetadata$3(x$8))));
        Assertions.assertEquals((Object)Option$.MODULE$.apply((Object)batch.countOrNull()), (Object)parsedBatch.get((Object)"count").map((Function1 & Serializable & scala.Serializable)x$9 -> BoxesRunTime.boxToLong((long)DumpLogSegmentsTest.$anonfun$assertDumpLogRecordMetadata$4(x$9))));
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToInteger((int)batch.partitionLeaderEpoch())), (Object)parsedBatch.get((Object)"partitionLeaderEpoch").map((Function1 & Serializable & scala.Serializable)x$10 -> BoxesRunTime.boxToInteger((int)DumpLogSegmentsTest.$anonfun$assertDumpLogRecordMetadata$5(x$10))));
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToBoolean((boolean)batch.isTransactional())), (Object)parsedBatch.get((Object)"isTransactional").map((Function1 & Serializable & scala.Serializable)x$11 -> BoxesRunTime.boxToBoolean((boolean)DumpLogSegmentsTest.$anonfun$assertDumpLogRecordMetadata$6(x$11))));
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToBoolean((boolean)batch.isControlBatch())), (Object)parsedBatch.get((Object)"isControl").map((Function1 & Serializable & scala.Serializable)x$12 -> BoxesRunTime.boxToBoolean((boolean)DumpLogSegmentsTest.$anonfun$assertDumpLogRecordMetadata$7(x$12))));
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToLong((long)batch.producerId())), (Object)parsedBatch.get((Object)"producerId").map((Function1 & Serializable & scala.Serializable)x$13 -> BoxesRunTime.boxToLong((long)DumpLogSegmentsTest.$anonfun$assertDumpLogRecordMetadata$8(x$13))));
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToShort((short)batch.producerEpoch())), (Object)parsedBatch.get((Object)"producerEpoch").map((Function1 & Serializable & scala.Serializable)x$14 -> BoxesRunTime.boxToShort((short)DumpLogSegmentsTest.$anonfun$assertDumpLogRecordMetadata$9(x$14))));
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToInteger((int)batch.baseSequence())), (Object)parsedBatch.get((Object)"baseSequence").map((Function1 & Serializable & scala.Serializable)x$15 -> BoxesRunTime.boxToInteger((int)DumpLogSegmentsTest.$anonfun$assertDumpLogRecordMetadata$10(x$15))));
        Assertions.assertEquals((Object)new Some((Object)batch.compressionType().name), (Object)parsedBatch.get((Object)"compresscodec"));
        Iterator parsedRecordIter = $this.readBatchRecords(lines$2).iterator();
        ((IterableLike)CollectionConverters$.MODULE$.iterableAsScalaIterableConverter((Iterable)batch).asScala()).foreach((Function1 & Serializable & scala.Serializable)record -> {
            DumpLogSegmentsTest.$anonfun$assertDumpLogRecordMetadata$11($this, parsedRecordIter, batch, record);
            return BoxedUnit.UNIT;
        });
    }

    public DumpLogSegmentsTest() {
        this.segmentName = "00000000000000000000";
    }

    public static final /* synthetic */ Object $anonfun$testDumpMetadataSnapshot$2$adapted(Seq metadataRecords$1, RecordsSnapshotWriter snapshotWriter) {
        return BoxesRunTime.boxToLong((long)DumpLogSegmentsTest.$anonfun$testDumpMetadataSnapshot$2(metadataRecords$1, snapshotWriter));
    }

    public static class TestDecoder
    implements Decoder<byte[]> {
        public byte[] fromBytes(byte[] bytes) {
            return bytes;
        }

        public TestDecoder(VerifiableProperties props) {
        }
    }

    public static class TestDecoderWithoutVerifiableProperties
    implements Decoder<byte[]> {
        public byte[] fromBytes(byte[] bytes) {
            return bytes;
        }
    }
}

