/*
 * Decompiled with CFR 0.152.
 */
package kafka.tools;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.PrintStream;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Arrays;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import kafka.server.KafkaConfig;
import kafka.tools.StorageTool$;
import kafka.tools.TerseFailure;
import kafka.utils.TestUtils$;
import net.sourceforge.argparse4j.inf.ArgumentParserException;
import org.apache.kafka.common.metadata.UserScramCredentialRecord;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.metadata.bootstrap.BootstrapDirectory;
import org.apache.kafka.metadata.bootstrap.BootstrapMetadata;
import org.apache.kafka.metadata.properties.PropertiesUtils;
import org.apache.kafka.metadata.storage.FormatterException;
import org.apache.kafka.server.common.ApiMessageAndVersion;
import org.apache.kafka.server.common.Features;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;
import scala.Function1;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@Timeout(value=40L)
@ScalaSignature(bytes="\u0006\u0001\t}a\u0001\u0002\u0017.\u0001IBQ!\u000f\u0001\u0005\u0002iBQ!\u0010\u0001\u0005\nyBqa\u0012\u0001C\u0002\u0013\u0005\u0001\n\u0003\u0004^\u0001\u0001\u0006I!\u0013\u0005\u0006=\u0002!\ta\u0018\u0005\u0006]\u0002!\ta\u0018\u0005\u0006a\u0002!\ta\u0018\u0005\u0006e\u0002!\ta\u0018\u0005\u0006i\u0002!\ta\u0018\u0005\u0006m\u0002!\ta\u0018\u0005\u0006q\u0002!\ta\u0018\u0005\bu\u0002\u0011\r\u0011\"\u0001|\u0011\u0019a\b\u0001)A\u0005\u007f!9Q\u0010\u0001b\u0001\n\u0003Y\bB\u0002@\u0001A\u0003%q\b\u0003\u0004\u0000\u0001\u0011%\u0011\u0011\u0001\u0005\n\u0003\u001b\u0002\u0011\u0013!C\u0005\u0003\u001fB\u0011\"!\u001a\u0001#\u0003%I!a\u001a\t\r\u0005-\u0004\u0001\"\u0001`\u0011\u0019\ty\u0007\u0001C\u0001?\"1\u00111\u000f\u0001\u0005\u0002}Ca!a\u001e\u0001\t\u0003y\u0006BBA>\u0001\u0011\u0005q\f\u0003\u0004\u0002\u0000\u0001!\ta\u0018\u0005\u0007\u0003\u0007\u0003A\u0011A0\t\r\u0005\u001d\u0005\u0001\"\u0001`\u0011\u0019\tY\t\u0001C\u0001?\"1\u0011q\u0012\u0001\u0005\u0002}Ca!a%\u0001\t\u0003y\u0006BBAL\u0001\u0011\u0005q\f\u0003\u0004\u0002\u001c\u0002!\ta\u0018\u0005\u0007\u0003?\u0003A\u0011A0\t\u000f\u0005\r\u0006\u0001\"\u0001\u0002&\"1\u0011q\u001a\u0001\u0005\u0002}Cq!a5\u0001\t\u0003\t)\u000eC\u0004\u0002`\u0002!\t!!9\t\r\u0005]\b\u0001\"\u0001`\u0011\u0019\tY\u0010\u0001C\u0001?\"1\u0011q \u0001\u0005\u0002}CaAa\u0001\u0001\t\u0003y\u0006B\u0002B\u0004\u0001\u0011\u0005q\f\u0003\u0004\u0003\f\u0001!\ta\u0018\u0005\u0007\u0005\u001f\u0001A\u0011A0\u0003\u001fM#xN]1hKR{w\u000e\u001c+fgRT!AL\u0018\u0002\u000bQ|w\u000e\\:\u000b\u0003A\nQa[1gW\u0006\u001c\u0001a\u0005\u0002\u0001gA\u0011AgN\u0007\u0002k)\ta'A\u0003tG\u0006d\u0017-\u0003\u00029k\t1\u0011I\\=SK\u001a\fa\u0001P5oSRtD#A\u001e\u0011\u0005q\u0002Q\"A\u0017\u000219,woU3mM6\u000bg.Y4fIB\u0013x\u000e]3si&,7\u000fF\u0001@!\t\u0001U)D\u0001B\u0015\t\u00115)\u0001\u0003vi&d'\"\u0001#\u0002\t)\fg/Y\u0005\u0003\r\u0006\u0013!\u0002\u0015:pa\u0016\u0014H/[3t\u0003-\tG\u000e\u001c$fCR,(/Z:\u0016\u0003%\u00032AS'Q\u001d\t!4*\u0003\u0002Mk\u00059\u0001/Y2lC\u001e,\u0017B\u0001(P\u0005\u0011a\u0015n\u001d;\u000b\u00051+\u0004CA)\\\u001b\u0005\u0011&BA*U\u0003\u0019\u0019w.\\7p]*\u0011QKV\u0001\u0007g\u0016\u0014h/\u001a:\u000b\u0005A:&B\u0001-Z\u0003\u0019\t\u0007/Y2iK*\t!,A\u0002pe\u001eL!\u0001\u0018*\u0003\u0011\u0019+\u0017\r^;sKN\fA\"\u00197m\r\u0016\fG/\u001e:fg\u0002\n!\u0004^3ti\u000e{gNZ5h)>dun\u001a#je\u0016\u001cGo\u001c:jKN$\u0012\u0001\u0019\t\u0003i\u0005L!AY\u001b\u0003\tUs\u0017\u000e\u001e\u0015\u0003\u000b\u0011\u0004\"!\u001a7\u000e\u0003\u0019T!a\u001a5\u0002\u0007\u0005\u0004\u0018N\u0003\u0002jU\u00069!.\u001e9ji\u0016\u0014(BA6Z\u0003\u0015QWO\\5u\u0013\tigM\u0001\u0003UKN$\u0018\u0001\u000b;fgR\u001cuN\u001c4jOR{Gj\\4ESJ,7\r^8sS\u0016\u001cx+\u001b;i\u001b\u0016$\u0018\rT8h\t&\u0014\bF\u0001\u0004e\u0003}!Xm\u001d;J]\u001a|7i\\7nC:$wJ\\#naRLH)\u001b:fGR|'/\u001f\u0015\u0003\u000f\u0011\f\u0011\u0005^3ti&sgm\\\"p[6\fg\u000eZ(o\u001b&\u001c8/\u001b8h\t&\u0014Xm\u0019;pefD#\u0001\u00033\u0002AQ,7\u000f^%oM>\u001cu.\\7b]\u0012|e\u000eR5sK\u000e$xN]=Bg\u001aKG.\u001a\u0015\u0003\u0013\u0011\fq\u0005^3ti&sgm\\,ji\"l\u0015n]7bi\u000eDW\r\u001a'fO\u0006\u001c\u0017pS1gW\u0006\u001cuN\u001c4jO\"\u0012!\u0002Z\u0001\"i\u0016\u001cH/\u00138g_^KG\u000f['jg6\fGo\u00195fI.\u0013\u0016M\u001a;D_:4\u0017n\u001a\u0015\u0003\u0017\u0011\fQ\u0004Z3gCVdGo\u0015;bi&\u001c\u0017+^8sk6\u0004&o\u001c9feRLWm]\u000b\u0002\u007f\u0005qB-\u001a4bk2$8\u000b^1uS\u000e\fVo\u001c:v[B\u0013x\u000e]3si&,7\u000fI\u0001\u001fI\u00164\u0017-\u001e7u\tft\u0017-\\5d#V|'/^7Qe>\u0004XM\u001d;jKN\fq\u0004Z3gCVdG\u000fR=oC6L7-U;peVl\u0007K]8qKJ$\u0018.Z:!\u0003A\u0011XO\u001c$pe6\fGoQ8n[\u0006tG\r\u0006\u0006\u0002\u0004\u0005%\u0011\u0011DA\u000f\u0003\u0007\u00022\u0001NA\u0003\u0013\r\t9!\u000e\u0002\u0004\u0013:$\bbBA\u0006!\u0001\u0007\u0011QB\u0001\u0007gR\u0014X-Y7\u0011\t\u0005=\u0011QC\u0007\u0003\u0003#Q1!a\u0005D\u0003\tIw.\u0003\u0003\u0002\u0018\u0005E!!\u0006\"zi\u0016\f%O]1z\u001fV$\b/\u001e;TiJ,\u0017-\u001c\u0005\u0007\u00037\u0001\u0002\u0019A \u0002\u0015A\u0014x\u000e]3si&,7\u000fC\u0005\u0002 A\u0001\n\u00111\u0001\u0002\"\u0005qQ\r\u001f;sC\u0006\u0013x-^7f]R\u001c\bCBA\u0012\u0003_\t\u0019DD\u0002\u0002&-sA!a\n\u0002.5\u0011\u0011\u0011\u0006\u0006\u0004\u0003W\t\u0014A\u0002\u001fs_>$h(C\u00017\u0013\r\t\td\u0014\u0002\u0004'\u0016\f\b\u0003BA\u001b\u0003{qA!a\u000e\u0002:A\u0019\u0011qE\u001b\n\u0007\u0005mR'\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0003\u007f\t\tE\u0001\u0004TiJLgn\u001a\u0006\u0004\u0003w)\u0004\"CA#!A\u0005\t\u0019AA$\u0003=IwM\\8sK\u001a{'/\\1ui\u0016$\u0007c\u0001\u001b\u0002J%\u0019\u00111J\u001b\u0003\u000f\t{w\u000e\\3b]\u0006Q\"/\u001e8G_Jl\u0017\r^\"p[6\fg\u000e\u001a\u0013eK\u001a\fW\u000f\u001c;%gU\u0011\u0011\u0011\u000b\u0016\u0005\u0003C\t\u0019f\u000b\u0002\u0002VA!\u0011qKA1\u001b\t\tIF\u0003\u0003\u0002\\\u0005u\u0013!C;oG\",7m[3e\u0015\r\ty&N\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BA2\u00033\u0012\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u0003i\u0011XO\u001c$pe6\fGoQ8n[\u0006tG\r\n3fM\u0006,H\u000e\u001e\u00135+\t\tIG\u000b\u0003\u0002H\u0005M\u0013A\f;fgR4uN]7biN+8mY3fINLe-\u00117m\t&\u0014Xm\u0019;pe&,7/\u0011:f\u0003Z\f\u0017\u000e\\1cY\u0016D#a\u00053\u0002eQ,7\u000f\u001e$pe6\fGoU;dG\u0016,Gm]%g\u0003RdU-Y:u\u001f:,G)\u001b:fGR|'/_%t\u0003Z\f\u0017\u000e\\1cY\u0016D#\u0001\u00063\u0002CQ,7\u000f\u001e$pe6\fGOR1jYN|e.\u00117sK\u0006$\u0017PR8s[\u0006$H/\u001a3)\u0005U!\u0017a\u0005;fgRLuM\\8sK\u001a{'/\\1ui\u0016$\u0007F\u0001\fe\u00035\"Xm\u001d;G_Jl\u0017\r\u001e$bS2\u001c\u0018JZ!mY\u0012K'/Z2u_JLWm]!sKVs\u0017M^1jY\u0006\u0014G.\u001a\u0015\u0003/\u0011\fq\u0003^3ti\u001a{'/\\1u\r\u0006LGn]%o5.lu\u000eZ3)\u0005a!\u0017\u0001\b;fgR4uN]7bi^KG\u000f\u001b*fY\u0016\f7/\u001a,feNLwN\u001c\u0015\u00033\u0011\fQ\u0005^3ti\u001a{'/\\1u/&$\bNU3mK\u0006\u001cXMV3sg&|g.Q:GK\u0006$XO]3)\u0005i!\u0017\u0001\b;fgR4uN]7bi^KG\u000f[%om\u0006d\u0017\u000e\u001a$fCR,(/\u001a\u0015\u00037\u0011\fa\u0005^3ti\u001a{'/\\1u/&$\b.\u00138wC2LGm\u0013*bMR4VM]:j_:dUM^3mQ\taB-A\u0016uKN$hi\u001c:nCR<\u0016\u000e\u001e5SK2,\u0017m]3WKJ\u001c\u0018n\u001c8B]\u0012\\%+\u00194u-\u0016\u00148/[8oQ\tiB-A\u0012uKN$hi\u001c:nCR<\u0016\u000e\u001e5SK2,\u0017m]3WKJ\u001c\u0018n\u001c8EK\u001a\fW\u000f\u001c;)\u0005y!\u0017\u0001\u000e;fgR4uN]7bi^KG\u000f\u001b*fY\u0016\f7/\u001a,feNLwN\u001c#fM\u0006,H\u000e^!oIJ+G.Z1tKZ+'o]5p]\"\u0012q\u0004Z\u0001*i\u0016\u001cHOR8s[\u0006$x+\u001b;i'R\fg\u000eZ1m_:,g\t\\1h\u001f:\u0014%o\\6fe\u001a\u000b\u0017\u000e\\:)\u0005\u0001\"\u0017\u0001\b;fgR4uN]7bi^KG\u000f[*uC:$\u0017\r\\8oK\u001ac\u0017m\u001a\u000b\u0004A\u0006\u001d\u0006bBAUC\u0001\u0007\u0011qI\u0001\u0017g\u0016$8J]1giZ+'o]5p]\u001a+\u0017\r^;sK\":\u0011%!,\u0002>\u0006}\u0006\u0003BAX\u0003sk!!!-\u000b\t\u0005M\u0016QW\u0001\taJ|g/\u001b3fe*\u0019\u0011q\u00175\u0002\rA\f'/Y7t\u0013\u0011\tY,!-\u0003\u0017Y\u000bG.^3T_V\u00148-Z\u0001\tE>|G.Z1og2\"\u0011\u0011YAb3\u0005\u0001\u0011$A\u0001)\u0007\u0005\n9\r\u0005\u0003\u0002J\u0006-WBAA[\u0013\u0011\ti-!.\u0003#A\u000b'/Y7fi\u0016\u0014\u0018N_3e)\u0016\u001cH/\u0001\u001euKN$hi\u001c:nCR<\u0016\u000e\u001e5Ti\u0006tG-\u00197p]\u00164E.Y4B]\u0012Le.\u001b;jC2\u001cuN\u001c;s_2dWM]:GY\u0006<g)Y5mg\"\u0012!\u0005Z\u0001%i\u0016\u001cHOR8s[\u0006$x+\u001b;i\u0013:LG/[1m\u0007>tGO]8mY\u0016\u00148O\u00127bOR\u0019\u0001-a6\t\u000f\u0005%6\u00051\u0001\u0002H!:1%!,\u0002>\u0006mG\u0006BAa\u0003\u0007D3aIAd\u0003\u001d#Xm\u001d;G_Jl\u0017\r^,ji\"|W\u000f^*uCRL7-U;peVlg)Y5mg^KG\u000f[8vi&s\u0017\u000e^5bY\u000e{g\u000e\u001e:pY2,'o](o\u0007>tGO]8mY\u0016\u0014Hc\u00011\u0002d\"9\u0011Q\u001d\u0013A\u0002\u0005M\u0012\u0001\u00049s_\u000e,7o\u001d*pY\u0016\u001c\bf\u0002\u0013\u0002.\u0006%\u00181^\u0001\bgR\u0014\u0018N\\4tY\u0011\ti/!=\"\u0005\u0005=\u0018AC2p]R\u0014x\u000e\u001c7fe\u0006\u0012\u00111_\u0001\u0012EJ|7.\u001a:-G>tGO]8mY\u0016\u0014\bf\u0001\u0013\u0002H\u00061D/Z:u\r>\u0014X.\u0019;XSRDgj\\%oSRL\u0017\r\\\"p]R\u0014x\u000e\u001c7feN\u001cVoY2fK\u0012\u001cxJ\\\"p]R\u0014x\u000e\u001c7fe\"\u0012Q\u0005Z\u0001Gi\u0016\u001cHOR8s[\u0006$x+\u001b;i_V$8\u000b^1uS\u000e\fVo\u001c:v[N+8mY3fIN<\u0016\u000e\u001e5pkRLe.\u001b;jC2\u001cuN\u001c;s_2dWM]:P]\n\u0013xn[3sQ\t1C-A\ruKN$(i\\8ugR\u0014\u0018\r]*de\u0006l'+Z2pe\u0012\u001c\bFA\u0014e\u0003\u0005\"Xm\u001d;TGJ\fWNU3d_J$7o\u00147e%\u0016dW-Y:f-\u0016\u00148/[8oQ\tAC-A\u000buKN$\b+\u0019:tK:\u000bW.Z!oI2+g/\u001a7)\u0005%\"\u0017!\t;fgR\u0004\u0016M]:f\u001d\u0006lW-\u00118e\u0019\u00164X\r\\,ji\"tu.R9vC2\u001c\bF\u0001\u0016e\u0003\u0005\"Xm\u001d;QCJ\u001cXMT1nK\u0006sG\rT3wK2<\u0016\u000e\u001e5O_:+XNY3sQ\tYC\rK\u0004\u0001\u0005+\u0011YB!\b\u0011\u0007\u0015\u00149\"C\u0002\u0003\u001a\u0019\u0014q\u0001V5nK>,H/A\u0003wC2,XMH\u0001)\u0001")
public class StorageToolTest {
    private final List<Features> allFeatures = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])Features.FEATURES)).toList();
    private final Properties defaultStaticQuorumProperties = new Properties();
    private final Properties defaultDynamicQuorumProperties;

    private Properties newSelfManagedProperties() {
        Properties properties = new Properties();
        properties.setProperty("log.dirs", "/tmp/foo,/tmp/bar");
        properties.setProperty("process.roles", "controller");
        properties.setProperty("node.id", "2");
        properties.setProperty("controller.quorum.voters", "2@localhost:9092");
        properties.setProperty("controller.listener.names", "PLAINTEXT");
        return properties;
    }

    public List<Features> allFeatures() {
        return this.allFeatures;
    }

    @Test
    public void testConfigToLogDirectories() {
        KafkaConfig config = new KafkaConfig((Map)this.newSelfManagedProperties());
        Assertions.assertEquals((Object)new .colon.colon((Object)"/tmp/bar", (List)new .colon.colon((Object)"/tmp/foo", (List)Nil$.MODULE$)), (Object)StorageTool$.MODULE$.configToLogDirectories(config));
    }

    @Test
    public void testConfigToLogDirectoriesWithMetaLogDir() {
        Properties properties = this.newSelfManagedProperties();
        properties.setProperty("metadata.log.dir", "/tmp/baz");
        KafkaConfig config = new KafkaConfig((Map)properties);
        Assertions.assertEquals((Object)new .colon.colon((Object)"/tmp/bar", (List)new .colon.colon((Object)"/tmp/baz", (List)new .colon.colon((Object)"/tmp/foo", (List)Nil$.MODULE$))), (Object)StorageTool$.MODULE$.configToLogDirectories(config));
    }

    @Test
    public void testInfoCommandOnEmptyDirectory() {
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        File tempDir = TestUtils$.MODULE$.tempDir();
        try {
            Assertions.assertEquals((int)1, (int)StorageTool$.MODULE$.infoCommand(new PrintStream(stream), true, (Seq)new .colon.colon((Object)tempDir.toString(), (List)Nil$.MODULE$)));
            Assertions.assertEquals((Object)new StringBuilder(62).append("Found log directory:\n  ").append(tempDir.toString()).append("\n\nFound problem:\n  ").append(tempDir.toString()).append(" is not formatted.\n\n").toString(), (Object)stream.toString());
        }
        finally {
            Utils.delete((File)tempDir);
        }
    }

    @Test
    public void testInfoCommandOnMissingDirectory() {
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        File tempDir = TestUtils$.MODULE$.tempDir();
        tempDir.delete();
        try {
            Assertions.assertEquals((int)1, (int)StorageTool$.MODULE$.infoCommand(new PrintStream(stream), true, (Seq)new .colon.colon((Object)tempDir.toString(), (List)Nil$.MODULE$)));
            Assertions.assertEquals((Object)new StringBuilder(34).append("Found problem:\n  ").append(tempDir.toString()).append(" does not exist\n\n").toString(), (Object)stream.toString());
        }
        finally {
            Utils.delete((File)tempDir);
        }
    }

    @Test
    public void testInfoCommandOnDirectoryAsFile() {
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        File tempFile = TestUtils$.MODULE$.tempFile();
        try {
            Assertions.assertEquals((int)1, (int)StorageTool$.MODULE$.infoCommand(new PrintStream(stream), true, (Seq)new .colon.colon((Object)tempFile.toString(), (List)Nil$.MODULE$)));
            Assertions.assertEquals((Object)new StringBuilder(38).append("Found problem:\n  ").append(tempFile.toString()).append(" is not a directory\n\n").toString(), (Object)stream.toString());
        }
        finally {
            tempFile.delete();
        }
    }

    @Test
    public void testInfoWithMismatchedLegacyKafkaConfig() {
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        File tempDir = TestUtils$.MODULE$.tempDir();
        try {
            Files.write(tempDir.toPath().resolve("meta.properties"), String.join((CharSequence)"\n", Arrays.asList((Object[])new String[]{"version=1", "node.id=1", "cluster.id=XcZZOzUqS4yHOjhMQB6JLQ"})).getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
            Assertions.assertEquals((int)1, (int)StorageTool$.MODULE$.infoCommand(new PrintStream(stream), false, (Seq)new .colon.colon((Object)tempDir.toString(), (List)Nil$.MODULE$)));
            Assertions.assertEquals((Object)new StringBuilder(246).append("Found log directory:\n  ").append(tempDir.toString()).append("\n\nFound metadata: {cluster.id=XcZZOzUqS4yHOjhMQB6JLQ, node.id=1, version=1}\n\nFound problem:\n  The kafka configuration file appears to be for a legacy cluster, but the directories are formatted for a cluster in KRaft mode.\n\n").toString(), (Object)stream.toString());
        }
        finally {
            Utils.delete((File)tempDir);
        }
    }

    @Test
    public void testInfoWithMismatchedKRaftConfig() {
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        File tempDir = TestUtils$.MODULE$.tempDir();
        try {
            Files.write(tempDir.toPath().resolve("meta.properties"), String.join((CharSequence)"\n", Arrays.asList((Object[])new String[]{"version=0", "broker.id=1", "cluster.id=26c36907-4158-4a35-919d-6534229f5241"})).getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
            Assertions.assertEquals((int)1, (int)StorageTool$.MODULE$.infoCommand(new PrintStream(stream), true, (Seq)new .colon.colon((Object)tempDir.toString(), (List)Nil$.MODULE$)));
            Assertions.assertEquals((Object)new StringBuilder(257).append("Found log directory:\n  ").append(tempDir.toString()).append("\n\nFound metadata: {broker.id=1, cluster.id=26c36907-4158-4a35-919d-6534229f5241, version=0}\n\nFound problem:\n  The kafka configuration file appears to be for a cluster in KRaft mode, but the directories are formatted for legacy mode.\n\n").toString(), (Object)stream.toString());
        }
        finally {
            Utils.delete((File)tempDir);
        }
    }

    public Properties defaultStaticQuorumProperties() {
        return this.defaultStaticQuorumProperties;
    }

    public Properties defaultDynamicQuorumProperties() {
        return this.defaultDynamicQuorumProperties;
    }

    private int runFormatCommand(ByteArrayOutputStream stream, Properties properties, Seq<String> extraArguments, boolean ignoreFormatted) {
        int n;
        File tempDir = TestUtils$.MODULE$.tempDir();
        try {
            String configPathString = new File(tempDir.getAbsolutePath(), "format.props").toString();
            PropertiesUtils.writePropertiesFile((Properties)properties, (String)configPathString, (boolean)true);
            ListBuffer arguments = (ListBuffer)ListBuffer$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"format", "--cluster-id", "XcZZOzUqS4yHOjhMQB6JLQ"}));
            if (ignoreFormatted) {
                arguments.$plus$eq((Object)"--ignore-formatted");
            }
            arguments.$plus$eq((Object)"--config");
            arguments.$plus$eq((Object)configPathString);
            extraArguments.foreach((Function1 & Serializable & scala.Serializable)x$1 -> arguments.$plus$eq(x$1));
            n = StorageTool$.MODULE$.execute((String[])arguments.toArray(ClassTag$.MODULE$.apply(String.class)), new PrintStream(stream));
        }
        finally {
            Utils.delete((File)tempDir);
        }
        return n;
    }

    private Seq<String> runFormatCommand$default$3() {
        return Nil$.MODULE$;
    }

    private boolean runFormatCommand$default$4() {
        return false;
    }

    @Test
    public void testFormatSucceedsIfAllDirectoriesAreAvailable() {
        .colon.colon availableDirs = new .colon.colon((Object)TestUtils$.MODULE$.tempDir(), (List)new .colon.colon((Object)TestUtils$.MODULE$.tempDir(), (List)new .colon.colon((Object)TestUtils$.MODULE$.tempDir(), (List)Nil$.MODULE$)));
        Properties properties = new Properties();
        properties.putAll((Map<?, ?>)this.defaultStaticQuorumProperties());
        properties.setProperty("log.dirs", availableDirs.mkString(","));
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        Assertions.assertEquals((int)0, (int)this.runFormatCommand(stream, properties, this.runFormatCommand$default$3(), this.runFormatCommand$default$4()));
        Assertions.assertTrue((boolean)stream.toString().contains(new StringOps(Predef$.MODULE$.augmentString("Formatting metadata directory %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{availableDirs.head()}))), (String)new StringBuilder(34).append("Failed to find content in output: ").append(stream.toString()).toString());
        ((IterableLike)availableDirs.tail()).foreach((Function1 & Serializable & scala.Serializable)dir -> {
            StorageToolTest.$anonfun$testFormatSucceedsIfAllDirectoriesAreAvailable$1(stream, dir);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testFormatSucceedsIfAtLeastOneDirectoryIsAvailable() {
        File availableDir1 = TestUtils$.MODULE$.tempDir();
        File unavailableDir1 = TestUtils$.MODULE$.tempFile();
        Properties properties = new Properties();
        properties.putAll((Map<?, ?>)this.defaultStaticQuorumProperties());
        properties.setProperty("log.dirs", new StringBuilder(1).append(availableDir1).append(",").append(unavailableDir1).toString());
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        Assertions.assertEquals((int)0, (int)this.runFormatCommand(stream, properties, this.runFormatCommand$default$3(), this.runFormatCommand$default$4()));
        Assertions.assertTrue((boolean)stream.toString().contains(new StringOps(Predef$.MODULE$.augmentString("Formatting metadata directory %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{availableDir1}))), (String)new StringBuilder(34).append("Failed to find content in output: ").append(stream.toString()).toString());
        Assertions.assertFalse((boolean)stream.toString().contains(new StringOps(Predef$.MODULE$.augmentString("Formatting log directory %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{unavailableDir1}))), (String)new StringBuilder(34).append("Failed to find content in output: ").append(stream.toString()).toString());
        Assertions.assertTrue((boolean)stream.toString().contains(new StringOps(Predef$.MODULE$.augmentString("I/O error trying to read log directory %s. Ignoring...")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{unavailableDir1}))), (String)new StringBuilder(34).append("Failed to find content in output: ").append(stream.toString()).toString());
    }

    @Test
    public void testFormatFailsOnAlreadyFormatted() {
        .colon.colon availableDirs = new .colon.colon((Object)TestUtils$.MODULE$.tempDir(), (List)new .colon.colon((Object)TestUtils$.MODULE$.tempDir(), (List)new .colon.colon((Object)TestUtils$.MODULE$.tempDir(), (List)Nil$.MODULE$)));
        Properties properties = new Properties();
        properties.putAll((Map<?, ?>)this.defaultStaticQuorumProperties());
        properties.setProperty("log.dirs", String.valueOf(availableDirs.apply(0)));
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        Assertions.assertEquals((int)0, (int)this.runFormatCommand(stream, properties, this.runFormatCommand$default$3(), this.runFormatCommand$default$4()));
        properties.setProperty("log.dirs", availableDirs.mkString(","));
        ByteArrayOutputStream stream2 = new ByteArrayOutputStream();
        Assertions.assertTrue((boolean)Assertions.assertThrows(FormatterException.class, () -> this.runFormatCommand(stream2, properties, this.runFormatCommand$default$3(), this.runFormatCommand$default$4())).getMessage().contains("already formatted. Use --ignore-formatted to ignore this directory and format the others"));
    }

    @Test
    public void testIgnoreFormatted() {
        .colon.colon availableDirs = new .colon.colon((Object)TestUtils$.MODULE$.tempDir(), (List)new .colon.colon((Object)TestUtils$.MODULE$.tempDir(), (List)new .colon.colon((Object)TestUtils$.MODULE$.tempDir(), (List)Nil$.MODULE$)));
        Properties properties = new Properties();
        properties.putAll((Map<?, ?>)this.defaultStaticQuorumProperties());
        properties.setProperty("log.dirs", String.valueOf(availableDirs.apply(0)));
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        Assertions.assertEquals((int)0, (int)this.runFormatCommand(stream, properties, this.runFormatCommand$default$3(), this.runFormatCommand$default$4()));
        properties.setProperty("log.dirs", availableDirs.mkString(","));
        ByteArrayOutputStream stream2 = new ByteArrayOutputStream();
        Assertions.assertEquals((int)0, (int)this.runFormatCommand(stream2, properties, (Seq<String>)Nil$.MODULE$, true));
    }

    @Test
    public void testFormatFailsIfAllDirectoriesAreUnavailable() {
        File unavailableDir1 = TestUtils$.MODULE$.tempFile();
        File unavailableDir2 = TestUtils$.MODULE$.tempFile();
        Properties properties = new Properties();
        properties.putAll((Map<?, ?>)this.defaultStaticQuorumProperties());
        properties.setProperty("log.dirs", new StringBuilder(1).append(unavailableDir1).append(",").append(unavailableDir2).toString());
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        Assertions.assertEquals((Object)"No available log directories to format.", (Object)Assertions.assertThrows(FormatterException.class, () -> this.runFormatCommand(stream, properties, this.runFormatCommand$default$3(), this.runFormatCommand$default$4())).getMessage());
        Assertions.assertTrue((boolean)stream.toString().contains(new StringOps(Predef$.MODULE$.augmentString("I/O error trying to read log directory %s. Ignoring...")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{unavailableDir1}))), (String)new StringBuilder(34).append("Failed to find content in output: ").append(stream.toString()).toString());
        Assertions.assertTrue((boolean)stream.toString().contains(new StringOps(Predef$.MODULE$.augmentString("I/O error trying to read log directory %s. Ignoring...")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{unavailableDir2}))), (String)new StringBuilder(34).append("Failed to find content in output: ").append(stream.toString()).toString());
    }

    @Test
    public void testFormatFailsInZkMode() {
        .colon.colon availableDirs = new .colon.colon((Object)TestUtils$.MODULE$.tempDir(), (List)Nil$.MODULE$);
        Properties properties = new Properties();
        properties.setProperty("log.dirs", availableDirs.mkString(","));
        properties.setProperty("zookeeper.connect", "localhost:2181");
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        Assertions.assertEquals((Object)"The kafka configuration file appears to be for a legacy cluster. Formatting is only supported for clusters in KRaft mode.", (Object)Assertions.assertThrows(TerseFailure.class, () -> this.runFormatCommand(stream, properties, this.runFormatCommand$default$3(), this.runFormatCommand$default$4())).getMessage());
    }

    @Test
    public void testFormatWithReleaseVersion() {
        .colon.colon availableDirs = new .colon.colon((Object)TestUtils$.MODULE$.tempDir(), (List)Nil$.MODULE$);
        Properties properties = new Properties();
        properties.putAll((Map<?, ?>)this.defaultStaticQuorumProperties());
        properties.setProperty("log.dirs", availableDirs.mkString(","));
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        Assertions.assertEquals((int)0, (int)this.runFormatCommand(stream, properties, (Seq<String>)new .colon.colon((Object)"--release-version", (List)new .colon.colon((Object)"3.8-IV0", (List)Nil$.MODULE$)), this.runFormatCommand$default$4()));
        Assertions.assertTrue((boolean)stream.toString().contains("3.8-IV0"), (String)new StringBuilder(34).append("Failed to find content in output: ").append(stream.toString()).toString());
    }

    @Test
    public void testFormatWithReleaseVersionAsFeature() {
        .colon.colon availableDirs = new .colon.colon((Object)TestUtils$.MODULE$.tempDir(), (List)Nil$.MODULE$);
        Properties properties = new Properties();
        properties.putAll((Map<?, ?>)this.defaultStaticQuorumProperties());
        properties.setProperty("log.dirs", availableDirs.mkString(","));
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        Assertions.assertEquals((int)0, (int)this.runFormatCommand(stream, properties, (Seq<String>)new .colon.colon((Object)"--feature", (List)new .colon.colon((Object)"metadata.version=20", (List)Nil$.MODULE$)), this.runFormatCommand$default$4()));
        Assertions.assertTrue((boolean)stream.toString().contains("3.9-IV0"), (String)new StringBuilder(34).append("Failed to find content in output: ").append(stream.toString()).toString());
    }

    @Test
    public void testFormatWithInvalidFeature() {
        .colon.colon availableDirs = new .colon.colon((Object)TestUtils$.MODULE$.tempDir(), (List)Nil$.MODULE$);
        Properties properties = new Properties();
        properties.putAll((Map<?, ?>)this.defaultStaticQuorumProperties());
        properties.setProperty("log.dirs", availableDirs.mkString(","));
        Assertions.assertEquals((Object)"Unsupported feature: non.existent.feature. Supported features are: group.version, kraft.version, transaction.version", (Object)Assertions.assertThrows(FormatterException.class, () -> this.runFormatCommand(new ByteArrayOutputStream(), properties, (Seq<String>)new .colon.colon((Object)"--feature", (List)new .colon.colon((Object)"non.existent.feature=20", (List)Nil$.MODULE$)), this.runFormatCommand$default$4())).getMessage());
    }

    @Test
    public void testFormatWithInvalidKRaftVersionLevel() {
        .colon.colon availableDirs = new .colon.colon((Object)TestUtils$.MODULE$.tempDir(), (List)Nil$.MODULE$);
        Properties properties = new Properties();
        properties.putAll((Map<?, ?>)this.defaultDynamicQuorumProperties());
        properties.setProperty("log.dirs", availableDirs.mkString(","));
        Assertions.assertEquals((Object)"No feature:kraft.version with feature level 999", (Object)Assertions.assertThrows(IllegalArgumentException.class, () -> this.runFormatCommand(new ByteArrayOutputStream(), properties, (Seq<String>)new .colon.colon((Object)"--feature", (List)new .colon.colon((Object)"kraft.version=999", (List)new .colon.colon((Object)"--standalone", (List)Nil$.MODULE$))), this.runFormatCommand$default$4())).getMessage());
    }

    @Test
    public void testFormatWithReleaseVersionAndKRaftVersion() {
        .colon.colon availableDirs = new .colon.colon((Object)TestUtils$.MODULE$.tempDir(), (List)Nil$.MODULE$);
        Properties properties = new Properties();
        properties.putAll((Map<?, ?>)this.defaultStaticQuorumProperties());
        properties.setProperty("log.dirs", availableDirs.mkString(","));
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        Assertions.assertEquals((int)0, (int)this.runFormatCommand(stream, properties, (Seq<String>)new .colon.colon((Object)"--release-version", (List)new .colon.colon((Object)"3.7-IV0", (List)new .colon.colon((Object)"--feature", (List)new .colon.colon((Object)"kraft.version=0", (List)Nil$.MODULE$)))), this.runFormatCommand$default$4()));
        Assertions.assertTrue((boolean)stream.toString().contains("3.7-IV0"), (String)new StringBuilder(34).append("Failed to find content in output: ").append(stream.toString()).toString());
    }

    @Test
    public void testFormatWithReleaseVersionDefault() {
        .colon.colon availableDirs = new .colon.colon((Object)TestUtils$.MODULE$.tempDir(), (List)Nil$.MODULE$);
        Properties properties = new Properties();
        properties.putAll((Map<?, ?>)this.defaultStaticQuorumProperties());
        properties.setProperty("log.dirs", availableDirs.mkString(","));
        properties.setProperty("inter.broker.protocol.version", "3.7");
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        Assertions.assertEquals((int)0, (int)this.runFormatCommand(stream, properties, this.runFormatCommand$default$3(), this.runFormatCommand$default$4()));
        Assertions.assertTrue((boolean)stream.toString().contains("3.7-IV4"), (String)new StringBuilder(34).append("Failed to find content in output: ").append(stream.toString()).toString());
    }

    @Test
    public void testFormatWithReleaseVersionDefaultAndReleaseVersion() {
        .colon.colon availableDirs = new .colon.colon((Object)TestUtils$.MODULE$.tempDir(), (List)Nil$.MODULE$);
        Properties properties = new Properties();
        properties.putAll((Map<?, ?>)this.defaultStaticQuorumProperties());
        properties.setProperty("log.dirs", availableDirs.mkString(","));
        properties.setProperty("inter.broker.protocol.version", "3.7");
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        Assertions.assertEquals((int)0, (int)this.runFormatCommand(stream, properties, (Seq<String>)new .colon.colon((Object)"--release-version", (List)new .colon.colon((Object)"3.6-IV0", (List)new .colon.colon((Object)"--feature", (List)new .colon.colon((Object)"kraft.version=0", (List)Nil$.MODULE$)))), this.runFormatCommand$default$4()));
        Assertions.assertTrue((boolean)stream.toString().contains("3.6-IV0"), (String)new StringBuilder(34).append("Failed to find content in output: ").append(stream.toString()).toString());
    }

    @Test
    public void testFormatWithStandaloneFlagOnBrokerFails() {
        .colon.colon availableDirs = new .colon.colon((Object)TestUtils$.MODULE$.tempDir(), (List)Nil$.MODULE$);
        Properties properties = new Properties();
        properties.putAll((Map<?, ?>)this.defaultStaticQuorumProperties());
        properties.setProperty("log.dirs", availableDirs.mkString(","));
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        ListBuffer arguments = (ListBuffer)ListBuffer$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"--release-version", "3.9-IV0", "--standalone"}));
        Assertions.assertEquals((Object)"You can only use --standalone on a controller.", (Object)Assertions.assertThrows(TerseFailure.class, () -> this.runFormatCommand(stream, properties, (Seq<String>)arguments.toSeq(), this.runFormatCommand$default$4())).getMessage());
    }

    @ParameterizedTest
    @ValueSource(booleans={false, true})
    public void testFormatWithStandaloneFlag(boolean setKraftVersionFeature) {
        .colon.colon availableDirs = new .colon.colon((Object)TestUtils$.MODULE$.tempDir(), (List)Nil$.MODULE$);
        Properties properties = new Properties();
        properties.putAll((Map<?, ?>)this.defaultDynamicQuorumProperties());
        properties.setProperty("log.dirs", availableDirs.mkString(","));
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        ListBuffer arguments = (ListBuffer)ListBuffer$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"--release-version", "3.9-IV0", "--standalone"}));
        if (setKraftVersionFeature) {
            arguments.$plus$eq((Object)"--feature");
            arguments.$plus$eq((Object)"kraft.version=1");
        }
        Assertions.assertEquals((int)0, (int)this.runFormatCommand(stream, properties, (Seq<String>)arguments.toSeq(), this.runFormatCommand$default$4()));
        Assertions.assertTrue((boolean)stream.toString().contains(new StringOps(Predef$.MODULE$.augmentString("Formatting dynamic metadata voter directory %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{availableDirs.head()}))), (String)new StringBuilder(34).append("Failed to find content in output: ").append(stream.toString()).toString());
    }

    @Test
    public void testFormatWithStandaloneFlagAndInitialControllersFlagFails() {
        ListBuffer arguments = (ListBuffer)ListBuffer$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"--release-version", "3.9-IV0", "--standalone", "--initial-controllers", "0@localhost:8020:K90IZ-0DRNazJ49kCZ1EMQ,1@localhost:8030:aUARLskQTCW4qCZDtS_cwA,2@localhost:8040:2ggvsS4kQb-fSJ_-zC_Ang"}));
        Assertions.assertThrows(ArgumentParserException.class, () -> StorageTool$.MODULE$.parseArguments((String[])arguments.toArray(ClassTag$.MODULE$.apply(String.class))));
    }

    @ParameterizedTest
    @ValueSource(booleans={false, true})
    public void testFormatWithInitialControllersFlag(boolean setKraftVersionFeature) {
        .colon.colon availableDirs = new .colon.colon((Object)TestUtils$.MODULE$.tempDir(), (List)Nil$.MODULE$);
        Properties properties = new Properties();
        properties.putAll((Map<?, ?>)this.defaultDynamicQuorumProperties());
        properties.setProperty("log.dirs", availableDirs.mkString(","));
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        ListBuffer arguments = (ListBuffer)ListBuffer$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"--release-version", "3.9-IV0", "--initial-controllers", "0@localhost:8020:K90IZ-0DRNazJ49kCZ1EMQ,1@localhost:8030:aUARLskQTCW4qCZDtS_cwA,2@localhost:8040:2ggvsS4kQb-fSJ_-zC_Ang"}));
        if (setKraftVersionFeature) {
            arguments.$plus$eq((Object)"--feature");
            arguments.$plus$eq((Object)"kraft.version=1");
        }
        Assertions.assertEquals((int)0, (int)this.runFormatCommand(stream, properties, (Seq<String>)arguments.toSeq(), this.runFormatCommand$default$4()));
        Assertions.assertTrue((boolean)stream.toString().contains(new StringOps(Predef$.MODULE$.augmentString("Formatting dynamic metadata voter directory %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{availableDirs.head()}))), (String)new StringBuilder(34).append("Failed to find content in output: ").append(stream.toString()).toString());
    }

    @ParameterizedTest
    @ValueSource(strings={"controller", "broker,controller"})
    public void testFormatWithoutStaticQuorumFailsWithoutInitialControllersOnController(String processRoles) {
        .colon.colon availableDirs = new .colon.colon((Object)TestUtils$.MODULE$.tempDir(), (List)Nil$.MODULE$);
        Properties properties = new Properties();
        properties.putAll((Map<?, ?>)this.defaultDynamicQuorumProperties());
        if (processRoles.contains("broker")) {
            properties.setProperty("listeners", "PLAINTEXT://:9092,CONTROLLER://:9093");
            properties.setProperty("advertised.listeners", "PLAINTEXT://127.0.0.1:9092,CONTROLLER://127.0.0.1:9093");
        }
        properties.setProperty("process.roles", processRoles);
        properties.setProperty("log.dirs", availableDirs.mkString(","));
        Assertions.assertEquals((Object)"Because controller.quorum.voters is not set on this controller, you must specify one of the following: --standalone, --initial-controllers, or --no-initial-controllers.", (Object)Assertions.assertThrows(TerseFailure.class, () -> this.runFormatCommand(new ByteArrayOutputStream(), properties, (Seq<String>)new .colon.colon((Object)"--release-version", (List)new .colon.colon((Object)"3.9-IV0", (List)Nil$.MODULE$)), this.runFormatCommand$default$4())).getMessage());
    }

    @Test
    public void testFormatWithNoInitialControllersSucceedsOnController() {
        .colon.colon availableDirs = new .colon.colon((Object)TestUtils$.MODULE$.tempDir(), (List)Nil$.MODULE$);
        Properties properties = new Properties();
        properties.putAll((Map<?, ?>)this.defaultDynamicQuorumProperties());
        properties.setProperty("log.dirs", availableDirs.mkString(","));
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        Assertions.assertEquals((int)0, (int)this.runFormatCommand(stream, properties, (Seq<String>)new .colon.colon((Object)"--no-initial-controllers", (List)new .colon.colon((Object)"--release-version", (List)new .colon.colon((Object)"3.9-IV0", (List)Nil$.MODULE$))), this.runFormatCommand$default$4()));
        Assertions.assertTrue((boolean)stream.toString().contains(new StringOps(Predef$.MODULE$.augmentString("Formatting metadata directory %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{availableDirs.head()}))), (String)new StringBuilder(34).append("Failed to find content in output: ").append(stream.toString()).toString());
    }

    @Test
    public void testFormatWithoutStaticQuorumSucceedsWithoutInitialControllersOnBroker() {
        .colon.colon availableDirs = new .colon.colon((Object)TestUtils$.MODULE$.tempDir(), (List)Nil$.MODULE$);
        Properties properties = new Properties();
        properties.putAll((Map<?, ?>)this.defaultDynamicQuorumProperties());
        properties.setProperty("listeners", "PLAINTEXT://:9092");
        properties.setProperty("advertised.listeners", "PLAINTEXT://127.0.0.1:9092");
        properties.setProperty("process.roles", "broker");
        properties.setProperty("log.dirs", availableDirs.mkString(","));
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        Assertions.assertEquals((int)0, (int)this.runFormatCommand(stream, properties, (Seq<String>)new .colon.colon((Object)"--release-version", (List)new .colon.colon((Object)"3.9-IV0", (List)Nil$.MODULE$)), this.runFormatCommand$default$4()));
        Assertions.assertTrue((boolean)stream.toString().contains(new StringOps(Predef$.MODULE$.augmentString("Formatting metadata directory %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{availableDirs.head()}))), (String)new StringBuilder(34).append("Failed to find content in output: ").append(stream.toString()).toString());
    }

    @Test
    public void testBootstrapScramRecords() {
        .colon.colon availableDirs = new .colon.colon((Object)TestUtils$.MODULE$.tempDir(), (List)Nil$.MODULE$);
        Properties properties = new Properties();
        properties.putAll((Map<?, ?>)this.defaultStaticQuorumProperties());
        properties.setProperty("log.dirs", availableDirs.mkString(","));
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        ListBuffer arguments = (ListBuffer)ListBuffer$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"--release-version", "3.9-IV0", "--add-scram", "SCRAM-SHA-512=[name=alice,password=changeit]", "--add-scram", "SCRAM-SHA-512=[name=bob,password=changeit]"}));
        Assertions.assertEquals((int)0, (int)this.runFormatCommand(stream, properties, (Seq<String>)arguments.toSeq(), this.runFormatCommand$default$4()));
        BootstrapMetadata bootstrapMetadata = new BootstrapDirectory(((File)availableDirs.head()).toString(), Optional.empty()).read();
        List scramRecords = ((TraversableOnce)((TraversableLike)((TraversableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(bootstrapMetadata.records()).asScala()).filter((Function1 & Serializable & scala.Serializable)apiMessageAndVersion -> BoxesRunTime.boxToBoolean((boolean)StorageToolTest.$anonfun$testBootstrapScramRecords$1(apiMessageAndVersion)))).map((Function1 & Serializable & scala.Serializable)apiMessageAndVersion -> (UserScramCredentialRecord)apiMessageAndVersion.message(), Buffer$.MODULE$.canBuildFrom())).toList();
        Assertions.assertEquals((int)2, (int)scramRecords.size());
        Assertions.assertEquals((Object)"alice", (Object)((UserScramCredentialRecord)scramRecords.head()).name());
        Assertions.assertEquals((Object)"bob", (Object)((UserScramCredentialRecord)scramRecords.last()).name());
    }

    @Test
    public void testScramRecordsOldReleaseVersion() {
        .colon.colon availableDirs = new .colon.colon((Object)TestUtils$.MODULE$.tempDir(), (List)Nil$.MODULE$);
        Properties properties = new Properties();
        properties.putAll((Map<?, ?>)this.defaultStaticQuorumProperties());
        properties.setProperty("log.dirs", availableDirs.mkString(","));
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        ListBuffer arguments = (ListBuffer)ListBuffer$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"--release-version", "3.4", "--add-scram", "SCRAM-SHA-512=[name=alice,password=changeit]", "--add-scram", "SCRAM-SHA-512=[name=bob,password=changeit]"}));
        Assertions.assertEquals((Object)"SCRAM is only supported in metadata.version 3.5-IV2 or later.", (Object)Assertions.assertThrows(FormatterException.class, () -> this.runFormatCommand(stream, properties, (Seq<String>)arguments.toSeq(), this.runFormatCommand$default$4())).getMessage());
    }

    @Test
    public void testParseNameAndLevel() {
        Assertions.assertEquals((Object)new Tuple2((Object)"foo.bar", (Object)BoxesRunTime.boxToShort((short)((short)56))), (Object)StorageTool$.MODULE$.parseNameAndLevel("foo.bar=56"));
    }

    @Test
    public void testParseNameAndLevelWithNoEquals() {
        Assertions.assertEquals((Object)"Can't parse feature=level string kraft.version5: equals sign not found.", (Object)Assertions.assertThrows(RuntimeException.class, () -> StorageTool$.MODULE$.parseNameAndLevel("kraft.version5")).getMessage());
    }

    @Test
    public void testParseNameAndLevelWithNoNumber() {
        Assertions.assertEquals((Object)"Can't parse feature=level string kraft.version=foo: unable to parse foo as a short.", (Object)Assertions.assertThrows(RuntimeException.class, () -> StorageTool$.MODULE$.parseNameAndLevel("kraft.version=foo")).getMessage());
    }

    public static final /* synthetic */ void $anonfun$testFormatSucceedsIfAllDirectoriesAreAvailable$1(ByteArrayOutputStream stream$1, File dir) {
        Assertions.assertTrue((boolean)stream$1.toString().contains(new StringOps(Predef$.MODULE$.augmentString("Formatting data directory %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{dir}))), (String)new StringBuilder(34).append("Failed to find content in output: ").append(stream$1.toString()).toString());
    }

    public static final /* synthetic */ boolean $anonfun$testBootstrapScramRecords$1(ApiMessageAndVersion apiMessageAndVersion) {
        return apiMessageAndVersion.message() instanceof UserScramCredentialRecord;
    }

    public StorageToolTest() {
        this.defaultStaticQuorumProperties().setProperty("process.roles", "broker");
        this.defaultStaticQuorumProperties().setProperty("node.id", "0");
        this.defaultStaticQuorumProperties().setProperty("controller.listener.names", "CONTROLLER");
        this.defaultStaticQuorumProperties().setProperty("controller.quorum.voters", "100@localhost:9093");
        this.defaultDynamicQuorumProperties = new Properties();
        this.defaultDynamicQuorumProperties().setProperty("process.roles", "controller");
        this.defaultDynamicQuorumProperties().setProperty("node.id", "0");
        this.defaultDynamicQuorumProperties().setProperty("controller.listener.names", "CONTROLLER");
        this.defaultDynamicQuorumProperties().setProperty("controller.quorum.bootstrap.servers", "localhost:9093");
        this.defaultDynamicQuorumProperties().setProperty("listeners", "CONTROLLER://:9093");
        this.defaultDynamicQuorumProperties().setProperty("advertised.listeners", "CONTROLLER://127.0.0.1:9093");
        this.defaultDynamicQuorumProperties().setProperty("unstable.api.versions.enable", "true");
        this.defaultDynamicQuorumProperties().setProperty("unstable.feature.versions.enable", "true");
    }
}

