/*
 * Decompiled with CFR 0.152.
 */
package kafka.docker;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import kafka.Kafka$;
import kafka.docker.Constants$;
import kafka.tools.StorageTool$;
import kafka.utils.Exit$;
import kafka.utils.Logging;
import net.sourceforge.argparse4j.ArgumentParsers;
import net.sourceforge.argparse4j.impl.Arguments;
import net.sourceforge.argparse4j.inf.ArgumentAction;
import net.sourceforge.argparse4j.inf.ArgumentParser;
import net.sourceforge.argparse4j.inf.Namespace;
import net.sourceforge.argparse4j.inf.Subparser;
import net.sourceforge.argparse4j.inf.Subparsers;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Iterable$;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.io.BufferedSource;
import scala.io.Codec$;
import scala.io.Source$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.sys.package$;

public final class KafkaDockerWrapper$
implements Logging {
    public static KafkaDockerWrapper$ MODULE$;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    static {
        new KafkaDockerWrapper$();
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public void main(String[] args) {
        Namespace namespace = this.parseArguments(args);
        String command = namespace.getString("command");
        if ("setup".equals(command)) {
            Path defaultConfigsPath = Paths.get(namespace.getString("default_configs_dir"), new String[0]);
            Path mountedConfigsPath = Paths.get(namespace.getString("mounted_configs_dir"), new String[0]);
            Path finalConfigsPath = Paths.get(namespace.getString("final_configs_dir"), new String[0]);
            try {
                this.prepareConfigs(defaultConfigsPath, mountedConfigsPath, finalConfigsPath);
            }
            catch (Throwable e) {
                String errMsg = new StringBuilder(31).append("error while preparing configs: ").append(e.getMessage()).toString();
                System.err.println(errMsg);
                throw Exit$.MODULE$.exit(1, (Option<String>)new Some((Object)errMsg));
            }
            String[] formatCmd = this.formatStorageCmd(finalConfigsPath, this.envVars());
            StorageTool$.MODULE$.main(formatCmd);
            return;
        }
        if ("start".equals(command)) {
            String configFile = namespace.getString("config");
            if (this.logger().underlying().isInfoEnabled()) {
                this.logger().underlying().info(this.msgWithLogIdent(KafkaDockerWrapper$.$anonfun$main$1()));
            }
            Kafka$.MODULE$.main((String[])((Object[])new String[]{configFile}));
            return;
        }
        throw new RuntimeException(new StringBuilder(62).append("Unknown operation ").append(command).append(". ").append("Please provide a valid operation: 'setup'.").toString());
    }

    private Namespace parseArguments(String[] args) {
        ArgumentParser parser = ArgumentParsers.newArgumentParser((String)"kafka-docker-wrapper", (boolean)true, (String)"-", (String)"@").description("The Kafka docker wrapper.");
        Subparsers subparsers = parser.addSubparsers().dest("command");
        subparsers.addParser("start").help("Start kafka server.").addArgument(new String[]{"--config", "-C"}).action((ArgumentAction)Arguments.store()).required(true).help("The kafka server configuration file");
        Subparser setupParser = subparsers.addParser("setup").help("Setup property files and format storage.");
        setupParser.addArgument(new String[]{"--default-configs-dir", "-D"}).action((ArgumentAction)Arguments.store()).required(true).help(new StringOps(Predef$.MODULE$.augmentString("Directory which holds default properties. It should contain the three file:-\n          |server.properties, log4j.properties and tools-log4j.properties.\n          |")).stripMargin());
        setupParser.addArgument(new String[]{"--mounted-configs-dir", "-M"}).action((ArgumentAction)Arguments.store()).required(true).help(new StringOps(Predef$.MODULE$.augmentString("Directory which holds user mounted properties. It can contain none to all the three files:-\n          |server.properties, log4j.properties and tools-log4j.properties.")).stripMargin());
        setupParser.addArgument(new String[]{"--final-configs-dir", "-F"}).action((ArgumentAction)Arguments.store()).required(true).help(new StringOps(Predef$.MODULE$.augmentString("Directory which holds final properties. It holds the final properties that will be used to boot kafka.\n          |")).stripMargin());
        return parser.parseArgsOrFail(args);
    }

    /*
     * WARNING - void declaration
     */
    public String[] formatStorageCmd(Path configsPath, Map<String, String> env) {
        void var4_4;
        Option option = env.get((Object)"CLUSTER_ID");
        if (!(option instanceof Some)) {
            if (None$.MODULE$.equals(option)) {
                throw new RuntimeException("CLUSTER_ID environment variable is not set.");
            }
            throw new MatchError((Object)option);
        }
        String str = (String)((Some)option).value();
        return (String[])((Object[])new String[]{"format", new StringBuilder(13).append("--cluster-id=").append((String)var4_4).toString(), "-c", new StringBuilder(18).append(((Object)configsPath).toString()).append("/server.properties").toString()});
    }

    private void prepareConfigs(Path defaultConfigsPath, Path mountedConfigsPath, Path finalConfigsPath) {
        this.prepareServerConfigs(defaultConfigsPath, mountedConfigsPath, finalConfigsPath, this.envVars());
        this.prepareLog4jConfigs(defaultConfigsPath, mountedConfigsPath, finalConfigsPath, this.envVars());
        this.prepareToolsLog4jConfigs(defaultConfigsPath, mountedConfigsPath, finalConfigsPath, this.envVars());
    }

    public void prepareServerConfigs(Path defaultConfigsPath, Path mountedConfigsPath, Path finalConfigsPath, Map<String, String> env) {
        String string;
        String propsToAdd = this.addNewlinePadding(this.getServerConfigsFromEnv(env).mkString(Constants$.MODULE$.NewlineChar()));
        Path defaultFilePath = defaultConfigsPath.resolve(String.valueOf(Constants$.MODULE$.ServerPropsFilename()));
        Path mountedFilePath = mountedConfigsPath.resolve(String.valueOf(Constants$.MODULE$.ServerPropsFilename()));
        Path finalFilePath = finalConfigsPath.resolve(String.valueOf(Constants$.MODULE$.ServerPropsFilename()));
        if (Files.exists(mountedFilePath, new LinkOption[0])) {
            this.copyFile(mountedFilePath, finalFilePath);
            this.addToFile(propsToAdd, finalFilePath, StandardOpenOption.APPEND);
        } else {
            this.addToFile(propsToAdd, finalFilePath, StandardOpenOption.TRUNCATE_EXISTING);
        }
        try (BufferedSource source = Source$.MODULE$.fromFile(((Object)finalFilePath).toString(), Codec$.MODULE$.fallbackSystemCodec());){
            string = source.mkString();
        }
        if (string.trim().isEmpty()) {
            this.copyFile(defaultFilePath, finalFilePath);
            return;
        }
    }

    public void prepareLog4jConfigs(Path defaultConfigsPath, Path mountedConfigsPath, Path finalConfigsPath, Map<String, String> env) {
        String propsToAdd = this.getLog4jConfigsFromEnv(env);
        Path defaultFilePath = defaultConfigsPath.resolve(String.valueOf(Constants$.MODULE$.Log4jPropsFilename()));
        Path mountedFilePath = mountedConfigsPath.resolve(String.valueOf(Constants$.MODULE$.Log4jPropsFilename()));
        Path finalFilePath = finalConfigsPath.resolve(String.valueOf(Constants$.MODULE$.Log4jPropsFilename()));
        this.copyFile(defaultFilePath, finalFilePath);
        this.copyFile(mountedFilePath, finalFilePath);
        this.addToFile(propsToAdd, finalFilePath, StandardOpenOption.APPEND);
    }

    public void prepareToolsLog4jConfigs(Path defaultConfigsPath, Path mountedConfigsPath, Path finalConfigsPath, Map<String, String> env) {
        String propToAdd = this.getToolsLog4jConfigsFromEnv(env);
        Path defaultFilePath = defaultConfigsPath.resolve(String.valueOf(Constants$.MODULE$.ToolsLog4jFilename()));
        Path mountedFilePath = mountedConfigsPath.resolve(String.valueOf(Constants$.MODULE$.ToolsLog4jFilename()));
        Path finalFilePath = finalConfigsPath.resolve(String.valueOf(Constants$.MODULE$.ToolsLog4jFilename()));
        this.copyFile(defaultFilePath, finalFilePath);
        this.copyFile(mountedFilePath, finalFilePath);
        this.addToFile(propToAdd, finalFilePath, StandardOpenOption.APPEND);
    }

    public List<String> getServerConfigsFromEnv(Map<String, String> env) {
        return (List)((TraversableOnce)env.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            if (x0$1 != null) {
                String key = (String)x0$1._1();
                String value = (String)x0$1._2();
                if (key.startsWith("KAFKA_") && !Constants$.MODULE$.ExcludeServerPropsEnv().contains((Object)key)) {
                    String final_key = key.replace("KAFKA_", "").toLowerCase().replace("_", ".").replace("...", "-").replace("..", "_");
                    return new StringBuilder(1).append(final_key).append("=").append(value).toString();
                }
                return "";
            }
            throw new MatchError(null);
        }, Iterable$.MODULE$.canBuildFrom())).toList().filterNot((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)KafkaDockerWrapper$.$anonfun$getServerConfigsFromEnv$2(x$1)));
    }

    public String getLog4jConfigsFromEnv(Map<String, String> env) {
        String kafkaLog4jRootLogLevelProp = (String)env.get((Object)Constants$.MODULE$.KafkaLog4jRootLoglevelEnv()).filter((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)KafkaDockerWrapper$.$anonfun$getLog4jConfigsFromEnv$1(x$2))).map((Function1 & Serializable & scala.Serializable)kafkaLog4jRootLogLevel -> new StringBuilder(25).append("log4j.rootLogger=").append((String)kafkaLog4jRootLogLevel).append(", stdout").toString()).getOrElse((Function0 & Serializable & scala.Serializable)() -> "");
        String kafkaLog4jLoggersProp = (String)env.get((Object)Constants$.MODULE$.KafkaLog4JLoggersEnv()).filter((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)KafkaDockerWrapper$.$anonfun$getLog4jConfigsFromEnv$4(x$3))).map((Function1 & Serializable & scala.Serializable)kafkaLog4JLoggersString -> new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])kafkaLog4JLoggersString.split(","))).map((Function1 & Serializable & scala.Serializable)kafkaLog4JLogger -> new StringBuilder(13).append("log4j.logger.").append((String)kafkaLog4JLogger).toString(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).mkString(Constants$.MODULE$.NewlineChar())).getOrElse((Function0 & Serializable & scala.Serializable)() -> "");
        return new StringBuilder(0).append(this.addNewlinePadding(kafkaLog4jRootLogLevelProp)).append(this.addNewlinePadding(kafkaLog4jLoggersProp)).toString();
    }

    public String getToolsLog4jConfigsFromEnv(Map<String, String> env) {
        return (String)env.get((Object)Constants$.MODULE$.KafkaToolsLog4jLoglevelEnv()).filter((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)KafkaDockerWrapper$.$anonfun$getToolsLog4jConfigsFromEnv$1(x$4))).map((Function1 & Serializable & scala.Serializable)kafkaToolsLog4jLogLevel -> MODULE$.addNewlinePadding(new StringBuilder(25).append("log4j.rootLogger=").append((String)kafkaToolsLog4jLogLevel).append(", stderr").toString())).getOrElse((Function0 & Serializable & scala.Serializable)() -> "");
    }

    private void addToFile(String properties, Path filepath, StandardOpenOption mode) {
        if (!Files.exists(filepath, new LinkOption[0])) {
            Files.createFile(filepath, new FileAttribute[0]);
        }
        Files.write(filepath, properties.getBytes(StandardCharsets.UTF_8), mode);
    }

    private Object copyFile(Path source, Path destination) {
        if (Files.exists(source, new LinkOption[0])) {
            return Files.copy(source, destination, StandardCopyOption.REPLACE_EXISTING);
        }
        return BoxedUnit.UNIT;
    }

    private String addNewlinePadding(String str) {
        if (new StringOps(Predef$.MODULE$.augmentString(str)).nonEmpty()) {
            return new StringBuilder(0).append(Constants$.MODULE$.NewlineChar()).append(str).toString();
        }
        return "";
    }

    private Map<String, String> envVars() {
        return package$.MODULE$.env();
    }

    public static final /* synthetic */ String $anonfun$main$1() {
        return "Starting Kafka server in the native mode.";
    }

    public static final /* synthetic */ boolean $anonfun$getServerConfigsFromEnv$2(String x$1) {
        return x$1.trim().isEmpty();
    }

    public static final /* synthetic */ boolean $anonfun$getLog4jConfigsFromEnv$1(String x$2) {
        return new StringOps(Predef$.MODULE$.augmentString(x$2)).nonEmpty();
    }

    public static final /* synthetic */ boolean $anonfun$getLog4jConfigsFromEnv$4(String x$3) {
        return new StringOps(Predef$.MODULE$.augmentString(x$3)).nonEmpty();
    }

    public static final /* synthetic */ boolean $anonfun$getToolsLog4jConfigsFromEnv$1(String x$4) {
        return new StringOps(Predef$.MODULE$.augmentString(x$4)).nonEmpty();
    }

    private KafkaDockerWrapper$() {
        MODULE$ = this;
        Logging.$init$(this);
    }
}

