/*
 * Decompiled with CFR 0.152.
 */
package kafka.network;

import com.typesafe.scalalogging.Logger;
import com.yammer.metrics.core.Meter;
import java.io.Serializable;
import java.net.InetAddress;
import java.nio.channels.SocketChannel;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import kafka.network.Processor$;
import kafka.network.SocketServer$;
import kafka.server.KafkaConfig;
import kafka.utils.Logging;
import kafka.utils.QuotaUtils$;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.Reconfigurable;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.metrics.KafkaMetric;
import org.apache.kafka.common.metrics.MeasurableStat;
import org.apache.kafka.common.metrics.MetricConfig;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.metrics.Quota;
import org.apache.kafka.common.metrics.QuotaViolationException;
import org.apache.kafka.common.metrics.Sensor;
import org.apache.kafka.common.metrics.stats.Avg;
import org.apache.kafka.common.metrics.stats.Rate;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.network.ListenerReconfigurable;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.network.ConnectionQuotaEntity;
import org.apache.kafka.network.ConnectionThrottledException;
import org.apache.kafka.network.TooManyConnectionsException;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.Map$;
import scala.jdk.CollectionConverters$;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\rmg\u0001B*U\u0001eC\u0001B\u001c\u0001\u0003\u0002\u0003\u0006Ia\u001c\u0005\tk\u0002\u0011\t\u0011)A\u0005m\"Q\u0011Q\u0001\u0001\u0003\u0002\u0003\u0006I!a\u0002\t\u000f\u0005E\u0001\u0001\"\u0001\u0002\u0014!I\u0011q\u0004\u0001A\u0002\u0013%\u0011\u0011\u0005\u0005\n\u0003S\u0001\u0001\u0019!C\u0005\u0003WA\u0001\"a\u000e\u0001A\u0003&\u00111\u0005\u0005\n\u0003\u0003\u0002\u0001\u0019!C\u0005\u0003\u0007B\u0011\"!\u0018\u0001\u0001\u0004%I!a\u0018\t\u0011\u0005\r\u0004\u0001)Q\u0005\u0003\u000bB\u0011\"a\u001a\u0001\u0001\u0004%I!!\u001b\t\u0013\u0005E\u0004\u00011A\u0005\n\u0005M\u0004\u0002CA<\u0001\u0001\u0006K!a\u001b\t\u0013\u0005m\u0004A1A\u0005\n\u0005u\u0004\u0002CAE\u0001\u0001\u0006I!a \t\u0013\u0005-\u0005A1A\u0005\n\u00055\u0005\u0002CAM\u0001\u0001\u0006I!a$\t\u0013\u0005m\u0005A1A\u0005\n\u0005u\u0005\u0002CAQ\u0001\u0001\u0006I!a(\t\u0015\u0005\r\u0006A1A\u0005\u0002Q\u000b)\u000b\u0003\u0005\u0003\u0002\u0002\u0001\u000b\u0011BAT\u0011%\u0011\u0019\t\u0001a\u0001\n\u0013\t\t\u0003C\u0005\u0003\u0006\u0002\u0001\r\u0011\"\u0003\u0003\b\"A!1\u0012\u0001!B\u0013\t\u0019\u0003C\u0005\u0003\u0010\u0002\u0001\r\u0011\"\u0003\u0002\"!I!\u0011\u0013\u0001A\u0002\u0013%!1\u0013\u0005\t\u0005/\u0003\u0001\u0015)\u0003\u0002$!I!1\u0014\u0001C\u0002\u0013%!Q\u0014\u0005\t\u0005W\u0003\u0001\u0015!\u0003\u0003 \"I!Q\u0016\u0001C\u0002\u0013%\u0011Q\u001b\u0005\t\u0005_\u0003\u0001\u0015!\u0003\u0002X\"I!\u0011\u0017\u0001C\u0002\u0013%!1\u0017\u0005\t\u0005w\u0003\u0001\u0015!\u0003\u00036\"9!Q\u0018\u0001\u0005\u0002\t}\u0006\u0002\u0003Bq\u0001\u0011\u0005AKa9\t\u0011\t%\b\u0001\"\u0001U\u0005WD\u0001Ba=\u0001\t\u0003!&Q\u001f\u0005\t\u0005s\u0004A\u0011\u0001+\u0003|\"91\u0011\u0001\u0001\u0005\u0002\r\r\u0001bBB\n\u0001\u0011\u00051Q\u0003\u0005\t\u00073\u0001A\u0011\u0001+\u0004\u001c!A1\u0011\u0005\u0001\u0005\u0002Q\u001b\u0019\u0003C\u0004\u0004*\u0001!\taa\u000b\t\u000f\rE\u0002\u0001\"\u0001\u00044!91q\u0007\u0001\u0005\n\re\u0002bBB \u0001\u0011\u00051\u0011\t\u0005\b\u0007\u0017\u0002A\u0011BB'\u0011\u001d\u0019\t\u0006\u0001C\u0005\u0007'Bqaa\u0016\u0001\t\u0013\u0019I\u0006C\u0004\u0004^\u0001!Iaa\u0018\t\u000f\r\u001d\u0004\u0001\"\u0003\u0004j!911\u000f\u0001\u0005\n\rU\u0004bBB>\u0001\u0011%1Q\u0010\u0005\b\u0007\u000b\u0003A\u0011BBD\u0011\u001d\u0019Y\n\u0001C\u0005\u0007;Cqaa)\u0001\t\u0013\u0019)\u000bC\u0004\u00042\u0002!Iaa-\t\u000f\t]\u0003\u0001\"\u0001\u0003Z\u00191\u0011Q\u0016\u0001\u0001\u0003_C!\"!0<\u0005\u0003\u0005\u000b\u0011BAY\u0011)\tyl\u000fB\u0001B\u0003%\u0011q\u0010\u0005\b\u0003#YD\u0011AAa\u0011%\t9m\u000fa\u0001\n\u0013\t\t\u0003C\u0005\u0002Jn\u0002\r\u0011\"\u0003\u0002L\"A\u0011qZ\u001e!B\u0013\t\u0019\u0003\u0003\u0006\u0002Tn\u0012\r\u0011\"\u0001U\u0003+D\u0001\"!8<A\u0003%\u0011q\u001b\u0005\u000b\u0003?\\$\u0019!C\u0001)\u0006U\u0007\u0002CAqw\u0001\u0006I!a6\t\u0015\u0005\r8H1A\u0005\u0002Q\u000b)\u000e\u0003\u0005\u0002fn\u0002\u000b\u0011BAl\u0011\u001d\t9o\u000fC\u0001\u0003CAq!!;<\t\u0003\nY\u000fC\u0004\u0002nn\"\t%a<\t\u000f\t52\b\"\u0011\u00030!9!qG\u001e\u0005B\te\u0002b\u0002B$w\u0011\u0005#\u0011\n\u0005\b\u0005/ZD\u0011\u0001B-\u0011\u001d\t9o\u000fC\u0005\u00057BqA!\u001b<\t\u0013\u0011Y\u0007C\u0004\u0003zm\"IAa\u001f\t\u000f\ru\u0006\u0001\"\u0001\u0004@\n\u00012i\u001c8oK\u000e$\u0018n\u001c8Rk>$\u0018m\u001d\u0006\u0003+Z\u000bqA\\3uo>\u00148NC\u0001X\u0003\u0015Y\u0017MZ6b\u0007\u0001\u0019B\u0001\u0001.aMB\u00111LX\u0007\u00029*\tQ,A\u0003tG\u0006d\u0017-\u0003\u0002`9\n1\u0011I\\=SK\u001a\u0004\"!\u00193\u000e\u0003\tT!a\u0019,\u0002\u000bU$\u0018\u000e\\:\n\u0005\u0015\u0014'a\u0002'pO\u001eLgn\u001a\t\u0003O2l\u0011\u0001\u001b\u0006\u0003S*\fA\u0001\\1oO*\t1.\u0001\u0003kCZ\f\u0017BA7i\u00055\tU\u000f^8DY>\u001cX-\u00192mK\u000611m\u001c8gS\u001e\u0004\"\u0001]:\u000e\u0003ET!A\u001d,\u0002\rM,'O^3s\u0013\t!\u0018OA\u0006LC\u001a\\\u0017mQ8oM&<\u0017\u0001\u0002;j[\u0016\u00042a^A\u0001\u001b\u0005A(BA2z\u0015\tQ80\u0001\u0004d_6lwN\u001c\u0006\u0003/rT!! @\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005y\u0018aA8sO&\u0019\u00111\u0001=\u0003\tQKW.Z\u0001\b[\u0016$(/[2t!\u0011\tI!!\u0004\u000e\u0005\u0005-!bAA\u0003s&!\u0011qBA\u0006\u0005\u001diU\r\u001e:jGN\fa\u0001P5oSRtD\u0003CA\u000b\u00033\tY\"!\b\u0011\u0007\u0005]\u0001!D\u0001U\u0011\u0015qG\u00011\u0001p\u0011\u0015)H\u00011\u0001w\u0011\u001d\t)\u0001\u0002a\u0001\u0003\u000f\t!\u0004Z3gCVdG/T1y\u0007>tg.Z2uS>t7\u000fU3s\u0013B,\"!a\t\u0011\u0007m\u000b)#C\u0002\u0002(q\u00131!\u00138u\u0003y!WMZ1vYRl\u0015\r_\"p]:,7\r^5p]N\u0004VM]%q?\u0012*\u0017\u000f\u0006\u0003\u0002.\u0005M\u0002cA.\u00020%\u0019\u0011\u0011\u0007/\u0003\tUs\u0017\u000e\u001e\u0005\n\u0003k1\u0011\u0011!a\u0001\u0003G\t1\u0001\u001f\u00132\u0003m!WMZ1vYRl\u0015\r_\"p]:,7\r^5p]N\u0004VM]%qA!\u001aq!a\u000f\u0011\u0007m\u000bi$C\u0002\u0002@q\u0013\u0001B^8mCRLG.Z\u0001\u001d[\u0006D8i\u001c8oK\u000e$\u0018n\u001c8t!\u0016\u0014\u0018\n](wKJ\u0014\u0018\u000eZ3t+\t\t)\u0005\u0005\u0005\u0002H\u00055\u0013\u0011KA\u0012\u001b\t\tIEC\u0002\u0002Lq\u000b!bY8mY\u0016\u001cG/[8o\u0013\u0011\ty%!\u0013\u0003\u00075\u000b\u0007\u000f\u0005\u0003\u0002T\u0005eSBAA+\u0015\r\t9F[\u0001\u0004]\u0016$\u0018\u0002BA.\u0003+\u00121\"\u00138fi\u0006#GM]3tg\u0006\u0001S.\u0019=D_:tWm\u0019;j_:\u001c\b+\u001a:Ja>3XM\u001d:jI\u0016\u001cx\fJ3r)\u0011\ti#!\u0019\t\u0013\u0005U\u0012\"!AA\u0002\u0005\u0015\u0013!H7bq\u000e{gN\\3di&|gn\u001d)fe&\u0003xJ^3se&$Wm\u001d\u0011)\u0007)\tY$\u0001\u000bce>\\WM]'bq\u000e{gN\\3di&|gn]\u000b\u0003\u0003W\u00022aZA7\u0013\r\ty\u0007\u001b\u0002\b\u0013:$XmZ3s\u0003a\u0011'o\\6fe6\u000b\u0007pQ8o]\u0016\u001cG/[8og~#S-\u001d\u000b\u0005\u0003[\t)\bC\u0005\u000261\t\t\u00111\u0001\u0002l\u0005)\"M]8lKJl\u0015\r_\"p]:,7\r^5p]N\u0004\u0003fA\u0007\u0002<\u00059\u0012N\u001c;fe\n\u0013xn[3s\u0019&\u001cH/\u001a8fe:\u000bW.Z\u000b\u0003\u0003\u007f\u0002B!!!\u0002\u00066\u0011\u00111\u0011\u0006\u0003+fLA!a\"\u0002\u0004\naA*[:uK:,'OT1nK\u0006A\u0012N\u001c;fe\n\u0013xn[3s\u0019&\u001cH/\u001a8fe:\u000bW.\u001a\u0011\u0002\r\r|WO\u001c;t+\t\ty\t\u0005\u0005\u0002\u0012\u0006]\u0015\u0011KA\u0012\u001b\t\t\u0019J\u0003\u0003\u0002\u0016\u0006%\u0013aB7vi\u0006\u0014G.Z\u0005\u0005\u0003\u001f\n\u0019*A\u0004d_VtGo\u001d\u0011\u0002\u001d1L7\u000f^3oKJ\u001cu.\u001e8ugV\u0011\u0011q\u0014\t\t\u0003#\u000b9*a \u0002$\u0005yA.[:uK:,'oQ8v]R\u001c\b%A\rnCb\u001cuN\u001c8fGRLwN\\:QKJd\u0015n\u001d;f]\u0016\u0014XCAAT!!\t\t*a&\u0002\u0000\u0005%\u0006cAAVw5\t\u0001AA\fMSN$XM\\3s\u0007>tg.Z2uS>t\u0017+^8uCN11(!-\u00028\u001a\u00042aZAZ\u0013\r\t)\f\u001b\u0002\u0007\u001f\nTWm\u0019;\u0011\t\u0005\u0005\u0015\u0011X\u0005\u0005\u0003w\u000b\u0019I\u0001\fMSN$XM\\3s%\u0016\u001cwN\u001c4jOV\u0014\u0018M\u00197f\u0003\u0011awnY6\u0002\u00111L7\u000f^3oKJ$b!!+\u0002D\u0006\u0015\u0007bBA_}\u0001\u0007\u0011\u0011\u0017\u0005\b\u0003\u007fs\u0004\u0019AA@\u0003=yV.\u0019=D_:tWm\u0019;j_:\u001c\u0018aE0nCb\u001cuN\u001c8fGRLwN\\:`I\u0015\fH\u0003BA\u0017\u0003\u001bD\u0011\"!\u000eA\u0003\u0003\u0005\r!a\t\u0002!}k\u0017\r_\"p]:,7\r^5p]N\u0004\u0003fA!\u0002<\u0005!2m\u001c8oK\u000e$\u0018n\u001c8SCR,7+\u001a8t_J,\"!a6\u0011\t\u0005%\u0011\u0011\\\u0005\u0005\u00037\fYA\u0001\u0004TK:\u001cxN]\u0001\u0016G>tg.Z2uS>t'+\u0019;f'\u0016t7o\u001c:!\u0003\u0011b\u0017n\u001d;f]\u0016\u00148i\u001c8oK\u000e$\u0018n\u001c8SCR,G\u000b\u001b:piRdWmU3og>\u0014\u0018!\n7jgR,g.\u001a:D_:tWm\u0019;j_:\u0014\u0016\r^3UQJ|G\u000f\u001e7f'\u0016t7o\u001c:!\u0003yI\u0007oQ8o]\u0016\u001cG/[8o%\u0006$X\r\u00165s_R$H.Z*f]N|'/A\u0010ja\u000e{gN\\3di&|gNU1uKRC'o\u001c;uY\u0016\u001cVM\\:pe\u0002\na\"\\1y\u0007>tg.Z2uS>t7/\u0001\u0007mSN$XM\\3s\u001d\u0006lW\r\u0006\u0002\u0002\u0000\u0005I1m\u001c8gS\u001e,(/\u001a\u000b\u0005\u0003[\t\t\u0010C\u0004\u0002t*\u0003\r!!>\u0002\u000f\r|gNZ5hgB\"\u0011q\u001fB\u000e!!\tI0a@\u0003\u0002\t]QBAA~\u0015\r\tiP[\u0001\u0005kRLG.\u0003\u0003\u0002P\u0005m\b\u0003\u0002B\u0002\u0005#qAA!\u0002\u0003\u000eA\u0019!q\u0001/\u000e\u0005\t%!b\u0001B\u00061\u00061AH]8pizJ1Aa\u0004]\u0003\u0019\u0001&/\u001a3fM&!!1\u0003B\u000b\u0005\u0019\u0019FO]5oO*\u0019!q\u0002/\u0011\t\te!1\u0004\u0007\u0001\t1\u0011i\"!=\u0002\u0002\u0003\u0005)\u0011\u0001B\u0010\u0005\ryF\u0005N\t\u0005\u0005C\u00119\u0003E\u0002\\\u0005GI1A!\n]\u0005\u001dqu\u000e\u001e5j]\u001e\u00042a\u0017B\u0015\u0013\r\u0011Y\u0003\u0018\u0002\u0004\u0003:L\u0018!\u0006:fG>tg-[4ve\u0006\u0014G.Z\"p]\u001aLwm\u001d\u000b\u0003\u0005c\u0001b!!?\u00034\t\u0005\u0011\u0002\u0002B\u001b\u0003w\u00141aU3u\u0003]1\u0018\r\\5eCR,'+Z2p]\u001aLw-\u001e:bi&|g\u000e\u0006\u0003\u0002.\tm\u0002bBAz\u0019\u0002\u0007!Q\b\u0019\u0005\u0005\u007f\u0011\u0019\u0005\u0005\u0005\u0002z\u0006}(\u0011\u0001B!!\u0011\u0011IBa\u0011\u0005\u0019\t\u0015#1HA\u0001\u0002\u0003\u0015\tAa\b\u0003\u0007}#S'A\u0006sK\u000e|gNZ5hkJ,G\u0003BA\u0017\u0005\u0017Bq!a=N\u0001\u0004\u0011i\u0005\r\u0003\u0003P\tM\u0003\u0003CA}\u0003\u007f\u0014\tA!\u0015\u0011\t\te!1\u000b\u0003\r\u0005+\u0012Y%!A\u0001\u0002\u000b\u0005!q\u0004\u0002\u0004?\u00122\u0014!B2m_N,GCAA\u0017)\u0011\t\u0019C!\u0018\t\u000f\u0005Mx\n1\u0001\u0003`A\"!\u0011\rB3!!\tI0a@\u0003\u0002\t\r\u0004\u0003\u0002B\r\u0005K\"ABa\u001a\u0003^\u0005\u0005\t\u0011!B\u0001\u0005?\u00111a\u0018\u00138\u0003ei\u0017\r_\"p]:,7\r^5p]\u000e\u0013X-\u0019;j_:\u0014\u0016\r^3\u0015\t\u0005\r\"Q\u000e\u0005\b\u0003g\u0004\u0006\u0019\u0001B8a\u0011\u0011\tH!\u001e\u0011\u0011\u0005e\u0018q B\u0001\u0005g\u0002BA!\u0007\u0003v\u0011a!q\u000fB7\u0003\u0003\u0005\tQ!\u0001\u0003 \t\u0019q\f\n\u001d\u0002E\r\u0014X-\u0019;f\u0007>tg.Z2uS>t'+\u0019;f)\"\u0014x\u000e\u001e;mKN+gn]8s)\u0011\t9N! \t\u000f\t}\u0014\u000b1\u0001\u0003\u0002\u0005qA\u000f\u001b:piRdW\r\u0015:fM&D\u0018AG7bq\u000e{gN\\3di&|gn\u001d)fe2K7\u000f^3oKJ\u0004\u0013A\u0003;pi\u0006d7i\\;oi\u0006qAo\u001c;bY\u000e{WO\u001c;`I\u0015\fH\u0003BA\u0017\u0005\u0013C\u0011\"!\u000e\u0018\u0003\u0003\u0005\r!a\t\u0002\u0017Q|G/\u00197D_VtG\u000f\t\u0015\u00041\u0005m\u0012A\u00073fM\u0006,H\u000e^\"p]:,7\r^5p]J\u000bG/\u001a)fe&\u0003\u0018A\b3fM\u0006,H\u000e^\"p]:,7\r^5p]J\u000bG/\u001a)fe&\u0003x\fJ3r)\u0011\tiC!&\t\u0013\u0005U\"$!AA\u0002\u0005\r\u0012a\u00073fM\u0006,H\u000e^\"p]:,7\r^5p]J\u000bG/\u001a)fe&\u0003\b\u0005K\u0002\u001c\u0003w\t1cY8o]\u0016\u001cG/[8o%\u0006$X\rU3s\u0013B,\"Aa(\u0011\u0011\t\u0005&qUA)\u0003Gi!Aa)\u000b\t\t\u0015\u00161`\u0001\u000bG>t7-\u001e:sK:$\u0018\u0002\u0002BU\u0005G\u0013\u0011cQ8oGV\u0014(/\u001a8u\u0011\u0006\u001c\b.T1q\u0003Q\u0019wN\u001c8fGRLwN\u001c*bi\u0016\u0004VM]%qA\u0005Q\"M]8lKJ\u001cuN\u001c8fGRLwN\u001c*bi\u0016\u001cVM\\:pe\u0006Y\"M]8lKJ\u001cuN\u001c8fGRLwN\u001c*bi\u0016\u001cVM\\:pe\u0002\n\u0011#\\1y)\"\u0014x\u000e\u001e;mKRKW.Z't+\t\u0011)\fE\u0002\\\u0005oK1A!/]\u0005\u0011auN\\4\u0002%5\f\u0007\u0010\u00165s_R$H.\u001a+j[\u0016l5\u000fI\u0001\u0004S:\u001cG\u0003CA\u0017\u0005\u0003\u0014\u0019Ma2\t\u000f\u0005%(\u00051\u0001\u0002\u0000!9!Q\u0019\u0012A\u0002\u0005E\u0013aB1eIJ,7o\u001d\u0005\b\u0005\u0013\u0014\u0003\u0019\u0001Bf\u0003m\t7mY3qi>\u0014(\t\\8dW\u0016$\u0007+\u001a:dK:$X*\u001a;feB!!Q\u001aBo\u001b\t\u0011yM\u0003\u0003\u0003R\nM\u0017\u0001B2pe\u0016TA!!\u0002\u0003V*!!q\u001bBm\u0003\u0019I\u0018-\\7fe*\u0011!1\\\u0001\u0004G>l\u0017\u0002\u0002Bp\u0005\u001f\u0014Q!T3uKJ\f\u0011$\u001e9eCR,W*\u0019=D_:tWm\u0019;j_:\u001c\b+\u001a:JaR!\u0011Q\u0006Bs\u0011\u001d\u00119o\ta\u0001\u0003G\t1#\\1y\u0007>tg.Z2uS>t7\u000fU3s\u0013B\f\u0011%\u001e9eCR,W*\u0019=D_:tWm\u0019;j_:\u001c\b+\u001a:Ja>3XM\u001d:jI\u0016$B!!\f\u0003n\"9!q\u001e\u0013A\u0002\tE\u0018AD8wKJ\u0014\u0018\u000eZ3Rk>$\u0018m\u001d\t\t\u0003\u000f\niE!\u0001\u0002$\u0005QR\u000f\u001d3bi\u0016\u0014%o\\6fe6\u000b\u0007pQ8o]\u0016\u001cG/[8ogR!\u0011Q\u0006B|\u0011\u001d\t9/\na\u0001\u0003G\tQ$\u001e9eCR,'I]8lKJl\u0015\r_\"p]:,7\r^5p]J\u000bG/\u001a\u000b\u0005\u0003[\u0011i\u0010C\u0004\u0003\u0000\u001a\u0002\r!a\t\u0002#5\f\u0007pQ8o]\u0016\u001cG/[8o%\u0006$X-A\u000eva\u0012\fG/Z%q\u0007>tg.Z2uS>t'+\u0019;f#V|G/\u0019\u000b\u0007\u0003[\u0019)aa\u0004\t\u000f\r\u001dq\u00051\u0001\u0004\n\u0005\u0011\u0011\u000e\u001d\t\u00067\u000e-\u0011\u0011K\u0005\u0004\u0007\u001ba&AB(qi&|g\u000eC\u0004\u0003\u0000\u001e\u0002\ra!\u0005\u0011\u000bm\u001bY!a\t\u0002'\r|gN\\3di&|gNU1uK\u001a{'/\u00139\u0015\t\u0005\r2q\u0003\u0005\b\u0007\u000fA\u0003\u0019AA)\u0003-\tG\r\u001a'jgR,g.\u001a:\u0015\r\u000552QDB\u0010\u0011\u0015q\u0017\u00061\u0001p\u0011\u001d\tI/\u000ba\u0001\u0003\u007f\naB]3n_Z,G*[:uK:,'\u000f\u0006\u0004\u0002.\r\u00152q\u0005\u0005\u0006]*\u0002\ra\u001c\u0005\b\u0003ST\u0003\u0019AA@\u0003\r!Wm\u0019\u000b\u0007\u0003[\u0019ica\f\t\u000f\u0005%8\u00061\u0001\u0002\u0000!9!QY\u0016A\u0002\u0005E\u0013aA4fiR!\u00111EB\u001b\u0011\u001d\u0011)\r\fa\u0001\u0003#\nQc^1ji\u001a{'oQ8o]\u0016\u001cG/[8o'2|G\u000f\u0006\u0004\u0002.\rm2Q\b\u0005\b\u0003Sl\u0003\u0019AA@\u0011\u001d\u0011I-\fa\u0001\u0005\u0017\fa#\\1y\u0007>tg.Z2uS>t7/\u0012=dK\u0016$W\r\u001a\u000b\u0005\u0007\u0007\u001aI\u0005E\u0002\\\u0007\u000bJ1aa\u0012]\u0005\u001d\u0011un\u001c7fC:Dq!!;/\u0001\u0004\ty(A\fd_:tWm\u0019;j_:\u001cFn\u001c;Bm\u0006LG.\u00192mKR!11IB(\u0011\u001d\tIo\fa\u0001\u0003\u007f\n\u0011\u0003\u001d:pi\u0016\u001cG/\u001a3MSN$XM\\3s)\u0011\u0019\u0019e!\u0016\t\u000f\u0005%\b\u00071\u0001\u0002\u0000\u00051R.\u0019=MSN$XM\\3s\u0007>tg.Z2uS>t7\u000f\u0006\u0003\u0002$\rm\u0003bBAuc\u0001\u0007\u0011qP\u0001%e\u0016\u001cwN\u001d3D_:tWm\u0019;j_:\fe\u000eZ$fiRC'o\u001c;uY\u0016$\u0016.\\3NgR1!QWB1\u0007GBq!!;3\u0001\u0004\ty\bC\u0004\u0004fI\u0002\rA!.\u0002\rQLW.Z't\u0003U)\b\u000fZ1uK2K7\u000f^3oKJlU\r\u001e:jGN$\u0002\"!\f\u0004l\r54\u0011\u000f\u0005\b\u0003S\u001c\u0004\u0019AA@\u0011\u001d\u0019yg\ra\u0001\u0005k\u000b!\u0002\u001e5s_R$H.Z't\u0011\u001d\u0019)g\ra\u0001\u0005k\u000bqD]3d_J$\u0017\n]\"p]:,7\r^5p]6\u000b\u0017PY3UQJ|G\u000f\u001e7f)\u0019\tica\u001e\u0004z!9\u0011\u0011\u001e\u001bA\u0002\u0005}\u0004b\u0002Bci\u0001\u0007\u0011\u0011K\u0001\u001be\u0016\u001cwN\u001d3B]\u0012<U\r\u001e+ie>$H\u000f\\3US6,Wj\u001d\u000b\u0007\u0003G\u0019yha!\t\u000f\r\u0005U\u00071\u0001\u0002X\u000611/\u001a8t_JDqa!\u001a6\u0001\u0004\u0011),\u0001\u0013hKR|%o\u0011:fCR,7i\u001c8oK\u000e$\u0018n\u001c8SCR,\u0017+^8uCN+gn]8s)\u0019\t9n!#\u0004\u000e\"911\u0012\u001cA\u0002\u0005\r\u0012AC9v_R\fG*[7ji\"91q\u0012\u001cA\u0002\rE\u0015!F2p]:,7\r^5p]F+x\u000e^1F]RLG/\u001f\t\u0005\u0007'\u001b9*\u0004\u0002\u0004\u0016*\u0011Qk_\u0005\u0005\u00073\u001b)JA\u000bD_:tWm\u0019;j_:\fVo\u001c;b\u000b:$\u0018\u000e^=\u00023U\u0004H-\u0019;f\u0007>tg.Z2uS>t'+\u0019;f#V|G/\u0019\u000b\u0007\u0003[\u0019yj!)\t\u000f\r-u\u00071\u0001\u0002$!91qR\u001cA\u0002\rE\u0015\u0001G2p]:,7\r^5p]J\u000bG/Z'fiJL7MT1nKR!1qUBX!\u0011\u0019Ika+\u000e\u0003eL1a!,z\u0005)iU\r\u001e:jG:\u000bW.\u001a\u0005\b\u0007\u001fC\u0004\u0019ABI\u0003U\u0011\u0018\r^3Rk>$\u0018-T3ue&\u001c7i\u001c8gS\u001e$Ba!.\u0004<B!\u0011\u0011BB\\\u0013\u0011\u0019I,a\u0003\u0003\u00195+GO]5d\u0007>tg-[4\t\u000f\r-\u0015\b1\u0001\u0002$\u0005a1\r\\8tK\u000eC\u0017M\u001c8fYRA\u0011QFBa\u0007\u000b\u001c9\r\u0003\u0004\u0004DJ\u0003\r\u0001Y\u0001\u0004Y><\u0007bBAu%\u0002\u0007\u0011q\u0010\u0005\b\u0007\u0013\u0014\u0006\u0019ABf\u0003\u001d\u0019\u0007.\u00198oK2\u0004Ba!4\u0004X6\u00111q\u001a\u0006\u0005\u0007#\u001c\u0019.\u0001\u0005dQ\u0006tg.\u001a7t\u0015\r\u0019)N[\u0001\u0004]&|\u0017\u0002BBm\u0007\u001f\u0014QbU8dW\u0016$8\t[1o]\u0016d\u0007")
public class ConnectionQuotas
implements Logging,
AutoCloseable {
    private final KafkaConfig config;
    private final Time time;
    public final Metrics kafka$network$ConnectionQuotas$$metrics;
    private volatile int defaultMaxConnectionsPerIp;
    private volatile Map<InetAddress, Object> maxConnectionsPerIpOverrides;
    private volatile Integer brokerMaxConnections;
    private final ListenerName interBrokerListenerName;
    private final scala.collection.mutable.Map<InetAddress, Object> counts;
    private final scala.collection.mutable.Map<ListenerName, Object> listenerCounts;
    private final scala.collection.mutable.Map<ListenerName, ListenerConnectionQuota> maxConnectionsPerListener;
    private volatile int totalCount;
    private volatile int defaultConnectionRatePerIp;
    private final ConcurrentHashMap<InetAddress, Object> connectionRatePerIp;
    private final Sensor brokerConnectionRateSensor;
    private final long maxThrottleTimeMs;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    private int defaultMaxConnectionsPerIp() {
        return this.defaultMaxConnectionsPerIp;
    }

    private void defaultMaxConnectionsPerIp_$eq(int x$1) {
        this.defaultMaxConnectionsPerIp = x$1;
    }

    private Map<InetAddress, Object> maxConnectionsPerIpOverrides() {
        return this.maxConnectionsPerIpOverrides;
    }

    private void maxConnectionsPerIpOverrides_$eq(Map<InetAddress, Object> x$1) {
        this.maxConnectionsPerIpOverrides = x$1;
    }

    private Integer brokerMaxConnections() {
        return this.brokerMaxConnections;
    }

    private void brokerMaxConnections_$eq(Integer x$1) {
        this.brokerMaxConnections = x$1;
    }

    private ListenerName interBrokerListenerName() {
        return this.interBrokerListenerName;
    }

    private scala.collection.mutable.Map<InetAddress, Object> counts() {
        return this.counts;
    }

    private scala.collection.mutable.Map<ListenerName, Object> listenerCounts() {
        return this.listenerCounts;
    }

    public scala.collection.mutable.Map<ListenerName, ListenerConnectionQuota> maxConnectionsPerListener() {
        return this.maxConnectionsPerListener;
    }

    private int totalCount() {
        return this.totalCount;
    }

    private void totalCount_$eq(int x$1) {
        this.totalCount = x$1;
    }

    private int defaultConnectionRatePerIp() {
        return this.defaultConnectionRatePerIp;
    }

    private void defaultConnectionRatePerIp_$eq(int x$1) {
        this.defaultConnectionRatePerIp = x$1;
    }

    private ConcurrentHashMap<InetAddress, Object> connectionRatePerIp() {
        return this.connectionRatePerIp;
    }

    private Sensor brokerConnectionRateSensor() {
        return this.brokerConnectionRateSensor;
    }

    private long maxThrottleTimeMs() {
        return this.maxThrottleTimeMs;
    }

    public void inc(ListenerName listenerName, InetAddress address, Meter acceptorBlockedPercentMeter) {
        scala.collection.mutable.Map<InetAddress, Object> map = this.counts();
        synchronized (map) {
            int max;
            this.waitForConnectionSlot(listenerName, acceptorBlockedPercentMeter);
            this.recordIpConnectionMaybeThrottle(listenerName, address);
            int count = BoxesRunTime.unboxToInt((Object)this.counts().getOrElseUpdate((Object)address, (Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> 0));
            this.counts().put((Object)address, (Object)BoxesRunTime.boxToInteger((int)(count + 1)));
            this.totalCount_$eq(this.totalCount() + 1);
            if (this.listenerCounts().contains((Object)listenerName)) {
                this.listenerCounts().put((Object)listenerName, (Object)BoxesRunTime.boxToInteger((int)(BoxesRunTime.unboxToInt((Object)this.listenerCounts().apply((Object)listenerName)) + 1)));
            }
            if (count >= (max = BoxesRunTime.unboxToInt((Object)this.maxConnectionsPerIpOverrides().getOrElse((Object)address, (Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> this.defaultMaxConnectionsPerIp())))) {
                throw new TooManyConnectionsException(address, max);
            }
            return;
        }
    }

    public void updateMaxConnectionsPerIp(int maxConnectionsPerIp) {
        this.defaultMaxConnectionsPerIp_$eq(maxConnectionsPerIp);
    }

    public void updateMaxConnectionsPerIpOverride(Map<String, Object> overrideQuotas) {
        this.maxConnectionsPerIpOverrides_$eq((Map<InetAddress, Object>)((Map)overrideQuotas.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            if (x0$1 != null) {
                String host = (String)x0$1._1();
                int count = x0$1._2$mcI$sp();
                return new Tuple2((Object)InetAddress.getByName(host), (Object)BoxesRunTime.boxToInteger((int)count));
            }
            throw new MatchError(null);
        }, scala.collection.Map$.MODULE$.canBuildFrom())));
    }

    public void updateBrokerMaxConnections(int maxConnections) {
        scala.collection.mutable.Map<InetAddress, Object> map = this.counts();
        synchronized (map) {
            this.brokerMaxConnections_$eq(Predef$.MODULE$.int2Integer(maxConnections));
            this.counts().notifyAll();
            return;
        }
    }

    public void updateBrokerMaxConnectionRate(int maxConnectionRate) {
        this.kafka$network$ConnectionQuotas$$updateConnectionRateQuota(maxConnectionRate, ConnectionQuotaEntity.brokerQuotaEntity());
    }

    public synchronized void updateIpConnectionRateQuota(Option<InetAddress> ip, Option<Object> maxConnectionRate) {
        if (ip instanceof Some) {
            InetAddress address = (InetAddress)((Some)ip).value();
            scala.collection.mutable.Map<InetAddress, Object> map = this.counts();
            synchronized (map) {
                if (maxConnectionRate instanceof Some) {
                    int rate = BoxesRunTime.unboxToInt((Object)((Some)maxConnectionRate).value());
                    this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(46).append("Updating max connection rate override for ").append(address).append(" to ").append(rate).toString());
                    this.connectionRatePerIp().put(address, BoxesRunTime.boxToInteger((int)rate));
                } else if (None$.MODULE$.equals(maxConnectionRate)) {
                    this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(42).append("Removing max connection rate override for ").append(address).toString());
                    this.connectionRatePerIp().remove(address);
                } else {
                    throw new MatchError(maxConnectionRate);
                }
            }
            this.kafka$network$ConnectionQuotas$$updateConnectionRateQuota(this.connectionRateForIp(address), ConnectionQuotaEntity.ipQuotaEntity((InetAddress)address));
            return;
        }
        if (None$.MODULE$.equals(ip)) {
            scala.collection.mutable.Map<InetAddress, Object> map = this.counts();
            synchronized (map) {
                this.defaultConnectionRatePerIp_$eq(BoxesRunTime.unboxToInt((Object)maxConnectionRate.getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> Integer.MAX_VALUE)));
            }
            this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(42).append("Updated default max IP connection rate to ").append(this.defaultConnectionRatePerIp()).toString());
            this.kafka$network$ConnectionQuotas$$metrics.metrics().forEach((metricName, metric) -> {
                if (ConnectionQuotas.isIpConnectionRateMetric$1(metricName)) {
                    int quota = this.connectionRateForIp(InetAddress.getByName((String)metricName.tags().get("ip")));
                    if (ConnectionQuotas.shouldUpdateQuota$1(metric, quota)) {
                        this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(55).append("Updating existing connection rate quota config for ").append(metricName.tags()).append(" to ").append(quota).toString());
                        metric.config(this.rateQuotaMetricConfig(quota));
                        return;
                    }
                    return;
                }
            });
            return;
        }
        throw new MatchError(ip);
    }

    public int connectionRateForIp(InetAddress ip) {
        return BoxesRunTime.unboxToInt((Object)this.connectionRatePerIp().getOrDefault(ip, BoxesRunTime.boxToInteger((int)this.defaultConnectionRatePerIp())));
    }

    public void addListener(KafkaConfig config, ListenerName listenerName) {
        scala.collection.mutable.Map<InetAddress, Object> map = this.counts();
        synchronized (map) {
            if (!this.maxConnectionsPerListener().contains((Object)listenerName)) {
                ListenerConnectionQuota newListenerQuota = new ListenerConnectionQuota(this, this.counts(), listenerName);
                this.maxConnectionsPerListener().put((Object)listenerName, (Object)newListenerQuota);
                this.listenerCounts().put((Object)listenerName, (Object)BoxesRunTime.boxToInteger((int)0));
                config.addReconfigurable((Reconfigurable)newListenerQuota);
                newListenerQuota.configure(config.valuesWithPrefixOverride(listenerName.configPrefix()));
            }
            this.counts().notifyAll();
            return;
        }
    }

    public void removeListener(KafkaConfig config, ListenerName listenerName) {
        scala.collection.mutable.Map<InetAddress, Object> map = this.counts();
        synchronized (map) {
            this.maxConnectionsPerListener().remove((Object)listenerName).foreach((Function1 & Serializable & scala.Serializable)listenerQuota -> {
                ConnectionQuotas.$anonfun$removeListener$1(this, listenerName, config, listenerQuota);
                return BoxedUnit.UNIT;
            });
            return;
        }
    }

    public void dec(ListenerName listenerName, InetAddress address) {
        scala.collection.mutable.Map<InetAddress, Object> map = this.counts();
        synchronized (map) {
            int count = BoxesRunTime.unboxToInt((Object)this.counts().getOrElse((Object)address, (Function0 & Serializable & scala.Serializable)() -> {
                throw new IllegalArgumentException(new StringBuilder(81).append("Attempted to decrease connection count for address with no connections, address: ").append(address).toString());
            }));
            if (count == 1) {
                this.counts().remove((Object)address);
            } else {
                this.counts().put((Object)address, (Object)BoxesRunTime.boxToInteger((int)(count - 1)));
            }
            if (this.totalCount() <= 0) {
                this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Attempted to decrease total connection count for broker with no connections");
            }
            this.totalCount_$eq(this.totalCount() - 1);
            if (this.maxConnectionsPerListener().contains((Object)listenerName)) {
                int listenerCount = BoxesRunTime.unboxToInt((Object)this.listenerCounts().apply((Object)listenerName));
                if (listenerCount == 0) {
                    this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(72).append("Attempted to decrease connection count for listener ").append(listenerName).append(" with no connections").toString());
                } else {
                    this.listenerCounts().put((Object)listenerName, (Object)BoxesRunTime.boxToInteger((int)(listenerCount - 1)));
                }
            }
            this.counts().notifyAll();
            return;
        }
    }

    public int get(InetAddress address) {
        scala.collection.mutable.Map<InetAddress, Object> map = this.counts();
        synchronized (map) {
            int n = BoxesRunTime.unboxToInt((Object)this.counts().getOrElse((Object)address, (Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> 0));
            return n;
        }
    }

    private void waitForConnectionSlot(ListenerName listenerName, Meter acceptorBlockedPercentMeter) {
        scala.collection.mutable.Map<InetAddress, Object> map = this.counts();
        synchronized (map) {
            long startThrottleTimeMs = this.time.milliseconds();
            long throttleTimeMs = package$.MODULE$.max(this.recordConnectionAndGetThrottleTimeMs(listenerName, startThrottleTimeMs), 0L);
            if (throttleTimeMs > 0L || !this.connectionSlotAvailable(listenerName)) {
                long startNs = this.time.nanoseconds();
                long endThrottleTimeMs = startThrottleTimeMs + throttleTimeMs;
                long remainingThrottleTimeMs = throttleTimeMs;
                do {
                    this.counts().wait(remainingThrottleTimeMs);
                } while ((remainingThrottleTimeMs = package$.MODULE$.max(endThrottleTimeMs - this.time.milliseconds(), 0L)) > 0L || !this.connectionSlotAvailable(listenerName));
                acceptorBlockedPercentMeter.mark(this.time.nanoseconds() - startNs);
            }
            return;
        }
    }

    public boolean maxConnectionsExceeded(ListenerName listenerName) {
        return this.totalCount() > Predef$.MODULE$.Integer2int(this.brokerMaxConnections()) && !this.protectedListener(listenerName);
    }

    private boolean connectionSlotAvailable(ListenerName listenerName) {
        if (BoxesRunTime.unboxToInt((Object)this.listenerCounts().apply((Object)listenerName)) >= this.maxListenerConnections(listenerName)) {
            return false;
        }
        if (this.protectedListener(listenerName)) {
            return true;
        }
        return this.totalCount() < Predef$.MODULE$.Integer2int(this.brokerMaxConnections());
    }

    private boolean protectedListener(ListenerName listenerName) {
        ListenerName listenerName2 = this.interBrokerListenerName();
        return !(listenerName2 != null ? !listenerName2.equals(listenerName) : listenerName != null) && this.listenerCounts().size() > 1;
    }

    private int maxListenerConnections(ListenerName listenerName) {
        return BoxesRunTime.unboxToInt((Object)this.maxConnectionsPerListener().get((Object)listenerName).map((Function1 & Serializable & scala.Serializable)x$19 -> BoxesRunTime.boxToInteger((int)x$19.maxConnections())).getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> Integer.MAX_VALUE));
    }

    private long recordConnectionAndGetThrottleTimeMs(ListenerName listenerName, long timeMs) {
        if (this.protectedListener(listenerName)) {
            return this.recordAndGetListenerThrottleTime$1(0, listenerName, timeMs);
        }
        int brokerThrottleTimeMs = this.recordAndGetThrottleTimeMs(this.brokerConnectionRateSensor(), timeMs);
        return this.recordAndGetListenerThrottleTime$1(brokerThrottleTimeMs, listenerName, timeMs);
    }

    private void updateListenerMetrics(ListenerName listenerName, long throttleMs, long timeMs) {
        if (!this.protectedListener(listenerName)) {
            this.brokerConnectionRateSensor().record(-1.0, timeMs, false);
        }
        this.maxConnectionsPerListener().get((Object)listenerName).foreach((Function1 & Serializable & scala.Serializable)listenerQuota -> {
            ConnectionQuotas.$anonfun$updateListenerMetrics$1(throttleMs, timeMs, listenerQuota);
            return BoxedUnit.UNIT;
        });
    }

    private void recordIpConnectionMaybeThrottle(ListenerName listenerName, InetAddress address) {
        int connectionRateQuota = this.connectionRateForIp(address);
        if (connectionRateQuota != Integer.MAX_VALUE) {
            long timeMs;
            Sensor sensor = this.kafka$network$ConnectionQuotas$$getOrCreateConnectionRateQuotaSensor(connectionRateQuota, ConnectionQuotaEntity.ipQuotaEntity((InetAddress)address));
            int throttleMs = this.recordAndGetThrottleTimeMs(sensor, timeMs = this.time.milliseconds());
            if (throttleMs > 0) {
                this.trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(19).append("Throttling ").append(address).append(" for ").append(throttleMs).append(" ms").toString());
                sensor.record(-1.0, timeMs, false);
                this.updateListenerMetrics(listenerName, throttleMs, timeMs);
                throw new ConnectionThrottledException(address, timeMs, (long)throttleMs);
            }
            return;
        }
    }

    private int recordAndGetThrottleTimeMs(Sensor sensor, long timeMs) {
        try {
            sensor.record(1.0, timeMs);
            return 0;
        }
        catch (QuotaViolationException e) {
            int throttleTimeMs = (int)QuotaUtils$.MODULE$.boundedThrottleTime(e, this.maxThrottleTimeMs(), timeMs);
            this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(45).append("Quota violated for sensor (").append(sensor.name()).append("). Delay time: ").append(throttleTimeMs).append(" ms").toString());
            return throttleTimeMs;
        }
    }

    public Sensor kafka$network$ConnectionQuotas$$getOrCreateConnectionRateQuotaSensor(int quotaLimit, ConnectionQuotaEntity connectionQuotaEntity) {
        return (Sensor)Option$.MODULE$.apply((Object)this.kafka$network$ConnectionQuotas$$metrics.getSensor(connectionQuotaEntity.sensorName())).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            Sensor sensor = $this.kafka$network$ConnectionQuotas$$metrics.sensor(connectionQuotaEntity.sensorName(), this.rateQuotaMetricConfig(quotaLimit), connectionQuotaEntity.sensorExpiration(), new Sensor[0]);
            sensor.add(this.connectionRateMetricName(connectionQuotaEntity), (MeasurableStat)new Rate(), null);
            return sensor;
        });
    }

    public void kafka$network$ConnectionQuotas$$updateConnectionRateQuota(int quotaLimit, ConnectionQuotaEntity connectionQuotaEntity) {
        Option$.MODULE$.apply((Object)this.kafka$network$ConnectionQuotas$$metrics.metric(this.connectionRateMetricName(connectionQuotaEntity))).foreach((Function1 & Serializable & scala.Serializable)metric -> {
            ConnectionQuotas.$anonfun$updateConnectionRateQuota$1(this, quotaLimit, connectionQuotaEntity, metric);
            return BoxedUnit.UNIT;
        });
    }

    private MetricName connectionRateMetricName(ConnectionQuotaEntity connectionQuotaEntity) {
        return this.kafka$network$ConnectionQuotas$$metrics.metricName(connectionQuotaEntity.metricName(), SocketServer$.MODULE$.MetricsGroup(), "Tracking rate of accepting new connections (per second)", connectionQuotaEntity.metricTags());
    }

    private MetricConfig rateQuotaMetricConfig(int quotaLimit) {
        return new MetricConfig().timeWindow((long)Predef$.MODULE$.Integer2int(this.config.quotaWindowSizeSeconds()), TimeUnit.SECONDS).samples(Predef$.MODULE$.Integer2int(this.config.numQuotaSamples())).quota(new Quota((double)quotaLimit, true));
    }

    @Override
    public void close() {
        this.kafka$network$ConnectionQuotas$$metrics.removeSensor(this.brokerConnectionRateSensor().name());
        this.maxConnectionsPerListener().values().foreach((Function1 & Serializable & scala.Serializable)x$20 -> {
            x$20.close();
            return BoxedUnit.UNIT;
        });
    }

    public void closeChannel(Logging log, ListenerName listenerName, SocketChannel channel) {
        if (channel != null) {
            log.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(24).append("Closing connection from ").append(channel.socket().getRemoteSocketAddress()).toString());
            this.dec(listenerName, channel.socket().getInetAddress());
            SocketServer$.MODULE$.closeSocket(channel, log);
            return;
        }
    }

    private static final boolean isIpConnectionRateMetric$1(MetricName metricName) {
        String string = metricName.name();
        String string2 = "connection-accept-rate";
        if (string != null && string.equals(string2)) {
            String string3 = metricName.group();
            String string4 = SocketServer$.MODULE$.MetricsGroup();
            if (!(string3 != null ? !string3.equals(string4) : string4 != null) && metricName.tags().containsKey("ip")) {
                return true;
            }
        }
        return false;
    }

    private static final boolean shouldUpdateQuota$1(KafkaMetric metric, int quotaLimit) {
        return (double)quotaLimit != metric.config().quota().bound();
    }

    public static final /* synthetic */ void $anonfun$removeListener$1(ConnectionQuotas $this, ListenerName listenerName$4, KafkaConfig config$1, ListenerConnectionQuota listenerQuota) {
        $this.listenerCounts().remove((Object)listenerName$4);
        listenerQuota.close();
        $this.counts().notifyAll();
        config$1.removeReconfigurable((Reconfigurable)listenerQuota);
    }

    public static final /* synthetic */ int $anonfun$recordConnectionAndGetThrottleTimeMs$1(ConnectionQuotas $this, long timeMs$2, int minThrottleTimeMs$1, ListenerConnectionQuota listenerQuota) {
        int listenerThrottleTimeMs = $this.recordAndGetThrottleTimeMs(listenerQuota.connectionRateSensor(), timeMs$2);
        int throttleTimeMs = package$.MODULE$.max(minThrottleTimeMs$1, listenerThrottleTimeMs);
        if (throttleTimeMs > 0) {
            listenerQuota.listenerConnectionRateThrottleSensor().record((double)throttleTimeMs, timeMs$2);
        }
        return throttleTimeMs;
    }

    private final int recordAndGetListenerThrottleTime$1(int minThrottleTimeMs, ListenerName listenerName$6, long timeMs$2) {
        return BoxesRunTime.unboxToInt((Object)this.maxConnectionsPerListener().get((Object)listenerName$6).map((Function1 & Serializable & scala.Serializable)listenerQuota -> BoxesRunTime.boxToInteger((int)ConnectionQuotas.$anonfun$recordConnectionAndGetThrottleTimeMs$1(this, timeMs$2, minThrottleTimeMs, listenerQuota))).getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> 0));
    }

    public static final /* synthetic */ void $anonfun$updateListenerMetrics$1(long throttleMs$1, long timeMs$3, ListenerConnectionQuota listenerQuota) {
        listenerQuota.ipConnectionRateThrottleSensor().record((double)throttleMs$1, timeMs$3);
        listenerQuota.connectionRateSensor().record(-1.0, timeMs$3, false);
    }

    public static final /* synthetic */ void $anonfun$updateConnectionRateQuota$1(ConnectionQuotas $this, int quotaLimit$2, ConnectionQuotaEntity connectionQuotaEntity$2, KafkaMetric metric) {
        metric.config($this.rateQuotaMetricConfig(quotaLimit$2));
        $this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(41).append("Updated ").append(connectionQuotaEntity$2.metricName()).append(" max connection creation rate to ").append(quotaLimit$2).toString());
    }

    public ConnectionQuotas(KafkaConfig config, Time time, Metrics metrics) {
        this.config = config;
        this.time = time;
        this.kafka$network$ConnectionQuotas$$metrics = metrics;
        Logging.$init$(this);
        this.defaultMaxConnectionsPerIp = Predef$.MODULE$.Integer2int(config.maxConnectionsPerIp());
        this.maxConnectionsPerIpOverrides = (Map)config.maxConnectionsPerIpOverrides().map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            if (x0$1 != null) {
                String host = (String)x0$1._1();
                int count = x0$1._2$mcI$sp();
                return new Tuple2((Object)InetAddress.getByName(host), (Object)BoxesRunTime.boxToInteger((int)count));
            }
            throw new MatchError(null);
        }, scala.collection.Map$.MODULE$.canBuildFrom());
        this.brokerMaxConnections = config.maxConnections();
        this.interBrokerListenerName = config.interBrokerListenerName();
        this.counts = (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.listenerCounts = (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.maxConnectionsPerListener = (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.totalCount = 0;
        this.defaultConnectionRatePerIp = Integer.MAX_VALUE;
        this.connectionRatePerIp = new ConcurrentHashMap();
        this.brokerConnectionRateSensor = this.kafka$network$ConnectionQuotas$$getOrCreateConnectionRateQuotaSensor(Predef$.MODULE$.Integer2int(config.maxConnectionCreationRate()), ConnectionQuotaEntity.brokerQuotaEntity());
        this.maxThrottleTimeMs = TimeUnit.SECONDS.toMillis(Predef$.MODULE$.Integer2int(config.quotaWindowSizeSeconds()));
    }

    public class ListenerConnectionQuota
    implements ListenerReconfigurable,
    AutoCloseable {
        private final Object lock;
        private final ListenerName listener;
        private volatile int _maxConnections;
        private final Sensor connectionRateSensor;
        private final Sensor listenerConnectionRateThrottleSensor;
        private final Sensor ipConnectionRateThrottleSensor;
        public final /* synthetic */ ConnectionQuotas $outer;

        private int _maxConnections() {
            return this._maxConnections;
        }

        private void _maxConnections_$eq(int x$1) {
            this._maxConnections = x$1;
        }

        public Sensor connectionRateSensor() {
            return this.connectionRateSensor;
        }

        public Sensor listenerConnectionRateThrottleSensor() {
            return this.listenerConnectionRateThrottleSensor;
        }

        public Sensor ipConnectionRateThrottleSensor() {
            return this.ipConnectionRateThrottleSensor;
        }

        public int maxConnections() {
            return this._maxConnections();
        }

        public ListenerName listenerName() {
            return this.listener;
        }

        public void configure(java.util.Map<String, ?> configs) {
            this._maxConnections_$eq(this.maxConnections(configs));
            this.kafka$network$ConnectionQuotas$ListenerConnectionQuota$$$outer().kafka$network$ConnectionQuotas$$updateConnectionRateQuota(this.maxConnectionCreationRate(configs), ConnectionQuotaEntity.listenerQuotaEntity((String)this.listener.value()));
        }

        public Set<String> reconfigurableConfigs() {
            return (Set)CollectionConverters$.MODULE$.setAsJavaSetConverter(SocketServer$.MODULE$.ListenerReconfigurableConfigs()).asJava();
        }

        public void validateReconfiguration(java.util.Map<String, ?> configs) {
            int value = this.maxConnections(configs);
            if (value <= 0) {
                throw new ConfigException(new StringBuilder(24).append("Invalid ").append("max.connections").append(" ").append(value).toString());
            }
            int rate = this.maxConnectionCreationRate(configs);
            if (rate <= 0) {
                throw new ConfigException(new StringBuilder(37).append("Invalid ").append("max.connection.creation.rate").append(" ").append(rate).toString());
            }
        }

        public void reconfigure(java.util.Map<String, ?> configs) {
            Object object = this.lock;
            synchronized (object) {
                this._maxConnections_$eq(this.maxConnections(configs));
                this.kafka$network$ConnectionQuotas$ListenerConnectionQuota$$$outer().kafka$network$ConnectionQuotas$$updateConnectionRateQuota(this.maxConnectionCreationRate(configs), ConnectionQuotaEntity.listenerQuotaEntity((String)this.listener.value()));
                this.lock.notifyAll();
                return;
            }
        }

        @Override
        public void close() {
            this.kafka$network$ConnectionQuotas$ListenerConnectionQuota$$$outer().kafka$network$ConnectionQuotas$$metrics.removeSensor(this.connectionRateSensor().name());
            this.kafka$network$ConnectionQuotas$ListenerConnectionQuota$$$outer().kafka$network$ConnectionQuotas$$metrics.removeSensor(this.listenerConnectionRateThrottleSensor().name());
            this.kafka$network$ConnectionQuotas$ListenerConnectionQuota$$$outer().kafka$network$ConnectionQuotas$$metrics.removeSensor(this.ipConnectionRateThrottleSensor().name());
        }

        private int maxConnections(java.util.Map<String, ?> configs) {
            return BoxesRunTime.unboxToInt((Object)Option$.MODULE$.apply(configs.get("max.connections")).map((Function1 & Serializable & scala.Serializable)x$21 -> BoxesRunTime.boxToInteger((int)ListenerConnectionQuota.$anonfun$maxConnections$1(x$21))).getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> Integer.MAX_VALUE));
        }

        private int maxConnectionCreationRate(java.util.Map<String, ?> configs) {
            return BoxesRunTime.unboxToInt((Object)Option$.MODULE$.apply(configs.get("max.connection.creation.rate")).map((Function1 & Serializable & scala.Serializable)x$22 -> BoxesRunTime.boxToInteger((int)ListenerConnectionQuota.$anonfun$maxConnectionCreationRate$1(x$22))).getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> Integer.MAX_VALUE));
        }

        private Sensor createConnectionRateThrottleSensor(String throttlePrefix) {
            Sensor sensor = this.kafka$network$ConnectionQuotas$ListenerConnectionQuota$$$outer().kafka$network$ConnectionQuotas$$metrics.sensor(new StringBuilder(27).append(throttlePrefix).append("ConnectionRateThrottleTime-").append(this.listener.value()).toString());
            MetricName metricName = this.kafka$network$ConnectionQuotas$ListenerConnectionQuota$$$outer().kafka$network$ConnectionQuotas$$metrics.metricName(new StringBuilder(31).append(throttlePrefix).append("connection-accept-throttle-time").toString(), SocketServer$.MODULE$.MetricsGroup(), "Tracking average throttle-time, out of non-zero throttle times, per listener", (java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Processor$.MODULE$.ListenerMetricTag()), (Object)this.listener.value())}))).asJava());
            sensor.add(metricName, (MeasurableStat)new Avg());
            return sensor;
        }

        public /* synthetic */ ConnectionQuotas kafka$network$ConnectionQuotas$ListenerConnectionQuota$$$outer() {
            return this.$outer;
        }

        public static final /* synthetic */ int $anonfun$maxConnections$1(Object x$21) {
            return new StringOps(Predef$.MODULE$.augmentString(x$21.toString())).toInt();
        }

        public static final /* synthetic */ int $anonfun$maxConnectionCreationRate$1(Object x$22) {
            return new StringOps(Predef$.MODULE$.augmentString(x$22.toString())).toInt();
        }

        public ListenerConnectionQuota(ConnectionQuotas $outer, Object lock, ListenerName listener) {
            this.lock = lock;
            this.listener = listener;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            this._maxConnections = Integer.MAX_VALUE;
            this.connectionRateSensor = $outer.kafka$network$ConnectionQuotas$$getOrCreateConnectionRateQuotaSensor(Integer.MAX_VALUE, ConnectionQuotaEntity.listenerQuotaEntity((String)listener.value()));
            this.listenerConnectionRateThrottleSensor = this.createConnectionRateThrottleSensor("");
            this.ipConnectionRateThrottleSensor = this.createConnectionRateThrottleSensor("ip-");
        }
    }
}

