/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.util.Collections;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiConsumer;
import kafka.controller.KafkaController;
import kafka.coordinator.transaction.TransactionCoordinator;
import kafka.server.AutoTopicCreationManager;
import kafka.server.ControllerMutationQuota;
import kafka.server.ForwardingManager$;
import kafka.server.KafkaConfig;
import kafka.server.ZkAdminManager;
import kafka.utils.Logging;
import org.apache.kafka.clients.ClientResponse;
import org.apache.kafka.clients.NodeApiVersions;
import org.apache.kafka.common.errors.InvalidTopicException;
import org.apache.kafka.common.internals.Topic;
import org.apache.kafka.common.message.CreateTopicsRequestData;
import org.apache.kafka.common.message.CreateTopicsResponseData;
import org.apache.kafka.common.message.MetadataResponseData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.ApiError;
import org.apache.kafka.common.requests.CreateTopicsRequest;
import org.apache.kafka.common.requests.RequestContext;
import org.apache.kafka.common.requests.RequestHeader;
import org.apache.kafka.common.utils.ImplicitLinkedHashCollection;
import org.apache.kafka.coordinator.group.GroupCoordinator;
import org.apache.kafka.server.ControllerRequestCompletionHandler;
import org.apache.kafka.server.NodeToControllerChannelManager;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Set;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.Map$;
import scala.compat.java8.OptionConverters;
import scala.compat.java8.OptionConverters$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;

@ScalaSignature(bytes="\u0006\u0001\u0005Ef\u0001\u0002\n\u0014\u0001aA\u0001\"\u000b\u0001\u0003\u0002\u0003\u0006IA\u000b\u0005\t[\u0001\u0011\t\u0011)A\u0005]!A1\b\u0001B\u0001B\u0003%A\b\u0003\u0005A\u0001\t\u0005\t\u0015!\u0003B\u0011!9\u0005A!A!\u0002\u0013A\u0005\u0002\u0003)\u0001\u0005\u0003\u0005\u000b\u0011B)\t\u000ba\u0003A\u0011A-\t\u000f\u0005\u0004!\u0019!C\u0005E\"1a\u000f\u0001Q\u0001\n\rDQa\u001e\u0001\u0005BaDq!!\u0014\u0001\t\u0013\ty\u0005C\u0004\u0002l\u0001!I!!\u001c\t\u000f\u0005M\u0004\u0001\"\u0003\u0002v!9\u0011q\u0010\u0001\u0005\n\u0005\u0005\u0005bBAD\u0001\u0011%\u0011\u0011\u0012\u0005\b\u00033\u0003A\u0011BAN\u0011\u001d\t)\u000b\u0001C\u0005\u0003O\u0013q\u0004R3gCVdG/Q;u_R{\u0007/[2De\u0016\fG/[8o\u001b\u0006t\u0017mZ3s\u0015\t!R#\u0001\u0004tKJ4XM\u001d\u0006\u0002-\u0005)1.\u00194lC\u000e\u00011\u0003\u0002\u0001\u001a?\r\u0002\"AG\u000f\u000e\u0003mQ\u0011\u0001H\u0001\u0006g\u000e\fG.Y\u0005\u0003=m\u0011a!\u00118z%\u00164\u0007C\u0001\u0011\"\u001b\u0005\u0019\u0012B\u0001\u0012\u0014\u0005a\tU\u000f^8U_BL7m\u0011:fCRLwN\\'b]\u0006<WM\u001d\t\u0003I\u001dj\u0011!\n\u0006\u0003MU\tQ!\u001e;jYNL!\u0001K\u0013\u0003\u000f1{wmZ5oO\u000611m\u001c8gS\u001e\u0004\"\u0001I\u0016\n\u00051\u001a\"aC&bM.\f7i\u001c8gS\u001e\fab\u00195b]:,G.T1oC\u001e,'\u000fE\u0002\u001b_EJ!\u0001M\u000e\u0003\r=\u0003H/[8o!\t\u0011\u0014(D\u00014\u0015\t!BG\u0003\u0002\u0017k)\u0011agN\u0001\u0007CB\f7\r[3\u000b\u0003a\n1a\u001c:h\u0013\tQ4G\u0001\u0010O_\u0012,Gk\\\"p]R\u0014x\u000e\u001c7fe\u000eC\u0017M\u001c8fY6\u000bg.Y4fe\u0006a\u0011\rZ7j]6\u000bg.Y4feB\u0019!dL\u001f\u0011\u0005\u0001r\u0014BA \u0014\u00059Q6.\u00113nS:l\u0015M\\1hKJ\f!bY8oiJ|G\u000e\\3s!\rQrF\u0011\t\u0003\u0007\u0016k\u0011\u0001\u0012\u0006\u0003\u0001VI!A\u0012#\u0003\u001f-\u000bgm[1D_:$(o\u001c7mKJ\f\u0001c\u001a:pkB\u001cun\u001c:eS:\fGo\u001c:\u0011\u0005%sU\"\u0001&\u000b\u0005-c\u0015!B4s_V\u0004(BA'5\u0003-\u0019wn\u001c:eS:\fGo\u001c:\n\u0005=S%\u0001E$s_V\u00048i\\8sI&t\u0017\r^8s\u00039!\bP\\\"p_J$\u0017N\\1u_J\u0004\"A\u0015,\u000e\u0003MS!\u0001V+\u0002\u0017Q\u0014\u0018M\\:bGRLwN\u001c\u0006\u0003\u001bVI!aV*\u0003-Q\u0013\u0018M\\:bGRLwN\\\"p_J$\u0017N\\1u_J\fa\u0001P5oSRtDc\u0002.\\9vsv\f\u0019\t\u0003A\u0001AQ!K\u0004A\u0002)BQ!L\u0004A\u00029BQaO\u0004A\u0002qBQ\u0001Q\u0004A\u0002\u0005CQaR\u0004A\u0002!CQ\u0001U\u0004A\u0002E\u000ba\"\u001b8gY&<\u0007\u000e\u001e+pa&\u001c7/F\u0001d!\r!\u0017n[\u0007\u0002K*\u0011amZ\u0001\u0005kRLGNC\u0001i\u0003\u0011Q\u0017M^1\n\u0005),'aA*fiB\u0011An\u001d\b\u0003[F\u0004\"A\\\u000e\u000e\u0003=T!\u0001]\f\u0002\rq\u0012xn\u001c;?\u0013\t\u00118$\u0001\u0004Qe\u0016$WMZ\u0005\u0003iV\u0014aa\u0015;sS:<'B\u0001:\u001c\u0003=IgN\u001a7jO\"$Hk\u001c9jGN\u0004\u0013\u0001D2sK\u0006$X\rV8qS\u000e\u001cHcB=\u0002*\u0005E\u00121\b\t\u0004uv|X\"A>\u000b\u0005q\\\u0012AC2pY2,7\r^5p]&\u0011ap\u001f\u0002\u0004'\u0016\f\b\u0003BA\u0001\u0003GqA!a\u0001\u0002\u001e9!\u0011QAA\f\u001d\u0011\t9!a\u0005\u000f\t\u0005%\u0011\u0011\u0003\b\u0005\u0003\u0017\tyAD\u0002o\u0003\u001bI\u0011\u0001O\u0005\u0003m]J!AF\u001b\n\u0007\u0005UA'\u0001\u0004d_6lwN\\\u0005\u0005\u00033\tY\"A\u0004nKN\u001c\u0018mZ3\u000b\u0007\u0005UA'\u0003\u0003\u0002 \u0005\u0005\u0012\u0001F'fi\u0006$\u0017\r^1SKN\u0004xN\\:f\t\u0006$\u0018M\u0003\u0003\u0002\u001a\u0005m\u0011\u0002BA\u0013\u0003O\u0011Q#T3uC\u0012\fG/\u0019*fgB|gn]3U_BL7M\u0003\u0003\u0002 \u0005\u0005\u0002bBA\u0016\u0015\u0001\u0007\u0011QF\u0001\u0007i>\u0004\u0018nY:\u0011\ti\fyc[\u0005\u0003UnDq!a\r\u000b\u0001\u0004\t)$A\fd_:$(o\u001c7mKJlU\u000f^1uS>t\u0017+^8uCB\u0019\u0001%a\u000e\n\u0007\u0005e2CA\fD_:$(o\u001c7mKJlU\u000f^1uS>t\u0017+^8uC\"9\u0011Q\b\u0006A\u0002\u0005}\u0012AF7fi\u0006$\u0017\r^1SKF,Xm\u001d;D_:$X\r\u001f;\u0011\tiy\u0013\u0011\t\t\u0005\u0003\u0007\nI%\u0004\u0002\u0002F)!\u0011qIA\u000e\u0003!\u0011X-];fgR\u001c\u0018\u0002BA&\u0003\u000b\u0012aBU3rk\u0016\u001cHoQ8oi\u0016DH/\u0001\tde\u0016\fG/\u001a+pa&\u001c7/\u00138[WR)\u00110!\u0015\u0002j!9\u00111K\u0006A\u0002\u0005U\u0013aD2sK\u0006$\u0018M\u00197f)>\u0004\u0018nY:\u0011\ri\f9f[A.\u0013\r\tIf\u001f\u0002\u0004\u001b\u0006\u0004\b\u0003BA/\u0003GrA!a\u0001\u0002`%!\u0011\u0011MA\u0011\u0003]\u0019%/Z1uKR{\u0007/[2t%\u0016\fX/Z:u\t\u0006$\u0018-\u0003\u0003\u0002f\u0005\u001d$AD\"sK\u0006$\u0018M\u00197f)>\u0004\u0018n\u0019\u0006\u0005\u0003C\n\t\u0003C\u0004\u00024-\u0001\r!!\u000e\u0002-M,g\u000eZ\"sK\u0006$X\rV8qS\u000e\u0014V-];fgR$R!_A8\u0003cBq!a\u0015\r\u0001\u0004\t)\u0006C\u0004\u0002>1\u0001\r!a\u0010\u0002+\rdW-\u0019:J]\u001ad\u0017n\u001a5u%\u0016\fX/Z:ugR!\u0011qOA?!\rQ\u0012\u0011P\u0005\u0004\u0003wZ\"\u0001B+oSRDq!a\u0015\u000e\u0001\u0004\t)&\u0001\bde\u0016\fG/\u00192mKR{\u0007/[2\u0015\t\u0005m\u00131\u0011\u0005\u0007\u0003\u000bs\u0001\u0019A6\u0002\u000bQ|\u0007/[2\u0002?\r|gN^3siR{Gk\u001c9jG\u000e{gNZ5h\u0007>dG.Z2uS>t7\u000f\u0006\u0003\u0002\f\u0006E\u0005\u0003BA/\u0003\u001bKA!a$\u0002h\tq2I]3bi\u0006\u0014G.\u001a+pa&\u001c7i\u001c8gS\u001e\u001cu\u000e\u001c7fGRLwN\u001c\u0005\u0007S=\u0001\r!a%\u0011\u0007\u0011\f)*C\u0002\u0002\u0018\u0016\u0014!\u0002\u0015:pa\u0016\u0014H/[3t\u0003AI7OV1mS\u0012$v\u000e]5d\u001d\u0006lW\r\u0006\u0003\u0002\u001e\u0006\r\u0006c\u0001\u000e\u0002 &\u0019\u0011\u0011U\u000e\u0003\u000f\t{w\u000e\\3b]\"1\u0011Q\u0011\tA\u0002-\fQCZ5mi\u0016\u00148I]3bi\u0006\u0014G.\u001a+pa&\u001c7\u000f\u0006\u0003\u0002*\u0006=\u0006C\u0002\u000e\u0002,\u0006U\u00130C\u0002\u0002.n\u0011a\u0001V;qY\u0016\u0014\u0004bBA\u0016#\u0001\u0007\u0011Q\u0006")
public class DefaultAutoTopicCreationManager
implements AutoTopicCreationManager,
Logging {
    private final KafkaConfig config;
    private final Option<NodeToControllerChannelManager> channelManager;
    private final Option<ZkAdminManager> adminManager;
    private final Option<KafkaController> controller;
    private final GroupCoordinator groupCoordinator;
    private final TransactionCoordinator txnCoordinator;
    private final java.util.Set<String> inflightTopics;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    private java.util.Set<String> inflightTopics() {
        return this.inflightTopics;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Seq<MetadataResponseData.MetadataResponseTopic> createTopics(Set<String> topics, ControllerMutationQuota controllerMutationQuota, Option<RequestContext> metadataRequestContext) {
        void var6_6;
        void var5_5;
        Tuple2<Map<String, CreateTopicsRequestData.CreatableTopic>, Seq<MetadataResponseData.MetadataResponseTopic>> tuple2 = this.filterCreatableTopics(topics);
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        Map creatableTopics = (Map)tuple2._1();
        Seq uncreatableTopicResponses = (Seq)tuple2._2();
        void creatableTopics2 = var5_5;
        void uncreatableTopicResponses2 = var6_6;
        Seq<MetadataResponseData.MetadataResponseTopic> creatableTopicResponses = creatableTopics2.isEmpty() ? Nil$.MODULE$ : (this.controller.isEmpty() || !((KafkaController)this.controller.get()).isActive() && this.channelManager.isDefined() ? this.sendCreateTopicRequest((Map<String, CreateTopicsRequestData.CreatableTopic>)creatableTopics2, metadataRequestContext) : this.createTopicsInZk((Map<String, CreateTopicsRequestData.CreatableTopic>)creatableTopics2, controllerMutationQuota));
        return (Seq)uncreatableTopicResponses2.$plus$plus((GenTraversableOnce)creatableTopicResponses, Seq$.MODULE$.canBuildFrom());
    }

    private Seq<MetadataResponseData.MetadataResponseTopic> createTopicsInZk(Map<String, CreateTopicsRequestData.CreatableTopic> creatableTopics, ControllerMutationQuota controllerMutationQuota) {
        Seq seq;
        block5: {
            AtomicReference topicErrors = new AtomicReference();
            try {
                ((ZkAdminManager)this.adminManager.get()).createTopics(0, false, creatableTopics, (Map<String, CreateTopicsResponseData.CreatableTopicResult>)scala.collection.Map$.MODULE$.empty(), controllerMutationQuota, (Function1<Map<String, ApiError>, BoxedUnit>)(Function1 & Serializable & scala.Serializable)x$1 -> {
                    topicErrors.set(x$1);
                    return BoxedUnit.UNIT;
                });
                Option option = Option$.MODULE$.apply(topicErrors.get());
                if (option instanceof Some) {
                    seq = (Seq)((Map)((Some)option).value()).toSeq().map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                        if (x0$1 != null) {
                            String topic = (String)x0$1._1();
                            Errors errors = ((ApiError)x0$1._2()).error();
                            Errors error = (Errors.TOPIC_ALREADY_EXISTS.equals(errors) ? true : Errors.REQUEST_TIMED_OUT.equals(errors)) ? Errors.LEADER_NOT_AVAILABLE : errors;
                            return new MetadataResponseData.MetadataResponseTopic().setErrorCode(error.code()).setName(topic).setIsInternal(Topic.isInternal((String)topic));
                        }
                        throw new MatchError(null);
                    }, Seq$.MODULE$.canBuildFrom());
                    break block5;
                }
                if (None$.MODULE$.equals(option)) {
                    seq = (Seq)creatableTopics.keySet().toSeq().map((Function1 & Serializable & scala.Serializable)topic -> new MetadataResponseData.MetadataResponseTopic().setErrorCode(Errors.UNKNOWN_TOPIC_OR_PARTITION.code()).setName(topic).setIsInternal(Topic.isInternal((String)topic)), Seq$.MODULE$.canBuildFrom());
                    break block5;
                }
                throw new MatchError((Object)option);
            }
            finally {
                this.kafka$server$DefaultAutoTopicCreationManager$$clearInflightRequests(creatableTopics);
            }
        }
        return seq;
    }

    private Seq<MetadataResponseData.MetadataResponseTopic> sendCreateTopicRequest(Map<String, CreateTopicsRequestData.CreatableTopic> creatableTopics, Option<RequestContext> metadataRequestContext) {
        CreateTopicsRequestData.CreatableTopicCollection topicsToCreate = new CreateTopicsRequestData.CreatableTopicCollection(creatableTopics.size());
        topicsToCreate.addAll(CollectionConverters$.MODULE$.asJavaCollectionConverter(creatableTopics.values()).asJavaCollection());
        CreateTopicsRequest.Builder createTopicsRequest = new CreateTopicsRequest.Builder(new CreateTopicsRequestData().setTimeoutMs(Predef$.MODULE$.Integer2int(this.config.requestTimeoutMs())).setTopics(topicsToCreate));
        ControllerRequestCompletionHandler requestCompletionHandler = new ControllerRequestCompletionHandler(this, creatableTopics){
            private final /* synthetic */ DefaultAutoTopicCreationManager $outer;
            private final Map creatableTopics$1;

            public void onTimeout() {
                this.$outer.kafka$server$DefaultAutoTopicCreationManager$$clearInflightRequests((Map<String, CreateTopicsRequestData.CreatableTopic>)this.creatableTopics$1);
                this.$outer.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(35).append("Auto topic creation timed out for ").append($this.creatableTopics$1.keys()).append(".").toString());
            }

            public void onComplete(ClientResponse response) {
                this.$outer.kafka$server$DefaultAutoTopicCreationManager$$clearInflightRequests((Map<String, CreateTopicsRequestData.CreatableTopic>)this.creatableTopics$1);
                if (response.authenticationException() != null) {
                    this.$outer.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(61).append("Auto topic creation failed for ").append($this.creatableTopics$1.keys()).append(" with authentication exception").toString());
                    return;
                }
                if (response.versionMismatch() != null) {
                    this.$outer.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(62).append("Auto topic creation failed for ").append($this.creatableTopics$1.keys()).append(" with invalid version exception").toString());
                    return;
                }
                this.$outer.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(50).append("Auto topic creation completed for ").append($this.creatableTopics$1.keys()).append(" with response ").append(response.responseBody()).append(".").toString());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.creatableTopics$1 = creatableTopics$1;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$onTimeout$1(kafka.server.DefaultAutoTopicCreationManager$$anon$1 ), $anonfun$onComplete$1(kafka.server.DefaultAutoTopicCreationManager$$anon$1 ), $anonfun$onComplete$2(kafka.server.DefaultAutoTopicCreationManager$$anon$1 ), $anonfun$onComplete$3(kafka.server.DefaultAutoTopicCreationManager$$anon$1 org.apache.kafka.clients.ClientResponse )}, serializedLambda);
            }
        };
        NodeToControllerChannelManager channelManager = (NodeToControllerChannelManager)this.channelManager.getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new IllegalStateException("Channel manager must be defined in order to send CreateTopic requests.");
        });
        AbstractRequest.Builder request = (AbstractRequest.Builder)metadataRequestContext.map((Function1 & Serializable & scala.Serializable)context -> {
            short s;
            Option option = OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(channelManager.controllerApiVersions()));
            if (None$.MODULE$.equals(option)) {
                s = ApiKeys.CREATE_TOPICS.latestVersion();
            } else if (option instanceof Some) {
                s = ((NodeApiVersions)((Some)option).value()).latestUsableVersion(ApiKeys.CREATE_TOPICS);
            } else {
                throw new MatchError((Object)option);
            }
            short requestVersion = s;
            RequestHeader requestHeader = new RequestHeader(ApiKeys.CREATE_TOPICS, requestVersion, context.clientId(), context.correlationId());
            return ForwardingManager$.MODULE$.buildEnvelopeRequest((RequestContext)context, createTopicsRequest.build(requestVersion).serializeWithHeader(requestHeader));
        }).getOrElse((Function0 & Serializable & scala.Serializable)() -> createTopicsRequest);
        channelManager.sendRequest(request, requestCompletionHandler);
        Seq creatableTopicResponses = (Seq)creatableTopics.keySet().toSeq().map((Function1 & Serializable & scala.Serializable)topic -> new MetadataResponseData.MetadataResponseTopic().setErrorCode(Errors.UNKNOWN_TOPIC_OR_PARTITION.code()).setName(topic).setIsInternal(Topic.isInternal((String)topic)), Seq$.MODULE$.canBuildFrom());
        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(57).append("Sent auto-creation request for ").append(creatableTopics.keys()).append(" to the active controller.").toString());
        return creatableTopicResponses;
    }

    public void kafka$server$DefaultAutoTopicCreationManager$$clearInflightRequests(Map<String, CreateTopicsRequestData.CreatableTopic> creatableTopics) {
        creatableTopics.keySet().foreach((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)DefaultAutoTopicCreationManager.$anonfun$clearInflightRequests$1(this, x$1)));
        this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(42).append("Cleared inflight topic creation state for ").append(creatableTopics).toString());
    }

    private CreateTopicsRequestData.CreatableTopic creatableTopic(String topic) {
        if ("__consumer_offsets".equals(topic)) {
            return new CreateTopicsRequestData.CreatableTopic().setName(topic).setNumPartitions(this.config.groupCoordinatorConfig().offsetsTopicPartitions()).setReplicationFactor(this.config.groupCoordinatorConfig().offsetsTopicReplicationFactor()).setConfigs(this.convertToTopicConfigCollections(this.groupCoordinator.groupMetadataTopicConfigs()));
        }
        if ("__transaction_state".equals(topic)) {
            return new CreateTopicsRequestData.CreatableTopic().setName(topic).setNumPartitions(Predef$.MODULE$.Integer2int(this.config.transactionTopicPartitions())).setReplicationFactor(Predef$.MODULE$.Short2short(this.config.transactionTopicReplicationFactor())).setConfigs(this.convertToTopicConfigCollections(this.txnCoordinator.transactionTopicConfigs()));
        }
        return new CreateTopicsRequestData.CreatableTopic().setName(topic).setNumPartitions(Predef$.MODULE$.Integer2int(this.config.numPartitions())).setReplicationFactor((short)this.config.defaultReplicationFactor());
    }

    private CreateTopicsRequestData.CreatableTopicConfigCollection convertToTopicConfigCollections(Properties config) {
        CreateTopicsRequestData.CreatableTopicConfigCollection topicConfigs = new CreateTopicsRequestData.CreatableTopicConfigCollection();
        config.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(x0$1, x1$1) -> topicConfigs.add((ImplicitLinkedHashCollection.Element)new CreateTopicsRequestData.CreatableTopicConfig().setName(x0$1.toString()).setValue(x1$1.toString()))));
        return topicConfigs;
    }

    private boolean isValidTopicName(String topic) {
        try {
            Topic.validate((String)topic);
            return true;
        }
        catch (InvalidTopicException invalidTopicException) {
            return false;
        }
    }

    private Tuple2<Map<String, CreateTopicsRequestData.CreatableTopic>, Seq<MetadataResponseData.MetadataResponseTopic>> filterCreatableTopics(Set<String> topics) {
        scala.collection.mutable.Map creatableTopics = Map$.MODULE$.empty();
        Buffer uncreatableTopics = (Buffer)Buffer$.MODULE$.empty();
        topics.foreach((Function1 & Serializable & scala.Serializable)topic -> {
            Some validationError;
            Object object = !this.isValidTopicName((String)topic) ? new Some((Object)Errors.INVALID_TOPIC_EXCEPTION) : (validationError = !this.inflightTopics().add((String)topic) ? new Some((Object)Errors.UNKNOWN_TOPIC_OR_PARTITION) : None$.MODULE$);
            if (validationError instanceof Some) {
                Errors error = (Errors)validationError.value();
                return uncreatableTopics.$plus$eq((Object)new MetadataResponseData.MetadataResponseTopic().setErrorCode(error.code()).setName(topic).setIsInternal(Topic.isInternal((String)topic)));
            }
            if (None$.MODULE$.equals(validationError)) {
                return creatableTopics.put(topic, (Object)this.creatableTopic((String)topic));
            }
            throw new MatchError((Object)validationError);
        });
        return new Tuple2((Object)creatableTopics, (Object)uncreatableTopics);
    }

    public static final /* synthetic */ boolean $anonfun$clearInflightRequests$1(DefaultAutoTopicCreationManager $this, Object x$1) {
        return $this.inflightTopics().remove(x$1);
    }

    public DefaultAutoTopicCreationManager(KafkaConfig config, Option<NodeToControllerChannelManager> channelManager, Option<ZkAdminManager> adminManager, Option<KafkaController> controller, GroupCoordinator groupCoordinator, TransactionCoordinator txnCoordinator) {
        this.config = config;
        this.channelManager = channelManager;
        this.adminManager = adminManager;
        this.controller = controller;
        this.groupCoordinator = groupCoordinator;
        this.txnCoordinator = txnCoordinator;
        Logging.$init$(this);
        if (controller.isEmpty() && channelManager.isEmpty()) {
            throw new IllegalArgumentException("Must supply a channel manager if not supplying a controller");
        }
        this.inflightTopics = Collections.newSetFromMap(new ConcurrentHashMap());
    }
}

