/*
 * Decompiled with CFR 0.152.
 */
package kafka;

import java.io.File;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Arrays;
import java.util.Properties;
import kafka.Kafka$;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.utils.Exit$;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.config.types.Password;
import org.apache.kafka.common.internals.FatalExitError;
import org.apache.kafka.common.utils.Exit;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;

@ScalaSignature(bytes="\u0006\u0001\t=b\u0001\u0002\u0017.\u0001ABQa\u000e\u0001\u0005\u0002aBQa\u000f\u0001\u0005\u0002qBQ!\u0014\u0001\u0005\u0002qBQA\u0015\u0001\u0005\u0002qBQa\u0016\u0001\u0005\u0002qBQ!\u0017\u0001\u0005\u0002qBQa\u0017\u0001\u0005\u0002qBQ!\u0018\u0001\u0005\u0002qBQa\u0018\u0001\u0005\u0002qBQ!\u0019\u0001\u0005\u0002qBQa\u0019\u0001\u0005\u0002qBQ!\u001a\u0001\u0005\u0002qBQa\u001a\u0001\u0005\n!DQa\u001d\u0001\u0005\u0002qBQ!\u001e\u0001\u0005\u0002qBqa\u001e\u0001C\u0002\u0013%\u0001\u0010\u0003\u0004}\u0001\u0001\u0006I!\u001f\u0005\b{\u0002\u0011\r\u0011\"\u0003\u007f\u0011\u001d\tY\u0001\u0001Q\u0001\n}D\u0001\"!\u0004\u0001\u0005\u0004%IA \u0005\b\u0003\u001f\u0001\u0001\u0015!\u0003\u0000\u0011%\t\t\u0002\u0001b\u0001\n\u0013\t\u0019\u0002\u0003\u0005\u0002&\u0001\u0001\u000b\u0011BA\u000b\u0011\u0019\t9\u0003\u0001C\u0001y!1\u00111\u0006\u0001\u0005\u0002qBa!a\f\u0001\t\u0003a\u0004BBA\u001a\u0001\u0011\u0005A\b\u0003\u0004\u00028\u0001!\t\u0001\u0010\u0005\u0007\u0003w\u0001A\u0011\u0001\u001f\t\r\u0005}\u0002\u0001\"\u0001=\u0011\u0019\t\u0019\u0005\u0001C\u0001y!1\u0011q\t\u0001\u0005\u0002qBa!a\u0013\u0001\t\u0003a\u0004BBA(\u0001\u0011\u0005A\b\u0003\u0004\u0002T\u0001!\t\u0001\u0010\u0005\u0007\u0003/\u0002A\u0011\u0001\u001f\t\r\u0005m\u0003\u0001\"\u0001=\u0011\u0019\ty\u0006\u0001C\u0001y!9\u00111\r\u0001\u0005\n\u0005\u0015\u0004\"CAg\u0001E\u0005I\u0011BAh\u0011\u001d\t\t\u0010\u0001C\u0001\u0003gDq!!>\u0001\t\u0003\t9\u0010C\u0004\u0003\u0004\u0001!\tA!\u0002\u0003\u001f-\u000bgm[1D_:4\u0017n\u001a+fgRT\u0011AL\u0001\u0006W\u000647.Y\u0002\u0001'\t\u0001\u0011\u0007\u0005\u00023k5\t1GC\u00015\u0003\u0015\u00198-\u00197b\u0013\t14G\u0001\u0004B]f\u0014VMZ\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003e\u0002\"A\u000f\u0001\u000e\u00035\nQa]3u+B$\u0012!\u0010\t\u0003eyJ!aP\u001a\u0003\tUs\u0017\u000e\u001e\u0015\u0003\u0005\u0005\u0003\"AQ&\u000e\u0003\rS!\u0001R#\u0002\u0007\u0005\u0004\u0018N\u0003\u0002G\u000f\u00069!.\u001e9ji\u0016\u0014(B\u0001%J\u0003\u0015QWO\\5u\u0015\u0005Q\u0015aA8sO&\u0011Aj\u0011\u0002\u000b\u0005\u00164wN]3FC\u000eD\u0017\u0001\u0003;fCJ$un\u001e8)\u0005\ry\u0005C\u0001\"Q\u0013\t\t6IA\u0005BMR,'/R1dQ\u0006QB/Z:u\u000f\u0016$8*\u00194lC\u000e{gNZ5h\rJ|W.\u0011:hg\"\u0012A\u0001\u0016\t\u0003\u0005VK!AV\"\u0003\tQ+7\u000f^\u0001*i\u0016\u001cHoR3u\u0017\u000647.Y\"p]\u001aLwM\u0012:p[\u0006\u0013xm\u001d(p]\u0006\u0013xm]!u)\",WI\u001c3)\u0005\u0015!\u0016!\n;fgR<U\r^&bM.\f7i\u001c8gS\u001e4%o\\7Be\u001e\u001chj\u001c8Be\u001e\u001cxJ\u001c7zQ\t1A+A\u0017uKN$x)\u001a;LC\u001a\\\u0017mQ8oM&<gI]8n\u0003J<7OT8o\u0003J<7/\u0011;UQ\u0016\u0014UmZ4j]\u001eD#a\u0002+\u0002=Q,7\u000f\u001e\"s_.,'OU8mK:{G-Z%e-\u0006d\u0017\u000eZ1uS>t\u0007F\u0001\u0005U\u0003\t\"Xm\u001d;D_:$(o\u001c7mKJ\u0014v\u000e\\3O_\u0012,\u0017\n\u001a,bY&$\u0017\r^5p]\"\u0012\u0011\u0002V\u0001!i\u0016\u001cHoQ8nE&tW\r\u001a*pY\u0016tu\u000eZ3JIZ\u000bG.\u001b3bi&|g\u000e\u000b\u0002\u000b)\u00069B/Z:u\u0013N\\%+\u00194u\u0007>l'-\u001b8fI6{G-\u001a\u0015\u0003\u0017Q\u000ba\u0006^3ti6+8\u000f^\"p]R\f\u0017N\\)v_J,XNV8uKJ\u001c\u0018JZ+tS:<\u0007K]8dKN\u001c(k\u001c7fg\"\u0012A\u0002V\u0001\u0011g\u0016$H*[:uK:,'\u000f\u0015:paN$\"!P5\t\u000b)l\u0001\u0019A6\u0002\u000bA\u0014x\u000e]:\u0011\u00051\fX\"A7\u000b\u00059|\u0017\u0001B;uS2T\u0011\u0001]\u0001\u0005U\u00064\u0018-\u0003\u0002s[\nQ\u0001K]8qKJ$\u0018.Z:\u0002+Q,7\u000f^&bM.\f7k\u001d7QCN\u001cxo\u001c:eg\"\u0012a\u0002V\u0001!i\u0016\u001cHoS1gW\u0006\u001c6\u000f\u001c)bgN<xN\u001d3t/&$\bnU=nE>d7\u000f\u000b\u0002\u0010)\u0006)\"m\\8mK\u0006t\u0007K]8q-\u0006dW/\u001a+p'\u0016$X#A=\u0011\u0005IR\u0018BA>4\u0005\u001d\u0011un\u001c7fC:\faCY8pY\u0016\fg\u000e\u0015:paZ\u000bG.^3U_N+G\u000fI\u0001\u0015gR\u0014\u0018N\\4Qe>\u0004h+\u00197vKR{7+\u001a;\u0016\u0003}\u0004B!!\u0001\u0002\b5\u0011\u00111\u0001\u0006\u0004\u0003\u000by\u0017\u0001\u00027b]\u001eLA!!\u0003\u0002\u0004\t11\u000b\u001e:j]\u001e\fQc\u001d;sS:<\u0007K]8q-\u0006dW/\u001a+p'\u0016$\b%\u0001\fqCN\u001cxo\u001c:e!J|\u0007OV1mk\u0016$vnU3u\u0003]\u0001\u0018m]:x_J$\u0007K]8q-\u0006dW/\u001a+p'\u0016$\b%\u0001\nmSN$\bK]8q-\u0006dW/\u001a+p'\u0016$XCAA\u000b!\u0015\t9\"!\t\u0000\u001b\t\tIB\u0003\u0003\u0002\u001c\u0005u\u0011!C5n[V$\u0018M\u00197f\u0015\r\tybM\u0001\u000bG>dG.Z2uS>t\u0017\u0002BA\u0012\u00033\u0011A\u0001T5ti\u0006\u0019B.[:u!J|\u0007OV1mk\u0016$vnU3uA\u0005)B/Z:u5.\u001c6\u000f\\\"mS\u0016tG/\u00128bE2,\u0007F\u0001\rU\u0003e!Xm\u001d;[WN\u001bHnS3z'R|'/\u001a'pG\u0006$\u0018n\u001c8)\u0005e!\u0016a\u0007;fgRT6nU:m)J,8\u000f^*u_J,Gj\\2bi&|g\u000e\u000b\u0002\u001b)\u0006iB/Z:u5>|7.Z3qKJ\\U-_*u_J,\u0007+Y:to>\u0014H\r\u000b\u0002\u001c)\u0006yB/Z:u5>|7.Z3qKJ$&/^:u'R|'/\u001a)bgN<xN\u001d3)\u0005q!\u0016!\u0006;fgRT6nU:m\u0017\u0016L8\u000b^8sKRK\b/\u001a\u0015\u0003;Q\u000bq\u0003^3tij[7k\u001d7UeV\u001cHo\u0015;pe\u0016$\u0016\u0010]3)\u0005y!\u0016!\u0005;fgRT6nU:m!J|Go\\2pY\"\u0012q\u0004V\u0001\u001ai\u0016\u001cHOW6Tg2,e.\u00192mK\u0012\u0004&o\u001c;pG>d7\u000f\u000b\u0002!)\u0006)B/Z:u5.\u001c6\u000f\\\"ja\",'oU;ji\u0016\u001c\bFA\u0011U\u0003!\"Xm\u001d;[WN\u001bH.\u00128ea>Lg\u000e^%eK:$\u0018NZ5dCRLwN\\!mO>\u0014\u0018\u000e\u001e5nQ\t\u0011C+\u0001\nuKN$(l[*tY\u000e\u0013H.\u00128bE2,\u0007FA\u0012U\u0003M!Xm\u001d;[WN\u001bHnT2ta\u0016s\u0017M\u00197fQ\t!C+A\u0011uKN$8i\u001c8oK\u000e$\u0018n\u001c8t\u001b\u0006D(+Z1vi\"l5\u000fR3gCVdG\u000f\u000b\u0002&)\u0006\u0011C/Z:u\u0007>tg.Z2uS>t7/T1y%\u0016\fW\u000f\u001e5Ng\u0016C\b\u000f\\5dSRD#A\n+\u0002\u0019Q,7\u000f\u001e.l\u0007>tg-[4\u0016\r\u0005\u001d\u0014\u0011SAc)=i\u0014\u0011NAA\u0003\u000b\u000bI)a)\u0002@\u0006%\u0007bBA6O\u0001\u0007\u0011QN\u0001\u000eW\u000647.\u0019)s_Bt\u0015-\\3\u0011\t\u0005=\u0014Q\u0010\b\u0005\u0003c\nI\bE\u0002\u0002tMj!!!\u001e\u000b\u0007\u0005]t&\u0001\u0004=e>|GOP\u0005\u0004\u0003w\u001a\u0014A\u0002)sK\u0012,g-\u0003\u0003\u0002\n\u0005}$bAA>g!9\u00111Q\u0014A\u0002\u00055\u0014!F3ya\u0016\u001cG/\u001a3LC\u001a\\\u0017\r\u0015:pa:\u000bW.\u001a\u0005\b\u0003\u000f;\u0003\u0019AA7\u0003-\u0019\u0018p\u001d)s_Bt\u0015-\\3\t\u000f\u0005-u\u00051\u0001\u0002\u000e\u0006q\u0001O]8q-\u0006dW/\u001a+p'\u0016$\b\u0003BAH\u0003#c\u0001\u0001B\u0004\u0002\u0014\u001e\u0012\r!!&\u0003\u0003Q\u000bB!a&\u0002\u001eB\u0019!'!'\n\u0007\u0005m5GA\u0004O_RD\u0017N\\4\u0011\u0007I\ny*C\u0002\u0002\"N\u00121!\u00118z\u0011\u001d\t)k\na\u0001\u0003O\u000b\u0001cZ3u!J|\u0007OV1mk\u00164%o\\7\u0011\u000fI\nI+!,\u0002:&\u0019\u00111V\u001a\u0003\u0013\u0019+hn\u0019;j_:\f\u0004\u0003BAX\u0003kk!!!-\u000b\u0007\u0005MV&\u0001\u0004tKJ4XM]\u0005\u0005\u0003o\u000b\tLA\u0006LC\u001a\\\u0017mQ8oM&<\u0007#\u0002\u001a\u0002<\u00065\u0015bAA_g\t1q\n\u001d;j_:Dq!!1(\u0001\u0004\t\u0019-A\u000bfqB,7\r^3e!J|\u0007/\u001a:usZ\u000bG.^3\u0011\t\u0005=\u0015Q\u0019\u0003\b\u0003\u000f<#\u0019AAK\u0005\u0005)\u0006\"CAfOA\u0005\t\u0019AA]\u0003Q)\u0007\u0010]3di\u0016$G)\u001a4bk2$h+\u00197vK\u00061B/Z:u5.\u001cuN\u001c4jO\u0012\"WMZ1vYR$s'\u0006\u0004\u0002R\u00065\u0018q^\u000b\u0003\u0003'TC!!6\u0002\\:\u0019!'a6\n\u0007\u0005e7'\u0001\u0003O_:,7FAAo!\u0011\ty.!;\u000e\u0005\u0005\u0005(\u0002BAr\u0003K\f\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\u0005\u001d8'\u0001\u0006b]:|G/\u0019;j_:LA!a;\u0002b\n\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0005\u000f\u0005M\u0005F1\u0001\u0002\u0016\u00129\u0011q\u0019\u0015C\u0002\u0005U\u0015\u0001\u00069sKB\f'/\u001a#fM\u0006,H\u000e^\"p]\u001aLw\r\u0006\u0002\u0002n\u0005i\u0001O]3qCJ,7i\u001c8gS\u001e$B!!\u001c\u0002z\"9\u00111 \u0016A\u0002\u0005u\u0018!\u00027j]\u0016\u001c\b#\u0002\u001a\u0002\u0000\u00065\u0014b\u0001B\u0001g\t)\u0011I\u001d:bs\u0006qD/Z:u\u0013:\u001cG.\u001e3f\u0007>tGO]8m!2\fg.\u001a'jgR,g.\u001a:OC6,\u0017J\\!em\u0016\u0014H/[:fI\n\u0013xn[3s\u0019&\u001cH/\u001a8feN$2!\u0010B\u0004\u0011\u0019\u0011Ia\u000ba\u0001s\u0006IQ.[4sCRLwN\u001c\u0015\bW\t5!Q\u0004B\u0010!\u0011\u0011yA!\u0007\u000e\u0005\tE!\u0002\u0002B\n\u0005+\t\u0001\u0002\u001d:pm&$WM\u001d\u0006\u0004\u0005/)\u0015A\u00029be\u0006l7/\u0003\u0003\u0003\u001c\tE!a\u0003,bYV,7k\\;sG\u0016\f\u0001BY8pY\u0016\fgn\u001d\u0017\u0005\u0005C\u0011\u0019#G\u0001\u00013\u0005\t\u0001fA\u0016\u0003(A!!\u0011\u0006B\u0016\u001b\t\u0011)\"\u0003\u0003\u0003.\tU!!\u0005)be\u0006lW\r^3sSj,G\rV3ti\u0002")
public class KafkaConfigTest {
    private final boolean booleanPropValueToSet;
    private final String stringPropValueToSet;
    private final String passwordPropValueToSet;
    private final List<String> listPropValueToSet = new .colon.colon((Object)"A", (List)new .colon.colon((Object)"B", (List)Nil$.MODULE$));

    /*
     * WARNING - void declaration
     */
    @BeforeEach
    public void setUp() {
        void setExitProcedure_exitProcedure;
        Function2 & Serializable & scala.Serializable intersect = (Function2 & Serializable & scala.Serializable)(status, x$1) -> KafkaConfigTest.$anonfun$setUp$1(BoxesRunTime.unboxToInt((Object)status), x$1);
        if (Exit$.MODULE$ == null) {
            throw null;
        }
        Exit.setExitProcedure((Exit.Procedure)new /* Unavailable Anonymous Inner Class!! */);
    }

    @AfterEach
    public void tearDown() {
        Exit$.MODULE$.resetExitProcedure();
    }

    @Test
    public void testGetKafkaConfigFromArgs() {
        String propertiesFile = this.prepareDefaultConfig();
        KafkaConfig config1 = KafkaConfig$.MODULE$.fromProps(Kafka$.MODULE$.getPropsFromArgs((String[])((Object[])new String[]{propertiesFile})));
        Assertions.assertEquals((int)1, (int)config1.brokerId());
        KafkaConfig config2 = KafkaConfig$.MODULE$.fromProps(Kafka$.MODULE$.getPropsFromArgs((String[])((Object[])new String[]{propertiesFile, "--override", "broker.id=2"})));
        Assertions.assertEquals((int)2, (int)config2.brokerId());
        KafkaConfig config3 = KafkaConfig$.MODULE$.fromProps(Kafka$.MODULE$.getPropsFromArgs((String[])((Object[])new String[]{propertiesFile, "--override", "log.cleanup.policy=compact"})));
        Assertions.assertEquals((int)1, (int)config3.brokerId());
        Assertions.assertEquals(Arrays.asList((Object[])new String[]{"compact"}), (Object)config3.logCleanupPolicy());
        KafkaConfig config4 = KafkaConfig$.MODULE$.fromProps(Kafka$.MODULE$.getPropsFromArgs((String[])((Object[])new String[]{propertiesFile, "--override", "log.cleanup.policy=compact,delete", "--override", "broker.id=2"})));
        Assertions.assertEquals((int)2, (int)config4.brokerId());
        Assertions.assertEquals(Arrays.asList((Object[])new String[]{"compact", "delete"}), (Object)config4.logCleanupPolicy());
    }

    @Test
    public void testGetKafkaConfigFromArgsNonArgsAtTheEnd() {
        String propertiesFile = this.prepareDefaultConfig();
        Assertions.assertThrows(FatalExitError.class, () -> KafkaConfig$.MODULE$.fromProps(Kafka$.MODULE$.getPropsFromArgs((String[])((Object[])new String[]{propertiesFile, "--override", "broker.id=1", "broker.id=2"}))));
    }

    @Test
    public void testGetKafkaConfigFromArgsNonArgsOnly() {
        String propertiesFile = this.prepareDefaultConfig();
        Assertions.assertThrows(FatalExitError.class, () -> KafkaConfig$.MODULE$.fromProps(Kafka$.MODULE$.getPropsFromArgs((String[])((Object[])new String[]{propertiesFile, "broker.id=1", "broker.id=2"}))));
    }

    @Test
    public void testGetKafkaConfigFromArgsNonArgsAtTheBegging() {
        String propertiesFile = this.prepareDefaultConfig();
        Assertions.assertThrows(FatalExitError.class, () -> KafkaConfig$.MODULE$.fromProps(Kafka$.MODULE$.getPropsFromArgs((String[])((Object[])new String[]{propertiesFile, "broker.id=1", "--override", "broker.id=2"}))));
    }

    @Test
    public void testBrokerRoleNodeIdValidation() {
        Properties propertiesFile = new Properties();
        propertiesFile.setProperty("process.roles", "broker");
        propertiesFile.setProperty("node.id", "1");
        propertiesFile.setProperty("controller.quorum.voters", "1@localhost:9092");
        this.setListenerProps(propertiesFile);
        TestUtils$.MODULE$.assertBadConfigContainingMessage(propertiesFile, "If process.roles contains just the 'broker' role, the node id 1 must not be included in the set of voters");
        propertiesFile.setProperty("node.id", "2");
        KafkaConfig$.MODULE$.fromProps(propertiesFile);
    }

    @Test
    public void testControllerRoleNodeIdValidation() {
        Properties propertiesFile = new Properties();
        propertiesFile.setProperty("process.roles", "controller");
        propertiesFile.setProperty("node.id", "1");
        propertiesFile.setProperty("controller.quorum.voters", "2@localhost:9092");
        this.setListenerProps(propertiesFile);
        TestUtils$.MODULE$.assertBadConfigContainingMessage(propertiesFile, "If process.roles contains the 'controller' role, the node id 1 must be included in the set of voters");
        propertiesFile.setProperty("node.id", "2");
        KafkaConfig$.MODULE$.fromProps(propertiesFile);
    }

    @Test
    public void testCombinedRoleNodeIdValidation() {
        Properties propertiesFile = new Properties();
        propertiesFile.setProperty("process.roles", "controller,broker");
        propertiesFile.setProperty("node.id", "1");
        propertiesFile.setProperty("controller.quorum.voters", "2@localhost:9092");
        this.setListenerProps(propertiesFile);
        TestUtils$.MODULE$.assertBadConfigContainingMessage(propertiesFile, "If process.roles contains the 'controller' role, the node id 1 must be included in the set of voters");
        propertiesFile.setProperty("node.id", "2");
        KafkaConfig$.MODULE$.fromProps(propertiesFile);
    }

    @Test
    public void testIsKRaftCombinedMode() {
        Properties propertiesFile = new Properties();
        propertiesFile.setProperty("process.roles", "controller,broker");
        propertiesFile.setProperty("node.id", "1");
        propertiesFile.setProperty("controller.quorum.voters", "1@localhost:9092");
        this.setListenerProps(propertiesFile);
        Assertions.assertTrue((boolean)KafkaConfig$.MODULE$.fromProps(propertiesFile).isKRaftCombinedMode());
    }

    @Test
    public void testMustContainQuorumVotersIfUsingProcessRoles() {
        Properties propertiesFile = new Properties();
        propertiesFile.setProperty("process.roles", "controller,broker");
        propertiesFile.setProperty("node.id", "1");
        propertiesFile.setProperty("controller.quorum.voters", "");
        this.setListenerProps(propertiesFile);
        TestUtils$.MODULE$.assertBadConfigContainingMessage(propertiesFile, new StringOps(Predef$.MODULE$.augmentString("If using process.roles, either controller.quorum.bootstrap.servers\n      |must contain the set of bootstrap controllers or controller.quorum.voters must contain a\n      |parseable set of controllers.")).stripMargin().replace("\n", " "));
        propertiesFile.setProperty("process.roles", "");
        TestUtils$.MODULE$.assertBadConfigContainingMessage(propertiesFile, "Missing required configuration `zookeeper.connect` which has no default value.");
        propertiesFile.setProperty("zookeeper.connect", "localhost:2181");
        propertiesFile.setProperty("controller.listener.names", "");
        KafkaConfig$.MODULE$.fromProps(propertiesFile);
    }

    private void setListenerProps(Properties props) {
        boolean hasBrokerRole = props.getProperty("process.roles").contains("broker");
        boolean hasControllerRole = props.getProperty("process.roles").contains("controller");
        String controllerListener = "SASL_PLAINTEXT://localhost:9092";
        String brokerListener = "PLAINTEXT://localhost:9093";
        if (hasBrokerRole || hasControllerRole) {
            props.setProperty("controller.listener.names", "SASL_PLAINTEXT");
            if (hasBrokerRole && hasControllerRole) {
                props.setProperty("listeners", new StringBuilder(1).append(brokerListener).append(",").append(controllerListener).toString());
            } else if (hasControllerRole) {
                props.setProperty("listeners", controllerListener);
            } else if (hasBrokerRole) {
                props.setProperty("listeners", brokerListener);
            }
        } else {
            props.setProperty("listeners", brokerListener);
        }
        if (!(hasControllerRole & !hasBrokerRole)) {
            props.setProperty("inter.broker.listener.name", "PLAINTEXT");
            props.setProperty("advertised.listeners", "PLAINTEXT://localhost:9092");
            return;
        }
    }

    @Test
    public void testKafkaSslPasswords() {
        String propertiesFile = this.prepareDefaultConfig();
        KafkaConfig config = KafkaConfig$.MODULE$.fromProps(Kafka$.MODULE$.getPropsFromArgs((String[])((Object[])new String[]{propertiesFile, "--override", "ssl.keystore.password=keystore_password", "--override", "ssl.key.password=key_password", "--override", "ssl.truststore.password=truststore_password", "--override", "ssl.keystore.certificate.chain=certificate_chain", "--override", "ssl.keystore.key=private_key", "--override", "ssl.truststore.certificates=truststore_certificates"})));
        Assertions.assertEquals((Object)"[hidden]", (Object)config.getPassword("ssl.key.password").toString());
        Assertions.assertEquals((Object)"[hidden]", (Object)config.getPassword("ssl.keystore.password").toString());
        Assertions.assertEquals((Object)"[hidden]", (Object)config.getPassword("ssl.truststore.password").toString());
        Assertions.assertEquals((Object)"[hidden]", (Object)config.getPassword("ssl.keystore.key").toString());
        Assertions.assertEquals((Object)"[hidden]", (Object)config.getPassword("ssl.keystore.certificate.chain").toString());
        Assertions.assertEquals((Object)"[hidden]", (Object)config.getPassword("ssl.truststore.certificates").toString());
        Assertions.assertEquals((Object)"key_password", (Object)config.getPassword("ssl.key.password").value());
        Assertions.assertEquals((Object)"keystore_password", (Object)config.getPassword("ssl.keystore.password").value());
        Assertions.assertEquals((Object)"truststore_password", (Object)config.getPassword("ssl.truststore.password").value());
        Assertions.assertEquals((Object)"private_key", (Object)config.getPassword("ssl.keystore.key").value());
        Assertions.assertEquals((Object)"certificate_chain", (Object)config.getPassword("ssl.keystore.certificate.chain").value());
        Assertions.assertEquals((Object)"truststore_certificates", (Object)config.getPassword("ssl.truststore.certificates").value());
    }

    @Test
    public void testKafkaSslPasswordsWithSymbols() {
        String password = "=!#-+!?*/\"'^%$=\\.,@:;=";
        String propertiesFile = this.prepareDefaultConfig();
        KafkaConfig config = KafkaConfig$.MODULE$.fromProps(Kafka$.MODULE$.getPropsFromArgs((String[])((Object[])new String[]{propertiesFile, "--override", new StringBuilder(22).append("ssl.keystore.password=").append(password).toString(), "--override", new StringBuilder(17).append("ssl.key.password=").append(password).toString(), "--override", new StringBuilder(24).append("ssl.truststore.password=").append(password).toString()})));
        Assertions.assertEquals((Object)"[hidden]", (Object)config.getPassword("ssl.key.password").toString());
        Assertions.assertEquals((Object)"[hidden]", (Object)config.getPassword("ssl.keystore.password").toString());
        Assertions.assertEquals((Object)"[hidden]", (Object)config.getPassword("ssl.truststore.password").toString());
        Assertions.assertEquals((Object)password, (Object)config.getPassword("ssl.keystore.password").value());
        Assertions.assertEquals((Object)password, (Object)config.getPassword("ssl.key.password").value());
        Assertions.assertEquals((Object)password, (Object)config.getPassword("ssl.truststore.password").value());
    }

    private boolean booleanPropValueToSet() {
        return this.booleanPropValueToSet;
    }

    private String stringPropValueToSet() {
        return this.stringPropValueToSet;
    }

    private String passwordPropValueToSet() {
        return this.passwordPropValueToSet;
    }

    private List<String> listPropValueToSet() {
        return this.listPropValueToSet;
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testZkSslClientEnable() {
        void testZkConfig_expectedPropertyValue;
        void testZkConfig_propValueToSet;
        void testZkConfig_sysPropName;
        void testZkConfig_expectedDefaultValue;
        Some some = new Some((Object)BoxesRunTime.boxToBoolean((boolean)false));
        Boolean bl = BoxesRunTime.boxToBoolean((boolean)this.booleanPropValueToSet());
        Boolean bl2 = BoxesRunTime.boxToBoolean((boolean)this.booleanPropValueToSet());
        String string = "zookeeper.client.secure";
        String testZkConfig_expectedKafkaPropName = "zookeeper.ssl.client.enable";
        String testZkConfig_kafkaPropName = "zookeeper.ssl.client.enable";
        Assertions.assertEquals((Object)testZkConfig_expectedKafkaPropName, (Object)testZkConfig_kafkaPropName);
        String testZkConfig_propertiesFile = this.prepareDefaultConfig();
        KafkaConfig testZkConfig_emptyConfig = KafkaConfig$.MODULE$.fromProps(Kafka$.MODULE$.getPropsFromArgs((String[])((Object[])new String[]{testZkConfig_propertiesFile})));
        Assertions.assertNull(testZkConfig_emptyConfig.originals().get(testZkConfig_kafkaPropName));
        if (testZkConfig_expectedDefaultValue.isDefined()) {
            Assertions.assertEquals((Object)testZkConfig_expectedDefaultValue.get(), testZkConfig_emptyConfig.values().get(testZkConfig_kafkaPropName));
            Assertions.assertEquals((Object)testZkConfig_expectedDefaultValue.get(), (Object)KafkaConfigTest.$anonfun$testZkSslClientEnable$1(testZkConfig_emptyConfig).get());
        } else {
            Assertions.assertNull(testZkConfig_emptyConfig.values().get(testZkConfig_kafkaPropName));
            Assertions.assertEquals((Object)None$.MODULE$, (Object)KafkaConfigTest.$anonfun$testZkSslClientEnable$1(testZkConfig_emptyConfig));
        }
        try {
            System.setProperty((String)testZkConfig_sysPropName, String.valueOf(testZkConfig_propValueToSet));
            KafkaConfig testZkConfig_config = KafkaConfig$.MODULE$.fromProps(Kafka$.MODULE$.getPropsFromArgs((String[])((Object[])new String[]{testZkConfig_propertiesFile})));
            Assertions.assertNull(testZkConfig_config.originals().get(testZkConfig_kafkaPropName));
            if (testZkConfig_expectedDefaultValue.isDefined()) {
                Assertions.assertEquals((Object)testZkConfig_expectedDefaultValue.get(), testZkConfig_config.values().get(testZkConfig_kafkaPropName));
            } else {
                Assertions.assertNull(testZkConfig_config.values().get(testZkConfig_kafkaPropName));
            }
            Assertions.assertEquals((Object)new Some((Object)testZkConfig_expectedPropertyValue), (Object)KafkaConfigTest.$anonfun$testZkSslClientEnable$1(testZkConfig_config));
        }
        finally {
            System.clearProperty((String)testZkConfig_sysPropName);
        }
        KafkaConfig testZkConfig_config = KafkaConfig$.MODULE$.fromProps(Kafka$.MODULE$.getPropsFromArgs((String[])((Object[])new String[]{testZkConfig_propertiesFile, "--override", new StringBuilder(1).append(testZkConfig_kafkaPropName).append("=").append(testZkConfig_propValueToSet).toString()})));
        Assertions.assertEquals((Object)testZkConfig_expectedPropertyValue, testZkConfig_config.values().get(testZkConfig_kafkaPropName));
        Assertions.assertEquals((Object)new Some((Object)testZkConfig_expectedPropertyValue), (Object)KafkaConfigTest.$anonfun$testZkSslClientEnable$1(testZkConfig_config));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testZkSslKeyStoreLocation() {
        void testZkConfig_expectedPropertyValue;
        void testZkConfig_propValueToSet;
        void testZkConfig_sysPropName;
        void testZkConfig_expectedDefaultValue;
        None$ none$ = this.testZkConfig$default$7();
        String string = this.stringPropValueToSet();
        String string2 = this.stringPropValueToSet();
        String string3 = "zookeeper.ssl.keyStore.location";
        String testZkConfig_expectedKafkaPropName = "zookeeper.ssl.keystore.location";
        String testZkConfig_kafkaPropName = "zookeeper.ssl.keystore.location";
        Assertions.assertEquals((Object)testZkConfig_expectedKafkaPropName, (Object)testZkConfig_kafkaPropName);
        String testZkConfig_propertiesFile = this.prepareDefaultConfig();
        KafkaConfig testZkConfig_emptyConfig = KafkaConfig$.MODULE$.fromProps(Kafka$.MODULE$.getPropsFromArgs((String[])((Object[])new String[]{testZkConfig_propertiesFile})));
        Assertions.assertNull(testZkConfig_emptyConfig.originals().get(testZkConfig_kafkaPropName));
        if (testZkConfig_expectedDefaultValue.isDefined()) {
            Assertions.assertEquals((Object)testZkConfig_expectedDefaultValue.get(), testZkConfig_emptyConfig.values().get(testZkConfig_kafkaPropName));
            Assertions.assertEquals((Object)testZkConfig_expectedDefaultValue.get(), (Object)testZkConfig_emptyConfig.zkSslKeyStoreLocation().get());
        } else {
            Assertions.assertNull(testZkConfig_emptyConfig.values().get(testZkConfig_kafkaPropName));
            Assertions.assertEquals((Object)None$.MODULE$, (Object)testZkConfig_emptyConfig.zkSslKeyStoreLocation());
        }
        try {
            System.setProperty((String)testZkConfig_sysPropName, String.valueOf(testZkConfig_propValueToSet));
            KafkaConfig testZkConfig_config = KafkaConfig$.MODULE$.fromProps(Kafka$.MODULE$.getPropsFromArgs((String[])((Object[])new String[]{testZkConfig_propertiesFile})));
            Assertions.assertNull(testZkConfig_config.originals().get(testZkConfig_kafkaPropName));
            if (testZkConfig_expectedDefaultValue.isDefined()) {
                Assertions.assertEquals((Object)testZkConfig_expectedDefaultValue.get(), testZkConfig_config.values().get(testZkConfig_kafkaPropName));
            } else {
                Assertions.assertNull(testZkConfig_config.values().get(testZkConfig_kafkaPropName));
            }
            Assertions.assertEquals((Object)new Some((Object)testZkConfig_expectedPropertyValue), (Object)testZkConfig_config.zkSslKeyStoreLocation());
        }
        finally {
            System.clearProperty((String)testZkConfig_sysPropName);
        }
        KafkaConfig testZkConfig_config = KafkaConfig$.MODULE$.fromProps(Kafka$.MODULE$.getPropsFromArgs((String[])((Object[])new String[]{testZkConfig_propertiesFile, "--override", new StringBuilder(1).append(testZkConfig_kafkaPropName).append("=").append(testZkConfig_propValueToSet).toString()})));
        Assertions.assertEquals((Object)testZkConfig_expectedPropertyValue, testZkConfig_config.values().get(testZkConfig_kafkaPropName));
        Assertions.assertEquals((Object)new Some((Object)testZkConfig_expectedPropertyValue), (Object)testZkConfig_config.zkSslKeyStoreLocation());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testZkSslTrustStoreLocation() {
        void testZkConfig_expectedPropertyValue;
        void testZkConfig_propValueToSet;
        void testZkConfig_sysPropName;
        void testZkConfig_expectedDefaultValue;
        None$ none$ = this.testZkConfig$default$7();
        String string = this.stringPropValueToSet();
        String string2 = this.stringPropValueToSet();
        String string3 = "zookeeper.ssl.trustStore.location";
        String testZkConfig_expectedKafkaPropName = "zookeeper.ssl.truststore.location";
        String testZkConfig_kafkaPropName = "zookeeper.ssl.truststore.location";
        Assertions.assertEquals((Object)testZkConfig_expectedKafkaPropName, (Object)testZkConfig_kafkaPropName);
        String testZkConfig_propertiesFile = this.prepareDefaultConfig();
        KafkaConfig testZkConfig_emptyConfig = KafkaConfig$.MODULE$.fromProps(Kafka$.MODULE$.getPropsFromArgs((String[])((Object[])new String[]{testZkConfig_propertiesFile})));
        Assertions.assertNull(testZkConfig_emptyConfig.originals().get(testZkConfig_kafkaPropName));
        if (testZkConfig_expectedDefaultValue.isDefined()) {
            Assertions.assertEquals((Object)testZkConfig_expectedDefaultValue.get(), testZkConfig_emptyConfig.values().get(testZkConfig_kafkaPropName));
            Assertions.assertEquals((Object)testZkConfig_expectedDefaultValue.get(), (Object)testZkConfig_emptyConfig.zkSslTrustStoreLocation().get());
        } else {
            Assertions.assertNull(testZkConfig_emptyConfig.values().get(testZkConfig_kafkaPropName));
            Assertions.assertEquals((Object)None$.MODULE$, (Object)testZkConfig_emptyConfig.zkSslTrustStoreLocation());
        }
        try {
            System.setProperty((String)testZkConfig_sysPropName, String.valueOf(testZkConfig_propValueToSet));
            KafkaConfig testZkConfig_config = KafkaConfig$.MODULE$.fromProps(Kafka$.MODULE$.getPropsFromArgs((String[])((Object[])new String[]{testZkConfig_propertiesFile})));
            Assertions.assertNull(testZkConfig_config.originals().get(testZkConfig_kafkaPropName));
            if (testZkConfig_expectedDefaultValue.isDefined()) {
                Assertions.assertEquals((Object)testZkConfig_expectedDefaultValue.get(), testZkConfig_config.values().get(testZkConfig_kafkaPropName));
            } else {
                Assertions.assertNull(testZkConfig_config.values().get(testZkConfig_kafkaPropName));
            }
            Assertions.assertEquals((Object)new Some((Object)testZkConfig_expectedPropertyValue), (Object)testZkConfig_config.zkSslTrustStoreLocation());
        }
        finally {
            System.clearProperty((String)testZkConfig_sysPropName);
        }
        KafkaConfig testZkConfig_config = KafkaConfig$.MODULE$.fromProps(Kafka$.MODULE$.getPropsFromArgs((String[])((Object[])new String[]{testZkConfig_propertiesFile, "--override", new StringBuilder(1).append(testZkConfig_kafkaPropName).append("=").append(testZkConfig_propValueToSet).toString()})));
        Assertions.assertEquals((Object)testZkConfig_expectedPropertyValue, testZkConfig_config.values().get(testZkConfig_kafkaPropName));
        Assertions.assertEquals((Object)new Some((Object)testZkConfig_expectedPropertyValue), (Object)testZkConfig_config.zkSslTrustStoreLocation());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testZookeeperKeyStorePassword() {
        void testZkConfig_expectedPropertyValue;
        void testZkConfig_propValueToSet;
        void testZkConfig_sysPropName;
        void testZkConfig_expectedDefaultValue;
        None$ none$ = this.testZkConfig$default$7();
        Password password = new Password(this.passwordPropValueToSet());
        String string = this.passwordPropValueToSet();
        String string2 = "zookeeper.ssl.keyStore.password";
        String testZkConfig_expectedKafkaPropName = "zookeeper.ssl.keystore.password";
        String testZkConfig_kafkaPropName = "zookeeper.ssl.keystore.password";
        Assertions.assertEquals((Object)testZkConfig_expectedKafkaPropName, (Object)testZkConfig_kafkaPropName);
        String testZkConfig_propertiesFile = this.prepareDefaultConfig();
        KafkaConfig testZkConfig_emptyConfig = KafkaConfig$.MODULE$.fromProps(Kafka$.MODULE$.getPropsFromArgs((String[])((Object[])new String[]{testZkConfig_propertiesFile})));
        Assertions.assertNull(testZkConfig_emptyConfig.originals().get(testZkConfig_kafkaPropName));
        if (testZkConfig_expectedDefaultValue.isDefined()) {
            Assertions.assertEquals((Object)testZkConfig_expectedDefaultValue.get(), testZkConfig_emptyConfig.values().get(testZkConfig_kafkaPropName));
            Assertions.assertEquals((Object)testZkConfig_expectedDefaultValue.get(), (Object)testZkConfig_emptyConfig.zkSslKeyStorePassword().get());
        } else {
            Assertions.assertNull(testZkConfig_emptyConfig.values().get(testZkConfig_kafkaPropName));
            Assertions.assertEquals((Object)None$.MODULE$, (Object)testZkConfig_emptyConfig.zkSslKeyStorePassword());
        }
        try {
            System.setProperty((String)testZkConfig_sysPropName, String.valueOf(testZkConfig_propValueToSet));
            KafkaConfig testZkConfig_config = KafkaConfig$.MODULE$.fromProps(Kafka$.MODULE$.getPropsFromArgs((String[])((Object[])new String[]{testZkConfig_propertiesFile})));
            Assertions.assertNull(testZkConfig_config.originals().get(testZkConfig_kafkaPropName));
            if (testZkConfig_expectedDefaultValue.isDefined()) {
                Assertions.assertEquals((Object)testZkConfig_expectedDefaultValue.get(), testZkConfig_config.values().get(testZkConfig_kafkaPropName));
            } else {
                Assertions.assertNull(testZkConfig_config.values().get(testZkConfig_kafkaPropName));
            }
            Assertions.assertEquals((Object)new Some((Object)testZkConfig_expectedPropertyValue), (Object)testZkConfig_config.zkSslKeyStorePassword());
        }
        finally {
            System.clearProperty((String)testZkConfig_sysPropName);
        }
        KafkaConfig testZkConfig_config = KafkaConfig$.MODULE$.fromProps(Kafka$.MODULE$.getPropsFromArgs((String[])((Object[])new String[]{testZkConfig_propertiesFile, "--override", new StringBuilder(1).append(testZkConfig_kafkaPropName).append("=").append(testZkConfig_propValueToSet).toString()})));
        Assertions.assertEquals((Object)testZkConfig_expectedPropertyValue, testZkConfig_config.values().get(testZkConfig_kafkaPropName));
        Assertions.assertEquals((Object)new Some((Object)testZkConfig_expectedPropertyValue), (Object)testZkConfig_config.zkSslKeyStorePassword());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testZookeeperTrustStorePassword() {
        void testZkConfig_expectedPropertyValue;
        void testZkConfig_propValueToSet;
        void testZkConfig_sysPropName;
        void testZkConfig_expectedDefaultValue;
        None$ none$ = this.testZkConfig$default$7();
        Password password = new Password(this.passwordPropValueToSet());
        String string = this.passwordPropValueToSet();
        String string2 = "zookeeper.ssl.trustStore.password";
        String testZkConfig_expectedKafkaPropName = "zookeeper.ssl.truststore.password";
        String testZkConfig_kafkaPropName = "zookeeper.ssl.truststore.password";
        Assertions.assertEquals((Object)testZkConfig_expectedKafkaPropName, (Object)testZkConfig_kafkaPropName);
        String testZkConfig_propertiesFile = this.prepareDefaultConfig();
        KafkaConfig testZkConfig_emptyConfig = KafkaConfig$.MODULE$.fromProps(Kafka$.MODULE$.getPropsFromArgs((String[])((Object[])new String[]{testZkConfig_propertiesFile})));
        Assertions.assertNull(testZkConfig_emptyConfig.originals().get(testZkConfig_kafkaPropName));
        if (testZkConfig_expectedDefaultValue.isDefined()) {
            Assertions.assertEquals((Object)testZkConfig_expectedDefaultValue.get(), testZkConfig_emptyConfig.values().get(testZkConfig_kafkaPropName));
            Assertions.assertEquals((Object)testZkConfig_expectedDefaultValue.get(), (Object)testZkConfig_emptyConfig.zkSslTrustStorePassword().get());
        } else {
            Assertions.assertNull(testZkConfig_emptyConfig.values().get(testZkConfig_kafkaPropName));
            Assertions.assertEquals((Object)None$.MODULE$, (Object)testZkConfig_emptyConfig.zkSslTrustStorePassword());
        }
        try {
            System.setProperty((String)testZkConfig_sysPropName, String.valueOf(testZkConfig_propValueToSet));
            KafkaConfig testZkConfig_config = KafkaConfig$.MODULE$.fromProps(Kafka$.MODULE$.getPropsFromArgs((String[])((Object[])new String[]{testZkConfig_propertiesFile})));
            Assertions.assertNull(testZkConfig_config.originals().get(testZkConfig_kafkaPropName));
            if (testZkConfig_expectedDefaultValue.isDefined()) {
                Assertions.assertEquals((Object)testZkConfig_expectedDefaultValue.get(), testZkConfig_config.values().get(testZkConfig_kafkaPropName));
            } else {
                Assertions.assertNull(testZkConfig_config.values().get(testZkConfig_kafkaPropName));
            }
            Assertions.assertEquals((Object)new Some((Object)testZkConfig_expectedPropertyValue), (Object)testZkConfig_config.zkSslTrustStorePassword());
        }
        finally {
            System.clearProperty((String)testZkConfig_sysPropName);
        }
        KafkaConfig testZkConfig_config = KafkaConfig$.MODULE$.fromProps(Kafka$.MODULE$.getPropsFromArgs((String[])((Object[])new String[]{testZkConfig_propertiesFile, "--override", new StringBuilder(1).append(testZkConfig_kafkaPropName).append("=").append(testZkConfig_propValueToSet).toString()})));
        Assertions.assertEquals((Object)testZkConfig_expectedPropertyValue, testZkConfig_config.values().get(testZkConfig_kafkaPropName));
        Assertions.assertEquals((Object)new Some((Object)testZkConfig_expectedPropertyValue), (Object)testZkConfig_config.zkSslTrustStorePassword());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testZkSslKeyStoreType() {
        void testZkConfig_expectedPropertyValue;
        void testZkConfig_propValueToSet;
        void testZkConfig_sysPropName;
        void testZkConfig_expectedDefaultValue;
        None$ none$ = this.testZkConfig$default$7();
        String string = this.stringPropValueToSet();
        String string2 = this.stringPropValueToSet();
        String string3 = "zookeeper.ssl.keyStore.type";
        String testZkConfig_expectedKafkaPropName = "zookeeper.ssl.keystore.type";
        String testZkConfig_kafkaPropName = "zookeeper.ssl.keystore.type";
        Assertions.assertEquals((Object)testZkConfig_expectedKafkaPropName, (Object)testZkConfig_kafkaPropName);
        String testZkConfig_propertiesFile = this.prepareDefaultConfig();
        KafkaConfig testZkConfig_emptyConfig = KafkaConfig$.MODULE$.fromProps(Kafka$.MODULE$.getPropsFromArgs((String[])((Object[])new String[]{testZkConfig_propertiesFile})));
        Assertions.assertNull(testZkConfig_emptyConfig.originals().get(testZkConfig_kafkaPropName));
        if (testZkConfig_expectedDefaultValue.isDefined()) {
            Assertions.assertEquals((Object)testZkConfig_expectedDefaultValue.get(), testZkConfig_emptyConfig.values().get(testZkConfig_kafkaPropName));
            Assertions.assertEquals((Object)testZkConfig_expectedDefaultValue.get(), (Object)testZkConfig_emptyConfig.zkSslKeyStoreType().get());
        } else {
            Assertions.assertNull(testZkConfig_emptyConfig.values().get(testZkConfig_kafkaPropName));
            Assertions.assertEquals((Object)None$.MODULE$, (Object)testZkConfig_emptyConfig.zkSslKeyStoreType());
        }
        try {
            System.setProperty((String)testZkConfig_sysPropName, String.valueOf(testZkConfig_propValueToSet));
            KafkaConfig testZkConfig_config = KafkaConfig$.MODULE$.fromProps(Kafka$.MODULE$.getPropsFromArgs((String[])((Object[])new String[]{testZkConfig_propertiesFile})));
            Assertions.assertNull(testZkConfig_config.originals().get(testZkConfig_kafkaPropName));
            if (testZkConfig_expectedDefaultValue.isDefined()) {
                Assertions.assertEquals((Object)testZkConfig_expectedDefaultValue.get(), testZkConfig_config.values().get(testZkConfig_kafkaPropName));
            } else {
                Assertions.assertNull(testZkConfig_config.values().get(testZkConfig_kafkaPropName));
            }
            Assertions.assertEquals((Object)new Some((Object)testZkConfig_expectedPropertyValue), (Object)testZkConfig_config.zkSslKeyStoreType());
        }
        finally {
            System.clearProperty((String)testZkConfig_sysPropName);
        }
        KafkaConfig testZkConfig_config = KafkaConfig$.MODULE$.fromProps(Kafka$.MODULE$.getPropsFromArgs((String[])((Object[])new String[]{testZkConfig_propertiesFile, "--override", new StringBuilder(1).append(testZkConfig_kafkaPropName).append("=").append(testZkConfig_propValueToSet).toString()})));
        Assertions.assertEquals((Object)testZkConfig_expectedPropertyValue, testZkConfig_config.values().get(testZkConfig_kafkaPropName));
        Assertions.assertEquals((Object)new Some((Object)testZkConfig_expectedPropertyValue), (Object)testZkConfig_config.zkSslKeyStoreType());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testZkSslTrustStoreType() {
        void testZkConfig_expectedPropertyValue;
        void testZkConfig_propValueToSet;
        void testZkConfig_sysPropName;
        void testZkConfig_expectedDefaultValue;
        None$ none$ = this.testZkConfig$default$7();
        String string = this.stringPropValueToSet();
        String string2 = this.stringPropValueToSet();
        String string3 = "zookeeper.ssl.trustStore.type";
        String testZkConfig_expectedKafkaPropName = "zookeeper.ssl.truststore.type";
        String testZkConfig_kafkaPropName = "zookeeper.ssl.truststore.type";
        Assertions.assertEquals((Object)testZkConfig_expectedKafkaPropName, (Object)testZkConfig_kafkaPropName);
        String testZkConfig_propertiesFile = this.prepareDefaultConfig();
        KafkaConfig testZkConfig_emptyConfig = KafkaConfig$.MODULE$.fromProps(Kafka$.MODULE$.getPropsFromArgs((String[])((Object[])new String[]{testZkConfig_propertiesFile})));
        Assertions.assertNull(testZkConfig_emptyConfig.originals().get(testZkConfig_kafkaPropName));
        if (testZkConfig_expectedDefaultValue.isDefined()) {
            Assertions.assertEquals((Object)testZkConfig_expectedDefaultValue.get(), testZkConfig_emptyConfig.values().get(testZkConfig_kafkaPropName));
            Assertions.assertEquals((Object)testZkConfig_expectedDefaultValue.get(), (Object)testZkConfig_emptyConfig.zkSslTrustStoreType().get());
        } else {
            Assertions.assertNull(testZkConfig_emptyConfig.values().get(testZkConfig_kafkaPropName));
            Assertions.assertEquals((Object)None$.MODULE$, (Object)testZkConfig_emptyConfig.zkSslTrustStoreType());
        }
        try {
            System.setProperty((String)testZkConfig_sysPropName, String.valueOf(testZkConfig_propValueToSet));
            KafkaConfig testZkConfig_config = KafkaConfig$.MODULE$.fromProps(Kafka$.MODULE$.getPropsFromArgs((String[])((Object[])new String[]{testZkConfig_propertiesFile})));
            Assertions.assertNull(testZkConfig_config.originals().get(testZkConfig_kafkaPropName));
            if (testZkConfig_expectedDefaultValue.isDefined()) {
                Assertions.assertEquals((Object)testZkConfig_expectedDefaultValue.get(), testZkConfig_config.values().get(testZkConfig_kafkaPropName));
            } else {
                Assertions.assertNull(testZkConfig_config.values().get(testZkConfig_kafkaPropName));
            }
            Assertions.assertEquals((Object)new Some((Object)testZkConfig_expectedPropertyValue), (Object)testZkConfig_config.zkSslTrustStoreType());
        }
        finally {
            System.clearProperty((String)testZkConfig_sysPropName);
        }
        KafkaConfig testZkConfig_config = KafkaConfig$.MODULE$.fromProps(Kafka$.MODULE$.getPropsFromArgs((String[])((Object[])new String[]{testZkConfig_propertiesFile, "--override", new StringBuilder(1).append(testZkConfig_kafkaPropName).append("=").append(testZkConfig_propValueToSet).toString()})));
        Assertions.assertEquals((Object)testZkConfig_expectedPropertyValue, testZkConfig_config.values().get(testZkConfig_kafkaPropName));
        Assertions.assertEquals((Object)new Some((Object)testZkConfig_expectedPropertyValue), (Object)testZkConfig_config.zkSslTrustStoreType());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testZkSslProtocol() {
        void testZkConfig_expectedPropertyValue;
        void testZkConfig_propValueToSet;
        void testZkConfig_sysPropName;
        void testZkConfig_expectedDefaultValue;
        Some some = new Some((Object)"TLSv1.2");
        String string = this.stringPropValueToSet();
        String string2 = this.stringPropValueToSet();
        String string3 = "zookeeper.ssl.protocol";
        String testZkConfig_expectedKafkaPropName = "zookeeper.ssl.protocol";
        String testZkConfig_kafkaPropName = "zookeeper.ssl.protocol";
        Assertions.assertEquals((Object)testZkConfig_expectedKafkaPropName, (Object)testZkConfig_kafkaPropName);
        String testZkConfig_propertiesFile = this.prepareDefaultConfig();
        KafkaConfig testZkConfig_emptyConfig = KafkaConfig$.MODULE$.fromProps(Kafka$.MODULE$.getPropsFromArgs((String[])((Object[])new String[]{testZkConfig_propertiesFile})));
        Assertions.assertNull(testZkConfig_emptyConfig.originals().get(testZkConfig_kafkaPropName));
        if (testZkConfig_expectedDefaultValue.isDefined()) {
            Assertions.assertEquals((Object)testZkConfig_expectedDefaultValue.get(), testZkConfig_emptyConfig.values().get(testZkConfig_kafkaPropName));
            Assertions.assertEquals((Object)testZkConfig_expectedDefaultValue.get(), (Object)KafkaConfigTest.$anonfun$testZkSslProtocol$1(testZkConfig_emptyConfig).get());
        } else {
            Assertions.assertNull(testZkConfig_emptyConfig.values().get(testZkConfig_kafkaPropName));
            Assertions.assertEquals((Object)None$.MODULE$, (Object)KafkaConfigTest.$anonfun$testZkSslProtocol$1(testZkConfig_emptyConfig));
        }
        try {
            System.setProperty((String)testZkConfig_sysPropName, String.valueOf(testZkConfig_propValueToSet));
            KafkaConfig testZkConfig_config = KafkaConfig$.MODULE$.fromProps(Kafka$.MODULE$.getPropsFromArgs((String[])((Object[])new String[]{testZkConfig_propertiesFile})));
            Assertions.assertNull(testZkConfig_config.originals().get(testZkConfig_kafkaPropName));
            if (testZkConfig_expectedDefaultValue.isDefined()) {
                Assertions.assertEquals((Object)testZkConfig_expectedDefaultValue.get(), testZkConfig_config.values().get(testZkConfig_kafkaPropName));
            } else {
                Assertions.assertNull(testZkConfig_config.values().get(testZkConfig_kafkaPropName));
            }
            Assertions.assertEquals((Object)new Some((Object)testZkConfig_expectedPropertyValue), (Object)KafkaConfigTest.$anonfun$testZkSslProtocol$1(testZkConfig_config));
        }
        finally {
            System.clearProperty((String)testZkConfig_sysPropName);
        }
        KafkaConfig testZkConfig_config = KafkaConfig$.MODULE$.fromProps(Kafka$.MODULE$.getPropsFromArgs((String[])((Object[])new String[]{testZkConfig_propertiesFile, "--override", new StringBuilder(1).append(testZkConfig_kafkaPropName).append("=").append(testZkConfig_propValueToSet).toString()})));
        Assertions.assertEquals((Object)testZkConfig_expectedPropertyValue, testZkConfig_config.values().get(testZkConfig_kafkaPropName));
        Assertions.assertEquals((Object)new Some((Object)testZkConfig_expectedPropertyValue), (Object)KafkaConfigTest.$anonfun$testZkSslProtocol$1(testZkConfig_config));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testZkSslEnabledProtocols() {
        void testZkConfig_expectedPropertyValue;
        void testZkConfig_propValueToSet;
        void testZkConfig_sysPropName;
        void testZkConfig_expectedDefaultValue;
        None$ none$ = this.testZkConfig$default$7();
        Object object = CollectionConverters$.MODULE$.seqAsJavaListConverter(this.listPropValueToSet()).asJava();
        String string = this.listPropValueToSet().mkString(",");
        String string2 = "zookeeper.ssl.enabledProtocols";
        String testZkConfig_expectedKafkaPropName = "zookeeper.ssl.enabled.protocols";
        String testZkConfig_kafkaPropName = "zookeeper.ssl.enabled.protocols";
        Assertions.assertEquals((Object)testZkConfig_expectedKafkaPropName, (Object)testZkConfig_kafkaPropName);
        String testZkConfig_propertiesFile = this.prepareDefaultConfig();
        KafkaConfig testZkConfig_emptyConfig = KafkaConfig$.MODULE$.fromProps(Kafka$.MODULE$.getPropsFromArgs((String[])((Object[])new String[]{testZkConfig_propertiesFile})));
        Assertions.assertNull(testZkConfig_emptyConfig.originals().get(testZkConfig_kafkaPropName));
        if (testZkConfig_expectedDefaultValue.isDefined()) {
            Assertions.assertEquals((Object)testZkConfig_expectedDefaultValue.get(), testZkConfig_emptyConfig.values().get(testZkConfig_kafkaPropName));
            Assertions.assertEquals((Object)testZkConfig_expectedDefaultValue.get(), (Object)testZkConfig_emptyConfig.ZkSslEnabledProtocols().get());
        } else {
            Assertions.assertNull(testZkConfig_emptyConfig.values().get(testZkConfig_kafkaPropName));
            Assertions.assertEquals((Object)None$.MODULE$, (Object)testZkConfig_emptyConfig.ZkSslEnabledProtocols());
        }
        try {
            System.setProperty((String)testZkConfig_sysPropName, String.valueOf(testZkConfig_propValueToSet));
            KafkaConfig testZkConfig_config = KafkaConfig$.MODULE$.fromProps(Kafka$.MODULE$.getPropsFromArgs((String[])((Object[])new String[]{testZkConfig_propertiesFile})));
            Assertions.assertNull(testZkConfig_config.originals().get(testZkConfig_kafkaPropName));
            if (testZkConfig_expectedDefaultValue.isDefined()) {
                Assertions.assertEquals((Object)testZkConfig_expectedDefaultValue.get(), testZkConfig_config.values().get(testZkConfig_kafkaPropName));
            } else {
                Assertions.assertNull(testZkConfig_config.values().get(testZkConfig_kafkaPropName));
            }
            Assertions.assertEquals((Object)new Some((Object)testZkConfig_expectedPropertyValue), (Object)testZkConfig_config.ZkSslEnabledProtocols());
        }
        finally {
            System.clearProperty((String)testZkConfig_sysPropName);
        }
        KafkaConfig testZkConfig_config = KafkaConfig$.MODULE$.fromProps(Kafka$.MODULE$.getPropsFromArgs((String[])((Object[])new String[]{testZkConfig_propertiesFile, "--override", new StringBuilder(1).append(testZkConfig_kafkaPropName).append("=").append(testZkConfig_propValueToSet).toString()})));
        Assertions.assertEquals((Object)testZkConfig_expectedPropertyValue, testZkConfig_config.values().get(testZkConfig_kafkaPropName));
        Assertions.assertEquals((Object)new Some((Object)testZkConfig_expectedPropertyValue), (Object)testZkConfig_config.ZkSslEnabledProtocols());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testZkSslCipherSuites() {
        void testZkConfig_expectedPropertyValue;
        void testZkConfig_propValueToSet;
        void testZkConfig_sysPropName;
        void testZkConfig_expectedDefaultValue;
        None$ none$ = this.testZkConfig$default$7();
        Object object = CollectionConverters$.MODULE$.seqAsJavaListConverter(this.listPropValueToSet()).asJava();
        String string = this.listPropValueToSet().mkString(",");
        String string2 = "zookeeper.ssl.ciphersuites";
        String testZkConfig_expectedKafkaPropName = "zookeeper.ssl.cipher.suites";
        String testZkConfig_kafkaPropName = "zookeeper.ssl.cipher.suites";
        Assertions.assertEquals((Object)testZkConfig_expectedKafkaPropName, (Object)testZkConfig_kafkaPropName);
        String testZkConfig_propertiesFile = this.prepareDefaultConfig();
        KafkaConfig testZkConfig_emptyConfig = KafkaConfig$.MODULE$.fromProps(Kafka$.MODULE$.getPropsFromArgs((String[])((Object[])new String[]{testZkConfig_propertiesFile})));
        Assertions.assertNull(testZkConfig_emptyConfig.originals().get(testZkConfig_kafkaPropName));
        if (testZkConfig_expectedDefaultValue.isDefined()) {
            Assertions.assertEquals((Object)testZkConfig_expectedDefaultValue.get(), testZkConfig_emptyConfig.values().get(testZkConfig_kafkaPropName));
            Assertions.assertEquals((Object)testZkConfig_expectedDefaultValue.get(), (Object)testZkConfig_emptyConfig.ZkSslCipherSuites().get());
        } else {
            Assertions.assertNull(testZkConfig_emptyConfig.values().get(testZkConfig_kafkaPropName));
            Assertions.assertEquals((Object)None$.MODULE$, (Object)testZkConfig_emptyConfig.ZkSslCipherSuites());
        }
        try {
            System.setProperty((String)testZkConfig_sysPropName, String.valueOf(testZkConfig_propValueToSet));
            KafkaConfig testZkConfig_config = KafkaConfig$.MODULE$.fromProps(Kafka$.MODULE$.getPropsFromArgs((String[])((Object[])new String[]{testZkConfig_propertiesFile})));
            Assertions.assertNull(testZkConfig_config.originals().get(testZkConfig_kafkaPropName));
            if (testZkConfig_expectedDefaultValue.isDefined()) {
                Assertions.assertEquals((Object)testZkConfig_expectedDefaultValue.get(), testZkConfig_config.values().get(testZkConfig_kafkaPropName));
            } else {
                Assertions.assertNull(testZkConfig_config.values().get(testZkConfig_kafkaPropName));
            }
            Assertions.assertEquals((Object)new Some((Object)testZkConfig_expectedPropertyValue), (Object)testZkConfig_config.ZkSslCipherSuites());
        }
        finally {
            System.clearProperty((String)testZkConfig_sysPropName);
        }
        KafkaConfig testZkConfig_config = KafkaConfig$.MODULE$.fromProps(Kafka$.MODULE$.getPropsFromArgs((String[])((Object[])new String[]{testZkConfig_propertiesFile, "--override", new StringBuilder(1).append(testZkConfig_kafkaPropName).append("=").append(testZkConfig_propValueToSet).toString()})));
        Assertions.assertEquals((Object)testZkConfig_expectedPropertyValue, testZkConfig_config.values().get(testZkConfig_kafkaPropName));
        Assertions.assertEquals((Object)new Some((Object)testZkConfig_expectedPropertyValue), (Object)testZkConfig_config.ZkSslCipherSuites());
    }

    @Test
    public void testZkSslEndpointIdentificationAlgorithm() {
        String kafkaPropName = "zookeeper.ssl.endpoint.identification.algorithm";
        Assertions.assertEquals((Object)"zookeeper.ssl.endpoint.identification.algorithm", (Object)kafkaPropName);
        String sysProp = "zookeeper.ssl.hostnameVerification";
        String expectedDefaultValue = "HTTPS";
        String propertiesFile = this.prepareDefaultConfig();
        KafkaConfig emptyConfig = KafkaConfig$.MODULE$.fromProps(Kafka$.MODULE$.getPropsFromArgs((String[])((Object[])new String[]{propertiesFile})));
        Assertions.assertNull(emptyConfig.originals().get(kafkaPropName));
        Assertions.assertEquals((Object)expectedDefaultValue, emptyConfig.values().get(kafkaPropName));
        Assertions.assertEquals((Object)expectedDefaultValue, (Object)emptyConfig.ZkSslEndpointIdentificationAlgorithm());
        ((IterableLike)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"true"), (Object)"HTTPS"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"false"), (Object)"")}))).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            KafkaConfigTest.$anonfun$testZkSslEndpointIdentificationAlgorithm$1(sysProp, propertiesFile, kafkaPropName, expectedDefaultValue, x0$1);
            return BoxedUnit.UNIT;
        });
        new .colon.colon((Object)"https", (List)new .colon.colon((Object)"", (List)Nil$.MODULE$)).foreach((Function1 & Serializable & scala.Serializable)expected -> {
            KafkaConfigTest.$anonfun$testZkSslEndpointIdentificationAlgorithm$2(propertiesFile, kafkaPropName, expected);
            return BoxedUnit.UNIT;
        });
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testZkSslCrlEnable() {
        void testZkConfig_expectedPropertyValue;
        void testZkConfig_propValueToSet;
        void testZkConfig_sysPropName;
        void testZkConfig_expectedDefaultValue;
        Some some = new Some((Object)BoxesRunTime.boxToBoolean((boolean)false));
        Boolean bl = BoxesRunTime.boxToBoolean((boolean)this.booleanPropValueToSet());
        Boolean bl2 = BoxesRunTime.boxToBoolean((boolean)this.booleanPropValueToSet());
        String string = "zookeeper.ssl.crl";
        String testZkConfig_expectedKafkaPropName = "zookeeper.ssl.crl.enable";
        String testZkConfig_kafkaPropName = "zookeeper.ssl.crl.enable";
        Assertions.assertEquals((Object)testZkConfig_expectedKafkaPropName, (Object)testZkConfig_kafkaPropName);
        String testZkConfig_propertiesFile = this.prepareDefaultConfig();
        KafkaConfig testZkConfig_emptyConfig = KafkaConfig$.MODULE$.fromProps(Kafka$.MODULE$.getPropsFromArgs((String[])((Object[])new String[]{testZkConfig_propertiesFile})));
        Assertions.assertNull(testZkConfig_emptyConfig.originals().get(testZkConfig_kafkaPropName));
        if (testZkConfig_expectedDefaultValue.isDefined()) {
            Assertions.assertEquals((Object)testZkConfig_expectedDefaultValue.get(), testZkConfig_emptyConfig.values().get(testZkConfig_kafkaPropName));
            Assertions.assertEquals((Object)testZkConfig_expectedDefaultValue.get(), (Object)KafkaConfigTest.$anonfun$testZkSslCrlEnable$1(testZkConfig_emptyConfig).get());
        } else {
            Assertions.assertNull(testZkConfig_emptyConfig.values().get(testZkConfig_kafkaPropName));
            Assertions.assertEquals((Object)None$.MODULE$, (Object)KafkaConfigTest.$anonfun$testZkSslCrlEnable$1(testZkConfig_emptyConfig));
        }
        try {
            System.setProperty((String)testZkConfig_sysPropName, String.valueOf(testZkConfig_propValueToSet));
            KafkaConfig testZkConfig_config = KafkaConfig$.MODULE$.fromProps(Kafka$.MODULE$.getPropsFromArgs((String[])((Object[])new String[]{testZkConfig_propertiesFile})));
            Assertions.assertNull(testZkConfig_config.originals().get(testZkConfig_kafkaPropName));
            if (testZkConfig_expectedDefaultValue.isDefined()) {
                Assertions.assertEquals((Object)testZkConfig_expectedDefaultValue.get(), testZkConfig_config.values().get(testZkConfig_kafkaPropName));
            } else {
                Assertions.assertNull(testZkConfig_config.values().get(testZkConfig_kafkaPropName));
            }
            Assertions.assertEquals((Object)new Some((Object)testZkConfig_expectedPropertyValue), (Object)KafkaConfigTest.$anonfun$testZkSslCrlEnable$1(testZkConfig_config));
        }
        finally {
            System.clearProperty((String)testZkConfig_sysPropName);
        }
        KafkaConfig testZkConfig_config = KafkaConfig$.MODULE$.fromProps(Kafka$.MODULE$.getPropsFromArgs((String[])((Object[])new String[]{testZkConfig_propertiesFile, "--override", new StringBuilder(1).append(testZkConfig_kafkaPropName).append("=").append(testZkConfig_propValueToSet).toString()})));
        Assertions.assertEquals((Object)testZkConfig_expectedPropertyValue, testZkConfig_config.values().get(testZkConfig_kafkaPropName));
        Assertions.assertEquals((Object)new Some((Object)testZkConfig_expectedPropertyValue), (Object)KafkaConfigTest.$anonfun$testZkSslCrlEnable$1(testZkConfig_config));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testZkSslOcspEnable() {
        void testZkConfig_expectedPropertyValue;
        void testZkConfig_propValueToSet;
        void testZkConfig_sysPropName;
        void testZkConfig_expectedDefaultValue;
        Some some = new Some((Object)BoxesRunTime.boxToBoolean((boolean)false));
        Boolean bl = BoxesRunTime.boxToBoolean((boolean)this.booleanPropValueToSet());
        Boolean bl2 = BoxesRunTime.boxToBoolean((boolean)this.booleanPropValueToSet());
        String string = "zookeeper.ssl.ocsp";
        String testZkConfig_expectedKafkaPropName = "zookeeper.ssl.ocsp.enable";
        String testZkConfig_kafkaPropName = "zookeeper.ssl.ocsp.enable";
        Assertions.assertEquals((Object)testZkConfig_expectedKafkaPropName, (Object)testZkConfig_kafkaPropName);
        String testZkConfig_propertiesFile = this.prepareDefaultConfig();
        KafkaConfig testZkConfig_emptyConfig = KafkaConfig$.MODULE$.fromProps(Kafka$.MODULE$.getPropsFromArgs((String[])((Object[])new String[]{testZkConfig_propertiesFile})));
        Assertions.assertNull(testZkConfig_emptyConfig.originals().get(testZkConfig_kafkaPropName));
        if (testZkConfig_expectedDefaultValue.isDefined()) {
            Assertions.assertEquals((Object)testZkConfig_expectedDefaultValue.get(), testZkConfig_emptyConfig.values().get(testZkConfig_kafkaPropName));
            Assertions.assertEquals((Object)testZkConfig_expectedDefaultValue.get(), (Object)KafkaConfigTest.$anonfun$testZkSslOcspEnable$1(testZkConfig_emptyConfig).get());
        } else {
            Assertions.assertNull(testZkConfig_emptyConfig.values().get(testZkConfig_kafkaPropName));
            Assertions.assertEquals((Object)None$.MODULE$, (Object)KafkaConfigTest.$anonfun$testZkSslOcspEnable$1(testZkConfig_emptyConfig));
        }
        try {
            System.setProperty((String)testZkConfig_sysPropName, String.valueOf(testZkConfig_propValueToSet));
            KafkaConfig testZkConfig_config = KafkaConfig$.MODULE$.fromProps(Kafka$.MODULE$.getPropsFromArgs((String[])((Object[])new String[]{testZkConfig_propertiesFile})));
            Assertions.assertNull(testZkConfig_config.originals().get(testZkConfig_kafkaPropName));
            if (testZkConfig_expectedDefaultValue.isDefined()) {
                Assertions.assertEquals((Object)testZkConfig_expectedDefaultValue.get(), testZkConfig_config.values().get(testZkConfig_kafkaPropName));
            } else {
                Assertions.assertNull(testZkConfig_config.values().get(testZkConfig_kafkaPropName));
            }
            Assertions.assertEquals((Object)new Some((Object)testZkConfig_expectedPropertyValue), (Object)KafkaConfigTest.$anonfun$testZkSslOcspEnable$1(testZkConfig_config));
        }
        finally {
            System.clearProperty((String)testZkConfig_sysPropName);
        }
        KafkaConfig testZkConfig_config = KafkaConfig$.MODULE$.fromProps(Kafka$.MODULE$.getPropsFromArgs((String[])((Object[])new String[]{testZkConfig_propertiesFile, "--override", new StringBuilder(1).append(testZkConfig_kafkaPropName).append("=").append(testZkConfig_propValueToSet).toString()})));
        Assertions.assertEquals((Object)testZkConfig_expectedPropertyValue, testZkConfig_config.values().get(testZkConfig_kafkaPropName));
        Assertions.assertEquals((Object)new Some((Object)testZkConfig_expectedPropertyValue), (Object)KafkaConfigTest.$anonfun$testZkSslOcspEnable$1(testZkConfig_config));
    }

    @Test
    public void testConnectionsMaxReauthMsDefault() {
        String propertiesFile = this.prepareDefaultConfig();
        KafkaConfig config = KafkaConfig$.MODULE$.fromProps(Kafka$.MODULE$.getPropsFromArgs((String[])((Object[])new String[]{propertiesFile})));
        Assertions.assertEquals((long)0L, (long)BoxesRunTime.unboxToLong(config.valuesWithPrefixOverride("sasl_ssl.oauthbearer.").get("connections.max.reauth.ms")));
    }

    @Test
    public void testConnectionsMaxReauthMsExplicit() {
        String propertiesFile = this.prepareDefaultConfig();
        int expected = 3600000;
        KafkaConfig config = KafkaConfig$.MODULE$.fromProps(Kafka$.MODULE$.getPropsFromArgs((String[])((Object[])new String[]{propertiesFile, "--override", new StringBuilder(47).append("sasl_ssl.oauthbearer.connections.max.reauth.ms=").append(expected).toString()})));
        Assertions.assertEquals((long)expected, (long)BoxesRunTime.unboxToLong(config.valuesWithPrefixOverride("sasl_ssl.oauthbearer.").get("connections.max.reauth.ms")));
    }

    private <T, U> void testZkConfig(String kafkaPropName, String expectedKafkaPropName, String sysPropName, T propValueToSet, Function1<KafkaConfig, Option<T>> getPropValueFrom, U expectedPropertyValue, Option<T> expectedDefaultValue) {
        Assertions.assertEquals((Object)expectedKafkaPropName, (Object)kafkaPropName);
        String propertiesFile = this.prepareDefaultConfig();
        KafkaConfig emptyConfig = KafkaConfig$.MODULE$.fromProps(Kafka$.MODULE$.getPropsFromArgs((String[])((Object[])new String[]{propertiesFile})));
        Assertions.assertNull(emptyConfig.originals().get(kafkaPropName));
        if (expectedDefaultValue.isDefined()) {
            Assertions.assertEquals((Object)expectedDefaultValue.get(), emptyConfig.values().get(kafkaPropName));
            Assertions.assertEquals((Object)expectedDefaultValue.get(), (Object)((Option)getPropValueFrom.apply((Object)emptyConfig)).get());
        } else {
            Assertions.assertNull(emptyConfig.values().get(kafkaPropName));
            Assertions.assertEquals((Object)None$.MODULE$, (Object)getPropValueFrom.apply((Object)emptyConfig));
        }
        try {
            System.setProperty(sysPropName, String.valueOf(propValueToSet));
            KafkaConfig config = KafkaConfig$.MODULE$.fromProps(Kafka$.MODULE$.getPropsFromArgs((String[])((Object[])new String[]{propertiesFile})));
            Assertions.assertNull(config.originals().get(kafkaPropName));
            if (expectedDefaultValue.isDefined()) {
                Assertions.assertEquals((Object)expectedDefaultValue.get(), config.values().get(kafkaPropName));
            } else {
                Assertions.assertNull(config.values().get(kafkaPropName));
            }
            Assertions.assertEquals((Object)new Some(expectedPropertyValue), (Object)getPropValueFrom.apply((Object)config));
        }
        finally {
            System.clearProperty(sysPropName);
        }
        KafkaConfig config = KafkaConfig$.MODULE$.fromProps(Kafka$.MODULE$.getPropsFromArgs((String[])((Object[])new String[]{propertiesFile, "--override", new StringBuilder(1).append(kafkaPropName).append("=").append(propValueToSet).toString()})));
        Assertions.assertEquals(expectedPropertyValue, config.values().get(kafkaPropName));
        Assertions.assertEquals((Object)new Some(expectedPropertyValue), (Object)getPropValueFrom.apply((Object)config));
    }

    private <T, U> None$ testZkConfig$default$7() {
        return None$.MODULE$;
    }

    public String prepareDefaultConfig() {
        return this.prepareConfig((String[])((Object[])new String[]{"broker.id=1", "zookeeper.connect=somewhere"}));
    }

    public String prepareConfig(String[] lines) {
        String string;
        File file = TestUtils$.MODULE$.tempFile("kafkatest", ".properties");
        try (OutputStream writer = Files.newOutputStream(file.toPath(), new OpenOption[0]);){
            new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])lines)).foreach((Function1 & Serializable & scala.Serializable)l -> {
                KafkaConfigTest.$anonfun$prepareConfig$1(writer, l);
                return BoxedUnit.UNIT;
            });
            string = file.getAbsolutePath();
        }
        return string;
    }

    @ParameterizedTest
    @ValueSource(booleans={false, true})
    public void testIncludeControlPlaneListenerNameInAdvertisedBrokerListeners(boolean migration) {
        Properties properties = new Properties();
        if (migration) {
            properties.setProperty("zookeeper.metadata.migration.enable", "true");
        } else {
            properties.setProperty("process.roles", "broker");
        }
        properties.setProperty("node.id", "1");
        properties.setProperty("controller.quorum.voters", "1@localhost:9092");
        properties.setProperty("listeners", "CONTROLLER://:9093,INTERNAL://:9092");
        properties.setProperty("controller.listener.names", "CONTROLLER");
        properties.setProperty("control.plane.listener.name", "CONTROLLER");
        properties.setProperty("advertised.listeners", "CONTROLLER://localhost:9093,INTERNAL://localhost:9092");
        properties.setProperty("listener.security.protocol.map", "CONTROLLER:SSL,INTERNAL:PLAINTEXT");
        properties.setProperty("inter.broker.listener.name", "INTERNAL");
        properties.setProperty("zookeeper.connect", "localhost:2181");
        if (migration) {
            KafkaConfig config = KafkaConfig$.MODULE$.fromProps(properties);
            Assertions.assertEquals((Object)new .colon.colon((Object)"CONTROLLER", (List)new .colon.colon((Object)"INTERNAL", (List)Nil$.MODULE$)), (Object)config.effectiveAdvertisedBrokerListeners().map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.listenerName().value(), Seq$.MODULE$.canBuildFrom()));
            Assertions.assertEquals((Object)new .colon.colon((Object)"CONTROLLER", (List)Nil$.MODULE$), (Object)config.effectiveAdvertisedControllerListeners().map((Function1 & Serializable & scala.Serializable)x$3 -> x$3.listenerName().value(), Seq$.MODULE$.canBuildFrom()));
            return;
        }
        Assertions.assertEquals((Object)"requirement failed: control.plane.listener.name is not supported in KRaft mode.", (Object)Assertions.assertThrows(IllegalArgumentException.class, () -> KafkaConfig$.MODULE$.fromProps(properties)).getMessage());
    }

    public static final /* synthetic */ Nothing$ $anonfun$setUp$1(int status, Option x$1) {
        throw new FatalExitError(status);
    }

    public static final /* synthetic */ Some $anonfun$testZkSslClientEnable$1(KafkaConfig config) {
        return new Some((Object)BoxesRunTime.boxToBoolean((boolean)config.zkSslClientEnable()));
    }

    public static final /* synthetic */ Some $anonfun$testZkSslProtocol$1(KafkaConfig config) {
        return new Some((Object)config.ZkSslProtocol());
    }

    public static final /* synthetic */ void $anonfun$testZkSslEndpointIdentificationAlgorithm$1(String sysProp$1, String propertiesFile$4, String kafkaPropName$1, String expectedDefaultValue$1, Tuple2 x0$1) {
        if (x0$1 != null) {
            String sysPropValue = (String)x0$1._1();
            String expected = (String)x0$1._2();
            try {
                System.setProperty(sysProp$1, sysPropValue);
                KafkaConfig config = KafkaConfig$.MODULE$.fromProps(Kafka$.MODULE$.getPropsFromArgs((String[])((Object[])new String[]{propertiesFile$4})));
                Assertions.assertNull(config.originals().get(kafkaPropName$1));
                Assertions.assertEquals((Object)expectedDefaultValue$1, config.values().get(kafkaPropName$1));
                Assertions.assertEquals((Object)expected, (Object)config.ZkSslEndpointIdentificationAlgorithm());
            }
            finally {
                System.clearProperty(sysProp$1);
            }
            return;
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ void $anonfun$testZkSslEndpointIdentificationAlgorithm$2(String propertiesFile$4, String kafkaPropName$1, String expected) {
        KafkaConfig config = KafkaConfig$.MODULE$.fromProps(Kafka$.MODULE$.getPropsFromArgs((String[])((Object[])new String[]{propertiesFile$4, "--override", new StringBuilder(1).append(kafkaPropName$1).append("=").append(expected).toString()})));
        Assertions.assertEquals((Object)expected, config.originals().get(kafkaPropName$1));
        Assertions.assertEquals((Object)expected, config.values().get(kafkaPropName$1));
        Assertions.assertEquals((Object)expected, (Object)config.ZkSslEndpointIdentificationAlgorithm());
    }

    public static final /* synthetic */ Some $anonfun$testZkSslCrlEnable$1(KafkaConfig config) {
        return new Some((Object)BoxesRunTime.boxToBoolean((boolean)config.ZkSslCrlEnable()));
    }

    public static final /* synthetic */ Some $anonfun$testZkSslOcspEnable$1(KafkaConfig config) {
        return new Some((Object)BoxesRunTime.boxToBoolean((boolean)config.ZkSslOcspEnable()));
    }

    public static final /* synthetic */ void $anonfun$prepareConfig$1(OutputStream writer$1, String l) {
        writer$1.write(l.getBytes());
        writer$1.write("\n".getBytes());
    }

    public KafkaConfigTest() {
        this.booleanPropValueToSet = true;
        this.stringPropValueToSet = "foo";
        this.passwordPropValueToSet = "ThePa$$word!";
    }
}

