/*
 * Decompiled with CFR 0.152.
 */
package kafka.admin;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.PrintStream;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.management.InstanceAlreadyExistsException;
import kafka.admin.AclCommand;
import kafka.security.authorizer.AclAuthorizer;
import kafka.test.ClusterInstance;
import kafka.test.annotation.ClusterConfigProperty;
import kafka.test.annotation.ClusterTest;
import kafka.test.annotation.ClusterTestDefaults;
import kafka.test.annotation.ClusterTests;
import kafka.test.annotation.Type;
import kafka.test.junit.ClusterTestExtensions;
import kafka.test.junit.ZkClusterInvocationContext;
import kafka.utils.Exit;
import kafka.utils.TestUtils;
import org.apache.kafka.common.acl.AccessControlEntry;
import org.apache.kafka.common.acl.AccessControlEntryFilter;
import org.apache.kafka.common.acl.AclOperation;
import org.apache.kafka.common.acl.AclPermissionType;
import org.apache.kafka.common.resource.PatternType;
import org.apache.kafka.common.resource.ResourcePattern;
import org.apache.kafka.common.resource.ResourceType;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.apache.kafka.common.utils.AppInfoParser;
import org.apache.kafka.common.utils.LogCaptureAppender;
import org.apache.kafka.common.utils.SecurityUtils;
import org.apache.kafka.server.authorizer.Authorizer;
import org.apache.log4j.Level;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import scala.Console;
import scala.collection.JavaConverters;

@ClusterTestDefaults(serverProperties={@ClusterConfigProperty(key="super.users", value="User:ANONYMOUS"), @ClusterConfigProperty(key="authorizer.class.name", value="kafka.security.authorizer.AclAuthorizer")})
@ExtendWith(value={ClusterTestExtensions.class})
public class AclCommandTest {
    public static final String ACL_AUTHORIZER = "kafka.security.authorizer.AclAuthorizer";
    private static final String STANDARD_AUTHORIZER = "org.apache.kafka.metadata.authorizer.StandardAuthorizer";
    private static final String LOCALHOST = "localhost:9092";
    private static final String AUTHORIZER = "--authorizer";
    private static final String AUTHORIZER_PROPERTIES = "--authorizer-properties";
    private static final String ADD = "--add";
    private static final String BOOTSTRAP_SERVER = "--bootstrap-server";
    private static final String COMMAND_CONFIG = "--command-config";
    private static final String CONSUMER = "--consumer";
    private static final String IDEMPOTENT = "--idempotent";
    private static final String GROUP = "--group";
    private static final String LIST = "--list";
    private static final String REMOVE = "--remove";
    private static final String PRODUCER = "--producer";
    private static final String OPERATION = "--operation";
    private static final String TOPIC = "--topic";
    private static final String RESOURCE_PATTERN_TYPE = "--resource-pattern-type";
    private static final String ZOOKEEPER_CONNECT = "zookeeper.connect=localhost:2181";
    private static final KafkaPrincipal PRINCIPAL = SecurityUtils.parseKafkaPrincipal((String)"User:test2");
    private static final Set<KafkaPrincipal> USERS = new HashSet<KafkaPrincipal>(Arrays.asList(SecurityUtils.parseKafkaPrincipal((String)"User:CN=writeuser,OU=Unknown,O=Unknown,L=Unknown,ST=Unknown,C=Unknown"), PRINCIPAL, SecurityUtils.parseKafkaPrincipal((String)"User:CN=\\#User with special chars in CN : (\\, \\+ \" \\ \\< \\> \\; ')")));
    private static final Set<String> HOSTS = new HashSet<String>(Arrays.asList("host1", "host2"));
    private static final List<String> ALLOW_HOST_COMMAND = Arrays.asList("--allow-host", "host1", "--allow-host", "host2");
    private static final List<String> DENY_HOST_COMMAND = Arrays.asList("--deny-host", "host1", "--deny-host", "host2");
    private static final ResourcePattern CLUSTER_RESOURCE = new ResourcePattern(ResourceType.CLUSTER, "kafka-cluster", PatternType.LITERAL);
    private static final Set<ResourcePattern> TOPIC_RESOURCES = new HashSet<ResourcePattern>(Arrays.asList(new ResourcePattern(ResourceType.TOPIC, "test-1", PatternType.LITERAL), new ResourcePattern(ResourceType.TOPIC, "test-2", PatternType.LITERAL)));
    private static final Set<ResourcePattern> GROUP_RESOURCES = new HashSet<ResourcePattern>(Arrays.asList(new ResourcePattern(ResourceType.GROUP, "testGroup-1", PatternType.LITERAL), new ResourcePattern(ResourceType.GROUP, "testGroup-2", PatternType.LITERAL)));
    private static final Set<ResourcePattern> TRANSACTIONAL_ID_RESOURCES = new HashSet<ResourcePattern>(Arrays.asList(new ResourcePattern(ResourceType.TRANSACTIONAL_ID, "t0", PatternType.LITERAL), new ResourcePattern(ResourceType.TRANSACTIONAL_ID, "t1", PatternType.LITERAL)));
    private static final Set<ResourcePattern> TOKEN_RESOURCES = new HashSet<ResourcePattern>(Arrays.asList(new ResourcePattern(ResourceType.DELEGATION_TOKEN, "token1", PatternType.LITERAL), new ResourcePattern(ResourceType.DELEGATION_TOKEN, "token2", PatternType.LITERAL)));
    private static final Set<ResourcePattern> USER_RESOURCES = new HashSet<ResourcePattern>(Arrays.asList(new ResourcePattern(ResourceType.USER, "User:test-user1", PatternType.LITERAL), new ResourcePattern(ResourceType.USER, "User:test-user2", PatternType.LITERAL)));
    private static final Map<Set<ResourcePattern>, List<String>> RESOURCE_TO_COMMAND = new HashMap<Set<ResourcePattern>, List<String>>(){
        {
            this.put(TOPIC_RESOURCES, Arrays.asList(AclCommandTest.TOPIC, "test-1", AclCommandTest.TOPIC, "test-2"));
            this.put(Collections.singleton(CLUSTER_RESOURCE), Collections.singletonList("--cluster"));
            this.put(GROUP_RESOURCES, Arrays.asList(AclCommandTest.GROUP, "testGroup-1", AclCommandTest.GROUP, "testGroup-2"));
            this.put(TRANSACTIONAL_ID_RESOURCES, Arrays.asList("--transactional-id", "t0", "--transactional-id", "t1"));
            this.put(TOKEN_RESOURCES, Arrays.asList("--delegation-token", "token1", "--delegation-token", "token2"));
            this.put(USER_RESOURCES, Arrays.asList("--user-principal", "User:test-user1", "--user-principal", "User:test-user2"));
        }
    };
    private static final Map<Set<ResourcePattern>, Map.Entry<Set<AclOperation>, List<String>>> RESOURCE_TO_OPERATIONS = new HashMap<Set<ResourcePattern>, Map.Entry<Set<AclOperation>, List<String>>>(){
        {
            this.put(TOPIC_RESOURCES, new AbstractMap.SimpleImmutableEntry<HashSet<AclOperation>, List<String>>(new HashSet<AclOperation>(Arrays.asList(AclOperation.READ, AclOperation.WRITE, AclOperation.CREATE, AclOperation.DESCRIBE, AclOperation.DELETE, AclOperation.DESCRIBE_CONFIGS, AclOperation.ALTER_CONFIGS, AclOperation.ALTER)), Arrays.asList(AclCommandTest.OPERATION, "Read", AclCommandTest.OPERATION, "Write", AclCommandTest.OPERATION, "Create", AclCommandTest.OPERATION, "Describe", AclCommandTest.OPERATION, "Delete", AclCommandTest.OPERATION, "DescribeConfigs", AclCommandTest.OPERATION, "AlterConfigs", AclCommandTest.OPERATION, "Alter")));
            this.put(Collections.singleton(CLUSTER_RESOURCE), new AbstractMap.SimpleImmutableEntry<HashSet<AclOperation>, List<String>>(new HashSet<AclOperation>(Arrays.asList(AclOperation.CREATE, AclOperation.CLUSTER_ACTION, AclOperation.DESCRIBE_CONFIGS, AclOperation.ALTER_CONFIGS, AclOperation.IDEMPOTENT_WRITE, AclOperation.ALTER, AclOperation.DESCRIBE)), Arrays.asList(AclCommandTest.OPERATION, "Create", AclCommandTest.OPERATION, "ClusterAction", AclCommandTest.OPERATION, "DescribeConfigs", AclCommandTest.OPERATION, "AlterConfigs", AclCommandTest.OPERATION, "IdempotentWrite", AclCommandTest.OPERATION, "Alter", AclCommandTest.OPERATION, "Describe")));
            this.put(GROUP_RESOURCES, new AbstractMap.SimpleImmutableEntry<HashSet<AclOperation>, List<String>>(new HashSet<AclOperation>(Arrays.asList(AclOperation.READ, AclOperation.DESCRIBE, AclOperation.DELETE)), Arrays.asList(AclCommandTest.OPERATION, "Read", AclCommandTest.OPERATION, "Describe", AclCommandTest.OPERATION, "Delete")));
            this.put(TRANSACTIONAL_ID_RESOURCES, new AbstractMap.SimpleImmutableEntry<HashSet<AclOperation>, List<String>>(new HashSet<AclOperation>(Arrays.asList(AclOperation.DESCRIBE, AclOperation.WRITE)), Arrays.asList(AclCommandTest.OPERATION, "Describe", AclCommandTest.OPERATION, "Write")));
            this.put(TOKEN_RESOURCES, new AbstractMap.SimpleImmutableEntry<Set<AclOperation>, List<String>>(Collections.singleton(AclOperation.DESCRIBE), Arrays.asList(AclCommandTest.OPERATION, "Describe")));
            this.put(USER_RESOURCES, new AbstractMap.SimpleImmutableEntry<HashSet<AclOperation>, List<String>>(new HashSet<AclOperation>(Arrays.asList(AclOperation.CREATE_TOKENS, AclOperation.DESCRIBE_TOKENS)), Arrays.asList(AclCommandTest.OPERATION, "CreateTokens", AclCommandTest.OPERATION, "DescribeTokens")));
        }
    };
    private static final Map<Set<ResourcePattern>, Set<AccessControlEntry>> CONSUMER_RESOURCE_TO_ACLS = new HashMap<Set<ResourcePattern>, Set<AccessControlEntry>>(){
        {
            this.put(TOPIC_RESOURCES, AclCommandTest.asJavaSet(AclCommand.getAcls((scala.collection.immutable.Set)AclCommandTest.asScalaSet(USERS), (AclPermissionType)AclPermissionType.ALLOW, (scala.collection.immutable.Set)AclCommandTest.asScalaSet(new HashSet<AclOperation>(Arrays.asList(AclOperation.READ, AclOperation.DESCRIBE))), (scala.collection.immutable.Set)AclCommandTest.asScalaSet(HOSTS))));
            this.put(GROUP_RESOURCES, AclCommandTest.asJavaSet(AclCommand.getAcls((scala.collection.immutable.Set)AclCommandTest.asScalaSet(USERS), (AclPermissionType)AclPermissionType.ALLOW, (scala.collection.immutable.Set)AclCommandTest.asScalaSet(Collections.singleton(AclOperation.READ)), (scala.collection.immutable.Set)AclCommandTest.asScalaSet(HOSTS))));
        }
    };
    private static final Map<List<String>, Map<Set<ResourcePattern>, Set<AccessControlEntry>>> CMD_TO_RESOURCES_TO_ACL = new HashMap<List<String>, Map<Set<ResourcePattern>, Set<AccessControlEntry>>>(){
        {
            this.put(Collections.singletonList(AclCommandTest.PRODUCER), AclCommandTest.producerResourceToAcls(false));
            this.put(Arrays.asList(AclCommandTest.PRODUCER, AclCommandTest.IDEMPOTENT), AclCommandTest.producerResourceToAcls(true));
            this.put(Collections.singletonList(AclCommandTest.CONSUMER), CONSUMER_RESOURCE_TO_ACLS);
            this.put(Arrays.asList(AclCommandTest.PRODUCER, AclCommandTest.CONSUMER), CONSUMER_RESOURCE_TO_ACLS.entrySet().stream().map(entry -> {
                HashSet value = new HashSet((Collection)entry.getValue());
                value.addAll(AclCommandTest.producerResourceToAcls(false).getOrDefault(entry.getKey(), Collections.emptySet()));
                return new AbstractMap.SimpleEntry(entry.getKey(), value);
            }).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue)));
            this.put(Arrays.asList(AclCommandTest.PRODUCER, AclCommandTest.IDEMPOTENT, AclCommandTest.CONSUMER), CONSUMER_RESOURCE_TO_ACLS.entrySet().stream().map(entry -> {
                HashSet value = new HashSet((Collection)entry.getValue());
                value.addAll(AclCommandTest.producerResourceToAcls(true).getOrDefault(entry.getKey(), Collections.emptySet()));
                return new AbstractMap.SimpleEntry(entry.getKey(), value);
            }).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue)));
        }
    };

    @ClusterTest(types={Type.ZK})
    public void testAclCliWithAuthorizer(ClusterInstance cluster) {
        this.testAclCli(cluster, this.zkArgs(cluster));
    }

    @ClusterTests(value={@ClusterTest(types={Type.ZK}), @ClusterTest(types={Type.KRAFT}, serverProperties={@ClusterConfigProperty(key="authorizer.class.name", value="org.apache.kafka.metadata.authorizer.StandardAuthorizer")})})
    public void testAclCliWithAdminAPI(ClusterInstance cluster) {
        this.testAclCli(cluster, this.adminArgs(cluster.bootstrapServers(), Optional.empty()));
    }

    @ClusterTest(types={Type.ZK})
    public void testProducerConsumerCliWithAuthorizer(ClusterInstance cluster) {
        this.testProducerConsumerCli(cluster, this.zkArgs(cluster));
    }

    @ClusterTests(value={@ClusterTest(types={Type.ZK}), @ClusterTest(types={Type.KRAFT}, serverProperties={@ClusterConfigProperty(key="authorizer.class.name", value="org.apache.kafka.metadata.authorizer.StandardAuthorizer")})})
    public void testProducerConsumerCliWithAdminAPI(ClusterInstance cluster) {
        this.testProducerConsumerCli(cluster, this.adminArgs(cluster.bootstrapServers(), Optional.empty()));
    }

    @ClusterTests(value={@ClusterTest(types={Type.ZK}), @ClusterTest(types={Type.KRAFT}, serverProperties={@ClusterConfigProperty(key="authorizer.class.name", value="org.apache.kafka.metadata.authorizer.StandardAuthorizer")})})
    public void testAclCliWithClientId(ClusterInstance cluster) {
        appender.setClassLogger(AppInfoParser.class, Level.WARN);
        try (LogCaptureAppender appender = LogCaptureAppender.createAndRegister();){
            this.testAclCli(cluster, this.adminArgs(cluster.bootstrapServers(), Optional.of(TestUtils.tempFile("client.id=my-client"))));
        }
        Assertions.assertEquals((long)0L, (long)appender.getEvents().stream().filter(e -> e.getLevel().equals(Level.WARN.toString())).filter(e -> e.getThrowableClassName().filter(name -> name.equals(InstanceAlreadyExistsException.class.getName())).isPresent()).count(), (String)"There should be no warnings about multiple registration of mbeans");
    }

    @ClusterTest(types={Type.ZK})
    public void testAclsOnPrefixedResourcesWithAuthorizer(ClusterInstance cluster) {
        this.testAclsOnPrefixedResources(cluster, this.zkArgs(cluster));
    }

    @ClusterTests(value={@ClusterTest(types={Type.ZK}), @ClusterTest(types={Type.KRAFT}, serverProperties={@ClusterConfigProperty(key="authorizer.class.name", value="org.apache.kafka.metadata.authorizer.StandardAuthorizer")})})
    public void testAclsOnPrefixedResourcesWithAdminAPI(ClusterInstance cluster) {
        this.testAclsOnPrefixedResources(cluster, this.adminArgs(cluster.bootstrapServers(), Optional.empty()));
    }

    @ClusterTest(types={Type.ZK})
    public void testInvalidAuthorizerProperty(ClusterInstance cluster) {
        AclCommand.AuthorizerService aclCommandService = new AclCommand.AuthorizerService(AclAuthorizer.class.getName(), new AclCommand.AclCommandOptions(new String[]{AUTHORIZER_PROPERTIES, "zookeeper.connect " + this.zkConnect(cluster)}));
        Assertions.assertThrows(IllegalArgumentException.class, () -> ((AclCommand.AuthorizerService)aclCommandService).listAcls());
    }

    @ClusterTest(types={Type.ZK})
    public void testPatternTypesWithAuthorizer(ClusterInstance cluster) {
        this.testPatternTypes(this.zkArgs(cluster));
    }

    @ClusterTests(value={@ClusterTest(types={Type.ZK}), @ClusterTest(types={Type.KRAFT}, serverProperties={@ClusterConfigProperty(key="authorizer.class.name", value="org.apache.kafka.metadata.authorizer.StandardAuthorizer")})})
    public void testPatternTypesWithAdminAPI(ClusterInstance cluster) {
        this.testPatternTypes(this.adminArgs(cluster.bootstrapServers(), Optional.empty()));
    }

    @Test
    public void testUseBootstrapServerOptWithAuthorizerOpt() {
        this.assertInitializeInvalidOptionsExitCodeAndMsg(Arrays.asList(BOOTSTRAP_SERVER, LOCALHOST, AUTHORIZER, ACL_AUTHORIZER), "Only one of --bootstrap-server or --authorizer must be specified");
    }

    @Test
    public void testRequiredArgsForAuthorizerOpt() {
        this.assertInitializeInvalidOptionsExitCodeAndMsg(Arrays.asList(AUTHORIZER, ACL_AUTHORIZER), "Missing required argument \"[authorizer-properties]\"");
        this.checkNotThrow(Arrays.asList(AUTHORIZER, ACL_AUTHORIZER, AUTHORIZER_PROPERTIES, ZOOKEEPER_CONNECT, LIST));
    }

    @Test
    public void testUseCommandConfigOptWithoutBootstrapServerOpt() {
        this.assertInitializeInvalidOptionsExitCodeAndMsg(Arrays.asList(COMMAND_CONFIG, "cfg.properties", AUTHORIZER, ACL_AUTHORIZER, AUTHORIZER_PROPERTIES, ZOOKEEPER_CONNECT), "The --command-config option can only be used with --bootstrap-server option");
    }

    @Test
    public void testUseAuthorizerPropertiesOptWithBootstrapServerOpt() {
        this.assertInitializeInvalidOptionsExitCodeAndMsg(Arrays.asList(BOOTSTRAP_SERVER, LOCALHOST, AUTHORIZER_PROPERTIES, ZOOKEEPER_CONNECT), "The --authorizer-properties option can only be used with --authorizer option");
    }

    @Test
    public void testExactlyOneAction() {
        String errMsg = "Command must include exactly one action: --list, --add, --remove. ";
        this.assertInitializeInvalidOptionsExitCodeAndMsg(Arrays.asList(BOOTSTRAP_SERVER, LOCALHOST, ADD, LIST), errMsg);
        this.assertInitializeInvalidOptionsExitCodeAndMsg(Arrays.asList(BOOTSTRAP_SERVER, LOCALHOST, ADD, LIST, REMOVE), errMsg);
    }

    @Test
    public void testUseListPrincipalsOptWithoutListOpt() {
        this.assertInitializeInvalidOptionsExitCodeAndMsg(Arrays.asList(BOOTSTRAP_SERVER, LOCALHOST, ADD, "--principal", "User:CN=client"), "The --principal option is only available if --list is set");
    }

    @Test
    public void testUseProducerOptWithoutTopicOpt() {
        this.assertInitializeInvalidOptionsExitCodeAndMsg(Arrays.asList(BOOTSTRAP_SERVER, LOCALHOST, ADD, PRODUCER), "With --producer you must specify a --topic");
    }

    @Test
    public void testUseIdempotentOptWithoutProducerOpt() {
        this.assertInitializeInvalidOptionsExitCodeAndMsg(Arrays.asList(BOOTSTRAP_SERVER, LOCALHOST, ADD, IDEMPOTENT), "The --idempotent option is only available if --producer is set");
    }

    @Test
    public void testUseConsumerOptWithoutRequiredOpt() {
        this.assertInitializeInvalidOptionsExitCodeAndMsg(Arrays.asList(BOOTSTRAP_SERVER, LOCALHOST, ADD, CONSUMER), "With --consumer you must specify a --topic and a --group and no --cluster or --transactional-id option should be specified.");
        this.checkNotThrow(Arrays.asList(BOOTSTRAP_SERVER, LOCALHOST, ADD, CONSUMER, TOPIC, "test-topic", GROUP, "test-group"));
    }

    @Test
    public void testInvalidArgs() {
        this.assertInitializeInvalidOptionsExitCodeAndMsg(Arrays.asList(BOOTSTRAP_SERVER, LOCALHOST, LIST, PRODUCER), "Option \"[list]\" can't be used with option \"[producer]\"");
        this.assertInitializeInvalidOptionsExitCodeAndMsg(Arrays.asList(BOOTSTRAP_SERVER, LOCALHOST, ADD, PRODUCER, OPERATION), "Option \"[producer]\" can't be used with option \"[operation]\"");
        this.assertInitializeInvalidOptionsExitCodeAndMsg(Arrays.asList(BOOTSTRAP_SERVER, LOCALHOST, ADD, CONSUMER, OPERATION, TOPIC, "test-topic", GROUP, "test-group"), "Option \"[consumer]\" can't be used with option \"[operation]\"");
    }

    private void testProducerConsumerCli(ClusterInstance cluster, List<String> cmdArgs) {
        for (Map.Entry<List<String>, Map<Set<ResourcePattern>, Set<AccessControlEntry>>> entry : CMD_TO_RESOURCES_TO_ACL.entrySet()) {
            List<String> cmd = entry.getKey();
            Map<Set<ResourcePattern>, Set<AccessControlEntry>> resourcesToAcls = entry.getValue();
            List resourceCommand = resourcesToAcls.keySet().stream().map(RESOURCE_TO_COMMAND::get).reduce(new ArrayList(), (list, commands) -> {
                list.addAll(commands);
                return list;
            });
            ArrayList<String> args = new ArrayList<String>(cmdArgs);
            args.addAll(this.getCmd(AclPermissionType.ALLOW));
            args.addAll(resourceCommand);
            args.addAll(cmd);
            args.add(ADD);
            this.callMain(args);
            for (Map.Entry<Set<ResourcePattern>, Set<AccessControlEntry>> resourcesToAclsEntry : resourcesToAcls.entrySet()) {
                for (ResourcePattern resource : resourcesToAclsEntry.getKey()) {
                    this.withAuthorizer(cluster, authorizer -> TestUtils.waitAndVerifyAcls(AclCommandTest.asScalaSet((Set)resourcesToAclsEntry.getValue()), authorizer, resource, AccessControlEntryFilter.ANY));
                }
            }
            ArrayList<String> resourceCmd = new ArrayList<String>(resourceCommand);
            resourceCmd.addAll(cmd);
            this.testRemove(cluster, cmdArgs, resourcesToAcls.keySet().stream().flatMap(Collection::stream).collect(Collectors.toSet()), resourceCmd);
        }
    }

    private void testAclsOnPrefixedResources(ClusterInstance cluster, List<String> cmdArgs) {
        List<String> cmd = Arrays.asList("--allow-principal", PRINCIPAL.toString(), PRODUCER, TOPIC, "Test-", RESOURCE_PATTERN_TYPE, "Prefixed");
        ArrayList<String> args = new ArrayList<String>(cmdArgs);
        args.addAll(cmd);
        args.add(ADD);
        this.callMain(args);
        this.withAuthorizer(cluster, authorizer -> {
            AccessControlEntry writeAcl = new AccessControlEntry(PRINCIPAL.toString(), "*", AclOperation.WRITE, AclPermissionType.ALLOW);
            AccessControlEntry describeAcl = new AccessControlEntry(PRINCIPAL.toString(), "*", AclOperation.DESCRIBE, AclPermissionType.ALLOW);
            AccessControlEntry createAcl = new AccessControlEntry(PRINCIPAL.toString(), "*", AclOperation.CREATE, AclPermissionType.ALLOW);
            TestUtils.waitAndVerifyAcls(AclCommandTest.asScalaSet(new HashSet<AccessControlEntry>(Arrays.asList(writeAcl, describeAcl, createAcl))), authorizer, new ResourcePattern(ResourceType.TOPIC, "Test-", PatternType.PREFIXED), AccessControlEntryFilter.ANY);
        });
        args = new ArrayList<String>(cmdArgs);
        args.addAll(cmd);
        args.add(REMOVE);
        args.add("--force");
        this.callMain(args);
        this.withAuthorizer(cluster, authorizer -> {
            TestUtils.waitAndVerifyAcls(AclCommandTest.asScalaSet(Collections.emptySet()), authorizer, new ResourcePattern(ResourceType.CLUSTER, "kafka-cluster", PatternType.LITERAL), AccessControlEntryFilter.ANY);
            TestUtils.waitAndVerifyAcls(AclCommandTest.asScalaSet(Collections.emptySet()), authorizer, new ResourcePattern(ResourceType.TOPIC, "Test-", PatternType.PREFIXED), AccessControlEntryFilter.ANY);
        });
    }

    private static Map<Set<ResourcePattern>, Set<AccessControlEntry>> producerResourceToAcls(boolean enableIdempotence) {
        HashMap<Set<ResourcePattern>, Set<AccessControlEntry>> result = new HashMap<Set<ResourcePattern>, Set<AccessControlEntry>>();
        result.put(TOPIC_RESOURCES, AclCommandTest.asJavaSet(AclCommand.getAcls(AclCommandTest.asScalaSet(USERS), (AclPermissionType)AclPermissionType.ALLOW, AclCommandTest.asScalaSet(new HashSet<AclOperation>(Arrays.asList(AclOperation.WRITE, AclOperation.DESCRIBE, AclOperation.CREATE))), AclCommandTest.asScalaSet(HOSTS))));
        result.put(TRANSACTIONAL_ID_RESOURCES, AclCommandTest.asJavaSet(AclCommand.getAcls(AclCommandTest.asScalaSet(USERS), (AclPermissionType)AclPermissionType.ALLOW, AclCommandTest.asScalaSet(new HashSet<AclOperation>(Arrays.asList(AclOperation.WRITE, AclOperation.DESCRIBE))), AclCommandTest.asScalaSet(HOSTS))));
        result.put(Collections.singleton(CLUSTER_RESOURCE), AclCommandTest.asJavaSet(AclCommand.getAcls(AclCommandTest.asScalaSet(USERS), (AclPermissionType)AclPermissionType.ALLOW, enableIdempotence ? AclCommandTest.asScalaSet(Collections.singleton(AclOperation.IDEMPOTENT_WRITE)) : AclCommandTest.asScalaSet(Collections.emptySet()), AclCommandTest.asScalaSet(HOSTS))));
        return result;
    }

    private List<String> adminArgs(String bootstrapServer, Optional<File> commandConfig) {
        ArrayList<String> adminArgs = new ArrayList<String>(Arrays.asList(BOOTSTRAP_SERVER, bootstrapServer));
        commandConfig.ifPresent(file -> adminArgs.addAll(Arrays.asList(COMMAND_CONFIG, file.getAbsolutePath())));
        return adminArgs;
    }

    private Map.Entry<String, String> callMain(List<String> args) {
        return AclCommandTest.grabConsoleOutputAndError(() -> AclCommand.main((String[])args.toArray(new String[0])));
    }

    private void testAclCli(ClusterInstance cluster, List<String> cmdArgs) {
        for (Map.Entry<Set<ResourcePattern>, List<String>> entry : RESOURCE_TO_COMMAND.entrySet()) {
            Set<ResourcePattern> resources = entry.getKey();
            List<String> resourceCmd = entry.getValue();
            HashSet<AclPermissionType> permissionTypes = new HashSet<AclPermissionType>(Arrays.asList(AclPermissionType.ALLOW, AclPermissionType.DENY));
            for (AclPermissionType permissionType : permissionTypes) {
                Map.Entry<Set<AclOperation>, List<String>> operationToCmd = RESOURCE_TO_OPERATIONS.get(resources);
                Map.Entry<Set<AccessControlEntry>, List<String>> aclToCommand = this.getAclToCommand(permissionType, operationToCmd.getKey());
                ArrayList<String> resultArgs = new ArrayList<String>(cmdArgs);
                resultArgs.addAll((Collection<String>)aclToCommand.getValue());
                resultArgs.addAll(resourceCmd);
                resultArgs.addAll((Collection<String>)operationToCmd.getValue());
                resultArgs.add(ADD);
                Map.Entry<String, String> out = this.callMain(resultArgs);
                this.assertOutputContains("Adding ACLs", resources, resourceCmd, out.getKey());
                Assertions.assertEquals((Object)"", (Object)out.getValue());
                for (ResourcePattern resource : resources) {
                    this.withAuthorizer(cluster, authorizer -> TestUtils.waitAndVerifyAcls(AclCommandTest.asScalaSet((Set)aclToCommand.getKey()), authorizer, resource, AccessControlEntryFilter.ANY));
                }
                resultArgs = new ArrayList<String>(cmdArgs);
                resultArgs.add(LIST);
                out = this.callMain(resultArgs);
                this.assertOutputContains("Current ACLs", resources, resourceCmd, out.getKey());
                Assertions.assertEquals((Object)"", (Object)out.getValue());
                this.testRemove(cluster, cmdArgs, resources, resourceCmd);
            }
        }
    }

    private void assertOutputContains(String prefix, Set<ResourcePattern> resources, List<String> resourceCmd, String output) {
        resources.forEach(resource -> {
            String resourceType = resource.resourceType().toString();
            List<String> cmd = resource == CLUSTER_RESOURCE ? Collections.singletonList("kafka-cluster") : resourceCmd.stream().filter(s -> !s.startsWith("--")).collect(Collectors.toList());
            cmd.forEach(name -> {
                String expected = String.format("%s for resource `ResourcePattern(resourceType=%s, name=%s, patternType=LITERAL)`:", prefix, resourceType, name);
                Assertions.assertTrue((boolean)output.contains(expected), (String)("Substring " + expected + " not in output:\n" + output));
            });
        });
    }

    private void testPatternTypes(List<String> cmdArgs) {
        Exit.setExitProcedure((status, message) -> {
            if ((Integer)status == 1) {
                throw new RuntimeException("Exiting command");
            }
            throw new AssertionError((Object)("Unexpected exit with status " + status));
        });
        try {
            ((Stream)Arrays.stream(PatternType.values()).sequential()).forEach(patternType -> {
                ArrayList<String> addCmd = new ArrayList<String>(cmdArgs);
                addCmd.addAll(Arrays.asList("--allow-principal", PRINCIPAL.toString(), PRODUCER, TOPIC, "Test", ADD, RESOURCE_PATTERN_TYPE, patternType.toString()));
                this.verifyPatternType(addCmd, patternType.isSpecific());
                ArrayList<String> listCmd = new ArrayList<String>(cmdArgs);
                listCmd.addAll(Arrays.asList(TOPIC, "Test", LIST, RESOURCE_PATTERN_TYPE, patternType.toString()));
                this.verifyPatternType(listCmd, patternType != PatternType.UNKNOWN);
                ArrayList<String> removeCmd = new ArrayList<String>(cmdArgs);
                removeCmd.addAll(Arrays.asList(TOPIC, "Test", "--force", REMOVE, RESOURCE_PATTERN_TYPE, patternType.toString()));
                this.verifyPatternType(removeCmd, patternType != PatternType.UNKNOWN);
            });
        }
        finally {
            Exit.resetExitProcedure();
        }
    }

    private void verifyPatternType(List<String> cmd, boolean isValid) {
        if (isValid) {
            this.callMain(cmd);
        } else {
            Assertions.assertThrows(RuntimeException.class, () -> this.callMain(cmd));
        }
    }

    private void testRemove(ClusterInstance cluster, List<String> cmdArgs, Set<ResourcePattern> resources, List<String> resourceCmd) {
        ArrayList<String> args = new ArrayList<String>(cmdArgs);
        args.addAll(resourceCmd);
        args.add(REMOVE);
        args.add("--force");
        Map.Entry<String, String> out = this.callMain(args);
        Assertions.assertEquals((Object)"", (Object)out.getValue());
        for (ResourcePattern resource : resources) {
            this.withAuthorizer(cluster, authorizer -> TestUtils.waitAndVerifyAcls(AclCommandTest.asScalaSet(Collections.emptySet()), authorizer, resource, AccessControlEntryFilter.ANY));
        }
    }

    private Map.Entry<Set<AccessControlEntry>, List<String>> getAclToCommand(AclPermissionType permissionType, Set<AclOperation> operations) {
        return new AbstractMap.SimpleImmutableEntry<Set<AccessControlEntry>, List<String>>(AclCommandTest.asJavaSet(AclCommand.getAcls(AclCommandTest.asScalaSet(USERS), (AclPermissionType)permissionType, AclCommandTest.asScalaSet(operations), AclCommandTest.asScalaSet(HOSTS))), this.getCmd(permissionType));
    }

    private List<String> getCmd(AclPermissionType permissionType) {
        String principalCmd = permissionType == AclPermissionType.ALLOW ? "--allow-principal" : "--deny-principal";
        List<String> cmd = permissionType == AclPermissionType.ALLOW ? ALLOW_HOST_COMMAND : DENY_HOST_COMMAND;
        ArrayList<String> fullCmd = new ArrayList<String>();
        for (KafkaPrincipal user : USERS) {
            fullCmd.addAll(cmd);
            fullCmd.addAll(Arrays.asList(principalCmd, user.toString()));
        }
        return fullCmd;
    }

    private void withAuthorizer(ClusterInstance cluster, Consumer<Authorizer> consumer) {
        if (cluster.isKRaftTest()) {
            ArrayList allAuthorizers = new ArrayList();
            allAuthorizers.addAll(cluster.brokers().values().stream().map(server -> (Authorizer)server.authorizer().get()).collect(Collectors.toList()));
            allAuthorizers.addAll(cluster.controllers().values().stream().map(server -> (Authorizer)server.authorizer().get()).collect(Collectors.toList()));
            allAuthorizers.forEach(consumer);
        } else {
            consumer.accept((Authorizer)cluster.brokers().values().stream().findFirst().orElseThrow(() -> new RuntimeException("No broker found")).authorizer().get());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Map.Entry<String, String> grabConsoleOutputAndError(Runnable runnable) {
        ByteArrayOutputStream outBuf = new ByteArrayOutputStream();
        ByteArrayOutputStream errBuf = new ByteArrayOutputStream();
        PrintStream out = new PrintStream(outBuf);
        PrintStream err = new PrintStream(errBuf);
        try {
            Console.withOut((PrintStream)out, () -> {
                Console.withErr((PrintStream)err, () -> {
                    runnable.run();
                    return null;
                });
                return null;
            });
        }
        finally {
            out.flush();
            err.flush();
        }
        return new AbstractMap.SimpleImmutableEntry<String, String>(outBuf.toString(), errBuf.toString());
    }

    private static <T> scala.collection.immutable.Set<T> asScalaSet(Set<T> javaSet) {
        return JavaConverters.asScalaSet(javaSet).toSet();
    }

    private static <T> Set<T> asJavaSet(scala.collection.immutable.Set<T> scalaSet) {
        return JavaConverters.setAsJavaSet(scalaSet);
    }

    private String zkConnect(ClusterInstance cluster) {
        return ((ZkClusterInvocationContext.ZkClusterInstance)cluster).getUnderlying().zkConnect();
    }

    private List<String> zkArgs(ClusterInstance cluster) {
        return Arrays.asList(AUTHORIZER_PROPERTIES, "zookeeper.connect=" + this.zkConnect(cluster));
    }

    private void assertInitializeInvalidOptionsExitCodeAndMsg(List<String> args, String expectedMsg) {
        Exit.setExitProcedure((exitCode, message) -> {
            Assertions.assertEquals((Object)1, (Object)exitCode);
            Assertions.assertTrue((boolean)message.contains((Object)expectedMsg));
            throw new RuntimeException();
        });
        try {
            Assertions.assertThrows(RuntimeException.class, () -> new AclCommand.AclCommandOptions(args.toArray(new String[0])).checkArgs());
        }
        finally {
            Exit.resetExitProcedure();
        }
    }

    private void checkNotThrow(List<String> args) {
        AtomicReference exitStatus = new AtomicReference();
        org.apache.kafka.common.utils.Exit.setExitProcedure((status, __) -> {
            exitStatus.set(status);
            throw new RuntimeException();
        });
        try {
            Assertions.assertDoesNotThrow(() -> new AclCommand.AclCommandOptions(args.toArray(new String[0])).checkArgs());
            Assertions.assertNull(exitStatus.get());
        }
        finally {
            org.apache.kafka.common.utils.Exit.resetExitProcedure();
        }
    }
}

