/*
 * Decompiled with CFR 0.152.
 */
package kafka.api;

import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.Properties;
import java.util.concurrent.ExecutionException;
import kafka.api.IntegrationTestHarness;
import kafka.server.KafkaConfig;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.clients.admin.Config;
import org.apache.kafka.clients.admin.CreateTopicsOptions;
import org.apache.kafka.clients.admin.CreateTopicsResult;
import org.apache.kafka.clients.admin.DescribeClusterOptions;
import org.apache.kafka.clients.admin.DescribeClusterResult;
import org.apache.kafka.clients.admin.DescribeTopicsOptions;
import org.apache.kafka.clients.admin.NewTopic;
import org.apache.kafka.clients.admin.TopicDescription;
import org.apache.kafka.common.KafkaFuture;
import org.apache.kafka.common.TopicPartitionInfo;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.acl.AclOperation;
import org.apache.kafka.common.errors.TopicExistsException;
import org.apache.kafka.common.errors.UnknownTopicOrPartitionException;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.resource.ResourceType;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.security.authorizer.AclEntry;
import org.apache.kafka.server.config.ServerLogConfigs;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.TestInfo;
import org.junit.jupiter.api.Timeout;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.Set;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Buffer$;
import scala.compat.java8.OptionConverters;
import scala.compat.java8.OptionConverters$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.RichLong$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@Timeout(value=120L)
@ScalaSignature(bytes="\u0006\u0001\u0005mg!B\f\u0019\u0003\u0003i\u0002\"\u0002\u0015\u0001\t\u0003I\u0003\"B\u0016\u0001\t\u0003a\u0003\"B\u001a\u0001\t\u0003b\u0003\"\u0003\u001b\u0001\u0001\u0004\u0005\r\u0011\"\u00016\u0011%\t\u0005\u00011AA\u0002\u0013\u0005!\tC\u0005I\u0001\u0001\u0007\t\u0011)Q\u0005m!I\u0011\n\u0001a\u0001\u0002\u0004%\tA\u0013\u0005\n-\u0002\u0001\r\u00111A\u0005\u0002]C\u0011\"\u0017\u0001A\u0002\u0003\u0005\u000b\u0015B&\t\u000bi\u0003A\u0011I.\t\u000b\u0005\u0004A\u0011\t2\t\u000b\u001d\u0004A\u0011\u00015\t\u000f\u0005U\u0001\u0001\"\u0001\u0002\u0018!9\u0011\u0011\u0005\u0001\u0005\u0002\u0005\r\u0002bBA\u001e\u0001\u0011\u0005\u0013Q\b\u0005\b\u0003?\u0002A\u0011IA1\u0011\u001d\t)\u0007\u0001C\u0001\u0003OBa!a\u001f\u0001\t\u0003Q\u0005bBA?\u0001\u0011\u0005\u0011q\u0010\u0005\b\u0003\u001b\u0003A\u0011AAH\u0011%\t\t\fAI\u0001\n\u0003\t\u0019\fC\u0005\u0002J\u0002\t\n\u0011\"\u0001\u0002L\nA\")Y:f\u0003\u0012l\u0017N\\%oi\u0016<'/\u0019;j_:$Vm\u001d;\u000b\u0005eQ\u0012aA1qS*\t1$A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\u0007\u0001q\"\u0005\u0005\u0002 A5\t\u0001$\u0003\u0002\"1\t1\u0012J\u001c;fOJ\fG/[8o)\u0016\u001cH\u000fS1s]\u0016\u001c8\u000f\u0005\u0002$M5\tAE\u0003\u0002&5\u0005)Q\u000f^5mg&\u0011q\u0005\n\u0002\b\u0019><w-\u001b8h\u0003\u0019a\u0014N\\5u}Q\t!\u0006\u0005\u0002 \u0001\u0005Y!M]8lKJ\u001cu.\u001e8u+\u0005i\u0003C\u0001\u00182\u001b\u0005y#\"\u0001\u0019\u0002\u000bM\u001c\u0017\r\\1\n\u0005Iz#aA%oi\u0006YAn\\4ESJ\u001cu.\u001e8u\u0003!!Xm\u001d;J]\u001a|W#\u0001\u001c\u0011\u0005]zT\"\u0001\u001d\u000b\u0005eI$B\u0001\u001e<\u0003\u001dQW\u000f]5uKJT!\u0001P\u001f\u0002\u000b),h.\u001b;\u000b\u0003y\n1a\u001c:h\u0013\t\u0001\u0005H\u0001\u0005UKN$\u0018J\u001c4p\u00031!Xm\u001d;J]\u001a|w\fJ3r)\t\u0019e\t\u0005\u0002/\t&\u0011Qi\f\u0002\u0005+:LG\u000fC\u0004H\u000b\u0005\u0005\t\u0019\u0001\u001c\u0002\u0007a$\u0013'A\u0005uKN$\u0018J\u001c4pA\u000511\r\\5f]R,\u0012a\u0013\t\u0003\u0019Rk\u0011!\u0014\u0006\u0003\u001d>\u000bQ!\u00193nS:T!\u0001U)\u0002\u000f\rd\u0017.\u001a8ug*\u00111D\u0015\u0006\u0003'v\na!\u00199bG\",\u0017BA+N\u0005\u0015\tE-\\5o\u0003)\u0019G.[3oi~#S-\u001d\u000b\u0003\u0007bCqa\u0012\u0005\u0002\u0002\u0003\u00071*A\u0004dY&,g\u000e\u001e\u0011\u0002\u000bM,G/\u00169\u0015\u0005\rc\u0006\"\u0002\u001b\u000b\u0001\u00041\u0004F\u0001\u0006_!\t9t,\u0003\u0002aq\tQ!)\u001a4pe\u0016,\u0015m\u00195\u0002\u0011Q,\u0017M\u001d#po:$\u0012a\u0011\u0015\u0003\u0017\u0011\u0004\"aN3\n\u0005\u0019D$!C!gi\u0016\u0014X)Y2i\u0003Y!Xm\u001d;De\u0016\fG/\u001a#fY\u0016$X\rV8qS\u000e\u001cHCA\"j\u0011\u0015QG\u00021\u0001l\u0003\u0019\tXo\u001c:v[B\u0011An\u001d\b\u0003[F\u0004\"A\\\u0018\u000e\u0003=T!\u0001\u001d\u000f\u0002\rq\u0012xn\u001c;?\u0013\t\u0011x&\u0001\u0004Qe\u0016$WMZ\u0005\u0003iV\u0014aa\u0015;sS:<'B\u0001:0Q\u0015aqo`A\u0001!\tAX0D\u0001z\u0015\tQ80\u0001\u0005qe>4\u0018\u000eZ3s\u0015\ta\u0018(\u0001\u0004qCJ\fWn]\u0005\u0003}f\u00141BV1mk\u0016\u001cv.\u001e:dK\u000691\u000f\u001e:j]\u001e\u001cH\u0006BA\u0002\u0003\u000f\t#!!\u0002\u0002\u0005i\\\u0017EAA\u0005\u0003\u0015Y'/\u00194uQ\ra\u0011Q\u0002\t\u0005\u0003\u001f\t\t\"D\u0001|\u0013\r\t\u0019b\u001f\u0002\u0012!\u0006\u0014\u0018-\\3uKJL'0\u001a3UKN$\u0018\u0001\u0007;fgR\fU\u000f\u001e5pe&TX\rZ(qKJ\fG/[8ogR\u00191)!\u0007\t\u000b)l\u0001\u0019A6)\u000b59x0!\b-\t\u0005\r\u0011q\u0001\u0015\u0004\u001b\u00055\u0011\u0001H2p]\u001aLw-\u001e:fI\u000ecWo\u001d;feB+'/\\5tg&|gn]\u000b\u0003\u0003K\u0001R\u0001\\A\u0014\u0003WI1!!\u000bv\u0005\r\u0019V\r\u001e\t\u0005\u0003[\t9$\u0004\u0002\u00020)!\u0011\u0011GA\u001a\u0003\r\t7\r\u001c\u0006\u0004\u0003k\t\u0016AB2p[6|g.\u0003\u0003\u0002:\u0005=\"\u0001D!dY>\u0003XM]1uS>t\u0017!D7pI&4\u0017pQ8oM&<7\u000fF\u0002D\u0003\u007fAq!!\u0011\u0010\u0001\u0004\t\u0019%A\u0004d_:4\u0017nZ:\u0011\r\u0005\u0015\u00131JA(\u001b\t\t9EC\u0002\u0002J=\n!bY8mY\u0016\u001cG/[8o\u0013\u0011\ti%a\u0012\u0003\u0007M+\u0017\u000f\u0005\u0003\u0002R\u0005mSBAA*\u0015\u0011\t)&a\u0016\u0002\tU$\u0018\u000e\u001c\u0006\u0003\u00033\nAA[1wC&!\u0011QLA*\u0005)\u0001&o\u001c9feRLWm]\u0001\u0017WJ\fg\r^\"p]R\u0014x\u000e\u001c7fe\u000e{gNZ5hgR!\u00111IA2\u0011\u0015!\u0004\u00031\u00017\u00031\u0019'/Z1uK\u000e{gNZ5h+\t\tI\u0007E\u0004\u0002R\u0005-4.a\u001c\n\t\u00055\u00141\u000b\u0002\u0004\u001b\u0006\u0004\b\u0003BA9\u0003oj!!a\u001d\u000b\t\u0005U\u0014qK\u0001\u0005Y\u0006tw-\u0003\u0003\u0002z\u0005M$AB(cU\u0016\u001cG/A\tde\u0016\fG/Z!e[&t7\t\\5f]R\fQb^1ji\u001a{'\u000fV8qS\u000e\u001cHcB\"\u0002\u0002\u0006\r\u0015\u0011\u0012\u0005\u0006\u0013N\u0001\ra\u0013\u0005\b\u0003\u000b\u001b\u0002\u0019AAD\u0003=)\u0007\u0010]3di\u0016$\u0007K]3tK:$\b#BA#\u0003\u0017Z\u0007bBAF'\u0001\u0007\u0011qQ\u0001\u0010Kb\u0004Xm\u0019;fI6K7o]5oO\u0006\u0001r-\u001a;U_BL7-T3uC\u0012\fG/\u0019\u000b\u000b\u0003#\u000b9*!'\u0002\u001e\u0006\u001d\u0006c\u0001'\u0002\u0014&\u0019\u0011QS'\u0003!Q{\u0007/[2EKN\u001c'/\u001b9uS>t\u0007\"B%\u0015\u0001\u0004Y\u0005BBAN)\u0001\u00071.A\u0003u_BL7\rC\u0005\u0002 R\u0001\n\u00111\u0001\u0002\"\u0006yA-Z:de&\u0014Wm\u00149uS>t7\u000fE\u0002M\u0003GK1!!*N\u0005U!Um]2sS\n,Gk\u001c9jGN|\u0005\u000f^5p]ND\u0011\"!+\u0015!\u0003\u0005\r!a+\u00021\u0015D\b/Z2uK\u0012tU/\u001c)beRLG/[8og>\u0003H\u000f\u0005\u0003/\u0003[k\u0013bAAX_\t1q\n\u001d;j_:\f!dZ3u)>\u0004\u0018nY'fi\u0006$\u0017\r^1%I\u00164\u0017-\u001e7uIM*\"!!.+\t\u0005\u0005\u0016qW\u0016\u0003\u0003s\u0003B!a/\u0002F6\u0011\u0011Q\u0018\u0006\u0005\u0003\u007f\u000b\t-A\u0005v]\u000eDWmY6fI*\u0019\u00111Y\u0018\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0002H\u0006u&!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0006Qr-\u001a;U_BL7-T3uC\u0012\fG/\u0019\u0013eK\u001a\fW\u000f\u001c;%iU\u0011\u0011Q\u001a\u0016\u0005\u0003W\u000b9\fK\u0004\u0001\u0003#\f9.!7\u0011\u0007]\n\u0019.C\u0002\u0002Vb\u0012q\u0001V5nK>,H/A\u0003wC2,XMH\u0001y\u0001")
public abstract class BaseAdminIntegrationTest
extends IntegrationTestHarness {
    private TestInfo testInfo;
    private Admin client;

    @Override
    public int brokerCount() {
        return 3;
    }

    @Override
    public int logDirCount() {
        return 2;
    }

    public TestInfo testInfo() {
        return this.testInfo;
    }

    public void testInfo_$eq(TestInfo x$1) {
        this.testInfo = x$1;
    }

    public Admin client() {
        return this.client;
    }

    public void client_$eq(Admin x$1) {
        this.client = x$1;
    }

    @Override
    @BeforeEach
    public void setUp(TestInfo testInfo) {
        this.testInfo_$eq(testInfo);
        super.setUp(testInfo);
        TestUtils$.MODULE$.waitUntilBrokerMetadataIsPropagated(this.brokers(), TestUtils$.MODULE$.waitUntilBrokerMetadataIsPropagated$default$2());
    }

    @Override
    @AfterEach
    public void tearDown() {
        if (this.client() != null) {
            Utils.closeQuietly((AutoCloseable)this.client(), (String)"AdminClient");
        }
        super.tearDown();
    }

    @ParameterizedTest
    @ValueSource(strings={"zk", "kraft"})
    public void testCreateDeleteTopics(String quorum) {
        this.client_$eq(this.createAdminClient());
        .colon.colon topics = new .colon.colon((Object)"mytopic", (List)new .colon.colon((Object)"mytopic2", (List)new .colon.colon((Object)"mytopic3", (List)Nil$.MODULE$)));
        .colon.colon newTopics = new .colon.colon((Object)new NewTopic("mytopic", (java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Predef$.MODULE$.int2Integer(0)), CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)Predef$.MODULE$.int2Integer(1), (List)new .colon.colon((Object)Predef$.MODULE$.int2Integer(2), (List)Nil$.MODULE$))).asJava()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Predef$.MODULE$.int2Integer(1)), CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)Predef$.MODULE$.int2Integer(2), (List)new .colon.colon((Object)Predef$.MODULE$.int2Integer(0), (List)Nil$.MODULE$))).asJava())}))).asJava()), (List)new .colon.colon((Object)new NewTopic("mytopic2", 3, (short)3), (List)new .colon.colon((Object)new NewTopic("mytopic3", OptionConverters.RichOptionForJava8$.MODULE$.asJava$extension(OptionConverters$.MODULE$.RichOptionForJava8(Option$.MODULE$.empty())), OptionConverters.RichOptionForJava8$.MODULE$.asJava$extension(OptionConverters$.MODULE$.RichOptionForJava8(Option$.MODULE$.empty()))), (List)Nil$.MODULE$)));
        CreateTopicsResult validateResult = this.client().createTopics((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)newTopics).asJava(), new CreateTopicsOptions().validateOnly(true));
        validateResult.all().get();
        this.waitForTopics(this.client(), (Seq<String>)Nil$.MODULE$, (Seq<String>)topics);
        this.validateMetadataAndConfigs$1(validateResult);
        CreateTopicsResult createResult = this.client().createTopics((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)newTopics).asJava());
        createResult.all().get();
        this.waitForTopics(this.client(), (Seq<String>)topics, (Seq<String>)Nil$.MODULE$);
        this.validateMetadataAndConfigs$1(createResult);
        scala.collection.immutable.Map<String, Uuid> topicIds = this.getTopicIds();
        topics.foreach((Function1 & Serializable & scala.Serializable)topic -> {
            BaseAdminIntegrationTest.$anonfun$testCreateDeleteTopics$1(createResult, topicIds, topic);
            return BoxedUnit.UNIT;
        });
        CreateTopicsResult failedCreateResult = this.client().createTopics((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)newTopics).asJava());
        java.util.Map results = failedCreateResult.values();
        Assertions.assertTrue((boolean)results.containsKey("mytopic"));
        TestUtils$.MODULE$.assertFutureExceptionTypeEquals((KafkaFuture)results.get("mytopic"), TopicExistsException.class, TestUtils$.MODULE$.assertFutureExceptionTypeEquals$default$3());
        Assertions.assertTrue((boolean)results.containsKey("mytopic2"));
        TestUtils$.MODULE$.assertFutureExceptionTypeEquals((KafkaFuture)results.get("mytopic2"), TopicExistsException.class, TestUtils$.MODULE$.assertFutureExceptionTypeEquals$default$3());
        Assertions.assertTrue((boolean)results.containsKey("mytopic3"));
        TestUtils$.MODULE$.assertFutureExceptionTypeEquals((KafkaFuture)results.get("mytopic3"), TopicExistsException.class, TestUtils$.MODULE$.assertFutureExceptionTypeEquals$default$3());
        TestUtils$.MODULE$.assertFutureExceptionTypeEquals(failedCreateResult.numPartitions("mytopic3"), TopicExistsException.class, TestUtils$.MODULE$.assertFutureExceptionTypeEquals$default$3());
        TestUtils$.MODULE$.assertFutureExceptionTypeEquals(failedCreateResult.replicationFactor("mytopic3"), TopicExistsException.class, TestUtils$.MODULE$.assertFutureExceptionTypeEquals$default$3());
        TestUtils$.MODULE$.assertFutureExceptionTypeEquals(failedCreateResult.config("mytopic3"), TopicExistsException.class, TestUtils$.MODULE$.assertFutureExceptionTypeEquals$default$3());
        java.util.Map topicToDescription = (java.util.Map)this.client().describeTopics((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)topics).asJava()).allTopicNames().get();
        Assertions.assertEquals((Object)topics.toSet(), (Object)CollectionConverters$.MODULE$.asScalaSetConverter(topicToDescription.keySet()).asScala());
        TopicDescription topic0 = (TopicDescription)topicToDescription.get("mytopic");
        Assertions.assertEquals((Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)BoxesRunTime.boxToBoolean((boolean)topic0.isInternal()));
        Assertions.assertEquals((Object)"mytopic", (Object)topic0.name());
        Assertions.assertEquals((int)2, (int)topic0.partitions().size());
        TopicPartitionInfo topic0Partition0 = (TopicPartitionInfo)topic0.partitions().get(0);
        Assertions.assertEquals((int)1, (int)topic0Partition0.leader().id());
        Assertions.assertEquals((int)0, (int)topic0Partition0.partition());
        Assertions.assertEquals((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2})), (Object)((TraversableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(topic0Partition0.isr()).asScala()).map((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToInteger((int)x$1.id()), Buffer$.MODULE$.canBuildFrom()));
        Assertions.assertEquals((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2})), (Object)((TraversableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(topic0Partition0.replicas()).asScala()).map((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToInteger((int)x$2.id()), Buffer$.MODULE$.canBuildFrom()));
        TopicPartitionInfo topic0Partition1 = (TopicPartitionInfo)topic0.partitions().get(1);
        Assertions.assertEquals((int)2, (int)topic0Partition1.leader().id());
        Assertions.assertEquals((int)1, (int)topic0Partition1.partition());
        Assertions.assertEquals((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 0})), (Object)((TraversableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(topic0Partition1.isr()).asScala()).map((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToInteger((int)x$3.id()), Buffer$.MODULE$.canBuildFrom()));
        Assertions.assertEquals((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 0})), (Object)((TraversableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(topic0Partition1.replicas()).asScala()).map((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToInteger((int)x$4.id()), Buffer$.MODULE$.canBuildFrom()));
        TopicDescription topic1 = (TopicDescription)topicToDescription.get("mytopic2");
        Assertions.assertEquals((Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)BoxesRunTime.boxToBoolean((boolean)topic1.isInternal()));
        Assertions.assertEquals((Object)"mytopic2", (Object)topic1.name());
        Assertions.assertEquals((int)3, (int)topic1.partitions().size());
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 3).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)partitionId -> {
            TopicPartitionInfo partition = (TopicPartitionInfo)topic1.partitions().get(partitionId);
            Assertions.assertEquals((int)partitionId, (int)partition.partition());
            Assertions.assertEquals((int)3, (int)partition.replicas().size());
            partition.replicas().forEach(replica -> {
                Assertions.assertTrue((replica.id() >= 0 ? 1 : 0) != 0);
                Assertions.assertTrue((replica.id() < this.brokerCount() ? 1 : 0) != 0);
            });
            Assertions.assertEquals((int)partition.replicas().size(), (int)((SeqLike)((SeqLike)((TraversableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(partition.replicas()).asScala()).map((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToInteger((int)x$5.id()), Buffer$.MODULE$.canBuildFrom())).distinct()).size(), (String)"No duplicate replica ids");
            Assertions.assertEquals((int)3, (int)partition.isr().size());
            Assertions.assertEquals((Object)partition.replicas(), (Object)partition.isr());
            Assertions.assertTrue((boolean)partition.replicas().contains(partition.leader()));
        });
        TopicDescription topic3 = (TopicDescription)topicToDescription.get("mytopic3");
        Assertions.assertEquals((Object)"mytopic3", (Object)topic3.name());
        Assertions.assertEquals((Integer)((KafkaConfig)this.configs().head()).numPartitions(), (int)topic3.partitions().size());
        Assertions.assertEquals((int)((KafkaConfig)this.configs().head()).defaultReplicationFactor(), (int)((TopicPartitionInfo)topic3.partitions().get(0)).replicas().size());
        this.client().deleteTopics((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)topics).asJava()).all().get();
        this.waitForTopics(this.client(), (Seq<String>)Nil$.MODULE$, (Seq<String>)topics);
    }

    @ParameterizedTest
    @ValueSource(strings={"zk", "kraft"})
    public void testAuthorizedOperations(String quorum) {
        this.client_$eq(this.createAdminClient());
        DescribeClusterResult result = this.client().describeCluster();
        Assertions.assertNull((Object)result.authorizedOperations().get());
        result = this.client().describeCluster(new DescribeClusterOptions().includeAuthorizedOperations(true));
        Assertions.assertEquals((Object)((java.util.Set)CollectionConverters$.MODULE$.setAsJavaSetConverter(this.configuredClusterPermissions()).asJava()), (Object)result.authorizedOperations().get());
        String topic = "mytopic";
        .colon.colon newTopics = new .colon.colon((Object)new NewTopic(topic, 3, (short)3), (List)Nil$.MODULE$);
        this.client().createTopics((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)newTopics).asJava()).all().get();
        this.waitForTopics(this.client(), (Seq<String>)new .colon.colon((Object)topic, (List)Nil$.MODULE$), (Seq<String>)Nil$.MODULE$);
        TopicDescription topicResult = this.getTopicMetadata(this.client(), topic, this.getTopicMetadata$default$3(), this.getTopicMetadata$default$4());
        Assertions.assertNull((Object)topicResult.authorizedOperations());
        topicResult = this.getTopicMetadata(this.client(), topic, new DescribeTopicsOptions().includeAuthorizedOperations(true), this.getTopicMetadata$default$4());
        Assertions.assertEquals((Object)AclEntry.supportedOperations((ResourceType)ResourceType.TOPIC), (Object)topicResult.authorizedOperations());
    }

    public scala.collection.immutable.Set<AclOperation> configuredClusterPermissions() {
        return ((TraversableOnce)CollectionConverters$.MODULE$.asScalaSetConverter(AclEntry.supportedOperations((ResourceType)ResourceType.CLUSTER)).asScala()).toSet();
    }

    @Override
    public void modifyConfigs(Seq<Properties> configs) {
        super.modifyConfigs(configs);
        if (this.testInfo().getTestMethod().toString().contains("testCreateTopicsReturnsConfigs")) {
            configs.foreach((Function1 & Serializable & scala.Serializable)config -> {
                config.setProperty("log.roll.hours", "2");
                config.setProperty("log.retention.minutes", "240");
                return config.setProperty(ServerLogConfigs.LOG_ROLL_TIME_JITTER_MILLIS_CONFIG, "123");
            });
        }
        configs.foreach((Function1 & Serializable & scala.Serializable)config -> {
            config.setProperty("delete.topic.enable", "true");
            config.setProperty("group.initial.rebalance.delay.ms", "0");
            config.setProperty("auto.leader.rebalance.enable", "false");
            config.setProperty("controlled.shutdown.enable", "false");
            if (!config.containsKey("ssl.truststore.password")) {
                return config.setProperty("ssl.truststore.password", "some.invalid.pass");
            }
            return BoxedUnit.UNIT;
        });
    }

    @Override
    public Seq<Properties> kraftControllerConfigs(TestInfo testInfo) {
        Properties controllerConfig = new Properties();
        .colon.colon controllerConfigs = new .colon.colon((Object)controllerConfig, (List)Nil$.MODULE$);
        this.modifyConfigs((Seq<Properties>)controllerConfigs);
        return controllerConfigs;
    }

    public java.util.Map<String, Object> createConfig() {
        HashMap<String, Object> config = new HashMap<String, Object>();
        config.put("bootstrap.servers", this.bootstrapServers(this.bootstrapServers$default$1()));
        config.put("request.timeout.ms", "20000");
        config.put("default.api.timeout.ms", "40000");
        return config;
    }

    public Admin createAdminClient() {
        Properties props = new Properties();
        props.putAll(this.createConfig());
        ListenerName x$2 = this.createAdminClient$default$1();
        return this.createAdminClient(x$2, props);
    }

    /*
     * WARNING - void declaration
     */
    public void waitForTopics(Admin client, Seq<String> expectedPresent, Seq<String> expectedMissing) {
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!BaseAdminIntegrationTest.$anonfun$waitForTopics$1(client, expectedPresent, expectedMissing)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)BaseAdminIntegrationTest.$anonfun$waitForTopics$4());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
    }

    /*
     * WARNING - void declaration
     */
    public TopicDescription getTopicMetadata(Admin client, String topic, DescribeTopicsOptions describeOptions, Option<Object> expectedNumPartitionsOpt) {
        ObjectRef result = ObjectRef.create(null);
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!BaseAdminIntegrationTest.$anonfun$getTopicMetadata$1(client, topic, describeOptions, result, expectedNumPartitionsOpt)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)BaseAdminIntegrationTest.$anonfun$getTopicMetadata$4(topic));
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        return (TopicDescription)result.elem;
    }

    public DescribeTopicsOptions getTopicMetadata$default$3() {
        return new DescribeTopicsOptions();
    }

    public Option<Object> getTopicMetadata$default$4() {
        return None$.MODULE$;
    }

    private final void validateMetadataAndConfigs$1(CreateTopicsResult result) {
        Assertions.assertEquals((int)2, (Integer)((Integer)result.numPartitions("mytopic").get()));
        Assertions.assertEquals((int)2, (Integer)((Integer)result.replicationFactor("mytopic").get()));
        Assertions.assertEquals((int)3, (Integer)((Integer)result.numPartitions("mytopic2").get()));
        Assertions.assertEquals((int)3, (Integer)((Integer)result.replicationFactor("mytopic2").get()));
        Assertions.assertEquals((Integer)((KafkaConfig)this.configs().head()).numPartitions(), (Integer)((Integer)result.numPartitions("mytopic3").get()));
        Assertions.assertEquals((int)((KafkaConfig)this.configs().head()).defaultReplicationFactor(), (Integer)((Integer)result.replicationFactor("mytopic3").get()));
        Assertions.assertFalse((boolean)((Config)result.config("mytopic").get()).entries().isEmpty());
    }

    public static final /* synthetic */ void $anonfun$testCreateDeleteTopics$1(CreateTopicsResult createResult$1, scala.collection.immutable.Map topicIds$1, String topic) {
        Assertions.assertNotEquals((Object)Uuid.ZERO_UUID, (Object)createResult$1.topicId(topic).get());
        Assertions.assertEquals((Object)topicIds$1.apply((Object)topic), (Object)createResult$1.topicId(topic).get());
    }

    public static final /* synthetic */ boolean $anonfun$waitForTopics$3(java.util.Set topics$1, String topicName) {
        return !topics$1.contains(topicName);
    }

    public static final /* synthetic */ boolean $anonfun$waitForTopics$1(Admin client$1, Seq expectedPresent$1, Seq expectedMissing$1) {
        java.util.Set topics = (java.util.Set)client$1.listTopics().names().get();
        return expectedPresent$1.forall((Function1 & Serializable & scala.Serializable)topicName -> BoxesRunTime.boxToBoolean((boolean)topics.contains(topicName))) && expectedMissing$1.forall((Function1 & Serializable & scala.Serializable)topicName -> BoxesRunTime.boxToBoolean((boolean)BaseAdminIntegrationTest.$anonfun$waitForTopics$3(topics, topicName)));
    }

    public static final /* synthetic */ String $anonfun$waitForTopics$4() {
        return "timed out waiting for topics";
    }

    public static final /* synthetic */ boolean $anonfun$getTopicMetadata$1(Admin client$2, String topic$1, DescribeTopicsOptions describeOptions$1, ObjectRef result$1, Option expectedNumPartitionsOpt$1) {
        KafkaFuture topicResult = (KafkaFuture)client$2.describeTopics((Collection)CollectionConverters$.MODULE$.setAsJavaSetConverter((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{topic$1}))).asJava(), describeOptions$1).topicNameValues().get(topic$1);
        try {
            result$1.elem = (TopicDescription)topicResult.get();
            return BoxesRunTime.unboxToBoolean((Object)expectedNumPartitionsOpt$1.map((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)x$6 -> x$6 == ((TopicDescription)result$1.elem).partitions().size()).getOrElse((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> true));
        }
        catch (Throwable throwable) {
            if (throwable instanceof ExecutionException && ((ExecutionException)throwable).getCause() instanceof UnknownTopicOrPartitionException) {
                return false;
            }
            throw throwable;
        }
    }

    public static final /* synthetic */ String $anonfun$getTopicMetadata$4(String topic$1) {
        return new StringBuilder(35).append("Timed out waiting for metadata for ").append(topic$1).toString();
    }
}

