/*
 * Decompiled with CFR 0.152.
 */
package kafka.api;

import java.io.Serializable;
import java.util.Properties;
import kafka.api.SaslEndToEndAuthorizationTest;
import kafka.server.KafkaBroker;
import kafka.utils.JaasTestUtils$;
import kafka.utils.TestInfoUtils$;
import kafka.utils.TestUtils$;
import kafka.zk.ConfigEntityChangeNotificationZNode$;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.apache.kafka.common.security.scram.internals.ScramMechanism;
import org.apache.kafka.metadata.storage.Formatter;
import org.apache.kafka.test.TestSslUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.TestInfo;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;
import scala.Function1;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0001\u0005Mc\u0001\u0002\t\u0012\u0001YAQa\u0007\u0001\u0005\u0002qAQA\b\u0001\u0005R}AQ\u0001\u000b\u0001\u0005R%Bq\u0001\u000e\u0001C\u0002\u0013\u0005S\u0007\u0003\u0004F\u0001\u0001\u0006IA\u000e\u0005\b\r\u0002\u0011\r\u0011\"\u00116\u0011\u00199\u0005\u0001)A\u0005m!9\u0001\n\u0001b\u0001\n\u0013y\u0002BB%\u0001A\u0003%\u0001\u0005C\u0003K\u0001\u0011\u00053\nC\u0003[\u0001\u0011\u00053\fC\u0003g\u0001\u0011\u0005s\rC\u0003w\u0001\u0011\u0005s\u000fC\u0004\u0002\u0002\u0001!\t%a\u0001\t\u000f\u0005=\u0001\u0001\"\u0001\u0002\u0012\t)3+Y:m'\u000e\u0014\u0018-\\*tY\u0016sG\rV8F]\u0012\fU\u000f\u001e5pe&T\u0018\r^5p]R+7\u000f\u001e\u0006\u0003%M\t1!\u00199j\u0015\u0005!\u0012!B6bM.\f7\u0001A\n\u0003\u0001]\u0001\"\u0001G\r\u000e\u0003EI!AG\t\u0003;M\u000b7\u000f\\#oIR{WI\u001c3BkRDwN]5{CRLwN\u001c+fgR\fa\u0001P5oSRtD#A\u000f\u0011\u0005a\u0001\u0011\u0001G6bM.\f7\t\\5f]R\u001c\u0016m\u001d7NK\u000eD\u0017M\\5t[V\t\u0001\u0005\u0005\u0002\"M5\t!E\u0003\u0002$I\u0005!A.\u00198h\u0015\u0005)\u0013\u0001\u00026bm\u0006L!a\n\u0012\u0003\rM#(/\u001b8h\u0003eY\u0017MZ6b'\u0016\u0014h/\u001a:TCNdW*Z2iC:L7/\\:\u0016\u0003)\u00022aK\u0019!\u001d\tas&D\u0001.\u0015\u0005q\u0013!B:dC2\f\u0017B\u0001\u0019.\u0003\u001d\u0001\u0018mY6bO\u0016L!AM\u001a\u0003\t1K7\u000f\u001e\u0006\u0003a5\nqb\u00197jK:$\bK]5oG&\u0004\u0018\r\\\u000b\u0002mA\u0011qgQ\u0007\u0002q)\u0011\u0011HO\u0001\u0005CV$\bN\u0003\u0002<y\u0005A1/Z2ve&$\u0018P\u0003\u0002>}\u000511m\\7n_:T!\u0001F \u000b\u0005\u0001\u000b\u0015AB1qC\u000eDWMC\u0001C\u0003\ry'oZ\u0005\u0003\tb\u0012abS1gW\u0006\u0004&/\u001b8dSB\fG.\u0001\tdY&,g\u000e\u001e)sS:\u001c\u0017\u000e]1mA\u0005q1.\u00194lCB\u0013\u0018N\\2ja\u0006d\u0017aD6bM.\f\u0007K]5oG&\u0004\u0018\r\u001c\u0011\u0002\u001b-\fgm[1QCN\u001cxo\u001c:e\u00039Y\u0017MZ6b!\u0006\u001c8o^8sI\u0002\n1eY8oM&<WO]3TK\u000e,(/\u001b;z\u0005\u00164wN]3TKJ4XM]:Ti\u0006\u0014H\u000f\u0006\u0002M\u001fB\u0011A&T\u0005\u0003\u001d6\u0012A!\u00168ji\")\u0001K\u0003a\u0001#\u0006AA/Z:u\u0013:4w\u000e\u0005\u0002S16\t1K\u0003\u0002\u0013)*\u0011QKV\u0001\bUV\u0004\u0018\u000e^3s\u0015\t9\u0016)A\u0003kk:LG/\u0003\u0002Z'\nAA+Z:u\u0013:4w.\u0001\u000bbI\u00124uN]7biR,'oU3ui&twm\u001d\u000b\u0003\u0019rCQ!X\u0006A\u0002y\u000b\u0011BZ8s[\u0006$H/\u001a:\u0011\u0005}#W\"\u00011\u000b\u0005\u0005\u0014\u0017aB:u_J\fw-\u001a\u0006\u0003Gz\n\u0001\"\\3uC\u0012\fG/Y\u0005\u0003K\u0002\u0014\u0011BR8s[\u0006$H/\u001a:\u0002%\r|gNZ5hkJ,G*[:uK:,'o\u001d\u000b\u0003\u0019\"DQ!\u001b\u0007A\u0002)\fQ\u0001\u001d:paN\u00042a\u001b8q\u001b\u0005a'BA7.\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0003_2\u00141aU3r!\t\tH/D\u0001s\u0015\t\u0019H%\u0001\u0003vi&d\u0017BA;s\u0005)\u0001&o\u001c9feRLWm]\u0001\u001cGJ,\u0017\r^3Qe&4\u0018\u000e\\3hK\u0012\fE-\\5o\u00072LWM\u001c;\u0015\u0003a\u0004\"!\u001f@\u000e\u0003iT!a\u001f?\u0002\u000b\u0005$W.\u001b8\u000b\u0005ut\u0014aB2mS\u0016tGo]\u0005\u0003\u007fj\u0014Q!\u00113nS:\fQa]3u+B$2\u0001TA\u0003\u0011\u0015\u0001f\u00021\u0001RQ\rq\u0011\u0011\u0002\t\u0004%\u0006-\u0011bAA\u0007'\nQ!)\u001a4pe\u0016,\u0015m\u00195\u0002'Q,7\u000f^!vi\",g\u000e^5dCRLwN\\:\u0015\u00071\u000b\u0019\u0002C\u0004\u0002\u0016=\u0001\r!a\u0006\u0002\rE,xN];n!\u0011\tI\"a\n\u000f\t\u0005m\u00111\u0005\t\u0004\u0003;iSBAA\u0010\u0015\r\t\t#F\u0001\u0007yI|w\u000e\u001e \n\u0007\u0005\u0015R&\u0001\u0004Qe\u0016$WMZ\u0005\u0004O\u0005%\"bAA\u0013[!:q\"!\f\u0002>\u0005}\u0002\u0003BA\u0018\u0003si!!!\r\u000b\t\u0005M\u0012QG\u0001\taJ|g/\u001b3fe*\u0019\u0011q\u0007+\u0002\rA\f'/Y7t\u0013\u0011\tY$!\r\u0003\u0017Y\u000bG.^3T_V\u00148-Z\u0001\bgR\u0014\u0018N\\4tY\u0011\t\t%!\u0012\"\u0005\u0005\r\u0013!B6sC\u001a$\u0018EAA$\u0003\tQ8\u000eK\u0002\u0010\u0003\u0017\u0002B!!\u0014\u0002P5\u0011\u0011QG\u0005\u0005\u0003#\n)DA\tQCJ\fW.\u001a;fe&TX\r\u001a+fgR\u0004")
public class SaslScramSslEndToEndAuthorizationTest
extends SaslEndToEndAuthorizationTest {
    private final KafkaPrincipal clientPrincipal = new KafkaPrincipal("User", JaasTestUtils$.MODULE$.KafkaScramUser());
    private final KafkaPrincipal kafkaPrincipal = new KafkaPrincipal("User", JaasTestUtils$.MODULE$.KafkaScramAdmin());
    private final String kafkaPassword = JaasTestUtils$.MODULE$.KafkaScramAdminPassword();

    @Override
    public String kafkaClientSaslMechanism() {
        return "SCRAM-SHA-256";
    }

    @Override
    public List<String> kafkaServerSaslMechanisms() {
        return ((TraversableOnce)CollectionConverters$.MODULE$.collectionAsScalaIterableConverter(ScramMechanism.mechanismNames()).asScala()).toList();
    }

    @Override
    public KafkaPrincipal clientPrincipal() {
        return this.clientPrincipal;
    }

    @Override
    public KafkaPrincipal kafkaPrincipal() {
        return this.kafkaPrincipal;
    }

    private String kafkaPassword() {
        return this.kafkaPassword;
    }

    @Override
    public void configureSecurityBeforeServersStart(TestInfo testInfo) {
        super.configureSecurityBeforeServersStart(testInfo);
        if (!TestInfoUtils$.MODULE$.isKRaft(testInfo)) {
            this.zkClient().makeSurePersistentPathExists(ConfigEntityChangeNotificationZNode$.MODULE$.path());
            this.createScramCredentials(this.zkConnect(), this.kafkaPrincipal().getName(), this.kafkaPassword());
        }
        TestSslUtils.convertToPemWithoutFiles((Properties)this.producerConfig());
        TestSslUtils.convertToPemWithoutFiles((Properties)this.consumerConfig());
        TestSslUtils.convertToPemWithoutFiles((Properties)this.adminClientConfig());
    }

    @Override
    public void addFormatterSettings(Formatter formatter) {
        formatter.setClusterId("XcZZOzUqS4yHOjhMQB6JLQ");
        formatter.setScramArguments((java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)new StringBuilder(31).append("SCRAM-SHA-256=[name=").append(JaasTestUtils$.MODULE$.KafkaScramAdmin()).append(",password=").append(JaasTestUtils$.MODULE$.KafkaScramAdminPassword()).append("]").toString(), (List)Nil$.MODULE$)).asJava());
    }

    @Override
    public void configureListeners(Seq<Properties> props) {
        props.foreach((Function1 & Serializable & scala.Serializable)sslProps -> {
            SaslScramSslEndToEndAuthorizationTest.$anonfun$configureListeners$1(sslProps);
            return BoxedUnit.UNIT;
        });
        super.configureListeners(props);
    }

    @Override
    public Admin createPrivilegedAdminClient() {
        return this.createScramAdminClient(this.kafkaClientSaslMechanism(), this.kafkaPrincipal().getName(), this.kafkaPassword());
    }

    @Override
    @BeforeEach
    public void setUp(TestInfo testInfo) {
        super.setUp(testInfo);
        this.createScramCredentialsViaPrivilegedAdminClient(JaasTestUtils$.MODULE$.KafkaScramUser(), JaasTestUtils$.MODULE$.KafkaScramPassword());
        this.createScramCredentialsViaPrivilegedAdminClient(JaasTestUtils$.MODULE$.KafkaScramUser2(), JaasTestUtils$.MODULE$.KafkaScramPassword2());
    }

    @ParameterizedTest
    @ValueSource(strings={"kraft", "zk"})
    public void testAuthentications(String quorum) {
        Assertions.assertTrue((TestUtils$.MODULE$.totalMetricValue((KafkaBroker)this.brokers().head(), "successful-authentication-total") > 0L ? 1 : 0) != 0, (String)"No successful authentications");
        long failedAuths = TestUtils$.MODULE$.totalMetricValue((KafkaBroker)this.brokers().head(), "failed-authentication-total");
        Assertions.assertEquals((long)0L, (long)failedAuths);
    }

    public static final /* synthetic */ void $anonfun$configureListeners$1(Properties sslProps) {
        TestSslUtils.convertToPemWithoutFiles((Properties)sslProps);
    }
}

