/*
 * Decompiled with CFR 0.152.
 */
package kafka.cluster;

import java.nio.charset.StandardCharsets;
import kafka.cluster.Broker;
import kafka.cluster.BrokerEndPoint;
import kafka.zk.BrokerIdZNode$;
import org.apache.kafka.common.feature.Features;
import org.apache.kafka.common.feature.SupportedVersionRange;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import scala.None$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Map;
import scala.collection.MapLike;
import scala.collection.Seq;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001Y3A\u0001D\u0007\u0001%!)\u0011\u0004\u0001C\u00015!)Q\u0004\u0001C\u0001=!)q\u0006\u0001C\u0001=!)\u0011\u0007\u0001C\u0001=!)1\u0007\u0001C\u0001=!)Q\u0007\u0001C\u0001=!)q\u0007\u0001C\u0001=!)\u0011\b\u0001C\u0001=!)1\b\u0001C\u0001=!)Q\b\u0001C\u0001=!)q\b\u0001C\u0005\u0001\n\u0011\"I]8lKJ,e\u000e\u001a)pS:$H+Z:u\u0015\tqq\"A\u0004dYV\u001cH/\u001a:\u000b\u0003A\tQa[1gW\u0006\u001c\u0001a\u0005\u0002\u0001'A\u0011AcF\u0007\u0002+)\ta#A\u0003tG\u0006d\u0017-\u0003\u0002\u0019+\t1\u0011I\\=SK\u001a\fa\u0001P5oSRtD#A\u000e\u0011\u0005q\u0001Q\"A\u0007\u0002#Q,7\u000f\u001e%bg\"\fe\u000eZ#rk\u0006d7\u000fF\u0001 !\t!\u0002%\u0003\u0002\"+\t!QK\\5uQ\t\u00111\u0005\u0005\u0002%[5\tQE\u0003\u0002'O\u0005\u0019\u0011\r]5\u000b\u0005!J\u0013a\u00026va&$XM\u001d\u0006\u0003U-\nQA[;oSRT\u0011\u0001L\u0001\u0004_J<\u0017B\u0001\u0018&\u0005\u0011!Vm\u001d;\u00023Q,7\u000f\u001e$s_6T5o\u001c8GkR,(/\u001a,feNLwN\u001c\u0015\u0003\u0007\r\na\u0002^3ti\u001a\u0013x.\u001c&t_:4&\u0007\u000b\u0002\u0005G\u0005qA/Z:u\rJ|WNS:p]Z\u000b\u0004FA\u0003$\u00039!Xm\u001d;Ge>l'j]8o-NB#AB\u0012\u00025Q,7\u000f\u001e$s_6T5o\u001c8Wi]KG\u000f\u001b(vY2\u0014\u0016mY6)\u0005\u001d\u0019\u0013\u0001\u0007;fgR4%o\\7Kg>tg\u000bN,ji\"tuNU1dW\"\u0012\u0001bI\u0001\u001di\u0016\u001cHO\u0012:p[*\u001bxN\u001c,5/&$\bNT8GK\u0006$XO]3tQ\tI1%\u0001\buKN$hI]8n\u0015N|gNV\u001b)\u0005)\u0019\u0013a\u00049beN,'I]8lKJT5o\u001c8\u0015\u0007\u0005#\u0015\n\u0005\u0002\u001d\u0005&\u00111)\u0004\u0002\u0007\u0005J|7.\u001a:\t\u000b\u0015[\u0001\u0019\u0001$\u0002\u0005%$\u0007C\u0001\u000bH\u0013\tAUCA\u0002J]RDQAS\u0006A\u0002-\u000b!B[:p]N#(/\u001b8h!\ta5K\u0004\u0002N#B\u0011a*F\u0007\u0002\u001f*\u0011\u0001+E\u0001\u0007yI|w\u000e\u001e \n\u0005I+\u0012A\u0002)sK\u0012,g-\u0003\u0002U+\n11\u000b\u001e:j]\u001eT!AU\u000b")
public class BrokerEndPointTest {
    @Test
    public void testHashAndEquals() {
        BrokerEndPoint broker1 = new BrokerEndPoint(1, "myhost", 9092);
        BrokerEndPoint broker2 = new BrokerEndPoint(1, "myhost", 9092);
        BrokerEndPoint broker3 = new BrokerEndPoint(2, "myhost", 1111);
        BrokerEndPoint broker4 = new BrokerEndPoint(1, "other", 1111);
        Assertions.assertEquals((Object)broker1, (Object)broker2);
        Assertions.assertNotEquals((Object)broker1, (Object)broker3);
        Assertions.assertNotEquals((Object)broker1, (Object)broker4);
        Assertions.assertEquals((int)broker1.hashCode(), (int)broker2.hashCode());
        Assertions.assertNotEquals((int)broker1.hashCode(), (int)broker3.hashCode());
        Assertions.assertNotEquals((int)broker1.hashCode(), (int)broker4.hashCode());
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToInteger((int)1)), (Object)((MapLike)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)broker1), (Object)BoxesRunTime.boxToInteger((int)1))}))).get((Object)broker1));
    }

    @Test
    public void testFromJsonFutureVersion() {
        String brokerInfoStr = "{\n      \"foo\":\"bar\",\n      \"version\":100,\n      \"host\":\"localhost\",\n      \"port\":9092,\n      \"jmx_port\":9999,\n      \"timestamp\":\"1416974968782\",\n      \"endpoints\":[\"SSL://localhost:9093\"]\n    }";
        Broker broker = this.parseBrokerJson(1, brokerInfoStr);
        Assertions.assertEquals((int)1, (int)broker.id());
        BrokerEndPoint brokerEndPoint = broker.brokerEndPoint(ListenerName.forSecurityProtocol((SecurityProtocol)SecurityProtocol.SSL));
        Assertions.assertEquals((Object)"localhost", (Object)brokerEndPoint.host());
        Assertions.assertEquals((int)9093, (int)brokerEndPoint.port());
    }

    @Test
    public void testFromJsonV2() {
        String brokerInfoStr = "{\n      \"version\":2,\n      \"host\":\"localhost\",\n      \"port\":9092,\n      \"jmx_port\":9999,\n      \"timestamp\":\"1416974968782\",\n      \"endpoints\":[\"PLAINTEXT://localhost:9092\"]\n    }";
        Broker broker = this.parseBrokerJson(1, brokerInfoStr);
        Assertions.assertEquals((int)1, (int)broker.id());
        BrokerEndPoint brokerEndPoint = broker.brokerEndPoint(ListenerName.forSecurityProtocol((SecurityProtocol)SecurityProtocol.PLAINTEXT));
        Assertions.assertEquals((Object)"localhost", (Object)brokerEndPoint.host());
        Assertions.assertEquals((int)9092, (int)brokerEndPoint.port());
    }

    @Test
    public void testFromJsonV1() {
        String brokerInfoStr = "{\"jmx_port\":-1,\"timestamp\":\"1420485325400\",\"host\":\"172.16.8.243\",\"version\":1,\"port\":9091}";
        Broker broker = this.parseBrokerJson(1, brokerInfoStr);
        Assertions.assertEquals((int)1, (int)broker.id());
        BrokerEndPoint brokerEndPoint = broker.brokerEndPoint(ListenerName.forSecurityProtocol((SecurityProtocol)SecurityProtocol.PLAINTEXT));
        Assertions.assertEquals((Object)"172.16.8.243", (Object)brokerEndPoint.host());
        Assertions.assertEquals((int)9091, (int)brokerEndPoint.port());
    }

    @Test
    public void testFromJsonV3() {
        String json = "{\n      \"version\":3,\n      \"host\":\"localhost\",\n      \"port\":9092,\n      \"jmx_port\":9999,\n      \"timestamp\":\"2233345666\",\n      \"endpoints\":[\"PLAINTEXT://host1:9092\", \"SSL://host1:9093\"],\n      \"rack\":\"dc1\"\n    }";
        Broker broker = this.parseBrokerJson(1, json);
        Assertions.assertEquals((int)1, (int)broker.id());
        BrokerEndPoint brokerEndPoint = broker.brokerEndPoint(ListenerName.forSecurityProtocol((SecurityProtocol)SecurityProtocol.SSL));
        Assertions.assertEquals((Object)"host1", (Object)brokerEndPoint.host());
        Assertions.assertEquals((int)9093, (int)brokerEndPoint.port());
        Assertions.assertEquals((Object)new Some((Object)"dc1"), (Object)broker.rack());
    }

    @Test
    public void testFromJsonV4WithNullRack() {
        String json = "{\n      \"version\":4,\n      \"host\":\"localhost\",\n      \"port\":9092,\n      \"jmx_port\":9999,\n      \"timestamp\":\"2233345666\",\n      \"endpoints\":[\"CLIENT://host1:9092\", \"REPLICATION://host1:9093\"],\n      \"listener_security_protocol_map\":{\"CLIENT\":\"SSL\", \"REPLICATION\":\"PLAINTEXT\"},\n      \"rack\":null\n    }";
        Broker broker = this.parseBrokerJson(1, json);
        Assertions.assertEquals((int)1, (int)broker.id());
        BrokerEndPoint brokerEndPoint = broker.brokerEndPoint(new ListenerName("CLIENT"));
        Assertions.assertEquals((Object)"host1", (Object)brokerEndPoint.host());
        Assertions.assertEquals((int)9092, (int)brokerEndPoint.port());
        Assertions.assertEquals((Object)None$.MODULE$, (Object)broker.rack());
    }

    @Test
    public void testFromJsonV4WithNoRack() {
        String json = "{\n      \"version\":4,\n      \"host\":\"localhost\",\n      \"port\":9092,\n      \"jmx_port\":9999,\n      \"timestamp\":\"2233345666\",\n      \"endpoints\":[\"CLIENT://host1:9092\", \"REPLICATION://host1:9093\"],\n      \"listener_security_protocol_map\":{\"CLIENT\":\"SSL\", \"REPLICATION\":\"PLAINTEXT\"}\n    }";
        Broker broker = this.parseBrokerJson(1, json);
        Assertions.assertEquals((int)1, (int)broker.id());
        BrokerEndPoint brokerEndPoint = broker.brokerEndPoint(new ListenerName("CLIENT"));
        Assertions.assertEquals((Object)"host1", (Object)brokerEndPoint.host());
        Assertions.assertEquals((int)9092, (int)brokerEndPoint.port());
        Assertions.assertEquals((Object)None$.MODULE$, (Object)broker.rack());
    }

    @Test
    public void testFromJsonV4WithNoFeatures() {
        String json = "{\n      \"version\":4,\n      \"host\":\"localhost\",\n      \"port\":9092,\n      \"jmx_port\":9999,\n      \"timestamp\":\"2233345666\",\n      \"endpoints\":[\"CLIENT://host1:9092\", \"REPLICATION://host1:9093\"],\n      \"listener_security_protocol_map\":{\"CLIENT\":\"SSL\", \"REPLICATION\":\"PLAINTEXT\"},\n      \"rack\":\"dc1\"\n    }";
        Broker broker = this.parseBrokerJson(1, json);
        Assertions.assertEquals((int)1, (int)broker.id());
        BrokerEndPoint brokerEndPoint = broker.brokerEndPoint(new ListenerName("CLIENT"));
        Assertions.assertEquals((Object)"host1", (Object)brokerEndPoint.host());
        Assertions.assertEquals((int)9092, (int)brokerEndPoint.port());
        Assertions.assertEquals((Object)new Some((Object)"dc1"), (Object)broker.rack());
        Assertions.assertEquals((Object)Features.emptySupportedFeatures(), (Object)broker.features());
    }

    @Test
    public void testFromJsonV5() {
        String json = "{\n      \"version\":5,\n      \"host\":\"localhost\",\n      \"port\":9092,\n      \"jmx_port\":9999,\n      \"timestamp\":\"2233345666\",\n      \"endpoints\":[\"CLIENT://host1:9092\", \"REPLICATION://host1:9093\"],\n      \"listener_security_protocol_map\":{\"CLIENT\":\"SSL\", \"REPLICATION\":\"PLAINTEXT\"},\n      \"rack\":\"dc1\",\n      \"features\": {\"feature1\": {\"min_version\": 1, \"max_version\": 2}, \"feature2\": {\"min_version\": 2, \"max_version\": 4}}\n    }";
        Broker broker = this.parseBrokerJson(1, json);
        Assertions.assertEquals((int)1, (int)broker.id());
        BrokerEndPoint brokerEndPoint = broker.brokerEndPoint(new ListenerName("CLIENT"));
        Assertions.assertEquals((Object)"host1", (Object)brokerEndPoint.host());
        Assertions.assertEquals((int)9092, (int)brokerEndPoint.port());
        Assertions.assertEquals((Object)new Some((Object)"dc1"), (Object)broker.rack());
        Assertions.assertEquals((Object)Features.supportedFeatures((java.util.Map)((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"feature1"), (Object)new SupportedVersionRange(1, 2)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"feature2"), (Object)new SupportedVersionRange(2, 4))}))).asJava())), (Object)broker.features());
    }

    private Broker parseBrokerJson(int id, String jsonString) {
        return BrokerIdZNode$.MODULE$.decode(id, jsonString.getBytes(StandardCharsets.UTF_8)).broker();
    }
}

