/*
 * Decompiled with CFR 0.152.
 */
package kafka.coordinator.group;

import java.io.Serializable;
import java.net.InetAddress;
import java.util.Iterator;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import kafka.common.OffsetAndMetadata;
import kafka.coordinator.group.GroupCoordinator;
import kafka.coordinator.group.GroupCoordinator$;
import kafka.coordinator.group.GroupCoordinatorAdapter;
import kafka.coordinator.group.GroupOverview;
import kafka.coordinator.group.GroupSummary;
import kafka.coordinator.group.JoinGroupResult;
import kafka.coordinator.group.LeaveGroupResult;
import kafka.coordinator.group.LeaveMemberResponse;
import kafka.coordinator.group.MemberSummary;
import kafka.coordinator.group.SyncGroupResult;
import kafka.server.RequestLocal;
import org.apache.kafka.common.TopicIdPartition;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.errors.InvalidGroupIdException;
import org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.kafka.common.message.ConsumerGroupHeartbeatRequestData;
import org.apache.kafka.common.message.DeleteGroupsResponseData;
import org.apache.kafka.common.message.DescribeGroupsResponseData;
import org.apache.kafka.common.message.HeartbeatRequestData;
import org.apache.kafka.common.message.HeartbeatResponseData;
import org.apache.kafka.common.message.JoinGroupRequestData;
import org.apache.kafka.common.message.JoinGroupResponseData;
import org.apache.kafka.common.message.LeaveGroupRequestData;
import org.apache.kafka.common.message.LeaveGroupResponseData;
import org.apache.kafka.common.message.ListGroupsRequestData;
import org.apache.kafka.common.message.ListGroupsResponseData;
import org.apache.kafka.common.message.OffsetCommitRequestData;
import org.apache.kafka.common.message.OffsetCommitResponseData;
import org.apache.kafka.common.message.OffsetDeleteRequestData;
import org.apache.kafka.common.message.OffsetDeleteResponseData;
import org.apache.kafka.common.message.OffsetFetchRequestData;
import org.apache.kafka.common.message.OffsetFetchResponseData;
import org.apache.kafka.common.message.ShareGroupHeartbeatRequestData;
import org.apache.kafka.common.message.SyncGroupRequestData;
import org.apache.kafka.common.message.SyncGroupResponseData;
import org.apache.kafka.common.message.TxnOffsetCommitRequestData;
import org.apache.kafka.common.message.TxnOffsetCommitResponseData;
import org.apache.kafka.common.network.ClientInformation;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.OffsetFetchResponse;
import org.apache.kafka.common.requests.RequestContext;
import org.apache.kafka.common.requests.RequestHeader;
import org.apache.kafka.common.requests.TransactionResult;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.utils.BufferSupplier;
import org.apache.kafka.common.utils.ImplicitLinkedHashCollection;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.annotation.ApiKeyVersionsSource;
import org.apache.kafka.server.util.MockTime;
import org.apache.kafka.test.TestUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Set;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005Ed\u0001\u0002\f\u0018\u0001yAQ!\n\u0001\u0005\u0002\u0019BQ!\u000b\u0001\u0005\n)BQ!\u0012\u0001\u0005\u0002\u0019CQ!\u0016\u0001\u0005\u0002\u0019CQa\u0016\u0001\u0005\u0002aCQ\u0001\u001d\u0001\u0005\u0002EDQ\u0001\u001f\u0001\u0005\u0002\u0019CQA\u001f\u0001\u0005\u0002\u0019CQa\u001f\u0001\u0005\u0002\u0019CQa\u001f\u0001\u0005\u0002uDa!a\u000f\u0001\t\u00031\u0005BBA \u0001\u0011\u0005a\t\u0003\u0004\u0002D\u0001!\tA\u0012\u0005\u0007\u0003\u000f\u0002A\u0011\u0001$\t\u000f\u0005-\u0003\u0001\"\u0001\u0002N!1\u00111\f\u0001\u0005\u0002\u0019Ca!a\u0018\u0001\t\u00031\u0005BBA1\u0001\u0011\u0005a\t\u0003\u0004\u0002f\u0001!\tA\u0012\u0005\u0007\u0003S\u0002A\u0011\u0001$\t\r\u00055\u0004\u0001\"\u0001G\u0005m9%o\\;q\u0007>|'\u000fZ5oCR|'/\u00113baR,'\u000fV3ti*\u0011\u0001$G\u0001\u0006OJ|W\u000f\u001d\u0006\u00035m\t1bY8pe\u0012Lg.\u0019;pe*\tA$A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\u0005\u0001y\u0002C\u0001\u0011$\u001b\u0005\t#\"\u0001\u0012\u0002\u000bM\u001c\u0017\r\\1\n\u0005\u0011\n#AB!osJ+g-\u0001\u0004=S:LGO\u0010\u000b\u0002OA\u0011\u0001\u0006A\u0007\u0002/\u0005YQ.Y6f\u0007>tG/\u001a=u)\rY\u0003\b\u0011\t\u0003YYj\u0011!\f\u0006\u0003]=\n\u0001B]3rk\u0016\u001cHo\u001d\u0006\u0003aE\naaY8n[>t'B\u0001\u000f3\u0015\t\u0019D'\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002k\u0005\u0019qN]4\n\u0005]j#A\u0004*fcV,7\u000f^\"p]R,\u0007\u0010\u001e\u0005\u0006s\t\u0001\rAO\u0001\u0007CBL7*Z=\u0011\u0005mrT\"\u0001\u001f\u000b\u0005uz\u0013\u0001\u00039s_R|7m\u001c7\n\u0005}b$aB!qS.+\u0017p\u001d\u0005\u0006\u0003\n\u0001\rAQ\u0001\u000bCBLg+\u001a:tS>t\u0007C\u0001\u0011D\u0013\t!\u0015EA\u0003TQ>\u0014H/A\u000buKN$(j\\5o\u0007>t7/^7fe\u001e\u0013x.\u001e9\u0015\u0003\u001d\u0003\"\u0001\t%\n\u0005%\u000b#\u0001B+oSRD#aA&\u0011\u00051\u001bV\"A'\u000b\u00059{\u0015aA1qS*\u0011\u0001+U\u0001\bUV\u0004\u0018\u000e^3s\u0015\t\u0011F'A\u0003kk:LG/\u0003\u0002U\u001b\n!A+Z:u\u0003I!Xm\u001d;K_&t7\u000b[1sK\u001e\u0013x.\u001e9)\u0005\u0011Y\u0015!\u0004;fgRTu.\u001b8He>,\b\u000f\u0006\u0002H3\")!,\u0002a\u0001\u0005\u00069a/\u001a:tS>t\u0007\u0006B\u0003]s\u0011\u0004\"!\u00182\u000e\u0003yS!a\u00181\u0002\u0015\u0005tgn\u001c;bi&|gN\u0003\u0002b_\u0005)Q\u000f^5mg&\u00111M\u0018\u0002\u0015\u0003BL7*Z=WKJ\u001c\u0018n\u001c8t'>,(oY3%\u0003\u0015L!AZ4\u0002\u0015){\u0015JT0H%>+\u0006K\u0003\u0002iy\u00059\u0011\t]5LKf\u001c\bFA\u0003k!\tYg.D\u0001m\u0015\tiw*\u0001\u0004qCJ\fWn]\u0005\u0003_2\u0014\u0011\u0003U1sC6,G/\u001a:ju\u0016$G+Z:u\u00035!Xm\u001d;Ts:\u001cwI]8vaR\u0011qI\u001d\u0005\u00065\u001a\u0001\rA\u0011\u0015\u0005\rqKD\u000fJ\u0001v\u0013\t1x-\u0001\u0006T3:\u001bul\u0012*P+BC#A\u00026\u0002\u001bQ,7\u000f\u001e%fCJ$(-Z1uQ\t91*\u0001\buKN$H*Z1wK\u001e\u0013x.\u001e9\u0002\u001dQ,7\u000f\u001e'jgR<%o\\;qg\"\u0012\u0011b\u0013\u000b\t\u000fz\fI#!\f\u00028!1qP\u0003a\u0001\u0003\u0003\tAb\u001d;bi\u0016\u001ch)\u001b7uKJ\u0004b!a\u0001\u0002\u0014\u0005ea\u0002BA\u0003\u0003\u001fqA!a\u0002\u0002\u000e5\u0011\u0011\u0011\u0002\u0006\u0004\u0003\u0017i\u0012A\u0002\u001fs_>$h(C\u0001#\u0013\r\t\t\"I\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\t)\"a\u0006\u0003\t1K7\u000f\u001e\u0006\u0004\u0003#\t\u0003\u0003BA\u000e\u0003GqA!!\b\u0002 A\u0019\u0011qA\u0011\n\u0007\u0005\u0005\u0012%\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0003K\t9C\u0001\u0004TiJLgn\u001a\u0006\u0004\u0003C\t\u0003bBA\u0016\u0015\u0001\u0007\u0011\u0011A\u0001\fif\u0004Xm\u001d$jYR,'\u000fC\u0004\u00020)\u0001\r!!\r\u0002)\u0015D\b/Z2uK\u0012\u001cF/\u0019;fg\u001aKG\u000e^3s!\u0019\tY\"a\r\u0002\u001a%!\u0011QGA\u0014\u0005\r\u0019V\r\u001e\u0005\b\u0003sQ\u0001\u0019AA\u0019\u0003M)\u0007\u0010]3di\u0016$G+\u001f9fg\u001aKG\u000e^3s\u0003E!Xm\u001d;EKN\u001c'/\u001b2f\u000fJ|W\u000f\u001d\u0015\u0003\u0017-\u000b\u0001\u0003^3ti\u0012+G.\u001a;f\u000fJ|W\u000f]:)\u00051Y\u0015a\u0005;fgR4U\r^2i\u00032dwJ\u001a4tKR\u001c\bFA\u0007L\u0003A!Xm\u001d;GKR\u001c\u0007n\u00144gg\u0016$8\u000f\u000b\u0002\u000f\u0017\u0006\tB/Z:u\u0007>lW.\u001b;PM\u001a\u001cX\r^:\u0015\u0007\u001d\u000by\u0005C\u0003[\u001f\u0001\u0007!\tK\u0003\u00109f\n\u0019\u0006\n\u0002\u0002V%\u0019\u0011qK4\u0002\u001b=3eiU#U?\u000e{U*T%UQ\ty!.\u0001\u0010uKN$8i\\7nSR$&/\u00198tC\u000e$\u0018n\u001c8bY>3gm]3ug\"\u0012\u0001cS\u0001\u0012i\u0016\u001cH\u000fR3mKR,wJ\u001a4tKR\u001c\u0018\u0001\n;fgR$U\r\\3uK>3gm]3ug^KG\u000f[$s_V\u0004H*\u001a<fY\u0016\u0013(o\u001c:)\u0005IY\u0015!\u0007;fgR\u001cuN\\:v[\u0016\u0014xI]8va\u0012+7o\u0019:jE\u0016D#aE&\u0002-Q,7\u000f^*iCJ,wI]8va\u0012+7o\u0019:jE\u0016D#\u0001F&\u0002cQ,7\u000f^(o)J\fgn]1di&|gnQ8na2,G/\u001a3XSRDWK\\3ya\u0016\u001cG/\u001a3Fq\u000e,\u0007\u000f^5p]\"\u0012Qc\u0013")
public class GroupCoordinatorAdapterTest {
    private RequestContext makeContext(ApiKeys apiKey, short apiVersion) {
        return new RequestContext(new RequestHeader(apiKey, apiVersion, "client", 0), "1", InetAddress.getLocalHost(), KafkaPrincipal.ANONYMOUS, ListenerName.forSecurityProtocol((SecurityProtocol)SecurityProtocol.PLAINTEXT), SecurityProtocol.PLAINTEXT, ClientInformation.EMPTY, false);
    }

    @Test
    public void testJoinConsumerGroup() {
        GroupCoordinator groupCoordinator = (GroupCoordinator)Mockito.mock(GroupCoordinator.class);
        GroupCoordinatorAdapter adapter = new GroupCoordinatorAdapter(groupCoordinator, Time.SYSTEM);
        RequestContext ctx = this.makeContext(ApiKeys.CONSUMER_GROUP_HEARTBEAT, ApiKeys.CONSUMER_GROUP_HEARTBEAT.latestVersion());
        ConsumerGroupHeartbeatRequestData request = new ConsumerGroupHeartbeatRequestData().setGroupId("group");
        CompletableFuture future = adapter.consumerGroupHeartbeat(ctx, request);
        Assertions.assertTrue((boolean)future.isDone());
        Assertions.assertTrue((boolean)future.isCompletedExceptionally());
        TestUtils.assertFutureThrows((Future)future, UnsupportedVersionException.class);
    }

    @Test
    public void testJoinShareGroup() {
        GroupCoordinator groupCoordinator = (GroupCoordinator)Mockito.mock(GroupCoordinator.class);
        GroupCoordinatorAdapter adapter = new GroupCoordinatorAdapter(groupCoordinator, Time.SYSTEM);
        RequestContext ctx = this.makeContext(ApiKeys.SHARE_GROUP_HEARTBEAT, ApiKeys.SHARE_GROUP_HEARTBEAT.latestVersion());
        ShareGroupHeartbeatRequestData request = new ShareGroupHeartbeatRequestData().setGroupId("group");
        CompletableFuture future = adapter.shareGroupHeartbeat(ctx, request);
        Assertions.assertTrue((boolean)future.isDone());
        Assertions.assertTrue((boolean)future.isCompletedExceptionally());
        TestUtils.assertFutureThrows((Future)future, UnsupportedVersionException.class);
    }

    @ParameterizedTest
    @ApiKeyVersionsSource(apiKey=ApiKeys.JOIN_GROUP)
    public void testJoinGroup(short version) {
        GroupCoordinator groupCoordinator = (GroupCoordinator)Mockito.mock(GroupCoordinator.class);
        GroupCoordinatorAdapter adapter = new GroupCoordinatorAdapter(groupCoordinator, Time.SYSTEM);
        RequestContext ctx = this.makeContext(ApiKeys.JOIN_GROUP, version);
        JoinGroupRequestData request = new JoinGroupRequestData().setGroupId("group").setMemberId("member").setProtocolType("consumer").setRebalanceTimeoutMs(1000).setSessionTimeoutMs(2000).setReason("reason").setProtocols(new JoinGroupRequestData.JoinGroupRequestProtocolCollection((Iterator)CollectionConverters$.MODULE$.asJavaIteratorConverter(new .colon.colon((Object)new JoinGroupRequestData.JoinGroupRequestProtocol().setName("first").setMetadata("first".getBytes()), (List)new .colon.colon((Object)new JoinGroupRequestData.JoinGroupRequestProtocol().setName("second").setMetadata("second".getBytes()), (List)Nil$.MODULE$)).iterator()).asJava()));
        BufferSupplier bufferSupplier = BufferSupplier.create();
        CompletableFuture future = adapter.joinGroup(ctx, request, bufferSupplier);
        Assertions.assertFalse((boolean)future.isDone());
        ArgumentCaptor capturedProtocols = ArgumentCaptor.forClass(List.class);
        ArgumentCaptor capturedCallback = ArgumentCaptor.forClass(Function1.class);
        ((GroupCoordinator)Mockito.verify((Object)groupCoordinator)).handleJoinGroup((String)ArgumentMatchers.eq((Object)request.groupId()), (String)ArgumentMatchers.eq((Object)request.memberId()), (Option)ArgumentMatchers.eq((Object)None$.MODULE$), ArgumentMatchers.eq((version >= 4 ? 1 : 0) != 0), ArgumentMatchers.eq((version >= 9 ? 1 : 0) != 0), (String)ArgumentMatchers.eq((Object)ctx.clientId()), (String)ArgumentMatchers.eq((Object)InetAddress.getLocalHost().toString()), ArgumentMatchers.eq((int)request.rebalanceTimeoutMs()), ArgumentMatchers.eq((int)request.sessionTimeoutMs()), (String)ArgumentMatchers.eq((Object)request.protocolType()), (List)capturedProtocols.capture(), (Function1)capturedCallback.capture(), (Option)ArgumentMatchers.eq((Object)new Some((Object)"reason")), (RequestLocal)ArgumentMatchers.eq((Object)new RequestLocal(bufferSupplier)));
        Assertions.assertEquals((Object)new .colon.colon((Object)new Tuple2((Object)"first", (Object)"first"), (List)new .colon.colon((Object)new Tuple2((Object)"second", (Object)"second"), (List)Nil$.MODULE$)), (Object)((List)capturedProtocols.getValue()).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            if (x0$1 != null) {
                String name = (String)x0$1._1();
                byte[] metadata = (byte[])x0$1._2();
                return new Tuple2((Object)name, (Object)new String(metadata));
            }
            throw new MatchError(null);
        }, List$.MODULE$.canBuildFrom()));
        ((Function1)capturedCallback.getValue()).apply((Object)new JoinGroupResult((List)new .colon.colon((Object)new JoinGroupResponseData.JoinGroupResponseMember().setMemberId("member").setMetadata("member".getBytes()).setGroupInstanceId("instance"), (List)Nil$.MODULE$), "member", 10, (Option)new Some((Object)"consumer"), (Option)new Some((Object)"range"), "leader", true, Errors.UNKNOWN_MEMBER_ID));
        JoinGroupResponseData expectedData = new JoinGroupResponseData().setMembers((java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)new JoinGroupResponseData.JoinGroupResponseMember().setMemberId("member").setMetadata("member".getBytes()).setGroupInstanceId("instance"), (List)Nil$.MODULE$)).asJava()).setMemberId("member").setGenerationId(10).setProtocolType("consumer").setProtocolName("range").setLeader("leader").setSkipAssignment(true).setErrorCode(Errors.UNKNOWN_MEMBER_ID.code());
        Assertions.assertTrue((boolean)future.isDone());
        Assertions.assertEquals((Object)expectedData, future.get());
    }

    @ParameterizedTest
    @ApiKeyVersionsSource(apiKey=ApiKeys.SYNC_GROUP)
    public void testSyncGroup(short version) {
        GroupCoordinator groupCoordinator = (GroupCoordinator)Mockito.mock(GroupCoordinator.class);
        GroupCoordinatorAdapter adapter = new GroupCoordinatorAdapter(groupCoordinator, Time.SYSTEM);
        RequestContext ctx = this.makeContext(ApiKeys.SYNC_GROUP, version);
        SyncGroupRequestData data = new SyncGroupRequestData().setGroupId("group").setMemberId("member1").setGroupInstanceId("instance").setProtocolType("consumer").setProtocolName("range").setGenerationId(10).setAssignments((java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)new SyncGroupRequestData.SyncGroupRequestAssignment().setMemberId("member1").setAssignment("member1".getBytes()), (List)new .colon.colon((Object)new SyncGroupRequestData.SyncGroupRequestAssignment().setMemberId("member2").setAssignment("member2".getBytes()), (List)Nil$.MODULE$))).asJava());
        BufferSupplier bufferSupplier = BufferSupplier.create();
        CompletableFuture future = adapter.syncGroup(ctx, data, bufferSupplier);
        Assertions.assertFalse((boolean)future.isDone());
        ArgumentCaptor capturedAssignment = ArgumentCaptor.forClass(scala.collection.immutable.Map.class);
        ArgumentCaptor capturedCallback = ArgumentCaptor.forClass(Function1.class);
        ((GroupCoordinator)Mockito.verify((Object)groupCoordinator)).handleSyncGroup((String)ArgumentMatchers.eq((Object)data.groupId()), ArgumentMatchers.eq((int)data.generationId()), (String)ArgumentMatchers.eq((Object)data.memberId()), (Option)ArgumentMatchers.eq((Object)new Some((Object)data.protocolType())), (Option)ArgumentMatchers.eq((Object)new Some((Object)data.protocolName())), (Option)ArgumentMatchers.eq((Object)new Some((Object)data.groupInstanceId())), (Map)capturedAssignment.capture(), (Function1)capturedCallback.capture(), (RequestLocal)ArgumentMatchers.eq((Object)new RequestLocal(bufferSupplier)));
        Assertions.assertEquals((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"member1"), (Object)"member1"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"member2"), (Object)"member2")})), (Object)((TraversableLike)capturedAssignment.getValue()).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            if (x0$1 != null) {
                String member = (String)x0$1._1();
                byte[] metadata = (byte[])x0$1._2();
                return new Tuple2((Object)member, (Object)new String(metadata));
            }
            throw new MatchError(null);
        }, Map$.MODULE$.canBuildFrom()));
        Errors x$1 = Errors.NONE;
        Some x$2 = new Some((Object)"consumer");
        Some x$3 = new Some((Object)"range");
        byte[] x$4 = "member1".getBytes();
        ((Function1)capturedCallback.getValue()).apply((Object)new SyncGroupResult((Option)x$2, (Option)x$3, x$4, x$1));
        SyncGroupResponseData expectedResponseData = new SyncGroupResponseData().setErrorCode(Errors.NONE.code()).setProtocolType("consumer").setProtocolName("range").setAssignment("member1".getBytes());
        Assertions.assertTrue((boolean)future.isDone());
        Assertions.assertEquals((Object)expectedResponseData, future.get());
    }

    @Test
    public void testHeartbeat() {
        GroupCoordinator groupCoordinator = (GroupCoordinator)Mockito.mock(GroupCoordinator.class);
        GroupCoordinatorAdapter adapter = new GroupCoordinatorAdapter(groupCoordinator, Time.SYSTEM);
        RequestContext ctx = this.makeContext(ApiKeys.HEARTBEAT, ApiKeys.HEARTBEAT.latestVersion());
        HeartbeatRequestData data = new HeartbeatRequestData().setGroupId("group").setMemberId("member1").setGenerationId(0);
        CompletableFuture future = adapter.heartbeat(ctx, data);
        ArgumentCaptor capturedCallback = ArgumentCaptor.forClass(Function1.class);
        ((GroupCoordinator)Mockito.verify((Object)groupCoordinator)).handleHeartbeat((String)ArgumentMatchers.eq((Object)data.groupId()), (String)ArgumentMatchers.eq((Object)data.memberId()), (Option)ArgumentMatchers.eq((Object)None$.MODULE$), ArgumentMatchers.eq((int)data.generationId()), (Function1)capturedCallback.capture());
        Assertions.assertFalse((boolean)future.isDone());
        ((Function1)capturedCallback.getValue()).apply((Object)Errors.NONE);
        Assertions.assertTrue((boolean)future.isDone());
        Assertions.assertEquals((Object)new HeartbeatResponseData(), future.get());
    }

    public void testLeaveGroup() {
        GroupCoordinator groupCoordinator = (GroupCoordinator)Mockito.mock(GroupCoordinator.class);
        GroupCoordinatorAdapter adapter = new GroupCoordinatorAdapter(groupCoordinator, Time.SYSTEM);
        RequestContext ctx = this.makeContext(ApiKeys.LEAVE_GROUP, ApiKeys.LEAVE_GROUP.latestVersion());
        LeaveGroupRequestData data = new LeaveGroupRequestData().setGroupId("group").setMembers((java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)new LeaveGroupRequestData.MemberIdentity().setMemberId("member-1").setGroupInstanceId("instance-1"), (List)new .colon.colon((Object)new LeaveGroupRequestData.MemberIdentity().setMemberId("member-2").setGroupInstanceId("instance-2"), (List)Nil$.MODULE$))).asJava());
        CompletableFuture future = adapter.leaveGroup(ctx, data);
        ArgumentCaptor capturedCallback = ArgumentCaptor.forClass(Function1.class);
        ((GroupCoordinator)Mockito.verify((Object)groupCoordinator)).handleLeaveGroup((String)ArgumentMatchers.eq((Object)data.groupId()), (List)ArgumentMatchers.eq((Object)((TraversableOnce)CollectionConverters$.MODULE$.asScalaBufferConverter(data.members()).asScala()).toList()), (Function1)capturedCallback.capture());
        Assertions.assertFalse((boolean)future.isDone());
        ((Function1)capturedCallback.getValue()).apply((Object)new LeaveGroupResult(Errors.NONE, (List)new .colon.colon((Object)new LeaveMemberResponse("member-1", (Option)new Some((Object)"instance-1"), Errors.NONE), (List)new .colon.colon((Object)new LeaveMemberResponse("member-2", (Option)new Some((Object)"instance-2"), Errors.NONE), (List)Nil$.MODULE$))));
        LeaveGroupResponseData expectedData = new LeaveGroupResponseData().setMembers((java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)new LeaveGroupResponseData.MemberResponse().setMemberId("member-1").setGroupInstanceId("instance-1"), (List)new .colon.colon((Object)new LeaveGroupResponseData.MemberResponse().setMemberId("member-2").setGroupInstanceId("instance-2"), (List)Nil$.MODULE$))).asJava());
        Assertions.assertTrue((boolean)future.isDone());
        Assertions.assertEquals((Object)expectedData, future.get());
    }

    @Test
    public void testListGroups() {
        this.testListGroups(null, null, (scala.collection.immutable.Set<String>)Predef$.MODULE$.Set().empty(), (scala.collection.immutable.Set<String>)Predef$.MODULE$.Set().empty());
        this.testListGroups((List<String>)Nil$.MODULE$, (List<String>)Nil$.MODULE$, (scala.collection.immutable.Set<String>)Predef$.MODULE$.Set().empty(), (scala.collection.immutable.Set<String>)Predef$.MODULE$.Set().empty());
        this.testListGroups((List<String>)new .colon.colon((Object)"Stable, Empty", (List)Nil$.MODULE$), (List<String>)Nil$.MODULE$, (scala.collection.immutable.Set<String>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Stable, Empty"}))), (scala.collection.immutable.Set<String>)Predef$.MODULE$.Set().empty());
        this.testListGroups((List<String>)Nil$.MODULE$, (List<String>)new .colon.colon((Object)"classic", (List)Nil$.MODULE$), (scala.collection.immutable.Set<String>)Predef$.MODULE$.Set().empty(), (scala.collection.immutable.Set<String>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"classic"}))));
    }

    public void testListGroups(List<String> statesFilter, List<String> typesFilter, scala.collection.immutable.Set<String> expectedStatesFilter, scala.collection.immutable.Set<String> expectedTypesFilter) {
        GroupCoordinator groupCoordinator = (GroupCoordinator)Mockito.mock(GroupCoordinator.class);
        GroupCoordinatorAdapter adapter = new GroupCoordinatorAdapter(groupCoordinator, Time.SYSTEM);
        RequestContext ctx = this.makeContext(ApiKeys.LIST_GROUPS, ApiKeys.LIST_GROUPS.latestVersion());
        ListGroupsRequestData data = new ListGroupsRequestData().setStatesFilter((java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter(statesFilter).asJava()).setTypesFilter((java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter(typesFilter).asJava());
        Mockito.when((Object)groupCoordinator.handleListGroups(expectedStatesFilter, expectedTypesFilter)).thenReturn((Object)new Tuple2((Object)Errors.NOT_COORDINATOR, (Object)new .colon.colon((Object)new GroupOverview("group1", "protocol1", "Stable", "classic"), (List)new .colon.colon((Object)new GroupOverview("group2", "qwerty", "Empty", "classic"), (List)Nil$.MODULE$))));
        CompletableFuture future = adapter.listGroups(ctx, data);
        Assertions.assertTrue((boolean)future.isDone());
        ListGroupsResponseData expectedData = new ListGroupsResponseData().setErrorCode(Errors.NOT_COORDINATOR.code()).setGroups((java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)new ListGroupsResponseData.ListedGroup().setGroupId("group1").setProtocolType("protocol1").setGroupState("Stable").setGroupType("classic"), (List)new .colon.colon((Object)new ListGroupsResponseData.ListedGroup().setGroupId("group2").setProtocolType("qwerty").setGroupState("Empty").setGroupType("classic"), (List)Nil$.MODULE$))).asJava());
        Assertions.assertTrue((boolean)future.isDone());
        Assertions.assertEquals((Object)expectedData, future.get());
    }

    @Test
    public void testDescribeGroup() {
        GroupCoordinator groupCoordinator = (GroupCoordinator)Mockito.mock(GroupCoordinator.class);
        GroupCoordinatorAdapter adapter = new GroupCoordinatorAdapter(groupCoordinator, Time.SYSTEM);
        String groupId1 = "group-1";
        String groupId2 = "group-2";
        GroupSummary groupSummary1 = new GroupSummary("Stable", "consumer", "roundrobin", (List)new .colon.colon((Object)new MemberSummary("memberid", (Option)new Some((Object)"instanceid"), "clientid", "clienthost", "metadata".getBytes(), "assignment".getBytes()), (List)Nil$.MODULE$));
        Mockito.when((Object)groupCoordinator.handleDescribeGroup(groupId1)).thenReturn((Object)new Tuple2((Object)Errors.NONE, (Object)groupSummary1));
        Mockito.when((Object)groupCoordinator.handleDescribeGroup(groupId2)).thenReturn((Object)new Tuple2((Object)Errors.NOT_COORDINATOR, (Object)GroupCoordinator$.MODULE$.EmptyGroup()));
        RequestContext ctx = this.makeContext(ApiKeys.DESCRIBE_GROUPS, ApiKeys.DESCRIBE_GROUPS.latestVersion());
        CompletableFuture future = adapter.describeGroups(ctx, (java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)groupId1, (List)new .colon.colon((Object)groupId2, (List)Nil$.MODULE$))).asJava());
        Assertions.assertTrue((boolean)future.isDone());
        Assertions.assertEquals((Object)((java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)new DescribeGroupsResponseData.DescribedGroup().setGroupId(groupId1).setErrorCode(Errors.NONE.code()).setProtocolType(groupSummary1.protocolType()).setProtocolData(groupSummary1.protocol()).setGroupState(groupSummary1.state()).setMembers((java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)new DescribeGroupsResponseData.DescribedGroupMember().setMemberId(((MemberSummary)groupSummary1.members().head()).memberId()).setGroupInstanceId((String)((MemberSummary)groupSummary1.members().head()).groupInstanceId().orNull(Predef$.MODULE$.$conforms())).setClientId(((MemberSummary)groupSummary1.members().head()).clientId()).setClientHost(((MemberSummary)groupSummary1.members().head()).clientHost()).setMemberMetadata(((MemberSummary)groupSummary1.members().head()).metadata()).setMemberAssignment(((MemberSummary)groupSummary1.members().head()).assignment()), (List)Nil$.MODULE$)).asJava()), (List)new .colon.colon((Object)new DescribeGroupsResponseData.DescribedGroup().setGroupId(groupId2).setErrorCode(Errors.NOT_COORDINATOR.code()), (List)Nil$.MODULE$))).asJava()), future.get());
    }

    @Test
    public void testDeleteGroups() {
        GroupCoordinator groupCoordinator = (GroupCoordinator)Mockito.mock(GroupCoordinator.class);
        GroupCoordinatorAdapter adapter = new GroupCoordinatorAdapter(groupCoordinator, Time.SYSTEM);
        RequestContext ctx = this.makeContext(ApiKeys.DELETE_GROUPS, ApiKeys.DELETE_GROUPS.latestVersion());
        .colon.colon groupIds = new .colon.colon((Object)"group-1", (List)new .colon.colon((Object)"group-2", (List)new .colon.colon((Object)"group-3", (List)Nil$.MODULE$)));
        BufferSupplier bufferSupplier = BufferSupplier.create();
        Mockito.when((Object)groupCoordinator.handleDeleteGroups((Set)groupIds.toSet(), new RequestLocal(bufferSupplier))).thenReturn((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"group-1"), (Object)Errors.NONE), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"group-2"), (Object)Errors.NOT_COORDINATOR), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"group-3"), (Object)Errors.INVALID_GROUP_ID)})));
        CompletableFuture future = adapter.deleteGroups(ctx, (java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)groupIds).asJava(), bufferSupplier);
        Assertions.assertTrue((boolean)future.isDone());
        DeleteGroupsResponseData.DeletableGroupResultCollection expectedResults = new DeleteGroupsResponseData.DeletableGroupResultCollection();
        expectedResults.add((ImplicitLinkedHashCollection.Element)new DeleteGroupsResponseData.DeletableGroupResult().setGroupId("group-1").setErrorCode(Errors.NONE.code()));
        expectedResults.add((ImplicitLinkedHashCollection.Element)new DeleteGroupsResponseData.DeletableGroupResult().setGroupId("group-2").setErrorCode(Errors.NOT_COORDINATOR.code()));
        expectedResults.add((ImplicitLinkedHashCollection.Element)new DeleteGroupsResponseData.DeletableGroupResult().setGroupId("group-3").setErrorCode(Errors.INVALID_GROUP_ID.code()));
        Assertions.assertEquals((Object)expectedResults, future.get());
    }

    @Test
    public void testFetchAllOffsets() {
        TopicPartition foo0 = new TopicPartition("foo", 0);
        TopicPartition foo1 = new TopicPartition("foo", 1);
        TopicPartition bar1 = new TopicPartition("bar", 1);
        GroupCoordinator groupCoordinator = (GroupCoordinator)Mockito.mock(GroupCoordinator.class);
        GroupCoordinatorAdapter adapter = new GroupCoordinatorAdapter(groupCoordinator, Time.SYSTEM);
        Mockito.when((Object)groupCoordinator.handleFetchOffsets("group", true, (Option)None$.MODULE$)).thenReturn((Object)new Tuple2((Object)Errors.NONE, (Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)foo0), (Object)new OffsetFetchResponse.PartitionData(100L, Optional.of(Predef$.MODULE$.int2Integer(1)), "foo", Errors.NONE)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)bar1), (Object)new OffsetFetchResponse.PartitionData(-1L, Optional.empty(), "", Errors.UNKNOWN_TOPIC_OR_PARTITION)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)foo1), (Object)new OffsetFetchResponse.PartitionData(200L, Optional.empty(), "", Errors.NONE))}))));
        RequestContext ctx = this.makeContext(ApiKeys.OFFSET_FETCH, ApiKeys.OFFSET_FETCH.latestVersion());
        CompletableFuture future = adapter.fetchAllOffsets(ctx, new OffsetFetchRequestData.OffsetFetchRequestGroup().setGroupId("group"), true);
        Assertions.assertTrue((boolean)future.isDone());
        .colon.colon expectedResponse = new .colon.colon((Object)new OffsetFetchResponseData.OffsetFetchResponseTopics().setName(foo0.topic()).setPartitions((java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)new OffsetFetchResponseData.OffsetFetchResponsePartitions().setPartitionIndex(foo0.partition()).setCommittedOffset(100L).setCommittedLeaderEpoch(1).setMetadata("foo").setErrorCode(Errors.NONE.code()), (List)new .colon.colon((Object)new OffsetFetchResponseData.OffsetFetchResponsePartitions().setPartitionIndex(foo1.partition()).setCommittedOffset(200L).setCommittedLeaderEpoch(-1).setMetadata("").setErrorCode(Errors.NONE.code()), (List)Nil$.MODULE$))).asJava()), (List)new .colon.colon((Object)new OffsetFetchResponseData.OffsetFetchResponseTopics().setName(bar1.topic()).setPartitions((java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)new OffsetFetchResponseData.OffsetFetchResponsePartitions().setPartitionIndex(bar1.partition()).setCommittedOffset(-1L).setCommittedLeaderEpoch(-1).setMetadata("").setErrorCode(Errors.UNKNOWN_TOPIC_OR_PARTITION.code()), (List)Nil$.MODULE$)).asJava()), (List)Nil$.MODULE$));
        Assertions.assertEquals((Object)"group", (Object)((OffsetFetchResponseData.OffsetFetchResponseGroup)future.get()).groupId());
        Assertions.assertEquals((Object)expectedResponse.sortWith((Function2 & Serializable & scala.Serializable)(x$1, x$2) -> BoxesRunTime.boxToBoolean((boolean)GroupCoordinatorAdapterTest.$anonfun$testFetchAllOffsets$1(x$1, x$2))), (Object)((TraversableOnce)CollectionConverters$.MODULE$.asScalaBufferConverter(((OffsetFetchResponseData.OffsetFetchResponseGroup)future.get()).topics()).asScala()).toList().sortWith((Function2 & Serializable & scala.Serializable)(x$3, x$4) -> BoxesRunTime.boxToBoolean((boolean)GroupCoordinatorAdapterTest.$anonfun$testFetchAllOffsets$2(x$3, x$4))));
    }

    @Test
    public void testFetchOffsets() {
        TopicPartition foo0 = new TopicPartition("foo", 0);
        TopicPartition foo1 = new TopicPartition("foo", 1);
        TopicPartition bar1 = new TopicPartition("bar", 1);
        GroupCoordinator groupCoordinator = (GroupCoordinator)Mockito.mock(GroupCoordinator.class);
        GroupCoordinatorAdapter adapter = new GroupCoordinatorAdapter(groupCoordinator, Time.SYSTEM);
        Mockito.when((Object)groupCoordinator.handleFetchOffsets("group", true, (Option)new Some((Object)new .colon.colon((Object)foo0, (List)new .colon.colon((Object)foo1, (List)new .colon.colon((Object)bar1, (List)Nil$.MODULE$)))))).thenReturn((Object)new Tuple2((Object)Errors.NONE, (Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)foo0), (Object)new OffsetFetchResponse.PartitionData(100L, Optional.of(Predef$.MODULE$.int2Integer(1)), "foo", Errors.NONE)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)bar1), (Object)new OffsetFetchResponse.PartitionData(-1L, Optional.empty(), "", Errors.UNKNOWN_TOPIC_OR_PARTITION)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)foo1), (Object)new OffsetFetchResponse.PartitionData(200L, Optional.empty(), "", Errors.NONE))}))));
        RequestContext ctx = this.makeContext(ApiKeys.OFFSET_FETCH, ApiKeys.OFFSET_FETCH.latestVersion());
        CompletableFuture future = adapter.fetchOffsets(ctx, new OffsetFetchRequestData.OffsetFetchRequestGroup().setGroupId("group").setTopics((java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)new OffsetFetchRequestData.OffsetFetchRequestTopics().setName(foo0.topic()).setPartitionIndexes((java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)Predef$.MODULE$.int2Integer(foo0.partition()), (List)new .colon.colon((Object)Predef$.MODULE$.int2Integer(foo1.partition()), (List)Nil$.MODULE$))).asJava()), (List)new .colon.colon((Object)new OffsetFetchRequestData.OffsetFetchRequestTopics().setName(bar1.topic()).setPartitionIndexes((java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)Predef$.MODULE$.int2Integer(bar1.partition()), (List)Nil$.MODULE$)).asJava()), (List)Nil$.MODULE$))).asJava()), true);
        Assertions.assertTrue((boolean)future.isDone());
        .colon.colon expectedResponse = new .colon.colon((Object)new OffsetFetchResponseData.OffsetFetchResponseTopics().setName(foo0.topic()).setPartitions((java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)new OffsetFetchResponseData.OffsetFetchResponsePartitions().setPartitionIndex(foo0.partition()).setCommittedOffset(100L).setCommittedLeaderEpoch(1).setMetadata("foo").setErrorCode(Errors.NONE.code()), (List)new .colon.colon((Object)new OffsetFetchResponseData.OffsetFetchResponsePartitions().setPartitionIndex(foo1.partition()).setCommittedOffset(200L).setCommittedLeaderEpoch(-1).setMetadata("").setErrorCode(Errors.NONE.code()), (List)Nil$.MODULE$))).asJava()), (List)new .colon.colon((Object)new OffsetFetchResponseData.OffsetFetchResponseTopics().setName(bar1.topic()).setPartitions((java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)new OffsetFetchResponseData.OffsetFetchResponsePartitions().setPartitionIndex(bar1.partition()).setCommittedOffset(-1L).setCommittedLeaderEpoch(-1).setMetadata("").setErrorCode(Errors.UNKNOWN_TOPIC_OR_PARTITION.code()), (List)Nil$.MODULE$)).asJava()), (List)Nil$.MODULE$));
        Assertions.assertEquals((Object)"group", (Object)((OffsetFetchResponseData.OffsetFetchResponseGroup)future.get()).groupId());
        Assertions.assertEquals((Object)expectedResponse.sortWith((Function2 & Serializable & scala.Serializable)(x$5, x$6) -> BoxesRunTime.boxToBoolean((boolean)GroupCoordinatorAdapterTest.$anonfun$testFetchOffsets$1(x$5, x$6))), (Object)((TraversableOnce)CollectionConverters$.MODULE$.asScalaBufferConverter(((OffsetFetchResponseData.OffsetFetchResponseGroup)future.get()).topics()).asScala()).toList().sortWith((Function2 & Serializable & scala.Serializable)(x$7, x$8) -> BoxesRunTime.boxToBoolean((boolean)GroupCoordinatorAdapterTest.$anonfun$testFetchOffsets$2(x$7, x$8))));
    }

    @ParameterizedTest
    @ApiKeyVersionsSource(apiKey=ApiKeys.OFFSET_COMMIT)
    public void testCommitOffsets(short version) {
        GroupCoordinator groupCoordinator = (GroupCoordinator)Mockito.mock(GroupCoordinator.class);
        MockTime time = new MockTime();
        GroupCoordinatorAdapter adapter = new GroupCoordinatorAdapter(groupCoordinator, (Time)time);
        long now = time.milliseconds();
        RequestContext ctx = this.makeContext(ApiKeys.OFFSET_COMMIT, version);
        OffsetCommitRequestData data = new OffsetCommitRequestData().setGroupId("group").setMemberId("member").setGenerationIdOrMemberEpoch(10).setRetentionTimeMs(1000L).setTopics((java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)new OffsetCommitRequestData.OffsetCommitRequestTopic().setName("foo").setPartitions((java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)new OffsetCommitRequestData.OffsetCommitRequestPartition().setPartitionIndex(0).setCommittedOffset(100L).setCommitTimestamp(now).setCommittedLeaderEpoch(1), (List)Nil$.MODULE$)).asJava()), (List)Nil$.MODULE$)).asJava());
        BufferSupplier bufferSupplier = BufferSupplier.create();
        CompletableFuture future = adapter.commitOffsets(ctx, data, bufferSupplier);
        Assertions.assertFalse((boolean)future.isDone());
        ArgumentCaptor capturedCallback = ArgumentCaptor.forClass(Function1.class);
        ((GroupCoordinator)Mockito.verify((Object)groupCoordinator)).handleCommitOffsets((String)ArgumentMatchers.eq((Object)data.groupId()), (String)ArgumentMatchers.eq((Object)data.memberId()), (Option)ArgumentMatchers.eq((Object)None$.MODULE$), ArgumentMatchers.eq((int)data.generationIdOrMemberEpoch()), (scala.collection.immutable.Map)ArgumentMatchers.eq((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicIdPartition(Uuid.ZERO_UUID, 0, "foo")), (Object)new OffsetAndMetadata(100L, Optional.of(Predef$.MODULE$.int2Integer(1)), "", now, (Option)new Some((Object)BoxesRunTime.boxToLong((long)(now + 1000L)))))}))), (Function1)capturedCallback.capture(), (RequestLocal)ArgumentMatchers.eq((Object)new RequestLocal(bufferSupplier)));
        ((Function1)capturedCallback.getValue()).apply((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicIdPartition(Uuid.ZERO_UUID, 0, "foo")), (Object)Errors.NONE)})));
        OffsetCommitResponseData expectedResponseData = new OffsetCommitResponseData().setTopics((java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)new OffsetCommitResponseData.OffsetCommitResponseTopic().setName("foo").setPartitions((java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)new OffsetCommitResponseData.OffsetCommitResponsePartition().setPartitionIndex(0).setErrorCode(Errors.NONE.code()), (List)Nil$.MODULE$)).asJava()), (List)Nil$.MODULE$)).asJava());
        Assertions.assertTrue((boolean)future.isDone());
        Assertions.assertEquals((Object)expectedResponseData, future.get());
    }

    @Test
    public void testCommitTransactionalOffsets() {
        GroupCoordinator groupCoordinator = (GroupCoordinator)Mockito.mock(GroupCoordinator.class);
        MockTime time = new MockTime();
        GroupCoordinatorAdapter adapter = new GroupCoordinatorAdapter(groupCoordinator, (Time)time);
        long now = time.milliseconds();
        RequestContext ctx = this.makeContext(ApiKeys.TXN_OFFSET_COMMIT, ApiKeys.TXN_OFFSET_COMMIT.latestVersion());
        TxnOffsetCommitRequestData data = new TxnOffsetCommitRequestData().setGroupId("group").setMemberId("member").setGenerationId(10).setProducerEpoch((short)1).setProducerId(2L).setTransactionalId("transaction-id").setTopics((java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)new TxnOffsetCommitRequestData.TxnOffsetCommitRequestTopic().setName("foo").setPartitions((java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)new TxnOffsetCommitRequestData.TxnOffsetCommitRequestPartition().setPartitionIndex(0).setCommittedOffset(100L).setCommittedLeaderEpoch(1), (List)Nil$.MODULE$)).asJava()), (List)Nil$.MODULE$)).asJava());
        BufferSupplier bufferSupplier = BufferSupplier.create();
        CompletableFuture future = adapter.commitTransactionalOffsets(ctx, data, bufferSupplier);
        Assertions.assertFalse((boolean)future.isDone());
        ArgumentCaptor capturedCallback = ArgumentCaptor.forClass(Function1.class);
        ((GroupCoordinator)Mockito.verify((Object)groupCoordinator)).handleTxnCommitOffsets((String)ArgumentMatchers.eq((Object)data.groupId()), (String)ArgumentMatchers.eq((Object)data.transactionalId()), ArgumentMatchers.eq((long)data.producerId()), ArgumentMatchers.eq((short)data.producerEpoch()), (String)ArgumentMatchers.eq((Object)data.memberId()), (Option)ArgumentMatchers.eq((Object)None$.MODULE$), ArgumentMatchers.eq((int)data.generationId()), (scala.collection.immutable.Map)ArgumentMatchers.eq((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicIdPartition(Uuid.ZERO_UUID, 0, "foo")), (Object)new OffsetAndMetadata(100L, Optional.of(Predef$.MODULE$.int2Integer(1)), "", now, (Option)None$.MODULE$))}))), (Function1)capturedCallback.capture(), (RequestLocal)ArgumentMatchers.eq((Object)new RequestLocal(bufferSupplier)), BoxesRunTime.unboxToShort((Object)ArgumentMatchers.any()));
        ((Function1)capturedCallback.getValue()).apply((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicIdPartition(Uuid.ZERO_UUID, 0, "foo")), (Object)Errors.NONE)})));
        TxnOffsetCommitResponseData expectedData = new TxnOffsetCommitResponseData().setTopics((java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)new TxnOffsetCommitResponseData.TxnOffsetCommitResponseTopic().setName("foo").setPartitions((java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)new TxnOffsetCommitResponseData.TxnOffsetCommitResponsePartition().setPartitionIndex(0).setErrorCode(Errors.NONE.code()), (List)Nil$.MODULE$)).asJava()), (List)Nil$.MODULE$)).asJava());
        Assertions.assertTrue((boolean)future.isDone());
        Assertions.assertEquals((Object)expectedData, future.get());
    }

    public void testDeleteOffsets() {
        GroupCoordinator groupCoordinator = (GroupCoordinator)Mockito.mock(GroupCoordinator.class);
        GroupCoordinatorAdapter adapter = new GroupCoordinatorAdapter(groupCoordinator, Time.SYSTEM);
        TopicPartition foo0 = new TopicPartition("foo", 0);
        TopicPartition foo1 = new TopicPartition("foo", 1);
        TopicPartition bar0 = new TopicPartition("bar", 0);
        TopicPartition bar1 = new TopicPartition("bar", 1);
        RequestContext ctx = this.makeContext(ApiKeys.OFFSET_DELETE, ApiKeys.OFFSET_DELETE.latestVersion());
        OffsetDeleteRequestData data = new OffsetDeleteRequestData().setGroupId("group").setTopics(new OffsetDeleteRequestData.OffsetDeleteRequestTopicCollection(((java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)new OffsetDeleteRequestData.OffsetDeleteRequestTopic().setName("foo").setPartitions((java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)new OffsetDeleteRequestData.OffsetDeleteRequestPartition().setPartitionIndex(0), (List)new .colon.colon((Object)new OffsetDeleteRequestData.OffsetDeleteRequestPartition().setPartitionIndex(1), (List)Nil$.MODULE$))).asJava()), (List)new .colon.colon((Object)new OffsetDeleteRequestData.OffsetDeleteRequestTopic().setName("bar").setPartitions((java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)new OffsetDeleteRequestData.OffsetDeleteRequestPartition().setPartitionIndex(0), (List)new .colon.colon((Object)new OffsetDeleteRequestData.OffsetDeleteRequestPartition().setPartitionIndex(1), (List)Nil$.MODULE$))).asJava()), (List)Nil$.MODULE$))).asJava()).iterator()));
        BufferSupplier bufferSupplier = BufferSupplier.create();
        Mockito.when((Object)groupCoordinator.handleDeleteOffsets(data.groupId(), (Seq)new .colon.colon((Object)foo0, (List)new .colon.colon((Object)foo1, (List)new .colon.colon((Object)bar0, (List)new .colon.colon((Object)bar1, (List)Nil$.MODULE$)))), new RequestLocal(bufferSupplier))).thenReturn((Object)new Tuple2((Object)Errors.NONE, (Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)foo0), (Object)Errors.NONE), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)foo1), (Object)Errors.NONE), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)bar0), (Object)Errors.GROUP_SUBSCRIBED_TO_TOPIC), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)bar1), (Object)Errors.GROUP_SUBSCRIBED_TO_TOPIC)}))));
        CompletableFuture future = adapter.deleteOffsets(ctx, data, bufferSupplier);
        OffsetDeleteResponseData expectedData = new OffsetDeleteResponseData().setTopics(new OffsetDeleteResponseData.OffsetDeleteResponseTopicCollection(((java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)new OffsetDeleteResponseData.OffsetDeleteResponseTopic().setName("foo").setPartitions(new OffsetDeleteResponseData.OffsetDeleteResponsePartitionCollection(((java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)new OffsetDeleteResponseData.OffsetDeleteResponsePartition().setPartitionIndex(0).setErrorCode(Errors.NONE.code()), (List)new .colon.colon((Object)new OffsetDeleteResponseData.OffsetDeleteResponsePartition().setPartitionIndex(1).setErrorCode(Errors.NONE.code()), (List)Nil$.MODULE$))).asJava()).iterator())), (List)new .colon.colon((Object)new OffsetDeleteResponseData.OffsetDeleteResponseTopic().setName("bar").setPartitions(new OffsetDeleteResponseData.OffsetDeleteResponsePartitionCollection(((java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)new OffsetDeleteResponseData.OffsetDeleteResponsePartition().setPartitionIndex(0).setErrorCode(Errors.GROUP_SUBSCRIBED_TO_TOPIC.code()), (List)new .colon.colon((Object)new OffsetDeleteResponseData.OffsetDeleteResponsePartition().setPartitionIndex(1).setErrorCode(Errors.GROUP_SUBSCRIBED_TO_TOPIC.code()), (List)Nil$.MODULE$))).asJava()).iterator())), (List)Nil$.MODULE$))).asJava()).iterator()));
        Assertions.assertTrue((boolean)future.isDone());
        Assertions.assertEquals((Object)expectedData, future.get());
    }

    @Test
    public void testDeleteOffsetsWithGroupLevelError() {
        GroupCoordinator groupCoordinator = (GroupCoordinator)Mockito.mock(GroupCoordinator.class);
        GroupCoordinatorAdapter adapter = new GroupCoordinatorAdapter(groupCoordinator, Time.SYSTEM);
        TopicPartition foo0 = new TopicPartition("foo", 0);
        TopicPartition foo1 = new TopicPartition("foo", 1);
        RequestContext ctx = this.makeContext(ApiKeys.OFFSET_DELETE, ApiKeys.OFFSET_DELETE.latestVersion());
        OffsetDeleteRequestData data = new OffsetDeleteRequestData().setGroupId("group").setTopics(new OffsetDeleteRequestData.OffsetDeleteRequestTopicCollection(((java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)new OffsetDeleteRequestData.OffsetDeleteRequestTopic().setName("foo").setPartitions((java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)new OffsetDeleteRequestData.OffsetDeleteRequestPartition().setPartitionIndex(0), (List)new .colon.colon((Object)new OffsetDeleteRequestData.OffsetDeleteRequestPartition().setPartitionIndex(1), (List)Nil$.MODULE$))).asJava()), (List)Nil$.MODULE$)).asJava()).iterator()));
        BufferSupplier bufferSupplier = BufferSupplier.create();
        Mockito.when((Object)groupCoordinator.handleDeleteOffsets(data.groupId(), (Seq)new .colon.colon((Object)foo0, (List)new .colon.colon((Object)foo1, (List)Nil$.MODULE$)), new RequestLocal(bufferSupplier))).thenReturn((Object)new Tuple2((Object)Errors.INVALID_GROUP_ID, (Object)Predef$.MODULE$.Map().empty()));
        CompletableFuture future = adapter.deleteOffsets(ctx, data, bufferSupplier);
        Assertions.assertTrue((boolean)future.isDone());
        Assertions.assertTrue((boolean)future.isCompletedExceptionally());
        TestUtils.assertFutureThrows((Future)future, InvalidGroupIdException.class);
    }

    @Test
    public void testConsumerGroupDescribe() {
        GroupCoordinator groupCoordinator = (GroupCoordinator)Mockito.mock(GroupCoordinator.class);
        GroupCoordinatorAdapter adapter = new GroupCoordinatorAdapter(groupCoordinator, Time.SYSTEM);
        RequestContext context = this.makeContext(ApiKeys.CONSUMER_GROUP_DESCRIBE, ApiKeys.CONSUMER_GROUP_DESCRIBE.latestVersion());
        java.util.List groupIds = (java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)"group-id-1", (List)new .colon.colon((Object)"group-id-2", (List)Nil$.MODULE$))).asJava();
        CompletableFuture future = adapter.consumerGroupDescribe(context, groupIds);
        Assertions.assertTrue((boolean)future.isDone());
        Assertions.assertTrue((boolean)future.isCompletedExceptionally());
        TestUtils.assertFutureThrows((Future)future, UnsupportedVersionException.class);
    }

    @Test
    public void testShareGroupDescribe() {
        GroupCoordinator groupCoordinator = (GroupCoordinator)Mockito.mock(GroupCoordinator.class);
        GroupCoordinatorAdapter adapter = new GroupCoordinatorAdapter(groupCoordinator, Time.SYSTEM);
        RequestContext context = this.makeContext(ApiKeys.SHARE_GROUP_DESCRIBE, ApiKeys.SHARE_GROUP_DESCRIBE.latestVersion());
        java.util.List groupIds = (java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)"group-id-1", (List)new .colon.colon((Object)"group-id-2", (List)Nil$.MODULE$))).asJava();
        CompletableFuture future = adapter.shareGroupDescribe(context, groupIds);
        Assertions.assertTrue((boolean)future.isDone());
        Assertions.assertTrue((boolean)future.isCompletedExceptionally());
        TestUtils.assertFutureThrows((Future)future, UnsupportedVersionException.class);
    }

    @Test
    public void testOnTransactionCompletedWithUnexpectedException() {
        GroupCoordinator groupCoordinator = (GroupCoordinator)Mockito.mock(GroupCoordinator.class);
        GroupCoordinatorAdapter adapter = new GroupCoordinatorAdapter(groupCoordinator, Time.SYSTEM);
        Mockito.when((Object)groupCoordinator.scheduleHandleTxnCompletion(BoxesRunTime.unboxToLong((Object)ArgumentMatchers.any()), (Iterable)ArgumentMatchers.any(), (TransactionResult)ArgumentMatchers.any())).thenThrow(new Throwable[]{new IllegalStateException("Oh no!")});
        CompletableFuture future = adapter.onTransactionCompleted(10L, (java.lang.Iterable)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)Nil$.MODULE$).asJava(), TransactionResult.COMMIT);
        Assertions.assertTrue((boolean)future.isDone());
        Assertions.assertTrue((boolean)future.isCompletedExceptionally());
        TestUtils.assertFutureThrows((Future)future, Exception.class);
    }

    public static final /* synthetic */ boolean $anonfun$testFetchAllOffsets$1(OffsetFetchResponseData.OffsetFetchResponseTopics x$1, OffsetFetchResponseData.OffsetFetchResponseTopics x$2) {
        return new StringOps(Predef$.MODULE$.augmentString(x$1.name())).$greater((Object)x$2.name());
    }

    public static final /* synthetic */ boolean $anonfun$testFetchAllOffsets$2(OffsetFetchResponseData.OffsetFetchResponseTopics x$3, OffsetFetchResponseData.OffsetFetchResponseTopics x$4) {
        return new StringOps(Predef$.MODULE$.augmentString(x$3.name())).$greater((Object)x$4.name());
    }

    public static final /* synthetic */ boolean $anonfun$testFetchOffsets$1(OffsetFetchResponseData.OffsetFetchResponseTopics x$5, OffsetFetchResponseData.OffsetFetchResponseTopics x$6) {
        return new StringOps(Predef$.MODULE$.augmentString(x$5.name())).$greater((Object)x$6.name());
    }

    public static final /* synthetic */ boolean $anonfun$testFetchOffsets$2(OffsetFetchResponseData.OffsetFetchResponseTopics x$7, OffsetFetchResponseData.OffsetFetchResponseTopics x$8) {
        return new StringOps(Predef$.MODULE$.augmentString(x$7.name())).$greater((Object)x$8.name());
    }
}

