/*
 * Decompiled with CFR 0.152.
 */
package kafka.coordinator.transaction;

import com.yammer.metrics.core.MetricName;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.function.Supplier;
import kafka.coordinator.transaction.CompleteCommit$;
import kafka.coordinator.transaction.CoordinatorEpochAndTxnMetadata;
import kafka.coordinator.transaction.PrepareCommit$;
import kafka.coordinator.transaction.TransactionMarkerChannelManager;
import kafka.coordinator.transaction.TransactionMarkerChannelManager$;
import kafka.coordinator.transaction.TransactionMetadata;
import kafka.coordinator.transaction.TransactionState;
import kafka.coordinator.transaction.TransactionStateManager;
import kafka.coordinator.transaction.TxnMarkerQueue;
import kafka.coordinator.transaction.TxnTransitMetadata;
import kafka.server.KafkaConfig$;
import kafka.server.MetadataCache;
import kafka.server.RequestLocal;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.ClientResponse;
import org.apache.kafka.clients.NetworkClient;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.AbstractResponse;
import org.apache.kafka.common.requests.RequestHeader;
import org.apache.kafka.common.requests.TransactionResult;
import org.apache.kafka.common.requests.WriteTxnMarkersRequest;
import org.apache.kafka.common.requests.WriteTxnMarkersResponse;
import org.apache.kafka.common.utils.MockTime;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.server.common.MetadataVersion;
import org.apache.kafka.server.metrics.KafkaMetricsGroup;
import org.apache.kafka.server.metrics.KafkaYammerMetrics;
import org.apache.kafka.server.util.RequestAndCompletionHandler;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.MockedConstruction;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.verification.VerificationMode;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Set;
import scala.collection.mutable.Set$;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichLong$;
import scala.runtime.java8.JFunction0;
import scala.util.Either;
import scala.util.Try;
import scala.util.Try$;

@ScalaSignature(bytes="\u0006\u0001\t5b\u0001\u0002!B\u0001!CQa\u0014\u0001\u0005\u0002ACqa\u0015\u0001C\u0002\u0013%A\u000b\u0003\u0004\\\u0001\u0001\u0006I!\u0016\u0005\b9\u0002\u0011\r\u0011\"\u0003^\u0011\u0019I\u0007\u0001)A\u0005=\"9!\u000e\u0001b\u0001\n\u0013Y\u0007BB8\u0001A\u0003%A\u000eC\u0004q\u0001\t\u0007I\u0011B9\t\ra\u0004\u0001\u0015!\u0003s\u0011\u001dI\bA1A\u0005\nEDaA\u001f\u0001!\u0002\u0013\u0011\bbB>\u0001\u0005\u0004%I\u0001 \u0005\b\u0003\u0003\u0001\u0001\u0015!\u0003~\u0011!\t\u0019\u0001\u0001b\u0001\n\u0013a\bbBA\u0003\u0001\u0001\u0006I! \u0005\n\u0003\u000f\u0001!\u0019!C\u0005\u0003\u0013A\u0001\"a\u0007\u0001A\u0003%\u00111\u0002\u0005\n\u0003;\u0001!\u0019!C\u0005\u0003\u0013A\u0001\"a\b\u0001A\u0003%\u00111\u0002\u0005\n\u0003C\u0001!\u0019!C\u0005\u0003GA\u0001\"a\u000b\u0001A\u0003%\u0011Q\u0005\u0005\n\u0003[\u0001!\u0019!C\u0005\u0003GA\u0001\"a\f\u0001A\u0003%\u0011Q\u0005\u0005\n\u0003c\u0001!\u0019!C\u0005\u0003gA\u0001\"a\u000f\u0001A\u0003%\u0011Q\u0007\u0005\n\u0003{\u0001!\u0019!C\u0005\u0003gA\u0001\"a\u0010\u0001A\u0003%\u0011Q\u0007\u0005\n\u0003\u0003\u0002!\u0019!C\u0005\u0003\u0007B\u0001\"a\u0013\u0001A\u0003%\u0011Q\t\u0005\n\u0003\u001b\u0002!\u0019!C\u0005\u0003\u0007B\u0001\"a\u0014\u0001A\u0003%\u0011Q\t\u0005\n\u0003#\u0002!\u0019!C\u0005\u0003\u0007B\u0001\"a\u0015\u0001A\u0003%\u0011Q\t\u0005\n\u0003+\u0002!\u0019!C\u0005\u0003\u0007B\u0001\"a\u0016\u0001A\u0003%\u0011Q\t\u0005\n\u00033\u0002!\u0019!C\u0005\u0003\u0007B\u0001\"a\u0017\u0001A\u0003%\u0011Q\t\u0005\n\u0003;\u0002!\u0019!C\u0005\u0003?B\u0001\"!\u001c\u0001A\u0003%\u0011\u0011\r\u0005\n\u0003_\u0002!\u0019!C\u0005\u0003cB\u0001\"!\u001f\u0001A\u0003%\u00111\u000f\u0005\n\u0003w\u0002!\u0019!C\u0005\u0003cB\u0001\"! \u0001A\u0003%\u00111\u000f\u0005\n\u0003\u007f\u0002!\u0019!C\u0005\u0003\u0003C\u0001\"a*\u0001A\u0003%\u00111\u0011\u0005\n\u0003S\u0003!\u0019!C\u0005\u0003WC\u0001\"!/\u0001A\u0003%\u0011Q\u0016\u0005\n\u0003w\u0003!\u0019!C\u0005\u0003{C\u0001\"!2\u0001A\u0003%\u0011q\u0018\u0005\b\u0003\u000f\u0004A\u0011BAe\u0011\u001d\tY\r\u0001C\u0001\u0003\u0013Dq!a9\u0001\t\u0003\tI\rC\u0004\u0002h\u0002!\t!!3\t\u000f\u0005-\b\u0001\"\u0001\u0002J\"9\u0011q\u001e\u0001\u0005\u0002\u0005%\u0007bBAz\u0001\u0011\u0005\u0011\u0011\u001a\u0005\b\u0003o\u0004A\u0011AAe\u0011\u001d\tY\u0010\u0001C\u0001\u0003\u0013Dq!a@\u0001\t\u0003\tI\rC\u0004\u0003\u0004\u0001!\t!!3\t\u000f\t\u001d\u0001\u0001\"\u0001\u0002J\"9!1\u0002\u0001\u0005\n\t5\u0001b\u0002B\u0015\u0001\u0011\u0005\u0011\u0011\u001a\u0002$)J\fgn]1di&|g.T1sW\u0016\u00148\t[1o]\u0016dW*\u00198bO\u0016\u0014H+Z:u\u0015\t\u00115)A\u0006ue\u0006t7/Y2uS>t'B\u0001#F\u0003-\u0019wn\u001c:eS:\fGo\u001c:\u000b\u0003\u0019\u000bQa[1gW\u0006\u001c\u0001a\u0005\u0002\u0001\u0013B\u0011!*T\u0007\u0002\u0017*\tA*A\u0003tG\u0006d\u0017-\u0003\u0002O\u0017\n1\u0011I\\=SK\u001a\fa\u0001P5oSRtD#A)\u0011\u0005I\u0003Q\"A!\u0002\u001b5,G/\u00193bi\u0006\u001c\u0015m\u00195f+\u0005)\u0006C\u0001,Z\u001b\u00059&B\u0001-F\u0003\u0019\u0019XM\u001d<fe&\u0011!l\u0016\u0002\u000e\u001b\u0016$\u0018\rZ1uC\u000e\u000b7\r[3\u0002\u001d5,G/\u00193bi\u0006\u001c\u0015m\u00195fA\u0005ia.\u001a;x_J\\7\t\\5f]R,\u0012A\u0018\t\u0003?\u001el\u0011\u0001\u0019\u0006\u0003C\n\fqa\u00197jK:$8O\u0003\u0002GG*\u0011A-Z\u0001\u0007CB\f7\r[3\u000b\u0003\u0019\f1a\u001c:h\u0013\tA\u0007MA\u0007OKR<xN]6DY&,g\u000e^\u0001\u000f]\u0016$xo\u001c:l\u00072LWM\u001c;!\u0003=!\bP\\*uCR,W*\u00198bO\u0016\u0014X#\u00017\u0011\u0005Ik\u0017B\u00018B\u0005]!&/\u00198tC\u000e$\u0018n\u001c8Ti\u0006$X-T1oC\u001e,'/\u0001\tuq:\u001cF/\u0019;f\u001b\u0006t\u0017mZ3sA\u0005Q\u0001/\u0019:uSRLwN\\\u0019\u0016\u0003I\u0004\"a\u001d<\u000e\u0003QT!!\u001e2\u0002\r\r|W.\\8o\u0013\t9HO\u0001\bU_BL7\rU1si&$\u0018n\u001c8\u0002\u0017A\f'\u000f^5uS>t\u0017\u0007I\u0001\u000ba\u0006\u0014H/\u001b;j_:\u0014\u0014a\u00039beRLG/[8oe\u0001\nqA\u0019:pW\u0016\u0014\u0018'F\u0001~!\t\u0019h0\u0003\u0002\u0000i\n!aj\u001c3f\u0003!\u0011'o\\6feF\u0002\u0013a\u00022s_.,'OM\u0001\tEJ|7.\u001a:3A\u0005\u0001BO]1og\u0006\u001cG/[8oC2LE-M\u000b\u0003\u0003\u0017\u0001B!!\u0004\u0002\u00185\u0011\u0011q\u0002\u0006\u0005\u0003#\t\u0019\"\u0001\u0003mC:<'BAA\u000b\u0003\u0011Q\u0017M^1\n\t\u0005e\u0011q\u0002\u0002\u0007'R\u0014\u0018N\\4\u0002#Q\u0014\u0018M\\:bGRLwN\\1m\u0013\u0012\f\u0004%\u0001\tue\u0006t7/Y2uS>t\u0017\r\\%ee\u0005\tBO]1og\u0006\u001cG/[8oC2LEM\r\u0011\u0002\u0017A\u0014x\u000eZ;dKJLE-M\u000b\u0003\u0003K\u00012ASA\u0014\u0013\r\tIc\u0013\u0002\u0005\u0019>tw-\u0001\u0007qe>$WoY3s\u0013\u0012\f\u0004%A\u0006qe>$WoY3s\u0013\u0012\u0014\u0014\u0001\u00049s_\u0012,8-\u001a:JIJ\u0002\u0013!\u00049s_\u0012,8-\u001a:Fa>\u001c\u0007.\u0006\u0002\u00026A\u0019!*a\u000e\n\u0007\u0005e2JA\u0003TQ>\u0014H/\u0001\bqe>$WoY3s\u000bB|7\r\u001b\u0011\u0002#1\f7\u000f\u001e)s_\u0012,8-\u001a:Fa>\u001c\u0007.\u0001\nmCN$\bK]8ek\u000e,'/\u00129pG\"\u0004\u0013A\u0005;y]R{\u0007/[2QCJ$\u0018\u000e^5p]F*\"!!\u0012\u0011\u0007)\u000b9%C\u0002\u0002J-\u00131!\u00138u\u0003M!\bP\u001c+pa&\u001c\u0007+\u0019:uSRLwN\\\u0019!\u0003I!\bP\u001c+pa&\u001c\u0007+\u0019:uSRLwN\u001c\u001a\u0002'QDh\u000eV8qS\u000e\u0004\u0016M\u001d;ji&|gN\r\u0011\u0002!\r|wN\u001d3j]\u0006$xN]#q_\u000eD\u0017!E2p_J$\u0017N\\1u_J,\u0005o\\2iA\u0005\t2m\\8sI&t\u0017\r^8s\u000bB|7\r\u001b\u001a\u0002%\r|wN\u001d3j]\u0006$xN]#q_\u000eD'\u0007I\u0001\ribtG+[7f_V$Xj]\u0001\u000eibtG+[7f_V$Xj\u001d\u0011\u0002\u0013QDhNU3tk2$XCAA1!\u0011\t\u0019'!\u001b\u000e\u0005\u0005\u0015$bAA4i\u0006A!/Z9vKN$8/\u0003\u0003\u0002l\u0005\u0015$!\u0005+sC:\u001c\u0018m\u0019;j_:\u0014Vm];mi\u0006QA\u000f\u001f8SKN,H\u000e\u001e\u0011\u0002\u0019QDh.T3uC\u0012\fG/Y\u0019\u0016\u0005\u0005M\u0004c\u0001*\u0002v%\u0019\u0011qO!\u0003'Q\u0013\u0018M\\:bGRLwN\\'fi\u0006$\u0017\r^1\u0002\u001bQDh.T3uC\u0012\fG/Y\u0019!\u00031!\bP\\'fi\u0006$\u0017\r^13\u00035!\bP\\'fi\u0006$\u0017\r^13A\u000512-\u00199ukJ,G-\u0012:s_J\u001c8)\u00197mE\u0006\u001c7.\u0006\u0002\u0002\u0004B1\u0011QQAF\u0003\u001fk!!a\"\u000b\u0007\u0005%U-A\u0004n_\u000e\\\u0017\u000e^8\n\t\u00055\u0015q\u0011\u0002\u000f\u0003J<W/\\3oi\u000e\u000b\u0007\u000f^8s!\u001dQ\u0015\u0011SAK\u0003CK1!a%L\u0005%1UO\\2uS>t\u0017\u0007\u0005\u0003\u0002\u0018\u0006uUBAAM\u0015\r\tY\n^\u0001\taJ|Go\\2pY&!\u0011qTAM\u0005\u0019)%O]8sgB\u0019!*a)\n\u0007\u0005\u00156J\u0001\u0003V]&$\u0018aF2baR,(/\u001a3FeJ|'o]\"bY2\u0014\u0017mY6!\u0003\u0011!\u0018.\\3\u0016\u0005\u00055\u0006\u0003BAX\u0003kk!!!-\u000b\u0007\u0005MF/A\u0003vi&d7/\u0003\u0003\u00028\u0006E&\u0001C'pG.$\u0016.\\3\u0002\u000bQLW.\u001a\u0011\u0002\u001d\rD\u0017M\u001c8fY6\u000bg.Y4feV\u0011\u0011q\u0018\t\u0004%\u0006\u0005\u0017bAAb\u0003\nyBK]1og\u0006\u001cG/[8o\u001b\u0006\u00148.\u001a:DQ\u0006tg.\u001a7NC:\fw-\u001a:\u0002\u001f\rD\u0017M\u001c8fY6\u000bg.Y4fe\u0002\n\u0011\"\\8dW\u000e\u000b7\r[3\u0015\u0005\u0005\u0005\u0016\u0001\u0007;fgR\u0014V-\\8wK6+GO]5dg>s7\t\\8tK\"\u001a1'a4\u0011\t\u0005E\u0017q\\\u0007\u0003\u0003'TA!!6\u0002X\u0006\u0019\u0011\r]5\u000b\t\u0005e\u00171\\\u0001\bUV\u0004\u0018\u000e^3s\u0015\r\ti.Z\u0001\u0006UVt\u0017\u000e^\u0005\u0005\u0003C\f\u0019N\u0001\u0003UKN$\u0018\u0001I:i_VdGm\u00148ms^\u0013\u0018\u000e^3Uq:\u001cu.\u001c9mKRLwN\\(oG\u0016D3\u0001NAh\u0003\r\u001a\bn\\;mI:{G\u000fT8tKRChnQ8na2,G/[8o\u0003\u001a$XM\u001d'pC\u0012D3!NAh\u0003=\u001a\bn\\;mI\u001e+g.\u001a:bi\u0016,U\u000e\u001d;z\u001b\u0006\u0004x\u000b[3o\u001d>\u0014V-];fgR\u001cx*\u001e;ti\u0006tG-\u001b8hQ\r1\u0014qZ\u0001+g\"|W\u000f\u001c3HK:,'/\u0019;f%\u0016\fX/Z:u!\u0016\u0014\b+\u0019:uSRLwN\u001c)fe\n\u0013xn[3sQ\r9\u0014qZ\u0001(g\"|W\u000f\u001c3TW&\u00048+\u001a8e\u001b\u0006\u00148.\u001a:t/\",g\u000eT3bI\u0016\u0014hj\u001c;G_VtG\rK\u00029\u0003\u001f\f!g\u001d5pk2$7+\u0019<f\r>\u0014H*\u0019;fe^CWM\u001c'fC\u0012,'/\u00168l]><hNQ;u\u001d>$\u0018I^1jY\u0006\u0014G.\u001a\u0015\u0004s\u0005=\u0017\u0001O:i_VdGMU3n_Z,W*\u0019:lKJ\u001chi\u001c:Uq:\u0004\u0016M\u001d;ji&|gn\u00165f]B\u000b'\u000f^5uS>tW)\\5he\u0006$X\r\u001a\u0015\u0004u\u0005=\u0017aN:i_VdGmQ8na2,G/Z!qa\u0016tG\rV8M_\u001e|e.\u00128e)btw\u000b[3o'\u0016tG-T1sW\u0016\u00148oU;dG\u0016,G\rK\u0002<\u0003\u001f\fQg\u001d5pk2$\u0017IY8si\u0006\u0003\b/\u001a8e)>dunZ(o\u000b:$G\u000b\u001f8XQ\u0016tgj\u001c;D_>\u0014H-\u001b8bi>\u0014XI\u001d:pe\"\u001aA(a4\u0002}MDw.\u001e7e%\u0016$(/_!qa\u0016tG\rV8M_\u001e|e.\u00128e)btw\u000b[3o\u0007>|'\u000fZ5oCR|'OT8u\u0003Z\f\u0017\u000e\\1cY\u0016,%O]8sQ\ri\u0014qZ\u0001\u0012GJ,\u0017\r^3QS\u0012,%O]8s\u001b\u0006\u0004H\u0003\u0002B\b\u0005K\u0001\u0002B!\u0005\u0003\u0018\tm!qD\u0007\u0003\u0005'QAA!\u0006\u0002\u0014\u0005!Q\u000f^5m\u0013\u0011\u0011IBa\u0005\u0003\u000f!\u000b7\u000f['baB!\u0011Q\u0002B\u000f\u0013\u0011\tI#a\u0004\u0011\u000f\tE!\u0011\u0005:\u0002\u0016&!!1\u0005B\n\u0005\ri\u0015\r\u001d\u0005\b\u0005Oq\u0004\u0019AAK\u0003\u0019)'O]8sg\u0006i2\u000f[8vY\u0012\u001c%/Z1uK6+GO]5dg>s7\u000b^1si&tw\rK\u0002@\u0003\u001f\u0004")
public class TransactionMarkerChannelManagerTest {
    private final MetadataCache metadataCache = (MetadataCache)Mockito.mock(MetadataCache.class);
    private final NetworkClient networkClient = (NetworkClient)Mockito.mock(NetworkClient.class);
    private final TransactionStateManager txnStateManager = (TransactionStateManager)Mockito.mock(TransactionStateManager.class);
    private final TopicPartition partition1 = new TopicPartition("topic1", 0);
    private final TopicPartition partition2 = new TopicPartition("topic1", 1);
    private final Node broker1 = new Node(1, "host", 10);
    private final Node broker2 = new Node(2, "otherhost", 10);
    private final String transactionalId1;
    private final String transactionalId2;
    private final long producerId1;
    private final long producerId2;
    private final short producerEpoch = (short)0;
    private final short lastProducerEpoch = (short)-1;
    private final int txnTopicPartition1;
    private final int txnTopicPartition2;
    private final int coordinatorEpoch;
    private final int coordinatorEpoch2;
    private final int txnTimeoutMs;
    private final TransactionResult txnResult = TransactionResult.COMMIT;
    private final TransactionMetadata txnMetadata1 = new TransactionMetadata(this.transactionalId1(), this.producerId1(), this.producerId1(), this.producerEpoch(), this.lastProducerEpoch(), this.txnTimeoutMs(), (TransactionState)PrepareCommit$.MODULE$, (Set)Set$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.partition1(), this.partition2()})), 0L, 0L);
    private final TransactionMetadata txnMetadata2 = new TransactionMetadata(this.transactionalId2(), this.producerId2(), this.producerId2(), this.producerEpoch(), this.lastProducerEpoch(), this.txnTimeoutMs(), (TransactionState)PrepareCommit$.MODULE$, (Set)Set$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.partition1()})), 0L, 0L);
    private final ArgumentCaptor<Function1<Errors, BoxedUnit>> capturedErrorsCallback = ArgumentCaptor.forClass(Function1.class);
    private final MockTime time = new MockTime();
    private final TransactionMarkerChannelManager channelManager = new TransactionMarkerChannelManager(KafkaConfig$.MODULE$.fromProps(TestUtils$.MODULE$.createBrokerConfig(1, "localhost:2181", TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18(), TestUtils$.MODULE$.createBrokerConfig$default$19(), TestUtils$.MODULE$.createBrokerConfig$default$20(), TestUtils$.MODULE$.createBrokerConfig$default$21())), this.metadataCache(), this.networkClient(), this.txnStateManager(), (Time)this.time());

    private MetadataCache metadataCache() {
        return this.metadataCache;
    }

    private NetworkClient networkClient() {
        return this.networkClient;
    }

    private TransactionStateManager txnStateManager() {
        return this.txnStateManager;
    }

    private TopicPartition partition1() {
        return this.partition1;
    }

    private TopicPartition partition2() {
        return this.partition2;
    }

    private Node broker1() {
        return this.broker1;
    }

    private Node broker2() {
        return this.broker2;
    }

    private String transactionalId1() {
        return this.transactionalId1;
    }

    private String transactionalId2() {
        return this.transactionalId2;
    }

    private long producerId1() {
        return this.producerId1;
    }

    private long producerId2() {
        return this.producerId2;
    }

    private short producerEpoch() {
        return this.producerEpoch;
    }

    private short lastProducerEpoch() {
        return this.lastProducerEpoch;
    }

    private int txnTopicPartition1() {
        return this.txnTopicPartition1;
    }

    private int txnTopicPartition2() {
        return this.txnTopicPartition2;
    }

    private int coordinatorEpoch() {
        return this.coordinatorEpoch;
    }

    private int coordinatorEpoch2() {
        return this.coordinatorEpoch2;
    }

    private int txnTimeoutMs() {
        return this.txnTimeoutMs;
    }

    private TransactionResult txnResult() {
        return this.txnResult;
    }

    private TransactionMetadata txnMetadata1() {
        return this.txnMetadata1;
    }

    private TransactionMetadata txnMetadata2() {
        return this.txnMetadata2;
    }

    private ArgumentCaptor<Function1<Errors, BoxedUnit>> capturedErrorsCallback() {
        return this.capturedErrorsCallback;
    }

    private MockTime time() {
        return this.time;
    }

    private TransactionMarkerChannelManager channelManager() {
        return this.channelManager;
    }

    private void mockCache() {
        Mockito.when((Object)BoxesRunTime.boxToInteger((int)this.txnStateManager().partitionFor(this.transactionalId1()))).thenReturn((Object)BoxesRunTime.boxToInteger((int)this.txnTopicPartition1()));
        Mockito.when((Object)BoxesRunTime.boxToInteger((int)this.txnStateManager().partitionFor(this.transactionalId2()))).thenReturn((Object)BoxesRunTime.boxToInteger((int)this.txnTopicPartition2()));
        Mockito.when((Object)this.txnStateManager().getTransactionState((String)ArgumentMatchers.eq((Object)this.transactionalId1()))).thenReturn((Object)package$.MODULE$.Right().apply((Object)new Some((Object)new CoordinatorEpochAndTxnMetadata(this.coordinatorEpoch(), this.txnMetadata1()))));
        Mockito.when((Object)this.txnStateManager().getTransactionState((String)ArgumentMatchers.eq((Object)this.transactionalId2()))).thenReturn((Object)package$.MODULE$.Right().apply((Object)new Some((Object)new CoordinatorEpochAndTxnMetadata(this.coordinatorEpoch(), this.txnMetadata2()))));
        Mockito.when((Object)this.metadataCache().metadataVersion()).thenReturn((Object)MetadataVersion.latestProduction());
    }

    @Test
    public void testRemoveMetricsOnClose() {
        try (MockedConstruction mockMetricsGroupCtor = Mockito.mockConstruction(KafkaMetricsGroup.class);){
            new TransactionMarkerChannelManager(KafkaConfig$.MODULE$.fromProps(TestUtils$.MODULE$.createBrokerConfig(1, "localhost:2181", TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18(), TestUtils$.MODULE$.createBrokerConfig$default$19(), TestUtils$.MODULE$.createBrokerConfig$default$20(), TestUtils$.MODULE$.createBrokerConfig$default$21())), this.metadataCache(), this.networkClient(), this.txnStateManager(), (Time)this.time()).shutdown();
            KafkaMetricsGroup mockMetricsGroup = (KafkaMetricsGroup)mockMetricsGroupCtor.constructed().get(0);
            TransactionMarkerChannelManager$.MODULE$.MetricNames().foreach((Function1 & Serializable & scala.Serializable)metricName -> ((KafkaMetricsGroup)Mockito.verify((Object)mockMetricsGroup)).newGauge((String)ArgumentMatchers.eq((Object)metricName), (Supplier)ArgumentMatchers.any()));
            TransactionMarkerChannelManager$.MODULE$.MetricNames().foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
                TransactionMarkerChannelManagerTest.$anonfun$testRemoveMetricsOnClose$2(mockMetricsGroup, x$1);
                return BoxedUnit.UNIT;
            });
            Mockito.verifyNoMoreInteractions((Object[])new Object[]{mockMetricsGroup});
        }
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void shouldOnlyWriteTxnCompletionOnce() {
        Future<Try> addMarkerFuture;
        this.mockCache();
        TxnTransitMetadata expectedTransition = this.txnMetadata2().prepareComplete(this.time().milliseconds());
        Mockito.when((Object)this.metadataCache().getPartitionLeaderEndpoint((String)ArgumentMatchers.eq((Object)this.partition1().topic()), ArgumentMatchers.eq((int)this.partition1().partition()), (ListenerName)ArgumentMatchers.any())).thenReturn((Object)new Some((Object)this.broker1()));
        this.txnStateManager().appendTransactionToLog((String)ArgumentMatchers.eq((Object)this.transactionalId2()), ArgumentMatchers.eq((int)this.coordinatorEpoch()), (TxnTransitMetadata)ArgumentMatchers.eq((Object)expectedTransition), (Function1)this.capturedErrorsCallback().capture(), (Function1)ArgumentMatchers.any(), (RequestLocal)ArgumentMatchers.any());
        Mockito.when((Object)BoxedUnit.UNIT).thenAnswer(x$2 -> {
            TransactionMarkerChannelManagerTest.$anonfun$shouldOnlyWriteTxnCompletionOnce$1(this, expectedTransition, x$2);
            return BoxedUnit.UNIT;
        });
        ExecutorService executor = Executors.newFixedThreadPool(1);
        this.txnMetadata2().lock().lock();
        try {
            addMarkerFuture = executor.submit(() -> Try$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.channelManager().addTxnMarkersToSend(this.coordinatorEpoch(), this.txnResult(), this.txnMetadata2(), expectedTransition)));
            RequestHeader header = new RequestHeader(ApiKeys.WRITE_TXN_MARKERS, 0, "client", 1);
            WriteTxnMarkersResponse response = new WriteTxnMarkersResponse(Collections.singletonMap(Predef$.MODULE$.long2Long(this.producerId2()), Collections.singletonMap(this.partition1(), Errors.NONE)));
            ClientResponse clientResponse = new ClientResponse(header, null, null, this.time().milliseconds(), this.time().milliseconds(), false, null, null, (AbstractResponse)response);
            long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
            long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
            if (TestUtils$.MODULE$ == null) {
                throw null;
            }
            long waitUntilTrue_startTime = System.currentTimeMillis();
            while (!TransactionMarkerChannelManagerTest.$anonfun$shouldOnlyWriteTxnCompletionOnce$4(this, clientResponse)) {
                void waitUntilTrue_pause;
                void waitUntilTrue_waitTimeMs;
                if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                    Assertions.fail((String)TransactionMarkerChannelManagerTest.$anonfun$shouldOnlyWriteTxnCompletionOnce$5());
                }
                Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
            }
        }
        finally {
            this.txnMetadata2().lock().unlock();
            executor.shutdown();
        }
        Assertions.assertNotNull(addMarkerFuture);
        Assertions.assertTrue((boolean)addMarkerFuture.get().isSuccess(), (String)new StringBuilder(38).append("Add marker task failed with exception ").append(addMarkerFuture.get().get()).toString());
        ((TransactionStateManager)Mockito.verify((Object)this.txnStateManager())).appendTransactionToLog((String)ArgumentMatchers.eq((Object)this.transactionalId2()), ArgumentMatchers.eq((int)this.coordinatorEpoch()), (TxnTransitMetadata)ArgumentMatchers.eq((Object)expectedTransition), (Function1)this.capturedErrorsCallback().capture(), (Function1)ArgumentMatchers.any(), (RequestLocal)ArgumentMatchers.any());
    }

    @Test
    public void shouldNotLoseTxnCompletionAfterLoad() {
        this.mockCache();
        TxnTransitMetadata expectedTransition = this.txnMetadata2().prepareComplete(this.time().milliseconds());
        Mockito.when((Object)this.metadataCache().getPartitionLeaderEndpoint((String)ArgumentMatchers.eq((Object)this.partition1().topic()), ArgumentMatchers.eq((int)this.partition1().partition()), (ListenerName)ArgumentMatchers.any())).thenReturn((Object)new Some((Object)this.broker1()));
        RequestHeader header = new RequestHeader(ApiKeys.WRITE_TXN_MARKERS, 0, "client", 1);
        WriteTxnMarkersResponse successfulResponse = new WriteTxnMarkersResponse(Collections.singletonMap(Predef$.MODULE$.long2Long(this.producerId2()), Collections.singletonMap(this.partition1(), Errors.NONE)));
        ClientResponse successfulClientResponse = new ClientResponse(header, null, null, this.time().milliseconds(), this.time().milliseconds(), false, null, null, (AbstractResponse)successfulResponse);
        ClientResponse disconnectedClientResponse = new ClientResponse(header, null, null, this.time().milliseconds(), this.time().milliseconds(), true, null, null, null);
        .colon.colon clientResponses = new .colon.colon((Object)successfulClientResponse, (List)new .colon.colon((Object)disconnectedClientResponse, (List)Nil$.MODULE$));
        .colon.colon getTransactionStateResponses = new .colon.colon((Object)package$.MODULE$.Left().apply((Object)Errors.NOT_COORDINATOR), (List)new .colon.colon((Object)package$.MODULE$.Left().apply((Object)Errors.COORDINATOR_LOAD_IN_PROGRESS), (List)new .colon.colon((Object)package$.MODULE$.Right().apply((Object)new Some((Object)new CoordinatorEpochAndTxnMetadata(this.coordinatorEpoch2(), this.txnMetadata2()))), (List)Nil$.MODULE$)));
        clientResponses.foreach(arg_0 -> TransactionMarkerChannelManagerTest.$anonfun$shouldNotLoseTxnCompletionAfterLoad$1$adapted(this, (Seq)getTransactionStateResponses, expectedTransition, successfulClientResponse, arg_0));
    }

    @Test
    public void shouldGenerateEmptyMapWhenNoRequestsOutstanding() {
        Assertions.assertTrue((boolean)this.channelManager().generateRequests().isEmpty());
    }

    @Test
    public void shouldGenerateRequestPerPartitionPerBroker() {
        this.mockCache();
        Mockito.when((Object)this.metadataCache().getPartitionLeaderEndpoint((String)ArgumentMatchers.eq((Object)this.partition1().topic()), ArgumentMatchers.eq((int)this.partition1().partition()), (ListenerName)ArgumentMatchers.any())).thenReturn((Object)new Some((Object)this.broker1()));
        Mockito.when((Object)this.metadataCache().getPartitionLeaderEndpoint((String)ArgumentMatchers.eq((Object)this.partition2().topic()), ArgumentMatchers.eq((int)this.partition2().partition()), (ListenerName)ArgumentMatchers.any())).thenReturn((Object)new Some((Object)this.broker2()));
        this.channelManager().addTxnMarkersToSend(this.coordinatorEpoch(), this.txnResult(), this.txnMetadata1(), this.txnMetadata1().prepareComplete(this.time().milliseconds()));
        this.channelManager().addTxnMarkersToSend(this.coordinatorEpoch(), this.txnResult(), this.txnMetadata2(), this.txnMetadata2().prepareComplete(this.time().milliseconds()));
        Assertions.assertEquals((int)2, (int)this.channelManager().numTxnsWithPendingMarkers());
        Assertions.assertEquals((int)2, (int)((TxnMarkerQueue)this.channelManager().queueForBroker(this.broker1().id()).get()).totalNumMarkers());
        Assertions.assertEquals((int)1, (int)((TxnMarkerQueue)this.channelManager().queueForBroker(this.broker1().id()).get()).totalNumMarkers(this.txnTopicPartition1()));
        Assertions.assertEquals((int)1, (int)((TxnMarkerQueue)this.channelManager().queueForBroker(this.broker1().id()).get()).totalNumMarkers(this.txnTopicPartition2()));
        Assertions.assertEquals((int)1, (int)((TxnMarkerQueue)this.channelManager().queueForBroker(this.broker2().id()).get()).totalNumMarkers());
        Assertions.assertEquals((int)1, (int)((TxnMarkerQueue)this.channelManager().queueForBroker(this.broker2().id()).get()).totalNumMarkers(this.txnTopicPartition1()));
        Assertions.assertEquals((int)0, (int)((TxnMarkerQueue)this.channelManager().queueForBroker(this.broker2().id()).get()).totalNumMarkers(this.txnTopicPartition2()));
        WriteTxnMarkersRequest expectedBroker1Request = (WriteTxnMarkersRequest)new WriteTxnMarkersRequest.Builder(ApiKeys.WRITE_TXN_MARKERS.latestVersion(), Arrays.asList((Object[])new WriteTxnMarkersRequest.TxnMarkerEntry[]{new WriteTxnMarkersRequest.TxnMarkerEntry(this.producerId1(), this.producerEpoch(), this.coordinatorEpoch(), this.txnResult(), Arrays.asList((Object[])new TopicPartition[]{this.partition1()})), new WriteTxnMarkersRequest.TxnMarkerEntry(this.producerId2(), this.producerEpoch(), this.coordinatorEpoch(), this.txnResult(), Arrays.asList((Object[])new TopicPartition[]{this.partition1()}))})).build();
        WriteTxnMarkersRequest expectedBroker2Request = (WriteTxnMarkersRequest)new WriteTxnMarkersRequest.Builder(ApiKeys.WRITE_TXN_MARKERS.latestVersion(), Arrays.asList((Object[])new WriteTxnMarkersRequest.TxnMarkerEntry[]{new WriteTxnMarkersRequest.TxnMarkerEntry(this.producerId1(), this.producerEpoch(), this.coordinatorEpoch(), this.txnResult(), Arrays.asList((Object[])new TopicPartition[]{this.partition2()}))})).build();
        scala.collection.immutable.Map requests = ((TraversableOnce)((TraversableLike)CollectionConverters$.MODULE$.collectionAsScalaIterableConverter(this.channelManager().generateRequests()).asScala()).map((Function1 & Serializable & scala.Serializable)handler -> new Tuple2((Object)handler.destination, (Object)((WriteTxnMarkersRequest.Builder)handler.request).build()), Iterable$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        Assertions.assertEquals((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.broker1()), (Object)expectedBroker1Request), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.broker2()), (Object)expectedBroker2Request)})), (Object)requests);
        Assertions.assertTrue((boolean)this.channelManager().generateRequests().isEmpty());
    }

    @Test
    public void shouldSkipSendMarkersWhenLeaderNotFound() {
        this.mockCache();
        Mockito.when((Object)this.metadataCache().getPartitionLeaderEndpoint((String)ArgumentMatchers.eq((Object)this.partition1().topic()), ArgumentMatchers.eq((int)this.partition1().partition()), (ListenerName)ArgumentMatchers.any())).thenReturn((Object)None$.MODULE$);
        Mockito.when((Object)this.metadataCache().getPartitionLeaderEndpoint((String)ArgumentMatchers.eq((Object)this.partition2().topic()), ArgumentMatchers.eq((int)this.partition2().partition()), (ListenerName)ArgumentMatchers.any())).thenReturn((Object)new Some((Object)this.broker2()));
        this.channelManager().addTxnMarkersToSend(this.coordinatorEpoch(), this.txnResult(), this.txnMetadata1(), this.txnMetadata1().prepareComplete(this.time().milliseconds()));
        Assertions.assertEquals((int)1, (int)this.channelManager().numTxnsWithPendingMarkers());
        Assertions.assertEquals((int)1, (int)((TxnMarkerQueue)this.channelManager().queueForBroker(this.broker2().id()).get()).totalNumMarkers());
        Assertions.assertTrue((boolean)this.channelManager().queueForBroker(this.broker1().id()).isEmpty());
        Assertions.assertEquals((int)1, (int)((TxnMarkerQueue)this.channelManager().queueForBroker(this.broker2().id()).get()).totalNumMarkers(this.txnTopicPartition1()));
        Assertions.assertEquals((int)0, (int)((TxnMarkerQueue)this.channelManager().queueForBroker(this.broker2().id()).get()).totalNumMarkers(this.txnTopicPartition2()));
    }

    @Test
    public void shouldSaveForLaterWhenLeaderUnknownButNotAvailable() {
        this.mockCache();
        Mockito.when((Object)this.metadataCache().getPartitionLeaderEndpoint((String)ArgumentMatchers.eq((Object)this.partition1().topic()), ArgumentMatchers.eq((int)this.partition1().partition()), (ListenerName)ArgumentMatchers.any())).thenReturn((Object)new Some((Object)Node.noNode())).thenReturn((Object)new Some((Object)Node.noNode())).thenReturn((Object)new Some((Object)Node.noNode())).thenReturn((Object)new Some((Object)Node.noNode())).thenReturn((Object)new Some((Object)this.broker1())).thenReturn((Object)new Some((Object)this.broker1()));
        Mockito.when((Object)this.metadataCache().getPartitionLeaderEndpoint((String)ArgumentMatchers.eq((Object)this.partition2().topic()), ArgumentMatchers.eq((int)this.partition2().partition()), (ListenerName)ArgumentMatchers.any())).thenReturn((Object)new Some((Object)this.broker2()));
        this.channelManager().addTxnMarkersToSend(this.coordinatorEpoch(), this.txnResult(), this.txnMetadata1(), this.txnMetadata1().prepareComplete(this.time().milliseconds()));
        this.channelManager().addTxnMarkersToSend(this.coordinatorEpoch(), this.txnResult(), this.txnMetadata2(), this.txnMetadata2().prepareComplete(this.time().milliseconds()));
        Assertions.assertEquals((int)2, (int)this.channelManager().numTxnsWithPendingMarkers());
        Assertions.assertEquals((int)1, (int)((TxnMarkerQueue)this.channelManager().queueForBroker(this.broker2().id()).get()).totalNumMarkers());
        Assertions.assertTrue((boolean)this.channelManager().queueForBroker(this.broker1().id()).isEmpty());
        Assertions.assertEquals((int)1, (int)((TxnMarkerQueue)this.channelManager().queueForBroker(this.broker2().id()).get()).totalNumMarkers(this.txnTopicPartition1()));
        Assertions.assertEquals((int)0, (int)((TxnMarkerQueue)this.channelManager().queueForBroker(this.broker2().id()).get()).totalNumMarkers(this.txnTopicPartition2()));
        Assertions.assertEquals((int)2, (int)this.channelManager().queueForUnknownBroker().totalNumMarkers());
        Assertions.assertEquals((int)1, (int)this.channelManager().queueForUnknownBroker().totalNumMarkers(this.txnTopicPartition1()));
        Assertions.assertEquals((int)1, (int)this.channelManager().queueForUnknownBroker().totalNumMarkers(this.txnTopicPartition2()));
        WriteTxnMarkersRequest expectedBroker1Request = (WriteTxnMarkersRequest)new WriteTxnMarkersRequest.Builder(ApiKeys.WRITE_TXN_MARKERS.latestVersion(), Arrays.asList((Object[])new WriteTxnMarkersRequest.TxnMarkerEntry[]{new WriteTxnMarkersRequest.TxnMarkerEntry(this.producerId1(), this.producerEpoch(), this.coordinatorEpoch(), this.txnResult(), Arrays.asList((Object[])new TopicPartition[]{this.partition1()})), new WriteTxnMarkersRequest.TxnMarkerEntry(this.producerId2(), this.producerEpoch(), this.coordinatorEpoch(), this.txnResult(), Arrays.asList((Object[])new TopicPartition[]{this.partition1()}))})).build();
        WriteTxnMarkersRequest expectedBroker2Request = (WriteTxnMarkersRequest)new WriteTxnMarkersRequest.Builder(ApiKeys.WRITE_TXN_MARKERS.latestVersion(), Arrays.asList((Object[])new WriteTxnMarkersRequest.TxnMarkerEntry[]{new WriteTxnMarkersRequest.TxnMarkerEntry(this.producerId1(), this.producerEpoch(), this.coordinatorEpoch(), this.txnResult(), Arrays.asList((Object[])new TopicPartition[]{this.partition2()}))})).build();
        scala.collection.immutable.Map firstDrainedRequests = ((TraversableOnce)((TraversableLike)CollectionConverters$.MODULE$.collectionAsScalaIterableConverter(this.channelManager().generateRequests()).asScala()).map((Function1 & Serializable & scala.Serializable)handler -> new Tuple2((Object)handler.destination, (Object)((WriteTxnMarkersRequest.Builder)handler.request).build()), Iterable$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        Assertions.assertEquals((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.broker2()), (Object)expectedBroker2Request)})), (Object)firstDrainedRequests);
        scala.collection.immutable.Map secondDrainedRequests = ((TraversableOnce)((TraversableLike)CollectionConverters$.MODULE$.collectionAsScalaIterableConverter(this.channelManager().generateRequests()).asScala()).map((Function1 & Serializable & scala.Serializable)handler -> new Tuple2((Object)handler.destination, (Object)((WriteTxnMarkersRequest.Builder)handler.request).build()), Iterable$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        Assertions.assertEquals((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.broker1()), (Object)expectedBroker1Request)})), (Object)secondDrainedRequests);
    }

    @Test
    public void shouldRemoveMarkersForTxnPartitionWhenPartitionEmigrated() {
        this.mockCache();
        Mockito.when((Object)this.metadataCache().getPartitionLeaderEndpoint((String)ArgumentMatchers.eq((Object)this.partition1().topic()), ArgumentMatchers.eq((int)this.partition1().partition()), (ListenerName)ArgumentMatchers.any())).thenReturn((Object)new Some((Object)this.broker1()));
        Mockito.when((Object)this.metadataCache().getPartitionLeaderEndpoint((String)ArgumentMatchers.eq((Object)this.partition2().topic()), ArgumentMatchers.eq((int)this.partition2().partition()), (ListenerName)ArgumentMatchers.any())).thenReturn((Object)new Some((Object)this.broker2()));
        this.channelManager().addTxnMarkersToSend(this.coordinatorEpoch(), this.txnResult(), this.txnMetadata1(), this.txnMetadata1().prepareComplete(this.time().milliseconds()));
        this.channelManager().addTxnMarkersToSend(this.coordinatorEpoch(), this.txnResult(), this.txnMetadata2(), this.txnMetadata2().prepareComplete(this.time().milliseconds()));
        Assertions.assertEquals((int)2, (int)this.channelManager().numTxnsWithPendingMarkers());
        Assertions.assertEquals((int)2, (int)((TxnMarkerQueue)this.channelManager().queueForBroker(this.broker1().id()).get()).totalNumMarkers());
        Assertions.assertEquals((int)1, (int)((TxnMarkerQueue)this.channelManager().queueForBroker(this.broker1().id()).get()).totalNumMarkers(this.txnTopicPartition1()));
        Assertions.assertEquals((int)1, (int)((TxnMarkerQueue)this.channelManager().queueForBroker(this.broker1().id()).get()).totalNumMarkers(this.txnTopicPartition2()));
        Assertions.assertEquals((int)1, (int)((TxnMarkerQueue)this.channelManager().queueForBroker(this.broker2().id()).get()).totalNumMarkers());
        Assertions.assertEquals((int)1, (int)((TxnMarkerQueue)this.channelManager().queueForBroker(this.broker2().id()).get()).totalNumMarkers(this.txnTopicPartition1()));
        Assertions.assertEquals((int)0, (int)((TxnMarkerQueue)this.channelManager().queueForBroker(this.broker2().id()).get()).totalNumMarkers(this.txnTopicPartition2()));
        this.channelManager().removeMarkersForTxnTopicPartition(this.txnTopicPartition1());
        Assertions.assertEquals((int)1, (int)this.channelManager().numTxnsWithPendingMarkers());
        Assertions.assertEquals((int)1, (int)((TxnMarkerQueue)this.channelManager().queueForBroker(this.broker1().id()).get()).totalNumMarkers());
        Assertions.assertEquals((int)0, (int)((TxnMarkerQueue)this.channelManager().queueForBroker(this.broker1().id()).get()).totalNumMarkers(this.txnTopicPartition1()));
        Assertions.assertEquals((int)1, (int)((TxnMarkerQueue)this.channelManager().queueForBroker(this.broker1().id()).get()).totalNumMarkers(this.txnTopicPartition2()));
        Assertions.assertEquals((int)0, (int)((TxnMarkerQueue)this.channelManager().queueForBroker(this.broker2().id()).get()).totalNumMarkers());
        Assertions.assertEquals((int)0, (int)((TxnMarkerQueue)this.channelManager().queueForBroker(this.broker2().id()).get()).totalNumMarkers(this.txnTopicPartition1()));
        Assertions.assertEquals((int)0, (int)((TxnMarkerQueue)this.channelManager().queueForBroker(this.broker2().id()).get()).totalNumMarkers(this.txnTopicPartition2()));
    }

    @Test
    public void shouldCompleteAppendToLogOnEndTxnWhenSendMarkersSucceed() {
        this.mockCache();
        Mockito.when((Object)this.metadataCache().getPartitionLeaderEndpoint((String)ArgumentMatchers.eq((Object)this.partition1().topic()), ArgumentMatchers.eq((int)this.partition1().partition()), (ListenerName)ArgumentMatchers.any())).thenReturn((Object)new Some((Object)this.broker1()));
        Mockito.when((Object)this.metadataCache().getPartitionLeaderEndpoint((String)ArgumentMatchers.eq((Object)this.partition2().topic()), ArgumentMatchers.eq((int)this.partition2().partition()), (ListenerName)ArgumentMatchers.any())).thenReturn((Object)new Some((Object)this.broker2()));
        TxnTransitMetadata txnTransitionMetadata2 = this.txnMetadata2().prepareComplete(this.time().milliseconds());
        this.txnStateManager().appendTransactionToLog((String)ArgumentMatchers.eq((Object)this.transactionalId2()), ArgumentMatchers.eq((int)this.coordinatorEpoch()), (TxnTransitMetadata)ArgumentMatchers.eq((Object)txnTransitionMetadata2), (Function1)this.capturedErrorsCallback().capture(), (Function1)ArgumentMatchers.any(), (RequestLocal)ArgumentMatchers.any());
        Mockito.when((Object)BoxedUnit.UNIT).thenAnswer(x$3 -> {
            TransactionMarkerChannelManagerTest.$anonfun$shouldCompleteAppendToLogOnEndTxnWhenSendMarkersSucceed$1(this, txnTransitionMetadata2, x$3);
            return BoxedUnit.UNIT;
        });
        this.channelManager().addTxnMarkersToSend(this.coordinatorEpoch(), this.txnResult(), this.txnMetadata2(), txnTransitionMetadata2);
        Iterable requestAndHandlers = (Iterable)CollectionConverters$.MODULE$.collectionAsScalaIterableConverter(this.channelManager().generateRequests()).asScala();
        WriteTxnMarkersResponse response = new WriteTxnMarkersResponse(this.createPidErrorMap(Errors.NONE));
        requestAndHandlers.foreach((Function1 & Serializable & scala.Serializable)requestAndHandler -> {
            requestAndHandler.handler.onComplete(new ClientResponse(new RequestHeader(ApiKeys.WRITE_TXN_MARKERS, 0, "client", 1), null, null, 0L, 0L, false, null, null, (AbstractResponse)response));
            return BoxedUnit.UNIT;
        });
        ((TransactionStateManager)Mockito.verify((Object)this.txnStateManager())).appendTransactionToLog((String)ArgumentMatchers.eq((Object)this.transactionalId2()), ArgumentMatchers.eq((int)this.coordinatorEpoch()), (TxnTransitMetadata)ArgumentMatchers.eq((Object)txnTransitionMetadata2), (Function1)this.capturedErrorsCallback().capture(), (Function1)ArgumentMatchers.any(), (RequestLocal)ArgumentMatchers.any());
        Assertions.assertEquals((int)0, (int)this.channelManager().numTxnsWithPendingMarkers());
        Assertions.assertEquals((int)0, (int)((TxnMarkerQueue)this.channelManager().queueForBroker(this.broker1().id()).get()).totalNumMarkers());
        Assertions.assertEquals((Object)None$.MODULE$, (Object)this.txnMetadata2().pendingState());
        Assertions.assertEquals((Object)CompleteCommit$.MODULE$, (Object)this.txnMetadata2().state());
    }

    @Test
    public void shouldAbortAppendToLogOnEndTxnWhenNotCoordinatorError() {
        this.mockCache();
        Mockito.when((Object)this.metadataCache().getPartitionLeaderEndpoint((String)ArgumentMatchers.eq((Object)this.partition1().topic()), ArgumentMatchers.eq((int)this.partition1().partition()), (ListenerName)ArgumentMatchers.any())).thenReturn((Object)new Some((Object)this.broker1()));
        Mockito.when((Object)this.metadataCache().getPartitionLeaderEndpoint((String)ArgumentMatchers.eq((Object)this.partition2().topic()), ArgumentMatchers.eq((int)this.partition2().partition()), (ListenerName)ArgumentMatchers.any())).thenReturn((Object)new Some((Object)this.broker2()));
        TxnTransitMetadata txnTransitionMetadata2 = this.txnMetadata2().prepareComplete(this.time().milliseconds());
        this.txnStateManager().appendTransactionToLog((String)ArgumentMatchers.eq((Object)this.transactionalId2()), ArgumentMatchers.eq((int)this.coordinatorEpoch()), (TxnTransitMetadata)ArgumentMatchers.eq((Object)txnTransitionMetadata2), (Function1)this.capturedErrorsCallback().capture(), (Function1)ArgumentMatchers.any(), (RequestLocal)ArgumentMatchers.any());
        Mockito.when((Object)BoxedUnit.UNIT).thenAnswer(x$4 -> {
            TransactionMarkerChannelManagerTest.$anonfun$shouldAbortAppendToLogOnEndTxnWhenNotCoordinatorError$1(this, x$4);
            return BoxedUnit.UNIT;
        });
        this.channelManager().addTxnMarkersToSend(this.coordinatorEpoch(), this.txnResult(), this.txnMetadata2(), txnTransitionMetadata2);
        Iterable requestAndHandlers = (Iterable)CollectionConverters$.MODULE$.collectionAsScalaIterableConverter(this.channelManager().generateRequests()).asScala();
        WriteTxnMarkersResponse response = new WriteTxnMarkersResponse(this.createPidErrorMap(Errors.NONE));
        requestAndHandlers.foreach((Function1 & Serializable & scala.Serializable)requestAndHandler -> {
            requestAndHandler.handler.onComplete(new ClientResponse(new RequestHeader(ApiKeys.WRITE_TXN_MARKERS, 0, "client", 1), null, null, 0L, 0L, false, null, null, (AbstractResponse)response));
            return BoxedUnit.UNIT;
        });
        ((TransactionStateManager)Mockito.verify((Object)this.txnStateManager())).appendTransactionToLog((String)ArgumentMatchers.eq((Object)this.transactionalId2()), ArgumentMatchers.eq((int)this.coordinatorEpoch()), (TxnTransitMetadata)ArgumentMatchers.eq((Object)txnTransitionMetadata2), (Function1)this.capturedErrorsCallback().capture(), (Function1)ArgumentMatchers.any(), (RequestLocal)ArgumentMatchers.any());
        Assertions.assertEquals((int)0, (int)this.channelManager().numTxnsWithPendingMarkers());
        Assertions.assertEquals((int)0, (int)((TxnMarkerQueue)this.channelManager().queueForBroker(this.broker1().id()).get()).totalNumMarkers());
        Assertions.assertEquals((Object)None$.MODULE$, (Object)this.txnMetadata2().pendingState());
        Assertions.assertEquals((Object)PrepareCommit$.MODULE$, (Object)this.txnMetadata2().state());
    }

    @Test
    public void shouldRetryAppendToLogOnEndTxnWhenCoordinatorNotAvailableError() {
        this.mockCache();
        Mockito.when((Object)this.metadataCache().getPartitionLeaderEndpoint((String)ArgumentMatchers.eq((Object)this.partition1().topic()), ArgumentMatchers.eq((int)this.partition1().partition()), (ListenerName)ArgumentMatchers.any())).thenReturn((Object)new Some((Object)this.broker1()));
        Mockito.when((Object)this.metadataCache().getPartitionLeaderEndpoint((String)ArgumentMatchers.eq((Object)this.partition2().topic()), ArgumentMatchers.eq((int)this.partition2().partition()), (ListenerName)ArgumentMatchers.any())).thenReturn((Object)new Some((Object)this.broker2()));
        TxnTransitMetadata txnTransitionMetadata2 = this.txnMetadata2().prepareComplete(this.time().milliseconds());
        this.txnStateManager().appendTransactionToLog((String)ArgumentMatchers.eq((Object)this.transactionalId2()), ArgumentMatchers.eq((int)this.coordinatorEpoch()), (TxnTransitMetadata)ArgumentMatchers.eq((Object)txnTransitionMetadata2), (Function1)this.capturedErrorsCallback().capture(), (Function1)ArgumentMatchers.any(), (RequestLocal)ArgumentMatchers.any());
        Mockito.when((Object)BoxedUnit.UNIT).thenAnswer(x$5 -> {
            TransactionMarkerChannelManagerTest.$anonfun$shouldRetryAppendToLogOnEndTxnWhenCoordinatorNotAvailableError$1(this, x$5);
            return BoxedUnit.UNIT;
        }).thenAnswer(x$6 -> {
            TransactionMarkerChannelManagerTest.$anonfun$shouldRetryAppendToLogOnEndTxnWhenCoordinatorNotAvailableError$2(this, txnTransitionMetadata2, x$6);
            return BoxedUnit.UNIT;
        });
        this.channelManager().addTxnMarkersToSend(this.coordinatorEpoch(), this.txnResult(), this.txnMetadata2(), txnTransitionMetadata2);
        Iterable requestAndHandlers = (Iterable)CollectionConverters$.MODULE$.collectionAsScalaIterableConverter(this.channelManager().generateRequests()).asScala();
        WriteTxnMarkersResponse response = new WriteTxnMarkersResponse(this.createPidErrorMap(Errors.NONE));
        requestAndHandlers.foreach((Function1 & Serializable & scala.Serializable)requestAndHandler -> {
            requestAndHandler.handler.onComplete(new ClientResponse(new RequestHeader(ApiKeys.WRITE_TXN_MARKERS, 0, "client", 1), null, null, 0L, 0L, false, null, null, (AbstractResponse)response));
            return BoxedUnit.UNIT;
        });
        this.channelManager().generateRequests();
        ((TransactionStateManager)Mockito.verify((Object)this.txnStateManager(), (VerificationMode)Mockito.times((int)2))).appendTransactionToLog((String)ArgumentMatchers.eq((Object)this.transactionalId2()), ArgumentMatchers.eq((int)this.coordinatorEpoch()), (TxnTransitMetadata)ArgumentMatchers.eq((Object)txnTransitionMetadata2), (Function1)this.capturedErrorsCallback().capture(), (Function1)ArgumentMatchers.any(), (RequestLocal)ArgumentMatchers.any());
        Assertions.assertEquals((int)0, (int)this.channelManager().numTxnsWithPendingMarkers());
        Assertions.assertEquals((int)0, (int)((TxnMarkerQueue)this.channelManager().queueForBroker(this.broker1().id()).get()).totalNumMarkers());
        Assertions.assertEquals((Object)None$.MODULE$, (Object)this.txnMetadata2().pendingState());
        Assertions.assertEquals((Object)CompleteCommit$.MODULE$, (Object)this.txnMetadata2().state());
    }

    private HashMap<Long, Map<TopicPartition, Errors>> createPidErrorMap(Errors errors) {
        HashMap<Long, Map<TopicPartition, Errors>> pidMap = new HashMap<Long, Map<TopicPartition, Errors>>();
        HashMap<TopicPartition, Errors> errorsMap = new HashMap<TopicPartition, Errors>();
        errorsMap.put(this.partition1(), errors);
        pidMap.put(Predef$.MODULE$.long2Long(this.producerId2()), errorsMap);
        return pidMap;
    }

    @Test
    public void shouldCreateMetricsOnStarting() {
        scala.collection.mutable.Map metrics = (scala.collection.mutable.Map)CollectionConverters$.MODULE$.mapAsScalaMapConverter(KafkaYammerMetrics.defaultRegistry().allMetrics()).asScala();
        Assertions.assertEquals((int)1, (int)metrics.count((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)TransactionMarkerChannelManagerTest.$anonfun$shouldCreateMetricsOnStarting$1(x0$1))));
        Assertions.assertEquals((int)1, (int)metrics.count((Function1 & Serializable & scala.Serializable)x0$2 -> BoxesRunTime.boxToBoolean((boolean)TransactionMarkerChannelManagerTest.$anonfun$shouldCreateMetricsOnStarting$2(x0$2))));
    }

    public static final /* synthetic */ void $anonfun$testRemoveMetricsOnClose$2(KafkaMetricsGroup mockMetricsGroup$1, String x$1) {
        ((KafkaMetricsGroup)Mockito.verify((Object)mockMetricsGroup$1)).removeMetric(x$1);
    }

    public static final /* synthetic */ void $anonfun$shouldOnlyWriteTxnCompletionOnce$1(TransactionMarkerChannelManagerTest $this, TxnTransitMetadata expectedTransition$1, InvocationOnMock x$2) {
        $this.txnMetadata2().completeTransitionTo(expectedTransition$1);
        ((Function1)$this.capturedErrorsCallback().getValue()).apply((Object)Errors.NONE);
    }

    public static final /* synthetic */ boolean $anonfun$shouldOnlyWriteTxnCompletionOnce$4(TransactionMarkerChannelManagerTest $this, ClientResponse clientResponse$1) {
        Iterable requests = (Iterable)CollectionConverters$.MODULE$.collectionAsScalaIterableConverter($this.channelManager().generateRequests()).asScala();
        if (requests.nonEmpty()) {
            Assertions.assertEquals((int)1, (int)requests.size());
            ((RequestAndCompletionHandler)requests.head()).handler.onComplete(clientResponse$1);
            return true;
        }
        return false;
    }

    public static final /* synthetic */ String $anonfun$shouldOnlyWriteTxnCompletionOnce$5() {
        return "Timed out waiting for expected WriteTxnMarkers request";
    }

    public static final /* synthetic */ void $anonfun$shouldNotLoseTxnCompletionAfterLoad$2(TransactionMarkerChannelManagerTest $this, TxnTransitMetadata expectedTransition$2, ClientResponse clientResponse$2, ClientResponse successfulClientResponse$1, Either getTransactionStateResponse) {
        $this.txnMetadata2().topicPartitions().add((Object)$this.partition1());
        Mockito.clearInvocations((Object[])new TransactionStateManager[]{$this.txnStateManager()});
        $this.channelManager().addTxnMarkersToSend($this.coordinatorEpoch(), $this.txnResult(), $this.txnMetadata2(), expectedTransition$2);
        Iterable requests1 = (Iterable)CollectionConverters$.MODULE$.collectionAsScalaIterableConverter($this.channelManager().generateRequests()).asScala();
        Assertions.assertEquals((int)1, (int)requests1.size());
        $this.channelManager().removeMarkersForTxnTopicPartition($this.txnTopicPartition2());
        Mockito.when((Object)$this.txnStateManager().getTransactionState((String)ArgumentMatchers.eq((Object)$this.transactionalId2()))).thenReturn((Object)getTransactionStateResponse);
        $this.channelManager().addTxnMarkersToSend($this.coordinatorEpoch2(), $this.txnResult(), $this.txnMetadata2(), expectedTransition$2);
        ((RequestAndCompletionHandler)requests1.head()).handler.onComplete(clientResponse$2);
        Mockito.when((Object)$this.txnStateManager().getTransactionState((String)ArgumentMatchers.eq((Object)$this.transactionalId2()))).thenReturn((Object)package$.MODULE$.Right().apply((Object)new Some((Object)new CoordinatorEpochAndTxnMetadata($this.coordinatorEpoch2(), $this.txnMetadata2()))));
        Iterable requests2 = (Iterable)CollectionConverters$.MODULE$.collectionAsScalaIterableConverter($this.channelManager().generateRequests()).asScala();
        Assertions.assertEquals((int)1, (int)requests2.size());
        ((RequestAndCompletionHandler)requests2.head()).handler.onComplete(successfulClientResponse$1);
        ((TransactionStateManager)Mockito.verify((Object)$this.txnStateManager())).appendTransactionToLog((String)ArgumentMatchers.eq((Object)$this.transactionalId2()), ArgumentMatchers.eq((int)$this.coordinatorEpoch2()), (TxnTransitMetadata)ArgumentMatchers.eq((Object)expectedTransition$2), (Function1)$this.capturedErrorsCallback().capture(), (Function1)ArgumentMatchers.any(), (RequestLocal)ArgumentMatchers.any());
    }

    public static final /* synthetic */ void $anonfun$shouldCompleteAppendToLogOnEndTxnWhenSendMarkersSucceed$1(TransactionMarkerChannelManagerTest $this, TxnTransitMetadata txnTransitionMetadata2$1, InvocationOnMock x$3) {
        $this.txnMetadata2().completeTransitionTo(txnTransitionMetadata2$1);
        ((Function1)$this.capturedErrorsCallback().getValue()).apply((Object)Errors.NONE);
    }

    public static final /* synthetic */ void $anonfun$shouldAbortAppendToLogOnEndTxnWhenNotCoordinatorError$1(TransactionMarkerChannelManagerTest $this, InvocationOnMock x$4) {
        $this.txnMetadata2().pendingState_$eq((Option)None$.MODULE$);
        ((Function1)$this.capturedErrorsCallback().getValue()).apply((Object)Errors.NOT_COORDINATOR);
    }

    public static final /* synthetic */ void $anonfun$shouldRetryAppendToLogOnEndTxnWhenCoordinatorNotAvailableError$1(TransactionMarkerChannelManagerTest $this, InvocationOnMock x$5) {
        ((Function1)$this.capturedErrorsCallback().getValue()).apply((Object)Errors.COORDINATOR_NOT_AVAILABLE);
    }

    public static final /* synthetic */ void $anonfun$shouldRetryAppendToLogOnEndTxnWhenCoordinatorNotAvailableError$2(TransactionMarkerChannelManagerTest $this, TxnTransitMetadata txnTransitionMetadata2$2, InvocationOnMock x$6) {
        $this.txnMetadata2().completeTransitionTo(txnTransitionMetadata2$2);
        ((Function1)$this.capturedErrorsCallback().getValue()).apply((Object)Errors.NONE);
    }

    public static final /* synthetic */ boolean $anonfun$shouldCreateMetricsOnStarting$1(Tuple2 x0$1) {
        if (x0$1 != null) {
            String string = ((MetricName)x0$1._1()).getMBeanName();
            String string2 = "kafka.coordinator.transaction:type=TransactionMarkerChannelManager,name=UnknownDestinationQueueSize";
            return string != null && string.equals(string2);
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ boolean $anonfun$shouldCreateMetricsOnStarting$2(Tuple2 x0$2) {
        if (x0$2 != null) {
            String string = ((MetricName)x0$2._1()).getMBeanName();
            String string2 = "kafka.coordinator.transaction:type=TransactionMarkerChannelManager,name=LogAppendRetryQueueSize";
            return string != null && string.equals(string2);
        }
        throw new MatchError(null);
    }

    public TransactionMarkerChannelManagerTest() {
        this.transactionalId1 = "txnId1";
        this.transactionalId2 = "txnId2";
        this.producerId1 = 0;
        this.producerId2 = 1;
        this.txnTopicPartition1 = 0;
        this.txnTopicPartition2 = 1;
        this.coordinatorEpoch = 0;
        this.coordinatorEpoch2 = 1;
        this.txnTimeoutMs = 0;
    }

    public static final /* synthetic */ Object $anonfun$shouldNotLoseTxnCompletionAfterLoad$1$adapted(TransactionMarkerChannelManagerTest $this, Seq getTransactionStateResponses$1, TxnTransitMetadata expectedTransition$2, ClientResponse successfulClientResponse$1, ClientResponse clientResponse) {
        getTransactionStateResponses$1.foreach((Function1 & Serializable & scala.Serializable)getTransactionStateResponse -> {
            TransactionMarkerChannelManagerTest.$anonfun$shouldNotLoseTxnCompletionAfterLoad$2($this, expectedTransition$2, clientResponse, successfulClientResponse$1, getTransactionStateResponse);
            return BoxedUnit.UNIT;
        });
        return BoxedUnit.UNIT;
    }
}

