/*
 * Decompiled with CFR 0.152.
 */
package kafka.coordinator.transaction;

import java.io.Serializable;
import java.lang.management.ManagementFactory;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.concurrent.CountDownLatch;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import kafka.coordinator.transaction.CompleteAbort$;
import kafka.coordinator.transaction.CompleteCommit$;
import kafka.coordinator.transaction.CoordinatorEpochAndTxnMetadata;
import kafka.coordinator.transaction.Dead$;
import kafka.coordinator.transaction.Empty$;
import kafka.coordinator.transaction.Ongoing$;
import kafka.coordinator.transaction.PrepareAbort$;
import kafka.coordinator.transaction.PrepareCommit$;
import kafka.coordinator.transaction.PrepareEpochFence$;
import kafka.coordinator.transaction.TransactionConfig;
import kafka.coordinator.transaction.TransactionConfig$;
import kafka.coordinator.transaction.TransactionLog$;
import kafka.coordinator.transaction.TransactionMetadata;
import kafka.coordinator.transaction.TransactionMetadata$;
import kafka.coordinator.transaction.TransactionPartitionAndLeaderEpoch;
import kafka.coordinator.transaction.TransactionState;
import kafka.coordinator.transaction.TransactionState$;
import kafka.coordinator.transaction.TransactionStateManager;
import kafka.coordinator.transaction.TransactionalIdAndProducerIdEpoch;
import kafka.coordinator.transaction.TxnMetadataCacheEntry;
import kafka.coordinator.transaction.TxnTransitMetadata;
import kafka.log.UnifiedLog;
import kafka.server.ActionQueue;
import kafka.server.MetadataCache;
import kafka.server.ReplicaManager;
import kafka.server.RequestLocal;
import kafka.server.RequestLocal$;
import kafka.utils.Pool;
import kafka.utils.Pool$;
import kafka.utils.TestUtils$;
import kafka.zk.KafkaZkClient;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.compress.Compression;
import org.apache.kafka.common.message.ListTransactionsResponseData;
import org.apache.kafka.common.metrics.JmxReporter;
import org.apache.kafka.common.metrics.KafkaMetricsContext;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.metrics.MetricsContext;
import org.apache.kafka.common.metrics.MetricsReporter;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.protocol.Message;
import org.apache.kafka.common.protocol.MessageUtil;
import org.apache.kafka.common.record.FileRecords;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.Records;
import org.apache.kafka.common.record.SimpleRecord;
import org.apache.kafka.common.requests.ProduceResponse;
import org.apache.kafka.common.requests.TransactionResult;
import org.apache.kafka.common.utils.MockTime;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.coordinator.transaction.generated.TransactionLogKey;
import org.apache.kafka.server.common.FinalizedFeatures;
import org.apache.kafka.server.common.MetadataVersion;
import org.apache.kafka.server.common.TransactionVersion;
import org.apache.kafka.server.util.MockScheduler;
import org.apache.kafka.server.util.Scheduler;
import org.apache.kafka.storage.internals.log.AppendOrigin;
import org.apache.kafka.storage.internals.log.FetchDataInfo;
import org.apache.kafka.storage.internals.log.FetchIsolation;
import org.apache.kafka.storage.internals.log.LogConfig;
import org.apache.kafka.storage.internals.log.LogOffsetMetadata;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.EnumSource;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.OngoingStubbing;
import org.mockito.verification.VerificationMode;
import scala.Function0;
import scala.Function1;
import scala.Function4;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.Set;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Range;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.Map$;
import scala.collection.mutable.Set$;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.RichLong$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

@ScalaSignature(bytes="\u0006\u0001\rmh\u0001\u00024h\u00019DQ!\u001e\u0001\u0005\u0002YDq!\u001f\u0001C\u0002\u0013\u0005!\u0010\u0003\u0004\u007f\u0001\u0001\u0006Ia\u001f\u0005\b\u007f\u0002\u0011\r\u0011\"\u0001{\u0011\u001d\t\t\u0001\u0001Q\u0001\nmD\u0001\"a\u0001\u0001\u0005\u0004%\tA\u001f\u0005\b\u0003\u000b\u0001\u0001\u0015!\u0003|\u0011%\t9\u0001\u0001b\u0001\n\u0003\tI\u0001\u0003\u0005\u0002\"\u0001\u0001\u000b\u0011BA\u0006\u0011!\t\u0019\u0003\u0001b\u0001\n\u0003Q\bbBA\u0013\u0001\u0001\u0006Ia\u001f\u0005\n\u0003O\u0001!\u0019!C\u0001\u0003SA\u0001\"a\u0012\u0001A\u0003%\u00111\u0006\u0005\n\u0003\u0013\u0002!\u0019!C\u0001\u0003\u0017B\u0001\"!\u0017\u0001A\u0003%\u0011Q\n\u0005\n\u00037\u0002!\u0019!C\u0001\u0003;B\u0001\"a\u001c\u0001A\u0003%\u0011q\f\u0005\n\u0003c\u0002!\u0019!C\u0001\u0003gB\u0001\"!!\u0001A\u0003%\u0011Q\u000f\u0005\n\u0003\u0007\u0003!\u0019!C\u0001\u0003\u000bC\u0001\"!%\u0001A\u0003%\u0011q\u0011\u0005\n\u0003'\u0003!\u0019!C\u0001\u0003+C\u0001\"!(\u0001A\u0003%\u0011q\u0013\u0005\n\u0003?\u0003!\u0019!C\u0001\u0003CC\u0001\"!,\u0001A\u0003%\u00111\u0015\u0005\n\u0003_\u0003!\u0019!C\u0001\u0003cC\u0001\"!/\u0001A\u0003%\u00111\u0017\u0005\n\u0003w\u0003!\u0019!C\u0001\u0003{C\u0001\"!2\u0001A\u0003%\u0011q\u0018\u0005\n\u0003\u000f\u0004!\u0019!C\u0001\u0003\u0013D\u0001\"!9\u0001A\u0003%\u00111\u001a\u0005\n\u0003G\u0004!\u0019!C\u0001\u0003\u0013D\u0001\"!:\u0001A\u0003%\u00111\u001a\u0005\n\u0003O\u0004!\u0019!C\u0001\u0003SD\u0001\"a>\u0001A\u0003%\u00111\u001e\u0005\n\u0003s\u0004!\u0019!C\u0001\u0003SD\u0001\"a?\u0001A\u0003%\u00111\u001e\u0005\n\u0003{\u0004!\u0019!C\u0001\u0003\u007fD\u0001Ba\u0004\u0001A\u0003%!\u0011\u0001\u0005\n\u0005#\u0001\u0001\u0019!C\u0001\u0005'A\u0011Ba\u0007\u0001\u0001\u0004%\tA!\b\t\u0011\t%\u0002\u0001)Q\u0005\u0005+A\u0011Ba\u000b\u0001\u0001\u0004%\tAa\u0005\t\u0013\t5\u0002\u00011A\u0005\u0002\t=\u0002\u0002\u0003B\u001a\u0001\u0001\u0006KA!\u0006\t\u0013\tU\u0002\u00011A\u0005\u0002\t]\u0002\"\u0003B#\u0001\u0001\u0007I\u0011\u0001B$\u0011!\u0011Y\u0005\u0001Q!\n\te\u0002b\u0002B'\u0001\u0011\u0005!q\n\u0005\b\u0005O\u0002A\u0011\u0001B(\u0011\u001d\u0011\t\b\u0001C\u0001\u0005\u001fBqAa\u001f\u0001\t\u0003\u0011y\u0005C\u0004\u0003\u0000\u0001!\tAa\u0014\t\u000f\t\r\u0005\u0001\"\u0001\u0003P!9!q\u0011\u0001\u0005\u0002\t=\u0003b\u0002BF\u0001\u0011\u0005!q\n\u0005\b\u0005\u001f\u0003A\u0011\u0001B(\u0011\u001d\u0011\u0019\n\u0001C\u0001\u0005\u001fBqAa&\u0001\t\u0003\u0011y\u0005C\u0004\u0003\u001c\u0002!\tAa\u0014\t\u000f\t}\u0005\u0001\"\u0001\u0003P!9!1\u0015\u0001\u0005\u0002\t=\u0003b\u0002BT\u0001\u0011\u0005!q\n\u0005\b\u0005W\u0003A\u0011\u0001B(\u0011\u001d\u0011y\u000b\u0001C\u0001\u0005\u001fBqAa-\u0001\t\u0003\u0011y\u0005C\u0004\u00038\u0002!\tAa\u0014\t\u000f\tm\u0006\u0001\"\u0001\u0003P!9!q\u0018\u0001\u0005\u0002\t=\u0003b\u0002Bb\u0001\u0011\u0005!q\n\u0005\b\u0005\u000f\u0004A\u0011\u0001B(\u0011\u001d\u0011Y\r\u0001C\u0001\u0005\u001fBqAa4\u0001\t\u0003\u0011y\u0005C\u0004\u0003T\u0002!\tAa\u0014\t\u000f\t]\u0007\u0001\"\u0001\u0003P!9!1\u001c\u0001\u0005\u0002\t=\u0003b\u0002Bp\u0001\u0011\u0005!q\n\u0005\b\u0005G\u0004A\u0011\u0001B(\u0011\u001d\u00119\u000f\u0001C\u0001\u0005\u001fBqAa;\u0001\t\u0003\u0011y\u0005C\u0004\u0003p\u0002!IA!=\t\u000f\r5\u0001\u0001\"\u0003\u0004\u0010!91Q\u0003\u0001\u0005\n\r]\u0001bBB\r\u0001\u0011\u0005!q\n\u0005\b\u0007;\u0001A\u0011\u0001B(\u0011\u001d\u0019\t\u0003\u0001C\u0005\u0007GAqa!\u000b\u0001\t\u0013\u0019Y\u0003C\u0004\u00040\u0001!Ia!\r\t\u000f\rm\u0002\u0001\"\u0003\u0004>!91Q\u000b\u0001\u0005\n\r]\u0003bBB0\u0001\u0011%1\u0011\r\u0005\b\u0007c\u0002A\u0011BB:\u0011\u001d\u0019I\b\u0001C\u0005\u0007wBqaa \u0001\t\u0013\u0019\t\tC\u0005\u0004\u0010\u0002\t\n\u0011\"\u0003\u0004\u0012\"I1q\u0015\u0001\u0012\u0002\u0013%1\u0011\u0016\u0005\b\u0007[\u0003A\u0011BBX\u0011\u001d\u0019Y\f\u0001C\u0005\u0007{Cqa!1\u0001\t\u0003\u0011y\u0005C\u0004\u0004F\u0002!\tAa\u0014\t\u000f\r%\u0007\u0001\"\u0001\u0004L\nYBK]1og\u0006\u001cG/[8o'R\fG/Z'b]\u0006<WM\u001d+fgRT!\u0001[5\u0002\u0017Q\u0014\u0018M\\:bGRLwN\u001c\u0006\u0003U.\f1bY8pe\u0012Lg.\u0019;pe*\tA.A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\u0005\u0001y\u0007C\u00019t\u001b\u0005\t(\"\u0001:\u0002\u000bM\u001c\u0017\r\\1\n\u0005Q\f(AB!osJ+g-\u0001\u0004=S:LGO\u0010\u000b\u0002oB\u0011\u0001\u0010A\u0007\u0002O\u0006Y\u0001/\u0019:uSRLwN\\%e+\u0005Y\bC\u00019}\u0013\ti\u0018OA\u0002J]R\fA\u0002]1si&$\u0018n\u001c8JI\u0002\nQB\\;n!\u0006\u0014H/\u001b;j_:\u001c\u0018A\u00048v[B\u000b'\u000f^5uS>t7\u000fI\u0001\u0015iJ\fgn]1di&|g\u000eV5nK>,H/T:\u0002+Q\u0014\u0018M\\:bGRLwN\u001c+j[\u0016|W\u000f^'tA\u0005qAo\u001c9jGB\u000b'\u000f^5uS>tWCAA\u0006!\u0011\ti!!\b\u000e\u0005\u0005=!\u0002BA\t\u0003'\taaY8n[>t'b\u00017\u0002\u0016)!\u0011qCA\r\u0003\u0019\t\u0007/Y2iK*\u0011\u00111D\u0001\u0004_J<\u0017\u0002BA\u0010\u0003\u001f\u0011a\u0002V8qS\u000e\u0004\u0016M\u001d;ji&|g.A\bu_BL7\rU1si&$\u0018n\u001c8!\u0003A\u0019wn\u001c:eS:\fGo\u001c:Fa>\u001c\u0007.A\td_>\u0014H-\u001b8bi>\u0014X\t]8dQ\u0002\n!\u0002\u001e=o%\u0016\u001cwN\u001d3t+\t\tY\u0003\u0005\u0004\u0002.\u0005]\u00121H\u0007\u0003\u0003_QA!!\r\u00024\u00059Q.\u001e;bE2,'bAA\u001bc\u0006Q1m\u001c7mK\u000e$\u0018n\u001c8\n\t\u0005e\u0012q\u0006\u0002\f\u0003J\u0014\u0018-\u001f\"vM\u001a,'\u000f\u0005\u0003\u0002>\u0005\rSBAA \u0015\u0011\t\t%a\u0004\u0002\rI,7m\u001c:e\u0013\u0011\t)%a\u0010\u0003\u0019MKW\u000e\u001d7f%\u0016\u001cwN\u001d3\u0002\u0017QDhNU3d_J$7\u000fI\u0001\u0005i&lW-\u0006\u0002\u0002NA!\u0011qJA+\u001b\t\t\tF\u0003\u0003\u0002T\u0005=\u0011!B;uS2\u001c\u0018\u0002BA,\u0003#\u0012\u0001\"T8dWRKW.Z\u0001\u0006i&lW\rI\u0001\ng\u000eDW\rZ;mKJ,\"!a\u0018\u0011\t\u0005\u0005\u00141N\u0007\u0003\u0003GRA!!\u001a\u0002h\u0005!Q\u000f^5m\u0015\u0011\tI'a\u0005\u0002\rM,'O^3s\u0013\u0011\ti'a\u0019\u0003\u001b5{7m[*dQ\u0016$W\u000f\\3s\u0003)\u00198\r[3ek2,'\u000fI\u0001\tu.\u001cE.[3oiV\u0011\u0011Q\u000f\t\u0005\u0003o\ni(\u0004\u0002\u0002z)\u0019\u00111P6\u0002\u0005i\\\u0017\u0002BA@\u0003s\u0012QbS1gW\u0006T6n\u00117jK:$\u0018!\u0003>l\u00072LWM\u001c;!\u00039\u0011X\r\u001d7jG\u0006l\u0015M\\1hKJ,\"!a\"\u0011\t\u0005%\u0015QR\u0007\u0003\u0003\u0017S1!!\u001bl\u0013\u0011\ty)a#\u0003\u001dI+\u0007\u000f\\5dC6\u000bg.Y4fe\u0006y!/\u001a9mS\u000e\fW*\u00198bO\u0016\u0014\b%A\u0007nKR\fG-\u0019;b\u0007\u0006\u001c\u0007.Z\u000b\u0003\u0003/\u0003B!!#\u0002\u001a&!\u00111TAF\u00055iU\r^1eCR\f7)Y2iK\u0006qQ.\u001a;bI\u0006$\u0018mQ1dQ\u0016\u0004\u0013aB7fiJL7m]\u000b\u0003\u0003G\u0003B!!*\u0002*6\u0011\u0011q\u0015\u0006\u0005\u0003?\u000by!\u0003\u0003\u0002,\u0006\u001d&aB'fiJL7m]\u0001\t[\u0016$(/[2tA\u0005IA\u000f\u001f8D_:4\u0017nZ\u000b\u0003\u0003g\u00032\u0001_A[\u0013\r\t9l\u001a\u0002\u0012)J\fgn]1di&|gnQ8oM&<\u0017A\u0003;y]\u000e{gNZ5hA\u0005\u0011BO]1og\u0006\u001cG/[8o\u001b\u0006t\u0017mZ3s+\t\ty\fE\u0002y\u0003\u0003L1!a1h\u0005]!&/\u00198tC\u000e$\u0018n\u001c8Ti\u0006$X-T1oC\u001e,'/A\nue\u0006t7/Y2uS>tW*\u00198bO\u0016\u0014\b%\u0001\tue\u0006t7/Y2uS>t\u0017\r\\%ecU\u0011\u00111\u001a\t\u0005\u0003\u001b\fYN\u0004\u0003\u0002P\u0006]\u0007cAAic6\u0011\u00111\u001b\u0006\u0004\u0003+l\u0017A\u0002\u001fs_>$h(C\u0002\u0002ZF\fa\u0001\u0015:fI\u00164\u0017\u0002BAo\u0003?\u0014aa\u0015;sS:<'bAAmc\u0006\tBO]1og\u0006\u001cG/[8oC2LE-\r\u0011\u0002!Q\u0014\u0018M\\:bGRLwN\\1m\u0013\u0012\u0014\u0014!\u0005;sC:\u001c\u0018m\u0019;j_:\fG.\u001333A\u0005\u0019B\u000f\u001f8NKN\u001c\u0018mZ3LKf\u0014\u0015\u0010^3tcU\u0011\u00111\u001e\t\u0006a\u00065\u0018\u0011_\u0005\u0004\u0003_\f(!B!se\u0006L\bc\u00019\u0002t&\u0019\u0011Q_9\u0003\t\tKH/Z\u0001\u0015ibtW*Z:tC\u001e,7*Z=CsR,7/\r\u0011\u0002'QDh.T3tg\u0006<WmS3z\u0005f$Xm\u001d\u001a\u0002)QDh.T3tg\u0006<WmS3z\u0005f$Xm\u001d\u001a!\u0003-\u0001(o\u001c3vG\u0016\u0014\u0018\nZ:\u0016\u0005\t\u0005\u0001\u0003\u0003B\u0002\u0005\u000b\tYM!\u0003\u000e\u0005\u0005M\u0012\u0002\u0002B\u0004\u0003g\u00111!T1q!\r\u0001(1B\u0005\u0004\u0005\u001b\t(\u0001\u0002'p]\u001e\fA\u0002\u001d:pIV\u001cWM]%eg\u0002\nA\u0002\u001e=o\u001b\u0016$\u0018\rZ1uCF*\"A!\u0006\u0011\u0007a\u00149\"C\u0002\u0003\u001a\u001d\u00141\u0003\u0016:b]N\f7\r^5p]6+G/\u00193bi\u0006\f\u0001\u0003\u001e=o\u001b\u0016$\u0018\rZ1uCFzF%Z9\u0015\t\t}!Q\u0005\t\u0004a\n\u0005\u0012b\u0001B\u0012c\n!QK\\5u\u0011%\u00119#KA\u0001\u0002\u0004\u0011)\"A\u0002yIE\nQ\u0002\u001e=o\u001b\u0016$\u0018\rZ1uCF\u0002\u0013\u0001\u0004;y]6+G/\u00193bi\u0006\u0014\u0014\u0001\u0005;y]6+G/\u00193bi\u0006\u0014t\fJ3r)\u0011\u0011yB!\r\t\u0013\t\u001dB&!AA\u0002\tU\u0011!\u0004;y]6+G/\u00193bi\u0006\u0014\u0004%A\u0007fqB,7\r^3e\u000bJ\u0014xN]\u000b\u0003\u0005s\u0001BAa\u000f\u0003B5\u0011!Q\b\u0006\u0005\u0005\u007f\ty!\u0001\u0005qe>$xnY8m\u0013\u0011\u0011\u0019E!\u0010\u0003\r\u0015\u0013(o\u001c:t\u0003E)\u0007\u0010]3di\u0016$WI\u001d:pe~#S-\u001d\u000b\u0005\u0005?\u0011I\u0005C\u0005\u0003(=\n\t\u00111\u0001\u0003:\u0005qQ\r\u001f9fGR,G-\u0012:s_J\u0004\u0013!B:fiV\u0003HC\u0001B\u0010Q\r\t$1\u000b\t\u0005\u0005+\u0012\u0019'\u0004\u0002\u0003X)!!\u0011\fB.\u0003\r\t\u0007/\u001b\u0006\u0005\u0005;\u0012y&A\u0004kkBLG/\u001a:\u000b\t\t\u0005\u0014\u0011D\u0001\u0006UVt\u0017\u000e^\u0005\u0005\u0005K\u00129F\u0001\u0006CK\u001a|'/Z#bG\"\f\u0001\u0002^3be\u0012{wO\u001c\u0015\u0004e\t-\u0004\u0003\u0002B+\u0005[JAAa\u001c\u0003X\tI\u0011I\u001a;fe\u0016\u000b7\r[\u0001\u001fi\u0016\u001cHOV1mS\u0012\fG/\u001a+sC:\u001c\u0018m\u0019;j_:$\u0016.\\3pkRD3a\rB;!\u0011\u0011)Fa\u001e\n\t\te$q\u000b\u0002\u0005)\u0016\u001cH/\u0001\buKN$\u0018\t\u001a3HKR\u0004\u0016\u000eZ:)\u0007Q\u0012)(A\nuKN$H)\u001a7fi\u0016\u0004\u0016M\u001d;ji&|g\u000eK\u00026\u0005k\n!\u0004^3ti\u0012+G.\u001a;f\u0019>\fG-\u001b8h!\u0006\u0014H/\u001b;j_:D3A\u000eB;\u0003%\"Xm\u001d;M_\u0006$\u0017I\u001c3SK6|g/\u001a+sC:\u001c\u0018m\u0019;j_:\u001chi\u001c:QCJ$\u0018\u000e^5p]\"\u001aqG!\u001e\u0002SQ,7\u000f^\"p[BdW\r^3Ue\u0006t7/\u001b;j_:<\u0006.\u001a8BaB,g\u000eZ*vG\u000e,W\rZ3eQ\rA$QO\u0001-i\u0016\u001cH/\u00119qK:$g)Y5m)>\u001cun\u001c:eS:\fGo\u001c:O_R\fe/Y5mC\ndW-\u0012:s_JD3!\u000fB;\u0003\r\"Xm\u001d;BaB,g\u000e\u001a$bS2$vNT8u\u0007>|'\u000fZ5oCR|'/\u0012:s_JD3A\u000fB;\u0003\u001d\"Xm\u001d;BaB,g\u000e\u001a$bS2$vnQ8pe\u0012Lg.\u0019;pe2{\u0017\rZ5oO\u0016\u0013(o\u001c:)\u0007m\u0012)(\u0001\u000fuKN$\u0018\t\u001d9f]\u00124\u0015-\u001b7U_Vs7N\\8x]\u0016\u0013(o\u001c:)\u0007q\u0012)(A\u0013uKN$\b+\u001a8eS:<7\u000b^1uK:{GOU3tKR|eNU3uef\f\u0005\u000f]3oI\"\u001aQH!\u001e\u0002[Q,7\u000f^!qa\u0016tG\r\u0016:b]N\f7\r^5p]R{Gj\\4XQ&dW\r\u0015:pIV\u001cWM\u001d$f]\u000e,G\rK\u0002?\u0005k\n!\u0007^3ti\u0006\u0003\b/\u001a8e)J\fgn]1di&|g\u000eV8M_\u001e<\u0006.\u001b7f!\u0016tG-\u001b8h'R\fG/Z\"iC:<W\r\u001a\u0015\u0004\u007f\tU\u0014aP:i_VdGMU3ukJtgj\u001c;D_>\u0014H-\u001b8bi>\u0014XI\u001d:pe&3GK]1og\u0006\u001cG/[8o\u0013\u0012\u0004\u0016M\u001d;ji&|gNT8u\u001f^tW\r\u001a\u0015\u0004\u0001\nU\u0014\u0001\u000e;fgRd\u0015n\u001d;Ue\u0006t7/Y2uS>t7oV5uQ\u000e{wN\u001d3j]\u0006$xN\u001d'pC\u0012LgnZ%o!J|wM]3tg\"\u001a\u0011I!\u001e\u0002;Q,7\u000f\u001e'jgR$&/\u00198tC\u000e$\u0018n\u001c8t\r&dG/\u001a:j]\u001eD3A\u0011B;\u0003Y\u001a\bn\\;mI>sG._\"p]NLG-\u001a:Ue\u0006t7/Y2uS>t7/\u00138UQ\u0016|enZ8j]\u001e\u001cF/\u0019;f)>\f%m\u001c:uQ\r\u0019%QO\u00019g\"|W\u000f\u001c3Xe&$X\r\u0016=o\u001b\u0006\u00148.\u001a:t\r>\u0014HK]1og\u0006\u001cG/[8o\u0013:\u0004&/\u001a9be\u0016$7i\\7nSR\u001cF/\u0019;fQ\r!%QO\u00018g\"|W\u000f\u001c3Xe&$X\r\u0016=o\u001b\u0006\u00148.\u001a:t\r>\u0014HK]1og\u0006\u001cG/[8o\u0013:\u0004&/\u001a9be\u0016$\u0017IY8siN#\u0018\r^3)\u0007\u0015\u0013)(A\u0019tQ>,H\u000e\u001a*f[>4XmQ8na2,G/Z\"p[6LG/\u0012=qSJ,G\r\u0016:b]N\f7\r^5p]\u0006d\u0017\nZ:)\u0007\u0019\u0013)(\u0001\u0019tQ>,H\u000e\u001a*f[>4XmQ8na2,G/Z!c_J$X\t\u001f9je\u0016$GK]1og\u0006\u001cG/[8oC2LEm\u001d\u0015\u0004\u000f\nU\u0014\u0001K:i_VdGMU3n_Z,W)\u001c9us\u0016C\b/\u001b:fIR\u0013\u0018M\\:bGRLwN\\1m\u0013\u0012\u001c\bf\u0001%\u0003v\u000514\u000f[8vY\u0012tu\u000e\u001e*f[>4X-\u0012=qSJ,G\r\u0016:b]N\f7\r^5p]\u0006d\u0017\nZ:JM2{w-\u00119qK:$g)Y5mg\"\u001a\u0011J!\u001e\u0002MMDw.\u001e7e\u001d>$(+Z7pm\u0016|enZ8j]\u001e$&/\u00198tC\u000e$\u0018n\u001c8bY&#7\u000fK\u0002K\u0005k\n1f\u001d5pk2$gj\u001c;SK6|g/\u001a)sKB\f'/Z!c_J$HK]1og\u0006\u001cG/[8oC2LEm\u001d\u0015\u0004\u0017\nU\u0014\u0001L:i_VdGMT8u%\u0016lwN^3Qe\u0016\u0004\u0018M]3D_6l\u0017\u000e\u001e+sC:\u001c\u0018m\u0019;j_:\fG.\u00133tQ\ra%QO\u00011i\u0016\u001cH\u000f\u0016:b]N\f7\r^5p]\u0006dW\t\u001f9je\u0006$\u0018n\u001c8XSRDGk\\8T[\u0006dGNQ1uG\"\u001c\u0016N_3)\u00075\u0013)(\u0001\u0017uKN$HK]1og\u0006\u001cG/[8oC2,\u0005\u0010]5sCRLwN\\,ji\"|eM\u001a7j]\u0016dun\u001a#je\"\u001aaJ!\u001e\u0002_Q,7\u000f\u001e+sC:\u001c\u0018m\u0019;j_:,\u0005\u0010]5sCRLwN\\*i_VdGMU3ta\u0016\u001cGOQ1uG\"\u001c\u0016N_3)\u0007=\u0013)(\u0001&uKN$HK]1og\u0006\u001cG/[8o\u000bb\u0004\u0018N]1uS>t7\u000b[8vY\u0012tu\u000e\u001e$bS2<\u0016\u000e\u001e5V]&t\u0017\u000e^5bY&TX\r\u001a+sC:\u001c\u0018m\u0019;j_:lU\r^1eCR\f\u0007f\u0001)\u0003v\u0005)3m\u001c7mK\u000e$HK]1og\u0006\u001cG/[8oC2LEm\u001d$s_6$v.\u001c2ti>tWm\u001d\u000b\u0005\u0005g\u0014I\u0010\u0005\u0004\u0002N\nU\u00181Z\u0005\u0005\u0005o\fyNA\u0002TKRDqAa?R\u0001\u0004\u0011i0A\bbaB,g\u000eZ3e%\u0016\u001cwN\u001d3t!!\tiCa@\u0002\f\r\u0005\u0011\u0002\u0002B\u0004\u0003_\u0001b!!\f\u0004\u0004\r\u001d\u0011\u0002BB\u0003\u0003_\u0011aAQ;gM\u0016\u0014\b\u0003BA\u001f\u0007\u0013IAaa\u0003\u0002@\tiQ*Z7pef\u0014VmY8sIN\f1\u0004\\8bI\u0016C\b/\u001b:fIR\u0013\u0018M\\:bGRLwN\\1m\u0013\u0012\u001cH\u0003\u0002Bz\u0007#Aaaa\u0005S\u0001\u0004Y\u0018a\u00058v[R\u0013\u0018M\\:bGRLwN\\1m\u0013\u0012\u001c\u0018!\b7jgR,\u0005\u0010]5sC\ndW\r\u0016:b]N\f7\r^5p]\u0006d\u0017\nZ:\u0015\u0005\tM\u0018a\u0007;fgR\u001cVoY2fgN4W\u000f\u001c*fS6l\u0017n\u001a:bi&|g\u000eK\u0002U\u0005k\n1\u0006^3ti2{\u0017\r\u001a+sC:\u001c\u0018m\u0019;j_:lU\r^1eCR\fw+\u001b;i\u0007>\u0014(/\u001e9uK\u0012dun\u001a\u0015\u0004+\nU\u0014A\t<fe&4\u00170T3uC\u0012\fG/\u0019#pKN,\u00050[:u\u0003:$\u0017j]+tC\ndW\r\u0006\u0003\u0003 \r\u0015\u0002bBB\u0014-\u0002\u0007\u00111Z\u0001\u0010iJ\fgn]1di&|g.\u00197JI\u0006Ib/\u001a:jMflU\r^1eCR\fGi\\3t]R,\u00050[:u)\u0011\u0011yb!\f\t\u000f\r\u001dr\u000b1\u0001\u0002L\u0006yR\r\u001f9fGR$&/\u00198tC\u000e$\u0018n\u001c8bY&#W\t\u001f9je\u0006$\u0018n\u001c8\u0015\r\t}11GB\u001c\u0011\u001d\u0019)\u0004\u0017a\u0001\u0005s\t1\"\u00199qK:$WI\u001d:pe\"91\u0011\b-A\u0002\tu\u0018aD2baR,(/\u001a3BaB,g\u000eZ:\u0002;1|\u0017\r\u001a+sC:\u001c\u0018m\u0019;j_:\u001chi\u001c:QCJ$\u0018\u000e^5p]N$BAa\b\u0004@!91\u0011I-A\u0002\r\r\u0013\u0001\u00049beRLG/[8o\u0013\u0012\u001c\b#BB#\u0007\u001fZh\u0002BB$\u0007\u0017rA!!5\u0004J%\t!/C\u0002\u0004NE\fq\u0001]1dW\u0006<W-\u0003\u0003\u0004R\rM#aA*fc*\u00191QJ9\u0002\u001f\u0015D\b/Z2u\u0019><7i\u001c8gS\u001e$bAa\b\u0004Z\rm\u0003bBB!5\u0002\u000711\t\u0005\u0007\u0007;R\u0006\u0019A>\u0002\u00195\f\u0007PQ1uG\"\u001c\u0016N_3\u0002IM,G/\u001e9B]\u0012\u0014VO\u001c+sC:\u001c\u0018m\u0019;j_:\fG.\u00133FqBL'/\u0019;j_:$bAa\b\u0004d\r\u001d\u0004bBB37\u0002\u0007!\u0011H\u0001\u0006KJ\u0014xN\u001d\u0005\b\u0007SZ\u0006\u0019AB6\u0003!!\bP\\*uCR,\u0007c\u0001=\u0004n%\u00191qN4\u0003!Q\u0013\u0018M\\:bGRLwN\\*uCR,\u0017\u0001\n<fe&4\u0017p\u0016:ji\u0016\u001cH\u000b\u001f8NCJ\\WM]:J]B\u0013X\r]1sKN#\u0018\r^3\u0015\t\t}1Q\u000f\u0005\b\u0007ob\u0006\u0019AB6\u0003\u0015\u0019H/\u0019;f\u00039\t7o]3si\u000e\u000bG\u000e\u001c2bG.$BAa\b\u0004~!91QM/A\u0002\te\u0012a\u0005;sC:\u001c\u0018m\u0019;j_:lU\r^1eCR\fGC\u0003B\u000b\u0007\u0007\u001b)i!#\u0004\f\"91q\u00050A\u0002\u0005-\u0007bBBD=\u0002\u0007!\u0011B\u0001\u000baJ|G-^2fe&#\u0007\"CB<=B\u0005\t\u0019AB6\u0011!\u0019iI\u0018I\u0001\u0002\u0004Y\u0018A\u0003;y]RKW.Z8vi\u0006iBO]1og\u0006\u001cG/[8o\u001b\u0016$\u0018\rZ1uC\u0012\"WMZ1vYR$3'\u0006\u0002\u0004\u0014*\"11NBKW\t\u00199\n\u0005\u0003\u0004\u001a\u000e\rVBABN\u0015\u0011\u0019ija(\u0002\u0013Ut7\r[3dW\u0016$'bABQc\u0006Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\r\u001561\u0014\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017!\b;sC:\u001c\u0018m\u0019;j_:lU\r^1eCR\fG\u0005Z3gCVdG\u000f\n\u001b\u0016\u0005\r-&fA>\u0004\u0016\u0006i\u0001O]3qCJ,G\u000b\u001f8M_\u001e$\u0002Ba\b\u00042\u000eM6q\u0017\u0005\b\u0003\u000f\t\u0007\u0019AA\u0006\u0011\u001d\u0019),\u0019a\u0001\u0005\u0013\t1b\u001d;beR|eMZ:fi\"91\u0011X1A\u0002\r\u001d\u0011a\u0002:fG>\u0014Hm]\u0001\u001baJ,\u0007/\u0019:f\r>\u0014H\u000b\u001f8NKN\u001c\u0018mZ3BaB,g\u000e\u001a\u000b\u0005\u0005?\u0019y\fC\u0004\u0004f\t\u0004\rA!\u000f\u0002/Q,7\u000f\u001e)beRLG/[8o\u0019>\fG-T3ue&\u001c\u0007fA2\u0003v\u0005YB/Z:u\u0013\u001etwN]3V].twn\u001e8SK\u000e|'\u000f\u001a+za\u0016D3\u0001\u001aB;\u0003]!Xm\u001d;Vg\u0016\u001ch\t\\3yS\ndWMU3d_J$7\u000f\u0006\u0003\u0003 \r5\u0007bBBhK\u0002\u00071\u0011[\u0001\u0013iJ\fgn]1di&|gNV3sg&|g\u000e\u0005\u0003\u0004T\u000e]WBABk\u0015\u0011\t\t\"a\u001a\n\t\re7Q\u001b\u0002\u0013)J\fgn]1di&|gNV3sg&|g\u000eK\u0004f\u0007;\u001cioa<\u0011\t\r}7\u0011^\u0007\u0003\u0007CTAaa9\u0004f\u0006A\u0001O]8wS\u0012,'O\u0003\u0003\u0004h\nm\u0013A\u00029be\u0006l7/\u0003\u0003\u0004l\u000e\u0005(AC#ok6\u001cv.\u001e:dK\u0006)a/\u00197vK\u000e\u00121\u0011\u001b\u0015\u0004K\u000eM\b\u0003BB{\u0007ol!a!:\n\t\re8Q\u001d\u0002\u0012!\u0006\u0014\u0018-\\3uKJL'0\u001a3UKN$\b")
public class TransactionStateManagerTest {
    private final int partitionId;
    private final int numPartitions;
    private final int transactionTimeoutMs;
    private final TopicPartition topicPartition = new TopicPartition("__transaction_state", this.partitionId());
    private final int coordinatorEpoch;
    private final ArrayBuffer<SimpleRecord> txnRecords = (ArrayBuffer)ArrayBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
    private final MockTime time = new MockTime();
    private final MockScheduler scheduler = new MockScheduler((Time)this.time());
    private final KafkaZkClient zkClient = (KafkaZkClient)Mockito.mock(KafkaZkClient.class);
    private final ReplicaManager replicaManager = (ReplicaManager)Mockito.mock(ReplicaManager.class);
    private final MetadataCache metadataCache = (MetadataCache)Mockito.mock(MetadataCache.class);
    private final Metrics metrics;
    private final TransactionConfig txnConfig;
    private final TransactionStateManager transactionManager;
    private final String transactionalId1;
    private final String transactionalId2;
    private final byte[] txnMessageKeyBytes1;
    private final byte[] txnMessageKeyBytes2;
    private final Map<String, Object> producerIds;
    private TransactionMetadata txnMetadata1;
    private TransactionMetadata txnMetadata2;
    private Errors expectedError;

    public int partitionId() {
        return this.partitionId;
    }

    public int numPartitions() {
        return this.numPartitions;
    }

    public int transactionTimeoutMs() {
        return this.transactionTimeoutMs;
    }

    public TopicPartition topicPartition() {
        return this.topicPartition;
    }

    public int coordinatorEpoch() {
        return this.coordinatorEpoch;
    }

    public ArrayBuffer<SimpleRecord> txnRecords() {
        return this.txnRecords;
    }

    public MockTime time() {
        return this.time;
    }

    public MockScheduler scheduler() {
        return this.scheduler;
    }

    public KafkaZkClient zkClient() {
        return this.zkClient;
    }

    public ReplicaManager replicaManager() {
        return this.replicaManager;
    }

    public MetadataCache metadataCache() {
        return this.metadataCache;
    }

    public Metrics metrics() {
        return this.metrics;
    }

    public TransactionConfig txnConfig() {
        return this.txnConfig;
    }

    public TransactionStateManager transactionManager() {
        return this.transactionManager;
    }

    public String transactionalId1() {
        return this.transactionalId1;
    }

    public String transactionalId2() {
        return this.transactionalId2;
    }

    public byte[] txnMessageKeyBytes1() {
        return this.txnMessageKeyBytes1;
    }

    public byte[] txnMessageKeyBytes2() {
        return this.txnMessageKeyBytes2;
    }

    public Map<String, Object> producerIds() {
        return this.producerIds;
    }

    public TransactionMetadata txnMetadata1() {
        return this.txnMetadata1;
    }

    public void txnMetadata1_$eq(TransactionMetadata x$1) {
        this.txnMetadata1 = x$1;
    }

    public TransactionMetadata txnMetadata2() {
        return this.txnMetadata2;
    }

    public void txnMetadata2_$eq(TransactionMetadata x$1) {
        this.txnMetadata2 = x$1;
    }

    public Errors expectedError() {
        return this.expectedError;
    }

    public void expectedError_$eq(Errors x$1) {
        this.expectedError = x$1;
    }

    @BeforeEach
    public void setUp() {
        this.transactionManager().startup((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> this.numPartitions(), false);
        Assertions.assertEquals((int)this.partitionId(), (int)this.transactionManager().partitionFor(this.transactionalId1()));
        Assertions.assertEquals((int)this.partitionId(), (int)this.transactionManager().partitionFor(this.transactionalId2()));
    }

    @AfterEach
    public void tearDown() {
        this.transactionManager().shutdown();
    }

    @Test
    public void testValidateTransactionTimeout() {
        Assertions.assertTrue((boolean)this.transactionManager().validateTransactionTimeoutMs(1));
        Assertions.assertFalse((boolean)this.transactionManager().validateTransactionTimeoutMs(-1));
        Assertions.assertFalse((boolean)this.transactionManager().validateTransactionTimeoutMs(0));
        Assertions.assertTrue((boolean)this.transactionManager().validateTransactionTimeoutMs(this.txnConfig().transactionMaxTimeoutMs()));
        Assertions.assertFalse((boolean)this.transactionManager().validateTransactionTimeoutMs(this.txnConfig().transactionMaxTimeoutMs() + 1));
    }

    @Test
    public void testAddGetPids() {
        this.transactionManager().addLoadedTransactionsToCache(this.partitionId(), this.coordinatorEpoch(), new Pool((Option)Pool$.MODULE$.$lessinit$greater$default$1()));
        Assertions.assertEquals((Object)package$.MODULE$.Right().apply((Object)None$.MODULE$), (Object)this.transactionManager().getTransactionState(this.transactionalId1()));
        Assertions.assertEquals((Object)package$.MODULE$.Right().apply((Object)new CoordinatorEpochAndTxnMetadata(this.coordinatorEpoch(), this.txnMetadata1())), (Object)this.transactionManager().putTransactionStateIfNotExists(this.txnMetadata1()));
        Assertions.assertEquals((Object)package$.MODULE$.Right().apply((Object)new Some((Object)new CoordinatorEpochAndTxnMetadata(this.coordinatorEpoch(), this.txnMetadata1()))), (Object)this.transactionManager().getTransactionState(this.transactionalId1()));
        Assertions.assertEquals((Object)package$.MODULE$.Right().apply((Object)new CoordinatorEpochAndTxnMetadata(this.coordinatorEpoch(), this.txnMetadata2())), (Object)this.transactionManager().putTransactionStateIfNotExists(this.txnMetadata2()));
    }

    @Test
    public void testDeletePartition() {
        TransactionMetadata metadata1 = this.transactionMetadata("b", 5L, this.transactionMetadata$default$3(), this.transactionMetadata$default$4());
        TransactionMetadata metadata2 = this.transactionMetadata("a", 10L, this.transactionMetadata$default$3(), this.transactionMetadata$default$4());
        Assertions.assertEquals((int)0, (int)this.transactionManager().partitionFor(metadata1.transactionalId()));
        Assertions.assertEquals((int)1, (int)this.transactionManager().partitionFor(metadata2.transactionalId()));
        this.transactionManager().addLoadedTransactionsToCache(0, this.coordinatorEpoch(), new Pool((Option)Pool$.MODULE$.$lessinit$greater$default$1()));
        this.transactionManager().putTransactionStateIfNotExists(metadata1);
        this.transactionManager().addLoadedTransactionsToCache(1, this.coordinatorEpoch(), new Pool((Option)Pool$.MODULE$.$lessinit$greater$default$1()));
        this.transactionManager().putTransactionStateIfNotExists(metadata2);
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToShort((short)metadata1.producerEpoch())), (Object)this.cachedProducerEpoch$1(metadata1.transactionalId()));
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToShort((short)metadata2.producerEpoch())), (Object)this.cachedProducerEpoch$1(metadata2.transactionalId()));
        this.transactionManager().removeTransactionsForTxnTopicPartition(0);
        Assertions.assertEquals((Object)None$.MODULE$, (Object)this.cachedProducerEpoch$1(metadata1.transactionalId()));
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToShort((short)metadata2.producerEpoch())), (Object)this.cachedProducerEpoch$1(metadata2.transactionalId()));
    }

    @Test
    public void testDeleteLoadingPartition() {
        long startOffset = 0L;
        long endOffset = 1L;
        FileRecords fileRecordsMock = (FileRecords)Mockito.mock(FileRecords.class);
        UnifiedLog logMock = (UnifiedLog)Mockito.mock(UnifiedLog.class);
        Mockito.when((Object)this.replicaManager().getLog(this.topicPartition())).thenReturn((Object)new Some((Object)logMock));
        Mockito.when((Object)BoxesRunTime.boxToLong((long)logMock.logStartOffset())).thenReturn((Object)BoxesRunTime.boxToLong((long)startOffset));
        Mockito.when((Object)logMock.read(ArgumentMatchers.eq((long)startOffset), ArgumentMatchers.anyInt(), (FetchIsolation)ArgumentMatchers.eq((Object)FetchIsolation.LOG_END), ArgumentMatchers.eq((boolean)true))).thenReturn((Object)new FetchDataInfo(new LogOffsetMetadata(startOffset), (Records)fileRecordsMock));
        Mockito.when((Object)this.replicaManager().getLogEndOffset(this.topicPartition())).thenReturn((Object)new Some((Object)BoxesRunTime.boxToLong((long)endOffset)));
        this.txnMetadata1().state_$eq((TransactionState)PrepareCommit$.MODULE$);
        this.txnMetadata1().addPartitions((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition("topic1", 0), new TopicPartition("topic1", 1)})));
        MemoryRecords records = MemoryRecords.withRecords((long)startOffset, (Compression)Compression.NONE, (SimpleRecord[])new SimpleRecord[]{new SimpleRecord(this.txnMessageKeyBytes1(), TransactionLog$.MODULE$.valueToBytes(this.txnMetadata1().prepareNoTransit(), true))});
        CountDownLatch latch = new CountDownLatch(1);
        Mockito.when((Object)BoxesRunTime.boxToInteger((int)fileRecordsMock.sizeInBytes())).thenReturn((Object)BoxesRunTime.boxToInteger((int)records.sizeInBytes()));
        ArgumentCaptor bufferCapture = ArgumentCaptor.forClass(ByteBuffer.class);
        fileRecordsMock.readInto((ByteBuffer)bufferCapture.capture(), ArgumentMatchers.anyInt());
        Mockito.when((Object)BoxedUnit.UNIT).thenAnswer(x$2 -> {
            latch.await();
            ByteBuffer buffer = (ByteBuffer)bufferCapture.getValue();
            buffer.put(records.buffer().duplicate());
            return buffer.flip();
        });
        int coordinatorEpoch = 0;
        TransactionPartitionAndLeaderEpoch partitionAndLeaderEpoch = new TransactionPartitionAndLeaderEpoch(this.partitionId(), coordinatorEpoch);
        Thread loadingThread = new Thread(() -> this.transactionManager().loadTransactionsForTxnTopicPartition(this.partitionId(), coordinatorEpoch, (Function4 & Serializable & scala.Serializable)(x$3, x$4, x$5, x$6) -> {
            TransactionStateManagerTest.$anonfun$testDeleteLoadingPartition$3(BoxesRunTime.unboxToInt((Object)x$3), x$4, x$5, x$6);
            return BoxedUnit.UNIT;
        }));
        loadingThread.start();
        long x$3 = 10L;
        long x$4 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!TransactionStateManagerTest.$anonfun$testDeleteLoadingPartition$4(this, partitionAndLeaderEpoch)) {
            if (System.currentTimeMillis() > waitUntilTrue_startTime + x$4) {
                Assertions.fail((String)TransactionStateManagerTest.$anonfun$testDeleteLoadingPartition$5());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(x$4), x$3));
        }
        this.transactionManager().removeTransactionsForTxnTopicPartition(this.partitionId());
        Assertions.assertFalse((boolean)this.transactionManager().loadingPartitions().contains((Object)partitionAndLeaderEpoch));
        latch.countDown();
        loadingThread.join();
        Assertions.assertEquals((Object)package$.MODULE$.Left().apply((Object)Errors.NOT_COORDINATOR), (Object)this.transactionManager().getTransactionState(this.txnMetadata1().transactionalId()));
    }

    @Test
    public void testLoadAndRemoveTransactionsForPartition() {
        this.txnMetadata1().state_$eq((TransactionState)Ongoing$.MODULE$);
        this.txnMetadata1().addPartitions((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition("topic1", 0), new TopicPartition("topic1", 1)})));
        this.txnRecords().$plus$eq((Object)new SimpleRecord(this.txnMessageKeyBytes1(), TransactionLog$.MODULE$.valueToBytes(this.txnMetadata1().prepareNoTransit(), true)));
        this.txnMetadata1().addPartitions((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition("topic2", 0), new TopicPartition("topic2", 1), new TopicPartition("topic2", 2)})));
        this.txnRecords().$plus$eq((Object)new SimpleRecord(this.txnMessageKeyBytes1(), TransactionLog$.MODULE$.valueToBytes(this.txnMetadata1().prepareNoTransit(), true)));
        this.txnMetadata1().state_$eq((TransactionState)PrepareCommit$.MODULE$);
        this.txnRecords().$plus$eq((Object)new SimpleRecord(this.txnMessageKeyBytes1(), TransactionLog$.MODULE$.valueToBytes(this.txnMetadata1().prepareNoTransit(), true)));
        this.txnMetadata2().state_$eq((TransactionState)Ongoing$.MODULE$);
        this.txnMetadata2().addPartitions((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition("topic3", 0), new TopicPartition("topic3", 1), new TopicPartition("topic3", 2)})));
        this.txnRecords().$plus$eq((Object)new SimpleRecord(this.txnMessageKeyBytes2(), TransactionLog$.MODULE$.valueToBytes(this.txnMetadata2().prepareNoTransit(), true)));
        this.txnMetadata2().state_$eq((TransactionState)PrepareAbort$.MODULE$);
        this.txnRecords().$plus$eq((Object)new SimpleRecord(this.txnMessageKeyBytes2(), TransactionLog$.MODULE$.valueToBytes(this.txnMetadata2().prepareNoTransit(), true)));
        this.txnMetadata2().state_$eq((TransactionState)CompleteAbort$.MODULE$);
        this.txnRecords().$plus$eq((Object)new SimpleRecord(this.txnMessageKeyBytes2(), TransactionLog$.MODULE$.valueToBytes(this.txnMetadata2().prepareNoTransit(), true)));
        this.txnMetadata2().state_$eq((TransactionState)Empty$.MODULE$);
        this.txnMetadata2().topicPartitions().clear();
        this.txnRecords().$plus$eq((Object)new SimpleRecord(this.txnMessageKeyBytes2(), TransactionLog$.MODULE$.valueToBytes(this.txnMetadata2().prepareNoTransit(), true)));
        long startOffset = 15L;
        MemoryRecords records = MemoryRecords.withRecords((long)startOffset, (Compression)Compression.NONE, (SimpleRecord[])((SimpleRecord[])this.txnRecords().toArray(ClassTag$.MODULE$.apply(SimpleRecord.class))));
        this.prepareTxnLog(this.topicPartition(), startOffset, records);
        this.transactionManager().getTransactionState(this.transactionalId1()).fold((Function1 & Serializable & scala.Serializable)err -> {
            TransactionStateManagerTest.$anonfun$testLoadAndRemoveTransactionsForPartition$1(err);
            return BoxedUnit.UNIT;
        }, (Function1 & Serializable & scala.Serializable)x$7 -> (Nothing$)Assertions.fail((String)new StringBuilder(44).append(this.transactionalId1()).append("'s transaction state is already in the cache").toString()));
        this.transactionManager().getTransactionState(this.transactionalId2()).fold((Function1 & Serializable & scala.Serializable)err -> {
            TransactionStateManagerTest.$anonfun$testLoadAndRemoveTransactionsForPartition$3(err);
            return BoxedUnit.UNIT;
        }, (Function1 & Serializable & scala.Serializable)x$8 -> (Nothing$)Assertions.fail((String)new StringBuilder(44).append(this.transactionalId2()).append("'s transaction state is already in the cache").toString()));
        this.transactionManager().loadTransactionsForTxnTopicPartition(this.partitionId(), 0, (Function4 & Serializable & scala.Serializable)(x$9, x$10, x$11, x$12) -> {
            TransactionStateManagerTest.$anonfun$testLoadAndRemoveTransactionsForPartition$5(BoxesRunTime.unboxToInt((Object)x$9), x$10, x$11, x$12);
            return BoxedUnit.UNIT;
        });
        this.scheduler().tick();
        this.transactionManager().getTransactionState(this.transactionalId1()).fold((Function1 & Serializable & scala.Serializable)err -> (Nothing$)Assertions.fail((String)new StringBuilder(42).append(this.transactionalId1()).append("'s transaction state access returns error ").append(err).toString()), (Function1 & Serializable & scala.Serializable)entry -> (CoordinatorEpochAndTxnMetadata)entry.getOrElse((Function0 & Serializable & scala.Serializable)() -> (Nothing$)Assertions.fail((String)new StringBuilder(50).append(this.transactionalId1()).append("'s transaction state was not loaded into the cache").toString())));
        CoordinatorEpochAndTxnMetadata cachedPidMetadata1 = (CoordinatorEpochAndTxnMetadata)this.transactionManager().getTransactionState(this.transactionalId1()).fold((Function1 & Serializable & scala.Serializable)err -> {
            throw new AssertionError((Object)new StringBuilder(42).append(this.transactionalId1()).append("'s transaction state access returns error ").append(err).toString());
        }, (Function1 & Serializable & scala.Serializable)entry -> (CoordinatorEpochAndTxnMetadata)entry.getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new AssertionError((Object)new StringBuilder(50).append(this.transactionalId1()).append("'s transaction state was not loaded into the cache").toString());
        }));
        CoordinatorEpochAndTxnMetadata cachedPidMetadata2 = (CoordinatorEpochAndTxnMetadata)this.transactionManager().getTransactionState(this.transactionalId2()).fold((Function1 & Serializable & scala.Serializable)err -> {
            throw new AssertionError((Object)new StringBuilder(42).append(this.transactionalId2()).append("'s transaction state access returns error ").append(err).toString());
        }, (Function1 & Serializable & scala.Serializable)entry -> (CoordinatorEpochAndTxnMetadata)entry.getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new AssertionError((Object)new StringBuilder(50).append(this.transactionalId2()).append("'s transaction state was not loaded into the cache").toString());
        }));
        Assertions.assertEquals((Object)this.txnMetadata1(), (Object)cachedPidMetadata1.transactionMetadata());
        Assertions.assertEquals((Object)this.txnMetadata2(), (Object)cachedPidMetadata2.transactionMetadata());
        this.transactionManager().removeTransactionsForTxnTopicPartition(this.partitionId(), this.coordinatorEpoch());
        this.scheduler().tick();
        this.transactionManager().getTransactionState(this.transactionalId1()).fold((Function1 & Serializable & scala.Serializable)err -> {
            TransactionStateManagerTest.$anonfun$testLoadAndRemoveTransactionsForPartition$15(err);
            return BoxedUnit.UNIT;
        }, (Function1 & Serializable & scala.Serializable)x$13 -> (Nothing$)Assertions.fail((String)new StringBuilder(42).append(this.transactionalId1()).append("'s transaction state is still in the cache").toString()));
        this.transactionManager().getTransactionState(this.transactionalId2()).fold((Function1 & Serializable & scala.Serializable)err -> {
            TransactionStateManagerTest.$anonfun$testLoadAndRemoveTransactionsForPartition$17(err);
            return BoxedUnit.UNIT;
        }, (Function1 & Serializable & scala.Serializable)x$14 -> (Nothing$)Assertions.fail((String)new StringBuilder(42).append(this.transactionalId2()).append("'s transaction state is still in the cache").toString()));
    }

    @Test
    public void testCompleteTransitionWhenAppendSucceeded() {
        this.transactionManager().addLoadedTransactionsToCache(this.partitionId(), this.coordinatorEpoch(), new Pool((Option)Pool$.MODULE$.$lessinit$greater$default$1()));
        this.transactionManager().putTransactionStateIfNotExists(this.txnMetadata1());
        this.prepareForTxnMessageAppend(Errors.NONE);
        this.expectedError_$eq(Errors.NONE);
        TxnTransitMetadata newMetadata = this.txnMetadata1().prepareAddPartitions((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition("topic1", 0), new TopicPartition("topic1", 1)})), this.time().milliseconds());
        String x$1 = this.transactionalId1();
        int x$2 = this.coordinatorEpoch();
        Function1 & Serializable & scala.Serializable x$4 = (Function1 & Serializable & scala.Serializable)error -> {
            this.assertCallback(error);
            return BoxedUnit.UNIT;
        };
        RequestLocal x$5 = RequestLocal$.MODULE$.withThreadConfinedCaching();
        Function1 x$6 = this.transactionManager().appendTransactionToLog$default$5();
        this.transactionManager().appendTransactionToLog(x$1, x$2, newMetadata, (Function1)x$4, x$6, x$5);
        Assertions.assertEquals((Object)package$.MODULE$.Right().apply((Object)new Some((Object)new CoordinatorEpochAndTxnMetadata(this.coordinatorEpoch(), this.txnMetadata1()))), (Object)this.transactionManager().getTransactionState(this.transactionalId1()));
        Assertions.assertTrue((boolean)this.txnMetadata1().pendingState().isEmpty());
    }

    @Test
    public void testAppendFailToCoordinatorNotAvailableError() {
        this.transactionManager().addLoadedTransactionsToCache(this.partitionId(), this.coordinatorEpoch(), new Pool((Option)Pool$.MODULE$.$lessinit$greater$default$1()));
        this.transactionManager().putTransactionStateIfNotExists(this.txnMetadata1());
        this.expectedError_$eq(Errors.COORDINATOR_NOT_AVAILABLE);
        TxnTransitMetadata failedMetadata = this.txnMetadata1().prepareAddPartitions((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition("topic2", 0)})), this.time().milliseconds());
        this.prepareForTxnMessageAppend(Errors.UNKNOWN_TOPIC_OR_PARTITION);
        RequestLocal requestLocal = RequestLocal$.MODULE$.withThreadConfinedCaching();
        String x$1 = this.transactionalId1();
        int x$2 = 10;
        Function1 & Serializable & scala.Serializable x$4 = (Function1 & Serializable & scala.Serializable)error -> {
            this.assertCallback(error);
            return BoxedUnit.UNIT;
        };
        Function1 x$6 = this.transactionManager().appendTransactionToLog$default$5();
        this.transactionManager().appendTransactionToLog(x$1, x$2, failedMetadata, (Function1)x$4, x$6, requestLocal);
        Assertions.assertEquals((Object)package$.MODULE$.Right().apply((Object)new Some((Object)new CoordinatorEpochAndTxnMetadata(this.coordinatorEpoch(), this.txnMetadata1()))), (Object)this.transactionManager().getTransactionState(this.transactionalId1()));
        Assertions.assertTrue((boolean)this.txnMetadata1().pendingState().isEmpty());
        failedMetadata = this.txnMetadata1().prepareAddPartitions((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition("topic2", 0)})), this.time().milliseconds());
        this.prepareForTxnMessageAppend(Errors.NOT_ENOUGH_REPLICAS);
        String x$7 = this.transactionalId1();
        int x$8 = 10;
        Function1 & Serializable & scala.Serializable x$10 = (Function1 & Serializable & scala.Serializable)error -> {
            this.assertCallback(error);
            return BoxedUnit.UNIT;
        };
        Function1 x$12 = this.transactionManager().appendTransactionToLog$default$5();
        this.transactionManager().appendTransactionToLog(x$7, x$8, failedMetadata, (Function1)x$10, x$12, requestLocal);
        Assertions.assertEquals((Object)package$.MODULE$.Right().apply((Object)new Some((Object)new CoordinatorEpochAndTxnMetadata(this.coordinatorEpoch(), this.txnMetadata1()))), (Object)this.transactionManager().getTransactionState(this.transactionalId1()));
        Assertions.assertTrue((boolean)this.txnMetadata1().pendingState().isEmpty());
        failedMetadata = this.txnMetadata1().prepareAddPartitions((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition("topic2", 0)})), this.time().milliseconds());
        this.prepareForTxnMessageAppend(Errors.NOT_ENOUGH_REPLICAS_AFTER_APPEND);
        String x$13 = this.transactionalId1();
        int x$14 = 10;
        Function1 & Serializable & scala.Serializable x$16 = (Function1 & Serializable & scala.Serializable)error -> {
            this.assertCallback(error);
            return BoxedUnit.UNIT;
        };
        Function1 x$18 = this.transactionManager().appendTransactionToLog$default$5();
        this.transactionManager().appendTransactionToLog(x$13, x$14, failedMetadata, (Function1)x$16, x$18, requestLocal);
        Assertions.assertEquals((Object)package$.MODULE$.Right().apply((Object)new Some((Object)new CoordinatorEpochAndTxnMetadata(this.coordinatorEpoch(), this.txnMetadata1()))), (Object)this.transactionManager().getTransactionState(this.transactionalId1()));
        Assertions.assertTrue((boolean)this.txnMetadata1().pendingState().isEmpty());
        failedMetadata = this.txnMetadata1().prepareAddPartitions((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition("topic2", 0)})), this.time().milliseconds());
        this.prepareForTxnMessageAppend(Errors.REQUEST_TIMED_OUT);
        String x$19 = this.transactionalId1();
        int x$20 = 10;
        Function1 & Serializable & scala.Serializable x$22 = (Function1 & Serializable & scala.Serializable)error -> {
            this.assertCallback(error);
            return BoxedUnit.UNIT;
        };
        Function1 x$24 = this.transactionManager().appendTransactionToLog$default$5();
        this.transactionManager().appendTransactionToLog(x$19, x$20, failedMetadata, (Function1)x$22, x$24, requestLocal);
        Assertions.assertEquals((Object)package$.MODULE$.Right().apply((Object)new Some((Object)new CoordinatorEpochAndTxnMetadata(this.coordinatorEpoch(), this.txnMetadata1()))), (Object)this.transactionManager().getTransactionState(this.transactionalId1()));
        Assertions.assertTrue((boolean)this.txnMetadata1().pendingState().isEmpty());
    }

    @Test
    public void testAppendFailToNotCoordinatorError() {
        this.transactionManager().addLoadedTransactionsToCache(this.partitionId(), this.coordinatorEpoch(), new Pool((Option)Pool$.MODULE$.$lessinit$greater$default$1()));
        this.transactionManager().putTransactionStateIfNotExists(this.txnMetadata1());
        this.expectedError_$eq(Errors.NOT_COORDINATOR);
        TxnTransitMetadata failedMetadata = this.txnMetadata1().prepareAddPartitions((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition("topic2", 0)})), this.time().milliseconds());
        this.prepareForTxnMessageAppend(Errors.NOT_LEADER_OR_FOLLOWER);
        RequestLocal requestLocal = RequestLocal$.MODULE$.withThreadConfinedCaching();
        String x$1 = this.transactionalId1();
        int x$2 = 10;
        Function1 & Serializable & scala.Serializable x$4 = (Function1 & Serializable & scala.Serializable)error -> {
            this.assertCallback(error);
            return BoxedUnit.UNIT;
        };
        Function1 x$6 = this.transactionManager().appendTransactionToLog$default$5();
        this.transactionManager().appendTransactionToLog(x$1, x$2, failedMetadata, (Function1)x$4, x$6, requestLocal);
        Assertions.assertEquals((Object)package$.MODULE$.Right().apply((Object)new Some((Object)new CoordinatorEpochAndTxnMetadata(this.coordinatorEpoch(), this.txnMetadata1()))), (Object)this.transactionManager().getTransactionState(this.transactionalId1()));
        Assertions.assertTrue((boolean)this.txnMetadata1().pendingState().isEmpty());
        failedMetadata = this.txnMetadata1().prepareAddPartitions((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition("topic2", 0)})), this.time().milliseconds());
        this.prepareForTxnMessageAppend(Errors.NONE);
        this.transactionManager().removeTransactionsForTxnTopicPartition(this.partitionId(), this.coordinatorEpoch());
        String x$7 = this.transactionalId1();
        int x$8 = 10;
        Function1 & Serializable & scala.Serializable x$10 = (Function1 & Serializable & scala.Serializable)error -> {
            this.assertCallback(error);
            return BoxedUnit.UNIT;
        };
        Function1 x$12 = this.transactionManager().appendTransactionToLog$default$5();
        this.transactionManager().appendTransactionToLog(x$7, x$8, failedMetadata, (Function1)x$10, x$12, requestLocal);
        this.prepareForTxnMessageAppend(Errors.NONE);
        this.transactionManager().removeTransactionsForTxnTopicPartition(this.partitionId(), this.coordinatorEpoch());
        this.transactionManager().addLoadedTransactionsToCache(this.partitionId(), this.coordinatorEpoch() + 1, new Pool((Option)Pool$.MODULE$.$lessinit$greater$default$1()));
        this.transactionManager().putTransactionStateIfNotExists(this.txnMetadata1());
        String x$13 = this.transactionalId1();
        int x$14 = 10;
        Function1 & Serializable & scala.Serializable x$16 = (Function1 & Serializable & scala.Serializable)error -> {
            this.assertCallback(error);
            return BoxedUnit.UNIT;
        };
        Function1 x$18 = this.transactionManager().appendTransactionToLog$default$5();
        this.transactionManager().appendTransactionToLog(x$13, x$14, failedMetadata, (Function1)x$16, x$18, requestLocal);
        this.prepareForTxnMessageAppend(Errors.NONE);
        this.transactionManager().removeTransactionsForTxnTopicPartition(this.partitionId(), this.coordinatorEpoch());
        this.transactionManager().addLoadedTransactionsToCache(this.partitionId(), this.coordinatorEpoch(), new Pool((Option)Pool$.MODULE$.$lessinit$greater$default$1()));
        String x$19 = this.transactionalId1();
        int x$20 = 10;
        Function1 & Serializable & scala.Serializable x$22 = (Function1 & Serializable & scala.Serializable)error -> {
            this.assertCallback(error);
            return BoxedUnit.UNIT;
        };
        Function1 x$24 = this.transactionManager().appendTransactionToLog$default$5();
        this.transactionManager().appendTransactionToLog(x$19, x$20, failedMetadata, (Function1)x$22, x$24, requestLocal);
    }

    @Test
    public void testAppendFailToCoordinatorLoadingError() {
        this.transactionManager().addLoadedTransactionsToCache(this.partitionId(), this.coordinatorEpoch(), new Pool((Option)Pool$.MODULE$.$lessinit$greater$default$1()));
        this.transactionManager().putTransactionStateIfNotExists(this.txnMetadata1());
        this.expectedError_$eq(Errors.COORDINATOR_LOAD_IN_PROGRESS);
        TxnTransitMetadata failedMetadata = this.txnMetadata1().prepareAddPartitions((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition("topic2", 0)})), this.time().milliseconds());
        this.prepareForTxnMessageAppend(Errors.NONE);
        this.transactionManager().removeTransactionsForTxnTopicPartition(this.partitionId(), this.coordinatorEpoch());
        this.transactionManager().addLoadingPartition(this.partitionId(), this.coordinatorEpoch() + 1);
        String x$1 = this.transactionalId1();
        int x$2 = 10;
        Function1 & Serializable & scala.Serializable x$4 = (Function1 & Serializable & scala.Serializable)error -> {
            this.assertCallback(error);
            return BoxedUnit.UNIT;
        };
        RequestLocal x$5 = RequestLocal$.MODULE$.withThreadConfinedCaching();
        Function1 x$6 = this.transactionManager().appendTransactionToLog$default$5();
        this.transactionManager().appendTransactionToLog(x$1, x$2, failedMetadata, (Function1)x$4, x$6, x$5);
    }

    @Test
    public void testAppendFailToUnknownError() {
        this.transactionManager().addLoadedTransactionsToCache(this.partitionId(), this.coordinatorEpoch(), new Pool((Option)Pool$.MODULE$.$lessinit$greater$default$1()));
        this.transactionManager().putTransactionStateIfNotExists(this.txnMetadata1());
        this.expectedError_$eq(Errors.UNKNOWN_SERVER_ERROR);
        TxnTransitMetadata failedMetadata = this.txnMetadata1().prepareAddPartitions((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition("topic2", 0)})), this.time().milliseconds());
        this.prepareForTxnMessageAppend(Errors.MESSAGE_TOO_LARGE);
        RequestLocal requestLocal = RequestLocal$.MODULE$.withThreadConfinedCaching();
        String x$1 = this.transactionalId1();
        int x$2 = 10;
        Function1 & Serializable & scala.Serializable x$4 = (Function1 & Serializable & scala.Serializable)error -> {
            this.assertCallback(error);
            return BoxedUnit.UNIT;
        };
        Function1 x$6 = this.transactionManager().appendTransactionToLog$default$5();
        this.transactionManager().appendTransactionToLog(x$1, x$2, failedMetadata, (Function1)x$4, x$6, requestLocal);
        Assertions.assertEquals((Object)package$.MODULE$.Right().apply((Object)new Some((Object)new CoordinatorEpochAndTxnMetadata(this.coordinatorEpoch(), this.txnMetadata1()))), (Object)this.transactionManager().getTransactionState(this.transactionalId1()));
        Assertions.assertTrue((boolean)this.txnMetadata1().pendingState().isEmpty());
        failedMetadata = this.txnMetadata1().prepareAddPartitions((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition("topic2", 0)})), this.time().milliseconds());
        this.prepareForTxnMessageAppend(Errors.RECORD_LIST_TOO_LARGE);
        String x$7 = this.transactionalId1();
        int x$8 = 10;
        Function1 & Serializable & scala.Serializable x$10 = (Function1 & Serializable & scala.Serializable)error -> {
            this.assertCallback(error);
            return BoxedUnit.UNIT;
        };
        Function1 x$12 = this.transactionManager().appendTransactionToLog$default$5();
        this.transactionManager().appendTransactionToLog(x$7, x$8, failedMetadata, (Function1)x$10, x$12, requestLocal);
        Assertions.assertEquals((Object)package$.MODULE$.Right().apply((Object)new Some((Object)new CoordinatorEpochAndTxnMetadata(this.coordinatorEpoch(), this.txnMetadata1()))), (Object)this.transactionManager().getTransactionState(this.transactionalId1()));
        Assertions.assertTrue((boolean)this.txnMetadata1().pendingState().isEmpty());
    }

    @Test
    public void testPendingStateNotResetOnRetryAppend() {
        this.transactionManager().addLoadedTransactionsToCache(this.partitionId(), this.coordinatorEpoch(), new Pool((Option)Pool$.MODULE$.$lessinit$greater$default$1()));
        this.transactionManager().putTransactionStateIfNotExists(this.txnMetadata1());
        this.expectedError_$eq(Errors.COORDINATOR_NOT_AVAILABLE);
        TxnTransitMetadata failedMetadata = this.txnMetadata1().prepareAddPartitions((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition("topic2", 0)})), this.time().milliseconds());
        this.prepareForTxnMessageAppend(Errors.UNKNOWN_TOPIC_OR_PARTITION);
        this.transactionManager().appendTransactionToLog(this.transactionalId1(), 10, failedMetadata, (Function1 & Serializable & scala.Serializable)error -> {
            this.assertCallback(error);
            return BoxedUnit.UNIT;
        }, (Function1 & Serializable & scala.Serializable)x$15 -> BoxesRunTime.boxToBoolean((boolean)TransactionStateManagerTest.$anonfun$testPendingStateNotResetOnRetryAppend$2(x$15)), RequestLocal$.MODULE$.withThreadConfinedCaching());
        Assertions.assertEquals((Object)package$.MODULE$.Right().apply((Object)new Some((Object)new CoordinatorEpochAndTxnMetadata(this.coordinatorEpoch(), this.txnMetadata1()))), (Object)this.transactionManager().getTransactionState(this.transactionalId1()));
        Assertions.assertEquals((Object)new Some((Object)Ongoing$.MODULE$), (Object)this.txnMetadata1().pendingState());
    }

    @Test
    public void testAppendTransactionToLogWhileProducerFenced() {
        this.transactionManager().addLoadedTransactionsToCache(this.partitionId(), 0, new Pool((Option)Pool$.MODULE$.$lessinit$greater$default$1()));
        this.transactionManager().putTransactionStateIfNotExists(this.txnMetadata1());
        this.prepareForTxnMessageAppend(Errors.NONE);
        this.expectedError_$eq(Errors.NOT_COORDINATOR);
        TxnTransitMetadata newMetadata = this.txnMetadata1().prepareAddPartitions((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition("topic1", 0), new TopicPartition("topic1", 1)})), this.time().milliseconds());
        this.txnMetadata1().producerEpoch_$eq((short)(this.txnMetadata1().producerEpoch() + 1));
        String x$1 = this.transactionalId1();
        int x$2 = 10;
        Function1 & Serializable & scala.Serializable x$4 = (Function1 & Serializable & scala.Serializable)error -> {
            this.assertCallback(error);
            return BoxedUnit.UNIT;
        };
        RequestLocal x$5 = RequestLocal$.MODULE$.withThreadConfinedCaching();
        Function1 x$6 = this.transactionManager().appendTransactionToLog$default$5();
        this.transactionManager().appendTransactionToLog(x$1, x$2, newMetadata, (Function1)x$4, x$6, x$5);
    }

    @Test
    public void testAppendTransactionToLogWhilePendingStateChanged() {
        this.transactionManager().addLoadedTransactionsToCache(this.partitionId(), this.coordinatorEpoch(), new Pool((Option)Pool$.MODULE$.$lessinit$greater$default$1()));
        this.transactionManager().putTransactionStateIfNotExists(this.txnMetadata1());
        this.prepareForTxnMessageAppend(Errors.NONE);
        this.expectedError_$eq(Errors.INVALID_PRODUCER_EPOCH);
        TxnTransitMetadata newMetadata = this.txnMetadata1().prepareAddPartitions((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition("topic1", 0), new TopicPartition("topic1", 1)})), this.time().milliseconds());
        this.txnMetadata1().pendingState_$eq((Option)None$.MODULE$);
        Assertions.assertThrows(IllegalStateException.class, () -> {
            String x$1 = this.transactionalId1();
            int x$2 = 10;
            Function1 & Serializable & scala.Serializable x$4 = (Function1 & Serializable & scala.Serializable)error -> {
                this.assertCallback(error);
                return BoxedUnit.UNIT;
            };
            RequestLocal x$5 = RequestLocal$.MODULE$.withThreadConfinedCaching();
            Function1 x$6 = this.transactionManager().appendTransactionToLog$default$5();
            this.transactionManager().appendTransactionToLog(x$1, x$2, newMetadata, (Function1)x$4, x$6, x$5);
        });
    }

    @Test
    public void shouldReturnNotCoordinatorErrorIfTransactionIdPartitionNotOwned() {
        this.transactionManager().getTransactionState(this.transactionalId1()).fold((Function1 & Serializable & scala.Serializable)err -> {
            TransactionStateManagerTest.$anonfun$shouldReturnNotCoordinatorErrorIfTransactionIdPartitionNotOwned$1(err);
            return BoxedUnit.UNIT;
        }, (Function1 & Serializable & scala.Serializable)x$16 -> (Nothing$)Assertions.fail((String)new StringBuilder(44).append(this.transactionalId1()).append("'s transaction state is already in the cache").toString()));
    }

    @Test
    public void testListTransactionsWithCoordinatorLoadingInProgress() {
        this.transactionManager().addLoadingPartition(0, 15);
        ListTransactionsResponseData listResponse = this.transactionManager().listTransactionStates(Predef$.MODULE$.Set().empty(), Predef$.MODULE$.Set().empty(), -1L);
        Assertions.assertEquals((Object)Errors.COORDINATOR_LOAD_IN_PROGRESS, (Object)Errors.forCode((short)listResponse.errorCode()));
    }

    @Test
    public void testListTransactionsFiltering() {
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.numPartitions()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)partitionId -> this.transactionManager().addLoadedTransactionsToCache(partitionId, 0, new Pool((Option)Pool$.MODULE$.$lessinit$greater$default$1())));
        this.putTransaction$1("t0", 0L, (TransactionState)Ongoing$.MODULE$);
        this.putTransaction$1("t1", 1L, (TransactionState)Ongoing$.MODULE$);
        this.time().sleep(1000L);
        this.putTransaction$1("t2", 2L, (TransactionState)PrepareCommit$.MODULE$);
        this.putTransaction$1("t3", 3L, (TransactionState)PrepareAbort$.MODULE$);
        this.time().sleep(1000L);
        this.putTransaction$1("t4", 4L, (TransactionState)CompleteCommit$.MODULE$);
        this.putTransaction$1("t5", 5L, (TransactionState)CompleteAbort$.MODULE$);
        this.putTransaction$1("t6", 6L, (TransactionState)CompleteAbort$.MODULE$);
        this.putTransaction$1("t7", 7L, (TransactionState)PrepareEpochFence$.MODULE$);
        this.time().sleep(1000L);
        this.putTransaction$1("t8", 8L, (TransactionState)Dead$.MODULE$);
        this.assertListTransactions$1((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"t0", "t1", "t2", "t3", "t4", "t5", "t6", "t7"})), TransactionStateManagerTest.assertListTransactions$default$2$1(), TransactionStateManagerTest.assertListTransactions$default$3$1(), TransactionStateManagerTest.assertListTransactions$default$4$1());
        scala.collection.immutable.Set x$1 = (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"t0", "t1", "t2", "t3", "t4", "t5", "t6", "t7"}));
        long x$2 = 0L;
        scala.collection.immutable.Set x$3 = TransactionStateManagerTest.assertListTransactions$default$2$1();
        scala.collection.immutable.Set x$4 = TransactionStateManagerTest.assertListTransactions$default$3$1();
        this.assertListTransactions$1(x$1, x$3, x$4, x$2);
        scala.collection.immutable.Set x$5 = (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"t0", "t1", "t2", "t3"}));
        long x$6 = 1000L;
        scala.collection.immutable.Set x$7 = TransactionStateManagerTest.assertListTransactions$default$2$1();
        scala.collection.immutable.Set x$8 = TransactionStateManagerTest.assertListTransactions$default$3$1();
        this.assertListTransactions$1(x$5, x$7, x$8, x$6);
        scala.collection.immutable.Set x$9 = (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"t0", "t1"}));
        long x$10 = 2000L;
        scala.collection.immutable.Set x$11 = TransactionStateManagerTest.assertListTransactions$default$2$1();
        scala.collection.immutable.Set x$12 = TransactionStateManagerTest.assertListTransactions$default$3$1();
        this.assertListTransactions$1(x$9, x$11, x$12, x$10);
        scala.collection.immutable.Set x$13 = (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$);
        long x$14 = 3000L;
        scala.collection.immutable.Set x$15 = TransactionStateManagerTest.assertListTransactions$default$2$1();
        scala.collection.immutable.Set x$16 = TransactionStateManagerTest.assertListTransactions$default$3$1();
        this.assertListTransactions$1(x$13, x$15, x$16, x$14);
        scala.collection.immutable.Set x$17 = (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"t0", "t1"}));
        scala.collection.immutable.Set x$18 = (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Ongoing"}));
        scala.collection.immutable.Set x$19 = TransactionStateManagerTest.assertListTransactions$default$2$1();
        long x$20 = TransactionStateManagerTest.assertListTransactions$default$4$1();
        this.assertListTransactions$1(x$17, x$19, x$18, x$20);
        scala.collection.immutable.Set x$21 = (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"t0", "t1"}));
        scala.collection.immutable.Set x$22 = (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Ongoing", "UnknownState"}));
        scala.collection.immutable.Set x$23 = TransactionStateManagerTest.assertListTransactions$default$2$1();
        long x$24 = TransactionStateManagerTest.assertListTransactions$default$4$1();
        this.assertListTransactions$1(x$21, x$23, x$22, x$24);
        scala.collection.immutable.Set x$25 = (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"t2", "t4"}));
        scala.collection.immutable.Set x$26 = (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"PrepareCommit", "CompleteCommit"}));
        scala.collection.immutable.Set x$27 = TransactionStateManagerTest.assertListTransactions$default$2$1();
        long x$28 = TransactionStateManagerTest.assertListTransactions$default$4$1();
        this.assertListTransactions$1(x$25, x$27, x$26, x$28);
        scala.collection.immutable.Set x$29 = (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$);
        scala.collection.immutable.Set x$30 = (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"UnknownState"}));
        scala.collection.immutable.Set x$31 = TransactionStateManagerTest.assertListTransactions$default$2$1();
        long x$32 = TransactionStateManagerTest.assertListTransactions$default$4$1();
        this.assertListTransactions$1(x$29, x$31, x$30, x$32);
        this.assertListTransactions$1((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"t5"})), (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapLongArray(new long[]{5L})), TransactionStateManagerTest.assertListTransactions$default$3$1(), TransactionStateManagerTest.assertListTransactions$default$4$1());
        this.assertListTransactions$1((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"t5", "t6"})), (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapLongArray(new long[]{5L, 6L, 8L, 9L})), TransactionStateManagerTest.assertListTransactions$default$3$1(), TransactionStateManagerTest.assertListTransactions$default$4$1());
        this.assertListTransactions$1((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"t4"})), (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapLongArray(new long[]{4L, 5L})), (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"CompleteCommit"})), TransactionStateManagerTest.assertListTransactions$default$4$1());
        this.assertListTransactions$1((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"t4", "t5"})), (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapLongArray(new long[]{4L, 5L})), (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"CompleteCommit", "CompleteAbort"})), TransactionStateManagerTest.assertListTransactions$default$4$1());
        this.assertListTransactions$1((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$), (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapLongArray(new long[]{3L, 6L})), (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"UnknownState"})), TransactionStateManagerTest.assertListTransactions$default$4$1());
        this.assertListTransactions$1((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$), (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapLongArray(new long[]{10L})), (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"CompleteCommit"})), TransactionStateManagerTest.assertListTransactions$default$4$1());
        scala.collection.immutable.Set x$33 = (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$);
        scala.collection.immutable.Set x$34 = (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Dead"}));
        scala.collection.immutable.Set x$35 = TransactionStateManagerTest.assertListTransactions$default$2$1();
        long x$36 = TransactionStateManagerTest.assertListTransactions$default$4$1();
        this.assertListTransactions$1(x$33, x$35, x$34, x$36);
    }

    @Test
    public void shouldOnlyConsiderTransactionsInTheOngoingStateToAbort() {
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.numPartitions()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)partitionId -> this.transactionManager().addLoadedTransactionsToCache(partitionId, 0, new Pool((Option)Pool$.MODULE$.$lessinit$greater$default$1())));
        this.transactionManager().putTransactionStateIfNotExists(this.transactionMetadata("ongoing", 0L, (TransactionState)Ongoing$.MODULE$, this.transactionMetadata$default$4()));
        this.transactionManager().putTransactionStateIfNotExists(this.transactionMetadata("not-expiring", 1L, (TransactionState)Ongoing$.MODULE$, 10000));
        this.transactionManager().putTransactionStateIfNotExists(this.transactionMetadata("prepare-commit", 2L, (TransactionState)PrepareCommit$.MODULE$, this.transactionMetadata$default$4()));
        this.transactionManager().putTransactionStateIfNotExists(this.transactionMetadata("prepare-abort", 3L, (TransactionState)PrepareAbort$.MODULE$, this.transactionMetadata$default$4()));
        this.transactionManager().putTransactionStateIfNotExists(this.transactionMetadata("complete-commit", 4L, (TransactionState)CompleteCommit$.MODULE$, this.transactionMetadata$default$4()));
        this.transactionManager().putTransactionStateIfNotExists(this.transactionMetadata("complete-abort", 5L, (TransactionState)CompleteAbort$.MODULE$, this.transactionMetadata$default$4()));
        this.time().sleep(2000L);
        Iterable expiring = this.transactionManager().timedOutTransactions();
        Assertions.assertEquals((Object)new .colon.colon((Object)new TransactionalIdAndProducerIdEpoch("ongoing", 0L, 0), (List)Nil$.MODULE$), (Object)expiring);
    }

    @Test
    public void shouldWriteTxnMarkersForTransactionInPreparedCommitState() {
        this.verifyWritesTxnMarkersInPrepareState((TransactionState)PrepareCommit$.MODULE$);
    }

    @Test
    public void shouldWriteTxnMarkersForTransactionInPreparedAbortState() {
        this.verifyWritesTxnMarkersInPrepareState((TransactionState)PrepareAbort$.MODULE$);
    }

    @Test
    public void shouldRemoveCompleteCommitExpiredTransactionalIds() {
        this.setupAndRunTransactionalIdExpiration(Errors.NONE, (TransactionState)CompleteCommit$.MODULE$);
        this.verifyMetadataDoesntExist(this.transactionalId1());
        this.verifyMetadataDoesExistAndIsUsable(this.transactionalId2());
    }

    @Test
    public void shouldRemoveCompleteAbortExpiredTransactionalIds() {
        this.setupAndRunTransactionalIdExpiration(Errors.NONE, (TransactionState)CompleteAbort$.MODULE$);
        this.verifyMetadataDoesntExist(this.transactionalId1());
        this.verifyMetadataDoesExistAndIsUsable(this.transactionalId2());
    }

    @Test
    public void shouldRemoveEmptyExpiredTransactionalIds() {
        this.setupAndRunTransactionalIdExpiration(Errors.NONE, (TransactionState)Empty$.MODULE$);
        this.verifyMetadataDoesntExist(this.transactionalId1());
        this.verifyMetadataDoesExistAndIsUsable(this.transactionalId2());
    }

    @Test
    public void shouldNotRemoveExpiredTransactionalIdsIfLogAppendFails() {
        this.setupAndRunTransactionalIdExpiration(Errors.NOT_ENOUGH_REPLICAS, (TransactionState)CompleteAbort$.MODULE$);
        this.verifyMetadataDoesExistAndIsUsable(this.transactionalId1());
        this.verifyMetadataDoesExistAndIsUsable(this.transactionalId2());
    }

    @Test
    public void shouldNotRemoveOngoingTransactionalIds() {
        this.setupAndRunTransactionalIdExpiration(Errors.NONE, (TransactionState)Ongoing$.MODULE$);
        this.verifyMetadataDoesExistAndIsUsable(this.transactionalId1());
        this.verifyMetadataDoesExistAndIsUsable(this.transactionalId2());
    }

    @Test
    public void shouldNotRemovePrepareAbortTransactionalIds() {
        this.setupAndRunTransactionalIdExpiration(Errors.NONE, (TransactionState)PrepareAbort$.MODULE$);
        this.verifyMetadataDoesExistAndIsUsable(this.transactionalId1());
        this.verifyMetadataDoesExistAndIsUsable(this.transactionalId2());
    }

    @Test
    public void shouldNotRemovePrepareCommitTransactionalIds() {
        this.setupAndRunTransactionalIdExpiration(Errors.NONE, (TransactionState)PrepareCommit$.MODULE$);
        this.verifyMetadataDoesExistAndIsUsable(this.transactionalId1());
        this.verifyMetadataDoesExistAndIsUsable(this.transactionalId2());
    }

    @Test
    public void testTransactionalExpirationWithTooSmallBatchSize() {
        Range partitionIds = RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.numPartitions());
        int maxBatchSize = 16;
        this.loadTransactionsForPartitions((Seq<Object>)partitionIds);
        scala.collection.immutable.Set<String> allTransactionalIds = this.loadExpiredTransactionalIds(20);
        Mockito.reset((Object[])new ReplicaManager[]{this.replicaManager()});
        this.expectLogConfig((Seq<Object>)partitionIds, maxBatchSize);
        scala.collection.mutable.Map attemptedAppends = Map$.MODULE$.empty();
        this.expectTransactionalIdExpiration(Errors.MESSAGE_TOO_LARGE, (scala.collection.mutable.Map<TopicPartition, Buffer<MemoryRecords>>)attemptedAppends);
        Assertions.assertEquals(allTransactionalIds, this.listExpirableTransactionalIds());
        this.transactionManager().removeExpiredTransactionalIds();
        ((ReplicaManager)Mockito.verify((Object)this.replicaManager(), (VerificationMode)Mockito.atLeastOnce())).appendRecords(ArgumentMatchers.anyLong(), ArgumentMatchers.eq((short)((short)-1)), ArgumentMatchers.eq((boolean)true), (AppendOrigin)ArgumentMatchers.eq((Object)AppendOrigin.COORDINATOR), (Map)ArgumentMatchers.any(), (Function1)ArgumentMatchers.any(), (Option)ArgumentMatchers.any(), (Function1)ArgumentMatchers.any(), (RequestLocal)ArgumentMatchers.any(), (ActionQueue)ArgumentMatchers.any(), (Map)ArgumentMatchers.any());
        attemptedAppends.values().foreach((Function1 & Serializable & scala.Serializable)batches -> {
            batches.foreach((Function1 & Serializable & scala.Serializable)batch -> {
                TransactionStateManagerTest.$anonfun$testTransactionalExpirationWithTooSmallBatchSize$2(maxBatchSize$1, batch);
                return BoxedUnit.UNIT;
            });
            return BoxedUnit.UNIT;
        });
        Assertions.assertEquals(allTransactionalIds, this.listExpirableTransactionalIds());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testTransactionalExpirationWithOfflineLogDir() {
        void var9_9;
        void var8_8;
        int onlinePartitionId = 0;
        int offlinePartitionId = 1;
        Seq partitionIds = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{onlinePartitionId, offlinePartitionId}));
        int maxBatchSize = 512;
        this.loadTransactionsForPartitions((Seq<Object>)partitionIds);
        scala.collection.immutable.Set<String> allTransactionalIds = this.loadExpiredTransactionalIds(20);
        Mockito.reset((Object[])new ReplicaManager[]{this.replicaManager()});
        this.expectLogConfig((Seq<Object>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{onlinePartitionId}))), maxBatchSize);
        Mockito.when((Object)this.replicaManager().getLogConfig(new TopicPartition("__transaction_state", offlinePartitionId))).thenReturn((Object)None$.MODULE$);
        scala.collection.mutable.Map appendedRecords = Map$.MODULE$.empty();
        this.expectTransactionalIdExpiration(Errors.NONE, (scala.collection.mutable.Map<TopicPartition, Buffer<MemoryRecords>>)appendedRecords);
        Assertions.assertEquals(allTransactionalIds, this.listExpirableTransactionalIds());
        this.transactionManager().removeExpiredTransactionalIds();
        ((ReplicaManager)Mockito.verify((Object)this.replicaManager())).appendRecords(ArgumentMatchers.anyLong(), ArgumentMatchers.eq((short)((short)-1)), ArgumentMatchers.eq((boolean)true), (AppendOrigin)ArgumentMatchers.eq((Object)AppendOrigin.COORDINATOR), (Map)ArgumentMatchers.any(), (Function1)ArgumentMatchers.any(), (Option)ArgumentMatchers.any(), (Function1)ArgumentMatchers.any(), (RequestLocal)ArgumentMatchers.any(), (ActionQueue)ArgumentMatchers.any(), (Map)ArgumentMatchers.any());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{onlinePartitionId})), (Object)appendedRecords.keySet().map((Function1 & Serializable & scala.Serializable)x$18 -> BoxesRunTime.boxToInteger((int)x$18.partition()), scala.collection.Set$.MODULE$.canBuildFrom()));
        Tuple2 tuple2 = allTransactionalIds.partition((Function1 & Serializable & scala.Serializable)transactionalId -> BoxesRunTime.boxToBoolean((boolean)TransactionStateManagerTest.$anonfun$testTransactionalExpirationWithOfflineLogDir$2(this, onlinePartitionId, transactionalId)));
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        scala.collection.immutable.Set transactionalIdsForOnlinePartition = (scala.collection.immutable.Set)tuple2._1();
        scala.collection.immutable.Set transactionalIdsForOfflinePartition = (scala.collection.immutable.Set)tuple2._2();
        void transactionalIdsForOnlinePartition2 = var8_8;
        void transactionalIdsForOfflinePartition2 = var9_9;
        scala.collection.immutable.Set<String> expiredTransactionalIds = this.collectTransactionalIdsFromTombstones((scala.collection.mutable.Map<TopicPartition, Buffer<MemoryRecords>>)appendedRecords);
        Assertions.assertEquals((Object)transactionalIdsForOnlinePartition2, expiredTransactionalIds);
        Assertions.assertEquals((Object)transactionalIdsForOfflinePartition2, this.listExpirableTransactionalIds());
    }

    @Test
    public void testTransactionExpirationShouldRespectBatchSize() {
        Range partitionIds = RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.numPartitions());
        int maxBatchSize = 512;
        this.loadTransactionsForPartitions((Seq<Object>)partitionIds);
        scala.collection.immutable.Set<String> allTransactionalIds = this.loadExpiredTransactionalIds(1000);
        Mockito.reset((Object[])new ReplicaManager[]{this.replicaManager()});
        this.expectLogConfig((Seq<Object>)partitionIds, maxBatchSize);
        scala.collection.mutable.Map appendedRecords = Map$.MODULE$.empty();
        this.expectTransactionalIdExpiration(Errors.NONE, (scala.collection.mutable.Map<TopicPartition, Buffer<MemoryRecords>>)appendedRecords);
        Assertions.assertEquals(allTransactionalIds, this.listExpirableTransactionalIds());
        this.transactionManager().removeExpiredTransactionalIds();
        ((ReplicaManager)Mockito.verify((Object)this.replicaManager(), (VerificationMode)Mockito.atLeastOnce())).appendRecords(ArgumentMatchers.anyLong(), ArgumentMatchers.eq((short)((short)-1)), ArgumentMatchers.eq((boolean)true), (AppendOrigin)ArgumentMatchers.eq((Object)AppendOrigin.COORDINATOR), (Map)ArgumentMatchers.any(), (Function1)ArgumentMatchers.any(), (Option)ArgumentMatchers.any(), (Function1)ArgumentMatchers.any(), (RequestLocal)ArgumentMatchers.any(), (ActionQueue)ArgumentMatchers.any(), (Map)ArgumentMatchers.any());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().empty(), this.listExpirableTransactionalIds());
        Assertions.assertEquals((Object)partitionIds.toSet(), (Object)appendedRecords.keys().map((Function1 & Serializable & scala.Serializable)x$20 -> BoxesRunTime.boxToInteger((int)x$20.partition()), Iterable$.MODULE$.canBuildFrom()));
        appendedRecords.values().foreach((Function1 & Serializable & scala.Serializable)batches -> {
            TransactionStateManagerTest.$anonfun$testTransactionExpirationShouldRespectBatchSize$2(maxBatchSize, batches);
            return BoxedUnit.UNIT;
        });
        scala.collection.immutable.Set<String> expiredTransactionalIds = this.collectTransactionalIdsFromTombstones((scala.collection.mutable.Map<TopicPartition, Buffer<MemoryRecords>>)appendedRecords);
        Assertions.assertEquals(allTransactionalIds, expiredTransactionalIds);
    }

    @Test
    public void testTransactionExpirationShouldNotFailWithUninitializedTransactionMetadata() {
        Range partitionIds = RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.numPartitions());
        int maxBatchSize = 512;
        String transactionalId = "id";
        scala.collection.immutable.Set allTransactionalIds = (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{transactionalId}));
        this.loadTransactionsForPartitions((Seq<Object>)partitionIds);
        TransactionMetadata txnMetadata = TransactionMetadata$.MODULE$.apply(transactionalId, 1L, (short)-1, this.transactionTimeoutMs(), (TransactionState)Empty$.MODULE$, this.time().milliseconds());
        this.transactionManager().putTransactionStateIfNotExists(txnMetadata);
        this.time().sleep((long)(this.txnConfig().transactionalIdExpirationMs() + 1));
        Mockito.reset((Object[])new ReplicaManager[]{this.replicaManager()});
        this.expectLogConfig((Seq<Object>)partitionIds, maxBatchSize);
        scala.collection.mutable.Map appendedRecords = Map$.MODULE$.empty();
        this.expectTransactionalIdExpiration(Errors.NONE, (scala.collection.mutable.Map<TopicPartition, Buffer<MemoryRecords>>)appendedRecords);
        this.transactionManager().removeExpiredTransactionalIds();
        ((ReplicaManager)Mockito.verify((Object)this.replicaManager(), (VerificationMode)Mockito.atLeastOnce())).appendRecords(ArgumentMatchers.anyLong(), ArgumentMatchers.eq((short)((short)-1)), ArgumentMatchers.eq((boolean)true), (AppendOrigin)ArgumentMatchers.eq((Object)AppendOrigin.COORDINATOR), (Map)ArgumentMatchers.any(), (Function1)ArgumentMatchers.any(), (Option)ArgumentMatchers.any(), (Function1)ArgumentMatchers.any(), (RequestLocal)ArgumentMatchers.any(), (ActionQueue)ArgumentMatchers.any(), (Map)ArgumentMatchers.any());
        scala.collection.immutable.Set<String> expiredTransactionalIds = this.collectTransactionalIdsFromTombstones((scala.collection.mutable.Map<TopicPartition, Buffer<MemoryRecords>>)appendedRecords);
        Assertions.assertEquals((Object)allTransactionalIds, expiredTransactionalIds);
    }

    private scala.collection.immutable.Set<String> collectTransactionalIdsFromTombstones(scala.collection.mutable.Map<TopicPartition, Buffer<MemoryRecords>> appendedRecords) {
        scala.collection.mutable.Set expiredTransactionalIds = Set$.MODULE$.empty();
        appendedRecords.values().foreach((Function1 & Serializable & scala.Serializable)batches -> {
            batches.foreach((Function1 & Serializable & scala.Serializable)records -> {
                TransactionStateManagerTest.$anonfun$collectTransactionalIdsFromTombstones$2($this, expiredTransactionalIds$1, records);
                return BoxedUnit.UNIT;
            });
            return BoxedUnit.UNIT;
        });
        return expiredTransactionalIds.toSet();
    }

    private scala.collection.immutable.Set<String> loadExpiredTransactionalIds(int numTransactionalIds) {
        scala.collection.mutable.Set allTransactionalIds = Set$.MODULE$.empty();
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), numTransactionalIds).foreach((Function1 & Serializable & scala.Serializable)i -> TransactionStateManagerTest.$anonfun$loadExpiredTransactionalIds$1(this, allTransactionalIds, BoxesRunTime.unboxToInt((Object)i)));
        return allTransactionalIds.toSet();
    }

    private scala.collection.immutable.Set<String> listExpirableTransactionalIds() {
        return ((TraversableOnce)((Buffer)((TraversableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(this.transactionManager().listTransactionStates(Predef$.MODULE$.Set().empty(), Predef$.MODULE$.Set().empty(), -1L).transactionStates()).asScala()).map((Function1 & Serializable & scala.Serializable)x$22 -> x$22.transactionalId(), Buffer$.MODULE$.canBuildFrom())).filter((Function1 & Serializable & scala.Serializable)transactionalId -> BoxesRunTime.boxToBoolean((boolean)TransactionStateManagerTest.$anonfun$listExpirableTransactionalIds$2(this, transactionalId)))).toSet();
    }

    @Test
    public void testSuccessfulReimmigration() {
        this.txnMetadata1().state_$eq((TransactionState)PrepareCommit$.MODULE$);
        this.txnMetadata1().addPartitions((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition("topic1", 0), new TopicPartition("topic1", 1)})));
        this.txnRecords().$plus$eq((Object)new SimpleRecord(this.txnMessageKeyBytes1(), TransactionLog$.MODULE$.valueToBytes(this.txnMetadata1().prepareNoTransit(), true)));
        MemoryRecords records = MemoryRecords.withRecords((long)0L, (Compression)Compression.NONE, (SimpleRecord[])((SimpleRecord[])this.txnRecords().toArray(ClassTag$.MODULE$.apply(SimpleRecord.class))));
        this.prepareTxnLog(this.topicPartition(), 0L, records);
        this.transactionManager().loadTransactionsForTxnTopicPartition(this.partitionId(), 0, (Function4 & Serializable & scala.Serializable)(x$23, x$24, x$25, x$26) -> {
            TransactionStateManagerTest.$anonfun$testSuccessfulReimmigration$1(BoxesRunTime.unboxToInt((Object)x$23), x$24, x$25, x$26);
            return BoxedUnit.UNIT;
        });
        Assertions.assertEquals((int)0, (int)this.transactionManager().loadingPartitions().size());
        this.prepareTxnLog(this.topicPartition(), 0L, records);
        this.transactionManager().loadTransactionsForTxnTopicPartition(this.partitionId(), 1, (Function4 & Serializable & scala.Serializable)(x$27, x$28, x$29, x$30) -> {
            TransactionStateManagerTest.$anonfun$testSuccessfulReimmigration$2(BoxesRunTime.unboxToInt((Object)x$27), x$28, x$29, x$30);
            return BoxedUnit.UNIT;
        });
        Assertions.assertEquals((int)0, (int)this.transactionManager().loadingPartitions().size());
        Assertions.assertTrue((boolean)this.transactionManager().transactionMetadataCache().contains((Object)BoxesRunTime.boxToInteger((int)this.partitionId())));
        Assertions.assertEquals((int)1, (int)((TxnMetadataCacheEntry)this.transactionManager().transactionMetadataCache().apply((Object)BoxesRunTime.boxToInteger((int)this.partitionId()))).coordinatorEpoch());
    }

    @Test
    public void testLoadTransactionMetadataWithCorruptedLog() {
        long startOffset = 0L;
        long endOffset = 10L;
        UnifiedLog logMock = (UnifiedLog)Mockito.mock(UnifiedLog.class);
        Mockito.when((Object)this.replicaManager().getLog(this.topicPartition())).thenReturn((Object)new Some((Object)logMock));
        Mockito.when((Object)BoxesRunTime.boxToLong((long)logMock.logStartOffset())).thenReturn((Object)BoxesRunTime.boxToLong((long)startOffset));
        Mockito.when((Object)logMock.read(ArgumentMatchers.eq((long)startOffset), ArgumentMatchers.anyInt(), (FetchIsolation)ArgumentMatchers.eq((Object)FetchIsolation.LOG_END), ArgumentMatchers.eq((boolean)true))).thenReturn((Object)new FetchDataInfo(new LogOffsetMetadata(startOffset), (Records)MemoryRecords.EMPTY));
        Mockito.when((Object)this.replicaManager().getLogEndOffset(this.topicPartition())).thenReturn((Object)new Some((Object)BoxesRunTime.boxToLong((long)endOffset)));
        this.transactionManager().loadTransactionsForTxnTopicPartition(this.partitionId(), 0, (Function4 & Serializable & scala.Serializable)(x$31, x$32, x$33, x$34) -> {
            TransactionStateManagerTest.$anonfun$testLoadTransactionMetadataWithCorruptedLog$1(BoxesRunTime.unboxToInt((Object)x$31), x$32, x$33, x$34);
            return BoxedUnit.UNIT;
        });
        this.scheduler().tick();
        ((ReplicaManager)Mockito.verify((Object)this.replicaManager())).getLog(this.topicPartition());
        ((UnifiedLog)Mockito.verify((Object)logMock)).logStartOffset();
        ((UnifiedLog)Mockito.verify((Object)logMock)).read(ArgumentMatchers.eq((long)startOffset), ArgumentMatchers.anyInt(), (FetchIsolation)ArgumentMatchers.eq((Object)FetchIsolation.LOG_END), ArgumentMatchers.eq((boolean)true));
        ((ReplicaManager)Mockito.verify((Object)this.replicaManager(), (VerificationMode)Mockito.times((int)2))).getLogEndOffset(this.topicPartition());
        Assertions.assertEquals((int)0, (int)this.transactionManager().loadingPartitions().size());
    }

    private void verifyMetadataDoesExistAndIsUsable(String transactionalId) {
        Option option;
        boolean bl = false;
        Right right = null;
        Either either = this.transactionManager().getTransactionState(transactionalId);
        if (either instanceof Left) {
            BoxedUnit cfr_ignored_0 = (BoxedUnit)Assertions.fail((String)"shouldn't have been any errors");
            return;
        }
        if (either instanceof Right) {
            bl = true;
            right = (Right)either;
            Option option2 = (Option)right.value();
            if (None$.MODULE$.equals(option2)) {
                BoxedUnit cfr_ignored_1 = (BoxedUnit)Assertions.fail((String)"metadata should have been removed");
                return;
            }
        }
        if (bl && (option = (Option)right.value()) instanceof Some) {
            Assertions.assertTrue((boolean)((CoordinatorEpochAndTxnMetadata)((Some)option).value()).transactionMetadata().pendingState().isEmpty(), (String)"metadata shouldn't be in a pending state");
            return;
        }
        throw new MatchError((Object)either);
    }

    private void verifyMetadataDoesntExist(String transactionalId) {
        Option option;
        boolean bl = false;
        Right right = null;
        Either either = this.transactionManager().getTransactionState(transactionalId);
        if (either instanceof Left) {
            BoxedUnit cfr_ignored_0 = (BoxedUnit)Assertions.fail((String)"shouldn't have been any errors");
            return;
        }
        if (either instanceof Right) {
            bl = true;
            right = (Right)either;
            if ((Option)right.value() instanceof Some) {
                BoxedUnit cfr_ignored_1 = (BoxedUnit)Assertions.fail((String)"metadata should have been removed");
                return;
            }
        }
        if (bl && None$.MODULE$.equals(option = (Option)right.value())) {
            return;
        }
        throw new MatchError((Object)either);
    }

    private void expectTransactionalIdExpiration(Errors appendError, scala.collection.mutable.Map<TopicPartition, Buffer<MemoryRecords>> capturedAppends) {
        ArgumentCaptor recordsCapture = ArgumentCaptor.forClass(Map.class);
        ArgumentCaptor callbackCapture = ArgumentCaptor.forClass(Function1.class);
        this.replicaManager().appendRecords(ArgumentMatchers.anyLong(), ArgumentMatchers.eq((short)((short)-1)), ArgumentMatchers.eq((boolean)true), (AppendOrigin)ArgumentMatchers.eq((Object)AppendOrigin.COORDINATOR), (Map)recordsCapture.capture(), (Function1)callbackCapture.capture(), (Option)ArgumentMatchers.any(), (Function1)ArgumentMatchers.any(), (RequestLocal)ArgumentMatchers.any(), (ActionQueue)ArgumentMatchers.any(), (Map)ArgumentMatchers.any());
        Mockito.when((Object)BoxedUnit.UNIT).thenAnswer(x$35 -> {
            TransactionStateManagerTest.$anonfun$expectTransactionalIdExpiration$1(callbackCapture, recordsCapture, capturedAppends, appendError, x$35);
            return BoxedUnit.UNIT;
        });
    }

    private void loadTransactionsForPartitions(Seq<Object> partitionIds) {
        partitionIds.foreach((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)partitionId -> this.transactionManager().addLoadedTransactionsToCache(partitionId, 0, new Pool((Option)Pool$.MODULE$.$lessinit$greater$default$1())));
    }

    private void expectLogConfig(Seq<Object> partitionIds, int maxBatchSize) {
        LogConfig logConfig = (LogConfig)Mockito.mock(LogConfig.class);
        Mockito.when((Object)BoxesRunTime.boxToInteger((int)logConfig.maxMessageSize())).thenReturn((Object)BoxesRunTime.boxToInteger((int)maxBatchSize));
        partitionIds.foreach((Function1 & Serializable & scala.Serializable)partitionId -> TransactionStateManagerTest.$anonfun$expectLogConfig$1(this, logConfig, BoxesRunTime.unboxToInt((Object)partitionId)));
    }

    private void setupAndRunTransactionalIdExpiration(Errors error, TransactionState txnState) {
        Range partitionIds = RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.numPartitions());
        this.loadTransactionsForPartitions((Seq<Object>)partitionIds);
        this.expectLogConfig((Seq<Object>)partitionIds, 0x10000C);
        this.txnMetadata1().txnLastUpdateTimestamp_$eq(this.time().milliseconds() - (long)this.txnConfig().transactionalIdExpirationMs());
        this.txnMetadata1().state_$eq(txnState);
        this.transactionManager().putTransactionStateIfNotExists(this.txnMetadata1());
        this.txnMetadata2().txnLastUpdateTimestamp_$eq(this.time().milliseconds());
        this.transactionManager().putTransactionStateIfNotExists(this.txnMetadata2());
        scala.collection.mutable.Map appendedRecords = Map$.MODULE$.empty();
        this.expectTransactionalIdExpiration(error, (scala.collection.mutable.Map<TopicPartition, Buffer<MemoryRecords>>)appendedRecords);
        this.transactionManager().removeExpiredTransactionalIds();
        if (Empty$.MODULE$.equals(txnState) ? true : (CompleteCommit$.MODULE$.equals(txnState) ? true : CompleteAbort$.MODULE$.equals(txnState))) {
            int partitionId = this.transactionManager().partitionFor(this.transactionalId1());
            TopicPartition topicPartition = new TopicPartition("__transaction_state", partitionId);
            SimpleRecord expectedTombstone = new SimpleRecord(this.time().milliseconds(), TransactionLog$.MODULE$.keyToBytes(this.transactionalId1()), null);
            MemoryRecords expectedRecords = MemoryRecords.withRecords((Compression)TransactionLog$.MODULE$.EnforcedCompression(), (SimpleRecord[])new SimpleRecord[]{expectedTombstone});
            Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{topicPartition})), (Object)appendedRecords.keySet());
            Assertions.assertEquals((Object)new .colon.colon((Object)expectedRecords, (List)Nil$.MODULE$), (Object)((SeqLike)appendedRecords.apply((Object)topicPartition)).toSeq());
            return;
        }
        Assertions.assertEquals((Object)scala.collection.Map$.MODULE$.empty(), (Object)appendedRecords);
    }

    private void verifyWritesTxnMarkersInPrepareState(TransactionState state) {
        this.txnMetadata1().state_$eq(state);
        this.txnMetadata1().addPartitions((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition("topic1", 0), new TopicPartition("topic1", 1)})));
        this.txnRecords().$plus$eq((Object)new SimpleRecord(this.txnMessageKeyBytes1(), TransactionLog$.MODULE$.valueToBytes(this.txnMetadata1().prepareNoTransit(), true)));
        MemoryRecords records = MemoryRecords.withRecords((long)0L, (Compression)Compression.NONE, (SimpleRecord[])((SimpleRecord[])this.txnRecords().toArray(ClassTag$.MODULE$.apply(SimpleRecord.class))));
        this.prepareTxnLog(this.topicPartition(), 0L, records);
        ObjectRef txnId = ObjectRef.create(null);
        this.transactionManager().loadTransactionsForTxnTopicPartition(this.partitionId(), 0, (Function4 & Serializable & scala.Serializable)(coordinatorEpoch, command, metadata, newMetadata) -> {
            TransactionStateManagerTest.rememberTxnMarkers$1(BoxesRunTime.unboxToInt((Object)coordinatorEpoch), command, metadata, newMetadata, txnId);
            return BoxedUnit.UNIT;
        });
        this.scheduler().tick();
        Assertions.assertEquals((Object)this.transactionalId1(), (Object)((String)txnId.elem));
    }

    private void assertCallback(Errors error) {
        Assertions.assertEquals((Object)this.expectedError(), (Object)error);
    }

    private TransactionMetadata transactionMetadata(String transactionalId, long producerId, TransactionState state, int txnTimeout) {
        return TransactionMetadata$.MODULE$.apply(transactionalId, producerId, (short)0, txnTimeout, state, this.time().milliseconds());
    }

    private TransactionState transactionMetadata$default$3() {
        return Empty$.MODULE$;
    }

    private int transactionMetadata$default$4() {
        return this.transactionTimeoutMs();
    }

    private void prepareTxnLog(TopicPartition topicPartition, long startOffset, MemoryRecords records) {
        Mockito.reset((Object[])new ReplicaManager[]{this.replicaManager()});
        UnifiedLog logMock = (UnifiedLog)Mockito.mock(UnifiedLog.class);
        FileRecords fileRecordsMock = (FileRecords)Mockito.mock(FileRecords.class);
        long endOffset = startOffset + (long)((TraversableOnce)CollectionConverters$.MODULE$.iterableAsScalaIterableConverter(records.records()).asScala()).size();
        Mockito.when((Object)this.replicaManager().getLog(topicPartition)).thenReturn((Object)new Some((Object)logMock));
        Mockito.when((Object)this.replicaManager().getLogEndOffset(topicPartition)).thenReturn((Object)new Some((Object)BoxesRunTime.boxToLong((long)endOffset)));
        Mockito.when((Object)BoxesRunTime.boxToLong((long)logMock.logStartOffset())).thenReturn((Object)BoxesRunTime.boxToLong((long)startOffset));
        Mockito.when((Object)logMock.read(ArgumentMatchers.eq((long)startOffset), ArgumentMatchers.anyInt(), (FetchIsolation)ArgumentMatchers.eq((Object)FetchIsolation.LOG_END), ArgumentMatchers.eq((boolean)true))).thenReturn((Object)new FetchDataInfo(new LogOffsetMetadata(startOffset), (Records)fileRecordsMock));
        Mockito.when((Object)BoxesRunTime.boxToInteger((int)fileRecordsMock.sizeInBytes())).thenReturn((Object)BoxesRunTime.boxToInteger((int)records.sizeInBytes()));
        ArgumentCaptor bufferCapture = ArgumentCaptor.forClass(ByteBuffer.class);
        fileRecordsMock.readInto((ByteBuffer)bufferCapture.capture(), ArgumentMatchers.anyInt());
        Mockito.when((Object)BoxedUnit.UNIT).thenAnswer(x$36 -> {
            ByteBuffer buffer = (ByteBuffer)bufferCapture.getValue();
            buffer.put(records.buffer().duplicate());
            return buffer.flip();
        });
    }

    private void prepareForTxnMessageAppend(Errors error) {
        Mockito.reset((Object[])new ReplicaManager[]{this.replicaManager()});
        ArgumentCaptor capturedArgument = ArgumentCaptor.forClass(Function1.class);
        this.replicaManager().appendRecords(ArgumentMatchers.anyLong(), ArgumentMatchers.anyShort(), ArgumentMatchers.eq((boolean)true), (AppendOrigin)ArgumentMatchers.eq((Object)AppendOrigin.COORDINATOR), (Map)ArgumentMatchers.any(), (Function1)capturedArgument.capture(), (Option)ArgumentMatchers.any(), (Function1)ArgumentMatchers.any(), (RequestLocal)ArgumentMatchers.any(), (ActionQueue)ArgumentMatchers.any(), (Map)ArgumentMatchers.any());
        Mockito.when((Object)BoxedUnit.UNIT).thenAnswer(x$37 -> {
            TransactionStateManagerTest.$anonfun$prepareForTxnMessageAppend$1(this, capturedArgument, error, x$37);
            return BoxedUnit.UNIT;
        });
        Mockito.when((Object)this.replicaManager().getMagic((TopicPartition)ArgumentMatchers.any())).thenReturn((Object)new Some((Object)BoxesRunTime.boxToByte((byte)1)));
    }

    @Test
    public void testPartitionLoadMetric() {
        MBeanServer server = ManagementFactory.getPlatformMBeanServer();
        String mBeanName = "kafka.server:type=transaction-coordinator-metrics";
        JmxReporter reporter = new JmxReporter();
        KafkaMetricsContext metricsContext = new KafkaMetricsContext("kafka.server");
        reporter.contextChange((MetricsContext)metricsContext);
        this.metrics().addReporter((MetricsReporter)reporter);
        Assertions.assertTrue((boolean)server.isRegistered(new ObjectName(mBeanName)));
        Assertions.assertEquals((double)Double.NaN, (double)TransactionStateManagerTest.partitionLoadTime$1("partition-load-time-max", server, mBeanName), (double)0.0);
        Assertions.assertEquals((double)Double.NaN, (double)TransactionStateManagerTest.partitionLoadTime$1("partition-load-time-avg", server, mBeanName), (double)0.0);
        Assertions.assertTrue((boolean)reporter.containsMbean(mBeanName));
        this.txnMetadata1().state_$eq((TransactionState)Ongoing$.MODULE$);
        this.txnMetadata1().addPartitions((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition("topic1", 1), new TopicPartition("topic1", 1)})));
        this.txnRecords().$plus$eq((Object)new SimpleRecord(this.txnMessageKeyBytes1(), TransactionLog$.MODULE$.valueToBytes(this.txnMetadata1().prepareNoTransit(), true)));
        long startOffset = 15L;
        MemoryRecords records = MemoryRecords.withRecords((long)startOffset, (Compression)Compression.NONE, (SimpleRecord[])((SimpleRecord[])this.txnRecords().toArray(ClassTag$.MODULE$.apply(SimpleRecord.class))));
        this.prepareTxnLog(this.topicPartition(), startOffset, records);
        this.transactionManager().loadTransactionsForTxnTopicPartition(this.partitionId(), 0, (Function4 & Serializable & scala.Serializable)(x$38, x$39, x$40, x$41) -> {
            TransactionStateManagerTest.$anonfun$testPartitionLoadMetric$1(BoxesRunTime.unboxToInt((Object)x$38), x$39, x$40, x$41);
            return BoxedUnit.UNIT;
        });
        this.scheduler().tick();
        Assertions.assertTrue((TransactionStateManagerTest.partitionLoadTime$1("partition-load-time-max", server, mBeanName) >= 0.0 ? 1 : 0) != 0);
        Assertions.assertTrue((TransactionStateManagerTest.partitionLoadTime$1("partition-load-time-avg", server, mBeanName) >= 0.0 ? 1 : 0) != 0);
    }

    @Test
    public void testIgnoreUnknownRecordType() {
        this.txnMetadata1().state_$eq((TransactionState)PrepareCommit$.MODULE$);
        this.txnMetadata1().addPartitions((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition("topic1", 0), new TopicPartition("topic1", 1)})));
        this.txnRecords().$plus$eq((Object)new SimpleRecord(this.txnMessageKeyBytes1(), TransactionLog$.MODULE$.valueToBytes(this.txnMetadata1().prepareNoTransit(), true)));
        long startOffset = 0L;
        TransactionLogKey unknownKey = new TransactionLogKey();
        byte[] unknownMessage = MessageUtil.toVersionPrefixedBytes((short)Short.MAX_VALUE, (Message)unknownKey);
        SimpleRecord unknownRecord = new SimpleRecord(unknownMessage, unknownMessage);
        MemoryRecords records = MemoryRecords.withRecords((long)startOffset, (Compression)Compression.NONE, (SimpleRecord[])((SimpleRecord[])((TraversableOnce)new .colon.colon((Object)unknownRecord, (List)Nil$.MODULE$).$plus$plus(this.txnRecords(), Seq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(SimpleRecord.class))));
        this.prepareTxnLog(this.topicPartition(), 0L, records);
        this.transactionManager().loadTransactionsForTxnTopicPartition(this.partitionId(), 1, (Function4 & Serializable & scala.Serializable)(x$42, x$43, x$44, x$45) -> {
            TransactionStateManagerTest.$anonfun$testIgnoreUnknownRecordType$1(BoxesRunTime.unboxToInt((Object)x$42), x$43, x$44, x$45);
            return BoxedUnit.UNIT;
        });
        Assertions.assertEquals((int)0, (int)this.transactionManager().loadingPartitions().size());
        Assertions.assertTrue((boolean)this.transactionManager().transactionMetadataCache().contains((Object)BoxesRunTime.boxToInteger((int)this.partitionId())));
        Pool txnMetadataPool = ((TxnMetadataCacheEntry)this.transactionManager().transactionMetadataCache().apply((Object)BoxesRunTime.boxToInteger((int)this.partitionId()))).metadataPerTransactionalId();
        Assertions.assertFalse((boolean)txnMetadataPool.isEmpty());
        Assertions.assertTrue((boolean)txnMetadataPool.contains((Object)this.transactionalId1()));
        TransactionMetadata txnMetadata = (TransactionMetadata)txnMetadataPool.get((Object)this.transactionalId1());
        Assertions.assertEquals((Object)this.txnMetadata1().transactionalId(), (Object)txnMetadata.transactionalId());
        Assertions.assertEquals((long)this.txnMetadata1().producerId(), (long)txnMetadata.producerId());
        Assertions.assertEquals((long)this.txnMetadata1().lastProducerId(), (long)txnMetadata.lastProducerId());
        Assertions.assertEquals((short)this.txnMetadata1().producerEpoch(), (short)txnMetadata.producerEpoch());
        Assertions.assertEquals((short)this.txnMetadata1().lastProducerEpoch(), (short)txnMetadata.lastProducerEpoch());
        Assertions.assertEquals((int)this.txnMetadata1().txnTimeoutMs(), (int)txnMetadata.txnTimeoutMs());
        Assertions.assertEquals((Object)this.txnMetadata1().state(), (Object)txnMetadata.state());
        Assertions.assertEquals((Object)this.txnMetadata1().topicPartitions(), (Object)txnMetadata.topicPartitions());
        Assertions.assertEquals((int)1, (int)((TxnMetadataCacheEntry)this.transactionManager().transactionMetadataCache().apply((Object)BoxesRunTime.boxToInteger((int)this.partitionId()))).coordinatorEpoch());
    }

    @ParameterizedTest
    @EnumSource(value=TransactionVersion.class)
    public void testUsesFlexibleRecords(TransactionVersion transactionVersion) {
        MetadataCache metadataCache = (MetadataCache)Mockito.mock(MetadataCache.class);
        Mockito.when((Object)metadataCache.features()).thenReturn((Object)new FinalizedFeatures(MetadataVersion.latestTesting(), Collections.singletonMap("transaction.version", Predef$.MODULE$.short2Short(transactionVersion.featureLevel())), 0L, true));
        TransactionStateManager transactionManager = new TransactionStateManager(0, (Scheduler)this.scheduler(), this.replicaManager(), metadataCache, this.txnConfig(), (Time)this.time(), this.metrics());
        Assertions.assertEquals((Object)BoxesRunTime.boxToBoolean((transactionVersion.featureLevel() > 0 ? 1 : 0) != 0), (Object)BoxesRunTime.boxToBoolean((boolean)transactionManager.usesFlexibleRecords()));
    }

    public static final /* synthetic */ short $anonfun$testDeletePartition$1(CoordinatorEpochAndTxnMetadata x$1) {
        return x$1.transactionMetadata().producerEpoch();
    }

    private final Option cachedProducerEpoch$1(String transactionalId) {
        return this.transactionManager().getTransactionState(transactionalId).toOption().flatten(Predef$.MODULE$.$conforms()).map((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToShort((short)TransactionStateManagerTest.$anonfun$testDeletePartition$1(x$1)));
    }

    public static final /* synthetic */ void $anonfun$testDeleteLoadingPartition$3(int x$3, TransactionResult x$4, TransactionMetadata x$5, TxnTransitMetadata x$6) {
    }

    public static final /* synthetic */ boolean $anonfun$testDeleteLoadingPartition$4(TransactionStateManagerTest $this, TransactionPartitionAndLeaderEpoch partitionAndLeaderEpoch$1) {
        return $this.transactionManager().loadingPartitions().contains((Object)partitionAndLeaderEpoch$1);
    }

    public static final /* synthetic */ String $anonfun$testDeleteLoadingPartition$5() {
        return "Timed out waiting for loading partition";
    }

    public static final /* synthetic */ void $anonfun$testLoadAndRemoveTransactionsForPartition$1(Errors err) {
        Assertions.assertEquals((Object)Errors.NOT_COORDINATOR, (Object)err);
    }

    public static final /* synthetic */ void $anonfun$testLoadAndRemoveTransactionsForPartition$3(Errors err) {
        Assertions.assertEquals((Object)Errors.NOT_COORDINATOR, (Object)err);
    }

    public static final /* synthetic */ void $anonfun$testLoadAndRemoveTransactionsForPartition$5(int x$9, TransactionResult x$10, TransactionMetadata x$11, TxnTransitMetadata x$12) {
    }

    public static final /* synthetic */ void $anonfun$testLoadAndRemoveTransactionsForPartition$15(Errors err) {
        Assertions.assertEquals((Object)Errors.NOT_COORDINATOR, (Object)err);
    }

    public static final /* synthetic */ void $anonfun$testLoadAndRemoveTransactionsForPartition$17(Errors err) {
        Assertions.assertEquals((Object)Errors.NOT_COORDINATOR, (Object)err);
    }

    public static final /* synthetic */ boolean $anonfun$testPendingStateNotResetOnRetryAppend$2(Errors x$15) {
        return true;
    }

    public static final /* synthetic */ void $anonfun$shouldReturnNotCoordinatorErrorIfTransactionIdPartitionNotOwned$1(Errors err) {
        Assertions.assertEquals((Object)Errors.NOT_COORDINATOR, (Object)err);
    }

    private final void putTransaction$1(String transactionalId, long producerId, TransactionState state) {
        TransactionMetadata txnMetadata = this.transactionMetadata(transactionalId, producerId, state, this.transactionMetadata$default$4());
        this.transactionManager().putTransactionStateIfNotExists(txnMetadata).left().toOption().foreach((Function1 & Serializable & scala.Serializable)error -> (Nothing$)Assertions.fail((String)new StringBuilder(43).append("Failed to insert transaction ").append(txnMetadata).append(" due to error ").append(error).toString()));
    }

    public static final /* synthetic */ boolean $anonfun$testListTransactionsFiltering$4(String state) {
        return TransactionState$.MODULE$.fromName(state).isEmpty();
    }

    private final void assertListTransactions$1(scala.collection.immutable.Set expectedTransactionalIds, scala.collection.immutable.Set filterProducerIds, scala.collection.immutable.Set filterStates, long filterDuration) {
        ListTransactionsResponseData listResponse = this.transactionManager().listTransactionStates(filterProducerIds, filterStates, filterDuration);
        Assertions.assertEquals((Object)Errors.NONE, (Object)Errors.forCode((short)listResponse.errorCode()));
        Assertions.assertEquals((Object)expectedTransactionalIds, (Object)((TraversableOnce)((TraversableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(listResponse.transactionStates()).asScala()).map((Function1 & Serializable & scala.Serializable)x$17 -> x$17.transactionalId(), Buffer$.MODULE$.canBuildFrom())).toSet());
        Assertions.assertEquals((Object)((scala.collection.immutable.Set)filterStates.filter((Function1 & Serializable & scala.Serializable)state -> BoxesRunTime.boxToBoolean((boolean)TransactionStateManagerTest.$anonfun$testListTransactionsFiltering$4(state)))), (Object)((TraversableOnce)CollectionConverters$.MODULE$.asScalaBufferConverter(listResponse.unknownStateFilters()).asScala()).toSet());
    }

    private static final scala.collection.immutable.Set assertListTransactions$default$2$1() {
        return Predef$.MODULE$.Set().empty();
    }

    private static final scala.collection.immutable.Set assertListTransactions$default$3$1() {
        return Predef$.MODULE$.Set().empty();
    }

    private static final long assertListTransactions$default$4$1() {
        return -1L;
    }

    public static final /* synthetic */ void $anonfun$testTransactionalExpirationWithTooSmallBatchSize$2(int maxBatchSize$1, MemoryRecords batch) {
        Assertions.assertTrue((batch.sizeInBytes() > maxBatchSize$1 ? 1 : 0) != 0);
    }

    public static final /* synthetic */ boolean $anonfun$testTransactionalExpirationWithOfflineLogDir$2(TransactionStateManagerTest $this, int onlinePartitionId$1, String transactionalId) {
        return $this.transactionManager().partitionFor(transactionalId) == onlinePartitionId$1;
    }

    public static final /* synthetic */ boolean $anonfun$testTransactionExpirationShouldRespectBatchSize$3(int maxBatchSize$2, MemoryRecords x$21) {
        return x$21.sizeInBytes() < maxBatchSize$2;
    }

    public static final /* synthetic */ void $anonfun$testTransactionExpirationShouldRespectBatchSize$2(int maxBatchSize$2, Buffer batches) {
        Assertions.assertTrue((batches.size() > 1 ? 1 : 0) != 0);
        Assertions.assertTrue((boolean)batches.forall((Function1 & Serializable & scala.Serializable)x$21 -> BoxesRunTime.boxToBoolean((boolean)TransactionStateManagerTest.$anonfun$testTransactionExpirationShouldRespectBatchSize$3(maxBatchSize$2, x$21))));
    }

    public static final /* synthetic */ void $anonfun$collectTransactionalIdsFromTombstones$2(TransactionStateManagerTest $this, scala.collection.mutable.Set expiredTransactionalIds$1, MemoryRecords records) {
        records.records().forEach(record -> {
            String transactionalId = TransactionLog$.MODULE$.readTxnRecordKey(record.key()).transactionalId();
            Assertions.assertNull((Object)record.value());
            expiredTransactionalIds$1.$plus$eq((Object)transactionalId);
            Assertions.assertEquals((Object)package$.MODULE$.Right().apply((Object)None$.MODULE$), (Object)$this.transactionManager().getTransactionState(transactionalId));
        });
    }

    public static final /* synthetic */ scala.collection.mutable.Set $anonfun$loadExpiredTransactionalIds$1(TransactionStateManagerTest $this, scala.collection.mutable.Set allTransactionalIds$1, int i) {
        String txnlId = new StringBuilder(3).append("id_").append(i).toString();
        TransactionMetadata txnMetadata = $this.transactionMetadata(txnlId, i, $this.transactionMetadata$default$3(), $this.transactionMetadata$default$4());
        txnMetadata.txnLastUpdateTimestamp_$eq($this.time().milliseconds() - (long)$this.txnConfig().transactionalIdExpirationMs());
        $this.transactionManager().putTransactionStateIfNotExists(txnMetadata);
        return (scala.collection.mutable.Set)allTransactionalIds$1.$plus$eq((Object)txnlId);
    }

    public static final /* synthetic */ boolean $anonfun$listExpirableTransactionalIds$2(TransactionStateManagerTest $this, String transactionalId) {
        Option option;
        Either either = $this.transactionManager().getTransactionState(transactionalId);
        if (either instanceof Right && (option = (Option)((Right)either).value()) instanceof Some) {
            TransactionMetadata txnMetadata = ((CoordinatorEpochAndTxnMetadata)((Some)option).value()).transactionMetadata();
            return $this.time().milliseconds() - txnMetadata.txnLastUpdateTimestamp() >= (long)$this.txnConfig().transactionalIdExpirationMs() && txnMetadata.state().isExpirationAllowed() && txnMetadata.pendingState().isEmpty();
        }
        return false;
    }

    public static final /* synthetic */ void $anonfun$testSuccessfulReimmigration$1(int x$23, TransactionResult x$24, TransactionMetadata x$25, TxnTransitMetadata x$26) {
    }

    public static final /* synthetic */ void $anonfun$testSuccessfulReimmigration$2(int x$27, TransactionResult x$28, TransactionMetadata x$29, TxnTransitMetadata x$30) {
    }

    public static final /* synthetic */ void $anonfun$testLoadTransactionMetadataWithCorruptedLog$1(int x$31, TransactionResult x$32, TransactionMetadata x$33, TxnTransitMetadata x$34) {
    }

    public static final /* synthetic */ void $anonfun$expectTransactionalIdExpiration$1(ArgumentCaptor callbackCapture$1, ArgumentCaptor recordsCapture$1, scala.collection.mutable.Map capturedAppends$1, Errors appendError$1, InvocationOnMock x$35) {
        ((Function1)callbackCapture$1.getValue()).apply((Object)((TraversableOnce)((TraversableLike)recordsCapture$1.getValue()).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            if (x0$1 != null) {
                TopicPartition topicPartition = (TopicPartition)x0$1._1();
                MemoryRecords records = (MemoryRecords)x0$1._2();
                ((Buffer)capturedAppends$1.getOrElse((Object)topicPartition, (Function0 & Serializable & scala.Serializable)() -> {
                    Buffer batches = (Buffer)Buffer$.MODULE$.empty();
                    capturedAppends$1.$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicPartition), (Object)batches));
                    return batches;
                })).$plus$eq((Object)records);
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicPartition), (Object)new ProduceResponse.PartitionResponse(appendError$1, 0L, -1L, 0L));
            }
            throw new MatchError(null);
        }, scala.collection.Map$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms()));
    }

    public static final /* synthetic */ OngoingStubbing $anonfun$expectLogConfig$1(TransactionStateManagerTest $this, LogConfig logConfig$1, int partitionId) {
        return Mockito.when((Object)$this.replicaManager().getLogConfig(new TopicPartition("__transaction_state", partitionId))).thenReturn((Object)new Some((Object)logConfig$1));
    }

    private static final void rememberTxnMarkers$1(int coordinatorEpoch, TransactionResult command, TransactionMetadata metadata, TxnTransitMetadata newMetadata, ObjectRef txnId$1) {
        txnId$1.elem = metadata.transactionalId();
    }

    public static final /* synthetic */ void $anonfun$prepareForTxnMessageAppend$1(TransactionStateManagerTest $this, ArgumentCaptor capturedArgument$1, Errors error$1, InvocationOnMock x$37) {
        ((Function1)capturedArgument$1.getValue()).apply((Object)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("__transaction_state", $this.partitionId())), (Object)new ProduceResponse.PartitionResponse(error$1, 0L, -1L, 0L))})));
    }

    private static final double partitionLoadTime$1(String attribute, MBeanServer server$1, String mBeanName$1) {
        return BoxesRunTime.unboxToDouble((Object)server$1.getAttribute(new ObjectName(mBeanName$1), attribute));
    }

    public static final /* synthetic */ void $anonfun$testPartitionLoadMetric$1(int x$38, TransactionResult x$39, TransactionMetadata x$40, TxnTransitMetadata x$41) {
    }

    public static final /* synthetic */ void $anonfun$testIgnoreUnknownRecordType$1(int x$42, TransactionResult x$43, TransactionMetadata x$44, TxnTransitMetadata x$45) {
    }

    public TransactionStateManagerTest() {
        this.partitionId = 0;
        this.numPartitions = 2;
        this.transactionTimeoutMs = 1000;
        this.coordinatorEpoch = 10;
        Mockito.when((Object)this.zkClient().getTopicPartitionCount("__transaction_state")).thenReturn((Object)new Some((Object)BoxesRunTime.boxToInteger((int)this.numPartitions())));
        Mockito.when((Object)this.metadataCache().features()).thenReturn((Object)new FinalizedFeatures(MetadataVersion.latestTesting(), Collections.singletonMap("transaction.version", Predef$.MODULE$.short2Short(TransactionVersion.TV_2.featureLevel())), 0L, true));
        this.metrics = new Metrics();
        this.txnConfig = new TransactionConfig(TransactionConfig$.MODULE$.apply$default$1(), TransactionConfig$.MODULE$.apply$default$2(), TransactionConfig$.MODULE$.apply$default$3(), TransactionConfig$.MODULE$.apply$default$4(), TransactionConfig$.MODULE$.apply$default$5(), TransactionConfig$.MODULE$.apply$default$6(), TransactionConfig$.MODULE$.apply$default$7(), TransactionConfig$.MODULE$.apply$default$8(), TransactionConfig$.MODULE$.apply$default$9(), TransactionConfig$.MODULE$.apply$default$10());
        this.transactionManager = new TransactionStateManager(0, (Scheduler)this.scheduler(), this.replicaManager(), this.metadataCache(), this.txnConfig(), (Time)this.time(), this.metrics());
        this.transactionalId1 = "one";
        this.transactionalId2 = "two";
        this.txnMessageKeyBytes1 = TransactionLog$.MODULE$.keyToBytes(this.transactionalId1());
        this.txnMessageKeyBytes2 = TransactionLog$.MODULE$.keyToBytes(this.transactionalId2());
        this.producerIds = (Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.transactionalId1()), (Object)BoxesRunTime.boxToLong((long)1L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.transactionalId2()), (Object)BoxesRunTime.boxToLong((long)2L))}));
        this.txnMetadata1 = this.transactionMetadata(this.transactionalId1(), BoxesRunTime.unboxToLong((Object)this.producerIds().apply((Object)this.transactionalId1())), this.transactionMetadata$default$3(), this.transactionMetadata$default$4());
        this.txnMetadata2 = this.transactionMetadata(this.transactionalId2(), BoxesRunTime.unboxToLong((Object)this.producerIds().apply((Object)this.transactionalId2())), this.transactionMetadata$default$3(), this.transactionMetadata$default$4());
        this.expectedError = Errors.NONE;
    }
}

